/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.nio;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.BiConsumer;

public class FlushOperation {
    private static final ByteBuffer[] EMPTY_ARRAY = new ByteBuffer[0];
    private final BiConsumer<Void, Exception> listener;
    private final ByteBuffer[] buffers;
    private final int[] offsets;
    private final int length;
    private int internalIndex;

    public FlushOperation(ByteBuffer[] buffers, BiConsumer<Void, Exception> listener) {
        this.listener = listener;
        this.buffers = buffers;
        this.offsets = new int[buffers.length];
        int offset = 0;
        for (int i = 0; i < buffers.length; ++i) {
            ByteBuffer buffer = buffers[i];
            this.offsets[i] = offset;
            offset += buffer.remaining();
        }
        this.length = offset;
    }

    public BiConsumer<Void, Exception> getListener() {
        return this.listener;
    }

    public boolean isFullyFlushed() {
        assert (this.length >= this.internalIndex) : "Should never have an index that is greater than the length [length=" + this.length + ", index=" + this.internalIndex + "]";
        return this.internalIndex == this.length;
    }

    public void incrementIndex(int delta) {
        this.internalIndex += delta;
        assert (this.length >= this.internalIndex) : "Should never increment index past length [length=" + this.length + ", post-increment index=" + this.internalIndex + ", delta=" + delta + "]";
    }

    public ByteBuffer[] getBuffersToWrite() {
        return this.getBuffersToWrite(this.length);
    }

    public ByteBuffer[] getBuffersToWrite(int maxBytes) {
        int index = Arrays.binarySearch(this.offsets, this.internalIndex);
        int offsetIndex = index < 0 ? -(index + 1) - 1 : index;
        int finalIndex = Arrays.binarySearch(this.offsets, Math.min(this.internalIndex + maxBytes, this.length));
        int finalOffsetIndex = finalIndex < 0 ? -(finalIndex + 1) - 1 : finalIndex;
        int nBuffers = finalOffsetIndex - offsetIndex + 1;
        int firstBufferPosition = this.internalIndex - this.offsets[offsetIndex];
        ByteBuffer firstBuffer = this.buffers[offsetIndex].duplicate();
        firstBuffer.position(firstBufferPosition);
        if (nBuffers == 1 && firstBuffer.remaining() == 0) {
            return EMPTY_ARRAY;
        }
        ByteBuffer[] postIndexBuffers = new ByteBuffer[nBuffers];
        postIndexBuffers[0] = firstBuffer;
        int finalOffset = offsetIndex + nBuffers;
        int nBytes = firstBuffer.remaining();
        int j = 1;
        for (int i = offsetIndex + 1; i < finalOffset; ++i) {
            ByteBuffer buffer = this.buffers[i].duplicate();
            nBytes += buffer.remaining();
            postIndexBuffers[j++] = buffer;
        }
        int excessBytes = Math.max(0, nBytes - maxBytes);
        ByteBuffer lastBuffer = postIndexBuffers[postIndexBuffers.length - 1];
        lastBuffer.limit(lastBuffer.limit() - excessBytes);
        return postIndexBuffers;
    }
}

