/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import java.util.regex.Matcher;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.skin.ColorParam;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.url.UrlBuilder;
import net.sourceforge.plantuml.url.UrlMode;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandActivity3
extends SingleLineCommand2<ActivityDiagram3> {
    public static final String endingGroup() {
        return "(;[%s]*(\\<\\<\\w+\\>\\>(?:[%s]*\\<\\<\\w+\\>\\>)*)?|" + Matcher.quoteReplacement("\\\\") + "|(?<![/|<}\\]])[/<}]|(?<![/|}\\]])\\]|(?<!\\</?\\w{1,5})(?<!\\<img[^>]{1,999})(?<!\\<[&$]\\w{1,999})(?<!\\>)\\>|(?<!\\|.{1,999})\\|)";
    }

    private static final String endingGroupShort() {
        return "(;[%s]*(\\<\\<\\w+\\>\\>(?:[%s]*\\<\\<\\w+\\>\\>)*)?|" + Matcher.quoteReplacement("\\\\") + "|(?<![/|<}\\]])[/<}]|(?<![/|}\\]])\\]|(?<!\\</?\\w{1,5})(?<!\\<img[^>]{1,999})(?<!\\<[&$]\\w{1,999})(?<!\\>)\\>|\\|)";
    }

    public static void main(String[] args) {
        System.err.println(Matcher.quoteReplacement("\\\\"));
        System.err.println(Matcher.quoteReplacement("\\\\").equals("\\\\\\\\"));
    }

    public CommandActivity3() {
        super(CommandActivity3.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandActivity3.class.getName(), RegexLeaf.start(), UrlBuilder.OPTIONAL, CommandActivity3.color().getRegex(), StereotypePattern.optional("STEREO"), new RegexLeaf(":"), new RegexLeaf("LABEL", "(.*?)"), new RegexLeaf("STYLE", CommandActivity3.endingGroupShort()), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram3 diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        BoxStyle style;
        Url url;
        if (arg.get("URL", 0) == null) {
            url = null;
        } else {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            url = urlBuilder.getUrl(arg.get("URL", 0));
        }
        Colors colors = CommandActivity3.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        String stereo = arg.get("STEREO", 0);
        if (stereo == null) {
            stereo = arg.get("STYLE", 1);
        }
        Stereotype stereotype = null;
        if (stereo != null) {
            stereotype = Stereotype.build(stereo);
            colors = colors.applyStereotype(stereotype, diagram.getSkinParam(), ColorParam.activityBackground);
        }
        if ((style = BoxStyle.fromString(arg.get("STEREO", 0))) == BoxStyle.PLAIN) {
            style = BoxStyle.fromString(arg.get("STYLE", 0));
        }
        Display display = Display.getWithNewlines2(arg.get("LABEL", 0));
        return diagram.addActivity(display, style, url, colors, stereotype);
    }
}

