/*
 * Decompiled with CFR 0.152.
 */
package zext.plantuml.com.ctreber.acearth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import zext.plantuml.com.ctreber.acearth.MapData;
import zext.plantuml.com.ctreber.acearth.util.Point3D;
import zext.plantuml.com.ctreber.acearth.util.Polygon;

public class MapDataReader {
    private static final double MAP_DATA_SCALE = 30000.0;
    private static List fData;
    private static List fPolygons;
    private static int fIndex;

    public static Polygon[] readMapData() throws IOException {
        List lines = new MapData().getLines();
        fData = new ArrayList();
        for (String lLine : lines) {
            if (lLine.contains("/*")) continue;
            StringTokenizer lST = new StringTokenizer(lLine, ", ");
            while (lST.hasMoreTokens()) {
                String lToken = lST.nextToken();
                Integer lValue = Integer.valueOf(lToken);
                fData.add(lValue);
            }
        }
        fPolygons = new ArrayList();
        fIndex = 0;
        while (MapDataReader.getValue(fIndex) != 0) {
            MapDataReader.processCurve();
        }
        return fPolygons.toArray(new Polygon[0]);
    }

    private static void processCurve() {
        Point3D lPoint3D;
        int lNPoint = MapDataReader.getValue(fIndex++);
        int lType = MapDataReader.getValue(fIndex++);
        Point3D[] lPoints = new Point3D[lNPoint];
        lPoints[0] = lPoint3D = new Point3D((double)MapDataReader.getValue(fIndex++) / 30000.0, (double)MapDataReader.getValue(fIndex++) / 30000.0, (double)MapDataReader.getValue(fIndex++) / 30000.0);
        for (int i = 1; i < lNPoint; ++i) {
            lPoints[i] = new Point3D(lPoints[i - 1].getX() + (double)MapDataReader.getValue(fIndex++) / 30000.0, lPoints[i - 1].getY() + (double)MapDataReader.getValue(fIndex++) / 30000.0, lPoints[i - 1].getZ() + (double)MapDataReader.getValue(fIndex++) / 30000.0);
        }
        Polygon lPolygon = new Polygon(lType, lPoints);
        fPolygons.add(lPolygon);
    }

    private static int getValue(int pIndex) {
        return (Integer)fData.get(pIndex);
    }
}

