/*
 * Decompiled with CFR 0.152.
 */
package zext.plantuml.com.ctreber.acearth.shader;

import java.awt.Color;
import zext.plantuml.com.ctreber.acearth.projection.Projection;
import zext.plantuml.com.ctreber.acearth.util.Coordinate;
import zext.plantuml.com.ctreber.acearth.util.Point3D;

public abstract class Shader {
    private static final Color COLOR_SPACE = Color.black;
    private static final Color COLOR_STAR = Color.white;
    private static final Color COLOR_WATER = Color.blue;
    private static final Color COLOR_LAND = Color.green;
    private static final Color COLOR_GRID_LAND = Color.white;
    private static final Color COLOR_GRID_WATER = new Color(128, 128, 255);
    Projection fProjection;
    private Coordinate fSunPos;
    private double fNightSideBrightness;
    private double fDaySideBrightness;
    private double fTerminatorDiscontinuity;
    private double fDaySideValueBase;
    private double fDaySideValueRange;
    Point3D fLightVector;

    public abstract Color[] getShadedColors(int var1, int[] var2);

    public void init() {
        double tmp = this.fTerminatorDiscontinuity / 100.0;
        this.fDaySideValueBase = (int)(tmp * this.fDaySideBrightness + (1.0 - tmp) * this.fNightSideBrightness);
        this.fDaySideValueRange = this.fDaySideBrightness - this.fDaySideValueBase;
        this.fLightVector = this.fProjection.rotate(this.fSunPos.getPoint3D());
    }

    Color getShadedColorForType(int pType, double pSunValue) {
        double lBrightness = pSunValue < 0.0 ? this.fNightSideBrightness / 100.0 : (this.fDaySideValueBase + pSunValue * this.fDaySideValueRange) / 100.0;
        if (lBrightness > 1.0) {
            lBrightness = 1.0;
        }
        switch (pType) {
            case 0: {
                return COLOR_SPACE;
            }
            case 3: {
                return COLOR_STAR;
            }
            case 4: {
                return Shader.shade(COLOR_GRID_LAND, lBrightness);
            }
            case 5: {
                return Shader.shade(COLOR_GRID_WATER, lBrightness);
            }
            case 1: {
                return Shader.shade(COLOR_LAND, lBrightness);
            }
            case 2: {
                return Shader.shade(COLOR_WATER, lBrightness);
            }
        }
        return null;
    }

    private static Color shade(Color pColor, double pBrightness) {
        return new Color((int)((double)pColor.getRed() * pBrightness), (int)((double)pColor.getGreen() * pBrightness), (int)((double)pColor.getBlue() * pBrightness));
    }

    public void setProjection(Projection pProjection) {
        this.fProjection = pProjection;
    }

    public void setSunPos(Coordinate pSunPos) {
        this.fSunPos = pSunPos;
    }

    public void setDaySideBrightness(double pDaySideBrightness) {
        this.fDaySideBrightness = pDaySideBrightness;
    }

    public void setNightSideBrightness(double pNightSideBrightness) {
        this.fNightSideBrightness = pNightSideBrightness;
    }

    public void setTerminatorDiscontinuity(double pTerminatorDiscontinuity) {
        this.fTerminatorDiscontinuity = pTerminatorDiscontinuity;
    }
}

