/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.fs;

import com.ceph.fs.CephMount;
import com.ceph.fs.CephNotMountedException;
import com.ceph.fs.CephStat;
import com.ceph.fs.CephStatVFS;
import org.junit.Before;
import org.junit.Test;

public class CephUnmountedTest {
    private CephMount mount;

    @Before
    public void setup() throws Exception {
        this.mount = new CephMount("admin");
    }

    @Test(expected=CephNotMountedException.class)
    public void test_unmount() throws Exception {
        this.mount.unmount();
    }

    @Test(expected=CephNotMountedException.class)
    public void test_statfs() throws Exception {
        CephStatVFS cephStatVFS = new CephStatVFS();
        this.mount.statfs("/a/path", cephStatVFS);
    }

    @Test(expected=CephNotMountedException.class)
    public void test_getcwd() throws Exception {
        this.mount.getcwd();
    }

    @Test(expected=CephNotMountedException.class)
    public void test_chdir() throws Exception {
        this.mount.chdir("/a/path");
    }

    @Test(expected=CephNotMountedException.class)
    public void test_listdir() throws Exception {
        this.mount.listdir("/a/path");
    }

    @Test(expected=CephNotMountedException.class)
    public void test_unlink() throws Exception {
        this.mount.unlink("/a/path");
    }

    @Test(expected=CephNotMountedException.class)
    public void test_rename() throws Exception {
        this.mount.rename("/a/path", "/another/path");
    }

    @Test(expected=CephNotMountedException.class)
    public void test_mkdirs() throws Exception {
        this.mount.mkdirs("/a/path", 0);
    }

    @Test(expected=CephNotMountedException.class)
    public void test_rmdir() throws Exception {
        this.mount.rmdir("/a/path");
    }

    @Test(expected=CephNotMountedException.class)
    public void test_stat() throws Exception {
        CephStat cephStat = new CephStat();
        this.mount.stat("/a/path", cephStat);
    }

    @Test(expected=CephNotMountedException.class)
    public void test_lstat() throws Exception {
        CephStat cephStat = new CephStat();
        this.mount.lstat("/a/path", cephStat);
    }

    @Test(expected=CephNotMountedException.class)
    public void test_setattr() throws Exception {
        CephStat cephStat = new CephStat();
        this.mount.setattr("/a/path", cephStat, 0);
    }

    @Test(expected=CephNotMountedException.class)
    public void test_open() throws Exception {
        this.mount.open("/a/path", 0, 0);
    }

    @Test(expected=CephNotMountedException.class)
    public void test_open_layout() throws Exception {
        this.mount.open("/a/path", 0, 0, 0, 0, 0, null);
    }

    @Test(expected=CephNotMountedException.class)
    public void test_close() throws Exception {
        this.mount.close(0);
    }

    @Test(expected=CephNotMountedException.class)
    public void test_lseek() throws Exception {
        this.mount.lseek(0, 0L, 2);
    }

    @Test(expected=CephNotMountedException.class)
    public void test_read() throws Exception {
        byte[] byArray = new byte[1];
        this.mount.read(0, byArray, 1L, 0L);
    }

    @Test(expected=CephNotMountedException.class)
    public void test_write() throws Exception {
        byte[] byArray = new byte[1];
        this.mount.write(0, byArray, 1L, 0L);
    }

    @Test(expected=CephNotMountedException.class)
    public void test_get_stripe_unit() throws Exception {
        this.mount.get_file_stripe_unit(0);
    }

    @Test(expected=CephNotMountedException.class)
    public void test_get_repl() throws Exception {
        this.mount.get_file_replication(0);
    }

    @Test(expected=CephNotMountedException.class)
    public void test_get_stripe_unit_gran() throws Exception {
        this.mount.get_stripe_unit_granularity();
    }

    @Test(expected=CephNotMountedException.class)
    public void test_get_pool_id() throws Exception {
        this.mount.get_pool_id("data");
    }

    @Test(expected=CephNotMountedException.class)
    public void test_get_pool_replication() throws Exception {
        this.mount.get_pool_replication(1);
    }

    @Test(expected=CephNotMountedException.class)
    public void test_fchmod() throws Exception {
        this.mount.fchmod(1, 0);
    }

    @Test(expected=CephNotMountedException.class)
    public void test_chmod() throws Exception {
        this.mount.chmod("/foo", 0);
    }
}

