/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClassDescriptor;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.core.importer.resolvers.ClassResolver;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableMap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSortedMap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

class ImportedClasses {
    private static final ImmutableSet<JavaModifier> PRIMITIVE_AND_ARRAY_TYPE_MODIFIERS = Sets.immutableEnumSet((Enum)JavaModifier.PUBLIC, (Enum[])new JavaModifier[]{JavaModifier.ABSTRACT, JavaModifier.FINAL});
    private final ImmutableMap<String, JavaClass> directlyImported;
    private final Map<String, JavaClass> allClasses = new HashMap<String, JavaClass>();
    private final ClassResolver resolver;
    private final MethodReturnTypeGetter getMethodReturnType;

    ImportedClasses(Map<String, JavaClass> directlyImported, ClassResolver resolver, MethodReturnTypeGetter methodReturnTypeGetter) {
        this.directlyImported = ImmutableMap.copyOf(directlyImported);
        this.allClasses.putAll(directlyImported);
        this.resolver = resolver;
        this.getMethodReturnType = methodReturnTypeGetter;
    }

    Map<String, JavaClass> getDirectlyImported() {
        return this.directlyImported;
    }

    JavaClass getOrResolve(String typeName) {
        JavaClass javaClass = this.allClasses.get(typeName);
        return javaClass != null ? javaClass : this.resolve(typeName);
    }

    ImportedClassState ensurePresent(String typeName) {
        if (this.allClasses.containsKey(typeName)) {
            return ImportedClassState.WAS_ALREADY_PRESENT;
        }
        this.resolve(typeName);
        return ImportedClassState.HAD_TO_BE_IMPORTED;
    }

    private JavaClass resolve(String typeName) {
        JavaClass javaClass;
        Optional<JavaClass> resolved = this.resolver.tryResolve(typeName);
        JavaClass javaClass2 = javaClass = resolved.isPresent() ? resolved.get() : ImportedClasses.stubClassOf(typeName);
        if (javaClass.isArray()) {
            this.ensureAllComponentTypesPresent(javaClass);
        }
        this.allClasses.put(typeName, javaClass);
        return javaClass;
    }

    private void ensureAllComponentTypesPresent(JavaClass javaClass) {
        JavaClassDescriptor current = JavaClassDescriptor.From.javaClass(javaClass);
        while (current.tryGetComponentType().isPresent()) {
            current = current.tryGetComponentType().get();
            this.ensurePresent(current.getFullyQualifiedClassName());
        }
    }

    Collection<JavaClass> getAllWithOuterClassesSortedBeforeInnerClasses() {
        return ImmutableSortedMap.copyOf(this.allClasses).values();
    }

    private static JavaClass stubClassOf(String typeName) {
        JavaClassDescriptor descriptor = JavaClassDescriptor.From.name(typeName);
        DomainBuilders.JavaClassBuilder builder = DomainBuilders.JavaClassBuilder.forStub().withDescriptor(descriptor);
        ImportedClasses.addModifiersIfPossible(builder, descriptor);
        return builder.build();
    }

    private static void addModifiersIfPossible(DomainBuilders.JavaClassBuilder builder, JavaClassDescriptor descriptor) {
        if (descriptor.isPrimitive() || descriptor.isArray()) {
            builder.withModifiers(PRIMITIVE_AND_ARRAY_TYPE_MODIFIERS);
        }
    }

    public Optional<JavaClass> getMethodReturnType(String declaringClassName, String methodName) {
        return this.getMethodReturnType.getReturnType(declaringClassName, methodName);
    }

    static interface MethodReturnTypeGetter {
        public Optional<JavaClass> getReturnType(String var1, String var2);
    }

    static enum ImportedClassState {
        HAD_TO_BE_IMPORTED,
        WAS_ALREADY_PRESENT;

    }
}

