/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.internal;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import net.infonode.docking.View;
import net.infonode.docking.internalutil.ButtonInfo;
import net.infonode.docking.internalutil.CloseButtonInfo;
import net.infonode.docking.internalutil.DockButtonInfo;
import net.infonode.docking.internalutil.InternalDockingUtil;
import net.infonode.docking.internalutil.MaximizeButtonInfo;
import net.infonode.docking.internalutil.MinimizeButtonInfo;
import net.infonode.docking.internalutil.RestoreButtonInfo;
import net.infonode.docking.internalutil.UndockButtonInfo;
import net.infonode.docking.properties.ViewTitleBarProperties;
import net.infonode.docking.properties.ViewTitleBarStateProperties;
import net.infonode.gui.ContentTitleBar;
import net.infonode.gui.DimensionProvider;
import net.infonode.gui.hover.hoverable.HoverManager;
import net.infonode.properties.gui.InternalPropertiesUtil;
import net.infonode.properties.gui.util.ComponentProperties;
import net.infonode.properties.gui.util.ShapedPanelProperties;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapListener;
import net.infonode.properties.propertymap.PropertyMapTreeListener;
import net.infonode.properties.propertymap.PropertyMapWeakListenerManager;

public class ViewTitleBar
extends ContentTitleBar {
    private static final ButtonInfo[] buttonInfos = new ButtonInfo[]{new UndockButtonInfo(ViewTitleBarStateProperties.UNDOCK_BUTTON_PROPERTIES), new DockButtonInfo(ViewTitleBarStateProperties.DOCK_BUTTON_PROPERTIES), new MinimizeButtonInfo(ViewTitleBarStateProperties.MINIMIZE_BUTTON_PROPERTIES), new MaximizeButtonInfo(ViewTitleBarStateProperties.MAXIMIZE_BUTTON_PROPERTIES), new RestoreButtonInfo(ViewTitleBarStateProperties.RESTORE_BUTTON_PROPERTIES), new CloseButtonInfo(ViewTitleBarStateProperties.CLOSE_BUTTON_PROPERTIES)};
    private DimensionProvider minimumSizeProvider;
    private View view;
    private AbstractButton[] buttons = new AbstractButton[buttonInfos.length];
    private List customBarComponents;
    private PropertyMapTreeListener propertiesListener = new PropertyMapTreeListener(){

        @Override
        public void propertyValuesChanged(Map changes) {
            ViewTitleBar.this.updateTitleBar(changes);
        }
    };
    private PropertyMapListener buttonsListener = new PropertyMapListener(){

        @Override
        public void propertyValuesChanged(PropertyMap propertyMap, Map changes) {
            ViewTitleBar.this.updateViewButtons(null);
        }
    };
    private int pressedCount = 0;
    private boolean dragOutside = false;

    public ViewTitleBar(View view) {
        super(view);
        this.view = view;
        PropertyMapWeakListenerManager.addWeakTreeListener(view.getViewProperties().getViewTitleBarProperties().getMap(), this.propertiesListener);
        PropertyMapWeakListenerManager.addWeakListener(view.getWindowProperties().getMap(), this.buttonsListener);
        this.updateTitleBar(null);
        this.updateTitle();
        this.updateViewButtons(null);
        HoverManager.getInstance().addHoverable(this);
    }

    private void updateTitle() {
        ViewTitleBarStateProperties titleProps = this.view.getViewProperties().getViewTitleBarProperties().getNormalProperties();
        this.getLabel().setText(titleProps.getTitleVisible() ? titleProps.getTitle() : null);
        this.getLabel().setIcon(titleProps.getIconVisible() ? titleProps.getIcon() : null);
    }

    private void updateTitleBar(Map changes) {
        this.updateTitle();
        JLabel label = this.getLabel();
        ViewTitleBarProperties titleBarProperties = this.view.getViewProperties().getViewTitleBarProperties();
        ShapedPanelProperties shapedProperties = titleBarProperties.getNormalProperties().getShapedPanelProperties();
        ComponentProperties componentProperties = titleBarProperties.getNormalProperties().getComponentProperties();
        this.updateViewButtons(changes);
        if (changes == null) {
            this.minimumSizeProvider = titleBarProperties.getMinimumSizeProvider();
            componentProperties.applyTo(this);
            int i = 0;
            while (i < this.buttons.length) {
                if (this.buttons[i] != null) {
                    this.buttons[i].setForeground(componentProperties.getForegroundColor());
                    this.buttons[i].setBackground(shapedProperties.getComponentPainter() != null ? null : componentProperties.getBackgroundColor());
                }
                ++i;
            }
            label.setForeground(componentProperties.getForegroundColor());
            label.setFont(componentProperties.getFont());
            label.setIconTextGap(titleBarProperties.getNormalProperties().getIconTextGap());
            InternalPropertiesUtil.applyTo(shapedProperties, this);
            this.setLayoutDirection(titleBarProperties.getDirection());
            this.setHoverListener(titleBarProperties.getHoverListener());
            this.setLabelAlignment(titleBarProperties.getNormalProperties().getIconTextHorizontalAlignment());
        } else {
            Map map = (Map)changes.get(titleBarProperties.getMap());
            if (map != null) {
                if (map.containsKey(ViewTitleBarProperties.MINIMUM_SIZE_PROVIDER)) {
                    this.minimumSizeProvider = titleBarProperties.getMinimumSizeProvider();
                    this.revalidate();
                }
                if (map.containsKey(ViewTitleBarProperties.DIRECTION)) {
                    this.setLayoutDirection(titleBarProperties.getDirection());
                }
                if (map.containsKey(ViewTitleBarProperties.HOVER_LISTENER)) {
                    this.setHoverListener(titleBarProperties.getHoverListener());
                }
            }
            if ((map = (Map)changes.get(titleBarProperties.getNormalProperties().getMap())) != null) {
                if (map.containsKey(ViewTitleBarStateProperties.ICON_TEXT_GAP)) {
                    label.setIconTextGap(titleBarProperties.getNormalProperties().getIconTextGap());
                }
                if (map.containsKey(ViewTitleBarStateProperties.ICON_TEXT_HORIZONTAL_ALIGNMENT)) {
                    this.setLabelAlignment(titleBarProperties.getNormalProperties().getIconTextHorizontalAlignment());
                }
            }
            if ((map = (Map)changes.get(titleBarProperties.getNormalProperties().getComponentProperties().getMap())) != null) {
                componentProperties.applyTo(this);
                label.setForeground(componentProperties.getForegroundColor());
                label.setFont(componentProperties.getFont());
                int i = 0;
                while (i < this.buttons.length) {
                    if (this.buttons[i] != null) {
                        this.buttons[i].setForeground(componentProperties.getForegroundColor());
                        this.buttons[i].setBackground(shapedProperties.getComponentPainter() != null ? null : componentProperties.getBackgroundColor());
                    }
                    ++i;
                }
            }
            if ((map = (Map)changes.get(titleBarProperties.getNormalProperties().getShapedPanelProperties().getMap())) != null) {
                InternalPropertiesUtil.applyTo(shapedProperties, this);
            }
        }
    }

    public void updateViewButtons(Map changes) {
        InternalDockingUtil.updateButtons(buttonInfos, this.buttons, null, this.view, this.view.getViewProperties().getViewTitleBarProperties().getNormalProperties().getMap(), changes);
        if (this.shouldUpdateButtons()) {
            this.updateCustomBarComponents(this.customBarComponents);
        }
    }

    private boolean shouldUpdateButtons() {
        JComponent[] titleComponents = this.getRightTitleComponents();
        if (titleComponents == null || titleComponents.length < this.buttons.length) {
            return true;
        }
        int i = 0;
        while (i < this.buttons.length) {
            if (titleComponents[titleComponents.length - i - 1] != this.buttons[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void updateCustomBarComponents(List list) {
        int i;
        this.customBarComponents = list;
        int size = list == null ? 0 : list.size();
        JComponent[] components = new JComponent[size + this.buttons.length];
        Insets[] insets = new Insets[components.length];
        if (list != null) {
            i = 0;
            while (i < list.size()) {
                components[i] = (JComponent)list.get(i);
                insets[i] = i == 0 ? new Insets(0, 0, 0, 0) : new Insets(0, this.view.getViewProperties().getViewTitleBarProperties().getNormalProperties().getButtonSpacing(), 0, 0);
                ++i;
            }
        }
        i = 0;
        while (i < this.buttons.length) {
            int k = size + i;
            components[k] = this.buttons[i];
            insets[k] = k == 0 ? new Insets(0, 0, 0, 0) : new Insets(0, this.view.getViewProperties().getViewTitleBarProperties().getNormalProperties().getButtonSpacing(), 0, 0);
            ++i;
        }
        this.setRightTitleComponents(components, insets);
    }

    public void dispose() {
        HoverManager.getInstance().removeHoverable(this);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            ++this.pressedCount;
        }
        if (e.getID() == 502) {
            --this.pressedCount;
            if (this.pressedCount <= 0) {
                this.dragOutside = false;
            }
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() == 506 && !this.dragOutside) {
            boolean bl = this.dragOutside = !this.contains(e.getPoint());
            if (!this.dragOutside) {
                return;
            }
        }
        super.processMouseMotionEvent(e);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.minimumSizeProvider == null) {
            return super.getMinimumSize();
        }
        Dimension d = this.minimumSizeProvider.getDimension(this);
        return d == null ? super.getMinimumSize() : d;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = this.minimumSizeProvider == null ? null : this.minimumSizeProvider.getDimension(this);
        Dimension pSize = super.getPreferredSize();
        if (d == null) {
            return pSize;
        }
        return new Dimension(Math.max(d.width, pSize.width), Math.max(d.height, pSize.height));
    }
}

