/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.OCSPRespBuilder;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.openssl.OCSP;
import org.jruby.ext.openssl.OCSPBasicResponse;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class OCSPResponse
extends RubyObject {
    private static final long serialVersionUID = 5763247988029815198L;
    private org.bouncycastle.asn1.ocsp.OCSPResponse bcResp;

    public OCSPResponse(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    public OCSPResponse(Ruby runtime) {
        this(runtime, (RubyClass)OCSP._OCSP(runtime).getConstantAt("Response"));
    }

    public static void createResponse(Ruby runtime, RubyModule OCSP2) {
        RubyClass Response = OCSP2.defineClassUnder("Response", runtime.getObject(), (r, klass) -> new OCSPResponse(r, klass));
        Response.defineAnnotatedMethods(OCSPResponse.class);
    }

    @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject[] args) {
        Ruby runtime = context2.getRuntime();
        if (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)0, (int)1) == 0) {
            return this;
        }
        RubyString derString = (RubyString)args[0];
        try {
            this.bcResp = org.bouncycastle.asn1.ocsp.OCSPResponse.getInstance((Object)ASN1TaggedObject.fromByteArray((byte[])derString.getBytes()));
        }
        catch (IOException e) {
            throw OCSP.newOCSPError(runtime, e);
        }
        return this;
    }

    @JRubyMethod(name={"create"}, meta=true)
    public static IRubyObject create(ThreadContext context2, IRubyObject self, IRubyObject status2) {
        Ruby runtime = context2.runtime;
        OCSPRespBuilder builder = new OCSPRespBuilder();
        OCSPResponse ret = new OCSPResponse(runtime);
        try {
            OCSPResp tmpResp = builder.build(RubyFixnum.fix2int((RubyFixnum)((RubyFixnum)status2)), null);
            ret.initialize(context2, new IRubyObject[]{RubyString.newString((Ruby)runtime, (byte[])tmpResp.getEncoded())});
        }
        catch (Exception e) {
            throw OCSP.newOCSPError(runtime, e);
        }
        return ret;
    }

    @JRubyMethod(name={"create"}, meta=true)
    public static IRubyObject create(ThreadContext context2, IRubyObject self, IRubyObject status2, IRubyObject basicResponse) {
        Ruby runtime = context2.runtime;
        if (basicResponse == null || basicResponse.isNil()) {
            return OCSPResponse.create(context2, self, status2);
        }
        OCSPResponse ret = new OCSPResponse(runtime);
        OCSPBasicResponse rubyBasicResp = (OCSPBasicResponse)basicResponse;
        OCSPRespBuilder builder = new OCSPRespBuilder();
        try {
            OCSPResp tmpResp = builder.build(RubyFixnum.fix2int((RubyFixnum)((RubyFixnum)status2)), (Object)new BasicOCSPResp(rubyBasicResp.getASN1BCOCSPResp()));
            ret.initialize(context2, new IRubyObject[]{RubyString.newString((Ruby)runtime, (byte[])tmpResp.getEncoded())});
        }
        catch (Exception e) {
            throw OCSP.newOCSPError(runtime, e);
        }
        return ret;
    }

    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject obj) {
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        this.bcResp = ((OCSPResponse)obj).bcResp;
        return this;
    }

    @JRubyMethod(name={"basic"})
    public IRubyObject basic(ThreadContext context2) {
        Ruby runtime = context2.runtime;
        if (this.bcResp == null || this.bcResp.getResponseBytes() == null || this.bcResp.getResponseBytes().getResponse() == null) {
            return context2.nil;
        }
        OCSPBasicResponse ret = new OCSPBasicResponse(runtime);
        return ret.initialize(context2, (IRubyObject)RubyString.newString((Ruby)runtime, (byte[])this.bcResp.getResponseBytes().getResponse().getOctets()));
    }

    @JRubyMethod(name={"status"})
    public IRubyObject status() {
        return RubyFixnum.newFixnum((Ruby)this.getRuntime(), (long)this.bcResp.getResponseStatus().getValue().longValue());
    }

    @JRubyMethod(name={"status_string"})
    public IRubyObject status_string() {
        String statusStr = OCSP.getResponseStringForValue(this.status());
        return RubyString.newString((Ruby)this.getRuntime(), (String)statusStr);
    }

    @JRubyMethod(name={"to_der"})
    public IRubyObject to_der() {
        Ruby runtime = this.getRuntime();
        try {
            return RubyString.newString((Ruby)runtime, (byte[])this.bcResp.getEncoded());
        }
        catch (IOException e) {
            throw OCSP.newOCSPError(runtime, e);
        }
    }
}

