/* This is a file of special graphs in sparse6 or digraph6 format,
 * for use with genspecialg -X# .
 * Note that graph names cannot start with a digit. */

#define SPECIALHELP1 \
" Arguments for genspecialg -X. Either the index or an unambigous prefix of \n" \
"   the case-insensitive name can be used. The -g switch is ignored.\n" \
" index     graph name                    vertices degree  edges  girth\n" \
" 150   ArmaniosWellsGraph                   32      5       80     5\n" \
"   1   Balaban10CageGraph                   70      3      105    10\n" \
"   2   Balaban11CageGraph                  112      3      168    11\n" \
"   3   BarnetteBosakLederbergGraph          38      3       57     4\n" \
"   4   BerlekampVanLintSeidelGraph         243     22     2673     3\n" \
"   5   BidiakisCube                         12      3       18     4\n" \
"   6   BiggsSmithGraph                     102      3      153     9\n" \
"   7   BlanusaSnark1                        18      3       27     5\n" \
"   8   BlanusaSnark2                        18      3       27     5\n" \
"   9   BrinkmannGraph                       21      4       42     5\n" \
"  10   BrouwerHaemersGraph                  81     20      810     3\n" \
"  11   Cage39Graph1                         58      3       87     9\n" \
"  12   Cage39Graph10                        58      3       87     9\n" \
"  13   Cage39Graph11                        58      3       87     9\n" \
"  14   Cage39Graph12                        58      3       87     9\n" \
"  15   Cage39Graph13                        58      3       87     9\n" \
"  16   Cage39Graph14                        58      3       87     9\n" \
"  17   Cage39Graph15                        58      3       87     9\n" \
"  18   Cage39Graph16                        58      3       87     9\n" \
"  19   Cage39Graph17                        58      3       87     9\n" \
"  20   Cage39Graph18                        58      3       87     9\n" \
"  21   Cage39Graph2                         58      3       87     9\n" \
"  22   Cage39Graph3                         58      3       87     9\n" \
"  23   Cage39Graph4                         58      3       87     9\n" \
"  24   Cage39Graph5                         58      3       87     9\n" \
"  25   Cage39Graph6                         58      3       87     9\n" \
"  26   Cage39Graph7                         58      3       87     9\n" \
"  27   Cage39Graph8                         58      3       87     9\n" \
"  28   Cage39Graph9                         58      3       87     9\n" \
"  29   Cage46Graph                          30      4       60     6\n" \
"  30   Cage47Graph                          67      4      134     7\n" \
"  31   Cage48Graph                          80      4      160     8\n" \
"  32   Cage58Graph                         170      5      425     8\n" \
" 127   Cage66Graph                          62      6      186     6\n" \
"  33   Cage68Graph                         312      6      936     8\n"

#define SPECIALHELP2 \
"  34   Cage76Graph                          90      7      315     6\n" \
"  35   CameronGraph                        231     30     3465     3\n" \
" 128   ChangGraph1                          28     12      168     3\n" \
" 129   ChangGraph2                          28     12      168     3\n" \
"  36   ChangGraph3                          28     12      168     3\n" \
"  37   ChvatalGraph                         12      4       24     4\n" \
"  38   ClebschGraph                         16      5       40     4\n" \
" 151   ConwaySmithGraph                     63     10      315     3\n" \
" 154   CoolsaetDegraerGraph                 42     13      273     3\n" \
"  39   CoxeterGraph                         28      3       42     7\n" \
"  40   DejterGraph                         112      6      336     4\n" \
" 153   DelsarteGraph                       243    110    13365     3\n" \
"  41   DesarguesGraph                       20      3       30     6\n" \
"  42   DodecahedronGraph                    20      3       30     5\n" \
" 130   DoobGraph1                           64      9      288     3\n" \
" 131   DoobGraph2                          256     12     1536     3\n" \
" 152   DoroGraph                            68     12      408     3\n" \
"  43   DoubleStarSnark                      30      3       45     6\n" \
"  44   DoyleGraph                           27      4       54     5\n" \
"  45   DuererGraph                          12      3       18     4\n" \
"  46   DyckGraph                            32      3       48     6\n" \
"  47   EllinghamHorton54                    54      3       81     6\n" \
"  48   EllinghamHorton78                    78      3      117     6\n" \
"  49   ErreraGraph                          17    5-6       45     3\n" \
"  50   FolkmanGraph                         20      4       40     4\n" \
"  51   FosterCageGraph                      30      5       75     5\n" \
"  52   FosterGraph                          90      3      135    10\n" \
"  53   FranklinGraph                        12      3       18     4\n" \
"  54   FruchtGraph                          12      3       18     3\n" \
"  55   GeneralizedHexagonGraph             126      3      189    12\n" \
" 134   GeneralizedOctagon45                 45      4       90     3\n" \
" 132   GeneralizedOctagon160               160      6      480     3\n" \
" 133   GeneralizedOctagon425               425      8     1700     3\n" \
"  56   GeorgesGraph                         50      3       75     6\n" \
"  57   GewirtzGraph                         56     10      280     4\n" \
" 156   GoethalsSeidelGraph                 105     32     1680     3\n" \
"  58   GoldnerHararyGraph                   11    3-8       27     3\n" \
"  59   GolombGraph                          10    3-6       18     3\n" \
"  60   GossetGraph                          56     27      756     3\n" \
" 135   GrassmannGraph1                      35     18      315     3\n" \
" 136   GrassmannGraph2                     155     42     3255     3\n" \
" 137   GrassmannGraph3                     651     90    29295     3\n" \
"  61   GrayGraph                            54      3       81     8\n" 

#define SPECIALHELP3 \
"  62   GreatRhombicosidodecahedralGraph    120      3      180     4\n" \
"  63   GreatRhombicuboctahedralGraph        48      3       72     4\n" \
"  64   GrinbergGraph                        46      3       69     5\n" \
" 155   GritsenkoGraph                       65     32     1040     3\n" \
"  65   GroetzschGraph                       11    3-5       20     4\n" \
" 138   HallGraph                            65     10      325     3\n" \
"  66   HallJankoGraph                      100     36     1800     3\n" \
" 139   HallJankoNearOctagon                315     10     1575     3\n" \
"  67   HarborthGraph                        52      4      104     3\n" \
"  68   HarriesGraph                         70      3      105    10\n" \
"  69   HarriesWongGraph                     70      3      105    10\n" \
"  70   HatzelGraph                          57    3-4       88     4\n" \
"  71   HeawoodGraph                         14      3       21     6\n" \
"  72   HerschelGraph                        11    3-4       18     4\n" \
"  73   HigmanSimsGraph                     100     22     1100     4\n" \
"  74   HoffmanGraph                         16      4       32     4\n" \
"  75   HoffmanSingletonGraph                50      7      175     5\n" \
"  76   HortonGraph92                        92      3      138     6\n" \
"  77   HortonGraph96                        96      3      144     6\n" \
"  78   IcosahedronGraph                     12      5       30     3\n" \
"  79   IcosidodecahedralGraph               30      4       60     3\n" \
"  80   KittellGraph                         23    5-7       63     3\n" \
"  81   KleinGraph                           24      7       84     3\n" \
" 149   KoolenRiebeekGraph.s6               486     45    10935     4\n" \
"  82   KrackhardtKiteGraph                  10    1-6       18     3\n" \
" 140   KummerGraph1                         32      6       96     4\n" \
" 141   KummerGraph2                         36      6      108     4\n" \
" 142   LeonardGraph                        288     12     1728     4\n" \
"  83   LivingstoneGraph                    266     11     1463     5\n" \
"  84   LjubljanaGraph                      112      3      168    10\n" \
"  85   LoupekineSnark1                      22      3       33     5\n" \
"  86   LoupekineSnark2                      22      3       33     5\n" \
"  87   M22Graph                             77     16      616     4\n" \
"  88   MarkstroemGraph                      24      3       36     3\n" \
"  89   McGeeGraph                           24      3       36     7\n" \
"  90   McLaughlinGraph                     275    112    15400     3\n" \
"  91   MeredithGraph                        70      4      140     4\n" \
"  92   MeringerGraph                        30      5       75     5\n" \
" 143   Mesner-WittGraph                     77     16      616     4\n" \
"  93   MirzakhaniGraph                      63   4-42      183     3\n"

#define SPECIALHELP4 \
"  94   MoebiusKantorGraph                   16      3       24     6\n" \
"  95   NauruGraph                           24      3       36     6\n" \
"  96   OctahedronGraph                       6      4       12     3\n" \
"  97   PappusGraph                          18      3       27     6\n" \
"  98   PerkelGraph                          57      6      171     5\n" \
"  99   PetersenGraph                        10      3       15     5\n" \
" 100   PoussinGraph                         15    4-6       39     3\n" \
" 101   RobertsonGraph                       19      4       38     5\n" \
" 102   RobertsonWegnerGraph                 30      5       75     5\n" \
" 103   SchlaefliGraph                       27     16      216     3\n" \
" 104   ShrikhandeGraph                      16      6       48     3\n" \
" 125   Skeleton120cell                     600      4     1200     5\n" \
" 126   Skeleton600cell                     120     12      720     3\n" \
" 105   SmallRhombicosidodecahedralGraph     60      4      120     3\n" \
" 106   SnubCubicalGraph                     24      5       60     3\n" \
" 107   SnubDodecahedralGraph                60      5      150     3\n" \
" 108   SoccerBallGraph                      60      3       90     5\n" \
" 109   SousselierGraph                      16    3-5       27     5\n" \
" 110   SuzukiGraph                        1782    416   370656     3\n" \
" 111   SylvesterGraph                       36      5       90     5\n" \
" 144   SuetakeGraph                         72     12      432     4\n" \
" 112   SzekeresSnark                        50      3       75     5\n" \
" 145   TesseractGraph                       16      4       32     4\n" \
" 113   TietzeGraph                          12      3       18     3\n" \
" 114   TriangleReplacedCoxeterGraph         84      3      126     3\n" \
" 115   TriangleReplacedPetersenGraph        30      3       45     3\n" \
" 116   TruncatedDodecahedralGraph           60      3       90     3\n" \
" 117   TruncatedIcosahedralGraph            60      3       90     5\n" \
" 118   TruncatedOctahedralGraph             24      3       36     4\n" \
" 119   TruncatedTetrahedralGraph            12      3       18     3\n" \
" 120   Tutte8CageGraph                      30      3       45     8\n" \
" 146   Tutte12Cage                         126      3      189    12\n" \
" 147   VanLintSchrijverGraph               162      6      486     6\n" \
" 121   WaltherGraph                         25    1-3       31     4\n" \
" 122   WellsGraph                           32      5       80     5\n" \
" 123   WienerArayaGraph                     42    3-4       67     4\n" \
" 124   WongGraph                            30      5       75     5\n" \
" 148   ZaraGraph                           126     45     2835     3\n"



static struct { int code; char *name,*p; } special[] = {
 { 1,"Balaban10CageGraph",
          ":~?@E_GA?a?QD`wYC`g]D`GUF`hoOCXGRbPAMCWoQbpMHDw_Ua`UJDGgYa@aHEWkZ"},
  {0,NULL,"b`aKEw{YbPeSDXWVd@aTEX[Zd`iaKIKphRMcKigliqq]Hh{hgAa`HxsnfAy@Nb}AL"},
  {0,NULL,"BiALRmBLruBLbq@MBf\n"},
 { 2,"Balaban11CageGraph",
          ":~?@o_GA?`_UCc?_JaOiKBwsMc@EQCpQWDh][EhmeDhiWexeVfXqGFg_^aQEIGgkc"},
  {0,NULL,"aaUHGGkbbAYLIG{kbaeNIwwibQuKHwS]`qQCFw[a`AEDGGWd`aM]HiClgambIX{fh"},
  {0,NULL,"QqcIi?glb}{PJ\\@nSUwOjk}mSAyOxksdq}\\JhcoeBUYKXWrfBJMTk|VsDbPU\\HYtT"},
  {0,NULL,"vSVLLZpc^IR[lKqCe@Vd}AWEE@WeUAWuQBXeeBXub\n"},
 { 3,"BarnetteBosakLederbergGraph",
          ":e_OGC_GFa`gs]QIcAwcUMMbBwcUVIgdY@QWRecilOtRhRbk{xAKfWH_xBJfgXW~A"},
  {0,NULL,"LoRQR\n"},
 { 4,"BerlekampVanLintSeidelGraph",
          ":~?Br_C??K?_?B_C??k?_C?_C?_C??{?@C?@K?@S?_C?AK?AS?@c?@[@?[@?_V_GD"},
  {0,NULL,"_GO_GN_GU_GT_GEBK@@_\\_GJBc@AS@AK@?{@@C@@oc_GLC[@AWa_GSCK@@GZ_GIBS"},
  {0,NULL,"A?WV_OCB?j_ODBKAAO`_OPCSA?wb_OGCcAAo[_OTBkAA_gDsAAWfD{A@geECA@odE"},
  {0,NULL,"KA?o]DkA@Oi_OHDKA@wZFSAA?YFKA@W_ESA@_^E[B?gdCo|FsB?ofD?xFO~_WIC?`"},
  {0,NULL,"Dwu_WHBwaDov_WLB_hEWs_WMBgiEOt_WRBW^Eo{_WSBO_Ewz_WTBWaF?|_WUBO`F?"},
  {0,NULL,"}_WJCWhEGtHCB@_cDOoE`F_WPBGgEGqGkBAOXCwoEXE_WNB_bDgxGSBA?\\C_lFP@_"},
  {0,NULL,"WFBodDw{G[B@?]ComFXC_gRBgbDWmHcDA_[C_jDxJ_wHC_fDW|HKG@ObD?jFpI`_P"},
  {0,NULL,"CGdDWyGSJAOaCojFH@`_NBOeDWtGhQ`WOBWdDWsGpPaWSDGiDWwGCL@o^C?jDg~JK"},
  {0,NULL,"E@oYCOjE@N_oLBW`DWpICNAG]C?jEXFIcOAO]BwjEPGI[IAg[CwjExCJcHAo\\D?jE"},
  {0,NULL,"pBJ[FAoXDOjFXLIkGAgXDGjF`MIsDAggDOkFhAHxR_gUCwhD_}GHOIcNA?`COkDhB"},
  {0,NULL,"G`YagUCWcD_wGhEJHd`gQBOdD_rHXLJhc`oPBWeD_qH`MJpb_wRB_gD_{GxOKSGA_"},
  {0,NULL,"\\CwkFXGHx`_wIBghD_nFxEISG@G[DOkDo~GhP`WPBO^D_pG@BJcKAOZC?kE@?G`Z`"},
  {0,NULL,"WMBo`D_tHPLIxj`_LBoaD_sHHMJ@k_oNBwdD_xHHKIph_oOC?eD_yHPJIhi`ORBGc"},
  {0,NULL,"D_uGPGK@m`GSBGbD_vGHFJxl_gFB?dE_yGhGIp\\McD@?WCotFHEGxTJpraGQB?XFW"},
  {0,NULL,"{HHIJx_KkF@?WBoqEX@GPVJ@eM{HAgWCOoFHGI@WJPj`OUB?`EGyGxNIxYLcJ@gWD"},
  {0,NULL,"GwF`CH`QI`q`_MB?iF?zGXJIHRMKRAgWBWpE_~GHZJpiN[SAoWBOoEg~GP[JhhNcL"},
  {0,NULL,"@wWB_nEx?HPPKPg`oOB?\\DouG@HIP`K{J@wWCWmFpJHpXJxmMsKA?WC_nFhKHhXK@"},
  {0,NULL,"lMkEAOWCwvFhBHpSKHnNKEAGWD?uFpCHhRKPoNSHAWWBwlEPEHxUJ`cOCIA_WC?lE"},
  {0,NULL,"XDI@TJXbN{D@GVBOpEXMKPmLx}_gIAwZE?qHh`LhoNkRAoVCgrFHCJxoMPta_TAwe"},
  {0,NULL,"EOyGX_LxpMsLA?VCwzFpDIxbMaB`oNAwgF_|GpWK`rOcH@OVBosEh?JHfL@w`WKAw"},
  {0,NULL,"XEovFxYLHiMyL_wSAw^EGxHPSKhgOkGAWVC?oFPHIXdKyE`gPAwiDo|GHUKpiNaF`"},
  {0,NULL,"oQAwhDw}GPTKphNYG_wTAw`DgtH`PLhqNQK`?UAwaDgsHXQLppNIJ_oKAw[Do{H@]"},
  {0,NULL,"LXsNyO_oJAw\\DwzGx\\L`rOAN`wQAwcEowI@[KXjOQHa?PAwbEwwHxZK`kOII__DBO"},
  {0,NULL,"ZDonFxRI`dMyHPSC?o[BgoEH?IhUKpwPYKRKC?w^CGzFhNIPaLq@PIL__GC?aF_}I"},
  {0,NULL,"@PKHlOQIPkCAOcDGqFHKJX\\L`yPYM__PCWiEWyHX[JpjNIKPsCA?bCwqE`MIhYLH}"},
  {0,NULL,"QqV__NC_gEWtHhUJPiNiTRCCA_^ConF@EJx`MACOyORkCAW_CgmF@DK@aLyBPANRs"},
  {0,NULL,"C@ogDGlE@CIx]M`tQIURcC@gfDOlEHBJ@\\MXuQQTR[CAoaCguFXGI`XL@~OyR__TC"},
  {0,NULL,"GeEw{GxRJHfOAGQcC@OZBovFp@IP_MH{QARR{C@GYBouFhAIH^MPzPySSCC@WXBgs"},
  {0,NULL,"FHHIx[KYEQQWSkC@_XB_tFPIJ@ZKaDQIVSsDAO^DOuFPCGxQJ@hLhwOYORA_SkDAG"},
  {0,NULL,"_DGvFHBH@PIxiLpwOaNQy^SsD@_aCWpFXCGpUK@bKxyNYLQi^SSD@W`C_oF`BGhTJ"},
  {0,NULL,"xcL@xNaLQq_SKD@w_CwsEpIHx]JxeMHyOAFQQ[RsDA?^D?tExHI@\\K@eMPxNyGQIZ"},
  {0,NULL,"RkD@o[CGrFX@HHXJXhM@uOQJPy]TCD@g\\COqF`AHPXJ`iLxtOIKQA\\S{LAo^C_mEh"},
  {0,NULL,"FHpZKHpM`zOqKPiXRqk`oTC?bDwsH@LJ`aMPrNaDPYLRI\\T[H@__D?pF@@H`VKHgL"},
  {0,NULL,"HxOAHRAXSaq`OJBwfE?wGPJJ@aKxiNP~PQVRIbUKF@_YDGqExJI@UJHoMYBOqRQqX"},
  {0,NULL,"SAn`?JBWiEWuH`NIhXLxsOaDQaTRI^UCMA_[BouFHDHpRJhiLhxOIQQYXTQl`gRBg"},
  {0,NULL,"]EwyGpLI`]LHmNQAQISRIhTsNAW`DOoExGHpQJhbM@zOiIPqYRcOA_aDGpEpFHhPJ"},
  {0,NULL,"pcLx{OqHPqYR[IAG[BwsFXKI@RJPnMXtNYFRAYSsHAO\\C?tF`JHxSJPoM`uNaGQyY"},
  {0,NULL,"SkI@_eDGlDpHHx\\JxgLP}OQKQaYSQj`GJCgiDgnHPOJp_KxhNi@PYRRQ`TcLA_XBW"},
  {0,NULL,"tFhCH@TKPfL`xOQNRAYSyn`oRBGYE_}GXFIp`L@jNQ@QAVRQgUCF@oZCwmFHFHXYK"},
  {0,NULL,"@cMPwOQFQi`TIz`?LBOgDwyH@KJP^KXpNA@PAUSQiVcKA_dCwlF`@HhRJ`kLpwNYI"},
  {0,NULL,"Qq]SioWSJAWeD?lFXAHpSJXjLhwNaHQi\\SqnWKNA_aDOqFo~HHZKPqM`wOARQyaSa"},
  {0,NULL,"mVQ|a?RCGhEW|FxIJ``MHrN@~QaWSIbTixVsI@w\\CopFhGHXPJXdLHtOYLQQ`TQwW"},
  {0,NULL,"kHA?[CgoFpFH`QJ`dLPuOaLQIaTIvWsQAoZBglExDHPRIpjMP}OaLRA[SapWcPAgY"},
  {0,NULL,"B_lEpEHHSIhkMH|OYLQyZSYqW[JAgYCwmFPLI@QJXeL@tOaMPycSy}XCKAoZD?nFH"},
  {0,NULL,"MHxPJ`eKxuOYMQAbTA|W{E@G`CWnEPCGhSJ@iMIAOqFPqcSrA_oICOcDorGXEIXVL"},
  {0,NULL,"HqOIDPAMSYdWKF@wYBgsF@@G`RIhcLhuNyMQa\\SSGA?ZB_tF@AGXSIpbLptOAMQY]"},
  {0,NULL,"SKEA_ZCWrF`AHHQJPgMXyOYHQI[TR?YKEAWYC_qFX@HPPJPfM`xOaIQQZTI~YSQAg"},
  {0,NULL,"]DOnEHDHHYKHcLptNyIPa^TBEXROaGUBohDooGpIJPaKXlMq?PIJSAfWjHX{F@WaD"},
  {0,NULL,"?rEx?Gh]KHdL`uNYFQyfTQsVzS`?KCGfEOuG@EJhaKhjMh{PAWTAhUZ?Y[JA_]C_y"},
  {0,NULL,"FpCHxPIpdMX}NyGPY]SqtWZK`_RBobFG|GXOIPTKhsNi?OyKRidUrCX[IAObCgtFW"},
  {0,NULL,"~GX]KPeLiCOqSQqgTQqUizW[HAGcCosF_~G`\\KHeLqBOiRQifTIpUq{WcI@oXCOyF"},
  {0,NULL,"hDH`SJ`eM@}OAIQiZSAkWBP`GLBG`FG}GpJIXZKpnNh~PIURa^TY~YSFAO[COwFO~"},
  {0,NULL,"HpVJxfMX{NiKPy[TIoVBNYsGAG\\CGwFG~HhWK@gM`zNqJQAZTQnUzOYkH@oeCwrF@"},
  {0,NULL,"GHPQIpkLhvOqGPaZRyyXsI@gdD?qF@FHHPIhjLpvOiFPY[SAxXkOAg]D?oFW~HXUJ"},
  {0,NULL,"xkLyAOiOQQcSikUZPY[NAo]CwpF_~H`TK@jMA@OqNQIbSqjUbQYcOAoXConEX?I@R"},
  {0,NULL,"J@mM`yNaNQQ_SQqVZK`wTBGdDoqG@NI`VLhrNHzQAPRy`UI{X[FA?XC?mEHAG`XJh"},
  {0,NULL,"jMH|OaIPYdTQmXr``?NBG^DwoGHBJH]L`qNqBPIKSqhTjL[SFAGZC_lFp?H@WJxhL"},
  {0,NULL,"y?OqIQI\\TAlVrg`?QBObDg|G@FIx_LPoNyDPIQRqfTq|[{E?w_DOtFpEHp[K@gL`t"},
  {0,NULL,"MyQQa_SquVbY[sE@?^DGsFhDHhZJxfLXuMyPQY^SitVZX[kEAoeDOsExAH`VKPcKh"},
  {0,NULL,"|OQOQqZRqxVra\\KEAgdDGtEp@HXWKHbKh}OINQi[RiyVj`\\SMAo^CWyF`?GHPJhbL"},
  {0,NULL,"xvNiSQy`SavWJIYCLAg_C_xFX?GPQJpcM@vNqRRAaSYwWRHX{PA_\\CgoFhMI@VJHc"},
  {0,NULL,"MHvNQGQicTAsYRVZsQAW[CopFpLHxWJHbMPvNIFQqbSyrYJWZn\n"},
 { 5,"BidiakisCube",
          ":K`ADQTeYXhCPChwaH\n"},
 { 6,"BiggsSmithGraph",
          ":~?@e_GA?b?QDBGQC`WUE`gaFDGeFDgeGaWgWapiJEWkRa`IGCWWO`o}IBgqQHGuT"},
  {0,NULL,"HhiPgyEXIx]RfQu_dAaadh_merI[frY]IX?ibrAMKyQwNJYeiId?lJAtmSIrNymlj"},
  {0,NULL,"cayjsiiOyqpPIUfPzHNlsuzNjo}nsBMSk|OoSJBPKdPnSjDPklRrCvFQGDSTWDUTw"},
  {0,NULL,"HWUWL[VwL\\VgHYU~\n"},
 { 7,"BlanusaSnark1",
          ":Q___dCfDEdcEgcbEGbFIaJ`JaHN`IM\n"},
 { 8,"BlanusaSnark2",
          ":Q___eDcdFcDeFcE`GaJ`IaHbKNbLM\n"},
 { 9,"BrinkmannGraph",
          ":T____gEFbc`GHaGIbFcELaDJM`DKLaEH`FIPcDFHbDEI\n"},
 { 10,"BrouwerHaemersGraph",
          ":~?@P_G?@_G?B_GA?_GA?_GA?@W?G_?Y?@w?J_?q?Ag?H_OKHA_kK_OKDB`KS_OKE"},
  {0,NULL,"C@GS_OKFBpCR_OKGBPCQ_OOD@_cP_OOD@ogQ_OOEA?oR_OOFA?kS_OOLB_{ODWCIB"},
  {0,NULL,"P?PD@q@AOsNC`K\\_OkMC@GREgCKB_{PD@m@@O_HB@?W_OSGA_kNDwCE@okKBPY@@_"},
  {0,NULL,"[HA_wX__KKBP?RE`saHAYA?okLBpOZFACbHgGBA_wNC`g\\FqKd__KHB`?PEpo_HAU"},
  {0,NULL,"A?oSE@o_TFq?`GgGCCPGRD@wbHASeIwGC@OkKB`[WFq?e__OEA_kOD`c_GaMA@?[H"},
  {0,NULL,"B?{UEP{`HGGCA?cIBP[WGQGd__SNC@CQDPW[FQWo___NC@KSDPcYEqSl__WLB`CRD"},
  {0,NULL,"P[ZFQKn__[LB`GSDP_YFAOm__SEA_oSE@c\\FaCi__SFAOkRDpc[FaGh__WGAOkQD`"},
  {0,NULL,"_ZF`{f__[GA_oPD`[YFa?g_oSEApGRFPw^GaKeIa{oKbOw_oSFB@CSF@w_GQOeIQw"},
  {0,NULL,"oKbKv_oWGA`CSEpw_GQKdHqsnKROu_o[GAPGRE`w^GaOdIAsmKRKt_oSHA_{OEPo\\"},
  {0,NULL,"GQGdJAsrLB[w_o_JB?{OD`gZFq?eJB?rLBSu_oWHB?sME@k\\FqCcJAwpKbWw_o[IA"},
  {0,NULL,"osMDpg[GAGbJA{pKbSv`?cJBP?QD`_[GaOeIQkqKrSwMwOIB?sNCPWVFQCbHagjKb"},
  {0,NULL,"OuLrqCA_oMC@OWEPg_HASgIrCrLb[x`?cJB_{RDpcZFqKdHqkpLBSwMgODA@?PCpS"},
  {0,NULL,"VGAGdHa_hJrOtLr}C@O_NC`OTE@{`HQWfIawrLb`?`?WFBPKSDPc`GaKcIQglKR[w"},
  {0,NULL,"NgOE@owPC`SUFq?bHA[gKBGtLbuDAOgMCPGVE@o\\FaSfIAkmJrG}Pw_JB?sRD@[WE"},
  {0,NULL,"`k]HaciIqwnKRtG`_cKC@CRD`cZFPwcIAcjJR?sOCYFA_kNC`OUEPg[FaKfIaklKB"},
  {0,NULL,"K~PWSEAowOD@SWEPk[GA[hJA{oMBpA`O[KB_{RDP[XE`s^IAgkJb?vMsEEA?gLC@G"},
  {0,NULL,"TD`_YFQGgIaolJrWyPG[GAOsNCPSUDpk[GQ[hJAsmLRdB\n"},
 { 11,"Cage39Graph1",
          ":y_OGCoTHdpp?ycPgTQcQHKeDxhYIWedGxEORfDWpIIOa@xGmSJbAGoiIHqhzX}k_"},
  {0,NULL,"ogjHyw\\gHIQMgegeIh]eY_jTsDQi`JD{Lar`iESHUo\n"},
 { 12,"Cage39Graph10",
          ":y_OGCoVIfbiPEHDbPG`UOOcchxQ[UeCxhASPbaGgeMHa`gouOKbbhW}SJnFyXQie"},
  {0,NULL,"oHypam`lF[YVCcgEYPqaZ_iDKDSp`ItcLYm`kE[H]q\n"},
 { 13,"Cage39Graph11",
          ":y_OGCwXLgaACeHIaQqSQUVdPrKSjMGRq[ohEDPpKWPDBPpscZJEQ@{SZOHSr|S|_"},
  {0,NULL,"OtcTtFYLxStpNWKsQ|PH@SIWQhVBUJWIx^BXKwR@b\n"},
 { 14,"Cage39Graph12",
          ":y_OGCkPLCbHOqMIDtA@MaQcpgsWlFJrHSuOWafWhqGZfCgxAORccW_mGDjHiy]q["},
  {0,NULL,"kEziM}cgGYPya_hhYhiga_iE[HQp`jUSLSm_iuCHWn\n"},
 { 15,"Cage39Graph13",
          ":y_OGCWJJCqh[[ZGEBiXEiPhSqcQGOeChhaLIadGxUM[cCHCXDHJQRkOTDDsC|CtR"},
  {0,NULL,"LvBmHHSRSbtc~UOTSl`FVOoTAeCiToTauEoXouJICmV~\n"},
 { 16,"Cage39Graph14",
          ":y_OGCgRGaAWgmKIbaIPE`PgUA|]lUceH@eSYdew`IMRbDWhQWLfBw_]IEghYAQmf"},
  {0,NULL,"jHjIAo`lGzYIi\\iFIP}e]_iDKHYq`jE[L]p`JeCDSj\n"},
 { 17,"Cage39Graph15",
          ":y_OGCWHDdAHKsSKdr@tGbPgUAtKnFacG`UOVcdHHUUYfEHPYWQb@w_aKNabYAUa_"},
  {0,NULL,"iGzPuu`nGix}kcihzIYc[heGI`RATIwYtb@VJwR@fBUKn\n"},
 { 18,"Cage39Graph16",
          ":y_OGCwZKbPqC]LHHqASaQUcqHPeUWdqhxu[[a@wgYGLabHOuUKaBwgyeahGyy]ke"},
  {0,NULL,"khZAQu_lGYHu_[ify`yAqXoTq}EhUodAqEjWodRB\n"},
 { 19,"Cage39Graph17",
          ":y_OGCgRGebHwycMeQXhI\\Jfdx@ALFIPRSSlCHpAK[bDGQPkgVEFp@S[PEESbLg~S"},
  {0,NULL,"QVC\\T@`PXc|XJRJurl?|PKOTAeCjUOUBEEmVotjMCiX^\n"},
 { 20,"Cage39Graph18",
          ":y_OGCoRGdbXOqcPgPg{QJEJpqsQJJLqbS_jHIQqKg`GHqQSOZDEPp{W\\cQtAlXFV"},
  {0,NULL,"PWS}@L[MuR\\_tRNsbt?b@SKwId\\ATjWQhXBWKgY|b\n"},
 { 21,"Cage39Graph2",
          ":y_OGCkRGbbGoiIIDsqLS`OHSYlgIRadHp]MXaPASWpLIQRKo|GCp`COVFDSC|DHQ"},
  {0,NULL,"QsrlSv[NUSDO~UPTsL`LYPoTAeCiTodauAmVouBMEpX^\n"},
 { 22,"Cage39Graph3",
          ":y_OGCgNHcP@GiKFEPP?meQgSZ@]sXjPqs_nHKqr[gpKLPQKOdEGPQ[WjCISA|CrQ"},
  {0,NULL,"JSrTSpSLvCTtF]QVsuDN_QoTAyChVotRAAjWodjMEkX^\n"},
 { 23,"Cage39Graph4",
          ":y_OGC[LMCB@kcSJicQdMcUdRBC_fLHQQKYMSaFWhAGOcAwwmKKaAWgiILnHzX}wc"},
  {0,NULL,"kgZiY_ahhY`ak_jgyhiaQ_jU[DOm`IT{LWq`iuKHSo\n"},
 { 24,"Cage39Graph5",
          ":y_OGCwWLca`\\KZIbRacSfGaDW{gtHKRQCSdJGpqS_bEGP@[OJGEPpcWRTJSrdctc"},
  {0,NULL,"Qxc|tFSNWST|@QKSB\\Cn@VJwQ``BUkWIdTBUKwQld\n"},
 { 25,"Cage39Graph6",
          ":y_OGC_NJCrPSoZDBBIpGfTiDx[OrFHpASwhEIpQCg`IGqQK_ZCBQ@[cXDBwSdpFY"},
  {0,NULL,"MsrtG~TQtB\\XLWPTsDDNOKoTZMCkUodAyAhWOtzEEiX^\n"},
 { 26,"Cage39Graph7",
          ":y_OGCoVIcbX?o\\QGSi[UHEGpqCQJDbpbcojHLQQc_lJKqqKgvEEppCOTONTa|PDZ"},
  {0,NULL,"RUC|C~ROtRlctbQVCDHJ@SIWIhVAUJWZ@fBWkgQx^\n"},
 { 27,"Cage39Graph8",
          ":y_OGCgOHcPggmMKaAYHAbSHtIT_nYKRBSgrJfdx@UMOacwpeGUbFXGyMLa@ZY]_["},
  {0,NULL,"gfYYUgUjhj@~CbnHIPiq`igGI`RATIwIpZAVJwZ@fBWkn\n"},
 { 28,"Cage39Graph9",
          ":y_OGC[JJCqhc_ZEDbiHAgQgTpPQHEKQa[SlGGpGc_zFHrAscjEHQRsuMdaayy]_W"},
  {0,NULL,"kejXqkbhhIiYg\\ngJqUaQoggI`RATIwIpZBWKwZDdAVJ~\n"},
 { 29,"Cage46Graph",
          ":]____fDedededeq@FGNaLMNcIJNbHKN`JMO`KLPcHMPbILOaFIPaGHObGJPcFKO\n"},
 { 30,"Cage47Graph",
          ":~?@B_GA?_HCObxgLD@YMD@eLb@QLCp]D``S[a@_^b`SVc@_XcPuE@w_HHWSIFGgJ"},
  {0,NULL,"Dg[ICwWJFw[KEGSKDwgQHGcODW_NCwWQEW_PDgcJBGkMBw[MCWcLCgSNCGCYHRYAE"},
  {0,NULL,"qWf_`wcIgKSIQyCFQ?n_PKXKgC`GauADPWj_qooKWO^LBUCDqKg_p_[K~\n"},
 { 31,"Cage48Graph",
          ":~?@O_GA?_I?D@_]YFP}ZF@yGB?uHA_mMCPINC@MTDpeSD`aGEP}GE@yQD`uRDpqH"},
  {0,NULL,"CPmHC@iKD@qKDPuLD`mLDpiICp}IC`yJB`qJBpuPD@}ODPyME@iNEPmDA?eDB`UDB"},
  {0,NULL,"pQFC`eFCpaECP]EC@YFAouEA_q@GACa_QOfIGCbHQYAIqoz_bcyOwGvMCICKbO|_r"},
  {0,NULL,"CrNGOlKB}BJa{}`ActOWKiLcB\n"},
 { 32,"Cage58Graph",
          ":~?Ai_C?_C?_DE?oF@?HfO|G@Bf_}GPDfW~GHC`OL@oNdoqE_we?rEovdwpEgxa?Z"},
  {0,NULL,"C?eaGYBgcaWXBofaOUBwbagVB_da_WCGa`WhDWl`_gDOk`OaCXB`OeCxC`OcChDb_"},
  {0,NULL,"]Ex?c?`FHAbg^F@@bghDxBc?kDpBbwgE@DcGlE@CbojDpDb_iDxCcwhEPAcOjEX@c"},
  {0,NULL,"ogE`?cgkEH@cWiEpAc_lEh?awgFGzbGlF?}bWiF?yaokEw{bOjFG|b?hEw~`gOAX@"},
  {0,NULL,"`wPAhA`oQA`?`gUCGy`gYB_}`oXC?~`wZBoz`wWBw|`oVBg{a?SDxDaWTE@BaGQDp"},
  {0,NULL,"CbGdEo|bWaEg{aocEOzawfEWybObE_~b?eEG}`_OEO|`WPEGy`WRE_{`_QEW}`WSE"},
  {0,NULL,"oz`_TEg~_oI@WK_oUBGn_oYBWo_oVB?m`G[COq`?]CWp`?_C_r_w`Cgs`G\\Cou_w^"},
  {0,NULL,"Cwt_wOAGv`?SAgw`GQAWx`?LD?h`GND_l_wMDOj_HEGxGHK@HPJH`L_HNI@RIk@Hp"},
  {0,NULL,"PIPS_PXJPZOsANHyNYR_PwN`~QkAMx|NqS_`]MY@PSDJxuOAJ_X`MiAPcCJ`sOYL_"},
  {0,NULL,"h\\MQCP{BK@pOiM_hbK`nO{CKpfLqH_XaKhoPCBIpgLIO_hWLPlQSCIxjLaP\n"},
 { 33,"Cage68Graph",
          ":~?Cw_A?G?_A?G?gO@oG?cA_Jf?\\@wFw_HpFW]p|GE[`vFc^qBfK\\PyFo_gK@?COQ"},
  {0,NULL,"@MVp_E[Y`mdoW`cEkZX]EKXPgEqVP`EWYPna[IolCKRGcAgJ`@CuHOhAoO@NaWI?n"},
  {0,NULL,"CGRgS@gK?yCUDoXBCMpC`SE?rB_PwU@kK_xCYFO_BONpI`oG_uBsQG^AKLo{CeF_`"},
  {0,NULL,"BSN`J_{T@TDWTwMDGSpWDeBPODCU`Z_oP`JCs_WKCSQ`MGIB@FCcRqB_oP@GCo_Gx"},
  {0,NULL,"BoO`kFyM_}CKZP~bkNp?E{^WwBsOPmFqK_uDgZqBbCLPYEo_grBOUplGAK?vDkZa@"},
  {0,NULL,"a?OPXE__waCGU@jGEGpBDcYQAaCO@WEg_GWCKT`dGEEp?D[XAA`cO`VE[_wYCCT`e"},
  {0,NULL,"GAHpHD_VP{aSQpXD{^gcCgU@]F}H`GDcV@|`cQpOEK^GYCcSP_FuEpGD?WP~`_Q`P"},
  {0,NULL,"EG^glC[TPkFmJ@EDOZPyawPPTE{]GnCOT@mFeL`MDKZPzbORPQEo]WtC{SpmFaLpK"},
  {0,NULL,"DGZpybkR`UD{\\wwCoTp]FYM`LD[VPsbcRpUDo\\W{CSS@iFYNpFD?YpsbsP`PEc\\w}"},
  {0,NULL,"COSPgFUD?iDOWP}`[I@TE?^wTAkT@bFuD_hDSW`{akN@REW[whBwS`fFAI?|DGX@p"},
  {0,NULL,"agNpRES[g\\B_U`[FAF?xDkVPq`wMpZDw[w^BgU`^FECoSAWL@{`GD_cBS^WR@SHOv"},
  {0,NULL,"F}C_VA[L`}`CE?^C?]WO@cF@BFaCOY@sO`y`?Eo]CC]wRAGJOzFAC__A{M`r`GGok"},
  {0,NULL,"B_[gRACJ_xFECOiBGN`u`?I?oB{\\WPAkKO|FQC?hBKN@vaGI_rE?_g_AcKP`GEGog"},
  {0,NULL,"BGWq?aCIooEG_wZA{QPdFAE_lCkX@q`cJ@IEW[WWAwQ@fFMFOdCOVPz`wHpDDo]W["},
  {0,NULL,"AOPp^FiFoeCWV`w`OLPKEk\\wTBWRPiFUDosC{YPu`WLpME_\\GL@OGpfFmBOTA?X@w"},
  {0,NULL,"_sDo`ES]gL@WG`eFeBocB?YPo_{HOqEk[wNA[KpgFEBoeBCY`q_wF_kE?\\GM@{JP`"},
  {0,NULL,"FUB_[A{W`u_wFOmEK\\wF?oBOM?}@oWA_LP\\_[EOiB[VGF@kIosD}@oYAcL`]_kJ?o"},
  {0,NULL,"C_ZGIAwKPHEuAonBKQpn_gJOqCgZgGA?MPKEAAO`B_R``__GozCsWgHAGM`NEMAOc"},
  {0,NULL,"BoP@c__HO|CSXWHA[NpEE]A?eBwPpe_gD?[C?YGJ@[Fp@EmAoU@sOpi_gDO]CGYWJ"},
  {0,NULL,"@KSPRD]A_QD?S`U_cCPTDcUwG@?T@WDi?QCGS`aFGa?QHGgaqKGu?QMG{cAPHq?QQ"},
  {0,NULL,"HKdATHm?QUH[eAXHi?a`IGgqcOE?biMo{rsPe?bhMk{RqPa?bdM_zRoP]?beM[zbn"},
  {0,NULL,"PY?qpKCwRuOY@QqKGwbwO]@AsKKxBvOe@arKOwrtOa@AtJsuRxOi@auJwubyOm?qw"},
  {0,NULL,"K?vB{Ou@QvJ{urzOq@ahJgpR\\OI@QkJcpr]OM?qjJopb_OU@AiJkqB^OQ@QdIstR|"},
  {0,NULL,"Oy?qfI{tb}O}@agIwuC?PE@AeJ?tr~PA?q\\KgrRPPI@Q]KkrbQPM@a_KosBSPU@A^"},
  {0,NULL,"KcrrRPR\n"},
 { 34,"Cage76Graph",
          ":~?@Y_GA?_GA?_Iw`GqOgIaklgAGdHa[hJGCGAOgJGAE@B?sMBqol_POVEp{cHwCO"},
  {0,NULL,"D`cYHQa@C`SWFQWi_PCRF@whIw[XFPw^GauEE@gZFAKk`?{TE`w_HGGNC`o^GQUBB"},
  {0,NULL,"PWWFq?j`OsOEpw`HgGMCPk\\GAaBB@[YFQCh`OoSEPo_IgOMCp_XGQ]FC@GRDq?b``"},
  {0,NULL,"CSDPW`GgKHCPGXHAqDApCVEASl__cRD@geJWOGC`WZIQuBA`?TFA[l`O_RDP{gJGG"},
  {0,NULL,"ID`[]IaqCAp?SFQkk`okMD`ocHgWIBPK\\HAUFAOoTEqSj`ogND@_gIW[GBPCYHqiE"},
  {0,NULL,"AOwOFqci`__NDpceIwWJB@G]HqaAA?oOEAGc_o_MD@wbHWOIB@C^GqYAAosTEQKh`"},
  {0,NULL,"OgMC`gaIwKJBpKZGaiCAOsVFAGg`OcND`sbH~\n"},
 { 35,"CameronGraph",
          ":~?Bf_C??K??K??GA_?@?[??GA?c??GB?k??GA?_E_?@?WD?{??GA?WC?gE?wG@K?"},
  {0,NULL,"_C?@[?@c??OC@WL_?B?gJ@gN_?F@GJ@k??oG@WLAK??OC@WL@wO_?B?gJ@gNA?R_?"},
  {0,NULL,"A?_K@oNA[??WD@_MA?S_?F@GJ@gPAS??oG@WLAGQA{??OC@_M@wRAk??WD@_MA?SA"},
  {0,NULL,"s??wH@_MAGTAwX_?E@?K@oQAoWBS??oG@_MAOUB?YBc??wH@_MAGTAwXB[@@WM_GK"},
  {0,NULL,"@k@@_LB{@@WMCC@?OEBw`_GB?w^CGb_GC@?^CK@?gHBw`Ck@?OEBw`CWc_GB?w^CG"},
  {0,NULL,"bC_f_GA?o_CObC{@?WFC?aC_g_GC@?^CGdCs@?gHBw`CgeD[@?OEC?aCWfDK@?WFC"},
  {0,NULL,"?aC_gDS@?_GC?aCgiDWm_GD@G_COeDGkDk@?gHC?aCohD_lEC@?_GC?aCgiDWmD{J"},
  {0,NULL,"@wOBwbCcJ@wOBwdCor`WPAO^CWcEWs`WPAO^CgeEWsEkKAg]C?hEGrEsKAo\\C?iEO"},
  {0,NULL,"rEov`WNA?aDGoEWs`WNA?aDOnEWsFKMAgZBwbC_rEkMAo[BwbC_rEgz`WVB?^DWk`"},
  {0,NULL,"WRA_^DWkFkJAwWBwfD?|FsJAWSBwfD?|Fo~`_XBW_DonE_t`_YB__DgoE_tGKKAo\\"},
  {0,NULL,"C?hEGvF?}F{KAg]C?iEOvF?}FxB`_XBW_DgoFh?GHA`_YB__DonFh?GHAGkL@wSCG"},
  {0,NULL,"bDCLA?RCGcC{MAgZCOhE?xFXF`oUB_aDOnFO{HCLAGWCGcCxG`gQAw`CWgG{LA?RC"},
  {0,NULL,"GeDXGH[L@wSCGdD`FHcMBO\\COhE?xHHJHkMBG]COiDwyHPKHsMAgZCOmEOzHHJHhN"},
  {0,NULL,"`oUB_aDgpF`IH`MICMBG]COlEHGHPOISMBO\\COmEPFHHNIKLAGWCGeDXGHPJHhR`g"},
  {0,NULL,"QAw`CgkGxHH`MIcJAGQCOlEGtEpQI[JAGQCOmEOtEpPI`V`oXBo^CgeE_uI@R`oYB"},
  {0,NULL,"g^CgeE_uHxSJKJAwWCOhE?xFO|FxHH{JAwWCOiDwxFO|FxII@Z`oUB_^DWkFW{Fg}"},
  {0,NULL,"HPQ`oTBW^DWkFW{Fg}HHPJkL@wSC?hEGvFXBGxMJkLA?RC?iEOwF`CH@LJsKAg]CG"},
  {0,NULL,"bD?vFHCGxKJcKAo\\CGcCwwFPBH@JJ[JAWSCOmEO}G@PI`VJCJAWSCOlEG}G@QIXVJ"},
  {0,NULL,"@b`oYBg^CwgFx?HxSJHY`oXBo^CwgFx?I@RJHYKkL@wSC?mDx@GpFHpXJxd`gOAW_"},
  {0,NULL,"DgoGPDH@LJP_KsKBO[CGbD@AGpFH`VKHb`_XBW`C_fGHDH@JJ@aKcLAGWC?mDwzGH"},
  {0,NULL,"EHXTJh^K{LAOVC?lE?{GPDH`UJp_LCKBO[CGeDWxGPEHhTJ``LKKBGZCGdD_yGHDH"},
  {0,NULL,"pUJXaLSLAGWC?hEGvGXJIhXJxdKxj`gQAw_DOqF@CH`UJP_KpgLcKAg]CGeDWvG`L"},
  {0,NULL,"IhVKHbLHl`_UBg`CgkF@BHpUJ@aK`iLsI@WKBw_EWsEguEwwFg}Fx?GHAGXCGhE`O"},
  {0,NULL,"L@o`CPFH@HHPJH`LHpNI@PIPRI`TIpr`OJ@_`COxFPVJ@ZJ``KPbK`hLPlLppMSI@"},
  {0,NULL,"gMBw_FW{JHYJh]Jx_KheKxgLXkLxoMkDA?YCWnEWyFXEH`OLHj__NBGcE?rFG{GhJ"},
  {0,NULL,"HxiLcEA?ZCWlEWyFXDHhPL@mM{F@w[C_mEWxF`EHpQKxlNCC@wXDWqEWwFHRIheLh"},
  {0,NULL,"oN@y_gOBOkEGrEwyI`UKhmLxvNKEB?\\CWlEWwFXRIhcLXqMxxN[FAw]C_mEWvF`SI"},
  {0,NULL,"pbL`pN@yNcH@w\\D_oEWwFHMHxdKxqN@yNX|`?OBojDwrEwyHhOKpgMHvNH{NsHAwZ"},
  {0,NULL,"CWqEWwFXKIHbLHoMxxNX|N{GB?[C_pEWvF`JIPcLPnN@yN`}OCA@wTCoiE_yG`IIh"},
  {0,NULL,"YM@p_WOAodDGsFHBHHUJHnMSAAGUCWhEg{GXIIhWLxqOYC_WQAgcDOtFXCHHUIxoM"},
  {0,NULL,"IBOcGA?]CgqE_xG`GIXXK@`OcH@w\\CopE_yGXFI`YJxaO[GAO\\C_pEgzGXGIXVJxa"},
  {0,NULL,"OqFPCHAG]CWqEg{G`FI`WK@`OiFPCAAWXCWhEg{GHLHxZK@mOiI_WSBOcDOtFXAHp"},
  {0,NULL,"OJ`^LiEPKA@wTCwlE_yGPJIH]KPkOYG_WOAogDosFH@H`QJh`LYCO{DA_UCWnEg{G"},
  {0,NULL,"HFHP[KHfOiIP[CAWTC_oEgzGPGHHZKPgOqHPcF@w[D?iE_yGPFHP\\JxhOYGPkEA?Z"},
  {0,NULL,"CwhE_xGHGHH]K@iOaFPsAAWXCoiEowHhOJH[K@lPYK_WSBOdDGuExMHxYJX^LqJPc"},
  {0,NULL,"AAGUCwlEowHXQIx\\KPjPiMQ[BAOTD?mEovH`PJ@]KHkPiMQcCAWTCgnEovH@IJP[K"},
  {0,NULL,"HgPyOQaU_gSAoeE?uF@FHHXJXaKyNQARQkEAO[CwhEovH@IJ@\\JxiQIQQaUQ{FAGZ"},
  {0,NULL,"D?iEowGxHIx]K@hQIQQYTRCDAOXCooEpDH`OJ@XLPkMxwQYURAX__PBOdDwuGpJHx"},
  {0,NULL,"VJPhLXvNASQiVRSEAO[ComEpEHhPJ@XKxlNHyQYURAXR[FAGZCglEpDHpQIxYL@mN"},
  {0,NULL,"HyQaTQyYRcFAw]CglE`AIXUJHcL`qNh}OaFPiP_oWBgeDosGHSIhYKXjMH|NqBPAM"},
  {0,NULL,"QSCAGYDWqEhAI`TJ@dLhnNX{OiIPaO_gQBGkEGtGHRIpVKpmM@zNaEPIJP{GB?[Cg"},
  {0,NULL,"qE`AHXPJHbLHnOIAOaFPiPR{HAwZCopE`@H`QJPcLPoOIAOYGPqQSCGAO\\DWnEh@H"},
  {0,NULL,"hNIxdKxpNy?OqHPYNSSHAG]D_oEhAHpOJ@eL@qNy?OiIPaOSKAAwYCWhFhEH`NJPZ"},
  {0,NULL,"LHoMy@OYDPYSRac_WWBGcDO|GhJI@XJ`iLxwOQCOqKQYZS[A@wTD_mFhEHpPJ@]Kx"},
  {0,NULL,"qNP~OYDPiURieS{BA?UDWlFhDHhQIx\\L@pNI?OaEPqTRqdTCEB?\\CWlFhDGxSJP[K"},
  {0,NULL,"HgNH|PAIPyVRq_TAi_wVBocDo|GpGIXXJXaKxyNqFPIORA\\RyfTKC@wXDWqFhDGxS"},
  {0,NULL,"J@\\JxiN@zPAIQIXRY`TAiT[DA?YD_pFhEH@RIx]K@hMx{OyHQQYRaaSyhTcAAWXCW"},
  {0,NULL,"hFpBH`OJHbLHnMy@OaDPYRRYbSyg_WSBOcDO}G`JHxYK`iM@wOQBOqKQa[SafTCA@"},
  {0,NULL,"wTCwlFxCHpQIxdKxpNP~OYEPiTRqdTIi_WOAogDo~GXLIHWKpgMPxOACOiMQq\\Sqh"},
  {0,NULL,"TSEA_]CWlFpCGxRJH`K`fNH|OyIPyWRi^TYkUCFAW\\C_mFpBH@SJPaKXgNP}PAHQA"},
  {0,NULL,"VRq_TYkT{DA?YCwqFxCH@SJ@_KhiMx{OyIQQXRY`TimUKC@wXD?pFxBGxRIx^KphN"},
  {0,NULL,"@zPAHQIYRaaTimUSHAG]D_oFG}G`JHx\\KHjN@~OyIPqTRaeUAr`?QBgjDwyFpBH`O"},
  {0,NULL,"JpaL`vOAGPILQqZSinUcHAwZCopFW~GXLIH[JxlNI@PAHPaRRicUQu`?WB_dEO{Fx"},
  {0,NULL,"CHpQJX_LpyOQFPQJQa]SYpUkEAO[DOkFO}G`IIp\\LpoNH{OYEQIXRiaUArU{FAGZD"},
  {0,NULL,"GjFG}GXHIh]LhnNPzOaDQQYRq`TysVCDAgWCooFW~G`HIhZLXpMx|OYEQAWRY_UIt"},
  {0,NULL,"VSCAoVCgnF_~GXIIp[L`qN@}OaDPyVRa^UQuVKGAO\\D?oFH?GhKHx`KhkN@~OyHPq"},
  {0,NULL,"URYdUyw`GPBofDwyG@EHXOKPeLXvOAGPQLQi[SqvVCHAW[CopF`?GpLIP_K`lNQAP"},
  {0,NULL,"AIPYRRicVIyWCGA_ZCgqFX?GhMIH^KXmNI@OyHPaSRqbVIyV{EAO[CwhFH?GpHIpe"},
  {0,NULL,"LhoNPzOaEQQXRiaVY{WB@_wPBWgDOyG@DHPTKhmLxxNaBOiPRQ]SIzVa~WSCAWTCg"},
  {0,NULL,"nFX?GpHIpcLXqMx|OaEQAVRa^Vi}WB@W[DA_UCooF`?GhIIhbL`pN@}OYDPyWRY_V"},
  {0,NULL,"i}VzAWcFAw]DGjEw|HhNJX\\JxpNq?PYPQaXRydSyiTal_oWBgiD_wFhMI@[Jp_MP|"},
  {0,NULL,"NyKQQRRQ_SqgTIjTsDAgWD_pEw|HXPJ`]KHnNaAPiNQqVSQbTAhTYmXCCAoVDWqF?"},
  {0,NULL,"|H`QJX\\KPoNY@PqOQiWSIcSyiTalW{FAW\\D?iF@?HhNK@cKhqNh~PYPQYYRydVz@W"},
  {0,NULL,"bDWzG_oSBofDGvG@MI@^KXeMH}OAKQQSRI_Sr?WRBWrFXCDA_UCwqF@?HXPKPbKpo"},
  {0,NULL,"NY@PiNQiWSQbWBAWZEXJIXcCAWTD?pEx?H`QKHcKhnNaAPqOQqVSIcVz@WbDXJIX["},
  {0,NULL,"AAWXD_mFp@I`UJhbLXmN`}PYMQYTSAaTysUyz_WSBOjDg}GPRIh]K`kLhzNiKPiSQ"},
  {0,NULL,"q^SIoUYwVcAAwYCwlFxAI`UJ`dL`lN`}PaLQYTRy`UItVI}XzO_WWBGgDo~GHRIhZ"},
  {0,NULL,"KpjLpzNiJPqSQq_SQqUqyVjNYCHAW[D_oFpAH@IJhbL@hNy@QAPQyXSYeTysUyzX{"},
  {0,NULL,"GA_ZDWnFp@GxHJpcKxiOAAPyQRAYSadUArVA{YCHAwZCwnFx@H@IJ`dKxiNy@PyQQ"},
  {0,NULL,"yXSadUItVI}YJRYcGB?[D?oFxAGxHJXeL@hOAAQAPRAYSYeUQuVQ|YRRYcA@?IEWu"},
  {0,NULL,"EwwGxHI`UMXsN`}OAAQYTRAYXzPYbU_WH@OrEovF@GHPRIhrM`zNh~OISQqVRJOYR"},
  {0,NULL,"RYjV_gF@OsEh@GPJHhNIHrMaJPiNQI^SQbSjFXJJXkC?oIE_tGHAH`MI@QMXsPaMQ"},
  {0,NULL,"AQSA`SaeXBIXbMZKA@?IFh?GhEH@IIXTMXsOYDOyHSyhTamVzAWbEYzW_WH@O|G@D"},
  {0,NULL,"GpFHHSIprMaCOqGPQgTQjTj?WJBWjVZBZ_gF@O}FxBG`KHpOIPrM`vNQZRqnUIsUi"},
  {0,NULL,"wVQ{VjXZSC?oIFo~GXCHXLHxPMXsN@xRa\\UAqUYuUyxVY}ZJYZkA@?IFGzJ`\\Jx`L"},
  {0,NULL,"XlMhuOyHPaMQYTUyxVzAXzPYzZ_WH@OyF`ZJp_KPkLptMqGPQJPiSQqwVR?WJOYRW"},
  {0,NULL,"ZcC?oIFPXJXaKhfLpnMhuNH{QAWRi`TarVZCXRMZR][CD?wIFHYJ``KpgLhoMhuNP"},
  {0,NULL,"zPyVRqaTYsVbBXJLZJ\\Z{C?oIF`VJp_KXhL`pMhuN@}QQYRa_TquVrEXBKZR][B`_"},
  {0,NULL,"gF@OzJ@\\JxcLPjMPtMpvNiPRIZRylUi|WjFXZXZj^[SA@?IJ@YK`eL@iM@qMhuOAA"},
  {0,NULL,"OYDSaeSyhUAqYbUYzZZza[cB@GIIxXKXdKxhLxpMhuNy@OaESYdTAiTypYZTZB[[B"},
  {0,NULL,"`[^\n"},
 { 36,"ChangGraph3",
          ":[__@_@_@AB_@ABC_@A_@BE_AEF_ADEG_BCFG_BCDHI_EFGHIJ`BEF`ACEL`BDFL`"},
  {0,NULL,"ACDMN`EFKLMNOaEGHLMbFGILNQaCGIMOQRaDGHNOQRSbCIJLMQRSbDHJLNQRTUfGI"},
  {0,NULL,"KNOPRSTeHJKLMPQUVcIJKMOPSUWXdHJKNOPTVWXY\n"},
 { 37,"ChvatalGraph",
          ":K`ACIQJCkqENGXwcKeG`d\n"},
 { 38,"ClebschGraph",
          ":O`ACGPDC[QPJGYCqG\\KafPK`ckeSqDsIWyn\n"},
 { 39,"CoxeterGraph",
          ":[___fCdechIdeKfgMgfchOePdQ`IKaLMbJN`OPbSTaQR\n"},
 { 40,"DejterGraph",
          ":~?@o_GA?_GA?a?]F`w]F`xGHaGqJbWiMC`MMCp]MC`]PD@]PDP]PD@UNDPYOD@YN"},
  {0,NULL,"CpYOC`YNCpUOC`QUDxKSc`UWGaYWGqU]GQY^GAU\\GqY\\GaUYFAYXEqUYGQQXGAQ[F"},
  {0,NULL,"aQZFqQGAPaHBQEGBQAJB@uKBP}JBPyIB@mIApqHA`iGA`eHBAMGAqIrLBUuLraxMr"},
  {0,NULL,"uyNBygKrufKrykLbyjLbuoLRqnLBmqLrepMBimMRqlMbmiLR]hLBa~Psa~PCy~Osv"},
  {0,NULL,"?QSj@QCfAPsj?Pcz?PSv@PcrAPSnAPCr@OsnGQcpMpsdJR[LCPSYETt`XUduDSDDT"},
  {0,NULL,"TduARtDRUdq@Rt@SUTmCSdPUUDqBSdLTTtm@?_wnKC}B@@CpKdI@@?{oKTQA?p?nK"},
  {0,NULL,"dMA@_wgJdi@@_wfJTeC@`CkJdaB@`CjJT]@@O{fITAA@P?gIdEC@O{iJDYB@P?hIt"},
  {0,NULL,"V\n"},
 { 41,"DesarguesGraph",
          ":S___fCDEccededaGLbGKaHJbHI`IJ`KL\n"},
 { 42,"DodecahedronGraph",
          ":S___fCDEceGcdIdeK`GaIMaJbKObL`HQ\n"},
 { 43,"DoubleStarSnark",
          ":]___eDccfedgIhJdFcEgJhIsKRlQrq`UVbNVaMU`OPbRTaQS\n"},
 { 44,"DoyleGraph",
          ":Z____eDdjGHgIeHKfIJbGcGcFbE`KQaJP`LOSaMNRbDHOcDINaFHQ`EIP\n"},
 { 45,"DuererGraph",
          ":K`ADpcJK`gdLGhgaH\n"},
 { 46,"DyckGraph",
          ":____fDEcEcDjIiighfjMkNjOkOlMlNced`PVaQVaSWbUX`RXbTW\n"},
 { 47,"EllinghamHorton54",
          ":u_OGC[LEdAXL?XIFCHW{`HcCwxMWTeDGsOkWadrCOJLFRP{k\\IFp@CSNZmFzhz?`"},
  {0,NULL,"pH[YQZasy\\EbNe`Id{LUn_itkDSk`JTsLWm\n"},
 { 48,"EllinghamHorton78",
          ":~?@M_GA?`OQCa_eHb_gLaouKbGiJbWqQDXKTc@QPDG{Qb`MHcHE[FXo]ePuWFhWZ"},
  {0,NULL,"dpibHH{agAEGiIaFiQmiIy{higSmJwWmKGWlJwSkKGaG`JSvlb]mljUyMzg{mRqwM"},
  {0,NULL,"zx?nR}F`yUfhgDDPwHDPgLCPwLBPgHAPGD@O~\n"},
 { 49,"ErreraGraph",
          ":Pa?_A_A``D`D`E`FG_B_CIaBFHaCGHKdEIJbDFIKMcEGJLM\n"},
 { 50,"FolkmanGraph",
          ":S____j@DEF`DEFaDGHbEGIcFHIcFHIbEGIaDGH`ABC\n"},
 { 51,"FosterCageGraph",
          ":]_____iBcd`aKLdIJL`HI`GJbELcFLaFIPaEJObGKRTcHKQSdEHPRdFGOQaGHN`E"},
  {0,NULL,"FKYbFHJMcEGIM\n"},
 { 52,"FosterGraph",
          ":~?@Y_GA?c?OD`_]KBWwNa?mHAh?SDXCQCwQC`WUE`gaHawiKbg}L`w]GagmHbwqM"},
  {0,NULL,"bXo]fQA[GXs^eqUYGhkbeaQ^GiCdgAQ]Gy[ghaifIyWhiAqjJygmiQuWJXcneQqWJ"},
  {0,NULL,"j_zmRisNZS{lr}uNk@BoSIoPJDDks]qPgDMRwHISGHJSWLLSwLKSgDGQ^\n"},
 { 53,"FranklinGraph",
          ":K`ADpcJK`gdLGhgaH\n"},
 { 54,"FruchtGraph",
          ":K`A?icgUtwdPKyGaH\n"},
 { 55,"GeneralizedHexagonGraph",
          ":~?@}_GA?h?OD`_]GAWgOb?yLCWkNa?iGAwcKaOuICgsSapUKCxCTb`INDH?Rc@EM"},
  {0,NULL,"BxWVd`uVFx[[d`yYFXk^ePyWFHgZe@eYGH_`eqMXGhwbfAA\\GX{a`aAFGW[b`aICD"},
  {0,NULL,"WOQ`PQDCyOdhbewOz\\AntJ?S{DOndErNZOzlRiuNIlDjCQmPytEjsaqQjDJkCegRI"},
  {0,NULL,"dLhs}iRlPTtd^cX}TeuEBXW\\laueN[YLthvun]YgDkZWDmZwHo\\GLp\\WLr\\wHq\\n\n"},
 { 56,"GeorgesGraph",
          ":q_OGCSHCc@xWaPHDq`cgVHEPw{sbNHRaL?dRJTAkWpDJqRSgrCmFZXvCDbVs\\xD`"},
  {0,NULL,"PwCUF@`oOtAeEiTocieAcSOSqmCfT^\n"},
 { 57,"GewirtzGraph",
          ":w_OGCA@?_OGCAAA__wGaAF_`gGQAD_agGeCBEbgO_]R`@pxICEGCWOgYP`APpACC"},
  {0,NULL,"ECgOSWR`aPXClBDAq@UGDDbqcWSJFEwocULLPp?kWVa@pXKpDCAqPeEEHCr@c{```"},
  {0,NULL,"px?oZOGwW_]PKebyIECEcqp[}b``PpGiVOGhGgWNIDsQMKFGcq`gybbAA@GgZMGg_"},
  {0,NULL,"caQIDRyDJDDCAXOk_Ohh?g[RJeb`xJFCbQP[u\\NHgwgWPIeRq@MjcAP`?kWNFtAiG"},
  {0,NULL,"IEbrHkw`SIggc[NKEbiDMja@`_wiWMGti}IEEBQpcyaUJg__[PJEri@Gha`ph?iYM"},
  {0,NULL,"Fsaf\n"},
 { 58,"GoldnerHararyGraph",
          ":Jk?XGaJ?GqeN?PAeMaG`cK\\A^\n"},
 { 59,"GolombGraph",
          ":IgMXG@F?PGaJ?GbFP\n"},
 { 60,"GossetGraph",
          ":w_O?K?AA_?W?CH??o?GY?@_?PC?B??ag?GGECAw?GGECag?GGFCAg?GGFCaw?GIE"},
  {0,NULL,"CA`{?CDBAPWy?AA`p?kZ?@@OwcSK_?o_WOIFcQPM?BA@`Gk[OHCw?KGFCAph?aR_?"},
  {0,NULL,"o_[QIECAHI?BA``?kYMFcq{?EDBAPOo[NHDg?KIFCA`_s]PIo?WSMHDb@gw_Sm_OO"},
  {0,NULL,"OKGDBqHGeTJDr@cs[____WQJFCAPKgUJeBHkx@@@?w_ULGCQXOiVKEbXqAAA@pGgW"},
  {0,NULL,"OGca`SkXLErcCCDBA@Ws[NHdAhWqYLfCCCCDBAPOo[NHDAh[oYLfB{CCDBa@OoYNG"},
  {0,NULL,"dAp[oXLfBsCCDBaPWoYMGDQp[oXLFBkCECBA@Ws[NGCQP[qYLfCAHEc__o_WQIEB`"},
  {0,NULL,"x?aRJEBPkw^OgscCECBa@OoYNGCaXSoXLfBqDCc__o_[QJEBPpCcRIEBHgw\\Ogc[C"},
  {0,NULL,"EDBA@OoYMGcaXSkVLfBp|?cSOOWSKHDb@g{_QHdAp[s[MfsALN@@`Ow_UKFBq@CeS"},
  {0,NULL,"IdrHoy]OGcsCEDBaPOs[NGCQPOiUKFBhw}`Qr@gw]OGcaXOiUJeBHgu[`?o_SKFCA"},
  {0,NULL,"Pgw_RIDrHgw\\OGcYXMhUJWOKGDB@p?cWNGcahWoZMFbyDGdSIdYt\\A@`?gWMIDbPx"},
  {0,NULL,"CeTJeRXo{_PHCq`SkUo_WOIEBa`Wo[OHDAp_s[MfsILIfSitjACBA@P?cSJEBQ@Cg"},
  {0,NULL,"TKER`s{`PHSqdSl`?o_SOHDApo{cRJDrPkw^OGsa\\OjUJUSGEEBa@GgUKEb`xOiUJ"},
  {0,NULL,"fBhw}_Qhcy`ZA@`_w_QIDcAHGeWKebXpAaPhDIhUkUlG_SKFCAPOkWLFBq@CcRMFR"},
  {0,NULL,"p|?`PGsauGDB@p?cSJIDQp[oXLEraTKfSITQlWlZ^\n"},
 { 61,"GrayGraph",
          ":u_OGCoGDb@w_aIJaag_eMGbAwoiMHcAxGiXMfsYDUhRhRY|YobkGjXqqYlgJPyw^"},
  {0,NULL,"kfZyAy]og{IIAgToTIiElVodayEcRociZ\n"},
 { 62,"GreatRhombicosidodecahedralGraph",
          ":~?@w_GA?`OQCa?]FaoiIb_uLcPAOd@MRdpYUe`eXfpy]gaE`hQQgHY{mjjGpjBEi"},
  {0,NULL,"laixHjewMj[zn`ugIQmlnRx?i{IhOytBnSPDlRg{hbSukbSukbKslyqvkZ@KRj@LR"},
  {0,NULL,"i|JRYMaIAeaGqQ_HtI^NRy^GAEwQza\\FhlYed`Xe`k[eA}VFTmVE@eTOHOmVhOTDh"},
  {0,NULL,"HKcQt`cPGRbsIMJEQMBpAKLGkjXwkKBWcdaAhia?cI`aPl`QYD@_]BFDeBFA]AMVE"},
  {0,NULL,"@HtI@?_R\n"},
 { 63,"GreatRhombicuboctahedralGraph",
          ":o_OGCSHCc@w{kTIfBXlKdQgtqtYpXhdZT[tPHRrsww\\fBqConJGfxWoZHIqAqIOH"},
  {0,NULL,"DPbCSuda`_{K_[`cAcGqg_cqcCCC\n"},
 { 64,"GrinbergGraph",
          ":m_OGCSHCdAWwiYGbAgo_RDBbg{mOKcbX_uIPaTa|CdVheilOxKhVBtk|^nujAQyb"},
  {0,NULL,"kggYDH@OHgQ]EdTOS[HCk\n"},
 { 65,"GroetzschGraph",
          ":Ji?c@pEUPBFaGhg@CKf\n"},
 { 66,"HallJankoGraph",
          ":~?@c_G?@_?CA_?CA_?CA_?CA_?E??W?@_?CB@?[G_?CD@_[G_?CB@O[H_?CC@_[H"},
  {0,NULL,"_?CC@O_H_?CB@__H_?GFA?cIAw?A@o_HB?u??_[GAOwN_?GD@_cIApCQ_?GB@?cIA"},
  {0,NULL,"pCQ_?GB@O_KBP?Q_?GC@__KBP?Q_?GC@O[MBp?P_?GB@_[MBp?P_?SEAOgKB`?SD`"},
  {0,NULL,"a?@OWHA_sNC@OTDw?C@__IB?wPCpSWEg?B@_[IB?wQCpWVEg?C@O[IBO{QCpSWEW?"},
  {0,NULL,"B@O_IBO{PCpWVEW?B@?cJB?{OCpWVEpu??oOHAosMC@KTE@o]_?OEA?kKBpCSDP[X"},
  {0,NULL,"F@s__?OD@okKBpGSD`_YEpw__?KE@okLB`GSDP[XEpw^_?KDA?kLB`CSD`_YF@s^_"},
  {0,NULL,"OGFA?cIAp?PC`KS_OGFA?cKBP?PC`SU_OGFA?cMBp?PC`[W_OGB@?cIAp?RD@{_Ha"},
  {0,NULL,"]@?_SEAOgJC@KSEPgeHwCA@?WGB?sPDPWZGQSf_OGB@O_KBPCTD`wcHQ]@?_OD@ow"},
  {0,NULL,"NC`[WFQGdHgCA?oWFB_{QDp_[GqSe_OSEAOgKB`KXE`k[HQ_iJWCD@_cIBO{REPg\\"},
  {0,NULL,"FaSgIqq@?oWFA_oME@cZFAKfIQgkJwCC@__IB?wUEPk[GQWhIqsn_OOD@ogLBp[YF"},
  {0,NULL,"PwaHqcjJQy@?oSGA_sNDPg\\FaOeIQgkJgCB@?cJB?{SFq?`GaShIaopKgCB@?cJBO"},
  {0,NULL,"wSFq?bHAShIqsoKwCC@__JB?{UEp{`GaWgIqomKBGt_OOD@okKBp[\\FqCaHq_iJQ{"},
  {0,NULL,"pKrU@?oSGAosMDPw_GqOeIAglJr?qLGCB@_[JBOwWFA?bHA[gIqomKRKs__KCA`?R"},
  {0,NULL,"DP_ZFP{_HQciJB?rLBUA?oOIC@KUDpo]Fq?dIQklKRGsLWGD@_kOD@WWEPgaHASgI"},
  {0,NULL,"qomJrWx__SEAp?SDP[XEaCbHQ_iJQwnLraA?oSKCPKUDpo]FqOeIAglJbKvMBg{__"},
  {0,NULL,"OEBPCRDP_ZFQ?`Ha_jJA{pLbczNWGB@_{QCpWVF@w^Gq[gIqonKBWxMbuA@?SMC`K"},
  {0,NULL,"TE@k\\GAGfIAglJbGvMBk{__KDB@CSD`_XFaGcHaciJB?rLB_zNS@@__KEBpGSDP[Y"},
  {0,NULL,"FACbHqciJB?rLBczNBw~__OEBPCSDP[YEqCbHacjJRCqLRWyNC@@__ODB`GSD`_XF"},
  {0,NULL,"QGcHqcjJRCqLR[yNRw~`o_IApCQCpO[FQCcHa[gIRCrLrc}NsLD`o_IApCQCpOZFa"},
  {0,NULL,"GbHa[gIR?qLb`?OSHC`ocKBP?QDPWYFA?aHQ[iIqwqLBczNCDB`ocKBP?QDPWXFP{"},
  {0,NULL,"bHQ[iIq{oLR[yNS@Da?cMBp?PDp_XFa?`HQWkJQ{pLB_zNR|Aa?cMBp?PDp_YEp{c"},
  {0,NULL,"HQWkJQwrLRWyNBxC_o[IB@CSE@cZFaGbHQklJbCqLBcyNBxCPSXHQgOGA_wQD@WXF"},
  {0,NULL,"@s`HASiJAwoKrSuMrp@OcLFQSiBA?gNC`OTE`o\\GQOdIqsnKRGsMBg|OCPDPs`J`?"},
  {0,NULL,"[IBPCSDpgZFaGbHQgkJr?rLR[zNR|AOsXGQwKFA_oODP_XEps^GqWgJQwpKr[xMrs"},
  {0,NULL,"~OSHFQClMRwKGA_{ODP_YEps^HA[gIq{oKbWwMro~OSLEQShKRWOGA_wOD`[XF@w_"},
  {0,NULL,"GQ[gIawoKbWwMbs}OCTEQClMRwOFA_sOD`[YF@w_GaWgJA{pKr[xMbo}OCPFQShKR"},
  {0,NULL,"WSFAooPCp[[FP{`HASjJAwqLBWxMrs~OCHFQSlLRdADA?kMC`KTEpw_GaKdIqomKr"},
  {0,NULL,"SuMRg|Ns@DPc`IRC|Q`_[JBPCRE@o\\GACcHQglJr?tLr_yNBx@PC\\GQctMSwWGAo{"},
  {0,NULL,"QCpWZF`{aGqSiJQ{pLB[wMro}OSLEQSlKRtED@okKC@SVEPs^GQKeIQooKbOuMBg{"},
  {0,NULL,"NcLCPc`IRDDQTTYEA?kNC@WWE`k^GaOfIQgpKrOvMRg|OCHDPs`IRd@RTTYE@okLC"},
  {0,NULL,"@WWE`o_GaOeIQsoKbSuMBk|NsHDPcdJRtDQTD]DA?kMC@SVEPw_GQKfIQkpKrSvMR"},
  {0,NULL,"k{OSLCPsdJRT@RTD]DAOoMCPKVE`k[FqOfIQknKBCtLrl?OSHCPc`IRtDTTd`X`Oc"},
  {0,NULL,"KB`GRDPgZFA?aHackJr?pLB_yNb|BPS\\HQsxRTD\\YUwWHBO{QCpWXFPw^GqWhJQwq"},
  {0,NULL,"KrSuMrw~OsTFQChLSDTUUDeEAOsNCPKWEPs]GACfIQgmKbKsMRh?OSHCPcdJRDHST"},
  {0,NULL,"thZ_ocKBpCSE@c]GACaHq_jJr?tLb[{Nb|BPS\\GQsxNSDHUUtt]_ocKBpGSDPg[GA"},
  {0,NULL,"CaHa_lJbKtLb[|OCDAPCXHQcpLSTLTUdp^`?cLB`GSD`c\\FqKcHa_kJrCsMBc{OCD"},
  {0,NULL,"APCXGQsxNSDHVUDp^`?cLB`CSDpgZFqKcHq_iJbGsMBc|Nb|BPS\\HQcpLSTLSUTt]"},
  {0,NULL,"\n"},
 { 67,"HarborthGraph",
          ":s_O?KA?Bb@XGSLEBaWwiMJdbIHAOOgCQTCfSiDZ@WnTJEH@InVLtr@miXLVJ{{s\\"},
  {0,NULL,"NRrXo~MORryA[_PhHqNLLGCX?oYgaa[}XMj`IgIlXCFBwa\\Un``_waEDTJWGHYm\n"},
 { 68,"HarriesGraph",
          ":~?@E_GA?a?]E`GUC`gUD`GYF`xoKCg{Rc@ELBgoSbP]ODWwWcPiNDhKXc`mJEg_T"},
  {0,NULL,"a`]GEGkZaPQHDggXdPYVExOWePioKzCqgAa`IYOjhQiaJIKnhqyeJXo^fPy@Lb]AM"},
  {0,NULL,"BeAMbu@MrqBLR}BLBz\n"},
 { 69,"HarriesWongGraph",
          ":~?@E_GA?a?YF`WQC`W]E`GUF`hoKCx?QbpELBgoSbP]QDWwWc@mPDhKXbpiHEg_T"},
  {0,NULL,"ap]GEGcXa`QJDggZdPYVEXOWe`moKzCqgAa`IYOjhQqfIiWngqyaJXo^fPy@Lb]AM"},
  {0,NULL,"BeAMbu@MrqBLR}BLBz\n"},
 { 70,"HatzelGraph",
          ":xa`GwYQGdag?Q?D`awGYCH`AGG]EIbQac]IUaQBCmQYeSRcuc]hriAE]__OW[Iwc"},
  {0,NULL,"mh{YV?enHKQ^AenhY`YmWkeyhj_pXK|AfWnYzTrVSjZL~\n"},
 { 71,"HeawoodGraph",
          ":M`AE?cJCpxCLK`xDNKhn\n"},
 { 72,"HerschelGraph",
          ":JcAKWObGXRqGW{qDL\n"},
 { 73,"HigmanSimsGraph",
          ":~?@c_GA?_GA?_GA?_GA?_GA?_GA?_GA?_GCA?oOD@gCABOwNCWCAAooOCgCA@ogS"},
  {0,NULL,"DgCAA?cRDWCBAowTDgCBB?sRDGCBAOgNCGCB@o_PCgCEBpGSDWCEC@CRDgCEA?gJB"},
  {0,NULL,"WCE@ocKBgCC@okNCwCDA_wQCwCCAOsQDgCDAOkPDGCD@osODWCDA?oNDgCCA?wODG"},
  {0,NULL,"CCA_oPDWGBC@CSDQGbHASeIWGBBpGRDaGbHq_iIwGBA?gKBa?`HAWfIGGB@ocJBQ?"},
  {0,NULL,"`HQciIwGEB?sTD`w^HASfIgGEAowRD@w^Ha_hIwGEAOgPC`o\\HA_hIgGE@o_NC@o\\"},
  {0,NULL,"HQWfIwGDAOwOD`s^GAGcIwGDA?sQD@o]GQKcIwGDA_kNDPs^GQKeIgGC@owQDPs]G"},
  {0,NULL,"QGfIWGCAOoND@o^GQGdIGGCA?kPD`s]GAKdIGGCA_sOCpo^GAKfIWGD@ooPCpo]GA"},
  {0,NULL,"GeIgKEBOwOC`gZHA[hIrWwMRmB@_kKBpCYEqSeIAgsLR[y_oWGAPOUE@ccHQ_jLb["},
  {0,NULL,"yMwKE@ogRDP_XHa[hIbOtMBeB@OgLCPWXEq?bHAgpKr[w_oSHB@GTE@g`GaOiKRKx"},
  {0,NULL,"MgKD@owND@cZGQGeIr?qMRiB@?gJC`OWEqCbIAcoKrOz_oOGBO{TEPg`GqSfKRGsM"},
  {0,NULL,"wKC@ooOD`_ZGAGdHrCqLRYB@?cMCPKXEa?aIAcoKrSu_oSGAp?RE@g_GqWjKBGvMG"},
  {0,NULL,"oMCPGSD`[ZFaGcIA{rLbg~PC]JBO{OD@WVEp{bHQkmKb[zNsDEaosPC`KTDpg]Gqc"},
  {0,NULL,"iJbKsMBxAPWoMBp?RDP[YFqGeHq{qLRc}OCMGA`?QDPWVE@sbHA[nKR_zNSHE`ocN"},
  {0,NULL,"CPSUDpc\\GaSiJbCtMbpBPw_IBpCRD@[XFAKeIA{oLB[{OSUFAP?QCpOVE@oaIQkmK"},
  {0,NULL,"BWxNS@CaOgLB`OTDpc^GQOhJRKxMrtDPw[GAooSDP[WFaCdHasqLBg{OCYFA?sMCp"},
  {0,NULL,"WVEPw_HqkkKbWwNSDBaOgJB@KUDp_^GA_iJBKtLrpAPG_HB?sOCP[YFA?cHQspLb["},
  {0,NULL,"~OcMFA_kMC@CVEps_HaclKBSwNcDCa?cJB_{QDpg\\GQ_jJB?yMr|?PW[IB?sNC`[Z"},
  {0,NULL,"FACfIaopLBc}Pc]C@O[GAOgWEPo\\GACkJR?pNBtGQShJ`OWGB`CTEPg\\FaOeJQ{wM"},
  {0,NULL,"cLDQS|RTwSEA_oOD@_ZF@{cHasnLrdCPchLSdYC@_gMBpWXEps^Hq_kJrSzOS\\IRt"},
  {0,NULL,"DS`OWFApGUE@k\\FagjJAwwMcPEQsxOTGOE@osPD@cZF@wdIQsmLBX@PslKStYC@_c"},
  {0,NULL,"JC@SWE`s^HQclJbSzOCHGRdHV`OWHBO{REPg[FqgjJAwvMSLDQCpPTWOEA?oQCp_Y"},
  {0,NULL,"F@wfIAonLBX?OcdLSDUC@PKSDPWWEPw^GaKmJrGrNBtSTTXV`?SNC@CQE`k[FQGbJ"},
  {0,NULL,"a{oKRw~SDDQSwODAooLB`gZF`{_GQolKbK}NspLRc~\n"},
 { 74,"HoffmanGraph",
          ":O`ACK`IW{afPKhcPGW{aFPK`cPCKn\n"},
 { 75,"HoffmanSingletonGraph",
          ":q_OGCA@?_OWKEB@_o`C[YMaA`sKWMbApsSQMbAG_aMG`aGgaCIIo``]CHKO`hYCJ"},
  {0,NULL,"IOpG{gXaBAP_w]aaq@Ws]bBAXWrDEcaxeMJGeBKWYPIesC[QQIegWkeTMPP_{i\\aB"},
  {0,NULL,"QXOsbaAQHWyaaApx[u`bA`x_seSpPPCg[QigwgeVMfscKYOKFSIUEIHDbY\\PECcAx"},
  {0,NULL,"pEfbbA@OuaR^\n"},
 { 76,"HortonGraph92",
          ":~?@[_GA?aOQHaWwLbXCOcH_QDPYPDP]PCpYQD@]SDhKVdXKSgPw_fqAEGHo\\`hyM"},
  {0,NULL,"HAUMGqYNGaYNGQULiymKJGoljIuokY{ojbEqLZKscGqqKzoyMzczmBmuLzaxnsA{O"},
  {0,NULL,"Zt?ncFAP[LCaC]FPkfG`ohJa?lI`?UFAGlJaciD@gUCt_LMTWHNTWDRTWLQTGHRTG"},
  {0,NULL,"DOS^\n"},
 { 77,"HortonGraph96",
          ":~?@__GA?`oUD`gYL@oqGBGcJa_mFaGeI`GQPDXGTcpYSDgwPbPIOCw{Se@mXFhg\\"},
  {0,NULL,"dpq^Gi?`hIMehiUd`WYfIy_jiQqiJGqJ`I]giierkzCskRUqLjGvjbQlLZ?vjrZCO"},
  {0,NULL,"{MwOjdAmb}zNjt@nCBBojaxrCzKR{\\Mpc~CR[TLqSnGQkVC_t\\X_dXW_dTX_tPW_T"},
  {0,NULL,"@R_TDQ\n"},
 { 78,"IcosahedronGraph",
          ":K`?K?oD?XJ`CYGrFcOpxdKa`RHT\n"},
 { 79,"IcosidodecahedralGraph",
          ":]___@_AeDddEdFefIhgKeIfJhKgLiJkLmPnO`MSaNTcOTbPS`QUaQVYbRXcRW[\n"},
 { 80,"KittellGraph",
          ":V__@`A_@eDe`BCbGdeFijKkLdEIJKLfJLMcGHiKMPhMOPQ_ADEFaBFHORS_CDIPQ"},
  {0,NULL,"S\n"},
 { 81,"KleinGraph",
          ":W__@__@_A_BC_BDi@AGaEHI`FHIcEGIJdFGIKcDHaBHJ`BHKOcFHKLNdEHJMN`CG"},
  {0,NULL,"NPaDGNOSbFGLOQTbEGMPRS\n"},
 { 82,"KrackhardtKiteGraph",
          ":I`OKhdcOkqENGXRFP\n"},
 { 83,"LivingstoneGraph",
          ":~?CI_A?G?_A?G?_A?G?_A?GW?qD?W`[EGR@aDOW`WEGK_qBGK_qBGK_qBGK`ICgQ"},
  {0,NULL,"`ICgQ_uBgN`ECGL`ABgN`EBOlB]BolBUCOlBYC?lBMB_lBQBOq`?JwMBABop`CJgL"},
  {0,NULL,"B?NGPA{MwNBGMGOBCMWMAwMgLAmB_i_{IGPAqC?h`GH@@`GH_~`GHo}`GGo|`GHP?"},
  {0,NULL,"_sGGO@yCO`_wGgN@}BO`CKTGOA?O`T_wF`DDMBoaCWSWP@{P@Q_sGpH`CH@GDmBod"},
  {0,NULL,"CkVGMAWPp\\`?HpIDkVgVAoLpF`KIorCmD?hBOQGTAgLPH`WI?uCiD_qCyDOmC{XWR"},
  {0,NULL,"B?SGSBCR@eE]DonCsXPf`SKOsDmD_mBSVwVBGL`]`OK?rDqConB[VWSAkO@PDOXGU"},
  {0,NULL,"AgNPRDOWWTAcOPQDSWGRAoNpQDKWwVA_N`PDSWgTA[Ioz`OGokBaD_eAcNGRAOI?y"},
  {0,NULL,"`[HOiBeDObBWSplFYD_fB[SPiFaDoeBKS`jF]CodBOT@kFUD?cBSTPmFQDO]BKUPf"},
  {0,NULL,"FaD_aBOU`gF]Do^BST`eFUD?_B[U@hFYCo`BWTpdFQCo]B_P`M`[G?yCSRwSAGMpC"},
  {0,NULL,"CuDO^BoOpO`WGOxCGRGL@kH_gGYCOYA[IaD`?EOdAo`wM@oH?jGQBo\\AKIQB_sEO]"},
  {0,NULL,"BwQ@K`CEo_BsQpO_wFO^C?Q`M_{E_`CCPpL`?F?aB{QPN`[F@BEOZQI`WEPCEKZaG"},
  {0,NULL,"`OE`DECYqK`KFPAE?YaJ`SEpEEGZAH`WF?nCCQpX`SEOqC?PpW`[FOoBsQ@Y`KE_p"},
  {0,NULL,"BwQPU`OEomB{Q`V__E?|CWVPrFY@oWBwP@[FG]GI@_O@AD{[Pt_cE?~CKUpnF]AoW"},
  {0,NULL,"CCPP]F?\\GEAwN`kFg`QK_WK_~Ew]qEGe@_nC?ZP{G[aGEB?OPiFs`AI_WKO|Ek]QB"},
  {0,NULL,"Gm@@[ECZ@pGCaGBDsW@jE{_aH_CVpbEs[p~Gm?`]EOY`qG?bGDDkW`mF?^aI_GOpD"},
  {0,NULL,"CoWptGGfAe_CO`CD?W`vG?gAf_OP@DCwW@uFwfqg_SOpECsWPwF{fah_KO`EC{X@s"},
  {0,NULL,"GCfQi_gLPVE?\\qLH]A?vDcW`sG{egJBWU@`FScQXJ?kWHBOT`cF_baWJA@orDgWpu"},
  {0,NULL,"H?eqpJMAolDKXpyGsdA^_[JPQEW^ANHKgGHAsT@dFscAQHqA_lDSYPxGwdQ\\__JPP"},
  {0,NULL,"E_]qPHWfgDA{PpRD[XaDIa?OoCkSPWES`ah_GKPGDGUPhG[hwCBGQ`TDWYABIi?om"},
  {0,NULL,"CcT@YE[`Ae_KLpODwWqLHGhQx_GL`LD{WaMHKhAt_SL@NDoWANHOgav_CLPMDkWQO"},
  {0,NULL,"HWgqw_OKpKDsXAPHSgQu__IOoBkSp]F[nWJAkJowDSVpwJyA_kBGM`SDk\\a{_[I_p"},
  {0,NULL,"BoSP\\FSmgHA_J_xDGV@sJmA_cBWN@jFw`WHASLOzEg_QB_[H_sB_ZQAGQA?fBKM`m"},
  {0,NULL,"G?`wJAKLoxEo^qE_gGoiCg]p|HgmwJA[I@FFc^AZJqA?eAoQpyFseA}_[HOjC_]Pz"},
  {0,NULL,"H[nWHAOIPHFg^AXJi?O_A_LABGcdqj_GF_kBS`QGHcjwBAGIouGWaaYIu@?^AcLqF"},
  {0,NULL,"Gkeqm_SGOiBK`AKH_jGAAKQpYGsdQUJ[mbKLU@OdCgUAOHKdQxJwqRR_OH`HD[bqQ"},
  {0,NULL,"HWlQ{Kgtw@AOPpXGwcaSJWnRLLQ?ofC_TaPHKdAwJkqrU_GH`CDWXpsH[fadKCsg@"},
  {0,NULL,"A[P`YEc\\QWH{hBBLE?odCKTpgFWeQ_ICobM_SGpDDcXPvHkfQbJ{sGCAOO`WEW]AY"},
  {0,NULL,"Hogb?K}A_aBKN`@D?_QhKCrwJ@{L?|B{R@}I[obO_[G?uB{OPMG?ia~LIAO]B[NP?"},
  {0,NULL,"Cs_agKKrgGACLO}C?Rp~IWoBP_SG_yC_TPiG_gBd_CFowCcSpjGgfBa_GGOzCgSPk"},
  {0,NULL,"GkfRb_KG?{C[S`mGofre_OF_xCkT@lGcfbc_WGpACsS`oHGkRDLM@_cCKR`PFCcqq"},
  {0,NULL,"KWtwEAWP`KDS[aSJKprT_WHPCC{SpnHWkBGLY@_fCSS@SFKdQsKOtGA@kIOnE{^aC"},
  {0,NULL,"JWrbg_KEOiB?[P~GKlrNMe@?[A_KPoG?`QwL?ygD@sJ?mFK_aEJSsRj_CE_jBG[a@"},
  {0,NULL,"G[mRQM]@oXAwQpLGkeakKWqbL_kE_oCgRqGH[jRFKgrGI@sJpHCoaQWI{pBJKuAO["},
  {0,NULL,"BGQ@OGoeqjKSqRK__EopC[RaIHcjbGKcqwG@cMO~DWW@xICsrfNE@o[BgO@VEC]aa"},
  {0,NULL,"LOyBq_cFOwCCU@aFkgrTMc{wJ@kN?}DgX@|IStrjNUA_YBkNPXEK^AcLWybs_[E_^"},
  {0,NULL,"ESY`nGshbCKczGG@sG`eEs[aMI[pRIMuA_XA?XpkF?bqgK_rBm_cEo`EcYppHCibF"},
  {0,NULL,"Ks{GJ@oF`gEw[qOIcpbJM}@?ZAGI_wDwXQcJA?O[ACJ?{DoXq`JD@WA@sG?jBcUpg"},
  {0,NULL,"IGlCD_SEO^A_Mp\\EchQqO]?oY@wIOyD{XabJL@cG\n"},
 { 84,"LjubljanaGraph",
          ":~?@o_GA?b_mKbWUF`hSRDHCSc`QZBpEMCx?QbhANh@caeAEYGxo_fPyZFx[bdQIU"},
  {0,NULL,"GWgJa?uHBGSJ`_uFBGSG`oiEAX_]eaAXFxiXeIEbggQC`GeIaKWuPZ`DlsUzPJhAm"},
  {0,NULL,"SMcNIW}hRugMYczhriiNyp@isAlNyx@jsApNJG}kBurOjTBlCRKR{xPrTBHSklSqd"},
  {0,NULL,"NTUL\\YtdfEU{`\\ptqAVeEBWEM@VuI@XE]AXeeBXUb\n"},
 { 85,"LoupekineSnark1",
          ":U___gFecGdHcEdFcFdE`GHbILaJKbNaM`RS\n"},
 { 86,"LoupekineSnark2",
          ":U___fEcdcdIeHfGcFdE`GHbILaJKbNaM`RS\n"},
 { 87,"M22Graph",
          ":~?@L_GA?_GA?_GA?_GA?_GA?_GCAB`A@?_sN_OGJBGCB@?m@AOgJ_OKDBgCC@`A@"},
  {0,NULL,"?o[N_OOGBWCDA_u@@_cN_O_HBgCFA`A@@OWK_O[GBGGDA_{SDpo^__[IB`OXEpyA@"},
  {0,NULL,"_cLD@W\\FwGGAP?SE@g]__KCB@gZF@uAAOgKD`[WEWGB@P?TEPk^__OGBpSUFPyA?o"},
  {0,NULL,"[LDP[[FgGC@_wTE@g^__SEAp_XF@uA@o_JD`[YEwsMBp?SDPw^HASiIwkKBO{UDpo"},
  {0,NULL,"\\GQKeIWkKB`?WEPgZGAGfIGSHB?{PD@c\\IAcja?gKC@GSD`kgIQiFAOoMC`OVEaWf"},
  {0,NULL,"IgWIB?sPD@_[Ha[j`O[LC@KSEpodHqeEA?wNCpOYFQSeIGKIBp?REPo]GacjKWOHB"},
  {0,NULL,"p?RD`g^GQ_iKgOHBOwRE@s]GAWjKGKIBOwRDpk^Gq[iJwODB@?QDP_[GQGjLBaB@_"},
  {0,NULL,"oMC`SXFQ?bIrKu`?[KBPCTD`k_GqgsLWKGB?{PDP[YGQGiKr]D@owNCpSVEQGbHB?"},
  {0,NULL,"q`__LC@KTD`__GQOnKWODAowQEps^GqSgKbS{NgKEAp?QE`o^GQSfJr[zNWKGAosP"},
  {0,NULL,"Eps]GAShKRWxNWOFAo{PE`o]GaSeKB_yNgSHAosPDp_^GQOfKBOtMg_IAowQDp_]G"},
  {0,NULL,"aOeJrKuMw[HAp?QD`c]GAOhKbOwNGWIAo{PD`c^GqOgKRKvMWSE@o_PC`OTHASlJb"},
  {0,NULL,"SuLraB@?cICPG]FqgjJQwrLBs}_oSGAPGRDps`IQomKblAPgODA?gPCp_ZGa_kJRC"},
  {0,NULL,"yOCUC@_[IC`KUFAKeJAwnNCDB_oWFAPCREPg_HqolKBc~PN\n"},
 { 88,"MarkstroemGraph",
          ":W___eCDgFdcGdHcEffLhLjKgI`N`MQbPaOaTbSU\n"},
 { 89,"McGeeGraph",
          ":W___fEegfkCHdIcJdJcdO`EJbGPaFObIMaHN`KL\n"},
 { 90,"McLaughlinGraph",
          ":~?CR_A??@_??OA_??OA?M??@_??W??E??@_??W??E??@_??W??E??@?U??@?SBg?"},
  {0,NULL,"?CBW??CBG??CAg??CAw??C@g??C@w??CAG??CAW??CAoR_??OI@I??@?sCG??CB?P"},
  {0,NULL,"_??OH@]??@?_Dg??C@_S_??OF@U??A?gB_P@SD_V@_E_]_??_J?wC?S@WDoX@kFw?"},
  {0,NULL,"?GAOM@?C_R@SEo\\@y??A?_B_P@GCoS@gF?^_??_L?{COR@[EO\\@wFw??GB?N@?C_U"},
  {0,NULL,"@_F?]@}??A?SC?P@ODOW@cF?\\_??_E?{CoT@WEOY@kFG??G@oN@GD?V@_E_Z@u??A"},
  {0,NULL,"?_AoK?sB_T@cF?]Aa??A?cA_K?sB_S@_FO^A]??A?W@oH?kB_P@cE_\\AU??A?W@oG"},
  {0,NULL,"?gB_O@_Eo[AQ??A?W@oK?sB_Q@KD_VAY??A?S@_J?sC_Z@oFO^AA??A?S@oI?oCoY"},
  {0,NULL,"@oFO]AE??A?_AOI?kBoY@kF_^AWJW??G@OE?_B?V@_EOY@{Gg??G@OF?cBOU@_EOZ"},
  {0,NULL,"@wGw??G@OG?gBOR@ODOV@kHOj_??_D?cAoK@GD?T@WE_cAq??A?WA_J?oBoO@SDo\\"},
  {0,NULL,"AKKg??G@oI?kBON@CD?U@oG_p_??_D?WAOI@?COR@WFogAe??A?S@oG?kC?P@GDo]"},
  {0,NULL,"A[Ig??G@_G?cBON@CC_T@_GOn_??_F?_AOK?{C?R@OEO_Ay??B?S@_F?_AOI?kB?L"},
  {0,NULL,"A?GOaAKH?dAWHog_?@?K?wCoS@SDoX@gFOdAoJ_oBGL_vB_MOz_?@?L?wC_S@SD_W"},
  {0,NULL,"@kF?cAkJooBCLOvB_M_z_?@?E?wC?P@GDoW@sFofAcJooBGKosBWM_z_?@?F?wC?P"},
  {0,NULL,"@KD_X@oF_gAgJ_oBCKosBSMOz_?@?D@GCoU@[E_Z@wFoeAcI_jAoLOuBcM_z_?@?J"},
  {0,NULL,"?{COQ@SE_[@sF_`AgJ?lBCK_rB[M_z_?@?I?{C?R@OEo[@sFo_AcIolBCK_sB_MOz"},
  {0,NULL,"_?@?G?{C?T@[E?X@kF_bAgIolAwJosBWLoz_?@?H?{COS@WE?X@gFoaAcJ?lAwJor"},
  {0,NULL,"BSM?z_??oM@_EOY@kF?\\@wFolBKL?tBWLowBcM_z_??oN@?COQ@KD?T@WDohAgIok"},
  {0,NULL,"AwJooBCK_zCU??C?WA_J?oB_U@gF?^AGH?eA_K_rB_MOyCKPg??O@oI?kBOM@[Eo\\"},
  {0,NULL,"@wGodAWHopBOLoxBgP@E_?@?E?_AOL?wCoX@kFo_ASH_gA{L?tBWM@@CY??C?[A?H"},
  {0,NULL,"?oB_Q@_E_]ACH?eA[J_rBSL_vCGPg??OA?H?gAoM@?COS@SH?dA[I?lAwJopBGO@D"},
  {0,NULL,"_?@?D?cAoK@?EO\\@wFo_AKHogAoJOrBWMO|CY??C?SA?I?sCOW@oF_^ACG_fA_Iol"},
  {0,NULL,"BOLOyBoPg??O@OE?cA_T@_E_Z@sGObAOHOhAsL_wBgNpE_?@?D?[A?J@OEOY@kF?_"},
  {0,NULL,"AGH?dAgJOtB[MO}CY??C?W@oK?sBoW@cF?\\A?GOaAKK?rBOLowC?P`J_?@?H?gB?L"},
  {0,NULL,"?{CoT@WF_`AKH_gAkJ?mBCM?}CSRw??OA?J?oBON@GD?V@{G?aAWHojAoJoqB[NpD"},
  {0,NULL,"Cy??C?S@_J?sCOT@WDoXAGGodA_I_kA{K?yCGPPI_?@?D?[A_K@?D?U@[E?aAKH?f"},
  {0,NULL,"AcIomB?MP@CSQW??O@OE?_B?O@GCoT@oG?`AOI?iAkK?qBWP@DCa??C?S@oH?sCOQ"},
  {0,NULL,"@KD?\\A?GOdA[IOkB?KOtCKPPF_?@?E?[AOJ?{C?Q@WEo_AKH?eAcI_nBCKo{CSRW?"},
  {0,NULL,"?O@_F?_A_N@CCoV@gGOaASH_hAgJ_qBONPDCq??B?cAoL?wCOQ@WF_^AWHogAoJop"},
  {0,NULL,"BKLOyBoO`BCwRpODOTPW_??oG?gB?M@?CoV@wFoeA[I?jAwK_sBWMO|CCP@MC{S@R"},
  {0,NULL,"DWTw??K@_I?sB_P@KDO[@sGOdA_K?pBGL?wBgO@BCOQ`KC{S`SD]??B?[AoK?wC?Q"},
  {0,NULL,"@OF?\\A?H?fB?KOqBKLoxC?OpCCcRPMDCSpW_??oE?_AoM@GDOV@gEocASH_iA{K_u"},
  {0,NULL,"B[M_~CGP@KCsS@PDOTg??K@oH?gB_R@OD_Y@kH?dAWIOmBCLOwBcN`@CKR@LD?S`R"},
  {0,NULL,"DU??B?WAOK?wC?T@WE?XAKH?gAwJooBKL_wC?OPAC_RPNDGT`W_??oF?_BOM@CD?V"},
  {0,NULL,"@_EOaASHomA{K?sBSLp?CCO`FCoR`PDSTw??K@OK?sC_T@[E?\\@wGObA[IokB?L_v"},
  {0,NULL,"BgNpACOPpHCkRpVD_Vg??K@OK?sCoS@WEO[@{G?aA_IokB?LOwBcN`@CKQ@ICkR`V"},
  {0,NULL,"D_VW??K@OI?kC?T@WEo[@wGocA_I_jAsKOxBgN?}COQPID?S`UD_WG??K@OI?kCOS"},
  {0,NULL,"@[E_\\@{G_dA[IOkAsK_xBgNO~CKQPID?SPTD[Vw??K@_I?sBoU@[E?Z@{G_bAWIOj"},
  {0,NULL,"A{L?wBgN?~CCQ`JCoRpTDWVG??K@oJ?oBoU@[EOY@wG_bAWI_kAwKovBcNO}CGQPJ"},
  {0,NULL,"CsR`TDWUw??KAOJ?sBoS@SEOZ@sG?bASJ?lA{KOvB_N_~C?PpICsT@TD_Ug??KA?I"},
  {0,NULL,"?oBoS@SE?Y@oGOaAOIolAwK_vB_N_~C?Q@HCoSpUD[UW??K@_H?oBoQ@KE_\\@{G?`"},
  {0,NULL,"AWIOkBGKouB_NO~CKQ@JCsRpRDOW@b_??oF?_BON@GCoZ@oF__ACH_iAkKOsBSLo{"},
  {0,NULL,"BwP@FCkR@MDKT@^EQ??B?SA?H@CCoT@cE_]ACHOgAgJ?lAwLOuBsN`AC[Q@ODGT@V"},
  {0,NULL,"DoXW??K@OG?cC?Q@OE?Z@{G?cA[IOjAsJotBWN?~CCPpGD?SPRD_Upe_??oD?W@oO"},
  {0,NULL,"@KDoX@kFO_AKHOhAgK?sBWMO|CCP@FCgQpLDCS`XEa??B?S@_F@CC_U@_E_[ACG_c"},
  {0,NULL,"AcI_oBKLOyBoO`BC_QPJCoSPQDgXw??K@_G?kBoO@CEO[@{G?aA_I_lA{K_rBON?|"},
  {0,NULL,"C?Q@ICwSPSDWV``_??oF?cA_N@?COW@sF_`AKHohAsJ_pBKL?{BsO@FCcRpQDKTP\\"},
  {0,NULL,"EI?OA?gAoM@ODOY@kF?\\AOHOlBCK_vB_MOyBkN_~C?OpCCWQPICoRPODCS`RDOTPU"},
  {0,NULL,"D[U@XDgVp_ECW`dEWYPiEkZ@lEwZpo_C?_E?oB_O@KEO[@sFo_A_K?qBKL?uB_MOz"},
  {0,NULL,"BsO@@CKP@EC_Q`JCsR`NDCS`RDOT`VD_UP\\DwW@`EKX@dEWXpgEgYpkEw[G@?G@oL"},
  {0,NULL,"?wCOQ@_F?\\@wGOfB?KOrBOLOvBgMo{C?O`BCOP`FCcQpKCwRpPDGSpSDSTpWDgVP]"},
  {0,NULL,"D{W`bEOXPeE[Y@hEkZ@lE}?OA?WAOM@GD_W@gEo^AOH_hA{KotBWM?yBkN?~CCO`B"},
  {0,NULL,"CWQ@JCoRPND?SPQDKT@TDWU@YDkV@_ECW`bEOX`fE_Y`jEsZpo_C?_F?_B_R@[EOY"},
  {0,NULL,"@kF_dAWI_mBOLOuB[MOzBsN`@CGP@EC[QpKCsR`ODCS`RDOTPUD[UPZDoVp`EGWpc"},
  {0,NULL,"ESXpgEcZ@mE{[G@?GAOL?wCOR@ODOU@cHOgAoJ_nB?KOtB_Mo}C?OPACKPPFC_Q`K"},
  {0,NULL,"CsR`ND?S`SDSTpWDgV@\\ECWpcESX`gEcY`kEsZ`nFA?OA?_B?M@?C_S@SDoWAOHoj"},
  {0,NULL,"AwJooBGL_vBkNp?CCO`CCSPpGCcR@LCwRpODCSpUD[U@XDkV`aEKX@dEWXphEgYpl"},
  {0,NULL,"EwZpo_C?_D?gC?V@_Eo\\@wFobA[IOjAsL?uBcM_zBoNO~CCP@EC[QPICkRpODCS`R"},
  {0,NULL,"DST`VD_UPZDoVP]D{W@aEWXpgEcY`jEwZpu_C?_D?kCOU@cE_[@wFoaA_I_kAsKot"},
  {0,NULL,"BcM_zBoNO}CGOpEC_QPICkR`ODCS`SDST`VD_U`ZDoVP]D{W@`ESXpgEcY`kEs[@v"},
  {0,NULL,"_C?_H?oBoT@_EOY@sF_`AKJ?lAwKouB[M?zBsN_~C?O`EC[Q@HCkRPNDGSpSDST`V"},
  {0,NULL,"D_UPYDkV@\\DwW@aEKX@dEgZ@lEwZw@?GA?L?{D?W@cEo[@{G?aAkJOnBOLOvB_Mo{"},
  {0,NULL,"BwNp?CCP`FC_Q`JCoR`PDKT@TDWTpWDcU`ZDoVP]D{WPbEOX`hEkZPmFA?OA?kBON"},
  {0,NULL,"@GDOU@[Eo]AKH_iAkJ?nBCLoyBkN?}B{O`CCSPpHCgQpKCsR`ND?T@TDWU@YDkV@]"},
  {0,NULL,"D{W@aEOY@hEkZ@lEwZpoFI?OA?gB?N@KD?U@[E_^AGH_hAkJ?mBGM?xBkNO}B{OPB"},
  {0,NULL,"CSQ@HCgQpKCsR`ND?SpTDWTpXDkV@\\D{W@`EKXpiEkZ@lEwZpoFM?OA?S@_P@GCoT"},
  {0,NULL,"@[E_\\ACHOhAgJ?oBGL_yBkNO~CGOpCCSPpGCcQ`JCoRPND?SPQDOTpXDgV@]D{W@a"},
  {0,NULL,"EKXPeE[Y@iEoZpoFm?OA?S@oO@GCoS@WEo[A?H?hAgIooBCLOxBkN?}CCOpCCSPpG"},
  {0,NULL,"CcQ`JCoRPMD?SPQDKU@XDgUp\\D{W@`EOXPeE[Y@hEkZpoFi?OA?_A_N@?COR@SF?]"},
  {0,NULL,"ACI?iAkJOmBCK_sBkN?|BwO@CCSPpGCcQ`KCwRpODGSpSDWTpXDoVP]D{W@`EGX@d"},
  {0,NULL,"EWXphEoZPmFQ?OA?cAoN@?COQ@OFO^A?HohAoJOnBCK_rBkN?|B{O@BCSPpGCcQ`L"},
  {0,NULL,"CwRpODCSpSDSU@YDkVP]D{W@`EGWpdEWY@iEkZPmFU?OA?W@oN@?COU@[E?XAGGoh"},
  {0,NULL,"AgJ_nB?KosBkN?|C?OPACSPpGCcQ`JCoRPMC{SPQDST`XDgUp[DsV``EGWpcE[Y@h"},
  {0,NULL,"EgYpkFE?OA?WA?I?kBOM@CDo^AGHOeA[I?nBGL?yBoNO~C?OPACKP@DCWQ`KCwRpO"},
  {0,NULL,"DCT@TDWTp[DwVp`EGWpeE[Y@hEgYpkEsZ`oFg^w@?G@oH?gAoK?wC?U@wGocAWHog"},
  {0,NULL,"AwKOrBcN?|BwO@@CGOpCCSP`HCsR`ND?S`RDST`WDkVP_ECW`cESXpgEcY`jEoZPm"},
  {0,NULL,"E{]p}_C?_D?WA_K?sDOU@_F?`AGGocA_IooB_M_{BwNp?CCO`BCOPPEC_QPICkR@N"},
  {0,NULL,"DGT`VD_UPYDoVP]E?X@eE[YPiEkZ@lE{[@tGE?OA?S@oJ?oBOS@[EO\\A?G_bASHok"},
  {0,NULL,"B?LoxBsN_~C?OPACKP@DCWPpHCgQpLCwSPTD[U@XDgUp\\DwVpbESY@hEgYpkEwZpo"},
  {0,NULL,"FO_G@?G@OG?cB?L@GCo]@{G?`AWHogAkJ?tBWN?|BwNp@CGOpCCSP`FC_QpMC{S@R"},
  {0,NULL,"DOTpWDkV@\\DwVp_EKX@dEWXpgEsZ`nF?[QA_C?_E?[AOI?sBoR@kFO_ACGodAWIOp"},
  {0,NULL,"BOM?{BsN_~C?OPBCOPPEC[Q`JCoRPNDGSpSDSUPYDoVP^E?WPaEKX@eE_YpkEwZpv"},
  {0,NULL,"Fe?OA?W@oG?kB?N@GE_[A?GOaAOH_iBGKovBoNO}B{O@ACKP@DCWQ@HCkR@LCwSPR"},
  {0,NULL,"DOT`XDgUp]D{W@`EGWpcESXpjEoZPoFW]G@?G@OE?_AOJ@?DOX@kG?bAOHOgAgJOn"},
  {0,NULL,"BWN?|BwNp?CCO`CCSP`FC_Q`LD?SPQDOT`WDcU`ZDoV`_ECW`cESX`gEcY`mF?[p|"},
  {0,NULL,"_C?_D?[A?H?gCOS@_E_`AGH?dA[IOlAwLO{BsN_~C?OPACKPPEC[Q@HCoS@PDGSpT"},
  {0,NULL,"D[UPYDkV@\\D{WPaEKXPeE[YPiEsZpqFq?OC?oBOM@WDoW@cF_^AGGoeA[I?jAoJ_n"},
  {0,NULL,"B?KosBSL_vB_MOyBkOPACWQpMC{TPUD[U@ZDoVP]EKX@fE_YPiEkZ@lEwZpoFC^`~"},
  {0,NULL,"G?_QGGcaaJ_C@?H?gB_P@KE_\\@wFo`ASH_fA_IOkAsJ_pBGKosBSL_wBcM_zBsOpE"},
  {0,NULL,"C{S@QDKT@TD[V@\\D{W@`EGWpdEWXpgEgZ@lEwZpvFk^@~GG`QEGcag@?OA?J?wC?Q"},
  {0,NULL,"@kF?]@{G?cAWHogAgIolA{KOqBKL?tBWLoxBgMo{COP`MD?SPRDOT`WDkV`^E?WPa"},
  {0,NULL,"EOXPeE[Y@hEkZPmF?\\`yFs^aAGS`aGGm?OC?WA?M@CDOW@cE_[ACG_cASI?iAsJ_n"},
  {0,NULL,"B?K_rBOLOuB[M?yBkO@ACWQ@KDCS`SDWTpXDgV@]ECW`bEOXPeE[YPiEoZPoF_^@|"},
  {0,NULL,"F{_QCGW`qG_C@?F?cB_O@OE?X@kFO_AKH?dA[IOlAwJooBCKosBSL_vB_MOzC?OPE"},
  {0,NULL,"C[RPPDGSpTD_UPYDkVP`EGWpcESX`gEcY`jEwZpxFo^P}G?_qDG[aW@?O@_I?wC?R"},
  {0,NULL,"@SD_V@kGocASH_gAcI_jAwJooBCK_sBWM?xBgMp@COPPICoRPND?S`UDcV@_ECW`c"},
  {0,NULL,"EWXpgEcY`jEoZ`nF?[pxFg]q@GW`qHGm?OC?[AoM@CC_S@WDoYAGH?dAWHohAgJ?m"},
  {0,NULL,"A{K?pBGKotB[MOyBkO`BCSQPKCsR`ODCTPYDkVp`EGWpdE[Y@hEgYpkEsZpoFG]@y"},
  {0,NULL,"Fk_ADG[aAI_C@?D?sCoT@cEo[@sF__ACGodA_I_jAoJOoBCL?tBWLowBcM_zBwP@E"},
  {0,NULL,"C[Q`JDGT@VD_UPYDoVP]D{W@cESX`gEcZ@mE{[@sF[^Q@GG_qCGcaqQ_C@?D?oC_S"},
  {0,NULL,"@_E_[@sFo_ACG_cA[IOjAoJOoBGKotBWLowBcM_zB{OpEC_QPJDCSpVD_UPYDkVP]"},
  {0,NULL,"D{W@bESX`fEgYplE{[@tFW^A?GG_qCG_aaP_C@?E?kBoV@cE_Z@sFo_AGGodAWIOi"},
  {0,NULL,"AoJOnBGKosBWLowBcM_zBsNpECgQpLDCT@TDWUPYDkV@]D{W@`EGWpgEgYpkEw[@r"},
  {0,NULL,"FW\\p~G?`ADG[aw@?O@oI?{D_W@gEo[@wGOaAKH?eAcI_jAsJ_pBKL?tB[M?xBgMo{"},
  {0,NULL,"BwP`HCkR@QDKTPUDcU`ZDoVP^E?WPaEOXphEkZ@lE{[`uF[^a@GK`aFGi?OC?gBON"},
  {0,NULL,"@CD?T@[E?\\ACG_bASHohAkJ?lAwJooBCK_sB[M?yBkNp?CSPpHCgR@NDSTpXDgV@\\"},
  {0,NULL,"DwVpaEKX`hEgYpkEsZ`nFG\\@tFc^qCG[aQIGy?OC?kB?N@?D?T@WEO[A?G_bAOI?i"},
  {0,NULL,"AkJ?lAwJooBCK_rB[M?xBkN`?CSQ@HCgRPMDWU@XDgUp\\DwW@`EOXPhEgYpkEsZ`o"},
  {0,NULL,"FK\\@tF_^aBG[aAJGu?OC?WBON@CC_R@WF?^A?GOaAWI?hAgIokA{K?pBGKosBSM?y"},
  {0,NULL,"BkN@BCSQ@ICkR@MC{T@YDoVP]D{W@`EKX@eE[Y@jEoZPoFC\\PvF_]aCGWaaJHA?OC"},
  {0,NULL,"?[B?N@?C_R@[FO]A?GObAWHohAgIokAwK?pBGKosBWLoxBkNPCCSPpHCkRPMC{SpX"},
  {0,NULL,"DkVP]D{W@aEKX@dE[Y@jEoZ`nFC\\@uFc]qBGSaaJG}?OC?SAOO@CC_T@WE?]ACGoc"},
  {0,NULL,"A[I?hAgIokAsJ_nB?KOrBSL_yBkN@ACSPpGCcRpODGU@YDkV@\\DwW@aEOXPeE[Y@h"},
  {0,NULL,"EgZPnFC[`tFk^QBGWaAHHU?OC?SA?O@CCoS@[EO^A?G_dA[I?hAgIokAsJ_nB?K_s"},
  {0,NULL,"BSL_xBkNP@CSPpGCgR`ODCTpXDkV@\\DwVp`EKXPeE[Y@hEgZ`oFC[psFg^ACGSaAH"},
  {0,NULL,"HY?OC?_AON@GCoS@SE_ZA?GOcASH_hAgIokAsJ_nBCK_tBWLowBkN_~CSPpGCoRPO"},
  {0,NULL,"DKT@XDgUp[D{W@`EGWpcESX`lEwZpoFG[pwFc_aBGO`QEGq?OB?sB_Q@KD?V@kFO^"},
  {0,NULL,"A?HOeA[IOjAoJooBCK_sBSL_vB_MOyBkNp@CKP@FCgQpKCsR`ND?SPRDOTPVD_Vpb"},
  {0,NULL,"EWY@jEwZpoFc]a?GG`ADGcaaJG{daWHm?OB?oB_Q@KDOU@gF?]ACH?eA_I_jAoJ_o"},
  {0,NULL,"BCK_rBSL_vB_MOyBkN`ACKP@GCcQpKCsR`ND?S`RDOT`VD_W@cESXpkEsZpoF_]q@"},
  {0,NULL,"GG_qEG_aaJH?dQVHq?OB?kB_O@CDOV@cFO]AKHOfA_I_kAsJ_nB?KOqBKL?uB[MOy"},
  {0,NULL,"BkNP?CGP@FCcQ`LCwRpODCS`SDST`VD_V`aESY@hEgZ@mFO]p|F{`QFG_aQJHOdaX"},
  {0,NULL,"Hu?OB?gB_O@CD?U@_F?^AGH?fA_IOjAsJ_nB?KOqBKL?tB_MOyBkN@?CCOpGCcQ`K"},
  {0,NULL,"CwRpODCS`RDST`VD_VP`EWXphEgYplFS]`{Fw`aFG_aQIHKdQYHu?OB?SD?T@WDoW"},
  {0,NULL,"@cE_ZAGGocASIOiAkJ?lAwJooBSL_vB_MOyBkN_~CCO`FC_QPICkR@LD?SPQDST`V"},
  {0,NULL,"D_UPYDkV@hEgZpoFG[q?GC_qCG[aAHGsbaXHi?OB?cBoO@KD_X@kF_^A?GoeA_IOi"},
  {0,NULL,"AkJ?lAwJopBKL?tBWM?xBkN?|BwOPFC_Q`JCsR`ND?S`RDOTPUD_Up[DsW@`EOY@m"},
  {0,NULL,"FC[pvFw_qDGWaQJG{caSH]?OB?_BoP@GDoW@gF_^ACG_eA[IOiAkJ?lAwJoqBKL?t"},
  {0,NULL,"BWLoyBkN?|B{O`FC_QPJCoR`ND?SPRDOTPUD[Up[DwVpaEKXplFC[`uF{`ADGWaAI"},
  {0,NULL,"H?cQRHa?OB?WBoO@GDOW@kF?\\A?GObAOIOiAkJOnB?KOqBKL?uB[M?yBkN?~C?P@F"},
  {0,NULL,"C_QPICkR@LC{SPQDKT@UD_UPYDwW@aEOX`jFS\\`xFs_qCGW`qJGobQQHq?OB?[BoP"},
  {0,NULL,"@KD?X@gF?\\A?GOaASIOiAoJOmB?KOqBKL?tB[M?xBkNO}C?OpFC_QPICkR@LCwSPQ"},
  {0,NULL,"DKT@TD[UPYDsVp`EKXPkFO\\pwFo_qCGS`qIGobaPHm?OC?WAOJ?oBOM@GDO\\A?GOb"},
  {0,NULL,"AOHOeA[I?kA{K?pBGKouB[M?yB{O@ACKP@DCWRPNDOU@YDwW@aEKX@dEWY@iEkZ@l"},
  {0,NULL,"EwZpoFS]@xFk^P~G?_aJHWfA`IGgqcIY?OC?[A?I?oBOM@KD?[A?GOaAOHOeA[I?j"},
  {0,NULL,"AwK?pBGL?tB[M?xBwO@@CKP@DCWR@MDKTpXDsVp`EKX@dEWXphEkZ@lEwZpoFO]@x"},
  {0,NULL,"Fg^@}GC_aIHSeq_IGgqcIU?OC?SA?I?kB?T@[E_]ACG_bAOHOeA[I?iAkJ?lAwK_u"},
  {0,NULL,"B[MOyBsN_~CGP@DCWQPODWTpXDkV@]D{W@aESXphEgZ@lEwZpoFG[psFW]p~GC_aG"},
  {0,NULL,"H?eQ]ICgqdIY?OC?SAOI?kBOS@WEo^A?G_bAOHOeA[I?hAkJ?lA{KOtB_MOyBoN_~"},
  {0,NULL,"CCOpDCWQ`ODSU@YDkV@\\D{W@`EWY@hEgYplEwZpoFG[ptF[]`}G?_aHG{ea^I?hAd"},
  {0,NULL,"IY?OC?S@_F?gAoO@CF?\\A?GOaAKH?dA[I?hAgJOoBCK_rBOMOyBoNP?CKP@DCWQPI"},
  {0,NULL,"DCS`XDgVP]D{W@`EGXPeE[Y@hEgYpkFO\\PuF[]`zFo^QFGofQ]H{gabIQ?OC?S@_F"},
  {0,NULL,"?_BOQ@[E?ZA?GOaAKH?dAWHohAgIonB?L?tBWLoyBoNp@CGP@DCWPpJCoSPXDgUp["},
  {0,NULL,"DwVpaEKX@eE[Y@hEkZpoFC[`uFc]`|G?_QCGseA^I?gQbIY?OC?S@_F?cB?R@WEOY"},
  {0,NULL,"A?GOaAKH?dAWI?hAgJ?mB?KotBWM?xBsN`@CGOpDCWQ@JCsS`XDgUp[DsW@`EKX@d"},
  {0,NULL,"E[Y@iEoZpoFC[pvF_]p{G?_QBGwdq]I?gQcIU?OC?WA?H?gB?N@?E?^A?GOaAKH?e"},
  {0,NULL,"A[I?hAkJOmA{K_rBOL_wBoNO~C?OPDCWQ@NDKT`XDkV@\\DwW@`EGWpcEWXpiEkZPm"},
  {0,NULL,"FC[ptFW]P{Fw^qEHGcq]H{gAaIY?OC?[A?H?kBON@CEO]A?GOaAKHOeA[I?iAoJOm"},
  {0,NULL,"A{KOrBOLOvBoNO}C?O`DCWPpMDOTPYDkV@\\DwVp`EGWpcESY@hEoZPmFC[`sF[]@|"},
  {0,NULL,"Fw^qDHCdA]H{gQaIU?OB?_AOI?sB_T@_Eo]ACGocASH_fA_IolAwJopBOLOuB[M?y"},
  {0,NULL,"BoN_~C?OPACOP`FCoRpODGSpSDST`VD_V@aEOX`hEsZ`nFG]P|Fw^q@GG`aHHGdAT"},
  {0,NULL,"H_eQYHohajIu?OB?_AOJ?oB_S@cE_^A?G_cASH_fA_J?lAwJoqBKLOuB[M?xBsN_~"},
  {0,NULL,"C?OPACKP`GCsR`ODCSpSDST`VD_Up`EKXPiEsZ`oFK]@{Fw^q?GG`QGHCcqUH[eQY"},
  {0,NULL,"HkhQjIq?OB?W@oJ?sB_U@cEo[A?G_bAOHOeA_I_nB?KOrBOLOvB_MOyBoN`?CCO`B"},
  {0,NULL,"COP`ICkR@LCwSPQDOTPUD_U``EOY@hEkZ@oF[]@yFs^a?GC`qJGsdAVHgeq[HshAh"},
  {0,NULL,"Iy?OB?W@oI?oB_V@_E_\\ACG_bAOHOeA[IOmB?K_rBOL_vB_MOyBsNp?CCO`BCOP`H"},
  {0,NULL,"CkR@LC{SPQDKTPUD[UPaEKXpiEkZ@nFW]PzFo^q?GC`qIGwcqWHceq[HsgqiI}?OB"},
  {0,NULL,"?W@oG?cB_O@CC_RA?GOcASH_fA_IOiAwJooBCK_rBOLOuBoNP?CCO`BCOPPFC_R@L"},
  {0,NULL,"CwRpODCS`RDOWPaEKX@dEWXpgFC]@xFg]p{Fs`QEGocqSHSdaVH_gahIi?OB?gAoK"},
  {0,NULL,"?sBo[@sF_^A?GOaAKH_fA_IokAsKOqBKL?vB_MOyBoNO}B{O@BCOP`HCgQpMC{SpS"},
  {0,NULL,"DST`VD_VP]D{W@jEoZPmFO\\PuF[^`~GGaaJG{cAPHGeq[HsgakIslG@?K@OE?_A_R"},
  {0,NULL,"@gEo[@{G?`AGH?dAWI?hAgIolBGL?tBWM?xBgN?|BwNp@CKP@EC_Q`JCoS@PDGSpS"},
  {0,NULL,"DWTpXDoVp_ECX`fF?[puF[]`{GC_aCGWbAOHGdqWHgeq_I[jw@?K@OF?cAoQ@gEo\\"},
  {0,NULL,"@wG?`AKH?dAWHohAgJ?lBCKotBWLoxBgN?|BwNpACKP@EC[QPJCsS@PDGSpSDSU@Y"},
  {0,NULL,"DkVp_EGXPgE{[`uF[]p|G?_aBGSbANHCdqWHcfA`I_jg@?K@OE?cBOP@_EO\\@{G?`"},
  {0,NULL,"AGGodA[I?hAoJOnB?KosBSL_wBgN?|B{O@@CGOpEC[Q@ICkRpPDGT@TD[U@YDoVP]"},
  {0,NULL,"EKX`gEg[PtF[^@|F{_ACGcbaPHGdaWHgfQ^I_iW@?K@OF?_B?O@_EO[@wG?`AGGoc"},
  {0,NULL,"A[I?iAkJOmB?KosBSL_vBcN?|BwO@@CGP@EC[Q@HCkR`PDGSpUD[U@XDkVP]EOXPf"},
  {0,NULL,"Ec[PsFW^@|Fw_QBG_bQPHGdQVHcfQ]I[ig@?K@OE?kB?O@GD_V@{G?aAKH?eA[I?h"},
  {0,NULL,"AgIokA{K?qBKL_xBgN?|B{OPACKP@DC_QPICkRPMC{S@PDWU@ZDwW@fE_Y`jF?[Pr"},
  {0,NULL,"FS\\`yFk_AGGkbQNH?cqUH[fQeI_jqo_C?oD?[A_L@CCoU@[F_`AGGodAWHogAcI_j"},
  {0,NULL,"AoJ_oBCL?tBcM_{BsN`@CGOpCCSPpHCgQpKCwRpODGTPVDoVP^E[Y@hEoZppFG\\@v"},
  {0,NULL,"Fg]q@GcaaMG{cASHSeA\\IShqmJE?OB?SAOI?oC?R@ODO\\A?GObAOHOfA_IOjAoJOm"},
  {0,NULL,"B?KOqBWM?xBsN_~C?OPBCOPPFC_QPICsRpODGSpVD_UP\\E?XPeEgZ`nFK\\@tFc]p{"},
  {0,NULL,"GG_qHGobaNHGdQUHchAkI{kg@?K@OG?kBOP@GD?T@oG?`AGH?dA[I?iAkJ?lA{K?p"},
  {0,NULL,"BGLOvBgN?}B{O@ACKP@DC[Q@HCgR@MD?SPSD[U@YDwVpdEWYPlF?[`sFS]@yFs_aC"},
  {0,NULL,"G_bALH?cQTHWeabIsjar_C?oE?_B?L?{CoT@[EO_ACG_bASH_gAgIokAwJooBGL?u"},
  {0,NULL,"B[M?|BwNp?CCO`CCSPpGCgQpKCsR`NDOT`VDcV@]EKX@kEw[@pFK\\@wFc^q@GOaqL"},
  {0,NULL,"GwcAQHOdaZICiajJ]?OB?[AOK?sBoQ@OD_WA?GOaAKH?eA[IOjAoJ_nB?KOrBSLow"},
  {0,NULL,"BoN_~C?OPACKPPFC_QPJCoRPMC{SpTD_U`ZDsWpcEkZPnFC[`tF_]P}G?_qIGsbaN"},
  {0,NULL,"HCcqTHogAhIklg@?K@_H?gAoN@CDOU@gGOaAKH?dAWI?hAgJ?lAwJopBGKowBgN?|"},
  {0,NULL,"BwNp?CGOpDC_QPICoRPND?S`SDST`YDoW@`EGY`kEs[`rFS\\pwFk^qEG[bAMH?cqS"},
  {0,NULL,"HgfA]I_jAx_C?oF?_A_J?{C?S@[Eo_AGGocASH_fAcI_jAsJ_nBCK_sB[MO{BsN_~"},
  {0,NULL,"C?OPCCSPpHCgR@LCwS@PDKTPUDcUp^ECW`hEkZ`qFK\\@uFc]`}GS`qKGsbqRHOeQZ"},
  {0,NULL,"H{hqlJa?_C?WA?I?oBOM?{C_R@SDoW@gEo[@sF_^ACH_jBGL?uB[M?yBkNpCCWQpK"},
  {0,NULL,"C{SpSDWTpXDoV`^E?W`bEOX`fEkZ@lEwZpoFW]P~GC_aCGWaaJH?caWHkfA_ICgab"},
  {0,NULL,"IWiajIsjqpJGlAvJ_mQyJknA|J{oB@_G@?F?cAoK?sB_N@GCoS@WEOY@kF?\\@wFo_"},
  {0,NULL,"AWJ?pBKLOvB_MOzBwOpECkRPMDKT@TD_U`ZDsVp_ECWpcESY@jEoZPmE{[@vF_^a?"},
  {0,NULL,"GG_qDGgaqNHCdqZHogA`IGhAdIciqkIwkArJOlawJcmazJonQ}K?oWA?O@OG?cAoL"},
  {0,NULL,"?wCOQ@ODOV@_EOY@kFO]@{HOfAoJOnBSL_vBgMo~CGP`FD?SPSDSTpWDgUp[DwVpa"},
  {0,NULL,"EKXPeE_YPiEsZ`nF?[`|F{_AAGO`QGGccQUH_eQYH{gQbIShagIkjQmJGkqsJSlax"},
  {0,NULL,"Jgmq{Jwnr?KE?_C?SA?H?gB?M@?CoS@SD_W@cE_Z@oF_^AOI?jAsJ_tBWM?xBkN`@"},
  {0,NULL,"CWQ@ODGSpUD[U@XDkV@\\E?WPcESX`fEcY`lEwZpoFK^@}GC_aBGWaAHHGdQVHcea]"},
  {0,NULL,"I?hAdIWhqjIojqqJKlAtJ[mAyJknQ}J{oB@_G@?D?W@oJ?oB_O@GDOU@[E?X@gEo["},
  {0,NULL,"@sF_bAOI_oBKL_vBcM_zCGP@ECcQpLDCS`UD_UPYDkV`_EGX@dE[Y@hEgYpkE{[@u"},
  {0,NULL,"Fk^Q?GC_qFG_aqLH[eQ[Hsfa`IKhAeI_iamI{kApJOlQuJ_mq{Jsna~K?oWA?O@OE"},
  {0,NULL,"?[A_L?wCOR@OD_V@_EOY@kF?\\@{G_dAcK?sBSM?xBgMp@CKP`ICkR@PDGTPVDcU`["},
  {0,NULL,"DsVp`EKX`fE_YPiEkZ@nF?\\pyFo_A@GO`qHGgbaWHgeq\\H{gAbIOhQfIcjanJ?kQs"},
  {0,NULL,"JSlqxJgnA|Jwnr?KE?_C?WAOI?kBOM?{C?P@SD_W@cEo[@sF_^AKI?lA{KOrBOM?y"},
  {0,NULL,"BkN@?CWQ`NDGT@TDWU@YDoVP]E?WPaEOX`gEcY`jEoZPmFS\\p|Fw^qEG[aQJHGdAY"},
  {0,NULL,"HofQ]H{gacIWiAhIojQpJKlAuJ[mQyJknA|Jwnr@_G@?F?_A_J?oB_N@?COS@[E?X"},
  {0,NULL,"@gF?\\@wFoaA[JOmBGKosB[MOzBsO@ECcR`PDKTPUD[UPZDsV`^ECW`bESXphEgYpk"},
  {0,NULL,"EsZ`sFW^@}F{`QFG_aaPHKeQZHsfa^IGgqdI[iakIskAqJOlavJ_mazJonQ}J{oGA"},
  {0,NULL,"?O@OI?kB?L?wC?P@GCoS@SD_V@oFO]@{HogAkJ?oBCK_xBgMpBCOPPHCgR`ND?TpW"},
  {0,NULL,"DsV`^E?XPeE[Y@hEgYpkEsZ`nF?\\@tFg]qAG_aQIGkbqOHSda\\IGgqcIShakIsjan"},
  {0,NULL,"J?kQqJKlAuJ[mAxJwnr?KE?_C?WA?H?kB?M?{C?P@GCoT@WDoX@gF_^AWI?iAoJ_n"},
  {0,NULL,"BGKouBkNPACSQ@LCwRpODOT`ZDoV`_ECW`bEOXPfE_Y`kEsZ`oFC[pwFk^qDGWaAJ"},
  {0,NULL,"H?cqSHWdq]ICgadIWiAiIkjAoJGkqtJWlqwJcmq{Jsnr@K]?_C?[A?H?gBOM?{C?P"},
  {0,NULL,"@GCoS@WDoW@kF_^AWHohAkJ_nBCL?tBkN@@CSPpKCwRpODKTPZDoVP^ECW`bEOX`f"},
  {0,NULL,"E_YPjEsZ`nFC[`xFg^aDGWaQIG{cqSHSeA^I?gadIWhqhIkjQpJGkqtJWlqwJcma{"},
  {0,NULL,"Jsnb?KY?_C?W@oG?kBOM?{C?P@GCoS@SDoX@kF?\\A?HOiA{K?pBGL?vBkO@CCSPpI"},
  {0,NULL,"CoRPMDCT@XDgV`^ECW`bEOXPeE_YPjEoZ`oFO]@xFg^QCGS`qJGobQSHWeq^ICgab"},
  {0,NULL,"IOiQiIsjaoJCkqtJWlqwJcmazJonr?KU?_C?W@oH?gB?M?{C?P@GCoS@SD_W@gF?\\"},
  {0,NULL,"ACH?hAwK?pBGKowBkO@BCSQ@HCoRPNDGSpXDgVP_ECW`bEOXPeE[Y`jEoZPnFS]@x"},
  {0,NULL,"Fk^ABGW`qIGobaRHSfA]I?gabIOiQiIojqoJCkatJWlqwJcmazJsnb@KQ?_C?S@_F"},
  {0,NULL,"?_AON@?COQ@KE?X@gEo[@sF_^A?GOhAgJOrBOLOuBkN?|CWPpGCkSPQDKT@XDgUp["},
  {0,NULL,"DsV`^E?WPaEKX@dEWXpgFC\\`vFo^QBGO`QEGocQQH[eA]H{gA`IGhqgIciaoJCkar"},
  {0,NULL,"JSmazJonQ}J{oB@Ki?_C?S@_H?oBON@?C_R@ODOU@[E?X@kFO^A?GohAkJ?nB?L_w"},
  {0,NULL,"BkNp@CSPpGCgQpLC{U@XDgUp[DsV`_EKX@eE_Y`jEwZpoFC[ptFc_ABGOaQJGsbaN"},
  {0,NULL,"HGda^I?gQcIWiAhIkjqoJCkarJOlQuJ[mQzJsoB@Ke?_C?S@oG?oBON@CC_R@ODOU"},
  {0,NULL,"@[E?X@gF?]ACG_iAkJ?mB?LOvBkN`ACSPpGCcQpKCwTpXDgUp[DsV`^EKX@dE[YPk"},
  {0,NULL,"EsZpoFC[`sF__QBGOaAIGsbaOHCdQ]I?gQbIShqiIkjaoJCkarJOlQuJ[mAyJooB@"},
  {0,NULL,"Ka?_C?S@_G?gAoN@?COQ@ODOU@[E?Y@kF?^AGH?hAgIolA{K_yBkN?~CSQ@HCgR@O"},
  {0,NULL,"DCT`XDgUp[DwVp_ECW`eE[YPiEkZPoFG[ptFW]aCGW`qGGobQOHKea]H{gAbIWhqg"},
  {0,NULL,"IsjqoJCkarJOlQvJ_mQzJona~KM?_C?S@oH?gAoN@?COR@ODOU@[EOY@kFO]AKHOh"},
  {0,NULL,"AgJ?lAwKOxBkNO}CSPpHCgRPODGTPXDgUp[DsVp_ECW`dE_YPiEoZ`nFG[psF[]qB"},
  {0,NULL,"GS`qHGobaNHOeQ]H{gQcIShqgIojaoJCkarJOlQuJ_mQyJsna~KI?_B?WAoK?sB_N"},
  {0,NULL,"@CC_S@SD_V@_EOY@oFO^AGJ?nB?K_rB[M?yBkNp?CGOpGCcQ`JCoRPMC{SPSDST`V"},
  {0,NULL,"D_U`]EKY`jEoZPoFS]@~G?`AFG_aaJGsbaOHCcqUHgeq[HsgqgIciajIojQmI{kAs"},
  {0,NULL,"JWlqxJknB@KSrBNLM?_B?[A_K?sB_N@?CoS@SD_V@_EOZ@oFO]AKIomB?KOsB[M?x"},
  {0,NULL,"BkN`?CCP@FCcQ`JCoRPMC{S`RDST`VD_UP\\EOYPjEoZ`nFO]P}GC_qFGcaaJGsbaN"},
  {0,NULL,"HGdATHceq[HshAfIciajIojQmI{kQsJWlqwJgnR?KOqrNLI?_B?S@_G?sB_O@CC_R"},
  {0,NULL,"@SD_V@_EOZ@oF_^A_I_jA{K?sBSL_yBkN@@CGP@FC_Q`JCoR`ND?SPQDOT`VD_V@]"},
  {0,NULL,"EOX`fE_YPoFC]`|GC`AEG_aQJGscAQHOdQUH[eAYHshafI_iQiIkjQmI{kQrJSlq{"},
  {0,NULL,"J{oB@KKqRMLM?_B?S@oH?oB_O@CC_R@OD_V@_EOY@sF_^A[IOkAwK?rBSL_xBkNP@"},
  {0,NULL,"CGOpFC_QPJCsR`ND?SPQDKTPVD_Up\\EKXPfE_Y`nFC]p{G?_qDG_aQIGwbqPHKdQU"},
  {0,NULL,"H[eAXHshQfI_iQiIkjAmI{kAqJSla|JwoB@KGqBLLI?_B?W@oI?kB_N@?COQ@KD_V"},
  {0,NULL,"@gEo[@sF_^AWIOiBCK_rBOMOyBkN?|CKP@HCgQpKCsR`ND?SPQDKT@TDWVp_ECW`f"},
  {0,NULL,"E_YpkFW\\pyFk`QEG[aaJGobqOHKdAVH_eq[HsgafI_iQiIojQmI{kApJ_mQ{Jsna~"},
  {0,NULL,"KOpROLE?_B?WA?H?gB_N@?COR@ODOV@_EOY@kFO^ASIOlAwJoqBOL_wBkNO~C?OPF"},
  {0,NULL,"C_Q`KCsRpODCS`RDOTPUD[UP[ECW`bEWY`mFK]P{F{`ADGW`qHGobaQHKdAUH_eQY"},
  {0,NULL,"HkfqfI_iQiIkjAlI{katJ[mQyJknQ~KKpbILE?_B?[A?H?kB_N@?COQ@ODOU@_EOY"},
  {0,NULL,"@kF?]AOI_lAwJopBKLOvBkN?}C?O`FC_QPKCsR`ODCS`RDOTPUD_U`ZECW`cESYPl"},
  {0,NULL,"FG]@|Fw_qDGW`qGGobQPHKdATH[eQYHofafI_iQiIkjAlIwkqtJWmAyJknA}KGprI"},
  {0,NULL,"LA?_B?SAOI?sBoP@GCoS@SD_W@gEo[@sF_^ACIOjAoJOpBSM?yBkN?}B{OpFC_QPI"},
  {0,NULL,"CkR@ND?S`RDOTPVD_U`[DsVp_EWZPnFG\\PvGG_qCGWaQIGobaNH?cQQHSeAYHogAf"},
  {0,NULL,"I_iQjIojQmI{kQqJKlAxJgnb@KWqRJKu?_B?SA?J?oBoO@GCoS@SDoX@gEo[@sF_^"},
  {0,NULL,"A?I_jAoJOqBWLoxBkNO}B{P@FC_QPICkRPMD?SPRDOT`VD_UPZDwVp_ESZ`oFK\\@u"},
  {0,NULL,"GG_qCGSaAJGobQNH?cQQHWdqXHkgQfI_iajIojQmI{kAqJKlAwJknr?K[qBKKy?_C"},
  {0,NULL,"?W@oG?cA_J?oBOM?{D?T@WDoW@cE_ZAGGocASH_mA{LowBwNp?CCO`DCWR@LDST`X"},
  {0,NULL,"DgUp[ECW`bEOYPiEkZ@lEwZpoFG[pwFc^`~G?_QFGsbaRHOeQYHkfA]H{gA`IKhAd"},
  {0,NULL,"IWiqsJSlavJ_mQyJknA|KgrrUL[uBZLq?_C?S@_F?_AOI?kBOM@CC_R@SD_Y@kF?]"},
  {0,NULL,"ACH?dAWI?iBCLOyBoN`ACKP@DCWR@ODGT@YDoVp_ECW`cESX`fE_YPkEsZpoFG\\pw"},
  {0,NULL,"Fg]p|GC_aEGocASHSdqWHgfA]I?gQaIKhAdIWjapJKlQwJcma{Jwnr@KcsBSLStrX"},
  {0,NULL,"Lq?_C?S@_F?_AOI?kB?M@?C_R@ODoY@kFO^A?H?dAWHohBGL_xBsNp@CKP@DCWRPO"},
  {0,NULL,"DCSpXDkVp_ECW`bESX`fE_Y`jEwZpoFK\\`xFg]p{G?_aDGobqRHWdqWHceq^I?gQa"},
  {0,NULL,"IKhAdIWjqoJGlQwJcmq|Jwnr?K_sRSLStbYLm?_C?S@_F?_AOI?oBOM@?COR@SDoW"},
  {0,NULL,"@cFO]ACGodA[I?mB?L?uBsO@@CGP@DCWPpNDGTpXDoVP]EGWpcESX`fE_YPiEoZ`n"},
  {0,NULL,"FC\\@xFk^@|F{_QHGwcaSHSdaWHcfQ]H{gQaIKhAdIWiapJGlQuJ[ma|J{oB@KKsbS"},
  {0,NULL,"L_ubZLq?_C?S@_F?_AOJ?oBOM@?COQ@OD_W@cF?^A?G_cA[I?nB?KotBoO@@CGOpD"},
  {0,NULL,"CWQ@MDCU@YDkVP]ECWpcESX`fE_YPiEkZPoFC\\PwFg^@|Fw_AGGscQRHSdaVHgfQ]"},
  {0,NULL,"H{gAaIKhAdIWiQoJKlQuJ[mq{JwoB@KGsrTL_uRZLq?_C?S@_F?cA_J?oBON@CC_U"},
  {0,NULL,"@[E?Y@sF_^ACG_bAWHohAoKoyBoNO~CGOpDCWQPJC{TPYDkV@\\DwVp_EGWpfE_Y`j"},
  {0,NULL,"EoZPnFC[`tFW\\pzF{_AIGwbqOHCcqWHofQ]H{gA`IGgqdIWiAoJCkasJWmQ{Jsnb@"},
  {0,NULL,"KSrRTLWuRYLq?_C?S@_F?_A_J?oBON@?CoU@[EOZ@oF_^A?G_bAWI?iAkL?xBoNO}"},
  {0,NULL,"CCP@DCWQ`JCwT`XDkV@\\DwVp_ECX@fE_YPjEoZ`oFC[psFW\\pyFw_QJGsbqOHGdAV"},
  {0,NULL,"HkfQ]H{gA`IGhAdIWhqoJCkqsJ[mA{Jsnr?KOrbSL[uRYLm?_C?S@_G?cA_J?oBON"},
  {0,NULL,"@CCoS@SEOY@oFO^A?GOaASI?kAsK_wBsN_~C?OpDCWQ@IDOTpXDgV@\\DwVp_ECWpd"},
  {0,NULL,"EWY`kEsZ`oFK\\@tF[]@{F{_aCGobaOHCcaUHgeq]H{gA`IGgqcISjAoJGkqsJ[mQy"},
  {0,NULL,"Jknr@KWrBTLWtrWLi?_C?S@oG?cA_J?oBON@?C_S@SE?Z@oFO]A?GObAOHojAsKOv"},
  {0,NULL,"BoN_~C?P@DCWPpHDKU@XDgUp\\DwVp_EGX@dEWYPjEsZ`nFG\\@tFW]P|Fw_aBGobQN"},
  {0,NULL,"HCcaTHcfA]H{gA`IGgqcIWjQpJGkqsJWmAyJknb?K[qrSLWtrWLe?_B?S@_H?gAoK"},
  {0,NULL,"?sB_R@SD_V@cE_Z@sF_^AKHOeA_J?uB_MOyBsN_~CCO`BCOP`ICkRPND?S`SDST`V"},
  {0,NULL,"D_V@_E_Y`kEwZpoFK\\pzF{_A@GGaQJGwbqOHGdAUH[eAXHgeq[HsgQcIShagIkjAm"},
  {0,NULL,"I{lAxJsnr@KcrBLKwrrPLGub`MU?_B?S@oG?gAoK?sB_Q@OD_V@_E_Z@oF_^AGH?e"},
  {0,NULL,"A[IotB[MOyBoN_~CCO`BCOP`HCkR@MD?SPRDST`VD_Up^E[YPjEsZpoFG\\`yFw_A@"},
  {0,NULL,"GGaAIGsbqOHCcqTH[eAXHgeq[HsgAbIShafIkjQmI{lAwJonb?K_qrLKwrrOLKuR_"},
  {0,NULL,"MQ?_B?S@_G?cA_J?oB_O@CC_T@_E_[@sF_^ACH?fA_JOqBKL_yBoNO~C?O`BCOP`G"},
  {0,NULL,"CcRpODCS`RDOT`VD_V`_EGXPeE[Y`lFS\\`zFo^P~GG`aGGocAPHGcqTHWdqWHcea["},
  {0,NULL,"HsfaaIKhagIgjAlI{kazJwnr@KKprKKssBPLKtR\\MM?_B?S@oG?cA_J?sB_O@CCoS"},
  {0,NULL,"@cEo[@sF_^A?HOfA_JOpBOLOxBoNO}C?OPBCOP`FCgR`ODCS`RDOTPVD_VP^ECXPe"},
  {0,NULL,"E_YPmFO\\pyFo^P}GG`QHGobqPHGdATHWdqWHceaZHsfqaIOhQfIcjAlIwkqyJwnr?"},
  {0,NULL,"KGpbJKwsBPLGtB\\MI?_B?S@_F?_AOK?sB_Q@KD?T@_EOY@kF?\\A?GOcASK?tBWLow"},
  {0,NULL,"BwNp?CCO`BCOP`FC_QpKCsSPQDKT@VD_UPYEKX@dEWZpoF_]P{Fs_A@GG_qCGobQM"},
  {0,NULL,"HCcaTHWdqWHceaZHogA`IKhAhIgiqmI{lQyJkoB@K_qRIKkrBQLKuBaMM?_B?W@oG"},
  {0,NULL,"?cAoK?sB_N@?C_V@_EOZ@sF_^A?GoeA[JorBOL_vBoNO~C?OPACOP`FCkRPMC{SPR"},
  {0,NULL,"DOTPUD_Up]EGWpcE_YpmFC\\`xFs^`~G?`QJGsbqPHGcqSHWdqWHceq[Hsfq`IGhag"},
  {0,NULL,"IciajIslazJonR?KSprIKwsRQLKur]MQ?_B?W@oG?cA_K?sB_N@CCoU@_EOY@oF_^"},
  {0,NULL,"ACG_eA_J_rBOLOwBoNO}C?OPACKP`GCkR@MC{S`RDOTPUD[V@\\ECWpcE[Z@lFC\\pw"},
  {0,NULL,"Fo^`~GC`aIGwcAPHGcqSHSdqWHgeq[Hsfa_IGhQfIciajIolqyJonR@KOpbIKssBQ"},
  {0,NULL,"LKvB^MU?_B?WA?H?gAoK?sB_N@?C_R@ODOU@kF?^A?H?eA_IonBCK_wBoN_~C?OPB"},
  {0,NULL,"COPPGCgR@LCwRpODKT@UD_W@`EOX`jEsZ`oFK\\PwFc]`}GG`aJGobQNH?caRHOdQU"},
  {0,NULL,"H[eaZHogAaIOhahIkjAlI{kqvJ_mQzKOpbFKcrrPLKtr_MI?_B?[A?H?gAoK?sB_N"},
  {0,NULL,"@CC_R@ODOV@gFO]ACHOeA[J?mBCK_vBsN_~C?O`BCOPPFCcR@LCwRpODKT@TD[Vpa"},
  {0,NULL,"EKXPkEsZ`nFG\\@wFc]p~GG`QIGobaNH?cQRHOdQUH_eQZHogQaIKhQiIkjAlIwkau"},
  {0,NULL,"J_mQyKSpbFK_rrOLGtb`MM?_B?S@_F?cA_J?sB_O@CC_S@SD_V@_Eo\\AKH?dA[IOn"},
  {0,NULL,"B?KOyBoNp?CCO`BCOPPFCcQ`KCsRpODCS`TD_U`aEWY@hEgYpnFG\\PxFg]p|G?`qH"},
  {0,NULL,"GobQMG{cqSHSdaWHcea[HsfqbIOhagIcjQmI{kQtJWmQ}KGorDKcqrNLCvBbMOzGA"},
  {0,NULL,"?K@OE?[A?I?kB?M@?COR@ODOU@[EOY@oG_cASI?iAwK?qBcNO}C?OPACKP@DC_QPI"},
  {0,NULL,"CoRPMD?SPQDWTpXECXPfEcY`kF?[psF_]`zFo_QFG_bALGwcARHOdQUH[eQYHkfQ]"},
  {0,NULL,"IKhAdI[iakIwjqoJSlqwJ{obBKOqBKK{sBZMGxRj_G?oD?W@oG?gAoL?{COT@[E?X"},
  {0,NULL,"@gEo[@sF_`AGGodAgJOsB[M_{BsN_~C?O`CCWPpHCgQpKDCS`SDST`VDcU`[DwVpa"},
  {0,NULL,"EcZ@qFO\\`vFs^q@GO`qKGsbaOHCcaSH_eQYHkfA\\Hwfq`IKhqgIgjQmJClAyJonrB"},
  {0,NULL,"KSqbJKorbOL[vr`Mu?_B?S@_F?cA_J?oBoO@OD_W@cE_Z@oFO^A?G_bAOIOlBKM?x"},
  {0,NULL,"BoNO}B{O@@CKP`GCcQ`JCsSPQDKTPUD_UPYDkVP_ECY`jFK\\PuF[^@}G?_qFGobQM"},
  {0,NULL,"G{cQQHKdqXHgeq[Hsfa^I?hAfI_iQkI{kAsJknQ}KGpBIKkrBLLCtb]M?zgA?K@OG"},
  {0,NULL,"?cA_J?oBON@?COS@SD_V@_EO]@{G_bA[I?jAoJOmA{N?|BwNp?CCO`DC[Q@HCgR`N"},
  {0,NULL,"D?TPUD[U@ZDoVP]EcY`lEw[PqFK\\@tFw^qGGcbQMG{cAPHGcqSHSdaXHgfQ]H{hQe"},
  {0,NULL,"I[iAjIojQqJKlAuJ[obBKWprLKwrrWLwvri_G?oD?W@oH?kB?L?{C?P@GCoT@WEO["},
  {0,NULL,"@sF__ACGogAgJ?oBCKo{BsN`?CGOpCCSPpGCcQ`JCsR`NDGT@WDgVP]E?X@dE_Z@p"},
  {0,NULL,"FO\\PvF_]p|GKaqKGsbaNH?cQQHOdQUH[fA\\HwgQaIOiAhIgjAmJ?kQrJWoRAKOpRF"},
  {0,NULL,"KcrBQLcvR^M]?_B?S@_F?_A_K?sBoO@CC_R@ODoW@oFO^A?GOaA[IOjB?K_sBoNO~"},
  {0,NULL,"C?OPBCOPPFC_QPICkR@MC{SPRD[UP\\DwVpbEWXpjFC\\@tFW]PyFo`AIGobQMG{cAP"},
  {0,NULL,"HGcqTHWeAZHsfq_IGgqfIcialI{kApJGlr?KKpBDKWqBJLKub\\LwxgA?K@OE?[A?H"},
  {0,NULL,"?gB?N@?C_R@SD_V@_E_Z@wGObAOH_hAgIomBWN?|BwNp@CGP@DC[Q@HCkR@LC{S@Q"},
  {0,NULL,"DKT`XDkV@_EGX@fE{[PqFK\\`xFk_QBGWbALGwbqOHGcqSHSdqWHcfA]I?gQeI[iAi"},
  {0,NULL,"IkjqpJGlQwJsorCK[qBHKgrRSMCxBh_G?oD?W@oG?cAoL?{COQ@KD?U@[EOY@kFo_"},
  {0,NULL,"AGHOeAcI_kA{LO{BsN_~CCO`BCSPpGCgQpKCsR`ODCT@TDgUp[D{WPbE_[@pFG[pv"},
  {0,NULL,"F_]a?GO`QKGsbaNH?cQRHOdaVH_eaZH{gA`IShqgIciqmJ?kqtJcnBAKSpbGKcqbM"},
  {0,NULL,"LSwBdMa?oC?cA_J?oB_N@?C_S@SD_V@_E_Z@sF_^AKH?eA[IOjAoJOmA{KOqBKL_v"},
  {0,NULL,"B_MOyBkNpHCsRpODKTPUD_Up_EGY`jEsZ`nFG[ptFW]PzFw^q?GG_qDGW`qGGcaaJ"},
  {0,NULL,"G{cqXHohagIkjAlI{kasJWmAxJknQ}K[rRNLCtb]M?wRbMOyRiMo{BpNO|Rv_K@?G"},
  {0,NULL,"?gAoL?wBoP@KD?T@WDoX@gEo[@wFoaASH_gAgIokAsJ_nBCK_sBSLowBcM_zBwQ`K"},
  {0,NULL,"CwS@SDST`VDoVp`EcZ@lEw[@qFK\\@vF_]`}F{_QAGO`QEG[aAHGgaqOHOeaZIShqj"},
  {0,NULL,"IojQmJKlAvJ_mQyJonrEKwrrOL[vr_MCwbdM_ybjM{{bsNS|gB?OA?H?oBOM?{C?P"},
  {0,NULL,"@GCoS@SE?X@oFO]@{G?`A[I?jAoJOmA{K?pBGKosBSL_vB_Mp?C[Q@MC{SpSD[U@\\"},
  {0,NULL,"DwWpcESX`lEw[PsFS]@xFo^P}F{_aBGO`QEG_aQIGkcQQHSdaaIciajIojQqJKlav"},
  {0,NULL,"Jgmr?KCpbFLGsrWLsvb^MGwreM[zroNC{buN]?oC?S@_H?kB_O@CC_R@ODOU@cE_Z"},
  {0,NULL,"@oFO^A?H?dA_IOiAoJOnB?KOqBKLOuB_MOyBkOpGCgRPODCS`SD_U`_ECXPeE_Y`o"},
  {0,NULL,"FK\\PvF_]`zFo^Q?GG_qCGS`aFG_aQJGodaVHghAgIcjAmI{kArJSmQzJwnr@KGqRK"},
  {0,NULL,"LCtR\\M?wbbMSxrjMozbpNK|Ru_K@?D?[A?I?wC?P@GCoS@SDoW@gEo[@sF_`AOHOf"},
  {0,NULL,"AcI_jAsJ_oBCK_sBSL_vBcM_zCOPpHCoS@PDGSpVDcVpaESX`fEcZpqFO\\`xFg]p{"},
  {0,NULL,"Fs_QAGK`ADGW`qGGcaaKHSeAXIKhqiIsjanJCkatJ_ma}J{oBBK_qrOLOvR`MGwrc"},
  {0,NULL,"MWyrkMs{brNO|wB?O@_F?cBOM?{COQ@KDOU@[E?X@gEo\\@wGObASH_hAgJ?mA{K?p"},
  {0,NULL,"BKL?tBWLowBgMpAC[QpKCsRpQDOTPYDoW`bEOY@kE{[PqF[]@xFk^P~G?_QBGO`QE"},
  {0,NULL,"G[aQIGkbaSH_fA`I_iQiIkjapJSlaxJgnA|KCpRHKgsb[L{wRbMOxRfM_yRlN?{br"},
  {0,NULL,"NU?oC?W@oG?oB_N@?C_R@OD_V@_EOY@kF?^A?G_cAWIOiAkJ_nB?K_rBOLOuB[M?x"},
  {0,NULL,"BkOPGCkR@LCwSPRDWUPZECWpcE[YpoFC[puF_]PyFo^a?GC_qCGS`aFG_aaJGscqV"},
  {0,NULL,"HkgAfIciajI{kAtJ[mAzJonR?KOqBILKur]M?wbcMSxbgMczbnNC{rs_K@?D?WA_K"},
  {0,NULL,"?{C?P@KDOU@[E?X@gF?\\@wFo`AGGogAcI_jAoJOmB?K_rBOL_wBcM_zBsQ@HCgQpN"},
  {0,NULL,"DGT`VDcV@\\DwW@fEgZ@pFK\\@tFW\\pzFo^q@GK`AEG[aAHGgaqMH?ca\\HwhqgIgjAn"},
  {0,NULL,"J?kQqJOlq|J{oRBKOrBLLgvR]L{wRdM[yRiMkzRmM{|wB?O@OF?kBON@?COQ@OD_V"},
  {0,NULL,"@_EOZ@oFO]@{G?aAKHohAgIokAsJooBCKosBSLoxBgMo{C[QPICkR`PDSU@YDkVP]"},
  {0,NULL,"D{Y@hEk[PqFO\\PuF[]`|Fw_ABGO`QFG_aQIGkbQNHCfQ^I[iAhIsjaoJCkqsJWnA}"},
  {0,NULL,"K?obDKkrbXLsvb^M?xBeM_ybkMszboNY?oC?S@_G?gAoK?sB_O@ODOV@_EOZ@oFO^"},
  {0,NULL,"A?G_bAOHOfA_IolA{K?qBOL_vB_MOyB{O@@COP`IDCT`VD_UP]EWYPiEkZ`oFK\\@t"},
  {0,NULL,"FW]PyFo^P}F{_A@GG`AFG_aQJGscaUHceaZHsfqbIOhalI{lAvJknr?KKqrKKwrrP"},
  {0,NULL,"LKtrWLgur]MGzBmNO|bvNu?oC?S@oH?gAoK?sB_P@ODOU@_EOY@oFO]ACG_bAOHOf"},
  {0,NULL,"A_J?lAwK?pBKLOvB_MOyBwO@ACKP`HDGTPVD_U`\\ESYPiEoZPnFG\\@tF[]@zFo^P}"},
  {0,NULL,"F{_A@GG_qFG_aQIGwcQTHcea[HsfabIOhQkIwlAuJgnb@KGqrKKsrrOLGtbWLcvB^"},
  {0,NULL,"MKyrlNS|bvNy?oC?S@_F?cA_K?sB_O@GCoU@_Eo[@sF_^A?GObAOH_fA_IOjB?KOr"},
  {0,NULL,"BOLOuB_MOyBoOPBCOP`JC{S`RD_VP_EOX`fE_YpnFC\\PuF[]PyFk^@|Fw_A@GG_qE"},
  {0,NULL,"GcaaJG{caTH[eA[HsgAaIOhahI{kQ|JwoB@KOqRJKssRQLKtBXLgvB\\MOzboNC{rv"},
  {0,NULL,"Ne?oC?S@_F?_AoK?sB_P@GCoV@cE_[@sF_^A?GOaASH_fA_I_kB?K_rBOLOuB[MOy"},
  {0,NULL,"BsO`BCOP`JCwSPSD[V`^EKXPfE_Z@oFC\\@uF[]@yFk^@|F{_A@GG`ADG_aaJH?cQU"},
  {0,NULL,"H[eAZHsgQaIKhQiIwkA{J{oB@KSqBKKwsBQLKtRXLgur\\MSzRnNG{ruNa?oC?S@_F"},
  {0,NULL,"?_AOI?kB_O@CD_V@_EOY@kF_^AGGocASH_fA_IOiAsJ_nBKL?tBWMOyBoNP@CGP`O"},
  {0,NULL,"DCS`TDWUp[ECW`fE_YPiFC[`rFW\\pyFk^@|Fw^q?GC`QEG[aAHHKdAVH_eQYHsfa^"},
  {0,NULL,"IShafI_lQ{Jsna~KGorIKsrbOLCtBTLkvBcMSyblMw|BtNi?oC?W@oG?cA_J?oB_N"},
  {0,NULL,"@?CoT@cE_Z@oFO]A?GObAOHOeA_I_lAwKOqBKL?uB[M?xBsN`?COP`LDGSpSDWUP_"},
  {0,NULL,"ECW`cESZ@mFK\\@uF[]@xFk^@|Fw^q@GG_qDGW`qJGocaSH[eQZHofa`IGhAiIomAy"},
  {0,NULL,"JknQ~KOprIKosBPLGtBUL[ur`MGxrnNK|RvOA?oC?W@oG?cA_J?sB_N@CC_S@_E_Z"},
  {0,NULL,"@oFO^A?GOaAOHOeA[IOlA{KOqBKL?tB[M?yBoNp?CKP`KDCSpSDSU`^ECW`bEWYpl"},
  {0,NULL,"FG\\PuF[]@xFg^@|Fw^q?GG`ADGW`qIGocQRH_eaZHofq_IGgqhIsmQyJknA}KSpbI"},
  {0,NULL,"KksBPLKtRUL[vB_MKxboNK|BuN}?oC?S@_G?cA_K?sB_P@GCoS@SD_V@_E_^ACG_c"},
  {0,NULL,"ASH_fA_IOjAoJ_nB?K_tBWM?yB{OPACKPPGCoRpOD[V@bEWXpiEsZpoFC[`rFS]@x"},
  {0,NULL,"Fg]p{F{_A@GG`AEG_aQIGwcARHSdaWHggAbIShajI{katJ[mR@KKpbGKcrRNLKtRW"},
  {0,NULL,"LgvBbMSyRjNC{bsO@@gB?O@OF?_AOJ?oBOM@?C_R@ODOU@[EOZ@wG?bAOHOeA[I?i"},
  {0,NULL,"AkJ?mA{K?pBSL_vBcN`@CGP@DC[RPMD?U@ZEOXPgEcZ`nF?[PqFK\\@wFc]`zFs^a?"},
  {0,NULL,"GC_aBGSaAHGkbQNHOdQUH[eQ`IOhQeIkjarJSlawK?obFK_qRMK{sbSL_uRZMGxBg"},
  {0,NULL,"Mo{RqNS~sF_K@?E?[A?I?kB?L?wBoO@CC_T@WDoW@oF_`AGGocAWHogAgIomA{K?p"},
  {0,NULL,"BGKosB[M_{C?O`CCSQPKCwRpUDwW`cE[YPjEoZPpFG\\@tFW]@xFg]p|Fw^q@GW`qG"},
  {0,NULL,"GgaqLH?cqSHSfA\\HwgabIWialJClavJ_nBBKOpRFK{sBRL[uRZLovrcMWyRiNG|rz"},
  {0,NULL,"_K@?E?[AOI?kB?L?wBoO@CCoS@WDoX@sFo_AGGodAWHogAcJ?mA{K?pBGKosB_MO|"},
  {0,NULL,"C?OPBCSQ`LCwRpTDsWPbE_Y`jEoZ`pFK\\@tF[]@xFg]p{Fw^q?GS`qHGgaqMG{cqS"},
  {0,NULL,"HWeq\\H{gacISiQkJ?lavJcnRAKOpREK{sRQLWubZLovbdM[yBiNC|b{_K@?D?WA?H"},
  {0,NULL,"?kB?L?{C_T@WE?X@gEo[@wFo_ACG_bAOH_gAgIokAsJorBSL_vB_M_{BwNpACWQ@J"},
  {0,NULL,"DOT`WDgUp[DwW@cEs[@pFG[ptFW\\pwFs^`~G?_QAGK`AEG_aqLH?cQQH[ea[HwgA`"},
  {0,NULL,"IWiAjJKlAzJooRFKcqbKKsrbRLStrWLcvr_MczbnN?|R{Om?oC?S@oG?cA_K?sBoR"},
  {0,NULL,"@ODoW@cE_Z@sF_^A?GOaAKHOeA[IOjAoJOmBOLOuB[M?xBsN_~CCP`FCkSpTD[UPZ"},
  {0,NULL,"DoVP^EKZ`nFC[`rFO\\`vFc^@}F{_A@GG_qCGSaQIGwbqPHGeAXHkfq_IChQfIkkas"},
  {0,NULL,"JgnR?KWqBIKkrRMLGtBUL_ub]MCyBlM{{BsNlAgB?O@OE?[A_J?oBON@GCoS@SD_V"},
  {0,NULL,"@gEo[@sG?`AGGocASH_hAgIokB?KOqB[M?xBgN_~CKP@DCcQ`JCoRPXDgVp_EkZ@n"},
  {0,NULL,"F?[`rFO\\PuF[]@xFg]q?GC_aBGO`qIGkbALGwbqOHkfA_ICgqcIwjqoJClAwJcpBD"},
  {0,NULL,"K_qRJKorrUL[uRYM?wRgMcyrkNK}cD_K@?D?WA?H?gAoL?{C?P@GCoT@[Eo\\@wFo_"},
  {0,NULL,"ACGodAWHogAcI_jAoJOnBCK_sBWM_{BsNpCCSPpIC{S@SDoV`^E?W`eE_Z`pFG[ps"},
  {0,NULL,"FS\\`vFc]`zFs^qAGO`QEGcaqKG{cAQHOdaWH{gQaIWiAlJCkarJcnrBKSpbFKcrbP"},
  {0,NULL,"LOtRVLgvR`M[ybkN?{b}OI?oC?S@oG?cA_J?oBoO@CC_R@OD_Y@oF_^A?GOaAOH_f"},
  {0,NULL,"A_IOiAkJ?lAwKOqBKLOxBoNO}CKPPGCcR`ODKUp\\D{W@`ESXplFC[`rFO\\PuF[]@y"},
  {0,NULL,"Fk^@}GG_qDGWaAIGobqOHCcqTH[fa_IGhQfIokAqJKmA}KGpBEK[qBLL?tBTLWuR\\"},
  {0,NULL,"M?xbiMkzrpNt?WB?O@OE?[A?H?kB?N@?COQ@ODOV@_EOY@sG?`AGGocASHohAgJ?l"},
  {0,NULL,"AwJooBGKouB[NO~C?O`DC[Q@HCsSPXDgUp]EGWpdEg[PqFK\\@tFW]@xFk^@|F{_AB"},
  {0,NULL,"GO`QFG_bALGwcQRHWeQ]H{gQbI_iaoJGlQuJkobBKSprGKgrBTLWuBZLwwreM[yRk"},
  {0,NULL,"Ms}SB_K@?D?W@oG?cA_L?{C?P@KD?T@WE?X@kF?_ACG_bAOHOgAcI_jAsJ_nB?KOs"},
  {0,NULL,"BSM?{BwO@@CSPpGCgR@QDcU`[DsWPcEWYPpFG[psFS\\pwFc]`{Fs^a@GK`AEG[aQK"},
  {0,NULL,"GsbaQHOdQYHwfq_IOhqhJCkqtJ[mbAKKpBEKcqbJLOtrWLovraMWxrgMkzbwOR\n"},
 { 91,"MeredithGraph",
          ":~?@E_GA?_GWDaoaFageJBWoMb?yKBgkLaouNCpQNCpQOCPIOCPITdh]Wf`uXE`uX"},
  {0,NULL,"E`uXE`uZF@yZF@yZF@yDAgSI`OiEAWWH`_edHa]dHa]gIQigIQi^GAEaGqQljimkk"},
  {0,NULL,"I}pKbYpKbYpKbYrLBUrLBUrLBUFAG[G`oa@NRw~_bs}NwOvMBeBMbk{_OGB@GCA?o"},
  {0,NULL,"R\n"},
 { 92,"MeringerGraph",
          ":]_____fEhGdddd`EIcHLMbGKMaHIbFIcGI`GJbHJaEJR`HKQU`FLRTaGLQcEKTXb"},
  {0,NULL,"ELPScFJOPaFKNS\n"},
 { 93,"MirzakhaniGraph",
          ":~??~a?GKMDKCQX[iaOhcg?QAD``gO]sGEQPkg^JFWA@EcRsGceHGgph[YTTeRxcy"},
  {0,NULL,"qWOLFcCsaZNGDs{e[NgXpGy^OkG@OocSoQh`GgXOqpdIj`DrITSsaDBAXWqadRAXY"},
  {0,NULL,"rZPqxdMlYpapdMkYMH@g{aSJhHk{aSjvSky^PiuKgw^PieBq?@@?o_SKFCAPOkWLF"},
  {0,NULL,"Bq@CcRSITQlWlVJuBDcrYLUr\\ox\\Mvbv\n"},
 { 94,"MoebiusKantorGraph",
          ":O`ADQShgHSPKePsrIeXsQKb\n"},
 { 95,"NauruGraph",
          ":W___hCEdGdEcFcGdFfge`HNaIN`JObMPaLPbKO\n"},
 { 96,"OctahedronGraph",
          ":Ea@_WGxGs\n"},
 { 97,"PappusGraph",
          ":Q___eCdddccaEGbEHaFJbFI`HJ`GI\n"},
 { 98,"PerkelGraph",
          ":x_OGCA@?daXOmRIdQX`AUNerh?{hFGCx?sdFFCX@MMSKoOwaIOHEwo{aZ`APPmAQ"},
  {0,NULL,"KoQHiAKJoPXaELFgG_w_^Pp@hEEMHO`XMCKIPaXS{aQPQ`W{`Po`hgyaRO`pcw`Qp"},
  {0,NULL,"A`\\DBHeCKW_XRIGg{sdRpPXT?mVp``W}lWOqp[ygaDR@pMraA@I@PBBaby\\jECAci"},
  {0,NULL,"yIFChdj^\n"},
 { 99,"PetersenGraph",
          ":I`ACWqHKhhccTF\n"},
 { 100,"PoussinGraph",
          ":NeIOzBJOkqDK]?WAEYGaF_SqTPI\\IuOAHId~\n"},
 { 101,"RobertsonGraph",
          ":R____eD```bGaHcFaDFIcEHIaEGKcDGJbEFJbDHK\n"},
 { 102,"RobertsonWegnerGraph",
          ":]_____hG`abcKdJLbEaFNdEcFPdFIcEI`HMNQ`GLOPcGJNRdHKOSaGIKQbHIJP`E"},
  {0,NULL,"FJKbFGMSaEHLR\n"},
 { 103,"SchlaefliGraph",
          ":Z__@_@A_@AB_@AB_@ABD_@ACD_@ACEF_@BCDF_@BCEGH_@DEFGHI_ABCDFH_ABCE"},
  {0,NULL,"GIK_ADEFGJKL_BDEHIJKLM_CFGHIJKLMN`ABCDFHK`ABCEGILP`ADEFGJMPQ`BDEH"},
  {0,NULL,"IJNPQR`CFGHIJOPQRSaBDEKLMNPQRSaCFGKLMOPQRTUbCHIKLNOPQSTUVdFHJKMNO"},
  {0,NULL,"PRSTUVWeGIJLMNOQRSTUVWX\n"},
 { 104,"ShrikhandeGraph",
          ":O`?K?o_Gc@caQGrpC]`bggSyXDOiXSJXGqTKeXIum\n"},
 { 105,"SmallRhombicosidodecahedralGraph",
          ":{_OGC?FGBqGweKHbAh[qLEFq@GuMIFQphAWMFsHxUIGa`zD]aVLSb@elTiFYXyiU"},
  {0,NULL,"nVXiA[^ngsm@CcnGSTtAbmHZYQsjkikylXeTJ\\M``aWwuCH]r_jeSDaq`KEZYGDLO"},
  {0,NULL,"ohdp@AJEkGElY^\n"},
 { 106,"SnubCubicalGraph",
          ":W____AB_@BfEeFiHigHgHIKfJfGJLMdJMbIJOaEK`EFbCHIP`DMORaCHKQ`AEQR\n"},
 { 107,"SnubDodecahedralGraph",
          ":{_OGC?CB_?O[[LFdAX_m[KEs@G}KFbBQK_^FCCypUiUidxxAoXjUydKg\\ebbdo~Z"},
  {0,NULL,"MGJ@iaQprQP|?boGSePLVOhc|[oaRiJiPNXLFcTCybQIjhxCiTqqpmUKLfDsgiUVQ"},
  {0,NULL,"Q@ctHDDUBEEGFcw_WMG_a`[GWM`BPrYAJELUsKINGKwOOKsZoOgcSt\n"},
 { 108,"SoccerBallGraph",
          ":{_OGC[GDBQ_sSTCCP@KSPECrX`A\\NjAxS_jHISq|GlPIsAdKrQKWbQAu`jtceLJa"},
  {0,NULL,"QVsLx@[miilRUltJLIvOkrxeUBB@XlWJHhBWlWR@hBVodrj\n"},
 { 109,"SousselierGraph",
          ":OiIXWoNALBIgTKbhVLAeOAGXN\n"},
 { 110,"SuzukiGraph",
          ":~?Zu_?_??@_??@?A_??@?A?B_??@?A?B?C_??@?A?B?C_??@?A?B?C_??@?A?B?C"},
  {0,NULL,"_??@?A?B_??@?A?B_??@?A?B_??@?A?B?D?G?H?I_??@?A?B?D?E?I?J_??@?A?B?"},
  {0,NULL,"D?F?H?J_??@?A?B?E?F?H?I_??@?A?B?F?G?I?J_??@?A?B?E?G?H?J_??@?A?C?H"},
  {0,NULL,"?I?J?L?O_??@?A?C?H?I?J?M?P_??@?A?C?H?I?J?K?N_??@?A?C?D?G?J?K?N?Q?"},
  {0,NULL,"R_??@?A?C?E?G?I?M?P?Q?S_??@?A?C?F?G?H?L?O?R?S_??@?A?C?E?F?J?K?N?Q"},
  {0,NULL,"?R_??@?A?C?D?F?I?M?P?Q?S_??@?A?C?D?E?H?L?O?R?S_??@?A?E?F?J?K?L?P?"},
  {0,NULL,"S?T?V?X_??@?A?D?F?I?N?O?P?R?T?U?Y?Z_??@?A?D?E?H?K?M?O?Q?U?V?W?Z?["},
  {0,NULL,"_??@?A?D?G?J?N?O?P?S?W?X?Y?\\_??@?A?E?G?I?K?M?O?R?W?X?Y?Z_??@?A?F?"},
  {0,NULL,"G?H?K?L?P?Q?W?X?Y?[_??@?A?E?F?J?K?M?O?S?T?U?Y?__??@?A?D?G?J?L?M?N"},
  {0,NULL,"?S?U?V?W?[?^?__??@?A?E?G?I?L?M?N?R?T?V?X?\\?]?_?`_??@?A?D?F?I?K?L?"},
  {0,NULL,"P?R?U?V?W?]?`_??@?A?D?E?H?N?O?P?Q?T?V?X?^?`?a?c_??@?A?F?G?H?L?M?N"},
  {0,NULL,"?Q?T?U?Y?Z?]?^?c_??@?B?C?H?I?J?M?P?Q?R?S?U?X_??@?B?C?H?I?J?K?N?Q?"},
  {0,NULL,"R?S?T?W_??@?B?C?H?I?J?L?O?Q?R?S?V?Y_??@?B?C?D?G?J?K?N?S?T?W?]?a?f"},
  {0,NULL,"?h_??@?B?C?F?G?H?L?O?Q?V?Y?_?e?f?g_??@?B?C?E?G?I?M?P?R?U?X?^?b?g?"},
  {0,NULL,"h_??@?B?C?D?E?H?L?O?Q?V?Y?\\?d?f?g_??@?B?C?E?F?J?K?N?S?T?W?Z?`?f?h"},
  {0,NULL,"_??@?B?C?D?F?I?M?P?R?U?X?[?c?g?h_??@?B?D?E?H?N?O?P?Y?[?\\?]?d?h?i?"},
  {0,NULL,"j?n_??@?B?E?F?J?K?M?O?W?Z?\\?^?`?g?i?k?l?o_??@?B?D?F?I?K?L?P?X?Z?["},
  {0,NULL,"?_?c?f?j?k?m?o?p_??@?B?F?G?H?K?L?P?V?Z?_?c?e?h?l?m?n?p_??@?B?D?G?"},
  {0,NULL,"J?N?O?P?T?[?]?a?d?g?l?m?n?q_??@?B?E?G?I?K?M?O?U?\\?^?`?b?f?l?m?n?o"},
  {0,NULL,"_??@?B?F?G?H?L?M?N?V?_?a?b?e?h?i?k?l?q?s?t_??@?B?D?E?H?K?M?O?Y?\\?"},
  {0,NULL,"^?`?d?h?j?k?m?s_??@?B?E?F?J?K?L?P?W?Z?_?`?c?g?i?j?n?t?u?v_??@?B?D"},
  {0,NULL,"?G?J?L?M?N?T?]?a?b?e?g?j?k?m?o?r?t_??@?B?D?F?I?N?O?P?X?[?]?c?d?f?"},
  {0,NULL,"i?k?l?r?v?w?x_??@?B?E?G?I?L?M?N?U?^?a?b?e?f?i?j?n?p?r?s?v_??@?C?D"},
  {0,NULL,"?E?L?Q?T?V?X?Z?\\?b?d?h?j?k?m?o?q?v?x_??@?C?D?F?M?R?U?V?W?[?\\?a?c?"},
  {0,NULL,"f?i?k?l?p?q?u?y?{_??@?C?E?F?N?S?T?U?Y?Z?[?`?e?g?i?j?n?o?p?w?z?{?|"},
  {0,NULL,"_??@?C?D?E?L?Q?U?V?W?\\?a?c?d?h?i?j?n?o?v?w?z_??@?C?F?G?O?Q?W?X?Y?"},
  {0,NULL,"]?^?_?e?h?i?k?l?p?r?u?y?}_??@?C?F?G?O?Q?T?U?Y?[?_?`?e?h?l?m?n?r?s"},
  {0,NULL,"?t?u?|_??@?C?D?F?M?R?T?U?Y?[?`?c?e?f?j?k?m?q?v?x?y?~@?_??@?C?D?G?"},
  {0,NULL,"K?S?U?V?W?\\?]?a?c?g?l?m?n?r?s?t?x?{@?@A_??@?C?D?G?K?S?W?X?Y?]?^?_"},
  {0,NULL,"?a?g?j?k?m?q?s?v?x?|?~@@_??@?C?E?F?N?S?T?V?X?Z?`?b?d?g?i?k?l?p?u?"},
  {0,NULL,"w?y?~@@@A_??@?C?E?G?P?R?W?X?Y?]?^?_?b?f?i?j?n?o?t?w?z?{@@@B@D_??@"},
  {0,NULL,"?C?E?G?P?R?T?V?X?Z?^?b?d?f?l?m?n?r?s?t?z?}?~@?@C_??@?H?I?K?N?Q?R?"},
  {0,NULL,"T?W?[?\\?_?b?f?h?i?m?o?q?t?u?{?|@@@E_??@?I?J?L?O?R?S?V?Y?Z?[?^?a?f"},
  {0,NULL,"?g?j?l?p?q?s?z?|?}@C@F_??@?I?J?L?O?R?S?V?Y?]?`?b?c?f?g?j?l?t?w?x?"},
  {0,NULL,"y@A@B@D@E_??@?H?I?K?N?Q?R?T?W?^?c?d?e?f?h?i?m?r?v?y?z?~@?@A@F_??@"},
  {0,NULL,"?H?J?M?P?Q?S?U?X?_?`?a?d?g?h?k?n?s?u?v?w?~@@@C@D_??@?H?J?M?P?Q?S?"},
  {0,NULL,"U?X?Z?\\?]?e?g?h?k?n?o?p?r?x?{?}@?@B_??@?D?J?L?M?Q?T?X?Z?\\?]?b?e?f"},
  {0,NULL,"?i?l?p?q?s?u?z?~@?@A@D@F@G@I@K_??@?D?I?K?L?S?X?Y?Z?[?^?_?a?h?i?n?"},
  {0,NULL,"r?v?w?y?z?{?}@?@B@E@G@I@K@M_??@?G?J?O?P?R?T?V?Z?[?^?a?d?h?i?k?o?p"},
  {0,NULL,"?r?x?y?{?|@@@D@E@I@J@K@N_??@?D?H?K?M?R?T?Y?^?`?c?d?e?g?l?n?o?p?r?"},
  {0,NULL,"t?x?|?}@@@C@F@G@I@K@M@N@O_??@?G?H?K?P?S?U?V?Z?\\?]?c?e?f?i?j?o?q?t"},
  {0,NULL,"?u?w?|?}?~@C@F@I@J@K@M@O@P_??@?G?I?K?O?Q?T?U?[?\\?_?`?b?g?j?k?p?q?"},
  {0,NULL,"s?v?z?{?}@?@A@B@I@J@K@M@N@O@Q_??@?D?J?L?M?R?T?Y?]?`?b?c?e?h?i?n?s"},
  {0,NULL,"?u?v?w?z?{?|?}@@@E@H@J@L_??@?E?I?L?N?S?U?Y?Z?[?^?a?e?h?k?m?o?q?t?"},
  {0,NULL,"u?x?~@@@A@C@D@I@J@L@O@Q_??@?F?H?M?N?R?V?W?[?\\?_?a?b?g?j?n?o?p?r?x"},
  {0,NULL,"?z?~@A@B@D@E@H@J@K@O@R_??@?E?I?L?N?Q?U?W?^?a?c?d?e?g?k?l?t?u?w?x?"},
  {0,NULL,"y?{?|?}@?@B@G@H@K@N@P_??@?F?H?M?N?S?V?X?_?`?a?b?d?f?j?m?r?v?x?y?z"},
  {0,NULL,"?{?|?}@C@F@G@I@L@N@P_??@?F?I?N?O?S?V?X?]?`?b?c?d?h?m?n?o?q?s?t?u?"},
  {0,NULL,"{?}@?@B@F@H@J@K@Q@R@S@U@V_??@?E?J?L?P?R?W?Y?]?_?`?b?c?h?k?m?o?p?q"},
  {0,NULL,"?r?x?~@?@A@C@F@G@H@K@M@P@U@V@X_??@?F?J?M?O?R?V?W?Z?[?\\?^?a?h?m?n?"},
  {0,NULL,"s?t?u?v?w?~@?@A@B@F@G@I@L@M@N@T@W_??@?G?I?K?O?S?U?V?\\?]?`?b?c?h?i"},
  {0,NULL,"?k?p?r?v?y?z?|?~@@@C@D@G@H@L@S@W@Y_??@?D?I?K?L?Q?T?X?Z?[?\\?_?b?g?"},
  {0,NULL,"l?n?r?t?w?x?y?~@@@C@D@F@H@J@L@S@T@U@[_??@?F?I?N?O?Q?W?X?]?^?c?d?e"},
  {0,NULL,"?g?j?n?o?p?q?s?z?~@@@C@D@E@G@I@L@M@P@T@W@Z@[_??@?E?H?N?P?S?U?Y?Z?"},
  {0,NULL,"[?\\?]?e?f?l?m?r?s?v?y?z@@@A@B@D@E@G@H@K@M@N@U@V@Y@[_??@?E?H?N?P?R"},
  {0,NULL,"?W?Y?[?\\?]?_?b?g?k?l?s?u?v?w?y?|?}@?@C@F@I@J@L@Q@R@S@T@W@Z@\\_??@?"},
  {0,NULL,"D?H?K?M?S?X?Y?^?_?`?a?d?f?i?l?o?p?q?t?u@?@A@B@D@E@H@J@L@S@T@U@X@\\"},
  {0,NULL,"_??@?E?J?L?P?Q?U?W?_?`?a?c?d?f?l?m?p?q?r?s?z?{?|@@@B@E@I@J@L@O@R@"},
  {0,NULL,"S@T@W@]@_@`_??@?G?H?K?P?R?T?V?Z?^?c?d?e?g?j?k?q?s?u?v?w?{@A@B@D@E"},
  {0,NULL,"@G@H@L@S@V@Z@[@]@^@`_??@?G?J?O?P?Q?T?U?[?_?`?a?d?f?i?j?o?t?w?x?y?"},
  {0,NULL,"}?~@?@A@F@G@H@L@V@W@Y@Z@[@\\@`@b_??@?F?J?M?O?Q?W?X?Z?\\?]?^?e?f?j?m"},
  {0,NULL,"?t?v?w?x?y?{?|@@@C@E@H@J@K@O@Q@S@U@V@X@\\@^_??A?B?C?H?I?J?M?P?Q?R?"},
  {0,NULL,"S?U?X?f?g?h?k?n@K@L_??A?B?C?H?I?J?K?N?Q?R?S?T?W?f?g?h?i?m@G@J_??A"},
  {0,NULL,"?B?C?H?I?J?L?O?Q?R?S?V?Y?f?g?h?j?l@H@I_??A?B?C?E?F?J?K?N?S?T?W?Z?"},
  {0,NULL,"`?g?i?m?p?w?}@D@e@g_??A?B?C?F?G?H?L?O?Q?V?Y?_?e?h?j?l?r?u@?@@@e@f"},
  {0,NULL,"_??A?B?C?E?G?I?M?P?R?U?X?^?b?f?k?n?t?z@E@F@f@g_??A?B?C?D?G?J?K?N?"},
  {0,NULL,"S?T?W?]?a?g?i?m?s?x@B@C@e@g_??A?B?C?D?E?H?L?O?Q?V?Y?\\?d?h?j?l?o?v"},
  {0,NULL,"?{?~@e@f_??A?B?C?D?F?I?M?P?R?U?X?[?c?f?k?n?q?y?|@A@f@g_??A?B?D?G?"},
  {0,NULL,"J?N?O?P?T?[?]?a?d?i?o?s?x?y@O@c@f@h@l@m_??A?B?D?E?H?K?M?O?Y?\\?^?`"},
  {0,NULL,"?d?l?o?p?t?v@P@`@g@h@i@j@n_??A?B?D?F?I?K?L?P?X?Z?[?_?c?n?q?r?w?y@"},
  {0,NULL,"N@\\@e@h@i@j@n_??A?B?F?G?H?K?L?P?V?Z?_?c?e?j?q?r?u?w@Q@b@g@h@l@m_?"},
  {0,NULL,"?A?B?E?G?I?K?M?O?U?\\?^?`?b?k?p?t?v?z@R@[@e@h@l@m_??A?B?D?E?H?N?O?"},
  {0,NULL,"P?Y?[?\\?]?d?l?o?s?v?y@^@_@g@i@k@m@p@r_??A?B?F?G?H?L?M?N?V?_?a?b?e"},
  {0,NULL,"?j?r?u?x?z@U@W@g@j@k@l@n@p@r_??A?B?E?F?J?K?L?P?W?Z?_?`?c?m?p?q?r?"},
  {0,NULL,"w@Y@a@f@i@k@m@o@r@t_??A?B?E?F?J?K?M?O?W?Z?\\?^?`?m?p?t?v?w@Z@d@f@j"},
  {0,NULL,"@k@l@p@q@s_??A?B?D?G?J?L?M?N?T?]?a?b?e?i?s?u?x?z@M@S@f@h@i@j@q@r@"},
  {0,NULL,"s_??A?B?D?F?I?N?O?P?X?[?]?c?d?n?o?q?s?y@X@]@e@j@k@l@o@q@u@w_??A?B"},
  {0,NULL,"?E?G?I?L?M?N?U?^?a?b?e?k?t?u?x?z@T@V@e@i@k@m@n@o@q@v_??A?C?D?E?L?"},
  {0,NULL,"Q?T?V?X?Z?\\?b?d?l?{?~@D@F@M@\\@g@h@i@j@o@p@s@w_??A?C?D?F?M?R?T?U?Y"},
  {0,NULL,"?[?`?c?e?n?|?}@@@A@P@S@e@h@i@j@o@p@w@x_??A?C?D?G?K?S?U?V?W?\\?]?a?"},
  {0,NULL,"c?i?|?~@B@C@Q@[@f@h@l@m@n@q@r@w@z@{_??A?C?D?E?L?Q?U?V?W?\\?a?c?d?l"},
  {0,NULL,"?{?|?~@B@V@a@g@i@k@m@o@s@u@y@{_??A?C?F?G?O?Q?T?U?Y?[?_?`?e?j?}@?@"},
  {0,NULL,"@@A@R@c@g@h@l@m@n@q@r@t_??A?C?F?G?O?Q?W?X?Y?]?^?_?e?j@?@@@C@E@]@d"},
  {0,NULL,"@g@j@k@l@q@t@v@x@{@|_??A?C?D?F?M?R?U?V?W?[?\\?a?c?n?|?~@A@B@U@Z@e@"},
  {0,NULL,"j@k@l@p@t@v@x@z@~_??A?C?D?G?K?S?W?X?Y?]?^?_?a?i@?@B@C@E@N@`@f@h@i"},
  {0,NULL,"@j@n@o@p@w@}@~A@_??A?C?E?F?N?S?T?V?X?Z?`?b?d?m?{?}@D@F@W@X@f@j@k@"},
  {0,NULL,"l@t@u@v@x@{@}@~_??A?C?E?F?N?S?T?U?Y?Z?[?`?e?m?}@@@A@D@T@^@f@i@k@m"},
  {0,NULL,"@s@u@v@y@zA?A@_??A?C?E?G?P?R?T?V?X?Z?^?b?d?k?{@D@E@F@O@b@e@h@l@m@"},
  {0,NULL,"n@q@r@y@}A?AAAC_??A?C?E?G?P?R?W?X?Y?]?^?_?b?k@?@C@E@F@Y@_@e@i@k@m"},
  {0,NULL,"@r@s@u@y@z@|@~AB_??A?H?I?K?N?Q?R?T?W?[?\\?_?b?g@G@J@R@U@\\@_@e@g@h@"},
  {0,NULL,"k@p@r@s@t@z@~A@AE_??A?I?J?L?O?R?S?V?Y?]?`?b?c?h@H@I@S@X@Y@[@e@f@i"},
  {0,NULL,"@l@r@u@w@x@{@|ABAE_??A?I?J?L?O?R?S?V?Y?Z?[?^?a?h@H@I@N@O@T@Z@e@f@"},
  {0,NULL,"i@l@n@p@v@yA@AAACAD_??A?H?I?K?N?Q?R?T?W?^?c?d?e?g@G@J@P@V@]@b@e@g"},
  {0,NULL,"@h@k@o@q@x@y@{@}A?AD_??A?H?J?M?P?Q?S?U?X?Z?\\?]?e?f@K@L@M@Q@^@d@f@"},
  {0,NULL,"g@j@m@q@s@v@w@z@|A?AC_??A?H?J?M?P?Q?S?U?X?_?`?a?d?f@K@L@W@`@a@c@f"},
  {0,NULL,"@g@j@m@n@o@t@u@}@~AAAB_??A?D?J?L?M?Q?T?X?Z?\\?]?b?e?x?{@L@M@S@\\@d@"},
  {0,NULL,"e@k@l@n@p@t@v@y@{@}A?ABADAFAGAK_??A?D?I?K?L?S?X?Y?Z?[?^?_?a?q@C@H"},
  {0,NULL,"@N@T@\\@`@g@k@m@o@q@u@x@y@z@|A?ACAEAFAGAKAL_??A?F?J?M?O?R?V?W?Z?[?"},
  {0,NULL,"\\?^?a?p?|@H@O@U@Z@d@g@h@m@n@o@r@t@u@{@|@}A?ADAFAGAJALAM_??A?E?H?N"},
  {0,NULL,"?P?S?U?Y?Z?[?\\?]?e?o?}@L@Q@T@^@_@e@h@l@n@o@q@x@y@{@|@~ABAEAFAHAKA"},
  {0,NULL,"LAM_??A?G?H?K?P?R?T?V?Z?^?c?d?e?r@F@J@O@P@Q@b@f@i@j@n@o@p@t@u@z@{"},
  {0,NULL,"@|ABAEAFAHAJANAO_??A?G?I?K?O?Q?T?U?[?\\?_?`?b?t@@@G@R@[@\\@c@f@i@j@"},
  {0,NULL,"n@o@p@v@y@z@{@|A?ACAGAIAKALAM_??A?D?J?L?M?R?T?Y?]?`?b?c?e?x@A@I@M"},
  {0,NULL,"@P@S@Y@g@k@m@n@o@t@u@y@z@~A@ACAEAHAIAJAP_??A?E?I?L?N?S?U?Y?Z?[?^?"},
  {0,NULL,"a?e?z?}@H@N@T@V@^@g@h@j@p@r@s@t@w@{@}@~AAABAGAIAJAN_??A?F?H?M?N?R"},
  {0,NULL,"?V?W?[?\\?_?a?b?u?|@G@U@W@Z@_@f@i@m@q@s@v@w@y@{@|@}ABAEAHAIAKAOAQ_"},
  {0,NULL,"??A?F?H?M?N?S?V?X?_?`?a?b?d?u@D@K@U@W@X@`@e@h@i@o@q@w@x@y@zA@AAAC"},
  {0,NULL,"ADAFAGAJAMAN_??A?E?I?L?N?Q?U?W?^?a?c?d?e?z?~@J@T@V@]@a@f@j@l@r@t@"},
  {0,NULL,"u@w@x@z@|A?A@ACAFAHAKAMAOAP_??A?F?I?N?O?S?V?X?]?`?b?c?d?y@D@I@W@X"},
  {0,NULL,"@[@]@g@h@m@n@p@r@s@t@z@|A?ACADAHAIAKAQARATAV_??A?E?J?L?P?R?W?Y?]?"},
  {0,NULL,"_?`?b?c?w@E@I@S@Y@_@a@g@h@j@p@q@s@v@w@{@}A?AAADAFAHAKALAOATAVAW_?"},
  {0,NULL,"?A?G?J?O?P?R?T?V?Z?[?^?a?d?s@F@H@O@Z@b@c@g@j@k@q@s@v@w@x@z@~A@ABA"},
  {0,NULL,"EAGAIAKAMAQASAT_??A?G?I?K?O?S?U?V?\\?]?`?b?c?t@B@I@Q@R@X@[@g@j@k@o"},
  {0,NULL,"@q@v@x@y@}@~A@AAABAFAHAJAOAPARAUAX_??A?D?I?K?L?Q?T?X?Z?[?\\?_?b?q?"},
  {0,NULL,"{@G@M@N@R@\\@f@l@m@q@r@u@w@x@}@~AAABADAHAIAJARASATAZ_??A?F?I?N?O?Q"},
  {0,NULL,"?W?X?]?^?c?d?e?y@?@J@V@X@]@d@f@i@m@n@p@s@v@y@}@~AAABAEAFAGAJALANA"},
  {0,NULL,"PASAUAZ_??A?D?H?K?M?R?T?Y?^?`?c?d?e?v@A@J@P@S@`@b@f@l@m@q@r@s@v@w"},
  {0,NULL,"@~A@AAACADAFAGAKALAMAUAVAXAYA\\_??A?E?H?N?P?R?W?Y?[?\\?]?_?b?o@E@G@"},
  {0,NULL,"U@Y@^@_@f@j@l@n@o@t@u@xA?A@AAACADAGAIAJANAQARASAUA[_??A?D?H?K?M?S"},
  {0,NULL,"?X?Y?^?_?`?a?d?v@C@K@N@P@W@`@e@k@l@p@r@s@t@v@{@|A?ABAEAHAIAJAPARA"},
  {0,NULL,"SATAWA[_??A?E?J?L?P?Q?U?W?_?`?a?c?d?w?~@K@V@Y@a@c@e@h@l@n@p@q@v@y"},
  {0,NULL,"@z@|@~A@AEAGAIAJAQARASAUAYA\\A^A__??A?G?H?K?P?S?U?V?Z?\\?]?c?e?r@B@"},
  {0,NULL,"L@Q@[@^@b@e@i@k@p@r@s@t@u@}A@AAACADAGAIAKALAQASAWAYA]A^_??A?G?J?O"},
  {0,NULL,"?P?Q?T?U?[?_?`?a?d?s@@@K@O@R@a@c@e@i@k@r@s@u@w@x@{@}A?ACADAFAHAJA"},
  {0,NULL,"NAPAUAVAXAZA[A__??A?F?J?M?O?Q?W?X?Z?\\?]?^?e?p@?@L@M@Z@]@d@e@h@i@o"},
  {0,NULL,"@r@u@w@x@z@~A@AAAEAHAIAKAOARATAVAWAYA[Aa_??B?C?D?E?L?Y?h?i?j?n?o?"},
  {0,NULL,"v?w?z?{?}?~@E@N@S@g@h@i@j@o@p@s@w@z@{@}AAASAX_??B?C?D?F?M?X?f?i?k"},
  {0,NULL,"?l?p?q?u?y?|@?@A@D@M@`@e@h@i@j@o@p@w@x@z@{A@AAAUAc_??B?C?D?G?K?T?"},
  {0,NULL,"g?j?k?m?q?s?v?x?{@A@B@C@R@b@f@h@l@m@n@q@r@w@|@~AAADA[A]AdAe_??B?C"},
  {0,NULL,"?D?F?M?X?f?j?k?m?q?v?x?y?{?|@A@C@W@d@e@j@k@l@p@t@v@x@{A?A@ABALA_A"},
  {0,NULL,"d_??B?C?D?G?K?T?g?l?m?n?r?s?t?x@@@B@C@F@P@\\@f@h@i@j@n@o@p@w@z@{@|"},
  {0,NULL,"AAAPAQAg_??B?C?E?F?N?W?g?i?k?l?p?u?w?y?|?}@?@D@V@_@f@i@k@m@s@u@v@"},
  {0,NULL,"y@}ABACAEATA\\AdAg_??B?C?E?G?P?U?f?i?j?n?o?t?w?z?}?~@E@F@Q@c@e@h@l"},
  {0,NULL,"@m@n@q@r@y@|@~ADAEAOA`AhAi_??B?C?D?E?L?Y?h?j?k?m?o?q?v?x?{?~@A@C@"},
  {0,NULL,"T@Y@g@i@k@m@o@s@u@y@z@}ACAEAMARAeAhAj_??B?C?F?G?O?V?h?i?k?l?p?r?u"},
  {0,NULL,"?y?|@?@@@D@O@[@g@h@l@m@n@q@r@t@|@~A?ADANAWAgAh_??B?C?F?G?O?V?h?l?"},
  {0,NULL,"m?n?r?s?t?u@?@@@B@F@X@Z@g@j@k@l@q@t@v@x@~A?A@ABAYAZAeAfAiAj_??B?C"},
  {0,NULL,"?E?F?N?W?g?i?j?n?o?p?w?z?}?~@D@E@U@]@f@j@k@l@t@u@v@xA?A@ABACAVA^A"},
  {0,NULL,"eAkAl_??B?C?E?G?P?U?f?l?m?n?r?s?t?z@@@B@E@F@^@a@e@i@k@m@r@s@u@y@}"},
  {0,NULL,"ACADAEAaAbAdAfAlAn_??B?H?I?K?N?S?f?h?i?m?o?q?t?u@G@J@Q@T@X@`@e@g@"},
  {0,NULL,"h@k@o@q@x@yAFAIAMAOAUAZAeAjAkAm_??B?I?J?L?O?Q?f?g?j?l?p?q?s?z@H@I"},
  {0,NULL,"@M@R@]@a@e@f@i@l@r@u@w@xAGAHAVA[AbAcAeAfAnAo_??B?I?J?L?O?Q?f?g?j?"},
  {0,NULL,"l?t?w?x?y@H@I@V@\\@c@d@e@f@i@l@n@p@v@yAGAHALAQA\\A`AgAhAiAj_??B?H?I"},
  {0,NULL,"?K?N?S?f?h?i?m?r?v?y?z@G@J@N@W@[@^@e@g@h@k@p@r@s@tAFAIASAWA_AaAdA"},
  {0,NULL,"gAlAo_??B?H?J?M?P?R?g?h?k?n?o?p?r?x@K@L@O@P@U@Y@f@g@j@m@n@o@t@uAJ"},
  {0,NULL,"AKANAPARA^AhAkAlAn_??B?H?J?M?P?R?g?h?k?n?s?u?v?w@K@L@S@Z@_@b@f@g@"},
  {0,NULL,"j@m@q@s@v@wAJAKATAXAYA]AdAfAiAm_??B?D?J?L?M?a?f?i?l?p?q?s?u?z?|@H"},
  {0,NULL,"@M@S@`@a@g@k@m@n@o@t@u@y@}AKALAMANARAdAgAiAlAoApArAu_??B?F?I?N?O?"},
  {0,NULL,"[?g?j?n?o?p?q?s?z?}@H@R@U@X@]@g@h@m@n@p@r@s@t@~AFANASAWA\\AdAfAiAj"},
  {0,NULL,"AmApArAtAv_??B?D?H?K?M?\\?g?l?n?o?p?r?t?x@B@L@P@U@\\@`@e@k@l@p@r@s@"},
  {0,NULL,"t@vA@AFALA]A_AaAeAfAmAnAoApArAuAvAw_??B?G?H?K?P?_?f?i?j?o?q?t?u?w"},
  {0,NULL,"@E@G@Q@`@b@c@f@i@j@n@o@p@t@uAAAKAPAQA^AaAdAeAfAnAoArAsAuAvAx_??B?"},
  {0,NULL,"E?J?L?P?Z?h?k?m?o?p?q?r?x?{@L@O@T@Y@a@e@h@l@n@p@q@v@yADAHALAOAXA`"},
  {0,NULL,"AdAfAgAlAoApAqAuAvAx_??B?G?I?K?O?^?h?i?k?p?r?v?y?z@?@J@N@O@R@[@f@"},
  {0,NULL,"i@j@n@o@p@v@yAAAHAPAQAZA\\AdAeAfAiAmApAqAtAwAz_??B?F?H?M?N?e?g?j?n"},
  {0,NULL,"?o?p?r?x?z?}@L@P@U@W@]@e@h@i@o@q@w@x@y@{AIAOATAUAcAdAgAhAiAjAqAsA"},
  {0,NULL,"uAz_??B?D?J?L?M?a?h?i?n?s?u?v?w?z?~@K@M@N@S@Z@e@k@l@n@p@t@v@yA@AH"},
  {0,NULL,"ALARA_A`AeAjAkAmAnAqAsAtA{_??B?E?I?L?N?b?g?k?l?t?u?w?x?y@D@I@T@V@"},
  {0,NULL,"\\@_@g@h@j@p@r@s@t@w@zAFASAVAWAXAeAhAkAlAnApAqAuAxAz_??B?E?I?L?N?b"},
  {0,NULL,"?h?k?m?o?q?t?u?x?{@G@T@V@X@Y@f@j@l@r@t@u@w@xABAGASAVA[A^AdAfAgAiA"},
  {0,NULL,"mArAsAtAwAy_??B?F?H?M?N?e?f?j?m?r?v?x?y?z@A@J@U@W@^@d@f@i@m@q@s@v"},
  {0,NULL,"@w@yACAJATAUA\\A]AeAfAkAnAoApArAtAwAxA{_??B?E?H?N?P?d?f?l?m?r?s?v?"},
  {0,NULL,"y?z@F@J@W@^@_@a@f@j@l@n@o@t@u@xABAKAOAPAVA^AgAhAiAjAmApAqAuAvAzA{"},
  {0,NULL,"A|A~_??B?D?H?K?M?\\?f?i?l?o?p?q?t?u?|@G@M@P@Q@`@f@l@m@q@r@s@v@w@|A"},
  {0,NULL,"JATA[A]A_AgAhAiAjAlAqAsAtA|A}B?_??B?G?H?K?P?_?g?j?k?q?s?u?v?w@C@K"},
  {0,NULL,"@Q@R@_@b@e@i@k@p@r@s@t@uAEAFAPA_AaAbAgAhAiAjAkApAqAtAwA{A}A~BABB_"},
  {0,NULL,"??B?D?I?K?L?c?g?l?n?r?t?w?x?y@B@I@N@P@V@\\@g@k@m@o@q@u@x@y@}AIAMAR"},
  {0,NULL,"AZA[AdAfAiAmAoAqAsAtA{A|A}B?BB_??B?D?I?K?L?c?h?i?n?r?v?w?y?z?~@J@"},
  {0,NULL,"N@S@[@\\@f@l@m@q@r@u@w@x@|AGAMAVA[A]AhAjAkAlAnApArAuAvAxA~B@BA_??B"},
  {0,NULL,"?F?I?N?O?[?h?m?n?o?q?s?t?u@@@G@T@X@Z@]@f@i@m@n@p@s@v@yACAHAQATAWA"},
  {0,NULL,"\\AhAkAlAnAoAqAsAuAyAzA|A}A~BB_??B?E?H?N?P?d?g?k?l?s?u?v?w?y@D@K@V"},
  {0,NULL,"@^@_@b@e@h@l@n@o@q@x@yADAIAOAUA^A`AeAfAlAnAoArAsAtAyA}B?B@BD_??B?"},
  {0,NULL,"E?J?L?P?Z?f?l?m?p?q?r?s?z@F@H@M@Y@^@a@g@h@j@p@q@s@v@w@zAJASAXAYA`"},
  {0,NULL,"AeAhAjAkAmArAsAtAwA}B?B@BBBG_??B?G?J?O?P?]?f?i?j?o?t?w?x?y@E@I@O@"},
  {0,NULL,"Q@c@d@g@j@k@q@s@v@w@xA?AJAXAYAZAbAdAgAlAnAoApAqAtAzA{A~B@BBBCBD_?"},
  {0,NULL,"?B?G?J?O?P?]?h?i?k?o?p?r?x?y@?@L@O@Y@[@c@e@i@k@r@s@u@w@xAEAGAYAaA"},
  {0,NULL,"bAcAeAiAjAkAmArAsAuAxAyA|B?BEBH_??B?G?I?K?O?^?g?j?k?p?q?s?v?z@C@H"},
  {0,NULL,"@R@[@]@b@g@j@k@o@q@v@x@yA?AIAMAQAYAZAgAhAkAlAnArAsAuAvAyA|BEBFBGB"},
  {0,NULL,"HBJ_??B?F?J?M?O?`?h?m?n?s?t?u?v?w@@@K@S@X@Z@d@e@h@i@o@r@u@w@x@{AG"},
  {0,NULL,"ANAUAbAcAdAgAhAlAoApArAtAvAwB?B@BCBEBGBI_??B?F?J?M?O?`?f?j?m?t?v?"},
  {0,NULL,"w?x?y@A@I@W@Z@c@d@g@h@m@n@o@r@t@u@~AKANARAWAcAeAfAjAkAmAqAsAuAyA|"},
  {0,NULL,"A}A~BABDBFBJ_??C?D?S?X?Y?]?h?i?n?o?{?}@?@B@E@L@N@S@X@`@e@k@l@x@{@"},
  {0,NULL,"|A?ABAEAGALAMAOA_AeAjAkAmAnApAxA}BEBJ_??C?D?R?T?Y?[?g?l?n?s?|?}@@"},
  {0,NULL,"@C@F@H@P@S@\\@_@g@k@m@s@z@~A@ACAEAFAMARAYA]AdAfAiAmAoAuAvAwAxBDBN_"},
  {0,NULL,"??C?G?Q?T?U?e?f?i?j?z?}?~@?@A@F@J@M@Q@R@c@f@i@j@w@z@{@|A?ACAJAPAQ"},
  {0,NULL,"AVAbAdAeAfAnAoAqAyA{B@BI_??C?E?Q?U?W?\\?g?k?l?p?{?|?}@?@B@L@R@V@_@"},
  {0,NULL,"a@e@h@l@r@z@|@~A@AEAFAOAVA`AcAeAfAlAnAoAqAxAzA~BGBNBOBP_??C?G?R?T"},
  {0,NULL,"?V?b?h?i?k?u?{?|@@@D@E@G@O@S@[@b@f@i@j@w@z@{@|ABAEAGAPAQATAYAdAeA"},
  {0,NULL,"fAiAmAuAyA{B?BJBNBO_??C?F?S?V?X?Z?f?j?m?q?{?|?}@C@F@H@Q@W@X@d@g@h"},
  {0,NULL,"@m@q@z@|A?ACADAJAMANAUAWAeAfAjAkAmApAwB@BHBMBNBOBP_??C?E?Q?U?W?\\?"},
  {0,NULL,"f?l?m?t?{?|@@@B@E@G@V@^@a@d@f@j@l@v@z@|A?A@ACAJAQAVA^A`AgAhAiAjAm"},
  {0,NULL,"ArB?BABBBHBRBS_??C?D?Q?T?X?d?f?i?l?y?~@?@A@D@F@J@M@\\@`@c@f@l@m@n@"},
  {0,NULL,"}@~AAABADAKALA[A\\A]AgAhAiAjAlArAvBABBBEBNBO_??C?F?R?V?W?c?g?j?n?w"},
  {0,NULL,"?~@A@B@D@E@I@U@Z@]@b@g@h@m@q@{@|@}A?ADAIANATAWAXAdAfAiAjAmAuAwA|B"},
  {0,NULL,"DBMBR_??C?F?S?V?X?Z?h?m?n?r?{?}@?@B@F@L@N@W@X@Z@e@h@i@p@zA@AAACAD"},
  {0,NULL,"AHAUAWAaAcAdAgAhAlAoAsAzA|BFBLBQBV_??C?F?Q?W?X?_?f?j?m?q?{?|@@@C@"},
  {0,NULL,"E@G@W@]@a@d@f@i@m@u@}@~AAABAEAKATA[A\\AcAeAfAkAnAoAqAyB@BFBMBQBRBV"},
  {0,NULL,"BW_??C?E?S?U?Y?`?h?k?m?v?~@@@A@C@D@K@T@Y@[@^@e@h@l@r@{@|@~ABAEAGA"},
  {0,NULL,"OASA_A`AdAfAgAlAoAsAzB?BGBLBRBT_??C?E?R?W?Y?^?g?k?l?p?|?}@?@C@F@H"},
  {0,NULL,"@P@V@Y@_@g@h@j@o@{@}A?AAADAIANASAXA^AeAhAkAlAnAtA~BGBHBKBSBTBY_??"},
  {0,NULL,"C?G?Q?T?U?e?g?j?k?x?{?}@?@A@B@L@R@V@b@c@e@i@k@y@{@}A?ACADAIALAQAa"},
  {0,NULL,"AbAgAhAiAjAkArA|BCBJBKBNBRBTBUBVBWBZ_??C?F?Q?W?X?_?g?j?n?w?~@@@C@"},
  {0,NULL,"D@E@K@U@\\@]@d@e@h@i@p@z@~A@AAAEAFAUA\\A`AcAdAgAhAiAjArAwA|BCBLBOBS"},
  {0,NULL,"BTBUBY_??C?G?R?T?V?b?g?j?k?x?{@A@B@D@E@I@O@R@U@b@g@j@k@t@z@~A@ABA"},
  {0,NULL,"EAFAPARAYAZAgAhAkAlAnAtA~BCBIBKBPBQB\\_??C?G?S?U?V?a?h?i?k?u?|?~@@"},
  {0,NULL,"@C@D@K@O@Q@T@[@e@i@k@y@}A@AAACADAHAUAZAaAbAeAiAjAkAmApA{A}BCBJBPB"},
  {0,NULL,"SB\\B]_??C?E?R?W?Y?^?h?k?m?v?~@?@A@C@F@J@T@Y@Z@_@f@j@l@vA?A@AAACAD"},
  {0,NULL,"AHAVAXA]A^AdAfAgAiAmAuAzA{B?BABOBPBQBUBVBWB^_??C?E?S?U?Y?`?f?l?m?"},
  {0,NULL,"t@@@A@B@D@E@I@T@^@`@a@g@h@j@o@{@}@~AAABAKAOASAXAZAeAhAjAkAmApA~BA"},
  {0,NULL,"BHBMBNBQBUBVBXB]B^B__??C?G?S?U?V?a?f?i?j?z?|?}?~@C@F@H@Q@W@[@c@g@"},
  {0,NULL,"j@k@t@}@~A@AAABAKASAYAZAaAdAgAlAnAoAsAvAyBIBKBOBRBUBWBXBYBZB[_??C"},
  {0,NULL,"?F?R?V?W?c?h?m?n?r?~@?@A@B@F@J@U@X@Y@Z@f@i@m@u@{@|@}ABAEAGANAPATA"},
  {0,NULL,"\\AhAkAlAnAoAtB@BEBFBLBNBPBSBUBYBZB\\B]_??C?D?R?T?Y?[?h?i?n?o?{?|?}"},
  {0,NULL,"@@@E@G@N@O@P@S@f@l@m@n@~A@AAACADAHARA[A]A^AhAjAkAlAnAtA}BBBEBFBTB"},
  {0,NULL,"WBXBZB]B^_??C?D?S?X?Y?]?f?i?l?y@?@A@B@D@E@I@M@N@^@`@g@k@m@s@z@|A?"},
  {0,NULL,"ACAEAJAMARAWA_AdAgAiAlAoAsAvBBBDBIBPBTBVBWBYB]Bc_??C?D?Q?T?X?d?g?"},
  {0,NULL,"l?n?s?~@@@C@D@F@K@M@P@\\@]@e@k@l@x@{@}A?ABADAIALA[A_AbAeAfAmAnAoAq"},
  {0,NULL,"AxA}BDBGBPBVBXBYBZB^BcBd_??J?P?R?T?Z?[?f?m?q?s@A@F@G@H@M@Y@Z@^@b@"},
  {0,NULL,"c@f@m@n@uACADAHAJANAPARA[A^AbAfAoAqAuAvAyAzBABFBMBOBPBSBUB_Bb_??J"},
  {0,NULL,"?O?Q?W?\\?]?h?i?o?p?~@?@G@L@M@Y@Z@[@]@c@f@l@n@v@|A?AGAJALANAQA\\A^A"},
  {0,NULL,"`AlAnAqAtAzA{A}BBBFBIBNBPBQBUB_BbBf_??I?K?S?U?`?c?g?n?t?w?}@B@I@K"},
  {0,NULL,"@N@P@Q@R@V@X@e@h@p@r@{@|AGAIAQASAWA_A`AaAhAjApArAwAxA~BCBEBLBNBQB"},
  {0,NULL,"VBWB[B`_??H?K?S?Y?_?`?g?j?v?w?}@C@I@K@N@P@Q@R@W@_@g@h@o@q@~AAAFAK"},
  {0,NULL,"AMAOAUAXAZA]AdAfAsAuAyA|BDBGBKBMBOBSBYBZB\\Ba_??H?M?R?V?\\?b?f?l?t?"},
  {0,NULL,"u?|@F@G@I@M@P@Q@W@Z@_@g@j@o@t@zA@AFAJANAPARAUAZA^AeAmApAuAvAxAyA~"},
  {0,NULL,"BABMBOBRBSBTBZBaBfBi_??I?L?Q?X?_?b?h?k?q?u?{@?@G@K@M@N@R@V@X@Y@e@"},
  {0,NULL,"i@p@y@zAEAFAGALAMAQAUA\\A`AeAkApAqAzA{A}A~BCBFBNBQBRBWBXB[BgBh_??H"},
  {0,NULL,"?P?R?Y?[?_?f?j?o?q@A@E@G@H@U@Y@^@`@b@c@g@m@q@s@~AEAFAKAMAOATAXAYA"},
  {0,NULL,"]AjAkApAtAwB@BBBCBHBIBVBXB]B`BcBd_??I?K?S?X?Z?^?g?k?p?q@C@D@H@L@T"},
  {0,NULL,"@[@\\@]@`@b@e@h@p@rAAADAHAIASAWA[A_AaAcAeAfApAqAwAxAzA{A~BCBSBYBZB"},
  {0,NULL,"\\B^Be_??I?O?Q?U?[?\\?h?n?o?t?~@@@G@L@T@Z@[@\\@]@c@e@l@r@x@~A@AFAHAO"},
  {0,NULL,"AVAZA[AbAcAjAmApArAwAxB?BEBJBLBTBYB\\B^BcBeBm_??H?K?S?V?Z?\\?g?l?p?"},
  {0,NULL,"r@B@D@H@L@U@[@\\@^@`@b@g@h@o@q@z@|AFAJAMANAOAPAUAZAhAlAsAtA|BBBDBG"},
  {0,NULL,"BHBKBQBVBWB]B`BdBl_??I?N?S?X?]?b?g?k?x?y@C@D@I@L@T@W@[@\\@]@_@e@k@"},
  {0,NULL,"x@yABAEAFAGALAMAOAUAZA\\AgAiArAsA|B?BDBGBJBKBYB\\B]B^BdBeBiBnBo_??J"},
  {0,NULL,"?M?R?W?^?a?f?i?p?z?|@E@H@J@O@S@U@`@a@d@f@j@v@wA@AAAHAKATAVAXAYA]A"},
  {0,NULL,"cAeAnAqAtA{A}B@BBBHBIBRBTBXBZBaBcBl_??J?L?Q?T?Z?e?h?m?r?x?{@@@J@L"},
  {0,NULL,"@O@S@T@\\@a@d@f@i@u@w@zACAHAJAPARAVA[AbAcAhAkArAtB?B@BEBHBJBLBRBTB"},
  {0,NULL,"WBXB[BcBnBq_??J?M?R?T?`?b?f?m?t?x@A@F@G@I@M@P@W@Y@Z@c@f@j@v@w@{AB"},
  {0,NULL,"AGAKALAQATAXAYA]AgAhArAtB?B@BBBHBIBLBPBUB]B_B`BbBgBl_??J?O?Q?T?`?"},
  {0,NULL,"d?h?m?s?v?{@@@J@K@O@R@S@X@a@d@f@l@n@v@~ABAGAKALAQAYA\\A]A`AfAmAqAu"},
  {0,NULL,"AzA{A}BABFBMBRBTBXBYBcBeBkBq_??H?M?R?Y?^?e?f?j?v?z@A@E@H@J@S@U@^@"},
  {0,NULL,"`@b@d@g@j@o@t@{A?AIAJANAPARASA^A_AdAgAsAuAvAyA|BABKBMBPBVB]B_B`Bd"},
  {0,NULL,"BfBo_??H?N?S?Y?]?e?g?j?o?x?}@C@I@L@P@Q@T@W@]@_@g@k@s@tA?ACAIAJARA"},
  {0,NULL,"SAWA^A_AaAkAnApAtAwAxA~B@BCBIBNBOBSBZB[BaBhBjBm_??I?O?Q?X?^?d?h?k"},
  {0,NULL,"?v?y?{@?@J@K@N@O@R@V@X@d@e@l@r@xA?ADAHAIAVAWA[A_AbAcAgAlArAsB?BEB"},
  {0,NULL,"GBJBKBLBNBQBUBWB[B_BhBr_??I?L?Q?U?c?e?h?n?r?z?~@@@J@L@S@T@[@\\@]@a"},
  {0,NULL,"@e@i@p@y@{@}AGAIALAQASA\\A`AaAdAoAqAsAzA{A|A}BDBFBPBYB\\B^BbBeBgBmB"},
  {0,NULL,"pBt_??H?N?S?V?a?d?g?l?s?u@B@D@H@K@U@V@X@^@`@b@g@k@s@t@}ABAIAKASAT"},
  {0,NULL,"AWAYA_AaAiAmApAuAvAwAxA~BABCBVB]B^B`BdBeBhBlBmBu_??I?N?S?U?[?a?g?"},
  {0,NULL,"n?s?z?}@B@H@K@N@R@U@V@X@^@e@k@x@yA@ACAFAHAMAOAUAVAZAbAnAoAqAsA|A}"},
  {0,NULL,"BDBFBGBKBNBOBQBWB[BaBiBkBoBw_??H?P?R?V?c?d?f?l?r?y?|@F@I@J@O@P@Q@"},
  {0,NULL,"W@_@a@g@m@q@s@}ADAIAKATAWAXAYA]AaAlAoAsAtB@BBBDBGBHBIBOBSBUBZBaBb"},
  {0,NULL,"BiBqBsBv_??J?L?Q?W?_?a?h?i?u?w?~@?@G@K@M@N@V@Y@Z@c@f@i@u@w@}AAAHA"},
  {0,NULL,"KATAVAXA[AbAcAdAiArAuAvAyB?BEBJBLBPBUB\\B^B_BbBfBnBsBw_??J?P?R?W?]"},
  {0,NULL,"?c?f?i?w?y?|@E@I@J@O@Q@S@_@a@d@f@m@n@u@|AEAGAJANAPARA\\A^A`AiAjArA"},
  {0,NULL,"uAvAyBABEBJBMBRBTBVBXBcBdBjBrBtBu_??J?O?Q?T?`?d?g?l?p?s@@@D@I@K@M"},
  {0,NULL,"@O@P@R@]@a@g@h@n@o@z@~AIAKAQARAWAYA`AcAhAlArAtAvAwBGBHBKBLBOBQBUB"},
  {0,NULL,"\\B]B`BgBhBiBrBsBwByB{_??I?N?S?U?[?a?f?i?y?z?|?}@G@H@N@V@W@[@^@c@f"},
  {0,NULL,"@m@n@y@|ACAHAKAMAOAQATAVAWAiAjApArAvAwA{B@BABEBPBSBTB^BcBdBfBhBlB"},
  {0,NULL,"nBpBqByB|_??J?M?R?T?`?b?g?k?p?x@A@D@I@K@M@O@P@R@U@Y@e@h@r@w@{ADAF"},
  {0,NULL,"AGALANAUAXA]AbAeAfAqAuAxAzA|A~BJBMBRBVBYBZB[BeBfBhBiBjBkBpBqBt_??"},
  {0,NULL,"H?K?S?V?Z?\\?h?m?r?v?{@B@G@L@N@W@Z@[@^@b@f@l@q@v@|ABAHAJAOAPATAZA["},
  {0,NULL,"A_AfAmApAuAxAzA{B@BABEBNBRBSBTBYBbBfBgBiBjBmBnBrByC?_??I?L?Q?X?_?"},
  {0,NULL,"b?f?j?q?z?{@E@G@I@M@N@R@W@]@a@g@j@p@t@zA?AFAKALAMAQAVAWAXAdAgArAs"},
  {0,NULL,"AvAwAyB?BHBKBPBSBTB\\B]BdBiBjBlBpBsBwBxB|B~C?_??H?P?R?Y?[?_?h?n?o?"},
  {0,NULL,"r@@@E@G@K@N@O@P@U@Y@^@e@i@p@s@{AEAFAHAOAPATAXA_AbAdAoAsAuAxAyAzA|"},
  {0,NULL,"BFBJBNBOBRBYB\\BbBfBiBkBnBuBzB{B|C@CA_??J?P?R?W?]?c?g?n?s?w@B@E@I@"},
  {0,NULL,"L@S@Z@]@_@a@b@e@k@u@xA@AEAGAIARAYA^A`AaAcAnAoAqAtA}BCBDBGBIBLBNBO"},
  {0,NULL,"BQB\\B]BbBfBgBhBpBqBvBxB{B~_??H?P?R?V?c?d?h?n?o?r?~@F@J@K@O@P@Q@U@"},
  {0,NULL,"X@Y@e@l@q@xA@ADAGAIAUAYA]A^A`AaAjAmApAuAxAzA|BABEBJBVBWB^B_BcBeBh"},
  {0,NULL,"BjBlBtBwBxByB}C@_??I?K?S?U?`?c?f?m?q?t@A@B@I@J@Q@R@T@X@`@a@f@m@r@"},
  {0,NULL,"u@|ACAGAKAMAQAVAWA]AaAfAoAqAsAyB?BBBDBFBMBPBSBTBYBbBdBiBmBsBtBxBz"},
  {0,NULL,"B{B}CB_??I?O?Q?X?^?d?f?l?t?y@?@F@H@J@V@X@\\@`@c@d@g@j@o@x@zA?AIAKA"},
  {0,NULL,"MAQAVAWAYAcAeAmApAqA{A~BABDBIBMBPBSBTBZBdBeBkBmBnBqBtBuByB{C?CF_?"},
  {0,NULL,"?H?K?S?Y?_?`?h?m?r?v@@@C@G@K@N@P@W@Y@[@^@f@i@o@uAAACAGAKAMAQAUA]A"},
  {0,NULL,"^AaAhAkApAtA{B@BABCBEBLBWBXB^B_B`BcBhBkBlBoBsBtBvB|C?CE_??I?K?S?X"},
  {0,NULL,"?Z?^?f?m?q?t@C@F@H@J@Q@T@X@\\@`@d@f@j@p@vAAABAHAJAPASAZA[A\\A_AgAhA"},
  {0,NULL,"rAsAyB?BBBFBHBKBUBWBXB_B`BaBfBhBoBpBqBrBuBw_??J?L?Q?W?_?a?g?j?w?x"},
  {0,NULL,"?~@C@H@K@U@V@Y@\\@c@d@g@k@t@u@}A?AFAKALAMANAVAXAbAkAnAqAtA}A~BCBDB"},
  {0,NULL,"IBMBVBXBZB[BaBeBgBiBkBlBqBrByBzC@CG_??J?M?R?W?^?a?g?k?p?x?|@C@H@K"},
  {0,NULL,"@O@P@U@V@Y@d@e@k@v@yA@AEAHAIARATAYA_A`AcAgAiArAuAvAxAzA|BJBKBOBQB"},
  {0,NULL,"\\B]B^B_BmBsBuBwByBzB|B}B~CCCE_??H?M?R?V?\\?b?h?k?u?v?{?|@G@L@S@W@Z"},
  {0,NULL,"@[@_@b@e@l@r@tA@ADAFAGALANAUA]A^AaAgAlAsAtA}B?BBBCBGBLBQBWB]B^B_B"},
  {0,NULL,"cBgBkBnBoBpBsBuB{CDCH_??J?O?Q?W?\\?]?g?l?p?s@?@B@I@L@M@R@Z@]@_@a@g"},
  {0,NULL,"@k@s@v@}A?AFAJALANAXAZA\\AbAiAmArAuAvAwAxBHBJBKBTBVBZB[BdBeBjBnBoB"},
  {0,NULL,"pBtBvB|B}C@CB_??H?N?S?V?a?d?h?i?o?u?~@D@J@K@O@Q@T@U@X@`@f@l@n@t@|"},
  {0,NULL,"ABAHAKAOAPATAVAWA_AlAnAsAtAyA}B?BBBFBGBNBRBUBYBaBbBoBqBtBvBwBzB{B"},
  {0,NULL,"|CCCFCI_??I?O?Q?U?[?\\?f?l?t?y?|@@@G@H@V@[@\\@^@c@d@g@m@r@s@}@~AFAJ"},
  {0,NULL,"ANASAZA[A\\AbAlAoAqAsA~BBBDBFBIBMBOBQBUBXB`BaBfBgBjBlBoBwBxBzCICJ_"},
  {0,NULL,"??H?M?R?Y?^?e?h?k?u?v@?@A@J@L@S@T@Z@_@`@b@e@i@o@y@{AEAHAIAOAPARAT"},
  {0,NULL,"A_AcAeAkApAtA{A}B@BCBGBLBNBRBYBZB[BbBjBlBmBqBrBvBwBxCACDCN_??I?L?"},
  {0,NULL,"Q?U?c?e?f?j?q?z?~@A@I@J@M@Q@R@T@]@a@g@m@q@y@}@~AIAJARASAZA[A\\A`Aj"},
  {0,NULL,"AkApArAvAwB@BEBHBKBUBVBXB[B`BaBhBkBnBrBuBvB{B}B~CICM_??H?N?S?Y?]?"},
  {0,NULL,"e?h?i?o?u?}@?@J@L@Q@S@T@X@_@`@f@i@s@wAAACAGAJASAUA\\A]A^AaAdAiAsAu"},
  {0,NULL,"AyA|B?BBBFBJBPBWB^B_BcBdBgBiBpBrBuBxByB}CECFCICL_??I?N?S?X?]?b?f?"},
  {0,NULL,"i?y?z@D@E@G@I@M@N@W@[@]@^@f@j@w@xAAABAGAJASAUAZA[A\\A^AeAnApAqA{A~"},
  {0,NULL,"B@BABEBIBNBRBUBXB`BaBgBjBkBmBsBvBzB}CACHCOCQ_??J?L?Q?T?Z?e?g?j?w?"},
  {0,NULL,"x?{?}@H@L@S@V@\\@b@c@d@g@h@q@w@z@~AIAJARASAYA[A`AcAdAfAqAuAzA|A~BD"},
  {0,NULL,"BIBMBOBPBQBSB\\B]BfBmBoBtBuBvBxB|CDCGCKCO_??J?P?R?T?Z?[?g?n?s?w?}@"},
  {0,NULL,"F@H@L@S@Z@\\@_@b@c@e@h@n@p@{ADAFAHALANAOAPAXAbAhAjArAtAwA}BCBGBHBL"},
  {0,NULL,"BVBWBZB[BcBeBlBmBnBoBrBsBzB}CJCLCMCP_??J?P?S?X?Z?]?f?i?w?y@D@E@I@"},
  {0,NULL,"K@M@N@O@Q@^@d@e@h@n@pAAADAHAKALAOAWAXAaAcAeAjArAsAyA}BGBHBJBMBNBS"},
  {0,NULL,"BUB\\B^B`BfBhBiBpBqBwB{B|B~C?C@CBCCCDCICN_??J?L?S?V?Z?a?h?i?u?w?~@"},
  {0,NULL,"D@I@K@M@N@O@Q@T@Z@g@h@q@w@z@|AGAJAMANASAUAYA`AdAlApAuAvAzA~BEBIBL"},
  {0,NULL,"BRBVBWBYBaBdBgBhBiBjBkBrByB}B~C@CACECJCQCRCS_??I?O?R?Y?[?^?h?n?o?"},
  {0,NULL,"t@@@E@G@I@N@O@P@T@Z@]@g@j@o@x@{A?AGAIAMANAQASAYA^AdAmApAtAwA{B?BD"},
  {0,NULL,"BIBLBNBOBRBVB_B`BgBhBjBlBsBvBwBxB~CBCDCECHCOCPCSCW_??I?K?R?W?^?c?"},
  {0,NULL,"g?k?p?q?|@C@G@H@P@V@Y@[@]@b@f@m@r@u@|AEAFAGAMANAPAVA\\A]AfAiAqAtAw"},
  {0,NULL,"A{B?BBBCBDBOBQBRBVBXB_BfBgBhBkBlBoBpBqC?C@CDCHCICJCLCOCX_??H?M?Q?"},
  {0,NULL,"U?\\?e?f?l?t?u?|@@@G@K@M@P@Q@V@^@d@e@i@o@y@{@}AIAKALAOAQATAaAcAeAo"},
  {0,NULL,"ApArAvAxAyB@BGBLBPBQBXB^B`BeBhBkBnBsBuByB{B|B~C?CCCGCHCKCLCQCV_??"},
  {0,NULL,"H?N?Q?T?d?e?g?j?o?x?{?}@G@L@P@V@W@]@b@c@f@l@n@t@~ABAFAKALAOAPAVA\\"},
  {0,NULL,"A]AfAnArAtAwAxAyB?B@BGBPBQBXB]BcBeBgBiBlBnBpBrBsByB~C?CACBCJCLCRC"},
  {0,NULL,"UCYCZ_??I?O?R?Y?[?^?h?k?v?y@?@A@I@J@N@O@R@T@Z@_@g@m@r@s@~AEAFAGAM"},
  {0,NULL,"ANASAYA\\A]AkAlAsAuA~BEBFBJBKBMBYBZB]BbBcBdBiBkBnBpBtBuB{B}C@CCCFC"},
  {0,NULL,"GCLCMCQCRCW_??J?O?S?Y?]?`?h?m?s?v@@@C@H@K@S@X@Y@[@^@d@g@k@s@vA?AC"},
  {0,NULL,"AHAJARAWAXAZA_AbAkAmAsAuA}BFBHBJBKBMBNBOBSB^B_B`BfBgBiBrBuBwByBzB"},
  {0,NULL,"~CACCCICJCKCOCRCV_??H?P?Q?X?_?d?f?l?r?y@?@F@J@L@W@\\@_@`@a@c@e@i@p"},
  {0,NULL,"@s@zAEAFAJAPAUA\\A_A`AbAeAoArAsAxAyB@BGBHBJBPBQBWBXBdBeBjBlBoBpBrB"},
  {0,NULL,"wBxB}CBCECICMCOCPCRCUC[_??I?K?R?W?^?c?g?n?t?w@B@E@G@I@N@P@V@Z@]@b"},
  {0,NULL,"@f@j@p@vA@AAAFAHAPAVAXAZA\\A]AhAnArAuAxAyA~BEBFBKBTBZB\\B]BbBcBiBjB"},
  {0,NULL,"mBnBsBzB|B}CACBCCCFCKCMCSCUC[C\\_??H?K?Q?W?\\?_?g?j?v?w?~@C@J@K@Q@R"},
  {0,NULL,"@U@\\@_@d@f@l@q@v@|A?AIAJAQATA[A^A_A`AfAnArAuAxAyB@BEBGBKBPBQBVBXB"},
  {0,NULL,"_BeBhBoBtBuBvBwB|B}CECHCICKCMCNCQCTCZC^_??J?O?S?Y?]?`?h?i?o?p?}@?"},
  {0,NULL,"@H@L@S@X@Y@[@`@c@g@h@n@o@~AAAHAKAOARAWAXAZAcAdAlApAtAvAwAzA{BIBLB"},
  {0,NULL,"WBYBZBaBcBdBlBmBnBoBqBtBvB|C?CGCHCMCNCPCTCU_??H?K?Q?W?\\?_?g?l?p?r"},
  {0,NULL,"@?@B@J@L@R@U@\\@_@`@a@f@i@o@u@}AAAIAKAQATA[A^AaAcAhAiAqAtA{A|BABBB"},
  {0,NULL,"CBDBTBUBZB[B\\BbBgBiBmBqBrBxByB{B~CACDCFCGCJCPCR_??H?N?Q?T?d?e?g?l"},
  {0,NULL,"?s?u@@@D@G@K@M@P@V@]@^@b@f@i@s@w@zACAFAJAPAUAVA\\A]AbAhAiAqAuA|A~B"},
  {0,NULL,"ABBBCBFBOBRBTBUB[B\\BfBjBkBoBtBvBzB|C@CCCHCMCNCOCSCTCYC__??I?L?R?V"},
  {0,NULL,"?b?c?h?k?q?u?{?|@G@H@S@V@X@Y@[@b@g@m@q@y@}ADAHAIARATAWAXAZA[AkAlA"},
  {0,NULL,"pAuAvAzA~BEBFBKBSBZB]B^BbBcBfBjBlBmBwBxByB|C?CACBCECKCOCPCTC]C_Ca"},
  {0,NULL,"_??H?M?Q?U?\\?e?f?j?v?z?~@A@J@K@M@Q@R@U@^@d@e@l@r@t@~A@AFAKALAOAVA"},
  {0,NULL,"]AaAcAgAjAqAsA|A}BABBBCBMBTBUBYB[B\\BaBiBjBlBqBtBwBxBzC@CBCECFCJCN"},
  {0,NULL,"COCPCVCbCc_??I?L?R?V?b?c?h?n?r?z?~@F@H@J@S@U@X@Y@[@\\@g@j@p@t@zA@A"},
  {0,NULL,"FAHAPARAVAWAXAZAdAmAsAtAwA{A}B?BDBHBOBRBVBWB_BaBkBnBoBqBrBuBzB{CC"},
  {0,NULL,"CGCICJCLCNCQCUCYC]Ca_??H?P?Q?X?_?d?f?j?o?q?{@E@G@L@W@]@`@a@b@c@e@"},
  {0,NULL,"l@q@xA?ADAIAJAUA[A^A_A`AbAgAjApAqAzA|BABBBCBIBNBSBTBUB[B\\BfBgBkBm"},
  {0,NULL,"BnBuBvB{CACCCDCGCLCQCSCTCbCc_??J?L?S?V?Z?a?h?m?r?x?{@B@I@L@N@O@T@"},
  {0,NULL,"W@Z@a@g@k@t@u@}ABAGAKALAMANASAYAaAkAmAsAtA}B?BDBHBJBMBNBSB]B^B`Bb"},
  {0,NULL,"BoBpBsBtBvBxB{B|CBCDCFCHCLCMCNCTCVCXC\\_??I?N?R?T?[?b?g?n?s?z?}@F@"},
  {0,NULL,"H@J@R@S@U@X@\\@_@f@j@w@x@{ABAGAIAQASATAYA[A^AhAnAqAuA|A~BABEBFBKBP"},
  {0,NULL,"BZB]BbBcBeBfBhBpBqBtBuBxByC?C@CDCECGCICRCTC\\C`CbCd_??J?M?S?U?`?a?"},
  {0,NULL,"f?m?t?x@A@B@I@L@T@W@Z@`@a@c@e@k@v@yA@ACAHAJARAUAZA_A`AbAgAoApArAv"},
  {0,NULL,"AxAzB@BIBLBTBWBYB[BaBdBfBhBjBnBpBqBrBvC?C@CACDCICMCPCQCWC^CaCg_??"},
  {0,NULL,"J?M?S?U?`?a?f?i?p?z?|?}@H@L@S@W@[@`@a@c@e@h@r@w@{@|AGAJANASAUA_A`"},
  {0,NULL,"AbAeAjAqAsA|A}BBBHBJBMBNBPBQBSB^B`BgBmBoBsBuBxBzB}CFCKCLCOCRCSCTC"},
  {0,NULL,"UC]C^CgCh_??I?N?R?T?[?b?g?k?x?y@A@D@I@J@O@R@T@U@\\@_@f@m@n@yACADAH"},
  {0,NULL,"AIAQARATAWA[A^AfAiArAtAwA{B?B@BDBGBOBRBUBVB[B_BmBrBsBvBwBzB{B}B~C"},
  {0,NULL,"FCKCNCPCQCSCUCXC`CbCf_??J?P?S?X?Z?]?f?m?q?s@C@F@H@K@M@Q@X@Y@^@d@e"},
  {0,NULL,"@k@u@xABAEAGAKALAMAOAYAaAcAgAoApAqAvAzBABCBIBLBWBXBYBaBdBeBkBlBmB"},
  {0,NULL,"sBtByBzB}CECFCGCHCJCKCSCUCWCZCaCe_??D?K?T?Z?[?\\?i?o?p?q?{?|?}@G@M"},
  {0,NULL,"@N@O@P@Q@R@h@n@o@p@z@{@|AFALAMANAOAPAQAdAeAfApAvAwAxAyAzA{BNBOBPB"},
  {0,NULL,"QBRBSBfBgBhBiBjBkB~C?C@CACBCCCVCWCXCYCZC[_??G?P?U?[?_?a?k?q?s?u?|"},
  {0,NULL,"@@@C@K@O@Q@R@T@_@a@m@n@q@y@|@~AEAKAMAOAQATAYA`AfAlAoAuAvAyAzBFBGB"},
  {0,NULL,"KBOBQBRBXBYBaBiBkBtBzB{B}B~CCCFCKCNCQCWCZC\\C`ClCmCn_??F?M?X?Z?^?e"},
  {0,NULL,"?n?p?r?z?}@?@F@L@M@N@P@W@Z@]@j@p@t@v@{A?ABAJALANAPASA\\A_AeAmAnAtA"},
  {0,NULL,"wAxA{A}B@BHBNBPBSBZBbBeBgBjBmBsBvBxCACBCMCPCSCUCXC[C^C_ChCkCn_??G"},
  {0,NULL,"?O?V?\\?]?b?j?o?t?x?{@B@E@I@O@Q@R@U@X@d@l@n@r@t@|A?ADAGALANAQAWA^A"},
  {0,NULL,"aAfAjAmArAwAxAyB?BJBMBNBRBSBTBVB[BhBjBtBvBwB}C@CBCECFCMCNCVCXC`Ce"},
  {0,NULL,"ChClCn_??E?L?Y?Z?^?e?l?p?r?z?}@?@F@H@M@N@P@V@Y@^@i@o@u@y@zACAEAHA"},
  {0,NULL,"MAOAPARAVAcAdAiAoAqAvAzA{A|BABDBOBPBQBWB_BdBfBkBoBuBzB|C?CCCGCHCK"},
  {0,NULL,"CTCYCZCaCcCfCmCn_??E?P?U?Z?[?\\?k?o?p?q?{?|?}@L@O@Q@R@T@_@a@m@r@s@"},
  {0,NULL,"u@}ACADAJANASA[A^AaAbAiAjAkAtAwB?BBBCBHBJBSBTBZB[B^BcBmBnBrBvB{B}"},
  {0,NULL,"CFCLCMCQCRCUC\\CbCgChCkClCq_??F?O?V?Z?[?\\?j?o?p?q?{?|?}@H@O@Q@R@U@"},
  {0,NULL,"X@d@l@q@v@x@~A@ABAHAOATAYAZA[AcAgAlAnAqAzA|BBBFBIBKBQBWBXB]BaBcBl"},
  {0,NULL,"BoBqBtBwBzCECICKCNCOCTC`CaCdCeCiCmCo_??D?K?T?`?c?d?i?v?w?y?~@A@D@"},
  {0,NULL,"J@S@[@\\@`@b@c@h@n@o@p@z@{@|AIAPAQARAWA_A`AdAeAfAsAyA{A}BDBGBMBPBR"},
  {0,NULL,"BVBYBdBeBmBoBtBuBxB}CFCGCNCPCTCUC^C`CaCfCkCl_??E?N?W?\\?]?b?m?o?t?"},
  {0,NULL,"x?{@B@E@G@U@V@X@Y@^@d@k@s@v@y@}ABAEAFALAOATAXAZA\\AkAnAoApAxAzA~B@"},
  {0,NULL,"BFBIBNBQBXB]B`BbBgBkBlBsByBzCACCCJCKCOCSCZC[C]C_CdCmCt_??E?N?W?^?"},
  {0,NULL,"a?d?m?s?v?z?~@C@F@J@T@W@Z@]@_@a@k@s@v@y@}ABAEAIASATAYA\\A_A`AkAnAo"},
  {0,NULL,"AsA}B@BFBGBHBKBXBYBZBaBbBeBpBqBtBvBxB{CDCICMCNCPCQC\\C^C`ChCiCjCoC"},
  {0,NULL,"p_??F?M?X?_?`?b?n?t?u?w@@@D@E@K@S@U@X@\\@`@d@j@p@t@v@{A?ABAKALAQAT"},
  {0,NULL,"AWAXA_AeAmAnAuAxAyA}A~BFBMBNBRBVBXB`BeBhBkBqBtBuByC@CCCGCICJCNCVC"},
  {0,NULL,"ZC]C`CfCiCqCuCv_??G?P?U?]?c?e?k?r?x?y@?@A@B@L@V@Y@[@^@b@c@m@n@q@y"},
  {0,NULL,"@|@~AEAJAOAPARAZA\\A`AfAlAoAtAzA{B@BDBGBIBPBQBYB]BbBdBfBgBlBoBpBxC"},
  {0,NULL,"?CACDCOCPCTCYC[C^CaCdCjCrCuCv_??G?K?T?_?`?b?i?t?u?w@@@D@E@G@S@[@\\"},
  {0,NULL,"@`@b@c@h@q@r@w@~AAADAFAUAXAZA[A]AbAhAjAlApA~BBBCBEBIBLBUB\\B]B^B`B"},
  {0,NULL,"cBlBmBnBoBsB|CHCLCOCSCTCUC_CaCcCdCgCk_??D?M?X?^?a?d?n?s?v?z?~@C@F"},
  {0,NULL,"@K@M@N@P@W@Z@]@j@o@w@x@zA@AAAKAMAUAVAYA]AcAdAgAhAuAvA|BABEBKBLBOB"},
  {0,NULL,"UBWB\\B_BaBiBjBsBwBzB|B~CBCECHCKCSCWCXC_CcCeCmCr_??F?N?W?]?c?e?m?r"},
  {0,NULL,"?x?y@?@A@B@J@U@V@X@Y@^@d@k@t@u@xA?A@ACAIARAVAWA^AaAcAgAiAmAsA|B?B"},
  {0,NULL,"ABDBJBMBTBVBWB[B_BdBrBuBwByBzB}CECFCGCJCKCRC]CbCeCfClCmCqCr_??E?L"},
  {0,NULL,"?Y?_?`?b?l?t?u?w@@@D@E@I@S@T@\\@_@`@a@i@o@u@y@zACAEAGAMAQARAUA^A`A"},
  {0,NULL,"dAiAoArAvAyB?BDBGBLBOBRBTBYB\\BdBiBjBpBrBxB}B~CBCDCFCPCRCWCXC^CbCj"},
  {0,NULL,"ClCoCu_??G?K?T?Z?^?e?i?p?r?z?}@?@F@J@M@N@O@P@Q@R@h@q@r@w@~AAADAIA"},
  {0,NULL,"SAYA[A]AaAcAhAjAlAsA|BBBEBHBJBKBUBWBZB[BaBcBhBiBqBrBwB{B~C@CECICQ"},
  {0,NULL,"CRCVCWC\\CbCeCiCsCtC{_??G?O?V?^?a?d?j?s?v?z?~@C@F@H@W@Z@[@]@b@c@l@"},
  {0,NULL,"n@r@t@|A?ADAHANAPAVAWA_AbAfAjAmAqAwA{A}BABCBMBPBSBVB^B_BeBfBgBmBn"},
  {0,NULL,"BuByC?CACGCJCLCUCYC[C]CfCgCkCpCu_??F?O?V?`?c?d?j?v?w?y?~@A@D@I@W@"},
  {0,NULL,"Z@[@]@b@c@l@q@v@x@~A@ABAGAUAYAZA\\A]A`AgAlAnArB@BEBGBIBKBLBUBYB\\B]"},
  {0,NULL,"BaBbBgBiBnBpBsB{B~CACDCLCQCSCWC[C\\C_CgCjCwCyCzC{_??D?L?Y?]?c?e?l?"},
  {0,NULL,"r?x?y@?@A@B@I@M@N@P@V@Y@^@i@p@s@w@{@}AAAGALASAXA\\A]AaAeAhAkArAxA~"},
  {0,NULL,"B@BEBHBJBNBUBZB[B`BbBhBkBsBvB{B|C@CCCHCMCQCSCVCZC\\C_CcChCpCvC~_??"},
  {0,NULL,"D?M?X?\\?]?b?n?o?t?x?{@B@E@L@S@U@X@\\@`@d@j@o@w@x@zA@AAAJARAUAZA[A^"},
  {0,NULL,"AcAdAgAhAtA|B?BBBDBIBLBTBWB\\B]BcBdBnBoBpBqBrBuCDCGCICLCRCTCaCbCfC"},
  {0,NULL,"gCiCjCtCzC|C}_??F?N?W?[?_?a?m?q?s?u?|@@@C@G@T@W@Z@]@_@a@k@t@u@xA?"},
  {0,NULL,"A@ACAFAMANAUAVA^AbAgAiAmApAvAwB?BABCBLBOBSBTB\\B^B_BfBjBnBpBvB|C?C"},
  {0,NULL,"BCDCHCLCMCXCYCcCgChCjCsC{C}D?_??E?P?U?`?c?d?k?v?w?y?~@A@D@K@V@Y@["},
  {0,NULL,"@^@b@c@m@r@s@u@}ACADAKAVAWAXA]AaAbAiAjAkAuA~BABCBEBJBMBUBVB[B^B_B"},
  {0,NULL,"`BfBhBlBwByB|C?C@CECHCJCOCVCYC]CcCdCeCzC|D?DA_??D?L?Y?[?_?a?l?q?s"},
  {0,NULL,"?u?|@@@C@H@S@T@\\@_@`@a@i@p@s@w@{@}AAAHASATAXA[A_AbAeAhAkAqA}A~BBB"},
  {0,NULL,"CBFBHBXBZB^B`BcBeBlBmBqBrBxByCICJCOCPCRCUC]C^CbCdCiCkCsCwCxCz_??D"},
  {0,NULL,"?K?T?`?c?d?m?q?s?v?{@A@B@J@R@S@X@`@a@b@k@o@u@x@{@}ABAIAPARAZA[A_A"},
  {0,NULL,"bAgAhAkApAvBABCBEBKBLBNBUB[B]B`BbBfBhBrBuBwByB~CACDCICPCQC]CbCdCg"},
  {0,NULL,"CiCjCnCwCzC|D@DBDDDE_??G?K?T?Z?^?e?m?r?t?x@@@C@F@J@O@P@Q@T@\\@d@k@"},
  {0,NULL,"q@v@yA?ACADAIALAMAQAYA]AaAfAmAoApAxAzA{B@BDBIBOBPBSB^B_BeBmBsBtBv"},
  {0,NULL,"BxB{CECFCGCHCKCTCXCZC`ChClCmCnCoCpCqCrCwCzC|_??F?N?W?[?_?a?i?u?w?"},
  {0,NULL,"y?|?}@?@G@N@V@W@Z@_@c@h@n@p@t@~A@AAAFANASAUA\\A^A`AeAlAnAsAyA}A~BF"},
  {0,NULL,"BGBMBQBWBXBZBaBcBgBiBjBkBzB}CJCLCOCRCSCUCWC[C\\C^C_CkCnCoCpCwCzC|D"},
  {0,NULL,"@DE_??D?M?X?^?a?d?k?v?x?y?{?|@C@K@N@O@P@V@W@d@m@n@o@y@}AAADAKALAM"},
  {0,NULL,"ANAUA\\A]AeAfAkAtA{A}B@BDBGBMBSBXBZB^BcBeBiBkBpBqBtB{C?C@CGCHCJCLC"},
  {0,NULL,"VCYCZC[C\\ChCnCoCpCwD?DADBDDDGDH_??E?P?U?Z?[?\\?n?o?t?w?}?~@F@L@Q@T"},
  {0,NULL,"@Z@\\@_@c@j@p@s@v@zA@ACAJAQASAYA^A`AaAdAnAoAuAxAyAzA~BFBIBOBPBQBWB"},
  {0,NULL,"_BaBfBgBhBjBvBxCDCECICOCRCTCWCXC^C`CiCjCnCoCpCtCwC}DBDDDGDH_??E?N"},
  {0,NULL,"?W?\\?]?b?i?o?p?z?~@D@E@G@M@U@Y@[@]@^@h@r@s@w@z@|AEAFAOATAVAWAXAcA"},
  {0,NULL,"dAiAjAsAwA|B?BBBHBJBRBTBVBYB\\BdBlBnBoBpBqB|C?C@CBCCCMCNCVCYCaCcCe"},
  {0,NULL,"CfCnCqCrCwCzC|DBDD_??F?O?V?Z?[?\\?l?p?r?y?|@@@D@H@O@U@[@\\@^@d@i@p@"},
  {0,NULL,"s@v@zA@ACAHAQATAWAYAaAcAeAiAmArAwAxA{B@BHBJBOBRBSBTB\\B^BmBnBqBrBy"},
  {0,NULL,"B{B~C?CACCCGCKCVCZC]CbCfClCnCqCrCsCxC|D@DEDGDK_??D?L?Y?]?c?e?j?o?"},
  {0,NULL,"q?x?~@A@C@I@M@P@Q@T@Y@]@l@q@w@x@{@|A?AGALAMAOAVAXA]AdAfAgAqAzA|B?"},
  {0,NULL,"BBBDBIBPBVBYB_BdBeBgBiBlBpBsBxC@CBCECFCJCRCWCXCYC[CeCmCnCqCrCyC{C"},
  {0,NULL,"|D@DEDGDK_??E?P?U?`?c?d?n?o?t?w?}?~@F@K@P@Q@V@X@Y@c@j@o@u@x@{@}AB"},
  {0,NULL,"AKAOAPAVAXAZAbAdAnAoAtAyB?BDBGBIBLBPBYBZBaBbBeBiBnBsBzB{B|CCCFCGC"},
  {0,NULL,"JCNCUCZC[C_CaCfCmCrCsCuCvCxCyC{D@DM_??F?O?V?`?c?d?l?p?r?y?|@@@D@I"},
  {0,NULL,"@O@P@W@[@]@a@i@o@u@x@{@}ABAGANAPAUAZA\\AbAeAiAmAqA{A|BABDBJBMBRBVB"},
  {0,NULL,"XB^B`BeBjBoBpBtBxB}C@CECHCMCOCSCXCYC^CcChCkCpCtCuC}D?DADCDDDI_??D"},
  {0,NULL,"?M?X?\\?]?b?k?v?x?y?{?|@C@L@S@W@[@\\@_@d@m@r@s@w@z@|AEAJARATAWA[A_A"},
  {0,NULL,"cAeAfAkAuAxA~B@BEBJBMBNBOBQBRBSBXBjBmBrBvBwB}CACKCOCPCSCTC]C^C`Cd"},
  {0,NULL,"CkClCqCsCuCvCxCyC{DEDL_??G?K?T?_?`?b?m?r?t?x@@@C@F@G@P@W@Y@[@\\@c@"},
  {0,NULL,"k@r@t@u@~ABAEAFAPARAZA[A_AbAfAmAoAsAxAyB?BDBJBMBOBRBXBYBaBeBfBiBj"},
  {0,NULL,"BnBpBrC@CACCCICJCOCYC[C]C^CfCjCuCvCxCyC}C~D?DCDNDODP_??F?N?W?]?c?"},
  {0,NULL,"e?i?u?w?y?|?}@?@J@Q@S@V@X@_@d@h@q@w@x@{@|A?AIAOATAVAWAXAcAeAlAnAp"},
  {0,NULL,"A~B@BEBGBIBLBNBPBQBSBZBbBhBqBvBwB{B|C?CDCGCNCPCTCVCZC`CaCdCiCtCuC"},
  {0,NULL,"vCxCyC~DADCDNDP_??G?P?U?]?c?e?n?r?s?z@@@B@E@L@S@[@]@^@a@b@j@q@w@x"},
  {0,NULL,"@{@|A?AJAOAPAVAXAZAbAhAjAmAuA|BABEBHBJBKBNBRBTBVB[B`BnBoBrBuBzB}C"},
  {0,NULL,"ACCCMCQCSCUC]C_CcCfCgCkCoCpCzC|D?DADBDDDFDKDO_??F?M?X?_?`?b?k?p?q"},
  {0,NULL,"?u@?@A@D@K@M@R@U@X@Y@`@m@r@t@u@~ABAEAKARATAWA[A_AcAgAiAlAtAvAwB?B"},
  {0,NULL,"BBCBLBUBYB\\B]BbBdBlBmBsBwByB|B~CBCFCKCNCPCaCbCdCeClCmCoCpCtCzC|C}"},
  {0,NULL,"DBDDDFDK_??D?K?T?Z?[?\\?m?q?s?v?{@A@B@G@M@N@R@Z@^@b@k@p@s@v@zA@ACA"},
  {0,NULL,"FALAMAQAYA]AaAgAhAkAsA}BBBCBFBHBKBTBWB[B]BcBdBkBlBoBsBtBzCBCFCHCL"},
  {0,NULL,"CMCUC\\C_CcCeChCmCsCtCuCvC{C~DADC_??E?N?W?^?a?d?i?o?p?z?~@D@E@J@O@"},
  {0,NULL,"T@U@]@`@a@h@n@o@y@}AAADAIANASAUA\\A^A`AdAiAjApAvAwAzA{A|BABUBVB\\B^"},
  {0,NULL,"B_B`BgBmBuBxByB}B~CECKCQCRCSCWCXCbCgCkClCsCuCvC{C}C~D?DCDO_??E?L?"},
  {0,NULL,"Y?Z?^?e?j?v?w?z?{?}@E@H@N@S@V@^@b@d@l@q@v@yA?ACADAHALAMAOAVAXA]Aj"},
  {0,NULL,"AkAnArA}B@BEBGBHBKBNBSBTBZB[BcBiBlBqBrBwBzC?CACBCJCPCUCVC[C]C_CdC"},
  {0,NULL,"eCpCtCvC}C~D?DADDDIDRDSDU_??G?O?V?^?a?d?l?s?t?u@?@B@F@H@V@X@Z@`@b"},
  {0,NULL,"@c@i@n@o@y@}AAADAHANAPAUAZA\\AbAhAlAoArAvAyBFBGBKBLBUBWBZB[BaBbBfB"},
  {0,NULL,"jBoBwBzB|CICMCNCOCPCUC^C_CaCcCdCjCqCrCwCyCzC{D@DEDFDHDN_??G?O?V?\\"},
  {0,NULL,"?]?b?l?s?t?u@?@B@F@I@M@Q@R@X@Z@_@i@r@s@w@z@|AEAGAQATAWAYAaAcAhAlA"},
  {0,NULL,"oAqA~BBBCBFBIBLBPBQBWB]BbBdBgBhBkBsByB{B~CDCFCGCLCRCWCZC\\CbCiCmCo"},
  {0,NULL,"CtCvC}C~D?DADBDJDRDTDU_??D?L?Y?[?_?a?j?o?q?x?~@A@C@H@T@U@Y@\\@`@c@"},
  {0,NULL,"l@n@p@t@~A@AAAHARASA[A^A_A`AdAfAgArAvAwAxAyAzB?BOBUBYB\\B_BaBfBmBn"},
  {0,NULL,"BuBvB|CCCICKCNCQCTC`CaCfCgCjClCoCtCuC}D?DADBDCDJDQDTDV_??E?L?Y?_?"},
  {0,NULL,"`?b?j?v?w?z?{?}@E@I@N@R@S@W@_@a@l@r@t@u@~ABAEAGARASA[A^A_A`AjAkAn"},
  {0,NULL,"AqA}A~BABCBEBMBNBQBXB]B`BcBhBkBtBuBvB}CDCHCLCQCSCTC\\C`CgChCiCkCqC"},
  {0,NULL,"rCsCwCxCzD@DEDFDHDP_??F?M?X?Z?^?e?k?p?q?u@?@A@D@L@M@T@Z@]@`@b@m@q"},
  {0,NULL,"@v@yA?ACADAJALAMANAUA\\A]AgAiAlAuAvAzA|BBBFBKBUBVBWB[B_BdBfBgBkBoB"},
  {0,NULL,"pBuC@CICLCMCQCRCWCYC\\CcCgCjCrCsCxCyC{C~D@DCDMDUDVDX_??G?P?U?[?_?a"},
  {0,NULL,"?n?r?s?z@@@B@E@K@N@O@R@U@^@a@j@n@p@t@~A@AAAKAQASAYA^A`AaAhAjAmAtA"},
  {0,NULL,"wA{A}BABCBHBTB\\B]B^B`BcBhBlBqBtBxByB~C?CBCDCECHCVCXCbCeChCiCqCsCx"},
  {0,NULL,"CyC{C~DCDEDLDUDVD[_??D?K?W?\\?]?c?i?v?w?y?|?~@C@J@Q@S@[@\\@_@d@k@p@"},
  {0,NULL,"s@v@}A@AAAFALAXAZA\\A]AaAdAgAiAsA{A}BBBCBDBIBOBUB\\B^B_BaBgBiBpBqBx"},
  {0,NULL,"B{CDCICJCLCOCRCVCYC]CbCeCfCnCwCzC|D@DBDDDEDFDGDHDIDJDKDLDM_??G?K?"},
  {0,NULL,"W?^?_?a?i?p?r?z@?@B@E@J@N@O@R@U@`@a@k@r@t@u@|A?AEAFAMANAPAVA_AbAl"},
  {0,NULL,"AnAoAsAvAxAyBEBJBKBNBPBQB]BbBdBoBuBwBzB|B}CBCCCFCKCMCNC\\C^C_C`ChC"},
  {0,NULL,"kCnCoCpCqCrCwCzC|DFDGDHDKDSDTDXD[_??F?N?T?Z?[?e?m?q?s?u@@@A@D@G@M"},
  {0,NULL,"@T@Z@]@^@b@h@q@w@x@{@~ABAIAOASATAYA[AcAeAfAmApAwB?B@BGBHBLBRBVBXB"},
  {0,NULL,"YB`BeBlBmBnBrBsByB~CACPCQCSCUCWCXCZC[ClCmCnCoCpCwCzC|D@DEDFDGDHDK"},
  {0,NULL,"DLDMDSDT_??D?M?U?[?\\?a?n?s?v?z?~@A@B@K@M@N@R@U@Z@^@m@r@s@w@{@|@}A"},
  {0,NULL,"JANASATA[A_AbAdAfAoAuAvAwAxB@BEBLBPBVBYBbBdBeBfBhBnBuByB|C?C@CACC"},
  {0,NULL,"CMCQCWCZC\\C`CiCjCnCoCpCwD?DADBDDDFDIDJDKDSDTDYDZD_D`_??E?P?X?Z?^?"},
  {0,NULL,"d?k?o?p?q?{@D@E@L@O@T@]@`@a@b@j@o@u@x@zABAEAKAMAOAPAVAYAcAeAkAnAt"},
  {0,NULL,"AyB?BGBHBJBKBNBQBRBXB]B`BlBoBpBqBrBwB~CBCDCICNCPCVCXCYC[C^ChCnCoC"},
  {0,NULL,"pCtCwC}DBDDDFDIDJDKDODSDTDWD_D`_??E?N?T?`?b?d?m?o?t?x?{?}@F@G@P@V"},
  {0,NULL,"@W@X@Y@c@h@n@o@y@zACADAIAQARAUAWA^A`AhAjAkApAzA|A~BABFBMBSBTBWBZB"},
  {0,NULL,"[BcBfBhBjBkBtBvC?C@CECGCHCTCaCcCdCgCiCjCnCqCrCwCzC|DBDDDFDGDHDIDJ"},
  {0,NULL,"DKDXD[_??F?O?Y?[?_?`?j?o?p?q?}@?@A@H@R@U@X@Y@`@c@i@o@u@x@{A?ACAGA"},
  {0,NULL,"MANAQAUA^AbAeAkAnAqAyA|BFBJBKBMBNBPBSBZB[BbBfBgBiBkBuBzC@CCCFCGCJ"},
  {0,NULL,"CRC\\C]CbCgCiCkCnCqCrCsCxC|D@DEDFDHDLDMDNDXD[D\\D_Dc_??D?L?V?a?c?d?"},
  {0,NULL,"l?r?x?y?{?|@B@I@N@O@P@V@W@a@l@n@p@t@z@|A@AHAPARAVAWA_A`AgAhAlArAv"},
  {0,NULL,"AxAzA~BABEBQBTBWB]BcBdBhBjBrBwByB}B~C?CACBCECKCWC[C^C_CdCjCnCqCrC"},
  {0,NULL,"yC{C|D@DEDFDHDLDMDPDXD[D]D_Dc_??E?P?X?Z?^?d?k?v?w?y?{@D@E@K@N@O@V"},
  {0,NULL,"@^@b@d@j@p@s@v@zABAEAJAPASAYA\\A_A`AdAgAiAuAzA{A~BABCBIBRBTBYB\\B]B"},
  {0,NULL,"dBkBmBtBuByB}CACCCGCKCSCTCWC\\C_CcCgCmCrCsCuCvCxCyC{D@DLDNDPDUDVD["},
  {0,NULL,"D\\D]De_??F?O?Y?[?_?`?j?v?w?y?}@?@A@I@N@R@W@Z@_@c@i@p@s@v@{A?ACAHA"},
  {0,NULL,"QATAWAXA_AbAdAgAiArAwA{B@BCBIBLBPBVBWB[B_BdBhBlBsBvBwB|C?CBCHCMCP"},
  {0,NULL,"CUCXC^C`CaCjClCpCtCuC}D?DADCDDDJDODRDTDUDWDYDZDa_??D?K?W?\\?]?c?i?"},
  {0,NULL,"o?p?q?|?~@C@G@M@P@Q@Y@[@]@k@o@u@x@}A@AAAIARAZA[A^AaAcAeAkAnApAvAx"},
  {0,NULL,"AyBEBJBKBXBZB^BaBcBeBjBmBnBvB|B}CECHCKCMCQCSCZC_C`CaCdCmCsCtCuCvC"},
  {0,NULL,"{C~DADCDNDODPDQDRDUDVDZ_??E?N?T?`?b?d?m?s?v?z?{?}@F@J@R@S@W@X@_@a"},
  {0,NULL,"@h@r@s@w@zACADAFAUAVAWAXA]AbAdAfAoAsAwB?B@BGBHBLBOBPBQBSBWB_BiBrB"},
  {0,NULL,"sBwBzB{B~CBCFCLCRCUC[C]C^CfCkClCsCuCvC{C}C~D?DCDNDPDQDRDUDVDWDYDg"},
  {0,NULL,"_??F?M?U?`?c?e?n?p?r?z?|?}@@@L@P@S@W@[@]@a@m@r@t@u@~A@ACAKARAVAWA"},
  {0,NULL,"]AaAcAlAnAoAtAvAwAxB@BEBLBOBQBWBXBaBcBhBnBqBrBvB{B~C?CDCHCLCQCYCZ"},
  {0,NULL,"C[CaCfCjCrCsCxCyC{C~D@DCDLDNDPDQDRD[D\\D]DeDhDi_??G?P?X?]?_?b?k?q?"},
  {0,NULL,"s?u@?@C@F@K@M@Q@R@X@Y@_@j@q@w@xA?AAADAJAUAXAZA[A^AbAeAfAmAuAyB?BG"},
  {0,NULL,"BHBJBKBPBSBZB^B_BeBfBiBjBpBwB|C@CBCECICMCRCVC]C^C`CdCiCqCsCxCyC{C"},
  {0,NULL,"~DCDEDMDNDPDQDRDXD\\D]DdDhDi_??G?P?X?]?_?b?k?r?x?y@?@C@F@L@W@Y@[@\\"},
  {0,NULL,"@_@c@j@n@p@tA?AAADAKALAQAWAXA^AaAgAhAlAtAzA{A~BABCBIBUBWBZB[B_BaB"},
  {0,NULL,"gBkBmBsBvB{CGCHCJCLCSCUCaCbCfCgClCmCoCpCzC|D?DADBDDDGDHDIDJDSDTDY"},
  {0,NULL,"DZD^DcDg_??F?M?U?`?c?e?n?t?u?w?|?}@@@K@P@Q@S@V@X@d@m@q@v@y@~A@ACA"},
  {0,NULL,"JARAUAZA\\A]A`AiAjAmAuA|A}BBBDBFBMBOBSBTB\\B^BcBiBjBtBxBzB}CECFCKCO"},
  {0,NULL,"CRCTC]C_CcCdCeCkCoCpCtCzC|C}DBDDDGDHDIDJDODSDTDWD^Dc_??D?M?U?[?\\?"},
  {0,NULL,"a?n?o?t?x?~@A@B@L@T@U@Z@\\@`@c@m@n@o@y@{@|@}AKALAMANAOAQATAhAjAkAt"},
  {0,NULL,"A|A}BBBDBFBMBNBUBVB[B`BbBgBlBoBsBxBzCFCJCNCOCPCUCXCbCeChCkClCqCsC"},
  {0,NULL,"uCvCxCyC{DEDMDNDPDUDVDXD\\D]Dd_??E?L?V?Z?\\?b?l?p?r?z?~@D@F@H@M@U@Y"},
  {0,NULL,"@[@\\@^@l@r@t@u@}ABADAGALANASA[A^AaAlAnAoAqAvAxAzA~BABEBUBYBZBaBbB"},
  {0,NULL,"eBfBgBjBmBxByC@CACECJCOCSCWCbCdCeCiCmCpCtCvC}C~D?DADDDJDODQDTDVDW"},
  {0,NULL,"DYDZDaDhDl_??G?O?Y?]?^?e?j?s?v?z@@@C@E@H@S@[@]@^@b@d@i@r@s@w@~AAA"},
  {0,NULL,"EAGASAYA\\A]AaAcAdAfAoAqAwA{B@BCBIBLBOBRBXBYB\\BaBlBmBqBtBvBxCDCHCO"},
  {0,NULL,"CPCSCTCXCYCaCcCeCmCqCrCwCyCzC{D@DEDGDKDLDMDPDXD[D]D^D`DfDj_??G?K?"},
  {0,NULL,"W?^?_?a?i?t?u?w@?@B@E@G@N@V@Z@`@b@c@k@q@v@y@|A?AEAIAMAQATAYA_A`Ai"},
  {0,NULL,"AjAmApA{A}BBBCBDBIBNBRBTBVB[BdBgBhBkBlBqByC?CACDCGCJCPCWCXCYCbCgC"},
  {0,NULL,"jCuCvCxCyC}C~D?DCDQDRDUDVDWDYD\\D]DfDgDn_??G?O?Y?]?^?e?j?o?t?x@@@C"},
  {0,NULL,"@E@I@O@P@Q@T@]@d@i@n@o@y@~AAAEAHAOAPARAZA\\AcAhAjAkArAyA|BFBJBKBMB"},
  {0,NULL,"XB\\B]B^B`BcBiBnBpBrBuB}B~CCCICKCQCRCVCZC[C\\C]C_CoCtCvC}C~D?DADBDI"},
  {0,NULL,"DODQDSDVDWDYDZDbDhDm_??D?L?V?a?c?d?l?q?s?u?{?|@B@H@S@V@X@`@a@b@l@"},
  {0,NULL,"q@w@x@z@|A@AGAMAUAVAYA]A`AeAfAmAqA}B?BBBDBGBHBNBOBQBRBSBTBkBoBqBt"},
  {0,NULL,"BzB{CDCFCGCLCNCTCYCcCfCgChCkCoCtCuC}D?DADBDCDIDODRDSDUDWDYDZDbDiD"},
  {0,NULL,"mDq_??E?L?V?Z?\\?b?l?t?u?w?~@D@F@I@M@Q@T@Z@\\@_@l@q@v@y@}ABADAHALAO"},
  {0,NULL,"ATAXAZA[AiAjAmArA}B?BBBDBGBHBUBVB^B_B`BeBnBoBpBsB{B|CICLCMCNCQCUC"},
  {0,NULL,"VCZC`CfChClCqCrCsCwCxCzD@DEDGDKDLDMDNDXD[D\\D^D`DkDn_??F?N?T?Z?[?e"},
  {0,NULL,"?m?r?x?y@@@A@D@J@O@T@U@\\@^@d@h@n@p@t@{@~ABAFALANAOAPASA\\AgAhAlAsA"},
  {0,NULL,"zA|A~BABFBMBUBYB\\B]B`BbBfBoBpBtBuBxC@CCCICNCOCTCVC\\CcCeChCiCtCuCv"},
  {0,NULL,"CxCyC~DADCDODQDRDUDVDZD\\D]DfDnDoDr_??C?J?Q?R?T?W?f?h?i?m?{?|@@@E@"},
  {0,NULL,"G@J@O@S@a@d@e@g@h@k@{@}A?ADAFAIALANAXAbAdAgAlAoApAsAvAzBIBLBNBOBP"},
  {0,NULL,"BQBSBUB\\B]B^B_B`BbBfBgBsBuBwBxB{B|B~CBCCCDCKCLCOCTCVCXCZC]CdCgChC"},
  {0,NULL,"kCnCvCzDCDFDGDRDVD^D_DiDu_??C?H?R?S?V?Y?f?g?j?l?|?}@C@F@H@I@P@Q@W"},
  {0,NULL,"@_@e@f@i@l@{@|ABAEAGAHAOAPATA_AgAhAiAjAqArA|BABBBCBPBQBVBWBXB]B^B"},
  {0,NULL,"_B`BcBdBeBhBlBoBpBsBuByB}C?CECHCICKCLCRCUCYCZC[C^C`CiCkCmCrCtD?DE"},
  {0,NULL,"DMDODYD[DeDgDrDt_??C?I?Q?S?U?X?g?h?k?n?{?}@?@B@K@L@N@R@V@X@f@g@j@"},
  {0,NULL,"m@}@~AAABAJAKASAZA[A\\AdAfAiAmAtAuAwA{B?BDBPBSBTBYBZB\\B]B^BbBcBdBe"},
  {0,NULL,"BiBmBnBpBtBxByB|C?CACBCFCGCMCRCTC[C\\C_CaCbCdChCiCpCsCyDBDIDNDTD]D"},
  {0,NULL,"aDfDkDm_??C?H?R?S?V?Y?f?g?j?l@A@B@D@E@H@I@U@^@`@b@e@f@i@lA@AAACAD"},
  {0,NULL,"AGAHAUA]A^AaAeAfAnAoAqArAxAyB@BGBNBOBRBSBTBUBYBZB[B\\BaBbBfBiBjBmB"},
  {0,NULL,"qBvBzB{C@CACCCDCFCNCPCSCVC_CbCcCeCgCjClCqC}D@DADLDWDXDZDdDoDpDs_?"},
  {0,NULL,"?C?J?Q?R?T?W?f?h?i?m?~@?@A@F@G@J@M@Y@Z@c@e@g@h@k@z@~A@AEAFAIARAYA"},
  {0,NULL,"`AcAeAjAkAmApAsA}BHBJBMBRBTBVBWBXBYBZB[BaBcBdBeBjBkBlBnBqBrBtB}C@"},
  {0,NULL,"CECGCJCMCPCQCUCWC\\C^CaCeCfCjCmCuCwC|C~DHDKDQDUD`DcDhDq_??C?I?Q?S?"},
  {0,NULL,"U?X?g?h?k?n?~@@@C@D@K@L@T@[@\\@]@f@g@j@m@z@|A?ACAJAKAMAQAVAWAhAkAl"},
  {0,NULL,"AnAtAuA~BEBFBKBNBOBQBRBUBVBWBXB[B_B`BaBgBhBkBoBrBvBwBzB~CHCICJCNC"},
  {0,NULL,"OCQCSCWCXCYC]C`CcCfClCoCxC{DDDJDPDSD\\DbDjDlDn_??J?K?S?T?Z?`?g?i?p"},
  {0,NULL,"?w?}@D@H@L@S@[@\\@`@b@c@f@k@u@vABACAGAKALAMAQAYA]AaAiAnArAuAvAxAyB"},
  {0,NULL,"EBJBKBNBOBRBUB[BaBfBgBhBiBpBqBrByB~C?C@CACDCICJCRCVCWCYC[C]CbCiCj"},
  {0,NULL,"CnCxC}C~D@DDDFDJDLDQDWD\\D^DbDdDjDoDqDyD{_??I?P?R?U?[?c?f?k?q?y?|@"},
  {0,NULL,"A@I@J@O@Q@R@T@_@a@e@j@p@x@{A@AFAHAOAPAVAXAZAbAeAgApAqAzA{A~BABCBI"},
  {0,NULL,"BPBQB]B^B_B`BfBhBjBlBpBqBwBxC?C@CBCDCECICOCPCVCXCYC^CdCeCiCjCnCtC"},
  {0,NULL,"yDCDDDEDFDJDMDODRD]D^DbDeDgDkDuDvDw_??H?O?Q?V?\\?d?h?j?o?v?{?~@J@K"},
  {0,NULL,"@O@Q@R@U@X@d@g@i@o@s@z@}AFAJANAPAUAZA\\AbAdAkApAtAwA{B@BCBIBLBPBSB"},
  {0,NULL,"\\B]B^BbBgBiBkBnBrBuByB{B~CACCCGCJCLCQCRCWCZC[C\\C]CbCfCgCnCsCvD?D@"},
  {0,NULL,"DBDFDIDLDNDVDYD^DaDdDfDiDrDvDx_??H?O?Q?V?\\?d?h?j?o?v?{?~@G@L@W@Z@"},
  {0,NULL,"[@]@b@c@g@i@o@s@z@}AIAKAQATAWAYAaAcAdAkAsAuAyA|BFBJBKBMBRBVBWBXB["},
  {0,NULL,"BaBjBlBoBtBvBwBxB|CBCECHCMCNCOCPCTCXC^C`CaCcCdCeChCqCtCuCwC{DDDJD"},
  {0,NULL,"KDODPDUDXDbDcDgDhDnDpDzD{_??I?P?R?U?[?c?f?k?q?y?|@A@G@H@V@Y@[@^@b"},
  {0,NULL,"@c@e@j@p@x@{A@AGAIAQASAYA^A`AaAeAgArAsAyB?BGBHBJBKBRBTBYBZB[BaBkB"},
  {0,NULL,"mBnBsBuBzB{B}CCCFCGCKCLCQCSCUCZC\\C_CfCgCkClCmCoCsCuC|D@DADHDLDNDS"},
  {0,NULL,"DUDZD`DdDfDhDlDsDyDz_??J?N?S?W?]?a?g?m?s?x@B@C@H@K@U@V@X@Y@^@d@f@"},
  {0,NULL,"h@n@w@|AAAGAJANASAUA\\A^A`AfAhArAtAwB?B@BGBHBLBSBTBYBZB\\BbBfBhBoBp"},
  {0,NULL,"BqBtBvB|C?C@CDCHCICMCNCTCVCYC`CaCcChCiCjCqCwCyDADBDCDIDKDRDXDZD]D"},
  {0,NULL,"aDcDkDpDsDuDxDy_??H?L?Q?Y?_?e?h?l?r?u@?@@@G@K@M@N@P@V@Y@^@g@l@q@t"},
  {0,NULL,"@~A?AIAJARASA[A^A_A`AlAmAsAtA}B?BBBDBGBHBTBYBZBcBdBeBgBiBjBlBrBwB"},
  {0,NULL,"xByB~CACBCECJCOCPCRCWCXC[C]C^CbCdCeCpCyC|C}C~DEDHDMDQDTDWD]D`DeDk"},
  {0,NULL,"DmDoDqDxDz_??I?M?R?X?^?b?f?n?t?z@E@F@G@I@M@N@P@W@Z@]@e@m@r@yADAEA"},
  {0,NULL,"HAIARATAWA[A_AcAjAoAqAsA|A}BBBDBFBMBVBWBXBcBdBeBfBhBkBnBpBqBuB{C?"},
  {0,NULL,"C@CCCDCGCICLCQCVCYCZC\\CfCgCiCjCrCwCxC~D?DBDIDKDQDYD[D\\DaDcDjDqDrD"},
  {0,NULL,"tDwDz_??H?L?Q?Y?_?e?h?l?r?u@?@@@J@L@S@T@\\@_@`@a@g@l@q@t@~A?AFAKAL"},
  {0,NULL,"AMAOAVAXA]AlAmApAuAvAxAzA~BABEBNBOBQBUB_B`BkBnBoBtBuBvB{B|CCCGCHC"},
  {0,NULL,"LCMCNCQCTCZC\\C`CaCcCfCgChCoCrCxCzDADCDGDRDSDZD[D\\D_DjDlDsDtDuDvD{"},
  {0,NULL,"_??I?M?R?X?^?b?f?n?t?z@E@F@H@J@S@U@X@\\@`@d@e@m@r@yADAEAFAGALAMANA"},
  {0,NULL,"UA\\A]AjAoApArAvAwAxB@BEBLBNBOBSBUB\\BbBjBlBmBsBwBxBzB}CBCECFCKCOCP"},
  {0,NULL,"CSCUCXC^C_CdCeCkClCmCpCqCvCzC{C}DGDPDTDVDWDXD_DiDmDnDoDpDvDy_??J?"},
  {0,NULL,"K?S?T?Z?`?g?i?p?w?}@D@I@K@M@N@O@P@Q@R@f@k@u@vABACAHAJAPARAZA[A_Ab"},
  {0,NULL,"AiAnAqAtA{A}BBBCBDBIBPB]B^BcBdBeBmBoBsBtBvBzB|B}CFCHCKCMCNCSCTCUC"},
  {0,NULL,"_C`CaCcChCkClCmCpCrCsCtCuCzDGDNDODTDUD[D_DfDgDhDmDtDwDx_??J?N?S?W"},
  {0,NULL,"?]?a?g?m?s?x@B@C@I@L@T@W@Z@]@_@a@f@h@n@w@|AAAHAKAOATAVAWAXAcAfAhA"},
  {0,NULL,"qAuAzA|A~BABFBMBQBVBWBXB_B`BgBiBmBrBsByBzB}B~CACFCJCKCRCSCUCWC[C]"},
  {0,NULL,"C_CbCkClCmCoCvC{C|D?DEDHDMDPDSDVDYD`DeDiDlDnDrDwD{_??G?N?T?]?b?e?"},
  {0,NULL,"i?s?u?z?}@?@F@J@M@Q@R@S@X@_@k@n@t@y@~ABAEAFALAOAPARAZA\\AiAjAmApAv"},
  {0,NULL,"AwA{A}BABCBNBOBRBUB[BaBjBkBtBvBzB}CMCNCPCQCSCUCaCcCeCfClCmCnCoCpC"},
  {0,NULL,"qCrCwCzC|DFDGDHDKDSDTDXD[D^D_D`DcDlDmDpDtDzEDEEEF_??D?P?X?]?c?d?n"},
  {0,NULL,"?o?q?s?~@C@F@K@M@P@Q@X@Y@]@m@n@p@s@z@|AEAJAPARAWA\\A_A`AhAjAkAtAwA"},
  {0,NULL,"}BBBCBFBHBNBOBSBUB\\BbBfBgBhBkBvB{B~CCCDCICNCQCVCYC]CcCfCgCnCoCpCw"},
  {0,NULL,"D?DADBDDDFDIDJDKDSDTDYDZD^DaDbDcDlDmDrDsD{D~EAECEH_??D?O?Y?[?\\?]?"},
  {0,NULL,"l?s?v?y@?@A@B@I@M@N@R@Z@^@_@l@n@o@x@~A@AAAHAOARAZA[A^AcAeAfAmAqA{"},
  {0,NULL,"A}BABDBGBMBNBOBQBUB_B`BfBgBiBjBwBzB~CACDCOCPCSCVCXC]CbCeClCnCqCrC"},
  {0,NULL,"yC{C|D@DEDFDHDLDMDPDXD[D]D^D`DdDeDkDnDpDtDyD}EBEGEH_??E?K?W?Z?\\?^"},
  {0,NULL,"?m?t?v?w?{@B@E@G@N@V@Z@^@b@d@h@o@r@u@}AAADAIANASA[A^AaAcAdAfAoAsA"},
  {0,NULL,"yB?BDBGBLBMBQBVBWBXB_B`BfBhBoBuBwB|CDCHCICLCOCTCVCXCYCZC`ChCnCqCr"},
  {0,NULL,"CwCzC|DBDDDFDGDHDIDJDKDXD[D^D_D`DaDbDcDpDtDvE?EAECEJ_??D?N?T?[?a?"},
  {0,NULL,"d?i?o?x?y?~@A@D@J@O@T@U@\\@`@c@k@s@w@x@zA@ACAFAMAUAVAYA]AbAeAkAnAp"},
  {0,NULL,"AxA~B@BEBIBJBPB]B^BcBdBeBlBnBpBqBrByC?C@CECGCJCRCWC[C\\C^CiCjCnCwC"},
  {0,NULL,"zC|D@DBDDDEDFDGDHDIDJDKDLDMD^D_D`DaDbDcDdDeDzD|D}D~_??F?K?W?_?`?c"},
  {0,NULL,"?m?p?q?r?|@@@C@G@P@W@Y@[@]@a@h@p@q@v@{@|A?AIAQATAWAXA_A`AgAhAlAsA"},
  {0,NULL,"zA|BBBFBHBKBSBTBYBZB\\BbBgBiBmBsBxB{B~CACBCCCFCKC]C_CbCdCgCkCnCoCp"},
  {0,NULL,"CwCzC|D@DEDFDGDHDKDLDMDSDTD^D_D`DcDdDeDlDmDvE@EBEGEI_??F?L?V?Z?c?"},
  {0,NULL,"e?j?q?u?w?{?|?}@H@Q@S@V@X@b@d@i@p@t@u@{@}ABAGALANAPASA\\AaAdAgAiAr"},
  {0,NULL,"AvAwAyB?BCBLBRBVBWBXB[BaBhBkBrBuByB}CICJCLCQCRCUCWCYCZC[CfCmCnCqC"},
  {0,NULL,"rCsCxC|D@DEDFDHDLDMDNDXD[D\\D^D`DdDeDfDjDpDtDwD|D~E@EHEK_??E?M?U?\\"},
  {0,NULL,"?`?b?k?p?v?z?{?|?}@L@R@S@W@[@_@a@j@o@v@y@{@}ABAKALAOAQATAXAZAdAgA"},
  {0,NULL,"iAuAvAzA{A|BABKBRBTBYBZB[BaBiBjBpBqBtBxC?C@CACBCMCPCaCbCdCeCiCjCn"},
  {0,NULL,"CoCpCtCwC}DBDDDFDIDJDKDODSDTDWD^DaDbDcDgDlDmDoDxD|D}E?EHEM_??G?M?"},
  {0,NULL,"U?^?a?e?k?t?u?x@?@A@B@L@T@V@Z@`@b@c@j@r@t@w@~A@AAAKASAVAYA]AaAcAe"},
  {0,NULL,"AfAmAuAxAyA~B?BJBMBPBQB]B^B_B`BmBnBsBuByB|CFCGCKCLCRCTCZC[C\\C_ChC"},
  {0,NULL,"kCoCpCzC|D?DADBDDDGDHDIDJDSDTDYDZD_D`DaDbDlDmDrDsDxE@EDEGEKEL_??F"},
  {0,NULL,"?P?X?Z?[?_?n?r?w?y@@@D@E@K@N@O@U@\\@^@d@m@q@u@xA?ACADAJAMANAUA[A^A"},
  {0,NULL,"bAlAnAoAtB@BDBEBGBIBLBVBWBXBcBdBeBlBoBrBwBzB}CECHCJCOCSCUCWCXC^C`"},
  {0,NULL,"ClCmCoCpCtCzC|C}DBDDDGDHDIDJDODSDTDWD_D`DaDbDgDlDmDoD{EBEEEFEKEL_"},
  {0,NULL,"??G?N?T?]?b?e?i?s?u?z@@@D@E@G@M@S@[@]@^@b@k@n@t@yA?ACADAIALAQARAW"},
  {0,NULL,"A^AaAlAnAoAsAvAyA}BFBGBKBPB]B^BcBdBeBfBgBpBuBxByB~C?CBCDCLCRCVCZC"},
  {0,NULL,"[C]CdCiCuCvCxCyC}C~D?DCDQDRDUDVDWDYD\\D]DhDiDjDkDoDqDrDuDvD|EBEC_?"},
  {0,NULL,"?F?K?W?_?`?c?m?p?q?r@?@A@B@J@R@U@X@Y@`@a@h@p@q@v@~A@AAAFAUAXAZA\\A"},
  {0,NULL,"]A`AeAfAmApAwAxAzA{B@BHBQBVBWBXB_B`BhBkBlBoBqBtC@CECHCICMCQCYC^C`"},
  {0,NULL,"CaCfCjCtCuCvCxCyC~DADCDODQDRDUDVDZD\\D]DgDhDiDjDkDqDsDuDzD}EAED_??"},
  {0,NULL,"E?K?W?Z?\\?^?m?t?v?w?~@C@F@J@Q@T@Z@\\@_@d@h@o@r@u@z@|AEAFAMANAOAPAV"},
  {0,NULL,"AcAhAjAkApA~BABCBEBLBMBSBTBYBZB\\BbBiBjBmBnBrB}CACFCGCJCPCUCWC\\C_C"},
  {0,NULL,"bCeCmCsCuCvC{C}C~D?DCDNDPDQDRDUDVDWDYDfDhDiDnDoDqDrDuDzD~EEEG_??E"},
  {0,NULL,"?O?Y?^?`?d?l?o?p?t@@@D@E@I@O@P@T@]@`@a@l@r@s@vA?ACADAHAVAWAXA]A_A"},
  {0,NULL,"bAlAnAoAqAxAzA~BBBFBIBTBYBZBcBdBeBmBnBqBtBvB{C@CCCFCGCMCNC\\C_CaCc"},
  {0,NULL,"CgCjCqCrCsCwCxCzD@DEDGDKDLDMDNDXD[D\\D_DcDdDeDfDjDpDtDyECEDEFELEM_"},
  {0,NULL,"??G?L?V?_?a?b?j?r?x?z?{@B@E@I@N@O@R@U@W@a@i@q@w@y@}AAADAHATAUAXAZ"},
  {0,NULL,"A[AbAdAfAoAqAzA{A|B@BDBIBRBVBWBXB[BaBiBkBqBrBzB{C@CACCCJCQCSCWCbC"},
  {0,NULL,"fCgCjClCoCtCvC}C~D?DADBDIDODQDSDVDWDYDZDaDgDiDlDoDqDrDsDyD~ECEGEO"},
  {0,NULL,"EQES_??G?L?V?_?a?b?j?r?x?z?~@C@F@H@U@W@Y@[@\\@c@i@q@w@y@z@|AEAGAMA"},
  {0,NULL,"QATAUAYA`AhAjAkArA|B@BEBHBJBKBPBSB\\B]B^BbBlBoBpBsBxB|C?CBCECHCKCT"},
  {0,NULL,"C^C`CdChCiCkCqCrCwCyCzC{D@DEDGDKDLDMDPDXD[D]D_DcDdDeDkDnDpDtDwE?E"},
  {0,NULL,"AEEELEM_??G?M?U?^?a?e?k?t?u?x?|@@@C@K@O@P@Q@T@V@d@j@r@t@w@{@|A?AJ"},
  {0,NULL,"ANAPASAVA_AbAgAhAlAtA~B?BBBCBIBLBRBTBYBZB[BaBhBjBqBrBvBwC@CICJCNC"},
  {0,NULL,"OCPCWCXCYCcCeCjCqCsCxCyC{C~DCDEDMDNDPDQDRDXD\\D]DeDfDjDkDnDpDqDuD{"},
  {0,NULL,"D}EAEBENETEU_??E?M?U?\\?`?b?k?p?v?z?~@A@D@K@M@R@U@Y@[@^@j@o@v@y@zA"},
  {0,NULL,"@ACAJAQARAUAZA^A`AeAkAnAtA{A}B@BGBHBKBPBQB]B^B_B`BgBkBoBsBuBzB~CH"},
  {0,NULL,"CKCLCQCSCZC]C`CfCkClCrCsCuCvCxCyC{D@DLDNDPDUDVD[D\\D]DdDfDhDiDjDkD"},
  {0,NULL,"nDtD{D~E@EFEJERESEW_??D?P?X?]?c?d?n?o?q?s?{@B@E@L@S@X@]@`@a@b@m@n"},
  {0,NULL,"@p@s@}AAADAKALAWAXA\\A]AaAdAfAoAuAvAwAxAyAzBFBVBWBXBcBdBeBlBmBtBxB"},
  {0,NULL,"yB}CBCECFCMCRCUC[C^C_CaCdCmCqCsCuCvCxCyC{DEDMDNDPDUDVDXD\\D]DeDfDh"},
  {0,NULL,"DiDjDkDnDpDxE?EEEGENERESEU_??D?N?T?[?a?d?i?o?x?y?{?|?}@G@N@O@P@V@"},
  {0,NULL,"W@c@k@s@w@x@{@}ABAIASATAYA[A_AbAdAgAiAsA|B?BBBDBIBJBNBOBRBUB[BaBs"},
  {0,NULL,"BvBwBzB{B|CCCKCNCOCSCTCXCcCgChCkClCsCtCuCvC{C~DADCDNDODPDQDRDUDVD"},
  {0,NULL,"ZDfDgDhDiDnDqDsDuDvE?E@EFEVEX_??F?P?X?Z?[?_?n?r?w?y?}@?@F@L@N@W@Z"},
  {0,NULL,"@\\@_@c@m@q@u@x@~ABAEAKAMAOATAYA[AcAiAjAmAuA|BABDBEBJBMBNBOBSBUB\\B"},
  {0,NULL,"bBfBiBnBpB{B|C?CACCCDCGCTCVC\\CbCgChCiCrCsCxCyC{C~D@DCDLDNDPDQDRD["},
  {0,NULL,"D\\D]DdDfDjDkDnDqDtDuDxD|ECEDEJETEWE[_??D?O?Y?[?\\?]?l?s?v?y?|@@@C@"},
  {0,NULL,"H@S@[@\\@^@_@d@l@n@o@x@{@|A?AGALAMANAOAQA^AgAhAlArAvBABEBGBKBLBTBY"},
  {0,NULL,"BZBcBdBeBnBoBpBtBuB}C?CGCHCLCMCUCZC\\C`CaCiCmCoCtCuC}D?DADBDCDIDOD"},
  {0,NULL,"RDSDUDWDYDZDaDgDhDlDoDrDsDuDwE@EAEDEOEQERET_??E?O?Y?^?`?d?l?o?p?t"},
  {0,NULL,"?}@?@F@H@P@V@X@Y@`@c@l@r@s@v@~ABAEAGASAYA\\A]A_A`AiAjAmArAwAxB?BBB"},
  {0,NULL,"HBJBNBOBQBUB_B`BgBhBlBsBwByB~CECICKCOCRCXCYC[C]C^CkCpCtCvC}C~D?DA"},
  {0,NULL,"DDDJDODQDTDVDWDYDZDbDgDiDmDoDqDrDsDwD|EBEEEIEPESE[_??F?L?V?Z?c?e?"},
  {0,NULL,"j?q?u?w?~@A@D@I@M@Q@T@Z@]@b@i@p@t@u@zA@ACAHAPARAVAWAaAcAeAkAnAqAy"},
  {0,NULL,"A}A~BCBFBMBPBSB\\B]B^BbBfBjBmBvBxB|CBCDCFCNCPCTCVC_CcCdCeChCpCtCuC"},
  {0,NULL,"}D?DADCDDDJDODRDTDUDWDYDZDbDgDhDmDoDrDsDuDyD}E?EFEIEPERET_@?A?B?C"},
  {0,NULL,"?H?I?J?M?P?Q?R?S?U?X?f?g?h?k?n@K@L@e@f@g@j@mAJAKAtAuCnCqCrCtCuCvC"},
  {0,NULL,"wCzC|C}C~D?D@DADCDEDFDGDHDKDLDMDODQDRDUDVDWDXDYDZD[D^D_D`DcDdDeDg"},
  {0,NULL,"DhDiDoDpDqDrDsDtDuDxD{EHEJEKELEMENERESETEUEVEWE[E]E^E__@?A?B?C?H?"},
  {0,NULL,"I?J?L?O?Q?R?S?V?Y?f?g?h?j?l@H@I@e@f@g@i@lAGAHAqArCnCoCpCsCuCvCwCx"},
  {0,NULL,"CyCzC{C|C~DBDCDDDFDGDHDIDJDKDNDPDQDRDSDTDUDVD\\D]D^D_D`DaDbDcDfDhD"},
  {0,NULL,"iDjDkDlDmDnDqDuDwDyEHEIEKELEMEOEPEQERESETEXEYEZE[E\\_@?A?B?C?H?I?J"},
  {0,NULL,"?K?N?Q?R?S?T?W?f?g?h?i?m@G@J@e@f@g@h@kAFAIApAsCoCpCqCrCsCtCxCyC{C"},
  {0,NULL,"}D?D@DADBDDDEDIDJDLDMDNDODPDSDTDWDXDYDZD[D\\D]DaDbDdDeDfDgDjDkDlDm"},
  {0,NULL,"DnDoDpDrDsDtDvDzEIEJENEOEPEQEUEVEWEXEYEZE\\E]E^E__@?A?B?C?F?G?H?L?"},
  {0,NULL,"O?Q?V?Y?_?e?h?j?l?r?u@?@@@g@i@l@q@t@~A?AlAmBfBhBmBpBqBsBzB}C?C@CD"},
  {0,NULL,"CFCICKCSCUCVCYC_CiCjCkClCmCnCsCuCvCwC{DBDDDFDIDJDKDNDPDUDVD^DaDbD"},
  {0,NULL,"cDfDhDiDnD|D}E@EAEBECEDEEEFEGEIEKELEOETEYEZE[E`Eb_@?A?B?C?E?G?I?M"},
  {0,NULL,"?P?R?U?X?^?b?f?k?n?t?z@E@F@e@j@m@r@yADAEAjAoBgBiBoBrBtBvByB|B~CAC"},
  {0,NULL,"HCJCMCNCRCTCWC[C]C`CaCbCcChCnCtCuC|D@DADCDEDFDHDLDMDODRDUDZD^D`Dd"},
  {0,NULL,"DeDgDhDsDuD|D~E?EAEBECEDEEEFEGEJELEMENESE[E]E_EaEb_@?A?B?C?D?G?J?"},
  {0,NULL,"K?N?S?T?W?]?a?g?i?m?s?x@B@C@f@h@k@n@w@|AAAfAhBjBkBlBnBuBwBxB{CBCC"},
  {0,NULL,"CECGCLCOCPCQCXCZC\\C^CdCeCfCgCpCrCsCtCxC}D@DDDJDLDNDODTDWD[D\\DbDdD"},
  {0,NULL,"fDgDjDmDoDtD}D~E?E@EAEBECEDEEEGENEOEQEUEYE\\E^E_E`Ea_@?A?B?C?D?E?H"},
  {0,NULL,"?L?O?Q?V?Y?\\?d?h?j?l?o?v?{?~@g@i@l@o@s@z@}AdAkBfBhBmBpBqBsBzB}C?C"},
  {0,NULL,"@CDCFCICKCSCUCVCYC_CiCjCkClCmCoCpCxCyCzC|C~DCDGDHDQDRDSDTD\\D]D_D`"},
  {0,NULL,"DjDkDlDmDqDuD|D}D~E?E@EAECEEEFEGEHEMEPEQERESEXE\\E`Eb_@?A?B?C?E?F?"},
  {0,NULL,"J?K?N?S?T?W?Z?`?g?i?m?p?w?}@D@f@h@k@u@vABACAiAnBjBkBlBnBuBwBxB{CB"},
  {0,NULL,"CCCECGCLCOCPCQCXCZC\\C^CdCeCfCgCoCqCyC{D?DADBDEDIDMDPDSDXDYDZD]DaD"},
  {0,NULL,"eDkDlDnDpDrDsD|D}D~E?E@EBECEDEEEFEIEJEPEVEWEXEZE]E`Ea_@?A?B?C?D?F"},
  {0,NULL,"?I?M?P?R?U?X?[?c?f?k?n?q?y?|@A@e@j@m@p@x@{A@AeAgBgBiBoBrBtBvByB|B"},
  {0,NULL,"~CACHCJCMCNCRCTCWC[C]C`CaCbCcChCqCrCvCwCzC}C~D?DGDKDQDVDWDXDYD[D_"},
  {0,NULL,"DcDiDoDpDqDrDtD|D}D~E?E@EAEBEDEFEGEHEKERETEUEVEWE^EaEb_@?A?B?F?G?"},
  {0,NULL,"H?L?M?N?V?_?a?b?e?j?r?u?x?z@U@W@i@q@t@w@yATAUA|B@BNBOBQBTBUBYBZB_"},
  {0,NULL,"B`BcBdBeBfBgBhBmBnBtBwB}B~CDCFCGCICMCOCUCVCXCYC\\C]C_CaCmCnCsCuDDD"},
  {0,NULL,"FDJDNDUD^DbDfDhDvDxDzD{D|D}E@EFEIEJEKETEUEVEWEZE]E^EaEdEeEf_@?A?B"},
  {0,NULL,"?E?G?I?L?M?N?U?^?a?b?e?k?t?u?x?z@T@V@j@r@t@w@yASAVA~B?BNBOBSBUBVB"},
  {0,NULL,"WBXB\\BbBcBdBeBfBgBiBlBoBtB{B}B~CACCCDCECHCMCUCVC]C^C`CaCbCgCmCnCt"},
  {0,NULL,"CuD@DFDLDODUD^DdDgDhDvDwDyDzD|D~E?EFEIEJEMEPEQESEXEZE\\E]E`EcEeEh_"},
  {0,NULL,"@?A?B?F?G?H?K?L?P?V?Z?_?c?e?j?q?r?u?w@Q@b@i@p@q@t@uAPAaAyBCBNBOBQ"},
  {0,NULL,"BTBUBYBZB_B`BcBdBeBgBnBpBqBsBtBwBzB~C?C@CGCKCMCOCSCXC\\C]CaCiCjCkC"},
  {0,NULL,"lCvCwC{DBDIDKDPDVDaDcDiDnDvDxDzD{EAECEEEGEJELENEOEUEYE[E]E^E_EaEf"},
  {0,NULL,"EgEhEj_@?A?B?D?G?J?N?O?P?T?[?]?a?d?i?o?s?x?y@O@c@k@n@s@w@xAYAbBIB"},
  {0,NULL,"JBQBSBTBVBWBXBYBZB\\B_B`BbBhBiBjBkBmBoBuBxCACBCFCHCICLCPCQCYCZC_C`"},
  {0,NULL,"CbCdCeCfCpCrCxC}DTDWD[D\\DjDmDoDtDwDxDyD{EBECEDEEEKELEMENEOESETEYE"},
  {0,NULL,"[E_EbEfEgEhEiEj_@?A?B?E?G?I?K?M?O?U?\\?^?`?b?k?p?t?v?z@R@[@j@o@r@v"},
  {0,NULL,"@yAQAZA{BKBNBOBSBUBVBWBXB\\BbBcBdBeBfBlBrBvByB{B|B}CCCDCECJCNCRCTC"},
  {0,NULL,"UCVCWC[C^CcCgChCmC|DADCDEDHDMDRDZD`DeDsDuDvDwDyDzEAEBEDEGEIELENEO"},
  {0,NULL,"EQEYEZE[E\\E_E`EfEgEhEi_@?A?B?D?E?H?N?O?P?Y?[?\\?]?d?l?o?s?v?y@^@_@"},
  {0,NULL,"l@n@o@s@xAOA^BABGBPBRBSBVBWBXB[B\\B]B^BaBbBhBkBmBqBrBsBxB|C@CBCFCI"},
  {0,NULL,"CJCKCQCTCWCYC_CdCfChCjCkCpCxCzC~DGDQDTD\\D_DjDmDqDvDxDzD{D|ECEEEFE"},
  {0,NULL,"JEMENEPESEVEWEXE]E_EaEcEeEhEm_@?A?B?D?E?H?K?M?O?Y?\\?^?`?d?l?o?p?t"},
  {0,NULL,"?v@P@`@l@o@r@s@vA]A_AxBBBPBRBSBVBWBXB[B\\B]B^BaBbBfBkBpBrBxBzB|B}C"},
  {0,NULL,"?CBCDCJCQCSCTCUCVCWCdCfChCiClCmCoCyC|DCDHDRDSD]D`DkDlDuDvDxDzD{D}"},
  {0,NULL,"E@EAEGEHENEQEREUEVEWE\\E^E_EaEcEdEgEjEl_@?A?B?E?F?J?K?L?P?W?Z?_?`?"},
  {0,NULL,"c?m?p?q?r?w@Y@a@h@p@q@u@vAXA`AzBHBNBOBPBRBUB[B]B^BaBcBdBeBjBnBpBu"},
  {0,NULL,"BvBwByBzC?CGCLCNCOCPCRCSCXCZC[C\\CcCeCiClCqC{D?DBDIDPDXDYDaDnDpDrD"},
  {0,NULL,"wDxDyD{D~E?ECEEEHEJELEMEPERESEXE[E]EbEcEeEhEiEmEo_@?A?B?E?F?J?K?M"},
  {0,NULL,"?O?W?Z?\\?^?`?m?p?t?v?w@Z@d@h@o@r@u@vANAcBLBMBNBOBPBRBUB[B]B^BaBcB"},
  {0,NULL,"dBeBkBlBpBvBxByBzB{C?CBCCCECNCQCRCSC[C^CcCdCfCgCiClCoCyDADEDMDSDZ"},
  {0,NULL,"D]DeDkDlDsDwDxDyD{D}E@EBEDEHEIEKELERETEVEWEZE[EbEdEeEfEjEkEn_@?A?"},
  {0,NULL,"B?D?G?J?L?M?N?T?]?a?b?e?i?s?u?x?z@M@S@k@n@t@w@yALARAvA}BQBSBTBVBW"},
  {0,NULL,"BXBYBZB\\B_B`BbBhBiBlBmBnBoBwB{CACCCECFCGCHCICOCXCYC\\C^C_C`CbCgCsC"},
  {0,NULL,"tD@DDDJDLDNDODbDdDfDgDwDxDyD{D}D~E?E@EHEKEMEQERESETEUE\\E^EbEcEdEg"},
  {0,NULL,"EkEmEn_@?A?B?D?F?I?N?O?P?X?[?]?c?d?n?o?q?s?y@X@]@m@n@p@s@xAWA\\AwB"},
  {0,NULL,"FBPBQBRBTBYBZB[B]B^B_B`BaBiBjBoBqBrBsBuB|C@CACHCJCKCLCPCTCWCZC`Cb"},
  {0,NULL,"CeChCjCkCrCzC}C~DGDQDWD[D_DoDqDtDvDwDyDzD|EBEDEFEIEKEOEPETEVEWEXE"},
  {0,NULL,"YEZE`EdEeEfEkEoEpEr_@?A?B?D?F?I?K?L?P?X?Z?[?_?c?n?q?r?w?y@N@\\@m@p"},
  {0,NULL,"@q@u@xAMA[BDBEBPBQBRBTBYBZB[B]B^B_B`BaBgBjBqBsBtBuBvByB~C@CKCLCMC"},
  {0,NULL,"NCPCRCZC[C]CaCcCeCjCkCqCvCwD?DKDVDXDYDcDiDpDrDvDwDyDzD~E?EAEGEHEO"},
  {0,NULL,"EPEQEREUEXEYE\\E^E`EcEdEgEiElEnEq_@?A?C?F?G?O?Q?W?X?Y?]?^?_?e?j@?@"},
  {0,NULL,"@@C@E@]@d@i@~A?AAAEA\\AcApAsAtAuAvAxAzA}A~B?BABBBDBEBGBHBXB\\BfBhBj"},
  {0,NULL,"BoBsByBzB{C?C@CACECFCLCNCUCWCdCfChCiCjCkClCnCsCuDDDFDJDNDUDaDcDeD"},
  {0,NULL,"iDnDoDpDrDsDtD|D}E@EFELEOEYE[EaEdEeEfEiEkEqEs_@?A?C?E?G?P?R?W?X?Y"},
  {0,NULL,"?]?^?_?b?k@?@C@E@F@Y@_@jA?AAADAEAXA^ApAqArAsAvAwAxA|A}B@BBBDBEBFB"},
  {0,NULL,"LBMBZB_BhBnBoBrBtBxByBzB~C?CACFCNCOCQCTCWCZC[CcCeChCjCkCnCtCuD@DF"},
  {0,NULL,"DLDODUD`DaDeDjDkDlDmDnDsDuD|D~E?EFELENE[E_E`EcEeEhEjEmEnEp_@?A?C?"},
  {0,NULL,"D?E?L?Q?U?V?W?\\?a?c?d?l?{?|?~@B@V@a@l@z@|@}A@AVA`ApAsAtAuAwAyA{A|"},
  {0,NULL,"B@BCBFBIBJBKBLBMBQBTBfBiBlBmBpBsBuBvC@CCCHCICPCRCSCUCVCXC\\C]CaCiC"},
  {0,NULL,"lCmCpCxCzC~DGDQDTD\\D`DdDeDgDkDlDpDrDsDuD|ECEEEFEHEQERE\\EaEcEeEhEj"},
  {0,NULL,"EnEoEp_@?A?C?D?E?L?Q?T?V?X?Z?\\?b?d?l?{?~@D@F@M@\\@l@z@}ABADALA[ApA"},
  {0,NULL,"sAtAuAwAyA{A|B@BCBFBIBJBKBLBMBUBeBhBiBlBqBuBvBzB}C?CCCDCFCHCKCPCR"},
  {0,NULL,"CXCYC\\C]C_CaCjCkCoCyC|DCDHDRDSD]D_DdDgDjDmDoDpDqDrDtD}E@EAEGEMEPE"},
  {0,NULL,"SEXEaEcEdEgEnEoErEtEv_@?A?C?F?G?O?Q?T?U?Y?[?_?`?e?j?}@?@@@A@R@c@i"},
  {0,NULL,"@{@~A?ACAQAbApAsAtAuAvAxAzA}A~B?BABBBDBEBGBHBPB[BjBmBoBpBqByB{B}C"},
  {0,NULL,"ACDCECICKCLCNCSCVCWCYC_CdCfChCmCvCwC{DBDIDKDPDVD^DbDdDeDfDgDhDoDs"},
  {0,NULL,"DtEAECEEEGEIEKETEZEaEfEgEhEiEkElEmEv_@?A?C?D?F?M?R?U?V?W?[?\\?a?c?"},
  {0,NULL,"n?|?~@A@B@U@Z@m@{@|@}A@ANATApAqArAsAyAzA{A~B?BABCBGBHBIBJBKBVBbBi"},
  {0,NULL,"BkBmBpBrBtBvBwB~CBCGCHCICRCSCTCVC[C]C^CaCcCgCmCrCzC}C~DGDQDWD[DaD"},
  {0,NULL,"bDcDfDiDkDlDnDpDrD|EBEDEFEHEREUE^E`EdEeEfEiEqEsEtExEy_@?A?C?D?F?M"},
  {0,NULL,"?R?T?U?Y?[?`?c?e?n?|?}@@@A@P@S@m@{@~A@ACARA]ApAqArAsAyAzA{A~B?BAB"},
  {0,NULL,"CBGBHBIBJBKBOBcBgBkBmBoBpBwByB|CACBCGCICJCMCNCSCVCWC^C`CbCgChCmCq"},
  {0,NULL,"CvCwD?DKDVDXDYD_DbDfDjDkDlDmDoDqDtD~E?EAEGEKETEVEWE`EcEdEgEoErEsE"},
  {0,NULL,"tEuEw_@?A?C?D?G?K?S?U?V?W?\\?]?a?c?i?|?~@B@C@Q@[@k@|@}A@AAAZAaAqAr"},
  {0,NULL,"AtAuAwAzA|A~B?B@BABFBGBHBLBMB^BaBfBkBlBrBsBtBuBwB~C@CBCCCGCPCTCUC"},
  {0,NULL,"XC[C\\C^CcCgCiClCpCrCxC}DTDWD[D\\D^D`DbDcDdDfDgDhDiDuEBECEDEEEQEUE\\"},
  {0,NULL,"E^EbEfEgEhEkElEmErEuEvExE{_@?A?C?D?G?K?S?W?X?Y?]?^?_?a?i@?@B@C@E@"},
  {0,NULL,"N@`@k@|A?AAAEAMA_AqArAtAuAwAzA|A~B?B@BABFBGBHBLBMBNBdBfBjBnBrBsBt"},
  {0,NULL,"BxB{B~C@CECLCOCQCTCUCZC[CcCdCeCfCiClCsCtD@DDDJDLDNDOD_D`DcDiDjDmD"},
  {0,NULL,"oDqDtDuD}D~E?E@ENEOEYE_EbEcEdEgElEoErEtEwEyEz_@?A?C?E?F?N?S?T?U?Y"},
  {0,NULL,"?Z?[?`?e?m?}@@@A@D@T@^@h@{@~ABACAOASAqArAtAuAvAxAyA{A}BBBCBDBEBIB"},
  {0,NULL,"JBKBYB`BgBjBkBqBwB{B|B}CBCDCECGCJCKCLCMCYC^C_C`CbCdCfCgCqC{D?DBDI"},
  {0,NULL,"DPDXDYD^D_D`DeDhDkDlDqDsDuD~E?ECEEEIEVEWEZEbEcEeEhEjEnEpEqEuExEz_"},
  {0,NULL,"@?A?C?E?F?N?S?T?V?X?Z?`?b?d?m?{?}@D@F@W@X@h@zABACADAUAWAqArAtAuAv"},
  {0,NULL,"AxAyA{A}BBBCBDBEBIBJBKBSBWBgBlBnBqBuBxB|B}CCCDCJCKCMCOCPCQCXCYCZC"},
  {0,NULL,"\\C_C`CbCeCoCyDADEDMDSDZD]D^D_DaDcDhDiDnDpDqDrD}E@EBEDEJEPEXE]EbEd"},
  {0,NULL,"EeEfEiEpEqEsEvEwEyE{_@?A?C?E?G?P?R?T?V?X?Z?^?b?d?k?{@D@E@F@O@b@j@"},
  {0,NULL,"zABADAEAPAYApAqArAsAvAwAxA|A}B@BBBDBEBFBLBMBRB]BgBhBiBnBvBxBzB|C?"},
  {0,NULL,"CFCHCJCMCOCQCRCZC]C`CaCbCeCjCkC|DADCDEDHDMDRDZD^DaDbDdDfDgDhDjDmD"},
  {0,NULL,"nEAEBEDEGEJEMESE]E`EfEgEhEjEkElEmEuEwE}E~_@?A?I?J?L?O?R?S?V?Y?]?`"},
  {0,NULL,"?b?c?h@H@I@S@X@Y@[@gAGAHARAWAXAZAeAfAgAhAiAjAnAoAxAyA|B@BABBBCBGB"},
  {0,NULL,"PBQBTBUBXB[B\\BeCZC[C]C^C`CaCbCcCdCeCfCgCnCoCpCsCwC{C~DCDGDHDIDJDU"},
  {0,NULL,"DVD\\D]D_D`DaDbDfDnDqDuEKELEPEQETEXE[E\\E`EbEcEfEmEpErEsEvE{E|F?_@?"},
  {0,NULL,"A?H?J?M?P?Q?S?U?X?_?`?a?d?f@K@L@W@`@a@c@eAJAKAUA_A`AbAdAfAhAiAkAl"},
  {0,NULL,"AmAnAwA{A~B?BDBEBFBKBOBRBVBZB]B_BbBcCXCYC\\C^C_CdCfCgCiCjCkClCnCqC"},
  {0,NULL,"rCtCvC|C~DADGDKDLDMDRDUDWDYD^D`DhDoDpDrDtDuEHEJEKENERETE]E_EaEbEd"},
  {0,NULL,"EhEiElEoEpEwEyE}F?_@?A?I?J?L?O?R?S?V?Y?Z?[?^?a?h@H@I@N@O@T@Z@gAGA"},
  {0,NULL,"HAMANASAYAeAfAgAhAiAjAnAoAxAyA|B@BABBBCBGBPBQBTBUBXB[B\\BeCWCXCZC["},
  {0,NULL,"C\\C^C`CbCcCeCgChCuCvCxCyCzC|DBDDDFDKDNDPDQDRDSDTD^DcDhDiDjDkDlDmE"},
  {0,NULL,"HEIEMEOERESEYEZE`EbEcEfEjElEqEtEzE}E~F@_@?A?H?I?K?N?Q?R?T?W?^?c?d"},
  {0,NULL,"?e?g@G@J@P@V@]@b@fAFAIAPAVA\\A]AdAeAgAjAkAlAmAoAvAzA}BHBIBJBLBMBNB"},
  {0,NULL,"SBWBYB^B`BaBdCVCWCYC[C]C_CaCcChCjCkCmCoCqCsCtCxC}DBDEDJDLDPDTDYDZ"},
  {0,NULL,"D[D]DaDdDgDkDlDnDoDtEJEOEQEVEWEYE\\E]E`EaEeEgEjEkEoEsEuEwE{F@_@?A?"},
  {0,NULL,"H?I?K?N?Q?R?T?W?[?\\?_?b?g@G@J@R@U@\\@_@fAFAIAQATA[A^AdAeAgAjAkAlAm"},
  {0,NULL,"AoAvAzA}BHBIBJBLBMBNBSBWBYB^B`BaBdCVCWC]C`CaCbChCiCjCkClCmCpCrCyC"},
  {0,NULL,"{D?D@DADDDIDMDNDODSDWDXD\\DbDeDfDjDmDpDrDsEIENEPEUEXEZE^E_E`EaEeEg"},
  {0,NULL,"EiEmEnEtEvExEyEz_@?A?H?J?M?P?Q?S?U?X?Z?\\?]?e?f@K@L@M@Q@^@d@eAJAKA"},
  {0,NULL,"LAOAaAcAdAfAhAiAkAlAmAnAwA{A~B?BDBEBFBKBOBRBVBZB]B_BbBcCVCXCYCZC\\"},
  {0,NULL,"C_CdCeCfCiClCmCuCwCzC}D?D@DCDEDFDHDODQDVDXDZD[D_DcDdDeDgDiDqDsELE"},
  {0,NULL,"MESEUEVEWE[E^EaEbEdEhEkEnEqErEuExE|E~_@?A?E?I?L?N?Q?U?W?^?a?c?d?e"},
  {0,NULL,"?z?~@J@T@V@]@a@y@}AIASAVA\\A`AeAfAgAhAlAmAtAuAxAyBBBCBIBJBLBMBNBOB"},
  {0,NULL,"RBSBWB]BcBdBfBiBjBlBoBsBxC@CACCCHCLCQCUCVC]CaCmCnCqCtCwCxCzDBDLDP"},
  {0,NULL,"DQDTDUDVDYDdDgDkDlDwDyD|EFEJEQE\\E]EbEdEfEiEmEpErEsEuExEzE|E~FBFCF"},
  {0,NULL,"E_@?A?F?H?M?N?S?V?X?_?`?a?b?d?u@D@K@U@W@X@`@tABAKATAUAWA_AdAfAhAj"},
  {0,NULL,"AkAoAqArAzA{BDBEBHBIBJBKBOBPBQBTBZB[B_BcBfBgBnBrBxByB}CDCMCNCOCQC"},
  {0,NULL,"TCUCXCYC\\C_CnCrCsCxCyC~DADGDJDMDSDTDUDWD^DhDpDrDvDzD}E@EJEKETE]E`"},
  {0,NULL,"EcEgEjEkEoErEsExEzE}E~F@FAFEFF_@?A?F?I?N?O?S?V?X?]?`?b?c?d?y@D@I@"},
  {0,NULL,"W@X@[@]@xABAGAUAWAZA\\AdAfAhAjAkAoAtAuAvAxAyAzA}BBBCBHBOBPBQBTBZB["},
  {0,NULL,"B_BcBfBlBpBqBrBuB|CCCJCKCPCSCTCUCZC`CbCeCnCoCrCsC~D@DEDGDJDODUDWD"},
  {0,NULL,"ZD]D_DaDnDqDvDzEBEDEKEPETEXEaEgEhEiElEmEnEtEuExE|E~F@FBFCFDFG_@?A"},
  {0,NULL,"?E?J?L?P?R?W?Y?]?_?`?b?c?w@E@I@S@Y@_@a@uAEAGARAXA^A`AeAfAgAhAlAmA"},
  {0,NULL,"pAsAwAxA{A|B@BBBFBKBPBSBUBWB[B^BaBeBmBnBoBwByBzB}C?CACDCGCICNCOCZ"},
  {0,NULL,"C[CcCeCnCpCtC{C}C~D?DGDIDLDUDXD[D\\D`DaDnDuDxD{D~E?ELEPEXE[EaEdEgE"},
  {0,NULL,"kEnEqErEtEuEwE{E}F@FBFCFEFGFI_@?A?D?I?K?L?Q?T?X?Z?[?\\?_?b?q?{@G@M"},
  {0,NULL,"@N@R@\\@p@zAFALAMAQA[AiAjAlAmAnAoAtAuA|B@BABGBIBJBLBMBVBYBZB^B_B`B"},
  {0,NULL,"aBbBkBqBuBvByB{B}CBCDCECKCNCPCRC]CaCjCkCnCwCyC|D?D@DDDNDODRDSDUDV"},
  {0,NULL,"DXDjDmDpDrDwDyEAEGEPEUEXE^EbEfEhEkEmEpErEsEwEyE}F?F@FCFDFF_@?A?F?"},
  {0,NULL,"I?N?O?Q?W?X?]?^?c?d?e?y@?@J@V@X@]@d@xA?AIAVAWA\\AcAdAfAhAjAkAoAtAu"},
  {0,NULL,"AvAxAyAzA}BBBCBHBOBRBYB]B^B`BaBcBfBiBjBlBoBsBwC@CACCCGCHCLCUCWChC"},
  {0,NULL,"jCkCnCoCsCzC|C}DEDJDQDRDUDZD[D]DaDnDoDtDwDyD|EFEOEVEWEYEbEcEhEjEl"},
  {0,NULL,"EnEqEtEvEwEyE}F?FAFEFFFH_@?A?E?J?L?P?Q?U?W?_?`?a?c?d?w?~@K@V@Y@a@"},
  {0,NULL,"c@u@}AKAVAXA`AbAeAfAgAhAlAmApAsAwAxA{A|B@BBBFBKBNBOBRBSBWB]BcBdBj"},
  {0,NULL,"BmBoBpBuBvB|CACICJCLCPCRCSCXC\\CiClCnCpCqCtC~DBDDDGDLDNDPDUDYD\\D`D"},
  {0,NULL,"pDrDuDwDyECEEEHEJERE]E`EfEgEjEkElEqEtEvExEyEzE|FAFDFFFHFL_@?A?D?J"},
  {0,NULL,"?L?M?R?T?Y?]?`?b?c?e?x@A@I@M@P@S@Y@w@{AGALARAXA]AiAjAlAmAnAoApAsA"},
  {0,NULL,"wAyA{BABCBFBGBKBQBSBTBWBXB\\B^BaBmBnBoBsBwByBzC?C@CACGCICNCOC^C`Cb"},
  {0,NULL,"CgCoCsCtCwD?DADCDHDJDLDMDVDXD]D_DbDfDqDxD{D~E?EKEQETE\\EaEeEhEiEjE"},
  {0,NULL,"lEoEpEvExEyEzE~FCFDFFFIFKFM_@?A?E?I?L?N?S?U?Y?Z?[?^?a?e?z?}@H@N@T"},
  {0,NULL,"@V@^@yACAHAMAOASAVAeAfAgAhAlAmAtAuAxAyBBBCBIBJBLBMBRBUBVBXB\\B]BbB"},
  {0,NULL,"eBgBjBsBtBzB{B}B~C?C@CDCECLCMC^C`CbCgCqCrCuCxCzD@DBDFDODPDQDTDWDY"},
  {0,NULL,"D^DhDkDlDvDzD~E?EIEMESEZEaEdEgEiEmEnErEtEwEyE{E}F?FAFDFFFKFLFM_@?"},
  {0,NULL,"A?D?J?L?M?Q?T?X?Z?\\?]?b?e?x?{@L@M@S@\\@d@w@zAJALARA[AcAiAjAlAmAnAo"},
  {0,NULL,"ApAsAwAyA{BABCBFBGBKBVBYBZB^B_B`BaBbBhBiBlBrByBzB{C?CCCECFCHCNCTC"},
  {0,NULL,"XCYC\\C_CoCwD?D@DBDCDDDHDNDODPDVDXD]D_DdDgDqDwDyD}E@EMESEUE^E`EeEf"},
  {0,NULL,"EiEjElEqEtEuEwE{F?F@FAFBFEFJFL_@?A?F?H?M?N?R?V?W?[?\\?_?a?b?u?|@G@"},
  {0,NULL,"U@W@Z@_@tA@AFANATAUA^AdAfAhAjAkAoAqArAzA{BDBEBHBIBJBKBNBPBUBYB[B`"},
  {0,NULL,"BdBeBhBjBmBrBtBwBxB~CFCGCICLCQCTCVC]CaCmCrCuCyC~DADCDDDFDGDHDMDND"},
  {0,NULL,"SDWDbDfDpDrDxD{D|EFEIEUEZE^EbEcEhEjEkEnEqErEvEwE{E|F?FBFCFDFIFJFK"},
  {0,NULL,"_@?A?D?I?K?L?S?X?Y?Z?[?^?_?a?q@C@H@N@T@\\@`@pAAAHAMASA[A_AiAjAlAmA"},
  {0,NULL,"nAoAtAuA|B@BABGBIBJBLBMBPBQBRBTBVB[B]BbBgBjBmBsBtB{B}B~C@CDCECICL"},
  {0,NULL,"CMCZC[CcCeCqCvCyC|D@DDDEDKDNDODRDSDYDZDcDiDjDmDvDzD~E?EHEOEREYEaE"},
  {0,NULL,"eEhEjEkEoEpEsEuEvExE|E~FAFBFEFGFHFP_@?A?G?J?O?P?R?T?V?Z?[?^?a?d?s"},
  {0,NULL,"@F@H@O@Z@b@c@nADAHANAPAYAbAdAeAgAiAkAnApAsAxA|A~B?B@BBBDBEBNBQBTB"},
  {0,NULL,"XBYB\\B`BdBfBhBiBkBpBvBxCBCFCHCQCRCSCUCZC`CbCeCvCxC|C}D?DADBDKDMDP"},
  {0,NULL,"DRDTDXD[D^DhDjDmDxD{EBEDEMEOESEYEaEdEeEkEnEqErEsEvExEyEzF?FAFBFDF"},
  {0,NULL,"MFOFQFR_@?A?F?J?M?O?R?V?W?Z?[?\\?^?a?p?|@H@O@U@Z@d@vA@AHANATAYAcAd"},
  {0,NULL,"AfAhAjAkAoApAsAyA~B?BABCBDBEBGBNBPBUBYB[B`BdBeBhBiBkBpBqBvBxCBCFC"},
  {0,NULL,"HCKCQCRCSC[C^CcCgCtCuCyCzC}DADDDFDLDMDNDQDSD[DcDiDkDlDxD{EBEDEHEI"},
  {0,NULL,"EREZEaEgEhEiElEmEoEpEuEwE{E|F@FAFEFFFHFLFOFPFR_@?A?G?I?K?O?S?U?V?"},
  {0,NULL,"\\?]?`?b?c?t@B@I@Q@R@X@[@r@|AGAQAWAZAaAdAeAgAiAkAnAtAuAvAzA|A}B@BA"},
  {0,NULL,"BGBHBOBUBXBZB\\B_BcBeBfBhBlBqBrBuB|CCCFCJCKCPCTCUC[C^CcCgCpCqCrCwC"},
  {0,NULL,"{DCDEDHDIDVDWDYDZD\\D`DbDfDuDvDzEBEDELEQE[E\\EaEdEeEjEkEoEqEsEwEyEz"},
  {0,NULL,"E}F?FCFEFFFHFJFKFLFN_@?A?D?H?K?M?S?X?Y?^?_?`?a?d?v@C@K@N@P@W@`@oA"},
  {0,NULL,"AAKAMAUA]A_AiAjAlAmAnAoAqArAwAzA~B?BFBHBIBJBPBQBRBTBVB[B]BbBfBgBi"},
  {0,NULL,"BnBrBxB}CDCHCMCOCQCTCUCdCfCiClCqCsCtCvCyC{C|DIDJDKDLDRDSDYD`DoDtD"},
  {0,NULL,"uDvDzD}E@EHENERE_E`EeEfEiEmEnEqEtEuEvE{E|F?FCFDFFFIFKFMFNFOFQ_@?A"},
  {0,NULL,"?E?H?N?P?S?U?Y?Z?[?\\?]?e?o?}@L@Q@T@^@_@sACAJAOASA^AaAeAfAgAhAlAmA"},
  {0,NULL,"qArAvA{A}BDBEBKBLBMBRBUBVBXB\\B]BbBeBkBqBsBtBvBwB|B~C@CBCGCJCKCRCY"},
  {0,NULL,"C_CdCfCsCuCxCzC{D?D@DFDIDJDODQDTDXD_DeDqDsDvDzECEEEMESEVEWE`EfEgE"},
  {0,NULL,"jEkElEoEsEvEyE{E|F?FBFCFEFGFJFPFQFRFU_@?A?E?H?N?P?R?W?Y?[?\\?]?_?b"},
  {0,NULL,"?o@E@G@U@Y@^@_@sAEAFAOATAXA^AeAfAgAhAlAmAqArAvA{A}BDBEBKBLBMBPBSB"},
  {0,NULL,"UBWB[B^BaBeBhBlBmBrBtBwBxB~CCCFCGCICQCTCWChCjCkCpCuCvC{C~D?D@DFDG"},
  {0,NULL,"DIDKDODXD\\DeDjDmDsDxD{D|EFENEPEXE_EbEdEfEiElEoEpEsEuEzE}E~F@FAFDF"},
  {0,NULL,"FFHFKFMFNFOFT_@?A?D?H?K?M?R?T?Y?^?`?c?d?e?v@A@J@P@S@`@b@o@{AIAPAR"},
  {0,NULL,"A]A_AiAjAlAmAnAoAqArAwAzA~B?BFBHBIBJBQBSBTBWBXB\\B^BaBgBkBnBpBuBzB"},
  {0,NULL,"|C?CBCJCMCOCPCSCVCWChCmCoCqCsCtCuCvDCDFDHDJDKDLDYD]DkDlDoDtDxD{EA"},
  {0,NULL,"EGEQEVEWE\\EbEfEhEkEmEnEqErEyEzE}E~F@FAFBFEFGFHFJFLFPFRFS_@?A?G?H?"},
  {0,NULL,"K?P?S?U?V?Z?\\?]?c?e?r@B@L@Q@[@^@b@q@|AJAOAPAZAaAdAeAgAiAkAnAqArAv"},
  {0,NULL,"AwA}A~B?BFBLBMBOBUBXBZB\\B_BcBeBkBoBqBsBtBwB|B~C@CACBCGCJCKCXC\\CiC"},
  {0,NULL,"lCwCxCyC{C}DCDEDHDIDSDTDVDZD[DcDdDgDiDvDzECEEELEUE[E^E`EcEeEiEmEn"},
  {0,NULL,"EpEtEwEzE}E~F@FAFBFDFIFOFPFSFXFY_@?A?G?H?K?P?R?T?V?Z?^?c?d?e?r@F@"},
  {0,NULL,"J@O@P@Q@b@qADAIAPAYA]AaAdAeAgAiAkAnAqArAvAwA}A~B?BFBLBMBNBQBTBXBY"},
  {0,NULL,"B\\B`BdBgBkBnBpBzB{B|C?CBCECJCMCOCSC]CaCjCkCvCxC}C~DBDCDEDGDHDKDPD"},
  {0,NULL,"TDZD[DaDdDgDnDxD{EAEGEJEOEYE]EbEcEdEiElEoEpEtEvExE{E|F?FCFEFFFGFL"},
  {0,NULL,"FNFTFUFVFW_@?A?G?J?O?P?Q?T?U?[?_?`?a?d?s@@@K@O@R@a@c@n@~AKAQAYA`A"},
  {0,NULL,"bAdAeAgAiAkAnApAsAxA|A~B?B@BBBDBEBNBSBVBWBZB_BbBdBjBmBoBpBtBuBvB~"},
  {0,NULL,"CACICLCPCRCSCYC_CdCfCoCpCrCvC|DADBDKDMDPDRDWD\\D]D^DhDoDtDwDyECEEE"},
  {0,NULL,"KENETE_E`EcEeEmEnEpErEsEuEwE{E~F@FCFEFFFGFHFJFKFTFUFVF[_@?A?G?I?K"},
  {0,NULL,"?O?Q?T?U?[?\\?_?`?b?t@@@G@R@[@\\@c@r@~AFAQAZA[AbAdAeAgAiAkAnAtAuAvA"},
  {0,NULL,"zA|A}B@BABGBHBNBSBVBWBZB_BbBdBnBqBuBvByB{B}CDCECKCNCOCPCRCVCWChCm"},
  {0,NULL,"CpCrCwCzC{C|DADIDMDQDRDVDWD\\DbDeDfDsDwDyEAEGEIENEZE_EbEcEdEjElEoE"},
  {0,NULL,"qEtEuExE{E|E~FAFBFDFIFMFPFQFRFSFXFZ_@?A?F?J?M?O?Q?W?X?Z?\\?]?^?e?p"},
  {0,NULL,"@?@L@M@Z@]@d@vA?AJALANA\\AcAdAfAhAjAkAoApAsAyA~B?BABCBDBEBGBOBRBYB"},
  {0,NULL,"]B^B`BaBcBgBhBiBlByBzB{C?CCCECFCHCMCNCdCfCiClCoCpCuCzC}DDDEDFDNDQ"},
  {0,NULL,"DZD[D\\D]DcDeDiDsDwDyD}E@ELEVEWE[E`EcEgEmEoEpErEsEvExEyEzE}FBFCFDF"},
  {0,NULL,"GFIFKFNFQFSFWFZ_@?B?C?E?G?P?U?f?l?m?n?r?s?t?z@@@B@E@F@^@a@jAFAGAH"},
  {0,NULL,"AIALAMANARATAUAWA[A\\A]A_AcAhAjAmAoBABHBTB`BgBiBkBmBpBvBwB|C@CJCKC"},
  {0,NULL,"LCNCPCRCTCWCYC[C\\C`CaCdClCnCtCuD@DHDIDMDPDRDSDTDZD\\D]D^DdDgDhD|D~"},
  {0,NULL,"E?EFELENE[E_E`EcEeEhEjEmEnEpEvEwE~F@FZF\\_@?B?C?F?G?O?V?h?l?m?n?r?"},
  {0,NULL,"s?t?u@?@@@B@F@X@Z@iAFAIAJAKALAMAOARASAVAXA[A]A^A_A`AhAlAmAoBFBLBW"},
  {0,NULL,"BbBiBlBmBpBqBuBvB}C?C@CBCJCKCQCSCTCVCYC[C`CeCgCkClCnCsCuDDDIDKDMD"},
  {0,NULL,"PDVDWDXDYDZD[D^DbDfDhD|D}E@EFELEOEYE[EaEdEeEfEiEkEqEsEuEyEzF?FSFU"},
  {0,NULL,"_@?B?C?D?F?M?X?f?i?k?l?p?q?u?y?|@?@A@D@M@`@mAFAGAHAIAOAPAQASAVAXA"},
  {0,NULL,"YAZA^A`AaAbAeAgAiAlAvBBBUBdBhBiBnBrBtBvBxBzCACCCDCECHCJCTCUCXC[C]"},
  {0,NULL,"C_C`CfChCiCqCvCwD?DGDJDNDQDSDTDWD[D\\D]DcDiDpDrD~E?EAEGEKETEVEWE`E"},
  {0,NULL,"cEdEgEoErEsEtExEzE{E}FHF^F`_@?B?C?D?G?K?T?g?j?k?m?q?s?v?x?{@A@B@C"},
  {0,NULL,"@R@b@kAGAHAJAKANAOASATAUAVAWAXA\\A^A`AcAfAgAhAkBCBKB[B]BgBjBnBqBxB"},
  {0,NULL,"{B|B}C?CCCECGCNCOCRCSCVCWCXCZC^CaCfCkCpCrCxC}DFDHDJDKDLDNDODRDUDV"},
  {0,NULL,"DjDmDoDtEBECEDEEEQEUE\\E^EbEfEgEhEkElEmErEyE|E}F@FKFYF_F`Fa_@?B?C?"},
  {0,NULL,"E?F?N?W?g?i?j?n?o?p?w?z?}?~@D@E@U@]@hAGAHAJAKALAMAPAQARAYAZA[A]A_"},
  {0,NULL,"AaAbAdAiAjAnAwA|BVB\\BfBjBkBrBsBtBwB{CACFCGCHCICLCOCPCZC\\C]C^CdChC"},
  {0,NULL,"jCmCoCyDADEDFDGDIDKDPDQDUDVDXDYDeDkDlDsD}E@EBEDEJEPEXE]EbEdEeEfEi"},
  {0,NULL,"EpEqEsEuEzE~F?FGFXF_Fa_@?B?C?D?E?L?Y?h?j?k?m?o?q?v?x?{?~@A@C@T@Y@"},
  {0,NULL,"lAFAIAJAKANAPAQATAUAWAYAZA\\AaAbAcAdAfAgAkAzB?BYB_BhBjBoBqByBzB{B}"},
  {0,NULL,"B~C?CDCGCMCOCSCUCVCZC^C_CbCcCiCkCpCxCzC~DHDLDMDODRDSDXDYDZD]D_DjD"},
  {0,NULL,"mDqD|ECEEEFEHEQERE\\EaEcEeEhEjEnEoEpEvEwExE~FNFRFaFc_@?B?C?D?E?L?Y"},
  {0,NULL,"?h?i?j?n?o?v?w?z?{?}?~@E@N@S@lAFAIAJAKANAPAQATAUAWAYAZA\\AaAbAcAdA"},
  {0,NULL,"jAkAnA}BEBNBcBfBjBmBoBpBsByB{B~C@CFCGCICKCMCOCYCZC^CbCcCjClCmCoCy"},
  {0,NULL,"C|DCDGDLDODQDTDWDXDYD[D\\D`DkDlDuD}E@EAEGEMEPESEXEaEcEdEgEnEoErEtE"},
  {0,NULL,"wExE{E}FJFOF_Fb_@?B?C?F?G?O?V?h?i?k?l?p?r?u?y?|@?@@@D@O@[@iAFAIAJ"},
  {0,NULL,"AKALAMAOARASAVAXA[A]A^A_A`AeAiAlAmA{BJBRB^BfBhBiBlBsBuBvBzCBCDCFC"},
  {0,NULL,"ICJCQCTCUC[C_C`CeCgCiCjCmCvCwC{DBDFDJDLDMDNDODUDWDZD[DaDcDiDnEAEC"},
  {0,NULL,"EEEGEIEKETEZEaEfEgEhEiEkElEmEuEyE|F@FIFTF_Fc_@?B?C?D?F?M?X?f?j?k?"},
  {0,NULL,"m?q?v?x?y?{?|@A@C@W@d@mAFAGAHAIAOAPAQASAVAXAYAZA^A`AaAbAeAfAgAkB@"},
  {0,NULL,"BMBSBXBgBhBnBoBxByBzB|B~CCCDCECMCNCRCUCWCXC_CaCbCcCfCiCrCzC}C~DID"},
  {0,NULL,"JDKDNDPDSDVDXDYD]D_DoDqDtD|EBEDEFEHEREUE^E`EdEeEfEiEqEsEtEuEzE{F?"},
  {0,NULL,"FPFVFeFf_@?B?C?D?G?K?T?g?l?m?n?r?s?t?x@@@B@C@F@P@\\@kAGAHAJAKANAOA"},
  {0,NULL,"SATAUAVAWAXA\\A^A`AcAfAhAmAoAxBDBOBeBgBkBlBqBuBwB|B}C?CBCLCNCPCQCR"},
  {0,NULL,"CSCVCWC\\CaCdCeCgCkCsCtD@DDDGDHDKDQDRDTDVDWD[D\\DbDdDfDgD}D~E?E@ENE"},
  {0,NULL,"OEYE_EbEcEdEgElEoErEtExE{E|E}F[F]FdFfFg_@?B?C?E?F?N?W?g?i?k?l?p?u"},
  {0,NULL,"?w?y?|?}@?@D@V@_@hAGAHAJAKALAMAPAQARAYAZA[A]A_AaAbAeAiAlAnA~BGBQB"},
  {0,NULL,"ZBfBlBnBrBsBtBuBxCACBCCCECFCHCICQCXC]CeCfCgChCjCmCqC{D?DBDFDGDHDM"},
  {0,NULL,"DQDRDSDUDZD]DaDnDpDrD~E?ECEEEIEVEWEZEbEcEeEhEjEnEpEqEvEwE~F?FLFQF"},
  {0,NULL,"`FeFg_@?B?C?E?G?P?U?f?i?j?n?o?t?w?z?}?~@E@F@Q@c@jAFAGAHAIALAMANAR"},
  {0,NULL,"ATAUAWA[A\\A]A_AcAdAjAnAoAyBIBPBaBkBmBoBpBrBtBwByB~C@CACHCKCLCMCPC"},
  {0,NULL,"YC\\C]CbCcCdChClC|DADCDEDFDIDJDLDNDODPDTDUD\\D`DeDsDuEAEBEDEGEJEMES"},
  {0,NULL,"E]E`EfEgEhEjEkElEmEvEyE|F@FMFWF`FdFhFi_@?B?I?J?L?O?Q?f?g?j?l?t?w?"},
  {0,NULL,"x?y@H@I@V@\\@c@d@g@{@|A@AAABACADAEAOAPATAUA]A^A_AaAqArA~BDBIBMBNBR"},
  {0,NULL,"BWBYB^B_BbBcCACCCECGCHCJCLCNCOCPCRCTCnCoCpCsCwC{C~DCDFDKDSDTDUDVD"},
  {0,NULL,"\\D]D_D`DaDbDhDiDjDkEHEIEMEOERESEYEZE`EbEcEfEjElEqEtFAFCFLFMFPF]Fg"},
  {0,NULL,"FhFiFj_@?B?H?J?M?P?R?g?h?k?n?s?u?v?w@K@L@S@Z@_@b@e@z@|@}@~A?AAABA"},
  {0,NULL,"CAMAQASAVAWAZA[A\\AtAuA}BCBGBLBPBSBTBUBXB`BaBdC?CBCDCFCGCICLCOCPCQ"},
  {0,NULL,"CSCUCnCqCrCtCvC|C~DADGDKDLDMDODQDVDZD_DcDdDeDhDoDrDuELEMESEUEVEWE"},
  {0,NULL,"[E^EaEbEdEhEkEnEqErFBFFFJFQFSFYF`FbFeFi_@?B?I?J?L?O?Q?f?g?j?l?p?q"},
  {0,NULL,"?s?z@H@I@M@R@]@a@g@{@|A@AAABACADAEAOAPATAUA]A^A_AaAqArAvAwBHBKBNB"},
  {0,NULL,"RBWBYB^B_BbBcB~CACBCCCECHCLCMCNCPCQCRCuCvCxCyCzC|DBDDDGDHDIDJDNDP"},
  {0,NULL,"DQDRD^DcDfDlDmDnDqDuEKELEPEQETEXE[E\\E`EbEcEfEmEpErEsFAFCFGFKF\\F^F"},
  {0,NULL,"_FaFbFc_@?B?H?I?K?N?S?f?h?i?m?r?v?y?z@G@J@N@W@[@^@f@z@{@}@~A?A@AD"},
  {0,NULL,"AEALANARAXAYA`AbAcApAsA{B@BABEBOBQBVBZB[B\\B]BeB~C?C@CACDCHCJCKCMC"},
  {0,NULL,"SCTCUCoCqCsCtCxC}DBDEDJDMDNDTDXDYDZD\\DbDdDkDmDnDrDsDtEIENEPEUEXEZ"},
  {0,NULL,"E^E_E`EaEeEgEiEmEnEtFDFEFIFOFVFZF_FeFfFg_@?B?H?I?K?N?S?f?h?i?m?o?"},
  {0,NULL,"q?t?u@G@J@Q@T@X@`@f@z@{@}@~A?A@ADAEALANARAXAYA`AbAcApAsAyB?BBBFBO"},
  {0,NULL,"BQBVBZB[B\\B]BeB~C@CDCFCICJCKCMCNCRCTCUCpCrCyC{D?D@DADDDIDLDODPDSD"},
  {0,NULL,"WD[D]DaDeDfDgDjDlDoDpEJEOEQEVEWEYE\\E]E`EaEeEgEjEkEoEsFDFEFHFRFUFW"},
  {0,NULL,"F`FaFdFj_@?B?H?J?M?P?R?g?h?k?n?o?p?r?x@K@L@O@P@U@Y@e@z@|@}@~A?AAA"},
  {0,NULL,"BACAMAQASAVAWAZA[A\\AtAuAxAzA|BJBPBSBTBUBXB`BaBdC?C@CBCCCECFCGCICK"},
  {0,NULL,"COCQCSCuCwCzC}D?D@DCDEDFDHDRDUDWDXDYD[D^D`DgDiDpDqDsDtEHEJEKENERE"},
  {0,NULL,"TE]E_EaEbEdEhEiElEoEpFBFFFNFTFXF[FcFdFfFh_@?B?F?H?M?N?e?f?j?m?r?v"},
  {0,NULL,"?x?y?z@A@J@U@W@^@d@t@z@|@}AAADAEAGAHAMAQAXAYAZA[A`AbAgAsA|B@BABMB"},
  {0,NULL,"NBOBQBRBZB^BcBeBgBhBkBmBnBuB|B~CDCMCUCWCXCYC_CaCdCeCnCoCsCzC|C}DE"},
  {0,NULL,"DJDNDXDYDbDhDkDqDsDtDuDxD{D|EFEIEUEZE^EbEcEhEjEkEnEqErE~FFFHFLFQF"},
  {0,NULL,"YF_FaFbFcFdFkFoFp_@?B?E?I?L?N?b?g?k?l?t?u?w?x?y@D@I@T@V@\\@_@y@{@|"},
  {0,NULL,"@~A?A@AAAJAKANAPAYA]A_AaAbAcAiArA~B?BDBGBNBPBSBWBXBaBbBcBfBgBlBpB"},
  {0,NULL,"qBtBuCACCCECHC]CaCeCgCkClCmCnCpCtC{C}C~D?DFDSDUD]D_DaDdDhDjDpDtDv"},
  {0,NULL,"DzD~E?EIEMESEZEaEdEgEiEmEnErEtExFEFGFIFJFOFaFcFdFfFhFlFmFo_@?B?E?"},
  {0,NULL,"H?N?P?d?g?k?l?s?u?v?w?y@D@K@V@^@_@b@s@{@|@~A?A@AAAGAHALAMANAQARAZ"},
  {0,NULL,"A[AcAiAuA~BABCBGBNBPBSBWBXBaBbBcBgBnBqBrBsBxByCBCFCICQCXCaCcCfChC"},
  {0,NULL,"jCkCnCpCqCtC~DBDDDGDMDQDZD_DdDfDhDjDnDrDvDzECEEEMESEVEWE`EfEgEjEk"},
  {0,NULL,"ElEoEsF@FDFHFMFWFXF_FaFbFcFfFkFnFpFq_@?B?D?H?K?M?\\?f?i?l?o?p?q?t?"},
  {0,NULL,"u?|@G@M@P@Q@`@o@~A?ABACADAEAGAHASAVAWAXAYA\\A`AbAeApAvAxAyBBBVBWBY"},
  {0,NULL,"B[B\\B]B_BbBjBpBrBtBwBxBzCDCJCTCUCZC\\C]CfChCiClCnCwCyC|D?D@DDDSDWD"},
  {0,NULL,"[D]DfDgDhDiDlDpDuDxD{EAEGEQEVEWE\\EbEfEhEkEmEnEqErE|FFFKFQFVFYFfFg"},
  {0,NULL,"FhFiFjFmFnFp_@?B?E?H?N?P?d?f?l?m?r?s?v?y?z@F@J@W@^@_@a@s@{@|@~A?A"},
  {0,NULL,"@AAAGAHALAMANAQARAZA[AcAoAsB@BABGBHBNBRBVB[B\\B]B^BcBgBhBkBmBnB{B|"},
  {0,NULL,"C@CJCKCTCWCXCYC^C_CaCdCnCqCtCwCxCzDBDMDTDZD\\DdDhDiDmDnDqDrDxD{D|E"},
  {0,NULL,"FENEPEXE_EbEdEfEiElEoEpEsF?FBFGFWFXF[F`FgFhFiFjFlFmFoFr_@?B?F?J?M"},
  {0,NULL,"?O?`?f?j?m?t?v?w?x?y@A@I@W@Z@c@d@v@z@|@}AAADAEAFAIAMAOAPASAVA[A^A"},
  {0,NULL,"aAgArB@BIBLBMBNBOBQBRBZB^BcBeBkBmBoBsBxByBzCCCECNCRCYCbCcCdCfCiCj"},
  {0,NULL,"CnCoCrCsC~D@DEDKDSDVD]D_DbDgDhDkDoDsDxD{EBEDEHEIEREZEaEgEhEiElEmE"},
  {0,NULL,"oEpEyFBFIFNFTF^F`FaFbFdFjFlFmFnFrFu_@?B?F?J?M?O?`?h?m?n?s?t?u?v?w"},
  {0,NULL,"@@@K@S@X@Z@d@v@z@|@}AAADAEAFAIAMAOAPASAVA[A^AaAmAuA}BFBLBMBPBQBUB"},
  {0,NULL,"ZB[B]BaBdBlBmBoBpBtBvB{C?CBCQCSCYC[C]C^CbCgClCnCrCsCxCyC~DADKDMDV"},
  {0,NULL,"DZD_DbDeDhDlDmDoDwDyD}E@ELEVEWE[E`EcEgEmEoEpErEsE{FAFHFTF\\F^F_FeF"},
  {0,NULL,"fFgFhFkFoFpFqFs_@?B?D?J?L?M?a?h?i?n?s?u?v?w?z?~@K@M@N@S@Z@w@~A?AB"},
  {0,NULL,"ACADAEAFAIAOAPAQAWAZA\\A^AaAdAuAvA}BEBLBQBSBTBXBZB[B]B`BlBmBoBpBvB"},
  {0,NULL,"{B|CFCGCICOCWCYC[C^CbCgClCqCsCtCvCyC{C|DGDLDODQDaDbDcDdDlDrDuDwDy"},
  {0,NULL,"D}E@EMESEUE^E`EeEfEiEjElEqEtEzFCFMFNFPFVF`FaFcFdFjFmFnFpFsFtFv_@?"},
  {0,NULL,"B?D?J?L?M?a?f?i?l?p?q?s?u?z?|@H@M@S@`@a@w@~A?ABACADAEAFAIAOAPAQAW"},
  {0,NULL,"AZA\\A^AaAeAqAvA}BBBHBVBWBYB[B\\B]B_BbBhBiBnBpBqBvBwCACCCECHCXC[C\\C"},
  {0,NULL,"_C`CkClCqCvCyC|D@DDDEDGDJDNDQDcDfDgDlDrDsDuDxD{D~E?EKEQETE\\EaEeEh"},
  {0,NULL,"EiEjElEoEpEwFBFNFPFRFTF_FeFfFgFiFkFlFoFuFw_@?B?F?H?M?N?e?g?j?n?o?"},
  {0,NULL,"p?r?x?z?}@L@P@U@W@]@t@z@|@}AAADAEAGAHAMAQAXAYAZA[A`AbAnAtAwAxA|B@"},
  {0,NULL,"BRBTBUBYB^B_B`BdBfBkBtBvBwB|B}CFCGCICOCVCWC[C\\C]CdCmCoCpCuCzC}DDD"},
  {0,NULL,"EDFDUDXDYD^DfDjDkDqDsDtDvDzD}E@EJEKETE]E`EcEgEjEkEoErEsE{FDFHFQFW"},
  {0,NULL,"F^FeFgFhFiFjFlFmFnFtFuFv_@?B?E?I?L?N?b?h?k?m?o?q?t?u?x?{@G@T@V@X@"},
  {0,NULL,"Y@y@{@|@~A?A@AAAJAKANAPAYA]A_AaAbAcAkApAzA~B?BFBOBPBUBVB\\BaBdBeBi"},
  {0,NULL,"BkBoBqBuB{B}B~CDCMCUCVC^C`CbCdCeCkCpCuCvC{C~D?D@DLDODSD]D^D_DaDcD"},
  {0,NULL,"gDjDpDwDyD|EFEJEQE\\E]EbEdEfEiEmEpErEsF?FAFGFKFOFXF`FbFeFgFiFkFnFp"},
  {0,NULL,"FsFtFw_@?B?D?H?K?M?\\?g?l?n?o?p?r?t?x@B@L@P@U@\\@`@o@~A?ABACADAEAGA"},
  {0,NULL,"HASAVAWAXAYA\\A`AbAhAtAxA|BBBDBPBRBSBXBYB^B_BaBfBkBoBtBwB|B}C?CBCQ"},
  {0,NULL,"CSCVCWC\\C]CbCdCmCoCwD?D@DBDCDDDHDRDWD[D`DfDgDiDkDnDpDvDzD}E@EHENE"},
  {0,NULL,"RE_E`EeEfEiEmEnEqEtEzFEFPFVFYFZF_F`FaFbFcFkFlFoFqFrFy_@?B?G?H?K?P"},
  {0,NULL,"?_?f?i?j?o?q?t?u?w@E@G@Q@`@b@c@q@z@{@}A@ABACAGAHALANARASAVAWA\\AcA"},
  {0,NULL,"jApAyBBBCBIBOBQBWBYBZB_BbBeBlBpBrBtBwBxBzB~C@CKCMC\\C]CfCgChCiClCp"},
  {0,NULL,"CrCwCzC{C|DADIDLDODPDaDeDiDjDoDqDuDxD{EAEGEJEOEYE]EbEcEdEiElEoEpE"},
  {0,NULL,"tE}FBFXFZF[F]F_FaFbFcFeFkFlFnFsFvFyF{F|_@?B?D?I?K?L?c?g?l?n?r?t?w"},
  {0,NULL,"?x?y@B@I@N@P@V@\\@p@~A?ABACADAEAJAKANAOATAUAYA^AbAcAhArAxA~BDBEBPB"},
  {0,NULL,"RBSBXBYB^B_BaBfBgBhBlBqBtBuCLCNCPCRC]C_CaCeCgCkCmCoCsCtCwD?DADCDK"},
  {0,NULL,"DTDVD\\D`DbDdDeDiDkDpDvDzD~E?EHEOEREYEaEeEhEjEkEoEpEsEwFDFKFNFRFUF"},
  {0,NULL,"_F`FbFeFiFmFnFpFsFtFvFxFzF{_@?B?D?I?K?L?c?h?i?n?r?v?w?y?z?~@J@N@S"},
  {0,NULL,"@[@\\@p@~A?ABACADAEAJAKANAOATAUAYA^AbAcAdAsA{A}BDBEBQBSBTBXBZB[B]B"},
  {0,NULL,"`BfBjBlBsBvBxByB~C@CKCMCZC[CcCfCgCjCmCoCqCsCtCuCvDCDTDXDYD\\D^D`Db"},
  {0,NULL,"DcDdDkDrDwDyEAEGEPEUEXE^EbEfEhEkEmEpErEsE|FAFGFKFRFYFcFdFfFhFjFkF"},
  {0,NULL,"lFoFqFrFuFwFyF|_@?B?F?I?N?O?[?g?j?n?o?p?q?s?z?}@H@R@U@X@]@x@z@|@}"},
  {0,NULL,"AAADAEAJAKALAPARAXA]A_A`AaAnAqAwA|BFBKBRBTBUBYB^B_B`BdBjBrBsBzB{B"},
  {0,NULL,"|B}CACHCLCPCVCWCZC^ChCiCjCtCuCyCzC}DADDDGDIDPDQD^DdDeDfDlDqDtDvDz"},
  {0,NULL,"EBEDEKEPETEXEaEgEhEiElEmEnEtEyFEFIFLFOFTF`FbFeFiFjFkFoFpFqFwFyF{F"},
  {0,NULL,"|_@?B?F?I?N?O?[?h?m?n?o?q?s?t?u@@@G@T@X@Z@]@x@z@|@}AAADAEAJAKALAP"},
  {0,NULL,"ARAXA]A_A`AaAmApAwB?BFBLBPBQBUBZB[B]BaBdBiBnBoBqBuB{B}C@CJCKCTCVC"},
  {0,NULL,"XC^C`CbCeCkCrCuCyC~DADCDDDIDPDWD[D^D_D`DeDfDlDoDwDyD|EFEOEVEWEYEb"},
  {0,NULL,"EcEhEjElEnEqEtE~FCFIFLFQF]F_FcFdFfFhFlFmFnFrFtFvFxFzF}_@?B?E?J?L?"},
  {0,NULL,"P?Z?f?l?m?p?q?r?s?z@F@H@M@Y@^@a@u@{@|@~A?A@AAAFAIAQATAUAWAZA\\A]A_"},
  {0,NULL,"AoAqAvAzBABHBNBRBVB[B\\B]B^BcBfBhBiBnBpBvBwCLCNCPCRCXC[C\\C_C`ClCmC"},
  {0,NULL,"qCrCuCxCzD@DBDHDIDPDRD^DgDmDnDoDqDrDxD{D~E?ELEPEXE[EaEdEgEkEnEqEr"},
  {0,NULL,"EtExFFFJFMFOFSF`FaFdFhFjFkFnFpFqFsFtFxF{G@_@?B?G?H?K?P?_?g?j?k?q?"},
  {0,NULL,"s?u?v?w@C@K@Q@R@_@b@q@z@{@}A@ABACAGAHALANARASAVAWA\\AcAfAuAyBCBGBK"},
  {0,NULL,"BNBTBUBWB`BbBcBdBgBiBnBqBrBsBxC?CGCOCSCXC`CaCfChCjCkCoCpCrCvC|DAD"},
  {0,NULL,"BDKDLDODVDcDeDjDkDnDoDuDvDzECEEELEUE[E^E`EcEeEiEmEnEpEtEvFEFVFZF["},
  {0,NULL,"F\\FdFgFhFiFjFmFoFpFrFtFuFwFxG@_@?B?E?J?L?P?Z?h?k?m?o?p?q?r?x?{@L@"},
  {0,NULL,"O@T@Y@a@u@{@|@~A?A@AAAFAIAQATAUAWAZA\\A]A_AkAtAzB?BHBJBOBPBUBVB\\Ba"},
  {0,NULL,"BdBeBhBiBjBrBuByBzC?CGCOCSCZC_C`CcCeChCiCsCuCxCzC{D?D@DHDRDXDYD^D"},
  {0,NULL,"aDbDgDmDpDqDwDyECEEEHEJERE]E`EfEgEjEkElEqEtF@FCFJFMFPFWF_FbFeFfFg"},
  {0,NULL,"FlFmFoFrFuFyFzF|GA_@?B?G?J?O?P?]?f?i?j?o?t?w?x?y@E@I@O@Q@c@d@n@z@"},
  {0,NULL,"{@}A@ABACAFAIAMASATAUAVA[A]A_AjArAyBIBJBMBOBQBWBYBZB_BbBeBkBmBoBx"},
  {0,NULL,"ByBzB}CACHCLCPCVCYCbCcCdCfCiCpCqCrCwC{DCDEDFDTDUD\\D`DaDiDjDoDrDsD"},
  {0,NULL,"xD{EBEDEMEOESEYEaEdEeEkEnEqErEsEuFFFJFSFUF\\F_FcFeFfFgFmFoFpFqFrFt"},
  {0,NULL,"FwF~GCGD_@?B?G?J?O?P?]?h?i?k?o?p?r?x?y@?@L@O@Y@[@c@n@z@{@}A@ABACA"},
  {0,NULL,"FAIAMASATAUAVA[A]A_AlAtAzA{BIBJBOBSBTBVBXB\\B`BeBgBhBiBjBuByBzCBCF"},
  {0,NULL,"CICQCZC_C`CaCcCeCiCwCxCyC{C}DCDEDFDUDWD[D`DaDiDlDmDsDtDwDyECEEEKE"},
  {0,NULL,"NETE_E`EcEeEmEnEpErEsEvFAFSFZF\\F^F`FaFdFiFjFkFlFnFvFzF{F|F}G?GB_@"},
  {0,NULL,"?B?G?I?K?O?^?g?j?k?p?q?s?v?z@C@H@R@[@]@b@r@z@{@}A@ABACAJAKALAOARA"},
  {0,NULL,"TAUAXA^A`AfAqAwA{BCBKBNBTBUBWB`BbBcBdBjBmBrBsB{B|B}CCCECNCRCVCWCY"},
  {0,NULL,"CZC^ChCjCvCxC|C}D?DADBDHDJDNDRDcDeDmDnDpDtDuDvDzEBEDELEQE[E\\EaEdE"},
  {0,NULL,"eEjEkEoEqEsEuFDFRFSFUF]FcFdFfFgFhFkFlFnFsFyFzF}G?GAGBGF_@?B?G?I?K"},
  {0,NULL,"?O?^?h?i?k?p?r?v?y?z@?@J@N@O@R@[@r@z@{@}A@ABACAJAKALAOARATAUAXA^A"},
  {0,NULL,"`AlAsA{BEBJBKBOBSBTBVBXB\\B`BeBfBjBlBsBvBwByCDCJCTCUCZC[C\\CcCgCjCm"},
  {0,NULL,"CvCxC}C~DBDCDEDJDMDNDZD_D`DcDmDnDsDtDwDyEAEGEIENEZE_EbEcEdEjElEoE"},
  {0,NULL,"qEtE}FCFLFUF[F]F`FaFbFeFiFmFoFpFqFuFxF~G@GCGDGE_@?C?F?Q?W?X?_?g?j"},
  {0,NULL,"?n?w?~@@@C@D@E@K@U@\\@]@d@n@o@r@s@w@yA?AGAHAOAPARASAYAZA]AaAnApAsA"},
  {0,NULL,"vAzA{B?BABBBHBJBVBXB\\BeBfBjBsB{C?CACFCJCLCPCRC\\C`CaCdChCjCkCnCrCs"},
  {0,NULL,"CxCyC~DADFDUDXDYDcDeDiDsD{D}E@EHEJEOEPEQE[E^E`EcEgEtEvExEyEzE}FEF"},
  {0,NULL,"HFLFMF^FeFgFhFiFjFkFwFzG@GC_@?C?F?R?V?W?c?h?m?n?r?~@?@A@B@F@J@U@X"},
  {0,NULL,"@Y@Z@n@o@r@s@w@yA@AJAKALAMAOAQASA[A_AbAmAqArAvAyA~BBBCBGBIBKBVBWB"},
  {0,NULL,"_BbBiBmBpBvB~C?CBCECOCSCTCVCZC[CcCfCgCkCnCoCsCzC|C}DEDIDPDWD[DbDf"},
  {0,NULL,"DpDrDzD|EFEOERESEUEXE[E]EbEcEhEpEvEwE{E|F?FAFLFQFTF[F_FcFdFfFhFpF"},
  {0,NULL,"qFwG?GAGI_@?C?E?R?W?Y?^?h?k?m?v?~@?@A@C@F@J@T@Y@Z@_@n@p@q@t@w@xAE"},
  {0,NULL,"AJAKALAQAUAWAZA[AaAbAkAqArAvAwAxAyA|BBBDBIBYBZB_BbBhBoByBzB~C?CBC"},
  {0,NULL,"OCPCSCTCVCZC[C\\CcCgCkCnCqCtCwCxCzDBDLDODSD]DeDjDmDsDzD|EFENEQERET"},
  {0,NULL,"EVEZE[EbEdEfEqEuEzE}E~F@FCFGFJFXFYF`FbFeFgFiFlFuF{GDGH_@?C?D?R?T?"},
  {0,NULL,"Y?[?h?i?n?o?{?|?}@@@E@G@N@O@P@S@q@r@t@u@v@y@{AJAKAUAVAWAZA\\A`AaAc"},
  {0,NULL,"AdAqArA~B@BABCBGBHBKBMBNBOBRBcBmBoBpByCCCFCGCICJCMCQCXC^C`CbCeCjC"},
  {0,NULL,"mCnCwCyC|D?D@DDDTDXDYD\\DkDlDoDtDvEAEGEPESETEWEYE[E_EbEfEhElEyEzE}"},
  {0,NULL,"E~F@FCFKFNFXFYFcFdFfFhFjFpFtFxG?GA_@?C?E?S?U?Y?`?f?l?m?t@@@A@B@D@"},
  {0,NULL,"E@I@T@^@`@a@n@p@q@t@w@xACAFAIALANAPATAYA[A\\AcAoAtAuAwA{A|A}BCBEBJ"},
  {0,NULL,"BKBTBYB`BdBgBkBwB|CECFCJCKCLCTCUCYC[C`CdCfCiCjCnCpCtC{C}C~D?DHDID"},
  {0,NULL,"PDRD^DhDkDlDyD~E?EHEIENEUEWE[E\\EaEdEgEoEwEyE{E}F?FBFJFOFUFWF`FaFd"},
  {0,NULL,"FhFjFoFrFuFvGBGK_@?C?E?S?U?Y?`?h?k?m?v?~@@@A@C@D@K@T@Y@[@^@n@p@q@"},
  {0,NULL,"t@w@xACAFAIALANAPATAYA[A\\AcAkAqArAvAwAxAyA|BBBDBIBYB^B_B`BjBqB{B}"},
  {0,NULL,"CBCDCGCHCMCTCUC[C]C^C_CbCgCiCnCpCqCtC~DBDDDHDRDXDYD_DeDqDsD{ECEEE"},
  {0,NULL,"HENEVEYEZE[E\\E`EfEgEmEvEyE{E|F?FAFMFOFVFWF_FbFeFfFgFnFsFwF{GDGIGJ"},
  {0,NULL,"_@?C?F?R?V?W?c?g?j?n?w?~@A@B@D@E@I@U@Z@]@b@n@o@r@s@w@yA@AJAKALAMA"},
  {0,NULL,"OAQASA[A_AbAnApAsAvAzA{B?BABBBHBJBVB\\B]BbBkBrBtBwC?CDCGCHCICOCRCZ"},
  {0,NULL,"C]C^C_CaCkCmCnCoCrCsC~D@DEDGDIDPDQDcDiDkDlDyEBEDEHEOEXE[E]E^E_EaE"},
  {0,NULL,"gEhEkEuEwE{E|F@FDFIFJFQFTF`FbFeFiFjFlFvFzF~G@GKGM_@?C?E?Q?U?W?\\?g"},
  {0,NULL,"?k?l?p?{?|?}@?@B@L@R@V@_@a@n@p@q@t@w@x@}AGAHAMAPARAUAWAYA]A_AiApA"},
  {0,NULL,"sAyA}B@BEBFBIBLBMBQBTBZB[BfBlBsBuCCCECHCICMCNCSCVCWCXC]CbCfCmCsCu"},
  {0,NULL,"CxCzC{D?D@DGDMDQDZD`DpDrDuDxECEEEIELEOEQEREWE_E`EfEgEmEvExEyEzE|F"},
  {0,NULL,"EFGFMFWF^F_FaFbFcFfFmFrFsF|GDGKGM_@?C?D?Q?T?X?d?g?l?n?s?~@@@C@D@F"},
  {0,NULL,"@K@M@P@\\@]@q@r@t@u@v@y@zAGAHANAOASATAXAZA^AaAhApAsAyAzA{B?B@BIBJB"},
  {0,NULL,"MBOBUB\\BeBlBqBuB}B~C?CACFCLCPCRC\\CaCcCdChCjCkCqCsCtCvCyC{C|DHDRDW"},
  {0,NULL,"D[D_DdDgDqD{D}E@EIEKENEOEPESEVE`EeEfEsEuEwE{F?F@FDFKFPFVF\\F_F`FaF"},
  {0,NULL,"bFcFmFsFxF|F~GLGNGO_@?C?F?S?V?X?Z?f?j?m?q?{?|?}@C@F@H@Q@W@X@d@n@o"},
  {0,NULL,"@r@s@w@yABAFAIAQARAVAXA]A^A`AbAgAtAuAxA{A}A~BDBEBGBJBSBWBXBaBgBnB"},
  {0,NULL,"xB|B~C@CCCDCICMCPCXC\\C_CbCcClCmCtCuCyCzC}DADDDKDSDVD]D_DaDnDqDwEB"},
  {0,NULL,"EDEJELENEPEREUEYEaEgEhEkEuExE|E~F@FFFHFIFRFTF`FaFbFdFjFoFqFvG@GBG"},
  {0,NULL,"IGJ_@?C?D?S?X?Y?]?f?i?l?y@?@A@B@D@E@I@M@N@^@`@q@r@t@u@v@yAAAFAIAN"},
  {0,NULL,"APAQATAVAYA`AbAeAtAuAwAzA|B?BCBFBKBLBNBUB`BdBnBrBtBxCECJCKCLCSCTC"},
  {0,NULL,"UCVCYC[C`CdCfCiCoCsCtCwD?DADCDGDJDNDQDcDiDjDmDyD~E?EJEMENEOETEWEX"},
  {0,NULL,"EaEeEhEnEuEvExE|E~FFFIFNFRFVF_FeFfFgFiFnFtFyF~GEGLGNGOGQ_@?C?G?Q?"},
  {0,NULL,"T?U?e?f?i?j?z?}?~@?@A@F@J@M@Q@R@c@o@p@s@u@v@x@~AGAHAMANATAUAWAXA^"},
  {0,NULL,"A_AjAtAuAxAzA~B?BDBFBGBLBPBUB[BaBmBoBpByCACCCDCHCKCLCQCXCYC]C_CdC"},
  {0,NULL,"eChCvCxC}C~DBDCDEDIDLDODPDbDeDfDsDzEAEGEHEKEMEQEUEZE]EbEcEdErEuEx"},
  {0,NULL,"E{E|E~FFFGF[F\\F]F_FaFbFcFeFmFqF}GEGHGJGKGPGQGRGS_@?C?F?Q?W?X?_?f?"},
  {0,NULL,"j?m?q?{?|@@@C@E@G@W@]@a@d@n@o@r@s@w@yA?AGAHAOAPARASAYAZA]AaAgAtAu"},
  {0,NULL,"AxA{A}A~BDBEBGBJBSBTBXB\\BhBoByBzC@CBCECNCPCRCUCWC\\CaCfCgCiClCrCuC"},
  {0,NULL,"yC~DADCDDDJDNDXDYDaDnDoDtDvD|EFEHEJELEMEPEYE^EbEcEhEpEvEwEyE}F?FB"},
  {0,NULL,"FKFLFQF^F_FaFbFcFdFmFqFvF}GAGLGMGOGPGQ_@?C?G?R?T?V?b?h?i?k?u?{?|@"},
  {0,NULL,"@@D@E@G@O@S@[@b@o@p@s@u@v@xADAJAKAMAOASAVA\\A_A`AcAlAqArAwAxA|B@BA"},
  {0,NULL,"BDBHBMBRB]B^BcBhBiBvBzCFCGCICJCLCMCQC^C`CbCdCeCjCmCpCrCwCzC{C|DAD"},
  {0,NULL,"JDMDNDZDaDdDgDnDvEAEGEIEJERESETE\\E^EbEcEdErEvExE{E|F?FAFQFSF[F]F`"},
  {0,NULL,"FaFbFeFiFlF{F}GFGHGNGOGU_@?C?G?S?U?V?a?f?i?j?z?|?}?~@C@F@H@Q@W@[@"},
  {0,NULL,"c@o@p@s@u@v@x@|AFAIALARAXA[A\\A]A^AcAjAtAuAxAzA~B?BDBFBGBLBPBSB^Ba"},
  {0,NULL,"BkBrBtBwB~C?C@CCCDCMCPCXC\\C_CbCcCkClCvCxC|C}D?DADBDFDTDUD\\D`DbDfD"},
  {0,NULL,"uDwEBEDEJEKEQESEUEWEZEaEdEeEiEwEyEzE}F?FBFOFSFUFZF_FcFeFfFgFnFyF}"},
  {0,NULL,"GEGGGNGUGV_@?C?G?Q?T?U?e?g?j?k?x?{?}@?@A@B@L@R@V@b@c@o@p@s@u@v@x@"},
  {0,NULL,"~AGAHAMANATAUAWAXA^A_AfApAsAvA}BABBBEBFBHBLBPBQB[B]BjBqB{B}CCCECH"},
  {0,NULL,"CICNCSCTCVCWCXC[C]CfCmCwCxCyC{C}DCDEDKDLDODVD^DhDoDtDxECEEEIEMEPE"},
  {0,NULL,"QETEUE]E`EcEeEjEuEwE{E~F@FDFPFZF\\F]FdFgFhFiFjFkFzGCGFGGGOGVGW_@?C"},
  {0,NULL,"?E?R?W?Y?^?g?k?l?p?|?}@?@C@F@H@P@V@Y@_@n@p@q@t@w@xAEAJAKALAQAUAWA"},
  {0,NULL,"ZA[AaAbAiApAsAyA}B@BEBFBIBLBMBOBQBZB_BnBrBtBxCACBCFCKCNCQCSCVCWCY"},
  {0,NULL,"CeCgChCjCqCrCuCxCzD@DBDFDSDUD]D`DaDnDuDwD~E?ELEQEREVEZE^E_EaEdEgE"},
  {0,NULL,"oEuEwE{E}F@FDFJFOFTFXFaFcFdFfFhFpFrFsGBGGGJGLGNGQGRGWGX_@?C?E?Q?U"},
  {0,NULL,"?W?\\?f?l?m?t?{?|@@@B@E@G@V@^@a@d@n@p@q@t@w@x@}AGAHAMAPARAUAWAYA]A"},
  {0,NULL,"_AoAtAuAwA{A|A}BCBEBJBKBQBTBXB`BiBmBpBvC@CECNCOCPCRCUCWCZC\\CaCfCi"},
  {0,NULL,"ClCpCuCvC{C~D?D@DMDTDZD\\DdDgDkDlDvD|EFEHEIEKELEWE\\E_EbEdEfEqEuExE"},
  {0,NULL,"zE|E~FFFGFMFXF]F`FgFhFiFjFkFtFuF{GBGIGLGNGRGSGVGXGY_@?C?G?S?U?V?a"},
  {0,NULL,"?h?i?k?u?|?~@@@C@D@K@O@Q@T@[@o@p@s@u@v@x@|AFAIALARAXA[A\\A]A^AcAlA"},
  {0,NULL,"qArAwAxA|B@BABDBHBMBRBYB^BaBfBlBsBuCBCDCGCMCNCTCUCWC[C^C_CbCgCiCo"},
  {0,NULL,"CpCrCvC|DADBDFDUDWD[DcDdDgDiD{ECEEEJEKESEXEZE\\E^E`EcEeEjEwEzE}E~F"},
  {0,NULL,"@FCFHFUFZF\\F`FaFdFiFjFoFxGCGFGHGIGKGLGMGQGRGT_@?C?G?R?T?V?b?g?j?k"},
  {0,NULL,"?x?{@A@B@D@E@I@O@R@U@b@o@p@s@u@v@xADAJAKAMAOASAVA\\A_A`AcAfApAsAvA"},
  {0,NULL,"}BABBBEBFBHBLBRBVB[B]BgBnBxB|C?C@CGCHCICOCRCZC]C^CaCkClCmCpCqCrCw"},
  {0,NULL,"C{DCDEDHDJDNDRD^DhDjDmDyEBEDEIEMETEVE\\E]E^EaEdEeEiEvExEyEzF?FEFNF"},
  {0,NULL,"SFUF[FcFdFfFgFhFpFrGCGEGGGIGJGLGMGPGSGTG[_@?C?F?S?V?X?Z?h?m?n?r?{"},
  {0,NULL,"?}@?@B@F@L@N@W@X@Z@n@o@r@s@w@yABAFAIAQARAVAXA]A^A`AbAmAqArAvAyA~B"},
  {0,NULL,"BBCBGBIBKBNBSBWBbBlBqBuB}B~C@CACJCKCOCQCYCZC`CcCeChClCoCpCuCzC}DD"},
  {0,NULL,"DEDKDMDVDZD^DhDpDrDxD}E@ELEREUEXEYE\\E]E`EcEgEtExEzE}E~F@FCFHFIFZF"},
  {0,NULL,"^F_FeFfFgFhFnFwFzGAGDGKGLGOGPGSGUGWGX_@?C?D?S?X?Y?]?h?i?n?o?{?}@?"},
  {0,NULL,"@B@E@L@N@S@X@`@q@r@t@u@v@yAAAFAIANAPAQATAVAYA`AbAdAqArA~B@BABCBGB"},
  {0,NULL,"HBKBMBNBWBcBdBfBjBsB{B~C@CJCKCOCQCRCYCZC`CaCcCeClCoCwD?D@DBDCDDDG"},
  {0,NULL,"DLDODQD`DoDtDuDxD}E@EMETEWEXEYEZE_E`EeEfEsEuEvE{E|F?FAFPFRFVFWF`F"},
  {0,NULL,"aFcFdFjFoFxF|G?GFGJGMGPGRGVGX_@?C?D?R?T?Y?[?g?l?n?s?|?}@@@C@F@H@P"},
  {0,NULL,"@S@\\@_@q@r@t@u@v@y@{AJAKAUAVAWAZA\\A`AaAcAhApAsAyAzA{B?B@BIBJBMBOB"},
  {0,NULL,"ZBcBeBgBkBwB|CACBCFCNCQCSCUCVCWCeCgChCiCjCqCvCyC|D@DDDEDKDTDVD\\D_"},
  {0,NULL,"DbDfDqDwD~E?EKEPESEVEYE]E_EaEeEhEnEvExEyEzE~FEFNFRFSFYF_F`FbFeFiF"},
  {0,NULL,"lFyF|F~G@GIGKGPGRGVGWG^_@?C?D?Q?T?X?d?f?i?l?y?~@?@A@D@F@J@M@\\@`@c"},
  {0,NULL,"@q@r@t@u@v@y@zAGAHANAOASATAXAZA^AaAeAtAuAwAzA|B?BCBFBKBLBPBUBdBeB"},
  {0,NULL,"hBiBvBzCACCCDCGCHCKCLCXCYC]C^C_CdChCoCqCsCtCuCvDCDSDWD[D]DjDmDpDr"},
  {0,NULL,"DzEAEGEKELEMENEOEVEXEbEfEhElEwEyE}F?F@FBFKFLFPFYFfFgFhFiFjFkFtFuF"},
  {0,NULL,"yG?GIGJGKGMGWGXG^G__@?H?N?S?V?a?d?g?l?s?u@B@D@H@K@U@V@X@^@`@b@j@m"},
  {0,NULL,"@p@r@u@v@{@~A?AEALAQARAUAXA[AcAdAgAjAkAzA{BEBGBIBJBMBPBXB_BcBgBnB"},
  {0,NULL,"oBrBsBxByBzB}CBCNCQCXC\\CcCnCpCsC~DGDJDMDPDQDXD[D^DgDhDjDlDrDsDvDy"},
  {0,NULL,"DzD}EAECEMEOETE\\EaEeEiEnEwF?FBFDFIFOFQFSFVFZF`FiFlFoFrFuFyF|G@GCG"},
  {0,NULL,"MGOGQGSG[G\\_@?H?M?R?Y?^?e?f?j?v?z@A@E@H@J@S@U@^@`@b@d@h@k@n@p@u@x"},
  {0,NULL,"@z@|@}ABAQAWAZA[A]A`AbAhAiAlAmAzA~B?B@BDBFBJBQBWB^BeBgBhBkBlBnBpB"},
  {0,NULL,"qBuB|B~CMCPCWCeChCnCoCsDCDHDJDNDODQDWDYDcDeDhDkDlDpDtDxDyD{EEEFEG"},
  {0,NULL,"EIEME[E\\EaEdEiEoEuE{FDFFFNFOFTFVFXF[FeFgFlFnFuFvFyFzF}GGGKGMGOGSG"},
  {0,NULL,"TG\\Ga_@?I?L?Q?U?c?e?h?n?r?z?~@@@J@L@S@T@[@\\@]@a@h@k@n@o@s@vAAABAD"},
  {0,NULL,"AEANATAUAVAYA^A_AeAfAgAiAyBBBCBEBGBIBMBSBZB]BdBfBiBjBlBnBrBsBxByC"},
  {0,NULL,"@CKCQCVCfCmCnCqCtCvDHDIDSDTDUDXDYDcDdDfDgDjDkDqDwDyD{EAEDEFEJEKE["},
  {0,NULL,"E^E`EcEjEtEwE{FAFDFLFMFOFPFZF]F_FeFmFnFxFzF~GAGDGHGIGJGNGQGTG[_@?"},
  {0,NULL,"I?N?S?X?]?b?g?k?x?y@C@D@I@L@T@W@[@\\@]@_@i@l@o@q@u@v@{@}@~A@ANAPAW"},
  {0,NULL,"AYA]A`AbAdAjAmAoAvAyA}A~BBBHBLBPBTBbBcBfBlBmBpBqBtBuBvB|CCCECSCZC"},
  {0,NULL,"eClCnCrCtC~DFDNDPDUDWDXD]D_DaDdDlDmDqDsDvDzD{D~EBEGEKENESE^E`EeEj"},
  {0,NULL,"EsEvF?FAFEFHFLFPFRFUFWFgFiFkFnFsFzF{F~GFGGGIGNGQGSG[G\\Gc_@?J?P?R?"},
  {0,NULL,"W?]?c?f?i?w?y?|@E@I@J@O@Q@S@_@a@d@i@l@o@r@t@y@z@~ABACAMAQASAUAXA["},
  {0,NULL,"A_AfAhAkAmAwAxA|B?BFBIBKBWBYB[BeBkBmBnBoBqByBzB{B}CACDCHCVC[CcCpC"},
  {0,NULL,"rC{D?DQDRDTDUDXDZD\\D^D`DaDcDdDnDoDvDxD{D}E?EBEPEWEYE^EbEhElEpEvE|"},
  {0,NULL,"FAFFFLFMFNFTFXF[FiFjFkFlFuFvFyF}G?GFGLGOGSGUGVGZGb_@?H?P?R?V?c?d?"},
  {0,NULL,"f?l?r?y?|@F@I@J@O@P@Q@W@_@a@h@k@r@v@w@y@~A?AAACALAMAPAQASA[AcAdAf"},
  {0,NULL,"AkAnAwA}B?BABFBKBLBNBYB[B\\BgBjBkBmBnBzB{B|B}CECJCTC]C^CaCvCxCzDBD"},
  {0,NULL,"KDODTDUDWDZD\\D`DaDdDeDnDpDqDwDxD{D|D}EAEKEPEREYEaEhEkEnEwF@FBFDFI"},
  {0,NULL,"FJFQFSFYFZF_FfFnFpFqFsFtF~GBGEGJGRGWGYG_G`_@?I?K?S?U?`?c?g?n?t?w?"},
  {0,NULL,"}@B@I@K@N@P@Q@R@V@X@i@l@n@s@t@w@zA?ADAEALANATAYAZA^AcAeAgAkAlAvAz"},
  {0,NULL,"B@BABDBHBJBRBUBXB_BfBgBhBiBlBqBrBuBzCFCLCPC^C_CgCwD?DCDEDKDLDNDPD"},
  {0,NULL,"VDZD\\D`DbDlDmDoDpDuDvDxDzE?EDEFELEREWE]E`EgEmEtE{E|FAFDFIFMFOFVFZ"},
  {0,NULL,"F]FhFjFkFoFrFwF|G?G@GCGMGOGPGXG]G^Ga_@?I?O?Q?X?^?d?h?k?v?y?{@?@J@"},
  {0,NULL,"K@N@O@R@V@X@d@h@k@q@t@u@w@{@|A@ACAOARATAXA\\A^AaAhAjAnAoAvAxAyA{A|"},
  {0,NULL,"BBBHBOBVB`BaBfBjBkBlBoBsBtBvBwCDCGCUC\\CjCkCzC}DCDEDIDJDKDMDQDSDZD"},
  {0,NULL,"`DfDhDjDnDoDtDwDxDyD|D~EGEMEREWE_E`EfEmEsEuF@FCFDFGFIFKFVF\\F^FfFg"},
  {0,NULL,"FkFnFsFwF{G?GFGGGKGPGXG]G^G`Gg_@?H?K?S?Y?_?`?g?j?v?w?}@C@I@K@N@P@"},
  {0,NULL,"Q@R@W@_@j@m@n@w@x@y@z@}A@ADALANAVAYA\\A_AcAeAlAmAoAvAzB?BCBFBHBJBR"},
  {0,NULL,"BTBUBbBfBgBhBiBnBqBrBvBxCGCHCOC`CdCfCvCyC|DBDKDLDSDVDXD[D\\D`DbDgD"},
  {0,NULL,"nDoDsDuDvDwDzE@EEEFELEPEREZEaEgEkEoEyE}FBFEFHFJFRFUFWFYFbFeFlFnFs"},
  {0,NULL,"FvFzF}F~GGGIGNGRGWGYG_GdGf_@?J?O?Q?T?`?d?h?m?s?v?{@@@J@K@O@R@S@X@"},
  {0,NULL,"a@d@j@m@p@q@t@y@|A@AAAEAMAOASATA^AaAbAeAiAjAnAxAyA|A~BBBDBLBVBZBa"},
  {0,NULL,"BdBjBlBmBoBpBrBtBvBwB~C?CSCYC]C_CpCrCyDADFDHDJDKDMDZD\\DhDiDlDnDoD"},
  {0,NULL,"qDtDvDwDyD~E@ECEPEWE\\E_EbEfElEqEyF?FAFBFLFMFPFSFYF]F`FbFlFmFuFvFx"},
  {0,NULL,"GAGDGHGLGNGQGUGVGZGcGe_@?I?N?S?U?[?a?g?n?s?z?}@B@H@K@N@R@U@V@X@^@"},
  {0,NULL,"i@l@o@q@u@v@zA?ADAEALAPARASAXA]AcAeAgAkAlAwAyAzBBBIBJBMBRBUBXB_Bg"},
  {0,NULL,"BhBjBrBsByBzB{B}C?CLCPC^CgCiCuCzC}D@DGDMDODPDQD\\D]D^DaDbDhDlDrDtD"},
  {0,NULL,"vDxDzE?EAEDEMETEUE_E`EeEjEsEzE~FCFEFGFHFRFUFWF\\F_FcFmFnFsFxFzF~GA"},
  {0,NULL,"GGGPGWGXG]G^G_GhGi_@?J?M?R?T?`?b?f?m?t?x@A@F@G@I@M@P@W@Y@Z@c@i@l@"},
  {0,NULL,"p@q@s@x@|@}A?AAAMAOARASAVA\\AaAdAiAlAnAwA{BCBEBGBKBMBNBQB\\B^BfBjBm"},
  {0,NULL,"BoBsBwBxByBzC@CNCRC`CbCjCoCsCtDEDLDQDRDSDVDWD]D^D_DbDcDfDpDsDxDzD"},
  {0,NULL,"{D~ECEDENEQEZE]EbEdEqErE{F?FAFBFJFPFQFSFYF]FgFhFkFpFqFtFwF{GBGEGJ"},
  {0,NULL,"GKGMGTG\\G`Gf_@?I?K?S?X?Z?^?g?k?p?q@C@D@H@L@T@[@\\@]@`@b@i@l@n@s@t@"},
  {0,NULL,"w@{@}@~A@AMARATAXA^A`AbAdAjAmAoA}B@BABIBKBLBMBPBTBbBcBjBmBoBpBsBt"},
  {0,NULL,"B{B|B}CCCECICYCZCeCqCvC|DADHDNDRDYD[D\\D]DaDbDcDeDgDiDmDvDzD{D|D~E"},
  {0,NULL,"BEHEJEVE[E`EgEmEtE}F@FCFDFIFKFOFVFZF^FaFbFmFoFrF|G@GCGDGHGIGNGQGR"},
  {0,NULL,"GYG[GaGc_@?J?L?Q?W?_?a?h?i?u?w?~@?@G@K@M@N@V@Y@Z@c@j@m@o@r@s@x@{A"},
  {0,NULL,"BACADAOAPAWAZA]A`AaAfAgAhAoAwAxA|A}B@BABKBOBSB]B`BgBkBmBoBpBuBvB{"},
  {0,NULL,"B|CFCICJCWCiClCqCsCtDBDFDGDHDLDODPDSDbDiDjDpDqDrDuDwDyDzD}EBEEEOE"},
  {0,NULL,"UEZE]EbEcEpErEwE}FBFCFGFJFKFQF\\F^FeFiFkFlFwFyF{F}G?GFGIGJGKGTG[G`"},
  {0,NULL,"GhGl_@?J?M?R?W?^?a?f?i?p?z?|@E@H@J@O@S@U@`@a@d@i@l@p@q@s@x@z@~ABA"},
  {0,NULL,"CANAOAQAWAZA[AaAfAhAkAmAvA~B?BCBDBFBGBWBYB[BeBhBiBkBnBpBqBuBvB}CA"},
  {0,NULL,"CHCKC[CcCkCyD@DADDDJDMDNDQDUDVDYD_D`DcDgDkDlDtDvDxD{E?EBEEEIEJE\\E"},
  {0,NULL,"_EbEdEqErEzE}FBFCFGFJFQFSFYF^FaFcFmFpFqFtFxGBGEGHGLGUGVGWGYGZGfGj"},
  {0,NULL,"_@?J?O?Q?W?\\?]?h?i?o?p?~@?@G@L@M@Y@Z@[@]@c@j@m@p@q@t@y@{ABACADAMA"},
  {0,NULL,"PASAUA]A_AcAfAgAhAoA~B@BABCBDBGBJBOBSB]B`BgBhBiBnBuByBzB{B|CFCICM"},
  {0,NULL,"CaCiClCoCxC}DEDFDGDIDKDWD[D]DeDfDhDiDmDsDuDwDyDzD}E?EEENEQEVEXEbE"},
  {0,NULL,"fElEqEuE|FAFFFLFMFPFTFXF]FcFfFmFpFtFxGAGDGEGHGJGKGPGTG^G`GcGl_@?H"},
  {0,NULL,"?M?R?V?\\?b?f?l?t?u?|@F@G@I@M@P@Q@W@Z@_@h@k@n@p@u@x@~A?AAACAMASATA"},
  {0,NULL,"VA\\A`AbAdAfAkAnAwAzA{BBBEBJBKBNBYB[B\\BjBmBrBsBtBwBxBzB{CJCLCTCZC]"},
  {0,NULL,"CaCuCyC|DDDFDSDVDWDYDZD]D_DbDdDfDpDtDuDwDxD{D|EAECELEQESEZEaEdEiE"},
  {0,NULL,"oExEzFEFFFHFNFTFUFXF[F`FaFlFoFrFuFvFyF|F}GRGVGWGYGZG_GeGi_@?H?K?S"},
  {0,NULL,"?V?Z?\\?g?l?p?r@B@D@H@L@U@[@\\@^@`@b@j@m@n@w@x@y@{@~A?AEARAVAXA\\A`A"},
  {0,NULL,"aAbAdAgAjAkAxA}B?BFBIBLBMBPBXB_BcBkBmBoBsBtBwByB|B}CACBCQCXC\\CbCo"},
  {0,NULL,"CwC{DCDHDIDLDMDNDRD[DcDgDiDkDmDoDrDvDyDzD|D}ECEHEIEXE[EaEgEkEoExE"},
  {0,NULL,"|FEFFFHFRFTFUFWF[FfFhFnFpFsFtFzF~GBGGGMGOGPGSG\\G]GbGdGk_@?I?O?Q?U"},
  {0,NULL,"?[?\\?h?n?o?t?~@@@G@L@T@Z@[@\\@]@c@h@k@q@t@u@wAAABADAEAPAQARAUAXA]A"},
  {0,NULL,"_AeAfAgAiAvB@BABCBFBGBHBSBZB]BdBgBiBnBqBuBxByB{B}C@CKCOCVCXCmCrC|"},
  {0,NULL,"C~DADFDIDJDRDTDWD[D_DeDfDiDkDnDsDwDyD{E?EAEFEHENESEVE`EfEmEsEyEzF"},
  {0,NULL,"CFEFGFKFUFWF\\F^F`FjFkFoFwF{F|G?G@GFGIGLGNGQGZG[GdGmGn_@?I?L?Q?X?_"},
  {0,NULL,"?b?h?k?q?u?{@?@G@K@M@N@R@V@X@Y@h@k@n@o@s@v@{@|A@ACANAOAPAYA[A]AaA"},
  {0,NULL,"hAjAnAoAxA|B?B@BABIBMBOBVB`BaBkBoBqBuBvBwB{B|B}CBCDCUCdCjCkCuCwD?"},
  {0,NULL,"D@DGDJDLDODSDTDVD^DjDkDnDpDrDuDwDxDyD|EBEGELETEUE]E`EcEjEtEvExFAF"},
  {0,NULL,"EFHFLFMFPFRF]FaFdFmFoFrFxGAGCGDGHGPGUGVGXG]G^GgGjGkGp_@?H?N?S?Y?]"},
  {0,NULL,"?e?g?j?o?x?}@C@I@L@P@Q@T@W@]@_@j@m@p@r@u@v@z@}A@ADANAOAQAYA[A`AbA"},
  {0,NULL,"eAlAmAoAvA{A|A}BEBHBLBRBTBUBbBfBiBkBpBqBtBvBwB|CGCOCRC[CdCfCuCxCz"},
  {0,NULL,"DDDFDLDMDTDUDXD]D_DaDfDoDqDrDsDvDwDzE@EEEGEKEQESEYEaEeEiEnEuE~FDF"},
  {0,NULL,"FFIFNFOFVFXFZFcFdFoFpFqFrF|G@GCGEGRGWGXGYG^G_GfGgGmGq_@?H?P?R?Y?["},
  {0,NULL,"?_?f?j?o?q@A@E@G@H@U@Y@^@`@b@c@h@k@r@v@w@y@z@|@}ABALAVAWAZA\\A^AcA"},
  {0,NULL,"hAiAlAmAyA{A}A~BDBEBLBQBWB^BeBfBhBlBpBrBtBuBwBxB~CCCMCWCgChCpCwC{"},
  {0,NULL,"C~DGDIDODPDRDYDZD^DdDeDiDjDmDtDxDyD{E@EFEGEHEOETEXEaEhEkEnEvEyFBF"},
  {0,NULL,"EFJFQFRFSFWFYFdFjFoFpFqFtG@GBGCGEGLGMGOGSGUG\\GaGlGoGr_@?J?P?R?T?Z"},
  {0,NULL,"?[?f?m?q?s@A@F@G@H@M@Y@Z@^@b@c@i@l@o@r@t@y@|@}A?AAAUAVAWAYAZA\\A_A"},
  {0,NULL,"dAiAlAnAxA{A|A~BDBEBHBNBQB\\B^BfBhBiBlBpBsBvBwBxCNCRCUC`CbCmCqCxC}"},
  {0,NULL,"DBDIDODPDRDUDVD[D^D_D`DeDjDmDrDxDzD{D~E@EDEOEUEVEXEbEhElEpE~F@FCF"},
  {0,NULL,"FFKFNFTFXF[F\\F_FbFlFmFuFvFyF}GAGDGJGKGRGTG_G`GbGnGpGq_@?J?L?Q?T?Z"},
  {0,NULL,"?e?h?m?r?x?{@@@J@L@O@S@T@\\@a@d@j@m@o@r@s@x@|A@AAAEALATAUAWAZA^A_A"},
  {0,NULL,"eAiAjAnAwAyAzBBBCBGBKBVBZBaBdBhBiBjBlBrBtBxByBzC?CSCTCYC_ChC{D?D@"},
  {0,NULL,"DDDGDHDKDNDTDXDYDaDdDgDhDkDqDuDvDwDyE@ECEDEIEJEYE^EbEcEpErExE~FCF"},
  {0,NULL,"FFGFKFNF[F\\F^FdFhFkFpFqFwF{G?GBGFGLGUGVGXGZG]GeGhGoGs_@?H?M?R?Y?^"},
  {0,NULL,"?e?h?k?u?v@?@A@J@L@S@T@Z@_@`@b@h@k@n@p@u@x@z@|@}ABAQAWAZA[A]A`AbA"},
  {0,NULL,"hAjAnAoAqArAuAwBDBHBIBSBTBXB\\B_BaBeBhBuBzB~C?CBCJCLCOCPCRCSCVC\\Cm"},
  {0,NULL,"CnCqCtCvDKDLDNDODQD\\D]DcDeDhDoEAEDEFEIEMEPEQEVEWE[E`EcEjEoEvE{FCF"},
  {0,NULL,"DFNFQFVFWF[F^FaFdFoFpFqFsFwFxGCGHGJGNGVGXGYG^GcGhGmGoGqGuGvGx_@?I"},
  {0,NULL,"?O?Q?X?^?d?f?l?t?y@?@F@H@J@V@X@\\@`@c@d@h@k@q@t@u@w@{@|A@ACAOARATA"},
  {0,NULL,"XA\\A^AaAdAfAkAnArAtAuAzA|A}BCBRBUBVBYB]B^BcBiBvBwC@CACCCDCGCHCICL"},
  {0,NULL,"COCWC^ChCnCoCsDCDKDMDSDUDXD[D]D`DaDhDjEEEFEGEMEOEREVEYE^E_EaEdEoE"},
  {0,NULL,"sEuExFBFDFGFIFRFSF]F^F`FaFmFoFrFuFvF~GEGHGQGRGSGTGYGZGaGbGfGjGmGo"},
  {0,NULL,"GsGt_@?J?L?Q?W?_?a?g?j?w?x?~@C@H@K@U@V@Y@\\@c@d@j@m@o@r@s@x@{ABACA"},
  {0,NULL,"DAOAPAWAZA]A`AaAeAlAmAoApArAsA{BABBBFBNBRBWB\\B`BcBdBjB{B|CACFCJCK"},
  {0,NULL,"CLCPCRCSCTCXC\\C`CnCpCsC~DFDODSDUDYDZD\\D`DbDiDjD}EAECEHEJEOEREUEWE"},
  {0,NULL,"ZEaEeEiEpEuEwFBFEFGFJFPFRFTF\\FcFdFmFpFrFvFxF~GCGEGOGQGUGWGXGYGaGi"},
  {0,NULL,"GkGoGpGtGvGxGz_@?J?P?R?W?]?c?g?n?s?w@B@E@I@L@S@Z@]@_@a@b@i@l@o@r@"},
  {0,NULL,"t@y@z@~ABACAMAQASAUAXA[A_AeAgAkAlApAsAuA{B?B@BBBPBSBUBVBYB^BaBkBw"},
  {0,NULL,"B}C?CDCGCHCICMCNCOCUCZC_CeCnCrCtC~DGDIDLDQDSDTDZDcDdDoDuD~EBEGELE"},
  {0,NULL,"WEXEYEZE[E^E`EeEpEsEvEzFAFDFMFNFSFXFZF^F_FcFmFpFsFwFxF~GCGEGIGJGP"},
  {0,NULL,"G\\G^G_GcGdGfGgGoGpGuGwGy_@?J?P?R?T?Z?[?g?n?s?w?}@F@H@L@S@Z@\\@_@b@"},
  {0,NULL,"c@i@l@o@r@t@y@|@}A?AAAUAVAWAYAZA\\A_AeAgAkAlApAsAuA{B?B@BBBOBTBXBY"},
  {0,NULL,"B^B`BdBfBkBwCBCDCFCHCNCQCSCTCUCZCeCiCqCvC|DADIDJDKDMDODTDVD_DeDhD"},
  {0,NULL,"rD|D~EBEMESEUEVEXEYE\\E`EgElEtE{F@FCFEFJFPFTFWF[F\\FhFjFkFpFsFwFxG@"},
  {0,NULL,"GBGCGLGOGQGXGYG]GeGkGlGmGrGsGvGxGyG{_@?H?P?R?Y?[?_?h?n?o?r@@@E@G@"},
  {0,NULL,"K@N@O@P@U@Y@^@h@k@r@v@w@y@z@|@}ABALAVAWAZA\\A^AcAeAfAgAiAqArAtAvA~"},
  {0,NULL,"BKBMBPBQBSBUB[BaBcBlBmBpCCCECFCGCHCICMCQCTCXCjCkCuCwD?D@DFDPDRDXD"},
  {0,NULL,"YD\\D]D^DiDsDtD|EBEGEHENEOEPEQETE_E`EcEnEtEvE{FCFEFJFQFVFWF[F\\F_Fe"},
  {0,NULL,"FlFnFzF|F}GAGDGFGIGJGNGVG^G_GbGfGiGkGnGsGtGw_@?I?K?S?X?Z?^?f?m?q?"},
  {0,NULL,"t@C@F@H@J@Q@T@X@\\@`@d@i@l@n@s@t@w@{@}@~A@AMARATAXA^A`AbAdAiAlAnAp"},
  {0,NULL,"AtAuA|A}BGBJBQBRBSBVB[B]BcBgBmB|B~C@CCCDCFCGCICLCMC[CcCmCyD@DADDD"},
  {0,NULL,"GDHDKDODSD[D]DaDeDgDjE?EBEEEJEOERETEVEYE[EbEdEqEtE}F?FCFFFKFLFOFU"},
  {0,NULL,"FVF[FgFhFkFnFtF{F}GAGBGGGKGMGUGWG]G`GbGdGgGhGoGrGwGx_@?I?O?Q?U?[?"},
  {0,NULL,"\\?f?l?t?y?|@@@G@H@V@[@\\@^@c@d@h@k@q@t@u@wAAABADAEAPAQARAUAXA]A_Ad"},
  {0,NULL,"AfAkAnArAtAuAzA|A}BCBNBTBVBWB]B_BbBiBnBvC?C@CDCECGCNCOCPCRCWCZChC"},
  {0,NULL,"pCwC{C~DFDLDMDTDVD[D\\D_DbDiDkE@EFEGEHEIESEVEZE]E_EaEhEmEnEwEyFEFF"},
  {0,NULL,"FKFLFOFTFUF\\F_FfFmFnFrFtFvF~GAGEGMGPGUGWG_G`GcGhGkGpGqGrGvGwG{H?_"},
  {0,NULL,"@?H?K?S?V?Z?\\?h?m?r?v?{@B@G@L@N@W@Z@[@^@b@j@m@n@w@x@y@{@~A?AEARAV"},
  {0,NULL,"AXA\\A`AaAbAeAiAjAnAqArAsAvAwA~BIBOBPBUBWBZB\\BeBoBqB}B~C@CACGCHCJC"},
  {0,NULL,"KCLCQChCiClCoCxC}DEDMDNDRDTDUDVDZDdDkDmDrD}E?EEEHEIEKELEUEXE^EbEf"},
  {0,NULL,"EkEqE|F?FCFFFKFQFUFVFWF[F`FbFlFoFqFuF|G?GDGHGJGNGRGVGZG^GaGiGmGpG"},
  {0,NULL,"qGsGwGxGyG~_@?J?O?Q?W?\\?]?g?l?p?s@?@B@I@L@M@R@Z@]@_@a@j@m@p@q@t@y"},
  {0,NULL,"@{ABACADAMAPASAUA]A_AcAdAgAjAkApAqAsAyB?B@BEBQBRBSBYB^BaBcBgBlBuB"},
  {0,NULL,"~C?CCCDCECHCICMCNCbCdCfCuCxCzDDDGDIDNDQDWDYDZDcDfDmDuE@EEEGEJELEN"},
  {0,NULL,"EQEWEXE[EaEeEnEqEuEwFEFFFJFLFPFTFUF\\F`FiFkFlFyF|G@GBGFGGGOGQGSGXG"},
  {0,NULL,"YGZGdGeGjGnGqGrGsGuG}_@?I?N?S?X?]?b?f?i?y?z@D@E@G@I@M@N@W@[@]@^@i"},
  {0,NULL,"@l@o@q@u@v@{@}@~A@ANAPAWAYA]A`AbAfAhAkAmAsAtAuAxAzBCBLBOBQBZB[B_B"},
  {0,NULL,"bBdBpBrBtC?CBCECJCKCPCSCTCUCVC`CbCoCsCtDEDFDGDJDKDNDXDZDdDmDnDsD~"},
  {0,NULL,"ECEDENEPERESETEXE^EbEdErEsE}F?FAFFFHFKFLFOFUFXFaFcFmFoFqFrFuG?GEG"},
  {0,NULL,"HGMGUGVGWG^G`GeGkGlGmGpGqGtGuH@HA_@?J?M?R?W?^?a?g?k?p?x?|@C@H@K@O"},
  {0,NULL,"@P@U@V@Y@d@i@l@p@q@s@x@z@~ABACANAOAQAWAZA[AaAdAjAmAoApAsAtAyBABEB"},
  {0,NULL,"FBNBPBUBWBZB`BdBnBqBxC@CACBCFCJCKCQCRCSCYC^CgCuCzC}D@DFDIDJDSDUDY"},
  {0,NULL,"D[D`DgDiDtE?EAEDEHEJEREXEZE\\E_E`EeEjEqEvEzFCFDFMFNFQFSFVF^FgFiFkF"},
  {0,NULL,"lFyFzF|GDGFGGGIGKGPG[G\\G_GaGbGeGhGkGlGmGnG~_@?I?K?S?U?`?c?f?m?q?t"},
  {0,NULL,"@A@B@I@J@Q@R@T@X@`@a@i@l@n@s@t@w@zA?ADAEALANATAYAZA^AcAdAiAlAnApA"},
  {0,NULL,"tAuA|A}BGBJBOBRBZB\\B`BcBeBgBhB|CCCFCICJCKCLCQCTCUC[CcCjCpCrC{D?DF"},
  {0,NULL,"DHDIDKDLDPDWDfDlDoDpD}E?EBEQERESEWE[E\\E]EbEhEmEpE|E~FAFBFGFIFRFYF"},
  {0,NULL,"ZF]F_FbFmFnFtFvF{F}F~GAGJGNGRGSGTGZGcGeGfGiGjGkGlGmGz_@?J?L?Q?T?Z"},
  {0,NULL,"?e?g?j?w?x?{?}@H@L@S@V@\\@b@c@d@j@m@o@r@s@x@|A@AAAEALATAUAWAZA^A_A"},
  {0,NULL,"eAlAmAoApArAsA{BABBBFBYB[B^B_B`BbBdBjBrB{CCCECFCHCJCNCSCTCUCXC[C\\"},
  {0,NULL,"CoCwC{DCDKDODTDVDWDYD]D_DaDhDkD|D}ECEIEJEMENESEUEYEaEgEkErExEyFDF"},
  {0,NULL,"FFKFMFNFOFSF^FbFeFlFmFrFvFzF~GDGEGIGPGRGTG\\G_GbGcGjGmGnGrGuGwGzG|"},
  {0,NULL,"H@HD_@?J?M?R?T?`?b?g?k?p?x@A@D@I@K@M@O@P@R@U@Y@i@l@p@q@s@x@|@}A?A"},
  {0,NULL,"AAMAOARASAVA\\AaAdAjAmAoApAsAtAyBABEBFBNBSBTBWBXB]BaBnBsBxB~C?C@CA"},
  {0,NULL,"CGCICKCOCRC^CgClCwD?DCDEDHDJDRDSDTDWDXD^DpDqDsE?EDEFEKENETEYEZE\\E"},
  {0,NULL,"]E`EgEmErE{F@FAFEFHFJFPFTFYF\\FaFbFlFmFrFvFzF|GDGFGNGOGQGVGXGYGdGg"},
  {0,NULL,"GiGjGoGqGtGwG{G~HB_@?J?O?Q?T?`?d?g?l?p?s@@@D@I@K@M@O@P@R@]@a@j@m@"},
  {0,NULL,"p@q@t@y@|A@AAAEAMAOASATA^AaAbAdAgAjAkApAqAsAyB?B@BEBNBSBWB_BaBbBe"},
  {0,NULL,"BlBtBuB~C?C@CACICLCMCPCRCcCdCfCvCyC|DBDHDJDODPDRDWDZD^DlDnDqE@EEE"},
  {0,NULL,"FEKENEPETEUEWE\\EaEgElEoExEyFBFDFIFMFNFSF]F^FfFhFkFpFsFwFyG@GBGGGI"},
  {0,NULL,"GMGPG\\G_G`GaGfGgGhGiGlGpGxG|HD_@?H?K?S?Y?_?`?h?m?r?v@@@C@G@K@N@P@"},
  {0,NULL,"W@Y@[@^@j@m@n@w@x@y@z@}A@ADALANAVAYA\\A_AcAeAiAjAnAqArAsAvAwA~BIBP"},
  {0,NULL,"BQBUBVBYB[B]BiBqB}CACCCDCGCHCMCQCTCUC]CiClCqCsCtDBDJDQDRDVDXDYD\\D"},
  {0,NULL,"bDnDsDtD}EBEEEHELEMENEPEZE_EbEcEoEpE}E~FAFBFHFRFXFYFZF]FdFhFoFpFq"},
  {0,NULL,"FuFwG?GCGHGKGLGMGUG[G]GgGjGlGnGrGtGuGvHC_@?H?N?S?Y?]?e?h?i?o?u?}@"},
  {0,NULL,"?@J@L@Q@S@T@X@_@`@j@m@p@r@u@v@z@}A@ADANAOAQAYA[A`AbAfAgAhAoApAqAr"},
  {0,NULL,"BDBHBKBMBNBTBVBXB\\B]BeBfBsBvB~C@CBCJCKCNCOCPCRCYC_CaC{D?D@DDDIDLD"},
  {0,NULL,"ODQDRDUD]DaDeDfDoE@ECEDEHEKEMEQEVEWEYEbEcEnErE}E~FAFFFHFLFOFXFYFZ"},
  {0,NULL,"FeFiFlFnFtFzF{F}GAGFGKGLGSGTG[G]GaGbGcGdGeGiGpGxH?HE_@?I?L?Q?U?c?"},
  {0,NULL,"e?f?j?q?z?~@A@I@J@M@Q@R@T@]@a@h@k@n@o@s@vAAABADAEANATAUAVAYA^A_Ah"},
  {0,NULL,"AiAlAmAqAtAuAxBGBJBLBNBOBPBRBWBZBcBoBxByCACBCCCFCHCKCLCQCUC]CaCeC"},
  {0,NULL,"vCxCzDBDHDIDLDMDPDQDXDcDfDlDqD|D}EAEKEQE[E\\E]E^E_EaEhEjEkEwEyFDFF"},
  {0,NULL,"FKFLFMFNFOFUFdFjFkFoFqFyG?G@GBGGGMGOGUGWGXG`GbGeGfGgGsGtGuGxH?HBH"},
  {0,NULL,"CHH_@?H?M?R?V?\\?b?h?k?u?v?{?|@G@L@S@W@Z@[@_@b@h@k@n@p@u@x@~A?AAAC"},
  {0,NULL,"AMASATAVA\\A`AbAhAjAnAoAqArAuAwBDBHBIBPBRBUB\\B`BdBeBhBjBzB~CACFCGC"},
  {0,NULL,"ICJCLCPCQCVCdCmCrC|C~DADGDMDNDPDVDZD]D_DdDrDuE?EAEFEIELEOEQESEUE^"},
  {0,NULL,"E`EfEiEmEzF@FAFEFHFPFTFXFYFZFfFgFnFpFsFtFwFxF{GCGKGLGPG[G\\G]GbGdG"},
  {0,NULL,"fGlGpGrGsGtG|G}HIHJ_@?I?L?Q?X?_?b?f?j?q?z?{@E@G@I@M@N@R@W@]@a@h@k"},
  {0,NULL,"@n@o@s@v@{@|A@ACANAOAPAYA[A]AaAhAiAlAmAqAtAuAxBGBJBLBOBXBYBZB^B_B"},
  {0,NULL,"bBkBoByCBCECKCNCPCQCRCSCUC]CaCgCuCyC|DDDGDJDLDNDRDXD[D^DmDnDuD|EA"},
  {0,NULL,"ECELEPETEVEXE]E^EaEdEiEtEuExFBFEFGFIFJFPFRF]FeFgFkFnFyF{F}G@GBGGG"},
  {0,NULL,"IGRGSGTGZG\\GcGdGhGiGlGnGqGvHBHEHH_@?H?N?S?V?a?d?h?i?o?u?~@D@J@K@O"},
  {0,NULL,"@Q@T@U@X@`@j@m@p@r@u@v@{@~A?AEALAQARAUAXA[AcAfAgAhAoApAqArBDBHBKB"},
  {0,NULL,"MBOBQBTBXBZB[B^BfBsByCBCDCECMCNCOCRCTCUCWCYC_CpCrCyDADPDQDSDUDVDW"},
  {0,NULL,"D[DgDjDlDpD~E@ECEJEKELEMEOE\\E]EbEfEiElE|F?FBFCFGFIFQFVFWF[FcFfFnF"},
  {0,NULL,"pFsFtFxF{F}GAGJGNGVGWG^G`GfGhGjGkGnGoGrGuGyG~H?HE_@?I?N?S?U?[?a?f"},
  {0,NULL,"?i?y?z?|?}@G@H@N@V@W@[@^@c@i@l@o@q@u@v@zA?ADAEALAPARASAXA]AcAfAhA"},
  {0,NULL,"kAmAsAtAuAxAzBCBLBVB\\B]B_BaBbBeBrBtBzB~C?C@CDCECMCOCPCSC`CbCkCqCx"},
  {0,NULL,"C}DBDFDGDHDMDTDYD\\DbDkDrDtD~E@EDEIESETEUEZE[E_EbEhEjElE|E~FBFCFGF"},
  {0,NULL,"IFQFRFWF]FiFjFkFoFqFuFyG?G@GHGLGRGSGTGZG[GaGdGgGnGoGsGvGwGzHAHIHM"},
  {0,NULL,"_@?H?P?R?V?c?d?h?n?o?r?~@F@J@K@O@P@Q@U@X@Y@h@k@r@v@w@y@~A?AAACALA"},
  {0,NULL,"MAPAQASA[AcAeAfAgAiAqArAtAvA~BKBMBQBTBXB[B`BbBdBmBpB{C?CBCCCECMCN"},
  {0,NULL,"COCSCTCfCjCkCzC}DCDEDHDNDPDUDWD[D\\D`DgDpDqD|D~EGEIEJEKEOEPERE]E`E"},
  {0,NULL,"fEkEsEzF@FAFDFHFMFSFXFYFZF`FjFlFoFuFzF|G?GDGFGKGLGOGQG[G]GaGcGeGg"},
  {0,NULL,"GhGjGqGvHDHGHIHJ_@?J?O?S?Y?]?`?h?m?s?v@@@C@H@K@S@X@Y@[@^@d@j@m@p@"},
  {0,NULL,"q@t@y@z@}A@ADAFAGAIAPATAVA[AeAiAjAnAxAyA|A~BBBDBLBPBQBUBVBYB[B]Bj"},
  {0,NULL,"BtB{CBCHCQC[C]C^C_CaCbCgClCmCnCpCsC~DHDJDVD\\D_DbDeDnDpDqDtD}EAECE"},
  {0,NULL,"LEPEVE[E\\E]E_EaEeEnEqEuE~FCFFFIFJFNFUFVF\\F`FdFlFnFvFxGAGBGFGGGKGM"},
  {0,NULL,"GRG[G^G_GaGbGhGiGkGpGwGxG{G~H?H@HAHDHHHJ_@?I?L?R?V?b?c?h?n?r?z?~@"},
  {0,NULL,"F@H@J@S@U@X@Y@[@\\@h@k@n@o@s@v@~A?AAACAGAJAKAOA_AbAcAeAfAgAiAyBBBC"},
  {0,NULL,"BEBGBIBMBQBTBXB[B`BbBdBiBvBxB~CECMCVCZC[CcCdCfCgCiCjCnCoCsDCDHDID"},
  {0,NULL,"UD\\D`DbDfDgDoDqDrEEEFEGEJEKEPEUEWEXE[EaEdEiEtExEzFCFEFGFIFJFNFUF["},
  {0,NULL,"F`FeFnFpFxF{F~G@GBGHGKGOGVGWG]G_GbGfGkGoGrGsGtGxGzG{G}G~H?HKHLHNH"},
  {0,NULL,"Q_@?H?P?Q?X?_?d?f?l?r?y@?@F@J@L@W@\\@_@`@a@c@h@k@r@v@w@y@{@|A@ACAG"},
  {0,NULL,"AHAKANARASAZAdAfAkAnAwA}B?BABFBKBLBRBUBVBYB]B^BcBhBzB{C@CGCKCWCXC"},
  {0,NULL,"YC]C^C_CbCdCgCnCqCtCvDKDMDUDWD`DaDhDlDmDpDrEAEDEFEKENEREXEYE\\E_E`"},
  {0,NULL,"EcEnEtEvExFEFFFHFLFMFVF[F\\F_FaFkFnFqFsF|F}GBGFGPGQGSGTGUG]GcGdGeG"},
  {0,NULL,"hGqGrGvGxGyG}H?H@HBHJHMHP_@?J?M?S?U?`?a?f?m?t?x@A@B@I@L@T@W@Z@`@a"},
  {0,NULL,"@c@i@l@p@q@s@x@zA?ADAEAFAIAKAPA[A\\A^AdAiAlAnAwA{BCBEBGBKBMBOBRBZB"},
  {0,NULL,"\\B`BcBeBkBsBwCCCECFCYC`CcCdCfChCiCjCkCnCrCtC~DKDLDRDWD^DfDhDkDnDo"},
  {0,NULL,"DpD~EBEGEHEIENEPEQERE]E`EeEjEqEzE~FCFFFHFMFNFUFVF\\F_FgFkFoFqFwFyF"},
  {0,NULL,"|GDGEGNGSGWGXGZG]GdGgGoGqGsGuGwGxGyG|H?HAHBHGHKHOHS_@?I?O?R?Y?[?^"},
  {0,NULL,"?h?n?o?t@@@E@G@I@N@O@P@T@Z@]@h@k@q@t@u@w@z@|@}ABAHAJAKALAUA`AaAeA"},
  {0,NULL,"fAgAiAvB@BABCBFBGBHBPBQBSBUB[BaBcBnBoByCCCJCTCXC\\C^C_C`CbCeCkCmCu"},
  {0,NULL,"CyC|DDDFDPDRDTD^DiDkDlDoDrDsD|EAECEHENEOESEUEWEYEaEdEoEsEuE{FAFDF"},
  {0,NULL,"OFRFSFTFXF]F`FeFoFpFwF{F~G@GEGHGKGMGOGVG^G_GcGgGhGlGpGqGuGvGyG|H@"},
  {0,NULL,"HCHHHIHMHP_@?J?O?S?Y?]?`?h?i?o?p?}@?@H@L@S@X@Y@[@`@c@j@m@p@q@t@y@"},
  {0,NULL,"z@}A@ADAFAGAIAPATAVA[AfAgAhAoA~B@BABCBDBGBJBNBTBVBXB\\B]BeBgBjB{CB"},
  {0,NULL,"CQCRCZC]C_C`CaCcCeCkClCoCwC{DCDGDIDUD]D`DaDdDeDfDtDuD|D}ECEKEQETE"},
  {0,NULL,"VEXE^E_EaEgElEoEyE}FBFCFIFJFNFUFWF^FeFfFoFpFwFyG@GDGEGHGLGNGSGWGY"},
  {0,NULL,"G]GjGmGnGoGrGsGuGvGyGzG}HBHFHIHNHOHRHT_@?J?P?S?X?Z?]?f?m?q?s@C@F@"},
  {0,NULL,"H@K@M@Q@X@Y@^@d@i@l@o@r@t@y@{@}@~A@AFAIAJAQATAVA]AdAiAlAnAxA{A|A~"},
  {0,NULL,"BDBEBHBQBRBSBVB[B]BcBfBnBxCICLCPCVCXC[C\\C]C_CbClCmCuCzC}D@DHDODVD"},
  {0,NULL,"[D_DeDgDjDkDnDqE?EAEDEIELEOEPEUEVE[E`EeEpEsEvF?FAFBFPFRFSFWFZF^F_"},
  {0,NULL,"FgFmFoFuFwFyGCGDGEGNGQGSGUGWG]GaGeGjGkGlGmGtGvGzG{G}HCHDHEHIHPHV_"},
  {0,NULL,"@?H?P?Q?X?_?d?f?j?o?q?{@E@G@L@W@]@`@a@b@c@h@k@r@v@w@y@{@|A@ACAGAH"},
  {0,NULL,"AKANARASAZAhAiAlAmAyA{A}A~BDBEBLBOBXBYBZB^B_BbBhBlBzC@CBCKCWC[C\\C"},
  {0,NULL,"]C^CfCgCiClCrC|C~DADGDLDRDYD^DaDbDmDoDtDuE?EAEFEHEJETEXEYEZE]E`Ef"},
  {0,NULL,"EkEsEuF@FDFFFHFKFMFVFXF\\FgFjFmFoFtFuFzGCGDGEGIGRGXGZG^G`GbGfGmGpG"},
  {0,NULL,"sGtGuGwGzG|G~HAHCHFHKHLHT_@?I?K?R?W?^?c?g?k?p?q?|@C@G@H@P@V@Y@[@]"},
  {0,NULL,"@b@i@l@n@s@t@w@z@~ABACAIAJAKALAOAUAbAdAjAmAoA}B@BABIBKBLBMBNBPBUB"},
  {0,NULL,"WBZB`BdBmBrBtCKCNCRCVCWCYC^C_CdCeChCjCqCxC}DBDJDYD[D]DaDgDhDiDnDt"},
  {0,NULL,"DuD~E@EDEHEJELEMEQEVE\\EbEhEmEpEvE|FAFEFGFLFRFTFYF[FbFiFmFpFtF{F~G"},
  {0,NULL,"@GCGHGKGOGPGUGVG_GdGgGoGpGrGtGvGwG{G|H?H@HGHIHLHOHRHU_@?H?K?Q?W?\\"},
  {0,NULL,"?_?g?l?p?r@?@B@J@L@R@U@\\@_@`@a@j@m@n@w@x@y@{ABACADAFAGAHARASAWAYA"},
  {0,NULL,"dAgAjAkAxA}B?BFBIBLBMBQBRBSBYB^BaBcBfBoBsC?CMCSCVCWCXC]C^C`CbCdCm"},
  {0,NULL,"C{D?D@DDDIDMDNDWD_D`DcDfDmDpDrE@ECEDEIENERESEXE[E_EbEcEoEpEwE}FBF"},
  {0,NULL,"DFKFQFXFZF]F^FhFiFmFpFtFuFzF~GCGHGIGJGXGYGZG`GaGcGfGiGmGoGpGxGyGz"},
  {0,NULL,"G{G|HAHEHHHJHX_@?J?L?S?V?Z?a?h?m?r?x?{@B@I@L@N@O@T@W@Z@a@j@m@o@r@"},
  {0,NULL,"s@x@{@~A?AEAFAHAIAQA\\A]A^AeAiAjAnAwAyAzBBBCBGBKBOBPBUBWBZB\\BeBlBr"},
  {0,NULL,"BuCACGCOCWCYCZC`CcCeChCiCjCuCxCzDDDKDNDRDTD^DdDeDhDkDmDpE@EEEGEHE"},
  {0,NULL,"IEREVEYE]E^EaEeEiEpEwF?FAFBFOFPFRFSFTFZF`FdFnFpFvFxF{F~GBGFGJGMGR"},
  {0,NULL,"G[G\\G^GcGdGfGjGlGnGrGuG|HBHEHFHIHLHMHNHU_@?H?K?Q?W?\\?_?g?j?v?w?~@"},
  {0,NULL,"C@J@K@Q@R@U@\\@_@d@j@m@n@w@x@y@{ABACADAFAGAHARASAWAYAeAlAmAoAvAzB?"},
  {0,NULL,"BCBFBHBJBNBRBWB\\B`BcBdBfBiBsC?CJCSCXC`CaCbCdCeChCjCkCpCrCyDADODSD"},
  {0,NULL,"XD\\D^D`DbDcDeDjDsD~E@ECEPERETEUEZE[E^EbEfEkEqEuE|FDFFFKFMFQFVFXF]"},
  {0,NULL,"FbFcFkFlFqFsF|F}G?GGGKGOGPGQGTGUGbGeGgGhGjGnGrGuH?HBHDHFHIHKHNHPH"},
  {0,NULL,"S_@?H?N?Q?T?d?e?g?j?o?x?{?}@G@L@P@V@W@]@b@c@j@m@p@r@u@v@|A@AAAEAG"},
  {0,NULL,"AHAIAMANAXAZAeAlAmAoAvA{A|A}BEBHBLBYB[B^B_B`BbBdBqBvB}CFCICTCVCWC"},
  {0,NULL,"[C\\C]CcCfCgCmCoCxC}DEDLDTDYD]D^D_DaDcDkDoDtD}E?EEEJEQESETEYE[E]Eb"},
  {0,NULL,"EfEiElEyF?FBFEFGFLFPFWFYF[FbFcFkFpFqFsF{F|F}G@GLGPGQGTGUG\\GaGdGiG"},
  {0,NULL,"lGpGsGvGxG{G}HAHHHJHLHMHOHSHY_@?I?O?R?Y?[?^?h?k?v?y@?@A@I@J@N@O@R"},
  {0,NULL,"@T@Z@_@h@k@q@t@u@w@z@|@}ABAHAJAKALAUA`AaAhAjAnAoAvAxAyA{A|BBBHBSB"},
  {0,NULL,"TBXB\\B_BaBeBoBwByCJCPCTCXCZC[C\\CcCgCkClCmCvCxCzDBDKDNDQDSDcDgDhDj"},
  {0,NULL,"DmDoDsD|D}EAEIEJEMENEREWEZEaEhEmEnEvEyFAFEFLFOFRFSFTFYFdFfFlFnFrF"},
  {0,NULL,"vG?GAGFGGGJGLGNGSGYG\\GbGdGeGfGiGjGsGtGzG~HBHEHGHJHKHLH[_@?H?M?Q?U"},
  {0,NULL,"?\\?e?f?l?t?u?|@@@G@K@M@P@Q@V@^@d@h@k@n@p@u@xAAABADAEAGAHAJAMAWAXA"},
  {0,NULL,"YAdAfAkAnAwAzA{BBBEBJBKBNBTBVBWB]B_BbBjBmBpCDCOCUCZC\\CaCcCeCfChCi"},
  {0,NULL,"ClCuCwD?D@DFDVDZD[D_DbDdDgDiDlDmD|EBEGELESEVEWEXEZE\\E`EcEjEoEwE{F"},
  {0,NULL,"BFDFPFQFWFZF]F^F_FaFkFoFqFsFwFyF|F}GMGPGQGTGUG[GaGbGfGgGlGnGsGtGz"},
  {0,NULL,"G~HDHHHIHKHLHOHWH\\H]_@?I?L?R?V?b?c?h?k?q?u?{?|@G@H@S@V@X@Y@[@b@h@"},
  {0,NULL,"k@n@o@s@v@~A?AAACAGAJAKAOA_AbAcAhAjAnAoAxA|B?B@BABIBMBPBRBUB\\B`Bd"},
  {0,NULL,"BeBiBkBvB~CLCMCVCYC^C`CbCdCeCfCjCpCwC{C~DGDJDVD]D_DaDgDnDrDsDuE@E"},
  {0,NULL,"FEGEJELENEQETEUE\\EaEhEjEkEwF@FCFDFIFJFKFNFQFUFdFfFlFoFrFyG?GAGDGG"},
  {0,NULL,"GJGLGRGYG[G\\GaGcGhGmGnGqGvGwGyH@HAHDHFHMHOHPHQHV_@?J?L?S?V?Z?a?h?"},
  {0,NULL,"i?u?w?~@D@I@K@M@N@O@Q@T@Z@j@m@o@r@s@x@{@~A?AEAFAHAIAQA\\A]A^AfAgAh"},
  {0,NULL,"AoAwAxA|A}B@BABKBOBQBTBXBZB[B^BlBuB|CGCNCOCVCWCYC[C^CbCgChCiCvCyC"},
  {0,NULL,"|DBDFDPDQDSDcDdDiDjDlDpDtE@EEEFEMEOESEZE]E^E_EaEgEkErExE|FAFFFHFM"},
  {0,NULL,"FOFRFSFTFeFfFlFoFrFwFyG?GDGEGNGOGSGVGWG]GaGeGgGiGpGqGtGxG{HAHCHGH"},
  {0,NULL,"HHJHKHPHTHUHWH^_@?I?N?R?T?[?b?g?k?x?y@A@D@I@J@O@R@T@U@\\@_@i@l@o@q"},
  {0,NULL,"@u@v@|@}A?AAAFAJAKA_A`AaAcAdAjAmAoAvAyA}A~BBBHBLBNBSBTBWBXB]BaBgB"},
  {0,NULL,"pB|C@CACHCZC\\C]CaCgCiCkClCmCpCrC{D?DNDSDWDXDhDjDmDpDqDsDuD}E?EBEI"},
  {0,NULL,"EKELEMENEZE^EbEhEjElE~F@FCFDFIFKFNFQFXF]FbFiFkFpFqFsF{F~G@GHGKGOG"},
  {0,NULL,"VGXG_G`GeGfGhGkGlGmGuGxGyG}HCHDHEHHHKHNHRHUHZH\\_@?J?M?S?U?`?a?f?i"},
  {0,NULL,"?p?z?|?}@H@L@S@W@[@`@a@c@i@l@p@q@s@x@zA?ADAEAFAIAKAPA[A\\A^AfAhAkA"},
  {0,NULL,"mAvA~B?BCBDBFBGBVB\\B]B_BaBbBeBkBqBwC?CCCECXC\\C_C`CaCcCjCkClCqCvC|"},
  {0,NULL,"DADGDMDUDYD`DfDjDkDrDtDuD|D~EBEIEJEKEOEQETE_E`EgEmErE{E|FAFFFHFMF"},
  {0,NULL,"OFTFVF\\FaFjFmFnFtFvFxFzGBGFGMGPGRGTG[G^GbGcGeGkGlGmGpGrG}H@HCHDHE"},
  {0,NULL,"HFHJHLHQHSHXH[_@?I?K?R?W?^?c?g?n?t?w@B@E@G@I@N@P@V@Z@]@b@i@l@n@s@"},
  {0,NULL,"t@w@z@~ABACAIAJAKALAOAUAbAeAgAkAlAvAzB@BABDBHBJBPBSBUBVBYB^BaBhBr"},
  {0,NULL,"BtCDCNCRCXCYC]C^C_CaCeCkCmCoCsCtDEDLDPDTDZDdDiDkDlDoDqDuD~ECEDEHE"},
  {0,NULL,"KELEOEWEYE]EbEdEqEtEzE}FCFEFGFJFLFUFYF[FcFhFkFlFrF|F}G?GAGGGIGJGL"},
  {0,NULL,"GYGZG\\GeGiGkGlGmGnGqGsG}G~HAHBHCHDHEHMH]H^H`_@?H?M?Q?U?\\?e?f?j?v?"},
  {0,NULL,"z?~@A@J@K@M@Q@R@U@^@d@h@k@n@p@u@xAAABADAEAGAHAJAMAWAXAYAhAiAlAmAz"},
  {0,NULL,"A~B?B@BDBFBJBNBOBPBRBWBZBcBmBpBuCDCQCUCXCYCZC_C`CaCdCeChCzC}DCDED"},
  {0,NULL,"HDODQDXDaDbDcDeDlDqDsD|D~EGEMEUEYEZE[E\\E^E`EfEiEmEyEzFBFEFGFPFWFY"},
  {0,NULL,"FZF^FgFjFmFnFtFuFvFxFzGCGIGNGWGXGZG`GcGhGiGjGkGoGqGvGyG{H@HEHGHMH"},
  {0,NULL,"NHPHWHZ_@?H?N?Q?T?d?e?g?l?s?u@@@D@G@K@M@P@V@]@^@b@j@m@p@r@u@v@|A@"},
  {0,NULL,"AAAEAGAHAIAMANAXAZAdAgAjAkAzA{BEBGBIBJBMBNBSBWB_BaBbBeBqByB}B~CFC"},
  {0,NULL,"ICZC[C\\CaCcCfChCjCkCqCsCtDBDJDPDZD[D^D_D`DdDgDlDnD}EBEEEOERESETEV"},
  {0,NULL,"EWE\\EbEcEnErExE~FEFFFGFHFLFYF[F\\FhFiFlFmFrFtFuFzGAGCGIGVGXGZG_G`G"},
  {0,NULL,"jGkGnGqGrGtGuGwG~H@HBHCHFHGHIHNHXHYHdHe_@?I?N?R?T?[?b?g?n?s?z?}@F"},
  {0,NULL,"@H@J@R@S@U@X@\\@_@i@l@o@q@u@v@|@}A?AAAFAJAKA_A`AaAcAeAgAkAlAwAyAzB"},
  {0,NULL,"BBIBJBMBOBTBXBYB^B`BdBgBzB|CACHCUCVCWCZCfCgChCiCjClCyD@DADDDIDMDO"},
  {0,NULL,"D\\DbDeDfDhDiDqDrE?EBEEEHEKEMEPEUEXE_EbEdErEsE{F?FAFDFKFOFQFSFXF]F"},
  {0,NULL,"cFhFlFmFrFuFzG?GAGGGJGLGQGTGYG\\GaGbGcGdGgGjGoGwGzG|H?HFHGHJHOHPHZ"},
  {0,NULL,"H\\H^H`_@?J?P?S?X?Z?]?f?i?w?y@D@E@I@K@M@N@O@Q@^@d@i@l@o@r@t@y@{@}@"},
  {0,NULL,"~A@AFAIAJAQATAVA]AfAhAkAmAwAxA|B?BFBIBKBOBQBZB[B_BbBdBnBxB}CLCPCS"},
  {0,NULL,"CVCWCYC[CbCdCfCiCmCwD?DCDEDFDQDXDZDcDdDfDiDjDnDsE?EDEFEMEOEPEQESE"},
  {0,NULL,"WE^E`EgElEtE}F@FBFCFIFJFPFWFZF^FaFjFkFnFsFvFxF}GBGFGIGMGRG[G^G`Gd"},
  {0,NULL,"GfGgGhGiGnGoGwG|G~H?HGHHHMHNHOHQH[H_He_@?E?P?U?`?c?d?k?v?w?y?~@A@"},
  {0,NULL,"D@K@V@Y@[@^@b@c@f@g@i@k@t@wA?AAAFAHALAMANATA[A`AcAhAmApAqAvAwAxA|"},
  {0,NULL,"BBBFBGBNBOBSBWBXBYBcBjBqBrBvCBCICMCRCXCbChCiCnCpCqCtCuCyC~D@DBDCD"},
  {0,NULL,"DDEDGDNDYD_DfDrDvDwE@ECEDEEEGEHEVEYEhEmEnEpEwE~F@FBFGFIFJFYFZF\\Fd"},
  {0,NULL,"FiFjFlFrFuFvG?GCGFGKGMGOGXG[G`GaGgGhGnGvGwG{H@HGHIHOHPHQHYH`HeHfH"},
  {0,NULL,"h_@?F?O?V?`?c?d?j?v?w?y?~@A@D@I@W@Z@[@]@b@c@e@f@j@k@w@yAAAEAFAJAL"},
  {0,NULL,"AMAOASAWA[A^AhAoApAtAvAxAzB?BBBHBMBNBOBQBTBVBZBcBkBqBrBzCCCICKCRC"},
  {0,NULL,"ZCbCiCmCnCoCrCsCuCvC~D?D@DBDDDEDGDOD]D_DgDkDvDxE?EAEBEDEEEHEXE_Ef"},
  {0,NULL,"EkEqEsEyEzF?FAFHFLFMFSFUFYFcFfFgFkFqFsFwG?GEGGGIGJGNGWG\\G`GdGfGiG"},
  {0,NULL,"lGpGsG|HAHCHHHKHLHTHXH]H^HaHd_@?G?K?T?Z?^?e?i?p?r?z?}@?@F@J@M@N@O"},
  {0,NULL,"@P@Q@R@e@g@l@m@s@x@}A@AGAKAPATAUAWAXA^A`AgAkArAuA{A~B?BFBGBLBMBPB"},
  {0,NULL,"TBVBXBYB\\B`BlBnBpByCDCJCLCOC]CdCgCjCnCpCrCvCxC}C~D@DBDCDDDEDGDPDZ"},
  {0,NULL,"D_DnDsDyD{E?E@EAEFEGEHEZE]EgEkEmErEyE}F@FDFKFOFSFYFZF^FfFhFjFnFtF"},
  {0,NULL,"zG?GBGFGGGLGWGXGYG]G`GfGgGhGiGoGxH?HGHHHJHKHPHZH^HaHeHgHh_@?F?N?W"},
  {0,NULL,"?]?c?e?m?r?x?y@?@A@B@J@U@V@X@Y@^@d@e@g@j@l@o@r@zADAHAKAMAQAYA[A\\A"},
  {0,NULL,"_AbAdAjAqAuAvAyA}B@BBBCBKBOBRB^BaBbBcBeBiBjBmBnB~CBCLCUCWCXCgCkCn"},
  {0,NULL,"CoCsCvCyCzC{C|C}D?DADEDJDRD[DbDtDuDwD{D|E?EAECEFEOESEUEeEiEpEsEuE"},
  {0,NULL,"zE~FDFGFIFNFXFZF^F`FgFiFnFuFvFzF{F~GFGKGOGSGXGZG]GaGbGeGhGkGxGzG{"},
  {0,NULL,"HDHEHJHPHQHRHWHZHbHeHi_@?E?P?U?Z?[?\\?k?o?p?q?{?|?}@L@O@Q@R@T@_@a@"},
  {0,NULL,"f@g@i@k@t@wA?AAAGAIAOARAUAWA\\A]A_AhAmArAsAzA}B@BDBEBLBMBQBUBVB\\Bb"},
  {0,NULL,"BdBeBsBuByB|CGCHCJCSC]C_CcCfCnCoCsCtCuCxCzC{C|D?D@DADJDQDXDbDpDqD"},
  {0,NULL,"yDzD}EAEBECEEEOEREWEhEmEnEpEwE~F@FFFKFOFTFXFZF\\FdFiFjFpFtF{G@GBGC"},
  {0,NULL,"GFGLGRGXGYGZG[GeGfGmGsGuGxG}HBHEHJHKHLHXHZH[H^HbHcHk_@?G?P?U?]?c?"},
  {0,NULL,"e?k?r?x?y@?@A@B@L@V@Y@[@^@b@c@f@g@h@l@o@v@zABAFAHAMANATAUA[A_AaAd"},
  {0,NULL,"AnApAqAvAwA}BBBFBJBLBOBSBXB[B\\BcBeBiBjBqBtB~CBCICNCWCXC`CiCnCtCwC"},
  {0,NULL,"xCyC{C|C}DADCDDDEDSDVD[DiDlDtDvDwD~E@ECEEEFEPETEUEhEjEkElEvEyE|FF"},
  {0,NULL,"FLFMFNFUFWF[F_FbFfFpFqFsF~GDGEGHGJGNGPGSGTG\\GcGdGpGrGvGwGyG|H@HAH"},
  {0,NULL,"FHOHSHTHVHYH]H`Hj_@?F?M?X?_?`?b?n?t?u?w@@@D@E@K@S@U@X@\\@`@d@f@g@k"},
  {0,NULL,"@l@n@s@|@}AHAIAOAPASAUAVAYAaAfAkAqAsAzA{BABHBJBKBLBPBQBZB[B\\B_BaB"},
  {0,NULL,"fBgBvB{C?CACMCQCYC[C\\ChCnCrCsCwCxCyCzC}C~D?DADBDMDTDUDeDhDmDwDzD}"},
  {0,NULL,"E?E@EEEGEJEQE[EdEiEqEtEuE{F?FBFIFJFPFQFVF]F`FaFcFlFrFvFxF|F}GAGMG"},
  {0,NULL,"OGQGUGVG^GaGbGgGjGoGtGzG{G~H?HGHNHQHRH\\H_HgHh_@?D?K?T?Z?[?\\?i?o?p"},
  {0,NULL,"?q?{?|?}@G@M@N@O@P@Q@R@e@g@i@j@t@yA?AEAGAKAUAVAWAXA[A\\A`AmAoArAuA"},
  {0,NULL,"~B@BABBBGBLBMBVBYB\\B_B`BbBcBpBuBxByCDCGCJCPC]C^CfCjCnCsCtCwCxCyC|"},
  {0,NULL,"C}C~D?D@DDDSDUDXDhDlDpDyD{EAEDEEEFEGEPEWE[EgElEoEtExE{E|FEFPFRFTF"},
  {0,NULL,"WF[F]FaFbFeFoFyF|F}G@GDGHGPGRGTGVG^G_GgGiGpGqGtGwG~HAHGHHHMHOHUHY"},
  {0,NULL,"H]H_HaHh_@?E?N?W?^?a?d?m?s?v?z?~@C@F@J@T@W@Z@]@_@a@e@g@i@m@p@q@{@"},
  {0,NULL,"~AGAJALAQARAVAZA[AaAeAlArAtAxAyBABBBDBIBJBNBRB[B]B_BcBdBhBkBlBoC@"},
  {0,NULL,"CCCOCTCVCZCaCdCnCqCtCwCxCyCzC{D?DADBDCDLDTDVDdDiDmDxDyD|E@EBEFEGE"},
  {0,NULL,"NEQETEeEjEnEqEvEwF?FDFLFMFOFQFSFVF_FcFdFnFqFsFxGAGBGGGJGNGQGUGWGY"},
  {0,NULL,"GcGdGfGjGoGuGyG|H?HBHKHNHSHTH[H\\H^HgHj_@?G?O?V?^?a?d?j?s?v?z?~@C@"},
  {0,NULL,"F@H@W@Z@[@]@b@c@e@f@h@m@p@u@{ACAFAJALAOARAXAYA[A^AeAiApAtAxAzA~B?"},
  {0,NULL,"BBBDBKBNBQBTB`BaBcBdBhBkBrB}C@CCCFCRCVCZCbClCnCsCvCwCxC{C|C}D?D@D"},
  {0,NULL,"ADBDRDTDXDmDpDuDvDxD}E?EBEDEFEQESEWEfEiElEmEuE|F@FCFGFIFTFVF[F\\F`"},
  {0,NULL,"FbFjFmFuFvFxG@GCGHGKGOGQGRGTG[GaGbGmGpGsGwGzG{G}HAHLHOHQHRHXHYH]H"},
  {0,NULL,"cHi_@?F?O?V?Z?[?\\?j?o?p?q?{?|?}@H@O@Q@R@U@X@d@e@f@j@k@w@yAAAEAIAK"},
  {0,NULL,"ANARAVAXA]A_A`AhAoAsAuAwA}A~BABDBEBGBSBUBYB_B`BdBeBpBsBxB|CDCHCPC"},
  {0,NULL,"SC^C_CcCjCnCqCsCtCuCwCyCzC{C}DADDDLDQDSDdDlDqDzD{D~EBECEDEGENEPER"},
  {0,NULL,"EfEkEqEsEyEzF?FCFKFQFSFUFWF^FcFfFgFmFtFzGAGDGEGGGLGPGUGWG\\G]GhGjG"},
  {0,NULL,"kGoGrGvH?H@HDHFHNHPHVHWH\\H`HeHgHk_@?E?L?Y?_?`?b?l?t?u?w@@@D@E@I@S"},
  {0,NULL,"@T@\\@_@`@a@e@f@k@m@n@x@|A@AIAJANAPAXAYA\\AaAcAfAgAsAtAwA{A|A~B@BJB"},
  {0,NULL,"KBPBSBWB[B`BaBbBfBgBwBzC?CACECKCYC[CeCmCnCpCtCxCyCzC{C|C}C~D?DEDI"},
  {0,NULL,"DUD[DaDhDtDxDzD~E?E@EAEDEIEUE[EcEjEoEpEvExE~FAFHFMFNFRFXF]F_FeFiF"},
  {0,NULL,"kFsFwFyF{F}F~GIGNGSGVGZG_GcGdGeGiGqGxGyG|HEHHHJHMHSHTHUHZHaHb_@?D"},
  {0,NULL,"?K?T?`?c?d?i?v?w?y?~@A@D@J@S@[@\\@`@b@c@e@g@i@j@t@yA?AEAHAJANAOASA"},
  {0,NULL,"TA]A^AcAmAoAqAtAwAzA|B?BEBFBHBQBSBTBUBWBXBZBjBkBvBzCBCCCKCMCXCZCh"},
  {0,NULL,"CmCoCpCqCrCsCtCuCvCzD@DCDDDFDYD]D^DkDrDwDxD|EAEBECEGELEVEXEgElEoE"},
  {0,NULL,"tExE{E|FDFIFMFNFVF[F]FaFbFeFnFsFvFxF}F~GHGNGOGQGSGTGVGbGcGeGjGmGr"},
  {0,NULL,"GyGzG}HEHFHNHRHSHVH\\HbHcHnHoHrHt_@?D?M?X?\\?]?b?n?o?t?x?{@B@E@L@S@"},
  {0,NULL,"U@X@\\@`@d@f@g@h@i@q@u@~ACAHAIALAPASAVAYA`AbAiAlAqAsAxA{BABCBGBHBK"},
  {0,NULL,"BNBPBYBZB^B_BaBfBiB{B|B~C?CHCQCWCYC\\CcCoCqCrCvCwCxC~D?D@DBDCDDDHD"},
  {0,NULL,"ODPD`DgDnDwDzD}E@EBEEEFEMEZE_EdEoErEsExEzE}FFFHFKFNFUFXF^FeFgFhFp"},
  {0,NULL,"FtFwFzF{F~GEGIGLGSGZG\\G]GbGdGoGrGsGxGzG|H?HFHJHLHRHTHVHXHZHgHlHsH"},
  {0,NULL,"t_@?F?N?W?[?_?a?m?q?s?u?|@@@C@G@T@W@Z@]@_@a@e@g@j@l@o@r@zADAGAJAL"},
  {0,NULL,"APARATAZA]AaAdAjArAtAxA{BDBEBFBIBJBNBPBUBXB[B]BdBhBoBuBwC@CECGCTC"},
  {0,NULL,"VCaCeCfCoCqCrCuCwCyC~DADBDCDDDEDHDNDWD`DfDoDxDyD|D~EEEFEGEMEYE^Ee"},
  {0,NULL,"EiEpEsEuEzE~FEFGFHFRFTFXF\\F`FgFiFoFuFwFyF{G@GCGIGKGRGZG[G_GdGnGqG"},
  {0,NULL,"sGuGwG|HBHIHLHMHOHTHUHXHYH[HfHmHrHt_@?G?K?T?_?`?b?i?t?u?w@@@D@E@G"},
  {0,NULL,"@S@[@\\@`@b@c@e@g@l@m@s@x@}A@AHAJANAOAQASAVA\\AcAgAkAqAtAwAyAzA|B@B"},
  {0,NULL,"ABHBQBRBSBWBZB_BbBvBwBzB{CECKCMCQC\\CeChCmCpCrCsCtCuCwCxCzC{C|C}DA"},
  {0,NULL,"DIDMDQDaDeDqDwDxD|D}D~EAEGEIEJEREgEkEmErEyE}F@FEFHFJFKFUFYF\\FfFhF"},
  {0,NULL,"jFoFrFtFwG?GCGEGIGLGMG[G\\G`GlGmGnGrGsGvG}H@HCHFHIHLHVHXH`HcHdHfHi"},
  {0,NULL,"HjHv_@?D?M?X?^?a?d?n?s?v?z?~@C@F@K@M@N@P@W@Z@]@f@g@h@i@q@u@~ACAFA"},
  {0,NULL,"GAOAQAXAZA^A_AaAiAlApArAyAzA}A~B?BIBJBQBRBTB[B]B`BeBlBoBrB}CFCOCR"},
  {0,NULL,"CTCaCbCdClCpCqCsCtCvCwCyCzC{C|C}D?DIDLDRDaDdDuDvDyD|D}E@ECEDEIENE"},
  {0,NULL,"SEdEoErEsExEzE}FBFGFHFRFSFYF^FeFgFhFlFuFwFyFzG?GGGIGKGWG]G_G`GhGi"},
  {0,NULL,"GkGlGnGqHCHDHHHIHMHPHUHWHaHdHeHfHjHkHw_@?E?N?W?\\?]?b?m?o?t?x?{@B@"},
  {0,NULL,"E@G@U@V@X@Y@^@d@e@g@i@m@p@q@{@~AHAKAMAPAYA]A^A_AbAeAlAqAuAvA{A}B?"},
  {0,NULL,"BCBEBKBOBPBTBUB^BaBeBiBmBxB{B~CPCQCUCWC\\C^CkCoCpCqCuCvC{C|C~D?D@D"},
  {0,NULL,"BDEDKDOD\\DcDgDjDwD{D|D}EAEDEFEKE\\E_EeEjEnEqEvEwF?FEFJFLFPFQFUFWF_"},
  {0,NULL,"FcFdFoFqFrF|GAGDGEGJGMGPGUG\\G^GaGkGlGpGtGvG{G~H@HAHCHDHQHWH]H_H`H"},
  {0,NULL,"dHnHoHs_@?E?L?Y?Z?^?e?l?p?r?z?}@?@F@H@M@N@P@V@Y@^@e@f@k@m@n@x@|A@"},
  {0,NULL,"AFAKAQASATAUAWAZAbAfAgApAuAyBCBFBHBIBLBMBRBVBXBZB\\B]B^BnBpBtB}CDC"},
  {0,NULL,"FCLCNC`CgCjClCoCpCqCrCuCxCzC~D@DADBDCDFDPDWD^DnDoDvD{D}D~E?EBEGEL"},
  {0,NULL,"EZE^EcEjEoEpEvExE~FCFGFNFRFWF[F^F_FeFiFmFuFyFzF~GDGHGKGPGSGTG]G_G"},
  {0,NULL,"bGkGnGrGtGwGzG~HDHFHIHOHRHVHWHYH_HfHlHnHpHy_@?G?O?V?\\?]?b?j?o?t?x"},
  {0,NULL,"?{@B@E@I@O@Q@R@U@X@d@e@f@h@m@p@u@{ACAIAKAMASAVAZA]A_A`AeAiAsAuAvA"},
  {0,NULL,"}BABEBGBHBIBOBUBYBZB]B_BeBfBmBxB|C?CHCPCUCYC^CcCkCpCqCrCtCuCvCwC{"},
  {0,NULL,"DBDCDDDEDHDYD\\D`DjDrDzD{D|D~E@EBEDEMEVE\\EfEiElEmEuE|F@FAFIFPFTFXF"},
  {0,NULL,"ZF]F`FbFjFkFvF{F|F}G@GFGOGRGVGXGZG^GeGgGhGjGqGuHBHEHGHMHNHPHUH[H\\"},
  {0,NULL,"HbHeHhHlHmHoHp_@?D?L?Y?[?_?a?l?q?s?u?|@@@C@H@S@T@\\@_@`@a@e@f@h@j@"},
  {0,NULL,"r@vABADAIAJAMAPAWAZA\\AaAcAjAnAsAtAvA{A|B@BIBJBMBOBPBVBWB[B]BbBgBh"},
  {0,NULL,"BsBwC@CACECSCVC[C_CeCoCpCqCvCyC|C}C~D@DCDDDEDKDNDZDcDfDsDxDzD~E?E"},
  {0,NULL,"CEDEFEKEYE]EcEnErEtEwE{E}FCFJFKFOFQFVF\\FaFdFhFmFrFtFxGAGBGCGLGMGQ"},
  {0,NULL,"GUGYG[GaGcGmGoGvGxGyG{G}H?H@HJHQHSHZH`HcHgHmHoHqHx_@?F?M?X?Z?^?e?"},
  {0,NULL,"n?p?r?z?}@?@F@L@M@N@P@W@Z@]@f@g@k@l@n@s@|@}AFAGAQAXAZA^A`AbAcAfAk"},
  {0,NULL,"ApArAyA|A~B?BCBGBIBRBTBWBYB]B^B`BlBtByB}CFCJCNCOC]C`CdClCoCpCqCrC"},
  {0,NULL,"uCvCzC{C}C~DDDEDFDZD\\D^DjDsDvDyD}D~E@EAECELE\\E]EdEiEqEtEuE{F?FFFL"},
  {0,NULL,"FOFPFTFVF[F`FaFcFpFqFxF|G@GBGHGJGQGRGTGYG^GcGlGmGpGqGuGyG}HAHBHCH"},
  {0,NULL,"MHSHUH[H]HcHdHpHqHr_@?G?P?U?[?_?a?k?q?s?u?|@@@C@K@O@Q@R@T@_@a@f@g"},
  {0,NULL,"@h@l@o@v@zABAGAIALARAWA\\A]AbAcAdAnArAsAxA|B@BCBDBEBMBNBUBVBWB^BbB"},
  {0,NULL,"dBgBoBsBuCACGCSCTC[C_CaCfCoCpCrCsCuCvC|D@DADBDCDEDKDWD]DcDkDoDyDz"},
  {0,NULL,"D|D}E?ECEEEKEXE^EhEjEkElEvEyE|FBFMFQFRFSFWF]F_FbFfFlFsFyF}GAGDGGG"},
  {0,NULL,"NGPGUGVGWG_GeGfGiGjGkGtG~HDHEHHHKHNHWH\\H^H_HaHbHpHqHsHt_@?D?L?Y?]"},
  {0,NULL,"?c?e?l?r?x?y@?@A@B@I@M@N@P@V@Y@^@e@f@h@j@r@vABADAFAKANAQARATAUAYA"},
  {0,NULL,"bAjAnApAuAwAyBCBDBFBKBLBRBSBXB\\B^BaBdBmBnBqBtCICLCNCUC`CgCiCkCoCr"},
  {0,NULL,"CsCtCwCxCyCzC|D?DADCDJDMDVDbDeDiDvD{D|D~E?EBEEEJEOETEcEnErEtEwE{E"},
  {0,NULL,"}FAFJFLFOFPFYFZFaFdFhFkFqFrF|G?GBGFGJGMGXGYG^G`GfGgGlGnGtGuG~HBHC"},
  {0,NULL,"HGHIHKH[H^H_HdHfHhHiHkHzH~_@?D?K?T?Z?[?\\?m?q?s?v?{@A@B@G@M@N@R@Z@"},
  {0,NULL,"^@b@e@g@i@j@t@yA?AEAGAKAUAVAWAXA[A\\A`AfAiAjAlAnArAtA|A~BIBJBZB\\B^"},
  {0,NULL,"BaBfBpBqBvBxB{B}CACECGCJCKCNCRC^CaCfCkCnCxC}DFDNDODRDUDVD`DaDjDlD"},
  {0,NULL,"mDrDwD{EDEEEJEKEUEWEXE^EeEnEqEtExEzE~FEFPFRFSFYFZF]FdFgFhFnFtFxGA"},
  {0,NULL,"GBGCGGGLGSGXGZG\\G]GjGkGlGrGtGvG}HBHEHIHLHMHWH[H^HdHeHfHkHmHsHuHwH"},
  {0,NULL,"yHzI@_@?G?P?U?]?c?e?n?r?s?z@@@B@E@L@S@[@]@^@a@b@f@g@h@l@o@v@zABAF"},
  {0,NULL,"AHAMANATAUA[A_AaAeAgAiAkAoApArA~B?BBBMBSBUBZB_BiBjBkBsBwBxB|C@CDC"},
  {0,NULL,"GCICJCKCNCWC\\C`ClCnCtCyDHDIDSDTDZD]DcDdDgDjDpDtDwDzD~EFELERETEZE["},
  {0,NULL,"E^EdEkErEsEuE{E|FFFGFJFUFWF[F\\F`FhFjFlFuFzG?GBGFGGGMGOGVGXGZG^GbG"},
  {0,NULL,"eGkGrGsGxG}G~HAHBHCHKHQHRHXHcHdHfHiHlHrHvHxH~I?I@_@?G?O?V?^?a?d?l"},
  {0,NULL,"?s?t?u@?@B@F@H@V@X@Z@`@b@c@e@f@h@m@p@u@{ACAFAJALAOARAXAYA[A^AdAgA"},
  {0,NULL,"kAmAnAsAtAzA|B@BEBXBYB\\BcBiBpBrBvBxByB}C@CBCCCGCHCQCSCVC`CeClCnCs"},
  {0,NULL,"D?DKDMDPDXDYD[D^DhDjDqDsDuDvD{D}EFEMEOEPEQEYE^EcEjElEoEwE}F@FCFHF"},
  {0,NULL,"LFTFUF[F\\F_FfFhFkFsFwFyF}GAGGGJGWGXGYG]G`GhGkGnGqGrGwGyG}H?H@HBHN"},
  {0,NULL,"HSHTHVH`HdHfHjHnHqHxHyH{H|H}_@?E?P?U?Z?[?\\?n?o?t?w?}?~@F@L@Q@T@Z@"},
  {0,NULL,"\\@_@c@f@g@i@k@t@wA?AAAGAIAOARAUAWA\\A]A_AeAfAgAjAlAqAsAvA{B@BKBRBX"},
  {0,NULL,"B]BdBkBnBqBtBuBwByB~C@CBCHCKCSCUCYC]CcCdCsC|DADFDIDJDNDODTD_DeDnD"},
  {0,NULL,"pDsDtDvDyEAEBEMERESETEVE\\EdEnEqEtExEzE~FFFMFOFSFXFZF]F_FcFeFlFrF|"},
  {0,NULL,"F}GAGDGEGKGPGTGWG]G_GcGgGpGqGuGwG|H?H@HFHJHPHSHTHUH\\HaHgHiHpHqHsH"},
  {0,NULL,"tHvH~I?_@?F?O?V?Z?[?\\?l?p?r?y?|@@@D@H@O@U@[@\\@^@d@e@f@j@k@w@yAAAE"},
  {0,NULL,"AIAKANARAVAXA]A_A`AdAfAjAkAlApAuAyA}B?BCBNBPB[B_BhBiBkBoBsBvB|CBC"},
  {0,NULL,"DCFCOCPCQCRC[C_CgCjCtCwC{DFDLDMDNDOD[DcDiDkDoDqDuDxDzECEGEHEIEPEQ"},
  {0,NULL,"EZE]EcEnEqEtExEzE~FCFIFQFSFZF]F^F`FaFiFkFqF|G@GBGFGHGIGRGVGZG[G_G"},
  {0,NULL,"aGfGmGoGsGxGzG~HAHDHHHOHQHRHZH_HbHhHjHlHmHoHpH{H|H}_@?G?P?U?[?_?a"},
  {0,NULL,"?n?r?s?z@@@B@E@K@N@O@R@U@^@a@f@g@h@l@o@v@zABAGAIALARAWA\\A]AbAcAeA"},
  {0,NULL,"gAiAkAoApArA~B?BBBMBSBUBZB_BgBjBmBpBsBvBzCCCGCICLCPCRCTCYC[CaCdCo"},
  {0,NULL,"CuD@DMDPDRDSD\\D]D^D_DaDcDhDtDwDzD|E?ENEQETEVE^E_EdEiElEtEyEzE}FBF"},
  {0,NULL,"MFOFSFXFZF]F`FhFjFpFuFxG@GBGCGHGIGLGMGZG[G\\GaGcGgGjGoGvG|HHHIHMHO"},
  {0,NULL,"HPHUHZH[HeHgHhHkHmHnHoHwHyH|H}IAIE_@?F?M?X?Z?^?e?k?p?q?u@?@A@D@L@"},
  {0,NULL,"M@T@Z@]@`@b@f@g@k@l@n@s@|@}AFAGAQAXAZA^A`AbAcAdAeAhAjAoArAsBABDBE"},
  {0,NULL,"BIBOBTBaBcBhBiBmBtBzB{B}C?CCCECHCJCOCPC]C`CfCiCpCqCvDNDQDTD[D\\D]D"},
  {0,NULL,"^D`DbDcDeDiDvDwD~EAEPEVEWE[E]E_EhEjEkEqEuE~F@FFFHFLFPFRFTFYFfFgFi"},
  {0,NULL,"FlFtFyFzGAGDGGGKGOGSGXG]G`GbGdGpGrGtGwH?HBHGHJHKHLHTHXHYH^HaHfHjH"},
  {0,NULL,"kHmHnHoHwHyH{IAIC_@?D?K?T?`?c?d?m?q?s?v?{@A@B@J@R@S@X@`@a@b@e@g@i"},
  {0,NULL,"@j@t@yA?AEAHAJANAOASATA]A^AcAfAiAjAlAnArAtA|A~BIBJBZB\\B^BaBgBjBnB"},
  {0,NULL,"pBtBvB|C?CCCFCJCKCOCSCVCWCXCZCpCrCuDFDHDJDKDLDUDiDlDoDrDsDtDwD{EB"},
  {0,NULL,"ECEQESEWEXEZE\\EeEoEpEsEwE{F?FDFKFNFUFVF[F\\FdFgFhFoFuFwFyG?GCGGGJG"},
  {0,NULL,"MGXG\\G^G`GaGbGgGhGwGxGyG|H?HAHHHKHQHTHXHZH`HgHiHjHlHpHqHvHxH}IBIC"},
  {0,NULL,"_@?E?N?W?\\?]?b?i?o?p?z?~@D@E@G@M@U@Y@[@]@^@e@g@i@m@p@q@{@~AHAKAMA"},
  {0,NULL,"PAYA]A^A_AbAfAgAhAmAnArAuBCBDBLBMBOBSBWB[BgBhBiBrBtBwB{CFCGCICPCS"},
  {0,NULL,"CTCUC\\C^ChCjCoCvDEDFDGDIDKDVDXDeDgDhDmDoDsDwDxD}EDENEPEREXEYE\\EgE"},
  {0,NULL,"mEnErEvExE|FEFGFIFJFQFWF^FeFiFjFnFtFzF{G@GBGFGIGNGOGSGVGZGdGnGoGr"},
  {0,NULL,"GsGvG~HBHGHMHNHOHRHVHYHeHfHhHiHlHpHqHvHxH{H|IBIE_@?E?N?W?^?a?d?i?"},
  {0,NULL,"o?p?z?~@D@E@J@O@T@U@]@`@a@e@g@i@m@p@q@{@~AGAJALAQARAVAZA[AaAfAgAh"},
  {0,NULL,"AmAnArAuBCBDBLBMBOBSBWB[BfBhBiBjBkBqBsCACHCLCNCOCTCUCZC]CdCmCwCyD"},
  {0,NULL,"ADKDPDQDUDVDYD_DbDgDkDlDmDwDxE@EBEJELENEUE\\E]EgEjElEoEwE}F@FDFHFL"},
  {0,NULL,"FMFOFTFXFeFiFjFoFuFyFzG@GDGHGIGKGMGOG[G`GaGbGcGeGmGpHCHDHHHJHKHPH"},
  {0,NULL,"UHXHZHaHbHcHkHmHrHtHuHwHyHzIFIG_@?F?M?X?_?`?b?k?p?q?u@?@A@D@K@M@R"},
  {0,NULL,"@U@X@Y@`@f@g@k@l@n@s@|@}AHAIAOAPASAUAVAYAaAdAeAhAjAoArAsBABDBEBIB"},
  {0,NULL,"OBTBaBcBkBnBrBvBxB{B}C?C@CACDCOCTCUCXC[C_ChCwCxD?DGDJDSDTDWD\\D^Dd"},
  {0,NULL,"DeDkDpDrDvDwE?EGEKESETEYE[E]EhEiEmEpEvEyF?FBFIFKFNFQFVF^FfFgFiFpF"},
  {0,NULL,"tFwFyF{G@GCGIGJGNGSG\\G`GaGhGlGmGnGvGyHDHEHHHMHNHVHWHZH`HbHeHiHlHs"},
  {0,NULL,"HtHvHxH~I?IHII_@?G?K?T?_?`?b?m?r?t?x@@@C@F@G@P@W@Y@[@\\@c@e@g@l@m@"},
  {0,NULL,"s@x@}A@AHAJANAOAQASAVA\\AcAdAeAhAiAnAqAuAvAwA}BGBNBQBVBdBqBsBuBwBy"},
  {0,NULL,"BzB}CDCHCMCNCPCQCRCVCWC\\CeCsCtCzDGDQDRDVDWD\\DaDbDcDfDlDsDxDyD}D~E"},
  {0,NULL,"JEMENEWEZE_EeEiEmEpEvEyF?FEFKFNFUFVF[F\\F_F`FbFnFvF{F|F}F~GFGNGQGU"},
  {0,NULL,"GVGWG_GdGiGqGsGwGxG{G~H?H@HAHGHQHRHSHTHYH]HkHnHoHrHtHuHwHz_@?D?M?"},
  {0,NULL,"X?^?a?d?k?v?x?y?{?|@C@K@N@O@P@V@W@d@f@g@h@i@q@u@~ACAFAGAOAQAXAZA^"},
  {0,NULL,"A_AaAgAjAmAnAoApAqAwAyBFBHBPBVB`BbBfBgBlBnBoBwBxCDCFCKCMCQCRCUCaC"},
  {0,NULL,"bCfCiCzC{C}DIDJDKDPDSDYD`DdDeDfDoDtDyDzD|EDEHERESEXE[E_EhEjElEoEw"},
  {0,NULL,"E}F@FBFHFLFPFRFTFYFaFbFdFpFqFsFvFxF~GHGLGQGRGUGYG[GdGfGiGjGoGtGzG"},
  {0,NULL,"{HGHIHLHOHYH[H]H^H_HhHiHpHqHrHvH~I?I@_@?F?N?W?]?c?e?i?u?w?y?|?}@?"},
  {0,NULL,"@J@Q@S@V@X@_@d@e@g@j@l@o@r@zADAHAKAMAQAYA[A\\A_AbAfAhAiAkAoAqAtAxA"},
  {0,NULL,"zBHBKBYB]B`BeBfBlBmBnBoBsB}B~C@CACBCCCHCRCXCgChCjC{C|D?DHDQDRDUDZ"},
  {0,NULL,"D]D^DaDbDmDnDoDyD{E?ECEHENEUEVEWEYEgEkErEsEuE{E|FDFGFIFJFQFWF^FaF"},
  {0,NULL,"cFfFoFqFrFsFwG?GEGJGPGRGTGYG^GfGgGhGnGoGuGyGzG|HFHNHOHVH\\H_H`HgHh"},
  {0,NULL,"HkHnHoHsHuHwHzI@_@?E?L?Y?_?`?b?j?v?w?z?{?}@E@I@N@R@S@W@_@a@e@f@k@"},
  {0,NULL,"m@n@x@|A@AIAJANAPAXAYA\\AaAcAdAeAhAlAmApAtAxBBBFBJBUB^BbBeBfBgBiBm"},
  {0,NULL,"BnBoByCBCECGCICKCNCOCYCZCcCmCyC|C}DGDLDWDXD[D\\D`DgDhDiDnDuDzD{E@E"},
  {0,NULL,"AEIELEOEPEVEXEfEiEmEpEvEyF?FAFKFMFNFOFVFXFcFdFjFmFrFuFvFxG?GCGLGM"},
  {0,NULL,"GPGUG\\G^GbGeGgGjGtGuG|HCHFHIHKHLHXH[H\\H^HcHgHjHmHoHqHxH{H|H}IFIH_"},
  {0,NULL,"@?G?O?V?\\?]?b?l?s?t?u@?@B@F@I@M@Q@R@X@Z@_@e@f@h@m@p@u@{ACAIAKAMAS"},
  {0,NULL,"AVAZA]A_A`AdAgAkAmAnAsAtAzA|B@BEBXBYB\\BcBjBlBmBqBrBuBxC?CCCHCJCKC"},
  {0,NULL,"MCTCYC[CgCkCqCuDDDIDVDWDXDYDZDbDfDjDkDtDuDvD{D|E@EHEJELEMEQE[EcEm"},
  {0,NULL,"EnErEvExE|FAFIFQFSFZF]F^F_FfFhFmFrFtFwGAGCGEGJGPGSGTG\\G]GaGfGgGlG"},
  {0,NULL,"pGtGzG|HEHHHJHLHWHZH^H_HaHgHkHrHsHtHvHzI?I@IAIDIKIN_@?G?K?T?Z?^?e"},
  {0,NULL,"?m?r?t?x@@@C@F@J@O@P@Q@T@\\@d@e@g@l@m@s@x@}A@AGAKAPATAUAWAXA^A`AdA"},
  {0,NULL,"eAhAiAnAqAuAvAwA}BGBNBQBVBdBgBkBlBrByBzB|C?CBCDCICLCMCSCaCdCgCkC~"},
  {0,NULL,"D@DDDGDHDKDQDTD[DaDdDgDrDsDuDxDyE?E@EJEOETEXEYEZEeEjEkEqEuE~F@FDF"},
  {0,NULL,"PFRFSFYFZF]F_F`FbFoFqF|F~GDGEGHGKGQGRGTG[G_GcGfGjGlGmGuGzHDHEHFHI"},
  {0,NULL,"HPHUHWH[H\\H_HbHlHpHqHxH{H|H~I?IDIEIM_@?F?O?V?`?c?d?l?p?r?y?|@@@D@"},
  {0,NULL,"I@O@P@W@[@]@a@e@f@j@k@w@yAAAEAFAJALAMAOASAWA[A^AdAfAjAkAlApAuAyA}"},
  {0,NULL,"B?BCBNBPB[B_BfBkBlBuBzB{B|B~CICJCPCRCTCUC`CeCiCmCvD@DBDJDLDODUDWD"},
  {0,NULL,"ZDaDeDjDkDnDqDxDzEAEEEHEKEMEPETEUEcEoEpEsEwE{F?FAFHFLFTFUF[F\\F`Fa"},
  {0,NULL,"FiFmFuFvFzF~GFGHGMGOGQGUGVG[GcGdGeGjGqGrH@HBHCHGHIHPHSHUHYH[HcHfH"},
  {0,NULL,"iHrHsHtHuHwH~I@IBIJILIM_@?E?L?Y?Z?^?e?j?v?w?z?{?}@E@H@N@S@V@^@b@d"},
  {0,NULL,"@e@f@k@m@n@x@|A@AFAKAQASATAUAWAZAbAdAeAhAlAmApAtAxBBBFBJBUB^BbBeB"},
  {0,NULL,"gBjBnBpBsBuB{B~C@CECFCMCNCTC^CbCjClCoCrDCDODQDTDWDYD[DfDhDkDlDnDp"},
  {0,NULL,"DzD{D}EGEIEKELEMENESEfEjEkEqEuE~F@FCFGFJFPFRFWFYFcFdFjFkFqFsFxG?G"},
  {0,NULL,"BGGGLGRGXGYGZG^GhGiGkGoGvGxGyG{G}HAHMHOHQH]H`HdHeHhHiHkHrHsHtHzH~"},
  {0,NULL,"I@IAIBIMIN_@?D?L?Y?]?c?e?j?o?q?x?~@A@C@I@M@P@Q@T@Y@]@e@f@h@j@r@vA"},
  {0,NULL,"BADAFAKANAQARATAUAYAbAiAkAlAmAoAsAuA{BABGBLBQBRBTBWBoBqBtBvBwByBz"},
  {0,NULL,"C?CACGCLCOCQCUC^CbCiCkCxCzDADHDLDMDXDZD]D_DfDhDiDqDrDvDxD|EEEIEKE"},
  {0,NULL,"OEQE\\E_EfEkErEsEuE{E|FAFGFJFPFRFWFYFbFeFgFmFtFzF{F~GDGEGKGNGOGQGS"},
  {0,NULL,"GTGcGdGiGlGpGvG{HEHGHJHMHPHUHWHYH]HaHeHjHlHnHpHyH{H|H}IGIIIQ_@?D?"},
  {0,NULL,"M?X?\\?]?b?k?v?x?y?{?|@C@L@S@W@[@\\@_@d@f@g@h@i@q@u@~ACAHAIALAPASAV"},
  {0,NULL,"AYA`AbAgAjAmAnAoApAqAwAyBFBHBPBVB`BbBfBhBlBpByBzB|B~CCCECFCLCNCQC"},
  {0,NULL,"WCXC_CcCrC~DBDIDNDPDVDXD]D^D_D`DdDlDqDyDzEBEFEOESEUE]E^E_EhEmEnEr"},
  {0,NULL,"EvExE|FFFIFKFNFQFVF^FaFbFdFlFqFrFvF|G?GFGPGRGUGVG^G_GeGhGmGqGuGxG"},
  {0,NULL,"yH@HAHCHDHFHQHSH\\H`HbHcHmHnHoHuHyHzH|H}IEILINIO_@?F?N?W?[?_?a?i?u"},
  {0,NULL,"?w?y?|?}@?@G@N@V@W@Z@_@c@e@g@j@l@o@r@zADAGAJALAPARATAZA]AaAfAhAiA"},
  {0,NULL,"kAoAqAtAxAzBHBKBYB]B`BeBmBoBrBtBuBxB|B~C?C@CECFCICQC]CeCfCmCqDBDC"},
  {0,NULL,"DFDGDHDMDRDSDbDgDoDpDqDrDyD{D~EEEIEUEYEZE[E\\EgEiElEtEyEzE}FEFHFLF"},
  {0,NULL,"MFOFTFXFaFcFfFnFrFsFvFxF}GAGLGPGUGWGYG]GeGiGkGpGqGtG{G}H@HCHJHLHS"},
  {0,NULL,"H]H^HaHcHdHjHlHpHqHxH}H~I?ICIDIMIO_@?D?L?Y?[?_?a?j?o?q?x?~@A@C@H@"},
  {0,NULL,"T@U@Y@\\@`@c@e@f@h@j@r@vABADAIAJAMAPAWAZA\\AaAcAiAkAlAmAoAsAuA{BABG"},
  {0,NULL,"BLBQBRBTBWBhBjBlBtBwB{B}B~CACDCJCLCMCSCVCZC_CcCpC~DEDMDODRDSDYDZD"},
  {0,NULL,"dDfDiDjDmDnDvDxECEFEHEKELEOEREWEfEiElEtEyEzE}FCFKFMFNFOFVFXFbFeFg"},
  {0,NULL,"FkFyF{F|F}G@GDGIGKGNGWG_G`GbGmGnGsGuGwG~H?HDHFHKHNHRHTHVHXH\\HbHrH"},
  {0,NULL,"sHtHuHvHwI?I@IDIJIKIL_@?E?P?U?`?c?d?n?o?t?w?}?~@F@K@P@Q@V@X@Y@c@f"},
  {0,NULL,"@g@i@k@t@wA?AAAFAHALAMANATA[A`AcAeAfAgAjAlAqAsAvA{B@BKBRBXB]BdBhB"},
  {0,NULL,"mBoBpBqBrBuCACBCECLCMCPCSC\\CbChClDCDDDEDJDLDNDPDUD\\D_D`DcDmDpDuDv"},
  {0,NULL,"DyEDEGEIEJEREVE]E^EdEoEpEsEwE{F?FBFGFJFUFWF[F\\F_FcFeFpFsFwF{F}F~G"},
  {0,NULL,"EGJGNGQGTGWGYGfGiGkGlGnGsGzG{G}G~HEHNHRHVHWH]H_HdHjHmHnHoHuHyHzH{"},
  {0,NULL,"ICILINIT_@?D?K?W?\\?]?c?i?o?p?q?|?~@C@G@M@P@Q@Y@[@]@e@g@i@j@t@y@|@"},
  {0,NULL,"~ABACADAHAKASAUAYAbAmAoArAuA~B@BABBBGBLBMBWB[B]B`BgBrBtBuBwByBzCG"},
  {0,NULL,"CPCTCUCYC\\C^ChCiCjClCnCxC}DKDMDWDXD[D]D^DfDgDhDiDuDxDyEDEEEIEMEPE"},
  {0,NULL,"QEVE\\EeEoEpEsEwEzE}FDFKFNFUFXFZF^FaFcFdFoFyF|F}G?GFGGGLGQGUGWGYG["},
  {0,NULL,"GeGmGnGqGsGuHBHCHDHIHKHPHVHWH\\H_H`HdHkHmHsHuHwHyHzI@IAIJILINIRIUI"},
  {0,NULL,"WIX_@?G?P?X?]?_?b?k?r?x?y@?@C@F@L@W@Y@[@\\@_@c@f@g@h@l@o@v@{@}A@AC"},
  {0,NULL,"AEAHAIANASAVA]AdAnApAqAvAwA}BBBFBJBLBTBVB`BcBhBpBqBtBuByBzB~CFCNC"},
  {0,NULL,"QCWCXCZC^C_CcCeCnCtCyDFDPDQDUDVDWD`DaDkDlDmDsDvDyD~EFEKENEUEWE\\E_"},
  {0,NULL,"EdEiElEtEuE}F@FBFIFJFPFXFZF]FfFgFhFpFrFuGCGDGEGHGKGWGXGYG]G`GfGlG"},
  {0,NULL,"mGpGtGuGzG{G}HCHIHLHRHVHWHXHZHbHiHlHrHvHxH~I?I@IBIDIKIMIPIQIVIW_@"},
  {0,NULL,"?G?O?Y?]?^?e?j?s?v?z@@@C@E@H@S@[@]@^@b@d@e@f@h@m@p@u@z@}A?A@ABAFA"},
  {0,NULL,"KATAUA[A`AeAiApAtAxAzA~B?BBBDBKBQBUBWBbBhBjBkBsBuB{B|C@CECFCNCWC]"},
  {0,NULL,"C^CbChCjClCnCsD?DHDJDNDSDTDWDcDeDnDpDrDtDxDzD}EFELERESE[E\\E]EcEmE"},
  {0,NULL,"nErEvEyE}FAFLFOFSFYFZF^F_FbFeFmFqFwG@GCGEGHGIGNGUGVGWG_GcGjGmGoGu"},
  {0,NULL,"GvGyG|H@HCHFHIHUHVHWHYHeHfHjHnHqHxHyH{H|H}ICIEIFIIIOIQITIU_@?E?P?"},
  {0,NULL,"X?Z?^?d?k?o?p?q?{@D@E@L@O@T@]@`@a@b@f@g@i@k@t@w@{@|@~A@ADAFAGAQAR"},
  {0,NULL,"ATAZAhAmArAsAzA}B@BDBEBLBMBOBPBaBbBhBiBjBmBsBzB|C?CHCJCOCZC]C`CeC"},
  {0,NULL,"fCgCiCsC|DADHDQDRDVDYD\\D^DaDbDfDgDmDwDzEAEBEHEJEUEWEZE]EdEoEpEsEv"},
  {0,NULL,"ExF?FBFGFRFSFWF[F^FaFcFdFpFsF{F}GBGFGGGMGPGUGVG\\G^GdGhGoGrGvGxGyG"},
  {0,NULL,"|H?HHHMHNHSHUHYH[H]HhHiHpHqHsHtHvH~I?IBIDIHIIIKIMIRIS_@?F?O?Y?[?_"},
  {0,NULL,"?`?j?o?p?q?}@?@A@H@R@U@X@Y@`@c@e@f@j@k@w@y@z@|@}@~ADAIAJALAPAVAaA"},
  {0,NULL,"hAoAsAuAwA}A~BABDBEBGBRBTB^BeBjBlBpBrBxB{B}CACDCLCSCVCWCZC_CaCcCh"},
  {0,NULL,"CtCwC{DGDIDPDSDTDZD^DdDeDfDgDtDvD{ECEGEKERESETEXE^EcEoEpEsEuE{E~F"},
  {0,NULL,"AFHFRFTFXF\\F]FaFcFdFmFvFzF}GAGFGGGJGRGTGXGYG^GbGiGkGpGtGwGzG{G~HE"},
  {0,NULL,"HGHJHQHXHZH^HcHgHjHlHmHoHpH{H|H}ICIEIGIHIOITIVIX_@?G?K?W?^?_?a?i?"},
  {0,NULL,"t?u?w@?@B@E@G@N@V@Z@`@b@c@e@g@l@m@s@x@z@{AAABACAGAJALAOARAWAgAkAq"},
  {0,NULL,"AtAwAyAzA|B@BABHBOBSBYBeBpBrBtBvBxB{B|B~C@CECQC]C_CeCfCiClCmCsCtC"},
  {0,NULL,"zDHDLDMDODPDXD_DiDjDoDqDuDwD{D}D~EIEKEOEPEYE]EeEjEkEqEuEvE|FDFMFQ"},
  {0,NULL,"FRFSFVF]F`FiFjFoFtFxF~GCGEGHGOGSGVGXGZG^GaGgGoGpGtGvGyGzG{G|HAHOH"},
  {0,NULL,"THUHXHYHZHaHkHnHoHrHtHuHwHzIAIFIGIJILINIPIS_@?D?K?W?\\?]?c?i?v?w?y"},
  {0,NULL,"?|?~@C@J@Q@S@[@\\@_@d@e@g@i@j@t@y@|@~ABACADAHAKASAUAYAbAmAoAqAtAwA"},
  {0,NULL,"zA|B?BEBFBHBWB[B]B`BfBkBlBsByBzB}B~C@CBCCCXC[C`CcCgChCjCpCrCuDPDR"},
  {0,NULL,"DTDXD\\D]D^D`DbDcDdDhDxDyEBECEPETEUEVE]E^EeEnEqEtEwEzE}FEFJFLFPFUF"},
  {0,NULL,"YFZFeFgFiFnFtFxF~GCGEGHGIGKGWG[G_G`GcGdGfGiGoGpG{G|H?H@HJHLHQHRHY"},
  {0,NULL,"HZHeHhHiHjHlHpHqHvHxH}IDIEIHIIIMIQITIVIZI[_@?F?N?T?Z?[?e?m?r?x?y@"},
  {0,NULL,"@@A@D@J@O@T@U@\\@^@d@e@g@j@l@o@r@|@}AAACAEAGAKAXAZA_A`AdAjAqAuAvAy"},
  {0,NULL,"A}B@BBBCBKBNBQBZBaBgBhBiBjBkBrB|CBCDCLCMCYC_CaCdCgCkClC{C|D?DGDLD"},
  {0,NULL,"NDXDYD[D`DhDkDqDsDuDwDxE?ECEIELEOEQEZE^EgEiElEtEyE{F?FEFLFOFPFTFW"},
  {0,NULL,"F[FfFgFhFnFrFuFvFzGAGDGIGJGMGNG\\G`GbGcGdGjGrGwG~H?H@HFHGHNH[H^HeH"},
  {0,NULL,"fHgHhHkHnHoHsHuHwHzI@IAIFIGIJILINIRIW_@?E?N?T?`?b?d?m?o?t?x?{?}@F"},
  {0,NULL,"@G@P@V@W@X@Y@c@e@g@i@m@p@q@|A?A@AAABAHAJAMANAaAcAeAlAqAuAvA{A}B?B"},
  {0,NULL,"CBEBKBVB\\B^BdBmBoBqBsBuBxB}CDCMCPCQCVCWC[C\\C`CbCeCoCvDEDLDNDQDSD\\"},
  {0,NULL,"D]D^D_DaDcDiDpDyD{D}EDEJEQE[E]E^E_EgEjElEoExE~F@FDFHFIFMFNFXF]FdF"},
  {0,NULL,"hFjFoFrFuFvFzGAGDGLGRGXGYGZG]GgGjGqGtGuGwGzHFHGHIHOHPHTHVHXH`HfHg"},
  {0,NULL,"HiHlHpHqHvHxH{H|ICIDIHIIIMIOIQIVIZI]_@?F?M?U?`?c?e?n?t?u?w?|?}@@@"},
  {0,NULL,"K@P@Q@S@V@X@d@f@g@k@l@n@s@z@{AAADAEAFAHAMAYA[A^AfAkAqAsAzA{BABHBJ"},
  {0,NULL,"BKBLBUB]B_BdBfBgBhBlBmBoBpCACBCMCSCZC\\C^CbCgChClCwCxD?DKDNDRDUDVD"},
  {0,NULL,"ZD_DbDjDlDmDoDyDzE?EGEJELENEVEWEXEhEjEkEqEyEzE~FFFHFLFMFNFUFYF`Fi"},
  {0,NULL,"FjFlFtFvFxFzF~GAGIGLGRGZG[G_GcGeGiGjGkGqH@HDHEHFHJHPHQH`HcHdHeHfH"},
  {0,NULL,"iHlHsHtHvHxH~I?IBIDIKIMIQIRISIVI_Ia_@?D?M?U?[?\\?a?n?o?t?x?~@A@B@L"},
  {0,NULL,"@T@U@Z@\\@`@c@f@g@h@i@q@uA?A@ABADAEAGAIAPAWAXA\\AiAlAqAsAxA{BABCBGB"},
  {0,NULL,"HBKBRBSBXBZBiBkBnBtBwB{B}B~CBCHCSCVCYC]CcCdCjCmCrC~DBDJDODRDWDZD["},
  {0,NULL,"DaDfDiDkDnDpDvDwEBEFEHELEMENEPEREhEjElEoEwE{E|FBFPFQFRFTFWF]FdFhF"},
  {0,NULL,"jFpFtFvFxFzF~GAGJGMGOGXG^G`GcGkGlGpGrGvGyG{G}H@HEHNHUHZH[HbHcHeHm"},
  {0,NULL,"HnHoHuHyHzH|H}IAICIFIGIJITIUIXI]I^I`_@?E?P?X?Z?^?d?k?v?w?y?{@D@E@"},
  {0,NULL,"K@N@O@V@^@b@d@f@g@i@k@t@w@{@|@~A@ADAFAGAQARATAZAhAmApAqAvAwAxA|BB"},
  {0,NULL,"BFBGBOBPBaBbBgBjBnBsBvBwBxCFCMCQCRCVCaCbCfCiCjCkDCDDDEDIDMDQDWDYD"},
  {0,NULL,"ZDbDdDfDhDjDnDwDzEDEGEHEKEMEQESEWEdEnEqEtEvExF?FFFLFMFOFSFVF[FeFg"},
  {0,NULL,"FiFlFrFuGCGDGEGHGIGNGSGVGZG\\GaGbGeGjGmGtGzG~HAHCHDHFHWHXH^HaHdHfH"},
  {0,NULL,"jHmHnHoHuHyHzH{IAIEIFIGIJIOIUIXI[I^I`_@?G?P?X?]?_?b?k?q?s?u@?@C@F"},
  {0,NULL,"@K@M@Q@R@X@Y@_@f@g@h@l@o@v@{@}A@ACAEAHAIANASAVA]AdAnArAsAxA|B@BCB"},
  {0,NULL,"DBEBMBTBVB`BcBkBnBoBqBrBuBxC?CACOCTCXC[C_ChCjCkCmCoCuD@DLDODTDVDW"},
  {0,NULL,"DYDeDjDkDlDnDuDvDyD|E?EHEIEKELEUE[EdEkErEsEuE}F@FFFHFJFKFUFXF\\F`F"},
  {0,NULL,"aFbFlFsF{F}GBGFGGGKGQGRGTGYG[GdGhGiGnGqGwH?HBHGHJHMHPHQHSH\\H`HgHh"},
  {0,NULL,"HkHmHnHoHwHyH|H}ICIFIGILINITIUIXIYI]_@?F?M?U?`?c?e?n?p?r?z?|?}@@@"},
  {0,NULL,"L@P@S@W@[@]@a@f@g@k@l@n@s@z@{AAADAEAFAHAMAYA[A^AfAkApArAyA|A~B?BC"},
  {0,NULL,"BGBIBUB]B_BdBfBkBlBwBxByB|CGCICJCNCVCWC\\C`CkClCmCpCqCvDODSDUDXDYD"},
  {0,NULL,"ZDfDjDkDmDqDtDyDzD~EAEJEKELEMEOETEhEiEmEpEyEzE~FBFGFIFNFYFZF^F_Fc"},
  {0,NULL,"FfFpFqFwFyF|G?G@GLGPGUGWG]G_GfGgGoGsGuGxG|HHHIHKHLHOHRHTHVHYH]H_H"},
  {0,NULL,"jHkHmHnHoHwHyH{IEIFIGILINIOIUIXIYI[_@?D?M?U?[?\\?a?n?s?v?z?~@A@B@K"},
  {0,NULL,"@M@N@R@U@Z@^@f@g@h@i@q@uA?A@ABADAEAGAIAPAWAXA\\AiAlApArAyAzA}A~B?B"},
  {0,NULL,"IBJBRBSBXBZBmBpBrBvBzB{B}CGCICRCTCYC[C^CaCdCeCgCzC{C}DGDODQDRDUD]"},
  {0,NULL,"DaDbDcDlDnDrDvDwD|EDEJEMENEUEYE^EhEmEnErEwE{E|FFFKFOFQFTFVF\\F_FbF"},
  {0,NULL,"eFlFqFwFyF|G?G@GJGNGOGQGSGTGaGbGgGnGsGwG~HAHBHGHKHOHTH\\H^H_HaHgHi"},
  {0,NULL,"HpHqHrHvH~I?I@IBIDIHIIIKIMIPIW_@?E?N?T?`?b?d?m?s?v?z?{?}@F@J@R@S@"},
  {0,NULL,"W@X@_@a@e@g@i@m@p@q@|A?A@AAABAHAJAMANAaAcAeAlArAtAxAyBABBBDBIBJBV"},
  {0,NULL,"B\\B^BdBgBlBmBnBoBtB|CCCJCKCOCVCWCXCYCZC_CiCwCyDADFDLDMDZD[D\\DcDhD"},
  {0,NULL,"iDnDqDrDyD{E@EBEHEOEPEQEXE_EgEmEnErExE~F@FEFGFHFIFJFYF\\F_FbFeFnFq"},
  {0,NULL,"FsFwF{G@GBGKGPGRGTG]G_GfGhGiGkGlGxG}HEHHHJHLHMHQHRHSH]HbHcHkHmHrH"},
  {0,NULL,"tHuHwHyHzIAIJILINIPISIUIXIeIf_@?E?L?V?Z?\\?b?l?t?u?w?~@D@F@I@M@Q@T"},
  {0,NULL,"@Z@\\@_@e@f@k@m@n@x@z@{@~A?AAAIAKA\\A]A_AbAfAgAsAtAwA{A|A~B@BJBKBNB"},
  {0,NULL,"XB[BcBjBlBqBtBuBwBzC?CCCHCKCWCYC[C]CaCgCkCyC|C}DFDIDJDSDYD]D_DdDj"},
  {0,NULL,"DoDpDtDvDxE@EAEMESETEZE[E_EfEjEkEqEwF?F@FCFJFKFPFQFUFWF`FiFjFkFsF"},
  {0,NULL,"tFxF{F~GBGKGMGOGQG[G`GdGfGlGnGrGsG}H?HBHKHLHNHRH[H\\H_HbHhHjHmHoHq"},
  {0,NULL,"HxH{H|H}ICIEIGIIIOIQITIXI_IcIe_@?G?O?Y?]?^?e?j?o?t?x@@@C@E@I@O@P@"},
  {0,NULL,"Q@T@]@d@e@f@h@m@p@u@z@}A?A@ABAFAKATAUA[A`AeAiAsAuAvA}BABEBGBHBIBQ"},
  {0,NULL,"BUBWBbBfBkBoBvByBzB|C?CACLCUCXC^CbCdCfCiCkCqCuDDDFDGDHDMDTDUDaDiD"},
  {0,NULL,"oDpDrDsDxDzD|E@EOESEUEXEYE\\EcEjElEoEvEyE}FCFLFNFUFWF[F^FdFhFjFkFv"},
  {0,NULL,"FzF}GAGFGGGIGLGMGUG[G\\GbGdGeGiGsGxG~H?HDHHHJHKHQH]H^H_HdHhHkHrHsH"},
  {0,NULL,"tHvHzI?I@IBIJILIMIPIRISIWIYI\\I`Ib_@?G?K?W?^?_?a?i?p?r?z@?@B@E@J@N"},
  {0,NULL,"@O@R@U@`@a@e@g@l@m@s@x@z@{AAABACAGAJALAOARAWAgAkArAuA{A~B?BFBGBLB"},
  {0,NULL,"MBOBSBYBeBfBjBnBpBqBsBvCLCOCTCUCZC[C]CbCcCdCmC~D@DDDJDMDNDPDVD]D_"},
  {0,NULL,"D`DcDmDqDtDwD{E?E@EIENESEVE]E_EeEiEmEpEuEvE|FEFGFRFTFVF[F\\F_FcFfF"},
  {0,NULL,"nFyF|F}G?GFGGGJGPGSGTG\\G^GbGeGhGkGnGrG~HBHDHEHMHNHSH[H\\H^HcHdHlHp"},
  {0,NULL,"HqHxH{H|H~I?IBICIHIIIKIOIQIVI\\I]Ig_@?F?O?Y?[?_?`?j?v?w?y?}@?@A@I@"},
  {0,NULL,"N@R@W@Z@_@c@e@f@j@k@w@y@z@|@}@~ADAIAJALAPAVAaAhAoApAtAvAxAzB?BBBH"},
  {0,NULL,"BMBRBTB^BeBiBmBoBqBrBxByCECICKCNCYCZC\\CcCdCfCmCvD@DBDGDHDKDSDVD[D"},
  {0,NULL,"bDdDgDhDoDsDvD{EAEEEIEJEREXEZE\\EcEnEqEtEuE{E~FCFIFJFQFVF\\F]FeFgFi"},
  {0,NULL,"FkFqFwG@GCGEGHGKGOGSGTGXG]GgGhGlGnGuGvGyG}HBHIHMHOHSHTHUHVH\\HbHiH"},
  {0,NULL,"rHsHtHuHwH~I@IAIDIKINIPIRISIWIZI^IgIh_@?D?L?V?a?c?d?l?r?x?y?{?|@B"},
  {0,NULL,"@I@N@O@P@V@W@a@e@f@h@j@r@v@}@~A?ACAEAFAJAOAQA^AcAjAnApAuAwAyBCBDB"},
  {0,NULL,"FBKBLBPBYB\\B_BfBgBlBmBnBuB{CICPCRCUC]C`CaCeChCiCmCxCzDADIDJDKDODT"},
  {0,NULL,"D\\D`DdDeDkDpDsDzD{D|EEEHERETEVEYE[EfEiElEtExEzE|FCFGFIFMFNFVF[FfF"},
  {0,NULL,"gFhFkFrFuFyF|G?GDGLGPGSGZG\\G]GaGeGgGhGqGxHAHDHHHMHOHPHSHTH]H`HaHd"},
  {0,NULL,"HjHlHnHpHyH{H|H}ICIEIFIHIOITIUIVIaIdIfIk_@?E?L?V?Z?\\?b?l?p?r?z?~@"},
  {0,NULL,"D@F@H@M@U@Y@[@\\@^@e@f@k@m@n@x@z@{@~A?AAAIAKA\\A]A_AbAfAgApAuAyBCBF"},
  {0,NULL,"BHBIBLBMBNBXB[BcBhBiBoBtBvBwB}CDCFCPCRCXC[C\\C_CfCgCjCoCrDCDFDHDID"},
  {0,NULL,"KDLDRDgDmDoDqDrDtDvDxD}EGEPEWEXEYEZE[EfEiEmEpEwF?F@FAFKFOFPFTFXFZ"},
  {0,NULL,"F_FcFfFmFrFuFyF|G?GDGJGNGQGWGYG`GaGcGmGpGqGwG{H@HAHCHGHPHWHZH`HaH"},
  {0,NULL,"eHgHiHkHrHsHtHzH~I@IDIJIKILIPIRISIWIYIZI`Ig_@?F?N?T?Z?[?e?m?q?s?u"},
  {0,NULL,"@@@A@D@G@M@T@Z@]@^@b@e@g@j@l@o@r@|@}AAACAEAGAKAXAZA_A`AdAjArAtAxA"},
  {0,NULL,"{BDBEBFBIBJBNBQBZBaBfBhBiBqBwB{B}CECGCJCKC^C`CaCbCcCfCkCqDBDCDIDN"},
  {0,NULL,"DPDUD[D\\D^D_D`DeDlDuDwDxD~EEEOEREVEWE^E_EgEkErEsEyE{F?FDFKFOFQFSF"},
  {0,NULL,"WF^F`FaFbFoFqFsFwF{G@GBGMGNGOGQGUGVGaGlGmGsGvGxGyG}HAHCHHHKHUHWH]"},
  {0,NULL,"H_HaHbHjHlHpHqHxH}H~I?IBIEIHIIIKIQITIVI[I\\IgIi_@?D?L?V?a?c?d?l?q?"},
  {0,NULL,"s?u?{?|@B@H@S@V@X@`@a@b@e@f@h@j@r@v@}@~A?ACAEAFAJAOAQA^AcAjAnAsAt"},
  {0,NULL,"AvA{A|B@BIBJBMBPBYB\\B_BgBiBnBpBsBvByC@CCCHCSCVCXC\\C`CdCeClCpC~DED"},
  {0,NULL,"FDGDJDKDQDXDeDgDlDrDsDuDzD{ECEFENEQETEYEZE\\EfEkErEsExEzE|FAFGFHFM"},
  {0,NULL,"FRFSFYF`FaFbFmFsFtFxF{F~GBGPGRGVGZG^G_GfGjGkGoGrGtGzG|HEHFHLHNHRH"},
  {0,NULL,"XHYH[HcHfHrHsHtHuHvHwI?I@IAIBIMINIPIRISIWI\\I^IbIh_@?C?H?R?S?V?Y?f"},
  {0,NULL,"?g?j?l@A@B@D@E@H@I@U@^@`@b@g@n@p@r@u@v@w@x@yALAQAVA[A\\A`AbAcAzA{A"},
  {0,NULL,"}B?BEBFBJBLBVB]B`BdBgBkBlBnBoBrBtBuBwBxByB|CnCoCpCsCwC{C~DCDGDHDI"},
  {0,NULL,"DJDNDPDQDRD^DcDhDiDjDkDlDmDwDyEHEIEMEOETEXE[E\\E`EbEcEfEzE}E~F@FAF"},
  {0,NULL,"CFHFXFYFZF_FaFbFcFkFmFqFsF|F}GIGJGNGRGVGWGXGYGZG^G_G`GfGiGkGmGoGq"},
  {0,NULL,"GuGwGyG|G~HAHCHEHGHNHTHXHZHbHdHeHfHhHjHtH|I@ICIEISIWI[I]InIp_@?C?"},
  {0,NULL,"I?Q?S?U?X?g?h?k?n?~@@@C@D@K@L@T@[@\\@]@e@n@o@q@s@t@u@v@wANAPARATAX"},
  {0,NULL,"AYA]A^AvAyB@BABBBHBIBMBYB\\B^BeBfBjBlBmBnBpBqBsBuBxB{B}CnCqCrCtCvC"},
  {0,NULL,"|C~DADFDHDRDUDWDXDYD[D_DcDdDeDgDiDqDsDxD{EHEJEKENESEVE[E^EaEbEdEh"},
  {0,NULL,"EuExE|E~FBFFFGFIFRF]FcFdFfFhFlFpFrG?GAGGGKGMGOGPGUGVGWGXG]G^G_G`G"},
  {0,NULL,"gGhGkGpGrGtGuGxG{H?H@HCHHHIHKHNHQHRHUHYH\\HaHbHfHiHoHyI?IBIDIGIUIZ"},
  {0,NULL,"I\\IcIf_@?C?J?Q?R?T?W?f?h?i?m?~@?@A@F@G@J@M@Y@Z@c@f@o@p@q@r@s@t@x@"},
  {0,NULL,"yAMAOASAUAWAZA_AaAwAxA|A~BCBDBGBKBPBUB_BbBfBgBhBiBmBoBpBsBvByBzB|"},
  {0,NULL,"CoCqCsCtCxC}DBDEDIDLDODPDSDWD[D]DbDeDfDjDmDpDrDsDvDzENEOEQEUEVEXE"},
  {0,NULL,"ZE]E`EaEeEgEvExEyEzFDFEFMFNFSF^F`FaFdFjFnFoFvFxGBGFGLGNGOGQGSGUGV"},
  {0,NULL,"GWGXGYGZG]GeGjGoGqGsGtGvGxGyGzG{G}HBHGHKHPHRHSHTHVHWH^HaHeHkHlHqH"},
  {0,NULL,"uIAIIILIVIYI^IaIo_@?C?H?R?S?V?Y?f?g?j?l?|?}@C@F@H@I@P@Q@W@_@g@n@p"},
  {0,NULL,"@r@u@v@w@x@yALAQAVA[A\\A`AbAcAzA{A}B?BEBFBJBLBOBSBZBaBgBiBjBkBnBrB"},
  {0,NULL,"tBvBwBxB{B|CuCvCxCyCzC|DBDDDFDKDSDTDUDVD\\D]D_D`DaDbDfDnDqDuDwDyEK"},
  {0,NULL,"ELEPEQERESEYEZE`EbEcEfEvE{E|F?FAFCFQFVFWF[FgFhFiFjFkFmFtFuFzGCGKG"},
  {0,NULL,"LGMGOGPGQGSGTGUG[G\\G]GaGbGdGeGgGlGrGvG}H?HDHIHJHLHOHPHSHWHYH\\H]H_"},
  {0,NULL,"HcHgHrHsH{H}IOIPIRITIiIjIlIm_@?C?J?Q?R?T?W?f?h?i?m?{?|@@@E@G@J@O@"},
  {0,NULL,"S@a@d@f@o@p@q@r@s@t@x@yAMAOASAUAWAZA_AaAwAxA|A~BCBDBGBKBRBTBXBcBh"},
  {0,NULL,"BiBmBoBpBqBrBtBvByBzB}CpCrCyC{D?D@DADDDJDMDNDTDXDYDZD\\DaDdDgDkDlD"},
  {0,NULL,"nDoDtDvDzEIEJEPEWEYE\\E^E_E`EaEeEgEuEwE{F@FDFEFJFPFTF\\F_FeFfFgFnFo"},
  {0,NULL,"FwFyGDGEGIGJGKGMGPGRGTG[G\\G^G_G`GbGcGfGhGlGnGpGwG|G~H@HDHFHHHLHMH"},
  {0,NULL,"QHUHXH[H_H`HcHhHpHwHxHzIHIJINIQI_I`IhIk_@?C?I?Q?S?U?X?g?h?k?n?{?}"},
  {0,NULL,"@?@B@K@L@N@R@V@X@e@n@o@q@s@t@u@v@wANAPARATAXAYA]A^AvAyB@BABBBHBIB"},
  {0,NULL,"MBNBQBWB[BfBhBjBkBlBqBsBuBwBzB{B}CuCwCzC}D?D@DCDEDGDKDLDMDODQDVDZ"},
  {0,NULL,"D^D`DhDoDpDrDtDuDxD{ELEMERETEUEWE]E_EaEbEdEhEwEyE}F?FBFFFKFLFOFUF"},
  {0,NULL,"`FbFeFiFlFpF{F~G@GHGIGJGLGNGQGRGSGTGYGZG[G\\GaGcGdGiGjGmGnGsGzHAHB"},
  {0,NULL,"HEHFHJHMHOHVHZH[H]H^H`HdHgHmHnHvH~IFIKIMIXIbIdIeIg_@?J?K?S?T?Z?`?"},
  {0,NULL,"g?i?p?w?}@D@I@K@M@N@O@P@Q@R@h@i@j@l@m@s@t@x@y@}A?A@AEATAVA\\A^AgAk"},
  {0,NULL,"AmAoB?B@BABFBTBXB_BbBhBiBlBnBuBxB~C@CGCLCOCPCVCWC^CdCfCgCnCvCwCyC"},
  {0,NULL,"|C~D?DBDCDEDPDSDXDZDlDnDpDsD|E?E@EDEEEFEPEWEZE]EbEeEpEqE~F?FCFFFK"},
  {0,NULL,"FNFUFVF[F\\FcFiFmFpFtFxF~GCGEGHGLGQGSGTG[G\\GeGjGkGlGmGnGrGuG}HBHCH"},
  {0,NULL,"DHEHFHIHNHVHWH[H\\HbHcHdHfHmHsHuHxH{H~IAIKIOIQIRIXIYIbIdIiIkIlItIv"},
  {0,NULL,"_@?J?N?S?W?]?a?g?m?s?x@B@C@I@L@T@W@Z@]@_@a@i@j@k@l@m@o@p@q@r@z@{@"},
  {0,NULL,"~ADAPAQA[A]AdAeAjAlAyA{BBBEBPBRBUBcBkBlBpBuBvBwCCCDCECGCMCOCZCdCe"},
  {0,NULL,"CfChCjCnCrCtCuCwCxCzC~DCDDDLDNDTDWDdDfDmDoD~E@EAEBEEEGENEQEYE^EbE"},
  {0,NULL,"gElErE|E}FBFCFGFIFJFQFWF^FbFhFlFmFrFuFvFzGAGDGKGMGOGPGUG]GaGeGiGk"},
  {0,NULL,"GlGmGpGxG{G}HAHCHDHEHHHJHQHWHZH]HaHbHcHdHlHrHyHzH}I?IBIJIPITIUIVI"},
  {0,NULL,"ZIcIhIjImIoIrIt_@?H?L?Q?Y?_?e?h?l?r?u@?@@@J@L@S@T@\\@_@`@a@h@i@j@k"},
  {0,NULL,"@m@n@r@v@x@|A@ABADANAWAYAZAfAgAjAnAwBIBKBMBSBVB]BaBfBhBrBsBxBzC?C"},
  {0,NULL,"@CKCPCRCSCVCYC^C_CbCmCnCqCtCvC{C}D?D@DDDEDIDKDNDUDaDcDfDhE@EAEBEC"},
  {0,NULL,"EDEFEIEKEYE[EaEfEiEkEuEyFBFEFGFJFPFRFWFYF`FfFlFoFrFuFyF|G?GDGKGMG"},
  {0,NULL,"PG^G_G`GbGfGjGnGrGsGtGuGzG~HBHFHIHKHLHNHRHVHXH[H\\H^H_HfHoHwHxH{I?"},
  {0,NULL,"I@IBIGINIOIQIWIZI`IfIiIkIpIrIu_@?I?M?R?X?^?b?f?n?t?z@E@F@H@J@S@U@"},
  {0,NULL,"X@\\@`@d@h@i@j@k@l@n@q@s@u@|@}@~ACAOA`AaAbAfAiAkAlAzBCBGBJBQBYB[B^"},
  {0,NULL,"BgBiBqBuBvB|B~CACGCHCICMCWC[CcCfChCiCnCoCsCxCyD@DADBDCDDDHDMDODUD"},
  {0,NULL,"`DeDgDhE?EBECEEEFEGEJEME[E_E`EhEjEmEvF@FAFEFHFLFPFRFTFYF_FjFkFoFq"},
  {0,NULL,"FwFyF|G?G@GIGJGRG^G_G`GcGeGhGkGlGmGqGvGyG}H@HCHDHEHMHPHSHUHWH`HbH"},
  {0,NULL,"cHdHeHtHxHyHzH|H~ICIJIKIQISIUI[IbIcIhIkInIqIu_@?J?N?S?W?]?a?g?m?s"},
  {0,NULL,"?x@B@C@H@K@U@V@X@Y@^@d@i@j@k@l@m@o@p@q@r@z@{@~ADAPAQA[A]AdAeAjAlA"},
  {0,NULL,"yA{BBBEBPBRBUBcBjBnBxByBzB{CBCJCKCLCPCQCXC\\C]C^CgCmCnCpCsCuCvCzC|"},
  {0,NULL,"C}C~D@DJDOD[D\\DbDgDjDtD}E?EAECEDEGEOEUE\\E_EbEgElErE|E}FAFFFHFLFMF"},
  {0,NULL,"OFTFXFbFhFkFpFqFsFwF{G@GBGIGJGNGRGYGZGdGgGjGnGoGrGuGwG|H?HBHFHGHI"},
  {0,NULL,"HNHOHTHVHYH[H\\HfHgHhHnHqHvHwH|I@ICIFIIIMINIWI[I`IaIeIgIpIqIv_@?H?"},
  {0,NULL,"O?Q?V?\\?d?h?j?o?v?{?~@J@K@O@Q@R@U@X@d@h@j@k@l@m@p@u@w@y@{AAACAEAM"},
  {0,NULL,"ARASAXAeAhAiAoAvA~BDBHBOBZB`BdBfBmBpBsBtBwC?CDCECNCSCUCYC_C`CeCjC"},
  {0,NULL,"kCpCqCrCtCyCzC}DADCDEDHDQDSD\\D`DjDlDqD|D~E?E@ECEGEMEPERE\\EaEcEnEo"},
  {0,NULL,"EwExFEFFFHFLFTFUF[F\\FdFeFoFpFqFwG@GCGEGHGIGJGRGTG[G\\GaGbGfGiGpGsG"},
  {0,NULL,"tGxGzG{G~HAHHHJHKHLHQHRHXHZH]H^H_HaHjHmHpHrHvHzIEIHIJIMIPIXI]I_Id"},
  {0,NULL,"IgIhIjIuIv_@?I?P?R?U?[?c?f?k?q?y?|@A@I@J@O@Q@R@T@_@a@h@i@k@l@m@o@"},
  {0,NULL,"t@v@w@zA?AAABALAUA_AcAdAhAmAnAxA|A}BLBNBWB\\BeBgBoByB{B|B}CACFCHCJ"},
  {0,NULL,"CQCTC[C\\C]CaCcClCoCpCrCsCvCxCzC{D?DBDKDQDWDXDcDoDpDqD|D}E?E@EAEBE"},
  {0,NULL,"KEREWE^E`EdEsEtEzE{FCFEFGFJFUFWF[F\\FaFgFmFoFrFuGCGDGEGHGKGMGPGTG["},
  {0,NULL,"G\\GcGdGgGhGoGqGvGwGyG|H?H@HGHMHOHPHSHTHUHYH`HeHgHhHiHnHpHsHwH}IDI"},
  {0,NULL,"FIHINIRITI\\I_I`IeIlImItIu_@?I?P?R?U?[?c?f?k?q?y?|@A@G@H@V@Y@[@^@b"},
  {0,NULL,"@c@h@i@k@l@m@o@t@v@w@zA?AAABALAUA_AcAdAhAmAnAxA|A}BLBNBWB\\BeBfBiB"},
  {0,NULL,"lBrBtBvB~C?CMCNCOCRCWCYC`CbCdChCpCqCwCxCyC{C}C~DBDDDGDVDYD[D_DiDr"},
  {0,NULL,"DtD}D~E@EDEFEGEHETEUEVE`EdEsEtEzE{FAFDFMFOFSFXFZF]FaFgFkFnFsF{F}G"},
  {0,NULL,"BGFGGGNGVGWGXGYGZGbGeGfGkGlGmGsGtGzG}G~HCHDHEHKHLHRHWHXH^H_HbHcHd"},
  {0,NULL,"HjHlHmHuI?I@IAIBIEIVIWIXIYIZI]IdIoIpIqIs_@?H?O?Q?V?\\?d?h?j?o?v?{?"},
  {0,NULL,"~@G@L@W@Z@[@]@b@c@h@j@k@l@m@p@u@w@y@{AAACAEAMARASAXAeAhAiAoAvA~BD"},
  {0,NULL,"BHBOBZB`BdBgBhBnBqBzB}C@CACFCICKCLCVC[CgCiClCmCoCrCxC|C}C~D?D@DAD"},
  {0,NULL,"EDGDRDTD]D_DkDmDuD}D~E?EAEEEFEHEQESEXEaEcEnEoEwExFBFDFIFQFSFZF]F^"},
  {0,NULL,"FdFeFlFnFvFzF}GAGFGGGOGUGVGWGXG]GcGhGjGnGqGrGuGvGyH@HBHFHIHMHNHPH"},
  {0,NULL,"SHUHVH[H\\H`HeHfHiHqHsHuHyH|IAICIDIIIRIUIYI[I\\IaIcIlIrIs_@?H?L?Q?Y"},
  {0,NULL,"?_?e?h?l?r?u@?@@@G@K@M@N@P@V@Y@^@h@i@j@k@m@n@r@v@x@|A@ABADANAWAYA"},
  {0,NULL,"ZAfAgAjAnAwBIBKBMBSBVB]BaBkBmBpBqB|B}CCCDCFCHCICUCZCcCiCjCkClCqCr"},
  {0,NULL,"CsCtCuCwD?D@DADBDFDJDPDVD^DbDiDnD|D}EBEDEEEGELEOETEZEaEfEiEkEuEyF"},
  {0,NULL,"DFFFKFMFNFOFVFXF`FfFnFpFsFtFxF{F~GBGLGNGQGSGYGZGaGcGhGiGpGqGvGxGy"},
  {0,NULL,"G{H@HAHHHJHMHPHQHSHUHZH]H`HaHeHkHlHnHtH}H~IFIKILISITIVI^IbIeImInI"},
  {0,NULL,"oIsIv_@?I?M?R?X?^?b?f?n?t?z@E@F@G@I@M@N@P@W@Z@]@h@i@j@k@l@n@q@s@u"},
  {0,NULL,"@|@}@~ACAOA`AaAbAfAiAkAlAzBCBGBJBQBYB[B^BjBoBrBsBtByCBCJCNCRCSCTC"},
  {0,NULL,"XC]C_C`CaCbCoCpCsCtCuCyC{C|DDDEDFDLDRDZD^DdDsDuD|D~EAECEDEEELENES"},
  {0,NULL,"E]E`EhEjEmEvF@FCFDFIFKFNFQFVF^F_FjFmFnFtFvFxFzF~GAGLGOGQGSGUG]GbG"},
  {0,NULL,"dGfGgGoGsGtGwGzG|G~H?HGHKHLHOHRHTHXHYH^H_HgHhHkHoHqHrHvH{IGIIILIM"},
  {0,NULL,"IOIPI^IaIfIgIiIjIsIt_@?J?K?S?T?Z?`?g?i?p?w?}@D@H@L@S@[@\\@`@b@c@h@"},
  {0,NULL,"i@j@l@m@s@t@x@y@}A?A@AEATAVA\\A^AgAkAmAoB?B@BABFBTBXB_BbBjBkBmBoBw"},
  {0,NULL,"B{CBCCCECQCTCUCXCZC\\CaCeCkCoCqCuCvCwCzC{C|DADCDIDMDYD]DaDeDkDrD|D"},
  {0,NULL,"}D~EBECEFEIEJEVEXEbEeEpEqE~F?FAFBFPFRFSFYFZF]FcFiFkFlFyF|F}G?GFGG"},
  {0,NULL,"GVGWGXG^G_G`GaGdGgGiGoGpGwGxG{G|H?HAHGHHHJHOHQHTHYHZH]HaHgHhHiHjH"},
  {0,NULL,"kHoHpHtIDIEIGIHILISI\\I]I^I_IfInIqIr_@?G?L?V?_?a?b?j?r?x?z?~@C@F@H"},
  {0,NULL,"@U@W@Y@[@\\@c@e@f@h@m@o@s@t@v@x@{ACAIAJAOA\\A]AcAeAiApAuBBBFBGBLBNB"},
  {0,NULL,"QBTB`BaBcBdBhBtBwB}B~CDCFCJCMCPCRCVCXCZC\\C_CcCfCnCsD?DFDQDRDUDZD\\"},
  {0,NULL,"D`DbDfDlDmDoDvDxD}EFEJEKEUEVEWEZEcEjEkErEvExE|FAFHFMFQFRFSF]FdFhF"},
  {0,NULL,"jFkFqFzG?GBGFGGGIGJGRGTG[G\\GcGdGlGnGrGvHDHFHIHMHOHPHSH[H\\H`HcHgHj"},
  {0,NULL,"HnHqHxHyH{H|H}ICIEIFIIIOIQITIUI[I]IaIcIeIiIkImItIzI{J?_@?G?M?U?^?"},
  {0,NULL,"a?e?k?t?u?x@?@A@B@L@T@V@Z@`@b@c@f@g@h@l@p@s@u@x@y@zABAFAGAWAXA[A^"},
  {0,NULL,"AdAnAqAsAwBABEBHBOBSBXB[B\\BcBeBiBtB{B}B~CBCCCECHCPCSCVC]C`CfCiCjC"},
  {0,NULL,"mCnCtCyDKDLDODXD[D\\D^DhDiDnDoDqDvDwD~EFEIEMEPEQEXE]EdEiEmErEyEzE}"},
  {0,NULL,"FBFGFOFSFYFZF^F`FaFbFlFrFvF{F|F}GFGKGMGPGTG[G\\GaGbGlGmGnGsGzHDHEH"},
  {0,NULL,"FHJHLH[H]H^H_HcHdHiHlHrHvHxH~I?I@IBIDIKIMIPIQIVIWIZI\\IbIgIjIkIoIp"},
  {0,NULL,"IvIxIyI~_@?D?N?T?[?a?d?i?o?x?y?{?|?}@G@N@O@P@V@W@c@e@g@i@j@n@q@r@"},
  {0,NULL,"u@vA?AEAGAJAXAZAaAcAmAoAqAuBCBHBKBLBVBYB\\B_B`BbBcBmBoBuBxC?CDCFCI"},
  {0,NULL,"CMCPCQC[C]C`CbCeCfCmCnCxC}DHDIDSDTDYD\\DcDeDkDoDpDtDyD{EDEEELESETE"},
  {0,NULL,"YE[E_EeEnErEsEwE{F?FDFKFOFQFSFVF\\FeFgFiFnFtFzF{F~GEGFGVGWGXG^G_G`"},
  {0,NULL,"GfGhGkGlGnGuG~H@HCHDHFHNHUHXH[HbHcHfHkHmHsHuHwHyHzI@IAIJILINIRIUI"},
  {0,NULL,"WIXIYI^I`IcIdIhIlIpIuIwI~J?_@?G?M?U?^?a?e?k?t?u?x?|@@@C@K@O@P@Q@T"},
  {0,NULL,"@V@d@f@g@h@l@p@s@u@x@y@zABAFAGAWAXA[A^AdAnAqAsAwBABEBHBNBUBVBWB^B"},
  {0,NULL,"bBdBfBgBlBoCACBCDCKCMCSCUCZC^CaCbCfCgCiCoCuD@DFDGDIDKDUD[DdDgDiDm"},
  {0,NULL,"DoDrDyDzD|E?EJEPESEXEZE\\EdEiEmErEuE{E|FFFGFOFTFVF[F\\FfFgFhFpFrFtF"},
  {0,NULL,"wF{GCGEGNGVGWGXGYGZGgGhGoGqGuGxGyG{H?H@HGHNHTHUHYHaHeHfHkHmHnHoHw"},
  {0,NULL,"HyH|H}ICIFIGILINITIUIXI[I^I`IcIdIeIfImIrI{I}J@JE_@?F?P?X?Z?[?_?n?"},
  {0,NULL,"r?w?y?}@?@F@L@N@W@Z@\\@_@c@f@g@k@l@o@p@r@w@y@|@}AGAIARAVAZA]AfAkAp"},
  {0,NULL,"AqAvB?BBBKBRBTBWBYB]B^B`BqBtBuByB~C@CFCKCNCQCUCYCZC]C^CcCdCeCpCqC"},
  {0,NULL,"vDFDHDJDKDMDVDgDhDlDpDrDsDvDyD~EAEQEREUEXEYE\\EhEkEpEsEvEyF?FBFKFQ"},
  {0,NULL,"FRFSFWF^F`FiFjFlFuFvFzF~G?GFGIGJGRG^G_G`GdGfGiGnGsGwGzG|G~HAHFHOH"},
  {0,NULL,"XHZH[H^HgHhHjHkHmHnHoHwHyH{IEIFIGILINIOIUIXI]I^I`IcIdIeIfIiIvIyJA"},
  {0,NULL,"JBJCJE_@?G?N?T?]?b?e?i?s?u?z?}@?@F@J@M@Q@R@S@X@_@e@g@l@m@o@p@u@v@"},
  {0,NULL,"w@}A@AHAKAMANA_A`AgAkArAtAxAzBDBMBPBTBVBXBYB\\B`BlBmBnBoCACCCHCJCK"},
  {0,NULL,"COCRCXCYC_CgChCiCjC~D@DDDIDLDODRDYDZDbDeDfDiDkDnDyD{E?E@EHEKEMEQE"},
  {0,NULL,"REUEeEiEjElEvEyF?FEFLFNFPFUFWF[F`FiFjFoFuFxFyG@GCGHGVGWGXG^G_G`Ge"},
  {0,NULL,"GjGkGqGtGuGyG}HBHCHKHNHRHVHWHbHeHfHlHpHqHxH{H|H~I?IBICIHIIIKIOIQI"},
  {0,NULL,"VIZI[I_IaIbIiIkIoIsIwIyIz_@?F?K?W?_?`?c?m?p?q?r?|@@@C@G@P@W@Y@[@]"},
  {0,NULL,"@a@e@g@j@l@n@s@u@w@y@zADAHAJALAOASAYAdAjArAuA}A~BGBIBNBPBUBXB[B]B"},
  {0,NULL,"dBuBwByBzCGCHCNCPCRCTCUCVCWCYC\\CeCiClCqDBDCDJDODQDWDXDYDaDfDhDjDn"},
  {0,NULL,"DtDxDyD~EEEHEJELEMEPESEgEkEqEtEuE{E|FDFIFJFMFQFVF]FfFgFhFnFtFzGAG"},
  {0,NULL,"BGDGGGIGJGNGRGYGZGcGfGiGlGmGpG~HAHDHEHHHMHQHXHZH`HcHdHjHlHpHqHxH}"},
  {0,NULL,"H~I?IBIEIHIIIKIQITIVIZI]I_IaIbIkImIoIuIxI~J@JC_@?G?N?T?]?b?e?i?s?"},
  {0,NULL,"u?z@@@D@E@G@M@S@[@]@^@b@e@g@l@m@o@p@u@v@w@}A@AHAKAMANA_A`AgAkArAt"},
  {0,NULL,"AxAzBDBMBQBRBSBWBZB_BbBhBiBwB{CECFCGCICJCKCSC\\C^C`CbCcChCjCsCtCzD"},
  {0,NULL,"IDJDKDNDSDZD`DdDeDgDnDpDwDxD}D~EHERESETE\\E^EeEiEjElEuE~F@FDFIFNFP"},
  {0,NULL,"FXFZF]F_FcFfFnFsFxFyF}GAGGGLGQGSGTG[G\\GaGbGcGdGpGwG|HHHJHLHMHOHQH"},
  {0,NULL,"]H_H`HgHhHkHnHoHrHtHuHwHzIAIFIGIJILINIPISIYI^I`IeIfIhIjInIuJ@JAJB"},
  {0,NULL,"_@?E?K?W?Z?\\?^?m?t?v?w?{@B@E@G@N@V@Z@^@b@d@e@g@i@m@n@t@v@w@x@{@~A"},
  {0,NULL,"GAKARAUAWAbAeAlAqAtAvAwA|BJBOBPBTBUB^BaBeBpBvBxB{B~C@CACECNCQCRC^"},
  {0,NULL,"C_CaCfCiCkClCoCvDEDMDODTDUDWDZDdDfDjDkDlDqDwD{D}EDEHEIEKELETEWEgE"},
  {0,NULL,"mEoEpEwE}F@FDFKFOFTFXFZF^F_FbFeFnFsFvFwF{F}F~GKGMGOGPGUG]GbGgGhGn"},
  {0,NULL,"GrGwG|H?H@HFHIHLHUHYH[H\\H_HhHiHlHpHqHvHxH{H|ICIDIHIIIMIOIQIVI[I\\I"},
  {0,NULL,"_IaIgIiIkIoIuI{J?JAJD_@?E?O?Y?^?`?d?l?o?p?t?}@?@F@H@P@V@X@Y@`@c@e"},
  {0,NULL,"@f@k@m@o@p@q@t@w@|A@AFAJALATA[AaAfAgAsAuA}B@BCBEBRBVBXBZB\\B]B^BpB"},
  {0,NULL,"rBxB}CACBCDCGCLCQCSCVCWC`CaCeChClCoCrDCDNDPDSDUDXD]D^D`DaDcDdDuDv"},
  {0,NULL,"D{D}EGEQEREUEVE^E_EfEmEnEqEvEyF?FAFLFMFOFSFVFYF`FiFjFkFtF{F|G@GBG"},
  {0,NULL,"FGKGMGPG^G_G`GaGgGhGlGpGvH?H@HDHHHJHPHQHSHUHYH]HcHiHkHrHsHtHzH~I@"},
  {0,NULL,"IDIJIKILIPIRISIWI\\I^IbIhIjIlInIpItIzJ@JBJDJE_@?D?P?X?]?c?d?n?o?q?"},
  {0,NULL,"s?{@B@E@L@S@X@]@`@a@b@f@g@h@i@r@t@v@x@y@~ACAFAHANAQASATAiAlArAsA{"},
  {0,NULL,"A~B@BMBNBPBYBZB^B_BaBiBjBsB|C?C@CDCHCJCKCOCWCZC\\C`CeCgClCrC~DBDFD"},
  {0,NULL,"GDHDLDQDSDbDgDoDsDtDuDwDzEBEFEIETEWEXEYEZEhElEnEtEwE}F@FBFIFJFLFP"},
  {0,NULL,"FYFZF_FbFeFlFyF|F}G@GAGDGLGOGQGSGUG]GaGcGeGjGmGvG}HBHEHJHMHPHSHVH"},
  {0,NULL,"WH]H`HdHmHnHoHuHyHzH|H}IAICIFIGIJITIUIXIYI[IcIdIeIfIhImIvIxIzJ?JJ"},
  {0,NULL,"_@?D?O?Y?[?\\?]?l?s?v?y?|@@@C@H@S@[@\\@^@_@d@e@f@h@j@q@s@t@u@yABADA"},
  {0,NULL,"IAKAPAUAVA`AjAnApAtAyAzA|B?BOBPBVBWB[B]BbBhBkBsB|C@CBCECFCNCOCQCW"},
  {0,NULL,"C[C]C_CgChCjCpC~DEDLDNDPDTDVD\\D^D_DbDcDpDqDxDzECEFEJEPESEVE]E_EfE"},
  {0,NULL,"lEoEsEuE{E|FAFPFRFTFWFXF]FfFgFhFkFsFuFwFyG?GGGLGNGQGSGYGZGbGdGeGj"},
  {0,NULL,"GrGsGzG}HBHIHLHOHVHWH\\H^H_HgHrHsHtHuHvHwI?I@IAIBIMINIPIRISIWIYIZI"},
  {0,NULL,"`IgIjIlInIpItIyI{I~JJ_@?G?L?V?_?a?b?j?r?x?z?{@B@E@I@N@O@R@U@W@a@e"},
  {0,NULL,"@f@h@m@o@s@t@v@x@{ACAIAJAOA\\A]AcAeAiApAuBBBFBGBLBOBUBYBZB]B_BeBfB"},
  {0,NULL,"gBmBnCBCGCICOCPCRCUCYCZC]CaCcChCmCqCuDDDJDNDRD[D\\D]D^D_D`DeDhDmDz"},
  {0,NULL,"D{D|E@EIETEVEWE]E^EcEjEkErEwE}F@FCFHFJFKFQFUF\\F_FbFeFmFqFzF~GDGEG"},
  {0,NULL,"HGOGUGVGWGXG]GfGiGkGoGtGxG{G~HAHCHGHKHRHTHXHZHaHbHkHrHsHtHvHzI?I@"},
  {0,NULL,"IBIJILIMIPIRISIWIZI^IgIhIjIlInIpIqIxI|JAJE_@?E?M?U?\\?`?b?k?p?v?z?"},
  {0,NULL,"{?|?}@L@R@S@W@[@_@a@f@g@i@k@n@p@q@r@xA?AAAHAIAMAPAYA\\AhAmApArAyBD"},
  {0,NULL,"BFBIBQBUBVB\\BbBdBeBfBlByB|CCCECGCICJCLCNCVCWCXC_CcCkCmCsC|DADGDMD"},
  {0,NULL,"PDXDZD[D`DiDjDqDrDuDyDzEAEBEIELEOEQEYE_EdEjEoEqEwE{F?FBFJFPFQFUFW"},
  {0,NULL,"F]FeFgFiFlFuFyFzGDGGGHGNGVGWGXGYGZGcGdGiGjGoGqGyHAHBHGHMHOHTHVHZH"},
  {0,NULL,"`HeHgHiHpHqHsHtHvH~I?IBIDIHIIIKIMIRISIZI\\I_IaIbIgIlInIvI}J?JBJHJI"},
  {0,NULL,"JNJO_@?D?P?X?]?c?d?n?o?q?s?~@C@F@K@M@P@Q@X@Y@]@f@g@h@i@r@t@v@x@y@"},
  {0,NULL,"~ACAFAHANAQASATAiAlArAsA{A~B@BMBQBRBTB[B]B`BeBoBqBrBuC?CACECLCOCP"},
  {0,NULL,"CTC\\CbChCjCkClCmCzC{C}DHDLDMDNDWD[D_DgDhDkDqDuDvDyD|EDEIEKEOEPEVE"},
  {0,NULL,"ZEhElEnEtEvExE|FFFIFLFMFNFVF[FdFhFjFpFtFxG@GAGBGCGIGJGRG^G_G`GfGg"},
  {0,NULL,"GpGtGuGwG|G~H?HHHKHNHQHRHXHYHfHhHiHpHqHrHvH~I?I@IBIDIHIIIKIMIPIWI"},
  {0,NULL,"ZI\\I_IaIbIgIjIpIrI{I|JAJHJIJL_@?E?K?W?Z?\\?^?m?t?v?w?~@C@F@J@Q@T@Z"},
  {0,NULL,"@\\@_@d@e@g@i@m@n@t@v@w@x@{@~AGAKARAUAWAbAeAlAqAtAvAwA|BJBNBRB[B]B"},
  {0,NULL,"_BcBdBkBlByBzB~C?C@CBCCCICSC[C`CaCcCdCgCkCwCyDADGDJDODSDTD]D^DdDe"},
  {0,NULL,"DjDsDtDxDyE@EBEKERETEVEZE[EgEmEoEpEvExE|FEFGFRFTFWF[F^FdFhFjFoFrF"},
  {0,NULL,"uFvFwG?GCGIGJGNGRGYGZGeGiGmGqGsGxGyGzG{G}HAHEHWHZH^HaHdHeHkHmHrHt"},
  {0,NULL,"HuHwHyHzIAIJILINIPISIUIXIYI^I`IcIdIhIjInIsIxIzI|JFJGJN_@?F?K?W?_?"},
  {0,NULL,"`?c?m?p?q?r@?@A@B@J@R@U@X@Y@`@a@e@g@j@l@n@s@u@w@y@zADAHAJALAOASAY"},
  {0,NULL,"AdAjArAuA}A~BGBIBOBRB^BaBbBcBeBjBnBpBvC?CFCLCOCSCTCUCVCWCXCZC[CbC"},
  {0,NULL,"cC{C|D?DFDIDJDPDTDWD_DdDfDpDrDtDwD{E?ECEMERESEXE[E]EgEkEqEtEyEzE}"},
  {0,NULL,"FEFHFJFLFMFUFYF`FaFbFoFqF|G@GBGDGHGKGMGOGPGUG]GgGjGoGrGtGvH?HBHGH"},
  {0,NULL,"IHKHPHRHSHTHVHYH\\HkHnHoHsHuHwHzI@IAIFIGIJILINIRIWIYI^I`IeIfIhIlIp"},
  {0,NULL,"IsIyI{I}JLJMJO_@?D?N?T?[?a?d?i?o?x?y?~@A@D@J@O@T@U@\\@`@c@e@g@i@j@"},
  {0,NULL,"n@q@r@u@vA?AEAGAJAXAZAaAcAmAoAqAuBCBHBKBLBQBSBTBUBWBXBZBhBiBjBkCA"},
  {0,NULL,"CBCDCHCLCMCNCYCZC]C_CdClCmCpCrCuDSDVDWDYDZD[DjDkDmDnDpDuDwDxEBECE"},
  {0,NULL,"KELEMENEOE[EeEnErEsExEzE~FEFGFHFRFSFYF\\FaFcFdFoFqFrF|G?GEGFGLGQGS"},
  {0,NULL,"GTG[G\\GaGdGoGsGvGxGzG{HGHJHOHPHSHTH]H^HaHgHiHjHlHpHqHvHxH}IDIEIHI"},
  {0,NULL,"IIMIQITIVI\\I]I_IaIgIkImIoIsI|I}JBJCJD_@?F?P?X?Z?[?_?n?r?w?y@@@D@E"},
  {0,NULL,"@K@N@O@U@\\@^@d@f@g@k@l@o@p@r@w@y@|@}AGAIARAVAZA]AfAkApAqAvB?BBBKB"},
  {0,NULL,"PBQBZB[B\\B_BaBgBjBsBvCCCFCLCMCPCQCRCVCYC[CaCdCjCkCwCxD?DFDLDMDXDY"},
  {0,NULL,"D]DcDfDhDiDsDuDwDzE?EGEHEOEPEQE\\E^EhEkEpEsEuE~F@FFFHFKFRFTFXF\\F_F"},
  {0,NULL,"cFfFpFqFsFwF~G?GEGLGOGQGSGUG]GeGhGkGrGvGxG{G}H@HCHIHPHSHUHWH\\HaHb"},
  {0,NULL,"HiHlHsHtHvHxH~I?IBIDIKIMIQIRISIVIZI\\IbIgIkIlInIoIrIwIzJ@JKJNJOJT_"},
  {0,NULL,"@?F?L?V?Z?c?e?j?q?u?w?~@A@D@I@M@Q@T@Z@]@b@e@f@j@k@n@o@q@r@sAAAEAF"},
  {0,NULL,"AKAQA^A_AbAhAoAsAtAxA{BABJBNBOBQBTBVBZBcBqBtBwBzC?CCCGCHCKCOCQCWC"},
  {0,NULL,"]C^CaCbCiCkCvD@DBDIDMDPDQD\\D]D_D`DcDiDlDtDvDxEAEEENEOE[E]E^E_EcEi"},
  {0,NULL,"EpEtExEzE~FCFGFIFNFZF[F^FaFcFdFmFrFvFxF}GAGCGIGJGRGTG[G\\GcGmGnGqG"},
  {0,NULL,"uGwGyG|HEHFHMHNH[H`HdHeHfHhHiHrHsHtHuHwH~I@IAIDIKINIPIRISIWIYI\\I`"},
  {0,NULL,"IbIjIlInIpIqIwI}J?JDJJJQJR_@?D?O?Y?[?\\?]?l?s?v?y@?@A@B@I@M@N@R@Z@"},
  {0,NULL,"^@_@e@f@h@j@q@s@t@u@yABADAIAKAPAUAVA`AjAnApAtAyAzA|B?BRBSBXB\\B^Ba"},
  {0,NULL,"BdBmBqBrBxCECICJCKCMCNCTCYC[C\\CdCfCgCkCxCzDADGDNDQDUDVDYDaDbDcDgD"},
  {0,NULL,"jDmDvD{D|EEEJEMENEWEXE]EfElEoEsEyEzE}FCFKFNFUFWFXF^F`FaFbFmFsFuFv"},
  {0,NULL,"FxF~GHGKGMGPG^G_G`GhGiGkGpGqGwGyG|H@HAHCHHHQHUHZHbHeHhHjHlHnHpHyH"},
  {0,NULL,"{H|H}ICIEIFIHIOITIUIVI[I]I_IcIeIiImIoIqIxI}J@JGJHJK_@?E?O?Y?^?`?d"},
  {0,NULL,"?l?o?p?t@@@D@E@I@O@P@T@]@`@a@e@f@k@m@o@p@q@t@w@|A@AFAJALATA[AaAfA"},
  {0,NULL,"gAsAuA}B@BCBEBPBSBWB[B`BaBbBfBkBzB|B~C?CACJCLCTCUCXC`CdCeCfCiCmCy"},
  {0,NULL,"C|C}DHDODPDRDUDVD^DaDbDkDlDrDxDzE@EAEHENEUEWE\\E^EfEmEnEqEuE~F@FCF"},
  {0,NULL,"GFIFJFVFYF\\F_FcFfFmFrFtF|GAGDGEGLGNGQGSGYGZGfGjGmGoGsGuGzG~HBHEHG"},
  {0,NULL,"HNHTHVHXH^HdHfHjHmHoHqHxH{H|H}ICIEIGIIIOIQITIXI[I]IaIdIfIiIkImIqI"},
  {0,NULL,"wIyJAJFJIJMJT_@?F?L?V?Z?c?e?j?q?u?w?{?|?}@H@Q@S@V@X@b@d@e@f@j@k@n"},
  {0,NULL,"@o@q@r@sAAAEAFAKAQA^A_AbAhAoAsAtAxA{BABJBSBUBYB_B`BdBeBgBnBpBsB~C"},
  {0,NULL,"@CCCHCMCSCTCXC\\C^CbCdCjClCtCwC{DKDQDRDVDWD]D_DaDlDmDnDsDzD{ECEGEJ"},
  {0,NULL,"ELENEUEYE_EcEiEpEtEwE{F?FAFLFOFPFTFZF[FeFgFiFkFwFyF{F}G@GCGOGUGVG"},
  {0,NULL,"WGXG]GaGbGeGgGtGxG{G}H?HJHKHLHRHWHYH]H_HaHjHlHmHoHpH{H|H}ICIEIGIH"},
  {0,NULL,"IOITIVIXI[I]I_IdIfIiImIoItI|I~JBJFJHJKJM_@?E?M?U?\\?`?b?k?p?v?z?~@"},
  {0,NULL,"A@D@K@M@R@U@Y@[@^@f@g@i@k@n@p@q@r@xA?AAAHAIAMAPAYA\\AhAmApArAyBDBF"},
  {0,NULL,"BIBNBOBSBWBXBYBcBrBvB{B}C@CDCGCICRCTCUCXC[C^C_CeCgChDCDDDEDGDHDKD"},
  {0,NULL,"RDTDXDaDeDoDqDrDsDvDwEDEGENEOEYEZE[E\\EdEjEoEqExEzE~FFFHFMFNFUFXF]"},
  {0,NULL,"FaFcFdFpFqFsFxGBGGGHGKGMGPGTG[G\\GbGkGlGpGrGtHCHDHHHIHKHLHQHRH\\H_H"},
  {0,NULL,"bHcHjHmHnHoHuHyHzH{IAIEIFIGIJIOIUIXIYI]IcIdIeIfIhIiIrIwI|I~JCJJJS"},
  {0,NULL,"JW_A?B?C?E?F?N?W?m@H@I@K@L@M@N@O@P@Q@R@S@[@\\@`@b@c@f@j@k@l@t@u@v@"},
  {0,NULL,"xA?A@ABACAVA^AgAiAmAnB?BABTB_BhBiBkBlBmBoBxB{B~C@CCCOCPCQCTCUCVCW"},
  {0,NULL,"CZC\\C^CaCdCkCnCoCuCyCzC|C~DADCDEDIDPDXDYDaDnDpDrD~E?ECEEEIEVEWEZE"},
  {0,NULL,"bEcEeEhEjEnEpEqEvEwE~F?FLFQF_FcFdFiFqGAGJGUGbGgGhGiGmGqGrGsGzG}HF"},
  {0,NULL,"HGHHHLHMHPHRHUHVHXHaHcHeHhHkHpHqHrHuHvHxHyHzH|IBIFITIWIZIeImIpIyI"},
  {0,NULL,"}I~J@JDJFJNJW_A?B?C?E?G?P?U?k@G@H@I@J@M@N@P@S@U@W@X@Z@\\@]@`@d@e@i"},
  {0,NULL,"@k@m@r@s@u@y@}ACADAEAaAbAiAjAkAoBCBJB[B^BgBiBjBoBqBsBtBuB~CACBCGC"},
  {0,NULL,"ICNCSCTCWCXC[C_C`CaCfCiCnCpCsCtCuCxC{D@DBDDDHDMDRDZD`DeDsDuEAEBED"},
  {0,NULL,"EGEJEMESE]E`EfEgEhEjEkElEmEvEyE|F@FMFWF_FbFfFjFsGDGNGPGaGbGlGnGoG"},
  {0,NULL,"qGuGxGzG{H?HBHCHIHJHMHQHRHUHZH[HdHfHgHlHnHoHvHwHyH}H~I?I@IAIEIHIR"},
  {0,NULL,"IYI]I_IlIwI|J?JBJEJTJVJYJ[_A?B?C?F?G?O?V?j@G@J@K@L@M@N@P@S@T@V@Y@"},
  {0,NULL,"\\@^@_@`@a@g@j@k@l@q@t@v@x@~A?A@ABAYAZAgAlAmAnBIBKB]BaBfBhBkBmBrBx"},
  {0,NULL,"B|B}C?C@CCCFCHCPCRCUCVCYCZC^CbCcCkClCnCrCsCtCuC}D@DADDDEDIDKDPDVD"},
  {0,NULL,"aDcDiDnEAECEEEGEIEKETEZEaEfEgEhEiEkElEmEuEyE|F@FIFTF`FbFfFjFvG@GO"},
  {0,NULL,"GRGcGdGkGlGnGoGtGxGyG|G~H?HCHDHIHJHSHTHWHZH_HdHfHgHqHrHtHvHyHzH{H"},
  {0,NULL,"|H}I@IAIDIHIXIYI\\I_IdIwI}I~JBJEJPJTJZ_A?B?C?D?G?K?T?i@H@I@K@L@T@U"},
  {0,NULL,"@V@W@X@Y@Z@]@^@_@a@d@f@h@i@j@n@o@p@w@z@{@|AAAPAQAdAeAfAhAyA{BPBRB"},
  {0,NULL,"lBnBpBvBwByBzB{CDCECJCKCLCMCOCQC\\C]CdCeCgChCjCmCnCsCtCuCvCwC|D@DC"},
  {0,NULL,"DDDTDWD[D\\DjDmDoDtEBECEDEEEQEUE\\E^EbEfEgEhEkElEmErEyE|E}F@FKFYFbF"},
  {0,NULL,"fFhFjFtG?GLG`GaGbGcGdGkGqGtGuGyGzG{G|G~HBHDHMHQHRHSHTHUHWH[H_HkHl"},
  {0,NULL,"HoHqHtHwHxHzH{H~IDIEIRIXI\\I]IdIlI|I}I~J?JPJVJYJZ_A?B?C?E?F?N?W?m@"},
  {0,NULL,"H@I@K@L@M@N@O@P@Q@R@S@[@\\@`@b@c@f@i@k@m@s@u@v@y@}ABACAEATA\\AiAkAn"},
  {0,NULL,"AoB@BFBXBbBhBiBjBmBnBoBuBwB~C@CBCECGCLCTCUCVCWCXCaCeCfCgCkCnCqCuC"},
  {0,NULL,"vCwCzC{C~D?DBDMDSDZD]DeDkDlDsD}E@EBEDEJEPEXE]EbEdEeEfEiEpEqEsEuEz"},
  {0,NULL,"E~F?FGFXF`FcFgFiFuF{GKGZGcGfGgGiGmGrGtGvGyG}G~H@HFHGHHHKHSHVH^H_H"},
  {0,NULL,"`HaHcHhHkHlHnHpHuHwHxH}I?I@ICIMIPIUI[IcIgIjIzI|J?JAJCJMJOJQJ]_A?B"},
  {0,NULL,"?C?D?F?M?X?n@G@H@I@J@O@Q@R@T@V@Y@[@^@_@a@b@c@e@h@i@j@o@p@w@x@z@{A"},
  {0,NULL,"@AAAUAcAdAeAgAhA|BLBWB\\BfBgBlBtBvByB{B}C?CACFCJCMCNCOCQCYC[C\\C]C`"},
  {0,NULL,"CdChClCoCqCsCvCwCyC{D?DBDDDGDQDWD[D_DoDqDtD|EBEDEFEHEREUE^E`EdEeE"},
  {0,NULL,"fEiEqEsEtEuEzE{F?FPFVF`FaFcFgFxF|GQG^GeGfGiGnGrGvGwGxH@HEHFHHHIHJ"},
  {0,NULL,"HKHOHVHYHZH^H`HaHbHfHiHkHmHnHoHtHxH{H~I?ICIIIJIPI[IaIhIjIxI{I|J?J"},
  {0,NULL,"CJKJOJRJ[J]_A?B?C?D?G?K?T?i@H@I@K@L@T@U@V@W@X@Y@Z@]@^@_@a@d@f@h@l"},
  {0,NULL,"@m@n@q@r@w@|@~AAADA[A]AfAhAjAlBBBEBUBcBjBkBpBuBvBxByBzCBCCCDCGCJC"},
  {0,NULL,"KCMCPCXCZC]C^CfChCjCmCpCrCvCwCxCzC|C}C~DCDJDLDNDODbDdDfDgD}D~E?E@"},
  {0,NULL,"ENEOEYE_EbEcEdEgElEoErEtExE{E|E}F[F]FaFbFeFhF}GHGTGVGaGdGfGhGkGsG"},
  {0,NULL,"uGvG{G|H@HBHDHKHLHPHQHTHWHXH[H^H`HeHiHjHlHmHpHqHsHuHwHzIGIKIOISIb"},
  {0,NULL,"IfIiInIyIzJ@JAJGJLJUJXJ\\J]J`_A?B?C?D?E?L?Y?l@G@J@K@L@O@Q@R@U@W@X@"},
  {0,NULL,"Z@[@]@b@c@d@g@i@k@m@o@s@u@y@z@}ACAEAMARAdAiAkAoAvBDBOBdBgBhBmBnBq"},
  {0,NULL,"BsBtBwC@CACECICLCNCSCUCVC[C_C`CeCgCiCkCpCqCrCtCxCzC}C~D?D@DHDRDSD"},
  {0,NULL,"]D`DkDlDuD}E@EAEGEMEPESEXEaEcEdEgEnEoErEtEwExE{E}FJFOFaFdFeFhFrGB"},
  {0,NULL,"GMGYGdGeGhGjGkGpGsGwG|HAHDHEHLHNHOHPHTHWHXHYH\\H]HbHeHjHlHnHrHsHwH"},
  {0,NULL,"|H}I?I@IGIKILIQI^IbIfIkIwIzJAJBJGJHJJJUJ[J^J`_A?B?C?D?E?L?Y?l@G@J"},
  {0,NULL,"@K@L@O@Q@R@U@W@X@Z@[@]@b@c@d@g@h@i@j@o@p@s@w@z@{@}AAASAXAdAeAhAkA"},
  {0,NULL,"~BHBZB`BfBgBnBpBtBwBzB}C?CACDCECFCKCLCNCYC[C`CeCgCjClCmCoCqCtCyC|"},
  {0,NULL,"D?D@DADCDEDGDQDTD\\D_DjDmDqD|ECEEEFEHEQERE\\EaEcEeEhEjEnEoEpEvEwExE"},
  {0,NULL,"~FNFRF_FdFeFiFyF~GSG_GgGhGjGlGmGoGpGsG}H?HAHCHGHLHNHPHXH\\H]HcHdHe"},
  {0,NULL,"HgHhHjHkHoHrHsHtHxH{H|H~IBIFINIVIZI`IeIoIxI{I}I~JDJFJIJSJ\\J_Ja_A?"},
  {0,NULL,"B?C?F?G?O?V?j@G@J@K@L@M@N@P@S@T@V@Y@\\@^@_@`@a@g@h@l@m@n@q@r@t@|@~"},
  {0,NULL,"A?ADANAWAfAjAlAmAwBMBSBVBkBpBqBrBsBxBzB|CCCDCHCICKCPCRCSCZC^C_CbC"},
  {0,NULL,"cCiCjCmCqCrCvCwC{C}D?DADBDEDFDJDNDUD^DbDfDhD|D}E@EFELEOEYE[EaEdEe"},
  {0,NULL,"EfEiEkEqEsEuEyEzF?FSFUF`FcFfFgGEGGGWG\\GcGeGgGmGnGtGwGxGyG}G~HEHGH"},
  {0,NULL,"IHJHOHSHYHZH_HbHcHfHhHiHjHmHpHsHtHuH{H}I@IIIJIMIUIaIcIgIhIxIzI{JA"},
  {0,NULL,"JKJMJQJRJ[J\\J^_A?B?C?D?F?M?X?n@G@H@I@J@O@Q@R@T@V@Y@[@^@_@a@b@c@e@"},
  {0,NULL,"j@k@l@p@t@v@x@{A?A@ABALA_AeAgAmAnAxA}BNBeBfBiBlBoBrB{B|B}B~C?CFCH"},
  {0,NULL,"COCQCRCTCWCYC\\CaCbCcCdClCoCpCrCsCxCyCzC}C~DDDKDVDXDYDcDiDpDrD~E?E"},
  {0,NULL,"AEGEKETEVEWE`EcEdEgEoErEsEtExEzE{E}FHF^FaFeFgFhFwFzGIG]GaGeGfGjGp"},
  {0,NULL,"GuGvGwG{H@HAHBHEHKHNHOHQHYH[H\\H]H^H`HbHiHmHnHqHrHvHyHzH|I?ILIOIQI"},
  {0,NULL,"SI^IiIkInIwIyJ@JBJHJJJLJXJ^J_JcJd_A?B?C?E?G?P?U?k@G@H@I@J@M@N@P@S"},
  {0,NULL,"@U@W@X@Z@\\@]@`@d@e@h@l@m@n@q@r@y@|@~ADAEAOA`AfAjAlAoAzBGBQBYBjBqB"},
  {0,NULL,"rBsBuBvByB|CBCGCHCICJCMCRCSCXC]C_CbCcCfChCiCoCpCxCyC{C|DADBDCDEDF"},
  {0,NULL,"DLDODUD^DdDgDhD|D~E?EFELENE[E_E`EcEeEhEjEmEnEpEvEwE~F@FZF\\F_FdFiF"},
  {0,NULL,"jGCGFGXG[GbGiGjGlGoGpGqGrGzH?HAHCHFHHHMHNHRHUHVH\\H]HaHdHgHiHjHmHo"},
  {0,NULL,"HpHsHuHvHyH~INITIVIWI`ImIoIpIxIyI{J@JIJNJSJWJ]J^J_Jb_A?B?I?J?L?O?"},
  {0,NULL,"Q?h?|?}@A@B@C@D@E@F@P@Q@U@W@^@_@`@b@e@f@i@l@r@u@w@xAGAHAVA[AbAcAq"},
  {0,NULL,"ArB?BEBJBLBOBSBVBZB]B`BaBdBiBjBlBnBoBrBuBvBwByB{B|CnCoCpCuCvCwCxC"},
  {0,NULL,"yDGDHDIDJDUDVD\\D]D^DcDfDlDmDnDqDuEHEIEMEOERESEYEZE`EbEcEfEjElEqEt"},
  {0,NULL,"FAFCFLFMFPF]FkFmFxGAGDGHGMGOGRGSGWGYG\\G_GaGbGcGfGiGjGpGqGrGtGuGvH"},
  {0,NULL,"iHkHlHmHvHwHxHyIBIHIIIKILINIUIXIYI\\IeIfIgIhIkIoJDJEJFJGJKJRJTJUJ["},
  {0,NULL,"J\\J`Ja_A?B?H?J?M?P?R?f?{?}?~@?@@@B@C@D@N@R@T@V@X@[@\\@]@f@g@j@m@q@"},
  {0,NULL,"s@v@wAJAKATAXAYA]AtAuB@BBBHBIBNBQBWBYB[B\\B^BeBhBkBlBmBnBpBqBsBwBx"},
  {0,NULL,"BzB{CnCqCrCuC|C}D?DCDFDHDODQDVDXDZD[D_DcDdDeDhDoDrDuEHEJEKENERETE"},
  {0,NULL,"]E_EaEbEdEhEiElEoEpFBFFFNFTFXF[FlFpFuFvFyF}GIGNGPGQGXG[G]G^GbGcGd"},
  {0,NULL,"GeGgGhGkGmGqGsGtGwHjHkHqHsHxHzH}I@IAIEIIINIPIQISITI[I^I_IhIiIlIoI"},
  {0,NULL,"pJCJEJIJLJOJSJTJXJ]J_JaJc_A?B?I?J?L?O?Q?h?|?}@A@B@C@D@E@F@P@Q@U@W"},
  {0,NULL,"@^@_@`@b@e@f@i@l@n@p@v@yAGAHALAQA\\A`AqArAzA{A}BFBOBSBVBZB]B`BaBdB"},
  {0,NULL,"gBiBjBkBlBoBtBuBvBxByB{CsCzC{C|C~DBDCDDDFDKDNDPDQDRDSDTD_D`DaDbDh"},
  {0,NULL,"DiDjDkEKELEPEQETEXE[E\\E`EbEcEfEmEpErEsFAFCFGFKF\\F^FkFmFwF{G?GFGMG"},
  {0,NULL,"OGRGSGWGYG\\G_GaGbGfGhGiGnGqGrGsGuGvGxHnHoHpHqHuHzH~I?IAIDIFIGIJIM"},
  {0,NULL,"IQIVIZI^I_I`IaIbIcIdJHJIJJJMJPJQJSJZJ^J_JeJf_A?B?H?I?K?N?S?g?{?|?"},
  {0,NULL,"~@?@@@A@E@F@M@O@S@Y@Z@a@c@d@e@g@h@k@o@q@x@yAFAIAMAOAUAZApAsA|BDBG"},
  {0,NULL,"BKBPBRBTBUBXB_BbBcBfBgBiBoBpBqBrBsBtBzB|B}CpCqCsCxD?DADDDEDJDLDPD"},
  {0,NULL,"TDYDZD[D]DaDeDfDgDjDlDoDpEIENEPEUEXEZE^E_E`EaEeEgEiEmEnEtFDFEFIFO"},
  {0,NULL,"FVFZFnFoFrF|G@GCGJGKGLGTGUGVGZG`GaGeGgGjGlGmGnGoGpGuGwGxHjHnHsHtH"},
  {0,NULL,"vHyH{I?IBICIGIMIRISITIXI\\I]IbIcIeIiIjIpJCJGJNJOJPJUJWJZJ]J`JbJf_A"},
  {0,NULL,"?B?H?I?K?N?S?g?{?|?~@?@@@A@E@F@M@O@S@Y@Z@a@c@d@e@g@h@k@p@r@s@tAFA"},
  {0,NULL,"IASAWA_AaApAsAwAxA~BCBPBRBTBUBXB_BbBcBfBgBhBmBqBrBsBtBvByB|B}CoCr"},
  {0,NULL,"CtCyC{C}D@DBDIDMDNDODSDWDXD\\DbDdDkDmDnDrDsDtEJEOEQEVEWEYE\\E]E`EaE"},
  {0,NULL,"eEgEjEkEoEsFDFEFHFRFUFWFnFoFsFzF~GGGJGKGLGTGUGVGZG`GdGeGiGjGkGlGn"},
  {0,NULL,"GoGpGrGwGxHiHmHoHrH|H}H~I@IDIEIFIKIOIPIUIWIZI[IdIfIgIlImInJDJFJLJ"},
  {0,NULL,"MJQJVJXJYJ\\JcJdJe_A?B?H?J?M?P?R?f?{?}?~@?@@@B@C@D@N@R@T@V@X@[@\\@]"},
  {0,NULL,"@f@g@j@m@n@o@t@uAJAKANAPARA^AtAuAvAyBABMBNBQBWBYB[B\\B^BeBfBhBjBkB"},
  {0,NULL,"mBnBpBuBwBxBzB}CtCvCwCzC~D@DADEDGDKDLDMDRDUDWDYD^D`DgDiDpDqDsDtEL"},
  {0,NULL,"EMESEUEVEWE[E^EaEbEdEhEkEnEqErFBFFFJFQFSFYFlFpFqFtGBGEGIGNGPGQGXG"},
  {0,NULL,"[G]G^GcGdGfGgGhGkGlGmGoGsGtGvHlHpHrHtHuHwH{H|ICIHIJILIOIRIVIWIYI]"},
  {0,NULL,"I`IaIjIkImInJHJJJKJNJRJVJWJYJ[J^JbJd_A?B?F?H?M?N?e?u?{?~@B@C@E@F@"},
  {0,NULL,"H@I@N@O@R@Y@[@\\@a@c@f@i@m@q@s@v@w@yACAJATAUA\\A]AiAuA|B@BBBFBNBQBY"},
  {0,NULL,"BZB]B`BaBeBhBmBnBwB~CBCDCGCJCRCUCVCXCaCcCfChCmCnCqCuD?DFDNDQDZD[D"},
  {0,NULL,"\\D]D_DbDeDhDlDmDoDvDzD}E@EJEKETE]E`EcEgEjEkEoErEsE{FDFHFQFWF^FaFo"},
  {0,NULL,"FqFsFwFzGKGLGSGWGZG\\G_G`GeGjGpGwGyG{H?H@HBHEHMHQHRHYH[H^H_HdHiHmH"},
  {0,NULL,"rH|IAIDIFILINIOIWIZI_IdIkImInIoIrIvIwJBJLJMJQJXJ[J\\J`JaJbJiJjJl_A"},
  {0,NULL,"?B?E?I?L?N?b?z?|@?@@@A@B@C@K@L@O@P@Q@Z@`@b@c@d@f@j@l@r@t@u@w@xABA"},
  {0,NULL,"GASAVA[A^AnAqA~B?BABEBOBSBVBWB[B\\B^BdBiBlBoB{B~CCCKCMCPCSCUCVCZC]"},
  {0,NULL,"C^CaCiCjCnCoCuCyDGDIDLDUDXD[D\\D^DgDmDnDoDqDrDvDzD~E?EIEMESEZEaEdE"},
  {0,NULL,"gEiEmEnErEtExFEFGFIFJFOFeFnFrF{G@GBGJGLGQGUGXG[G^G`GeGjGpGwGyG|HA"},
  {0,NULL,"HDHIHMHPHRHTHWHXHZH\\H_HjHnHsI?ICIGIHIIIMIQIRIYI]I^IbIcIhIjIqItIwJ"},
  {0,NULL,"BJGJNJUJWJ]J_JaJcJeJiJkJl_A?B?G?J?O?P?]?s?{?|?}?~@A@D@G@J@N@P@T@U"},
  {0,NULL,"@V@W@\\@`@g@j@k@q@s@v@w@xA?AJAXAYAZAbAmAuBHBIBJBKBQBUBWBXBYB\\BbBcB"},
  {0,NULL,"hBkBmBxC?CFCHCLCMCNCPCYCZC[C]CbCeClCnCrCuC}DHDIDSDTDVDZD[DcDeDjDk"},
  {0,NULL,"DnDoDuDwDyECEEEKENETE_E`EcEeEmEnEpErEsEvFAFSFZF\\F^F_FmFwGCGEGFGKG"},
  {0,NULL,"LGMGOGRGYGZG`GbGiGqGrG|H?HAHKHMHNHOHRHWH\\H]H`HbHdHoHpHuH~IGIJIMIP"},
  {0,NULL,"ISIVIWI[I`IaIbIcIiImIrIvIyJ@JIJPJSJZJ[J\\JcJdJeJgJjJlJm_A?B?G?J?O?"},
  {0,NULL,"P?]?s?{?|?}?~@A@D@G@J@N@P@T@U@V@W@\\@`@e@i@k@r@s@u@w@xAEAGAYAaAbAc"},
  {0,NULL,"AoAqBCBIBJBLBSBTBUBVBZB_B`BcBiBjBoBuC?CACBCDCICNCQC[C_C`CdCfClCmC"},
  {0,NULL,"nCpCuCxDHDIDVDWDYDZD\\DcDeDmDnDpDtDuDxD{EBEDEMEOESEYEaEdEeEkEnEqEr"},
  {0,NULL,"EsEuFFFJFSFUF\\F`FlGBGEGFGGGIGJGLGNGPGUG]G`GcGgGmGtGyHBHEHIHLHNHOH"},
  {0,NULL,"QHYHZH]H_HbHeHpHtHuH{IBIJIKIMIOIVIWI`IaIcIeIfImInIqItIzJAJKJRJVJY"},
  {0,NULL,"J]J_J`JbJfJhJiJkJn_A?B?D?J?L?M?a?x?}@?@@@D@E@F@G@J@Q@R@X@[@]@^@_@"},
  {0,NULL,"b@g@k@m@n@o@t@u@y@}AKALAMANARAkAtAvA}BDBMBPBQBRBTBWBYB\\B_BhBmBnBw"},
  {0,NULL,"CACCCECICJCRCSC^C_C`CcCgChCiCtCzC~D@DIDJDKDLDRDSDYD`DfDgDiDkDnDpD"},
  {0,NULL,"wDyD}E@EMESEUE^E`EeEfEiEjElEqEtEzFCFMFNFPFVFgFkFxFyF|GDGJGMGOGRGT"},
  {0,NULL,"GUGVGYGfGiGrGvGzH@HCHDHEHIHJHTHUHYHZH^HfHgHiHkHmHxIBIIINIPIRIWIXI"},
  {0,NULL,"[I\\I]IeIhImIoIrIvI|J?JGJKJRJUJ\\J_JcJdJeJhJiJj_A?B?D?J?L?M?a?x?}@?"},
  {0,NULL,"@@@D@E@F@G@J@Q@R@X@[@]@^@_@b@e@k@l@n@p@t@v@yA@AHALARA_A`AgArAvAxA"},
  {0,NULL,"zA}BPBRBSBVBXBZB`BbBiBlBoB{CFCGCHCKCOCRCSCXCYC\\CbCcCiCjCsCzC~DDDK"},
  {0,NULL,"DNDODRDSDYDZD`DbDdDeDiDkDpDxD{D~E?EKEQETE\\EaEeEhEiEjElEoEpEwFBFNF"},
  {0,NULL,"PFRFTFdFpFvFxFyF~GIGKGNGPGTGVGZG]GgGhGmGsG{G~H?HAHCHJHPHSHXH[H\\Hd"},
  {0,NULL,"HfHgHjHkHsHxIBIDIEIIIMINIPI[IcIdIeIhIlIoIqItI}I~JIJLJSJXJ[J]J`JbJ"},
  {0,NULL,"fJgJkJl_A?B?F?H?M?N?e?u?{?~@B@C@E@F@H@I@N@O@R@Y@[@\\@a@c@e@h@i@o@q"},
  {0,NULL,"@w@x@y@{AIAOATAUAcAeApA|B@BGBLBOBTBUB]B_BaBcBdBfBgBtB}CBCFCICJCMC"},
  {0,NULL,"OCPCYCZC\\C]C_CfChCqCsD?DDDJDQDRDUDZD[D]D^D_D`DeDfDlDoDxD{D|EFEIEU"},
  {0,NULL,"EZE^EbEcEhEjEkEnEqErE~FFFHFLFQFYFiFlFqFtFzGAGMGNGPGQGWGYG\\G^GgGhG"},
  {0,NULL,"mGsGzG{G|G}HHHJHMHRHUHVHWH[HfHhHpHrHuH|IFIGIHILIOIWIXIYIZI\\IbIkIm"},
  {0,NULL,"InIsIuI}I~JKJNJRJWJ^J_JcJeJfJgJhJkJp_A?B?E?I?L?N?b?z?|@?@@@A@B@C@"},
  {0,NULL,"K@L@O@P@Q@Z@`@b@c@d@g@h@j@p@r@s@t@w@zAFASAVAWAXAdAsAwA~B?BHBNBUBX"},
  {0,NULL,"B[B^BbBcBeBfBgBtB}CACBCDCECHCKCPCZC`CbCfCgCjCmCoCtCyD@DFDGDIDKDOD"},
  {0,NULL,"XD\\DdDhDiDmDnDqDrDwDyD|EFEJEQE\\E]EbEdEfEiEmEpErEsF?FAFGFKFOFXFcFm"},
  {0,NULL,"FrFuF{G?GIGOGRGSGXG[G]G_GfGiGrGvGyG}G~HBHCHDHHHQHSHTHVH_HgHhHnHpH"},
  {0,NULL,"uI?IAICIEIGIMIOIQI^I_IbIcIjIlInIsIuI|J?JIJMJQJSJ[J^J`JbJdJgJhJjJo"},
  {0,NULL,"_A?B?D?H?K?M?\\?v?}@?@@@D@E@F@H@I@O@T@V@X@Y@]@a@c@e@k@l@p@r@s@t@vA"},
  {0,NULL,"@AFALA]A_AaAgAsAxA}BBBCBPBRBSBVBXBZB`BbBfBrB|B}B~C?CGCLCQCSCTCWCX"},
  {0,NULL,"CaCdCeCiClCoCrCyC}DNDODRDSDUDVDXD^D`DbDcDdDkDrDxD{EAEGEQEVEWE\\EbE"},
  {0,NULL,"fEhEkEmEnEqErE|FFFKFQFVFYFbFlFqFtF|G?GIGMGWGXGYG[G\\G]GcGdGkGtGzG{"},
  {0,NULL,"G|G}HAHHHMHRHUHVHWH[H\\HhHlHtHwH{ICIFIJIRIUIVIXIZI\\I]I`IaIgIjIsIuI"},
  {0,NULL,"}I~JHJJJVJYJ[J\\J]J`JaJhJiJjJmJpJqJt_A?B?E?H?N?P?d?o?|@?@@@A@B@C@H"},
  {0,NULL,"@I@M@N@R@S@Z@[@\\@d@e@h@l@n@o@q@x@yADAIAOAUA^A`AjApAzA|BABGBOBPBRB"},
  {0,NULL,"XB]BaBbBdBqBrBsB|CBCECFCICJCMCOCYC\\C]C_CfCgChCpCxDADEDLDPDQDTDUDV"},
  {0,NULL,"DYD^D_DaDcDgDjDpDxD{D|EFENEPEXE_EbEdEfEiElEoEpEsF?FBFGFWFXF[FcFpF"},
  {0,NULL,"sFuF{F}GIGOGRGSGXG[G]G_GcGgGmGtH@HBHDHFHGHKHNHQHTH]H^H`HaHcHkHxH}"},
  {0,NULL,"I@IAIEIGIPIQIUIXI[I\\I^I_IbIgIlIsIuIzJAJCJIJOJSJ[J\\J`JaJdJiJkJlJmJ"},
  {0,NULL,"nJr_A?B?G?H?K?P?_?r?{?|?}?~@A@D@H@I@M@S@T@V@X@Z@]@d@f@i@j@n@o@p@t"},
  {0,NULL,"@uAAAKAPAQA^AaAhAtAyA{BABCBNBOBQBSBVBYBdBeBnBpBwBzC@CHCKCMCOCQCTC"},
  {0,NULL,"WC\\C]CbCdCjCkCtCvCwD@DKDMDPDRDWD\\D]D`DaDiDlDmDsDtDvDzECEEELEUE[E^"},
  {0,NULL,"E`EcEeEiEmEnEpEtEvFEFVFZF[F\\F_FnF|F}GCGFGKGLGMGOGRGYGZG`GjGlGoGpG"},
  {0,NULL,"zG~HCHFHHHKHOHSHUHVH`HaHbHgHjHsHvHyIGIJILIMINISITIaIbIcIiIkIoIpIr"},
  {0,NULL,"IvIxI{JNJPJWJZJ[J\\J`JaJcJhJiJkJnJpJqJuJv_A?B?D?I?K?L?c?q?}@?@@@D@"},
  {0,NULL,"E@F@K@L@O@U@W@Z@^@_@c@d@f@l@m@q@r@u@w@x@|AGAMAVA[A]AfAqB?BBBDBEBW"},
  {0,NULL,"BZB[B\\B]B^B`BaBjBuBvByB~CCCFCKCMCPCUCVCYCZC]C^CaCjCpCvCwCxDHDJDLD"},
  {0,NULL,"MDVDXD]DcDfDgDlDrDsDuDvDzD~E?EHEOEREYEaEeEhEjEkEoEpEsEwFDFKFNFRFU"},
  {0,NULL,"FdFoFyF~G?GGGIGKGNGPGTGVGZG]GjGlGoGpG}G~HGHJHKHLHNHSH]H`HcHeHfHhH"},
  {0,NULL,"oHrH|H~IDIEIFIHIIIPIVIYIZI[I`IdIhIlIqItIxI{JDJFJLJXJ[J^JbJdJfJhJi"},
  {0,NULL,"JjJmJpJqJtJu_A?B?D?I?K?L?c?q?}@?@@@D@E@F@K@L@O@U@W@Z@^@_@c@d@g@k@"},
  {0,NULL,"m@o@q@u@x@y@}AIAMARAZA[AkApAvBDBEBKBPBQBRBTBWBYB\\B_BgBqBsBtC@CCCL"},
  {0,NULL,"CNCQCRCUCVC[C^CcCdCeCkCpCqCxD?DFDHDJDKDLDYD]DfDgDhDiDlDpDuDwDyEAE"},
  {0,NULL,"GEPEUEXE^EbEfEhEkEmEpErEsE|FAFGFKFRFYFbFmFtF{F~G?GIGMGWGXGYG[G\\G]"},
  {0,NULL,"GaGbGqGuGyG}G~HBHDHEHHHQHSHTHVHYH_HhHoHqHzH~ICIDIEIFIJITIVIZI`IaI"},
  {0,NULL,"dIjIlIpIsIuI|J?JHJJJPJZJ\\J]J_JaJcJgJkJlJnJoJrJsJv_A?B?F?I?N?O?[?y"},
  {0,NULL,"?{?~@B@C@E@F@K@L@M@P@Q@S@Y@`@a@b@f@i@m@n@p@s@v@yACAHAQATAWA\\AiArA"},
  {0,NULL,"wA{B@BFBNBQBYBZB]B`BaBeBiBjBoBuC?C@CDCECJCLCTCWCeCgChCkClCmCzC{C~"},
  {0,NULL,"DBDFDLDMDNDQDSD[D_DbDgDhDkDoDsDvDzEBEDEKEPETEXEaEgEhEiElEmEnEtEyF"},
  {0,NULL,"EFIFLFOFTFfFnFrFvG@GAGKGQGTGVGXGZG[G^GlGnGoGxGyG|H@HAHDHIHPHTHWHX"},
  {0,NULL,"HZH\\H^H_HtHvHyH{IBIHIQISITIVIXIYI\\I^I`IeIiIpIqItIwJBJCJOJPJZJ[J\\J"},
  {0,NULL,"^JbJdJgJhJkJrJsJtJw_A?B?F?I?N?O?[?y?{?~@B@C@E@F@K@L@M@P@Q@S@Y@`@a"},
  {0,NULL,"@b@g@h@m@n@p@r@s@t@~AFANASAWA\\AlAsAwA~BFBMBNBPBRBTB[B^B_BeBqBrBsB"},
  {0,NULL,"|CACDCECHCKCOCPCZC\\C`CbCgCjCmCrC{C}DBDFDGDHDMDNDSDWDbDhDkDqDsDtDu"},
  {0,NULL,"DwDyD|EFEOEVEWEYEbEcEhEjElEnEqEtE~FCFIFLFQF]FiFkFqG@GAGHGMGNGPGQG"},
  {0,NULL,"WGYG\\G^GbGiGqGrG{G|HFHGHLHOHPHWHXH[HaHbHcHeHkHvHxHyIBIEIHILIOITIX"},
  {0,NULL,"IYI\\IeIkIlInIpIsIuIyJ@JDJFJKJRJ]J_JaJcJfJiJjJlJmJnJqJu_A?B?E?H?N?"},
  {0,NULL,"P?d?o?|@?@@@A@B@C@H@I@M@N@R@S@Z@[@\\@d@f@j@l@n@o@t@u@xABAKAOAPAVA^"},
  {0,NULL,"AnAtAyB?BABGBOBSBVBWB[B\\B^BdBhBkBmBxC@CKCMCNCOCQCTCWC[C\\C]CdCjCkC"},
  {0,NULL,"zC~DADEDGDLDNDPDUDYD\\D^DaDbDgDmDpDqDvDzECEEEMESEVEWE`EfEgEjEkElEo"},
  {0,NULL,"EsF@FDFHFMFWFXFjFoFsFuFzGDGJGSGTGUGVGWG\\G_GlGnGoGxG{H?H@HBHEHMHPH"},
  {0,NULL,"QHRHXHYH[H^HdHoH}H~I@IAIEIJIKILIPIUI[I_IaIfIgIkIlIrIvIwJBJDJFJVJY"},
  {0,NULL,"J]J^J_JeJfJgJhJjJqJsJtJx_A?B?D?H?K?M?\\?v?}@?@@@D@E@F@H@I@O@T@V@X@"},
  {0,NULL,"Y@]@a@c@f@l@m@q@r@s@v@w@|AJATA[A]A_AfAuAxB@BBBEBWBZB[B\\B]B^B`BaBk"},
  {0,NULL,"BpBxBzB~CACBCDCGCJCUCVCXC`CaCfChCmCrC|C}DCDHDNDODPDVDXD]DaDbDcDdD"},
  {0,NULL,"lDrDuDvDzD}E@EHENERE_E`EeEfEiEmEnEqEtEzFEFPFVFYFZFgFnFtFxF|GCGJGM"},
  {0,NULL,"GOGRGTGUGVGYGeGnGwGxGzHCHFHHHKHLHOHUHVH`HaHbHeHgHnHtH{I?IAIBICIJI"},
  {0,NULL,"NIRIXI\\I]I_IaIeIjIoIrIvIxI{JCJGJOJUJ^J_JdJeJfJgJkJlJnJoJrJsJyJz_A"},
  {0,NULL,"?B?G?H?K?P?_?r?{?|?}?~@A@D@H@I@M@S@T@V@X@Z@]@d@e@i@k@p@r@s@t@uAEA"},
  {0,NULL,"FAPA_AaAbAoAsAxAyBCBJBSBTBUBVBZB_B`BcBgBqBsBtB~C?CCCGCQCSCTCWCXC^"},
  {0,NULL,"CaCdCiClCtC{D@DBDIDMDQDRDVDWD\\D_D`DcDmDnDsDtDxD{EAEGEJEOEYE]EbEcE"},
  {0,NULL,"dEiElEoEpEtE}FBFXFZF[F]FhFpFuF}GCGHGNGOGPGQGRGSG^G_GdGhGkGsH@HBHD"},
  {0,NULL,"HFHGHIHKHQHTHZH^H`HaHcHjHqHsHzIFIGIIINISITIUIZIbIgIhIiIoIpIsIuIzJ"},
  {0,NULL,"AJEJLJTJXJ^J_JbJeJfJgJjJlJoJrJtJ{J|J}_A?B?E?J?L?P?Z?w?|@?@@@A@B@C"},
  {0,NULL,"@G@J@P@R@U@W@X@[@]@`@e@h@l@n@p@q@v@yADAHALAOAXA`AjArAzA}BGBHBOBPB"},
  {0,NULL,"RBXB]BaBbBdBjBuBvByCFCGCHCOCRCSCUCVCXCYC\\CbCcCiC{C|DBDCDFDODPDQDT"},
  {0,NULL,"DWDYD_DaDdDhDjDpDtDxD{D~E?ELEPEXE[EaEdEgEkEnEqErEtExFFFJFMFOFSFeF"},
  {0,NULL,"lFrGBGDGEGJGLGQGUGXG[G^G`GdGhGkGsGyHEHFHIHLHNHOHYHZH]H_HaHbHeHlHr"},
  {0,NULL,"HwH|ICIDIHIKILIMIRIYI]IcIdIfIjIkIqItIzJAJHJJJNJWJ\\JaJcJdJeJgJhJjJ"},
  {0,NULL,"oJqJsJtJuJzJ|_A?B?E?J?L?P?Z?w?|@?@@@A@B@C@G@J@P@R@U@W@X@[@]@`@g@h"},
  {0,NULL,"@j@p@q@s@v@w@zAJASAXAYA`AdAuAzA~BHBIBNBUBXB[B^BbBcBeBnBpBwBzC?CFC"},
  {0,NULL,"HCLCNCPCTCWCYCZC[CbCeClCqC|D?DCDFDIDJDODQDTDXD_DdDfDhDjDnDrDwDyEC"},
  {0,NULL,"EEEHEJERE]E`EfEgEjEkElEqEtF@FCFJFMFPFWFjFkFsFxGBGDGJGSGTGUGVGWG\\G"},
  {0,NULL,"_GaGbGqGuGzG}H@HCHEHIHJHUHYHZH^HfHgHhHlHvHwHyIHIKILIPIRISIUIYI[I]"},
  {0,NULL,"IfIgIiIkIrIvI|J?JDJEJFJTJ]J^J`JbJfJiJkJlJmJnJpJrJvJ{J}_A?B?G?I?K?"},
  {0,NULL,"O?^?t?{?|?}?~@A@D@K@L@M@S@U@W@Y@^@_@a@f@i@j@n@o@p@v@yAAAHAPAQAZA\\"},
  {0,NULL,"AhArAyA{BFBKBNBOBQBSBVBYBdBeBlBvByB{C@CDCECICJCLCTCWC_CeCgChCkCmC"},
  {0,NULL,"sC|DCDDDKDMDPDRDTDXD[D`DaDiDjDoDrDsDvDzEBEDELEQE[E\\EaEdEeEjEkEoEq"},
  {0,NULL,"EsEuFDFRFSFUF]F`FoF~GEGGGHGIGJGLGNGPGUG]G`GeGnGwGxGzG}G~HGHJHLHNH"},
  {0,NULL,"SHUH]HcHeHfHhHiHmH}I@IIIKIOIQIUIVIWI^I`IfIgIhImInIqItIxI{JMJQJVJY"},
  {0,NULL,"J]J_J`JaJcJgJjJlJmJoJrJyJ{J|J~K?_A?B?F?J?M?O?`?p?{?~@B@C@E@F@G@J@"},
  {0,NULL,"N@Q@T@V@\\@^@_@b@e@h@i@o@r@u@w@x@{AGANAUAbAcAeAqA|BJBLBMBOBTBUB]B_"},
  {0,NULL,"BaBcBdBlBvByB{C?C@CACBCICNCQC[C_C`CdCfCkClCoCvCwCyDGDJDODUDWDZD]D"},
  {0,NULL,"^DdDeDfDlDqDtDxD{EBEDEHEIEREZEaEgEhEiElEmEoEpEyFBFIFNFTF^FfFpFvFw"},
  {0,NULL,"FyG@GKGQGTGVGXGZG[G^GcGdGkGtG~H?HAHCHHHJHPHSHVHXH\\HdHfHgHqHzH}I@I"},
  {0,NULL,"AIBIDIKIQISITI^I_IdIeIfIiIpIqItI}I~JCJEJOJTJ\\J^JcJdJeJiJjJlJmJnJo"},
  {0,NULL,"JqJvJxJ{J~_A?B?F?J?M?O?`?p?{?~@B@C@E@F@G@J@N@Q@T@V@\\@^@_@b@g@h@m@"},
  {0,NULL,"n@o@r@t@u@~AKANARAWAcAlAtAvAwBLBMBNBPBRBTB[B^B_BeBkBpBxBzB~CACCCE"},
  {0,NULL,"CICRCSC^C_C`CaCcCgCiCvCwDADEDGDJDMDSDTDUDWD^DfDjDkDqDsDtDwDyD}E@E"},
  {0,NULL,"LEVEWE[E`EcEgEmEoEpErEsE{FAFHFTF\\F^FaFmFvFwFzGFGKGLGSGWGZG\\G_G`Ga"},
  {0,NULL,"GfGuGvH?HAHGHKHMHNHOHRH\\H]H`HbHcHdHnHqHzI?IAIDIFIQIRISIWIZI]I^I_I"},
  {0,NULL,"dIiImIrIvIyJ@JHJJJMJQJ]J`JaJbJfJgJhJkJpJrJsJtJwJyJzJ|_A?B?G?I?K?O"},
  {0,NULL,"?^?t?{?|?}?~@A@D@K@L@M@S@U@W@Y@^@_@a@g@j@k@o@q@v@x@yA?AIAMAQAYAZA"},
  {0,NULL,"mApA{BDBIBKBQBUBWBXBYB\\BbBcBfBrB|B}C@CCCGCLCNCRCUCVCXC[C^CcCeCkCs"},
  {0,NULL,"DADDDEDGDHDKDPDTDZD[DaDeDiDjDoDqDuDwDyEAEGEIENEZE_EbEcEdEjElEoEqE"},
  {0,NULL,"tE}FCFLFUF[F]FhFkF}GAGGGHGNGOGPGQGRGSG^G_GaGfGuGvG{G|H?HFHGHLHPHW"},
  {0,NULL,"HXH[HaHcHdHeHiHlHmHwICIIIKINIOITIUIfIgIhIjInIoIpIsIuIyJ@JEJGJTJUJ"},
  {0,NULL,"[J^JbJdJeJhJiJkJpJqJsJvJwJxJzK@_A?C?E?R?W?Y?^?q?r?s?u?x?y@E@K@L@M"},
  {0,NULL,"@Q@R@W@X@[@\\@c@f@j@l@vA?A@AAACADAHAVAXA]A^AnApAsAvAwA|BCBDBJBLBMB"},
  {0,NULL,"TBZB_BcBhBkBoBpBqBxByB~COCQCTCWCZC^C_ChCkCmCnCoCuCyDFDODPDQDTDWDY"},
  {0,NULL,"D`DaDnDuDyD~E?EHEIENEUEWE[E\\EaEdEgEoEuEwE{E}F@FDFJFOFTFXFeFkFmFqF"},
  {0,NULL,"tFxF|G?GAGCGFGKGMGOGYGbGdGjGkGsGtGxHAHEHNHOHSHTHUHWH]HeHfHjHnHsI?"},
  {0,NULL,"IAIEIJIKILIPIUIbIfImIpIuIwJBJCJGJHJKJQJTJVJ]J_JaJcJeJhJnJ|K?KA_A?"},
  {0,NULL,"C?F?Q?W?X?_?o?s?t?v?x?z@?@H@I@O@P@Q@S@T@[@^@b@f@i@m@u@}@~AAABAEAK"},
  {0,NULL,"ATA[A\\AcAiApAsAxAzA}A~BGBHBIBKBUBXB\\BbBhBjBoBuBvBzB|C@CECLCUCWCXC"},
  {0,NULL,"]CbCfCjCkCnCqCuD?DGDJDMDSDTDUDWDcDeDiDsDxD}E@ELEREUEXEYE\\E]E`EcEg"},
  {0,NULL,"EtEvExEyEzE}FEFHFLFMF^FaFlFpFtFuFyF{F~G?GEGGGIGPGUG]GaGbGfGlGtGuG"},
  {0,NULL,"wHAHEHNHOHQHSHUH[H`HbHgHiHmHrH|IBIHIQISITIVIXIcIgIiInIsIwJBJEJFJJ"},
  {0,NULL,"JNJPJSJXJ[J\\J`JaJbJgJmJwJzKC_A?C?G?S?U?V?a?o?p?q?v?w?y@B@G@J@M@P@"},
  {0,NULL,"S@Y@\\@]@_@d@g@j@k@t@}@~A@AAABAKASAYAZAaAmAqArAzA|B@BBBEBFBGBLB]B^"},
  {0,NULL,"B`BaBfBgBkBrBwByB}C@CCCPCUCYC^C`CcCgChClCnCrCuC}DKDMDPDRDWD\\D]DcD"},
  {0,NULL,"dDgDiDxECEEEIEMEPEQETEUE]E`EcEeEjEwEzE}E~F@FCFHFUFZF\\F_FlFpFrFtFu"},
  {0,NULL,"FvF{G?G@GBGWGXG[G]GbGeGjGkGlGpGvGzHFHHHMHTHUHYH\\H]H^HgHoHpHuH~ICI"},
  {0,NULL,"IIKINIOITIUI\\I`IdIoIqIyJ@JGJIJLJNJOJQJRJ[J\\JcJdJeJkJoJqJwKDKF_A?C"},
  {0,NULL,"?G?S?U?V?a?o?p?q?v?w?y@B@G@J@M@P@S@Y@\\@]@_@d@e@i@k@y@}A@AAACADAHA"},
  {0,NULL,"UAZAaAbAoAtAuAwA~B?BABBBEBHBMBWB[B^BaBgBlBsBtBuBzB}B~CBCGCTCXCYC["},
  {0,NULL,"C\\C`CiCjCnCpCuCxDKDMDPDRDTDXD[D`DbDfDuDyEBEDEIEMETEVE\\E]E^EaEdEeE"},
  {0,NULL,"iEwEyEzE}F?FBFOFSFUFZF`FkFmFqFsFtFwFzG?GAGDGMGWG[G\\GaGeGhGpGtGwGx"},
  {0,NULL,"GyG}G~HGHSHXHYH[H\\HbHfHpHtHuH{IFIGIIINISITIUI]IaIhIlIvIzJAJDJIJNJ"},
  {0,NULL,"QJRJUJXJ]J_J`JbJfJjJpJrJ~KAKE_A?C?E?Q?U?W?\\?q?r?s?u?x?y?~@H@I@N@O"},
  {0,NULL,"@P@S@W@X@`@b@e@h@l@r@z@|@~A@AEAFAOAVA`AcAjAtAuAvAyA{B@BDBFBIBKBQB"},
  {0,NULL,"TBYB\\BfBnBsBuBvByB{CHCICRCSCXC]CdCeChCiClCpCxDADEDFDGDIDKDODXD\\Dd"},
  {0,NULL,"DgDkDlDzD|EFENEQERETEVEZE[EbEdEfEqEuExEzE|E~FFFGFMFXF]FcFnFoFvFwF"},
  {0,NULL,"yFzF~G@GCGFGKGPGTGZGaGdGfGiGmGpGvGyG}G~HGHVHWH[H\\H^H`HhHkHxH}I@IC"},
  {0,NULL,"IDIHIKILIMIRI[I`IjIoIrIzJAJEJGJHJMJOJYJZJ[J\\J`JaJdJgJtJuJvK?KEKF_"},
  {0,NULL,"A?C?D?Q?T?X?d?p?r?t?u?w?z?{@H@I@Q@T@U@Y@Z@[@^@_@e@k@l@x@{@}A?ABAD"},
  {0,NULL,"AIALA[A_AbAgAtAuAwAyA{A~B@BFBHBMBNBUB[BeBiBjBlBoBqBwB}C?CFCHCRCWC"},
  {0,NULL,"YC\\C_CaCfCgCoCrCyC}DFDHDJDKDLDYD]DjDmDpDrDvEAEGEPESETEWEYE[E_EbEf"},
  {0,NULL,"EhElEwEyE}F?F@FBFKFLFPFYFbFnFoFrFwFzGBGCGEGFGGGLGQGUG`GbGgGjGkGqG"},
  {0,NULL,"rGuGyG|G~HDHQHRHTHUH]HaHcHlHtHwH{IBIDIEIIIMINIPI]I^IkIlIvI}I~JCJF"},
  {0,NULL,"JIJMJRJVJZJ[J\\J]J`JaJgJrJuJvJyKFKH_A?C?F?R?V?W?c?o?s?t?v?x?z?|@K@"},
  {0,NULL,"L@M@N@R@T@\\@^@`@c@f@i@m@u@{@|@}ABAEAGANAPATA\\AiApAsAxAzA}A~BGBHBI"},
  {0,NULL,"BKBRBVBXBbBiBmBnBvBwBzB}B~CBCGCTCVCYC]CaCeCgCjCzC{C~DBDGDJDODUDWD"},
  {0,NULL,"ZD]DcDiDkDlDwEBEDEJELENEPEREUEYEaEgEhEkEuEwE{E|F@FDFIFJFQFTFfFkFm"},
  {0,NULL,"FuFxF{F|F}GCGFGHGJGOGRGYGdGfGjGkGsGtGxH?HCHIHJHSHTHWH]H`HeHfHtHvH"},
  {0,NULL,"yH{IAIDIFILINIOIWI[I\\IdIjIuIwJBJDJHJIJLJTJWJZJ[J\\J^JbJdJlJmJxJzKB"},
  {0,NULL,"_A?C?F?S?V?X?Z?o?s?t?v?x?z@D@G@J@P@R@S@V@Y@_@a@c@g@h@m@q@z@|A?ACA"},
  {0,NULL,"DAJAMANAUAWAlAqArAxAyA{A}B?BABCBJBSBVBWBdBnBoBqBsBtBxB|CCCDCKCPCW"},
  {0,NULL,"CZC[C_CbCeCiCvCwDADEDFDNDQDZD[D\\D]D^DhDpDrD{D}E@EHEJEOEPEQE[E^E`E"},
  {0,NULL,"cEgEtExEzE}E~F@FCFHFIFZF^FaFlFpFtFuFyF{F~G?GEGGGIGRG[G]GbGeGjGlGm"},
  {0,NULL,"GpGvG{H@HBHKHUHYH\\H]H^HgHhHnHqHzI?IBIEIHILIOITIXI^IcIgIkIqIyJ@JEJ"},
  {0,NULL,"FJHJLJNJPJVJ]J`JaJbJfJjJmJ{K@KCKHKK_A?C?F?Q?W?X?_?o?s?t?v?x?z@?@H"},
  {0,NULL,"@I@O@P@Q@S@T@[@^@b@e@h@i@p@z@~A@AAAEAFAUA\\A`AcAeAtAuAvB?BABBBDBEB"},
  {0,NULL,"IBKBQBWBXB\\BfBkBsBuBvByB{C?CACFCNCXC]C^CdChCiClCqCsD?DDDFDGDHDMDN"},
  {0,NULL,"DSDWDaDnDoDtDzD|EFEOERESEUEXE[E]EbEcEhEpEvEwEyE}F?FBFKFLFQF^FiFnF"},
  {0,NULL,"oFrFsFxF|GBGDGEGGGIGJGUG`GbGgGkGnGqGrGuG}HGHLHPHQHRHTHUHZHaHcHpHr"},
  {0,NULL,"HuH|IAIBIDIKIQISITIaIhImIpIvI}I~JFJGJJJNJTJXJZJ^J_JcJeJfJiJsJ{J~K"},
  {0,NULL,"BKHKKKL_A?C?D?S?X?Y?]?p?r?t?u?w?z@C@G@J@O@R@U@V@Z@a@b@c@g@k@m@s@z"},
  {0,NULL,"@|A?ACAEAJAMARAWA_AkAqArAyAzA{A|B?BABGBLBNBOBSBdBnBqBsBtBvBxB|C@C"},
  {0,NULL,"ECLCUCZC[C]C_CbCeCiCtCzC~D@DHDNDODPDVDXD]D`DoDtDuD{D}E@EIEKENEOEP"},
  {0,NULL,"ESEVE`EeEfEsEuEvE{E|F?FAFPFRFVFWFgFlFpFqFrFvF}G@GAGBGHGNGQGSG^GdG"},
  {0,NULL,"fGnGoGqGwGxH@HFHHHKHRHWHZH`HbHdHfHiHkHmHxICIDIEIFIJITIVIaIbIfIhIt"},
  {0,NULL,"I|J?JDJKJNJOJSJVJZJ\\J_JcJdJeJkJoJqJyJ}KJ_A?C?E?S?U?Y?`?q?r?s?u?x?"},
  {0,NULL,"y?}@G@J@M@O@U@Z@\\@]@b@d@g@h@j@o@{@}@~AAABAKAOASAXAZAdAqArAxA}B@BB"},
  {0,NULL,"BCBEBFBJBYBZB`BaBfBgBiBkBrBwB}CDCECKCLCYC^C`CaCcCgClCqC|D?DCDGDLD"},
  {0,NULL,"NDPDUDYD\\D_DeDqDsDxECEEEIELEOEQEREWE_E`EfEgEmEvEyE{E|F?FAFMFOFVFW"},
  {0,NULL,"FjFlFpFqFyF}F~GAGEGGGHGMGNGPG^GfGgGnGoGqGwGxGzG{HBHMHRHZH`HbHcHdH"},
  {0,NULL,"fHlHvHwHyIAICIEIGIMIOIQIYIZI_IeItI|J?JJJLJMJOJTJUJVJ]J^J`JbJfJjJt"},
  {0,NULL,"J|K@KCKEKFKHKI_A?C?D?R?T?Y?[?p?r?t?u?w?z@A@K@L@Q@V@W@X@[@]@a@d@f@"},
  {0,NULL,"l@m@n@~A@AAACADAHARA[A]A^AfApAsA|A~BCBHBIBJBKBLBOBUB_BcBfBhBkBoBp"},
  {0,NULL,"BxByCBCGCJCMCWCZC^ChCkClCmCpCvCwCxDKDNDODRDSDYDZD_DbDfDqDyD~E?EJE"},
  {0,NULL,"MENEOETEWEXEaEeEhEnEvExEyEzE~FEFNFRFSFYFdFkFmFsFuFwFzF{F}GDGHGLGS"},
  {0,NULL,"G\\G_GcGgGhGmGnGpGvH?HAHCHNHXHZH\\H^H_HcHhHoHrH|H~IAIBICIJINIRIXIZI"},
  {0,NULL,"eIiInIsIxI{JFJIJKJOJPJTJYJ[J^JbJdJfJlJrJxJzJ}KFKHKJKN_A?C?G?Q?T?U"},
  {0,NULL,"?e?o?p?q?v?w?y@@@H@I@N@U@W@X@Y@Z@_@`@f@i@j@w@z@{@|A?ACAJAPAQAVAbA"},
  {0,NULL,"hApAsAvAwAxAzA}BDBGBMBPBRBTB[BiBlBmBpBrByB{CDCECKCLCVC\\CaCcCdChCm"},
  {0,NULL,"CtCvCwD@DHDIDSDTDVDZD[D^DhDoDtD{ECEEEJEKESEXEZE\\E^E`EcEeEjEuEwE{E"},
  {0,NULL,"~F@FDFPFZF\\F]F_FlFpFrFtFuFvF{G?G@GBGQGTGXG[GcGeGiGoGqGrGvH?HAHCHN"},
  {0,NULL,"HRHVHYH^H_HaHdHjHsHvHyIIIKIOIQIUIVIWI\\IdImIpIuIxI{JGJJJLJQJRJSJWJ"},
  {0,NULL,"[J\\J`JaJcJgJmJoJwKAKEKHKIKJKKKLKN_A?C?G?Q?T?U?e?o?p?q?v?w?y@@@H@I"},
  {0,NULL,"@N@U@W@X@Y@Z@_@`@e@i@k@y@{@}A?ACADAIALAQAaAbAoAtAuAwA~B?BABBBEBHB"},
  {0,NULL,"MBPB[B^BeBiBjBlBoBqBxB}CACICNCSCWCYCZC\\C_CaCfCtC{D@DBDGDHDKDPDTDZ"},
  {0,NULL,"D[DbDeDfDsDvEAEGEIEJERESETE\\E^EbEcEdErEuExE{E|E~FFFGF[F\\F]FhFnFoF"},
  {0,NULL,"sFvFxFyF|F~G@GDGTGVGXGZGaGdGfGiGmGvGxG|HDHLHPHVHWH[H^H`HfHhHjHqHs"},
  {0,NULL,"HzIBIJIKIMIOIVIWIYI_IiInIrIzJAJFJGJKJLJMJSJWJ^J_JbJeJfJiJpJsJ~KDK"},
  {0,NULL,"G_A?C?G?R?T?V?b?o?p?q?v?w?y@F@K@L@N@T@V@]@^@`@a@d@f@i@j@w@z@{@|AB"},
  {0,NULL,"AEAGAPAQATAYAhApAsAvAwAxAzA}BDBGBMBPBRB]BbBiBmBnBsBvBwBzCJCMCOCQC"},
  {0,NULL,"VC]CaCeCgCiCjCsC|DCDDDHDIDVDWDYDZD\\D^DhDjDmDwEBEDEJEKEQESEUEWEZEa"},
  {0,NULL,"EdEeEiEvExEyEzF?FEFNFSFUF[F`FkFmFqFsFtFwFzG?GAGDGVGWG\\G_GcGgGhGmG"},
  {0,NULL,"nGpGqHEHIHJHOHRHXHZH\\H_HcHhHiHmH}I@IGIJILIMINISITI]IcIgIlIsIxI{JH"},
  {0,NULL,"JIJKJMJNJUJXJ]J_J`JaJcJhJnJpJwKAKFKGKR_A?C?E?S?U?Y?`?q?r?s?u?x?y?"},
  {0,NULL,"}@G@J@M@O@U@Z@\\@]@b@d@e@h@l@r@{@|@~ABAEAGAOASA_A`AjAtAuAvAyA{B@BD"},
  {0,NULL,"BFBIBKBNBQBYB`BfBhBjBqBrB{B|CBCGCJCMC_CbCcCdCfCkClC{C|DBDCDGDIDLD"},
  {0,NULL,"UDXD[D\\D^DhDkDlDwD~E?ELEQEREVEZE^E_EaEdEgEoEwEyE{E}F?FBFJFOFUFWFe"},
  {0,NULL,"FkFmFqFtFxF|G?GAGCGFGMGNGWGYGeGhGiGpGtGwGxG|HDHLHPHSHVHXHYH\\HbHfH"},
  {0,NULL,"lHrHwH|IAIEIGIPIQIUIXI^IkImIpIvIzJAJCJJJPJQJTJUJVJ\\JaJcJdJeJkJnJv"},
  {0,NULL,"K?KBKGKJKKKMKNKS_A?C?E?Q?U?W?\\?q?r?s?u?x?y?~@H@I@N@O@P@S@W@X@`@b@"},
  {0,NULL,"f@j@l@v@z@|A?A@ACAJAQAVA^A`AnApAsAvAwA|BCBDBJBLBMBPBQBTB_BgBiBlBm"},
  {0,NULL,"BpByB{C@CCCPCUCVC\\C`CaCdChCmCzC~DADEDFDIDJDODQDTDXD`DpDrDuD{ECEEE"},
  {0,NULL,"HENEVEYEZE[E\\E`EfEgEmEvExEyEzE|FEFGFMFWF^FjFlFpFqFyF}F~GAGEGGGHGI"},
  {0,NULL,"GNGPGZGaGbGfGlGsGuGwH?HCHIHJHQHUH[H`HbHeHgHoH}H~I@ICIGIHIIIMIQIRI"},
  {0,NULL,"ZI]IeIlIsIwJBJEJJJMJOJRJUJYJ]J^J_JeJfJiJnJ|J}K@KLKMKNKPKRKSKT_A?C"},
  {0,NULL,"?E?R?W?Y?^?q?r?s?u?x?y@E@K@L@M@Q@R@W@X@[@\\@c@g@h@j@o@{@}A?AAADAIA"},
  {0,NULL,"NASAXA^AdAqArAxA}B@BBBCBEBFBJBVBZB_B`BkBnBpBrBtBuBzC?CACFCNCXC[C^"},
  {0,NULL,"CcCeCjCmCoCtCyD@DLDPDQDTDUDVDYDeDjDmDsDvD|EFEHEIEKELEWE\\E_EbEdEfE"},
  {0,NULL,"qEuEzE}E~F@FCFGFJFXFYFcFnFoFvFwFyFzF~G@GCGFGKGLGYGZGaGcGdGgGoGrGt"},
  {0,NULL,"H@HFHHHKHSHWH[H_HaHcHdHnHpHuI?IHIKILIPIRISIUI`IcIgIoIqI|J?JCJEJGJ"},
  {0,NULL,"HJQJXJYJ[J^J`JbJdJlJtJvK@KDKGKJKKKLKPKRKTKU_A?C?G?R?T?V?b?o?p?q?v"},
  {0,NULL,"?w?y@F@K@L@N@T@V@]@^@`@a@d@g@j@k@t@z@~A@ABAEAFAPARAYAZAmAqArAzA|B"},
  {0,NULL,"@BBBEBFBGBLBOBRB]BaBgBhBjBmBwBxB|C?CFCHCRCVCZC`CbCfCgCkCsDADDDEDI"},
  {0,NULL,"DMDQDRDVDWD\\DaDdDgDnDzEAEGEHEKEMEQEUEZE]EbEcEdErEvExE{E|F?FAFQFSF"},
  {0,NULL,"[F]FhFnFoFsFvFxFyF|F~G@GDGJGTGVG\\GhGiGkGlGmGsGuG{H@HBHKHQHTHVHXHe"},
  {0,NULL,"HgHhHiHlHmHwIGIJIMIPISIVIWIYI_IbIfItIyJ@JCJKJMJSJUJWJXJ[J^JbJdJeJ"},
  {0,NULL,"lJoJtJ~KDKHKIKKKMKNKOKPKQ_A?C?F?R?V?W?c?o?s?t?v?x?z?|@K@L@M@N@R@T"},
  {0,NULL,"@\\@^@`@c@g@h@m@q@{@|@}A?ADAIANATAWAXAlAqArAxAyA{A}B?BABCBJBSBVBZB"},
  {0,NULL,"bBkBnBpBrBtBzB{CHCICRCSC[C^CcCdCeCjCmCrC{C}DBDJDQDRDUDZD[D]DbDfDp"},
  {0,NULL,"DrDvD|EFEHEJELEMEPEYE^EbEcEhEpEvEwE{E|F?FAFLFQFTF[FiFnFoFrFsFxF|G"},
  {0,NULL,"BGDGEGGGJGOGUGVGeGhGiGkGmGsGuGzHFHHHMHQHTHVHXHYHeHhHkHvHxHyIAIDIF"},
  {0,NULL,"IQIRISIWIZIaIeIhItIyJ@JDJJJTJWJXJYJZJ]J_JaJcJfJhJsJyJ{KCKEKFKJKNK"},
  {0,NULL,"OKRKS_A?C?F?S?V?X?Z?o?s?t?v?x?z@D@G@J@P@R@S@V@Y@_@a@c@e@h@i@p@zA@"},
  {0,NULL,"AAACADAHAUAWAaAcAeAtAuAvB?BABBBDBEBIBKBSBWB\\B^BgBlBmBsBtBuB}CJCMC"},
  {0,NULL,"OCQCVCXCYC[C\\C`CiCoCvCwCyDFDLDMDNDQDSD[D_DaDnDqDyEBEDEHEOEXE[E]E^"},
  {0,NULL,"E_EaEgEhEkEuExE|E~F@FFFHFIFRFTFfFkFmFuFxF{F|F}GCGFGHGOGRGSG]GcGjG"},
  {0,NULL,"lGnGoGrGsGyG|G~HDHZH]H_HaHdHeHgHqHzH}I@IFIGIHILIOIWIXIYI[I_IjIrI}"},
  {0,NULL,"I~JDJEJHJLJPJUJWJ\\J^JcJdJeJkJsJzK?KBKEKFKGKIKNKPKRKX_A?C?D?R?T?Y?"},
  {0,NULL,"[?p?r?t?u?w?z@A@K@L@Q@V@W@X@[@]@a@d@g@k@m@s@z@~A@ACAEAFAMARAYA]Ak"},
  {0,NULL,"AqArAyAzA{A|B?BABGBLBOB]BcBdBgBhBlBmBwBxB|CACICNCSCVCZC\\C`CbCgCkC"},
  {0,NULL,"pCqCxD?DNDODRDSDUDVDXDkDlDoDtDzEAEGEKELEMENEOEVEXEbEfEhElEyEzE}E~"},
  {0,NULL,"F@FCFKFNFXFYFbFnFoFrFwFzGBGCGEGFGGGKGLG_G`GaGcGdGgGrGtGwGzG{HBHMH"},
  {0,NULL,"SHWH[H_HaHbHcHoHqHzH~IBIIINIPIRIWIXI\\I^IdIkIqI|J?JCJFJIJPJRJWJYJ\\"},
  {0,NULL,"J]J_JaJcJhJqJuJyJ{KEKGKIKLKMKS_A?C?D?Q?T?X?d?p?r?t?u?w?z?{@H@I@Q@"},
  {0,NULL,"T@U@Y@Z@[@^@_@f@l@m@n@}@~AAABADAKALA[A\\A]AfApAsA|A~BCBHBIBJBKBLBU"},
  {0,NULL,"BXBcBeBhBjBoBtBuBvBzCCCDCKCPCWCXC[C]CfCjCkCrC|C}DCDIDJDKDLDRDSDYD"},
  {0,NULL,"_DdDgDqDxD}E@EMETEWEXEYEZE_E`EeEfEsEuEwE{F?F@FDFKFPFVF\\FgFlFpFqFr"},
  {0,NULL,"FvF}G@GAGBGHGQGXG^G`GeGhGiGoGqGrGvHEHIHJHOHRHVHXHYH^HaHdHnHtH{I?I"},
  {0,NULL,"DIEIFIHIIIPIVI[IbIfIjIuIxI{JCJDJEJRJSJVJZJ^J_JdJeJfJiJqJxJ|J}KEKG"},
  {0,NULL,"KKKMKOKRKZ_A?C?D?S?X?Y?]?p?r?t?u?w?z@C@G@J@O@R@U@V@Z@a@b@c@e@k@l@"},
  {0,NULL,"x@{@|A?ABAEAGALAMAOA_AgAtAuAwAyA{A~B@BFBHBMBNBYBdBeBfBjBpBqBrB{B|"},
  {0,NULL,"B~COCQCTC_CbCcCdCfClCmCsCzC~DDDHDJDLDMDVDXD]DcDiDjDmDwD~E?EKEPESE"},
  {0,NULL,"VEYE]E_EaEeEhEnEuEvExE|E~FFFIFNFRFVFdFkFmFsFuFwFzF{F}GDGHGRGSG^G_"},
  {0,NULL,"GcGjGlGnGoGsGuG}HGHLHPHQHZH]H_HdHeHgHjHkHsHxICIFIJIRIUIVIXI`IiInI"},
  {0,NULL,"oIrI}I~JDJKJOJPJQJSJYJ[J]J`JbJfJjJpJrJuJxKIKKKLKOKRKSKZK[_A?J?P?R"},
  {0,NULL,"?T?Z?[?j?l?t?u?v?z?~@?@B@C@O@V@W@X@[@]@`@e@h@n@p@{ADAFAHALANAOAPA"},
  {0,NULL,"XAbAiAkAmAnAzB?B@BBBDBEBKBTBXBaBdBfBvByC@CCCFCGCHCQCRCSCUCVC`CbCn"},
  {0,NULL,"CwC{C|C}D@DBDPDTDYD[DhDjDmDpDqDsDuDvDxD{D}E?EBEPEWEYE^EbEhElEpE~F"},
  {0,NULL,"@FCFFFKFNFTFXF[F\\F`FaFeFgFnFoFpFrFzF|GGGIGLGMGNGPGWG^GaGcGdGeGgGi"},
  {0,NULL,"GtGwGxGzG}HMH_HbHeHjHmHoHqHyHzI@IIINIPITI[I^I_IpIwIyJ?JCJDJIJLJPJ"},
  {0,NULL,"SJUJ^JfJiJlJrJvJ{J~K@KBKJKPKRKVKXKY_A?I?N?S?X?]?b?j?l?p?r?v?w?|?~"},
  {0,NULL,"@@@A@O@P@X@Z@a@b@c@f@j@w@xAAABAGAJASAUAZA[A\\A^AjAkAlAoAvAxAzA}B?B"},
  {0,NULL,"CBMBOBQBVB[BlBpB{B~CCCICJCKCPCRCSCUCZCeCiCnCoCrCuD?DBDDDGDLDUDWD_"},
  {0,NULL,"DeDgDjDkDnDqDvDxDzE?EAEDEMETEUE_E`EeEjEsEvF?FAFEFHFLFPFRFUFWFbFeF"},
  {0,NULL,"fFhFlFoFpFtFvF}GBGKGLGOGTGYGZG^GbGdGfGkGnGoGtGwGxHCHFHHHWHZH\\HiHk"},
  {0,NULL,"HmHrHuHzH}IDIEIFIWIfIgIlImIzJ?J@JDJFJHJIJKJVJXJ[J`JgJjJmJoJtJxJ|K"},
  {0,NULL,"AKFKGKOKSK[K\\_A?J?M?R?W?^?a?j?l?o?q?r?y?{?}@@@D@Q@R@X@Z@[@\\@^@e@k"},
  {0,NULL,"@v@yA@AEAHAIARATAYA_A`AcAdAfAhAlAwAyA}A~B?BABEBPBSBUB`BiBoBqCBCDC"},
  {0,NULL,"FCHCKCOCPCRCSC[CcCjCnCqCsCwCzDADDDMDNDODSDdDiDkDlDoDqDuDxDzD{D~EC"},
  {0,NULL,"EDENEQEZE]EbEdEqErEzE}FBFCFGFJFQFSFYF^F_FdFfFjFlFnFoFsF~G@GCGKGNG"},
  {0,NULL,"QGRGSGXG^GcGdGgGlGnGoGrGtGuH@HDHKHSHXHdHmHnHpHtHuHyH|IHILIOIRI]I`"},
  {0,NULL,"IaInIxI|J@JDJHJJJNJQJUJYJ_JeJhJiJpJqJsJuK?KDKEKHKIKMKWKZ_A?H?N?S?"},
  {0,NULL,"Y?]?e?k?n?p?q?t?w?{?|?~@F@O@R@Z@\\@^@a@c@f@i@s@wAAACAGAJASAUA\\A]A^"},
  {0,NULL,"AaAgAjAlAmAvAzA}B@BDBKBMBQBVB]BeBnBvBwB~CBCGCHCJCKCRCSCUCcCdCfCnC"},
  {0,NULL,"oCtCuCxD?DADFDNDQDTD_DbDeDnDpDqDtDvDyDzD}EAECEMEOETE\\EaEeEiEnEuE~"},
  {0,NULL,"FDFFFIFNFOFVFXFZFaFbFhFjFkFmFnFwG?GDGHGIGJGPGSGUGVG`GaGbGjGlGnGoG"},
  {0,NULL,"sGtGuG}HGHJHQHYHdHjHlHpHsHxHyI?ICIMIRIXI\\IcIiIpIzI}J@JCJGJJJOJPJR"},
  {0,NULL,"JSJ_JcJhJkJnJpJsJwJzJ}KEKHKNKPKQKY_A?I?L?Q?U?c?e?i?m?o?p?s?v@C@D@"},
  {0,NULL,"E@F@O@U@V@W@Z@_@`@g@m@q@y@}@~AIAJARASAZA[A\\A`AeAgAhAnAxAyBABCBDBJ"},
  {0,NULL,"BLBNBRBWB_BqBsBxC@CCCHCLCNCOCQCTCUCVCdCmCnCqCxCyC{D?DCDKDLDUDYD_D"},
  {0,NULL,"bDdDgDiDlDmDwDxDyD|EBEGELETEUE]E`EcEjEtEwE{FAFDFLFMFOFPFZF]F`FbFc"},
  {0,NULL,"FfFkFlFpFtFuFvGEGKGLGRGSGXG\\G_GcGgGiGoGqGrGtGvGwHAHKHNHQHVH_HrHsH"},
  {0,NULL,"vHwHxHyI@IIIKILIUI\\IeIhIkIwIxI~JGJRJTJUJWJXJYJbJfJiJjJmJqJxJ{K@KD"},
  {0,NULL,"KFKGKOKRKXK[K^_A?H?P?R?V?c?d?i?m?p?t?x?z?}@?@@@C@M@N@R@T@\\@b@d@e@"},
  {0,NULL,"l@q@xA@ADAGAIAUAYA]A^A`AaAdAhAiAkAvAwA{A~BFBGBMBPBXB`BdBrB{B|C?CB"},
  {0,NULL,"CDCECICJCLCMCOC]CaCgCnCpCrCvCxD@DEDKDPDQDTD_DaDgDnDrDsDuDxDyD{E@E"},
  {0,NULL,"FEGEHEOETEXEaEhEkEnEwF@FBFDFIFJFQFSFYFZFaFcFgFhFkFlFmFwFxF{GHGIGN"},
  {0,NULL,"GOGPGTGZG^GaGdGfGkGpGsGtGvGxH?HCHPHTH`HcHiHpHtHvHwH{H~ILIOIVIWI]I"},
  {0,NULL,"`IjIkIwI{J?JFJHJMJNJRJWJZJ]JfJhJjJpJsJuJxJ|K?KEKHKJKPKXKYK_K`_A?J"},
  {0,NULL,"?P?R?W?]?c?j?l?t?u?v?z?{?}@@@D@N@R@T@W@Y@\\@`@e@k@u@xA@AEAGAIARAYA"},
  {0,NULL,"^A`AaAcAdAfAhAlAwA{A~B@BBBFBJBPBSBUB`BiBoB}C?CACBCDCECICKCNCOC[Cc"},
  {0,NULL,"CmCnCpCxCzC|D?DEDIDWDXD\\DaDgDhDiDnDtDuDxDzD{D~E@EDEOEUEVEXEbEhElE"},
  {0,NULL,"pEvE|FAFFFLFMFNFTFXF[F`FaFeFgFnFoFpFrFzF|GGGJGMGQGWGXG[G]GaGeGhGi"},
  {0,NULL,"GkGmGpGsGwGzG|HMHYH_HeHkHnHoHsHxHyH}IAIEIQISIhIiIlIoIyI{J?JDJEJOJ"},
  {0,NULL,"PJQJTJXJ[J\\JgJlJoJrJvJyJ~KBKIKKKMKWKZK\\_A?H?P?R?Y?[?_?i?m?p?t?x?z"},
  {0,NULL,"?{?~@B@D@M@V@X@[@]@_@d@e@i@p@s@{AEAFAHAOAPATAXA_AbAfAlAmAnAvB?BCB"},
  {0,NULL,"DBEBKBMBSBTBUBaBgBlBtB~CCCFCGCPCQCSCTCUCWC^ChCqC{C|C~D@DBDEDGDIDV"},
  {0,NULL,"D\\DcDgDhDjDmDoDsDwDxD{D|D}EAEKEPEREYEaEhEkEnEvEyFBFEFJFQFRFSFWFYF"},
  {0,NULL,"aFcFgFhFkFlFmFwFxF{GHGQGTGXGZG[G]G_GcGfGgGhGiGmGpGvGxG~H?HCHTH^Hc"},
  {0,NULL,"HlHrHuHvH|H~I?ICIHIJIRIYIaImInIwIyI{JFJGJJJKJVJYJZJ\\JcJhJkJpJsJuJ"},
  {0,NULL,"wJzK?KKKMKSKTKZK\\K__A?I?K?S?X?Z?^?j?l?o?s?u?x?|?~@@@A@N@S@U@Y@_@a"},
  {0,NULL,"@c@f@j@p@vAAABAHAJAPASAZA[A\\A_AjAkAlAoAvA{A|BGBJBLBMBOBQBVB[BlBmB"},
  {0,NULL,"{B~C@CACDCECICJCLCSCZC_CeCoCpCqC|C}DCDDDKDMDRDYDcDdDfDiDjDnDsDvDx"},
  {0,NULL,"DzE?EDEFELEREWE]E`EgEmEtE}F@FCFDFIFKFOFVFZF^F`FcFdFiFlFnFpFqFuFyG"},
  {0,NULL,"EGJGTGVGZG\\G]G_GeGgGhGjGlGmGpGqGvG{H?HBH]HfHhHjHkHnHtHwHzI?IBIRIT"},
  {0,NULL,"IXI]IbIcIpIyI|JAJCJHJKJNJPJTJZJ^JeJiJkJnJwJzJ}K@KDKEKFKGKOKYK[K`K"},
  {0,NULL,"a_A?I?O?Q?U?[?\\?i?m?r?u?w?x@C@D@E@F@P@R@S@W@Y@`@b@g@m@r@s@}@~AFAJ"},
  {0,NULL,"ANASAZA[A\\AbAeAgAhAnAwAyAzA|A}BABGBNBRBWB_BnBqBsCDCECHCKCMCNCOCPC"},
  {0,NULL,"QCVC\\CmCrCsCuCxC{C|C}DGDMDRDWDaDbDcDeDlDqDsDwDxDyD|D~EGEMEREWE_E`"},
  {0,NULL,"EfEmEsEyEzFCFEFGFKFUFWF\\F^FdFeFhFiFlFmFpFqFyF}GBGJGOGPGRGSGVGYGaG"},
  {0,NULL,"bGeGfGhGkGlGsGuH@HIHJH[HaHeHoHqHsHtHuH~I@IGIJIMIQIZI^IaIdI{I}JBJC"},
  {0,NULL,"JIJJJMJQJWJYJ\\JdJgJkJoJtJyJzJ}KCKFKGKIKOKZK[K^Ke_A?H?K?S?V?Z?\\?k?"},
  {0,NULL,"n?s?x?y?z@?@@@A@E@Q@S@V@Y@]@a@c@f@l@q@v@|ABAHAJAOAPATAZA[A_AdAeAk"},
  {0,NULL,"AoAvAwA~BBBJBLBMBOBZB[B\\BkBoBxB~C@CACBCDCGCICJCNCXC\\C`CtC{C|C}DAD"},
  {0,NULL,"CDDDHDIDVD]DcDdDiDjDlDpDtDvDwDzE@EEEFELEPEREZEaEgEkEoExE|FEFFFHFR"},
  {0,NULL,"FTFUFWF[F_FcFgFiFkFmFoFxF{GAGFGKGLGQGRGUGXG`GcGhGiGjGlGnGoGqGrG|H"},
  {0,NULL,"AHDHaHbHgHiHlHoHpHqH}I@IFIKIOIWIZI[IfIlI|I~JAJDJEJJJLJMJRJXJ]JaJh"},
  {0,NULL,"JjJmJuJxJ|K?KAKKKLKSKTKUK\\K^Kd_A?J?O?Q?W?\\?]?k?n?q?r?u?z?}@A@D@F@"},
  {0,NULL,"N@P@T@W@`@b@d@g@k@s@v@}A?AFAJALANAXAZA\\AbAeAfAhAjAyA|B?BABEBGBIBR"},
  {0,NULL,"BWBYBcBgBhBmC?CECFCHCJCMCNCOCPC]CiClCoCrCuCvC{C}C~DTDZD[D]D^D`DbD"},
  {0,NULL,"cDeDjDsDvDwDyD~E@ECEPEWE\\E_EbEfElEqEuE|FAFFFLFMFPFTFXF]F_FaFdFeFk"},
  {0,NULL,"FnFoFrFzF~GCGMGWGZG[G\\G]G_GaGeGfGiGjGkGmGpGvGyG~HBHRH\\H`HiHkHxHyH"},
  {0,NULL,"{H|H}IHIKILIXI\\IfIhIoI{I}JAJDJEJGJNJOJTJVJ]J_JhJiJpJqJuJ{K@KDKJKN"},
  {0,NULL,"KRKUKVKXK]Ka_A?I?K?S?U?`?c?j?l?o?s?u?x?{@?@E@F@M@O@U@Z@[@_@d@f@m@"},
  {0,NULL,"r@u@|ACAGAKAMAQAVAWA]AaAdAeAgAmAzA|A}BEBGBHBIBZB\\B]BeBhBjBuC?CCCF"},
  {0,NULL,"CHCKCMCPCTCUCYC^CgCpCtCvCwDBDDDEDHDVDXDZD`DfDjDkDrDtDuDvDzD{D|D~E"},
  {0,NULL,"BEHEJEVE[E`EgEmEtE{E|FAFDFIFMFOFVFZF]F`FcFdFiFlFnFpFqFuFyGEGKGLGN"},
  {0,NULL,"GUG\\G_G`GcGgGmGnGoGqGvGwGxG{HBHEH]HcHfHsHuHvHwHyHzH{ICIGIMISI\\IeI"},
  {0,NULL,"iIjIyI|I~JGJHJIJOJTJUJWJ\\JaJgJkJnJwJyJzJ}KCKKKLKNKQKTKUK`_A?J?L?Q"},
  {0,NULL,"?T?Z?e?k?n?o?t?v?y?|@B@C@E@M@U@W@X@[@_@`@g@h@q@w@z@~AIAJARASAYA[A"},
  {0,NULL,"`AcAgAiAnAoAxAyA{BABCBFBHBNB^B_BbBpBrBzB~C?CCCFCHCLCNCQCTCWCYC_Cq"},
  {0,NULL,"CvCxC~D?DCDDDIDNDODXD^D_D`DdDgDlDnDwDyDzD}EBEEEOEUEZE]EbEcEpErExE"},
  {0,NULL,"~FCFFFGFKFNF[F\\F^F`FfFgFjFmFnFoFsF|G@GGGMGNGOGTGWGYG^GaGdGfGgGiGn"},
  {0,NULL,"GvGwGxHFHLHPHUH^HfHjHoHqHzH{H|I?IFIJIMIVIZI^I_IcIwIzI~JIJLJMJNJPJ"},
  {0,NULL,"SJVJaJcJgJhJoJsJtJyK?KCKIKLKMKQKWKZK_KcKf_A?J?M?R?T?`?b?j?l?o?q?r"},
  {0,NULL,"?y?~@?@B@C@N@Q@S@T@V@]@^@e@h@r@w@{ADAFAGALANAUAXA]AbAiAkAmAnAyA{B"},
  {0,NULL,"ABDBFBKBLBTBXBaBdBsBvByC?C@CACGCICLCNCQCUC`CbCkCoCrCtCwCyCzC|DJDL"},
  {0,NULL,"DZD]DbDeDfDhDiDqDrDvDxD{E?EBEEEIEJE\\E_EbEdEqErE{F?FAFBFJFPFQFSFYF"},
  {0,NULL,"]F_FdFfFjFlFnFoFsF~G@GCGIGPGRGSGVG[G]GhGjGkGlGmGoGrGsGuH@HGHKHSHX"},
  {0,NULL,"HgHlHmHnHoHrHwH{ICIJIVIWIYIjIkImI|J@JBJKJPJQJRJUJVJWJ`JaJgJhJpJsJ"},
  {0,NULL,"tJuK?KCKJKRKSKTKVKXKbKdKh_A?H?M?R?Y?^?e?i?m?q?s?w?y?{?~@B@D@P@R@X"},
  {0,NULL,"@[@\\@a@c@e@i@o@y@{AEAHAIAOAPARATA_AcAfAlAmAnAwA|A~B?BEBHBIBSBTBUB"},
  {0,NULL,"aBgBtBuCBCCCFCJCKCMCOCPCSCWCZChCqCrCsCzD@DCDDDHDJDUD]D^DiDkDlDoDr"},
  {0,NULL,"DsDwDxD{D|EAECELEQESEZEaEdEiEoEuE{FDFFFNFOFTFVFXF[F_FbFiFjFkFmFpG"},
  {0,NULL,"?GAGDGFGIGPGUGYG[G]G`GbGdGjGkGnGqGsGtGuGyHEHOHUHWHhHiHjHsHxHzH~I?"},
  {0,NULL,"IAIEIIIPI_IhIiIpIxJ@JBJCJFJGJMJOJSJTJ`JbJjJlJmJrJvJ~KAKBKKKRKSKTK"},
  {0,NULL,"VK\\K]KcKg_A?J?O?Q?T?`?d?k?n?q?r?u?z?|@B@C@E@N@Q@T@U@^@_@c@g@h@n@o"},
  {0,NULL,"@z@~AIAKAQARAWAYA`AcAgAiAnAoAxB?B@BBBCBEBMBNB^B_BbBpBtBzB~CACCCGC"},
  {0,NULL,"ICLCRCSCTCYC_CaCpCsCuCvDADCDEDMDSDWD\\D^D_DaDcDkDoDtDwDyDzD}E?EEEN"},
  {0,NULL,"EQEVEXEbEfElEqEyF?FAFBFLFMFPFSFYF]F_FaFdFeFkFnFoFrFzF~GCGOGRGSGYG"},
  {0,NULL,"[G]G`GbGjGkGlGmGpGqGrGuGyG~HHHRH]H`HjHlHmHvHwH{H}IBIIINIUIYIeIgIk"},
  {0,NULL,"I}JAJBJFJKJLJOJRJUJVJ^JdJiJlJqJvJ{K@KBKDKIKMKOKWKZK[K_KaKc_A?H?K?"},
  {0,NULL,"S?Y?_?`?k?n?s?x?y?z?{?|?~@F@M@O@V@Z@]@`@d@f@i@o@uAAACAGAKAMAQAUA]"},
  {0,NULL,"A^AaAgAjAlAmAwAyAzA}A~BHBIBQBVB]BeBiBnBwCFCHCKCMCOCQCRCTCUCbCdCfC"},
  {0,NULL,"pCtCvCwCyC}D?DKDPDRDSD`DaDdDeDfDtDuDvDyDzD|D}ECEHEIEXE[EaEgEkEoEy"},
  {0,NULL,"E}FBFEFHFJFRFUFWFYF_FcFgFiFkFmFoFxF{GAGFGJGMGQGTGVGXGZGcGeGhGiGpG"},
  {0,NULL,"rGvGwGxG|HDHIHVHbHgHlHmHqHrHxH|H~IDIEIPIUIdIgImInIyI~JAJEJFJJJQJS"},
  {0,NULL,"JVJYJ^JbJjJlJmJxJ|J~KAKBKEKFKHKOKPKYK^Kb_A?I?O?Q?X?^?d?i?m?r?u?w?"},
  {0,NULL,"x?|?}@A@B@Q@S@U@Y@]@^@_@g@j@o@x@zA?AIAKAMAQAVAWAYAcAfAiAjAoAxAzA}"},
  {0,NULL,"B@BBBCBKBYB^BbBcBfBwB}B~C@CACBCCCGCLCRCUCXCjCkCsCvCyCzC{DADEDHDQD"},
  {0,NULL,"ZD[D^DaDbDmDoDtDuDwDyD{E?EAEFEHENESEVE`EfEmEsEuF@FCFDFGFIFKFVF\\F^"},
  {0,NULL,"FdFeFhFiFlFmFpFqFyF}GBGJGMGQGVGWG\\G_GeGhGiGlGmGqGrGsGvGzHIHJHXH[H"},
  {0,NULL,"aHnHpHrHtHzI?I@IAIDIFIVI_I`IbIcI{JAJBJCJHJPJSJXJYJZJ]J`JgJjJoJtJy"},
  {0,NULL,"J|KAKCKJKLKNKQKUKVKiKj_A?H?M?R?V?\\?b?i?m?q?s?w?y?}@?@@@C@N@T@U@V@"},
  {0,NULL,"]@a@c@e@l@r@tA@ADAFAGALANAUA]A^AaAdAhAiAkAxA{BDBFBHBIBKBPBXB`BdBj"},
  {0,NULL,"BrB|B~C?C@CECGCICLCQCTC]CaCeCoCqCrCuCwCyDEDFDNDRDSD`DbDfDgDoDqDrD"},
  {0,NULL,"xDyD{EEEFEGEIEME[E\\EaEdEiEoExEzFEFFFHFNFTFUFXF[F_FbFiFjFkFmFpG?GA"},
  {0,NULL,"GDGFGNGQGUGXG\\G^G`GbGcGgGhGjGmGnGqGrHEHLHOHRHWHhHiHkHqHvH}I?I@INI"},
  {0,NULL,"QISITI[I^IlIoIxI|JBJEJGJIJLJMJXJZJdJeJkJlJnJrJvJ}J~KBKEKHKIKPKWKY"},
  {0,NULL,"K]K`KcKn_A?I?L?Q?X?_?b?i?m?o?p?s?v?|?}@A@B@O@P@Q@Z@\\@^@b@g@j@p@t@"},
  {0,NULL,"zA?AFAKALAMAQAVAWAXAfAiAjAoA|A~B@BBBGBJBLBYB^BbBcBfBkB}CACBCDCECG"},
  {0,NULL,"CJCKCPCRCfCjCkCsCtCwCxCyC~D@DFDODVDXD`DaDhDlDmDpDrDwDyD{EAEDEFEJE"},
  {0,NULL,"KE[E^E`EcEjEtEvExFAFEFHFLFMFPFRF]F`FbFcFfFkFlFpFtFuFvGEGIGKGLGMGO"},
  {0,NULL,"GWGYGaGbGcGdGfGoGtGuGwHAHMHNHQHSHVHiHkHlHmHrHsHtIBIHINIXIYIfIgIoI"},
  {0,NULL,"wIxIzJCJDJEJFJKJWJXJcJeJiJkJnJqJwJ{K@KDKLKMKNKQKUKWKhKiKm_A?H?N?S"},
  {0,NULL,"?V?a?d?k?n?p?q?t?w@?@@@A@E@M@R@S@W@Y@\\@d@f@l@n@t@|ABAHAKAOAPATAVA"},
  {0,NULL,"WA_AdAeAkAoBABDBHBIBJBKBLBOBZB[B\\BkBxByC?C@CACDCMCNCOCQCTCXC[C\\Cs"},
  {0,NULL,"CzC}C~D?DADBDGDJDUD\\D^DdDeDhDkDmDpDvDwDzE@EEEGEKEQESEYEaEeEiEnEwF"},
  {0,NULL,"?FBFDFIFOFQFSFVFZFaFbFhFjFkFmFnFwG?GDGHGIGKGLGPGTGWGZGaGeGfGpGsGt"},
  {0,NULL,"GuGwGxG}HGHNHYH[HdHnHpHqHtHvHxH{IBIGISITI]IbIeIjIzI}J?JEJNJRJSJUJ"},
  {0,NULL,"WJZJ[JdJkJlJnJrJvJwJzJ}KGKKKSKTK[K\\KdKeKiKl_A?I?N?S?U?[?a?j?l?p?r"},
  {0,NULL,"?v?w?{@?@E@F@M@P@S@T@Y@b@d@f@m@n@y@|ACAHAKAMAOAQATAVAWAdAeAgAmAxB"},
  {0,NULL,"CBFBHBIBJBLBZB\\B]BeBjBuBzC?C@CDCECFCLCMCNCTC^CgClCoCpCzC~D@DADBDF"},
  {0,NULL,"DODQD[D^DfDhDkDnDoDpDvDzD{D~EBEGEKENESE^E`EeEjEsEzE~FCFEFGFHFRFUF"},
  {0,NULL,"WF\\FbFeFfFhFlFoFpFtFvF}GBGJGOGUGVGYG[G`GbGdGeGfGjGkGlGpGsHFHHHOHT"},
  {0,NULL,"HZH\\HkHoHuHwH|H~I@IKIOIPIUIZI[IdInI}J?J@JIJKJLJMJQJTJYJ_JfJiJjJmJ"},
  {0,NULL,"qJxJ{J|KAKHKLKNKPKQKUKgKnKoKq_A?J?L?Q?W?_?a?k?n?o?t?v?y?}@A@D@F@P"},
  {0,NULL,"@Q@X@[@^@a@b@g@k@t@u@}A?AFAKALAMANAVAXAbAeAfAhAjAvA{A|B@BBBFBGBRB"},
  {0,NULL,"WBYBcBhBmB|CACBCECICJCMCPCRCSChCiClCtCuCyC~D@DBDCDJDLDPDYD_D`DcDf"},
  {0,NULL,"DmDpDrDvDwDyE@ECEDEIEJEYE^EbEcEpErEwE}FBFCFGFJFKFQF\\F^F`FfFgFjFmF"},
  {0,NULL,"nFoFsF|G@GGGNGRGSGUG\\G^G_GbGdGgGnGoGqGrGuGxG{HLHPHUHZH^HjHnHpHuH|"},
  {0,NULL,"H}H~IAIDIGIQI`IaIbIdIxIzI~JHJJJLJNJOJQJZJ[JbJgJlJoJrJtJyJ~KCKFKGK"},
  {0,NULL,"JKRKVKXK]KfKkKo_A?H?P?R?V?c?d?i?m?p?t?x?z?}@?@@@C@M@N@R@T@\\@b@d@g"},
  {0,NULL,"@m@q@s@}ADAIAKATAWAXAYA]AaAeAgAhAnAqArAuA{A}B?BLBNBPBQBTBVBYB\\BgB"},
  {0,NULL,"kBlBnBpBrByBzB{CECICSCdCjCkCnCpCrC}DBDCDDDHDQDZD[D_DdDrDuE?EAEFEH"},
  {0,NULL,"EJETEXEYEZE]E`EfEkEsEzF@FAFDFHFMFSFXFYFZFdFeFhFiFrFsFvFyG@GAGHGMG"},
  {0,NULL,"SGTGUGfGnGxG{G|H?H@HBHLHMHOHPHQHVHXHjHoHpHzH{H}H~IIIKILIUI`IcIgIj"},
  {0,NULL,"IkIlIpIqIrIvIwIxI~JFJHJPJRJ\\JdJkJlJmJoJvJyJ}K@KGKKKLKVKZK[KaKcKdK"},
  {0,NULL,"iKmKoKpKr_A?I?O?Q?X?^?d?i?m?r?u?w?x?|?}@A@B@Q@S@U@Y@]@^@_@e@l@r@x"},
  {0,NULL,"A?ADAHAIAVAWA[A_AbAcAdAhAiAkAqAtAuAvAyB@BHBOBRB]B`BaBbBeBiBjBlBmB"},
  {0,NULL,"nBoBsBwB}CGCHCRCWCgChCnCoCvCyC}D?DADHDJDUD]D^DmDnDuD|EAECEHENEOES"},
  {0,NULL,"EUEWEYEaEdEoEsEuExFBFDFGFIFRFSF]F^F_FbFiFjFqFtFxF|GCGDGGGJGLGNG[G"},
  {0,NULL,"eGhGwGzG}G~HAHGHHHJHLHMHTHUHcHmHnHxHyHzH}I@ILIOIVIWI\\I_I`IbIgIiIn"},
  {0,NULL,"IqIrItIwI{J?JHJOJSJYJdJeJiJkJnJpJvJxKBKDKEKIKRKYK[K\\K_KbKeKfKlKmK"},
  {0,NULL,"qKr_A?J?L?Q?W?_?a?k?n?o?t?v?y?}@A@D@F@P@Q@X@[@^@a@b@f@i@u@w@}AAAH"},
  {0,NULL,"AKATAVAXA[AbAcAgAjAlAmApAqAsAwAxBGBKBNBOBSBXBYB]BdBhBjBoBpBqBrBuB"},
  {0,NULL,"vB|CECJCLCXC\\CbCnCpCqCuCyD@DEDGDJDUD\\DcDfDmDuE@EEEGEHEIEREVEYE]E^"},
  {0,NULL,"EaEeEiEpEuEwFBFEFGFJFPFRFTF\\FaFbFhFjFqFsFtFyFzGAGHGLGNGVG]GgGmGnG"},
  {0,NULL,"yG{H?HAHBHCHJHMHPH[HbHgHjHkHnHsHuHvHwIDIEIPIUI[IaIbIdIjIkIoIqItIu"},
  {0,NULL,"IyI~JAJLJQJWJZJ_JcJhJiJnJpJqJwJxKBKEKHKKKMKQK[K_KdKhKjKnKqKrKsKv_"},
  {0,NULL,"A?J?M?R?W?^?a?j?l?o?q?r?y?{?}@@@D@Q@R@X@Z@[@\\@^@f@j@v@wA@AAAHAKAT"},
  {0,NULL,"AVAXAYA]AcAjAkAlAoApAsAuAwBCBDBGBNBSBYB[B_BdBeBhBkBoBpBqBsBvBxB|C"},
  {0,NULL,"KCOCQC^C_CgCnCqCsCuCyC{C}DFDODQD[DcDdDoDuD~EBEGEHEIENEPEQERE]E`Ee"},
  {0,NULL,"EjEqEvEzFCFDFMFNFQFSFVF^FbFeFfFhFrFuFxF{F}G?G@GMGRGTG`GiGoGrGyG|H"},
  {0,NULL,"@HCHDHEHIHJHMHTH]HfHiHmHpHqHxH|I@IBIRITIXIZI]I^I`IeIhInIrIsIvIyI|"},
  {0,NULL,"JAJMJNJUJYJ[J`JgJlJmJoJrJ}K@KAKFKGKPKSKUKVKcKeKkKlKoKrKsKtKu_A?H?"},
  {0,NULL,"K?S?V?Z?\\?k?n?s?x?y?z@?@@@A@E@Q@S@V@Y@]@a@c@g@h@o@q@z@|AFAJAMANAO"},
  {0,NULL,"APAUAZAgAiAnAoApAqArA}B?BFBJBSBUBXB[B_BcBeBiBjBoBqBsBtBwBxB|CACDC"},
  {0,NULL,"KCWCiClCnCwCxC|DADDDEDTDZD[D]DgDjDlDpD~E@ECEPERETEUEZE[E^EbEfEkEq"},
  {0,NULL,"E|F?FCFFFKFQFUFVFWF[F_FaFdFeFrFtFvFwFyG@GFGIGXGYG_GcGrGtGzG{G|H?H"},
  {0,NULL,"AHGHHHMHNHUH\\H^HiHlHsHtHwHyI@IFIJIMIVIZI[I]IaIfIhIiIsItIuIwIzI~JD"},
  {0,NULL,"JJJMJTJ^JdJkJlJsJvJyJ}K@KDKIKNKOKWKXKYK]KeKfKhKjKnKpKr_A?H?N?S?V?"},
  {0,NULL,"a?d?k?n?p?q?t?w@?@@@A@E@M@R@S@W@Y@\\@d@g@k@s@t@}ABAIAKASATAWAYA_Aa"},
  {0,NULL,"AeAfAhAjAqArAsAzA{BEBLBPBQBTB\\B_BaBcBfBgBkBnBrBvByB{B}C@CNCUCYC_C"},
  {0,NULL,"hCnCrCwCyCzC}DBDMDSDWD\\DdDkDmDrD}E?EEEJEQESETEYE[E]EbEfEiElE|F?FB"},
  {0,NULL,"FCFGFIFQFVFWF[F_FaFdFeFuFwF~GBGEGFGGGIGXGYG_GaGcGtG|H@HAHBHFHGHKH"},
  {0,NULL,"NHOHUH]H^HkHmHrHtHvHxI@IAIDIGIQIYI[I]I_IbIeImIsItIuIxIzI~JKJSJUJZ"},
  {0,NULL,"J]J_JhJjJqJtJuJ{J|J~KHKJKNKOKWKXK_K`KbKgKmKoKsKt_A?H?N?S?Y?]?e?k?"},
  {0,NULL,"n?p?q?t?w?{?|?~@F@O@R@Z@\\@^@a@c@g@k@s@tA?ACAIAJARASAWA^A_AaAeAfAh"},
  {0,NULL,"AjAqArAsAzA{BEBLBQBRBUBXB\\BbBdBkBnBqBsBtBuBvByB|C@CRCUCYC]C_CnCoC"},
  {0,NULL,"tCzC{C|D@DIDNDODXDbDnDsDtD}EBEEEOERESETEVEWE\\EbEcEnErE}E~FAFFFHFL"},
  {0,NULL,"FOFXFYFZF`FfFgFjFqFvFxFyF~GDGGGOGPGQG\\GhGsGuGzG{G}HCHDHHHIHJHMHRH"},
  {0,NULL,"`HfHoHpHrHsHuI?I@IHIKILIXI[I\\I^IcIiIkImIqIsIuI{I}JAJGJIJPJRJ[JbJj"},
  {0,NULL,"JlJmJoJtJuJ{J~KGKLKRKVKZK\\K^KaKcKhKjKlKnKrKu_A?J?P?R?W?]?c?j?l?t?"},
  {0,NULL,"u?v?z?{?}@@@D@N@R@T@W@Y@\\@`@f@m@n@u@|AEAGAJANAPARA\\A^A`AdAeAgAmAp"},
  {0,NULL,"AsAtAxA|A~BKBWB[B^B`BaBbBeBfBgBiBmBnBwByBzB}CBCDCGCYCZCeCtCxCyCzC"},
  {0,NULL,"{C~DEDGDLDUDWD`DgDiDtE?EAEDEIELEOEPEUEVE[E`EeEpEsEvEzFAFDFMFNFSFX"},
  {0,NULL,"FZF^FbFeFfFhFqFrFtG@GAGFGHGMGRGTG`GeGiGrG|H?H@HAHDHMHNHOHPHWH]HfH"},
  {0,NULL,"lHoHpHrHxH}H~ICIGIMISIYI`IcIgIhIiIlIrIsIvIyI|I~JFJOJPJXJ_JfJhJiJp"},
  {0,NULL,"JqJwJxJ|KCKFKNKPKSKUKXK]K^K_K`KaKbKhKi_A?I?K?S?U?`?c?j?l?o?s?u?x?"},
  {0,NULL,"{@?@E@F@M@O@U@Z@[@_@d@e@h@p@r@{@|AGAIAQASAWA_A`AaAiAkAmAnAsAtAuAv"},
  {0,NULL,"B@BABIBOBUBXBYB]B_BcBfBhBjBlBmBqBrBxB|CFCJCMC[CcCkCrCtCuCvC{DBDCD"},
  {0,NULL,"IDWDXD\\DbDkDrDtD~E@EDEHEJELEMEQEVE\\EbEhEmEpE|E~FAFBFGFIFRFYFZF]F`"},
  {0,NULL,"FaFeFgFsFxFzG?GBGDGEGIGQGYG\\GbGgGqGyG}G~HBHDHEHFHIHOHSHXHYHiHqHsH"},
  {0,NULL,"vHzH}H~ICIJIVIWI`IdIeIfIiIjIoIrIsIuI|J@JBJEJHJOJWJ^JfJiJjJtJuJxJ{"},
  {0,NULL,"J~KBKIKOKRKXKYK\\KaKbKcKeKkKmKnKsKvKzK{_A?H?K?S?Y?_?`?k?n?s?x?y?z?"},
  {0,NULL,"{?|?~@F@M@O@V@Z@]@`@d@g@h@o@q@~AAAFAKAMAOAUAXAZA]AgAiAnAoApAqArA}"},
  {0,NULL,"B?BFBJBPBRBTB[B`BbBeBfBgBiBlBoBrBwBxB}CDCHCKCaCiClCpCqCsCwCzC|D?D"},
  {0,NULL,"JDLDPDYDaDeDfDoE@ECEDEIENERESEXE[E_EbEcEoEpE}E~FAFBFHFRFXFYFZF]F`"},
  {0,NULL,"FfFgFjFrFxF}G@GBGDGEGOGPGQG\\GhGiGsG}H@HBHDHEHFHIHJHKHRHZH`HnHqHrH"},
  {0,NULL,"sHtHzH~IBIIINIUI]I`IdIgIiImIoIqIsIuI}JAJBJEJFJHJQJaJcJhJkJsJvJwJy"},
  {0,NULL,"KCKDKGKLKMKTKVKZK`KdKgKiKkKmKqKtKu_A?J?O?Q?T?`?d?k?n?q?r?u?z?|@B@"},
  {0,NULL,"C@E@N@Q@T@U@^@_@c@f@l@n@v@~ABAGAKALAQAYA\\A]A`AdAeAkAoApArAsA|A~BC"},
  {0,NULL,"BDBSBUBVBWBZB^BdBgBjBmBoBsBtBuBvBzB~CCCPC[CdCfCrCsC|D@DBDCDEDKDPD"},
  {0,NULL,"RDSD_DaDhDkD|D}ECEKEQETEVEXE^E_EaEgElEoExEyFBFDFIFMFNFSF]F^F_FcFg"},
  {0,NULL,"FiFqFtFvF{F|G?GCGJGKG[G^GdGjGkGzG~H?HAHCHFHHHJHLHVHYHdHmHuHwHzH}H"},
  {0,NULL,"~I@IBIGISITI_IaIeIgIiIkInIqIsItIzI}J?JFJOJUJYJ]JaJgJhJrJzJ|K?KAKC"},
  {0,NULL,"KFKJKPKSKTKUKbKhKiKjKkKnKoKrKxK|_A?I?N?S?U?[?a?j?l?p?r?v?w?{@?@E@"},
  {0,NULL,"F@M@P@S@T@Y@b@d@e@k@x@yA@ACAFAHAMAOAUAVAZAbAdAfAhAlApAtAuAyBBBHBM"},
  {0,NULL,"BRBUBVBXBZB^BbBgBnBpBsBtBuBzB{B}B~C?CTC`CbCjCpCqCuCxC~DADCDPDTDYD"},
  {0,NULL,"[DfDlDoDpD}E?EBEIEKELEMENEZE^EbEhEjElE|E~FBFCFGFIFQFRFWF]F`FaFeFg"},
  {0,NULL,"FwF|GAGBGCGEGFGIGQGYG\\GbGkGqG|HBHEHFHGHLHNHOHPHSHXHbHjHkHvHxH~I?I"},
  {0,NULL,"@IHILIOIRIYI[I_IcIdIeInIrIsIuIxI|J@JKJLJSJYJ[J\\JgJkJrJsJvJyJzKDKG"},
  {0,NULL,"KIKRKYKZK\\K]K^K_KdKfKiKrKtKvKyK~_A?J?M?R?T?`?b?j?l?o?q?r?y?~@?@B@"},
  {0,NULL,"C@N@Q@S@T@V@]@^@f@j@v@w@{ABAGAKALAQATAXAYA]AjAkAlAoApAsAuAwBCBDBG"},
  {0,NULL,"BQBRBSBWB\\B^BdBmBnBoBqBsBtBvBwBzC@COCQC^CgCiCrCsCxCyC|D?DCDHDVDXD"},
  {0,NULL,"ZD_DeDhDrD|D~EBEIEJEKEOEQETE_E`EgEmErE{F@FAFEFHFJFPFTFYF\\F`FcFdFi"},
  {0,NULL,"FuFwF}F~GAGGGHGSGUGWGZGaGlGuGzG}H?HAHGHKHLHNHOHZH\\HcHlHnHqHsHxH{I"},
  {0,NULL,"?IDIEIFIWIYI\\I^IdIhIjImIrIuIvIzJ?J@JGJQJVJWJ^JeJiJlJmJnJoJ}K@KBKE"},
  {0,NULL,"KKKOKQKWK[K]K^K_KiKmKnKpKqKuKw_A?I?K?S?X?Z?^?j?l?o?s?u?x?|?~@@@A@"},
  {0,NULL,"N@S@U@Y@_@a@c@e@h@p@rAAADAHAIASAWA[A_AaAcAiAkAmAnAsAtAuAvB@BABIBO"},
  {0,NULL,"BPBRBTBWB]BbBgBhBjBlBmBsBtBwB}CICJCMCVC[CcCoCvCyC}C~D@DCDMDNDODSD"},
  {0,NULL,"dDmDnDsD~ECEDEHEKELEOEWEYE]EbEdEqEtE}F?FCFFFKFLFOFUFVF[F_FdFfFjFs"},
  {0,NULL,"FvFwFyFzGFGHGOGPGXG_GfGmGvG{G|H?HAHCHGHHHLHPH_HdHeHiHlHtHwH|H~I?I"},
  {0,NULL,"IINIPITI]IaIcIdIfIhIpIsIuIvIwIyJ?JCJJJNJTJ`JaJgJjJtJuJ{J~K?KAKHKJ"},
  {0,NULL,"KLKMKTKVK]K^K_KgKiKjKlKoKzK{_A?H?M?R?V?\\?b?i?m?q?s?w?y?}@?@@@C@N@"},
  {0,NULL,"T@U@V@]@a@c@g@j@o@t@zA@AFAJANAPARAUAZA^AfAiAjAoAqArAtAzBEBFBJBNBU"},
  {0,NULL,"BXBYB[B]BeBhBjBmBoBtBuBwBxB|C?CFCLCVCfCmCoCwC~DADBDDDEDGDMDRDWD`D"},
  {0,NULL,"gDpDqD|D~EGEMEUEYEZE[E\\E^E`EfEiEmEzF@FAFEFHFPFTFXFYFZFdFeFhFiF|F~"},
  {0,NULL,"GAGBGEGGGHGMGSGTGUGnGqGxGzH?HFHGHHHKHLHOHPHQHVHeHnHqHuH{H|H}I?IBI"},
  {0,NULL,"HINIXI\\I^IdIjIlInIoIqIrIvIwIxIzJEJGJIJQJ]J`JhJjJqJtJuJwJ|KCKGKLKS"},
  {0,NULL,"KUKVKZK^KbKfKgKhKkKlKqK{K|K~_A?J?O?Q?W?\\?]?k?n?q?r?u?z?}@A@D@F@N@"},
  {0,NULL,"P@T@W@`@b@d@f@l@n@v@|A?AGAJALANAQA\\A^A`AdAeAkAoApArAsA|A~BCBDBOBT"},
  {0,NULL,"BWB]B^B`BaBgBiBlBmBtByBzB{B}CCCMCPC`CdCfCqCrCzC{C~DDDEDFDNDQDTD`D"},
  {0,NULL,"bDiDjD}EAECELEPEVE[E\\E]E_EaEeEnEqEuEwFEFFFJFLFPFTFUF\\FaFbFhFjFsFu"},
  {0,NULL,"FzF{F}G?GEGLGNGVG]GgGmGpGyG{H@HBHEHIHNHOHPHQHbHgHkHtHuHyHzH{I?IFI"},
  {0,NULL,"KIOIWI\\I_IaIfImIoIpIqItIuI|I~JAJCJDJGJVJ[JdJgJlJoJrJzJ}K?KAKEKIKK"},
  {0,NULL,"KQK[K\\K^K`KcKfKgKmKpKtLA_A?I?O?Q?U?[?\\?i?m?r?u?w?x@C@D@E@F@P@R@S@"},
  {0,NULL,"W@Y@`@b@e@l@r@x@~A@AFAHAOAVAZA[AbAcAdAhAiAkAqAtAuAvAyB@BHBQBRBSBV"},
  {0,NULL,"BZBbBdBnBsBuBvBwByBzB{B}CHCOCRCWCeChCpCtCuCwCxC}DADGDIDVD\\DcDfDlD"},
  {0,NULL,"qD|D}EAEIEJEMENEREWEZEaEhEmEnEwEyFEFFFKFLFOFTFUF\\FaFcFgFhFsFuFxFz"},
  {0,NULL,"F}G@GDGKGVG]G^GlGoGsGyG|H@HBHDHIHKHNHPHWH^HhHlHmHoHtHuHyH{INIQISI"},
  {0,NULL,"TIZI\\I^IaIgImIpIqItIvIxI|JBJCJIJJJVJ]JfJiJjJnJpJuJxJ{KBKHKJKMKPKT"},
  {0,NULL,"KUK]KaKdKgKhKoKpKsKwLB_A?I?L?Q?X?_?b?i?m?o?p?s?v?|?}@A@B@O@P@Q@Z@"},
  {0,NULL,"\\@^@b@e@i@p@y@zAEAFAGALAMAQAUA\\A`AfAlAmAnArAtAuBABBBIBMBVBZB\\B_B`"},
  {0,NULL,"BaBcBfBkBpBqBuBvBxByB{CACBCNC]C^CaCsCtC|C}C~D?DDDFDNDRDSD`DaDhDjE"},
  {0,NULL,"EEFEGEJEKEPEUEWEXE[EaEdEiEtEuExFBFEFGFIFJFPFRF]F_FbFiFjFqFrFsFtFw"},
  {0,NULL,"FzGFGJGLGNG[GeGtGwGyGzG{G|HAHDHJHMHPHRHTHcHjHkHmHnHoHqHsICIHIJIRI"},
  {0,NULL,"YIZI[IbIgIjIoIqIrItIwIyI{JEJKJLJWJ`JbJgJjJrJtJzJ~K?KAKFKIKRKSKYK\\"},
  {0,NULL,"K^KaKdKkKnKoKpKtK}L?L@LD_A?H?M?R?Y?^?e?i?m?q?s?w?y?{?~@B@D@P@R@X@"},
  {0,NULL,"[@\\@a@c@g@j@o@t@{A?AIAJANAPARASA^A_AfAiAjAoAqArAtAzBEBFBJBQBUBWBX"},
  {0,NULL,"BZB\\B^BjBkBnBpBtBuBvBzB|C?CFCPCVCXCmCoCpCtCvCzD@DDDKDLDUDYD^DiDsD"},
  {0,NULL,"tD|EBEGELESEVEWEXEZE\\E`EcEjEoEvE{FCFDFNFQFVFWF[F^F`FbFcFfFrFzF{G?"},
  {0,NULL,"G@GBGEGRGWGZG`GbGjGpGyG{G~H@HBHCHDHEHMH[H_HaHiHjHmHwHxH{H|IAIDIFI"},
  {0,NULL,"VIZI_IeIhIjInIpIrItIvI{JAJBJMJSJTJUJcJeJhJkJqJsJwJ|KCKDKEKNKOKQKW"},
  {0,NULL,"KXK_K`KaKdKeKjKoKpKyKzK|_A?I?L?Q?U?c?e?i?m?o?p?s?v@C@D@E@F@O@U@V@"},
  {0,NULL,"W@Z@_@`@e@i@p@y@{@}AGAIALAQASA\\A`AaAfAlAmAnArAtAuBABBBIBMBOBSB[B]"},
  {0,NULL,"B_BcBdBfBhBiBjBkBlBoBqBxCACNCQCZC]CaCtCzC{D?DADBDCDKDPDQDTD_DbDiD"},
  {0,NULL,"kE@EFEGEJELENEQETEUE\\EaEhEjEkEwEyFDFFFKFLFMFNFOFUFaFcFgFhFuFwF|F}"},
  {0,NULL,"F~GCGFGKGVG]G^GcGlGoG}G~H@HFHGHIHKHLHNHWH`HhHnHoHpHrHwHyH|IAIEIII"},
  {0,NULL,"PIZI\\I]IbIhIkIlIqItIvIxJ@JBJNJRJTJXJ\\JcJgJkJrJsJyJzK?KAKHKJKKKMKQ"},
  {0,NULL,"KTK`KbKcKfKiKjKlKqL?LBLD_A?I?N?S?X?]?b?j?l?p?r?v?w?|?~@@@A@O@P@X@"},
  {0,NULL,"Z@a@b@c@e@k@x@yABAEAFAGALAMAOAUAZA\\AdAfAhAlApAtAuAyBBBHBMBNBPBTBV"},
  {0,NULL,"BZB_BcBfBkBpBqBrBuBzB{B|B~CSCTC`CbCmCsCuCvC~D?DDDEDJDLDZD]DaDeDgD"},
  {0,NULL,"jE?EBEEEHEKEMEPEUEXE_EbEdErEsE}F?FAFFFHFKFLFOFUFXF_FdFfFjFvFxFyF{"},
  {0,NULL,"F|GCGDGOGPGXG_GdGfGvGyG{G}G~H?HCHDHHHJH_HeHgHiHpHrHuHvH{I?IAIEIQI"},
  {0,NULL,"SI^IcIeIfIkIlImIsIuIvIyI{J?JIJRJVJXJ_JeJiJkJnJpJsJvJyKDKHKJKMKNKT"},
  {0,NULL,"KWK`KcKeKhKkKpKqKsKyK~LELH_A?H?P?R?Y?[?_?i?m?p?t?x?z?{?~@B@D@M@V@"},
  {0,NULL,"X@[@]@_@d@g@m@q@s@~AEAFAKAMAOATAXAYA]AeAgAhAnAqArAuA{A}B?BLBOBPBT"},
  {0,NULL,"BWB[B^BeBgBhBiBlBmBrBwBxB{CCCICSC\\CjCkCoCpCqCuC|D?DBDFDODVDXDcDeD"},
  {0,NULL,"hDoEAEDEFEKENEREXEYE\\E_E`EcEnEtEvE{FCFEFJFQFVFWF[F\\F`FbFcFfFvFyF{"},
  {0,NULL,"F~G?GCGGGRGWGZG`GjGpGvGyGzG}G~HCHEHFHHHKHSH[HaHjHkHlHvHyH|H}IGIJI"},
  {0,NULL,"MIQIYIaIbIfIlInIpIrItIvI{I}JBJDJJJKJZJbJfJjJlJmJoJ{J}J~K@KFKNKOKP"},
  {0,NULL,"KWKXK]KbKfKlKnKqKsKtKxKyKzLA_A?J?L?Q?T?Z?e?k?n?o?t?v?y?|@B@C@E@M@"},
  {0,NULL,"U@W@X@[@_@`@f@i@u@w@zACAHAJAPARAVA[AbAcAgAjAlAmApAqAsAwAxBGBKBNBP"},
  {0,NULL,"BVBYBZB`BaBfBhBiBlBpBrByB{B|CECLCTCXC\\CcCoCqCrCvCwCxD@DHDIDVD]D^D"},
  {0,NULL,"lDnDqE@EEEFEMEOESEZE]E^E_EaEgEkErExEyFDFFFKFMFNFOFSF^F_FcFgFiFuF|"},
  {0,NULL,"F}GAGBGCGHGJGKG[G^GdGkGxG~HEHFHHHIHKHLHNHOHYHaHdHiHkHoHrHwHzH|ICI"},
  {0,NULL,"MIRIXIZI]I_IcIkIlIoIqIsItIzI}J@JMJNJPJXJ^JbJiJlJmJnJpJxK@KBKFKPKR"},
  {0,NULL,"KSKUKYK]K`KaKeKgKlKmKtKvKxK|LE_A?J?P?R?T?Z?[?j?l?t?u?v?z?~@?@B@C@"},
  {0,NULL,"O@V@W@X@[@]@`@f@m@n@uACADAHAJANAPARA[A^AbAdAeAgAmApAsAtAxA|A~BKBN"},
  {0,NULL,"BQBYB\\B`BaBcBfBhBiBkBpBrBxByB}CBCGCUCZCeClCsCvCwCxC{D@DADKDMDRDYD"},
  {0,NULL,"^DpDqDsE?EDEFEMEOEPEQESEWE^E`EgElEtE{F@FCFEFJFPFTFWF[F\\F`FcFdFiFq"},
  {0,NULL,"FtF{F~G?GDGGGSGUGWGZGaGuGwGzG}G~HCHEHGHIHJHKHZH\\HhHjHlHpHqHtHvHyI"},
  {0,NULL,"KIOIPIUIYI[I^I`IbIfIpIrIuIvI}J?J@JCJDJLJZJ\\JaJgJhJqJwJzJ|K?KCKEKK"},
  {0,NULL,"KLKQKZK[KcKdKeKfKgKjKkKsKwLCLDLG_A?H?P?Q?X?_?d?i?m?p?t?x?z?|?}@A@"},
  {0,NULL,"B@H@I@K@S@T@Z@[@e@l@q@xA?ADAIAJAUA[A^A_A`AbAdAhAiAkAvAwA{A~BFBGBM"},
  {0,NULL,"BOBRB]B`BaBbBeBqBsBwC?CECFCYC\\C^C_C`CaCfCgChCnCrCvDADKDLDUDYD^DjD"},
  {0,NULL,"kDnDpDrDuD|EBEGEHENEOEPEQETE_E`EcEnEtEvExFEFFFHFLFMFVF[F\\F`FbFcFf"},
  {0,NULL,"FvFyF{F~G?GCGGGIGKGLGMGOGWGYGlGoGtG~HEHOHSHUHVHXH[H`HbHfHgHkHlHsH"},
  {0,NULL,"|INIQISITIYIcIdIfIiInIoIxI|JBJDJJJKJNJPJQJWJeJfJgJjJoJsJ|J}J~K?KL"},
  {0,NULL,"KMKRKUK[K\\K^KaKcKdKgKjKoKpKuK{LBLDLELFLGLL_A?J?O?S?Y?]?`?k?n?q?r?"},
  {0,NULL,"u?z?{?|?~@F@G@I@J@U@V@\\@b@g@k@s@vA?ACAHAJARAWAXAZA_AbAeAfAhAjAyA|"},
  {0,NULL,"B?BABEBGBIBQBRBUBXB\\BbBdBkBvBxCECLCMCYCZC[C]CaCbCeCiCjCnCoC{C~DHD"},
  {0,NULL,"IDVD]D`DbDgDnDoDsDuE@EEEFEKENEPETEUEWE\\EaEgElEoEyE}FBFCFIFJFNFUFW"},
  {0,NULL,"F^F_FcFgFiFqFtFvF{F|G?GCGJGMGQGTGVGXGZGcGiGtHHHLHPHQHSHVHXHYH\\HfH"},
  {0,NULL,"gHhHmHqHwH~IAIDIGIQI^IdIgIjIkInIpIxIzI~JCJEJFJTJUJWJYJ]JbJhJkJpJr"},
  {0,NULL,"JzK@KCKDKEKHKLKOKZK\\K_K`KdKeKfKgKmKtKvKzK~L@LDLGLKLL_A?I?L?R?V?b?"},
  {0,NULL,"c?i?m?o?p?s?v?}@?@@@C@I@K@L@^@`@c@d@g@m@q@y@}ADAHAIARATAWAXAZA[Ae"},
  {0,NULL,"AgAhAnAxAyBABCBDBJBLBNBPBQBTBVBYB\\BgBtB{CHCQCRC[C^CcCdCeCfCkClCmC"},
  {0,NULL,"nCpC{DCDHDJDUD]D_DbDdDfDpDtDuD|EAECELEPETEVEXE]E^EaEdEiEtExEzFCFE"},
  {0,NULL,"FGFIFJFNFUF[F_FbFiFjFqFrFsFtFwFzGFGNGQGUGXG\\G^G`GjGpGqHIHJHMHRHWH"},
  {0,NULL,"XHZH\\H_H`HcHdHkHmHqI?IGIJIMIQI[I]I^IcIgImIoI{I}JBJEJGJKJLJNJUJVJb"},
  {0,NULL,"JdJhJjJqJtJxJzK?KDKHKKKLKPKVKWK_KbKfKgKjKlKqKsKvKwKzLBLCLHLJLLLN_"},
  {0,NULL,"A?J?M?S?U?`?a?j?l?o?q?r?y?{@?@E@F@G@J@K@\\@]@_@b@e@k@v@yA@ACAHAJAR"},
  {0,NULL,"AUAZA_A`AbAdAfAhAlAwAyA}A~B?BABEBRBUBVBXBZB^BbBlBzB{CBCGCKCXCYC[C"},
  {0,NULL,"\\C]CbCiCjCkCnCqC~DADKDMDRDYD`DbDlDmDoDpDuE?EDEFEKENETEYEZE\\E]E`Eg"},
  {0,NULL,"EmErE{E|FAFFFHFMFOFTFVF\\F`FcFdFiFuFwF}F~GAGGGHGKGLGNGUG\\G_G`GfGgG"},
  {0,NULL,"vGzHGHMHRHTHZH]H`HaHbHcHdHlHsHzH{IAIEIQISIYIZI\\I_IgIiIjIyI{J?JFJG"},
  {0,NULL,"JHJJJMJVJWJ\\JeJiJjJmJoJqJuK?KBKGKNKRKTKUKYKaKcKeKgKhKkKlKsKxK{K}L"},
  {0,NULL,"CLELILKLLLM_A?I?O?R?Y?[?^?i?m?r?u?w?x?{?~@B@D@H@K@L@M@Q@W@a@g@j@o"},
  {0,NULL,"@x@{A?AGAIAMANAQASAYA^AfAiAjAoAxAzA}B@BBBCBKBQBUBWBXBZB\\B^BrBuB|C"},
  {0,NULL,"ACGCNCVCXC[C\\C^CcCeCiCjCvCyCzDDDKDPDQDTD^DdDeDiDjDmDtE@EFEGEHEIES"},
  {0,NULL,"EVEZE]E_EaEhEmEnEvEyFAFEFLFOFRFSFTFYFaFcFgFhFsFuFxFzF}G@GDGQGTGXG"},
  {0,NULL,"ZG[G]G_GnGvGxH@HAHNHTHUHXHYHZH\\H^H_HhHlHoHuHvIBIHINIXIYIZI[IaIeIi"},
  {0,NULL,"ImIwIxIzJIJJJLJOJPJVJZJ]JcJjJlJnJoJyJ{KAKBKEKOKSKXKZK\\K^KbKcKfKlK"},
  {0,NULL,"mKnKqKvK{K}LALCLDLHLJ_A?J?O?S?Y?]?`?k?n?q?r?u?z?{?|?~@F@G@I@J@U@V"},
  {0,NULL,"@\\@b@g@h@n@o@~AAAHAKAOARAWAXAZAcAgAiAnAoAxB?B@BBBCBEBMBPBRBTB[B`B"},
  {0,NULL,"bBeBiBkBxB~CECLCVCYC]C^C`CaCcCgCiCpCsCwDCDGDJDUD\\D_DaDfDoDqDrDsE@"},
  {0,NULL,"EEEGEJELENEQEWEXE[EaEeEnEqEuE~FCFFFIFJFNFUFVF\\FaFbFhFjFsFuFzF{F}G"},
  {0,NULL,"?GEGIGJGPGSGUGVG`GcGtGuHBHLHPHQHTHVHYHZH]H_HeHgHkHpHyI?IFIJIMIVI\\"},
  {0,NULL,"I`IcIlInIoIpIwIzI~JCJDJGJKJRJXJYJcJdJjJlJoJqJ{K?KAKBKGKNKPKTKVKYK"},
  {0,NULL,"]KhKjKlKnKoKrKsKwKxKyK{L?LBLELJLOLP_A?J?P?S?X?Z?]?j?l?t?u?v?z?|?~"},
  {0,NULL,"@@@A@G@J@L@P@R@U@V@e@k@u@xABAEAGAKALAMAOAYAaAcAdAfAhAlAwA{A~B@BBB"},
  {0,NULL,"FBJBNBPBTBVBZB_BcBjBpBuCDCOCQCVC_C`CcCdCfChClCmCuCzD?DEDHDVDXDZDa"},
  {0,NULL,"DbDcDeDgDiDmD|D~EBEMESEUEVEXEYE\\E`EgElEtE}F@FBFCFIFJFPFWFZF^F`FcF"},
  {0,NULL,"dFiFqFtF{F~G?GDGGGJGTGVGZG\\G]G_GbGmGqG}H@HKHUHVHWHYH\\H^HfHgHhHjHq"},
  {0,NULL,"HtHwIHILIOIRIZI]I^IbIgIkIpIxI|J@JCJEJFJLJMJTJZJ\\JeJgJjJoJqJ|J~K?K"},
  {0,NULL,"BKFKGKJKNKTKYK]K^K_KbKiKnKoKtKzK|L?L@LALBLFLJLR_A?I?K?R?W?^?c?j?l"},
  {0,NULL,"?o?s?u?x?{?}@@@D@J@K@L@M@W@^@c@f@m@r@u@|AEAFAGAMANAPAVA\\A]AdAeAgA"},
  {0,NULL,"mAzA|A}BEBGBHBIBWB[B^B`BaBbBeBvByB}B~CFCTCVCYCZC\\C]C_CaCgCjCtCxDB"},
  {0,NULL,"DEDJDLDZD]D_D`DcDgDkDlDtE?EBEEEJEOERETEVEYE[EbEdEqEtEzE}FCFEFGFJF"},
  {0,NULL,"LFUFYF[F_FdFfFjFsFvFwFyFzGFGHGKGNGQGRGSGXG^GaGoGuH?HFHHHRHWHXHYH["},
  {0,NULL,"H_HaHcHdHmHtH|I?IKIOIPIUI]I_IaIcIgInIoI}J?J@JCJEJGJJJNJSJUJ_JaJgJ"},
  {0,NULL,"lJnJyJ{J}J~KAKEKFKIKSKXKZKcKeKfKkKnKpKsKtKxKyK}LDLFLILJLLLQ_A?H?K"},
  {0,NULL,"?Q?W?\\?_?k?n?s?x?y?z?}@A@D@F@G@H@I@O@S@T@X@f@i@o@u@}AAAIAKAQATA[A"},
  {0,NULL,"^AaAcAgAjAlAmAwAyAzA}A~BHBIBNBOBSBXBYB]BdBpBzB|C@CHCUCWCZC\\C]C`Cb"},
  {0,NULL,"CfCjCkCpCyD?D@DMDSDWD\\DeDfDhDiDmDsDuD}E?EEEHEIEKELEUEXE^EbEfEkEqE"},
  {0,NULL,"uE|FDFFFKFMFQFVFXF]F_FaFdFeFrFtFvFwFyG@GFGMGWGZG[G\\G]G_GdGkGpG}HA"},
  {0,NULL,"HGHRHVHWHXHZH[H\\H^HhHiHyH{I@ICIMIRIXI[I\\I^I`IfIhIjIzI}J@JDJHJIJMJ"},
  {0,NULL,"TJVJYJ^J_JgJlJsJyJ|J}J~KAKKKMKRKUKVK[K`KcKgKiKlKmKoKtKuKxKzK~LBLD"},
  {0,NULL,"LHLKLM_A?J?L?S?V?Z?a?k?n?o?t?v?y@?@@@A@E@G@H@J@P@R@]@_@g@k@t@u@}A"},
  {0,NULL,"BAGAKALAMANASAYAaAeAfAhAjAvA{A|B@BBBFBGBPBQBTB\\B_BaBcBnBwByCCCJCP"},
  {0,NULL,"CWC^C_C`CcCgChClCmCuCyCzDBDKDPDRDSDcDgDiDkDmDoDrD|D}ECEIEJEMENESE"},
  {0,NULL,"UEYEaEgEkErExE|FAFFFHFMFOFRFSFTF_FcFgFiFuF|F}GAGBGCGHGKGLGQGRGUGX"},
  {0,NULL,"G`GhGrGsGyG~HFHZH[H]H_HaHbHcHdHeHiHlHoHzIHIKILIXIYIZI_IfIjIlIpI{I"},
  {0,NULL,"}JAJCJHJJJMJPJWJXJ]JbJkJlJnJpJrJyK@KCKHKKKLKOKWK\\KcKhKiKjKnKpKqKr"},
  {0,NULL,"KuKwKyK{L?LALHLILQ_A?H?K?Q?W?\\?_?k?n?s?x?y?z?}@A@D@F@G@H@I@O@S@T@"},
  {0,NULL,"X@f@l@q@v@|A?AIAJAQATA[A^A_A`AdAeAkAoAvAwA~BBBJBLBMBOBTBWB]B^B`Ba"},
  {0,NULL,"BgBpBzC@CACUCVC\\C`CaCbCfCgChCmCrC{DADDDIDNDODXDbDiDjDpDqDrDuD}EBE"},
  {0,NULL,"EEHELEMENEPEZE_EbEcEoEpEwE}FBFDFKFQFXFZF]F^F`FfFgFjFrFxF}G@GBGDGE"},
  {0,NULL,"GNGRGSGUG\\G^G_GdGkGnG}HGHIHQHRHTHZH\\H^H_HaHcHjHnHrH~IBIGISITIYI`I"},
  {0,NULL,"bIdIhImIpIzI}J?JFJHJKJLJQJTJXJ[JaJhJiJmJuJvJwJxKDKEKFKIKJKQKXK_Ka"},
  {0,NULL,"KbKeKhKjKnKrKvKwKyK{K|K}L?LG_A?H?N?Q?T?d?e?k?n?p?q?t?w?|@B@C@E@H@"},
  {0,NULL,"I@J@N@Y@Z@[@f@l@n@t@~ABAFAKALAOAPAVA\\A]AdAeAkAoBABDBHBIBJBKBLBSBU"},
  {0,NULL,"BVBWBZB^BdBhBmBtCDCKCNCWCXC[C]CcCdCeCjCkCsC}DBDEDJDLDPDYDaDdDgDhD"},
  {0,NULL,"kDqDuE@ECEDEHEKEMEQEVEWEYEbEcEnErExE~FEFFFGFHFLFYF[F\\F`FfFgFjFqFv"},
  {0,NULL,"FxFyF~GDGGGMGNGOGTGWGYG^GgGmGxG|HDHJHSHUHVHWH[H]H`HfHhHoHsH|I?IFI"},
  {0,NULL,"KIOIWIYIZI^IcIhIiInI|I~JAJGJIJKJNJPJTJWJ[JaJiJlJmJnJuJvJwJ{KFKIKJ"},
  {0,NULL,"KPKQKWK]K`KgKmKpKqKsKtKzK~LALDLELILJLKLT_A?I?O?R?Y?[?^?i?m?r?u?w?"},
  {0,NULL,"x?{?~@B@D@H@K@L@M@Q@W@a@g@m@r@s@~AEAFAGAMANASAYA\\A]AeAgAhAnAwAyAz"},
  {0,NULL,"A|A}BABGBOBPBTBWB[B^BeBlBrB|CACNCOCVCXCYCZC\\C`CbCgCjCuCxC|DBDFDND"},
  {0,NULL,"RDSDcDeDhDkDlDpDtEEEFEGEMEOEREVEYE^E_EaEdEoEsEuE{FAFDFOFRFSFTFXF]"},
  {0,NULL,"F_FbFiFjFqFtFxF|GCGDGGGIGPGUGYG[G]G`GbGnGxGzHAHNHSHTHUH]H^HeHfHgH"},
  {0,NULL,"hHiHnHxHzIIIKILIUI]I_IbIfIhIiImIwIxI~JHJMJNJOJQJSJVJbJdJhJkJpJtJx"},
  {0,NULL,"JzKCKDKKKNKPKTKVKWK`KaKdKhKiKkKoKpKuK|K~L?LELFLGLILV_A?I?L?R?V?b?"},
  {0,NULL,"c?i?m?o?p?s?v?}@?@@@C@I@K@L@^@`@c@d@g@j@p@t@zA@AFAHAPARAVAWAXAZAf"},
  {0,NULL,"AiAjAoA|A~B@BBBGBJBLBNBUBXBYB[B]BeBgBjBtCBCHCRCZC_C`CbCdCfCgCkCmC"},
  {0,NULL,"oCsCwC~DGDIDVD\\D`DaDdDeDnDpDqD|D}EAEKEQE[E\\E]E^E_EaEhEjEkEwF@FCFD"},
  {0,NULL,"FIFJFKFNFQFUFaFcFgFhFuFwF|F}F~GCGFGIGNGOGPGTGZG^GfGjGpHIHJHKHRHSH"},
  {0,NULL,"WH]H`HbHcHeHfHpHwHyH~IAIDIFIVI[I\\I]I`IdIiIkI{JAJBJDJFJLJNJOJRJTJ]"},
  {0,NULL,"JcJkJlJnJrJyJ{K@KAKEKGKSKXKYKZK]KaKdKeKoKpKrKtKuKxKyL@LELFLGLKLNL"},
  {0,NULL,"RLT_A?H?M?Q?U?\\?e?i?m?q?s?w?y@C@D@E@F@H@I@L@N@O@X@Y@e@i@o@y@{@}AI"},
  {0,NULL,"AKALAOAQATAaAcAfAlAmAnAwA|A~B?BEBHBIBOBSB[B]B_BcBdBfBxB}CICPCSCWC"},
  {0,NULL,"YCZC\\C]C_CbCeCfCzD?D@DCDHDQDZD[D_DeDfDiDkDnDsE?EAEFEIELEOEQESEUE^"},
  {0,NULL,"E`EfEiEmEyEzFBFEFGFPFWFYFZF^FdFeFhFiF|F~GAGBGEGGGHGJGOGPGRGSGVGYG"},
  {0,NULL,"eGsGwH?HCHLHQHUH]H_H`HaHbHeHgHqHtHuH}ICIHIJIRI]I^IaIdIeIfIlIwIyI{"},
  {0,NULL,"JCJDJEJIJOJQJUJ\\J`JiJjJmJqJuJvJwKBKFKHKIKJKOKQK_KaKdKmKnKoKpKsKuK"},
  {0,NULL,"wKzK}LALELFLGLSLWLX_A?H?P?Q?X?_?d?i?m?p?t?x?z?|?}@A@B@H@I@K@S@T@Z"},
  {0,NULL,"@[@e@i@p@s@zAEAFAJAPAUA\\A_A`AbAfAlAmAnAvB?BCBDBEBKBMBVBZB\\B_B`BaB"},
  {0,NULL,"cBkBqBsC?CCCFCXC^CaCcCdCgChCiClCqCtC|C~DGDMDRDWD`DfDhDjDnDoDtD|D~"},
  {0,NULL,"EGEIEJEKEOEPERE]E`EfEkEsEuF@FDFFFHFKFMFVFXF\\FdFeFhFiFrFsFvFyG@GAG"},
  {0,NULL,"HGJGMGQGVGWG\\G_GhGlGoHEHOHPHRHSHVHXHYH[H\\H^HdHpHzH{I@IAIEIIIPI[I_"},
  {0,NULL,"I`IcIeIfIjIxJ@JBJDJHJPJRJUJVJYJ\\J`JiJkJmJpJuJvJwK@KFKIKJKNKQKYK]K"},
  {0,NULL,"`KbKeKfKhKlKqKvKyK|LCLHLILJLKLPLWLX_A?J?L?S?V?Z?a?k?n?o?t?v?y@?@@"},
  {0,NULL,"@A@E@G@H@J@P@R@]@_@g@h@q@w@z@|AGAJAMANASAUAYA`AgAiAnAoAxAyA{BABCB"},
  {0,NULL,"FBHBSBUBXB[B_BcBeBnBoBwCCCPCTCWCZC[C_CbCeChCkClCvCxC|DDDFDNDQDTD^"},
  {0,NULL,"DgDhDjDlDrDsD}EAECEHEJEOEREUEWEZEaEeEiEpEwF?FAFBFOFPFRFSFTFZFaFbF"},
  {0,NULL,"hFjFqFsFtFyFzGAGHGIGKGLGPGTGWGZGaGhGsGyG{G~HSHWHXH[H\\HaHbHdHfHnHu"},
  {0,NULL,"HvHxIBIIINIUIaIbIeIhIjIlInI}JAJBJIJQJSJWJXJYJZJcJdJhJjJoJqJtJxK?K"},
  {0,NULL,"BKGKNKSKTKXKYK^K`KaKbKgKkKmKtKzK|K}K~LCLDLFLKLPLQLSLY_A?I?N?R?T?["},
  {0,NULL,"?b?j?l?p?r?v?w?~@?@B@C@G@K@L@Q@`@a@d@f@m@n@yACADAHAIAQARATAWA[A^A"},
  {0,NULL,"dAeAgAmAxBCBFBHBIBJBLBNBQBYB\\B`BaBcBfBiBoC?CJCMCWC^CdCeChCiCkClCm"},
  {0,NULL,"CpC{D@DADMDNDODSD^D_DbDcDfDpDsD~ECEDENEPERESETEXE^EbEdErEsE{F?FAF"},
  {0,NULL,"DFKFOFQFSFXF]F_FdFfFjFvFxFyF{F|GCGDGIGPGRGSGVG[G]GiGlGrG{HBHCHQHS"},
  {0,NULL,"HTHUHVHbHeHgHhHiHnHrH{ICIGIMISI_IbIfIjIkImIoIyI|I~JEJMJQJRJSJVJXJ"},
  {0,NULL,"_JaJiJlJmJnJvJyJ{KAKEKRKSKXKZK[K]K^K_KaKiKlKmKrKuKvK{K|L@LALBLKLQ"},
  {0,NULL,"LULWLZ_A?J?M?S?U?`?a?j?l?o?q?r?y?{@?@E@F@G@J@K@\\@]@_@b@e@h@r@w@{@"},
  {0,NULL,"|AGAJANASAUA_A`AbAiAkAmAnAyA{BABDBFBKBLBOBUBXBYB]B_BcBhBlB{C@CBCG"},
  {0,NULL,"CWC[C_CbCdCfCjCkClCrCtCvC|DGDLDUDWD^DaDbDhDlDrDtE?EAEDEHEJEREXEZE"},
  {0,NULL,"\\E_E`EeEjEqEzE~FCFFFHFMFNFUFVF\\FbFeFfFhFrFuFxF{F}G?G@GJGOGUGVGYG["},
  {0,NULL,"G`GfGkGvGzHDHMHQHTHUHYHZH]H^HcHgHkHpH|I@IIINIPITIZI[I\\I`IbInIoIwI"},
  {0,NULL,"yJ?JGJKJMJNJRJYJZJ`JfJgJkJpJrJsJ}K@KCKHKIKLKOKQK\\K]K^K_K`KfKiKjKp"},
  {0,NULL,"KyK|L@LALBLDLGLHLMLNLVL\\_A?I?K?R?W?^?c?j?l?o?s?u?x?{?}@@@D@J@K@L@"},
  {0,NULL,"M@W@^@c@f@j@p@vA@AAAFAHAPAVAXAZA\\A]AjAkAlAoAvA{A|BGBJBLBMBNBSBYB["},
  {0,NULL,"B_BdBeBqBvByB~CICTCWCYCZC_CfCgChCkCmCoCqCsC}DPDTDYD[D^D`DaDcDdDnD"},
  {0,NULL,"oD}E?EBEQERESEWE[E\\E]EbEhEmEpEvE|FAFEFGFLFRFTFYF[F`FaFeFgFsFxFzG?"},
  {0,NULL,"GBGDGEGJGMGQGWGXG[G]GaGeGuHEHFHHHQHTHVHXHYH^H_HdHhHoHsHvH}IDIEIFI"},
  {0,NULL,"WIZIaIeIiIkIlIoIzJ?J@JEJJJOJPJRJWJZJ[J^JhJiJtJuJwJxJzKDKKKMKPKUKV"},
  {0,NULL,"KWK]K^K_KdKgKhKiKqKwK|K~L@LALBLCLELOLXLY_A?H?M?Q?U?\\?e?i?m?q?s?w?"},
  {0,NULL,"y@C@D@E@F@H@I@L@N@O@X@Y@e@l@r@t@~A@AFAKALAOAVA]AaAcAdAhAiAkAxA{BD"},
  {0,NULL,"BFBHBIBKBQBRBSBVBZBbBdBfBnB}CICLCSCWCXCZC[C]CdCeCiClCuCwC}DEDFDOD"},
  {0,NULL,"VDXDcDdDfDgDjDkDqEAEDEFEIEMEPEQEVEWE[E`EcEjEoEwE{FBFDFPFQFWFZF]F^"},
  {0,NULL,"F`FbFcFfFrFzF{G?G@GBGEGKGLGRGSGXG\\G_GcGeGwGyH?HCHQHRHYHZH^H_HaHdH"},
  {0,NULL,"eHjHrHwHxILIOIVIWIcIdIeIhIkImIpIwI{J?JLJPJQJSJTJUJXJeJfJgJkJrJsJ|"},
  {0,NULL,"J}J~KCKGKMKRKTKUK[KbKfKiKkKlKqKrKtKvKxK~L?L@LCLHLJLSLU_A?H?N?Q?T?"},
  {0,NULL,"d?e?k?n?p?q?t?w?|@B@C@E@H@I@J@N@Y@Z@[@f@i@s@w@zACAFAJAPAUAVA\\A]Ab"},
  {0,NULL,"AgAjAlAmAvAzA}B@BDBKBMBNBPBVBYBZB`BaBhBmBrCDCKCRCVCXC[C^CaCcCdChC"},
  {0,NULL,"mCoCqCtCxDTDZD[D]DhDiDlDnDoDqDtD~E@ECEJEKELEMEOE\\E]EbEfEiElEyF?FB"},
  {0,NULL,"FEFGFLFPFWFYF[F_FaFdFeFuFwF~GBGEGFGGGOGRGSGYG[G]G`GgGjGmG|HDHNHQH"},
  {0,NULL,"THUH]H`HaHcHeHfHmHtHvH}IDIEIPIUIYI]I^I`IeIgIlIyI~JAJCJHJIJKJOJUJZ"},
  {0,NULL,"J^J_JgJhJsJtJzJ|J}J~KMKRKSKUKZK[K^KdKfKhKjKkKnKrKwKyK{L?L@LCLFLLL"},
  {0,NULL,"MLTL`La_A?I?N?R?T?[?b?j?l?p?r?v?w?~@?@B@C@G@K@L@Q@`@a@d@f@j@w@x@{"},
  {0,NULL,"ABAGAIAQASATAYA[A^AjAkAlAoAvAxAzA}B?BCBMBQBRBSBWB\\B^BdBiBoBsCJCMC"},
  {0,NULL,"SCVCXC]C^CaCeCiCjClCrCyD?DDDIDWDXD\\D^D_D`DeDjDmDrD~E@EDEIESETEUEZ"},
  {0,NULL,"E[E_EbEhEjElE~F@FCFDFIFKFNFQFXF]F`FaFeFgFwF|GAGBGCGEGFGIGLGMGNGPG"},
  {0,NULL,"WG^GiGrGwG{HBHOHSHWH[H`HaHbHcHeHgHjHyH~I@IBIRITIXI[I\\I_IaIdIkIpIy"},
  {0,NULL,"I|JAJDJFJJJLJRJSJYJ[J^JgJhJsJtJxJzJ|KDKJKKKPKQKVKWK`KbKcKeKjKkKoK"},
  {0,NULL,"sKxKzK}L?LGLHLILLLOLULWLY_A?J?P?S?X?Z?]?j?l?t?u?v?z?|?~@@@A@G@J@L"},
  {0,NULL,"@P@R@U@V@e@h@n@pAAADAHAKALAOAWAXAaAcAiAkAmAnAzB?B@BBBDBEBKBOBPBRB"},
  {0,NULL,"TBWB]BbBjBmBuCOCQCUCVCXCYC\\C`CaCcCiCmCwC}D@DCDFDODQD[D_DaDdDlDmDq"},
  {0,NULL,"DsD~EBEGELEWEXEYEZE[E^E`EeEpEsEvF?FAFBFPFRFSFWFZF^FbFeFfFhFqFrFtG"},
  {0,NULL,"@GAGFGHGKGLGOGTGYGZG^GbGdGqG|H@HKHRHWH[H\\H`HbHdHfHhHrHuHxH}ICIJIV"},
  {0,NULL,"IWI\\IaIbIgIhIlImI|J@JBJFJGJIJOJSJXJZJ`JfJiJkJpJrJvJwK@KCKHKLKMKOK"},
  {0,NULL,"[K\\KcKdKeKkKmKqKrKsKuKvKwKxK}K~LILLLNLVL[La_A?D?K?T?Z?[?\\?f?h?j?k"},
  {0,NULL,"?u?z@?@E@I@K@V@W@X@Y@\\@]@a@k@p@s@v@zA@ACAFALAMAQAYA]AaAjAlAqAtAxA"},
  {0,NULL,"|B?BABGBLBMBOBVBXBYBZB`BbBuBwB|B}CNCPCQCSCaCdCgCkCnCyD?DGDJDLDNDO"},
  {0,NULL,"DRDSDTDUDVDXD[D^DkDrDwDxD|EAEBECEGELEVEXEgElEoEtExE{E|FEFPFRFTFWF"},
  {0,NULL,"[F]F_F`FcFhFiFlFmFqF{GEGFGKGUGWG[GaGfGhGnGoGrGuG|G}HCHDHJHKHPHQHT"},
  {0,NULL,"HXH`HiHjHlHpHqHuIAIKIOI[I`IbIcIeIfIqIvJ@JAJDJLJNJOJRJXJ^JbJeJkJrJ"},
  {0,NULL,"zJ}J~K@KDKNKPKRKUKWKYK]KhKiKnKpKqKyL?L@LALFLJLSLVLYL`LaLb_A?F?M?X"},
  {0,NULL,"?_?`?b?g?h?i?l?o?s?~@B@H@J@O@Q@T@V@W@^@b@m@r@t@u@~ABAEAKARATAWA[A"},
  {0,NULL,"_AcAdAhApArAzA{BGBHBIBKBMBPBTBXBZB[B^B_BgBoBxBzCECMCRCUCWCXC_CcCn"},
  {0,NULL,"CxDADGDJDMDPDQDSDTDUDVDWDXD[D^DjDsDvDyD}D~E@EAECELE\\E]EdEiEqEtEuE"},
  {0,NULL,"{F?FBFIFJFPFQFVF]F_FbFdFgFjFmFoFsF~G?GFGLGPG[G_GeGkGlGrGsGwGxG|H@"},
  {0,NULL,"HFHJHKHMHPHYH^HaHfHkHmHnHoH{H~ICIJIKIYIZI[IjIlIpIqIsI{I|JIJKJPJRJ"},
  {0,NULL,"TJWJ_JdJeJlJnJqJ{J}J~KBKKKMKNKTKWK[K_KiKlKmKqKrKvKwKzLALBLJLOLRLS"},
  {0,NULL,"LUL^La_A?E?L?Y?_?`?b?f?g?i?n?s?y?|@B@J@L@O@Q@Y@Z@]@b@d@l@r@t@u@~A"},
  {0,NULL,"BAEAGARASA[A^A_A`AeAhApAuA{A|B?B@BFBIBKBPBSBVBWBYB[B^BoBqBzB{C?CG"},
  {0,NULL,"CMCUCVCZC_CcCnC{C}DGDIDLDQDRDSDTDUDXDZD[D\\D^DnDoDvD{D}D~E?EBEGELE"},
  {0,NULL,"ZE^EcEjEoEpEvExE~FAFHFMFNFRFXF]F`FbFdFfFgFlFnFtF|G@GEGOGQGWG`GaGf"},
  {0,NULL,"GhGmGoGsGtG}H?H@HAHBHIHNH]HdHeHhHkHrHsHtH{H~IBINIOI]I_I`IaIgIoIuI"},
  {0,NULL,"vIxI}JCJDJEJFJMJZJ[JbJfJgJrJtJxJ|J~KCKFKIKOKPKWK\\K^KaKcKjKnKpK{K|"},
  {0,NULL,"K}L?LFLGLMLVLWLYL_Lc_A?E?P?U?Z?[?\\?g?h?i?j?u?x@?@C@I@J@P@S@W@X@]@"},
  {0,NULL,"^@`@j@p@s@v@zA@ACAJAQASAYA^A`AaAfAlApAqAvA|BDBEBHBLBMBNBTBUBVBXBb"},
  {0,NULL,"BeBiBpBwB|C@CJCNCPCYC[CaCdCsCzD?DFDIDJDLDMDODQDRDTDUDXD]D_DfDrDvD"},
  {0,NULL,"wE@ECEDEEEGEHEVEYEhEmEnEpEwE~F@FFFKFOFTFXFZF\\F_F`FaFgFhFkFoFxFzGG"},
  {0,NULL,"GHGIGVG\\G^GdGiGjGlGoGtGwGyGzH@HDHHHMHNHRHVH]HdHiHjHmHoHuHyIDINITI"},
  {0,NULL,"^IgIjImInIpIsItIxIyJCJHJIJKJSJUJ[J\\JcJhJoJtJuJwJzK?KEKGKIKQKYKZK`"},
  {0,NULL,"KbKcKeKfKjK{K}LCLDLHLLLPLQLWL\\L]Lc_A?F?O?V?Z?[?\\?f?g?i?k?x?z@C@E@"},
  {0,NULL,"J@K@P@S@V@Y@Z@`@a@i@p@s@v@zA@ACAHAQATAWAYAaAcAfAjApAtAvB?BABDBEBF"},
  {0,NULL,"BGBNBUBWBYBZB`BeBiBpBuB}C@CJCQCSCYC[CgCkCtCyCzDFDIDJDLDMDNDQDSDUD"},
  {0,NULL,"VDYD[D_DgDkDvDxE?EAEBEDEEEHEXE_EfEkEqEsEyEzF?FCFKFQFSFUFWF^F_F`Fd"},
  {0,NULL,"FeFhFnFpFrFyF}GCGSGTGXGYGbGcGeGgGsGtGuG{HAHEHGHIHJHMHSHYHcHfHiHjH"},
  {0,NULL,"sHtHuI@IEIJIMIZIaIhIiIkIoIrIuIzI{JFJGJJJMJQJWJ]J_J`JiJmJpJuJ{K@KA"},
  {0,NULL,"KHKLKMKSKUKZK_KdKgKmKoKsKuKxKzLBLELKLNLULZL[L^Ld_A?G?P?U?[?_?a?g?"},
  {0,NULL,"h?l?m?p?v?{@D@I@J@M@P@S@X@]@c@d@j@n@p@t@~A@AAAKAQASAYA^A`AaAiAkAp"},
  {0,NULL,"AqAyA|B@BBBDBEBLBNBSBVBaBbBdBeBoBpBrBwC@CACMCPCYC]CcCdCoCrCvDFDHD"},
  {0,NULL,"JDKDMDODPDRDWDZD\\D]DiDlDtDvDwD~E@ECEEEFEPETEUEhEjEkElEvEyE|FBFMFQ"},
  {0,NULL,"FRFSFWF]FaFcFeFgFjFmFnFrFwF{F|GKGQGYG]GbGhGmGqGuGvGxH?HBHCHGHJHLH"},
  {0,NULL,"OHQHRHdHfHlHnHvH~I?I@IFIHIRIYI^I_IcIhInIqIuIwI|JCJGJKJVJXJYJ]J^Jf"},
  {0,NULL,"JlJrJ{J|J~K@KAKHKMKOKPKUKWKbKcKmKnKqKsKxKzK}L?LHLJLQLULVLaLcLdLeL"},
  {0,NULL,"gLi_A?F?M?X?Z?^?e?g?h?i?l?o?s?~@B@G@I@R@Y@[@_@a@c@d@m@q@v@yA?ACAD"},
  {0,NULL,"AJALAMANAUA\\A]AdAhAqAsAyA~B?B@BABCBJBQBRBSBYB]B`BaBhBnByB|B~CCCDC"},
  {0,NULL,"NCaCbCfCiCpCuDEDFDGDIDKDNDQDWDYDZD[D\\D]DeDhDmDwDzD}E?E@EEEGEJEQE["},
  {0,NULL,"EdEiEqEtEuE{F?FFFLFOFPFTFVF[F_FbFdFgFjFmFoFsF~G?GFGLGPG[G_GbGfGiG"},
  {0,NULL,"kGnGsGvG|H?HEHHHIHOHPHVHZH`HbHiHoHtHxH~I?IGIIIPIYI`IaIdIhIpIqIsIx"},
  {0,NULL,"J?JCJFJOJTJWJYJ_JdJeJhJqJsJzJ}K?KDKEKNKRKXKYK[K`KaKeKhKkKpKyLDLFL"},
  {0,NULL,"GLILLLMLPLTLYL]LbLe_A?D?K?T?`?c?d?f?h?j?k?u?z@?@E@H@L@P@T@U@Z@^@_"},
  {0,NULL,"@d@k@o@u@x@{@}ABAIAPARAZA[A_AbAjAlArAuAwAzA~B@BDBFBHBQBSBTBWB\\B_B"},
  {0,NULL,"eBgBkBlBqC?CBCLCRCVCWC\\CeCoCqCuDFDHDJDKDLDNDODQDWDYD\\D]DhDlDpDyD{"},
  {0,NULL,"EAEDEEEFEGEPEWE[EgElEoEtExE{E|FDFIFMFNFVF[F]F_F`FcFhFiFlFmFqF{GEG"},
  {0,NULL,"FGKGUGWG[GdGgGkGnGoGsGvG{H@HBHCHHHJHLHWH[H^HeHmHpHsHuHwHzIGIHISI["},
  {0,NULL,"IaIeIiImInIqIvIyIzJDJGJIJOJQJUJ^JbJeJjJqJxJ|J~KBKDKKKOKRKWK[K\\KaK"},
  {0,NULL,"cKeKgKlKmKvKzK}LGLKLLLMLNLOLPLULcLfLg_A?E?N?W?\\?]?b?f?h?j?n?q?r@@"},
  {0,NULL,"@A@H@K@N@O@P@_@`@b@c@h@r@s@w@z@|AEAFAOATAVAWAXAcAgAmArAtAvAyA{A}A"},
  {0,NULL,"~BDBKBQBUB[B^BaBcBeBfBtBuBxCECHCICQCXCgChCjCpCvD@DFDGDIDKDODPDRDX"},
  {0,NULL,"DYDZD\\D]DdDiDmDxDyD|E@EBEFEGENEQETEeEjEnEqEvEwF?FEFJFLFPFQFUFWFaF"},
  {0,NULL,"bFfFhFiFmFpFvFwF}G?GLGRGTG]GbGdGgGhGmGwGxGzHBHEHFHHHIHPHUHXHaHcHk"},
  {0,NULL,"HqHrHuHyHzIFIIIWI]I_IfIiImIpIqIrI~J@JDJFJHJPJUJVJ_JcJfJkJnJpJsJ{J"},
  {0,NULL,"}K@KMKNKSKTKUKXKdKhKkKqKrKsKwKxKyLELILJLRLTLZLaLbLdLfLi_A?E?N?W?^"},
  {0,NULL,"?a?d?f?h?j?n?q?r@@@A@I@L@M@Q@R@S@V@[@\\@h@n@o@y@}AAADAIANASAUA\\A^A"},
  {0,NULL,"`AgAmAqAuAxBBBCBEBGBIBJBNBOBPBRBZB]BdBlBnBrBsCACBCCCFC]CeCfCmCtCw"},
  {0,NULL,"CxDHDIDLDMDPDQDSDTDUDVDXDYDcDgDjDwD{D|D}EAEDEFEKE\\E_EeEjEnEqEvEwF"},
  {0,NULL,"?FDFLFMFOFQFSFVFaFbFfFhFiFmFpFvFwF}G?GLGRGTG]GaGiGqGrGsGwGxG}HDHE"},
  {0,NULL,"HGHIHLHMHRHVHeHhHpHqHvHxHzH|IBIJITIZI]I^IdIeIfIqIrIyI}JEJLJNJUJVJ"},
  {0,NULL,"WJ_JcJfJjJqJsJ{J|K?KAKEKHKMKOKXK[K^K_K`KaKbKmKzK|LBLDLGLHLMLQLUL]"},
  {0,NULL,"L^L_LjLk_A?G?P?U?]?c?e?g?h?l?m?p?v?{@D@G@H@N@Q@U@W@Z@\\@`@j@q@w@x@"},
  {0,NULL,"{@|A?AJAOAPAVAXAZAbAiAkArAsAvAwAxA}BFBIBMBOBPBUBWBXB\\BcBkBmBtByB~"},
  {0,NULL,"CHCKCLC\\CbChClCwCyC}DHDIDLDMDNDRDSDTDUDVDZD[DcDkDoDyDzD|D}E?ECEEE"},
  {0,NULL,"KEXE^EhEjEkElEvEyE|FFFLFMFNFUFWF[FaFcFeFgFjFmFnFrFwF{F|GKGQGYG]Ga"},
  {0,NULL,"GeGhGlGmGnGoGzG{HGHIHKHLHMHUHZH[HgHnHoHwHyH}I?IAIBIEI]IbIhIjIlInI"},
  {0,NULL,"qIuJ?JBJEJHJKJQJTJXJ]J^JfJhJpJsJxJ|K@KDKOKRKSKUKXK\\K]K^KaKdKgKhKy"},
  {0,NULL,"K|L@LELGLKLMLNLZL_L`LbLlLm_A?G?K?T?_?`?b?f?h?l?n?o?y?|?~@H@L@R@T@"},
  {0,NULL,"V@Z@]@^@d@k@r@t@u@~ABAEAFAPARAZA[A_AbAdAeArAuAzA|B@BCBFBGBHBSBTBV"},
  {0,NULL,"BWBZB]B_BgBqBxB{C?CECGCRCVCWCXCZCzC{DADFDIDJDLDMDQDRDTDVDWD[D\\D_D"},
  {0,NULL,"nDsDyD{E?E@EAEFEGEHEZE]EgEkEmErEyE}F@FEFHFJFKFUFYF\\FbFcFdFgFiFkFp"},
  {0,NULL,"FuFxFyGAGJGSGZG^GaGbGcGeGiGpGuGyGzG|HDHGHNHOHUHWH[H_HkHlHqHxH{H~I"},
  {0,NULL,"DIEILI\\IcIdIeIhImIrItI~J?JNJOJQJSJVJYJ\\J]JaJkJnJpJuJwJyKCKFKGKJKS"},
  {0,NULL,"KTKZKdKeKfKgKkKtK~LCLELILKLLLNLPLTLXLZL\\_A?D?M?X?^?a?d?g?h?j?m?r?"},
  {0,NULL,"w?}@@@G@I@Q@R@Y@[@^@_@`@m@n@o@y@}AAADAKALAMANAUA\\A]AmAnAqAsAvA~B?"},
  {0,NULL,"BCBHBIBJBPBQBRBTBUBYB]BhBnBrBvCACCCDCTC]C`CfCiCtC{C|DIDJDKDLDQDRD"},
  {0,NULL,"SDVDXDYD[D\\D`DgDnDwDzD}E@EBEEEFEMEZE_EdEoErEsExEzE}FBFGFHFRFSFYF^"},
  {0,NULL,"F_FaFfFiFjFkFnG@GAGCGDGJGNGOGXGcGeGgGoGpGuGwGzG}G~H@HAHBHKHQH\\H`H"},
  {0,NULL,"bHmHnHvHyHzH|ILIMIOI\\I`IiIlInIpItIuIwJ@JDJHJIJJJTJYJ`JaJbJlJmJrJv"},
  {0,NULL,"JyKAKCKFKHKJKLKPKVKkKnKoKpKsKtKuKxK~L?LFLILTLVLXLYL[Ld_A?F?N?W?]?"},
  {0,NULL,"c?e?f?h?k?l?t?v?{@F@H@K@N@O@R@\\@]@`@c@h@q@w@x@{@|A?AIAOATAVAWAXAc"},
  {0,NULL,"AkAoArAtAvAxAyA{A|A}BCBOBUBVB]B^BaBcBfBjBkBtCHCICLCOC\\C^ChCjCsC|C"},
  {0,NULL,"}DIDJDKDMDQDRDSDUDXDZD[D]D`DfDoDxDyD|D~EEEFEGEMEYE^EeEiEpEsEuEzE~"},
  {0,NULL,"FDFGFIFNFXFZF^FbFcFeFhFjFkFlFtGBGDGHGMGNGVG`GiGjGlGrGtGuGvG|G}G~H"},
  {0,NULL,"?H@HAHGHSH^HaHcHlHpHwHxH}I?ICIMINIYIcIdIfIgIiItIvIzI|JCJJJLJOJPJV"},
  {0,NULL,"J[J`JdJjJmJoJtJvJxKBKIKKKLKQKVK\\KcKjKlKoKrKsKuKvKwKxK{K}LOLRLWL[L"},
  {0,NULL,"cLd_A?G?O?V?\\?]?b?f?g?m?n?q?w?}@A@J@K@N@P@T@V@[@`@a@i@r@s@w@z@|AE"},
  {0,NULL,"AGAQATAWAYAaAcAgAnApAtAvAzA}BABDBGBJBRBUBZB_B`BcBeBfBiBuBzCICJCQC"},
  {0,NULL,"UC[C_CgCjCpCqDCDFDHDIDKDLDNDPDVDWDYDZD\\DmDpDuDvDxD}E?EBEDEFEQESEW"},
  {0,NULL,"EfEiElEmEuE|F@FAFIFPFTFXFZF]FaFdFeFfFiFlFoFqFzF~GBGIGMGUG_GiGkGnG"},
  {0,NULL,"oGpGvGxGyG~H?HDHFHKHLHSHTHdHfHqHrHyH{H|H}IHIPIXIZI\\IbIdInIoIsIvIw"},
  {0,NULL,"I}JEJGJJJNJSJTJ\\J^JdJgJoJtJzJ}J~KBKIKKKNKQKWKYK`KcKiKmKoKpKuKzK}L"},
  {0,NULL,"ALDLFLSLULYL[L]LcLeLfLhLr_A?G?K?T?Z?^?e?f?h?l?n?o?y?|?~@I@K@U@W@X"},
  {0,NULL,"@Y@_@a@b@k@q@v@yA?ACADAIALAMAQAYA]AaAdAeAqAtAwA~B?BABKBLBMBQBXBYB"},
  {0,NULL,"[B\\B`BbBjBnB|B}CCCNCOCSC^CaCfCkC~DBDEDGDHDKDNDODPDTDUDWDZD[D\\DaDe"},
  {0,NULL,"DqDwDxD|D}D~EAEGEIEJEREgEkEmErEyE}F@FDFKFOFSFYFZF^FbFcFdFgFiFkFpF"},
  {0,NULL,"uFxFyGAGJGSGZG^GdGeGkGmGpGqGtG{G~HBHFHMHNHOHQHRHSHTHkHoHtHwHxHzIQ"},
  {0,NULL,"IRIXI[I]IcIlImIoIrItI|I}JDJKJNJPJQJZJ\\J]JaJjJmJoJuJyK?KAKEKHKJKLK"},
  {0,NULL,"QKZK_KbKiKjKnKoKuK{L?LALBLHLQLSLVLWL[L^LhLiLq_A?G?O?V?^?a?d?f?g?m"},
  {0,NULL,"?n?q?w?}@A@G@L@M@O@S@Y@\\@^@_@i@n@o@y@}AAADAHANAPAUAZA\\AbAgAnAsAuA"},
  {0,NULL,"xA{A~B?BBBEBHBNBOBQBTBYB^BdBhBlBsBvCBCDCFCTC`CeCiCmCxC|D?DIDJDKDM"},
  {0,NULL,"DODPDRDTDUDVDXD[D`DjDrDzD{D|D~E@EBEDEMEVE\\EfEiElEmEuE|F@FCFGFIFTF"},
  {0,NULL,"VF[F\\FaFdFeFfFiFlFoFqFzF~GBGIGMGUG_GcGdGhGiGlGtGvG|HCHFHIHJHKHNHW"},
  {0,NULL,"HZH_HgHrHtHvHzH|I@IAICIDIYI_IbIkImIoIsIvI~JBJFJGJPJSJXJZJ\\J^JdJiJ"},
  {0,NULL,"qJvJwJzKBKDKGKKKRKVKYK[K]KeKfKhKlKrKvKwKyL@LCLLLOLPLRL\\L`LbLkLl_A"},
  {0,NULL,"?F?O?V?`?c?d?f?g?i?k?x?z@C@E@G@L@M@N@T@X@\\@^@_@i@o@u@x@{@}ABAGANA"},
  {0,NULL,"PAUAZA\\AbAfAjAsAuAxAzA}A~BBBHBLBOBQBTB_BbBcBdBlBmBqBvC?CBCKCTCVC`"},
  {0,NULL,"CeClCoC~D@DFDGDJDKDNDODPDUDWDXDZD]DdDlDqDzD{D~EBECEDEGENEPEREfEkE"},
  {0,NULL,"qEsEyEzF?FAFHFLFMFSFUFYF_F`FdFeFhFnFpFrFyF}GCGSGTGXGYGbGjGmGnGuGw"},
  {0,NULL,"GxGyG{G}G~HMHOHPHZH_HbHhHjHmHpHsH{H}IIIRIUIZIbIcIgIkIpIrIuIxJAJFJ"},
  {0,NULL,"JJKJLJRJSJ]J_J`JgJpJsJyJ|KAKCKFKHKJKOKSKXK^KbKfKhKkKnKyK|L?LCLHLI"},
  {0,NULL,"LQLTLVL\\L_LbLnLoLpLq_A?D?L?Y?]?c?e?f?g?k?m?p?t@D@F@G@K@O@R@S@U@W@"},
  {0,NULL,"Z@c@l@q@w@x@{@|A?AGALAMAOAVAXA]AiAoAsAtAwAyA{BCBEBFBMBNBWBXB\\B]B^"},
  {0,NULL,"BaBfBjBmByB~CICKCOC^CbCjClCsCwDADHDJDLDMDQDRDSDTDVDWDXD]DcDfDsDxD"},
  {0,NULL,"zD~E?ECEDEFEKEYE]EcEnErEtEwE{E}FAFJFLFOFPFYFZF`FcFeFfFjFoFpFsFuFv"},
  {0,NULL,"GGGPGRGZG\\GcGhGkGqGrGsGwGzHAHDHHHJHNHOHTHXH\\HbHrHsHwH}I?I@IKILITI"},
  {0,NULL,"[I\\I^I_IaIkIrIsIwJAJGJMJRJUJYJZJaJcJeJgJnJoJsJyJ}K?KEKJKNKQKTKXK`"},
  {0,NULL,"KbKiKkKqKtK~LALDLHLILJLQLSLTLXL]LaLkLmLt_A?E?L?Y?Z?^?e?f?g?i?n?s?"},
  {0,NULL,"y?|@B@G@K@R@T@U@W@X@[@c@l@q@v@yA?ACADAHALAMAOAVAXA]AeAhAsAtAwAyAz"},
  {0,NULL,"BCBJBLBMBRBXB\\B]B_BaBbBhBjByB}B~CDCOCSC^CbCiCkCrCuDBDFDGDHDMDODPD"},
  {0,NULL,"QDTDWDYD\\D]DaDhDtDxDzD~E?E@EAEDEIEUE[EcEjEoEpEvExE~FCFGFNFRFWF[F^"},
  {0,NULL,"F`FbFdFfFgFlFnFtF|G@GEGOGQGWG`GaGfGgGjGlGpGxGyH@HBHCHGHLHPHXH\\HcH"},
  {0,NULL,"gHjHoHtHxH{H|IFISIVIZI\\I_IeIgIjIuIvI{I~JEJIJMJRJSJVJ[JbJfJiJmJrJv"},
  {0,NULL,"JxK@KDKLKPKRKUKVK\\K]KgKlKqKsKtKvKxK~L@LJLKLNLOLXL`LaLdLeLoLqLr_A?"},
  {0,NULL,"D?M?X?\\?]?b?g?h?j?m?r?w?}@@@H@J@M@O@T@V@a@b@c@m@r@s@w@z@|AEAJARAT"},
  {0,NULL,"AWA[A_AcAmAnApArAyAzA{BABBBGBKBZB[B^B_B`BaBdBiBtBxBzCECHCJCUCXC[C"},
  {0,NULL,"_ChD@DBDCDGDHDKDNDODPDTDVDWDXDYD]DaDdDuDvDyD|D}E@ECEDEIENESEdEoEr"},
  {0,NULL,"EsExEzE}FFFHFKFNFUFXF^F_FaFfFiFjFkFnG@GAGCGDGJGNGOGXGaGcGfGgGjGqG"},
  {0,NULL,"vG{G}G~HCHEHNHOHYH[H]H^HiHqHrHvHyI?IQISIUIYI^I`IeIkIlItIuIyJBJIJL"},
  {0,NULL,"JWJXJYJZJ`JaJbJhJmJpJtJuJxKCKFKIKLKSKZK\\K^K_KfKgKjKlKvK{K|LBLCLKL"},
  {0,NULL,"NLOLWL\\L^L_LgLiLpLr_A?F?N?W?[?_?a?f?h?k?l?t?v?{@F@I@L@M@P@Q@S@U@["},
  {0,NULL,"@b@h@n@p@t@~A@AAAFANASAUA\\A^A`AkAoAqAuAwBBBDBEBIBJBKBNBPBRB[B\\BdB"},
  {0,NULL,"eBrBsBwB{CACFCGCPCZC]CdCmCrDCDDDFDGDHDMDNDPDSDVDWDYDZD]DbDtDuDwD{"},
  {0,NULL,"D|E?EAECEFEOESEUEeEiEpEsEuEzE~FEFGFHFRFTFXF\\FbFcFeFhFjFkFlFtGBGDG"},
  {0,NULL,"HGMGNGVG`GcGfGgGjGkGlGmGyG{H?HAHFHHHKHVH_H`HhHkHlHnHuHwI@IPIUIVI["},
  {0,NULL,"I]IdIiIjIkItIvJ?JAJLJMJPJQJTJUJ[J`JdJkJrJtJvJwJzKCKFKGKIKPKVKYK]K"},
  {0,NULL,"^K`KfKpKtK|K~L@LCLDLFLXLYL\\L]L_L`LgLhLqLu_A?D?L?Y?[?_?a?f?g?k?m?p"},
  {0,NULL,"?t@D@F@J@L@N@Q@X@[@]@b@d@l@n@p@t@~A@AAAHARASA[A^A_A`AiAoApAuA|A}B"},
  {0,NULL,"@BIBJBKBLBPBRBSBVB[BbBcBoBpBsB{C@CFCGCMCYCZCcCmCvDDDEDGDHDKDNDODR"},
  {0,NULL,"DSDYDZD[D\\D]DbDeDiDvD{D|D~E?EBEEEJEOETEcEnErEtEwE{E}FCFJFKFOFQFVF"},
  {0,NULL,"\\F`FcFeFfFjFoFpFsFuFvGGGPGRGZG\\GdGeGjGnGpGqGrGzG|G~HEHHHLHPHWHYH]"},
  {0,NULL,"HeHjHlHnH|H}I@IGIQIWI\\IaIbIfIgIlIrIsIzJBJEJHJJJOJRJZJaJcJeJiJnJqJ"},
  {0,NULL,"uJwJ{K?KEKGKMKTKZK[K_KaKdKeKjKrKwK{LBLELGLLLMLPLRLWLZL^LfLhLnLp_A"},
  {0,NULL,"?E?P?U?`?c?d?g?h?i?j?u?x@?@C@G@H@M@N@U@Z@\\@a@d@j@o@u@x@{@}ABAKAOA"},
  {0,NULL,"PAVAXAZAbAfAlArAsAwAxA}B@BABBBFBOBSBWB\\B`BcBdBgBkBmBvCKCLCRCTCWC\\"},
  {0,NULL,"C`ClCqC~DDDFDGDHDLDNDODPDSDUDYDZD\\DbDpDqDyDzD}EAEBECEEEOEREWEhEmE"},
  {0,NULL,"nEpEwE~F@FBFGFIFJFYFZF\\F_F`FaFgFhFkFoFxFzGGGHGIGVG\\G^GbGdGfGpGqGr"},
  {0,NULL,"GtGyH?HAHCHDHEHFHUH\\HaHgHiHmHpHsHvH~IVIWIXI^I`IfIhIjIoIsItI{J@JCJ"},
  {0,NULL,"HJMJNJWJXJ[J\\JcJlJnJoJvJwJyKBKGKJKKKQKTKVK]KdKiKoKrKtKuKwK~L@LALE"},
  {0,NULL,"LRLSLXLZL[L`LpLrLuLw_A?E?P?U?`?c?d?g?h?i?j?u?x@?@C@G@H@M@N@U@Z@\\@"},
  {0,NULL,"a@d@m@r@s@u@}ACADAKAVAWAXA]AaAbAeAgAhAmAoApArA{A|A}BKBNBRB\\B]BgBj"},
  {0,NULL,"BkBoBpBuB{CACFCICKCPCSCTCWCXC`CiCnCpCsCtDBDDDHDNDZD`DiDjDqDrDuDwD"},
  {0,NULL,"zEAEBEHEJEUEWEZE]EdEoEpEsEwE{F?FBFGFJFUFWF[F\\FbFfFkFnFqFtFuFxF|G@"},
  {0,NULL,"GAGIGLGMGRGSG]G_GmGpGtGuHDHFHJHLH\\H^HaHbHiHkH|IAIBIEIGIHIPIQIRIUI"},
  {0,NULL,"VIWIXI[I\\I^IqIsIzI{I}J@JAJCJJJPJ_JbJfJhJpJtJxJ|J~KCKEKHKOKRKXK[Kb"},
  {0,NULL,"KfKkKnKsKtKvKwKzK}LJLLLNLOLTLaLbLdLfLhLlLmLoLqLvLx_A?F?O?V?`?c?d?"},
  {0,NULL,"f?g?i?k?x?z@C@E@G@L@M@N@T@X@\\@^@_@l@q@v@x@~A@ABAGAUAYAZA\\A]A`AdAh"},
  {0,NULL,"AkAmAoAsAtAvAyA~BCBPBZB[BdBfBmBrBtBuBvB|C?CBCCCECJCPCUCVCZCbClCnC"},
  {0,NULL,"rCsCtD@DEDKDODPD_DaDlDmDnDsDvD{ECEGEKERESETEXE^EcEoEpEsEwE{F?FAFH"},
  {0,NULL,"FLFTFUF[F\\FbFjFlFnFrFtFwFxF|GBGDGJGKGLGPGSGZG_GmGoGuGvHDHFHMHOH\\H"},
  {0,NULL,"bHeHhHjHkI?IAICIDIFIHIIIQIRISIUIWIXIZI]I^IrIsIxIyI|J@JAJDJJJYJ[Jd"},
  {0,NULL,"JeJiJmJoJvJxKBKDKGKKKMKTKWK[K^KaKcKgKmKpKuK~LALDLELILMLPLXLYL]L`L"},
  {0,NULL,"gLiLkLlLuLwLzL|_A?D?K?T?`?c?d?f?h?j?k?u?z@?@E@H@L@P@T@U@Z@^@_@d@h"},
  {0,NULL,"@n@o@p@z@{@|AIAPAQARAWA_A`AhAiAmAnAoAqAuB?B@BIBJBXB^B_BaBhBlBnBpB"},
  {0,NULL,"qBzB|B~CJCLCMCOCRCSC\\CeChCmCnCsCtCuCvDCDFDWD\\DcDeDkDoDpDtDxDyEDEE"},
  {0,NULL,"EIEMEPEQEVE\\EeEoEpEsEwE{F?FDFKFNFUFVF[F\\FfFjFkFlFqFrF~G@GAGBGDGIG"},
  {0,NULL,"KGPGQGRGZG]GoGpGtGvHJHLHMHOH^HaHeHhHuH|I?IDIEIFIGIHIIILIPIRISIVIX"},
  {0,NULL,"IYIZI[IqIrIwIxIyIzI{JCJDJEJ`JaJcJkJrJvJwJyKAKCKJKNKQKSKTKXK]KiKjK"},
  {0,NULL,"lKoKrKyK|L?LBLGLHLRLWLZL\\L^L_LeLnLpLrLvLyL{L|_A?F?N?W?]?c?e?f?h?k"},
  {0,NULL,"?l?t?v?{@F@H@K@N@O@R@\\@]@`@c@k@t@u@xA?A@ACAIARAVAWA^AaAcAdAfAhAjA"},
  {0,NULL,"nArAuAzA{BBBHBRBUBYB`BiBkBlBoBsBtBvC@CACCCDCICOCUCWC\\C^CkCnCoCzC|"},
  {0,NULL,"DCDEDIDRDXDaDfDhDjDnDtDwDxD~EEEOEREVEWE^E_EgEkErEsEuE{E|FDFGFIFJF"},
  {0,NULL,"QFWF^F_FdFkFpFxFyFzF|F}GCGHGLGOGWG[G\\G_G`GjGqGtGwH?H@HIHLHSHTH[H^"},
  {0,NULL,"HlHmHtIAIBICIDIFIIILIMINIOITIWIdInIoIqIvIwIxIzI|JBJIJLJZJ]J_JeJkJ"},
  {0,NULL,"nJpJsJyJ|KCKEKNKRKUKXKYK_K`KbKiKoKtKvKzK|L@LGLKLNLSLULZL^LaLfLiLl"},
  {0,NULL,"LmLoLtLwLzL}_A?D?K?T?Z?[?\\?f?h?j?k?u?z@?@E@I@K@V@W@X@Y@\\@]@a@h@n@"},
  {0,NULL,"o@p@z@{@|AFALAMANAOAPAQAhAiAmAnAoAqAuB?B@BIBJBXB^B_BaBoBqBvBwByB{"},
  {0,NULL,"B|CDCECKCQCRCSCUC]CdCgCjCnCuCwC|D@DDDTDUD[DjDkDmDnDpDuDxDyEBECEPE"},
  {0,NULL,"TEUEVE]E^EeEnEqEtExEzE~FEFPFRFSFYFZF]FfFjFmFpFsFuFvFwFzF{F|GJGMGN"},
  {0,NULL,"GOGUGYG_GbGeGhGnGyHCHKHNHVHXH`HcHnHpHrIAIBICIDIEIJIKINIOIQIRIXI_I"},
  {0,NULL,"eIjItIvIxI{J@JAJBJFJOJTJ`JaJcJjJqJuJwJ{K?KAKIKLKQKSKZK\\KdKgKkKmKq"},
  {0,NULL,"KsK}K~LCLDLFLLLQLTLXL[L]LdLhLiLlLmLqLtLwLz_A?E?N?W?^?a?d?f?h?j?n?"},
  {0,NULL,"q?r@@@A@I@L@M@Q@R@S@V@[@\\@k@s@v@y@}ABAEAIASATAYA\\A_A`AeAfAhAiAlAq"},
  {0,NULL,"AtAyBEBLBMBPBSBWBcBfBiBjBnBoBrByC@CBCFCHCKCLCUCVCaCeCfCnCqCvCwCzD"},
  {0,NULL,"BDMDSDVDdDfDjDkDlDqDyD{D}EDEJEQE[E]E^E_EgEjElEoEwE}F@FDFHFLFMFOFT"},
  {0,NULL,"FXF`FgFlFmFsFtF|G?GCGEGFGSGTGVGYG\\G^G_GlGsGvGxG~HAHEHMHQHRHWHeHoH"},
  {0,NULL,"qHsIAIBICIEIJIKILIMIPITIUIVIaIfIlIrItIwIyI{I}JBJGJKJVJ[J\\JbJkJmJr"},
  {0,NULL,"JvJzK@KDKFKGKJKKKTKVKaKcKeKhKlKrKuKxK{L?LHLILPLVLWLYL\\LcLgLhLlLmL"},
  {0,NULL,"qLtLuLzL~_A?G?K?T?Z?^?e?f?h?l?n?o?y?|?~@I@K@U@W@X@Y@_@a@b@h@q@r@w"},
  {0,NULL,"@~AAADAIASAYA[A]AaAcAfAgAiAkAnArAtAvA}BABFBNBTBbBdBgBjBkBmBpBzB}C"},
  {0,NULL,"?CBCCCJCMCNCTC]C^CfCjCvCxCzC}C~DCDGDNDOD`DdDeDgDnDpDwD{D}D~EIEKEO"},
  {0,NULL,"EPEYE]EeEjEkEqEuE~F@FDFPFRFSFYFZF]FaFeFmFpFrFuFvFwF{G@GGGIGJGMGNG"},
  {0,NULL,"PGUGXGeGnGqGsG~H@HCHNHRHSHVHcHkHvH}IAIGIIIKIOIQIRISIUIVIWIXI^IgIm"},
  {0,NULL,"ItIvIxI{I|I}JBJJJQJWJ^JdJfJkJpJsJxJ}K@KDKGKPKRKVKYK[K`KaKbKeKkKmK"},
  {0,NULL,"uKvKxK}K~LKLULYL]LaLcLdLeLjLkLnLpLrLsLx_A?D?M?X?\\?]?b?g?h?j?m?r?w"},
  {0,NULL,"?}@@@H@J@M@O@T@V@a@b@c@j@o@w@x@zA@AAAJARAUAZA[A^AcAeAiAjAlAoArAsA"},
  {0,NULL,"wAzBCBFBVBYB[BbBhBjBlBtBxByB{C?CCCFCJCNCSCUCYC[C\\ChCoCwC{D?DBDDDG"},
  {0,NULL,"DPDWD_DgDhDkDqDuDvDwD|EDEJEMENEUEYE^EhEmEnErEvExE|FFFIFKFNFQFVF^F"},
  {0,NULL,"`FcFkFoFsFtFuF}GDGGGHGKGMGSGWGXGYG[GcGiGjGkG{G}HIHPHUH[H]HdHjHvHw"},
  {0,NULL,"ICIFIIIJIKIPIQIRISIUIVIXI]I`IgIqIuIyI}I~JAJBJQJSJYJ^JcJeJlJnJoJsJ"},
  {0,NULL,"yJ}KBKMKNKPKUKWKYK`KcKeKjKoKpKxKyLELGLILKLMLPLRLULZLcLfLhLlLmLoLq"},
  {0,NULL,"LsL{M@_A?F?N?W?[?_?a?f?h?k?l?t?v?{@F@I@L@M@P@Q@S@U@[@b@k@t@u@xA?A"},
  {0,NULL,"@ACAFAMANAUAVA^AbAdAfAhAjAnArAuAzA{BBBHBRBUBYB`BhBmBsBtBxBzB{B~CA"},
  {0,NULL,"CICJCPCQCTCVCZCaCdCuCyC|C~DADCDHDPDYD_DdDfDpDrDtDwDxE?ECEIELEOEQE"},
  {0,NULL,"ZE^EgEiElEtEyEzE}FEFHFLFMFOFTFXF_FdFlFmFtF~G?G@GEGFGGGIGQGSGTGVGX"},
  {0,NULL,"G^GfGhGlGxGyGzHAHEHQHWH_H`HiHwH{IBIFIHIJIPIQISITIUIVIWIXI\\I`IiIrI"},
  {0,NULL,"tIwI{J?JAJBJPJSJXJ]J_JeJjJnJqJ{J|J~KBKEKHKLKMKUKZKcKhKnKpKqKsKwK{"},
  {0,NULL,"LCLELILLLMLPLQLTLVLbLeLjLkLnLpLrLvL{_A?G?K?T?_?`?b?f?h?l?n?o?y?|?"},
  {0,NULL,"~@H@L@R@T@V@Z@]@^@d@h@q@r@w@~AAADAFAUAXAZA[A]AbAfAgAiAkAnArAtAvA}"},
  {0,NULL,"BABFBNBTBbBdBgBiBuBvBxByB}C?C@CDCGCKCNCPCXCZChCmCpCrCwCzC|C~DJDLD"},
  {0,NULL,"QDbDeDfDiDkDnDwD{E?E@EIENESEVE]E_EeEiEmEpEvEyF?FEFKFNFUFVF[F\\FaFe"},
  {0,NULL,"FkFlFqFsFzGAGBGCGDGKGOGRGYGZG\\G]GcGfGoGpGzHJHOHPHUH_HaHhHxHyI@IDI"},
  {0,NULL,"EIGIHIJIKILIMINIOISITIcIkIpIqIrIwIxI{I~J?JHJMJNJ^JdJfJjJoJtJxJ}J~"},
  {0,NULL,"KBKHKMKOKPKWK[K]K^KfKjKnKpKwKyLALBLELJLMLOLRL_L`LbLfLgLlLmLoLtLuL"},
  {0,NULL,"zL}L~MD_A?D?M?X?^?a?d?g?h?j?m?r?w?}@@@G@I@Q@R@Y@[@^@_@`@j@o@w@x@z"},
  {0,NULL,"A@AAAKAMAUAVAYA]AcAeAiAjAlAoArAsAwAzBCBFBVBYB[BbBfBgBhBqBvBxB}CAC"},
  {0,NULL,"CCGCMCOCQCUC]C`CdClCqCsCvCyC{DBDIDQD[DbDgDoDsDtDuDvDwEBEFEHELEMEN"},
  {0,NULL,"EPEREhEjElEoEwE}F@FBFHFLFPFRFTFYF`FcFmFnFrFyF{GBGCGEGFGNGPGTGVGZG"},
  {0,NULL,"\\G`GgGsGuGxG|G~HAHFHQHRH\\HgHlHsHyIBICIDIEIGIIIJILIMINIOIPIcIlIoIs"},
  {0,NULL,"ItIwIzI}I~J@JIJMJVJ^JcJeJhJqJsJxJ|KBKDKEKGKMKYKZK[K^K_KbKmKnKqKvK"},
  {0,NULL,"wK~L@LALCLQLSL]L`LaLbLeLjLkLnLuLwLyL|L~MCME_A?E?P?U?Z?[?\\?g?h?i?j"},
  {0,NULL,"?u?x@?@C@I@J@P@S@W@X@]@^@`@m@r@s@u@}ACADAJANASA[A^AaAbAeAgAhAmAoA"},
  {0,NULL,"pArA{A|A}BKBNBRB\\B]BfBiBkBpBqBsBtB~CBCGCKCNCOCPC[C_CaCfCsCuCxC{D@"},
  {0,NULL,"DDDJDMDRDaDeDoDqDrDsDwDzEDEGEHEKEMEQESEWEdEnEqEtExEzE~FFFMFOFSFXF"},
  {0,NULL,"ZF]FbFfFmFoFvFwFyFzF~G?GBGJGOGQGUGZG^G`GdGhGiGnGyG{HGHNHVHYH]H`Hm"},
  {0,NULL,"HrHxIAICIDIEIFIHIKILIMINIRITIdIjIkItIuIxIyIzI~JAJHJOJZJ_JbJfJlJnJ"},
  {0,NULL,"pJ{J}J~K@KHKLKPKRKUKVK]K`KaKhKiKpKuK{K|LBLELKLMLULVLYL^L_LeLgLiLj"},
  {0,NULL,"LkLnLyL|MCME_A?G?P?U?]?c?e?g?h?l?m?p?v?{@D@G@H@N@Q@U@W@Z@\\@`@m@n@"},
  {0,NULL,"q@y@|@~AEAJAOAPARAZA\\A`AdAeAgAjAnAqAsAxA~B?BLBWBZB_BeBmBqBsBwByB|"},
  {0,NULL,"B}C@CBCGCHCJCLCQCXCbChCiCoCxCyC{DCDEDLDSDUDdDgDiDmDoDrDvDyD|E?EHE"},
  {0,NULL,"IEKELEUE[EdEkErEsEuE{E|FFFGFJFUFWF[F\\FdFiFkFnFvFxFyF|G@GAGEGIGLGT"},
  {0,NULL,"GUG]G_G`GaGjGmGtHDHHHIHLHZH[H^HbHnHqHtIAIBIEIJIKIMINIOITIVIWIXIaI"},
  {0,NULL,"eInIqIsIzI}J?JAJBJFJKJLJ\\JaJdJlJmJoJvJyK?KAKIKKKNKQKTKWKcKfKgKjKl"},
  {0,NULL,"KsKyLDLHLILJLLLOLPLRLTLXL\\LjLkLpLrLuLwLyL|L~M?_A?F?M?X?_?`?b?g?h?"},
  {0,NULL,"i?l?o?s?~@B@H@J@O@Q@T@V@W@^@b@j@p@t@v@{A?ABAKALAQATAWAXA_AfAgAjAk"},
  {0,NULL,"AoApAqBDBEBGBJBOBQB^BcBfBnBoBrBsBzB}CBCDCECOCQCRCTCWCYC\\CcCpCrCsC"},
  {0,NULL,"xCyC~DTDVDXDgDhDlDpDrDsDyDzD~EAEJEKELEMEOETEhEiEmEpEvEyF?FBFIFKFN"},
  {0,NULL,"FQFVF^FeFhFkFoFsFvGBGDGEGGGHGKGTGUGXGYGZG[GcGkGpGrG}HBHJHPHUHaHdH"},
  {0,NULL,"fHoHpI@IAIBICIDIJIKILIOIQISITIUI_IfIpIqIuI{I|I}I~JAJGJNJTJ[J]J`Jh"},
  {0,NULL,"JrJtJuJwJzKCKFKJKOKSKXK\\KdKeKkKoKrKtKxKzK}L?LFLGLNLWLZL[LcLdLgLiL"},
  {0,NULL,"jLkLpLrLyL|M?_A?E?N?W?\\?]?b?f?h?j?n?q?r@@@A@H@K@N@O@P@_@`@b@c@k@s"},
  {0,NULL,"@v@y@}ABAEAFALAOATAXAZA\\AeAfAhAiAlAqAtAyBEBLBMBPBSBWBcBfBhBmBpBrB"},
  {0,NULL,"uBwB~CECFCGCHCMCTCWCXCgCkCuCvCwC{C~D?DKDZD]D^DdDeDjDsDtDyD{E@EBEH"},
  {0,NULL,"EOEPEQEXE_EgEmEnErEvExE|FEFGFIFJFQFWF^F`FgFkFpFrFxFyF}F~GGGHGLGPG"},
  {0,NULL,"QGWGXG[G`GbGcGjGwH?HIHKHPHTHUHXH[HjHzH~ICIFIGIHIIIMINIPIQIRIUIWI]"},
  {0,NULL,"IbIhIqIvIwIxI~J@JBJRJUJYJ[J\\JbJjJmJoJtJuJzK?KFKIKKKOKWK\\K^K_KdKfK"},
  {0,NULL,"gKtKzL@LALDLFLJLNLOLSLXL[L`LeLnLpLrLsLxLyL|MIMJ_A?E?L?Y?Z?^?e?f?g"},
  {0,NULL,"?i?n?s?y?|@B@G@K@R@T@U@W@X@[@c@i@o@u@y@zACAEAHAMAOAPARAVAcAfAgAkA"},
  {0,NULL,"lAmAsAuAwAxBBBIBUBVBaBeBgBhBrBsBtByB{C@CECLCMCOCPCSC`CgCiCkCqCrCx"},
  {0,NULL,"CzC}D@DHDWD]D^DaDbDkDlDrDvDxE@EAEMESETEZE[E_EfEjEkEqEuE~F@FCFGFJF"},
  {0,NULL,"PFRFWFYFaFhFnFpFvFwF}G@GCGDGFGIGJGKGUGVGWG\\GaGeGgGqG|H@HCHHHSHZHc"},
  {0,NULL,"HgHuHvH{IFIGIHIKILIPIQIRISITIUIVIYIgIiIsIvIyI{I|I~J?JEJQJXJ\\J_JcJ"},
  {0,NULL,"gJqJsJyJ|K?KAKEKIKNKQKYKZK_KdKjKnKoKsKwKyL@LFLGLLLRLSLTLZL[LbLgLi"},
  {0,NULL,"LkLmLtLuLwL|M@MAMGMI_A?G?O?V?^?a?d?f?g?m?n?q?w?}@A@G@L@M@O@S@Y@\\@"},
  {0,NULL,"^@_@l@n@r@t@|A?ADAHANAPAVAWA_AbAdAeAiAkAlApAuA|B@BDBHBOBXB\\B`BiBk"},
  {0,NULL,"BlBpBsBwBxCDCHCNCQCRCSCTCZCbCiCmCqCvC}D?DADBDJDUDXD^D_D`DeDhDmDxD"},
  {0,NULL,"zD|E@EOESEUEXEYE\\EcEjElEoEwE}F@FCFHFLFTFUF[F\\FcFgFlFnFrFtF{F|G?GB"},
  {0,NULL,"GHGNGPGSGZG[G^G_GgGlGuGvG|HEHFHMHWH\\HeHgHlHoHrIAICIDIIIJIKIMINIOI"},
  {0,NULL,"RITIUIfIjIoIrIsIyI|I~J@JBJGJIJOJ]JaJfJgJrJ{J|J~KAKCKEKHKJKLKQKXK]"},
  {0,NULL,"KgKoKpKsKtKzLBLDLELGLLLMLNLTLXLZL_LnLoLpLqLsLvLxL{L}M?ME_A?G?O?V?"},
  {0,NULL,"\\?]?b?f?g?m?n?q?w?}@A@J@K@N@P@T@V@[@`@a@l@n@r@t@|A?ADAGALANAQAWA^"},
  {0,NULL,"AaAdAeAiAkAlApAuA|B@BDBHBOBXB\\B`BgBiBlBqBrBzB|CCCICKCLCPCQCTC^C_C"},
  {0,NULL,"cCjCqCrCwC{D?DEDFDNDYD`DbDfDlDmDoDxDzD}EFELERESE[E\\E]EcEmEnErEvEx"},
  {0,NULL,"E|FAFIFQFSFZF]F^FcFgFoFpFsFuFxFyF~GDGFGKGLGMGQGVGYG`GbGiGkGwG{G}H"},
  {0,NULL,"?HKHTHXH]HdHwH|H~IEIGIHIIIJIMIPISIUIVIWIXI[I`IbIuIvIwIyI}J?J@JCJS"},
  {0,NULL,"JUJ]JaJfJiJnJpJuJwJ{KCKLKRKSKUKXK\\KbKhKiKkKqKrKvK{K|K}L?LCLQLVLWL"},
  {0,NULL,"^LaLdLgLiLjLmLtLuLwLyM@MAMHMJ_A?F?O?V?Z?[?\\?f?g?i?k?x?z@C@E@J@K@P"},
  {0,NULL,"@S@V@Y@Z@`@a@l@q@v@x@~A@ABAHAOATAYAZA[AcAdAhAkAmAoAsAtAvAyA~BCBPB"},
  {0,NULL,"ZB[BdBhBkBnBuBvBxB}C@CACBCFCHCJCRCYC^CcCkCtCuC}D@DADDDIDLDVD_D`Dc"},
  {0,NULL,"DiDlDtDvD{EAEEEIEJEREXEZE\\EcEnEqEtExEzE~FCFIFQFSFZF]F^FbFjFoFpFsF"},
  {0,NULL,"uFyF{F~G?GAGMGNGQGYG]G^G`GbGdGeGiG{HCHGHKHXHYH]HcHnHsHxIAIBIDIEIH"},
  {0,NULL,"IJILIMIOIPITIXIeIkIlIuIvIyIzI{J?J@JFJHJVJ[JdJeJgJoJsJzJ}K?KDKFKGK"},
  {0,NULL,"IKPKWKYK_KbKeKfKjKrKvKxKyL?L@LJLOLRLSLWLaLcLeLfLhLrLsLvLxL{MCMDMK"},
  {0,NULL,"_A?E?L?Y?_?`?b?f?g?i?n?s?y?|@B@J@L@O@Q@Y@Z@]@b@d@i@o@u@y@zACAEAGA"},
  {0,NULL,"MAQARAUA^A`AfAgAkAlAmAsAuAwAxBBBIBUBVBaBeBkBmBnBqBwByB{CACHCICMCN"},
  {0,NULL,"COCUCVC[C_CeCpCrCtC}C~D?DRDSD[D^D`DaDcDdDuDvDxD}EGEPEWEXEYEZE[EfE"},
  {0,NULL,"iEmEpEvEyF?FAFKFMFNFOFVFXFaFhFlFoFqFzF{GAGEGGGHGNGOGRGTGXG[G]GfGk"},
  {0,NULL,"GoGrGzG}HBHOH_HdHfHhHpHtHyIAIBICIEIGIKILIMINIOIQIWI_IcInIrIuIxI|I"},
  {0,NULL,"}J?J@JLJMJTJ\\J_JcJiJnJqJvJwJyKBKMKNKSKTKUKZK`KcKiKlKmKqK|K~LCLHLI"},
  {0,NULL,"LKLPLQLUL\\L]L^LfLhLnLpLsLvLxL{M?MDME_A?D?L?Y?[?_?a?f?g?k?m?p?t@D@"},
  {0,NULL,"F@J@L@N@Q@X@[@]@b@d@i@p@s@w@{@}AAAHASATAXA[A_AbAdAjAlAmAnApAtBABG"},
  {0,NULL,"BKBMBQBSBTB]BgBjBoBpBtB|B}B~CCCDCECFCGCLCYC[CeCmCqCyC|D@DADEDGDZD"},
  {0,NULL,"\\DaDbDcDgDjDmDzD{D|EEEHERETEVEYE[EfEiElEtEyEzE}FCFKFMFNFOFVFXF_Fi"},
  {0,NULL,"FlFoFqFwFxFzGEGFGGGJGLGOGRGTGVGXGdGfGlGrGzHBHEHGHWHYH_HfHiHzH}IBI"},
  {0,NULL,"FIGIIINIOIPIQIRIVIWIXI\\IhImIrIuIzI|J?J@JBJPJRJWJ^J`JbJgJrJtJzJ}J~"},
  {0,NULL,"K@KFKHKJKOKPKVK]K`KeKfKlKtKxKzLBLHLJLKLNLOLUL\\L_LcLgLiLjLlLuLwLyL"},
  {0,NULL,"zMBMFMHMJ_A?F?M?X?Z?^?e?g?h?i?l?o?s?~@B@G@I@R@Y@[@_@a@c@d@j@p@t@v"},
  {0,NULL,"@{A?ABAJALANAPASA\\A_AfAgAjAkAoApAqBDBEBGBJBOBQB^BcBiBlBnBuBzB{B|B"},
  {0,NULL,"~C?CDCECFCHCICaCbCdClCoCpCxCzC}DDDKDYD\\DcDfDhDiDsDuDyDzE?EGEJELEN"},
  {0,NULL,"EVEWEXEhEjEkEqEuE~F@FFFHFLFPFRFTFYFeFhFmFnFqFrFuF{F}GCGFGMGNGPGRG"},
  {0,NULL,"VGWG\\GaGgGnGsG|G~HHHNHRHVHZHgHuH}H~IFIGIHIIILIMIOIPIQISIWIXIYIbIm"},
  {0,NULL,"IsItIxIzI}I~J?JEJUJWJ[J]J`JlJmJrJuJ{K@KAKJKKKLKQKVK\\K]K^KgKhKlKqK"},
  {0,NULL,"{LALBLCLDLHLQLVLXL\\L_L`LfLhLoLqLtLvLxLzMAMBMM_A?G?P?U?[?_?a?g?h?l"},
  {0,NULL,"?m?p?v?{@D@I@J@M@P@S@X@]@c@d@m@n@q@y@|@~AEAKAMAOAQATAYA`AdAeAgAjA"},
  {0,NULL,"nAqAsAxA~B?BLBWBZB_BeBjBlBmBrBuBvBwC?C@CICLCMCRCSC]C_CcCfCoCpCyC|"},
  {0,NULL,"DADBDFDOD]D^DhDiDnDoDqDvDyD~EFEKENEUEWE\\E_EdEiElEtEyEzE}FBFMFOFSF"},
  {0,NULL,"XFZF]FdFiFmFoFqFtFwFzF}F~G?GJGOGQGRGSGWG^GdGhGrGxGyHAHBHGHQHYH`Hf"},
  {0,NULL,"HzH{I?IDIFIGIHIIINIRISITIUIVIWIZIhIiItIuIwIzI|I~JAJDJRJXJ\\JaJdJhJ"},
  {0,NULL,"qJvJwJzK?KDKFKGKIKSKTKZK_KaKdKiKmKrKuK|K~L?L@LFLSLWLYL[L]L^LfLhLo"},
  {0,NULL,"LqLsLtLzL{MAMBMOMP_A?D?L?Y?]?c?e?f?g?k?m?p?t@D@F@G@K@O@R@S@U@W@Z@"},
  {0,NULL,"c@i@p@s@w@{@}AAAGALASAXA\\A]AaAdAjAlAmAnApAtBABGBKBMBQBSBTB]BfBjBn"},
  {0,NULL,"BoBwBxBzB~C?CACGCKCNCRC`CgCjClCoCtD?DADCDEDMDQDTD^D_DbDcDpDqDzD{E"},
  {0,NULL,"CEFENEQETEYEZE\\EfEkErEsEuE{E|FAFGFJFPFRFWFYF_FiFnFpFvF}G?G@GAGCGH"},
  {0,NULL,"GIGUGWG[G\\G]G^GaGmGqGwH?H@HDHHHSHTHZHbHmHqI@IBICIDIEIFIJIKILINISI"},
  {0,NULL,"TIVIaIdIpIsIvIwIyI|J?JAJKJNJZJ^J`JbJiJmJpJtJuJxK@KKKOKRKVK[K\\K^Ka"},
  {0,NULL,"KdKhKkKnKuKwK{K}LALFLVLYL[L`LbLdLeLoLqLrLsLvLxL{L}MCMKMR_A?F?N?T?"},
  {0,NULL,"Z?[?e?f?h?k?l?t?v?}?~@B@C@E@I@K@Y@[@`@a@h@n@p@t@{@~ABAFALANAOAPAS"},
  {0,NULL,"A\\AkAoAqAuAwBBBDBEBIBJBKBTB^B_BdBqBwB{B|CDCECFCGCHCKCUC[C]C`CbCdC"},
  {0,NULL,"gCjCnCpC{C}DBDDDHDPDYD`DhDkDqDsDuDyD{E?ECEHENEUEVEWEYEgEkErEsEyE{"},
  {0,NULL,"F?FDFKFOFQFSFWF^F_FdFkFpFxFyFzF|F}GCGHGKGSGZG[GeGpGqGtG{HBHEHFHIH"},
  {0,NULL,"LHMHQHRHSHTHYHdHgHiHkHrHsHtH|ICIMINIZI_I`IkImIoIqIrIzI|JEJGJMJQJX"},
  {0,NULL,"JZJ^JdJeJkJsJtJzJ|K?KCKKKMKOKTKWK[KdKeKfKjKkKrKyL?LGLHLILLLVLYLaL"},
  {0,NULL,"bLcLdLeLjLkLnLpLrLvL{M?MCMEMIMJMKMOMT_A?F?M?U?`?c?e?g?h?i?l?o?s?{"},
  {0,NULL,"@A@C@E@F@G@H@N@O@\\@_@m@q@v@y@~A@ACAJARAUAZA\\A]A`AdAhAqAsAyA~B?B@B"},
  {0,NULL,"ABCBJBNBRBZBeBmBwByB|CBCCCGCJCNCQCUCVCXCbChCiCjCmCnCqCyD?D@DEDKDY"},
  {0,NULL,"D\\D_DbDjDlDmDoDvDwE?EGEKESETEYE[E]EhEiEmEpEyEzE~FBFGFIFNFYFZF^FeF"},
  {0,NULL,"hFkFoFsFvGBGDGEGGGHGQGVGYG^GdGpGrGtG}G~H?HAHBHCHEHSHUHXH\\HaHeHgHi"},
  {0,NULL,"HlHpHqHzH}ICIJIKI^IbIdIeIfIiItIuI{I|JCJDJEJNJOJVJ]J_JfJhJrJsJyJzJ"},
  {0,NULL,"}KCKHKLKMKPKUKZK_K`KbKfKiKjK|K~L?L@LCLHLNLOL_L`LaLbLfLhLoLqLtLvLx"},
  {0,NULL,"LzL}M@MDMFMOMPMRMS_A?D?M?U?[?\\?a?g?h?j?m?r?w?|@?@D@E@F@I@J@X@Y@]@"},
  {0,NULL,"b@m@n@o@y@{@|@}AKALAMANAOAQATAmAnAqAsAvA~B?BCBHBIBJBWB\\B]B_BmBrBv"},
  {0,NULL,"BwC?CDCECICRCSCTCZC]C^C_CcCfCgCnCoCzC|C~D@DIDQD[DaDfDiDkDnDpDyDzE"},
  {0,NULL,"BEFEOESEUE]E^E_EhEmEnErEwE{E|FFFKFOFQFTFVF\\F`FcFkFoFsFtFuF}GDGGGH"},
  {0,NULL,"GIGKG\\G]GdGiGjGtGzG|H@HHHIHMHPHRHVHWH]HcHdHhHjHlHmHtH{H}IQISIUIZI"},
  {0,NULL,"\\IaIcIgIjIqIsIyJBJEJFJHJJJSJVJ^JbJfJlJrJsJyJzJ}KCKKKOKRKXK[K\\K]Kf"},
  {0,NULL,"KiKlKrKtKyL@LALDLHLJLQLULVL^L_LaLeLjLkLnLuLwLyL|M?MGMHMIMJMKMNMQM"},
  {0,NULL,"U_A?G?P?X?]?_?b?g?h?l?m?p?v?|?}?~@A@E@H@J@P@T@V@Z@j@q@w@xA?AAADAJ"},
  {0,NULL,"AUAXAZA[A^AbAiAkArAsAvAwAxA}BFBIBMBOBQBYBbBhBtBxByB~C?CFCKCNCPCSC"},
  {0,NULL,"YCZC[C\\CeCgChCnCrCuCwCzDBDLDSDUDeDjDkDlDnDuDwDzD|E?ENEQETEVE^E_Ed"},
  {0,NULL,"EiElEtEuE}F@FBFIFJFPFXFZF]FdFiFmFoFqFtFwFzF}F~G?GJGNGPG_GkGrGsGxG"},
  {0,NULL,"yH@HAHDHFHKHMHTHYH^HaHcHfHhHjHoHqHsH{H|IFIHIRIZIbIeIgIoIpIsItIwI|"},
  {0,NULL,"JEJJJLJMJRJTJ]J`JaJhJnJpJvJwK@KDKEKHKJKLKQKVK`KbKeKhKkKqKvKwK~LCL"},
  {0,NULL,"ILLLNLOLWL\\LcLdLjLkLpLrLuLwLyL|MCMEMGMHMIMJMNMQ_A?F?M?U?`?c?e?g?h"},
  {0,NULL,"?i?l?o?s?{@A@C@E@F@G@H@N@O@\\@_@m@r@t@u@~A@ACAKARAVAWA]AaAcAdAhApA"},
  {0,NULL,"rAzA{BGBHBIBKBMBNBRBZBeBgBkBoBpCACCCFCICMCSCUCWCXC^C`CeCgCiCnCvCw"},
  {0,NULL,"C|DDDEDTDVDXDfDjDkDmDqDtDvDwD~EAEPEVEWE[E]E_EhEjEkEqEyEzE~FFFHFLF"},
  {0,NULL,"MFNFUFYFeFhFmFnFqFrFuF{F}GCGFGQGVGYG^GaGhGmGnGzG{G}G~HKHMHNHTHUHW"},
  {0,NULL,"HZH[HgHhHjHnHpHrH|H}IGIIIPIZI\\IbIfIkInItIuIxJ?JEJKJNJRJSJZJ[J\\JdJ"},
  {0,NULL,"lJmJqJuJxJ{KBKFKGKIKPKYKZKaKcKmKnKpKsKuKxK{K}LELKLPLRLTLXLZL[LgLi"},
  {0,NULL,"LjLkLpLrLyL|L~MCMEMGMHMIMJML_A?G?O?Y?]?^?e?f?g?m?n?q?w?{?|?~@?@D@"},
  {0,NULL,"G@K@U@W@\\@a@i@r@s@w@~AAAEAGASAYA\\A]AaAcAgAnApAtAvAzA}BABDBGBJBSBT"},
  {0,NULL,"BVBeBfBjBoBzC?CACBCJCNCRCUC\\C`CdCfCgCjClCnCuCxC~DADCDFDNDYDcDeDnD"},
  {0,NULL,"pDrDtDvD{D}EFEMEOEPEQEYE^EcEjElEoEvEyE}FCFLFNFUFWF[F^FcFgFlFnFrFt"},
  {0,NULL,"F{F|G?GBGHGOGQGRGZGaGfGgGlGyG{HEHGHLHMHPHVHXH[H\\HaHcHgHiHmHnHoHwH"},
  {0,NULL,"{IAICIDI[IgIhIjInIpIrIuI~JBJEJHJIJTJUJWJ\\JaJcJgJmJoJ{J~KAKBKFKGKM"},
  {0,NULL,"KSKTKZK^KcKfKjKlKnKxK{L?LBLHLJLQLRLSLTLaLbLgLiLjLmLtLuLwLyL~MBMFM"},
  {0,NULL,"GMIMLMNMQMY_A?E?P?X?Z?^?d?g?h?i?j?u?x?|@@@A@B@F@G@I@R@S@U@[@j@o@u"},
  {0,NULL,"@x@zABAEAKAMAOAPAVAYAcAfAlArAsAwAxA}B@BABBBFBVB[B^BcBgBhBvBxC@CGC"},
  {0,NULL,"LCMCOCQCRC]C`CdCjCkClCmCqCrCzC{DADEDHDNDZD^DaDbDfDgDmDvDyEAEBEMER"},
  {0,NULL,"ESETEVE\\EdEnEqEtEvExF?FFFLFMFOFSFVF[FbFfFmFoFvFwFyFzF~G?GBGLGOGXG"},
  {0,NULL,"[GiGkGnGsG{H?HEHGHIHLHOHSHVHZH_H`HbHeHlHqHwHxH|H~IDINITIYI\\I]IcId"},
  {0,NULL,"IfIqIuIxIyJJJLJNJOJQJWJ[J`JbJlJnJpJvJwK@KDKFKIKOKSKWK\\KcKeKlKmKqK"},
  {0,NULL,"rKvKxKyLILJLKLQLTLVLXL\\LdLfLhLlLmLoLqLvLxL}MAMBMDMOMPMRMS_A?F?O?Y"},
  {0,NULL,"?[?_?`?f?g?i?k?x?z?{?~@@@B@F@J@L@M@Q@V@b@i@o@u@x@{A?ACAGAMANAQAUA"},
  {0,NULL,"^AbAfAjAsAuAxAzA}A~BBBHBLBQBUB]BaBmBqByB{CACHCICKCNCQCTCVCXC[C_Cd"},
  {0,NULL,"CeCfCvCwCyC}C~DCDKDODPD^DdDeDfDgDtDxDzECEGEHEIEPEQEZE]EcEnEqEtEuE"},
  {0,NULL,"{E~FCFIFJFQFVF\\F]FbFjFoFpFsFuFyF{F~G?GAGPGWG\\G`GdGeGqGrG|G~HCHFHK"},
  {0,NULL,"HLHPHQHWHYH[H]HaHeHkHnHoHvHyH}IEIJIMIYI\\I]IlInIpIsIvIzI{JDJHJIJKJ"},
  {0,NULL,"RJXJ[J`JbJgJpJsJwJzKCKDKKKLKQKRKVK\\K`KdKiKkKoKtK~L@LDLFLGLLLMLNLU"},
  {0,NULL,"LYL_LcLgLiLkLlLuLwLzL|L~M@MAMHMJMLMNMQMWMX_A?D?K?W?\\?]?c?f?h?j?k?"},
  {0,NULL,"u?z?}@@@B@D@F@H@K@O@T@W@c@k@o@u@x@}A@AAAIARAZA[A^AaAcAjAlArAuAwAz"},
  {0,NULL,"A~B@BDBFBHBPBRBSBYBkBlBsBtC?C@CBCCCDCNCUCWC[C\\C^CbCcCkCoCpCxC|D?D"},
  {0,NULL,"BDFDWD\\D^DfDgDhDiDuDwD{EDEEEJEKEUEWEXE^EeEnEqEtEwEzE}FEFJFLFPFUFY"},
  {0,NULL,"FZFfFjFmFpFsFuFvFwFzF{F|GNGRGTGVGbGhGwGxGyGzHBHFHHHNHOHUHXHaHbHcH"},
  {0,NULL,"dHgHrHtHzH{I?I@IAIKIOIYI\\I]I_IaIoIrItJ@JAJCJFJGJMJSJUJ[J`JbJjJpJq"},
  {0,NULL,"JuJwJxKDKFKGKHKJKPKVK^K_KaKbKhKnKwK{K|LBLCLELOLRLSLWL[L`LeLnLpLrL"},
  {0,NULL,"vLyL{L|M?MCMEMGMHMKMOMTMXMY_A?G?K?W?^?_?a?f?h?l?n?o?y?{?}@A@C@D@I"},
  {0,NULL,"@L@M@S@X@^@k@q@v@y@|A?AEAIAMAQATAYA_A`AdAeAqAtAwA~B?BABKBLBMBUBWB"},
  {0,NULL,"`BcBfBjBnBrC@CKCLCOCRCSCUCVC[C`CaCcCeCfCoCsCwDADBDDDGDNDOD_DiDjDo"},
  {0,NULL,"DqDuDxDyD}D~EJEMENEWEZE_EeEiEmEpEuEvE|FEFGFRFTFVF[F\\FaFeFkFlFqFsF"},
  {0,NULL,"zGAGBGCGDGLGMG]G`GcGfGjGlG{HCHFHHHJHKHPHVHYH_H`HbHgHhHjHrHsHvHwI@"},
  {0,NULL,"IDIEILI^IaIbIiIkIoIqIvI~J?JFJMJPJRJWJZJ]J_JfJjJoJrJyJ}J~KAKNKRKSK"},
  {0,NULL,"UKXK\\KcKgKlKoKsKtKxKzK}LDLFLJLMLPLQLTLUL]LeLjLkLnLpLrLsLxM?MCMEMI"},
  {0,NULL,"MJMKMMMPMW_A?D?K?W?\\?]?c?f?h?j?k?u?z?}@@@B@D@F@H@K@O@T@W@c@k@p@s@"},
  {0,NULL,"v@}A@AAAFALAXAZA\\A]AaAjAlAqAtAxA|B?BABGBLBMBPBRBSBYBfBrBuBwB~C?CG"},
  {0,NULL,"CMCNCPCTCWCXC_CgCiCkClCoCrCvC}D?DADTDUD[D^D`DbDcDdDhDwD{EBECEQESE"},
  {0,NULL,"WEXEZE\\EeEoEpEsEwEzE}FDFKFNFUFXFZF^FfFjFkFlFqFrF~G@GAGBGDGNGRGTGV"},
  {0,NULL,"GjGlGtGvG|G}G~HGHMHNHOHSHZH]H^HaHcHfHlHoHrHvH~I?IGIHISIYI_I`IdIhI"},
  {0,NULL,"lIrItIyIzJCJFJKJLJWJXJ_JcJeJkJoJrJyJ}J~KAKEKGKHKMKZK[K`KcKeKfKpKt"},
  {0,NULL,"KuKxK~LDLHLILNLTLULZLaLdLhLiLlLmLqLtLwLzL}L~M@MAMBMDMFMQMVMZ_A?E?"},
  {0,NULL,"N?T?`?b?d?f?h?j?n?q?r?|@?@B@C@D@H@L@N@Q@Z@d@h@n@o@y@zACADAIAQARAU"},
  {0,NULL,"AWA^A`AgAmAqAuAxBBBCBEBGBIBJBNBXBaBbBlBnBqB|B~CACCCICJCMCOCYC\\C_C"},
  {0,NULL,"eChClCmCpCtCuC}DADEDMDSDVD^D_DaDcDiDpDwDxD}EDENEPEREXEYE\\EgEmEnEr"},
  {0,NULL,"ExE~F@FEFGFHFIFJFYF\\F`FgFkFpFrFxFyF}F~GGGHGJGUGWG^GbGcGeGpGyG|H?H"},
  {0,NULL,"AHDHGHKHUHWHZH[H\\H_HfHiHnHsHxH~I?IFIIIWIYI^IaIcIhIjItIvI~J@JGJNJT"},
  {0,NULL,"JWJXJYJ^JbJfJjJsJtJzJ|K?KCKLKPKRKUKVKYKbKjKkKnKoKsK{K}L?LCLFLLLML"},
  {0,NULL,"OLPLRLbLcLgLhLlLmLqLtLuLzL}M@MAMBMDMFMLMNMVM\\_A?G?P?X?]?_?b?g?h?l"},
  {0,NULL,"?m?p?v?|?}?~@A@E@H@J@P@T@V@Z@j@n@p@tA?AAADAKALAQAWAXA^AaAiAkApAqA"},
  {0,NULL,"yA|B@BBBDBEBLBOBQBYBbBnBoBrBzCACBCKCOCPCQCTCVCWCYC\\CcCjCkCqCrCtCw"},
  {0,NULL,"CxD@DFDOD]D`DaDkDlDmDsDwDzD~EFELERETEZE[E^EdEkErEsEuE}F@FFFHFJFKF"},
  {0,NULL,"UFXF\\FdFiFkFnFvFxFyF|G@GAGEGJGNGPG_GaGcGgGjGyHCHDHEHHHNHOHXHYH[H]"},
  {0,NULL,"H^H_HeHpHqHuHvHxH{IAIBIEIZI`IcIeIfImIsItJ?JBJLJOJRJUJVJYJ^JdJeJlJ"},
  {0,NULL,"oJtJ|J~K?KAKEKGKRKVKYK[K]K^KnKoKpKtKuK{LALBLDLFLMLRLSLULZL^LfLhLo"},
  {0,NULL,"LqLsLtLzL{L}M@MDMFMMMRMSMTM_M`_A?E?P?X?Z?^?d?g?h?i?j?u?x?|@@@A@B@"},
  {0,NULL,"F@G@I@R@S@U@[@j@p@s@v@zABAEAJAPASAYA\\A_A`AfAlApAqAvA|BDBEBHBLBMBV"},
  {0,NULL,"B[B^BcBiBnBzB|C?C@CFCHCICJCLCZC^CaCbCdCeClCpCqCwCzC|DCDJDMDRDbDdD"},
  {0,NULL,"fDhDjDnDvDyEDEGEIEJEREVE]E^EdEoEpEsEvExF?FBFGFRFSFWF[F^FbFfFkFnFq"},
  {0,NULL,"FtFuFxF|G@GAGLGOGXG[GcGgGpGuGzH@HBHGHJHKHLHQHTHWH\\H`HbHcHxHyH{H|H"},
  {0,NULL,"}I@IVIWIXI\\I_IbIdIgIlIqIuI{J@JGJIJJJOJRJSJ_JcJeJhJoJtJ|J~K?KAKMKN"},
  {0,NULL,"KSKTKUKWK^K_KdKgKjKoKzK|L?LBLFLGLMLSLYL]L`LbLeLgLiLjLkLnLyL|L~M?M"},
  {0,NULL,"GMHMIMJMKMLMUMZM^_A?D?M?U?[?\\?a?g?h?j?m?r?w?|@?@D@E@F@I@J@X@Y@]@b"},
  {0,NULL,"@m@r@s@w@{@|@}AJANASATA[A_AbAmAnApArAyAzA{BABBBGBKBWB\\B]B_BiBkBpB"},
  {0,NULL,"tB~CBCDCECGCHCOCVC[C_CaCfCkCmCrCsC|C}D@DEDGDPDWDaDbDcDlDnDrDyDzD|"},
  {0,NULL,"EDEHERESEXE[E_EhEjElEoEwE{E|FBFPFQFRFTFWF]F`FcFmFnFrFyF{GBGCGEGFG"},
  {0,NULL,"IGKG\\G]GhGmGuGxG|H?HCHFHJHOHPHQHRHSHXH_HdHfHjHkHlHpHxI?ILIMIOI[Ic"},
  {0,NULL,"IdIeIgIhIqIsIwJ@JLJNJPJSJVJXJ\\JaJcJhJmJqJuJxJ{KBKJKKKNKQKTKXKaKdK"},
  {0,NULL,"gKhKkKsKwKzK}LELGLLLPLWLYL[L]LcLfLhLlLmLoLqLsL{L}MAMBMDMMMRMSMT_A"},
  {0,NULL,"?E?N?T?`?b?d?f?h?j?n?q?r?|@?@B@C@D@H@L@N@Q@Z@d@h@r@s@w@zACADAFAUA"},
  {0,NULL,"VAWAXA]AbAgAmArAtAvAyA{A}A~BDBKBNBXBaBbBgBuBxB}C@CACDCICKCPCQCXCZ"},
  {0,NULL,"C`CbCcChCmCoCpCtCyCzDDDKDZD]DcDhDiDnDqDrDwDxE@EBEJELENEUE\\E]EgEjE"},
  {0,NULL,"lEoExE~F@FDFHFIFMFNFXF]F`FgFlFmFsFtF|G?GCGEGFGJGUGWG^GnGoGsGvG{G~"},
  {0,NULL,"H?H@HAHBHHHWHYH[H^HbHdHeHsHtHuH}H~I@IBIJITI[I_IaIgIhIkItIvIyI}JDJ"},
  {0,NULL,"FJGJJJYJZJ\\JaJcJkJmJnJvJ{K@KBKEKIKLKQKYKZK]K`KiKmKpKqKuKvK~L@LALK"},
  {0,NULL,"LNLXLZL\\L^L_LeLnLpLrLsLxLyL|M?MCMEMGMHMKMMMPMXMY_A?E?L?V?Z?\\?b?f?"},
  {0,NULL,"g?i?n?s?y?{@?@@@A@C@J@K@P@]@`@c@l@q@v@y@}ABADAHALAOATAXAZA[AeAhAs"},
  {0,NULL,"AtAwAyAzBCBJBLBMBOBPB\\BdBhBuBvB}B~CACDCFCGCHCRCXCYC\\C^CcCdCkCtCuC"},
  {0,NULL,"vC{C|DCDHDWD]D_DdDjDoDpDtDzD{E@EAEIELEOEPEVEXEfEiEmEpEwF?F@FAFKFO"},
  {0,NULL,"FPFTFXFZFaFhFlFoFqFzF{GAGEGGGHGIGSGTG_GiGkGoGvGyGzG~HDHHHLHOHQHSH"},
  {0,NULL,"THVH[HdHfHmHnHuHyH|I?IBINIOI^IbIiIjIlInIrIsIxI}JIJKJQJSJTJYJ]J_Jf"},
  {0,NULL,"JiJnJrJvJyJ}K@KEKHKJKOKXK[K]KaKeKhKpKrKuKwKyLALELILVLWLZL[L^LdLgL"},
  {0,NULL,"iLkLmLtLuLwL|L~MBMFMHMJMLMNMQMWMXM__A?G?O?Y?]?^?e?f?g?m?n?q?w?{?|"},
  {0,NULL,"?~@?@D@G@K@U@W@\\@a@i@n@o@y@~AAAEAHAOAPARAZA\\AcAgAnAsAuAxA{A~B?BBB"},
  {0,NULL,"EBHBSBTBVBeBhBsByB{C@CBCECFCJCLCPCWC`CaCgChCiCkCrCsCxCyDCDDDJDUDX"},
  {0,NULL,"DaDiDoDpDrDsDvD{D|E@EHEJELEMEQE[EcEmEnErEvEyE}FAFLFOFSFYFZF^FcFgF"},
  {0,NULL,"oFpFsFuFxFyF~GDGFGOGQGRGZGkGqGrGwG{G}HAHJHMHNHOHRHTHXH\\H^H`HbHkHo"},
  {0,NULL,"HpHuHwI@IHIPIXI[IaIcIiIjImIrIuIwI}JDJIJLJPJUJZJ^JbJfJiJpJsJwJzKCK"},
  {0,NULL,"DKFKHKMKOKPKWK_K`KaKdKeKmK|K~LELGLILKLNLXLYL[L`LdLnLoLpLqLsLvLxL{"},
  {0,NULL,"MCMDMKMMMOMPMSMTMUMVM[M]_A?G?K?W?^?_?a?f?h?l?n?o?y?{?}@A@C@D@I@L@"},
  {0,NULL,"M@S@X@^@k@r@t@u@|A?AEAFAMANAPAVA_AbAdAeArAuAzA|B@BCBFBGBHBUBWB`Bc"},
  {0,NULL,"BsBtBxB{B~CECJCQCRCSCTCVCYCZCaCdCiClCtD?D@DADBDCDJDLDQD_D`DcDmDqD"},
  {0,NULL,"tDxDyE?E@EJEOETEXEYEZEeEjEkEqEuEvE|FDFMFQFRFSFVF]FaFeFmFpFrFuFvFw"},
  {0,NULL,"F{G@GGGLGMG]G`GqGsGwGxG}H@HCHDHGHJHLHRHVH\\H]HeHfHhHiHmHqHvI?I@IQI"},
  {0,NULL,"RIXI^I`IfIhIkInIqIvI|I}JCJIJMJVJWJYJ[J\\JdJkJpJqJuJwJxKDKIKKKNKQKW"},
  {0,NULL,"K\\K_KdKhKiKqKrKvKwKyK|L@LGLVLWLYL\\L_L`LfLgLlLmLoLtLuLzM@MAMBMFMLM"},
  {0,NULL,"NMRMSM[M\\Mc_A?F?O?Y?[?_?`?f?g?i?k?x?z?{?~@@@B@F@J@L@M@Q@V@b@i@p@s"},
  {0,NULL,"@v@{A?ACAHAQATAWAXA_AbAfAjApAtAvB?BABDBEBFBGBQBUB]BaBjBoBpB}CCCDC"},
  {0,NULL,"ECLCQCSCTCWCYC[C]CeChCmCxCyC{C~DBDEDIDLDVDbDdDgDhDoDsDxDzEAEEEHEK"},
  {0,NULL,"EMEPETEUEcEoEpEsEuE{E~FAFHFRFTFXF\\F]FbFjFlFnFrFtFwFxF|GBGDGPGWG\\G"},
  {0,NULL,"`GaGfGmGoH?HAHDHFHIHKHNHRHUH]H`HdHeHhHkHnHqHtHwHzIIIRIUI]I_IdIiIl"},
  {0,NULL,"ImIsIvIxJAJDJHJMJNJQJUJ_JcJeJiJmJoJ{J~KAKBKEKNKQKRKXKYK]KhKlKnKqK"},
  {0,NULL,"sKvKwK{K}LALJLPLQLRLWL\\L^LeLfLhLrLsLvLxL{L}M?MEMMMOMPMRMTM^MaMcMd"},
  {0,NULL,"_A?E?L?V?Z?\\?b?f?g?i?n?s?y?{@?@@@A@C@J@K@P@]@`@c@l@r@t@u@}ABADAGA"},
  {0,NULL,"LANASA[A^AaAeAhApAuA{A|B?B@BFBIBKBOBPB\\BdBiBlBqBzB~C?CCCGCKCLCPC]"},
  {0,NULL,"C^C_CaCcChCjCoCqCsCuCyC{DRDSD[DgDmDoDqDrDtDzD{D}EGEIEKELEMENESEfE"},
  {0,NULL,"jEkEqEwF?F@FCFJFKFPFQFUFWFaFhFnFpFvFwF}G@GCGDGFGIGSGTG_GbGeGgGuGz"},
  {0,NULL,"G|HAHEHHHIHJHSHUHYH^H`HcHfHlHsHuHwHyHzIFISIVI[I]IfIiIkInIrIsI{I~J"},
  {0,NULL,"DJFJOJPJQJTJ[J\\JdJgJqJtJuJxJ|K?KGKJKKKTKVK[K^KbKfKgKkKtKzLBLCLDLH"},
  {0,NULL,"LLLOLSLUL]LaLcLfLhLnLpLsLvLxL{L}MCMKMMMOMPMRMTMUM]MaMc_A?D?L?V?a?"},
  {0,NULL,"c?d?f?g?k?m?p?t?}?~@?@@@E@G@L@R@^@_@d@l@n@p@t@z@|A@AHAPARAVAWA_A`"},
  {0,NULL,"AiAoApAuA|A}B@BIBJBKBLBXBZB[B`BiBlBpBsC@CHCMCNCOCRCSCXCZC\\CbCfCiC"},
  {0,NULL,"mCsCuCvCzC~D?DGDZD\\D`DdDeDkDpDsDvDxD|EEEIEKEOEQE\\E_EfEkErEsExEzE|"},
  {0,NULL,"FAFGFHFMFRFSFYF_FiFnFpFvF}G?G@GAGCGHGMGUGXGYGbGmGuGwGyG}G~H?H@HBH"},
  {0,NULL,"PHQHVHZH_HaHbHhHjHmHoHyHzH~IKILITIZI`IjIlImIpIuIvIwJAJCJHJJJKJPJT"},
  {0,NULL,"J^JdJeJiJqJtJuJxJ|K?KIKNKPKUKWKYK_KbKgKmKqKsKvKzK|K}LCLKLOLPLXL\\L"},
  {0,NULL,"]L`LgLiLjLlLuLwLyLzL~M@MAMGMIMLMNMQMYM`MbMg_A?F?N?T?Z?[?e?f?h?k?l"},
  {0,NULL,"?t?v?}?~@B@C@E@I@K@Y@[@`@a@h@q@w@x@{@~ABAIAOASATAYA[AcAkAoArAtAvA"},
  {0,NULL,"xAyA{A|A}BCBTB^B_BdBgBjBkB}CBCFCHCJCLCMCTCYC]C^C_CfCiCjCqCtC}C~D?"},
  {0,NULL,"DDDIDRDXD^D_D`DeDlDuDyD{D~EEEIEUEYEZE[E\\EgEiElEtEyE{F?FEFLFOFPFTF"},
  {0,NULL,"WF[F_FdFlFmFtF~G?G@GEGFGGGKGSGZG[GfGhGnGoGzG|G}HDHEHIHPHQHTHXHZH\\"},
  {0,NULL,"H]H`HiHpHtHvHyH~IPIUIVIYI^I`IeIoIpIqIrJ?JAJCJHJOJXJYJZJ]J`JaJjJmJ"},
  {0,NULL,"nJvJ{K@KBKFKJKOKSKTKXK]K^KaKgKlKmKzLALBLELJLKLQLSLXL[L]L^LfLiLlLm"},
  {0,NULL,"LoLtLwLzL~M@MAMBMFMQMRMSMZM[McMe_A?D?L?V?a?c?d?f?g?k?m?p?t?}?~@?@"},
  {0,NULL,"@@E@G@L@R@^@_@d@l@q@w@x@z@|A@AGAMAUAVAYA]A`AiAoAsAtAwAyA{BCBEBFBM"},
  {0,NULL,"BXBZB[B`BfBmBuBvCCCECICMCOCPCUCVCWCZC]CaCbClCpCsCvCxC{D@DMDQDTDeD"},
  {0,NULL,"gDlDrDsDuDvDxECEFEHEKELEOEREWEfEiElEtExEzE|FCFGFIFMFNFVF[F_FiFlFo"},
  {0,NULL,"FqFwFxFzGEGFGGGMGUGXGYGdGiGlGvH@HBHCHGHIHJHNHRHUHWHZH^H_HgHkHmHrH"},
  {0,NULL,"uHxHzIGIQIWI[I]IeImIoIpIuIvIzJBJGJKJPJQJUJVJ]J`JaJgJnJrJvJyJ}K@KI"},
  {0,NULL,"KLKSKUKZK\\KcKiKjKoKpKrKuKxKyL?L@LFLMLTLVLZL_LbLeLoLqLrLsLvLxL{M?M"},
  {0,NULL,"DMEMMMOMPMSMTMVM[M^Md_A?C?H?R?S?V?Y?h?p?q?s?t?w?x?y?z@M@R@V@\\@]@a"},
  {0,NULL,"@c@d@e@f@i@lA@AAACADAGAHAUA]A^AaAvAwA~BDBHBIBKBMBWB^B_BcB~CBCECGC"},
  {0,NULL,"HCJCLCMCOCQCRCTCnCoCpCuCvCwCxCyDFDKDNDPDQDRDSDTD_D`DaDbDfDnDqDuDw"},
  {0,NULL,"DyEHEIEMEOETEXE[E\\E`EbEcEfEvE{E|F?FAFCFQFVFWF[FrFvFyF~G@GBGEGGGJG"},
  {0,NULL,"NGVG^GyGzG{G~H@HAHBHFHHHKHMHNHiHkHlHmHvHwHxHyIAIDIFIGIJIMIQIVIYIZ"},
  {0,NULL,"I_IaIbIeIfIhIqItJDJJJKJMJSJTJUJZJ[J\\J`JaJgJiJmJuJvJwKGKKKLKMKRKSK"},
  {0,NULL,"TKUKVKZK[K\\K^KcKdKgKiKkKlKrKuKxK{K~L@LBLCLLLMLPLUL^L`LaLbLdLiLuLx"},
  {0,NULL,"L{L~MNMPMTMZM\\MiMl_A?C?I?Q?S?U?X?f?o?p?r?s?u?v?w?x@O@P@S@U@Y@Z@_@"},
  {0,NULL,"b@f@g@j@m@}@~AAABAJAKASAZA[A\\AxAzA|A}BCBGBJBLBUBXB`BaC@CCCDCECICK"},
  {0,NULL,"CLCOCPCQCSCUCnCqCrCuC|C}D?DCDGDKDLDMDRDUDWDYD_DcDdDeDgDiDqDsDxD{E"},
  {0,NULL,"LEMERETEUEWE]E_EaEbEdEhEuExE|E~FBFFFGFIFRF]FsFwFxFzF|GCGDGFGRGSGT"},
  {0,NULL,"GZGyGzG|G}G~HDHEHGHLHMHOHPHjHkHqHsHxHzH}I@ICIHIJILIOIRIVIWIYI[I_I"},
  {0,NULL,"`IiIjInIoIrIvJEJHJKJLJOJSJWJYJ]J_JaJcJhJlJnJyJ{KAKHKJKKKLKMKNKPKQ"},
  {0,NULL,"KTKUKVKWK`KgKhKiKjKoKqKsKwKzK~L?LBLELHLILOLRLULVLXLYL`LcLfLjLqL|M"},
  {0,NULL,"DMHMIMRMVMXMbMc_A?C?J?Q?R?T?W?g?o?q?r?t?u?v?y?z@N@Q@T@W@X@[@^@`@e"},
  {0,NULL,"@g@h@k@z@~A@AEAFAIARAYA`AcAyA{B?B@BABBBEBFBOBQB\\B]B~C?CACDCFCHCIC"},
  {0,NULL,"KCNCRCSCTCpCqCsCxD?DADDDEDIDMDNDODSDWDXD\\DaDdDgDkDlDnDoDtDvDzENEO"},
  {0,NULL,"EQEUEVEXEZE]E`EaEeEgEuEwE{F@FDFEFJFPFTF\\FqFtFuF{F}G?GAGHGOGQGXGYG"},
  {0,NULL,"{G}H?HAHBHCHEHGHIHJHNHOHjHnHsHtHvHyH{I?IDIEIFIKIOIPIUIWI[I\\IbIdIf"},
  {0,NULL,"IjImIpIsIuJCJDJGJLJQJVJWJZJ]J`JbJfJjJkJpJrK@KCKFKGKJKNKPKRKSKTKUK"},
  {0,NULL,"VKXKYK]KaKbKhKkKlKoKtKxK|L?LCLELFLJLKLPLRLSLYLZL\\L]LaLeLmLpLzM?M@"},
  {0,NULL,"MBMCM]M^M`Mk_A?C?I?Q?S?U?X?f?o?p?r?s?u?v?w?x@O@P@S@U@Y@Z@_@b@f@g@"},
  {0,NULL,"j@m@z@|A?ACAJAKAMAQAVAWAxAzA|A}BCBGBJBLBPBSBTBdC?C@CBCCCDCECFCGCK"},
  {0,NULL,"CLCPCUCtCvCwCzC~D@DADEDFDHDODQDVDXDZD[D^D`DhDoDpDrDtDuDxD{EHEJEKE"},
  {0,NULL,"NESEVE[E^EaEbEdEhEwEyE}F?FBFFFKFLFOFUFsFwFxFzF|GCGDGFGMGUGWG`GyG|"},
  {0,NULL,"G}G~H?H@HCHDHGHKHLHPHlHpHrHtHuHwH{H|IAIEIIINIPIQISITI]I^IaIhIkIlI"},
  {0,NULL,"mIpIrIvJCJIJJJNJRJTJVJXJ[J^JbJdJhJlJtJxJzKDKEKFKGKIKOKRKSKXKYKZK["},
  {0,NULL,"K\\K^KaKeKfKmKnKrKtKvKyK{K}L@LDLFLKLNLQLTLWLZL]L^LbLhLkLoLyL}MGMJM"},
  {0,NULL,"SMWMYM[Ma_A?C?H?R?S?V?Y?h?p?q?s?t?w?x?y?z@M@R@V@\\@]@a@c@d@e@f@i@l"},
  {0,NULL,"@{@|ABAEAGAHAOAPATA_AvAwA~BDBHBIBKBMBNBRBYBbB~CACBCCCGCJCMCNCOCPC"},
  {0,NULL,"QCTCsCzC{C|C~DBDCDDDGDHDIDJDUDVD\\D]D^DcDhDiDjDkDlDmDwDyEKELEPEQER"},
  {0,NULL,"ESEYEZE`EbEcEfEzE}E~F@FAFCFHFXFYFZFrFvFyF~G@GBGEGGGKGLG[G]GzG{H@H"},
  {0,NULL,"BHFHHHIHJHKHLHMHPHnHoHpHqHuHzH~I?IBIHIIIKILINIUIXI\\I^I`IcIdIgIkIo"},
  {0,NULL,"IqItJEJFJGJHJIJPJQJRJ^J_JeJfJgJiJsJ|J}J~KEKFKHKIKJKNKOKPKQKWKXKYK"},
  {0,NULL,"]K_K`KbKeKnKpKsKyKzK|K}LALGLILJLSLTLWLXL[L\\L_LcLgLsLvLwMLMMMOMQMe"},
  {0,NULL,"MfMhMj_A?C?J?Q?R?T?W?g?o?q?r?t?u?v?y?z@N@Q@T@W@X@[@^@`@e@g@h@k@{@"},
  {0,NULL,"}A?ADAFAIALANAXAbAyA{B?B@BABBBEBFBVBZB[BeC?C@CACFCHCICJCMCNCRCSCU"},
  {0,NULL,"CoCrCtCyC{C}D@DBDJDLDPDTDYDZD[D]DbDeDfDjDmDpDrDsDvDzEIEJEPEWEYE\\E"},
  {0,NULL,"^E_E`EaEeEgEvExEyEzFDFEFMFNFSF^FqFtFuF{F}G?GAGHGIGPG\\G_G|H?HAHCHD"},
  {0,NULL,"HEHFHHHIHJHNHOHiHmHoHrH|H}H~I@IBICIGIMIRISITIXIZI]IcIeIgIiIlInIsI"},
  {0,NULL,"uJFJMJNJOJPJUJXJYJ\\JcJdJeJjJkJoJqK?KBKEKHKIKKKLKMKOKQKWKZK[K\\K_Kc"},
  {0,NULL,"KdKfKjKmKpKqKuKvKwLALDLGLHLLLMLNLOLQLVL[L_LdLlLnLrLtMAMEMFMKMUM_M"},
  {0,NULL,"dMg_A?H?L?Q?Y?_?e?i?j?k?m?n?p?s?t?y?|@B@D@F@O@X@Z@[@g@l@q@t@~A?AI"},
  {0,NULL,"AJARASA[A^A_A`AeAhAiAoA{BFBJBLBRBWB^BbBpBqBsBuBvBzC?C@CFCQCTCUCVC"},
  {0,NULL,"YC_C`CgCmCnCvC{DDDIDKDLDNDODUDXDYDZD[D^DbDiDnD|D}EBEDEEEGELEOETEZ"},
  {0,NULL,"EaEfEiEkEuEyFBFEFGFJFPFRFWFYF_FaFhFiFwGAGFGHGJGVG[G]GeGgGiGmGvGwG"},
  {0,NULL,"{G|H?HCHDHMHTH]HbHcHeHgHmHqHuHvICIDIEIHIJIPIRISITIUIYIaIdIgIwIyI{"},
  {0,NULL,"I~J@JAJEJKJQJZJ]JdJkJlJnJrJvJyJ}K@KJKNKPKTKUKVK`KbKfKgKlKmKqKtKvK"},
  {0,NULL,"zK~LCLDLHLJLKLNLOLQLULXL\\L]LaLfLjLpLwLxLzM@MCMIMPMQMRMVMXM^MiMjMk"},
  {0,NULL,"MnMo_A?I?M?R?X?^?b?i?j?k?l?m?o?r?s?w?}?~@@@B@Q@^@a@c@e@m@r@yADAEA"},
  {0,NULL,"HAIARATAWA[A_AcAdAhAmAnAyBABHBIBPBTB`BaBgBiBmBoBtBwCHCJCKCMCPCRCW"},
  {0,NULL,"C[CcCdChClCnD@DADCDHDJDMDNDODPDSDTDUD]D^DdDsDuD|D~EAECEDEEELENESE"},
  {0,NULL,"]E`EhEjEmEvF@FAFEFHFLFPFRFTFYF`FcFeFhFuF}GBGEGMGTGWGZGaGdGnGtGuGx"},
  {0,NULL,"HAHFHGHHHLHNHQHVHYHZH\\H^HlHsHuH}IBIDIEIFIGIHIMINIWIXIYIlImIoIwIxI"},
  {0,NULL,"zJ?J@JAJEJIJVJWJ\\JfJgJkJrJsJyJzJ}KCKFKJKNKPKXKYKaKcKdKeKkKoKpKsKu"},
  {0,NULL,"KxK}LELFLGLILLLMLPLTLYLZL[LcLdLgLkLmLpLqLsMBMCMDMJMLMMMYM^M`McMeM"},
  {0,NULL,"fMoMq_A?H?O?Q?V?\\?d?i?k?l?m?n?q?w?x?z?}@A@C@E@N@S@T@Y@g@i@o@s@z@}"},
  {0,NULL,"AFAJANAPAUAZA\\AbAfAgAjAnAzA}B?BEBNBYB_BcBhBjBmBoBqBsC?CDCFCKCMCOC"},
  {0,NULL,"VC^CcCiClCmCoCxC|C~DGDMDODRDTDWDXDZD[D]D`DjDlDqD|D~E?E@ECEGEMEPER"},
  {0,NULL,"E\\EaEcEnEoEwExFBFDFIFQFSFZF]F^FbFcFgFjFxF{G?GDGKGLGNG^GaGdGeGfGkG"},
  {0,NULL,"wGzG}H?HCHGHHHTHYHZH_HcHdHnHwHxH~IBIEIGILIOIPISITIVIWI`IbIeIkIwIz"},
  {0,NULL,"I{I|I}J?JFJHJSJUJbJcJjJlJmJoJ{J~KAKBKHKKKLKMKQKWK`KaKdKgKmKoKpKtK"},
  {0,NULL,"uKzK~LDLELFLGLKLMLNLULXLYLZL[L]LiLlLnLqLsL|L~MAMDMHMKMMM\\M_MbMcMd"},
  {0,NULL,"MfMnMr_A?J?K?S?T?Z?`?j?k?l?m?n?o?u?y?z?|?~@?@E@U@V@]@_@f@k@u@vABA"},
  {0,NULL,"CAHAJAPARAZA[A_AbAdAeAjAlAwA|A~BGBQBVBZB\\BfBkBlBrBxB{CACBCECGCICL"},
  {0,NULL,"CXCZC\\C]CeCjCoCqC{DADFDHDIDKDMDQDRDVDYD]DlDnDpDsD|E?E@EDEEEFEPEWE"},
  {0,NULL,"ZE]EbEeEpEqE~F?FAFBFPFRFSFYFZF]FaFeFfFjFrFsFzG@GIGOGPGYGbGhGjGlGq"},
  {0,NULL,"GsGyG~H@HEHIHKHRHSHWHXH[H`HnHrHvH}IAIBICIIIJINIQIUIVIWIeIgIjImIwI"},
  {0,NULL,"|I}J@JAJBJFJOJQJWJ[J_JgJlJoJrJyJ}J~KAKHKJKNKPKQKWK]K^K_KhKiKjKnKr"},
  {0,NULL,"KwKyK{K|L?L@LALBLRLSLVLWL^L_L`LbLeLfLgLtLvL|M?MFMHMLMOMRMVM]MbMeM"},
  {0,NULL,"gMhMnMq_A?I?P?R?U?[?c?i?j?l?m?n?p?u?v?x?{@?@C@D@M@W@`@d@e@j@p@x@{"},
  {0,NULL,"A@AFAHAOAPAVAXAZAbAfAiAkAlAvB@BBBMBSBUBXBdBgBnBtBvByBzB~CCCHCRCTC"},
  {0,NULL,"UCWC_C`CbCfChCqCwC}C~DGDIDNDPDSDTDVDYD[D\\DcDoDpDqD|D}E?E@EAEBEKER"},
  {0,NULL,"EWE^E`EdEsEtEzE{FAFDFMFOFSFXFZF]FbFdFfFiFqFtFvFyGRGSGUG`GcGgGiGnG"},
  {0,NULL,"rGxG{G|HAHBHNHPHQHUHVH]HfHgHrHxHzH{ICIDIFIGIIIKILIMISIUIhIiIjIkIw"},
  {0,NULL,"IxIyI|I}I~JHJOJRJXJ`JeJgJjJoJtJ|J~K?KAKEKHKIKOKQKWKbKcKeKfKkKlKqK"},
  {0,NULL,"sKvKxK}LCLHLILJLLLOLPLQLTL\\LaLcLdLhLjLlLrLvLwL}MAMEMIMOMQMUMXM[M_"},
  {0,NULL,"MhMjMqMr_A?J?N?S?W?]?a?i?j?k?l?n?q?r?t?v?{@@@A@F@P@R@\\@b@f@h@n@w@"},
  {0,NULL,"|AAAHAKAOATAVAWAXAcAgAkAmAoAxBCBDBKBOB[B]BeBjBkBqBuBxB|C?CECLCNCO"},
  {0,NULL,"CQCVCXC\\C^CaCgCpCsC}D@DFDGDJDKDODQDRDUD[D\\DdDfDmDoD~E@EAEBEEEGENE"},
  {0,NULL,"QEYE^EbEgElErE|E}FAFFFHFLFMFOFTFXF_F`FdFgF|F~GCGGGQGXG\\G_GeGfGhGp"},
  {0,NULL,"GsGvGyGzG~HCHJHMHRH_H`HaHcHeHiHoHsH{IAIEIHIJIKILIQISIVIXI\\IfIiIlI"},
  {0,NULL,"xIyI{I}J?JAJGJPJVJXJ^JaJgJhJsJtJzJ|K?KCKEKFKIKOKXKYK]K^K_K`KgKiKm"},
  {0,NULL,"KtKzK|K~L@LALBLDLKLNLSLULXL]L^L_L`LnLoLsLwLyLzM@MGMKMMMQMSMWMaMdM"},
  {0,NULL,"fMjMkMpMq_A?I?P?R?U?[?c?i?j?l?m?n?p?u?v?x?{@?@C@D@M@W@`@d@e@j@p@x"},
  {0,NULL,"@{A@AGAIAQASAYA^A`AaAfAiAkAlAvB@BBBMBSBUBXBdBhBiBoBrBxB|CACDCECJC"},
  {0,NULL,"MCNCXC[C]CaCcCiCrCvCzD?DIDJDKDPDQDTDWDXD\\D]D_DiDrDtD}D~E@EDEFEGEH"},
  {0,NULL,"ETEUEVE`EdEsEtEzE{FCFEFGFJFUFWF[F\\FbFdFfFiFqFtFvFyGRGSGUG`GaGjGkG"},
  {0,NULL,"pGsGuG}G~HFHHHIHJHRHZH[H\\HaHdHkHqHtH|IBIGIJIKIMIOIPIQIUIXI[I^IaIn"},
  {0,NULL,"I{I}I~J?J@JBJCJJJKJLJ`JeJiJkJnJpJvJwK@KDKGKRKSKTKUKVK]K^K_KaKdKiK"},
  {0,NULL,"oKpKuK|L@LALBLELFLGLMLSLYLZL[L^L_L`LeLiLoLzL{L|L~M?M@MHMSMTM\\M]Ma"},
  {0,NULL,"MbMkMlMmMo_A?H?L?Q?Y?_?e?i?j?k?m?n?p?s?t?y?|@B@D@F@O@X@Z@[@g@l@q@"},
  {0,NULL,"t@~A?AFAKALAMAOAVAXA]AeAhAiAoA{BFBJBLBRBWB^BbBfBhBiBlBmB}CBCDCICJ"},
  {0,NULL,"CKCSC[CeCiCjCkClCsCuCwDBDFDJDLDMDODPDVDWDXDYDaDcDfDhE@EAEBECEDEFE"},
  {0,NULL,"IEKEYE[EaEfEiEkEuEyFDFFFKFMFNFOFVFXF_FaFhFiFwGAGFGHGJGVG[G]GbGdGk"},
  {0,NULL,"GlGoGuG}HEHFHGHKHOHWHXHYH\\HdHhHiHpHyHzIAICIEIIIMIOIPIRIWIXI\\I_IcI"},
  {0,NULL,"hIxIyIzI}J@JBJMJPJRJTJ]JdJhJjJqJtJuJxJ|K?KEKIKOKZK[K\\KaKdKhKjKnKo"},
  {0,NULL,"KpKrKuKwKyK{L?LELFLGLMLRLVLWLYLZL[LbLgLkLoLrLtL{MEMFMJMLMSMTMUMYM"},
  {0,NULL,"aMeMgMlMpMr_A?H?O?Q?V?\\?d?i?k?l?m?n?q?w?x?z?}@A@C@E@N@S@T@Y@g@i@o"},
  {0,NULL,"@s@z@}AIAKAQATAWAYAaAcAfAgAjAnAzA}B?BEBNBYB_BcBfBpByBzB{B}B~C@CGC"},
  {0,NULL,"ICSCUCYCZC_CbCjCkCpCyCzDCDHDLDMDQDSDWDYDZD[D\\D_DkDmDuD}D~E?EAEEEF"},
  {0,NULL,"EHEQESEXEaEcEnEoEwExFEFFFHFLFTFUF[F\\FbFcFgFjFxF{G?GDGKGLGNG^GgGlG"},
  {0,NULL,"mGoGqGrG|H@HBHDHEHOHSHWHbHfHgHhHkHlHoI?ICIFIKINIOIQIRISITIWIZI^If"},
  {0,NULL,"IoIxI|I~J?JAJBJDJGJIJJJbJcJhJkJpJsJwJzKCKDKFKGKRKSKXKYKbKfKhKjKlK"},
  {0,NULL,"nKqKrKvKwKyK{L?LCLHLJLOLQLRLVLWL\\LaLbLeLhLmLuLvLyL}M?MBMGMNMOMWMZ"},
  {0,NULL,"M[M]M`MhMoMp_A?I?M?R?X?^?b?i?j?k?l?m?o?r?s?w?}?~@@@B@Q@^@a@c@e@m@"},
  {0,NULL,"r@yADAEAFAGALAMANAUA\\A]AdAhAmAnAyBABHBIBPBTB`BaBkBpBrBvByB|B~C@CA"},
  {0,NULL,"CLCNCTCYC\\C]C`CaCbCtCuC|DEDFDIDJDLDNDRDSDZD\\D]D`DeDgDhE?EBECEEEFE"},
  {0,NULL,"GEJEME[E_E`EhEjEmEvF@FCFDFIFKFNFQFVF^F`FcFeFhFuF}GBGEGMGTGWGZGhGi"},
  {0,NULL,"GjGmGpGrGyG{HBHDHIHJH[H]H`HaHbHfHjHpHwI@IAIBIDIFIKIRITIUIVIXI]I_I"},
  {0,NULL,"`IpIyIzI{I|JAJBJNJSJTJYJ\\JfJiJjJmJqJuJxJ{KBKKKLKMKZK[K\\K]K^K_KbKf"},
  {0,NULL,"KiKlKqKvK|L@LALBLCLHLJLOLQLSL\\L^L_L`LaLfLnLtLuLxLyMFMGMKMNMPMRMVM"},
  {0,NULL,"WMZMdMgMiMmMr_A?J?K?S?T?Z?`?j?k?l?m?n?o?u?y?z?|?~@?@E@U@V@]@_@f@k"},
  {0,NULL,"@u@vABACAGAKALAMAQAYA]AaAdAeAjAlAwA|A~BGBQBVBZB\\BjBnBsBtBuBwCCCFC"},
  {0,NULL,"HCOCPCQC^CdCfCgChCmCyD?DBDEDGDHDKDPDRDSDUDVDXDZDaDeDkDrD|D}D~EBEC"},
  {0,NULL,"EFEIEJEVEXEbEeEpEqE~F?FCFFFKFNFUFVF[F\\FaFeFfFjFrFsFzG@GIGOGPGYGcG"},
  {0,NULL,"fGtGvGwGxGzH?HAHLHMHPHQHTHUH^H_HeHyH|I?I@IFIHIIIJILIMINIPITIVIZI["},
  {0,NULL,"IcIpIwIyIzI~J?JBJCJDJMJNJ[J_JhJiJpJqJuJwJxKDKGKRKSKZK[K\\K`KcKeKgK"},
  {0,NULL,"kKmKsKtKxKzK}K~LDLILKLLLNLPLTLULXL]LcLdLhLiLkLlLpLxL}L~MAMCMJMPMY"},
  {0,NULL,"M[M\\M^M_MiMmMp_A?J?N?S?W?]?a?i?j?k?l?n?q?r?t?v?{@@@A@F@P@R@\\@b@f@"},
  {0,NULL,"h@n@w@|AAAGAJANASAUA\\A^A`AgAkAmAoAxBCBDBKBOB[B]BeBgBlBnBwB{B}CBCC"},
  {0,NULL,"CGCPCRCSCWCZCdCeCfCkCrCtCxDDDFDGDHDLDNDQDTDUDVDWDbDgDjDtD}E?EAECE"},
  {0,NULL,"DEGEOEUE\\E_EbEgElErE|E}FBFCFGFIFJFQFWF^F_F`FdFgF|F~GCGGGQGXG\\G_Gb"},
  {0,NULL,"GcGnGoGqGtH@HKHLHNHOHPHSHUHVHXH^HhHjHmHtH~IAIDIGIHIIILINIOIQIRI]I"},
  {0,NULL,"bIdInIxIzI{I|I~J@JLJUJYJZJ^JaJiJlJmJnJvJ{K@KBKKKLKMKTKUKVKcKeKhKj"},
  {0,NULL,"KkKnKrKsKwKxKyK{K}L?LILLLPLRLTLVLWLbLcLdLjLmLqLrLuL{MBMDMEMIMNMTM"},
  {0,NULL,"UMXMZM`McMlMmMn_A?E?O?Y?^?`?d?f?g?i?n?q?r?u?v?x?|@B@G@L@M@Q@U@\\@l"},
  {0,NULL,"@r@s@v@~ABAEAGASAYA\\A]A_A`AeAhApAtAvAyA|BDBPBSBVBWBYB[B^BfBjBoBrB"},
  {0,NULL,"tBzB|C?CBCJCUCVCZC\\CbCdCfClCnCwC|D@DBDCDRDSD[DfDhDkDlDnDpDvD{D}EG"},
  {0,NULL,"EQEREUEVE^E_EfEmEnEqEuE~F@FCFGFIFJFVFYF\\FaFhFoFpFyFzF}F~GIGJGKGUG"},
  {0,NULL,"VGWG\\GcGdGeGhGqGrGtG|HCHFHKHQHWHZH[H_HaHgHiHnHpHrHvI?IFISIVIYI`Ic"},
  {0,NULL,"IhIlIoIsIvI{I~JCJGJHJLJXJYJ]J_JfJiJnJpJuJ{J}K@KEKIKOKZK[K\\K_K`KbK"},
  {0,NULL,"eKfKmKvKzK}LALDLJLNLQLTLXL\\L_LfLhLnLpLsLvLxL{L}MCMKMMMOMPMRMTMVM["},
  {0,NULL,"M^MdMfMhMiMlMqMsM|M}_A?D?O?Y?[?\\?]?f?g?k?m?o?r?u?w?z@D@F@J@K@V@W@"},
  {0,NULL,"a@b@l@n@o@x@{@|A?AGALAMANAOAQA^AiAoAsAuA~B@BCBHBNBWBXB\\B]B^BaBgBm"},
  {0,NULL,"BqBrByB{B|CICKCQCTCXC^C_CcCdCfCjCnCqCwCzC~DDDMDQDTDdDfDiDjDmDnDxD"},
  {0,NULL,"zECEFEJEPESEVE]E_EfElEoEsEyEzE}FCFKFNFUFWFXF^F_FiFlFnFqFrGBGCGJGL"},
  {0,NULL,"GOGRGTGVGXGaGcGfGgGlGsGtG{HEHGHMHSHVHYH[HaHcHfHiHoHqHsHvH~IGIQIWI"},
  {0,NULL,"YI^IdIhIjIkIrIuIzJBJCJFJIJNJWJYJ^JdJeJiJqJvJxJ|KBKDKJKNKPKTKUKVK]"},
  {0,NULL,"KhKnKoKpKsKyK|L?LELGLILRLSLWLYL[LcLeLoLqLrLsLvLxL{M?MDMEMMMOMPMSM"},
  {0,NULL,"TMUM]MaMcMfMhMiMlMqMyMzM~_A?G?L?V?_?a?b?f?g?m?n?o?p?u?v?y?}@A@J@L"},
  {0,NULL,"@P@]@^@d@i@q@w@y@}AAADAHATAUAXAZA[AbAgAnAsAtAwAxBABMBNBOBQBTBYB^B"},
  {0,NULL,"dBgBhBtBuBvB|B}B~CDCFCGCXCYC[C\\CdCeCmCnCpCuCzC|DEDJDUDXDbDfDjDkDt"},
  {0,NULL,"DuDzD{D|E@EIETEVEWE]E^EcEjEkErEvExE|FAFHFMFQFRFSF]FcFgFnFpFuFvF|G"},
  {0,NULL,"@GKGLGMGQGVGYG`GbGhGmGsGtGuGwG}H?H@HBHQHVH]HaHdHeHhHiHlHmHtH~I?IH"},
  {0,NULL,"IPIXIYI^I_I`IfIpIuIvIwI}JCJKJMJOJWJXJ\\JaJcJgJmJoJsJyK?KAKFKGKRKSK"},
  {0,NULL,"XKYK^KaKdKgKkKtKuKxK~L@LFLKLMLPLULZL]L^LnLoLpLqLsLvLxL{MCMDMKMMMO"},
  {0,NULL,"MPMSMTM^MaMcMdMfMhMiMlMmMtMuMx_A?G?M?U?^?a?e?g?h?l?m?o?q?w?y?z?{@"},
  {0,NULL,"D@G@I@X@Y@\\@_@j@r@t@w@~A@AAAKASAVAYA]AaAcAiAkApArAzBDBFBGBNBSBVBa"},
  {0,NULL,"BbBdBeBfBgBkBoBpBqB}CACCCMCUC]C^C`CdCeCgClCnCuCvC{C}C~DFDOD]DcDdD"},
  {0,NULL,"gDjDpDtDvDwD~EFEIEMEPEQEXE]EdEiEmErEuE{E|FFFGFOFTFVF[F\\FdFiFkFoFs"},
  {0,NULL,"F~GAGDGIGLGTGUG]G_G`GbGdGfGiGjGtGvG|HHHIHPHVHWHZH`HbHcHhHjHrHsHtH"},
  {0,NULL,"zH~IAIBIEIYI_IaIgIiIkIqIsJ?JBJDJFJGJMJSJWJ]J`JaJhJnJpJtJuJwKCKEKH"},
  {0,NULL,"KIKOKQKWK_K`KiKjKoKpKwKzLALBLELGLVLXLYL[L_L`LfLhLoLqLsLtLzL{L}M@M"},
  {0,NULL,"DMFMMMRMSMTMVM[MaMcMfMgMkMlMnMxMyMzN?_A?E?K?W?Z?\\?^?f?h?j?n?p?s?u"},
  {0,NULL,"?x?y@@@A@I@K@S@W@X@c@h@o@r@u@z@|AEAFAMANAOAPAVAcAgAmArAuA}B@BFBIB"},
  {0,NULL,"QBUB[B^BaBcBeBoBsBtBvBxByB{CECQCRCSCYC]CdCgCiCjClCnCrCxD@DADEDKDZ"},
  {0,NULL,"D]D_DbDgDkDlDmDxDyE@EBEKERETEVEZE[EgEmEoEpEwE}F@FDFKFOFTFXFZF^F`F"},
  {0,NULL,"gFkFlFqFxGAGEGSGTGVGYG\\G^G_GdGjGkGlGmGtGvG~HMHNHOHQHRHSHTHZH]HfHj"},
  {0,NULL,"HkHmHnHoI?IBIJITIYIbIlImInIpIrItIyI}JCJHJKJQJRJTJ^JbJfJjJtJxJ|J~K"},
  {0,NULL,"BKCKKKLKMKTKUKVK]KgKiKlKoKtK|K~LBLCLELKLSLULYL]L`LaLeLnLpLrLsLxLy"},
  {0,NULL,"L|M?MCMEMGMHMKMMMPMUMWM]M^MbMdMfMiMoMuMxM|N@_A?E?O?Y?^?`?d?f?g?i?"},
  {0,NULL,"n?q?r?u?v?x?|@B@G@L@M@Q@U@\\@l@r@s@vA?ACADAHAVAWAXA]A_AbAeAhApAtAv"},
  {0,NULL,"AyA|BDBRBXB\\B]B_BaBbBjBkBoBpBwBxB}CDCQCSCTCWCZC]CbChCiCmCnCoCyD?D"},
  {0,NULL,"BDDDHDWD]D`DgDhDiDnDuDxDzE@EAEHENEUEWE\\E^EfEmEnEqEvEyF?FAFLFMFOFS"},
  {0,NULL,"FVFYFaFhFoFpFyFzF}F~GNGOGRGTGXG[G]GjGkGnGqGrGwGxG{G}HMHOHRHZH^H_H"},
  {0,NULL,"`HbHhHjHlHpHqHvHwIBINIOIYIZI[IcIdIeIrIuIxI}JJJLJOJUJVJXJ[J\\JdJgJo"},
  {0,NULL,"JtJuJzJ}K?KJKNKPKTKUKVKdKhKiKkKoKrKuKxK{L?LBLELMLPLRLYL`LbLgLiLkL"},
  {0,NULL,"mLtLuLwL|L~MBMFMHMJMLMNMQMYMZM\\M`MbMeMgMjMmMtMvMz_A?G?M?U?^?a?e?g"},
  {0,NULL,"?h?l?m?o?q?w?y?z?{@D@G@I@X@Y@\\@_@j@r@t@w@{@|A?AJANAPASAVA_AbAiAkA"},
  {0,NULL,"pArAzBDBFBGBOBPBUBWBXB\\BcBiBkBlBpBtBuB{B~CDCECHCVCaCbCdCkClCmCpCt"},
  {0,NULL,"CvC}D?D@DLDSDUD^D_DaDcDhDtDyDzD|E?EJEPESEXEZE\\EdEiEmErEyEzE}FBFGF"},
  {0,NULL,"OFSFYFZF^FdFiFkFoFsF~GAGDGJGOGQGRGSGWG^GdGeGoGpGrGtGwG}G~HAHBHQHS"},
  {0,NULL,"HXH\\H`HbHeHkHpHtHuHyHzIFIHIRI[I]IaIfIiIlItIuIwI|JDJFJIJNJQJUJ^JdJ"},
  {0,NULL,"eJlJnJoJtJ}J~KBKGKRKSKTKUKVKeKfKkKlKrKtKvKxK{K}LCLKLPLQLTL]LaLbLj"},
  {0,NULL,"LkLpLrLuLwLyL|MCMEMGMHMIMJMNMQMUMWMXMYMZM^MbMjMpMsMwM~NCND_A?F?P?"},
  {0,NULL,"X?Z?[?_?g?h?i?l?q?t?v?x?z?~@B@I@J@P@S@V@[@m@q@u@x@~ABAEAKAMAOATAY"},
  {0,NULL,"A[AcAdAhArAsAxA{A}A~BPBTBXBZB[B^B_BgBhBjBlBuBvBxC@CLCMCRC]C_CcCfC"},
  {0,NULL,"jCkCmCoCqCtCuD?DADTDVDXD^D`DbDcDeDiDvDyD~EAEQEREUEXEYE\\EhEkEpEsEu"},
  {0,NULL,"E~F@FFFHFKFRFTFXF\\FeFhFkFnFrFxF|GHGMGNGPGRGVGWG\\GaGcGgGjGlGoGwGyH"},
  {0,NULL,"DHHHNHRHVHXH]H_HdHeHmHqHuHwHzI@IGIIIPI[I]I_IeIjImIsItIxJ?JDJGJHJL"},
  {0,NULL,"JPJUJ]J_JfJhJpJsJxJyJ|KCKKKLKMKZK[K\\KcKdKgKjKoKsKuKwK~LELILLLMLUL"},
  {0,NULL,"VLYLcLdLgLiLjLkLpLrLyL|L~MCMEMGMHMIMJMLMUMWMXMYM\\M^MbMeMnMtMzM}NC"},
  {0,NULL,"_A?G?N?T?]?b?e?f?h?l?n?p?q?v?w?x?|?~@H@K@N@Z@`@a@k@n@t@y@~ABAEAFA"},
  {0,NULL,"LAOAPARAZA\\AdAeAqAuBBBEBHBLBSBTBVBWBZB]B_BhBmBpBqBwB{B|CECFCGCHCW"},
  {0,NULL,"CXC[C`CbCgCkCsCvCyC{DDDEDJDLDQDaDdDgDrDsDuDyD{E?E@EHEKEMEQEREUEeE"},
  {0,NULL,"iEjElEuE~F@FDFIFNFPFXFZF]FaFeFlFmFtFwG?GBGIGJGMGNGPGUGXGiGnGoGrGs"},
  {0,NULL,"GuGvG~H?H@HAHSHYH^HaHbHcHdHjHlHsHyH|H}IQIRIXIZI\\IaIdIgIpItIvI|I}J"},
  {0,NULL,"GJHJJJLJRJSJ]J_JfJjJqJrJ{J|J~KAKGKRKSKZK[K\\K]K^KaKhKlKrK{K|L?L@LC"},
  {0,NULL,"LFLRLSLZL^LaLbLfLgLlLmLoLtLuLzM@MAMBMFMLMNMRMSMVMZM_M`MaMeMgMkMoM"},
  {0,NULL,"vMzM|_A?F?K?W?_?`?c?f?h?k?l?o?s?w?x?z?{@F@H@L@M@O@T@^@h@p@q@v@{@|"},
  {0,NULL,"A?AIAQATAWAXA_A`AkAoAqAtAvB?BABJBOBUBVB]B^BaBcBfBhBjBnBpBrBzCLCOC"},
  {0,NULL,"RCSC[C\\C`CcCeChCmCrCsCuCxC{DBDIDRDXDbDgDoDpDqDrDxDyD~EEEHEJELEMEP"},
  {0,NULL,"ESEgEkEqEtEyEzE}FEFHFJFLFMFUFYF_FdFmFpFuFyF{GFGIGQGSGTGVGXG^GaGbG"},
  {0,NULL,"hGiGuGwGxGyGzHNHOHUHWH[H_HbHdHgHjHmHrHxH{H|IPIUIVI\\I_IbIcIgInIrIt"},
  {0,NULL,"J?JAJEJFJIJJJNJSJ^JdJeJkJsJzJ}K?K@KDKKKLKMKTKUKVK_KdKgKiKmKqKuK~L"},
  {0,NULL,"ALBLDLHLMLNLOLUL_L`LfLiLlLmLoLtLwLzL~M@MAMBMFMQMRMSMVM\\M_M`MaMgMj"},
  {0,NULL,"MkMrMsMxMyND_A?G?N?T?]?b?e?f?h?l?n?p?q?v?w?x?|?~@H@K@N@Z@`@a@k@n@"},
  {0,NULL,"t@yA?ACADAIALAQARAWA^AaAdAeAqAuBBBEBHBLBQBXBYB[B\\B`BbBiBlBnBoBqBv"},
  {0,NULL,"B|CACCCICOCWCYC\\C^C_CkClCqCtC{C|D@DEDGDNDODaDbDcDfDlDsDwDxD}D~EHE"},
  {0,NULL,"RESETE\\E^EeEiEjElEvEyF?FEFLFNFPFUFWF[FaFeFlFmFtFwG?GBGKGOGRGYGZG\\"},
  {0,NULL,"G]GdGfGgGhGmGnGoGzHEHIHPHUHXHZH\\H]HaHcHiHmHnHyHzH}IDIEILI]I`IgIjI"},
  {0,NULL,"lIpIqIrI~J?JHJIJJJKJUJXJ[J\\JdJkJqJrJvJwJzKDKHKJKNKPKQKWK`KcKmKpKq"},
  {0,NULL,"KsKzLDLGLHLILLLNLOLXL[LcLdLeLjLkLnLpLrLsLxM?MCMEMIMJMKMMMPMUMXMYM"},
  {0,NULL,"]M^MdMfMiMrMsMtM}N@_A?E?K?W?Z?\\?^?f?h?j?n?p?s?u?x?y@@@A@I@K@S@W@X"},
  {0,NULL,"@c@h@o@r@u@}AAADAIANASA[A^AaAcAgAmArAuA}B@BFBIBNBOBPBRBZB]BdBkBlB"},
  {0,NULL,"mBpBsBtBzC?CBCCCNC[C]C^CbCcCfCjCoCsCxCyC~D@DMDSDVDeDgDhDmDoDsDwD{"},
  {0,NULL,"D}EDEHEIEKELETEWEgEmEoEpEvExE|FEFGFRFTFWF[F^F`FgFkFlFqFxGAGEGLGPG"},
  {0,NULL,"QGWGXG[G`GaGcGfGjGlGrGuHCHJHKHPHQHTHXHYH`HbHgHjHoHpH{H}I@IFIIIWIZ"},
  {0,NULL,"I\\IbIeIkIlIqIvI~J@JEJJJKJMJOJRJ\\JaJcJkJnJvJwJyKBKCKEKFKIKOKXKYKcK"},
  {0,NULL,"eKfKjKnKpKvKwKyK}LGLLLQLTLVLWL[LdLgLhLlLmLqLtLuLzL}M@MAMBMDMFMLMN"},
  {0,NULL,"MZM[M_M`McMeMgMkMrMtM{M~NB_A?G?L?V?_?a?b?f?g?m?n?o?p?u?v?y?}@A@J@"},
  {0,NULL,"L@P@]@^@d@i@q@w@y@z@|AEAGAMAQATAUAYA`AgAnAsAtAwAxBABMBRBUBZB_B`Bc"},
  {0,NULL,"BeBfBkBmBnBuBvBwCICMCOCUCVCWC[C]C_CaCeCoCpCsC|C}DDDFDNDYD^DhDjDqD"},
  {0,NULL,"sDuDvDxD}EFEJEKEUEVEWEZEcEjEkErEwE}F@FCFHFJFKFQFUF\\FcFgFnFpFuFvF|"},
  {0,NULL,"G@GNGPGSGZG[G^G_GbGeGgGjGnGpGuGzG|HEHHHUHWHYH]H^H`HeHlHpHuHxH}H~I"},
  {0,NULL,"AICIDI\\I`IdIeIfIiIrIsI~JBJCJLJNJOJQJRJ^JbJfJiJmJpJsJxK@KDKHKKKLKM"},
  {0,NULL,"KQKWK_KbKjKnKqKsKwKyLALHLILJLOLVLWL\\L_LcLgLiLjLmLtLuLwLyL~MBMFMGM"},
  {0,NULL,"IMLMNMQMWMXMZM\\M`MeMgMjMqM{M|M~NFNH_A?D?P?X?]?c?d?g?h?j?m?p?t?u?y"},
  {0,NULL,"?z?}@@@G@H@R@T@U@Z@m@n@p@s@}AAADAKALAWAXA\\A]AaAmAnApAqA|B?BKBLBPB"},
  {0,NULL,"QBRBTBUBYB]BjBnBoBrBuBzB{CACKCPCTCVCWCXC`CiCjCkCrCtC}DADCDDDIDQD["},
  {0,NULL,"D^D_D`DdDlDqDwDzEBEFEIETEWEXEYEZEhElEnEtEvExE|FFFIFLFMFNFVF[F`FcF"},
  {0,NULL,"mFoFwFzF{GGGKGMGSGWGXGYG[GeGiGkGlGnGoGsG{HGHIHLHSHUHZH[H_HeHgHkHn"},
  {0,NULL,"HsHuHwHxIQISIUI]IdIiImInIoIqIuIyJBJDJKJMJOJPJQJ\\JaJcJhJqJuJwJzJ{K"},
  {0,NULL,"?KFKJKNKPKXKYK]K`KbKhKiKqKzK|L?LBLHLJLOLRLSLXL\\L`LeLjLkLnLuLwLyL|"},
  {0,NULL,"M?MGMHMIMJMKMNMQMWMXMYMZM]MbMdMjMnMxM{M|NDNI_A?E?M?U?\\?`?b?g?h?i?"},
  {0,NULL,"j?q?r?s?t?y@?@C@H@J@N@O@]@b@j@o@v@y@{@}ABAKALAOAQATAXAZAfAlAqAsAw"},
  {0,NULL,"BCBEBJBOBSBWB\\B`BcBdBfBmBrBsBvBwB}CDCECRCTCWCYCZC\\C^CcCgCvCxC|C~D"},
  {0,NULL,"?DCDHDNDZD_DeDnDpDsDtDyDzEAEBEIELEOEQEYE_EdEjEoEqExEzE~FFFHFMFNFU"},
  {0,NULL,"FXF]FbFfFmFnG?G@GCGFGJGOGQGUGZG^G`GaGfGhGmGnGqGvG{G}G~HNHTHWHYH[H"},
  {0,NULL,"]H^HhHkHrHtHvH}I@IDINITI[I`IaIbIkIoItIuIxIyJEJGJMJPJYJZJ_JcJeJhJq"},
  {0,NULL,"JsJ|K?KAKDKGKRKSKTKUKVKgKhKkKlKqKsKxK~L?LCLHLILOLPLRLULaLcLfLhLlL"},
  {0,NULL,"mLoLqLvLxL}MAMBMDMOMPMRMSMVM[M_M`MaMcMhMiMnMwM{M}N@NANGNH_A?D?P?X"},
  {0,NULL,"?]?c?d?g?h?j?m?p?t?u?y?z?}@@@G@H@R@T@U@Z@m@n@p@s@z@|AEAJAPARAWA\\A"},
  {0,NULL,"_A`AmAnApAqA|B?BKBLBZB[B^B_B`BaBdBiBnBqBsBzB|B}C@CHCJCLCXCZC^CbCe"},
  {0,NULL,"ChCiCtCuCyCzC~DCDGDPDWD`DdDeDfDoDtDvDyD|EDEIEKEOEPEVEZEhElEnEtEwE"},
  {0,NULL,"}F@FBFIFJFLFPFYFZF`FcFmFoFwFzF{GGGNGPGTGVGZG\\G`GbGfGkGqGrGsGxGyHA"},
  {0,NULL,"HDHFHTHUH\\HaHcHgHhHiHsHtHwH{I@ILIMIOIZI]I^I_IkIoIsItIwJ@JCJFJMJQJ"},
  {0,NULL,"RJZJ^JbJfJlJrJzJ{J}J~K@KKKLKMKZK[K\\KaKcKdKeKmKrKuK{K}LDLFLLLMLNLT"},
  {0,NULL,"LZLbLdLfLhLlLmLoLqLsL{L}MAMBMDMMMRMSMTMVM[M_M`MaMcMfMlMpMtMuM~N?N"},
  {0,NULL,"GNH_A?D?N?T?[?a?d?f?h?j?k?p?r?s?t?w@?@E@I@L@Q@Y@[@d@k@s@w@x@{@}AB"},
  {0,NULL,"AIASATAYA[A_AbAjAlArAtAyAzA{BMBQBSBTBWB\\B_BeBgBiBjBkBoByB}CBCFCHC"},
  {0,NULL,"LCVCYC_CaCeCfCiCqCrCwCyC}DEDFDWD\\D`DaDjDlDmDrDyD{EDEEELESETEYE[E_"},
  {0,NULL,"EeEnErEsExEzE~FEFGFHFRFSFYF\\FfFjFkFpFvF}GDGHGJGMGNGOGUGYG_GbGcGeG"},
  {0,NULL,"gGkGmGpGyH?HAHKHVHZH\\H_H`HfHhHnHoHwHyH|H~IAIKIOIZIhIiIjInIpItIvJ@"},
  {0,NULL,"JAJEJIJKJPJTJYJ_JcJeJkJnJoJpJsJyJ}KGKRKSKZK[K\\K^K_KdKfKjKrKuKvKwK"},
  {0,NULL,"{L@LALMLQLVL^L_LbLeLnLpLrLvLyL{L|M?MCMEMGMHMKMOMTMUMWM]M^MbMdMhMl"},
  {0,NULL,"MrMvMyM{N?NANENF_A?F?K?W?_?`?c?f?h?k?l?o?s?w?x?z?{@F@H@L@M@O@T@^@"},
  {0,NULL,"h@p@q@v@~A@AAAFAUAXAZA\\A]A`AkAoAqAtAvB?BABJBNBPBRB[B\\BdBeBfBiBrBu"},
  {0,NULL,"BvBwByC?CGCNCPCXCZC_ChCiClCmCqCrCsCzD?D@DHDPDYD^DaDbDmDnDoDwD{E?E"},
  {0,NULL,"CEMERESEXE[E]EgEkEqEtEuE{E|FDFIFJFMFQFVF]F_FdFmFpFuFyF{GFGLGOGWG["},
  {0,NULL,"G\\G_G`GdGgGkGqGsGwGxH@HCHJHLHWH[H\\H]H^HeHfHmHoHuHvHyH{ICIMINI[I\\I"},
  {0,NULL,"^IjIlInIqIvIzI|JDJHJIJSJTJWJ]J`JaJjJmJuJ{K?K@KAKEKFKIKOKXKYKaKbKe"},
  {0,NULL,"KhKkKnKxKyK}L?LFLJLPLRLTLWLZL\\LeLjLkLnLpLrLvL{M?MCMEMIMJMKMOMTMUM"},
  {0,NULL,"XMYM]M^MdMhMlMoMwMzM~N?NANL_A?D?N?T?[?a?d?f?h?j?k?p?r?s?t?w@?@E@I"},
  {0,NULL,"@L@Q@Y@[@d@k@s@w@x@zA@ACAFAMAUAVAYA]AbAjAlArAtAyAzA{BMBOBVBXBYBZB"},
  {0,NULL,"`BbBgBhBmBuBxBzB}CACICPCQCVCZC`CaCbCcCdCpCqCxCyC{DCDTDUD[DiDlDoDr"},
  {0,NULL,"DsDtDwDxEBECEKELEMENEOE[EeEnErEsEwE{F?FDFKFOFQFSFVF\\FfFjFkFpFvF}G"},
  {0,NULL,"DGHGIGKGPGQGRGZG]GaGeGiGpGqGrGtHEHIHLHMHRHVHYHdHeHgHhHnHqHtH{H|H}"},
  {0,NULL,"IGIHISIZIbIfIgIjIoIqIrIyIzJEJRJSJTJVJZJ[J`JbJjJmJoJpJtJuJxKHKJKNK"},
  {0,NULL,"PKQKWK`KbKkKoKsKtKxKzLELILJLKLPLXLYL\\L]LcLhLiLlLmLqLtLwLzL}L~M@MA"},
  {0,NULL,"MBMDMFMQM[M\\M_M`McMgMjMkMoMuMwM}NBNDNK_A?F?P?X?Z?[?_?g?h?i?l?q?t?"},
  {0,NULL,"v?x?z?~@B@I@J@P@S@V@[@m@q@u@xA?ACADAJAMANAUA[A^AbAdAhArAsAxA{A}A~"},
  {0,NULL,"BQBRBSBYB]B`BaBfBhBqBsBtBxByB~CKCNCPCZC[C_CaCeCfCgCsCuCvCwDADCDKD"},
  {0,NULL,"YD\\D^DdDeDkDpDrDwDzE?EGEHEOEPEQE\\E^EhEkEpEsEvEyF?FBFKFQFRFSFWF^Fe"},
  {0,NULL,"FhFkFnFrFxF|GHGKGTGUGXGYGZG[GbGcGgGpGqGuGvHBHGHJHLHQHRHTHWHcHdHfH"},
  {0,NULL,"rHsHuH|I?I@ICIJIKI\\I_IaIhImIoIqIuI{I|JFJGJJJUJXJZJ[J\\JdJlJmJoJvJx"},
  {0,NULL,"JyKBKFKJKNKPKXKYK]K^KbKfKnKtKvKyK|L@LJLKLQLSLWL\\L]L^LfLhLoLqLtLvL"},
  {0,NULL,"xLzL}M@MDMFMOMPMRMSMVM[MaMcMgMhMiMkMpMsMvM|N@NANJNQ_A?F?L?V?Z?c?e"},
  {0,NULL,"?f?g?i?k?o?r?s?t?v@C@E@G@K@R@_@`@c@i@p@t@u@zA@ACAHAPARAVAWAaAcAfA"},
  {0,NULL,"jApAuBBBGBIBKBNBUBWBYBZB`BeBgBiBlBpBrBsBtC@CMCOCSCXC\\C`CfCgCiCkCo"},
  {0,NULL,"CrCvCwCzC|DIDLDVDaDeDjDkDnDqDvDxEAEEENEOE[E]E^E_EcEiEpEtEwE{F?FAF"},
  {0,NULL,"LFOFPFTFZF[FbFjFlFoFsFtGEGGGJGKGLGPGSGZG_GcGhGiGkGoGsGvGzHDHHHOHQ"},
  {0,NULL,"HTHVHXH[H\\HbHvHxHyH~I?I@IIIRIUI^I`IaIeIhInIrIsIxJAJTJVJWJXJYJZJ[J"},
  {0,NULL,"`JbJgJrJtJwJzJ~KCKHKKKLKMKQKWKcKiKjKlKqKrKwK{LBLCLHLLLOLVL`LaLbLd"},
  {0,NULL,"LeLfLhLrLsLvLxL{L}M?MEMMMOMPMRMTMUMVM[M]MfMhMiMlMmMvMwM{NBNCNINN_"},
  {0,NULL,"A?D?O?Y?[?\\?]?f?g?k?m?o?r?u?w?z@D@F@J@K@V@W@a@b@l@n@o@x@~A@AAAHAO"},
  {0,NULL,"ARAZA[A^AcAiAoAsAuA~B@BCBHBPBRBSBVB[BbBcBhBkBnBsBxByB{C@CBCFCJCWC"},
  {0,NULL,"YC^CaCcChCkCpCtCwCxDBDDDGDZD\\D_DfDhDiDqDrDvD{D|EEEJEMENEWEXE]EfEl"},
  {0,NULL,"EoEsEuE{E|FAFPFRFTFWFXF]F_FiFlFnFqFrGBGCGIGUGWG[G\\G]G^GaGfGmGnGoG"},
  {0,NULL,"pGxH?HDHFHKHRHSHTHUH`HdHfHiHkHpHqHxH|IKILITI]IbIcIdIfIhIsIvIwJAJD"},
  {0,NULL,"JNJOJSJVJWJ]J`JaJgJrJvJyJ|KAKCKEKIKOKZK[K\\K^KcKfKgKlKmKvK~L@LCLDL"},
  {0,NULL,"LLNLQLUL^LaLdLgLiLjLlLuLwLyLzL~M@MAMGMIMLMNMQMWMXMZM\\M_MeMjMkMmMs"},
  {0,NULL,"MwMxNFNGNJ_A?F?L?V?Z?c?e?f?g?i?k?o?r?s?t?v@C@E@G@K@R@_@`@c@i@p@t@"},
  {0,NULL,"u@{@}ABAGALANAPASA\\AaAfAjApAuBBBGBIBKBOBQBTB_BbBcBdBiBlBnBqBwBxBz"},
  {0,NULL,"B~C?CGCKC]C`CaCgChCjClCoCpCzC{DADBDKDODPDcDiDkDoDqDuDzD{ECEGEJELE"},
  {0,NULL,"NEUEYE_EcEiEpEtExEzE~FCFGFIFNFZF[F^FbFjFlFoFsFtGEGGGMGNGQGYG]G^G`"},
  {0,NULL,"GdGiGjGlGpGvGxH@HBHCHGHRHUHXH\\H^HcHgHlHqHxHzH{I?IEIJIMI^IcIeIfIgI"},
  {0,NULL,"mIuIvIzI{JEJLJNJPJVJYJ_JcJeJiJnJqJwJ{J~KBKFKGKRKSKXKYK]K`KaKeKpKt"},
  {0,NULL,"KzK|K}LFLGLKLSLTLXLZL[L]LgLiLkLlLuLwLzL|L~M@MAMHMJMLMNMQMYMZM\\M_M"},
  {0,NULL,"bMeMjMkMqMuMyM}NENGNJNL_A?E?M?U?\\?`?b?g?h?i?j?q?r?s?t?y@?@C@H@J@N"},
  {0,NULL,"@O@]@b@j@o@v@y@zA@ACAJAQARAUAZA^A`AfAlAqAsAwBCBEBJBNBTBUBVBXBbBeB"},
  {0,NULL,"jBlBmBwByB{B|CCCJCNCUCVCYC[C\\ChCjCmC}C~D?DADBDEDJDMDRD_D`DcDmDpDu"},
  {0,NULL,"DvDwEDEGENEOEYEZE[E\\EdEjEoEqEwE{F?FBFJFPFQFUFWF]FbFfFmFnG?G@GCGFG"},
  {0,NULL,"IGLGMGRGSG]G_GeGhGlGmGuGwGxG|HFHJHPHSHXHYH^H_HaHfHkHlHoHrHwHzIVIW"},
  {0,NULL,"IXI[IcIiIkImIpIqIsI{J@JPJQJTJUJVJZJ[J`JbJlJmJrJvK@KAKDKEKHKIKOKQK"},
  {0,NULL,"WK^K_KaKmKnKpKyL@LALDLFLGLNLWLZL[L^L_LeLgLiLjLkLnLyL|L~M?MGMHMIMJ"},
  {0,NULL,"MKMLMWMXMYM\\M]MbMdMeMpMuMvMyNINKNPNT_B?C?F?\\?]?^?a?b?d?h?m?n?r@@@"},
  {0,NULL,"H@I@M@Q@R@V@_@`@b@c@f@i@m@uACAFAIALAOASAXAYAZA_A`AhAkAlAnAoAtB@BE"},
  {0,NULL,"BFBLBWBXBbBcBiBjBmBpBrBuByC@CBCGCHCKCMCTCVCeCgCkCnCqCuD?DKDMDVDZD"},
  {0,NULL,"^DfDjDkDqDsDtD{D}E@EHEJEOEPEQE[E^E`EcEgEtE{FBFFFGFKFNFRFSFUFXFYF_"},
  {0,NULL,"FeFfFgFhFnFwFzGAGDGIGJGNG]GaGcGeGoGqGuGvGzG{G~HBHCHKHOHYH\\H]HbHiH"},
  {0,NULL,"mHrH|IMIOISIUIYI\\I^I`IeIiIpIuIwJBJDJHJIJLJTJWJZJ[J\\J`JaJbJgJmJwJz"},
  {0,NULL,"KCKFKKKLKQK]K_KbKhKiKmKpKvKyKzK}LELILLLQLRLZL]LjLmLnLoMCMDMFMGM\\M"},
  {0,NULL,"^M_MaMbMeMjMmMsMzN?N@NENGNMNONS_B?C?G?Z?[?\\?`?c?d?g?j?k?x@C@G@J@M"},
  {0,NULL,"@N@S@X@Z@^@`@a@g@j@k@tA?AGAHAOATAUA[A\\A]A`AcAgAhAkAlAnAtA~BCBIBKB"},
  {0,NULL,"ZB[B]BaBfBnBtBvBxB|B}C?CACCCECFCJCRCVCZC^CkCnCrCuC}DKDLDODVD`DaDi"},
  {0,NULL,"DlDmDsDtD{ECEEEJEKESEXEZE\\E^E`EcEeEjEvFBFFFGFIFJFKFOFTFXFYFdFgFhF"},
  {0,NULL,"iFjFkFzGCGFGGGIGXG[G\\GdGfGjGoGpGqGwGzH@HAHCHDHEHNHRHUHVHaHoHpHuH~"},
  {0,NULL,"IDINIVIXIfIgIhIjInIoIpItIyJ@JCJKJMJSJUJWJXJ[J\\JcJdJeJkJoJqJwKDKGK"},
  {0,NULL,"NKQKWK]KbKgKkKlKnKqK}L?LBLELFLGLKLTLUL^LbLiLqLvLyL}MHMQMTMVMWM`Me"},
  {0,NULL,"MgMkMlMrMxM~N?NCNFNINNNPNTNW_B?C?G?Z?[?\\?`?c?d?g?j?k?x@C@G@J@M@N@"},
  {0,NULL,"S@X@Z@^@`@a@e@i@k@yAEAJAKANASAVAWAXA[A]A^AgAhAiAjAkArA|BCBJBKB[B\\"},
  {0,NULL,"B]B^BfBgBjBpBqBtB{CACFCGCKCNCOCSCWCXCaCfCnCpCuCxDHDJDNDRD`DaDiDjD"},
  {0,NULL,"oDrDsDwEBEDEJEKEQESEUEWEZEaEdEeEiEuFAFCFHFKFLFMFQFWFYF^FcFdFfFgFh"},
  {0,NULL,"FpFrGCGEGGGWGXGYG\\GcGeGjGnGsGuGwG{G~HAHEHJHOHPHSH_HcHhHpHtHuH{IEI"},
  {0,NULL,"IIJIRIZIbIgIhIiIoIpIrIzJAJFJGJKJLJMJSJWJ]J_J`JbJfJjJpJrJ~KAKHKRKS"},
  {0,NULL,"K\\KeKfKiKjKlKmKqKuKyK~LALFLGLLLWLXL`LcLhLwL{L|L~MDMGMOMUMYM^McMdM"},
  {0,NULL,"iMjMoMxM~N@NDNGNHNJNLNR_B?C?E?[?]?_?a?c?e?f?l?m?t@F@K@L@N@O@R@S@U"},
  {0,NULL,"@[@]@b@f@j@l@vABAFAIAMANARAUAWAaAbAcAgAhAiAjAmArB?BABBBHBTBUB_B`B"},
  {0,NULL,"iBkBmBsBvBxBzC@CCCDCICJCPCTCWC\\CaCdCnCoCuCyDHDIDPDRD_DaDdDhDjDpDt"},
  {0,NULL,"DwD~E?ELEQEREVEZE^E_EaEdEgEoExFAFCFKFLFPFQFVFYFZF\\F`FaFdFhFjFoFrF"},
  {0,NULL,"uFvGBGMGRGYGZGcGdGhGkGnGpGqGzG|G~HDHJHLHNHYH\\H]HbHjHnHsI?IGIKITIW"},
  {0,NULL,"I[I_IaIfIgIkIlIsIwJBJEJJJMJOJRJUJYJ]J_JaJcJeJhJnJ|K?KAKEKSKTKUK]K"},
  {0,NULL,"aKcKfKgKmKtKuKyK{K}L?L@LJL[L\\L_LdLrLsLuLzMCMFMQMTMWMYM\\M]MbMfMgMn"},
  {0,NULL,"MtM|NINKNMNNNQNRNSNY_B?C?D?Z?^?_?`?b?e?h?i?n?o?~@H@I@R@V@W@^@_@a@"},
  {0,NULL,"b@d@f@l@m@n@|AFAIASAUAXAYAZAaAbAcAhAjAkAlAnAtA}BBBEBFBNBUBbBcBgBi"},
  {0,NULL,"BjBmBpBuByC@CBCGCKCMCNCTCZC^CjCmCrC|C}DCDGDLDODQD`DfDgDiDkDnDpD{D"},
  {0,NULL,"}E@EIEKENEOEPESEVE`EeEfEsEzFBFFFIFJFLFOFQFTF[F]F`FaFcFdFjFoFxF|G?"},
  {0,NULL,"GFGLGQG[G^GbGfGiGlGrGsGwH?H@HEHFHHHMHPHYHZHbHfHnHtH{I?ICIGIKIPIYI"},
  {0,NULL,"ZI[I`IdIhIlIsIxI{JFJIJKJOJPJTJYJ^J_JdJeJfJiJqJxJ|J}KNKPKUK[KcKdKj"},
  {0,NULL,"KkKlKsKtK{K|K~L@LBLFLHLNLQLVLZLhLpLtL|MBMJMKMRMXMZM[M\\MdMjMkMqMuM"},
  {0,NULL,"{N@NANBNJNPNSNVNXNZ_B?C?E?[?]?_?a?c?e?h?k?m?v?{@H@I@M@P@Q@U@\\@]@`"},
  {0,NULL,"@c@f@j@l@vABAFAIAMANARAUAWAaAbAcAdAfAgAiAmAuAzA{B?BABRBTBYB_BhBlB"},
  {0,NULL,"oBtBvBzB{B~CACDCJCOCQCUCVCZC^CkCzC~DADEDHDRDXDYD_DdDfDhDjDnDrDxEC"},
  {0,NULL,"EEEIELEOEQEREWE_E`EfEgEmF@FBFFFLFNFQFRFSFUF[F]F_FbFeFfFgFnFsFwF{G"},
  {0,NULL,"DGKGNGPG]GaGeGhGoGqGuGvGzG{HBHCHKHLHOHZHdHfHgHoH}H~I@IBIEIFIRIYI]"},
  {0,NULL,"I^IbIcIhIjIuIwJBJCJGJHJKJQJTJVJ]J^J_JeJfJiJnJ|J}K@KEKOKUK[KcKdKeK"},
  {0,NULL,"jKkKlKtK{K~L@LALBLFLHLOLRLYL]LqLrLyLzM?MAMIMSMYMZM\\M]McMeMgMqMuM{"},
  {0,NULL,"N?NANINLNQNRNS_B?C?E?[?]?_?a?c?e?f?l?m?t@F@K@L@N@O@R@S@U@[@]@b@g@"},
  {0,NULL,"h@j@o@zAGAHALATA[A\\A]A_AaAbAeAhAjAkAmApA~BABHBMBSBTBZB`BgBjBpBwBx"},
  {0,NULL,"BzB|CCCDCGCKCLCNCRCYC[C`ClCoCtCyD@DMDTDZD\\D^D_DaDcDgDjDpDzD|EFENE"},
  {0,NULL,"QERETEVEZE[EbEdEfEqF?FDFEFHFIFNFRFTFZF\\F^F`FgFhFiFjFkFtFuF{GBGKGM"},
  {0,NULL,"GZG`GcGiGkGlGmGtGuGyG{G|G~H?HFHGHVH^H`HaHnHpHuI?IMINIUIVIYI[I]IfI"},
  {0,NULL,"gIiIkItI|J?JJJLJMJOJTJUJVJ[J^J`JbJdJlJtJvK@KDKIKOKVKWK`KbKdKgKiKm"},
  {0,NULL,"KsKwKyK|L?LELHLLLMLPLSLaLpLtLwL{M@MEMMMNMVMZM[M^M_McMhMpMtM|NANFN"},
  {0,NULL,"GNLNONUNVNXN\\_B?C?E?[?]?_?a?c?e?g?k?l?p@D@G@J@N@Q@S@W@X@Z@c@d@e@h"},
  {0,NULL,"@l@rADAJAKAMAPAQARATAYAZA\\AeAfAlAnAoAqAxAzA~BGBQBYBZBeBlBmBrBsBuB"},
  {0,NULL,"|B}C?C@CBCHCICQCRCXC]CfChC{C|DBDCDFDSDUD]D^DgDmDnDoDqDrDyD~E?EHEI"},
  {0,NULL,"ENEUEWE[E\\EaEdEgEoExFAFCFKFLFPFQFVFYFZF\\FaFcFdFfFhFpFrFsGBGGGMGPG"},
  {0,NULL,"YG\\GcGeGjGnGrGsGwG~HAHEHHHJHOHPHTHWHXHeHlHrHwH|ILIQITIWI[I\\I^I_Ib"},
  {0,NULL,"IgIlIrIzJAJEJGJHJMJOJYJZJ\\JaJcJdJeJkJnJvK?KBKEKIKTKYK^KaKhKoKpKsK"},
  {0,NULL,"tKvKxKzK{K|LCLJLUL`LbLcLiLjLoLvMJMQMRMTMVMWM\\M]M^MdMfMrMvM}NFNGNJ"},
  {0,NULL,"NKNNNQNSNXN\\N]_B?C?D?Z?^?_?`?b?e?f?i?l?y?|@K@L@R@T@U@X@Y@Z@]@b@g@"},
  {0,NULL,"k@m@s@}AGAHAOAPAQAUAVA^A`AcAdAgAiAlAoAsAvBBBDBIBOBUBaBdBhBkBmBnBr"},
  {0,NULL,"BtB{C@CACECHCOCPCUC[C_C`CiCpCqCxD?DSDWD[D]D^D`DbDcDdDkDrDvEAEGEPE"},
  {0,NULL,"SETEWEYE[E_EbEfEhElE|FDFEFHFJFOFSFUFZF\\F^FfFgFhFiFjFkFtFuFyG?GLGS"},
  {0,NULL,"GZG`GcGeGiGkGmGtGuGyG{G|G~HFHGHOHQHRHUH[HoHqHzH~IDILIQIXI[I\\I]IeI"},
  {0,NULL,"hImIoItI|J?JDJKJNJOJSJVJZJ\\J]J_JaJcJhJqJuJyJ{KJKNKXKZK^KeKhKlKnKp"},
  {0,NULL,"KrKvKxKzLALDLFLKLML_LaLdLgLrLxLzL~MCMFMOMUM[M\\M`MaMcMfMnMwMyNCNEN"},
  {0,NULL,"HNKNLNSNVNXNZN[_B?C?D?Z?^?_?`?b?e?g?l?n?s@B@G@J@O@Q@T@W@Y@[@c@d@e"},
  {0,NULL,"@k@l@xA@AJAKANAPAQASATAWAXA\\AeAfAmAnAoAqAxA}BDBGBNBOBQBeBlBrBsBuB"},
  {0,NULL,"zB|B}C?CBCDCHCICQCRCWC\\CaCdCsCzC~DDDKDTDVD\\DcDfDgDlDrDsDuDyD~E?EJ"},
  {0,NULL,"EMENEOETEWEXEaEeEhEnEwFAFCFGFHFMFWFXF[F]F^F_F`FbFeFiFlFyF|F~G@GOG"},
  {0,NULL,"QGSG_GaGhGlGoGpGtGxGyH?HBHCHIHLHNHXHcHeHhHjHkHsHxINIOISIVIZI\\I]I`"},
  {0,NULL,"IaIgIjIvI}I~JCJFJIJMJRJVJZJ[J]J`JbJfJjJpJrJuJxKHKJKPK\\KbKeKfKiKjK"},
  {0,NULL,"mKqKuKyK~LALELGLLLTLUL^LbLfLkLsLuMIMLMPMSMUMZM]MaMbMdMhMoMxM~NANE"},
  {0,NULL,"NHNJNMNQNUN[N__B?C?F?\\?]?^?a?b?d?g?j?n?w?}@G@J@M@O@T@Y@[@^@`@a@e@"},
  {0,NULL,"h@i@p@{AJAKAMARAVAYAZA[A]A^AdAgAhAiAjArAwA|BCBLBVBWB[B\\BfBgBhBjBq"},
  {0,NULL,"BtB{CACFCGCNCOCSCUC\\C]CdChCoCvCwCyDGDIDPDQD_DbDgDhDkDoDsDwEBEDEJE"},
  {0,NULL,"LENEPEREUEYEaEgEhEkEyFAFCFGFPFVFXFZF[F\\F]F`FbFeFiFjFlFvFzF~G@GIGO"},
  {0,NULL,"GRG_GhGiGlGoGpGtGxGyH?HCHFHIHLHNHSHTHWH_HqHzH}I@IAICIHIPIYIZI\\IbI"},
  {0,NULL,"kImInIvI}I~JFJGJJJNJTJXJZJ\\J^JcJdJeJkJsJzK?KBKKKMKTKYK^KaKdKhKoKs"},
  {0,NULL,"KtKxKzK{K|LCLHLJLTLWLXL^LgLqLxLyL}MHMMMNMUMXM[M]M^MeMlMrMvM}N?NBN"},
  {0,NULL,"GNHNQNTNVNWNXNZ_B?C?F?\\?]?^?a?b?d?f?j?m?q@A@K@L@N@O@P@S@V@[@\\@_@g"},
  {0,NULL,"@h@m@q@~AGAHALAPAQAVA^A_AaAbAeAfAjAkAmApAwB@BHBMBSBVBXB`BgBlBpBwB"},
  {0,NULL,"xBzB|CCCDCKCLCNCQCRC_CbCcCiCrC{C}DBDJDNDXDYD^D_D`DeDfDlDoDzD|EFEO"},
  {0,NULL,"ERESEUEXE[E]EbEcEhEpE~FDFEFJFMFOFPFSFUFVFWF_FaFbFcFdFmFqFvF}GAGJG"},
  {0,NULL,"RGTGUGaGdGgGhGrGsGwG}HBHDHEHHHLHPHRHUHVHaHkHvHxHyIBIFIIIJIZI]I^I_"},
  {0,NULL,"IdIiImIqIyJ@JEJFJHJLJNJPJVJ]J_JaJcJfJhJsJyJ{KCKLKMKXKZK^KeKjKlKnK"},
  {0,NULL,"pKrKvKxK~LALDLFLKLPLSL[L\\LeLlLsLuMBMKMQMTMVM[M]MaMgMiMjMnMwMyN@ND"},
  {0,NULL,"NENFNINQNVNWNZNa_B?C?G?Z?[?\\?`?c?d?f?i?j?z@E@K@L@P@T@V@X@Y@Z@\\@_@"},
  {0,NULL,"f@i@j@wAAAFAIALAMANAOARAWA_A`AdAeAfAnAoAqAyA{B@BIBPBRBXBaBhBnBoBp"},
  {0,NULL,"BqBwByB~CECKCLCMCSCUC\\C]CdChCsC|DCDDDFDTDUD\\DcDeDmDnDpDtDuDyEBEDE"},
  {0,NULL,"IEMETEVE\\E]E^EaEdEeEiEuFAFCFHFKFLFMFQFWFYF^F_FcFeFfFgFnFyF}GEGGGS"},
  {0,NULL,"GTGWG\\GbGgGjGmGsGtGxGyG}HAHGHIHMHPHYHZHbHfHiHmH}I@IEIMIRIUIaIbIcI"},
  {0,NULL,"iIkIoIpIuIxI{JGJJJLJQJRJSJWJ]J_J`JaJcJhJnJpJwKAKEKHKQKSK]K`KaKcKf"},
  {0,NULL,"KmKtKuKwKyK{K}L@LJLMLPLSLaLeLgLlLxL~MBMKMOMUMWMXMYM`MiMjMnMtM|N@N"},
  {0,NULL,"BNCNDNHNNNRNWNXN\\N^N_N`Nb_B?C?G?Z?[?\\?`?c?d?h?i?k?u@?@H@I@P@U@W@\\"},
  {0,NULL,"@]@^@a@d@e@i@k@yAEAJAKANASAVAWAXA[A]A^AeAiAjAkAmApA{A}BCBJBNBRB[B"},
  {0,NULL,"^BfBiBkBoBsBuB{B~CBCFCICOCPCTC[C_C`CiCtC{D@DBDJDMDNDZDaDeDiDjDoDq"},
  {0,NULL,"DuDzEAEGEHEKEMEQEUEZE]EbEcEdErE}FDFEFIFMFNFPFRFTFVFWF`FaFbFeFiFlF"},
  {0,NULL,"{F}GFGHGKGTGVG[GfGgGkGnGrGuGvG{G|G}H@HHHJHKHTHWHXHeHjHqHsHzIAIHIO"},
  {0,NULL,"ISI`IaIcIeIfImInIvIzJAJDJIJNJQJRJUJXJ^J_JbJeJfJiJpJsJ~KDKHKMKRKWK"},
  {0,NULL,"^K_KfKgKiKoKrKuKxL?LCLDLILLLQLRLZL]LhLrLzL|M?MAMJMRMYMcMdMfMiMkMl"},
  {0,NULL,"MqMsMzNDNJNKNLNPNRNTNXN[N\\N]N`NaNbNc_B?C?F?\\?]?^?a?b?d?g?j?n?w?}@"},
  {0,NULL,"G@J@M@O@T@Y@[@^@`@a@g@h@m@q@~AGAHALAPAQAVA^A_AaAbAdAfAiAjAmAuAwA|"},
  {0,NULL,"BDBMBOBSBVB\\BgBiBkBqBrBsBwCHCICLCNCPCSCTCZC^CjCmCvCwDADEDFDUDXDYD"},
  {0,NULL,"_DbDeDhDlDmDoDxD}E@ELEREUEXEYE\\E]E`EcEgEtE{FBFFFGFKFNFRFSFUFXFYFe"},
  {0,NULL,"FgFhFiFjFkFwFzG@GCGIGOGXG]GfGgGjGoGpGqGwGzG}H@HAHCHEHNHQH[H^H`HnH"},
  {0,NULL,"qHzI?ILIMIQIUIYI\\IeIkIlInIpItIyJ@JDJJJTJWJXJYJZJ]J`JaJbJfJjJmJ{K@"},
  {0,NULL,"KCKFKLKOKXK_K`KaKcKdKpKrKvKwL@LDLHLILJLUL`LbLcLhLsLuL|MDMGMLMPM_M"},
  {0,NULL,"aMbMgMiMjMkMoMvM}N@NDNENINMNONPNYN\\N]N_N`_B?C?F?\\?]?^?a?b?d?h?m?n"},
  {0,NULL,"?r@@@H@I@M@Q@R@V@_@`@b@c@e@h@i@p@{AJAKAMARAVAYAZA[A]A^AdAgAhAlAoA"},
  {0,NULL,"sAzA|BFBLBWBYB\\BbBjBlBqBvBxByB}C?CCCGCJCMCQCSCYC[C`ClCqCsD?DDDIDP"},
  {0,NULL,"DWD[DbDhDkDqDsDtDuDvD|EFEHEJELEMEPEYE^EbEcEhEpE~FDFEFJFMFOFPFSFUF"},
  {0,NULL,"VFWF_FcFdFfFhFpFqFwG?GAGJGLGUG]GaGbGdGiGmGqGxGzHBHDHFHGHIHMHXHcHe"},
  {0,NULL,"HhHpHrHuH|IIIJITIWI^I_IdIeIfIiIpIrI}I~JDJEJHJLJPJUJWJ^J_JcJeJfJiJ"},
  {0,NULL,"sJ{J~KBKMKRKXKYK]K^KfKgKiKoKrKuKxK}L?LCLDLLLNLOLVLYLpLqLtLyMBMIMK"},
  {0,NULL,"MSMXM[M]MgMhMiMlMqMsMzNBNDNINQNTNUNVNYN[N\\N^N_Ne_B?C?F?\\?]?^?a?b?"},
  {0,NULL,"d?f?j?m?q@A@K@L@N@O@P@S@V@[@\\@_@f@i@m@uACAFAIALAOASAXAYAZA_A`AeAf"},
  {0,NULL,"AkAnAoAqAyB@BFBMBPBSBXBbBfBhBnBoBpBwByB~CECFCKCLCMCUCWCXCaCfCzC{C"},
  {0,NULL,"~DBDKDSDVD]D^DdDeDfDlDqDtDyEBEDEHEOEXE[E]E^E_EaEgEhEkEyFAFCFGFPFV"},
  {0,NULL,"FXFZF[F\\F]F`FaFbFdFjFoFqFvG@GBGMGOGRGUGcGdGhGkGnGpGvG|G~HDHJHKHLH"},
  {0,NULL,"NHZHdHfHgHtHvHyH{ICIDIPIXIZI_IdIkImInIoIsIwJBJEJFJJJNJPJSJXJ[J\\J^"},
  {0,NULL,"JbJdJlJmJxJzKBKFKKKPKYK_KhKjKkKnKoKqKzK~LBLCLGLILKLML_LaLdLmLnLwL"},
  {0,NULL,"{M?MAMMMNMXMYM^M_MbMeMlMpMwMyN?NBNGNMNONRNTN[N]N^N`NeNf_B?C?G?Z?["},
  {0,NULL,"?\\?`?c?d?f?i?j?z@E@K@L@P@T@V@X@Y@Z@\\@_@g@j@k@tA?AGAHAOATAUA[A\\A]A"},
  {0,NULL,"`AcAdAgAlAnAoAsAvAyBIBKBPB]BaBdBhBkBmBnBrBtBuC@CACBCECHCPCUCYCbCc"},
  {0,NULL,"ClCsDADDDEDIDLDODPD_D`DcDmDnDsDtDvEAEGEIEJERESETE\\E^EbEcEdErE}FDF"},
  {0,NULL,"EFIFMFNFPFRFTFVFWF_FaFbFcFeFmFqF}GEGHGTGUGVGWGaGdGgGhGoGrGsG}HBHC"},
  {0,NULL,"HDHHHLHPHQH[H^H`HiHlHmHwIAIGIHIKI[I`IaIbIcIiImIqIyJ@JGJIJLJNJOJQJ"},
  {0,NULL,"RJ[J^JbJdJeJlJoJtJ~KDKGKRKVKWK`KbKdKgKiKsKtKwK{K|L?LELHLLL[L\\L_Ld"},
  {0,NULL,"LiLmLnLvM?MAMLMPMVMaMcMdMeMkMlMpMtM|N?NENFNJNLNPNTNYNfNg_B?C?G?Z?"},
  {0,NULL,"[?\\?`?c?d?h?i?k?u@?@H@I@P@U@W@\\@]@^@a@d@f@i@j@wAAAFAIALAMANAOARAW"},
  {0,NULL,"A_A`AdAeAfAiAmAuAyA{B?BJBPBRB^B_BhBlBoBvBzB{B|B~CDCJCOCQCRCUCeCgC"},
  {0,NULL,"jCmCtCvCwD@DFDUDWD[DcDeDjDkDnDoDuDxECEEEIEMEPEQETEUE]E`EcEeEjEvFB"},
  {0,NULL,"FFFGFIFJFKFOFTFXFYF`FaFdFiFjFoFxGCGFGHGVGXG[G^GbGfGiGlGrGtGwGyH?H"},
  {0,NULL,"@HEHFHHHMH\\H]HdHgHjHsHvHyIDITIWIXI^I`IfIgIhImInIsIxI{JHJIJKJMJNJU"},
  {0,NULL,"JXJ[J\\J`JaJcJgJmJoJwKAKFKGKQKSK]K^K_KbKhKmKpKvKxKyKzK}LELILNLOLVL"},
  {0,NULL,"YLeLfLkLlL}M@MEMHMUMVMWMZM`MeMjMmMsMzN?N@NANCNFNHNNNYNZNeNgNh_B?C"},
  {0,NULL,"?E?[?]?_?a?c?e?g?k?l?p@D@G@J@N@Q@S@W@X@Z@c@d@g@h@j@o@zAGAHALATA[A"},
  {0,NULL,"\\A]A_AaAbAeAhAkAlAnAtA~BGBHBKBQBZB]B`BfBnBoBtBxB|B}B~C?CACCCECFCR"},
  {0,NULL,"CeCgCjCmCqC|D?DCDGDMDQDZD^DaDbDgDmDpDqD{ECEEEHENEVEYEZE[E\\E`EfEgE"},
  {0,NULL,"mF@FBFFFLFNFQFRFSFUF[F]F_FaFbFcFfFmFrFsF|GDGNGPGQGYGbGeGlGmGnGvGx"},
  {0,NULL,"H?HGHIHJHKHMHOHQHRHUH[HlHvHwHyIAIBIFIHI^I_IbIcIjIlInIqI|J?JCJEJGJ"},
  {0,NULL,"HJQJXJYJ]J^J`JbJfJjJtJ|K@KCKLKOKUKVK_K`KcKdKoKpKrKvKwL@LCLDLHLILT"},
  {0,NULL,"LWLXL^LfLkLwL{L~MIMOMSMYMZM_M`McMgMhMoMvM}NANCNINLNONRNUNWNYNZN[N"},
  {0,NULL,"`NbNh_B?C?E?[?]?_?a?c?e?h?k?m?v?{@H@I@M@P@Q@U@\\@]@`@c@e@h@l@rADAJ"},
  {0,NULL,"AKAMAPAQARATAYAZA\\AdAfAgAlAoAsAzB?BGBLBQBWBYB_BjBlBqBvBwByB}C?CGC"},
  {0,NULL,"JCLCMCQCSC_CbCcCiCpCxDADEDLDODSD]DdDhDiDmDnDqDrDvD|EFEHEIEKELEWE\\"},
  {0,NULL,"E_EbEdEfEqF?FDFEFHFIFNFRFTFZF\\F^F`FbFeFgFiFlFuF{GDGHGKGNGVGZGfGgG"},
  {0,NULL,"jGkGrGuGvG{G|G}H@HAHHHKHSH_HcHhHkHxH}I@ICINIPIVIYI]IcIdIfIjIkIvIz"},
  {0,NULL,"JAJCJJJPJQJTJUJVJ[J\\J`JaJdJgJtJuJvK?KIKJKTKVK`KaKeKkKnKqKsKwK|LAL"},
  {0,NULL,"BLGLJLKLNLQLVLZLeLjLlLoM@MDMEMGMVMWM^M_MfMhMiMmMuM{NDNFNGNKNNNONU"},
  {0,NULL,"NWNZN_N`NaNhNiNj_B?C?D?Z?^?_?`?b?e?f?i?l?y?|@K@L@R@T@U@X@Y@Z@]@b@"},
  {0,NULL,"f@l@m@n@|AFAIASAUAXAYAZAaAbAcAgAhAiAjAlArAvBABBBEBTBUBcBdBiBkBmBv"},
  {0,NULL,"BxBzB}C?C@CCCDCJCPCTCXC]CfChCpCvCwCxDGDJDNDQD`DbDdDeDiDkDpDwD~E?E"},
  {0,NULL,"KEPESEVEYE]E_EaEeEhEnEwFAFCFGFHFMFWFXF[F]F^F_FeFfFgFiFnFtFyF~GEGS"},
  {0,NULL,"GWG_G`GfGgGjGmGsGtGxGyG}H@HAHGHIHPH\\H]HdHgHoHrH|H~IBIFIOISI\\I]I_I"},
  {0,NULL,"aIeIjIoIuIxI{JCJDJEJRJSJVJZJ[J^JbJdJfJlJrJxJzJ}KKKPK[K\\K_KhKjKkKo"},
  {0,NULL,"KqKrKzK~LBLCLDLGLILPLSL[L\\LiLpLtLvM@MEMLMPMWMXMZMbMdMhMkMpMwMyNAN"},
  {0,NULL,"BNJNMNNNPNUNWNYN\\N]NaNh_B?C?D?Z?^?_?`?b?e?h?i?n?o?~@H@I@R@V@W@^@_"},
  {0,NULL,"@a@b@d@e@k@l@xA@AJAKANAPAQASATAWAXA\\AeAjAkAmAnApAxA}BEBJBNB^BcBeB"},
  {0,NULL,"fBiBnBoBsBuB{B~CBCECFCICOCTCYCbCcClCoCrCyC}DTDXDYD\\DfDgDhDiDlDpDu"},
  {0,NULL,"DzEAEGEKELEMENEOEVEXEbEfEhElE|FDFEFHFJFOFSFUFZF\\F^FcFdFfFhFjFpFtF"},
  {0,NULL,"xG?GAGJGLG^G`GaGbGdGiGmGpGqGzHBHDHFHGHMHNHSHTHWH_HlHtHwH{IEILIQIR"},
  {0,NULL,"I[IcIdIeIhIlIoIrI}I~JDJKJOJPJQJSJYJ[J\\J]J`JaJgJrJuJvJyKIKJKZK\\K`K"},
  {0,NULL,"aKcKeKnKqKsKwK|L@LALGLJLKLOLRLYL]LfLkLmLnL}MCMFMHMUM`MaMbMfMhMlMm"},
  {0,NULL,"MuM{NCNENHNKNMNTNUNWNYN]N^NbNiNl_B?C?D?Z?^?_?`?b?e?g?l?n?s@B@G@J@"},
  {0,NULL,"O@Q@T@W@Y@[@c@d@g@k@m@s@}AGAHAOAPAQAUAVA^A`AcAdAfAiAmAoAuAvAwAxBD"},
  {0,NULL,"BOBVBdBeBgBkBqBrBsBwByCHCICLCMCNCPCSCVCeCgCkCtCzC~D@DHDRDWD[DaDbD"},
  {0,NULL,"cDdDlDrDuDxD}E@EMETEWEXEYEZE_E`EeEfEsEzFBFFFIFJFLFOFQFTF[F]F_F`Fa"},
  {0,NULL,"FbFcFmFsFxF|F~GPGQG^G_GbGeGkGlGnGvGxG|H?HIHJHKHMHOHVH^H`HaHiHkHmH"},
  {0,NULL,"xIGIIIJIKIZI`IaIdIjIlIpIqI|J?JCJFJIJPJRJWJYJ\\J_JcJdJeJkJoJqJyJ}KG"},
  {0,NULL,"KNKZK[K]KbKfKgKkKlKnKuK}L?LBLELFLKLWLXL`LcLgLjLoLxMJMMMNMRMXM[M\\M"},
  {0,NULL,"_M`MfMkMrMxM~NBNCNKNONPNSNVN\\N^NaNbNhNiNlNm_B?J?O?U?X?_?b?c?e?h?i"},
  {0,NULL,"?o?p@A@B@C@F@O@V@W@\\@^@_@b@g@h@n@oA@ABACAEANATAVA[A]A_AaAdAlApAtA"},
  {0,NULL,"vAwAzA{BIBLBTBXB[BeBgBpBzB~CFCICWCXC^C_C`CaCcCeCiCnCwCxC|DADDDEDP"},
  {0,NULL,"DQDSDUDVDWD[DkDmDsDtDvDwDyD~E@ECEPEWE\\E_EbEfElEqEvEwExE{FCFDFEFHF"},
  {0,NULL,"OFRFZFcFfFmFpFtFxGAGDGEGHGIGLGMGOGRGXG_GaGbGdGgGiGjGoGpGqHKHMHNHS"},
  {0,NULL,"HVH_HiHlHsHtHwHyI@IBIHILIUIeIgIhIoIwIzI~JCJDJGJKJRJXJYJ^JdJiJlJqJ"},
  {0,NULL,"vJ{K@KBKDKEKFKHKQKSKVK\\K]K^K`KbKdKgKhKiKmKyLFLHLMLRLaLgLhLpLtLuLw"},
  {0,NULL,"LyL}M@MJMKMVM^M_MbMtMwM~N@NANBNFNONQNSN[N_NfNhNjNk_B?I?N?V?Y?Z?\\?"},
  {0,NULL,"_?`?g?n?s?z?{?|@?@A@O@Q@Y@]@`@c@d@f@j@w@x@}@~ADAEALANARAVA_A`AaAh"},
  {0,NULL,"AnAqAuA|A~BABEBFBKBSBYB^BdBlBzB{CLCPCSCVCZC^C_CaCcChCiCjCnCqCsCuC"},
  {0,NULL,"yC{C}DGDIDLDQDSDTDZD^DgDqDtDvDzD{D~EBEGEKENESE^E`EeEjEsExEyE|E}FB"},
  {0,NULL,"FDFFFJFTFYF[F_FcFmFnFsFxFzF~GAGGGKGMGQGRGVGZG`GcGdGeGkGlGnGqGvGxG"},
  {0,NULL,"|HAHIHVHaHgHiHmHpHqHxH|I@IEIKIUIWIZIdIlImIyI|JAJDJFJJJLJRJSJYJ[J`"},
  {0,NULL,"JgJjJmJoJtJxJ|KAKMKQKRKTKXKYKZK]K^K_KdKhKmKoKpKsKxKyK~LNLVLcLeLfL"},
  {0,NULL,"kLpLrLuL{MHMNMPMSMVMWMeMfMsMwM{N?NHNJNLNNNQNUNWNXN[N`NcNj_B?J?L?U"},
  {0,NULL,"?X?[?\\?^?d?h?m?r?x?|?}@D@E@Q@R@Y@]@_@`@b@g@k@t@u@{@|AAADAOAQARATA"},
  {0,NULL,"UA\\A]AkAmAsAtA}B?BDBHBJBMBPBQBUB\\BhBmBrC?CJCSCZC]C_C`CcCfCgChCiCn"},
  {0,NULL,"CoCtCzC{C|D@DJDQDRDVDXDYD\\DaDfDgDpDwDyDzD}EBEEEOEUEZE]EbEcEpErEuE"},
  {0,NULL,"yEzF@FAFDFEFIFUFVFWFdFhFkFpFqFwF{G?GBGFGJGOGPGQGSGWG_GaGbGiGkGlGm"},
  {0,NULL,"GnGqGxGzH@HIHXH[HeHoHpHrHsHuI?I@IDIGIJIVI^I_IbIdI{I}JAJCJHJJJMJPJ"},
  {0,NULL,"WJXJ[JbJgJlJoJrJtJyJ~KCKEKSKTKUKWKYK[K`KbKcKdKeKgKjKsKtKvK{LELVL["},
  {0,NULL,"L\\LgLiLkLmLnLoLuMAMCMGMSMXMcMdMkMvMyM|N?N@NHNLNMNPNSNWNXN]NbNdNm_"},
  {0,NULL,"B?H?M?T?W?Z?[?]?c?f?j?v?z@?@@@B@D@O@T@V@W@X@Y@\\@e@l@r@t@z@}AAACAM"},
  {0,NULL,"AQAXAYAZA\\A_AgAjAqAsA|A}BABBBCBMBOBRBZBbBrBuB|B~CLCMCWCXC_CaCdCeC"},
  {0,NULL,"gCkClCnCoCvCyC}D?DADGDJDLDNDRDXD[D`DbDhDkDwDxD{D|EAECELEQESEZEaEd"},
  {0,NULL,"EiEoEvE|E~F@FAFBFCFKFLFMF\\FeFgFlFnFuFvFyFzF}GGGJGLGPGQGWG[G^GbGgG"},
  {0,NULL,"iGmGpGqGsGtGxG|G}HMHYHbHeHmHnHxHyHzH}I@IEINIPIQI^IiIoIpIwI{J?JLJP"},
  {0,NULL,"JQJSJTJUJXJdJeJkJlJnJrJvJ}J~KBKFKLKOKQKTKXKZK^KaKhKjKlKoKpKrKsKvK"},
  {0,NULL,"|LLL`LaLcLfLhLiLnLoLtLvMAMKMLMTM\\M]M`MfMsMxM}NANENFNKNLNPNQNYNZNa"},
  {0,NULL,"NhNkNl_B?J?O?U?X?_?b?c?e?h?m?s?v?|?}@D@E@P@Q@U@V@Z@\\@`@g@k@s@v@{@"},
  {0,NULL,"|AAADAOAPAUAVAYA[A^AkAmAsAuA}BFBHBJBKBMBPBQBUB\\BhBmBtC?CMCSCYCZC["},
  {0,NULL,"C\\C]CbCgChClCnCrCwCyCzC}DBDMDNDRDTDUDVDZDeDjDlDoDwDyDzD}E?EEENEQE"},
  {0,NULL,"VEXEbEfElEqEvEwExE{FCFDFEFHFOFRFZF`FbFlFmFuFvFxGAGDGHGIGKGSGWGXGY"},
  {0,NULL,"G\\GdGfGgGjGpGrGuGvGwHAHKHMHQHSH_HkHmHrHtHvHxI@IIIKINIXIYI\\IfIkIxI"},
  {0,NULL,"zI~JCJEJFJTJUJWJYJ]J_JhJiJpJqJuJ{K@KDKFKKKPKQKTKYKZK^K_KhKiKlKmKn"},
  {0,NULL,"KpKrKzLFLHLMLNLaLgLiLqLrLwLzL|M?MDMFMIMUMWM`MaMtMwM}N?NANCNENJNRN"},
  {0,NULL,"SN\\N]NbNdNmNn_B?I?O?T?W?Z?_?a?e?h?k?v?y?}@B@E@F@M@P@Q@U@[@`@a@g@m"},
  {0,NULL,"@r@s@{A@AAABALAOAPAUAWA^A`AkAlAsAuA~BEBFBJBKBMBPBTB\\BeBqBsBwCDCOC"},
  {0,NULL,"UCZC[C\\C]CbCdCgCjCmCnCpCrC}DBDCDDDGDMDNDPDVDZD]D`DqDsDtDwDyD{E?EA"},
  {0,NULL,"EFEHENESEVE`EfEmEsEwExE}E~FAFBFFFJFNFQF[FfFgFkFnFsFwF{G?GFGGGMGNG"},
  {0,NULL,"OGRGTGUG_GaGdGhGoGqGsGuGvGwG{HFHLHZH^HfHjHoHpHzH{H}H~IDIFIJIQI^Ia"},
  {0,NULL,"IbIcIwIxI~JHJMJNJOJQJSJVJ\\JdJgJkJoJtJyJzJ}KCKEKHKMKNKRKSK\\K]K_KbK"},
  {0,NULL,"fKgKiKlKnKoKuKwLKLWLXLYLjLlLnLoLsLxL{MAMEMGMRMXM[M]MkMtM}M~NDNGNK"},
  {0,NULL,"NMNPNUNVNWNXN[N_NjNkNpNq_B?H?N?U?X?Z?^?`?c?g?l?s?u?{?~@A@E@N@O@Y@"},
  {0,NULL,"[@_@c@d@f@i@s@w@~A?A@ADALAMANARATAZA`AhAiAqAuA|A~BABBBCBFBNBSBYBa"},
  {0,NULL,"BnBwByCBCQCRCVCXCaCbCcCfChCiCjCnCpCqCuCyD@DEDGDIDNDQDWDYDZD_DbDhD"},
  {0,NULL,"jDvDwDzE@EEEGEKEQESEYEaEeEiEnE{E|E}F@FAFCFEFKFMF]F^F`FiFlFoFrFuFy"},
  {0,NULL,"F|G@GCGJGLGNGTGUG]G_GaGcGhGlGoGpGqGuGxH?HBHEHcHfHhHjHkHnHsHuHvHwI"},
  {0,NULL,"MISITIXI\\I]IcIjIyI~JAJCJHJIJKJOJUJZJ_JcJhJkJnJpJsJwJzJ}KIKJKLKOKS"},
  {0,NULL,"KVKWK]K`KaKcKdKmKoKrKtKwK}LBLPLSLbLgLjLlLmLqLtLxL~MIMMMRMYMaMiMjM"},
  {0,NULL,"wM{M|N@NCNONPNRNTNVNYNZNaNiNlNnNr_B?J?P?V?Y?\\?^?b?e?f?m?q?s?}?~@?"},
  {0,NULL,"@D@N@P@U@V@[@\\@a@e@k@u@x@z@|@~AAAQASATAWA\\A]AbAgAoApAqAvAzBABCBIB"},
  {0,NULL,"LBRBVBZBcBfBiBoCDCNCRC[C\\C_C`CfCgCjClCmCpCqCuCxC~DADCDFDHDIDKDLDP"},
  {0,NULL,"DWDmDnDrDtDvDxD{D}E?EBEPEWEYE^EbEhElEpEuExEzE{FBFDFEFHFOFUFVF_FbF"},
  {0,NULL,"lFmFuFvFyF}GAGDGIGUGXGYG[G\\G^GdGeGgGhGjGrGsGuGwGyHEHLHRHUHWHjHkHv"},
  {0,NULL,"HxH~I?I@IEIIINISI^I_IiIlIxI|J@JCJEJFJLJMJTJZJ[J\\JgJlJoJrJvJyJ~KBK"},
  {0,NULL,"EKJKLKOKSKUK[K]K`KaKcKeKgKqKsKtL@LCLGLOLSLYLiLkLmLnLyL{L|MAMCMNMT"},
  {0,NULL,"MUM`MfMjMvMzM{N?NBNHNKNMNPNRN_N`NfNgNhNkNoNr_B?I?K?V?Y?]?a?d?e?g?"},
  {0,NULL,"k?p?q?~@@@E@F@R@S@W@Z@^@c@d@f@m@r@u@z@{A?A@ALAOAUAXAYA[A`AfAiAqAt"},
  {0,NULL,"AwA{B?BBBCBDBNBWB`BaBjBmBuCCCECFCVCWCYCZC]C^CbCjClCsCvCwCxC{D@DAD"},
  {0,NULL,"HDJDRDSDTDWDXDcDeDrDuDvDxDzE?EDEFELEREWE]E`EgEmEtEuEwE~F?FBFEFFFN"},
  {0,NULL,"FQFSFXFaFbFmFoFrF|G@GCGDGHGJGLGPGSGWGZG`GbGeGfGgGlGmGnGtGxHGHJHNH"},
  {0,NULL,"QHYH[HjHlHpHqHtHvHyIBICISIXIbIcIiIjI}J?J@JCJEJGJJJNJSJUJ\\JaJgJkJn"},
  {0,NULL,"JwJyJzJ}KCKFKHKMKRKVKWK\\K]K_KbKeKfKhKiKlKmKzK{LLLRLTL]LiLjLnLoLpL"},
  {0,NULL,"rLxL~MGMRMTMaMbMhMjMtMuMzN@NGNJNKNMNQNVN\\N^NeNgNiNnNu_B?H?P?T?W?^"},
  {0,NULL,"?`?a?b?f?j?o?q@?@@@B@D@N@Q@S@V@Z@[@\\@e@l@q@x@z@}AAACANAOAQARASAWA"},
  {0,NULL,"\\AgAjApAqAzA|BABBBCBIBOBRBZBbBlBrB|B~CECMC\\C]C_CeCfCgChClCmCpCtCu"},
  {0,NULL,"CwCxC}DADHDIDLDMDPDQDXD_DaDiDjDwDxD{D|D}EAEKEPEREYEaEhEkEnEzE{E}F"},
  {0,NULL,"?FAFCFFFGFPF]F^FdFjFoFpFqFtG@GBGCGEGKGNGPGQGRGVG]GcGdGfGhGjGkGnGu"},
  {0,NULL,"GvHDHGHKHXHdHgHlHmHoHtHuHyH{ICILIRIVI`IkImInIxI|JBJDJJJKJNJPJQJWJ"},
  {0,NULL,"]JfJhJjJpJsJuJxJ|K?KFKGKNKQKVKWK\\KbKdKeKfKgKiKmKqKtKxLALELMLTL^Le"},
  {0,NULL,"LfLoLqLsLuLzM?MBMPMQMZM_MdMhMvMzM~NENFNINJNSNUNVNYNZNaNbNlNmNu_B?"},
  {0,NULL,"I?O?T?W?Z?_?a?e?h?n?o?t?|@A@C@D@M@W@X@^@_@a@b@g@j@o@x@|ACADAEALAT"},
  {0,NULL,"AZA]A_A`AaAdAmApAtAwA{B?BDBIBLBQBUBXB[BfBnB}C@CGCKCVCXC^C`CaCcCeC"},
  {0,NULL,"fCkCoCwC~DADBDDDEDHDNDPDUDWD[D\\D_DeDoDuDwDxDyD|D~EGEMEREWE_E`EfEm"},
  {0,NULL,"EsEwExE}E~FAFBFFFJFNFQF[F`FjFkFoFwF{F|G?G@GFGSGTGUGWGYG\\G^GbGfGgG"},
  {0,NULL,"hGiGoGrGsGwG{HFHPHUHZHfHnHqHuH{H|H}I?IAIGIMIVIZI_I`IdIwIxIzJIJJJL"},
  {0,NULL,"JOJPJVJZJ]J`JgJjJoJtJyJ|KAKCKKKMKOKPKRKTKYK]K^K_K`KdKfKoKpKrKwLCL"},
  {0,NULL,"KLQLWLXLeLfLkLmLvLxL{MBMCMHMSMYMcMdMgMwM}M~NHNINKNLNNNTNUN\\N]NeNi"},
  {0,NULL,"NmNnNqNw_B?H?K?U?X?[?]?a?b?g?l?p?r?{?~@A@E@P@S@T@X@Z@c@d@f@i@o@u@"},
  {0,NULL,"~A?A@ADALAPASAWAXAYA`AhAiAqAtA{A|BABBBCBDBNBSBYBaBnBoBwCBCHCQCVCW"},
  {0,NULL,"CYC\\C]CbCcCdCjCoCqCrCvCwCxD@DHDJDODPDRDWDZD`DaDiDkDvDwDzE@EEEFELE"},
  {0,NULL,"PEREZEaEgEkEoEvEzE~F?FAFCFDFGFLFPF\\FfFhFnFpFsFtFzF~GBGGGKGTGUGVGY"},
  {0,NULL,"G[G^GeGfGiGjGnGrGsGtGwHCHHHOHTHWHZHiHkHoHrHwHzH|IDIOIUIWI[IdIgIlI"},
  {0,NULL,"zI}J@JDJHJIJMJTJVJYJ^JbJjJlJmJxJ|J~KAKBKGKIKJKKKNKXKZK_KfKgKhKjKk"},
  {0,NULL,"KlKnKqL@LILKLUL_LdLhLkLlLmLwLzL{MJMNMOMSMVMXMeMlMtMuMyN?NBNCNDNIN"},
  {0,NULL,"LNONWNYNZNaNjNlNpNrNx_B?J?M?V?Y?[?_?c?d?f?i?p?z?{@@@B@C@M@T@V@X@\\"},
  {0,NULL,"@_@b@e@h@r@w@}A?ABACAMAPAQAZA\\A^AcAeAjAqAsA|A}BBBHBJBMBOB]B_BbBqB"},
  {0,NULL,"vByC@CACHCVCXC[C_C`CdCeCkClCoCvCyC}C~D@DCDFDGDJDKDNDXDZDeDfDgDlDx"},
  {0,NULL,"DzD{D~ECEDENEQEZE]EbEdEqErEvEwEyF@FDFEFFFIFRFWFZFaFcFmFpFqFtFxGBG"},
  {0,NULL,"EGHGIGNGOGTGXG]G_GaGdGgGhGiGlGoGpGsG~HCHPH^H`HcHiHlHtHwH|H~I?ICIH"},
  {0,NULL,"ILIWI`IaIjImIwIyJ?JGJKJMJNJRJYJZJ`JaJgJhJpJsJtJuK?KCKGKIKKKNKPKUK"},
  {0,NULL,"[K_KaKeKjKkKnKqKrKsKuLBLJLQLZL_LeLjLlLuLxLyL|L~MBMEMPM^M_MeMhMsMu"},
  {0,NULL,"MxN@NBNGNINNNRNUN]N^NbNcNdNmNqNsNx_B?H?K?U?X?[?]?a?b?g?j?v?w?|@?@"},
  {0,NULL,"@@F@M@O@T@X@Y@a@b@f@l@q@v@z@{@}AEANARASAWA]AbAcAfAnArAuAxAyB@BEBG"},
  {0,NULL,"BKBWB^B`BdBiBkBxCACGCOCXC[C_C`CaCfChCkCmCrCsC|D@DBDCDEDKDODTDVDWD"},
  {0,NULL,"YD]DcDlDnDuDvDyDzD|D}ECEHEIEXE[EaEgEkEoEvEzE~F?FAFCFDFGFLFPF\\FbFe"},
  {0,NULL,"FlFnFsFvFzF}F~GGGJGLGOGZG[G^G`GbGiGlGoGpGrGsGtGxHCHFHOHTHWH\\HmHuH"},
  {0,NULL,"wHzH}H~I@IEIFIKIPIZIfImInIzI}J?JFJHJKJLJQJTJXJ]JaJhJjJmJuJxJ|K?KA"},
  {0,NULL,"KEKGKMKNKRKVKWK]KbKcKfKgKmKnKqKtL?L@LILWL_LdLfLmLsLtLuLzL|MDMHMPM"},
  {0,NULL,"QMWM[M\\MfMtMyMzNENINNNONPNSNUN\\N^N`NcNeNgNp_B?H?N?U?X?Z?^?`?c?g?j"},
  {0,NULL,"?o?x?|@?@@@F@M@N@S@U@Z@[@a@f@l@n@t@z@{@}AEAMAXAYAZA^AbAcAfAnArAtA"},
  {0,NULL,"wAxAyB?B@BGBWB^B`BdBkBvBxCGCNCOCWC[C\\C]C`CdCkClCmCqCrCzC{C~DDDEDF"},
  {0,NULL,"DODSDUDYDZD\\D^DfDmDqDvDyDzD}EAECEMEOETE\\EaEeEiEnE{E|E}F@FAFCFEFKF"},
  {0,NULL,"MF]F^FcFdFoFpFqFrF|G@GCGEGKGNGVGZG\\G]G`GaGcGeGhGjGnGuGvGwG{H?HEH]"},
  {0,NULL,"HcHhHkHtHuHyHzH{I?IBICIGIRIbIeIiIpI|I~JAJGJIJKJNJPJTJWJ[JdJkJlJnJ"},
  {0,NULL,"rJvJwJzJ}KLKMKOKPKRKXKZK_K`KaKhKjKkKoKpKrK}LBLDLPLSLXLiLlLoLtLvLy"},
  {0,NULL,"LzL}MGMLMTMZMbMcMhMsMwM|NANCNFNINKNMNPNXN[N^N`NcNgNw_B?H?M?T?W?Z?"},
  {0,NULL,"[?]?c?f?l?t?u?{?}?~@C@N@O@R@Y@[@]@`@e@i@o@y@|@~A?ABASAUAVAWAXAYA["},
  {0,NULL,"AeAoApArAvAxAyB@BGBLBVB]B_BcBgBjBtCJCPCTCYCZC\\C]C^CfChCiCjCsCtC|C"},
  {0,NULL,"}C~D?DDDKDMDSDUDXD[D]D^DfDlDuDxDyD{EEEFEGEIEME[E\\EaEdEiEoEvE|E~F@"},
  {0,NULL,"FAFBFCFKFLFMF\\F`FaFlFoFrFuFvFyF|F}GIGJGLGMGNGXG]GaGbGcGdGhGkGpGqG"},
  {0,NULL,"xGzG|G}HYH_HbHjHkHmHnHoHqHsIAIIISITI[I_IhIlIwIyI{JCJDJEJIJOJQJUJ`"},
  {0,NULL,"JbJjJlJmJrJvJ~KAKBKGKHKNKUKXKZK[KeKfKhKiKjKlKnKpKqK|LFLLL[L`LcLhL"},
  {0,NULL,"mLoLpLqLwL{M@MCMNMOMUMgMiMjMuMxM}N?NDNFNHNLNONVN]N^N`NcNdNgNvN|N}"},
  {0,NULL,"_B?H?P?T?W?^?`?a?b?f?l?r?y?{?}?~@C@R@S@T@X@Z@]@^@e@i@p@s@|@~A?ABA"},
  {0,NULL,"MANARAVAZA[AaAeAoArAsAxAyB@BGBHBJBVB]B_BcBgBtB{CCCJCTCVCWCXCYCZC^"},
  {0,NULL,"CaCdCiCtCzC{D?DADBDCDFDLDMDTDVD[D\\DcDmDnDqDxDyD{E@EFEGEHEOETEXEaE"},
  {0,NULL,"hEkEnEzE{E}F?FAFCFFFGFPF]F^F_FfFnFpFqFsFtF~GBGEGIGKGSGVGXG[G^GfGg"},
  {0,NULL,"GjGmGnGrGsGtGvH@HDHGHSHdHgHnHoHpHrHwHyH|IHIJIOIWIYI]IaIjIxJ@JBJDJ"},
  {0,NULL,"HJPJRJUJVJYJ\\JcJhJkJpJsJuJwJzK?KLKOKUKVKWKYK[K^K`KaKbKdKmKoKsKtKx"},
  {0,NULL,"LALHLTL\\L^LfLgLhLlLqLrLxL~MEMFMMM^MeMkMlMvM{M~N@NCNENGNLNTNVN^N_N"},
  {0,NULL,"`NcNfNgN{N|N}_B?I?N?V?Y?Z?\\?_?`?g?k?x?y?~@@@E@F@M@Q@S@V@Z@`@a@f@m"},
  {0,NULL,"@n@y@z@{A?A@AXAYA\\A_AaAbAcAfAiArAtAwA{B?B@BDBGBNBWB`BaBjBpBuC?CCC"},
  {0,NULL,"ECWCYC[C]CeCgCkClCmCtCxCyCzC{C~DEDFDIDJDSDUDYD[D_DdDhDoDvDxDzE?EA"},
  {0,NULL,"EDEMETEUE_E`EeEjEsExEyE|E}FBFDFFFJFTFYF[FgFiFkFnFsFzF{F~GFGGGJGLG"},
  {0,NULL,"MGRGTGUGXGdGhGjGkGoGpGqGvGwHAHDHIHVHaHbHlHoHpHrHxH}H~IDIFIOIPI[If"},
  {0,NULL,"IgInIyI|I~JEJMJQJRJSJVJXJ_JfJiJjJmJqJxJ{J|KAKIKJKTKVKWKYK[K^KaKcK"},
  {0,NULL,"dKjKkKpKsKtKyK|K~LNLVL^LeLhLnLpLsLwL|MDMJMOMQMXM[M\\MlMsM{M|NBNDNE"},
  {0,NULL,"NGNHNJNSNYN\\NeNiNlNnNyNzN|_B?I?K?V?Y?]?a?d?e?g?n?t?w?{?|@?@A@M@O@"},
  {0,NULL,"W@Y@\\@^@a@f@j@p@v@}@~ADAEANAOAQARAUAbAcAhAnArAuAxAyA~BEBFBKBSBYB^"},
  {0,NULL,"BdBhBlB{CICLCPC_C`CaCeCgChCiCkCmCrCsCxCyC|D?DCDIDJDKDMDODTDVD`DiD"},
  {0,NULL,"pDsDvDzD{D|D~EBEHEJEVE[E`EgEmEtEuEwE~F?FBFEFFFNFQFSFXFhFjFkFoFrFw"},
  {0,NULL,"F|G?G@GCGIGKGSGTGUGVGWGbGfGgGjGmGoGpGsGwG}HJHNHQH[HdHlHnHqHsHxH{I"},
  {0,NULL,"?IGIMIRITI\\I]IeIpIzJ?J@JEJJJOJPJRJWJZJ^JeJiJkJnJwJzJ}K@KDKHKIKJKU"},
  {0,NULL,"KXKZK\\KbKcKeKiKjKkKlKqKtKzK{LALRL]L`LeLgLnLqLrLvLyL}MIMLMMMYMZMcM"},
  {0,NULL,"iMuMyMzNANFNGNHNQNRNTNWNXNZN[NaNjNtNuN}_B?J?M?V?Y?[?_?c?d?f?m?t?x"},
  {0,NULL,"?}?~@?@D@N@R@[@]@_@b@d@e@k@v@y@z@|@~AAALAPASAVAWA[A^AgAoApArAvAxA"},
  {0,NULL,"zB@BIBLBRBVBZBcBiBoBsCKCNCRCYCZC\\CbCcCfCiCjCmCsCuCvC~D?DDDEDGDHDK"},
  {0,NULL,"DODSD[D]DbDdDkDsDvDxD{E?EBEEEIEJE\\E_EbEdEqErEvEwEyF@FDFEFFFIFRFWF"},
  {0,NULL,"ZFgFhFkFpFqFtFwF{GBGEGOGPGQGZG[G^G_GaGcGiGkGlGmGoGtGxG~H?HPHTH^H`"},
  {0,NULL,"HiHpHrHuHvH{I?IJIOIRIVIYI]IkInIyI{J?JFJGJHJJJMJVJWJ_JeJhJiJpJqJsJ"},
  {0,NULL,"uK?KDKFKKKLKOKPKQKRK^K_KfKhKiKkKnKoKrKuLILJLPLQLZLgLjLkLrLsLzL|M?"},
  {0,NULL,"MFMMMQMZMdMkMlMsMuM}NCNJNMNNNRNSNTNYNZN_NfNhNkNoNxO?_B?I?L?T?W?\\?"},
  {0,NULL,"]?`?d?h?n?r?z?|@A@C@D@N@Q@_@`@b@c@d@g@j@p@t@|ACADAEAOASATAUA]AbAc"},
  {0,NULL,"AdAmAsAtAwA{A}B?BDBHBQBUBXB[BfBxB}C@CBCKCXCZC`CcCfCgChCjCmCoCpCtC"},
  {0,NULL,"vCzD@DDDFDPDRDXDYD\\D]DcDdDhDrDwDxDyD|EBEGELETEUE]E`EcEjEtEuEyE|F?"},
  {0,NULL,"FBFCFFFSFTFXFYF_FeFmFnFxFzF~GAGDGHGMGRGYGZG\\G]G`GaGcGeGkGlGqGtGuG"},
  {0,NULL,"vG~HBHHHRH\\H]HiHjHmHwHxH{H|IHIKINIUIYI\\IeIoI{JAJBJDJFJLJNJOJRJTJc"},
  {0,NULL,"JeJiJkJnJqJwJ{K@KDKGKHKIKJKKKPK\\KaKbKcKeKgKkKlKnKqL?LDLGLULZLbLqL"},
  {0,NULL,"rLsLtLvLyL{L}MFMIMKMVMWM^M`MvMxMyNCNDNFNQNRNTNUN\\NeNfNhNiNnNoNsNw"},
  {0,NULL,"O@_B?I?L?T?W?\\?]?`?d?h?k?q?u?}@B@E@F@P@T@U@W@^@c@d@g@m@q@y@{A@AAA"},
  {0,NULL,"BAMAPA^A_AaAbAcAkAlApAuAvAzA~BEBFBKBPBTB\\BeBkBqBsCDCQCUCVCWC[C\\C^"},
  {0,NULL,"CbCdCeCkCoCpCqCuC|D?DBDKDLDNDODQD\\D]D^DgDiDpDwDyD{EAEDEFEJEKE[E^E"},
  {0,NULL,"`EcEjEtEuEyE|F?FBFCFFFSFTFXFYFaFdFmFoFrFxGAGCGDGHGOGSGWGZG[G_G`Gb"},
  {0,NULL,"GcGeGfGiGlGmGrGtGyHBHHH\\H]H`HjHkHlHvHyH|H}IBIIILIXIfIgIhIkI{I}JBJ"},
  {0,NULL,"EJGJKJLJNJUJVJbJfJiJjJmJqJxJ{K@KDKEKIKJKLKSKTKYK`KaKcKdKkKpKqKrKs"},
  {0,NULL,"L?LDLJLOLULbLhLpLsLvLxLzL|M?M@MDMJMUM_MaMbMvMxM|NBNDNENJNKNONTNWN"},
  {0,NULL,"XN[NbNdNjNoNpNsOA_B?J?L?U?X?[?\\?^?d?h?i?u?w@A@B@C@F@P@R@S@U@W@]@^"},
  {0,NULL,"@g@h@q@wA@ABACAEAPAQAXA\\A^A_AaAdAlApAuAvAzA~BEBIBLBTBXB[BeBpBzB|C"},
  {0,NULL,"FCICTCWCYC[C^CaCbCdCeClCpCqCsCwCzC|D?DIDLDODQDRDUD]DbDdDnDrDvDwDy"},
  {0,NULL,"E@ECEDEIEJEYE^EbEcEpErEuEyEzF@FAFDFEFIFUFVFWFeFiFkFlFwFyF{F}G?GFG"},
  {0,NULL,"MGPGQGRGVGYG\\GeGfGkGmGnGrGuGvGxGzH@HJHXHaHeHnHqHrHsHtHzH~IAIFIMIQ"},
  {0,NULL,"IZI`IaIcI}JAJBJIJQJSJWJXJYJZJaJcJgJhJoJsJtJyK?KCKHKKKPKUKXK[K\\KeK"},
  {0,NULL,"jKkKlKnKpKrKsKtKvK~LEL[L\\L]LeLfLiLjLlLuLwMBMEMHMRMYM[M]MgMxMyM|N?"},
  {0,NULL,"N@NANGNINNNVN_NeNfNhNiNkNtNvNyOB_B?J?P?V?Y?\\?^?b?e?f?i?w?y?{@@@B@"},
  {0,NULL,"C@P@R@T@U@X@]@c@e@h@n@p@}A?ABACAMATAVAZA[A]A`AeAjArAsAyA}BGBHBJBM"},
  {0,NULL,"BOB]B_BbBvByB}CACHCUCVCXCYC^CbCcCdCiCkCrCtCuCvC{DBDCDFDGDHDMDTDYD"},
  {0,NULL,"\\DaDjDoDpDxDzD{D~E@EDEOEUEVEXEbEhElEpEuExEzE{FBFDFEFHFOFUFVFiFjFk"},
  {0,NULL,"FlFuFvFyF}G?GFGNGPGQGYG\\G]G`GcGeGkGmGnGrGtGuGwGyHLHOHRHUHhHiHqHsH"},
  {0,NULL,"vHzH}H~IAIPIQITI[IhIoIpI|J@JBJFJGJIJOJSJXJZJ^JfJiJlJrJvJ{J~K@KBKE"},
  {0,NULL,"KFKGKMKNKQKSK]K^K`KcKfKgKiKmKoK}LCLGLOLYLdLjLkLpLtLvLwLyM@MKMLMOM"},
  {0,NULL,"\\M]MgMiMzM{M~NANBNDNMNNNONQN]NaNbNdNlNmNqNrNsN~_B?H?P?T?W?^?`?a?b"},
  {0,NULL,"?f?l?r?y?{?}?~@C@R@S@T@X@Z@]@^@g@m@q@s@{A@AAABAGAHAJALAQAVAcAlAoA"},
  {0,NULL,"sAtB@BBBDBGBHBIBNBRB[B\\B^B_BdBhBkBlBmBnBoBtB{B|C@CKCOC^C_CiCnCqCx"},
  {0,NULL,"CyC{D?DCDFDVDZD[DcDdDhDrD|EBEGEHENEOEPEQETE_E`EcEnEtEuEyE|F?FGFKF"},
  {0,NULL,"NFRFTFUFZF_FaFkFnFqFsF|F}GBGFGKGLGOG\\GfGjGpG{G~HFHSHUHVHYH_H`HaHg"},
  {0,NULL,"HhHrHsHvHwHxHyI@IEIGIHIJIKIOITI^IaIbIcIqIrIvIwIxI~JFJHJPJRJbJfJjJ"},
  {0,NULL,"lJmJoJ{J}J~K@KEKIKJKLKSKTKYK_KaKkKuKvKwK{L?L@LHLILJLML`LcLpLuLvLz"},
  {0,NULL,"M?M@MGMHMJMLMPMUMgMiMjMuMxM}N@NBNINJNMNNNTNWNbNhNjNlNnNqNtNxNzN~O"},
  {0,NULL,"@OCOF_B?I?O?T?W?Z?_?a?e?h?k?v?y?}@B@E@F@M@P@Q@U@[@`@a@e@l@r@x@z@}"},
  {0,NULL,"AAACAGAJAKAPARATAXAgAlArAsB?BEBGBJBKBLBOBPBSBVBXBYB`BfBjBlBnBpBqB"},
  {0,NULL,"vBwByCJCLCTC\\CbCcCnCpCrCvCxD@DEDGDJDVD]DcDmDnDqE@EFEGEHEIESEVEZE]"},
  {0,NULL,"E_EaEhEmEnEzE{E}F?FHFIFMFPFWFXF[FdFfFlFnFrFvG?GAGFGGGIGQGTGZGhGlG"},
  {0,NULL,"oG|G}H@HQHTHWHXHZH]H^H_H`HiHpHtHvHwH{H~IFIJIQITIUIWIXI^IiIoIpIqIr"},
  {0,NULL,"ItIwI{J?JHJOJSJYJ]JfJiJjJnJpJuJxJ{KBKFKGKNKQKVKWK\\KbKjKtKuKvKxKyK"},
  {0,NULL,"}K~LELGLLLQLULbLeLkLqLzM?MBMIMLMNMQMSMUM_MaMbMvMxM|N?NANHNINMNSNV"},
  {0,NULL,"NYN\\N^NfNlNmNrNsNyN|O?O@ODOF_B?J?M?V?Y?[?_?c?d?f?m?t?x?}?~@?@D@N@"},
  {0,NULL,"R@[@]@_@b@d@f@j@v@w@}@~ADAEAFAIAJAMAOAWAaAgAhArAtB?B@BBBHBIBLBNBO"},
  {0,NULL,"BQBTBVB^BeBiBkBmBqBrBsBxByBzCCCECIC\\CdCjCnCoCrCuD?DBDDDHDODVD[D_D"},
  {0,NULL,"dDhDoE?EAEDEHEJEREXEZE\\E_E`EeEjEqExEyE|E}FGFIFKFOFPFXF[F_FgFkFoFq"},
  {0,NULL,"FwFyF|GDGEGLGOGVGYGiGlGrHDHJHNHRHTHWHYHZH^H_HfHgHiHkHmHrHuHzH}IBI"},
  {0,NULL,"FIIIOIQIRIVI\\I]IeIpIrIuIvIzJ?J@JGJQJVJWJ[J`JgJlJmJoJrJ}K@KAKMKQKR"},
  {0,NULL,"KTKXKYKZK^KbKdKvKxKzK}K~LALDLELILOLYL_LlLpLuL{L}M@MEMNMPMRMSMUM`M"},
  {0,NULL,"fMjMvMzM{N@NCNFNJNLNUNVNWNXN\\N]NcNlNqNvNyN{N}N~O@OAOG_B?I?N?V?Y?Z"},
  {0,NULL,"?\\?_?`?g?k?x?y?~@@@E@F@M@Q@S@V@Z@`@a@e@k@x@y@z@|@~AAAIAJAKANAPAXA"},
  {0,NULL,"]AgAiArAsA|B?BDBGBJBKBPBSBXB[B`BbBcBfBgBjBlBpBqBtBwBzCACHCKCWCaCl"},
  {0,NULL,"CnCpCxCzC|D?DEDJDYD[D]DaDjDoDpD~E@EDEIESETEUEZE[E_EbEhEjElEuExEzE"},
  {0,NULL,"{FJFLFSFVFZF\\F^FbFiFkFpFqFsF{F~G@GHGMGWG]G^GbGdGqG~HOHPHQHWHXHYH]"},
  {0,NULL,"HaHbHcHeHkHnHoHsHxHyH}IAIBIDIHIMIOIPIYI]IkInIsIuIvIyI{J?JIJRJVJXJ"},
  {0,NULL,"[J\\JgJkJrJsJvJyJzKDKEKJKLKOKSKUK[KcKgKnKwK|L@LALCLHLILJLKLRL]LcLf"},
  {0,NULL,"LiLyL{L}MAMBMFMHMNMTMaMbMhMjMtMuMzN?NBNCNENINPNUNXN_N`NaNdNkNpNqN"},
  {0,NULL,"tNwN}O?OBOF_B?I?N?V?Y?Z?\\?_?`?g?n?s?z?{?|@?@A@O@Q@Y@]@`@c@d@e@k@x"},
  {0,NULL,"@y@z@|@~AAAIAJAKANAPAXA]AnAoAqAsA|A}BDBFBGBKBRBSBTBUB_B`BeBjBlBpB"},
  {0,NULL,"rBsBxBzB|B}CACDCHCWCaCiCnCqCsCwCzDADDDLDPDTDZDeDfDgDlD~ECEDENEPER"},
  {0,NULL,"ESETEXE^EbEdErEsEvEwEyF@FGFMFNFPFTFVFZFcFhFlFmFrFuFzG?GAGGGNGRGSG"},
  {0,NULL,"[GfGkGvGyHCHLHSHTHVH[H_HdHfHgHhHmHnHpHtHuHyH|IBIEIKILIMIQIWI^I_Ii"},
  {0,NULL,"IlIrIsIuIxI|J@JKJLJSJYJ_JeJiJkJnJpJsJvJyKDKFKKKLKOKPKQKRK_KgKnKvK"},
  {0,NULL,"xL?L@LCLDLILJLLLRL]L^LgLhLjLsM@MAMFMJMMMQMRMYMZMcMiMuMyMzNCNDNLNN"},
  {0,NULL,"NONPNSNYN^NfNhNmNnNrNsNuNvN{O@OAOCOH_B?I?K?V?Y?]?a?d?e?g?k?p?q?~@"},
  {0,NULL,"@@E@F@R@S@W@Z@^@c@d@e@h@p@r@}A?ABACAFAJAKARATAYA^AeAfApAqAwAxAzA{"},
  {0,NULL,"A~BCBQBTBUBaBbBcBdBhBkBmBrBsBuB{B|B}C@CNCRCYC]ChCnCwC{C|C}D@DBDND"},
  {0,NULL,"SDWDXDmDnDrDtD}E?EBEQERESEWE[E\\E]EbEhEmEpEuExEzE{FHFJFKFMFPFSFWFb"},
  {0,NULL,"FiFmFpFtF{F~G@GCGHGMGWG]G^GbGmGqG~HEHPHQHSHTHYHZH_HaHbHhHjHmHoHqH"},
  {0,NULL,"yHzI@IBICIDIKINISIVI`IaIjImIsIuIvIwIyJ?JCJJJNJTJ^JfJiJjJtJuJxJ{J~"},
  {0,NULL,"KBKEKFKGKMKNKQKSK]K`KrKuKxK}L?LBLDLELGLLLNLVL`LkLqLvLwM@MBMFMIMLM"},
  {0,NULL,"OMSMXM[M\\MlMsM{M|NANCNINMNONTNVN`NaNbNdNjNkNoNvNxNzN{O@OAOD_B?J?L"},
  {0,NULL,"?U?X?[?\\?^?d?h?m?r?x?|?}@D@E@Q@R@Y@]@_@`@b@f@i@u@w@~A?A@ADAFAGAIA"},
  {0,NULL,"OAWAZA_AhAkArAtB?B@BEBHBJBLBOBQBVBaBbBdBeBiBjBmBrBsBuByBzB|CGCHCO"},
  {0,NULL,"CeCgChCnCoCtCuCxD?DADHDJDVD\\D^DfDmDqD}EAECEHEJEOEREUEWEZEaEeEiEpE"},
  {0,NULL,"{E|E}F@FHFLFNFQFWFYF]F`FdFnFpFvFxF{F~GBGFGIGPGTG`GgGmGxG{HCHOHQHR"},
  {0,NULL,"HXH[H\\H_HdHfHgHjHlHpHsHxHyI?ICIDIGIJILINIPI[IdIgIlIqIsItIzI}J@JMJ"},
  {0,NULL,"NJPJXJ_JcJhJiJnJpJqJwJxKBKIKJKLKOKSKVKWK`KfKoKuKwKyK{K|L@LBLJLKLM"},
  {0,NULL,"L]LaLeLjLqLtMBMIMKMMMOMPMRMUMWM`MaMtMwM}NDNHNNNPNTNUNVNYNZN[NfNgN"},
  {0,NULL,"iNsNzN}O?O@OBOCOEOH_B?J?P?V?Y?\\?^?b?e?f?i?w?y?{@@@B@C@P@R@T@U@X@]"},
  {0,NULL,"@c@f@m@n@u@z@{A?A@AFAIAKASAUAZA_AiAjArAuAvAyBABEBJBMBQBUBWBYBZB]B"},
  {0,NULL,"eBfBkBmBoBvBxBzB|B}C?CLCPCVCXCfCpCtCvCwDBDDDEDGDMDUDYD`DiDpDsD|D~"},
  {0,NULL,"EBEMESEUEVEXEYE\\E`EgElEtEuEwE~F?FGFKFMFQFRFUFYFaFjFkFnFsFvFxF}GBG"},
  {0,NULL,"FGJGKG\\G_GaGeGuG}HAHIHSHUHYHZH`HcHfHgHhHsHuHvHwHyHzH{IGIHIKIPIQIT"},
  {0,NULL,"IVI[IfIgInIrIsIvIyI|I~JFJOJPJXJ\\JaJgJhJqJwJzJ|K?KCKFKHKMKRKVKWK\\K"},
  {0,NULL,"iKlKpKvKyK{K|K}L?LELILLLQLSLZLiLmLrLxL~MCMDMFMRMSMTM^M_MeMhMsMuMx"},
  {0,NULL,"N?NENKNLNONQNVNZN[N_NeNgNiNtNvN{N|O?O@OAOEOM_B?I?K?V?Y?]?a?d?e?g?"},
  {0,NULL,"n?t?w?{?|@?@A@M@O@W@Y@\\@^@a@e@h@p@r@}A?ABACAFAJAKARATAYA^AhAjApAr"},
  {0,NULL,"AwAxA~BCBEBLBPBRBXB\\B_BaBdBfBgBhBmBnBqBtBuB{CNCRCUC]C_ChCoCrCtCwC"},
  {0,NULL,"yCzC|DIDMDOD\\DbDdDkDsE?EBEEEJEOERETEVEYE[EbEdEqEtEvEwEyF@FHFNFTFW"},
  {0,NULL,"F\\F]F^FcFhFkFlFrF|F}G?GAGGGNGRGSG[GfGgGvGyH?HLHVHWHXH[H\\HcHdHeHgH"},
  {0,NULL,"lHmHnHoHrHwH{IDIIIJIKIMIRITI[IhIoIpIrIsIuI|J@JBJEJHJOJWJ`JaJgJjJt"},
  {0,NULL,"JuJ{J~K?KAKGKIKKKNKPKUK[K`KkKrKuKwK|K}LALBLFLGLKLNLTLVLoLuLxL|L~M"},
  {0,NULL,"@MAMBMDMGMPMVMWMeMfMsMwM{N@NFNINKNONPNRNYN]N^NeNfNmNpNwNyN|N~OBOE"},
  {0,NULL,"OFOH_B?H?K?U?X?[?]?a?b?g?j?v?w?|@?@@@F@M@O@T@X@Y@a@b@g@h@o@qA@ABA"},
  {0,NULL,"CAEAGAHAIALAVA\\AbAdAfAsAuAyA|BDBGBKBMBNBTBUBVB^BbBcBgBiBkBnBoBqBr"},
  {0,NULL,"BsBuC?CSCTC`CjCmCpCsCuCvDADCDEDLDTDYD]DeDjDlDoD}E?EEEHEIEKELEUEXE"},
  {0,NULL,"^EbEfEkEqEvEwExE{FIFNFOFTFYF\\F^FbFcFkFlFqFsF|F}G?GGGMGSG[G]GcGiGt"},
  {0,NULL,"GzH@HAHRHUHVHWH[H\\H]HcHdHjHlHmHvHwH{H}IFIIIJIKIPIRISIZI`IaIcIqIsI"},
  {0,NULL,"uI}JAJBJEJFJHJQJ^JdJkJlJsJvJyJ}K@KDKEKFKHKQKSKVK\\K^KmKsKuKwKyK|K~"},
  {0,NULL,"L?LELFLLLPLSLULgLhLyL{L}MCMEMJMKMMMNMZMbMcMhMsMwM|NBNGNHNLNQNSNUN"},
  {0,NULL,"aNbNhNjNkNnNrNsNtNzN}OAOEOFOGOJOK_B?J?O?U?X?_?b?c?e?h?m?s?v?|?}@D"},
  {0,NULL,"@E@P@Q@U@V@Z@\\@`@f@l@n@v@z@{@}AEAFAHAIAMASAUAaAfAmAqAuAzA{A}BABFB"},
  {0,NULL,"MBZB[B\\B]B_BaBdBfBgBhBlBoBpBtBvB{CACBCQCZC]C^CsCzC}C~D?DADBDKDNDR"},
  {0,NULL,"DTD_DbDhDjE@EEEGEJELENEQEWEXE[EaEeEnEqE{E|E}F@FGFHFKFSFWFXF[F`FdF"},
  {0,NULL,"lFnFvFxGAGBGFGGGIGPGTG`GgGjGmHBHCHOHQHXHYHZH[H]H^H_HbHnHpHqHtHvHx"},
  {0,NULL,"H{IAIJIKINITIWIXIZIfImInIqIsItIzI}J?JFJOJUJYJ[JdJgJlJoJrJzJ}K?KAK"},
  {0,NULL,"LKMKOKPKRKXKZKaKqKrKxKzK}K~L?LCLDLGLILRL[L\\LlLoLpLyL}M@MEMGMOMPMT"},
  {0,NULL,"MXMcMdMkMvMyM|NBNCNDNFNJNKNUNZN[N`NgNiNkNoNpNqNrNtNuNvN|ON_B?H?K?"},
  {0,NULL,"U?X?[?]?a?b?g?l?p?r?{?~@A@E@P@S@T@X@Z@c@d@g@h@o@qA@ABACAEAGAHAIAL"},
  {0,NULL,"AVA\\AbAhAlAsAtA|BBBDBGBHBKBNBPBRBXBZB^B_BfBiBkBnBoBtB{B|B}B~C?CSC"},
  {0,NULL,"bCjCmCqCvCxC~D?DCDDDJDPDZD[DaDfDgDpD}EBEEEHELEMENEPEZE_EbEcEoEpEu"},
  {0,NULL,"EyEzF@FIFJFMFOFPFSF[FhFiFmFpFtFuFzF~GCGHGNGRGWG^GhGrGsHIHKHMHQHTH"},
  {0,NULL,"YHZH^H`HaHfHhHjHoHqHzH{H|I?IDINIRISIUIVIWIeIgIhIoIsItIuIwIzI~JDJJ"},
  {0,NULL,"JMJTJaJcJhJkJsJvJwJyKCKDKHKKKPKUKXK[K\\K^KjKsKxKyK~LALDLELFLGLKLPL"},
  {0,NULL,"SLWLfLiLjLsM?MEMHMKMQMRMTMYMaMiMjMwM{M|N?NDNENGNJNNNQNXN]N^N_NeNf"},
  {0,NULL,"NoNqNuNwN{N|O?OCOJOK_B?H?N?U?X?Z?^?`?c?g?l?s?u?{?~@A@E@N@O@Y@[@_@"},
  {0,NULL,"c@d@g@k@s@t@{@|AAADAFAGAHAQA[A`AcAiAmApAuAvAwAxA~BABCBOBPBWBXBYBb"},
  {0,NULL,"BcBgBjBqBrBsBvBwBxByCFCICMCVCcCkCtCuCyC~D@DBDCDIDMDNDWDbDdDnDrE@E"},
  {0,NULL,"CEDEHEKEMEQEVEWEYEbEcEnErEuEyEzF@FMFNFPFQFRFTFUFhFiFlFmFrFtFuFzGA"},
  {0,NULL,"GCGNGRGWG^GaGhGsHJHKHMHRHTHUHVHZH[HfHgHhHjHnHpHuH|H}H~ILIMIPIQISI"},
  {0,NULL,"WIXIYI\\IfIkIsItIuIxIzI~JKJSJUJZJ[JbJjJlJmJoJtJuJ{J~KEKSKTKUKWKYK["},
  {0,NULL,"KeKiKtKvKwKzK{K|L?LHLJLLLXL_LdLkLoLuLvM?MCMGMKMLMPMSMVMXMeMlMtMuM"},
  {0,NULL,"yN@NFNHNJNMNQNTNXN]N_N`NdNeNpNsNvNzN}N~ODOEOLOO_B?H?M?T?W?Z?[?]?c"},
  {0,NULL,"?f?j?v?z@?@@@B@D@O@T@V@W@X@Y@\\@g@j@o@t@|ACADAEAGAHAKA[A\\A`AbAdAgA"},
  {0,NULL,"sAuAvAyA|BABKBMBNBQB^BaBbBcBeBgBhBiBjBkBmBnBrBuCBCDCUCYCeClCsCvCy"},
  {0,NULL,"CzC{DADEDGDLDRDYD`DqDsDtE?EAEFEIELEOEQESEUE^E`EfEiEmEwExE}E~FJFLF"},
  {0,NULL,"RFSFUFVF]FgFjFmFnFtFuFvFxFzGCGJGVGYG_GbGnGxHBHHHLHUHVHXH`HaHbHcHd"},
  {0,NULL,"HeHnHpHrHtHzI?I@ICIDIEINIOIQIXIYI\\IeIoIrItIvI{JAJBJMJSJTJUJ]J`JhJ"},
  {0,NULL,"jJqJtJuJwJ|KCKKKMKOKPKRKTKYK]KcKoKvKzL@LCLDLGLHLILKLTL[L^LeLmLwLx"},
  {0,NULL,"L~MBMCMHMIMJMOMZM_MdMhMvMzM~NANBNHNKNNNONRNXN\\N]N_NcNeNpNsNtNxN{N"},
  {0,NULL,"|N~OCONOROS_B?H?P?T?W?^?`?a?b?f?j?o?q@?@@@B@D@N@Q@S@V@Z@[@\\@g@m@q"},
  {0,NULL,"@s@{A@AAABAGAHAJALAQAVAcAjAkApAtAwB@BBBCBHBIBQBRBSBWBYB_BeBlBpBtB"},
  {0,NULL,"vBwBxBzB{B|C@CKCQC_CgCiCrCsCuCxC{C|C}DHDODQDXD_DeDoDuD|D~EGEIEJEK"},
  {0,NULL,"EOEPERE]E`EfEkEsEwExE}E~FIFLFNFOFTFWF]FgFjFmFoFtFuFzGCGDGEGJGVGYG"},
  {0,NULL,"_GnGvGxHBHHHPHQHRHWHXH[H^HbHdHeHoHqHsHtHuH~I@ICIEILIMITIUIVIfIgIh"},
  {0,NULL,"IkIrItIvI{I}JBJDJJJKJZJ\\JdJkJlJmJoJvJyJ}K@KEKHKMKNKRKSK\\K_KfKkKuK"},
  {0,NULL,"wKyK}L?LBLELFLJL\\L`LcLgLlLnL{MAMEMGMIMJMMMNM\\M]M`MfMsMxM}NBNCNGNM"},
  {0,NULL,"NRNSNUNXN[N]N_NeNgNoNrNvNwNyN}O?ODOIOROS_B?J?L?U?X?[?\\?^?d?h?i?u?"},
  {0,NULL,"w@A@B@C@F@P@R@S@U@W@]@^@f@i@u@w@~A?A@ADAFAGAIAOAWAZA_AdAiArAuAvAy"},
  {0,NULL,"B?BEBJBLBQBRBSBZB]B`BeBlBmBoBrBvBzB{B|B}CGCOCRCWCeCgCpCtCvCwCyC}D"},
  {0,NULL,"?DGDIDUD]DcDlDnDuD|D}ECEIEJEMENESEUEYEaEgEkErEvEzE~F?FJFLFVFXFZF["},
  {0,NULL,"F]FeFfFlFoFrFwFyG?GDGEGQGUGXGZGdGkGnH?HEHFHSHVHYHZH]H`HaHbHeHlHmH"},
  {0,NULL,"qHrHxH|H~IAIEIFILIMINIRI\\I]IcIjIqItIuIyI~JAJLJQJWJZJ^JbJiJlJmJnJp"},
  {0,NULL,"JxK@KBKGKIKJKKKNKXKZKfKnKoKwKzK~L@LALBLCLGLKLMLVLaLhLkLnLzM?MAMJM"},
  {0,NULL,"MMOMSMTMVM^M_MbMtMwM~NDNGNINKNLNMNTNWN\\NaNcNdNlNoNqNuN|N~OAODOFOH"},
  {0,NULL,"OI_B?J?M?V?Y?[?_?c?d?f?i?p?z?{@@@B@C@M@T@V@X@\\@_@b@f@j@v@w@}@~ADA"},
  {0,NULL,"EAFAIAJAMAOAWAaAeAnAqAtA{A}B@BBBHBIBOBPBVBWBYB[B\\BgBhBiBnBpBqBsBw"},
  {0,NULL,"ByCCCECSC\\CdCkCoCpCqC|C}DCDDDFDQDXDZDcDeDrDuE?EDEFEKENETEYEZE\\E]E"},
  {0,NULL,"`EgEmErEuEwE~F?FLFRFUFXF[F]F^FaFjFmFnFtFvFxFzGBGFGJGKG\\G_GaGoGuHA"},
  {0,NULL,"HGHIHUH\\H]H`HbHcHdHeHhHjHkHnHtHwHzI?ICIDIHIIIQIWIXIZIdIlImIrIsIvI"},
  {0,NULL,"yI|JAJMJNJUJYJ^JeJiJlJmJnJoJ}K@KBKHKIKJKUKXKZK\\KbKdKeKxKzK~L@LALB"},
  {0,NULL,"LFLHLKLOLPLYLgLnLvLzL}M?MAMDMLMMMSM\\M]MgMiMzM{M~NENFNGNINLNSNTNZN"},
  {0,NULL,"[NgNhNiNjNoNpNrNwNzOBOCOFOGOMOQOU_B?J?O?U?X?_?b?c?e?h?i?o?p@A@B@C"},
  {0,NULL,"@F@O@V@W@\\@^@_@b@f@l@n@v@z@{@}AEAFAHAIAMASAUAaAlAnAqAtAzA{A}BBBFB"},
  {0,NULL,"IBOBSBVB[B\\B`BcBgBhBiBjBpBqBtBuByCBCNCQCZC^CaCtC{C|C}DADCDDDFDPDQ"},
  {0,NULL,"DSD`DaDiDkE@EEEFEKENEPETEUEWE\\EaEgElEoEvEzE~F?FGFKFQFTFVFYFZFeFfF"},
  {0,NULL,"oFpFwFyG@GDGEGHGQGUGXGZGdGkGpH?HEHHHSHUHVH\\HaHdHeHfHgHiHlHoHpHqH}"},
  {0,NULL,"I@IAIBIJILIOISIUIbIeIiIpIqItIuI|I~JAJCJDJGJVJ]JaJgJhJrJzJ|K?KAKCK"},
  {0,NULL,"EKGKMKNKRKVKWKaKgKqKuKyK{K}L?LDLILJLLLNL[L\\LfLmLrL|MCMDMFMHMMMPMT"},
  {0,NULL,"MYM[M]MgMxMyM|NENKNONQNRNTNUNWN\\N^NcNlNmNsNwNxNyNzN{N}OEOI_B?H?M?"},
  {0,NULL,"T?W?Z?[?]?c?f?l?t?u?{?}?~@C@N@O@R@Y@[@]@`@g@j@o@t@|ACADAEAGAHAKA["},
  {0,NULL,"A\\A`AbAeAmApAuAvAxAyA~BABMBWBYB[B\\B`BbBcBgBjBpBrBuBwBxByBzCDCGCUC"},
  {0,NULL,"YCZClCsCtCwCxCyC~D@DKDMDUDWD^DgDiDpEAEDEFEIEMEPEQEVEWE[E`EcEjEoEu"},
  {0,NULL,"EyE|F?FGFHFIFJFKFOFSF_FaFkFoFqFsFwFyF|F}GKGLGOG\\GjGpGqGyG{HFHQHRH"},
  {0,NULL,"SHTHYH[H^H_HgHiHkHlHmHrHsHtIAIBICIFIIIOITIZI_I`IdIqIrIvIwIxIzJEJG"},
  {0,NULL,"JIJQJcJeJhJkJqJsJwJ|KCKDKGKHKIKJKKKPK\\K]KcKqK}K~LBLCLDLELFLGLKLTL"},
  {0,NULL,"^LaLiLrLsLtMFMGMHMIMKMQMTM^MeMkMlMvM{M~N?NDNMNNNPNQNRNZNbNhNiNjNn"},
  {0,NULL,"NrNuNyO?OAOBODOEONOP_B?I?O?T?W?Z?_?a?e?h?n?o?t?|@A@C@D@M@W@X@^@_@"},
  {0,NULL,"a@b@e@l@r@x@z@}AAACAGAJAKAPARATAXAjAmApArAwAxB?BEBJBLBNBPBXBZB]Ba"},
  {0,NULL,"BdBfBhBiBnBoBqBuBwB{CECJCTCXCbCcCoCqCrCuCwCyDEDHDIDUD\\D^DfDlDuEEE"},
  {0,NULL,"FEGEMEOEREVEYE^E_EaEdEoEsEvE|E~F@FMFPFQFUFVFYFZF`FeFoFpFwF{F~G@GE"},
  {0,NULL,"GHGPGUGXG`GeGsGwGzHDHGHRHSHUHVH\\HcHeHfHhHiHkHqHvH}I?I@IAIGIOISIUI"},
  {0,NULL,"VIXI`IkImInIqItIvIxI|JBJCJIJJJVJdJeJiJkJnJpJvJxKBKDKFKLKOKQKTKXKZ"},
  {0,NULL,"KjKpKtKvKxKzK{LCLELILJLLLULYLbLhLjLnLtL~MAMJMKMLMQMRMVMWM^M`MvMxM"},
  {0,NULL,"yN@NANGNLNNNPNSNZN[N`NaNdNkNoNtNxN}N~OAOBOCOJOLOMOV_B?I?L?T?W?\\?]"},
  {0,NULL,"?`?d?h?k?q?u?}@B@E@F@P@T@U@W@^@c@d@e@i@p@y@|@~A?ABAHAJAKANAYA]A^A"},
  {0,NULL,"eAkApAqAzA{A}A~BCBFBOBTBUBVB^BaBdBiBkBmBoBsBuBxB{B}B~CMCPC[C`CdCq"},
  {0,NULL,"C{C|C~D@DBDEDKDNDQDSD_DaDiDjD|D}EAEKEQE[E\\E]E^E_EaEhEjEkEzE{E}F?F"},
  {0,NULL,"RFVFXFZF[F\\F^FdFfFlFoFrFyG?GAGDGGGIGQGTGZGlGoGtG|G}HKHSHZH]H^H`Ha"},
  {0,NULL,"HcHeHhHlHrHuHvH|H~I?IEIFIGIIILIRIXI[I_IhIlIqIrItIwIyI{JEJKJLJWJ\\J"},
  {0,NULL,"cJgJkJrJsJyJzK?KAKLKOKUKVKWKYK[KdKhKmKzK{K|L@LALCLFLHLJLWLXLZLfLl"},
  {0,NULL,"LrLyL}L~MEMFMHMLMNMXM[M]MkMtM}M~N?N@NANBNCNENQNYN^NfNgNiNmNtNuNvN"},
  {0,NULL,"wNxN~OCOEOKOOOQOX_B?I?L?T?W?\\?]?`?d?h?n?r?z?|@A@C@D@N@Q@_@`@b@c@d"},
  {0,NULL,"@e@i@p@y@|@~A?ABAHAJAKANAYA]A^AdAoAqAsAzA{A|A}BDBFBSBTBUBWBZB]B`B"},
  {0,NULL,"jBkBlBsBvBxByBzB}B~CCCMC[C`CfCqCrCsCzD@DCDDDFDPDRDTD`DbDhDkD|EAEC"},
  {0,NULL,"ELEPETEVEXE]E^EaEdEiEtEvE|E~F@FHFOFQFWFYF\\F^F`FeFnFpFxF{F~G@GBGHG"},
  {0,NULL,"PGUGXG`GcGeGwHDHGHMHRHTHUHWHXH[H\\H_HfHiHjHsHxHzH~I?ICIFIGIHINIPIU"},
  {0,NULL,"IYI]IaIjIqItIvIxJ@JBJNJRJTJXJ`JbJgJjJrJtJzJ~K?KAKGKHKNKUKXKZK[KhK"},
  {0,NULL,"lKmKuKyK|K~LALBLFLGLHLOLWLXLmLoLpL|L~M@MCMDMGMNMQMYMcMdMgMwM}M~N?"},
  {0,NULL,"N@NFNJNONRNSNWN`NaNcNdNkNpNqNrNyNzN{O?ODOJOLOQOX_B?H?N?U?X?Z?^?`?"},
  {0,NULL,"c?g?j?o?x?|@?@@@F@M@N@S@U@Z@[@a@g@k@s@t@{@|AAADAFAGAHAQA[A`AcAkAn"},
  {0,NULL,"ApAtAwAxA~B@BCBIBRBTBUBWBYB]B_BfBlBtBvBwBxByB|B}CFCICJCVC[CkCoCrC"},
  {0,NULL,"uCvC{C}C~DODSDXD\\DkDmDsDtD~E@ECEJEKELEMEOE\\E]EbEfEiElEvEwExE{FJFR"},
  {0,NULL,"FSFUFXF\\F^FbFcFkFpFqFsF{F|F}G@GMGSG[G]GcGtGuGzH@HNHQHWH\\H]H^H`HaH"},
  {0,NULL,"bHcHiHkHxHyH{H|H}IAIBIGIHIPIRIWI^I_IbIdIqIsIuI{I}JAJGJIJPJRJ]J_Jh"},
  {0,NULL,"JjJqJtJuJ{J|J~KFKKKPKQKTKYKZKeKhKiKvKxKzK{LALCLDLHLKL_LbLdLqLwLxL"},
  {0,NULL,"|L~M?MCMDMEMIMOMWM[M\\MfMtMyMzNANGNHNJNKNRNVNYNbNhNjNmNnNoNqNuNxNy"},
  {0,NULL,"N|O@OBOGOLOOOY_B?J?P?V?Y?\\?^?b?e?f?m?q?s?}?~@?@D@N@P@U@V@[@\\@a@f@"},
  {0,NULL,"m@n@u@z@{A?A@AFAIAKASAUAZA_AfAoAqAuAvAyAzBABFBMBNBXBZB[B\\B]B^BfBh"},
  {0,NULL,"BnBoBpBtBvBwB}CFCLCPCXCfCmCoCpCzC~D@DADBDKDLDRDWD^DgDqDtD~EBEGELE"},
  {0,NULL,"WEXEYEZE[E^E`EeEpEsExEyE|E}FIFLFOFQFYF\\F]F_FgFmFoFuFwFyGCGDGEGLGO"},
  {0,NULL,"GVGYGiGrGwG|HJHNHRHTHWHXH\\H]H^HbHdHkHoHuHwH|H~I@IEIHIIIMISIUIVIbI"},
  {0,NULL,"cIiIjIrIuIvI}J?J@JCJDJLJZJ_JfJhJiJpJqJwJxJ|KCKIKJKTKVKWKYK[KlKpKs"},
  {0,NULL,"KwKyK{K|L@LBLFLHLLLQLZLdLeLsLtLwL}MBMDMKMOMQMRMZMdMkMlMsMuM}NANDN"},
  {0,NULL,"ENFNHNPNVNWN\\NbNcNlNnNpNsNuNwNxOBODOFOTOVOXOY_B?I?O?T?W?Z?_?a?e?f"},
  {0,NULL,"?l?t?y?{?}?~@C@I@K@L@S@U@Y@b@g@m@r@s@{A@AAABALAOAPAUAWA^A`AlAoAqA"},
  {0,NULL,"sA~BBBDBFBIBMBNBRB[B\\B^B_BdBrB{B|CACECFCGCHCKCOCPCUC[C\\C`CnCpC{DC"},
  {0,NULL,"DFDSDVDWDYDZD]D`DbDhDkD|EAECEHENEOESEUEWEYEaEdEoEsEvE|E~F@FMFPFQF"},
  {0,NULL,"UFVFYFZF`FaFmFoFrFuFvF~GEGHGIGJGLGMGNGXG]GnGqGxGzG}G~H@HCHDHJHLHN"},
  {0,NULL,"HUH\\H]HkHmHqI?IAIGIIIKIRISIWIfIgIhIkI{I}JBJCJIJJJMJQJWJYJbJdJhJkJ"},
  {0,NULL,"pJtJxJzKCKDKJKMKQKUK]KcKfKvKxLALMLNLOLPLSLULXLYL[LjLnLtLwLyL{L|L}"},
  {0,NULL,"MAMDMEMLMPMRM^MeMkMlMmMpMqMvM{M~NANGNPNUN]N^NgNhNlNnNrNsNuNwNyN{O"},
  {0,NULL,"?ODOHOKOROUOXOYO\\O^_B?H?M?T?W?Z?[?]?c?h?k?u?v?}@B@E@F@H@I@K@\\@]@a"},
  {0,NULL,"@c@e@l@r@t@z@}AAACAMAQAXAYAZA\\A_AgAlAsAtA}B?BBBCBGBLBOBPBSBVBXBYB"},
  {0,NULL,"`BfBwB}C?CGCLCMCNCPCQCSCTC_CeCiCnCrCvDADGDJDLDODSDTDVDcDdDhDrD|EB"},
  {0,NULL,"EGELESEVEWEXEZE\\E`EcEjEoEuEyE|F?FGFHFIFJFKFOFSFaFdFoFpFqFsFwFxGCG"},
  {0,NULL,"HGOGSGWGZG[G_G`GeGtGwGyH?H@HBHEHFHIHLHMH_HdHgHkHlHsH|IBIDIIILIMIT"},
  {0,NULL,"IWI`IkImInIxI|JBJEJGJIJLJMJXJZJeJfJgJkJrJsJ|J}J~KCKKKSKVKZKhKmKpK"},
  {0,NULL,"wLGLKLMLOLQLRL]L^L_L`LaLgLhLiLrLtLuL|MAMIMKMMMPMSMTMXM[M]MkMnMpMq"},
  {0,NULL,"MtM}M~NLNPNQNRNXN[N\\N^NdNfNqNtNwNxN{N}N~OCOGOIOJOROTOXOZO[_B?J?L?"},
  {0,NULL,"U?X?[?\\?^?d?g?j?w?x?|@?@@@F@G@I@J@X@[@^@`@g@k@t@u@{@|AAADAOAQARAT"},
  {0,NULL,"AUA\\A]AkAnAqAtA}A~BCBDBIBMBRBTBUBWBYB]B_BnBvBwC?CACCCDCECICJCRCTC"},
  {0,NULL,"ZC^ChCnCoC{C~DKDLDSDVDXD[D\\D`DaDiDkE@EEEFEMEOESEZE]E^E_EaEgEkErEv"},
  {0,NULL,"EzE~F?FJFLFVFXFZF[F]FbFeFlFmFrFvFzF~GDGEGJGLGOGZG[G^G`GhGiGsGyG{H"},
  {0,NULL,"?HFHGHIHLHNHOHSH_HaHmHqHwH~IAICIEIFIHIKITIYI\\IfIkIxIzI~JHJJJLJNJO"},
  {0,NULL,"JQJZJ]JbJkJlJnJpJrJyK@KCKIKMKQK[K^KsKtK}LBLKLMLNLVLWLZL[L`LbLcLhL"},
  {0,NULL,"kLnLpLrLsLuL~M@MAMFMGMOMSMZMbMcMhMmMoMqMsMwM|N@NDNLNMNYN`NeNgNhNj"},
  {0,NULL,"NrNsNvNwNzN}OCOEOKOMOPOSOUOWOXO[O__B?J?P?V?Y?\\?^?b?e?g?n?s?w?{?|@"},
  {0,NULL,"?@A@G@J@K@T@W@[@`@e@k@u@x@z@|@~AAAQASATAWA\\A]AbAnAoAqAtA}BCBDBGBI"},
  {0,NULL,"BLBRBSBTBUB_B`BeBjBuBzC?CACBCDCICJCQCRCUC\\CdCmCnCqC~DADKDLDNDPDVD"},
  {0,NULL,"ZD\\DcDeDrDuE?EDEFEMEOEPEQESEWE^E`EgElEtEuEwE~F?FGFKFMFQFRFUFYFhFj"},
  {0,NULL,"FkFpFsFwFxG@GBGCGIGKGSGTGUGVGWGbGgGqGzG|G}H@HAHCHEHHHJH^H`HhHlHsH"},
  {0,NULL,"zH{IFIGILIQIRITIUIYI]IkInIyI{J?JDJEJOJPJQJTJXJ\\JeJgJjJoJqJ|J~K?KB"},
  {0,NULL,"KPKSKVKXK`KcKrKyK~LLLMLPLSLWLXLYLZL^L`LiLlLmLqLxLyLzM?MCMEMJMNMRM"},
  {0,NULL,"TMVMWMeMfMnMpMrMsMwM{N?NBNKNVNWNXN^NaNmNnNpNqNwNxNyNzOBOFOGOJOOOW"},
  {0,NULL,"OXO\\O]O^O`_B?J?P?V?Y?\\?^?b?e?g?n?s?w?{?|@?@A@G@J@K@T@W@[@`@e@h@n@"},
  {0,NULL,"p@}A?ABACAMATAVAZA[A]A`AhAjArAtAwA}BCBGBHBLBPBRBXB\\B_BaBdBhBjBuB~"},
  {0,NULL,"CACDCFCGCOCRCSCUCVC\\CdCrCtCvC|DGDMDODPDQD\\D]D_DdDhDoE?EAEDEIELEOE"},
  {0,NULL,"PEUEVE[E`EeEpEsExEyE|E}FIFLFOFQFYF\\F]F_FcFmFpFsFwFxF~GCGEGKGMGQGR"},
  {0,NULL,"GVGZG`GbGkGqG{G|G}H?HAHJHKHMHOHWH^H`HkHpH|I@IEIGIIIJIUIWIXI`IaIjI"},
  {0,NULL,"mIwIyJ?JCJDJIJLJPJSJUJ`JfJiJkJpJrJvJwK@KCKEKKKWKZK]KgKnKzK{K|LOLQ"},
  {0,NULL,"LTLUL\\L_LbLcLdLfLkLlLsLtLwLzM?MDMEMGMKMLMOMYMZMcMiMnMoMpMuMyMzNAN"},
  {0,NULL,"DNENMNYN[N`NeNfNjNoNvN{N}O?O@OAOCOIOKOLOMONOROUOZO`Oa_B?I?K?V?Y?]"},
  {0,NULL,"?a?d?e?f?m?q?t?}?~@?@D@G@K@L@O@S@U@_@f@j@p@v@}@~ADAEANAOAQARAUAbA"},
  {0,NULL,"cAgAhArAsAyB?BBBFBHBKBNBOBQBTBVB^BeBsBvByC@CBCDCECFCICJCPCTCWC_Ca"},
  {0,NULL,"CrCyD?DDDIDODPDRDUDVD[DaDjDoDpD~E@EDEHEJELEMEQEVE\\EbEhEmEpEuExEzE"},
  {0,NULL,"{FHFJFKFMFPFSFWF_FbFmFnFtFvF{F}F~GAGIGUGXGYG[G\\G^GaGuGwGyG}H?H@HB"},
  {0,NULL,"HDHEHHHPHVHYHaHjHyH~I@IBIEIFIJILINISIZIdIlImIyI|JAJCJHJKJNJPJTJZJ"},
  {0,NULL,"[J^JhJiJtJuJwJxJzKDKHKLKNKTKeKlKpKuK}LJLMLRLSLVLWL_L`LaLcLfLhLmLn"},
  {0,NULL,"LqLvLwM@MEMHMIMJMLMMMZMdMkMlMoMpMrMsMuM}NANGNONTN\\N]NfNgNhNlNpNsN"},
  {0,NULL,"wN|O?OBOCOFOHOJOMOOOROTOWO^O__B?H?P?T?W?^?`?a?b?h?n?o?r?|@A@C@D@H"},
  {0,NULL,"@I@L@M@R@V@d@e@i@p@s@|@~A?ABAMANARAVAZA[AaAdAoAsAuAxAyAzA|BFBJBSB"},
  {0,NULL,"TBUBWBZB]B`BqBsBxB~C?CCCECGCJCQCRCSCYC^ClCzD?D@DCDFDIDJDRDTDWD[D`"},
  {0,NULL,"DqDsDtE?EAEFEHEJETEXEYEZE]E`EfEkEsEwExE}E~FIFLFNFOFTFWF]F`FjFlFoF"},
  {0,NULL,"uFzF|G?GDGFGSGTGUGWGYG\\G^GlGoGsG{G~H?H@HAHEHHHMHPHXHYHbHqHtHuH}IA"},
  {0,NULL,"IBICIKIMIPIVI[I_IhIlIwIyI{JFJGJJJKJVJYJZJ\\J`JiJkJmJpJuJvJwK@KEKPK"},
  {0,NULL,"WKXKdKjKtKuL?LDLOLQLRLTL[L\\L]LcLdLfLgLiLkLlLnLwMDMEMFMGMMMOMTMVMW"},
  {0,NULL,"M^M`MmMnMpMvMxMyNCNENGNMNWNaNiNkNmNnNsNtNuNxN~OAOCOFOGOKOPOTOVOZO"},
  {0,NULL,"[O^_B?H?K?U?X?[?]?a?b?h?m?r?v?|?}@D@E@H@I@J@M@V@]@c@f@l@q@v@z@{@}"},
  {0,NULL,"AEANARASAWA]AbAcAfAmApAuAxAzA{B@BABEBZB[B\\B]B_BaBdBpBtBzB~CACBCDC"},
  {0,NULL,"ECHCJCOCUCVC`CkCsC}DBDEDGDHDKDNDTDXDYDbDdDnDrE@ECEDEIENERESEXE[E_"},
  {0,NULL,"EbEcEoEpEuEyEzF@FIFJFMFOFPFSF[FdFhFoFpFqFuFwG?GCGHGJGOGPGQGSGWG_G"},
  {0,NULL,"dGkGxGyH@HAHBHDHFHGHIHMHZHcHhHoHsH|I?IDIGIHIIITIVIWIbIeIiIpI|I~JA"},
  {0,NULL,"JDJEJJJLJMJRJXJ[JaJhJiJmJuJvJwJxKDKHKNKOKYKfKgKoK~LFLHLQLRLSLVLWL"},
  {0,NULL,"XLZL_L`LfLjLmLnLsLvLxL~M@MDMEMHMLMQMUMWM`MaMmMoMrMtMwM}NENGNNNONW"},
  {0,NULL,"NZNbNiNkNmNsNxNzN}OAOBODOEOLOMOPOSOXOYOZO^Oe_B?J?O?U?X?_?b?c?e?g?"},
  {0,NULL,"l?p?s?{?~@A@E@G@H@J@N@Q@T@W@g@k@s@v@{@|AAADAOAPAUAVAYA[A^AiAmArAu"},
  {0,NULL,"AvAwAxBHBJBKBOBPBWBXBYBbBcBkBxByB~CFCHCKCLCMCNCPCSC]CeCgCuCyCzDBD"},
  {0,NULL,"HDIDLDMDNDRD[DcDlDnDuD|D}ECEKEQETEVEXE^E_EaEgElEoEvEzE~F?FGFKFQFT"},
  {0,NULL,"FVFYFZFfFhFkFpFsFwFyG@GBGGGKGTGUGVGYG[G^GcGrGtG}G~HAHBHCHEHHHJHPH"},
  {0,NULL,"VHXHeHiHlHoHzICIDILIOIQITIUI^I_IbIdI{I}JAJDJEJGJNJOJTJVJ]JbJhJkJp"},
  {0,NULL,"JrJzK@KCKDKIKMKQK[K^KhKsK}L?LBLMLNLTLULVLXLYL[L^LeLfLnLrLwL{L|MAM"},
  {0,NULL,"BMDMFMIMLMPMYMaMiMjMmMoMqMwM{M|NANENRNUNYNZN_N`NeNjNoNqNtNuN|O?OA"},
  {0,NULL,"OBOJONOQOROVOYOZO]Oc_B?J?M?V?Y?[?_?c?d?g?k?p?x?~@@@E@F@G@J@L@N@Q@"},
  {0,NULL,"X@^@e@k@v@y@z@|@~AAALAPASAVAWA[A^AgAiArAuAvAxAzA|BJBKBPBSBXB[B`Bb"},
  {0,NULL,"BcBlBpB{C@CFCGCHCKCMCNCOCSCXCfCjCuCzD?DEDHDNDRDYD[D\\D]D`DiDpDsD|D"},
  {0,NULL,"~EBEIEJEKEOEQETE_E`EgEmErEuEwE~F?FLFRFUFXF[F]F^FaFbFlFmFrFvFzF|GD"},
  {0,NULL,"GFGJGLGPGSGWGZG`GfGmGvH?HDHFHGHIHKHMHNHOHRHUHcHjHqHtHwIAICIFIHISI"},
  {0,NULL,"UIXI^I_IiIlIxI|J@JDJHJJJNJQJUJYJ\\JeJiJjJmJoJqJuK?KBKPKSKVKXK_K`Kr"},
  {0,NULL,"KyK~LALPLSLTLULYLZL[LbLcLgLjLmLoLtLvLzL}M?MCMHMKMMMQMXM[M\\MlMnMpM"},
  {0,NULL,"rMsM{M|NFNNNSNTNXN\\N^NaNdNnNsNvN{N|N~O@OAODOHOIOKOLONOSOTOVOe_B?H"},
  {0,NULL,"?K?U?X?[?]?a?b?h?m?r?v?|?}@D@E@H@I@J@M@V@]@c@f@i@o@u@~A?A@ADALAPA"},
  {0,NULL,"SAWAXAYA`AhAkApAtA{B@BABCBEBLBOBQBVBaBbBdBeBpBrBzC@CACBCHCKCMCOCP"},
  {0,NULL,"CTCVCbCkCoCqCtCxDFDHDJDKDMDZD\\DkDmDsDtD~E@ECEPERETEUEZE[E^EbEfEkE"},
  {0,NULL,"qEvEwExE{FIFNFOFTFYF\\F^F`FbFlFoFqFuF|G?GDGHGIGKGSGWGXGYG\\GdGjGkG{"},
  {0,NULL,"G|G}H@HAHHHIHMHPH\\HcHhHmHtHvH}ICIIIKIPIQIVIXI\\I]IcIjIyI~JAJEJFJJJ"},
  {0,NULL,"QJSJVJYJ^J_JgJlJsJyJ|J}J~KAKGKLKTK\\KaKnKqKvKyLELNLOLPLTLULYL]LbLd"},
  {0,NULL,"LhLrLvLxLyLzL{L~MBMJMKMLMNMSMXMcMdMkMoMqMrMvMyM|NBNINLNQN[N\\N]NdN"},
  {0,NULL,"fNgNoNqNuNvNwNyN|N~OIOOOQOROUOVO[O]O`_B?H?N?U?X?Z?^?`?c?h?i?o?u@A"},
  {0,NULL,"@B@C@F@G@H@I@R@\\@a@d@f@i@s@w@~A?A@ADALAMANARATAZA`AdAiAsAuAyA|B?B"},
  {0,NULL,"BBFBJBQBRBSBZB]B`BeBhBmB|B~CCCDCGCJCNCQCRCUCcCjCmCpCyD?D@DFDGDIDK"},
  {0,NULL,"DWD[D]DeDjDlDoD}E?EEEJEQESETEYE[E]EbEfEiElEvEwExE{FJFRFSFUFXF\\F^F"},
  {0,NULL,"cFfFnFpFsFtFxF{F}GAGIGLGMGOGRGXG_GgGmGpGzHBHDHFHGHJHKHLHNHTHWH]Hi"},
  {0,NULL,"HyH{I@IBIEIHIQIRIUIVI[IdIgIlIzI}J@JCJGJJJOJPJRJSJ^J_JgJhJsJtJzJ|J"},
  {0,NULL,"}J~KGKLKTK\\K`KaKqKvKzLELPLQLRLULVLZLbLcLdLpLqLsLtLxL{L|L~M?MAMIMN"},
  {0,NULL,"MQMRMYM[M]MgMoMqMrMxMyM|NJNPNRNVN[N\\N_NcNdNfNpNsNtNzN{N}O?OEOJOMO"},
  {0,NULL,"NOPOSOTOXO\\O`Od_B?I?N?V?Y?Z?\\?_?`?f?i?y?z?{@@@B@C@J@K@L@P@Y@Z@b@f"},
  {0,NULL,"@m@n@y@z@{A?A@AXAYA\\A_AaAbAcAiAjApArAvAwA{B@BABEBQBUBWBYBZB]BeBiB"},
  {0,NULL,"oB}C?C@CCCDCJCLCQCSCTC]ChClCtCxDBDEDJDMDNDQDUDVDYDbDdDkDsE?EBEEEH"},
  {0,NULL,"EKEMEPEUEXE_EbEdErEsEvEwEyF@FGFMFNFPFTFVFZFaFcFmFoFqFrFuG?GEGHGIG"},
  {0,NULL,"NGOGTGXG]G_GiGoGrGzG}G~HBHCHDHHHLHOHQH[HgHmHtH|I?IAICIGIKILINIWIb"},
  {0,NULL,"IcIiIjI}J?J@JIJKJLJMJQJTJYJ_JaJiJlJmJnJvJyJ{KAKGKOKYK\\KbKdKsLCLGL"},
  {0,NULL,"ILMLNLSLTLXL]L^L_LaLeLgLhLlLoLqLsMCMFMGMIMJMOMQM\\M]MgMiMnMoMrMzM{"},
  {0,NULL,"M~NCNDNHNSNZN[N_NbNcNdNoNpNwN}N~OBODOFOJOOOSOUOVOWOZO^OfOi_B?H?P?"},
  {0,NULL,"T?W?^?`?a?b?h?n?o?r?|@A@C@D@H@I@L@M@R@V@d@e@l@q@x@z@}AAACANAOAQAR"},
  {0,NULL,"ASAWA\\AjAmApAuAxAzA|BABEBJBNBPBXBZB]BaBdBnBqBsB~CACBCCCECFCICJCOC"},
  {0,NULL,"YCgClCuCwC}DEDHDIDSDTDUDXDYD^DgDiDpEAEDEFEKENEREXEYE\\E_E`EcEnEtEu"},
  {0,NULL,"EyE|F?FGFKFNFRFTFUFZF_FeFlFnFzF|F}GAGDGFGMGRGYGZG\\G]G`GcGlGoGzG{G"},
  {0,NULL,"~HCHHHJHKHOHPHSHYHbHjHrHwHxIDIHIKIMINIOISI^IiIoIpIwI{J?JFJHJMJNJR"},
  {0,NULL,"JWJZJeJfJgJjJoJsJ|J}J~K?KKKSKVKZKbKhKmKwLJLKLMLNLSLVLYLZL^L`LaLiL"},
  {0,NULL,"pLqLuLwLyLzM?MBMJMOMPMRMTMYMcMdMgMnMpMqMwM}M~NBNINJNVN[N\\N`NdNeNf"},
  {0,NULL,"NpNrNvNyN|O?ODOEOHONOOOQOSOUOYO\\OhOiOj_B?I?N?V?Y?Z?\\?_?`?f?i?y?z?"},
  {0,NULL,"{@@@B@C@J@K@L@P@Y@Z@b@f@j@w@x@}@~ADAEALANARAVA_A`AaAeAnApAqA{A~B@"},
  {0,NULL,"BABEBIBOBPBVBWBYB[B\\BiBoBqB~C?CCCGCKCLCMCSCUC]ChCiCoCqCsC}DQDRDTD"},
  {0,NULL,"UDXDZD\\DmDnDrDtD}E?EBEIEKELEMENEZE^EbEhEjElEuExEzE{FJFLFSFVFZF\\F^"},
  {0,NULL,"FiFjFkFoFqFuFyG?G@GHGNGPGQGYG\\G]G`GeGiGrG{G|G~HCHFHGHKHLHOHQH[HbH"},
  {0,NULL,"oHsHvH}IAIDIJILIPITIXI\\I]IeIpIzJ?J@JDJFJHJIJKJVJXJ[J^JgJhJsJtJxJz"},
  {0,NULL,"J|KDKHKLKNKTK^KlKpKuL@LJLPLRLVL[L\\L`LbLcLdLfLiLoLpLqLtL{M?MAMGMHM"},
  {0,NULL,"IMNMPM^M_MeMhMoMpMrMsMuMxN?NJNPNUN]NgNhNiNlNmNuNvNxNyN{O@OAOEOIOK"},
  {0,NULL,"OLONOXOYO[O]O_OfOi_B?I?K?V?Y?]?a?d?e?f?m?q?t?}?~@?@D@G@K@L@O@S@U@"},
  {0,NULL,"_@f@m@r@u@z@{A?A@ALAOAUAXAYA[A`AfAoAqAsAyB?BBBDBFBMBNBXBZB[B\\B]B^"},
  {0,NULL,"BfBvByB~CECFCICKCMCOCPCUCWCYCaCpC{D@DADLDQDRDSDVDWD]DeDfDgDlD~ECE"},
  {0,NULL,"DEHEKELEOEWEYE]EbEdEqEtEvEwEyF@FHFNFTFWF\\F]F^FgFhFkFnFtF{F}GAGBGG"},
  {0,NULL,"GOGPGQGZG[G^G_GaGlGuGyG{G|H?HEHFHGHMHPHVHaHdHiHnHrH{IAIJIMINIOIRI"},
  {0,NULL,"UI[IfIgInIyI|I~JGJHJIJOJTJUJWJ_JaJgJlJnJyJ{J}J~KAKGKOKYK\\KbKdKiLB"},
  {0,NULL,"LCLGLNLPLTLUL[L\\L]L^LdLfLhLoLrLuLxLzL~MBMGMHMJMKMTMUM`MfMjMnMoMrM"},
  {0,NULL,"vMzM{N@NINKNQNWNZN_NbNcNkNqNrNtNvNzN{O@OAOGOIOKOLONOPOQO\\Oj_B?J?L"},
  {0,NULL,"?U?X?[?\\?^?d?g?j?w?x?|@?@@@F@G@I@J@X@[@^@`@g@h@q@wA@ABACAEAPAQAXA"},
  {0,NULL,"\\A^A_AaAdAfAqAuAzA|A~BDBIBMBNBTBUBVB^BbBcBiBnBwC?C@CHCICJCLCNCPCT"},
  {0,NULL,"CWCZC^CpCsCwDCDFDLDMDTDUDXD]D_DbDhDjE@EEEGEHEIEREVEYE]E^EaEeEiEpE"},
  {0,NULL,"{E|E}F@FHFLFNFQFWFYF]FcFdFmFpFrFvFxF~GCGEGKGNGVGZG\\G]G`GhGsGuG{G|"},
  {0,NULL,"G~H?HAHFHJHOHPHSH[H_HkHpHyI?IBICIEIGIIIJIOIeIgIhIoIwIzI~JIJLJMJNJ"},
  {0,NULL,"PJSJVJcJdJhJjJoJqJtJxK?KBKFKJKRKUKeKiKjKwL@LILOLRLTLULXL\\L]L^LaLe"},
  {0,NULL,"LiLjLpLqLrLvM@MBMFMHMMMNMRMWM[M\\MfMmMqMrMtMyMzN?NNNTNVNXN^NaNbNcN"},
  {0,NULL,"nNoNpNqNuNxN{N|ODOLOQOROTOVO\\O]O^O_ObOh_B?J?M?V?Y?[?_?c?d?g?k?p?x"},
  {0,NULL,"?~@@@E@F@G@J@L@N@Q@X@^@e@h@r@w@}A?ABACAMAPAQAZA\\A^AcAeAfAqAuAxAzA"},
  {0,NULL,"|A~BJBMBQBTBUBaBbBcBdBlBmB{C?C@CBCHCICKCNCQCTCXCfCkCwC}D@DCDFDNDP"},
  {0,NULL,"DUDWDXD]D^DgDqDtD~EBEGEHEIENEPEQERE]E`EeEjEqExEyE|E}FGFIFKFOFPFXF"},
  {0,NULL,"[FgFiFkFlFyFzF|GDGFGGGJGLGMGRGTGUGXGdGfGvGzH@HBHCHDHEHGHIHNHRHTHU"},
  {0,NULL,"HrHuHxH}IFIGINIOIPIVIXI[IhIoIpI|J@JBJKJPJQJRJUJVJWJ`JfJgJkJpJrJsJ"},
  {0,NULL,"}K@KCKEKKKWKZKgKkKnKxKzK{LOLQLWLXL^L_L`LaLdLhLlLmLtLuL{L|L~MCMEMI"},
  {0,NULL,"MKMPMSMaMbMhMjMnMoMpMtMuMzN@NLNRNUNYN`NeNiNjNkNpNrNtNuNwOBOEOFOJO"},
  {0,NULL,"OOPOQOWOYO[O^OaOeOgOl_B?H?M?T?W?Z?[?]?c?h?k?u?v?}@B@E@F@H@I@K@\\@]"},
  {0,NULL,"@a@c@e@i@o@y@|@~A?ABASAUAVAWAXAYA[AeAkApAtA{A}B@BCBGBLBOBTBUBVB^B"},
  {0,NULL,"aBdBfBkB}CBCFCHCICLCMCOCPCTCZC_CiCqCtC|C~DIDJDKDMDQDSDZD_DeDoDuD|"},
  {0,NULL,"D~EGEMEUEYEZE[E\\E^E`EfEiEmEwExE}E~FJFLFRFSFUFVF]FfFgFnFpFsFtFwFxF"},
  {0,NULL,"{GCGMGNGOGRGTGUG_GeGhGwGyGzHBHCHFHKHLHNHOHdHeHgHpHzH{I@IBIDIEIJIK"},
  {0,NULL,"IQIRIYI]IaIjIxJ@JBJCJFJGJMJOJSJTJ\\J`JiJjJmJqJuJvJwKBKEKPKWKXKjKlK"},
  {0,NULL,"tL?LCLDLNLPLTLVLYLZL[L\\LcLeLgLjLmLoLuLwL}M@MCMHMMMOMPMUM_MaMbMmMn"},
  {0,NULL,"MpMvMxM|NFNHNNNONWNYNiNjNkNmNoNrNyNzO?O@OBODOHOLOMOUOWOYO\\O]ObOcO"},
  {0,NULL,"f_B?J?O?U?X?_?b?c?e?g?l?p?s?{?~@A@E@G@H@J@N@Q@T@W@g@h@n@oA@ABACAE"},
  {0,NULL,"ANATAVA[A]A_AaAhAlArAtAvAwBGBHBKBLBNBPBRBXBZB^B_BkBoBxB~CACCCECFC"},
  {0,NULL,"MCRCSCUCaCeCgCvCxC|DDDGDJDMDPDQDXD[D^DfDmDqD}EAECELEPEVE[E\\E]E_Ea"},
  {0,NULL,"EeEnEqE{E|E}F@FGFHFKFSFWFXF[F`FiFkFlFyF|G@GBGFGGGJGLGNGTGUG]G_GaG"},
  {0,NULL,"cGtGyHBHCHDHEHHHIHLHNHQHXHeHnHuHvHxIEIMINIOITIVIXIZI`IaIcI}JAJBJF"},
  {0,NULL,"JKJLJOJRJUJVJcJdJjJlJoJqJ{K?KAKBKFKJKRKUKeKiKmL@LDLILQLRLWL\\L]L`L"},
  {0,NULL,"aLbLcLeLgLnLoLpLxLyL}M@MAMBMJMQMTMVMXMeMlMmMqMrMtMuMyNBNFNKNSNXN]"},
  {0,NULL,"N^NaNlNnNsNyNzN}N~O@OEOFOGOHOIOMOOOPOSOXObOh_B?I?O?T?W?Z?_?a?e?f?"},
  {0,NULL,"l?t?y?{?}?~@C@I@K@L@S@U@Y@b@g@j@o@x@|ACADAEALATAZA]A_A`AaAeAmApAq"},
  {0,NULL,"A{A~BABDBIBMBWBYB[B\\B`BbBcBjBrB|CCCGCKCLCNCOCRCSCUCXC[C`CoCsCwC~D"},
  {0,NULL,"KDODTDUDWDZD\\D_DaDiDjD|D}EAEIEJEMENEREWEZEaEhEmEnEzE{E}F?FHFIFMFP"},
  {0,NULL,"FWFXF[F_FfFmFnFrFtFvF~GAGEGIGKGSGVGXG[G^GfGnGxGyGzG}H@HAHDHEHIHPH"},
  {0,NULL,"\\H]H^HpHwHyH~IBIFIHIJIPISIWIYI\\IeIoI{JAJBJCJHJPJSJXJYJZJ]JcJjJlJn"},
  {0,NULL,"JoJyJ{KAKBKFKIKRK[K_KkKoK|LELLLQLRLWLZL\\L_LaLbLdLeLgLkLxLyLzL|L}M"},
  {0,NULL,"BMCMDMQMSMTMUMgMiMjMmMnMqMuMxM}NHNINKNSNZN_N`NbNcNjNoNpNtNvNxNzN~"},
  {0,NULL,"OCOGOLOQOSOTOWOZO[OaOkOnOo_B?I?L?T?W?\\?]?`?d?f?j?q?z@?@@@B@D@H@K@"},
  {0,NULL,"L@O@P@Z@_@g@m@q@y@{A@AAABAMAPA^A_AaAbAcAjAkApArAvAwB@BEBHBKBQBRBS"},
  {0,NULL,"BWBYB_BeBgBlBtC?C@CBCCCDCLCNCQCRCbCcCdCuCxC|DBDHDJDNDODQDWDYD^DfD"},
  {0,NULL,"lDuEEEFEGEJEKEPEUEWEXE[EaEdEiEtEvE|E~F@FHFOFQFWFYF\\F^FeFgFkFnFyF{"},
  {0,NULL,"F}G@GBGGGJGLGPGQGWG[G^GbGjGpGyG|H?HAHGHIHKHMHPHRHZHfHiHnHxHzIMINI"},
  {0,NULL,"PIQIRIUIWI^IaIbIcIwIxI~JGJRJTJUJWJXJYJbJdJhJjJqJtJxJzK?KDKJKMKQKU"},
  {0,NULL,"K]KaKcKxLALFLOLULXLYL\\L]L_LaLdLiLjLkLmLpLvL|M?M@MDMMMNMRMSMZM_MdM"},
  {0,NULL,"hMmMpMqMvMzM~N?NJNONTNYN]NeNgNhNlNtNxN|N~O@OBOCOEOGOMONOOOTOZO[O]"},
  {0,NULL,"OdOgOmOr_B?I?L?T?W?\\?]?`?d?f?j?q?z@?@@@B@D@H@K@L@O@P@Z@_@g@j@p@t@"},
  {0,NULL,"|ACADAEAOASATAUA]AbAcAdAgArAsAvAwAyB?BHBKBNBQB^BaBbBcBeBgBtBuC@CA"},
  {0,NULL,"CBCDCECHCICPCQCbCcCfCvCyCzDDDGDIDODPDRDYDZDcDmDnDqE@EFEGEJELENEQE"},
  {0,NULL,"TEUE\\EaEhEjEkEzE{E}F?FRFVFXFZF[F\\F^FdFjFkFoFqFyG?G@GBGGGKGNGPGQGR"},
  {0,NULL,"GVG]GjGpGvG|G~HGHJHKHLHMHNHOHZH`HfHlHoHuHvIDILIPIRISIVIXIZI_I`IdI"},
  {0,NULL,"wIxIzJCJDJEJFJKJWJXJ]JcJkJlJnJrJyJ{K@KAKFKIKRK[K_KkKqK|LHLLLMLPLQ"},
  {0,NULL,"LSLVLWLZL[LbLjLkLlLrLsLuLyL}L~MFMKMOMRMSM\\M]M`MfMmMnMqMsMxM}N@NCN"},
  {0,NULL,"DNQNXNZN_NaNbNcNqNrNyN}O?OAODOFOHOIOJOPOUOVOYO\\OgOkOnOr_B?H?N?U?X"},
  {0,NULL,"?Z?^?`?c?h?i?o?u@A@B@C@F@G@H@I@R@\\@a@d@f@l@n@t@z@{@}AEAMAXAYAZA^A"},
  {0,NULL,"bAcAlAnAsAtAyA}B?BBBFBGBOBSBVB[B\\B`BcBgBhBmC@CGCKCLCMCNCQCRCTC[Cj"},
  {0,NULL,"CmCrC{DADDDFDGDHDLDODPDSDaDfDgDpD}EBEEEOERESETEVEWE\\EbEcEnErEuEyE"},
  {0,NULL,"zF@FMFNFPFQFRFTFUFeFiFlFnFtFzF{F}GAGFGMGPGQGRGVGYG\\GgGmGnGzG{G|G}"},
  {0,NULL,"G~HHHJHKHNHTHWHfHjHnHrH~IFIHIIIMIOIQISIZIfImInIzI}J?JEJNJRJSJUJWJ"},
  {0,NULL,"ZJ[JaJiJlJmJnJuJvJwJ{KHKNKOKYKfKoKrK{LFLHLNLOLSLWLXLYL]L^L_LeLkLl"},
  {0,NULL,"LoLsLvL{L}MCMFMGMLMNMQMVM^M_MbMmMoMrMtMwM~NCNFNHNMNWNhNiNkNlNmNoN"},
  {0,NULL,"qNrNuN|O@OCOFOGOHOKOQOROVOWO]OdOeOnOq_B?D?K?Q?R?U?V?b?e?i?o?p?q@@"},
  {0,NULL,"@F@I@K@V@W@Z@^@_@`@d@k@o@u@x@~ADAHAJAMASATAWAXA\\A`AeAkAnApAvAxAyB"},
  {0,NULL,"EBJBKBNBTBVBWBYB\\B_BsBtBxB{CLCOCTCUCcCeCfClCnCyD?DFDYD]D_DbDdDfDg"},
  {0,NULL,"DhDiDlDmDpDtDuDwDxD|EAEBECEGELEVEXEgElEoEtEuEvE}E~F?FAFFFGFQFSF\\F"},
  {0,NULL,"aFbFeFoFyF|F}G@GDGHGJGXGZG\\GdGfGhGkGlGmGxG{G|H@HLHQHVH[H^HeHfHgHi"},
  {0,NULL,"HjHlHpHqHuIBIJIOIPISIWIYIbIiIrItJ@JAJCJFJGJMJSJUJ^JbJeJjJqJxJ|J~K"},
  {0,NULL,"BKDKIKQKSKXK`KdKfKjKkKnKrKuKxLDLHLSLXLZL\\L^L_LdLeLhLiLlLmLzMEMGMI"},
  {0,NULL,"MJMNMRMVM]MeMmMnMsMtN?N@NANBNCNDN[N`NdNgNhNjNoNvN|N~OAODOLONOVOYO"},
  {0,NULL,"ZO]OgOhOiOlOmOt_B?E?L?R?S?T?X?[?]?l?t?u?w@A@C@J@L@O@R@U@V@W@[@]@l"},
  {0,NULL,"@q@v@y@{AAAFAKANAPAWA`AaAbAcAiAjAmArA}B?BBBDBGBHBPBTBWBXB]BaBbBfB"},
  {0,NULL,"mBuBvC@CCCHCSC\\CaCiCmCnC{C}DFDPDWD_DaDdDhDjDlDmDpDqDsDtDuDvD{D}D~"},
  {0,NULL,"E?EBEGELEZE^EcEjEoEpEuEwEyEzE|FEFFFIFSFVFYF_FeFiFkFsFwFyF{F}F~GLG"},
  {0,NULL,"RG\\G^GjGmGnGoGpGuGvHAHCHGHPHQHXH^H_HcHeHgHkHrHsHtH{H~IAIBICIFIUIX"},
  {0,NULL,"IZI`IiIrIsIxI}JIJKJQJSJTJYJ[JbJfJiJmJrJvJxK@KDKNKSKYKZK`KaKdKfKiK"},
  {0,NULL,"kKoKzLBLCLLLQLRLSLTLULWLbLfLgLpLsLvLxL~M@MAMBMDMEMUMaMeMnMrMwMxNB"},
  {0,NULL,"NENKNLNONVN\\N]N`NdNeNlNqN|N~O@OCOFOGOIOJOROVOZO`OcOdOgOtOv_B?F?M?"},
  {0,NULL,"Q?S?T?Y?]?d?n?t?u?w?{@C@H@J@O@R@Y@Z@[@^@a@m@q@v@y@zAAAFAGAPASATAV"},
  {0,NULL,"A^AaAbAiAjAmAuA|A}BBBDBFBMBPBQBVBYBZB]BaBmBrBvBwB~CBCHCSC[C^CaCmC"},
  {0,NULL,"nCxDADFDZD\\D_DbDeDhDiDlDmDnDoDpDqDtDvDyD}D~E@EAECELE\\E]EdEiEqEtEv"},
  {0,NULL,"EwEzE|F@FAFDFKFRFWF\\F`FaFcFlFrFvFxF|F}GAGNGSGXG`GdGfGhGqGrGvGxHHH"},
  {0,NULL,"IHKHOHVHWHXHYHZHbHdHkHmHnHoH{H~IDIHIIIJITIVI[IbIhItIuI{I|JCJDJEJN"},
  {0,NULL,"JOJVJ_JdJeJhJqJsJzJ}K?KDKJKOKQK\\K]K^K_KcKnKoKtK{K}LELKLOLQLVLXLZL"},
  {0,NULL,"\\LdLfLgLjLkLpL|M?MMMNMOMSMTMVMZMdMmMoMuM~NCNHNJNMNQNTNZN[NaNbNdNn"},
  {0,NULL,"NrNsNuN{OAODOKONOPOQOYO\\O_OhOjOlOnOo_B?E?P?Q?S?T?V?a?e?k?o?p?q@@@"},
  {0,NULL,"B@I@J@N@S@W@Y@Z@\\@d@j@o@u@x@|@~AFAHALATAWA\\A]A^A_AeAkAnAtAyB?BGBH"},
  {0,NULL,"BJBKBOBUBVBWBZB\\BdBhBtBxByC?CACOCTCWCcCeCjCsCzD?DGDNDYD^DaDbDdDeD"},
  {0,NULL,"gDhDkDmDpDqDuDvDwE@ECEDEEEGEHEVEYEhEmEnEpEuEvEzE{E}FCFDFHFPFUF]Fd"},
  {0,NULL,"FiFjFpFtF{G@GBGCGFGQGTGWG]GbGcGiGjGkGqGvGzHAHCHFHTHYH\\H_HaHdHgHiH"},
  {0,NULL,"jHmHoHuHyICIIIKINIQIVI\\I`ImIqIuIxIyJJJLJNJOJQJWJ[J\\JcJlJnJoJvJwJy"},
  {0,NULL,"KBKHKLKRK[K_KaKcKgKhKkKsKzL?LBLFLNLOLQLYL_LaLbLeLhLiLkLyL|MCMDMMM"},
  {0,NULL,"PMQMTMUM[MjMoMqMxMzNGNHNJNKNPNRNXN]N^NgNiNmNqNwNyN}O?OFOHOJOMOROU"},
  {0,NULL,"OWObOdOqOrOuOv_B?F?O?R?S?T?U?a?b?j?o?p?q@B@F@J@K@N@S@V@\\@]@^@_@i@"},
  {0,NULL,"o@u@x@|ADAFAJALASAXA]A_A`AcAeAkAnAqAyA|BFBJBKBMBOBTBUBXBYB_BdBhBs"},
  {0,NULL,"ByB{C?CACLCUCWCfCjClCtCyCzDGDOD]D^DaDbDdDeDfDhDiDlDqDrDtDvDxE?EAE"},
  {0,NULL,"BEDEEEHEXE_EfEkEqEsEuEvEwExE}FBFEFNFOFZF[FcFfFgFmFtFzGAGDGEGGGMGV"},
  {0,NULL,"G[G_GaGeGgGnGpGqGxGyG}HIHOHRHSHXH[H_HbHhHiHjHsHtHuI@IFIGILIMITIUI"},
  {0,NULL,"]IgIhIsIvIzI{JDJHJIJKJRJXJ]J_J`JgJpJsJyJ|KAKCKGKPKTKWK]KaKeKoKpKq"},
  {0,NULL,"KrK{K}LALJLOLPLULWLXL]L`LeLhLiLvLxL{M@MBMFMKMLMSM\\McMdMpMrM|M~NEN"},
  {0,NULL,"FNINLNNNTNWNYNbNcNjNmNpNsNtNxNzN{OKOPOTOXO[O^OaOeOjOnOpOs_B?G?O?R"},
  {0,NULL,"?S?W?X?Z?c?j?o?t?x?|@D@J@K@M@N@S@^@_@a@c@i@n@o@yA@ABAFAJAQASAVAXA"},
  {0,NULL,"[A]A_AhAjAkArAyA|BFBJBKBMBOBQBYB[B_BdBeBmBqByB{CACDCLCSCWCYCfCmCp"},
  {0,NULL,"CqDCDRDTDXD^D`DaDcDdDfDiDjDnDoDrDsDvDxD}E?EBEDEFEQESEWEfEiElEmEwE"},
  {0,NULL,"xEyE{E~FDFFFHFJFQFRF`FbFjFkFvF{F|F}G@GFGJGSGYG]GcGfGkGoGrGsGtGyG|"},
  {0,NULL,"HCHIHWHZH]H`HaHfHgHqHrHyH{H|H}IAIGIHILINIWI_IdIjIrIuIwI}JDJIJLJPJ"},
  {0,NULL,"UJZJ\\J^JdJiJqJvJwJzKBKDKEKLKXK\\K^KbKgKjKkKmKtKxK{LBLJLMLTLVLZL[L_"},
  {0,NULL,"LaLgLmLsLuLwLyL}M@MHMPMRMSM_MbMfMnMoMvMwN@NFNINONPNQNXN[N]NaNdNgN"},
  {0,NULL,"sNtN}N~OAOFOJOMONOPOTOZOdOeOhOjOrOtOwOyOz_B?F?O?R?S?T?U?a?b?j?v?w"},
  {0,NULL,"?y@B@F@G@L@M@P@T@Y@`@a@d@i@p@s@v@|ADAIAKAMAOARAVA[A\\A^AdAgAiArAwA"},
  {0,NULL,"{B@BCBIBLBNBQBZB\\B`BcBeBfBjBoBzC@CECFCNCdChCiCkCoC~D@DLDQDSD^D_Db"},
  {0,NULL,"DcDfDgDhDkDnDoDpDsDzD{D~EBECEDEGENEPEREfEkEqEsEuEvEwExE}FBFEFNFOF"},
  {0,NULL,"ZF[FcFfFgFkFqFsFwG?GEGGGMGVG[G_GaGcGhGmGqGtGwG~HEHGHJHRHYHZH[H\\Hc"},
  {0,NULL,"HfHjHmHpHsH{H}IFIIIJILINISIaIcIlIsIvIxJAJDJHJMJNJQJUJ]J_J`JiJmJpJ"},
  {0,NULL,"uJ{K@KAKGKPKTKWKcKhKiKjKpKrKtK~L@LGLLLMLOLSL\\L]LaLcLgLiLlLvLwL|MD"},
  {0,NULL,"MFMGMRMSMTMWM`MhMpMrMtMxN?NCNENINJNPNYN\\N_NcNeNfNoNyN|O?O@OBOHOIO"},
  {0,NULL,"OOUOVO]OcOgOiOkOqOu_B?D?L?R?S?U?W?^?`?l?r?x?y?}@E@G@K@Q@R@X@Z@\\@]"},
  {0,NULL,"@b@l@n@p@tACAEAIAJALATAUAYAZAbAcAgAhAlArAvAxAzA~BABEBPBRBSBUBVBXB"},
  {0,NULL,"^BiBlBqBzCDCFCPCRCXCYC]CkCsCwDADKDNDZD`DbDdDeDiDkDlDmDoDpDqDuDxDz"},
  {0,NULL,"D~E?ECEDEFEKEYE]EcEnErEtEuExEyF?F@FBFDFTFUFWFXFaFdFhFkFqFrF|G?GBG"},
  {0,NULL,"FGKGNGOGWGbGiGjGkGpGwGxG|HEHLHNHSHUHVHWHXHYHeHrHsHwH}I?I@IEIGIJIK"},
  {0,NULL,"IUIXI^IbImIuIvIwJAJCJHJJJKJPJTJaJcJeJiJnJqJuJwJ{K?KHKKKOKVK^KcKfK"},
  {0,NULL,"lKnKoKqKuKxKyL@LNLULXLYL_LbLcLoLrLsLvLwL{L}MAMBMCMFMNMVM^MjMoMpMt"},
  {0,NULL,"MvNCNFNLNRNUNVNXNZN[N^N_NfN}O?OAOBODOEOHOMONOOOSOYOfOhOkOlOrOu_B?"},
  {0,NULL,"G?P?Q?S?W?Y?\\?`?k?q?s?u?}?~@I@J@N@P@U@W@\\@b@d@j@q@w@x@}ACAFAHALAN"},
  {0,NULL,"ARAWAYA\\A_AeAfAmAuAyB?BGBHBJBKBRBUBWB\\BbBcBdBgBhBvBxC?CHCJCOCaCbC"},
  {0,NULL,"eCjCoCrCvDSDVD[D^D`DbDcDeDgDjDkDnDoDsDuDvDwD~E@ECEEEFEPETEUEhEjEk"},
  {0,NULL,"ElExEzE{F?F@FAFEFGFOFVF^F_FbFfFlFsFyF}GAGDGGGIGMGZG^GgGlGoGsGuGwG"},
  {0,NULL,"xGzG{HCHIHRHUHZH[H`HcHeHlHnHvH~I?I@ICIEIGIIIOIRI_IeIlIsItIwI|JEJJ"},
  {0,NULL,"JLJMJRJTJ]J^JfJhJpJsJxJ|K@KDKFKIKNKTKbKfKiKlKpKrKtK{LBLDLFLPLRLTL"},
  {0,NULL,"XL[L^LcLfLjLoLqLzL{M?MAMCMGMKMPMXM_MhMmMrMuMvNDNFNJNKNSNUN\\N`NbNc"},
  {0,NULL,"NdNjNpNsN|O?ODOFOHOJOPOVOYO^OdOgOjOlOpOuOwOxO{_B?F?M?Q?S?T?Y?]?d?"},
  {0,NULL,"n?p?r?z?{@C@G@I@Q@T@U@V@_@b@c@m@r@t@u@zAAAHAIANAOAQAXAYAZA`AlAnAo"},
  {0,NULL,"AtAvAwAxB@BEBLBRBTB[B^B_B`BbBiBkBpBtCGCICRCTCVC]CcCgCpCuDEDMDTDUD"},
  {0,NULL,"^D_DaDcDfDjDkDoDqDrDsDtDwDzD}E?E@EEEGEJEQE[EdEiEqEtEvEwEzE|F@FAFD"},
  {0,NULL,"FKFRFWF\\F`FaFcFpFqFxF|G@GBGHGNGSGXG`GdGeGhGiGnGoGwH@HEHFHJHRHWHXH"},
  {0,NULL,"^H`HaHfHiHoHtHxH~I?ICIEIFIHIPITIaIfIjItIuIxJ?JEJKJNJRJSJZJ_JdJeJl"},
  {0,NULL,"JnJqJ{J}J~KBKJKOKQK\\K^KbKdKgKjKoKpK~L?L@LHLNLTLWL\\L`LcLdLfLhLkLoL"},
  {0,NULL,"tLxM?MBMEMHMKMTMYM`MfMmMoMxM{NANENKNQNTNUN[N^NfNgNhNnNoNwN}N~OBOC"},
  {0,NULL,"OGOMOOOWOZO]O`ObOiOkOrOtOwO~_B?G?K?Q?R?X?Y?[?d?i?t?u?w?{@A@H@L@Q@"},
  {0,NULL,"U@W@Y@]@^@a@k@q@v@y@z@{AGAKANASAVAWAZA^AcAiAjAmApA{A}BBBCBDBIBQBW"},
  {0,NULL,"BXBYBZB^BbBfBrBuBwB~C@CBCCC[C\\C^CiCzC{DADGDPDZD^DaDbDdDeDiDjDmDoD"},
  {0,NULL,"qDtDuDyD{E?E@EAEFEGEHEZE]EgEkEmErEwEzE|E~F?FBFCFLFNFPFXFfFhFjFoFr"},
  {0,NULL,"FtFwG?GCGEGKGQGUG_GbGcGdGgGjGkGwG~HBHDHMHQHRHSH[H]HaHbHkHlHqHxH{H"},
  {0,NULL,"~IEIMINIPIRIWI\\I]I^IqIvI~J?JFJMJPJRJWJZJ\\J]JaJjJmJoJuJyK?KAKMKPKV"},
  {0,NULL,"K[K]K`KgKmKpKqKrKvKwK|LGLPLYL_LaLbLcLdLfLgLmLpLtLzL}MGMHMIMKMQM[M"},
  {0,NULL,"\\M^MpMqMyM{N@NANNNPNSNUNYNZN_NeNiNmNwNxNyNzOBOEOOOSOUOWOXO[OaObOf"},
  {0,NULL,"OkOqOsO}_B?D?M?Q?S?V?W?Z?_?n?s?v?z@?@D@G@I@O@Q@S@T@V@Y@c@m@r@s@wA"},
  {0,NULL,"?ABAHAIAOAPAQAZA]A^A`AdAfAoAuAvAwAxB@BEBLBOBTBZB[B]B^B`BgBkBoBpCG"},
  {0,NULL,"CICJCNCVCbCgChCtC{C|DHDODPDaDbDcDdDiDjDlDpDqDrDtDuDwDzD}E@EBEEEFE"},
  {0,NULL,"MEZE_EdEoErEsEvEyE{E~F@FCFEFIFLFMFZFeFgFhFlFuFwFyFzG?GGGPGRGUG[Gb"},
  {0,NULL,"GfGmGpGtGuGvG{H@HEHNHSHYH[H]HbHgHhHmHnHvHyHzH|IBIEIHILIQIVI^IgIiI"},
  {0,NULL,"qIsIwJ@JLJNJPJSJVJXJ`JaJbJhJmJpJtJuJxKCKGKMKUKYK]KcKeKkKmKqKrKyL@"},
  {0,NULL,"LDLHLMLQLRLSLULYLZLjLnLqLuLyL|L}MEMLMOMPMTM^McMeMqMrMsMvNBNGNHNIN"},
  {0,NULL,"QNUNWN_N`NcNeNkNpNtN|N~OBOEOOOSOTOVOZO^OeOfOgOkOpOtO}_B?D?K?Q?R?U"},
  {0,NULL,"?V?b?e?i?v?w?y@@@F@H@L@N@T@U@X@Y@]@a@k@p@s@v@~ADAGAKANAOAUAVA^A_A"},
  {0,NULL,"cAdAgAiAsA{A}BBBCBDBIBQBSBXBZB`BbBdBfBjBnBrB~C@CECQCZC[CdCiCoCqCu"},
  {0,NULL,"DSDUDXD^D`DbDcDdDfDgDjDkDoDqDrDyD{EAEDEEEFEGEPEWE[EgElEoEtEuEvE}E"},
  {0,NULL,"~F?FAFFFGFQFSF\\FaFbFeFnFsFvFxF}F~GHGJGXGZG\\GaGiGlGsGuGvGxHBHDHKHP"},
  {0,NULL,"HTHWHXH`HfHgHhHmHpHsHuHwHzIBIGIKIMIPIVI_IfInIrItIyIzJCJFJKJLJWJXJ"},
  {0,NULL,"^JbJeJkJrJzJ}J~K@KDKIKQKSKXK^KbKeKjKkKoKsKwK|LCLELNLQLRLXL[L]L^Le"},
  {0,NULL,"LlLnLrLvL|MBMIMLMNMPMQMYM_MiMmMnMzM|NANBNFNHNNNRN\\NaNdNhNlNnNrNsN"},
  {0,NULL,"wNzOCOFOGOJOPOWOXO\\O_O`OaObOdOjOxOy_B?F?N?Q?R?U?Y?\\?^?m?r?x?y?~@E"},
  {0,NULL,"@H@K@M@Q@R@S@W@`@b@h@n@p@t@}AEAGAJAMAWAYAZA[A]AbAgAhAlAsAzA|A~BAB"},
  {0,NULL,"FBMBNBOBPBRBWB^BeBlBnBqB|CDCMCPCQCXCYCZC`CsC|C}DHDNDWDaDbDcDeDhDk"},
  {0,NULL,"DlDpDqDsDtDuDxDyD|D~EEEFEGEMEYE^EeEiEpEsExE|E}F?F@FCFFFJFMFYF]F`F"},
  {0,NULL,"gFiFnFuFvFzF{F~GFGLGPGTGYGdGgGmGoGpGtGvGyG}HHHKHVH[H\\H_H`HaHdHlHp"},
  {0,NULL,"HwHxH}I?ICIDILIPIRISI[I`IgIqIrIzI|JEJGJMJQJXJZJ[J`JdJkJrJtJvJwJzK"},
  {0,NULL,"CKEKRKUKZK_KaKbKgKhKnKrLALELJLKLMLPLQLSLTLULdLlLoLrLtLwLzM?MDMGMH"},
  {0,NULL,"MJMLMUMZMcMnMqMuM|N?NANINKNMNSNWNXN]NaNkNlNpNqNrNtNuOFOJOQOROTO\\O"},
  {0,NULL,"^O_OdOeOoOpOvO|_B?E?N?Q?R?V?X?_?c?m?o?t?x?|@?@H@K@M@N@R@S@T@[@b@h"},
  {0,NULL,"@n@o@yA?A@AGAJAOAYA[A]A_AaAbAhAjAkApAzA|A~BABFBMBOBPBRB`BaBdBeBqB"},
  {0,NULL,"wB{B|CBCDCLCMCYC^C`CfCpCvD@DLDTDVD^D_DaDcDgDjDkDnDpDrDsDuDxDyD|E@"},
  {0,NULL,"EBEFEGENEQETEeEjEnEqEyE{E|E}E~FAFBFKFTF[F^F_FcFdFoFqFrF|GAGDGEGIG"},
  {0,NULL,"OGVG`GbGeGhGiGnGrGuG}HHHLHMHRHTHYHZHcHeHhHkHqHrHuHyHzIBIDIFIKIQIR"},
  {0,NULL,"IaIeIpItIvI~J@JGJNJTJWJXJYJ_JcJfJjJqJsJ{J|K?KAKFKJKKKWKcKeKfKiKpK"},
  {0,NULL,"sKtKuKvLALKLNLRLVLWLYL\\L`LeLmLnLpLsLyL~MAMJMLMQMTMXM`MlMmMpMsMyNB"},
  {0,NULL,"NENGNMNRNSNYNZN[NbNfNjNoNpNuNxOBODOOOQOYO[O]O^OiOkOlOoOpOsOyO{O~_"},
  {0,NULL,"B?E?N?Q?R?V?X?_?c?m?s?v?z?|@?@I@L@O@P@Q@\\@^@`@c@h@r@s@wA?A@AHAKAL"},
  {0,NULL,"AMAPAQARASAZAdAfAoAsAwB?B@BGBHBLBNBUBYB[B]B^BcBgBjBkB}CECGCJCKC_C"},
  {0,NULL,"bCdCgCtCwCxDKDOD\\D`DaDdDeDhDiDlDmDnDpDqDrDwD{D|D}EAEDEFEKE\\E_EeEj"},
  {0,NULL,"EnEqEyE{E|E}E~FAFBFKFTF[F^F_FcFdFnFqFsFxGAGBGGGIGOGVG`GeGgGkGmGnG"},
  {0,NULL,"qGsGzHFHGHPHQHUHVHXHYHZHaHpHqHvHxHzH|IAIKIRISITIWIZIhImItIvIyI}JD"},
  {0,NULL,"JFJGJJJYJZJ_JcJfJkJnJpJsJ{J}K@KFKJKKKWK`KcKgKlKnKoKtL?LCLFLLLOLPL"},
  {0,NULL,"SLWL[L_L`LlLmLnLqLtLuL~MCMHMIMJMSMaMdMjMmMpMwMzN?N@NONRNSNTN\\N^Nb"},
  {0,NULL,"NcNfNnNsN{N}O?O@OCOGOHOIOKOMOPO`OcOjOnOrOuO}P?P@_B?G?K?Q?R?X?Y?[?"},
  {0,NULL,"d?i?p?r?z?{@A@I@K@T@V@X@Z@[@_@d@k@r@t@u@z@{AHAJAOATAUAXA\\A`AaAlAn"},
  {0,NULL,"AoAsAvAxAyBEBJBKBSBTBVB\\B_B`BaBkBlBsBtCGCPCTCUCXCcCgClC~DBDEDIDMD"},
  {0,NULL,"QD_D`DcDfDgDhDjDmDnDoDsDtDwDxD|D}D~EAEGEIEJEREgEkEmErEwEzE|E~F?FB"},
  {0,NULL,"FCFLFNFPFXFfFhFjFnFtFzG?GBGFGGGKGQGUG_GaGjGqGrGtGuGwGyGzG{G|HTHUH"},
  {0,NULL,"WH]H_HbHcHkHoHtHwHxHzIBIDIIIMIWIXIdIkIlIqIvI|I}JCJIJMJVJWJYJ\\J]Ja"},
  {0,NULL,"JkJnJpJuJwJyKCKMKPKVK[K]K^KaKiKlKmKsKxLDLFLJLMLOLRLVL]LbLcLkLnLpL"},
  {0,NULL,"rLtLxL~M@MGMNMOMQMbMgMhMpMqMuMwN@NBNJNMNNNVNWNXN^N_NcNmNqNtN{N|O?"},
  {0,NULL,"OAOHOKONOROTOVOeOgOhOnOuOvOzO{O~PB_B?G?O?R?S?W?X?Z?c?j?s?v?z?|@D@"},
  {0,NULL,"G@L@P@R@T@V@Y@\\@`@i@r@s@wA@ABAIAKALAMAOARA^A`AbAdAfAoAqAwA{B@BCBI"},
  {0,NULL,"BLBNBPBTBUBZB`BcBjBoBpB}CECICKCNCVC_CdChCxC|D?DHDYD\\DaDbDcDeDgDhD"},
  {0,NULL,"iDmDnDpDtDuDzD{D|D~E@EBEDEMEVE\\EfEiElEmEwExEyE{E~FDFFFHFJFQFRF`Fb"},
  {0,NULL,"FjFmFuFvFxG@GCGHGJGSGYG]GdGfGjGlGnGrGxG~H?HDHJHSHTH_H`HaHdHeHrHtH"},
  {0,NULL,"vHzH|I@IDIFIGINIOIXIYI[I\\IrIuI~JBJEJHJIJTJUJWJ\\J^JdJgJoJtJzJ}J~KB"},
  {0,NULL,"KEKLKXK\\K_KaKbKfKgKqKsK|K~LGLILVLWLXLZL^LbLdLnLqLsLuLxL{M?M@MAMFM"},
  {0,NULL,"QMRMZM[M]MnMoMyM}NDNENFNMNPNVNaNgNhNiNkNnNoNrNuNvNwNyOLOQOUOWO\\O]"},
  {0,NULL,"O_ObOiOmOoOqP@PC_B?E?L?R?S?T?X?[?]?l?p?r?z@A@C@G@K@Q@X@Z@a@b@c@d@"},
  {0,NULL,"l@r@t@u@{AAAIAJAQATAUAVAYAZA\\AlAnAoAqAvAxAzA~BABEBQBRBSBVB[B\\B^Bi"},
  {0,NULL,"BlBpBsCICPCRCUCVCXC]ClCrCuDBDIDUD[D^D_D`DeDgDjDkDmDnDoDqDrDxDzD~E"},
  {0,NULL,"?E@EAEDEIEUE[EcEjEoEpEuEwEyEzE|FEFFFIFSFVFYF_FeFiFmFuFyFzF~GDGHGL"},
  {0,NULL,"GRG\\G^GcGgGhGlGsGuGvG}H?HLHNHQHZH\\H]H^HdHhHjHoHtHxH{H|IAIJINIRIUI"},
  {0,NULL,"VIeInIoIrIsI{I~JDJFJOJPJQJTJ[JbJfJgJrJtJxJ|J~KCKNKSKYKZK_K`KdKeKh"},
  {0,NULL,"KmKtKuKyLALILPLQLRL[L\\L^LaLgLiLkLtLuLxL}MAMDMIMMMSMXMiMkMnMrMyM~N"},
  {0,NULL,"CNHNLNONPNSNWN`NhNjNkNlNpNrNvNzODOEOLOSOXOYO\\O^O_OaOfOlOmOpOwPBPD"},
  {0,NULL,"_B?D?M?Q?S?V?W?Z?_?n?o?t?x@?@D@H@J@P@R@[@^@_@a@b@m@n@o@yA?ABAFAGA"},
  {0,NULL,"RASAVAXAYAaAbAhAjAkAtA|A}BBBDBFBMBPBQBRBYB_BaBcBmBwByB|CACBCMCSCW"},
  {0,NULL,"C^C`CmD@DBDCDIDLDRD_D`DcDfDgDiDkDmDnDoDpDrDvDyD|D}E@ECEDEIENESEdE"},
  {0,NULL,"oErEsEvEyE{E~F@FCFEFIFLFMFZFeFgFhFpFtFwFzF{F~GEGPGRGUG[GaGeGjGlGm"},
  {0,NULL,"GtGwHAHBHKHOHQHSHUH\\H^H`HhHiHqHrHvHyI?IEIOISITIVIXIcIkInIqIsIyJBJ"},
  {0,NULL,"EJFJHJJJSJVJ`JaJbJlJmJrJvJyKAKCKGKMKUKYK`KbKdKeKhKlKqKwKzK}LELMLS"},
  {0,NULL,"L]L^L`LbLcLhLmLoLqLsLyM?MCMEMFMIMOMWMgMiMqMrMzM}N?NDNHNTNUNVNWNYN"},
  {0,NULL,"]NeNlNmNqNrNyNzN{O@OIOKOROUOXO\\O_OaOcOnOqOvOxO{PAPD_B?F?N?Q?R?U?Y"},
  {0,NULL,"?\\?^?m?q?s?u?~@E@I@L@N@O@P@X@[@\\@c@h@q@w@x@}AEAHAKALAPAQARAUA_AaA"},
  {0,NULL,"eAfAmApAwB?B@BGBHBLBSBUB[B]BaBcBdBgBuBxB}CCCJCKCOC\\C_CbCeCrDCDDDJ"},
  {0,NULL,"DRD[D^D_D`DeDfDiDkDlDnDoDrDsDwD{D|E?EAECEFEOESEUEeEiEpEsExE|E}F?F"},
  {0,NULL,"@FCFFFJFMFYF]F`FgFiFoFuFwFyF{G@GCGLGPGTGYGaGcGfGiGoGpGrG~H@HFHGHS"},
  {0,NULL,"HWH\\H^HcHdHhHkHlHnHuHwI@IDIHIKIMISIUIcIjIoIqIrJ?JAJCJHJOJXJYJZJ[J"},
  {0,NULL,"`JdJjJmJoJtJvJxKBKEKRKUKZK^K_KdKeKhKiKqL?LGLHLLLNLTLULVLZL]LaLeLj"},
  {0,NULL,"LpLrLzL{L~MFMHMLMMMNMWMfMkMnMqMtM{N?NLNMNNNQNRN]N`NeNgNiNkNvNyN}N"},
  {0,NULL,"~O@OEOIOLOMOSOUOZOcOfOmOqOrOtOxOzPBPH_B?G?P?Q?S?W?Y?\\?`?k?r?x?y?}"},
  {0,NULL,"?~@G@H@M@O@S@X@Z@]@`@j@n@p@t@}ACAGAIAMAPATAUA[A]AcAgAhAlAtAzA{A~B"},
  {0,NULL,"ABCBIBNBOBSBVBXB]BeBiBnBzB|CFCMCQCRCZC]C`CkCwCyC}DKDWD]D`DaDdDeDf"},
  {0,NULL,"DhDiDlDmDsDtDuDyDzD|D}E?ECEEEKEXE^EhEjEkElExEzE{F?F@FAFEFGFOFVF^F"},
  {0,NULL,"_FbFfFpFqFsF~GDGEGHGIGMGZG^GaGbGfGgGnGqGsH?HBHJHMHQHbHcHdHeHfHgHn"},
  {0,NULL,"HoHwHyH}I?IAIHIIIMIOIQIYIZI]IsItJ?JBJLJOJRJUJVJYJ]J^JfJlJrJ{J|J~K"},
  {0,NULL,"@KAKFKIKNKTK]K_K`KfKiKjKkKvKwK~LILOLPLWLYLZL[L]LjLkLoLrLwLyL~MKMM"},
  {0,NULL,"MOMPMRM\\M]MaMmMrM{M}NDNGNJNNNONQNYN\\NfNhNjNlNoNvNxNzO@OCOGOIOLOXO"},
  {0,NULL,"[O]O`OaOcOiOmOsO}PCPEPI_B?D?L?R?S?U?W?^?`?l?q?s?u?}@E@J@L@M@O@U@W"},
  {0,NULL,"@[@c@d@l@q@w@xACAEAFAKANAPAQAWA[A\\AaAeAfAmAqA}B?BBBDBGBHBWB[B\\B]B"},
  {0,NULL,"aBbBeBhBuBvB}C?CCCHCKC\\C_CaCjCvDDDEDJDMDVD_D`DcDfDgDjDkDlDrDsDtDu"},
  {0,NULL,"DvD{D|D~E?EBEEEJEOETEcEnErEtEuExEyF?F@FBFDFTFUFWFXFaFdFhFmFrFtFxG"},
  {0,NULL,"AGBGCGKGNGOGWGbGdGeGhGiGsGtHAHDHOHPHTHUHVH\\H]HbHfHjHlHnH|H}I@IAIJ"},
  {0,NULL,"ILIPIQIXIfIkIpIuIvIzJBJGJKJPJQJUJVJaJcJeJgJnJoJsJyJ}K?KHKKKOKVK]K"},
  {0,NULL,"hKjKlKmKnKsKzK|K}LCLMLNLYL[L\\L`LdLiLjLuLwLzL{L}MBMDMJMOMRMYMgMlMo"},
  {0,NULL,"MpM|M}NANCNGNINONVNZN^NbNiNmNnNqNuNwNxN{OCOGOKOQOROWO[O`ObOnOoOsO"},
  {0,NULL,"vOyOzPAPF_B?E?P?Q?S?T?V?a?e?k?v?w?y@@@B@G@H@M@P@U@X@]@_@`@j@p@s@v"},
  {0,NULL,"@|@~AGAIAMANARAUAXA[AcAdAgAiAuAzA{A~BABCBIBNBSBXB_BbBcBeBnBoBrBzB"},
  {0,NULL,"~CFCNCQCZC[ChCkCqC~DDDJDQDXD^D_D`DdDfDgDhDjDlDnDrDsDyDzD}EAEBECEE"},
  {0,NULL,"EOEREWEhEmEnEpEuEvEzE{E}FCFDFHFPFUF]FdFiFjFlFrFuFvG?GCGFGQGTGWG]G"},
  {0,NULL,"cGeGkGlGoGpGrH?HHHMHNHRHTHUHVH]H^H_HiHmHpHsHvH~ICIOIQITIUIWIdIoIp"},
  {0,NULL,"IqIuI{J@JGJIJJJOJRJSJ[J\\JcJhJoJtJuJwJzK?KHKLKRK[KaKdKlKmKnKpKsKvK"},
  {0,NULL,"yLILKLTLULVL^L_L`LaLfLhLlLqLvL|M@MCMEMJMKMMMbMkMlMoMqMsM~N@NDNGNK"},
  {0,NULL,"NLNTNXNZN_NaNiNkNtNuNvNxOAOEOLONOQOSOTO[OeOfOhOmOoOsO~PAPDPH_B?E?"},
  {0,NULL,"P?Q?S?T?V?a?e?k?v?w?y@@@B@G@H@M@P@U@X@]@_@`@m@r@s@u@{A?A@AAAEAHAI"},
  {0,NULL,"ALAQAUAZAiAjAkAuA~BABCBEBJBMBPBWBaBeBgBoBqBsBxBzB}B~CBCICNCXCZC[C"},
  {0,NULL,"\\CaCfCjCnCpCsCtDBDDDGDMDPDXDZD[D`DfDsDvDyEAEBEMERESETEVE\\EdEnEqEt"},
  {0,NULL,"EyE|FAFDFHFJFKFNFRFTF^FeFgFiFlFrFuGCGDGEGHGJGKGLGQGRGUG^GkGrGsGxH"},
  {0,NULL,"EHHHKHNH[H]H_HcHiHkH|ICIDILIYIZI]I_IcIdIfIjIkIlIoIpIqIsIzI{I}J@JA"},
  {0,NULL,"JCJJJPJ_JbJfJlJnJpJ{J}J~K@KGKJKQKYK^KgKjKoK~L?L@LCLGLHLJLPLTLWL[L"},
  {0,NULL,"]L`LcLfLmLrLtLuLzL}L~M?MGMHMJMUM[MjMmMrMxMzN?N@NANINNNTNYN\\N]NdNe"},
  {0,NULL,"NlNrNsNuNwODOFOHOOOSOUOVO^O_OaOiOkOlOpOyOzO}PBPCPEPIPL_B?F?O?R?S?"},
  {0,NULL,"T?U?a?b?j?v?w?y@B@F@G@L@M@P@T@Y@`@a@d@l@q@v@x@z@}A?AAAEAFAKAPARAS"},
  {0,NULL,"AaAgAlAnArB@BEBGBIBKBLBOBRB^B`BfBjBkBmBwBxByC@CCCFCRCYC`CbCcCfChC"},
  {0,NULL,"kCnCrCsCtD@DEDKDQDRDVDWD]DcDgDnDxDzECEGEHEIEPEQEZE]EcEnEqEtE|F@FB"},
  {0,NULL,"FDFGFKFLFNFRFWFXFeFgFiFkFqFwG@GCGEGHGIGLGMGPGQGYG^GkGqGrGwHEHGHNH"},
  {0,NULL,"PH[H`HcHgHjHkI?IBIEILIYI[I\\I_IaIcIdIeIkIlInIpIrIsIxIyI|J@JAJDJJJY"},
  {0,NULL,"J[JdJeJgJoJsJzJ}K?KDKHKOKSKZK]KlKnKsKwKzK|K}LCLDLKLMLVLZL[L\\L^LdL"},
  {0,NULL,"jLkLpLqLwLyL}L~M?MOMPMTM\\McMdMnMoM|M~NBNCNDNGNHNJNWNXNaNhNkNlNtNx"},
  {0,NULL,"N}OAOBOEOGOIOJOPOXOZO`ObOfOmOrOtOxO{O~P@PCPHPKPN_B?D?K?Q?R?U?V?b?"},
  {0,NULL,"e?i?v?w?y@@@F@H@L@N@T@U@X@Y@]@a@h@n@o@pA?AAABACAEAGAJATAVAYAbAdAe"},
  {0,NULL,"AfAsAyA{A}BDBGBMBTB[B]BbBiBlBnBrBsBvByCECKCMCQCVCcCdCgCiCjCmCnCsC"},
  {0,NULL,"tCuCvDCDHDIDSDTDYD\\D^DjDoDwD{EDEEEJEKEUEWEXE^EeEnEqEtEyF@FAFBFGFH"},
  {0,NULL,"FTFVFWFXF^FeFgFiFnFtFxF~GCGEGHGJGMGPGRGSGUGYGqGsGwGxHGHHHKHPH]H_H"},
  {0,NULL,"`HgHuH|I?IAIBICI\\I]I^I_IaIdIeIfIjIlInIoIqIrIwIxIyIzI{JCJDJEJ`JaJc"},
  {0,NULL,"JjJqJuJwJ{K?KAKKKRKUKWKcKfKpKtKuKvL@LALBLILKLNLRLVLYLaLbLcLgLnLoL"},
  {0,NULL,"sLxL{L}L~M?M@MAMBMVM]MeMpMqMsMtNENFNKNLNPNRN_N`NcNeNiNkNoN{N|O?O@"},
  {0,NULL,"OCOLONOQOROTO\\OcOnOoOqOsOvOwO}PAPDPFPJPMPN_B?D?K?Q?R?U?V?b?e?i?o?"},
  {0,NULL,"p?q@@@F@I@K@V@W@Z@^@_@`@d@h@n@o@pA?AAABACAEAGAJATAVAYAbAdAeAfApAv"},
  {0,NULL,"AwAxAyAzA{BTB[B]BbBmBpBrBsBwBzB{CDCJCLCOC\\C]CaCcCeChCiCnCuCwC|D@D"},
  {0,NULL,"DDSDVDWDYDZD[DhDmDtDwD{EBECEQESEWEXEZE\\EeEoEpEsEyF@FCFFFIFJFLFMFO"},
  {0,NULL,"FQFRFaFcFdFoFyF|F}G?GFGGGIGKGNGOGZG]G^GcGfGjGlG}H@HFHLHRHbHeHfHnH"},
  {0,NULL,"pHrIFIHIPIYIZI[I\\I]I`IbIdIhIiIkIlItIvIxI{J@JAJBJFJOJTJ`JaJcJkJrJv"},
  {0,NULL,"JwJyKAKCKKKRKUKWK_KaKbKhKzK{K~LALELJLKLMLOLPLSLbLcLdLfLkLoLqLsLzM"},
  {0,NULL,"?MAMEMHMKMOMYM_MiMpMqMzM|N?NDNENJNKNTN^NbNcNiNmNnNwNyN}N~OEOFOOOP"},
  {0,NULL,"OXOYO[O^OeOfOkOpOrOuOzO{O~PBPCPEPGPK_B?E?N?Q?R?V?X?_?c?m?s?v?z?|@"},
  {0,NULL,"?@I@L@O@P@Q@\\@^@`@c@k@s@v@y@{@|@~AAACAGAKANAPA[AcAkAnAoAsA}B@BFBG"},
  {0,NULL,"BHBKBRBUBVB\\BhBjBmBnBzB|B}C@CECGCTCWCXCYC]CaCbCgCnCqCvCwCzDBDMDOD"},
  {0,NULL,"TDUDWDZDeDiDlDwDxD}EDENEPEREXEYE\\EgEmEnErEuEzFBFCFNFOFPFRFUF[F]F_"},
  {0,NULL,"FbFeFnFqFsFwF{G@GBGLGNGXG[G\\G^G`GeGpGqGtGzG{HDHPHXHZH`HdHoHqHsIGI"},
  {0,NULL,"IIRIYIZI[I]I^IbIcIgIhIjImIoIrItIwIyI{I}JBJGJKJVJ[J\\JbJjJmJoJtJuJz"},
  {0,NULL,"K?KMKSKXK[K]KmKpKqKvKwKyK{K|K~LGLPLTLULZL_LaLdLfLhLjLoLtLvM?MBMCM"},
  {0,NULL,"GMKMMMXM`MlMnMqMsMyN@NDNFNQNTNUNWN`NgNhNjNkNpNqNtN|O?OBOGOJOQOWO\\"},
  {0,NULL,"O]ObOdOgOqOtOvOxOzPBPCPEPGPHPKPP_B?F?N?Q?R?U?Y?\\?^?m?r?x?y?~@E@H@"},
  {0,NULL,"K@M@Q@R@S@W@`@b@k@t@u@x@z@|AAABADAHAJAQAXA]A`AgAiAmAsA|B?BABDBJBM"},
  {0,NULL,"BPBQBZBcBgBhBkBlBmBpBqB~CPCQCUCWCZC_C`CaCdChCnCoCzC|DCDEDJDODQDWD"},
  {0,NULL,"XDYDaDpDuDyD{D~EEEIEUEYEZE[E\\EgEiElEtEvEwFAFFFIFKFRFSFUFYF\\FfFgFh"},
  {0,NULL,"FnFrFuFvFzGAGDGQGTGVG[G]G^G_GnGoGsGvGyG|HBHKHUHYH\\H_HlHmHtISIVIXI"},
  {0,NULL,"YIZI[I\\I^I`IaIeIgIiImIpIqIvIwIxIzI|JBJIJLJZJ]J_JeJjJnJqJ{J|J~KBKI"},
  {0,NULL,"KPKQKVKdKfKjKkKuKxKyKzK~LDLHLSLWLYL\\L_L`LdLfLhLlLqLxLyM?M@MCMEMIM"},
  {0,NULL,"TMWMfMkMmMpMtM{NANDNGNKNUNVNYNZN\\N_NeNfNrNsNvNzO@OCOHOKOMONOSOTOa"},
  {0,NULL,"OhOjOlOnOsOyO{O~PCPEPGPKPLPO_B?E?L?R?S?T?X?[?]?l?p?r?z@A@C@G@K@Q@"},
  {0,NULL,"X@Z@a@b@c@d@i@o@u@y@|@}@~A?A@AFAJAWAYA]A_AdAiAoAqAvAzA{A|BABDBNBS"},
  {0,NULL,"B]BcBhBlBnBsBvBwBxCICLCNCUCVC[C\\C]C_C`CbCqCrCxCzC}D@DHDODPDRDUDVD"},
  {0,NULL,"`DkDoDzD{E@EAEIELEOEPEVEXEfEiEmEpE{E}FDFFFGFHFLFQFSFUF]F_FcFfFmFr"},
  {0,NULL,"FuFyF|G?GDGIGOGPGRGVGXG[GdGiGlGvGyG}H?HJHQHUHbHhHuHvH{IAIMIOI^I_I"},
  {0,NULL,"bIcIeIfIjIkIlImInIoIsIvIyI{I|I~J?JEJQJXJ\\J_JcJiJnJqJvJwJyKBKLKPKW"},
  {0,NULL,"K\\K^KbKgKkKwKxK{L?LBLDLJLMLNLYL[L_LaLcLeLjLoLuLyL|MCMLMMMOMPMRMUM"},
  {0,NULL,"aMeMoMpMwMxNHNJNNNPNQNUN\\N^N_NcNfNnNoNuNvNwN~OCOKOROTOVO[O^OeOhOi"},
  {0,NULL,"OkOoOsOxO{O~P@PEPGPHPNPRPT_B?G?O?R?S?W?X?Z?c?j?s?v?z?|@D@G@L@P@R@"},
  {0,NULL,"T@V@Y@\\@`@l@n@r@t@z@{@}@~ACAIAJAMATAUAXAfAjAmAqAwA{A}BABCBMBWBZBb"},
  {0,NULL,"BdBoBpBrBsBtB{B|CCCICKCRCWCZC^C_CdCeCjCqCvC}D?DADBDJDNDRD[D\\D]DbD"},
  {0,NULL,"hDpDvD{D|E@EHEJELEMEQE[EcEmEnErEzF?FBFDFMFNFPFRFWFXF\\F_FbFeFmFqFw"},
  {0,NULL,"G@GCGEGHGLGMGTGYGZG^G`GdGeGqGrH?HDHNHPH[H`HdHhHlHoHrIGIPIVIYI[I\\I"},
  {0,NULL,"`IaIbIcIgIhIiIlImIrIsIyI|I~J@JBJGJIJOJ]JaJfJiJnJpJuJwJ{KCKKKNKVKY"},
  {0,NULL,"K^KcKlKnKuKxKyL@LELFLHLOLSLULXL]LbLcLeLkLlLpLrL{MBMGMLMMMNMQM_MbM"},
  {0,NULL,"fMpMrMvMwN?NBNHNMNRNVN\\N`NbNcNdNeNsNwNxN{N}OCOLOSOTOXOZO^O`OaOcOf"},
  {0,NULL,"OkOsO|O}PAPBPFPIPLPMPOPQ_B?F?O?R?S?T?U?a?b?j?o?p?q@B@F@J@K@N@S@V@"},
  {0,NULL,"\\@]@^@_@l@q@v@x@z@}A?AAAEAFAKAPARASAaAgAlAnAqAzA|BBBFBIBKBOBRB^B`"},
  {0,NULL,"BgBhBjBrByB|B}C?CHCPCUCVCZC^CfCgChClCtCuC}D@DADDDIDMDPDQD\\D]DaDdD"},
  {0,NULL,"iDxDzEAEEEHEKEMEPETEUEcEoEpEsE|F@FEFFFJFMFOFPFVFYF^FaFcFdFmFvFzF}"},
  {0,NULL,"GAGFGGGKGNGSGUGZG_G`GaGfGgGlG}HAHLHOHRHTHaHbHnHsHxIFIQIRIYIZI\\I]I"},
  {0,NULL,"^I_IdIgIhIiIjImIuIvIyIzI{J?J@JFJHJVJ[JdJeJiJmJoJvJxKBKDKHKOKSKZK`"},
  {0,NULL,"KdKiKkKvKzLBLCLFLHLLLTLULVLWLZL_LbLjLmLnLpLrLxL~MAMHMLMOMQMWM`MhM"},
  {0,NULL,"nMoMtMxN@NBNGNLNNNRNXN[N^NfNgNhNoNpNrNvN|ODOHOKOQOROUOWO_OdOhOlOo"},
  {0,NULL,"OvOwOyOzO|O}PDPIPM_B?D?L?R?S?U?W?^?`?l?q?s?u?}@E@J@L@M@O@U@W@[@c@"},
  {0,NULL,"d@i@p@s@w@z@~A?ABADAIAKANAOAZA^AeAhAkAqA}A~BBBCBFBHBVBYB_BaBiBkBn"},
  {0,NULL,"BpBuBwB}C?CACECKCXC[C`CaCcCjClCqCyC|D@DADEDGDNDQDUDVDYD_DjDsDvDxD"},
  {0,NULL,"|EEEIEKEOEQE\\E_EfEkErEsEvE~FBFEFIFKFLFTFZF[F]F`FaFbFmFsFtFxF{F~GB"},
  {0,NULL,"GIGJGQGWGXG\\G]GbGeGgGuG~HDHIHOHTHVH^HdHiHzH}IDIJITIZI`IaIdIeIfIiI"},
  {0,NULL,"jIkIlIoIpIrIuIzI|J?J@JBJPJRJWJ^J`JbJiJmJpJtJuJxK@KEKGKTKXKcKiKpKr"},
  {0,NULL,"K~L?L@LDLGLKLLLMLQLRLSLTL\\LaLfLiLkLnLyL|MEMMMOMQMSMTMVM^MjMnMrMtM"},
  {0,NULL,"vNGNINJNKNMNQN[N]N`NdNgNjNpNsNzN{O?ODOLOMOSOUOWO\\O_OaOcOdOjOqOxO{"},
  {0,NULL,"O~P?PCPHPJPKPS_B?G?P?Q?S?W?Y?\\?`?k?r?x?y?}?~@G@H@M@O@S@X@Z@]@`@m@"},
  {0,NULL,"n@q@y@z@{A@ABADAFAGASAVA_AcAfAlAoAtAzA{B@BDBGBIBNBTB\\B`BhBjBnBuBy"},
  {0,NULL,"B{B|CBCICMCRC]C_CcCeCiCkClCoCxCyC{DCDEDFDGDIDKDUD[DdDhDlDwDzD|E?E"},
  {0,NULL,"NEQETEVE^E_EdEiElEtEwE~FAFDFHFKFQFRFYF[F^FfFgFhFpFrFuGCGDGEGHGOGQ"},
  {0,NULL,"GRGUG\\G^G_GiGkGnGsHBHEHJHKHQH\\H_HcHnHqHtIFIIISIYIZI]I`IbIdIgIhIiI"},
  {0,NULL,"mIoIpIqIsIzI}J?JAJBJFJKJLJ\\JaJdJhJqJvJwJzK?KDKMKOKUK\\K^KnKoKtKxK{"},
  {0,NULL,"K}LALELKLLLOLQLULVLZL_LaLgLiLkLmLuLvM@MDMIMRMSMTMXM_MhMoMqMuMvN?N"},
  {0,NULL,"CNINLNONQNWNXN^N_NcNkNoNwN}O?OBODOJOROUOXO\\O^O_ObOfOkOoOqO~P?P@PA"},
  {0,NULL,"PDPHPJPNPPPQPU_B?F?M?Q?S?T?Y?]?d?n?t?u?w?{@C@H@J@O@R@Y@Z@[@^@a@j@"},
  {0,NULL,"p@t@v@|@}A@ADAEAGAIAMAOA[AbAeAmAnAuAxAyA}A~BFBMBUBYB[BdBjBlBoBpBr"},
  {0,NULL,"BwB{B~C?CHCQCYC_CaCbCgClCmCpCrCsCxCyC~DFDHDJDKDMDVDiDmDpDvDwD~EAE"},
  {0,NULL,"PEVEWE[E]E_EhEjEkEqExE}FAFEFGFOFQFXFZF[F\\F`FiFjFlFtFvFxFzF~GAGNGO"},
  {0,NULL,"GPGTGWGYG\\GhGmGuGxHCHHHIHMHSHVHWH]HoHpI@IGIHIWIYIZI[I\\I^IbIcIhIiI"},
  {0,NULL,"kImInIqIuI{I|I}I~JAJGJNJTJ[J]J`JlJmJrJuJ{K@KAKNKRKTK[K`KfKiKjKvKw"},
  {0,NULL,"KxK|K~LILLLMLOLSLYLZL]LbLiLjLlLsLuLwL}MFMJMPMRMSMYM`MfMqMrMxM{N@N"},
  {0,NULL,"CNJNONPNVN]N`NeNgNiNmNpNsN|N~OCOFOOOQOSOTOWO[OaOdOeOpOsOvOxO{P?P@"},
  {0,NULL,"PAPDPJPNPQPX_B?G?K?Q?R?X?Y?[?d?i?p?r?z?{@A@I@K@T@V@X@Z@[@_@d@h@q@"},
  {0,NULL,"r@w@|@}A@ABACAHAKALARA\\A^AhAjAlAsA|BBBEBHBJBKBOBXB_BeBfBjBkBoBtBv"},
  {0,NULL,"ByCDCGCJCPCXCZC[CjCkClCmCvCxCzC}C~DCDIDJDKDNDSDZD_DfDgDxDyD}D~EJE"},
  {0,NULL,"MENEWEZE_EeEiEmEpExE{FCFFFHFJFLFMFQFWFZF_FcFfFnFyF|F}G?GFGGGIGKGM"},
  {0,NULL,"GOGRGWGZGjGlGtGvGyGzG}HFHUHXHbHfHkHvH}ILIMITIYIaIbIcIdIfIiIkIlInI"},
  {0,NULL,"oIpItIvIxI{I|I}JBJJJQJWJ^JdJfJjJoJtJxJ}J~KBKEKFKJKZK_KdKhKqK}L?L@"},
  {0,NULL,"LGLHLILLLNLVLXLZL\\L]L^LiLqLrLsLvL{M@MBMCMFMLMRM[M\\M^MmMnMyM{NCNEN"},
  {0,NULL,"LNMNTNVNYN[NfNhNjNlNpNrNtNzOEOFOGOHOMOOOPOWOdOjOlOpOrOtOwO|P?P@PA"},
  {0,NULL,"PDPFPIPW_B?D?M?Q?S?V?W?Z?_?n?o?t?x@?@D@H@J@P@R@[@^@_@a@b@j@o@w@x@"},
  {0,NULL,"{@~ACADAEAFAHAWA\\A`AaAdAgAhAtA|B?BBBDBIBLBQBSBXB^BfBkBmBsBtByB}C?"},
  {0,NULL,"CACMCQCVCXC\\C]C^C`CdCoCwC{D?DBDDDHDLDMDNDWD[D_DnDoDyDzD|EDEHERESE"},
  {0,NULL,"XE[E_EhEjElEoEuF?FAFEFGFJFNFOFSFZF\\FdFhFjFpFtFvFxFzF~GAGKGLGNGPGT"},
  {0,NULL,"GVGWGaGhGmGnHAHBHCHMHSHWH\\HaHjHvHwIEIMINI[IaIbIcIdIeIhIjIkIlInIoI"},
  {0,NULL,"qIuIyI}I~JAJBJQJSJYJ^JcJeJhJqJsJxJ|KBKDKFKHKIKLKfKiKrKtKuK{LBLDLF"},
  {0,NULL,"LGLJLTLVLXL\\L^LcLdLiLlLoLpLtLzMDMGMHMIMKMNM^McMeMmMoMsMvN?N@NDNMN"},
  {0,NULL,"PNSNXNZN[N_NaNfNoNpNxNzOBOCOJOMOROTOWOZO`ObOdOjOoOsOyOzO|PBPCPEPL"},
  {0,NULL,"PMPTPW_B?F?N?Q?R?U?Y?\\?^?m?q?s?u?~@E@I@L@N@O@P@X@[@\\@c@k@t@u@x@z@"},
  {0,NULL,"|AAABADAHAJAQAXA]A`AgAiAmApAvAwB?BABCBLBPBQBZBcBgBiBoBqBxByB{C@CC"},
  {0,NULL,"COCTCVC\\C^C_C`CkCmCuCyC|C~DADCDFDIDJDPDTDWD`DnDrDyD{E?ECEHENEUEVE"},
  {0,NULL,"WEYEgEkErEsEvEwFBFCFHFNFPFVFZF[F]F`FaFbFoFqFsFwF{G@GBGLGRGSGWGXG\\"},
  {0,NULL,"G`GbGcGeGpG{G~H@HDHZH^HdHeHiHwH{IDINIOIZI_IcIdIeIhIjIkImInIoIpIrI"},
  {0,NULL,"tIwI{J?JAJBJPJSJXJ]J_JeJkJnJpJsJyJ|KCKIKPKQKVK]KaKlKmKxK}LBLDLFLI"},
  {0,NULL,"LJLOLRLVLWL[L]L`LhLpLsLuLvLxM@MAMEMFMQMSMUMZMcMmMpMuM|NDNFNLNNNON"},
  {0,NULL,"VNZN\\NaNbNdNnNqNuNwNxNyOBOJOVOYOZO]O^O`ObOgOiOkOuOwO}P?P@PAPDPFPM"},
  {0,NULL,"PV_B?E?N?Q?R?V?X?_?c?m?o?t?x?|@?@H@K@M@N@R@S@T@[@b@k@s@v@y@{@|@~A"},
  {0,NULL,"AACAGAKANAPA[AcAkAnAoApAxAzA~B@BFBIBRBUBVB\\BiBoBuBvBwB|B}B~CBCLCU"},
  {0,NULL,"CVCYCbCeCfCjCkCuCvCwC{C~D?DGDJDODSDTD]DcDkDsDwDxE@EBEJELENEUE\\E]E"},
  {0,NULL,"gEjElEoEuEzFAFFFKFSFVFWFYFZF\\FdFhFjFoFrFuFvFzGAGDGMGQGSGTGVGWG_Gf"},
  {0,NULL,"GhGnGoG|HBHLHMHRHSHYH\\HjHzH~IEIJIKI[I_I`IaIcIeIfIgIjIkIlIpIqIvIwI"},
  {0,NULL,"xI~J@JBJRJUJYJ[J\\JbJkJmJrJvJzK@KDKMKSKXK[KbKjKkKoKwK|K}L@LBLCLELM"},
  {0,NULL,"LNLQLRLTLUL]LeLfLvLwLxL{MAMBMDMFMKMNMaMdMjMnMqMwMzNBNENFNINUNVNWN"},
  {0,NULL,"XN]N^NgNmNsNvN}N~OAODOIOKOSOUOXO[O_OaOeOfOhOmOwO|PAPDPFPIPJPNPWPY"},
  {0,NULL,"PZ_B?G?K?Q?R?X?Y?[?d?i?t?u?w?{@A@H@L@Q@U@W@Y@]@^@a@h@q@r@w@|@}A@A"},
  {0,NULL,"BACAHAKALARA\\A^AhAjAlApA~BBBCBEBIBLBOBXB_BeBfBhBpBtBuBxBzCBCCCKCM"},
  {0,NULL,"CWC[C]C^CfChClCpCrCwCzC|C~DIDLDODRDYDZDbDdDqDxDyE?E@EJEOETEXEYEZE"},
  {0,NULL,"eEjEkEqExE{FAFBFGFIFOFTFUFXF^F`FiFjFoFtFxF~GCGEGHGJGNGPGUGYG[G]Gb"},
  {0,NULL,"GhGwGxG~HGHHHMHSH]H^HgHxHyI@IQIUIWI\\I]I^I_I`IbIfIgIhIiImInIqIrIwI"},
  {0,NULL,"xI{I~J?JHJMJNJ^JdJfJkJpJsJxJ}K@KDKEKFKJKZKcKlKoKtKyKzK{L?LCLFLLLP"},
  {0,NULL,"LQLSLXL[L^L_LhLmLoLqL{L|MCMEMFMJMKMPMbMgMhMmMnMuMwNHNKNLNSNTNUNXN"},
  {0,NULL,"[N]NaNdNlNoNuNxN{OAODOIOLOROUOVOZO_O`OcOiOmOoOxOyPCPEPGPHPKPLPOPP"},
  {0,NULL,"PXP\\_B?G?O?R?S?W?X?Z?c?j?o?t?x?|@D@J@K@M@N@S@^@_@a@c@l@n@r@t@z@{@"},
  {0,NULL,"}@~ACAIAJAMATAUAXAfAjAmArAwAxAyB?BJBMBWBZBbBdBkBnBoBqBxBzB{CDCHCP"},
  {0,NULL,"CSCWC[CbCcCdCiCmCqCrCwC{D?DEDFDQDRDUDZD\\D^DfDrDvD{D}EFEMEOEPEQEYE"},
  {0,NULL,"^EcEjElEoEzF?FEFFFGFJFKFOFVFYF]FdFhFjFkFvFzF}GAGFGGGKGNGPGQGSGXG_"},
  {0,NULL,"GaGfGmGoG|HAHCHLHRHWHYHaHwH|H~ICIKINI]I_IaIcIdIfIgIhIjInIoIpIuIvI"},
  {0,NULL,"wIyI}J?J@JCJSJUJ]JaJfJgJrJ{J|J~KAKCKKKNKVKYK_K`KdKeKuKwKyL?LALILK"},
  {0,NULL,"LOLPL[L\\L]L`LaLgLhLjLkLrL|MDMKMMMNMPMTMZM[M]MpMrMyM}NGNHNONQNRNTN"},
  {0,NULL,"YNZNbNeNiNmNqNrNyN|O@OFOHONOOOQOYO]OgOlOnOpOuOvOxO{O~P?PEPGPHPJPR"},
  {0,NULL,"PTPZ_B?E?L?R?S?T?X?[?]?l?t?u?w@A@C@J@L@O@R@U@V@W@[@]@i@o@u@y@|@}@"},
  {0,NULL,"~A?A@AFAJAWAYA]A_AdAiAoArAvAyB?BDBGBLBNBSB]BcBgBlBmBqBtBvB|C@CACE"},
  {0,NULL,"CSCZC\\C]CeCgCiCkCpCrCtC}C~D?DNDPDSDUDXD]DlDtDuDzD{D}EGEIEKELEMENE"},
  {0,NULL,"SEfEjEkEqE{E}FBFEFIFMFTFZF[F\\F^F`FiFjFkFsFtFxF{F~GBGJGTGUGWGZG\\G]"},
  {0,NULL,"GbGmGuGwG~HCHGHIHVHWH^HgHpHtHyIHISIUIYIZI[I]I^I`IbIfIgIiIkIpIrIuI"},
  {0,NULL,"xI|I}J?J@JLJMJTJ\\J_JcJgJqJsJyJ|K?KAKLKPKWK\\K]KeKpKrKvK{K}LALELHLJ"},
  {0,NULL,"LNLULWLXLYL`LdLeLnLrLvLyLzL~MFMJMLMNMPMXMiMkMoMpMyM~NANBNENMNNNQN"},
  {0,NULL,"ZN_NaNiNkNnNyNzO?O@OBOEOJOMONOPOYO\\ObOjOnOqOrOuOyOzO|O}PAPFPIPMPQ"},
  {0,NULL,"P\\P]_B?F?M?Q?S?T?Y?]?d?n?p?r?z?{@C@G@I@Q@T@U@V@_@b@c@j@p@t@v@|@}A"},
  {0,NULL,"@ADAEAGAIAMAOA[AbAeAmAnAtAwAxA{A}B@BHBUBYB[BdBfBiBpBqBwB|B}CFCOCR"},
  {0,NULL,"CTCWC\\CcCdCfCgCmCoCpCxCzC}DDDFDLDMDXDYD]DcDjDrDvDwE?EGEKESETEYE[E"},
  {0,NULL,"]EhEiEmEpExE}FCFDFJFMFSFTFUFWF]F_FcFfFpFqFwFyF|G?G@GJGKGMGVGXGZG["},
  {0,NULL,"GdGiGjGtGzH?HFHJHQHXHfHhHuH}H~IAIKITI^I_IaIdIeIfIgIiIjIkInIpIsItI"},
  {0,NULL,"xIzI}I~J?JEJUJWJ[J]J`JhJrJtJuJwJzKCKNKRKTK[KaKmKnKsKuKvKyLCLILJLK"},
  {0,NULL,"LMLRLSLTLUL^L`LhLlLmLnLwLzMCMHMIMJMLMRMVMZMdMqMrMuM~N@NANBNKNONSN"},
  {0,NULL,"WN`NbNcNjNmNqNyN{N}O?OAOIOLOXOYO\\O]OcOfOgOmOqOuOyOzO}PBPGPIPKPLPR"},
  {0,NULL,"PSPV_B?D?M?Q?S?V?W?Z?_?n?s?v?z@?@D@G@I@O@Q@S@T@V@Y@c@j@o@w@x@{@~A"},
  {0,NULL,"CADAEAFAHAWA\\A`AaAdAgAhAuAvA|BABEBKBLBQBSBXB^BgBkBlBmBuBvB{CFCJCN"},
  {0,NULL,"COCVCYC[C^ChCiClCqCsCvCyC{DBDFDGDHDLDQDSDaDqDtDyDzEBEFEOESEUE]E^E"},
  {0,NULL,"_EhEmEnErEuF?FCFDFMFUFWFXFYF[F]F_FbFeFlFqFwFyF|G?G@GMGXGYGZG[G\\G_"},
  {0,NULL,"GdGpGrGtGzG{H?HNHXHZH[HhHlHsHyIRIUIVIZI[I\\I]I^I`IaIfIgIhIiIjIsItI"},
  {0,NULL,"wIzI}I~J@JIJMJVJ^JcJeJlJnJoJsJyJ}KBKFKHKIKLKaKgKhKsKzK|L?LALBLFLL"},
  {0,NULL,"LNLOLQLWLYL\\LdLgLiLwLxLzL|L}MBMDMGMMMSMWMgMiMmMoMzM}NENGNINONPNSN"},
  {0,NULL,"\\NaNfNhNlNnNrNuNvNyOAOEOHOIOKOPOVOYOhOiOlOmOrOuOwO~P?P@PFPHPJPNPP"},
  {0,NULL,"PUP[P]_B?G?P?Q?S?W?Y?\\?`?k?q?s?u?}?~@I@J@N@P@U@W@\\@b@d@m@n@q@y@z@"},
  {0,NULL,"{A@ABADAFAGASAVA_AcAfAlAoAuAvAyAzBFBGBKBNBTB\\B`BfBhBnBqBrBsBvCGCH"},
  {0,NULL,"CJCSCXCbCdCeCfChCkCoCpCyC|DADBDKDLDODXD[D\\D^DgDkDwDzD~EFELERETEZE"},
  {0,NULL,"[E^EdEkErEsEwE~FCFEFIFLFNFPFSFTFVF`FaFbFlFsF{F}GBGFGGGIGJGLGSGVG]"},
  {0,NULL,"G`GcGgGpGuG{H@HIHOHTHVHZHeHzH{I?IBIJIOI\\I_I`IaIcIeIfIlImInIoIpItI"},
  {0,NULL,"uIwIzI|I~JAJDJRJXJ\\JaJdJlJmJoJvJyK?KAKMKOKUK\\K`KeKhKqKuKwKzK}LCLE"},
  {0,NULL,"LGLNL^L_L`LaLbLcLeLgLlLmLqLtMEMGMIMJMQMSM\\M]MaMoMqM{M}N?NANCNRNSN"},
  {0,NULL,"UN^NgNhNiNkNnNtNvN|N~O@OEOGOKONOPOQO[OeOhOnOrOtOvOyOzO|PBPGPKPLPM"},
  {0,NULL,"PRPSPWPa_B?E?P?Q?S?T?V?a?e?k?o?p?q@@@B@I@J@N@S@W@Y@Z@\\@d@m@r@s@u@"},
  {0,NULL,"{A?A@AAAEAHAIALAQAUAZAiAjAkAtAwB?BBBCBHBJBPBWBaBeBiBjBlBtBuBxBzCA"},
  {0,NULL,"CGCSCTCWCYCZC_C`CiCjCsCuCxC{D@DDDGDHDKDRDTDXDbDeDuDvDyEDEGEIEJERE"},
  {0,NULL,"VE]E^EdEoEpEsEyE|FCFEFIFLFPFQFVFXFYFaFcFdFpFsF{F}GBGFGGGIGOGSGYG]"},
  {0,NULL,"G_G`GaGcGgGjH@HAHFHOHTHaHeHfHmHrHxIPIQIXIYI[I\\I]I^I_I`IbIeIgIlImI"},
  {0,NULL,"tIuIxIyIzI~JAJHJOJZJ_JbJfJhJpJtJxJ|J~KCKGKJKQKYKeKmKqKrKxKyK|L@LA"},
  {0,NULL,"LDLHLPLQLRLXLYLZL[LgLtLuLwLyL{L}MAMDMHMOMRMbMkMlMmMrMsM~NANCNFNHN"},
  {0,NULL,"INPNYNZN[NbNdNjNqNtNxNzN{O@OGOLOMONOZO]O`OcOgOjOnOtOwOxO{P?P@PFPJ"},
  {0,NULL,"PNPXP[P]P`_B?D?L?R?S?U?W?^?`?l?r?x?y?}@E@G@K@Q@R@X@Z@\\@]@b@i@p@s@"},
  {0,NULL,"w@z@~A?ABADAIAKANAOAZA^AeAhAkArAxA~B@BEBHBJBVBYB_BaBfBgBiBrBtBuBz"},
  {0,NULL,"CDCFCLCNCXCYC^CaCeCgCmCoCtD?DADCDEDLDNDPDTDVD\\DeDmDqDvDxECEFEHEKE"},
  {0,NULL,"LEOEREWEfEiElEtEvE~FDFFFHFPFQFSFUF\\F^FfFgFhFkFrFuFyF|G?GDGOGRGTGU"},
  {0,NULL,"GVG[G`GiGkGoGvGyG|HEHJHQHUHYHcHmHqI@IIIWIXIZI[I\\I]I^I`IbIeIhImInI"},
  {0,NULL,"oIsIvIwIyI|J?JAJKJNJZJ^J`JbJgJrJtJzJ}J~K@KEKGKTKXK_KbKgKsKvK|K~LE"},
  {0,NULL,"LFLGLILPLQLRLWLXL^LbLeLnLpLsLtL|L~M@MIMNMQMTMYMgMlMnMrM|M}NFNJNMN"},
  {0,NULL,"NNRNSNWNYN]NjNlNmNqNtNuN~OAOFOGOIOOOVO[O]OeOgOiOmOpOtOwO|O}PBPDPI"},
  {0,NULL,"PLPMPOP[P^Pb_B?E?L?R?S?T?X?[?]?j?v?w?z?|?~@?@@@B@G@L@O@P@X@`@l@r@"},
  {0,NULL,"t@u@{AAAIAJAQATAUAVAYAZA\\AjAkAnAqA}A~BABCBEBMBOBRBWBdBoBpBsB{B~CC"},
  {0,NULL,"CICJCKCMCRCXCZC^CaCeCjClCnCoCyD?DBDDDGDLDWDXD[D\\D`DkDoDvDxE@EAEME"},
  {0,NULL,"SETEZE[E_EfEjEkEqE{E}FBFEFIFMFTFZF[F\\F^FcFdFjFkFqFsFxG?GBGGGSGVG]"},
  {0,NULL,"G_GaGmGqGwGzG~H@HEHGHJHKHUHVHWHYHZH\\HfHjHlHpHqHvHwIKILIOIPIRISIZI"},
  {0,NULL,"`IiIuIvIxI}JCJDJEJFJMJZJ[J\\JdJgJqJtJuJxJ|K?KHKIKLKMKRKSKXK]K`KeKl"},
  {0,NULL,"K~LALILJLNLQL^LdLeLgLqM?MDMLMVMWMXMYM^M_MfMgMhMiMjMkMnMoMuMyMzM{M"},
  {0,NULL,"~NDNNNONXN[N]N^NgNmNpNqNtNxN{N|ONOOOQOTO[O]O`ObOiOmOoOtOxO{O~P@PE"},
  {0,NULL,"PGPHPNPPPSPUPXPZP_P`Pe_B?G?O?R?S?W?X?Z?c?l?s?t?u?{?}?~@@@A@J@L@N@"},
  {0,NULL,"U@W@Y@i@r@s@wA@ABAIAKALAMAOARA^A`AbAhAlAoAqA~BBBCBFBIBLBNBSBVB_Bi"},
  {0,NULL,"BpBuB}C?CACBCECKCOCQCVC[C`CcCfChClCnCpCuCzC|DEDIDVDWDXDYDZDbDhDpD"},
  {0,NULL,"xDzD|E@EOESEUEXEYE\\EcEjElEoEzF?FEFFFGFJFKFOFVFYF]F_FfFhFkFsFwFyF}"},
  {0,NULL,"GAGGGKGOGRG^GmGoGuGvG{HAHCHFHGHHHPHRHXHYH[H_HcHeHiHlHmHtH~I?ICIII"},
  {0,NULL,"OIPITIUI_IdIjIsIvIwI}JEJGJJJNJSJTJ\\JaJcJgJmJoJ{J~KAKBKOKPKQKUKVK["},
  {0,NULL,"K\\K_KbKeKrKyK|LCLILOLVL`LdLkLsLzM@MJMMMUMVMWMZM[M]M`McMdMeMhMjMoM"},
  {0,NULL,"pMsMuMyMzM}NANFNHNWNXN^N_NcNfNpNtNvNzN~OEOGOIOOOSOXO[O`ObOjOnOrOs"},
  {0,NULL,"O|O}PAPBPFPIPLPMPVPWP[P\\P^PaPdPf_B?E?N?Q?R?V?X?_?c?i?o?p?z?}@@@A@"},
  {0,NULL,"B@C@I@K@Z@\\@b@d@h@n@o@yA?A@AGAJAOAYA[A]A_AaAbAdAiAjApAvAwAzA{A|BA"},
  {0,NULL,"BXB]BbBeBrBsBwB{C?CDCFCICJCLCOC\\C]C^C_C`CaChCnCrCxD@DADEDKDPDQDUD"},
  {0,NULL,"VDYDcDkDsDyD{E@EBEHEOEPEQEXE_EgEmEnErEuEzFBFCFNFOFPFRFUF[F]FeFiFj"},
  {0,NULL,"FnFtFzF{G@GBGFGJGQGUG\\GjGqGtGwGyGzG{G|HAHIHJHTHWH\\H_H`HcHdHjHkHmH"},
  {0,NULL,"nHoI?ICIHIIIJIMIQIZIhImIqIrIyI}JEJLJNJUJVJWJ^JbJfJjJsJtJzJ|K?KCKG"},
  {0,NULL,"KJKNKOKQKSKZKcKhKpKqKuKvKwKxLTLWLZL\\LfLiLnL~MKMRMUMWMXMYMZM_M`McM"},
  {0,NULL,"fMgMhMlMmMnMsMvMxMyM}NCNRNUN\\N]NaNdNeNlNxNyNzN{O@OEOLONOSOTOXO\\Oh"},
  {0,NULL,"OjOlOmOrOtOwO|PAPDPFPIPJPNPQPVP[P]P^PaPcPe_B?E?L?R?S?T?X?[?]?j?v?"},
  {0,NULL,"w?z?|?~@?@@@B@G@L@O@P@X@`@l@q@v@y@{AAAFAKANAPAWA`AaAbAcAjAkAnArA}"},
  {0,NULL,"B@BEBGBHBKBOBRBWBdBfBjBmByC@CCCFCGCOCQCRCXCYC`CaCbCcCmCnCwC|D@DBD"},
  {0,NULL,"CDODQDTDWDYD[DlDtDuDvDxD}EGEPEWEXEYEZE[EfEiEmEpE{E}FDFFFGFHFLFQFS"},
  {0,NULL,"FUF]FcFdFjFmFrFuFvFxG?GCGSGVG]G_GdGfGlGrG{G~H?HBHDHHHJHSHTHUHVH_H"},
  {0,NULL,"bHeHiHnHpHrHvI?ICIEIGIOIQISIeInIoIuIvI{I~JEJIJMJRJSJVJ]J_JfJiJnJr"},
  {0,NULL,"JvJyJ}K@KFKGKKKQKUKWKYK^KdKkKnK{LBLGLLLRLSLYLcLlLxLyMAMGMPMUMVMYM"},
  {0,NULL,"ZM\\M]M^MaMcMeMgMlMpMrMsMuMwMxM{N?NLNQNYNZN[NbNjNmNrNsN}OAODOFOHOK"},
  {0,NULL,"OMOPOUOWOaOcOfOkOqOuOyOzO|O}PAPFPIPMPOPVPWP[P^PaPbPf_B?G?P?Q?S?W?"},
  {0,NULL,"Y?\\?`?n?r?s?z?{?|@A@D@F@G@I@T@V@`@d@j@q@w@x@}ACAFAHALANARAWAYA\\A_"},
  {0,NULL,"AhAjAmAuA|BABEBHBJBKBQBXBYBdBgBkBmBvCECFCJCLCNCOCPCYCZC[CaCiCjClC"},
  {0,NULL,"nCuCvC{C}C~DHDIDSDTDZD]D^DgDkDvDyD~EFEKENEUEWE\\E_EdEiElEtEwE~FAFD"},
  {0,NULL,"FHFKFQFRFYF[F^F`FhFjFpFuFxG@GBGCGHGNGPGSGUGdGhGiGnG}H@HDHEHFHGHJH"},
  {0,NULL,"RHTH\\H^H_H`HaHjHrHsHtHzH~IBIFIGINITIUIYIZI]IqIuJ?JBJEJHJKJQJTJXJ]"},
  {0,NULL,"J`JaJhJnJpJvJwK@KDKKKMKNKPKSKYK[KfKnKsKtK{K}LDLHLPLRLULaLgLnLoMKM"},
  {0,NULL,"LMSMUMWMXMYM[M_M`MhMiMjMkMlMqMrMtMuMvMyM|NBNCNDNYNZN]NeNiNmNsNuNx"},
  {0,NULL,"N{OAOCOKOMONOROTOZOcOeOfOgOmOtOyOzO|PBPGPKPLPMPOPTPVP\\P_PbPdPfPj_"},
  {0,NULL,"B?D?L?R?S?U?W?^?`?j?o?q?x?{@?@@@D@F@J@K@Z@[@^@_@l@n@p@tACAEAIAJAL"},
  {0,NULL,"ATAUAYAZAbAcAdAfAgArAvAwAxAyAzB?BZB^B`BbBoBqBzB{CBCDCGCHCOCPCSC[C"},
  {0,NULL,"\\C]CbCcCiCkCnCqCwCzC~DDDMDODRDSDYDZDeDmDqDzD{ECEFENEQETEYEZE\\EfEk"},
  {0,NULL,"ErEsEvE~FBFEFIFKFLFTFZF[F]FbFeFgFmFtFzF{F~GDGEGJGMGYG[GaGeGgGqGyG"},
  {0,NULL,"}HBHFHHHIHOHQHSHXH^H_HdHhHiHoHqHsHvH~ICIEIFITIVIWIfIkIpIrIsIzJBJE"},
  {0,NULL,"JHJJJOJRJZJ^JdJeJiJqJtJuJxJ|K?KFKHKLKQKSKXK[K`KcKiKlKxK~L@LJLNLQL"},
  {0,NULL,"TL_LmL{L|MBMHMTMUMVMXMZM[M\\M^MaMdMiMjMkMnMoMtMuMvMzM{N@NJNVN\\NaNh"},
  {0,NULL,"NkNlNnNoNxN|O@OBOCOLOTOVOZO]O^OdOeOhOoOtOvOwO|O}PBPDPIPLPMPQPVPWP"},
  {0,NULL,"\\P]PaPdPfPi_B?E?P?Q?S?T?V?a?e?n?o?t?w?|@?@A@C@E@H@J@M@R@W@[@j@p@s"},
  {0,NULL,"@v@|@~AGAIAMANARAUAXA[AcAdAnAoAuAxAyAzA~BFBIBSBUB[B^BoBpBrBwB~C?C"},
  {0,NULL,"CCHCLCPCQCYC_CbCeChCkClCvCxC|C~D?DCDFDIDJDNDODTD`DfDsDwDzEAEBEHEJ"},
  {0,NULL,"EUEWEZE]EdEoEpEsEyE|FCFEFIFLFPFQFVFXFYF_FcFeFpFsFwF{F}F~GEGRGXG[G"},
  {0,NULL,"`GaGjGmGtG|HAHBHDHGHKHOHQHUH^H`HcHeHfHkHrHtHvH}I@IAIDIEIGIUIXI\\I`"},
  {0,NULL,"ImIsItIxIyJCJHJIJKJSJUJ_JcJeJhJoJtJ|J~K?KAKEKFKJKKKLKPK\\KaKiKmKrK"},
  {0,NULL,"yL@LELKLVLXL[L_LhLpLuL}MCMNMWMYM\\M]M_MaMbMfMgMhMkMlMmMoMsMtMwM|M~"},
  {0,NULL,"NINKNMN\\N^NcNfNhNnNpNyN|O?OBOEOOOXOYO\\O]O^O_ObOdOjOlOoOyOzO}PBPCP"},
  {0,NULL,"EPIPLPOPRPSPWP\\PaPbPdPhPl_B?F?O?R?S?T?U?a?b?l?p?r?y?{?~@?@C@E@G@K"},
  {0,NULL,"@Q@S@T@b@i@p@s@v@|ADAIAKAMAOARAVA[A\\A^AeAiAmArAwAxA{B@BHBJBYB]BaB"},
  {0,NULL,"cBfBiBuBzCDCFCJCLCMCNCTCWC^CdCeCgCiCmCoCpCzC{DADBDFDLDMDNDOD[DcDg"},
  {0,NULL,"DnDvD{ECEGEKERESETEXE^EcEoEpEsE|F@FEFFFJFMFOFPFVFYF^F`FaFiFmFuFvF"},
  {0,NULL,"zF~GFGHGLGNGWG\\GgGlGuGvGzG}H?HKHLHMHNHTHZH\\H]H`HaHdHlHqHxHzH{I?IA"},
  {0,NULL,"IDIEIRISIWI]IgIhIrIuIzI{JFJGJJJMJQJWJ_JcJeJiJmJoJ{J~KAKBKIKJKMKOK"},
  {0,NULL,"PKVK\\KbKiKkKrKyL@LCLLLOLVL_LcLiLoLpL~MCMSMWMXMZM[M]M_M`MbMgMhMiMl"},
  {0,NULL,"MoMpMsMtMuMxMzNBNINUNZNaNbNdNiNnNsNzN~O@OCOFOGOLOMOSOWOZOeOfOhOkO"},
  {0,NULL,"rOsOxO{O~P@PCPHPKPNPPPRPTPUPXPZP`Pe_B?D?K?Q?R?U?V?b?e?m?q?s?v?}@?"},
  {0,NULL,"@C@D@E@I@L@O@U@V@c@k@p@s@v@~ADAGAKANAOAUAVA^A_AcAgAhAkAsA}BBBCBFB"},
  {0,NULL,"HBKBPBQBRBVBjBnB|B}C?C@CECGCICSCTCWCXCZC[C]CaClCqCrCwCyC}DEDFDNDO"},
  {0,NULL,"DRDUDVD^DjDoDxDyEDEEEIEMEPEQEVE\\EeEoEpEsEyF@FCFFFIFJFLFMFOFQFRFdF"},
  {0,NULL,"gFhFoFuFwFyG?GCGGGOGPGTGVGcGfGoGpG~H@HFHGHIHJHNHRHSHWH]HbHcHhHnHo"},
  {0,NULL,"HwHyH|H~IAIDIEIHIIIVIYIbIiIqIvJ@JAJDJLJNJOJRJXJ_JcJeJkJoJrJyJ}J~K"},
  {0,NULL,"AKFKIKKKLKNKOKVKaKbKkKmLCLELKLLLOLXL[LcLeLoLuM?MNMSMXMYM[M\\M^M_M`"},
  {0,NULL,"MbMfMhMiMkMmMpMvMxMzM|M~NBNKNONXNYNZN[N_NfNqNrNtNuNvOAOIOKOQOROUO"},
  {0,NULL,"[O`OcOgOiOnOuOwO}PAPDPFPJPMPNPQPWP[P]P^PcPePfPhPj_B?F?O?R?S?T?U?a"},
  {0,NULL,"?b?l?p?r?y?{?~@?@C@E@G@K@Q@S@T@b@i@o@u@x@|ADAFAJALASAXA]A_A`AcAeA"},
  {0,NULL,"iAmAqA{A|BABDBJBMBYB]BaBcBhBlBsBvCBCGCICLCNCQCUCWC[C_C`CbCdCjCoCr"},
  {0,NULL,"CvCwCzC|DJDLDODUDWDZDaDdDiDvD{EAEEEIEJEREXEZE\\EcEnEqEtE|F@FBFDFGF"},
  {0,NULL,"KFLFNFRFWFXF`FaFiFkFqF|G@GBGFGHGLGNGWG\\GbGiGkGwG{G|HBHEHFHLHNHSHW"},
  {0,NULL,"HXH`HaHeHgHvHxHyH~I?I@IEIHIOIRITIXIaIcIlIrIuIxJAJFJJJKJLJRJSJ[J`J"},
  {0,NULL,"bJgJpJsJwJzKCKDKEKFKNKTKUKZK[K]KgKpKsKuKzK}LALPLZL]L^LjLtLvMFMIMO"},
  {0,NULL,"M[M\\M]M^M_MaMbMcMdMeMfMjMnMrMsMzM{M|M~NENGNSN]N`NdNeNgNiNqNuNwNyN"},
  {0,NULL,"{O?OJONOQOROYO\\O_OgOiOlOmOpOwOyOzO|O}PDPIPMPOPQPVPWP]PaPbPfPiPk_B"},
  {0,NULL,"?D?L?R?S?U?W?^?`?j?o?q?x?{@?@@@D@F@J@K@Z@[@^@_@l@q@w@xACAEAFAKANA"},
  {0,NULL,"PAQAWA[A\\AaAdAfAgAqAzA|B?BBBDBIBZB^B`BbBhBjByB}B~C?CHCMCPCTCUCVCZ"},
  {0,NULL,"C\\C]C^C_CgCpCtCwCxDBDDDHDLDMDXDZD]D_DjDsDzD{D|EEEHERETEVEYE[EfEiE"},
  {0,NULL,"lEtEvE~FDFFFHFPFQFSFUF\\F^FbFeFgFkFyF{F|F}G@GDGJGMGYG[GfGkGoGrGyGz"},
  {0,NULL,"G|H@HCHIHMHQHZH]H^HcHfHgHiHkHpHqHxH|IBINIPIRITIWI^IbImIrIsIwJAJGJ"},
  {0,NULL,"MJRJUJYJZJ]J`JaJgJnJrJvJyJ}K@KGKJKKKMKRKWKYK_KdKnKsK{K|K}LGLPLRLY"},
  {0,NULL,"L`LhLnLwL}MKMQMUMXMYM`MaMbMeMfMgMhMkMlMpMrMsMuM{M|M}NCNMNTN\\N_N`N"},
  {0,NULL,"cNeNkNrNvNwNyN}OEOIOJOPOUOXO\\OaOjOlOnOpOuOxO{O~P?PCPHPJPKPPPRPTPU"},
  {0,NULL,"PXPYP`Pc_B?G?P?Q?S?W?Y?\\?`?n?r?s?z?{?|@A@D@F@G@I@T@V@`@d@j@n@p@t@"},
  {0,NULL,"}ACAGAIAMAPATAUA[A]AcAhAjAmAtAwA{A}BABCBHBQBXBYBdBiBpBwB|C@CFCKCO"},
  {0,NULL,"CRCTCUCWCZC\\C`CdCfCjCpCtCvC}D?D@DMDPDRDSD\\D]DdDhDlDvDyD|E?EHEIEKE"},
  {0,NULL,"LEUE[EdEkErEsEwE~FCFEFIFLFNFPFSFTFVF`FhFjFlFuFzG?GBGFGGGNGPGSGUGm"},
  {0,NULL,"GpGtGuGyG{H@HEHLHNHPHTHVHYH]H_HbHgHkHpHtHuHyHzIBIFIKIMIVIWI_IeIlI"},
  {0,NULL,"qIuIwI|JCJGJKJVJXJYJ^JdJeJlJoJtJ|J~K?KAKFKJKLKWKXKZK\\K`KaKhKiKwK~"},
  {0,NULL,"L@LELNLWL[L_LjLmLxMBMIMPMUMVM\\M]MaMbMcMdMeMjMkMlMmMoMtMwM{M|M}N?N"},
  {0,NULL,"ENJNXNZN[N]NaNdNpNqNrNyNzOFOOOQOSOUOWO\\ObOiOkOlOrOuO~P?P@PAPDPHPJ"},
  {0,NULL,"PNPXPYPZP[P]P`PcPePgPiPnPo_B?F?M?Q?S?T?Y?]?d?k?p?q?u?|?~@B@E@F@I@"},
  {0,NULL,"J@N@\\@^@c@m@q@v@y@zAAAFAGAPASATAVA^AaAbAgAiAlAuAvAzA|BBBFBKBNBPB`"},
  {0,NULL,"BeBhBnBrBvCDCGCHCJCKCSCUCVCXC[C^CdCfChCoCqCtCuD?DADNDQDTD[D\\D]DiD"},
  {0,NULL,"mDpDyDzD~EAEJEKELEMEOETEhEiEmEpExE}FCFDFJFMFSFTFUFWF]FfFgFiFpFtFw"},
  {0,NULL,"FyF{G@GCGMGQGTG^GcGiGjGkGzG~HAHCHFHLHPHQHSHYH\\HdHgHhHmHqHuHwHzI@I"},
  {0,NULL,"BIDIGIKIQISIaIfIjIqIsIxJ?JCJFJOJTJWJYJ]J_JfJhJrJsJyJzJ}KCKGKIKQKT"},
  {0,NULL,"KVKWKXK^KmKnKqKvK{LBLKLRLSLXL\\LkLlL{MAMJMTMVMWMZM[M]M^MaMdMeMgMiM"},
  {0,NULL,"jMmMrMtMuMwMyM~N@NFNQNYN\\N_NeNfNlNtNuNwNxOBOEOJOROTOXO[O^O`OdOgOj"},
  {0,NULL,"OpOtOxO{P?P@PAPDPJPNPPPUPYPZP[P]PcPePiPoPq_B?G?K?Q?R?X?Y?[?d?m?r?"},
  {0,NULL,"t?x?|?}?~@B@D@H@K@M@S@]@_@k@r@t@u@z@{AHAJAOATAUAXA\\A`AaAfAmAoAsAx"},
  {0,NULL,"AyB?BDBJBMBUBZB\\BcBgBkBlBqB~C?CFCPCQCSCUCWCaCcCdCgChCiCqCtC{C|D@D"},
  {0,NULL,"EDGDQDRDVDWD\\D_DfDgDwD{D}D~EIEKEOEPEYE]EeEjEkEqExE{FAFBFGFIFOFTFU"},
  {0,NULL,"FXF^F_F`FbFoFqF|F~GDGEGHGIGLGYG`GbGeGhGnG}HAHHHJHLHMHNHTH^HcHeHfH"},
  {0,NULL,"gHhHiHmHnHyHzH}IIIKILIOIQIVI\\I]I^IrItI~J?JNJOJQJSJVJYJ[J\\JdJkJpJq"},
  {0,NULL,"JuJwJxKDKEKGKLKMKOKUKXK]KjKlKoL?LALFLJLMLQL^LbLpLqLwMCMDMQMVMWMYM"},
  {0,NULL,"]M`MbMeMgMhMiMkMlMnMqMuMwMxM}M~NINNNTN`NgNhNiNkNnNsNwN}O?OBOCOJOM"},
  {0,NULL,"OPOYOZO^O_OaOdOeOfOpOwO|P?P@PAPDPFPIPQPVPYPZP[P]P^PaPlPp_B?D?M?Q?"},
  {0,NULL,"S?V?W?Z?_?k?v?x?y?}@@@A@E@F@G@H@Q@X@]@a@m@n@o@yA?ABAFAGARASAVAXAY"},
  {0,NULL,"AaAbAeAfAkAtA{A}B@BDBGBMBTBWB\\BaBhBnByB|CBCCCECICMCPCRCWC_CcCgCiC"},
  {0,NULL,"lCmCtCuCyCzC~DCDIDJDKDPDSDYD_DnDoDvDwD|EDEJEMENEUEYE^EhEmEnErEuF?"},
  {0,NULL,"FCFDFMFUFWFXFYF[F]FaFbFdFlFqFrFvF|G?GFGIGWGZG]GcGkGpGrG|G}H?HGHHH"},
  {0,NULL,"MHNHRHUHVHWHXHZH^HiHsHtHwH{I@ICIFIJIMIUIXI^IgIiItIuIwJ@JDJHJIJJJT"},
  {0,NULL,"JYJ^JbJfJlJrJsJyJzJ}KCKEKGKIKPKQKSKTK^KgKhKqKvKwKzLBLSLWL\\L]LiLqL"},
  {0,NULL,"rL~MDMEMVMWMXMZM`MbMdMfMgMhMiMkMmMrMtMwMyMzM}NNNPNUN[N`NbNdNgNjNq"},
  {0,NULL,"NtNwN}N~OFOGOJOPOQOWO[O`OaOiOkOpOsOyOzO|PBPCPEPLPMPOPRPSPVP\\PbPdP"},
  {0,NULL,"fPjPp_B?D?K?Q?R?U?V?b?e?m?q?s?v?}@?@C@D@E@I@L@O@U@V@c@k@o@u@x@~AD"},
  {0,NULL,"AHAJAMASATAWAXA\\A`AgAhAkApAvBABCBEBKBLBPBQBRBVBgBqBxB{C@CCCHCNCOC"},
  {0,NULL,"RCTCVC[C^CfCkClCmCpCqCxCyC{DCDFDHDJDKDLDUDhDmDtDxDyEBECEPETEUEVE]"},
  {0,NULL,"E^EeEnEqEtEyF@FAFBFGFHFTFVFWFXF^FdFgFhFnFtFxGAGBGCGGGOGPGTGVGeGnG"},
  {0,NULL,"qGsGzH?HCHFHGHOHPHQHUHVH]H_HaHbHnHqHtH{H|H}IAIHIJINIRIXI_IfInIqIv"},
  {0,NULL,"IyIzJDJGJIJOJQJUJ[J`JbJjJpJqJuJwJxKDKEKMKTKUKXKYK\\K]KfKjKpKuL?LAL"},
  {0,NULL,"HLZL^LaLbLjLlLsMAMIMMMUMVMZM[M\\M]MaMbMdMeMgMhMnMqMsMtMxM}M~NANENQ"},
  {0,NULL,"NWNXNYN]NlNmNpNsNxNzOBODOHOMOOOSOTO^ObOdOfOqOrOtOzO{O~PBPCPEPGPKP"},
  {0,NULL,"OPPPRPSPTPXP\\P_PgPk_B?F?N?Q?R?U?Y?\\?^?i?u?w?y?{@B@C@D@F@H@L@P@R@Y"},
  {0,NULL,"@a@h@q@w@x@}AEAHAKALAPAQARAUA_AaAeAlAnApA~B@BEBGBIBLBOBTB[B_BfBtB"},
  {0,NULL,"uBxCBCCCFCICKCMCSCWCYC]CbCeCfChCqCrCsCzD?D@DHDQDRDUDZD]D`DnDrDwDx"},
  {0,NULL,"E?ECEIELEOEQEZE^EgEiElEtEvEwFAFFFIFKFRFSFUFYF\\FaFcFfFnFrFsFvFxF}G"},
  {0,NULL,"AGKGXGZG_GlGsGvGxHAHBHDHIHKHNHPHTHUHWHXHYHZHhHmHoHuHvHyH{IBIHINIQ"},
  {0,NULL,"ITIVI[I`IgItIvIzI|JCJJJLJOJPJVJ]J`JaJjJmJnJvJ{K@KBKGKLKNKPKRKWK[K"},
  {0,NULL,"_KdKfKtK|LDLGLHLULYL`LaLgLhLrL}MEMLMWMXM_MaMbMdMfMgMiMjMkMlMpMqMt"},
  {0,NULL,"MvM{M}M~NDNMNPNWN^NbNcNjNmNoNpN|N~ODOFOGOHOOOVOWO]ObOkOoOqOsOvOwO"},
  {0,NULL,"}P?P@PAPDPFPMPQPWPYPZP[P]P^PfPhPj_B?E?N?Q?R?V?X?_?c?i?o?p?z?}@@@A"},
  {0,NULL,"@B@C@I@K@Z@\\@b@d@h@r@s@wA?A@AHAKALAMAPAQARASAZAdAiAjAsAwA|B?BBBHB"},
  {0,NULL,"JBXB]BbBeBfBjBkBtCACDCGCHCJCPCRCZC_C`CdCjCkCmCoCsCxCyC~D@DFDGDIDK"},
  {0,NULL,"DVDXDeDiDlDyD{D}EDEJEQE[E]E^E_EgEjElEoEuEzFAFFFKFSFVFWFYFZF\\FeFiF"},
  {0,NULL,"jFoFuFyFzG@GDGHGJGQGUG\\GfGhGlGxG{G|H?H@HEHLHOHQHSHVH[H\\H^HdHjHoHp"},
  {0,NULL,"H{H}I@IAIIIJILIPIUIaIeIpIqIrI~J@JDJFJHJPJUJVJ\\JaJcJkJmJnJvJ{K@KBK"},
  {0,NULL,"HKPKRKTKWK[K\\K_KbKoKtK|LCLDLFLMLOLUL`LkLmLvMBMJMOMVMWMZM\\M]M^MaMc"},
  {0,NULL,"MdMfMjMkMpMqMvMwMzM}M~NFNJNSNZN_NaNeNiNkNoNrNuNwOCOFOJOROUOVOWOZO"},
  {0,NULL,"eOgOkOpOuOvOxOzPBPCPEPGPHPKPOPRPSPTPUP\\P_P`PkPnPq_B?G?K?Q?R?X?Y?["},
  {0,NULL,"?d?m?r?t?x?|?}?~@B@D@H@K@M@S@]@_@k@q@v@y@z@{AGAKANASAVAWAZA^AcAfA"},
  {0,NULL,"mAoApAxAzA{B@BDBIBUBZB\\BcBuBwB|B}B~CACBCLCNCRCUCVC\\CcCeCiCjCkCsCv"},
  {0,NULL,"CyC{DDDEDGDHDKDQDTD[DbDdDqDwD{E?E@EIENESEVE]E_EeEiEmEpExE{FCFFFHF"},
  {0,NULL,"JFLFMFQFWFZF_F`FbFnFvF{F|F}F~GFGIGLGYG`GoGpGtGvGyG}HCHEHHHKHOHVHX"},
  {0,NULL,"H[H`HaHfHgHjHlHsHyH|H}IGIJILINIQISIdIkIlIrItI|I}JDJKJNJPJQJZJ]J_J"},
  {0,NULL,"fJjJoJrJyJ}J~KAKFKHKIKKKTKVKYKdKkKmKqKvLGLKLLLXLYL\\LcLtLyL{MFMGMT"},
  {0,NULL,"MUMVMYM[M\\M^M_McMdMeMiMjMmMpMvMxMyM{M~N@NGNLN\\N`NbNcNdNnNqNvNyN|N"},
  {0,NULL,"~O@OGOIOLOQO\\O]OhOiOlOnOoOsOxOyPCPEPGPHPKPLPRPSPTPUP_P`PbPdPmPnPq"},
  {0,NULL,"Pu_B?G?O?R?S?W?X?Z?c?l?s?t?u?{?}?~@@@A@J@L@N@U@W@Y@i@n@o@yA@ABAFA"},
  {0,NULL,"JAQASAVAXA[A]A_AhAlAoArAvAyBFBGBKBLBNBSBVB_BlBmBqBvB~C@CACECJCSCT"},
  {0,NULL,"CYCZCeCfCgChCkCoCpCsC|C}DDDKDMDPDXDYD[D^DfDrDxDzD}EFELERESE[E\\E]E"},
  {0,NULL,"cEmEnErEzF?FBFDFMFNFPFRFWFXF\\F_FfFhFmFrFtFwGAGCGEGKGOGRG^GbGdGeGi"},
  {0,NULL,"H@HAHDHKHMHOHPHRH[H\\H]HbHfHhHlHpHuHxH}H~ICIJIMIPISIWIYI[I\\IsIvI~J"},
  {0,NULL,"BJFJGJPJSJXJZJ^JbJfJiJpJsJwJzKCKDKEKIKJKNKRKTKZK^KcKgKpKuKxKzLBLS"},
  {0,NULL,"LTLZL]LfLrLuMEMNMRMWMYM\\M_M`MbMcMdMfMiMkMlMnMrMsMvMwMzM{NKNPNRNWN"},
  {0,NULL,"YNfNhNjNlNoNuO?OAOBODOHOKOROVOYO^O_OcOdOgOqOvOxO{O~P?PEPGPHPJPPPS"},
  {0,NULL,"PUPXPYP_P`PcPsPv_B?F?M?Q?S?T?Y?]?d?k?p?q?u?|?~@B@E@F@I@J@N@\\@^@c@"},
  {0,NULL,"m@r@t@u@zAAAHAIANAOAQAXAYAZA`AgAiAlAtAvAwB?BBBCBLBNBPB`BeBiBtBxBz"},
  {0,NULL,"CACCCECGCLCSCTCVCYC]C^C_C`CiCsCuCvCwDADCDGDJDSDTDWD\\DcDjDrDyDzE?E"},
  {0,NULL,"GEJELENEVEWEXEhEjEkEqExE}FAFEFGFOFQFXFZF[F\\FfFgFiFlFtFyFzGAGDGGGM"},
  {0,NULL,"GQGTG^GgGsGuGxGzG{G|G}HCHDHIHRHSHUH[H]H`HhHrHsHuH|I?I@IFIGIKILIOI"},
  {0,NULL,"XI[IbIhIqIsI{I|JIJKJPJRJTJWJ[J\\JdJlJmJqJuJxJ{KBKEKHKKKOKRKSKUK`Ke"},
  {0,NULL,"KjKoK~L?LFLILMLNLbLdLeLfLwM?MQMRMXMYM^M_M`MbMcMeMfMgMiMlMoMqMwMxM"},
  {0,NULL,"yM{M|NONRNTNWNXN_NaNkNlNoNrNvNzO@ODOHOIOLOSOUOVOhOnOqOrOuOvOyOzO}"},
  {0,NULL,"PBPGPIPKPLPOPTPWP\\P_PaPbPdPhPlPvPx_B?D?M?Q?S?V?W?Z?_?k?v?x?y?}@@@"},
  {0,NULL,"A@E@F@G@H@Q@X@]@a@m@r@s@wA?ABAHAIAOAPAQAZA]A^A`AeAfAkAuAxA~B@BEBJ"},
  {0,NULL,"BMBTBWB\\BaBgBoBxBzB~C@CBCDCICNCUCXC\\CaCbCfCgCmCrCtC}DADCDDDIDNDPD"},
  {0,NULL,"VDXD]DaDqDtDvDwEBEFEHELEMENEPEREhEjElEoEuF?FAFEFGFJFNFOFSFZF\\FaFb"},
  {0,NULL,"FdFpFqFsFvFxF~GHGIGWGZG]GaGgGnGsGyG~H?HBHJHMHPHWHXHaHbHdHfHgHkHnH"},
  {0,NULL,"sHuHwHxIBIDIIIMIPIUIcIkInItIuIyJBJIJLJWJXJYJZJ\\JaJcJhJmJqJuJxJ{KB"},
  {0,NULL,"KHKOKRKUKVKWKZKeKoKrKtKyLDLFLILMLULVLdLvLyLzM@MGMOMUMYMZM[M\\M^M`M"},
  {0,NULL,"aMcMdMeMfMoMqMsMvMwMyM|NHNLNSN^NbNgNiNmNnNsN{N|O?O@ODOHOLOMONOYO]"},
  {0,NULL,"O_OfOhOmOoOqOwO~P?P@PFPHPJPNPQPXPYPZP^P`PcPePgPnPtPw_B?F?N?Q?R?U?"},
  {0,NULL,"Y?\\?^?i?u?w?y?{@B@C@D@F@H@L@P@R@Y@a@h@n@p@t@}AEAGAJAMAWAYAZA[A]Ab"},
  {0,NULL,"AeAlAnAsAyA}A~BFBGBMBOBTB[B_BlBnBrBsCACECHCKCMCNCQCVCXCYCbCgCjCmC"},
  {0,NULL,"rCsCuCxC{DBDFDGDHDMDRDSDaDpDuDwDxD~EEEOEREVEWE^E_EgEkErEsEvEwFBFC"},
  {0,NULL,"FHFNFPFVFZF[F]FaFcFfFoFqFrFsFwG?GEGKGXGZG_GbGcGjGwG~H?HBHCHDHEHMH"},
  {0,NULL,"QHRHYHZH[HaHeHjHmHrHxH{H|IAIFILINIVIWIcIjIoItIvJ?JAJLJMJPJQJTJUJ^"},
  {0,NULL,"JdJeJkJsJtJzJ|K?KCKHKJKQKSKYKZK\\KaKcKhKlKwKxLELJLQLTLWL[LxLzL|M@M"},
  {0,NULL,"HMPMUMXMZM[M]M^M`MaMcMeMjMlMmMnMuMvMxM|M}N?NHNVN[N^NfNgNhNjNtN{N}"},
  {0,NULL,"O?OAOEOKONOPOXOYO[O_O`OaOcOjOmOyO{O~PCPEPGPKPLPPPRPSPTPXP_PbPdPgP"},
  {0,NULL,"mPuPz_B?E?P?Q?S?T?V?a?e?n?o?t?w?|@?@A@C@E@H@J@M@R@W@[@j@o@u@x@|@~"},
  {0,NULL,"AFAHALATAWA\\A]A^A_AdAnAoAtAyB?BDBGBIBLBSBUB[B^BkBmBtByC?C@CACDCKC"},
  {0,NULL,"MCQCXC\\C]CcCdCeCkC}C~D?DADBDEDJDLDNDPDUD\\DbDeDuDwDzEDEGEHEKEMEQES"},
  {0,NULL,"EWEdEnEqEtEyE|FAFDFHFJFKFNFRFTF^F_FcFeFlFrF|F}GAGDGEGRGXG[G`GdGhG"},
  {0,NULL,"rGxGyG~HHHIHKHLHOHYHZH[HbHcHdHeHkHlHoHrHwHzIDIHIKIMIRIXIdIoIpIsIt"},
  {0,NULL,"I{J@JCJHJMJNJWJXJ[J`JbJlJnJpJvJwK@KDKMKNKVKXKYKZK[KfKgKjKsKzK}L?L"},
  {0,NULL,"HLPL]LaLbLsLtL|MFMHMMMUMVMXMZM[M\\M]M^M_McMhMjMqMrMtMxMyMzM|NANGNV"},
  {0,NULL,"NWN`NcNhNjNkNoNvN}N~OAOCOGOIOKOPOVOZOaOcOeOnOsOvOwOxO{P?P@PFPJPNP"},
  {0,NULL,"PPQPUPYPZP^PcPePqPtPwPz_C?L?O?R?W?Z?`?d?e?g?n?q?u?v?y@B@E@M@Q@T@U"},
  {0,NULL,"@W@[@c@f@j@q@r@s@yA@AAALAMAOAWA^A_AbAhAnApAsAtAvAzBJBMBTBZB\\B]BbB"},
  {0,NULL,"cBkBqBwCDCOCQCWCZC]C^C_CbCiCkCmCnCoCrCuD?DBDDDGDMDODPDQD\\D]D`DgDi"},
  {0,NULL,"DtDxDyE?EAEDEHENE[E^E`EeEkElEoErEvEzFBFEFFFIFKFOF]F_FcFtFuFvF{F|G"},
  {0,NULL,"BGHGIGJGPG\\G^G_GjGkGxGzG|G~H?HDHIHJHKHOHVHaHdHiHkHmHrHuHzH}IGIMIR"},
  {0,NULL,"ITIZIaIeIiIkIlIoIqIuIzJ?J@JFJNJPJYJ[J`JsJwJyJ{J~K?KBKFKGKPKSKUKVK"},
  {0,NULL,"^KjKmKvKxKyKzK|K}LCLHLILNLVL`LfLkLlLsLtLwLzL}MIMLMMMUMWM]McMdMeMh"},
  {0,NULL,"MmMoMuMyMzN?NFNKNNNWNXN[N`NcNjNpNrNsNxN}OAOBOEOFOHOIO[O_OcOtPAPCP"},
  {0,NULL,"HPMPOPTP]P`PaPbPdPiPlPnPsPxP|P~_C?L?O?S?U?^?_?b?d?f?m?o?p?u?w@A@B"},
  {0,NULL,"@O@P@S@\\@]@^@_@e@k@n@o@q@wA@ACANAPATAXA[A\\AaAgAoAsAtAuAwA{A~BEBTB"},
  {0,NULL,"WBYB[BaBdBgBzB|B~CFCTCXCYC[C`CdCeCiCjCmCnCpCxCzC|D?DEDIDODPDRDUDV"},
  {0,NULL,"D[DbDkDrDtDyDzD~E@EDEIEWE\\E^EbEhEiEoEsEtE|E~FDFEFFFJFPFSF^F_FbFqF"},
  {0,NULL,"rFxFzGCGFGGGJGNGRGSGTGZGhGtGwG{G}HAHDHEHHHLHOHPHRHTHUHkHnHoHsHxHy"},
  {0,NULL,"H}IJIOIRIVIYIZI\\I_IgIiIjIqIvIyI{J?JEJHJLJYJ[J\\JnJuJ|J}K@KAKCKGKIK"},
  {0,NULL,"RKYKZK\\KcKoKqKwK{K|K}L?L@LALGLJLOLPLYLfLhLmLnLqLvLwM?MFMMMQMUMXMY"},
  {0,NULL,"MbMeMfMkMmMpMsMuM}N@NCNHNKN_N`NfNgNhNkNuNvNyNzO?O@OAOBODOJOVOXOdO"},
  {0,NULL,"oOrOyO{PJPMPOPRPSP_P`PePfPiPjPkPnPrPtPw_C?L?O?S?X?[?\\?c?e?f?m?o?p"},
  {0,NULL,"?u?w@C@F@O@R@S@U@V@W@b@e@k@n@o@q@wABAEANAQAVAXA]A^A_AgAoAsAtAuAwA"},
  {0,NULL,"{A~BEBWBXBYBaBdBeBgBpB|B~CICTCXC^C_CbCcCdCjClCmCnCqCsCwCzDADDDLDQ"},
  {0,NULL,"DRDSDVDWD]DdDmDnDsDwDzD~ECEDEJEPEYE_EbEdEjEkEmEnE}F?FBFDFEFMFNFTF"},
  {0,NULL,"\\FgFhFsFuFxF|F~G@GFGKGMGUGWG]G`GcGlGsGyG|G~H?HBHCHFHGHIHWH^H`HmHn"},
  {0,NULL,"HpHtHuHyH|IEIIINISIZI]I^IbIgIkIpIrItIxI|J@JJJTJVJXJ_JeJmJwJxJzJ~K"},
  {0,NULL,"@KCKHKJKMKNKTKWK_KaKfKuKxKzLBLCLDLILKLLLQLSLZLfLhLoLrLuLxLzMAMCMN"},
  {0,NULL,"MTMWMYM\\M`MbMdMlMnMqMvMzM{NANJNPNTNYNZN_NfNhNkNpNrNvNwNyN|N}OBODO"},
  {0,NULL,"KOVOXOnOoOrOxOzO|P?PRPTPVPXPZP_PbPgPiPoPpPuPwP|_C?L?O?S?U?^?_?b?d"},
  {0,NULL,"?f?i?r?s?v?x?|?}@Q@U@Y@Z@\\@]@b@e@h@s@t@u@v@{@|AOARAYA[A\\A]A^AeAjA"},
  {0,NULL,"pAtAuB?BDBFBKBNBPBQBSB^B`BhBrBtC?CJCMCVCZC\\C_CbCcCfCkClCnCwC{C|C}"},
  {0,NULL,"D@DBDQDRDTDUDXDZD\\DfDlDoDpDvDwD}E?EBEQEUEVEZEbEhEiEoEsEtE|E~FDFEF"},
  {0,NULL,"FFJFPFSF^FiFjFrFsFtFwF|GDGGGLGRGSGTGZG[GeGhGtGyG{G|G~HEHGHHHJHOHR"},
  {0,NULL,"HUHcHjHmHoHqHyHzI@ICIHILIWIZI[I\\I`IbInIoItIvIwIyJ?JKJOJSJWJ^JfJmJ"},
  {0,NULL,"nJoJqJsJwKAKIKOKRKXKYK\\K]KoKqKuKwKxKyK}L?L@LCLLLOLYL_LfLiLoLpLqLt"},
  {0,NULL,"L{L~MBMEMPMWMXMZM]M_MbMiMpMqMsMuMxNDNINQNSN]NaNbNdNlNmNpNtNwNxN{N"},
  {0,NULL,"|N}OCOFOLOMOQOaOgOmO}O~P@PBPSPTPUPWPYP_PdPhPiPmPoPqPtP~_C?K?N?Q?U"},
  {0,NULL,"?Z?]?^?b?f?j?p?r?s?u?~@A@N@O@P@S@X@_@c@e@l@o@s@u@w@~A@AMANAPATAWA"},
  {0,NULL,"XA`AgAjArAtAuA{A~BDBFBTBUBYB[B\\BaBnBoByCHCQCRCXCYC]CdCeCgChCiCjCn"},
  {0,NULL,"CpCrCvCxD@DEDGDIDODPDRDYDZD_DbDiDkDyDzE@EFEGEKEQEREZEaEhEqErEsEtE"},
  {0,NULL,"wEyFAFBFCFHFVFXF[FdFjFsFvFwF{F|GDGHGMGOGUGWGXG`GdGmGvG{G|G~H@HAHD"},
  {0,NULL,"HJHKHLHdHeHgHiHpHtHvHwH{H~IEINIPIQIcIdIeIhIkImIpIrIsIwI{J?JIJJJNJ"},
  {0,NULL,"XJ]JfJmJoJqJrJtJwKDKHKJKMKPKTKUK^KbKeKuKyK{L?LALELGLHLLLTL^LaLjLk"},
  {0,NULL,"LlLrLsLuLyMAMKMLMTMVM[M\\MaMdMgMhMnMoMsMxM}NANJNONUNYNZNaNbNlNmNoN"},
  {0,NULL,"pNrNtNwNxOCOEOFOHOROSOiOjOuOwP@PBPKPQPSPUPXPYP`PdPhPjPmPpPtP}P~QA"},
  {0,NULL,"_C?K?N?R?Y?Z?\\?a?d?h?k?s?t?w?z@?@A@Q@W@Y@\\@]@a@d@g@m@p@v@w@x@~AEA"},
  {0,NULL,"LAQARAUAVAaAbAkAlAqArAtAxAyA|BABYBZB]BbBcBdBhBlBzCICPCSCVCZC\\C`Ca"},
  {0,NULL,"CcCdCgCkCnCqCxCyC{D?DCDGDJDLDODSDTDVD^DiDsDtDxDzD|EBEGEKENEVE[E`E"},
  {0,NULL,"cEiEkElEqEvE{FAFBFFFGFIFKFUFaFdFtFuFyF~G@GEGFGJGNGVGXGYG^GaGrGtGy"},
  {0,NULL,"G~H?H@HFHGHHHMHOH\\H]H^HrHsHvHwHxHyI@IDIFIJIQI]I_IbIfIhIiImIqIsIwI"},
  {0,NULL,"xI~JJJKJMJUJbJfJnJuJvK?KAKBKCKFKNKOKPKWKXKaKgKrKvKwK|L@LBLDLGLHLJ"},
  {0,NULL,"LULYLbLgLhLiLrLtLuL|MAMEMGMRMXM_MaMdMfMiMlMoMqMtM}M~NENHNMNONWNXN"},
  {0,NULL,"[NbNdNjNqNrNtNuNvN|O?OBODOGOKOOO`OdOmO}PAPHPKPQPTPUPZPaPcPePkPlPm"},
  {0,NULL,"PqPtPuPxQ?_C?M?P?Q?W?Z?[?`?b?g?l?o?q?v?z@?@B@O@Q@S@T@V@W@[@f@i@q@"},
  {0,NULL,"r@t@x@}AAAMAOARAWAYA\\A_AhAiApArAsAzA}BIBMBTBUBZB[B\\BbBlBuB|CECLCM"},
  {0,NULL,"CWCXC]C_CbCcCfCkCmCnCoCtCuCxD?DADGDJDMDPDQDXD[D`DbDiDjDxDyD}EAECE"},
  {0,NULL,"LEQEREYEaEeElEmErEtEuEwFAFCFDFHFWFYF[F`FiFqFwF}F~G?GAGDGOGQGSGXGY"},
  {0,NULL,"GZGaGlGwGzG{G~H?HBHCHIHLHNHZHcHhHjHlHpHsHxHyI?IDIOIUIWI[I\\I^I`IfI"},
  {0,NULL,"hIjIsIvIzI}J@JCJQJVJZJ_JcJtJuJvK@KAKCKDKEKHKKKMKQK[K]K`KkKwKyK{K}"},
  {0,NULL,"L@LCLDLHLJLPLSLULeLgLnLoLpLxLyMJMNMOMSMYM[M_M`MjMkMlMnMrMtMuMyN@N"},
  {0,NULL,"DNENRNYNZNaNiNlNnNoNqNtNuNvNzN{O@ODOMOTOUO`OlOrOwP?PBPGPSPVPWPYP^"},
  {0,NULL,"PaPbPgPnPqPuPwP}P~QC_C?L?O?R?T?\\?]?_?a?g?k?o?r?t?z@A@D@N@Q@W@X@a@"},
  {0,NULL,"b@d@f@m@o@p@t@xACADAOASAZA]A_A`AcAfAiApAsAuA}BHBIBLBOBRBUBVB[B_Bf"},
  {0,NULL,"BnBxC@CBCGCYCZC^CaCcChCkClCmCpCtCvCwDBDDDEDHDNDRDYD[D\\D]D_DeDhDrD"},
  {0,NULL,"yD{D|D~EBEMETEWE]E`EgEiEnEpEqE{F@FBFDFFFGFLFRFUFaFbFsFtFuFyG?GAGE"},
  {0,NULL,"GNGOGQGVGXGYGmGnGpGyG}H?H@HGHIHJHMHOHQH[HbHsHuHvHwHyHzH{IDIFIOIPI"},
  {0,NULL,"_IbIfIjIkImIoIqIsIyI|I~JCJGJLJQJ\\JaJmJpJrJsJtJ~KDKEKKKLKQKZK[KhKi"},
  {0,NULL,"KtKuKyKzK}LALELFLILLLRL]L^LgLjLmLoLtLvLzMDMJMOMQM[M]M^MbMdMfMjMmM"},
  {0,NULL,"rMsM{M|N@NENMNUN\\N^NeNgNiNnNoNqNrNwNxN|O@OBOFONOZO\\OhOsOuO{PDPEPI"},
  {0,NULL,"PPP[P\\P_PbPdPfPjPoPrPvPzP|P~QE_C?K?N?Q?X?[?`?a?c?f?l?o?v?w?x@?@F@"},
  {0,NULL,"M@O@S@T@U@[@b@e@i@n@q@t@v@zAEANASAXAZA]A^AcAeAoAqAtAuAwB?BEBKBPBQ"},
  {0,NULL,"BWBXBdBeBiBkBvCACGCNCXCZC]C^C_CdChClCmCqCrCsCzD@DCDDDFDSDVDWDYDZD"},
  {0,NULL,"]D^DmDnDuDwDzD|EAECEMEOEXE[EaEdEjElEmEpEuExFAFCFFFQFWFYFZF`FaFwFz"},
  {0,NULL,"G?GAGBGCGDGQGRGSGTGYGZGgGkGqGzG|G~HBHDHIHLHMHNHSHYHbHiHjHsHxHzH~I"},
  {0,NULL,"?IHIJIOIWI[I_I`IcIeIfIjIsIvIxJ@JBJEJKJOJYJ`JbJoJpJqJyJ{J|J}KFKIKR"},
  {0,NULL,"KSKYK\\KiKlKsKuKvKzK~LALFLGLKLLL\\L`LcLjLnLtLwLyL{L|L~MEMFMMMUMVM[M"},
  {0,NULL,"_McMeMiMoMpMvM{M~N@NDNHNIN]N^N`NcNdNgNoNtN{N~O?O@OAOCOEOPO\\O]O_Of"},
  {0,NULL,"OvPAPEPLPNPPPTPXP[P\\P`PcPjPlPoPpPsPxP{Q@QB_C?L?O?S?X?[?\\?c?e?f?i?"},
  {0,NULL,"r?s?v?x@D@E@P@R@V@Y@Z@_@`@e@h@s@t@u@vAAADAPAQARATAUAVAYAeAjApAtAu"},
  {0,NULL,"B?BDBFBKBNBSBUB\\B^B`BmBrBtCJCMCSCVCYC[C\\C`CfCgCiCkCoCrCtCwCyCzC|D"},
  {0,NULL,"JDMDNDQDUDVDYDaDeDgDjDvDyE?EBEEENEOEXE]EbEdEjEkEmEnE}F?FBFDFEFMFN"},
  {0,NULL,"FTF\\FaFcFwFzF}F~G@GCGDGMGUGVGWG^G`GcGoGsG}H?HBHCHDHFHLHNHPH^H`HhH"},
  {0,NULL,"lHmHnHoHrHwH{IAIPIQITI\\IaIbIgIhIlImIqIrI|J@JBJCJIJNJRJ`JaJoJqJvJx"},
  {0,NULL,"JzJ|J}KHKJKLKMKTKVKaKfKkK|K~LALBLDLGLILJLKLQLZLdLeLgLhLlLoLqLsM@M"},
  {0,NULL,"KMLMOMWMXMYM^MgMhMjMmMnMzM{M~N?NGNONUN]N^NbNcNdNmNtNuNzN{N~O@OAOC"},
  {0,NULL,"OFOMOOOQOaOgOkPHPIPLPNPPPRPSPTP\\PaPcPlPoPsPtPwPzP{QC_C?K?N?Q?U?Z?"},
  {0,NULL,"]?^?b?f?l?o?v?w?x?|@@@N@U@X@Y@Z@a@b@e@i@n@q@t@v@{@}AMARAWAYA]A^Ab"},
  {0,NULL,"AeAoAqAtAuAwB?BEBKBPBQBXB^B`BeBiBvBxCACNCOCWCZC\\C^C_CaCfCkClCqC{C"},
  {0,NULL,"|C~D@DBDEDKDODTDUDWDZD\\DcDfDlDqDvDwD|D}EAEHEIETE\\EaEhEqErEsEtEwEy"},
  {0,NULL,"FAFBFCFHFVFXF[F_FfFxFyFzF{GCGFGHGMGPGUGWG_G`GdGfGmGyG}H@HAHGHHHJH"},
  {0,NULL,"KHPH_HdHgHlHrHuHvH|H~I?IAIIISITI]I^IaIdIeIfIlIrIuIwIyI{JCJRJTJVJ\\"},
  {0,NULL,"JcJtJ|J}K@KBKCKDKHKJKKKMKQKTK^KdKeKwKxKyK{K|LCLELHLJLTL[L^LeLgLkL"},
  {0,NULL,"xLyLzL|M@MCMNMOM[M^M`MaMcMjMlMnMrMuMxM}N?NGNPNTN^N_N`NcNfNgNqNsNv"},
  {0,NULL,"NyN~O?O@OAODOPO[O]OfOsOvOyPCPDPJPOPPPUP]P_P`PePhPiPjPkPlPrPvQAQH_"},
  {0,NULL,"C?M?P?Q?W?Z?[?`?b?g?j?r?t?u?y?~@C@N@O@S@X@]@^@`@f@l@o@p@s@y@|A?AR"},
  {0,NULL,"ASAUAVAYAZAaAfAnApAqAsAvBHBJBLBPBQBVBXB_BeBgBjB{CCCJCPCVCYC[C\\C`C"},
  {0,NULL,"aCdChCjCsCzC}C~D?DADBDFDLDMDTDUDXD]DcDfDmDuDwD{E@EEEGEHEOE[E\\EaEe"},
  {0,NULL,"ElEmErEtEuEwFAFCFDFHFWFYF[FcFdFtFuFwF{GDGGGHGOGQGUGWGXGYGlGuGwG{G"},
  {0,NULL,"~HAHBHEHJHKHLHOH\\HcHhHnHpHqHtHvHxH{IEIFIKIPIYI`IbIdIhImIpIrIsIzI}"},
  {0,NULL,"J?JDJGJLJWJ[JdJsJxJyJ{J~K@KCKEKIKKKQK[K\\K]KkKrKvKwKzK~LBLCLDLILJL"},
  {0,NULL,"PLSLWLeLiLjLpLqLrLvMDMHMPMQMVMZM`MbMfMgMkMpMrMtMyMzNANLNMNUNXN[N^"},
  {0,NULL,"N`NcNgNpNsNyN|N}OBOCOEOFOGOQOYOeOoOqPAPCPJPLPOPTPWP]PaPcPfPgPiPkP"},
  {0,NULL,"nPsPxPzQFQGQI_C?M?P?Q?T?]?^?a?c?g?j?r?t?u?y?{?}@R@T@Y@Z@[@^@`@f@l"},
  {0,NULL,"@o@p@s@y@~ABAMANAUAWAXA[AaAfAnApAqAsAvBHBJBLBPBQBXB]BcBeBjBtB{CCC"},
  {0,NULL,"PCTCVCWCXC[C]C`CfCiCjCtC{C|C}DADCDDDKDLDSDVDXD[D\\D^DlDnDqDwDxE@EE"},
  {0,NULL,"EFEIEMETEXEaEgEjEpEqEsExEyFAFCFEFQFVFXFZFbFeFtFuFxG?G@GAGFGIGPGRG"},
  {0,NULL,"TG\\G_GeGiGoGyH?HCHFHHHIHMHNHPHTHWH]HiHlHoHpHqH}I@IBICIGIRIYIZI^Ic"},
  {0,NULL,"IhIiInIuIvI|I~JAJFJNJUJXJ]JaJnJoJqJsJtJ~KDKFKJKPKSKTKUK_KcKgKuKyK"},
  {0,NULL,"{K}L?L@LELGLKLXL_LdLhLkLnLpLrLsLuL}MGMLMTMWM\\M_MaMgMhMkMnMoMsMwM|"},
  {0,NULL,"NKNNNSNVN\\N^N`NcNeNgNoNqNtNwN|N}OBODOFOGOXOYOaOeOqOyPDPEPNPVP[P\\P"},
  {0,NULL,"_PaPePfPnPoPqPrPvPzP{Q?QGQI_C?K?N?R?Y?Z?\\?a?d?h?n?p?q?x?y@@@E@M@Q"},
  {0,NULL,"@R@S@V@W@c@g@j@n@r@u@y@{A?AUAXA[A\\A`AaAcAdAmAqArAuB@BBBCBGBNBOBRB"},
  {0,NULL,"VB_B`BmBpBuC?CCCFCXC[C]C^CbCeCfCjCmCsCtCwCxCyC~D@DHDIDSDTDUDXDYDc"},
  {0,NULL,"DeDhDoDvD{EAEDEFELETEWE_E`EcEiEkElEqEvE{FAFBFFFGFIFKFUF_FeFrFtFuF"},
  {0,NULL,"vFwGBGGGIGJGNGVG^G_GaGcGrGyGzG{G|G~H?HBHKHOHUH\\H]HiHkHlHmHrHsHtIA"},
  {0,NULL,"IGIMIVIYIZI[IaIeIiImIqIuIwIxIzJDJSJTJZJcJeJoJpJrJuJvJxJzKEKNKOKQK"},
  {0,NULL,"WKXKgKqKrL?L@LALBLELFLGLJLKLQLULbLiLpLqLuLwLyLzMBMCMHMSMVMYM]M`Mh"},
  {0,NULL,"MiMlMqMrMwM}M~NCNFNGNNN\\NeNfNhNiNnNxNyNzN{N}N~OCOEOFOJOLOYOkOlOnO"},
  {0,NULL,"{O|PDPGPXPYP^P_PcPePfPgPjPmPuPvPwP{QF_C?K?N?R?V?]?_?`?e?h?k?s?t?w"},
  {0,NULL,"?z?{?|@M@O@\\@]@^@`@c@g@m@p@v@w@x@}ADANAOAQAVA_A`AcAkAlAqArAtAxAyA"},
  {0,NULL,"|BABSBZB]B^BbBcBhBzB{CICLCSC\\C^C`CcCdCeChCjCmCrCsCuCxC{C|C}DIDJDK"},
  {0,NULL,"DMDQDSDZD`DgDpDqDvDxD|D~EGEHEJESE^E`EfEnEoEpErEzF@FBFCFFFLFOFRF]F"},
  {0,NULL,"fFgFqFvF}F~G@GBGDGKGLGPG[G\\G]GhGiGuGzG{HBHCHDHEHKHLHPHZH`HfHoHqHs"},
  {0,NULL,"HtHuH~I@IBIIILIXI[I]I^IcIgImIoItIuI{I}JBJGJHJQJRJ\\JdJnJpJqJrJsJ~K"},
  {0,NULL,"AKGKKKLKVKZK[K`KfKnKuK}L?LCLELFLILKLLLOLWLXLeLgLjLmLoLuLwM?M@MDMJ"},
  {0,NULL,"M[M^MbMfMhMiMkMmMrMvMxM|NBNPNQNVNWNXN[N_NjNkNoNtNuNxN{N|N~ODOFOKO"},
  {0,NULL,"OOUOdOmOqOxPCPFPMPRPVPYPZP]P`PcPiPkPmPnPpPyP{Q?_C?L?O?R?T?\\?]?_?a"},
  {0,NULL,"?g?n?q?u?v?y?}@F@P@T@[@^@`@a@d@f@j@q@r@s@y@{ABAMAPAUAWA`AaAcAhAnA"},
  {0,NULL,"pAsAtAvAzBJBMBPBZB]BbBcBeBkBsBwCOCQCUCVCWC[C]C_CeCgCiCjCoCpCqC|C}"},
  {0,NULL,"DCDDDKDLDNDPDVDZD\\D^DpDqDsDwDxE?EDEFEJEKESEVE`EgEiEnEpEqE{F@FBFDF"},
  {0,NULL,"FFGFLFRFUFhFjFqFyFzF{F}GEGHGLGOGQGXGYG]GgGnGpG}H@HAHCHEHGHMHNHPHQ"},
  {0,NULL,"H[HgHjHkHnHtHwHzI?IEIKIUIWI[I\\I_IaIdIkIpIsItIyI|JAJDJVJWJZJ^JeJpJ"},
  {0,NULL,"rJuJvJyJ{J|KEKKKOKQKWK[KeKhKtK{K~L@LALBLELFLGLLLRL]LcLiLlLmLqLxLy"},
  {0,NULL,"LzMHMNMPMSMUMVMYMZM]M^MlMqMrMsMwM{NANDNLNRNWNXNZN[NaNjNpNsNvNzN{N"},
  {0,NULL,"~O?OAOEOHOWO[O_ObOtOxO}PFPKPOPQPRPUPVP\\PdPpPqPrPsPtPyP|QDQEQJQM_C"},
  {0,NULL,"?L?O?R?W?Z?`?d?e?g?k?o?r?t?z?|@C@M@N@X@^@_@`@c@f@m@o@p@t@x@|AEALA"},
  {0,NULL,"SATAUAZAaAbAfAiApAsAuA}BHBIBLBOBQBRBVBXB_BnBxB}CBCGCKCVCYC`CaCeCg"},
  {0,NULL,"ChCjClCoCpCzC~D@DADBDFDNDPDUDWDXD]DcDdDoDuDwD{D~EBEGELEREUE_E`EeE"},
  {0,NULL,"kElEoErEvEzFBFEFFFIFKFOF]FgFiFqFvF}G?GAGBGCGIGKGPG[G\\G_GdGjGxGzG|"},
  {0,NULL,"HAHCHDHEHKHLHNHVHYHaHkHoHuHwH|H~I@IBICISIXI]I_IaIcIgInIoItIuI}J?J"},
  {0,NULL,"@JMJOJUJXJ_JfJtJuJvJ}K?KBKDKFKNKPKSKUKXKjKmKsKvKxK{K|K~L@LBLHLJLN"},
  {0,NULL,"LTLVLhLlLmLtLuL{L|L~MGMRMTMUMXM\\M^MaMdMiMoMqMtMuMzNBNSNTNVNYN\\NeN"},
  {0,NULL,"iNlNnNoNqNuNvNwN{N~O?O@OZO\\O^OpOsOuOwO|O~PGPOPSPWPXP\\P^PbPgPhPrPs"},
  {0,NULL,"PwP}P~QKQL_C?K?N?R?V?]?_?`?e?h?n?p?q?x?y?~@F@R@V@Z@^@`@a@d@g@j@n@"},
  {0,NULL,"r@u@y@zA@ALAOAYA[A\\A_AbAdAmAqArAuB@BBBCBGBOBRBVBWB_BaBjBmBpC?CECF"},
  {0,NULL,"CVCWCXCZC[CbCfCgCkCsCvCyCzC{DADEDFDIDJDRDTDWD[D_DdDrDuDzD{E?EAEFE"},
  {0,NULL,"MEREUE]E`EfEnEoEpErEzF@FBFCFFFLFOFRF]F`FjFqFrFxFyF}GEGGGKGLGOGQG["},
  {0,NULL,"G]GiGsGuG}H@HCHEHFHHHLHMHPHRHZHfHnHpHrHtHzI?I@IHIKINIUI[I\\I]I`IdI"},
  {0,NULL,"iIkIsItI{JAJBJEJFJIJPJ]J`JsJxJzJ~K?K@KBKGKLKSKUKVKZK`KnKoKuKvKwKx"},
  {0,NULL,"K}LCLDLHLILWLXLZLfLgLiLkLlLnLwL}MFMIMKMUMWMcMfMgMhMlMmMoMvMxMyNIN"},
  {0,NULL,"JNLNRN\\N]NeNiNmNnNrNsNvNyNzN}O?OBOCOJOLOTOeOkOnOwO~PEPIPPPSPWPYPZ"},
  {0,NULL,"P[PePhPkPoPuPzP{P}QFQO_C?K?N?Q?X?[?`?a?c?f?j?p?r?s?u?{@E@P@T@Y@Z@"},
  {0,NULL,"[@_@d@e@l@o@s@u@wA?ADALAPARASATAYAZAgAjArAtAuA{A~BDBFBNBSBTBUB[B\\"},
  {0,NULL,"BoBwByCBCHCRCVCWCYC\\CaCeCfCgCiCoCqCrCuCwCyDEDHDJDNDODQDWDYD`DaDhD"},
  {0,NULL,"jDvDyEEEFEGELEPESEYEaEdEjElEmEpEuExFAFCFFFQFWFYFZFeFgFsFxF|G?GAGE"},
  {0,NULL,"GFGIGRGSGTGZG\\GbGgGkGyGzG}HFHGHIHMHNHPHXHYHbHiHkHqHvH}I?I@ICILIRI"},
  {0,NULL,"VIYIcIdIfIiInIoIuIvIxI|JBJHJLJSJWJdJeJmJwJyJ{K?K@KCKEKIKRKYK[K\\Ki"},
  {0,NULL,"KpKsKvKxKzK|K~LCLDLFLJLML`LcLiLjLkLmLpLvL|M?MBMPMQMVMZM]MaMcMfMkM"},
  {0,NULL,"pMrMvMzM~NCNKNQNSNYNZNaNhNkNlNpNqNrNsNwNxNyOBODOROSOZOiOjOtOzP?PF"},
  {0,NULL,"PGPPPRPUPXPZP^PbPhPlPpPuPwPyP|Q@QBQE_C?M?P?Q?T?]?^?a?c?g?l?o?q?v?"},
  {0,NULL,"z@@@D@N@Q@W@X@Y@Z@\\@f@i@q@r@t@x@zACANAOAQASAXAZA_AhAiApArAsAzA}BI"},
  {0,NULL,"BMBOBRBTBUB[B\\BlBrBuB~CECLC\\CaCbCcCdChCkClCmCpCtCvCwCyC}D?DHDIDLD"},
  {0,NULL,"MDNDRD[D_DaDhDkDyD{D|D}ECEKEPESEZEaEgEjEpEqEsExEyFAFCFEFQFVFXFZFf"},
  {0,NULL,"FhFqFrFxF{F}GFGHGIGMGPG\\G_G`GeGoGrGyH@HAHEHFHHHJHOHPHTHWHfHlHmHqH"},
  {0,NULL,"rHxH|H~IMISITIXIYI]I^I`IeIgIlIrIuIyI~JAJMJOJPJYJ^JbJoJqJuJvJyJzJ{"},
  {0,NULL,"KFKPKRKSKUKYK_KcKnKuKzK~L?LBLFLGLILKL_LbLdLeLfLnLrLwL{L|L~MIMMMRM"},
  {0,NULL,"XM_M`McMeMgMiMoMpMwM{M|N?NBNFNTNWNYNZNaNjNlNsNuNvNyNzN{OAOCOEOTOU"},
  {0,NULL,"OVO`OgOlOzP@PFPKPQPRPVPWPZPdPfPgPmPqPtPyPzP|Q?QCQOQQ_C?M?P?S?V?[?"},
  {0,NULL,"^?_?e?h?m?p?w?y?z?{@B@M@P@X@\\@]@_@c@g@k@n@p@r@w@}ABAQAVAZA]A^A`Ac"},
  {0,NULL,"AkAmApAqArAyA|BBBGBNBSB]B^B`BbBqByB}C@CACUCYC]C^C`CcCdCeChClCoCrC"},
  {0,NULL,"uCvC{C}C~DFDHDJDKDMDZD\\DgDjDlDpDvDxD~E@ECEQEUEXE]EbEfEjEnEoEtE|F?"},
  {0,NULL,"FAFDFEFJFNF\\F^F`FbFrFyFzF{GCGEGGGJGNGRGVGZG^GbGjGvG{G}H@HAHDHEHHH"},
  {0,NULL,"KHNHSH[H_HiHkHxHyH{H|H}IDIGIJIVIYIZI_IfIjIlIpIqIvI{I}JAJJJTJUJZJ]"},
  {0,NULL,"J_JmJwJxJyJzK?KBKHKJKNKOKWKXKdKhKlKvKxKyKzLDLFLILKLLLMLVLaLhLrLvL"},
  {0,NULL,"xLyLzL{MAMCMGMSMYMZM\\M`MaMdMeMnMqMvMyM|NCNENHNNN\\N]NbNdNmNnNpNqNr"},
  {0,NULL,"NsNyNzN}O?OAONOWO]OcOiOpO~PBPIPNPPPQPWPYP[P\\P]PhPxPyPzP{P}P~QBQDQ"},
  {0,NULL,"HQL_C?M?P?S?Y?\\?b?c?d?h?i?q?s?t?x?}@?@N@U@\\@]@a@b@d@g@h@u@v@x@y@~"},
  {0,NULL,"AAALAPAQASATAVAbAdAlAqArAsAxB@BABCBWBYBZBaBcBdBfBiBsCDCKCRCWCYCZC"},
  {0,NULL,"\\C`CaCcCgClCqCvCxC~D?DCDDDFDGDHDLDODPDSDbDnDsDtDxDzD}EBEEEIEWEYE_"},
  {0,NULL,"EbEcEiEkEmEsE}E~FCFDFEFMFPFSFTFeFiFrFsFvF|GBGGGHGKGLGSGTG[G]GfGnG"},
  {0,NULL,"qG{G|H@HGHHHIHJHKHOHVHXHeHjHoHqHzH{H|I?IBIHILIUI\\I`IcIlInIoIpItIv"},
  {0,NULL,"IwIzI~JFJIJQJRJaJcJpJrJxJzJ{J|J}KGKLKMKTKVKZKbKjKpKvK{K|K~LALBLDL"},
  {0,NULL,"FLKLRL[L\\LeLkLlLoLsLvL{L}M@MJMKMWMZM[M^MeMgMjMmMnMtMwM~NINQNRNVN_"},
  {0,NULL,"NeNfNhNiNkNoNpNxNzN}N~OAOCOEOIORO^ObOhOvOyO{O|P?PQPXP]P^PbPePfPgP"},
  {0,NULL,"jPrPuPvPxPyQ@QAQMQP_C?M?P?S?Y?\\?b?c?d?h?m?p?w?y?z@@@C@M@R@T@U@V@b"},
  {0,NULL,"@c@g@k@n@p@r@wA?ACAMAPATA[A\\A`AcAkAmApAqArAyA|BBBGBNBOBSB^B_B`BqB"},
  {0,NULL,"vB}C@CHCUCXC[C]C^C_CbCeChCiCtCuCyC~D@DBDCDGDHDKDNDTDXDYDaDeDfDoDv"},
  {0,NULL,"D{E@ECEDENEOEVEZEbEcEiEkEmEsE}E~FCFDFEFMFPFSFTFdFhFsFyF|F~G@GAGEG"},
  {0,NULL,"KGLGMGUG[G]GfGqGxGzG|H?HBHFHGHIHJHMHQHXHeHjHnHpHuH|H}H~IIIKINIXI^"},
  {0,NULL,"IdIgIjIkInIpIrItIxIzI~JEJGJHJPJ[JbJnJ|J}K?KAKBKDKGKLKRKVKZK\\KbKpK"},
  {0,NULL,"tKwK{K|K~L?L@LALELHLNL[L\\LfLjLmLnLsLvLxM?MDMFMIMUM\\MbMcMeMjMkMmMp"},
  {0,NULL,"MtMwM}NBNJNLNPNWNXN]NbNdNmNqNrNsNuNwN|O?O@ODONOSOWOcOfOpO}P@PHPLP"},
  {0,NULL,"QPUP[P^PaPcPdPlPmPqPsPvPxP}QBQHQMQP_C?M?P?S?V?[?^?_?e?h?i?q?s?t?x"},
  {0,NULL,"?~@D@P@R@V@[@_@a@d@g@h@u@v@x@y@z@|ALAWA[A\\A]A^AbAdAlAqArAsAxB@BAB"},
  {0,NULL,"CBRBVBWBYBaBdBfBoBsCDCKCNCWCZC[C_CaCbCfCgCiCpCsCuCvDADCDEDFDGDIDK"},
  {0,NULL,"DWD[D]DdDkDmDrDzD{D}E?EEEJEPE\\E^EbEfEjEnEoEtE|F?FAFDFEFJFNF\\F^FcF"},
  {0,NULL,"fFvFzF~G?G@GBGCGJGNGVGWG^G`GbGpGvGzG}HAHBHCHDHFHMHNHSH_HaHjHlHmHv"},
  {0,NULL,"HwH{H}IAIFIMIQIaIbIeIhIjIlInIqIrI}JAJBJDJKJMJSJ^JdJmJnJpJrJtJwKAK"},
  {0,NULL,"IKNKOKWKXKYKdKlKmKwKxKyKzK}L?LELHLLLML]LaLpLqLsLtLxL{L|MBMEMHMRMV"},
  {0,NULL,"MXMZM\\M]M_MjMpMqMxMyM|NFNGNMNON[N_NfNhNjNkNoNtNuNwNxN|N~O@OEOIOPO"},
  {0,NULL,"^ObOhOjOxOzPJPMPOPVPZP[P]P^P`PkPnPpPvPyP|P}Q@QAQDQL_C?L?O?S?X?[?\\"},
  {0,NULL,"?c?e?f?m?o?p?u?w@C@F@O@R@S@U@V@W@b@f@j@q@r@s@yAAABAFAIAKANARA`AbA"},
  {0,NULL,"gAhAwAxA}BABDBGBJBUBWBXB_B`BaBnBsBxC@CCCDCHCICMCPCSCTC\\CdCmCnCqCs"},
  {0,NULL,"CuCyC{C}DKDLDRDWD_DaDdDlDmDqDsDwD{D~EBEGELEREUE_E`EeEkElEoErEvF?F"},
  {0,NULL,"GFJFTFVFXFYF]F_FgFlFnFpFrG?G@GHGNGQGSGUGWG]GdGnGpH?HFHHHSHTHUHWHZ"},
  {0,NULL,"H`HbHdHfHiHmHpHqHxH|I@IBIEIFIJILINISI]IbIcIpIsItIyI|JAJDJVJWJZJ[J"},
  {0,NULL,"`JsJwJyJ{J~K?KBKFKGKOKSK[K\\K]K^K_KbKeKhKjKpKrKxLELHLOLYLdLeLsLtLw"},
  {0,NULL,"M@MEMHMIMJMLMMMVM[M`McMdMhMjMmMpMsMuM}N@NCNHNKNWNXN\\N]NcNlNoNpOEO"},
  {0,NULL,"IOKOLOPOTOZO[O]O^OaOdOgOwOyP@PAPDPHPMP`PaPdPePjPnPuPvPxP|P}Q@QGQH"},
  {0,NULL,"QJQNQOQPQU_C?K?N?Q?U?Z?]?^?b?f?j?p?r?s?u?~@A@N@O@P@S@X@_@c@g@m@p@"},
  {0,NULL,"v@w@x@}@~AGAHAKAPAUA^A_AjAkAxAzA{B?BGBLBMBUBVBXB[B`BaBlBmBpCACCCD"},
  {0,NULL,"CJCKCLCOCQCRC_CeCiCnCpCrC}DBDCDDDGDLDRDYD_DeDfDiDkDnDsDzD{E?EAEFE"},
  {0,NULL,"MEREUE]E`EfEnEoEpErEyEzFIFJFMFQFRFTF[FgFjFkFlFpFrF~GAGHGIGNGWGXGZ"},
  {0,NULL,"G`GaGrGsHIHJHKHQHTHUHXHYH[H`HeHgHjHoHpHzH{H}H~IMINIPIQIRIUIWI\\IeI"},
  {0,NULL,"hIkIqIsIwIxI~JJJKJMJUJ\\JdJnJpJqJrJsJ~KAKFKGKIKOKZK[K]K`KaKbKfKgKk"},
  {0,NULL,"KlKmKuLBLIL[L`LcLeLmLwLxM?M@MDMMMNMRMSMXMYM\\M^M`MbMhMpMrMvMzM~NCN"},
  {0,NULL,"KNQNSNXN[N]N_NeNgNtNuNzOHOKOLONOTOUOVOXO\\OfOtOvO|P?PCPFPIPLPMPRP]"},
  {0,NULL,"PbPcPgPmPnPwPyPzP~Q@QDQFQIQJQPQQQVQW_C?M?P?Q?W?Z?[?`?b?g?l?o?q?v?"},
  {0,NULL,"z@?@B@O@Q@S@T@V@W@[@g@k@n@p@r@w@}A?AGAHAIAOAPAUA]AiAmAyAzB@BDBEBF"},
  {0,NULL,"BLBTBVBZB[BdBeBfBsByCCCGCHCICJCLCMCNCSCVCbCkCnCoCtCzC{C|D@DJDPDZD"},
  {0,NULL,"[DbDiDjDpDqDrDuDxDzD}EBEEEIEWEYE_EbEcEiEkEmEsEwE}FIFLFNFRFSFVFWFh"},
  {0,NULL,"FiFkFnFoFvFxGDGEGIGJGXGYGZG`GbGnGvHBHLHPHQHRHUHWHZHaHcHdHfHoHpHrH"},
  {0,NULL,"sHuI?I@ICIDILIOIQITIUI\\IfIhIoIqIvI{I}JAJJJTJUJZJ[JbJnJ|J}K?KAKBKD"},
  {0,NULL,"KFKGKJKRKVKXK`KaKdKgKhKiKpKsKtK{LALLLWL_LdLfLiLjLsMAMBMDMFMIMLMPM"},
  {0,NULL,"UMVM]MbMdMjMlMoMpMwM{M|N?NBNFNTNXN]N_N`NdNeNqNrNxOHOJOMOROSOWOXO["},
  {0,NULL,"O^OeOgOqOxO{P@PEPFPHPLPRP[PcPdPjPlPmPpPwP|P}Q?Q@QDQGQJQRQSQTQX_C?"},
  {0,NULL,"K?N?R?V?]?_?`?e?h?n?p?q?x?y?~@F@R@V@Z@^@`@a@d@e@l@o@s@u@wA@ADAHAJ"},
  {0,NULL,"AKAMAQASA\\AjAmAvAyA}A~B@BIBKBVBWB^B_BcBeBiBnBvB~CBCECFCLCOCSCTCUC"},
  {0,NULL,"bCcCfCnCoCvCyC}D?DADFDPDRDTD_DbDdDfDpDtDuDwDzD|EAECEMEOEXE[EaEdEj"},
  {0,NULL,"ElEmEpExEzFKFLFPFSFVFWF\\F`FeFkFlFmFqFsFtGCGKGOGVGWG]G_GdGmGqHEHOH"},
  {0,NULL,"PHRHUHXHZH]H_HaHcHhHmHnHxHyHzH}I@IDIHIKIMINIOISI]I`IjIkIrIsIwI{J?"},
  {0,NULL,"JIJJJNJXJdJeJmJwJyJ{K?K@KCKEKHKIKPKWKYK^K_KaKbKhKiKoKpKtKvK{K~LOL"},
  {0,NULL,"ULbLmLoLpL|M?MBMJMOMPMRMTMWMZM\\M^McMjMkMqMrMwM}M~NCNFNGNNNZN[N`Na"},
  {0,NULL,"NdNkNrNwO@OGOIOQOROTOZO\\O]O^OdOlOmOyOzO{O}PFPGPLPRPUP^PfPhPrPsPvP"},
  {0,NULL,"wPzP|QAQCQGQJQLQMQNQV_C?M?P?S?Y?\\?b?c?d?h?m?p?w?y?z@@@C@M@R@T@U@V"},
  {0,NULL,"@b@c@f@i@q@r@t@xAAACAFAHAIALANAYA`AhAkAvAwAxBDBFBGBIBWBXB^B_B`BcB"},
  {0,NULL,"jBrB{C@CBCDCGCHCICMCRCTC]CeCgCnCpCqCuCyD@DEDKDNDRDTD_DaDfDoDqDrDs"},
  {0,NULL,"DwD{E@EEEGEHEOE[E\\EaEeElEmErEtEuE~FKFLFMFQFRF[F^F`FdFkFmFoFsFtFzF"},
  {0,NULL,"}GKGMGRG[G^G_GeGoGuG}HGHIHQHSHUHZH[H]HdHeHgHjHkHnHsHuHvHwICIIIKIP"},
  {0,NULL,"IQIVIXIdIgImInIrIuIyI~JAJMJOJPJYJ_JcJtJuJvK@KAKCKDKEKHKNKPKQKYK`K"},
  {0,NULL,"aKcKfKkKmKnKsKtKuKwLCLMLRLaLlLoLpLyL~MBMJMKMLMNMSMUMWM[MhMiMkMlMn"},
  {0,NULL,"MqMvMyM|NCNENHNNNYNZN[NfNgNiNuN{OFOGOJOLOMOPOQOSOTO[ObOhOiOxP?PBP"},
  {0,NULL,"CPEPGPIPPPVPYPbPiPlPoPqPwP{P~QAQIQJQLQOQRQSQTQZ_C?M?P?Q?T?]?^?a?c"},
  {0,NULL,"?g?j?r?t?u?y?{?}@R@T@Y@Z@[@^@`@g@h@u@v@x@y@z@~AFAGAHATA^A_AaAdAfA"},
  {0,NULL,"wA}BABBBEBFBJBOBPBQBSB\\B]BiBqB}B~CBCECHCICNCPCSCTC[CjCmCnCwCxC|DA"},
  {0,NULL,"DDDEDODSDXD\\DhDiDlDnDoDqDtDvDxD~E@ECEQEUEXE]EbEfEjEnEoEtEyF?FHFIF"},
  {0,NULL,"JFKFRFTFZFbFcFmFnFoFwFyGBGFGLGPGQGTGUG\\GfGjGqGyG~HFHQHRHTHUH\\H]Ha"},
  {0,NULL,"HgHhHiHlHsHtHwHyI@IBICIEIGIIIJIOIZI^I_IcItIvIwIzI~JFJIJQJRJ^JdJmJ"},
  {0,NULL,"nJpJrJtJwKAKIKMKOKWKZK[K`KbKfKgKiKjKlKmKsKxKyK|LPLSLbLqLwLxL|M@MB"},
  {0,NULL,"MFMHMMMNMRMUMXM\\M]M^McMhMpMrMtMyMzNANLNMNUNaNbNhNjNkNnNoN~O?OHOIO"},
  {0,NULL,"LOMONOPOXO[O]O`OlOoOxOzO~PAPGPHPJPOPTPZP^PhPkPlPoPpPsPvQBQJQMQNQQ"},
  {0,NULL,"QRQSQT_C?M?P?Q?W?Z?[?`?b?g?j?r?t?u?y?~@C@N@O@S@X@]@^@`@g@k@n@p@r@"},
  {0,NULL,"w@}A?AGAHAIAOAPAUA]AkAnAzA{B?BABBBKBLBVBXBZB[BaBeBfBsBvC?CACCCFCJ"},
  {0,NULL,"CLCMCQCRCVC`CkCnCrCwCyCzC}DBDLDTDYD]DeDfDhDiDmDsDuDzD{D}E?EEEJEPE"},
  {0,NULL,"\\E^EbEfEjEnEoEtEuE|FGFHFNFOFSFUFZFbFcFmFnFoFwFyGBGFGKGOGPGQGTGUGf"},
  {0,NULL,"GpGqGyG{G~HTHVHYH[H\\H]H^H`HhHkHmHrHtHvHxI@IAICIEIFIHIKITI`IaIbIdI"},
  {0,NULL,"rItIxIzI~JEJGJHJPJ]J_JmJwJxJyJzK?KBKJKNKRKUKVKXK^KdKeKhKnKoKpKrKt"},
  {0,NULL,"KzLALLLUL_LdLgLhLyL{L~M@MAMFMGMOMSMUMYMZM[M^MdMfMnMoMsMwM|NKNNNSN"},
  {0,NULL,"VNYNbNhNjNmNnNsN~O?OIOKONOPOQOVOZO\\O]O`OaOlOxO{O~PBPDPKPNPQPYP\\P_"},
  {0,NULL,"PhPiPjPpPrPxP{QAQCQEQKQOQPQUQV_C?L?O?R?W?Z?`?d?e?g?k?o?r?t?z?|@C@"},
  {0,NULL,"M@N@X@^@_@`@c@e@k@n@o@q@wA@AEAFAJAKAQASAWA[AgAiAyB@BCBEBFBHBMBOBQ"},
  {0,NULL,"B\\B]B^B_BpBrBtCACDCFCGCKCLCNCQCSCWCYCaCpCqCuCxC~DADCDNDSDWDXD^D`D"},
  {0,NULL,"aDcDdDnDoDvDwD}E?EBEQEUEVEZEbEhEiEoEsEtEvE|FHFOFPFQFUFZF\\FbFiFlFn"},
  {0,NULL,"FoFwFxGBGEGKGOGPGUGVG_GcGeGsGzHDHMHTHVHXHYH[H\\HbHeHhHjHkHvHxH~I?I"},
  {0,NULL,"@IAICIFIHISIUIXI]I`IaInIrItIxI|J@JJJTJVJXJ[J\\JnJuJ|J}K@KAKCKIKKKM"},
  {0,NULL,"KWKZK\\K_K`KaKcKdKeKnKoKsL?L@LKLRL]L`LkLqLvLwL}M?MCMHMKMMMQMXM`MaM"},
  {0,NULL,"eMgMhMkMmMrMsM{M|N@NENMNUNXN_N`NaNdNkNvNyOCOGOJOLOMOSOWOXOYO^O_Oh"},
  {0,NULL,"OtO{P@PEPFPJPMPNPRP[P`PfPjPkPmPwPzP{P}Q?QAQBQFQIQJQMQUQZQ\\_C?L?O?"},
  {0,NULL,"R?T?\\?]?_?a?g?n?q?u?v?y?}@F@P@T@[@^@`@a@d@e@h@s@t@u@v@{ADAIAJAKAM"},
  {0,NULL,"AVAZA\\AhAjAvAyA{A|B?B@BIBVBWBZB[BcBeBgBhB|C@CACBCECFCNCOCSCUC]ChC"},
  {0,NULL,"iCoCvCyC}C~D@DCDLDPDTDZD^D_DbDcDfDpDsDwDzD~ECEDEJEPEYE_EbEdEjEkEm"},
  {0,NULL,"EnE{F?FHFIFMFRFZF[F^FcFhFnFoFpFvFyGDGFGJGLGQGTGYG\\GhGlGtG}H@HKHQH"},
  {0,NULL,"THXH]HaHdHeHgHhHiHlHtHwH|H~I?IEIGIIIJIUIWIXI[I^I_IpItIvIwIyJ?JKJO"},
  {0,NULL,"JSJWJ`JaJoJqJvJxJzJ|J}KJKRKSKTKVKXK]K`KeKfKkKlKnKqKsKwLBLDLNLVL^L"},
  {0,NULL,"gLhLjLsM?MDMEMGMKMLMOMVMYM_MfMgMjMkMmMoMuMyMzN?NFNKNNNYN]N^NeNfNm"},
  {0,NULL,"NtN{ODOGOKOOOQOROVOWOYO^OcOsOuOwP?PCPHPIPJPNPPPSP]PaPkPlPnPtPuPyP"},
  {0,NULL,"{Q?QAQBQFQGQKQPQTQYQ]_C?K?N?Q?X?[?`?a?c?f?j?p?r?s?u?{@E@P@T@Y@Z@["},
  {0,NULL,"@_@d@g@j@n@r@u@y@zA?AGAHAJAOATA]AaAdAgAxA}BEBFBGBIBJBPBSBTB\\B]BdB"},
  {0,NULL,"hBuBzC@CBCECGCHCNCPCTCUCYCgClCoCwC~DADBDDDEDHDODQDXD`DfDhDjDnDoDt"},
  {0,NULL,"DvDxD|D~EGEHEJESE^E`EfEnEoEpErEuF@FNFOFPFQFSFUF[FgFjFkFlFpFrF~GAG"},
  {0,NULL,"HGIGRGXGZG^G`GaGhGrHIHJHMHRHVHXHYH^HaHeHgHhHnHqHuH{H|H}I?IDILIPIR"},
  {0,NULL,"ISIVIXIYIfIgIoIqIuIwIxIzJDJSJTJZJ]J`JsJxJzJ~K?K@KBKJKLKNKQKUKVK_K"},
  {0,NULL,"cKdKhKnKoKpKqKrK}L@LCLTL\\L^LgLlLnL{L}L~MFMKMOMRMSMUMWMXMYMZM_MfMn"},
  {0,NULL,"MoMsMxM}NANJNONUNXN\\N]N_NcNeNuNyNzOIOKOLOMOQOTOUOZO[OfOuOvOwOyO}P"},
  {0,NULL,"@PEPIPMPSP[PdPePnPqPtPuPzP|P}Q?QCQGQHQKQLQMQSQY_C?L?O?S?U?^?_?b?d"},
  {0,NULL,"?f?i?r?s?v?x?|?}@Q@U@Y@Z@\\@]@b@f@m@o@p@t@x@|ACAFAIAJALAXAYAcAiAjA"},
  {0,NULL,"xAzA~BBBGBKBLBPBSBTB^BcBdBkBwB}B~C?C@CCCDCFCJCPCRCXCfCkCsCvCwCxC{"},
  {0,NULL,"D@DADFDQDXDZD`DbDlDmDoDpDuDwDxE?EDEFEJEKESEVE`EgEiEnEpEqE{E|FKFLF"},
  {0,NULL,"NFSFWFXFYFaFjFlFoFpF{F~GAGGGMGPGRGTG[G^GgGjGxG{HBHOHRHZH^H_HbHcHd"},
  {0,NULL,"HfHhHjHlHpHqHtHvHyIAICIGIKILINIWIZI[IdInItIuI}J?J@JMJOJUJXJ\\JaJmJ"},
  {0,NULL,"pJrJsJtJ~KDKKKLKNKQKTKUK]K_KbKgKiKmKpKsKtKvLFLLLPLQLZLgLnLvLzMCMF"},
  {0,NULL,"MGMIMJMOMQM[M]M_MaMcMeMfMmMnMzM{M~N?NGNONUNZN[N_NeNgNiNqNsNwOHOKO"},
  {0,NULL,"LONOPOUOWO\\O]OkOoOrO{P?PAPDPFPIPLPPPbPcPfPlPmPvPxPyPzP~Q@QHQIQKQM"},
  {0,NULL,"QNQOQTQ[Q`_C?M?P?Q?T?]?^?a?c?g?l?o?q?v?z@@@D@N@Q@W@X@Y@Z@\\@g@h@u@"},
  {0,NULL,"v@x@y@z@~AFAGAHATA^A_AaAhAlAyA{A}A~B?B@BJBOBQBUB\\B]B`BoBqB}B~C?CA"},
  {0,NULL,"CECFCOCPCRCTCcCjCmCpCqCsCwCzC|D?DIDMDNDWDaDdDgDhDkDqDuDvD{E@ECEDE"},
  {0,NULL,"NEOEVEZEbEcEiEkEmEsExE~FJFOFTFUFVFWF]FhFiFkFnFoFvFxGDGEGIGVGXGZG_"},
  {0,NULL,"G`GbGvGxHHHLHPHVHWHZH[H^H`HbHcHfHnHqHrHsHtHzH~IEIMINIOITIVIXIYIeI"},
  {0,NULL,"gIkIqIrI}JAJBJDJKJMJSJaJcJpJrJxJzJ{J|J}KIKLKMKQKWKZK^KbKeKjKlKmKn"},
  {0,NULL,"KqKrKxK|K~LPLSLXLkLoLuLvL}M@MAMBMJMQMTMWM]M^MaMdMeMiMnMrMtMuMyN@N"},
  {0,NULL,"DNENRNXN]N^N_NeNfNrNxOEOOOQOROSOVOWOZO\\O^OeOqOrOwOyO{O~P?PCPHPSP]"},
  {0,NULL,"PbPePhPjPlPtPuPyP~QEQFQHQIQKQLQUQVQXQ^Q`_C?L?O?S?U?^?_?b?d?f?m?o?"},
  {0,NULL,"p?u?w@A@B@O@P@S@\\@]@^@_@f@m@o@p@t@x@|ACAFAIAJALAXAYAcAfAoA|A}A~B@"},
  {0,NULL,"BCBJBKBPBSBTBYBbBdBfBkBwB~C?CACECFCJCKCLCUCXCfCjCtCxCyCzC{C~DEDHD"},
  {0,NULL,"ODVD[D^DaDbDhDlDrDtDxDyE?EAEDEHENE[E^E`EeEkElEoErEzE~FJFKFLFQFTFZ"},
  {0,NULL,"F[F_FgFlFnFpFrG?G@GHGNGSGWGXGZG]GkGnGpHEHFHHHTHUHWHYH\\H]H`HeHgHlH"},
  {0,NULL,"oHpHrHxH}H~IAIJIMINIOIRIUI\\IeIiIjIqIsIyI|I~JCJGJLJQJ_JfJtJuJvJ}K?"},
  {0,NULL,"KBKDKHKLKNKPKQKUK`KcKdKiKkKlKmKsKtKvK|LFLQLZL_LlLpLuL{L~MBMGMHMJM"},
  {0,NULL,"KMTMUMVMZM[MaMiMkMnMqMvMzM{NANJNPNTNWN\\NbNcNlNnNoO@OEOGOIOJOOOROS"},
  {0,NULL,"OZO[O^OaOgOnOwOzO|O~PAPFPNPWPXPZP\\PgPkPpPrPxPyP}Q?QAQBQCQDQEQFQSQ"},
  {0,NULL,"`_C?L?O?S?X?[?\\?c?e?f?i?r?s?v?x@D@E@P@R@V@Y@Z@_@`@f@j@q@r@s@yAAAB"},
  {0,NULL,"AFAIAKANARA`AbAeAnAwAyAzA|BCBDBLBNBRBUBXB`BaBnBqBxCECICKCLCMCNCSC"},
  {0,NULL,"TCUCVC\\CdCrCsCxCyC|D?DCDGDMDUDYDaDbDcDeDgDiDmDyD{D|D~EBEMETEWE]E`"},
  {0,NULL,"EgEiEnEpEqE}F@FGFHFNFQFSF[F]FaFjFlFoFpF{F~GAGGGIGMGRG[G^G`GjGmGxG"},
  {0,NULL,"{HBHCHRHXHYH\\H]H^HcHgHhHlHnHqHsHxH{I?IAIDIJILIPITIXIfIgIlImIqIuIz"},
  {0,NULL,"J?J@JFJNJPJYJ^JeJpJrJuJvJyJ{J|KEKFKGKOKYK[K^KcKdKeKhKjKkKlKnLALEL"},
  {0,NULL,"HLOLSLYLiLmLrLxM?MAMGMHMIMNMPMVM\\M^MaMcMgMlMpMqMsMuMxNDNINQNSNZN["},
  {0,NULL,"NgNhNiNjNqNsOAOHOJONOOOROSOWOYO\\OmOoOrOwOxO}PBPDPFPJPOPUPVPYPhPqP"},
  {0,NULL,"sPvPyP{P}Q?QAQBQFQLQQQRQVQXQ[_C?K?N?R?Y?Z?\\?a?d?h?k?s?t?w?z@?@A@Q"},
  {0,NULL,"@W@Y@\\@]@a@d@e@i@n@q@t@v@{AEAGAJAKAVAWAZA[AeAkAvAwBABBBDBIBJBNBRB"},
  {0,NULL,"YBZB[BbBkBoByB~C?C@CBCCCICOCPCTC[C\\C`CtCzC{D?DADBDCDGDJDVD]D^DdDe"},
  {0,NULL,"DiDjDmDtDyDzE@EFEGEKEQEREZEaEhEqErEsEtEvEyFGFHFNFPFZF\\F]FdFfFkFmF"},
  {0,NULL,"pFuFzF|F}GJGLGNGSGYG\\GgGkGvGyH?HCHVHXH\\H^H_H`HcHfHhHnHoHpHrHwHyH|"},
  {0,NULL,"IBIDIEIJIKIQIRI_IhIiIpIsIvIxJ@JBJEJKJOJYJ\\JcJtJ|J}K@KBKCKDKKKMKSK"},
  {0,NULL,"TKZK\\KaKcKdKeKhKlKoKsKtKyKzLHLQLWLXLeLkLqLzL}M@MCMHMMMOMPMXMZM]M`"},
  {0,NULL,"MaMeMjMmMrMvMxM|NBNPNQNVNYN^NfNgNiNmNpO?OAOGOHOIOMOPOSOTO[O^OkOnO"},
  {0,NULL,"qOxOyOzPBPCPDPIPPPVP]P_PiPlPqPrPyP|P~Q@QCQEQFQGQLQMQTQ__C?K?N?Q?U"},
  {0,NULL,"?Z?]?^?b?f?l?o?v?w?x?|@@@N@U@X@Y@Z@a@b@g@m@p@v@w@x@}@~AGAHAKAPAUA"},
  {0,NULL,"^A_AlAoAvA{A|A}B?BCBJBOBQBUBXB`BaBmBpB{B~C@CACECOCPCQCRCUCZC_CiCo"},
  {0,NULL,"CpCqCuC|D?DBDKDMDUDWDcDdDfDgDjDkDqDvD{EAEDEFELETEWE_E`EcEiEkElEqE"},
  {0,NULL,"wE{FIFNFRFSFXFYF\\F_FaFlFmFpF{G?G@GGGMGPGQGTGUG[GcGiGuH@HAHNHRHSHV"},
  {0,NULL,"H^H_HaHbHcHdHjHkHlHvHyH|H}IAIGIIIKIRISIWIZI^IaIdItIuI{I}JBJGJHJQJ"},
  {0,NULL,"RJbJfJnJuJvK?KAKBKCKFKGKOKRKXK[K_K`KaKcKdKfKgKpKtLBLILJL`LaLcLiLr"},
  {0,NULL,"LsLtL}MAMDMEMLMPMRMWMXMbMdMgMjMlMoMpMvM{M~N@NDNHNINWNbNhNjNlNnN|N"},
  {0,NULL,"}ODOGOJOMOOOQOYOZO[O^O_OiOjOzO|O}PAPIPKPNPQPTPZP\\PgPkPoPqPrPxPzQB"},
  {0,NULL,"QCQGQLQMQOQRQUQWQ\\Q]Qd_C?L?O?R?T?\\?]?_?a?g?k?o?r?t?z@A@D@N@Q@W@X@"},
  {0,NULL,"a@b@d@e@h@s@t@u@v@{ADAIAJAKAMAVAZA\\AeAfAvBABBBEBFBGBIBRBVBYBZB[Be"},
  {0,NULL,"BgBmB|C?C@CBCHCICOCPCRCUC]ChClCrCtCuCvC{DBDCDJDYD[D]D^D_D`DeDjDmD"},
  {0,NULL,"rDyDzD~E@EDEIEWE\\E^EbEhEiEoEsEtE~F@FMFOFUFVFWFYF^FbFiFlFnFoFwFxGB"},
  {0,NULL,"GEGKGOGVGXG_G`GcGsGwGzHGHMHSHVHWHYH[H_HbHcHfHiHqHsHvHzH}H~IFIGINI"},
  {0,NULL,"OIPIVIXIYIjIkImIqIrI|J@JBJCJIJNJRJ^JfJmJnJoJqJsJwKAKJKPKRKVKXKYK]"},
  {0,NULL,"K^KbKfKgKiKkKqKrKwK}LDLNLVLcLfLiLyL{L~MCMEMIMKMPMSMZM[M_M`MbMgMlM"},
  {0,NULL,"oMqMtMuMzNBNSNTNVN`NaNbNdNjNkNyOCOFOIOJOLOMONOPOTOUOXO_OpOtO}O~P?"},
  {0,NULL,"P@PAPGPJPTPUPWP^PgPhPkPmPoPuPvQ@QCQDQHQNQOQRQVQYQZQ]_C?L?O?R?W?Z?"},
  {0,NULL,"`?d?e?g?n?q?u?v?y@B@E@M@Q@T@U@W@[@c@e@k@n@o@q@wA@AEAFAJAKAQASAWA["},
  {0,NULL,"AnAoAxA{B?BABBBHBMBNBOBQB\\B]BbBrBtBzC?CCCDCGCHCICKCQCRCWC_CaCsCuC"},
  {0,NULL,"vC~D?DDDEDIDMDOD\\D_D`DcDgDkDlDtDvDyE?EBEEENEOEXE]EbEdEjEkEmEnEzE}"},
  {0,NULL,"FIFPFRFVFWFXF\\FcFhFnFoFpFvFyGDGFGIGJGLGYGZG\\GhGoGtG|H@HKHQHSHWHZH"},
  {0,NULL,"_HaHcHdHgHiHpHrHuHvH{I?IFIGILIQIRITIUIhIiIlIoIqIvIyI{J?JEJHJLJYJ_"},
  {0,NULL,"JeJmJwJxJzJ~K@KCKEKHKIKMKWKZK^K_KaKcKgKiKoKpKrL?LILKLRLTL]LoLuLxL"},
  {0,NULL,"|M?MCMEMJMNMRMTMWM\\M_M`McMiMkMqMrMsMwM{NANDNLNRNYN^NfNhNmNnNtOBOD"},
  {0,NULL,"OIOKONOOOQOTOUOVO]ObOsOuOxO|P?P@PDPKPNPQPVPXP_PiPmPpPqPuPxP{Q@QEQ"},
  {0,NULL,"HQLQNQOQQQSQ\\QbQe_C?K?N?Q?X?[?`?a?c?f?l?o?v?w?x@?@F@M@O@S@T@U@[@b"},
  {0,NULL,"@g@j@n@r@u@y@zA?AGAHAJAOATA]AaAeAmAzA|BCBEBFBHBLBPBSBTBZBdBeBhBjB"},
  {0,NULL,"zCBCCCDCGCHCKCLCMCNCYC^ClCoCpCtCvCzD@DDDFDVDZD[D^DjDkDnDpDrDuDxDz"},
  {0,NULL,"D|EBEGEKENEVE[E`EcEiEkElEqEvExFJFOFTFUFXFYF^F_FaFlFmFpF{G?G@GGGPG"},
  {0,NULL,"QGSGTGUG]GiGtGuGzHAHNHQHSHUHWH[H_H`HbHdHiHjHmHwHxH{H|IBIFIHIJIPIS"},
  {0,NULL,"IWI_I`IbIcIsItI{JAJBJEJFJIJPJcJeJoJpJrJuJvJxJzKLKMKNKQKUKWK]KbKjK"},
  {0,NULL,"kKlKnKoKqKrK}L@LGLMLTL^LpLuLvLzL}MBMCMDMQMSMTMWMYM]MbMeMiMkMnMrMu"},
  {0,NULL,"MxM}N?NGNPNTNZNbNhNiNjNnN|N}OCOGOHOJOOOVOWOXOYO\\OiOjOsO|O}PBPDPGP"},
  {0,NULL,"JPMPOPYP^P_PgPiPnPqPsPvP{QAQDQEQIQNQPQQQTQ\\Q]QaQc_C?K?N?R?Y?Z?\\?a"},
  {0,NULL,"?d?h?n?p?q?x?y@@@E@M@Q@R@S@V@W@c@e@i@n@q@t@v@{AEAGAJAKAVAWAZA[AdA"},
  {0,NULL,"oA~BABBBHBKBLBMBNBOBRBYB\\BbBoBxByC?CCCDCGCICJCMCPCQCXC[C`CsCtC|C}"},
  {0,NULL,"C~D?DDDHDIDUD\\DcDeDhDkDlDpDtDvDyEEEFEGELEPESEYEaEdEjElEmEpEuE{FHF"},
  {0,NULL,"JFKFLFMFZF^F`FeFkFlFmFqFsFtGCGKGMGOGVG^G_GbGdGmG~HEHOHQHRHSHTHUHW"},
  {0,NULL,"HZH]HeHjHkHmHnHoHqHsIAIBICIKIMIPIVIYIaImInIrIuIwIyI{JCJRJTJVJ`JbJ"},
  {0,NULL,"oJpJqJyJ{J|J}KKKRKSKTKVK\\KdKeKfKjKkKlKmKqKsKyKzLFLWLXLYLhLjLnLtMD"},
  {0,NULL,"MEMFMGMMMOMTMVMYM\\M_MdMeMjMmMoMvMxMyNINJNLNRNWN`NaNcNdNkNwN~O@ONO"},
  {0,NULL,"ROUOVOWOYOZO\\O]OdOeOmOzO~PAPBPEPLPMPTPWP[P`PgPjPoPsP|P}P~Q?QDQHQI"},
  {0,NULL,"QPQQQRQUQ^Qg_C?K?N?R?V?]?_?`?e?h?k?s?t?w?z?{?|@M@O@\\@]@^@`@c@e@l@"},
  {0,NULL,"o@s@u@wA@ADAHAJAKAMAQASA\\AgAlAwAyAzB@BDBHBMBQBWB]B^B_BcBiBvBwCECF"},
  {0,NULL,"CGCJCKCLCMCQCSCbCcCdCpCtCuCwCxC}DADKDNDQDSD`DaDdDeDnDpDqDvDwD|D}E"},
  {0,NULL,"AEHEIETE\\EaEhEqErEsEtEwF@FGFMFTFVFWF]F^FdFfFkFmFpFuFzF|F}GJGLGRGY"},
  {0,NULL,"G[G\\GfGgGkH?HCHLHSHTHWH[H\\H^H`HeHfHlHmHoHtHuHyH{IBIDIIILIMITIWI[I"},
  {0,NULL,"^IlIoIuIvIxI|JBJHJLJSJWJ]JfJmJoJqJrJtJwKDKEKHKJKPKXKYK]K^KbKfKiKj"},
  {0,NULL,"KmKpKqK{K~LELULZLbLfLlLrLyMAMIMKMMMPMSMTMUMZM[M\\MbMeMgMoMqMtM}M~N"},
  {0,NULL,"ENHNMNONYN\\N^NfNlNmNpNxOAOHONOPOSOUOWOXOYO[O`OkOnOwOyO|PBPHPKPLPQ"},
  {0,NULL,"PSPXPaPnPpPrPsPtPxP~QBQDQIQKQOQPQQQSQ[Q_Qh_C?M?P?S?V?[?^?_?e?h?i?"},
  {0,NULL,"q?s?t?x?~@D@P@R@V@[@_@a@d@f@l@o@p@s@y@|ABAFAGAIARAXAbAcAlAnAwA|BC"},
  {0,NULL,"BDBEBHBMBNBRBUBYBaBbBgBlBuCACBCGCKCMCNCSCTCUCWCZC^CrCsC|D@DBDCDED"},
  {0,NULL,"GDIDUD]DcDgDiDkDmDoDrDyD{D|D}ECEKEPESEZEaEgEjEpEqEsExE|FIFKFLFPFX"},
  {0,NULL,"FYF\\FeFfFkFmFnFqFuF|GCGNGOGSGVGWG]GlGrGwG|HDHNHRHVHXHZH]H_HaHdHgH"},
  {0,NULL,"mHuHwHzH}H~I@IFIHIIIMIOIQISI]IbIeIjIrIsIzI}J?JDJGJLJWJ]JaJnJoJqJs"},
  {0,NULL,"JtJ~KDKKKLKSKTKUK\\K]K_KaKfKgKiKmKrKtL?LGLJLVL[L\\LhLkLnLzL}MCMFMGM"},
  {0,NULL,"LMNMQMYM]M_MaMfMhMlMmMnMtMwM~NINQNRNVNWN\\N^NcNlNmNvN|OBOHOJOLOPOS"},
  {0,NULL,"OUOVOXOYOcOpOvOyO|PEPGPHPKPNPXP\\PaPePnPoPpPrPtPuPwQCQFQHQJQPQRQSQ"},
  {0,NULL,"TQWQcQeQj_C?M?P?S?Y?\\?b?c?d?h?i?q?s?t?x?}@?@N@U@\\@]@a@b@d@f@i@q@r"},
  {0,NULL,"@t@xAAACAFAHAIALANAYA`AdAiAxA{A~BGBHBKBMBPBWB^B_BcBdBjB{B|B~C?C@C"},
  {0,NULL,"DCHCJCOCQCRCaCeCgCoCqCrCvCwCxD@DFDPDQDSD`DbDgDnDoDsDuDwDxE@EEEFEI"},
  {0,NULL,"EMETEXEaEgEjEpEqEsEyE}FGFOFPFQF[F\\F]FeFfFkFmFnFqFuF|GCGLGNGSGWGYG"},
  {0,NULL,"]GiGlGwG|HDHJHVHXHYH\\H^H_HaHbHfHiHkHoHrHwHzH|IBIEIHIQIRIUIVI\\IcIi"},
  {0,NULL,"IpIsIvIzI}J@JCJQJVJZJ^JbJoJqJuJvJyJzJ{KEKFKHKOKPKYK`KcKeKhKjKkKnK"},
  {0,NULL,"oKqKuLCLKLMLNLaLfLmLrL|L~M?MAMIMNMQMRM^MbMcMfMgMiMlMpMqMxMyM|NFNG"},
  {0,NULL,"NMNONWN\\NaNcNdNlNvNzOBOKOOOROUOVOXOYO\\O]OcOjOpOzO~P@PCPEPKPMPWPZP"},
  {0,NULL,"`PdPgPiPjPkPoPtP|QBQDQEQGQKQNQUQVQWQZQcQk_C?M?P?S?V?[?^?_?e?h?m?p"},
  {0,NULL,"?w?y?z?{@B@M@P@X@\\@]@_@c@f@l@o@p@s@y@|ABAFAGAIARAXAbAcAfAmAvA|A~B"},
  {0,NULL,"?BCBIBKBNBRBSBTBYBbBlBtBuB~CACFCJCKCNCOCQCUCZC^ChCqCrCzC{C~DDDEDH"},
  {0,NULL,"DJDVD\\D^DgDhDjDlDrDsDxDyD}EAECELEQEREYEaEeElEmErEtEwF?FGFMFUFXFYF"},
  {0,NULL,"]F^F`FdFkFmFoFsFtFzF}GJGMGRG[G\\G^GaGeGoG}HAHGHQHSHYH[H\\H`HbHeHfHk"},
  {0,NULL,"HtHuHyHzH{I?IDIGIHIIITIVIWIZI[IfIlIuIvI|I~JAJFJNJUJXJ[JdJsJxJyJ{J"},
  {0,NULL,"~K@KCKGKKKSKTK[K\\K]K^K_KgKhKjKoKqKrLDLGLJL[L\\L]LeLjLqLtL~M@MDMEMH"},
  {0,NULL,"MLMQMVMXM`MdMfMhMiMmMpMtMwM}NBNJNLNPNZN[N`NgNiNkN{N}OFOGOKOMOOOQO"},
  {0,NULL,"ROTOZO]ObOfOhO{O}PCPGPJPKPLPOPUPcPfPhPiPmPsPtPwPzQ?Q@QEQKQMQQQUQV"},
  {0,NULL,"QaQdQeQj_C?L?O?S?X?[?\\?c?e?g?k?o?r?t?z@C@D@G@J@K@S@Z@a@c@e@k@n@o@"},
  {0,NULL,"q@wABAEANAQAVAXA]A^A_AgAiAyB@BCBEBFBHBMBYB\\B]B^BdBeBfBgBjBmBpBqBr"},
  {0,NULL,"ByB{CKCOCQCXCfCmCnCqC~DADHDJDRDSDTDWDXDcDdDfDiDjDnDsDwDxE?EDEFEJE"},
  {0,NULL,"KESEVE`EgEiEnEpEqE}F@FGFHFNFQFSF[F]FaFbFsFtFuFyG?GAGEGIGNGQGRGYG["},
  {0,NULL,"GbGdGeGiGlGmGpGvGxH@HGHKHRHUHhHlHsHzH{IAIBIDIHIMIOIPI^IcIeIfIkIlI"},
  {0,NULL,"mIqIvIyI{J?JEJHJLJYJ\\JeJhJkJlJtJxJ{KAKFKGKJKNKTKYKeKjKmKwLDLILOLP"},
  {0,NULL,"LQLSLUL\\L^L`LbLiLjLnLoLpLrLxL}MAMBMFMHMNMTMVMWM\\MlMoMqMtMuMzNBNSN"},
  {0,NULL,"TNVNXN\\N^NaNdNnNoNwOEOJOMOQO`ObOfOhOmOnOsOtOvO{PBPCPEPIPJPKPQPZP["},
  {0,NULL,"P]P`PbPfPjPkPzP~Q@QDQGQHQKQNQOQSQWQYQ`QaQgQhQkQm_C?K?N?Q?U?Z?]?^?"},
  {0,NULL,"b?h?n?p?q?x?y?~@@@H@I@K@W@_@`@b@e@l@o@s@u@w@~A@AMANAPATAWAXA`AjAm"},
  {0,NULL,"AvAyA}A~B@BIBKBTBYB\\B^BcBeBfBnBoBsBtBuBvBxB{CECICSCYCeClCnCrCvDAD"},
  {0,NULL,"FDPDRDXDYD\\D]D_DbDdDgDiDlDmDxDzD|EBEGEKENEVE[E`EcEiEkElEqEwE{FIFN"},
  {0,NULL,"FRFSFXFYF\\F_FeFrFtFuFvFwGBGGGIGJGNGQGTG[GcGeGnGoGqGrGsGuGvG~H?HCH"},
  {0,NULL,"YH_HbHkHlHsH|IAIGIOISIUIVIXIZI\\I^IaIgImIpIuIvIxI|JBJHJLJSJWJeJfJh"},
  {0,NULL,"JiJlJtJyJzKAKGKMKRKTKUK[K`KaKnKyKzLELMLNLOLPLQLTLVLaLcLqLrLsLtLvL"},
  {0,NULL,"yL{L~MAMJMKMLMQMRMXM[MdMgMmMoMvMxMyNINJNLNRN[N\\N`NdNeNfNuNzOCOPOZ"},
  {0,NULL,"O]O_O`OcOlOmOnOoOrOuOxOzO{PDPGPHPNPRPVPYP^PaPdPfPvPwP{P|Q?Q@QDQIQ"},
  {0,NULL,"KQPQQQTQXQYQ_QaQiQjQkQnQo_C?K?N?R?Y?Z?\\?a?d?f?j?p?r?s?u@A@E@I@K@L"},
  {0,NULL,"@V@X@[@\\@g@m@p@v@w@x@~AEALAQARAUAVAaAbAjAkAxAzA{B?BGBLBMBVBXB]B`B"},
  {0,NULL,"cBdBgBlBmBuBwBxBzB|B}CACNCQC\\CbCcCnCpC{DCDGDJDLDNDRDXD[D^DiDkDlDo"},
  {0,NULL,"DrDsDwDzD|EAECEMEOEXE[EaEdEjElEmEpEuE{FHFJFKFLFMFZF^FeFgFsFxF|G?G"},
  {0,NULL,"AGEGFGKGMGOGSGTG\\GbGjGkGlGmGsGtGvGxHAHMHNHUHZHfHkHmHqI?ICIEILIMIT"},
  {0,NULL,"IUIVIYIaIbIfIlInIpItIuI{I}JBJGJHJQJRJbJdJgJiJlJsJuJwJ|KKKNKPKTKVK"},
  {0,NULL,"WK^KeKlK}L@LJLMLOLRLWLYL[L_LbLdLfLhLiLnLoLtLvMAMEMGMIMJMMMNM_MdMe"},
  {0,NULL,"MlMnMoMsMxM}NANJNONUNYN]NeNgNhNlNpNrOAOJOLOUO_O`OaObOeOfOhOjOtO~P"},
  {0,NULL,"?PFPGPJPMPNPOPRPUP\\P]PaPbPhPnPwPyQAQCQGQKQLQMQOQTQZQ[Q]Q_Q`QaQeQf"},
  {0,NULL,"_C?M?P?S?V?[?^?_?e?g?l?o?q?v?z@B@D@G@I@J@S@Y@c@d@g@k@n@p@r@w@}ABA"},
  {0,NULL,"QAVAZA]A^A`AcAiAmAyAzB@BDBEBFBLBVB]B^B`BdBeBfBgBkBoBpBqBrBwByCCCM"},
  {0,NULL,"CPCeCgChCnCoC{C~DHDJDODPDRDWDZDcDdDiDjDlDpDtDwDxE@EEEFEIEMETEXEaE"},
  {0,NULL,"gEjEpEqEsExE|FIFKFLFPFXFYF\\FfFhFqFrFxF{F}GFGHGMGOGPGSG\\G]GaGcGgGj"},
  {0,NULL,"GnGoGrGsGwGyG~HHHXHaHeHmHqHwH~ILIMIPIQISIWIXIYI[I]I_IbIeImIrItIxI"},
  {0,NULL,"zI~JEJGJHJPJ]JbJgJiJjJsJvJwJ}KHKKKLKOKWK\\K]KgKkKxKzK|LNLOLTLVLWL\\"},
  {0,NULL,"L^LaLbLhLkLlLmLwLzL{M?MCMGMKMLMPMSMYMZMaMhMnMrMtMuMyN@NDNENRNYNZN"},
  {0,NULL,"_N`NeNjNzN{OFOIOSO^O`OaOdOeOgOiOmOsOvOzO|P@PAPDPFPHPPPRPTPWP_PcPd"},
  {0,NULL,"PgPlPmP|QAQEQIQKQMQNQUQVQZQ]Q^QaQbQiQmQnQq_C?L?O?R?T?\\?]?_?a?f?m?"},
  {0,NULL,"o?p?u?w@A@F@J@K@L@N@V@[@]@f@j@q@r@s@y@{ABAMAPAUAWA`AaAcAgAhAwAxA}"},
  {0,NULL,"BABDBGBJBPBUB]B_B`BbBfBiBkBmBnBsBuBvBzCICJCMCWCaCiCoCqCsC}DFDHDID"},
  {0,NULL,"KDLDPDWDhDjDmDpDqDsDuDvDwD}E?EBEQEUEVEZEbEhEiEoEsEtE~F@FMFOFUFVFW"},
  {0,NULL,"FYF^F_FbFqFrFxFzGCGFGGGJGKGRGTG_G`GaGdGfGgGlGrGsGtGwG{HBHEHVHaHbH"},
  {0,NULL,"oHsHvH}IBIFIIIOIQIRIVIYI\\I^IdIhIjImIqIuIzJ?J@JFJNJPJYJ[J^JjJkJlJp"},
  {0,NULL,"JqK?KCKJKKKPKQKVKWK]KaKfKvLALFLMLNLPLXL]L`LaLcLdLiLkLmLnLyL{L|L}M"},
  {0,NULL,"@MEMNMPMRMSMZM^M_MlMnMqMvMzM{NANJNPNTN\\N]NfNgNhNlNtNvODOIOZO\\ObOd"},
  {0,NULL,"OeOgOiOmOoOpOqOyO{PAPBPGPLPMPQPRPYP`PaPcPePjPnPwPxQ?QAQBQFQIQKQLQ"},
  {0,NULL,"SQ[Q^Q_Q`QbQcQdQkQq_C?L?O?R?W?Z?`?d?e?f?i?r?s?v?x?|@E@G@K@L@R@T@X"},
  {0,NULL,"@\\@f@m@o@p@t@x@|AEALASATAUAZAaAbAiAjAxAzA~BBBGBKBLBRBTBVBXBcBdBiB"},
  {0,NULL,"lBmBqBvBwBxBzB}B~C?CTCYC]ChCpC{D@DADFDGDJDKDNDXDZDdDiDkDlDoDqDuDw"},
  {0,NULL,"DzD~ECEDEJEPEYE_EbEdEjEkEmEnEzE}FIFPFRFVFWFXF\\FaFcFwFzF}F~G@GCGDG"},
  {0,NULL,"LGUGVGWGYGZGaGcGdGeGgGhGoGqGrHCHFHHHQH[HdHiHnHrH{IGIHIKIPIQITIVIY"},
  {0,NULL,"I`IcIgIhIiIlIqIsIyI|I~JCJGJLJQJ_JaJhJjJkJoJrK@KBKEKFKIKSKXKZK_KoK"},
  {0,NULL,"qK|LELHLMLPLRLTLVLWL^LaLdLeLjLlLuLxLyL|L~MCMDMFMRMSMTMUM\\M`MiMpMq"},
  {0,NULL,"MsMuMxNDNINQNSNZN[N_NbNcNdNyN{OCOHONO[OaObOeOjOkOnOpOqOrOyOzPDPHP"},
  {0,NULL,"IPKPLPPPSPZP^PcPePfPlPtPvPzQ?QAQBQDQFQGQJQVQXQYQZQ^Q_QcQdQm_C?K?N"},
  {0,NULL,"?Q?X?[?`?a?c?h?k?s?t?w?z?{@?@H@I@L@P@Q@U@^@e@l@o@s@u@wA?ADALAPARA"},
  {0,NULL,"SATAYAZAgAlAwAyAzB@BDBHBMBNBQBUBWB[B_BgBiBjBkBlBqBwByB}C?CFCLC_Cg"},
  {0,NULL,"CiCuCwC}DEDKDLDNDODQD\\D]D`DaDhDlDmDpDrDvD{EAEDEFELETEWE_E`EcEiEkE"},
  {0,NULL,"lEqEvExFJFOFTFUFXFYF^FaFdFtFuFyF~G@GEGFGPGUGVGXG]G^GaGbGfGhGiGlGt"},
  {0,NULL,"GwGxGyHEHOHSHdHgHjHrHwHxIFIJIQITIUIWIXI\\I_I`IbIgIiInIrIsIwI{J?JIJ"},
  {0,NULL,"JJNJXJeJfJhJiJlJtJyJzKAKLKMKRKUK[K\\K`KnKqKvKyKzLMLRLTLYLZL]LaLcLd"},
  {0,NULL,"LhLpLsLvLxLzL|M?MBMIMLMNMQMSMYM]McMkMmMrMvMxM|NBNPNQNVNXN[N\\N^NdN"},
  {0,NULL,"fNuNzODOHOPO]O`OaOgOhOlOmOnOsOtO{O~PAPBPHPJPKPQPSPWPZPaPbPfPkPtPx"},
  {0,NULL,"P~QCQFQGQHQJQLQMQUQWQZQ^Q`QbQeQfQl_C?L?O?S?U?^?_?b?d?g?n?q?u?v?y?"},
  {0,NULL,"}@B@G@J@L@M@O@Y@d@e@h@s@t@u@v@{@|AOARAYA[A\\A]A^AhAjAvAyA{A|B?B@BI"},
  {0,NULL,"BNBQBVBWB[B`BfBhBjBoBqBtBzB{B|CBCGCUC\\CdCkCwC}D@DCDGDIDLDQDSDTDZD"},
  {0,NULL,"^DfDhDkDnDoDpDwD{D~EBEGELEREUE_E`EeEkElEoErEzE~FJFKFLFQFTFZF[F_Fc"},
  {0,NULL,"FtFuFvF{F|GBGHGPGWGXG]G^G_GbGeGgGjGkGlGnGuGvGzG|HMHTH^H`HrHuHxH}I"},
  {0,NULL,"DIIIJIKIMIRITI`IdIeIfIiIjIoIqIrI|J@JBJCJIJNJRJ`JfJhJjJlJnJyJzKDKH"},
  {0,NULL,"KIKLKOKQK\\KhKsKtK}L?LKLULYLZL[L^L_L`LbLdLeLfLkLpLrLuL{L~M@MAMBMDM"},
  {0,NULL,"GMPMZMaMbMiMqMrMsMwM{NANDNLNRNYN[N`NeNfNjNpNqNsOOOVOXO_OcOfOlOmOn"},
  {0,NULL,"OpOuOvOzPCPEPGPHPMPNPPPYP[P]P^PaPdPlPnP{P|Q@QHQIQJQLQNQOQVQWQXQZQ"},
  {0,NULL,"[QaQbQgQhQrQu_C?M?P?Q?W?Z?[?`?b?h?i?q?s?t?x?~@?@H@I@J@P@W@^@b@f@i"},
  {0,NULL,"@q@r@t@x@}AAAMAOARAWAYA\\A_AdAiAxA{A~BGBHBKBMBPBUB\\B^B_BbBgBhBjBlB"},
  {0,NULL,"oBvBxBzB|C@CRCUCbCjCmCoCqCtCxDPDQDSDUDVDWD[D^D`DbDcDeDjDsDvDxD~E@"},
  {0,NULL,"ECEQEUEXE]EbEfEjEnEoEtEuE|FGFHFNFOFSFUFZFcFfFvFzF~G?G@GBGCGJGKGPG"},
  {0,NULL,"TG^G`GaGdGhGiGmGnGpGqGvG}HGHNHTHWH\\HmHtHvH}IAIEIFILIMINIRI[IaIbId"},
  {0,NULL,"IjIkIoIrIuIyI~JAJMJOJPJYJ^J_JiJjJkJoJrK?KCKKKMKRKUKVK[KbKhKpKwLGL"},
  {0,NULL,"JLNLQLSLULZL]L_L`LbLgLhLpLtLuLwLyM?MAMJMMMOMSMTMYM[MdMkMmMnMtMwM~"},
  {0,NULL,"NINQNRNVN[N\\N_NcNdNfNoNrNxOGOVOYO_OaObOiOjOkOpOrOtOzO}PDPIPJPKPMP"},
  {0,NULL,"PPSPUPZP^P`PdPkPtPvP|Q?QHQIQJQMQRQSQTQYQ[Q\\Q^Q`QaQjQlQpQsQu_C?M?P"},
  {0,NULL,"?Q?T?]?^?a?c?h?m?p?w?y?z?{@@@G@H@I@Q@U@_@`@f@i@q@r@t@x@zACANAOAQA"},
  {0,NULL,"SAXAZA_AhAkAvAwAxBDBFBGBIBRBTBWBXB[BcBiBkBmBpBrBtBuByB{CDCHCKCVCc"},
  {0,NULL,"CkCpCyD?D@DMDNDRDTDUDVDZD^D_DaDcDkDoDtDzD{D}E?EEEJEPE\\E^EbEfEjEnE"},
  {0,NULL,"oEtEyF?FHFIFJFKFRFTFZF`FbFrFyFzF{GCGEGGGLGNGQGUGVGZGbGfGgGjGkGrGs"},
  {0,NULL,"GuGxG|HAHDH]HcHhHiHyH{I@ICIDIGIJILINIPIZI]I_IcIkIlIoIsIvIzI}J@JCJ"},
  {0,NULL,"QJVJZJ^J_JiJjJkJoJrK?KCKMKRKSKUKZK[KbKmKpLGLJLKLOLRLSLULVLYL^L_Lb"},
  {0,NULL,"LgLiLqLrLwLzL|MBMIMKMMMOMPMRMXM]McMgMmMpMtMwM}NBNJNLNPN[N\\N]NdNfN"},
  {0,NULL,"gNrNsNxOGOMOYObOdOgOiOjOoOpOsOuO|PAPBPGPIPMPNPPPQPRPXPYP`PbPwPxP{"},
  {0,NULL,"P~Q@QEQFQGQKQPQUQVQWQXQ]Q_QbQeQmQnQpQtQu_C?L?O?S?X?[?\\?c?e?g?k?o?"},
  {0,NULL,"r?t?z@C@D@G@J@K@S@Z@a@c@e@h@s@t@u@vAAADAPAQARATAUAVAYAeAfAvBABBBE"},
  {0,NULL,"BFBGBIBSBYBZB\\B^BeBgBiBlBmBpBrBsBuB}C@COCQCVCXCfCrCtCvC|DFDIDJDSD"},
  {0,NULL,"UDYD[D_DeDgDjDkDnDqDxDyE?EAEDEHENE[E^E`EeEkElEoErEvF?FGFJFTFVFXFY"},
  {0,NULL,"F]FgFiFqFvF}G?GAGBGCGIGNGQGSG[G\\GaGdGfGmGoGpGqGwGxH@HDHKHRHUHWHkH"},
  {0,NULL,"pH|I@IBICIDIKINISIVI]IaIcIdIfIhIpItIvIwIyJ?JKJOJSJWJ`JfJhJjJlJnJy"},
  {0,NULL,"JzKDKHKLKMKOK[K\\K^KhKtL?LBLKLMLTLWLXLYLZL_LcLdLeLhLnLpLsLwL|M@MBM"},
  {0,NULL,"FMIMLMOMSMYMcMhMjMmMrMsM{M|N@NENMNUNYN`NeNiNjNkNqNsO@OLOVOXO_OcOd"},
  {0,NULL,"OiOjOkOpOqOuOyO|O~P@PCPGPKPQPUPWP\\P]P^PcPgPhPmPrQ?QAQBQEQFQMQQQTQ"},
  {0,NULL,"\\Q^Q_QcQdQeQiQnQpQr_C?L?O?S?U?^?_?b?d?g?n?q?u?v?y?}@B@G@J@L@M@O@Y"},
  {0,NULL,"@d@e@k@n@o@q@wA@ACANAPATAXA[A\\AaAnAoAxA{B?BABBBHBMBNBOBQBWB[BaBhB"},
  {0,NULL,"lBsBtBuBvBzB|B}CBCDCGC\\CdCjCuCzD?DEDIDJDKDMDODTDVD`DfDjDkDrDtDuDy"},
  {0,NULL,"D{D|D~EBEMETEWE]E`EgEiEnEpEqE{E|FKFLFNFSFWFXFYFhFjFqFyFzF{F}GEGHG"},
  {0,NULL,"MGOGPGXG]G^GfGgGjGkGnGoGqGrGwGzG}HMH^H`HcHjHqHtHwIBIEIKILIMIQIWIY"},
  {0,NULL,"I[I_IcIdIeInIrItIxI|J@JJJTJVJXJ\\JeJhJkJlJtJxJ{KAKGKNKRKTKUKYKiKjK"},
  {0,NULL,"mKwL@LDLOLPLQLSLTLWLXLaLcLeLgLnLqLrLvLyM@MAMFMJMMMQMRMXM[MeMfMmMo"},
  {0,NULL,"MuMyMzN?NFNKNNNWNXN^NaNmNnNoOAOEOKOMOQObOdOeOhOiOjOkOsOtOxO}P?PEP"},
  {0,NULL,"GPKPLPOPQPVPXP[P^PePpPqPsPuQ?QAQBQCQFQPQRQUQ]Q^Q_QcQdQfQjQlQu_C?K"},
  {0,NULL,"?N?Q?U?Z?]?^?b?h?n?p?q?x?y?~@@@H@I@K@W@_@`@b@e@i@n@q@t@v@{@}AMARA"},
  {0,NULL,"WAYA]A^AbAdAoA~BABBBHBKBLBMBPBYB\\B^BbBeBjBlBnBoBqBvBxB|B}CCCICSCY"},
  {0,NULL,"CZClCqCtC|C~DHDNDPDUDWD[D\\DaDbDcDeDlDqDsDvDxD|D~EGEHEJESE^E`EfEnE"},
  {0,NULL,"oEpErEyEzFIFJFMFQFRFTF[F`FjFqFrFxFyF}GEGGGIGLGNGQGZG[GbGcGfGjGlGr"},
  {0,NULL,"GsGuGwH?HCHPHYHbHeHpHzH{I@ICIFIGIHINIPIUIZI\\I]IbIhIkIlIsIvIxJ@JBJ"},
  {0,NULL,"EJKJOJYJ\\J`JgJhJlJnJxJ{KDKFKHKIKJKOKQKfKgKrK{K~LHLRLYLZL[L\\L]L^L_"},
  {0,NULL,"L`LeLfLkLmLvLxL{L~M@MCMDMGMNMQM^M`MaMbMqMrMwM}M~NCNFNGNNNWNaNiNkN"},
  {0,NULL,"mNnNyN|N}OROSO\\OaObOdOeOgOkOqOsOtOwOxO~P?PEPHPLPOPTPVPWP[PaPePoPs"},
  {0,NULL,"PuP}QBQCQEQGQLQMQNQSQZQ\\Q`QcQeQfQhQmQoQy_C?K?N?R?V?]?_?`?e?f?l?o?"},
  {0,NULL,"v?w?x?|@F@H@K@L@N@R@T@]@g@j@n@r@u@y@zA@ALAOAYA[A\\A_AbAeAmAzA|BCBE"},
  {0,NULL,"BFBHBLBOBRBSBTBZBaBgBhBjBpBqBwBxB{B|CGCHCRC[C`CfCvCyCzDDDFDLDMDTD"},
  {0,NULL,"VD[D\\D_DaDgDnDrDsDuDyDzE@EFEGEKEQEREZEaEhEqErEsEtEwF@FGFMFTFVFWF]"},
  {0,NULL,"F^F_FfFxFyFzF{GCGFGHGJGRGWGYG_G`GdGfGgGjGqGsGtGwGxH@HIHJH\\H]H`HlH"},
  {0,NULL,"oHuHvIAIBICIFIIIOITI\\I^IdIjIlInIoIqIuIwIxIzJDJSJTJZJ]JcJgJhJiJmJv"},
  {0,NULL,"J}J~KEKGKSKXKYKZKbKiKsLBLCLILMLQLULXLZL[L]L_LdLfLgLhLlLqLrLxMFMGM"},
  {0,NULL,"HMIMKMQMTMUM\\MfMgMoMpMvM{M~N@NDNHNINZN_N`NbNcNjNwO?O@OKOOOYO`ObOe"},
  {0,NULL,"OgOhOiOsOuOvO|P?P@PCPDPHPJPOPPPWP^P_PbPdPgPiPlPvQ?Q@QCQGQLQMQRQVQ"},
  {0,NULL,"YQZQ`QdQeQfQgQnQt_C?L?O?R?T?\\?]?_?a?f?m?o?p?u?w@A@F@J@K@L@N@V@[@]"},
  {0,NULL,"@f@m@o@p@t@xACADAOASAZA]A_A`AcAfAoA|A}A~B@BCBJBKBOBPBSBUB_BbBfBhB"},
  {0,NULL,"kBnBoBpBsByB{CFCJCMCWCaClCtCxDBDEDGDHDKDODSD[D]DbDeDfDhDiDqDrDvDy"},
  {0,NULL,"E?EBEEENEOEXE]EbEdEjEkEmEnE{F?FHFIFMFRFZF[F^FgFhFsFuFxF|F~G@GFGJG"},
  {0,NULL,"KGMGTG\\G`GbGiGkGlGmGsGtGuGwG{H?HBHVHaHgHmHtH|I?IEIHIIIMISIUIVIYI["},
  {0,NULL,"I^I`IbIfIpItIuI}J?J@JMJOJUJXJ_JaJhJjJkJoJrK@KBKEKRKSKXKZK[KkKoKqL"},
  {0,NULL,"ELHLLLRLSLTLVL[L\\L^L_LbLgLjLkLrLsLzL|L}MBMDMKMOMQMRM]MfMgMjMmMpMs"},
  {0,NULL,"MuM}N@NCNHNKNWNZN_NbNcNkNyOBOCOHO[O^O`OaOcOfOhOkOlOnOrOwOxOzO|PBP"},
  {0,NULL,"CPLPWPXPYPZP[P_PcPgPiPpP}Q@QHQMQNQOQQQRQUQWQ\\QaQfQgQhQjQnQwQ|_C?L"},
  {0,NULL,"?O?R?W?Z?`?d?e?f?i?r?s?v?x?|@E@G@K@L@R@T@X@\\@f@j@q@r@s@yA@AAALAMA"},
  {0,NULL,"OAWA^A_AbAeAnAwAyAzA|BCBDBLBRBTBXBZBaBcBhBjBoBpBqBwBxByB}B~CSCTC]"},
  {0,NULL,"C_ChCrCyD?DDDFDGDHDMDTDYD\\DaDgDhDiDnDtDuDyDzD~E@EDEIEWE\\E^EbEhEiE"},
  {0,NULL,"oEsEtEvE|FHFOFPFQFUFZF\\FiFjFrFsFtFwF|GDGGGLGOGSGUGVGZGcGeGhGiGkGm"},
  {0,NULL,"GoGuGvHFHHHOHQHYH[HjHyH~I@ICIDIHIIIQIWIXIZI]I^I`IeIhInIsItIyI|JAJ"},
  {0,NULL,"DJVJWJZJ[J^JjJkJlJpJqK?KCKKKMKPKUKVKWKaKcKfKvKxLFLNLSLUL[L\\L]L_L`"},
  {0,NULL,"LcLjLkLpLtLvLwLyL}M?MAMDMLMMMSMdMeMhMkMmMnMzM{M~N?NGNONUN]NgNhNiN"},
  {0,NULL,"lNmNtODOFOWOZO\\O`OcOdOgOhOlOmOoOvOyOzO}O~PBPEPFPTPUPVPYPZP]PePhPo"},
  {0,NULL,"PqPyQ@QCQEQHQNQOQPQTQWQ]QaQeQgQhQiQlQqQx_C?K?N?R?V?]?_?`?e?f?l?o?"},
  {0,NULL,"v?w?x?|@F@H@K@L@N@R@T@]@g@m@p@v@w@x@}ADANAOAQAVA_A`AcAlAoAvA{A|A}"},
  {0,NULL,"B?BCBJBOBSBUBZBaBbBfBhBjBkBnBpBrBtB{CHCOCRC[C`CdCuCxC|DBDKDMDSDUD"},
  {0,NULL,"XD[D]D`DbDfDgDoDqDrDvDyEEEFEGELEPESEYEaEdEjElEmEpExEzFKFLFPFSFVFW"},
  {0,NULL,"F\\F`FaFwFzG?GAGBGCGDGRGVGWGYGZG_GcGdGfGgGhGnGoGpGqGzHIHJHRH\\H]HiH"},
  {0,NULL,"nHxHzIEIGIHIJIKIOITI`IcIgIjIkIlIpIqIsIwIxI~JJJKJMJUJbJdJgJiJlJsJu"},
  {0,NULL,"JwJ|KHKKKLKPKVKWK^KeKpKuK}L@LOLPLSLVLWLYL\\LaLbLhLmLoLpLqLwL{M?M@M"},
  {0,NULL,"GMHMJMLMPMZM^MhMkMnMrMuMxM}N?NGNPNTN]N^NgNhNlNnNpN~OAOGOJOLO_OcOf"},
  {0,NULL,"OjOlOpOqOrOtO{O}P?P@PAPEPNPQPTPVP\\P`PbPdPjPoPqPxQDQEQFQHQIQPQQQSQ"},
  {0,NULL,"XQbQcQhQiQjQkQlQsQ~_C?K?N?Q?X?[?`?a?c?h?k?s?t?w?z?{@?@H@I@L@P@Q@U"},
  {0,NULL,"@^@e@i@n@q@t@v@zAEANASAXAZA]A^AcAeAkAvAwBABBBDBIBJBNBQBRBWBXB[BfB"},
  {0,NULL,"iBkBrBsBuBwByB{C?CFCPC^C_CiCzD?D@DCDGDMDNDPDVDZD]D^DaDbDmDoDtDuDz"},
  {0,NULL,"D{E?EAEFEMEREUE]E`EfEnEoEpErEuF@FNFOFPFQFSFUF[FfFgFqFvF}F~G@GBGDG"},
  {0,NULL,"KGPGXG]G^G`GaGeGhGiGoGpGqGtGvHEHLHOHXHdHgHqHtHuH}IEIFIGIIILIRIXIY"},
  {0,NULL,"IZI[IbIgIjIoIrIuIwIyI{JCJRJTJVJ\\J`JgJhJlJnJxJ{KDKFKIKJKNKQKYKgKoK"},
  {0,NULL,"rK{K~LFLNLOLQLSLVL[L\\L^L`LjLlLnLoLsLxL{L}L~MEMFMHMLMNMUMVMWM_MoMq"},
  {0,NULL,"MtM}M~NENHNMNONWNYNiNjNkNmNtN|N}OROSO[O_OdOeOkOoOpOqOrOuOxOyO{O~P"},
  {0,NULL,"@PCPFPVPWP\\P]P_PcPfPiPmPrPyQAQDQIQOQPQQQRQVQXQ[Q]QdQgQiQjQkQvQz_C"},
  {0,NULL,"?K?N?R?Y?Z?\\?a?d?f?j?p?r?s?u@A@E@I@K@L@V@X@[@\\@g@j@n@r@u@y@{A?AUA"},
  {0,NULL,"XA[A\\A`AaAcAdAgAxA}BEBFBGBIBJBPBVB]B_B`BdBkBlBmBnBrBsBtBuBzCACBCN"},
  {0,NULL,"CXCbCcCoCsCwC~DHDIDLDMDPDQDXDcDgDhDjDmDoDsDvDwD|D}EAEHEIETE\\EaEhE"},
  {0,NULL,"qErEsEtEvEyFGFHFNFPFZF\\F]FdFjFsFvFwF{F|GDGHGLGMGOGSGUG\\GbGcGeGhGk"},
  {0,NULL,"GmGnGpGvHAHKHNHZH^HfHpHwHyH~ICIDIEINIOIQIXIZI_IeIhIjInIpIsItI{JAJ"},
  {0,NULL,"BJEJFJIJPJ]JcJgJhJiJmJvJ}J~KEKOKSKXKZK\\KdKiKsLBLGLILNLPLQLSLULXLZ"},
  {0,NULL,"L\\LaLeLfLoLqLsLuLzL~MBMCMHMIMJMOM]M`MiMjMpMrMvMzM~NCNKNQNSNXNZN_N"},
  {0,NULL,"aNbNcNwNxO@OKOOOTOcOiOlOoOpOqOsOuOvOwOxP@PIPJPKPNPOPSPXP[P\\PdPfPp"},
  {0,NULL,"PtPzP}QBQDQIQJQNQPQQQUQWQXQ\\Q^QiQjQkQmQrQtQ}_C?M?P?S?V?[?^?_?e?g?"},
  {0,NULL,"l?o?q?v?z@B@D@G@I@J@S@Y@c@d@g@h@u@v@x@y@z@|ALAWA[A\\A]A^AbAhAlAyA{"},
  {0,NULL,"A}A~B?B@BJBQBVBWB]B`BdBfBhBnBoBqBtBxByB|B~CCCPCWCeCgCpCsCwDCDGDID"},
  {0,NULL,"NDQDWDYDZD^DdDeDhDkDmDpDwD{E@EEEGEHEOE[E\\EaEeElEmErEtEwF?FGFMFUFX"},
  {0,NULL,"FYF]F^F`FiFqFwF}F~G?GAGDGMGOGQGSG[G\\GaGdGhGoGpGrGtGwGxGyG~HBHXH[H"},
  {0,NULL,"eHkHpHyI?IDINIRISIUIVIWIZI[I]IaIfIhIiItIvIwIzI~JFJIJQJRJcJdJgJiJk"},
  {0,NULL,"JmJuJ|J~KGKNKSKTKXKYK_KcKrKyLALLLMLRLULXLZL[L]L`LcLgLjLlLmLqLtLxM"},
  {0,NULL,"?MEMHMKMQMRMTMVMXM\\MfMoMpMwM{M|N?NBNFNTNXN]N^NaNlNnNuNvOBONOROWO_"},
  {0,NULL,"OfOjOkOlOnOoOqOrOwO{O}P?PAPBPDPSPTPVP_P`PbPePjPqPuP~QBQGQJQOQPQRQ"},
  {0,NULL,"SQTQWQYQ[Q\\Q_QfQkQlQoQqQzRA_C?M?P?Q?T?]?^?a?c?h?m?p?w?y?z?{@@@G@H"},
  {0,NULL,"@I@Q@U@_@`@f@l@o@p@s@y@~ABAMANAUAWAXA[AaAfAmAvA|A~B?BCBIBKBRBTBXB"},
  {0,NULL,"YBcBeBhBnBoBrBtBuBvBzB{CACDCKCVC[CkCrC{DADDDJDQDRDVDXDYD\\D^D_D`Dd"},
  {0,NULL,"DgDlDnDxDzD}EBEEEIEWEYE_EbEcEiEkEmEsExE~FJFOFTFUFVFWF]FdFhFsFyF|F"},
  {0,NULL,"~G@GAGEGLGUGVGXGZG]GaGbGdGfGiGjGmGtGxG|HDHIHcHfHhHjHnHrH~IAIJIKIN"},
  {0,NULL,"ITIWIXI_IaIeIgIiIkInIrIsIzI}J?JDJGJLJWJ[JaJgJjJkJpJqK@KBKFKIKJKPK"},
  {0,NULL,"QKWKdKjKlKuL?LCLNLPLQLWLXLZL]LcLdLgLiLkLmLnLoLuL}M@MEMGMOMPMTMWM^"},
  {0,NULL,"M_MaMnMqMvMyM|NCNENHNNNWNZNbNiNkNmNqN~O?OQOTOUO_OaOcOfOhOnOrOtOvO"},
  {0,NULL,"wO|O}P@PCPLPMPOPUPXP[P_P`PcPiPmPsP}QAQCQDQJQNQRQSQTQYQZQ[Q\\QcQgQi"},
  {0,NULL,"QlQtQ{Q~R@_C?M?P?S?Y?\\?b?c?d?g?j?r?t?u?y?}@C@G@H@J@M@O@Z@a@g@k@n@"},
  {0,NULL,"p@r@wA?ACAMAPATA[A\\A`AcAkAnAzA{B?BABBBKBLBNBOBSBZB[BaBiBnBsBtBvBx"},
  {0,NULL,"BzB|B}CECJCLCZC]C^CuCyCzDBDKDODTDVDWDYD]D`DaDdDeDfDtDuDyD{D|D}ECE"},
  {0,NULL,"KEPESEZEaEgEjEpEqEsEyE}FGFOFPFQF[F\\F]FbFeFtFuFxG?G@GAGFGIGNGRGWGY"},
  {0,NULL,"G_GeGhGiGlGmGpGtGuGxHFHLHPHSHVH_HiHlHoHzIAIBIGIHIPIRIWI[I\\I^IcIiI"},
  {0,NULL,"kImIqIvI{I}JAJJJTJUJZJ]JbJgJiJjJsJvJwJ}KEKHKLKOKZK\\K]KkKnKxK{K|LN"},
  {0,NULL,"LQLULVLXL\\L`LaLcLfLmLsLtLuLzL|L~M?MCMDMEMIMOMbMcMiMjMpMrMtMyMzNAN"},
  {0,NULL,"LNMNUNYN`NeNgNhNjN{N|OFOIO]O^O`OaOeOfOgOjOkOnOtOwOyO~PDPFPMPNPRPS"},
  {0,NULL,"PUPYP\\P_PaPhPnPrP{Q@QFQJQLQQQRQSQTQXQYQ[Q\\QdQeQhQlQvQyQ|R?_C?M?P?"},
  {0,NULL,"S?Y?\\?b?c?d?g?j?r?t?u?y?}@C@G@H@J@M@O@Z@a@g@h@u@v@x@y@~AAALAPAQAS"},
  {0,NULL,"ATAVAbAdAfAwA}BABBBEBFBJBOBSBYBZB\\BaBgBiBkBmBrBsBvBwB}CECLCTCZC^C"},
  {0,NULL,"aCvCxC|DDDFDODSDUDYDZD\\D_DbDeDnDpDqDtDxDyD}EAECELEQEREYEaEeElEmEr"},
  {0,NULL,"EtEuE~FKFLFMFQFRF[F^FcFdFtFuFwF{GDGGGHGRGWGXGYG^G_GcGeGiGjGkGlGnG"},
  {0,NULL,"sGuG{HLHPHQHSH_HnHuHvHxIFIIIJIKIPIRISI]I`IdIgIiImIoIqIrI}JAJBJDJK"},
  {0,NULL,"JMJSJcJdJgJiJkJmJuJ|J~KGKNKPKTKVKYK_K`KcK~LALLLMLRLTLWLYL[L]L^LbL"},
  {0,NULL,"iLlLoLtLvLyLzL}MCMEMJMKMMMNMWM[MeMlMnMoMsMwM|NKNNNSNVNXN^NaNbNcNn"},
  {0,NULL,"NvN}OBONOPOWOdOiOlOmOoOqOrOuOvOwOxPAPFPIPJPLPOPRPSPTPXPZPfPkPpPsP"},
  {0,NULL,"zQ?QCQDQEQHQKQUQVQ]Q`QbQcQgQjQmQnQoQzQ|R?_C?M?P?Q?W?Z?[?`?b?h?i?q"},
  {0,NULL,"?s?t?x?~@?@H@I@J@P@W@^@b@f@l@o@p@s@y@|A?ARASAUAVAYAZAaAlAnAwA|BCB"},
  {0,NULL,"DBEBHBMBNBPBQBUB_BbBgBiBjBlBmBpBwByB|C@CNCUC`CjCmCsC}DBDEDIDLDODQ"},
  {0,NULL,"DRDUD]D_D`DcDfDmDpDrDvD{E@ECEDENEOEVEZEbEcEiEkEmEsEwE}FIFLFNFRFSF"},
  {0,NULL,"VFWFeFiFrFsFvF|GBGGGHGIGJGKGTG[G`GcGgGkGnGpGqGrGuGvG}HGHJHTHWHZHo"},
  {0,NULL,"HsH|I?IAIBIJILIOISIUI\\I_IaIfImIoIpIuIvI|I~JAJFJNJUJXJ[JaJgJjJkJpJ"},
  {0,NULL,"qK@KBKEKFKIKJKQKXKdKlKtKuLCLDLOLPLRLTLVLWLXLYLdLeLfLiLjLlLuLwMCMD"},
  {0,NULL,"MFMHMMMPMTMUMVM`MbMpMqMxMyM|NFNGNMNONWNhNiNkNlNmN~O?OEOTOUOXOcOfO"},
  {0,NULL,"gOhOmOoOsOuOvOyO|O}P?PEPFPIPPPTPUPXP\\P]PePoPrPuPyQBQEQKQLQOQQQUQV"},
  {0,NULL,"Q]QbQdQfQhQkQmQnQsQ{Q}R@_L?M?N?T?V?X?[?^?c?i?k?l?o?r?v?}@B@C@G@I@"},
  {0,NULL,"K@a@c@d@h@i@j@n@u@v@}@~A?AFAGAJAOA_AaAgAjAoApAqAuAwBDBKB_BbBcBlBn"},
  {0,NULL,"BuBwBxB{C?CDCFCICKCUC[C]C`CaCbChCnCxCzC{C}DADHDKDODPDYD\\D`DcDfDkD"},
  {0,NULL,"oDsDyDzD{EHELEVEXEYE_E`EaEbEkElEmEvEwE~FJFUFVFXF]F^F`FcFgFwF}F~GA"},
  {0,NULL,"GBGCGIGLGMGNGOGTGfGhGmGpGrGwGyHBHDHJHKHOHRHWH[H]HeHgHpHyI@IBIDIKI"},
  {0,NULL,"RIUIVI[I]IaIdIiIpIyIzJBJFJJJOJRJSJTJaJbJeJoJpJvJxJ{J}KHKIKKKNKUKZ"},
  {0,NULL,"K]KbKeKmKnKoKwKxK~L@LGLHLMLOLPLVLXL^LkLvLzL}MAMDMJMSMTM]M^MbMdMiM"},
  {0,NULL,"kMtMxM{NDNENGNKNSNTNXN\\N`NbNgNmNoNtNzO?OAOFOIOMOOOTO\\O]O_O`OaOhOk"},
  {0,NULL,"OvPEPIPNPPPRPXP`PaPcPoPpPsPtPwPxQBQEQIQLQOQTQWQ\\Q_Q`QjQnQoQrQtQuR"},
  {0,NULL,"?RC_K?L?P?W?X?Y?\\?d?e?i?j?n?p?s?x?|@A@F@G@I@K@T@X@[@h@i@j@r@x@y@|"},
  {0,NULL,"ABACAFAHAKANARAYAkAlAmArAsAuB@BABBBQB[BeBgBoBrBtBvByCECGCLCOCPCQC"},
  {0,NULL,"YCiCjCkClCmCnCxCzC{C}DADHDKDNDWDZD]D^D_DfDgDkDrDvDxDyEKEMEVEZE\\E_"},
  {0,NULL,"E`EaEbEiEqEsEyE|F@FHFNFOFQF\\F]F_FdFiFrFsFtFvFwGHGMGQGVGZG\\G]GbGhG"},
  {0,NULL,"kGoGpGuG}HAHFHKHOHPHSHWHYHZH[H^HpHyI@ICIEIIIOIWIXI^I_I`IeIhIjIyIz"},
  {0,NULL,"JBJDJIJMJPJUJVJaJbJeJoJrJuJzJ{J|KGKHKIKPKXK[K^K`KhKkKlKoKuKyK}LAL"},
  {0,NULL,"HLKLMLNLOLSLTLWLmLxL|L~MAMGMNMPMQMVMaMbMcMfMgMsMyM~NFNINJNONPNSNY"},
  {0,NULL,"N\\N_NgNkNnNoNpNyN{N}N~OLOMOROYO[O^OaObOlOnOtOvO|P?PGPQP]P^P_PcPfP"},
  {0,NULL,"jPmPrPuPxP{QBQCQNQPQRQVQWQ[Q^QbQeQiQoQpQqQtRDRFRG_K?L?P?T?V?X?]?`"},
  {0,NULL,"?a?j?k?m?t?y?z?~@?@@@G@H@L@P@U@_@h@l@m@o@s@t@{A@AEAHAIAJAQAVA\\AhA"},
  {0,NULL,"iAnApAqAuA}BJBLB`BaBdBhBpBqBsBzB}B~CHCJCMCNCRCXCZC\\C^CeCfCnCsCtCy"},
  {0,NULL,"CzD?DFDGDPDWDZD\\D`DcDfDkDoDsDvDxDyEKEMEVEZE\\E_E`EaEbEiEqEsEvEwE~F"},
  {0,NULL,"OFTFWFYF]F^FaFeFhFsFtFyG@GAGFGLGOGPGWGZG^GaGbGdGhGjGlGyG{G|HEHIHK"},
  {0,NULL,"HRHSHaHdHfHhHnHrHxIAIJINIQIUIWI\\IaIbIeIgInIwI|I}JGJIJOJWJXJYJ\\J]J"},
  {0,NULL,"^JmJnJoJrJsKDKEKFKHKNKRKVK^KfKkKmKpKrKwK|K}K~LELJLSLULVLZL\\LcLlLy"},
  {0,NULL,"L{MAMCMEMIMKMMMZM\\M`MbMeMlMzM|M}NBNHNLNMNRNSN]N`NcNfNiNnNoNrNtN}O"},
  {0,NULL,"@OBOGONOOOROXO\\OaOdOeOhOiOuPEPIPNPVP\\P_PbPdPePjPnPqPvPzP|QBQCQDQJ"},
  {0,NULL,"QOQUQZQ_QaQbQiQlQoQsQxQ|R@RDRGRH_K?M?O?T?U?Y?Z?]?a?l?m?n?q?y?z?{?"},
  {0,NULL,"~@?@G@I@K@U@_@b@h@i@j@q@s@tA@ADAEAGAIAKAVA[A\\AfAiAnApArAtAzA}BJBS"},
  {0,NULL,"BaBdBfBmBpBqBzB}CACJCMCNCRCTC\\C^CdCeCfCgCnCxCzC{C}DADFDGDNDODYD]D"},
  {0,NULL,"`DcDgDjDnDrDvDwD{EKEMEXEYE]E^E`EaEbEjEnEpEuEzF?FHFIFJFKFMF[FbFfFj"},
  {0,NULL,"FrFxFzF{F}GEGIGSGUGVGYG[GcGfGkGuGwGxGzH?HAHBHDHPHVHYH]H^HcHeHpHyI"},
  {0,NULL,"@IFIHIJILINIPIZI\\IbIcIlIoIyIzJBJCJKJNJXJYJZJaJbJeJpJqJvJyJzJ|KGKJ"},
  {0,NULL,"KKKUKXK\\K]K`KdKjKqKsKxKyLBLCLDLFLNLPLWLYL^LaLjLsLtM?MEMFMGMKMTMYM"},
  {0,NULL,"\\MeMfMjMkMuMvMwN?NENJNMNNNRNXNYN[NbNkNlNpNuNvO?OCOEOHOLOPOTOVOWO_"},
  {0,NULL,"O`ObOfOgOnO}P@PKPOPRPZP\\PdPfPgPpPqPrPyPzQ?QEQGQHQPQSQXQ\\QdQeQgQmQ"},
  {0,NULL,"pQqQrQzQ}RCRGRH_K?M?O?U?V?W?_?d?e?i?k?l?s?w?x@A@E@F@G@H@L@N@T@X@h"},
  {0,NULL,"@l@m@p@x@yAAABACAFAGAJARAXAYAdAkAmAqAsAtAyB@BAB[B\\BeBiBrBtBvByB|C"},
  {0,NULL,"BCCCECGCPCQCVC_CiCjClCmCnCsCtCyCzD?DHDKDODPDYD\\D^D_DjDnDoDsDvDwD{"},
  {0,NULL,"EKEMEXEYE]E^E`EaEbEjEnEpExE{E}FIFKFPFSFWFXF`FcFgFzF}G?G@GBGDGLGNG"},
  {0,NULL,"RGUGXG_GaGcGdGeGfGnGyGzHCHGHHHIHQHRHTH\\HdHeHnHrHxIEIGIOIPITIVIYI`"},
  {0,NULL,"IcIhIkIpIwI|I}JFJKJLJPJQJUJ\\J]J^JmJnJpJqJtJ~KMKNKQKSKVK\\K]KaKbKrK"},
  {0,NULL,"sKtKvK~L?LBLGLLLPLQLULVL[L`LkLvLzMFMIMLMNMOMQMYM[M_MaMcMlMtMxM{N?"},
  {0,NULL,"NCNHNINONVNWNXNZN`NfNhNuNxO@ODOEOFOIOOOPOQOUOZOdOgOhOjOqOsPCPJPMP"},
  {0,NULL,"RPVPYP[P]P^PkPmPpP{P|P}QDQFQGQHQKQTQXQZQ\\QcQhQnQrQwQzQ|Q~R@RGRIRJ"},
  {0,NULL,"_N?O?P?T?U?Y?^?b?c?i?j?n?r?u?v@B@C@D@G@H@L@M@a@d@h@l@m@u@v@w@z@}A"},
  {0,NULL,"?AFAHAKAUA_AaAeAgAoApArAtA~BDBKBRB_BbBjBkBuBwBxB{C@CDCFCICKCSCWC]"},
  {0,NULL,"C`CbCcChCnCsCtCyCzD?DHDKDNDWDZD]D`DcDgDjDnDrDwDxDzEHELEZE\\E]E^E`E"},
  {0,NULL,"aEbEoErEtEuEzF?FKFMFQFRFTFZF_FdFiFtFvF{F|GDGGGPGRGVGYG]G`GbGcGgGi"},
  {0,NULL,"GlGnGzG{G|HCHNHPHQHSHTH^HbHfHnHrHxIDIFIIIKIMISI]IfIiIjImIoIwI|I}J"},
  {0,NULL,"EJHJMJNJRJSJ\\J]J^JqJrJsJtJwKAKEKFKGKMKWK\\KaKgKiKjKkKlKuKvKyK|LDLI"},
  {0,NULL,"LNLQLSL[LbLcLmLxL|MDMFMHMMMRMSMUMYM]M^M`MhMsMyM~N?NKNLNQNTNUNWNYN"},
  {0,NULL,"ZN]NdNnNrNwN{N|OCOEOGOHOLOQOSO^ObOeOgOjOmOuO}P@PKPUPWPXPYP_P`PiPj"},
  {0,NULL,"PoPtP}P~Q?QHQJQMQQQVQ[QbQcQfQgQkQxQzQ{Q~RARDRHRIRJRK_L?M?N?T?U?Y?"},
  {0,NULL,"\\?_?d?i?j?n?q?t?y@B@C@D@H@J@L@O@Y@Z@h@i@j@n@u@vA@ADAEAGAIAJAMAWAZ"},
  {0,NULL,"AkAlAmAqAsAuAxBCBGBTBUBXBjBkBlBnBwB{B~CACHCJCMCNCVCYC_CjClCmCpCrC"},
  {0,NULL,"uC~DBDEDJDMDRDSDVD[DaDdDiDmDpDuDvDwDxENEOEPEREWE[E`EaEbEkElEmEuEz"},
  {0,NULL,"F?FJFLFRFZF[F^F_FdFiFuFwF|GBGGGHGPGRGVGYG]G`GeGgGiGjGsGvG{G|HCHLH"},
  {0,NULL,"MHNHQHTH_H`HbHfHuHvH}IDIJIPIRISITI]I`IdIeIfIgIwJ@JAJCJDJEJHJIJKJa"},
  {0,NULL,"JbJeJoJpJvJxJ{J}KGKJKKKUKXK\\K]KdKeKfKmKnKwKxKzLBLCLFLPLVLXLYL^LaL"},
  {0,NULL,"gLhLnM?MDMLMMMOMTMVM\\M_MdMgMkMwMxMzNENFNINKNLNMNYN\\N_NgNkNnNoNxNy"},
  {0,NULL,"NzOAOFOIOJOMOROYO[OaOhOkOlOtOvOyO{PDPQPXPYPbPcPePgPmPvPwPxPyQ?QGQ"},
  {0,NULL,"HQJQPQVQ[QbQcQeQgQiQpQqQzQ}RDRF_L?M?N?U?V?W?Z?]?`?i?k?l?o?r?v@A@E"},
  {0,NULL,"@F@G@H@K@R@\\@]@i@k@m@p@r@x@z@~A?AHAIAKAPA]A^AfAhAnApArAuBHBIBMBNB"},
  {0,NULL,"WBYBgBiBoBrBtBvC@CDCFCICSCUCXC\\C^CeCfCgCoCrCvDCDDDEDIDLDRDTDVDXDa"},
  {0,NULL,"DeDhDmDqDtDvDwDxENEOEPEREWE[E`EaEbEkElEmExE{E}FLFRFSFVFXF\\F`FcFgF"},
  {0,NULL,"wF}F~GAGBGCGLGNGRGUGXG_GeGfGgGhGpGrGyGzHCHFHGHJHRHTH[H]HdHeHiHzH{"},
  {0,NULL,"IEIHIJIKIQIVIYIgIiIjIlIpIxIyI}JCJFJGJJJMJPJ[JcJfJvJ}K?KAKCKDKJKOK"},
  {0,NULL,"SKVKYK[KcKdKfKgKhKiK{LALFLILJLKLWLZL]L_LaLcLfLiLrL}MAMBMEMFMLMVMW"},
  {0,NULL,"MXM]MbMjMuM|M~N?N@NANBNINUNZN\\NaNeNhNmNoNtNvNwNzO?OKOMOTO\\O]O^O`O"},
  {0,NULL,"mOpOrOuOvOwO~PBPOPVPWPXP^PaPnPrPsPuPwP~QDQFQGQHQRQUQXQZQ[Q]QcQhQp"},
  {0,NULL,"QyQ|Q~RBRFRM_L?M?N?T?V?X?[?^?c?j?k?m?p?s?w?~@?@@@G@I@L@Q@^@`@j@k@"},
  {0,NULL,"l@o@q@s@|AAACAFAGAKA`AbAcAeAjAoArAsAtA{BEBFBOBVBZBfBhBmBqBzB}CCCE"},
  {0,NULL,"CGCOCPCQCWC]C`CaCbCcCpCqCvD@DBDCDIDMDQDTDUD[DbDeDiDlDtDuDvDwDxENE"},
  {0,NULL,"OEPEREWE[E`EaEbEkElEmEvEwE~FJFUFVFXF]F^FaFeFhFuF|F~GAGEGFGLGOGPGW"},
  {0,NULL,"GZG^GfGhGiGjGmGwGyG{HDHIHKHOHRHSHaHcHfHgHjHwH~IAIFIKITIUIXI\\I_I`I"},
  {0,NULL,"aIiIkIzI{I|JDJJJLJNJOJYJ_J`JdJwJxJ{J~K?KCKFKKKOKRKTKZK]KbKeKgKhKo"},
  {0,NULL,"KxK{L@LDLGLHLOL[L]L^LbLdLeLqLwL~MDMEMHMIMJM[MdMfMhMiMjMsMtMvNBNGN"},
  {0,NULL,"HNJNKNON_NaNfNiNjNlNsNvNwNxNyN|OKOSOVOWOYOZOjOnOoOpOqOtOxOzPFPPPR"},
  {0,NULL,"PTP^P_PbPgPhPlPoPpPuQ?Q@QCQDQJQUQZQbQdQhQiQlQqQxQyQ}R@RBRMRN_K?M?"},
  {0,NULL,"O?T?U?Y?Z?]?a?j?k?m?o?r?u?|@E@F@I@J@K@V@\\@]@h@l@m@p@x@y@z@}A?AFAG"},
  {0,NULL,"AKAPATA^AhAiAnAqAsAuAvBHBIBNBWB^BgBoBrBvByB|C?CDCICKCSCUCXCZC^CdC"},
  {0,NULL,"fCgCoCqCuC~D@DDDIDMDQDTDUD[DaDdDiDmDpDuDxDyDzEJEOEPESETEUE`EaEbEj"},
  {0,NULL,"EnEpEuEzF?FHFIFJFKFMF[FaFeFhFsFuFxG?G@GEGJGOGPGSG[G`GkGtGuGvGwGxH"},
  {0,NULL,"?HAHBHDHLHMHUHVHZH_HcHgHkH|I?IHIIILIMITIVI[I`IbIlInIpI~J?JBJDJGJM"},
  {0,NULL,"JRJXJZJ\\J]J^JmJnJpJqJtJ~KEKFKGKMKWK\\K]K`KaKbKjKsKuKvKxKyLBLDLNLPL"},
  {0,NULL,"QL[L`LbLeLqLwM?M@MBMFMNMSMUMXMYM\\MbMcMsMtMvN?NANCNMNSNTN]N`NcNfNi"},
  {0,NULL,"NnNqNxN}O@ODOFONOOOROXOYOZOaOdOhOiOqOsOyO{PDPPPVP[PaPdPfPoPqPrP{P"},
  {0,NULL,"|P~QAQJQMQOQQQVQ_QaQbQfQjQlQoQsQxQ{RARDRMRO_K?M?O?U?V?W?_?d?e?l?m"},
  {0,NULL,"?n?q?y?z?}@C@D@G@I@L@O@S@Y@j@k@l@n@u@w@{ADAEAFAHAJAMASAWAdAkAlApA"},
  {0,NULL,"rAuA|BCBGBPBUBXBkBlBuBwBxB{B~CHCJCNCRCTCVCYCiCkClCmCpCqCvD@DBDCDJ"},
  {0,NULL,"DLDQDSDUDXDaDeDhDmDqDtDxDyDzEJEOEPESETEUE`EaEbEjEnEpExE{E}FIFKFPF"},
  {0,NULL,"SFWFXFbFfFjFrFxFzF{F}GEGKGSGUGXG\\G^GaGcGfGkGnGwGyGzG}H?HHHIHYH\\H^"},
  {0,NULL,"HaHcHeHjHwH~IBIEILIPISIWIYIbIcIdIeImIzI{I|JHJKJPJSJTJXJ_J`JdJmJyJ"},
  {0,NULL,"zJ~K?K@KMKOKPKQKYKZK^KaKbKcKrKtKvK~L?LALGLILOLRLTLUL[L_LoLpLuMEMN"},
  {0,NULL,"MOMPMRMTM^M_M`McMjMkMyM{M}NBNCNDNFNLNVN^NbNdNeNiNlNpNqNvN}O?OCOHO"},
  {0,NULL,"LOTOWOXO]O_OeOiOnOpOrOwO~PBPPPYPZP\\P]PePkPoPxPyPzP}QAQLQNQQQRQUQ]"},
  {0,NULL,"Q^Q`QaQkQlQtQvQxQ{R?RBRNRORP_K?M?O?W?X?Y?[?b?c?i?k?l?s?w?x?{?~@@@"},
  {0,NULL,"H@J@L@Q@W@^@h@i@j@q@s@t@|ABACAHAIAKALA`AbAgAjAoApAqAtB?BEBFBOBVB]"},
  {0,NULL,"BfBhBpBsBzB}CBCCCECLCOCQCWC[C]C`CcChCpCrCuC~DBDEDIDLDRDTDVDXDbDdD"},
  {0,NULL,"hDlDpDqDxDyDzEJEOEPESETEUE`EaEbEjEnEpEyE|F@FGFHFOFPFSF[F`FcFgFzF}"},
  {0,NULL,"G?G@GBGDGJGMGTGXG]G_GaGdGeGnGtGvH@HEHGHHHLHNHQHTHUHXH\\HdHuHvH}IEI"},
  {0,NULL,"FIGIMINIXIYIZI[IaIkIoIwJ@JAJLJOJPJRJVJWJaJbJeJpJqJvJyJzJ|KGKHKIKP"},
  {0,NULL,"KXK[K^K`KcKdKjKqKyK}LALCLELKLNLSLTLWLYLaLfLiLrM?MGMHMIMQMRM\\M^MaM"},
  {0,NULL,"fMiMlMuM|M~NDNGNJNMNPNQNXN\\N`NbNgNmNuO?O@OCOEOFOIOOOPOQOTO\\O_O`Of"},
  {0,NULL,"OgOhOkPAPHPLPRPSPTPXP[P\\PjPlPpPwPzP{QBQIQMQNQRQVQWQ[Q]Q_Q`QjQoQtQ"},
  {0,NULL,"uR?RDRFRMRNRPRQ_L?M?N?T?U?Y?\\?_?d?j?k?m?p?s?w?|@E@F@I@J@L@N@X@[@i"},
  {0,NULL,"@k@m@p@r@x@|AAABAHAIAJANAXAYAdAlAmApArAtAyBABBBQB\\BeBgBiBoBtByB|C"},
  {0,NULL,"BCCCECGCLCOCVCYC_CiCkCmCsCwCyC|C}DADFDGDPDWDZD\\D`DcDgDjDnDrDyDzD{"},
  {0,NULL,"EHELEVEXEYE_E`EaEbEkElEmEuEzF?FJFLFRFZF[F^FaFeFhFuF|F~GAGEGFGJGOG"},
  {0,NULL,"PGSG[G`GiGjGmGsGvGwG{H?HDHLHMHNHUH_HaHcHfHgHmHqHtICIEIHISITIUIYI^"},
  {0,NULL,"I`IaIfIlI{I~J@JDJHJOJQJUJZJ[JcJfJvJ}K?KAKCKDKEKJKLKUKWKYKcKdKfKiK"},
  {0,NULL,"mKnKwKzK|LCLFLILRLXLZL_LaLcLlLyL{L~MBMHMLMNMTMVMWM[MaMhMkMzM|M}NA"},
  {0,NULL,"NCNENINPNQN[N]NaNcNjNmNsNtNvNwN|O?OGOKOSOVOWO\\O`OfOmOoOpOuO}P@PKP"},
  {0,NULL,"QPTP[P^PaPePkPlPmPsPuPvQAQEQMQOQQQSQYQ_QaQfQjQmQsQuQvRARCRERGRIRJ"},
  {0,NULL,"RL_L?M?N?U?V?W?Z?]?`?i?j?n?q?t?y?{@?@@@H@J@K@P@_@b@j@k@l@o@q@s@{A"},
  {0,NULL,"DAEAFAHAKAQA[A\\AfAhAiAqAsAtAzBJBLBSB`BdBfBhBmBpBsB}B~CACHCMCRCTCX"},
  {0,NULL,"CZC\\C^CdCgCtCwCxC{C|D?DHDKDNDWDZD]D^D_DjDnDoDsDyDzD{EHELEVEXEYE_E"},
  {0,NULL,"`EaEbEkElEmExE{E}FLFRFSFVFXF\\F_FdFiFuFwF|GBGGGHGKGNGQGRG\\G`GeGgGp"},
  {0,NULL,"GrGsGvG~HCHFHGHJHMHTHZH[H_H`HbHlHoHsIAIJILISIVIXIZI\\I_IfIgIpIxJ?J"},
  {0,NULL,"AJCJFJHJVJWJXJ_J`JdJwJxJ{J~K?KCKMKOKPKQKYKZKbKcKgKhKiKoKvK{LALGLI"},
  {0,NULL,"LKLOLTL[L]L_LbLmLxL|M?MBMCMEMJMOMWMZM\\M_MiMjMsMyM~NANBNGNNNRNVNWN"},
  {0,NULL,"^N_NdNgNjNsNxNyN|OAOFOIOJOQOSOYO[OcOjOkOoOqOtPCPJPMPOPTPWPbPcPdPg"},
  {0,NULL,"PlPnPxPzP~QAQKQLQNQQQTQWQYQ^QfQkQnQtQvQwQ{R?RERGRHRKRLRS_K?L?P?U?"},
  {0,NULL,"V?W?[?^?b?l?m?n?o?u?v?}@C@D@I@J@L@M@c@d@i@k@m@n@v@w@z@~A?AGAIAKAO"},
  {0,NULL,"AUA_AeAgAjAqAsAtAwA~BKBRB_BcBjBkBlBnBuBwC?C@CICKCSCUCWC[C]C`CaCcC"},
  {0,NULL,"sCwCyC|C}DADFDGDNDODYD]D^D_DjDnDoDsDvDxDyEKEMEVEZE\\E_E`EaEbEiEqEs"},
  {0,NULL,"ExE{E}FIFLFNFWFYF\\FbFfFjFqFrFyFzGFGHGKGSGUGXG\\G^GaGjGkGoGqGsG}G~H"},
  {0,NULL,"?HHHIHMHXHYH\\H`HaHcHmHqHtIBIKIMIPIQIXI[I]I_IcImInI{I~J@JEJGJJJKJS"},
  {0,NULL,"JVJ[JcJfJnJuJ|KBKCKDKJKOKSKVKYK[K_K`KfKhKpKsK{LBLFLJLKLLLWLZL]L`L"},
  {0,NULL,"aLdLjLsLtL}MBMDMIMPMRMUMWM]MdMgMlMuMvMwNANDNFNHNTNUN[N^NcNeNhNkNs"},
  {0,NULL,"NuNyN~O@OBOJONOPOUOVO[OcOdOfOlOoOsPCPJPMPPPSPUP`PePfPhPiPrPtPvPwQ"},
  {0,NULL,"AQDQGQNQRQUQXQ]Q^QaQeQlQpQsQvQ|RBRFRHRIRJRKRSRT_K?L?P?U?V?W?[?^?b"},
  {0,NULL,"?i?j?n?p?s?x?{@?@@@I@J@K@W@^@`@h@l@m@o@s@tAAABACAGAIAJALAbAcAeAgA"},
  {0,NULL,"oApArAuA{B?BFBOBZB]BfBmBpBqBsBzCBCCCGCLCOCPC[C]CaCbCcChCoCqCuC~D@"},
  {0,NULL,"DDDJDMDRDSDVD[DaDeDhDmDqDtDwDzD{EIENEQESETEWE`EaEbEiEqEsExE{E}FIF"},
  {0,NULL,"LFNFWFYF\\F_FdFiFrFsFtFvFwGHGKGNGQGRG\\G`GkGoGpGqGsGuG}G~H?HFHJHMHW"},
  {0,NULL,"HYHZH[H_H`HkH|I?IBIGIJIOIUIXI^I_IaIgImIoI~J?JBJCJLJNJSJUJVJ\\J]J^J"},
  {0,NULL,"mJnJoJrJsKDKMKNKQKSKVK\\K_KfKmKpKrKsK~L?LBLFLJLLLPLULVLZL\\L`LgLhLn"},
  {0,NULL,"L}MCMGMIMJMNM]McMeMfMhMlMwMxMzNCNGNHNQNRNUNWNYNZN]NdNnNoNpNrNtN{N"},
  {0,NULL,"}OGOHOLOMORO^OaObOeOiOmOuOwO~PBPQPSPTP_P`PdPhPiPjPmPpPqQFQHQKQLQQ"},
  {0,NULL,"QTQYQcQfQgQkQnQrQwQzQ{Q~RARMRNRPRQ_K?L?P?W?X?Y?\\?d?e?j?k?m?t?y?z?"},
  {0,NULL,"}@B@D@G@H@K@O@S@Z@i@k@m@n@v@w@{A@ADAFAGAKASAWAZAdAlAmApAqAtAxA|BG"},
  {0,NULL,"BPBTBUBjBnBuBwBxB{B~CACMCNCRCTCVC_CiCjCkClCoCrCvDCDDDEDIDMDQDTDUD"},
  {0,NULL,"[DbDdDhDlDpDqDwDzD{EIENEQESETEWE`EaEbEiEqEsEyE|F@FHFNFOFQF\\F]FaFe"},
  {0,NULL,"FhFsFtFyG@GAGFGJGQGWGZG[G_GbGdGhGlGpGuHAHEHFHGHKHPHRHSHVHZHdHhHiH"},
  {0,NULL,"zH{IAIMIOIPIRIWI[I\\I^IcIeIfIxIyI}JHJIJRJTJUJYJ[JcJfJnJuJ|KBKCKDKI"},
  {0,NULL,"KLKSKTKWK[K_K`KhKlKoKsKuKyL@LHLKLLLMLQLWL]L`LdLeLqLwL}MKMMMOMPMQM"},
  {0,NULL,"ZM]M`MaMgMkMsMtMvNENFNNNPNUNVN[N]NaNcNjNmNrNsNtNuO@OBOGONOOOSOVO\\"},
  {0,NULL,"O`OcOdOfOoOuPAPHPLPUPZP^PcPdPePqPtPuPvPxP}Q@QFQIQKQMQSQYQdQfQhQjQ"},
  {0,NULL,"mQuQyQ~RARCRERNRORPRRRV_K?L?P?T?V?X?]?`?a?l?m?n?o?u?v?|@A@E@H@J@L"},
  {0,NULL,"@R@V@]@h@i@j@r@x@y@}@~A?AFAHAJATA]A^AfAiAnArAsAtAvBIBMBNBYB^BgBiB"},
  {0,NULL,"tBvByB|C?C@CDCFCKCSCXCZC\\CdCeCgCpCrCuC~DBDEDJDLDQDSDUDXDbDeDiDlDt"},
  {0,NULL,"DuDwDzD{EIENEQESETEWE`EaEbEiEqEsEvEwE~FOFTFWFYF]F^FbFfFjFqFrFyFzG"},
  {0,NULL,"FGHGIGKGTGWGYG^GaGdGjGlGqGsG{G|G~H@HEHIHXH\\H`HaHbHhHuHvH}IAIBICII"},
  {0,NULL,"IQIVI\\IhIjIlImInIwJ@JAJFJGJQJSJYJZJaJbJeJoJrJuJzJ{J|KHKIKKKNKUKZK"},
  {0,NULL,"^KkKlKmKoKrKwK|K}K~LGLHLMLOLSLTLVLXLoLpLuM@MAMBMCMDMQMWMYMaMbMdMe"},
  {0,NULL,"MyM{M}N?N@NKNPNRNSNXNYN[NbNkNlNpNsNuNyN{N~OLOPOUOVOWO[ObOfOgOlOnO"},
  {0,NULL,"tOxOzPFPQPUPVPWP\\PfPmPrPsPtPzP|Q?Q@QEQIQLQTQ\\Q`QdQgQkQmQrQuQzQ}R?"},
  {0,NULL,"RCRMRORQRRRVRW_N?O?P?T?U?Y?^?b?c?l?m?n?p?w?x?{?~@?@G@H@K@Q@W@`@i@"},
  {0,NULL,"k@m@o@q@t@|AAABAFAHAJALA`AcAeAgAjAqAsAuA{B?BEBVBZB]BhBmBpBqBsB}CB"},
  {0,NULL,"CECGCLCPCQCWC[C`CaCbChCoCrCvDCDDDEDJDLDQDSDUDXDaDdDiDmDpDuDvDyD{E"},
  {0,NULL,"IEJEQEREUE[E`EaEbEoErEtEuEzF?FKFMFQFRFTFZFbFfFjFqFxFyF{GCGGGIGSGU"},
  {0,NULL,"GVGYG[GbGcGgGlGrGxGzG|HAHBHCHPHVH]H^HbHeHhHiHzH{ICIDIFIGILIUI]I_I"},
  {0,NULL,"bIhIkIoIxIyI}JEJNJOJQJVJXJ[JcJfJtJuJ}K@KAKBKEKJKLKUKWKYKaKiKkKlKn"},
  {0,NULL,"KtKuKvKwKzK|LILMLQLRLXL_LcLoLpLuMGMHMJMKMLMSMUMVMZMhMiMlMyM{M}NHN"},
  {0,NULL,"INJNNNQNTN[N^NcNeNhNkNqNzN~OAOBODOJONOUOXO[O]OcOdOlOrOsOvOyO{PDPO"},
  {0,NULL,"PRPSPUP]P_PhPjPkPlPnPtQAQEQGQOQPQSQXQ\\Q^QaQeQmQpQsQvQ|RCRERMRNRPR"},
  {0,NULL,"QRWRX_N?O?P?T?V?X?\\?_?e?l?m?n?p?w?x?|@A@E@H@J@K@N@T@[@j@k@l@p@r@y"},
  {0,NULL,"@|AAACAGAIAKANARAXAdAkAlApAqAuAyB@BBBQB[B\\BgBiBoBrBvB|CBCCCLCOCPC"},
  {0,NULL,"QCVCYC_CjCkClCtCwCxC{C|D?DFDGDNDODYD]D`DcDfDkDoDsDwDxDzEHELEZE\\E]"},
  {0,NULL,"E^E`EaEbEoErEtEvEwE~FGFMFTFUFVFYFbFfFjFqFxFyF{GCGGGIGKGTGWGYG^GgG"},
  {0,NULL,"lGqGrGtGxG|G~H@HBHEHJHVHXH]H`HbHhHlHoHsICIFIOIQIRITIYI^IdIhInIoIx"},
  {0,NULL,"J?JAJDJGJNJPJQJTJ_J`JdJsJwJxJyK@KBKFKKKOKRKTKZK_KeKgKjKpKqKxK{L@L"},
  {0,NULL,"DLELJLYL\\L]L^LbLdLjLsLtL~M@MJMLMMMQMVMXM[M`McMiMuMvMwN@NCNGNLNONP"},
  {0,NULL,"N^NbNdNeNiNlNqNrNzOAOBOCOHOJONOTOXO]O_OcOeOiOkOrPEPIPNPQPSPWPZP[P"},
  {0,NULL,"]PhPkPuPyP{P~Q?Q@QIQJQLQUQ]Q`QdQgQkQlQxQyQ{Q}R?RBRGRIRJRLRTRU_N?O"},
  {0,NULL,"?P?W?X?Y?Z?`?a?i?k?l?q?t?z?{?~@@@I@J@L@P@U@b@i@k@m@o@q@t@{A@ADAFA"},
  {0,NULL,"GAJAQAVA[AfAhAnArAsAuAzA}BLBSB`BaBfBhBmBqBsBzB~CACHCJCNCTCXCZCdCe"},
  {0,NULL,"CfCgCsCwCyC|C}DADHDKDODPDYD\\D^D_DfDgDkDrDwDxDzEHELEZE\\E]E^E`EaEbE"},
  {0,NULL,"oErEtEyE|F@FGFNFPFQFUFZF`FcFgFqFvF~G?GCGDGJGMGTGXG]G_GiGmGnGoGqGt"},
  {0,NULL,"G}H@HHHLHNHOHQHUHWHXH\\HgHmHqHtIAIGIIILINIRIZIbIdIgIjIkI{I~J@JCJLJ"},
  {0,NULL,"MJTJWJYJ[JcJfJtJuJ}K@KAKBKIKLKSKTKWK[K_KaKeKlKnKtKuKzL?L@LHLLLMLQ"},
  {0,NULL,"LRLXL`LdLkLvLzM?M@MCMHMKMPMXMZMeMgMhMjMtMxM{N@NBNFNMNNNQNZN\\NaNeN"},
  {0,NULL,"hNmNqNwNzN{N~ODOKOMOUOZO]O^OlOmOpOrOsOvO|P?PGPOPSPYP\\PaPbPgPhPnPq"},
  {0,NULL,"PsP}Q@QFQIQMQRQVQ[Q]Q`QcQhQjQuQyQ~RARBRFRGRHRKRLRSRURZ_N?O?P?W?X?"},
  {0,NULL,"Y?Z?`?a?i?j?n?r?u?v?|@A@F@G@I@L@R@V@\\@j@k@l@p@r@y@z@}@~AGAIAJAPAT"},
  {0,NULL,"A]AfAhAiApAqAtAvBHBMBWBYB^BiBoBrBtByB|C?C@CFCICKCUCZC\\C^CdCeCfCpC"},
  {0,NULL,"qCvD@DBDCDJDMDRDSDVD[DbDdDhDlDpDqDvDyD{EIEJEQEREUE[E`EaEbEoErEtEy"},
  {0,NULL,"E|F@FGFNFPFQFUFZF_FdFiFtFvF{F|GDGGGMGQGVGZG\\G]GbGcGiGmGnGoG}HHHKH"},
  {0,NULL,"NHOHPHQHSHWHYH^HfHjHwH~IDIHIIINIOIQIZI]I^IjInIpIzI{I|JEJFJMJUJWJZ"},
  {0,NULL,"J_J`JdJsJwJxJyK@KBKLKPKQKRKTKXK_KeKnKpKqKtKzL?L@LCLELLLRLULYL\\L^L"},
  {0,NULL,"dLgLhLnL~M@MAMFMKMRMWMXMYMZM[M^MwMxMzN@NANDNNNONSNWN^N_NdNgNjNrN|"},
  {0,NULL,"OAOBOCOEOGOHOIOJOQOSO_OcOeOjOkOoPAPHPLPWP]P`PaPbPfPgPiPkPsP|P~QBQ"},
  {0,NULL,"CQKQNQPQSQWQYQ^QeQiQnQqQtQvQwR@RERMRORQRRRVRWRY_N?O?P?T?V?X?\\?_?e"},
  {0,NULL,"?i?k?l?q?t?z?}@B@C@I@J@K@S@Y@Z@h@l@m@u@v@w@{A@AEAHAIAKAMASAZAdAkA"},
  {0,NULL,"mArAsAtAxA|BCBPBTBXBjBkBlBnBuBxCACHCJCMCRCTCYC_CiCjCkCmCoCqCuC~D@"},
  {0,NULL,"DDDIDLDRDTDVDXDbDeDiDlDtDuDvDyD{EIEJEQEREUE[E`EaEbEoErEtEvEwE~FGF"},
  {0,NULL,"MFTFUFVFYF`FcFgFqFvF~G?GCGDGIGLGMGNGOGTGmGoGqGrGtGxG~H@HBHDHJHOHU"},
  {0,NULL,"HWHXH[H]HgHkH|I?ICIKINIRISIWIZIcIdIfIhIiI~J?JBJIJJJKJQJTJWJ\\J]J^J"},
  {0,NULL,"qJrJsJtJwKAKEKFKHKNKRKVKgKiKjKkKpKqK{K|K}LDLELJLNLSLZL\\LbLcLfLiLr"},
  {0,NULL,"L~MCMMMPMSMTMUM[M_M`MeMgMuM|M~NENLNONRNTNVNWNXNZN`NfNhNwN{N|N~ODO"},
  {0,NULL,"EOKOPOQOUOZO^ObOgOjOmOqOsOxOzPFPOPYPZP[P`PcPiPnPvPyP{P}QBQCQDQEQO"},
  {0,NULL,"QTQWQXQZQ\\Q_QnQoQrQsQwQ|R@RNRORPRRRVRXRYR\\_K?M?O?W?X?Y?[?b?c?j?k?"},
  {0,NULL,"m?o?r?u?}@B@D@H@J@K@M@a@c@j@k@l@n@u@w@z@}@~AHAIAJAOAUAaAeAjAoArAs"},
  {0,NULL,"AuAwA~BDBRBbBcBjBkBlBnBxB{C?C@CDCFCSCUCWC[CaCbCcChCtCwCxC{C|D?DFD"},
  {0,NULL,"GDPDWDZD\\D^D_DfDgDkDrDvDwD{EKEMEXEYE]E^E`EaEbEjEnEpEyE|F@FGFHFOFP"},
  {0,NULL,"FSF[FaFeFhFsFuFxG?G@GEGJGQGWGZG[G_GdGeGtGuGvGxH@HAHEHFHGHLHUHVHZH"},
  {0,NULL,"_HdHhHlHoHsIBIDIGIHIMIWI[IeIiIkIlImIxJ?JAJEJIJJJLJRJZJ_J`JdJmJyJz"},
  {0,NULL,"J~K?K@KLKPKQKRKTKXK^KcKdKqKrKtKzK}L?LALCLELRLTLULYL\\L_LlLyL{L}M@M"},
  {0,NULL,"GMOMRMSMUMXM^M_MdMfMzM|M}N@NDNJNKNUNVN_NaNfNiNjNlNpNqNvNxN}ODOKOR"},
  {0,NULL,"OWOXOYOZOiOnOpOqOrOtO|P?PGPPPTPUPVPXPZPiPlPoPwPyP|Q@QCQFQKQPQSQYQ"},
  {0,NULL,"ZQdQhQiQmQqQwQyQ}R@RERHRIRJRKRSRTRZR[_L?M?N?T?V?X?[?^?c?i?k?l?o?r"},
  {0,NULL,"?v?}@B@C@G@I@K@a@c@d@e@f@g@n@q@r@}ACAEAQAXAZA^A_AcAgAmAnAyBCBDBFB"},
  {0,NULL,"HBLBPBVBYB\\B`BcBfBgBmBoBwB{C?CKCMCPCQCRC[CeCfChCiCmCnC{DADHDJDODP"},
  {0,NULL,"DSDTDcDdDfDpDsDtD|EDEEELERESETEVEXEcEdEgElEpEqEuEwEyFAFEFFFVFWFZF"},
  {0,NULL,"_FgFjFlFmFoF~G@GGGJGKGLGbGcGfGhGsGvG|G}H?HDHEHOHQHVHZH[H\\H]HoHpHt"},
  {0,NULL,"HxHyI@IGIIIPIRIUIVIaIdIeInIoIpIqIrIsJFJHJOJTJVJZJ^J`JcJoJpJuJyJzJ"},
  {0,NULL,"|KGKIKPKUKXK\\K_KaKlKnKsKtKuKvK~L?LBLLLZL\\L]L_LbLcLeLfLjLwLyL|L~ME"},
  {0,NULL,"MRMUM[M_M`MeMgMuM|M~N?N@NANBNINUNYN[NbNgNkNnNqNrN}OAOBOCOGOHONOOO"},
  {0,NULL,"ROXOjOmOoOpOqOsOwOxO|O}PBPMPOPUP^PiPnPvPyP{P}QAQKQLQNQQQSQYQ^QaQf"},
  {0,NULL,"QjQmQxQyQ|Q~R@RBRLRNRORUR]R^_K?M?O?T?U?Y?Z?]?a?l?m?n?q?y?z?{?~@?@"},
  {0,NULL,"G@I@K@U@_@b@e@f@g@s@u@yA?A@ABAPAUAWAXA[A`AfAjAlAyA|A}A~B?BIBRBXBZ"},
  {0,NULL,"B\\B^BdBfBrBvBxBzB{CACECGCICKCMCYC[C\\CaCeCkCnC{DADFDQDRDVDYD]D`DbD"},
  {0,NULL,"gDlDmDnD|EDEEEKENEUEWEYE]EcEdEgEiEkEnEvEzF@FAFBFDFGFKFLFbFcFiFkFo"},
  {0,NULL,"FpFxGDGFGRGSGWGdGeGkGmGoGwG{HAHBHFHJHNHRHSHXH^H`HeHoHpHtHxHyI@IFI"},
  {0,NULL,"HIPIQIRIXIaIcIfIjIlIoIrItIuJFJIJKJLJNJZJ^J`JcJoJrJvJxJ{J|KHKIKKKN"},
  {0,NULL,"KXK[K_KeKgKhKpKqK{L@LFLJLKLLLQLRLUL[L_LcLlLmLpLqLwLzMCMNMSMUMVMZM"},
  {0,NULL,"hMiMlMyM{M}NBNCNDNFNLNVNXNYN\\N_NgNmNrNtNwN{N|OEOGOKOSOVO\\O^OcOdOi"},
  {0,NULL,"OqOrOsOwOyO~P?PJPNPPP]PbPhPjPkPlPnPtQCQDQFQHQKQTQYQZQdQhQiQnQsQvQ"},
  {0,NULL,"xQ{RARBRIRPRQRTRYR[R__K?L?P?W?X?Y?\\?d?e?i?j?n?p?s?x?|@A@F@G@I@K@T"},
  {0,NULL,"@X@[@e@f@g@t@v@x@|@~ADAQARASATAUAbAiAkAoA{A~BBBGBLBMBRBTBWB]B`BeB"},
  {0,NULL,"gBqBuBvBwBzC?CACECQCTCUCYC\\C^CbChCmCnC{DADKDLDNDXDZD[D^DiDkDqDrDu"},
  {0,NULL,"D|EDEEEMEOEPEQEZE_EcEdEgEjEmEsE|E~F?FBFCFEFNFSFTF`FdFfFkFlFnFqFtF"},
  {0,NULL,"uGPGQGXGaGjGpGrGuGxGyGzH@HKHLHPHTHWHYHbHcHgHoHpHtHxHyI@IFIIISIVIW"},
  {0,NULL,"IXI_IdIeIjIkIlIqIuIvJGJIJKJMJOJVJ^J`JcJpJqJvJzJ{J}KGKHKJKKKUKZKaK"},
  {0,NULL,"bKgKiKjKkKvK{LALDLGLILRLULZL\\L`LdLeLgLqLsLvL{L}MKMLMWMXMYMZM[M^Mw"},
  {0,NULL,"MxMzNCNGNHNQNRNUNXN\\N`NbNkNlNqNvNwNzN~ODOKOWOXOYOZO]OcOdOeOjOoOuO"},
  {0,NULL,"~PAPBPCPEPKP[P`PdPgPiPkPsP|P~QAQDQGQOQRQUQXQZQ_QaQbQlQwQyQ{Q~RARE"},
  {0,NULL,"RKRSRVRWRZR\\R_R`_L?M?N?U?V?W?Z?]?`?i?j?n?q?t?y?{@?@@@H@J@K@P@_@b@"},
  {0,NULL,"e@f@g@n@q@r@z@{AAAMAYA\\A^A_AbAiAkAoAxA{BABHBKBLBSBUBYB]B_BeBgBhBl"},
  {0,NULL,"BnBoB}C@CBCCCRCSCTCZCbCdChCjClCtCxC|DHDNDQDUDVDWD^DaDbDjDlDsE?ECE"},
  {0,NULL,"GEHEJEUEWEXE_EdEeEfEkEnEoEvE{F@FBFCFEFKFLF]FbFhFiFmFnFpFwGDGFGMGR"},
  {0,NULL,"GSGdGeGgGlGmGwHAHBHFHHHIHJHSHUHXH^H_H`HlHoHqHrHsHyIFIIISIVIWIXI_I"},
  {0,NULL,"cIfIkInIpIqIrIsJFJHJOJTJVJZJ[J]JeJwJyJzJ~K@KBKFKLKPKRKTKZK^K`KjKk"},
  {0,NULL,"KlKoKuKvKyK|K}LDLPLVLXLZL`LaLfLiLlLnLtLzL}MKMLM]McMeMfMhMlMwMxMzN"},
  {0,NULL,"ENFNINKNLNMN^NbNfNiNjNlNsNuN~O@OBODONOOOPOQOUOZO`OaObOmOuOvO{P?P@"},
  {0,NULL,"PBPDPNPQPXP\\PhPiPjPmPpPqQAQEQIQMQOQSQWQ\\Q_Q`QjQmQpQzQ|Q~RDRFRIRJR"},
  {0,NULL,"MRNRVR[R_Ra_L?M?N?T?U?Y?\\?_?d?j?k?m?p?s?w?|@E@F@I@J@L@N@X@[@e@f@g"},
  {0,NULL,"@n@q@rA?A@ABAMAPAXA\\AaAcAdAeAhAxBABDBFBIBJBQBUBVB^BbBdBfBiBlBmBnB"},
  {0,NULL,"tCBCICJCKCLCNCWCXCZCcCiCkCsCwC}DFDLDMDPDWDXDcDgDhDjDqDuE@EAEBEHEI"},
  {0,NULL,"EPEQEVEYEcEeEhEmEsEtE|E}F?FCFDFFFJFSFTF`FeFfFkFoFpFtFuF}GIGPGQGaG"},
  {0,NULL,"iGjGnGpGrGzG~H@HLHMHPHWHYHcHdHgHhHlHmHnHqHtI@IGIHIQISIUIWIaIcIfIj"},
  {0,NULL,"IlIoIqIrIsJFJHJOJTJVJZJ\\J_JbJuJ|K@KAKBKDKIKLKSKVKYK[K^KcKpKqKrKtK"},
  {0,NULL,"|K}K~L?LELJLNLOLPL[L^LbLhLnLsLvLwLxM?MDMQMUMXMYM\\MbMcMsMtMvNBNGNH"},
  {0,NULL,"NJNKNONZN[N^NeNhNmNpNuN{O?OCOEOGOHOLOPOQO^OaOhOiOkOqOtOxOzPCPDPEP"},
  {0,NULL,"GPPP]PbPoPqPrP{P|P~QBQEQIQLQNQTQWQYQ^Q`QkQnQqQxQzQ}R@RDRHRKRMRORP"},
  {0,NULL,"RZR_R`Rb_K?M?O?W?X?Y?[?b?c?j?k?m?o?r?u?}@B@D@H@J@K@M@a@c@e@f@g@s@"},
  {0,NULL,"u@y@|@~ADALAPASAUAVAYAdAeAhAwA}BABEBGBIBOBTB^BaBbBeBkBlBpBrBvB}C@"},
  {0,NULL,"CACFCLCOCTCVCXCZC_CaCbCtCxC|DFDIDJDSDZD\\D_DeDgDkDpDtE?ECEGEMERETE"},
  {0,NULL,"YE[E^EdEeEfElEpErEwExEyFCFDFFFHFWFZF_FaFjFkFlFnFrF~G@GJGLGVGcGfGq"},
  {0,NULL,"GsGtGvG|G}HCHEHGHOHVHZH[H]HaHfHlHoHqHrHsHyIGIHIQISIUIWI_IdIeIjIkI"},
  {0,NULL,"lIrItIuJFJIJKJLJNJZJ[J]JeJsJwJxJ{K?K@KKKOKQKRKYKZKfKiKkKmKpKrKwKz"},
  {0,NULL,"K|LFLILJLMLNLPLQLWL`LiLjLkLqLrL|M?MDMQMZM]M`MaMgMkMsMtMvN?NANCNMN"},
  {0,NULL,"SNTNWN^N_NdNeNlNoNpNyNzN{N~OKOMOUO[O]O^O`OdOfOgOhOuOyO}PDPHPIPMP["},
  {0,NULL,"P`PdPqPtPuPvPxP}Q?QEQGQHQPQTQXQZQ\\QcQgQnQoQsQuRARDRFRGRLRPRRRURWR"},
  {0,NULL,"`RaRbRc_K?M?O?U?V?W?_?d?e?i?k?l?s?w?x@A@E@F@G@H@L@N@T@X@e@f@g@s@u"},
  {0,NULL,"@y@z@{AAALAOAWAYA[A^AgAmAnAwAyAzA|BEBHBOBSBXBYB[BcBpBxByB{B|B}B~C"},
  {0,NULL,"@CGCHCPCSC]C_C`CeCfCjCyCzD?DHDLDMDYD[D\\D_DhDiDnDsDuD}D~EFEIEKEOEQ"},
  {0,NULL,"EXE^EfEgEhEjEsEtE}E~F?FAFEFFFJFNFSF`FdFeFmFnFpFqFuF}GIGQGXGaGiGjG"},
  {0,NULL,"nGuGxGyGzG~HKHMHPHTHWHbHdHgHhHmHnHpHrHsHxIGIIIPIRIUIVI_IcIfIkInIp"},
  {0,NULL,"IrItIuJFJIJKJLJNJZJaJdJfJnJoJrJsJtJwKEKFKNKRKWK\\K]KeKlKmKnKoKuKwK"},
  {0,NULL,"zL@LHLLLTLWLYL]L_LaLiLoLpLsLxL{L~MEMRMVMWMXM]MbMjMuM|M~NDNGNJNMNP"},
  {0,NULL,"NQNWNYN]NcNfNnNsNxNyN|OAOBOJONOSOUOVO[O_O`OnOpOrOvOwPEPGPHPKPLPQP"},
  {0,NULL,"XP\\PnPrPsPuPwP~Q?Q@QCQKQPQSQ\\QdQeQgQiQmQtQuQvR?RBRFRHRNRQRRRSRZR_"},
  {0,NULL,"R`RbRd_L?M?N?T?U?Y?\\?_?d?i?j?n?q?t?y@B@C@D@H@J@L@O@Y@Z@e@f@g@n@q@"},
  {0,NULL,"rA?A@ABAMAPAXA\\AaAcAiAkAoAxA{BABHBKBLBQBRBSBUBWBZBhBiBlBnBtB}CBCD"},
  {0,NULL,"CJCLCNCSCZC]CcCdCjClCuDBDEDJDMDODVDWDYDaDdDfDjDkDuEBECEFEHEKEMEPE"},
  {0,NULL,"WE[EcEdEgElEpEqEvEzF@FAFDFFFIFRFUF`FdFfFlFmFnFsF|GCGUGZG`GfGhGqGs"},
  {0,NULL,"GtGvG{HAHBHHHIHNHTHWHYHbHdHhHkHuHvH{H}H~IBIDIJINIOITI[I]I`IbIgIhI"},
  {0,NULL,"tIuIvJCJDJEJJJPJYJ^J`JcJoJpJuJyJzJ|KHKIKKKNKXK[K_KeKpKqKrKtK~L?LB"},
  {0,NULL,"LELJLLLQL[L]L_LbLcLiLlLuLwLxLyMBMHMPMUMYM]M^M`MhMsMyM~NANBNGNNNRN"},
  {0,NULL,"VNXN\\N`NbNkNlNqNzN~O@OBODONOOOROUOXOZOeOjOmOoOpOuOzP@PBPCPLPMPTPW"},
  {0,NULL,"PZPiPjPoPtP}P~Q@QDQFQGQRQUQZQ]QdQhQiQlQsQvQwQ{RARERLRQRSRTRWR]_L?"},
  {0,NULL,"M?N?U?V?W?Z?]?`?i?k?l?o?r?v@A@E@F@G@H@K@R@\\@]@e@f@g@n@q@r@z@{AAAM"},
  {0,NULL,"AYA\\A^A_AbAgAmAnAyBCBDBFBHBLBOBSBXBYB[BcBgBhBoBwB{B}C@CGCPCRCSCTC"},
  {0,NULL,"[C_CeCfChCjCrCvDDDFDGDHDLDTDVDaDgDhDrDsDtD}EDEGEOEREWEXEZE\\EcEeEh"},
  {0,NULL,"EmEsEtEuExEyFBFCFDFXFYF[FbFcFhFkFlFoFvGBGEGNG]G^GiGjGpGrGuGxG|G}H"},
  {0,NULL,"?HCHEHGHRHSHUHXH^HeHiHwHzH{H}I?ICIEIJIKIMINIYI^IbIgIiImItIuIvJCJD"},
  {0,NULL,"JEJJJPJYJ\\J_JbJuJ|K@KAKBKDKEKJKLKTKWK[K^K`KdKjKkKqKyK|K}LDLELJLOL"},
  {0,NULL,"PLULVL[L^LeLnLpLxLzL|M@MJMOMYM[M_MaMcMlMtMxM{NDNENGNKNSNTN[N]NaNc"},
  {0,NULL,"NeNkNpNqNrNvN}OCOGOHOLOROXO^OgOhOjOkOqOtOxO{PEPHPMPNPRPcPfPkPmPpP"},
  {0,NULL,"{P|P}Q?Q@QCQJQPQUQ[QbQdQeQgQiQoQrQtQwQ{R?RGRKRPRTRXR\\Rf_L?M?N?T?V"},
  {0,NULL,"?X?[?^?c?j?k?m?p?s?w?~@?@@@G@I@L@Q@^@`@e@f@g@n@q@r@}ACAEAQAXAZA^A"},
  {0,NULL,"_AcAdAeAhAxBABDBFBIBJBNBQBTBVBaBcBfBiBmBtBwB{C?CHCJCKCPCQCWC^CcCf"},
  {0,NULL,"CiCkCpD@DCDMDNDPDTDUD]D^D_DbDcDtDuD~EAEEENEPEREVE]E^EdEeEfEkEnEoE"},
  {0,NULL,"|E}E~FAFBFEFMF\\F^F_FaFjFkFnFpG?GAGHGOGYG_GeGgGkGmGoGwGyGzG~H@HKHP"},
  {0,NULL,"HQHVHZH\\HaHfHjHvHwHzH|H~IAIKILIMIOITIZI\\I`IhIiImItIuIvJCJDJEJJJPJ"},
  {0,NULL,"YJ[J]JeJwJyJzJ~K@KBKMKOKPKQKTKXK_K`KaKhKlKsKuKvKyLBLDLLLSLVLXLZLa"},
  {0,NULL,"LcLfLhLoLvLyLzMAMGMTMZM\\M`MbMeMlMzM|M}NANCNENINPNQNWN^N_NdNeNlNpN"},
  {0,NULL,"uNyN{N~OEOLOPOQOUOZO^O`OaOdOhOuOvOwO}P@PAPDPEPSPaPePjPnPqPvPzP|Q?"},
  {0,NULL,"QGQHQPQRQVQXQ[Q]QcQeQhQoQrQsQuRARCRGRIRRRSRVRYRfRg_K?L?P?U?V?W?[?"},
  {0,NULL,"^?b?i?j?n?p?s?x?{@?@@@I@J@K@W@^@`@e@f@g@t@v@x@z@{AAAOARAWA\\A]AbAi"},
  {0,NULL,"AkAoA{A~BBBGBLBMBSBUBYB]B_BeBgBjBnBqBvBzCBCCCICRCTCUCYCZCbCdChCmC"},
  {0,NULL,"oCqC~DNDPDSDVD[D\\D^D`DaDcDeDqD|E?E@EQESEWE]E^E_EfEgEhEiEnEoE}E~F?"},
  {0,NULL,"FAFDFFFPF\\F^F_FaFgFkFlFoF{GAGHGYG\\G_GdGkGlGmGoGwGyGzG~H@HLHMHQHVH"},
  {0,NULL,"ZH[H]HfHiHjHkHuH|I?IBIDIJINIOITIYI^IbIgIiImIrIsItJCJQJRJSJUJYJaJd"},
  {0,NULL,"JfJmJpJqJsJtKAKEKFKNKRKWK\\K]KdKeKmKnKqKxKzL?L@LCLELMLOLTLWL]L_LfL"},
  {0,NULL,"oLqLsLtL|MBMHMPMWMZM\\M_MiMjMsMyM~NFNINJNONPNSNXNZN]N`NfNiNqNtNvNw"},
  {0,NULL,"NzO?OHOKOTOWOXO]OcOfOkOlOoOtO|P?PAPCPDPFPRPcPfPgPlPnPxPzP~Q@QEQFQ"},
  {0,NULL,"IQMQSQ\\Q`QdQgQjQmQpQqQtQvRBRFRHRORRRTRURYRfRg_K?L?P?W?X?Y?\\?d?e?j"},
  {0,NULL,"?k?m?t?y?z?}@B@D@G@H@K@O@S@Z@e@f@g@t@v@x@|@~ADAQARASATAUAbAdAeAhA"},
  {0,NULL,"vAwBBBFBGBJBOBTB^BaBbBeBgBpBsBuBvBwC@CACECFCQCTCVC^C_CaCbCfCrCvDD"},
  {0,NULL,"DIDODUDYDZD[DbDjDkDnDpDqD}EDEGEHELEMENEQETEcEeEhElEqErEzE{F@FAFBF"},
  {0,NULL,"EFIFOFUF`FeFfFmFoFpFsFzF|GTGZG`GbGcGfGhGqGsHAHBHFHHHJHNHTHbHcHdHg"},
  {0,NULL,"HhHiHwHzH{H}I?IAIKILIMIOITIYIZI[I\\I]I^IrIsItJCJQJRJSJUJYJ\\J_JbJtJ"},
  {0,NULL,"vJ}KAKBKCKJKOKSKUKWKYK]KaKbKgKjKsKvKxK{L@LDLGLSLTLULVLYL\\LgLiLmLu"},
  {0,NULL,"L{L|MAMGMTMUMXM^M_MdMfMzM|M}NBNHNLNMNRNSNZN[N^NeNhNmNuO?OAOCOEOFO"},
  {0,NULL,"HOIOJOQOSOTOaObOiOnOqOtOyOzP?PBPEPIPVPYP_PiPlPoPwPyP|Q?QEQHQIQLQT"},
  {0,NULL,"Q\\QcQfQgQkQnQoQqQtQxR@RDRHRIRMRQR]R^RgRhRi_K?L?P?T?V?X?]?`?a?l?m?"},
  {0,NULL,"n?o?u?v?|@A@E@H@J@L@R@V@]@e@f@g@t@v@x@}ACAEANAOAQASA]AcAfAjAlAvA{"},
  {0,NULL,"A|A~B@BJBNBPBZB\\B_BaBjBnBpBsBtByCCCDCFCHCJCOCVCWC`CdCgClCuDBDEDGD"},
  {0,NULL,"HDKDSDUDXDbDeDgDiDoDrEBECEFEIENESEXEYE\\EcEdEgEjEmEsEuEwEyFCFEFFFQ"},
  {0,NULL,"FXFYFbFcFiFkFnFpFvFyGEGNG[G^GaGiGjGnGpGuG|HCHDHEHGHOHUHXH^H_H`HeH"},
  {0,NULL,"kHuHvH{H}H~IAIBICIDIEILIZI\\I`IhIiImIrIsItJCJQJRJSJUJYJ^J`JcJpJqJv"},
  {0,NULL,"JzJ{J}KGKIKPKUKXK\\KaKcKiKlKnKtKvKzL?LALGLILZL\\L]L`LbLdLeLnLrLtLyL"},
  {0,NULL,"{MFMIMMMVMXM[M`McMiMuMvMwNANDNFNHNTNUNXNYN\\N_NgNmNwNxN{N|ODOEOKOQ"},
  {0,NULL,"OSOWOYOZOcOdOeOiOrOuO{O~PCPHPIPJPSPaPePhPkPuPyP{P~QFQHQKQMQQQTQYQ"},
  {0,NULL,"cQfQhQjQmQsQvQxQ|R@RBRIRNRPRURZR\\RfRhRiRj_K?L?P?T?V?X?]?`?a?j?k?m"},
  {0,NULL,"?t?y?z?~@?@@@G@H@L@P@U@_@e@f@g@t@v@x@}ACAEANAOAQASA]AcAdAeAhAvAwB"},
  {0,NULL,"BBFBGBJBNBQBTBVBaBcBpBsBtBuBwByCDCFCHCJCPCQCVCWC^C_CcCfCyCzD?DGDP"},
  {0,NULL,"DRDUDVDZDaDbDcDkDmDoD}D~EFEJEMENEUEVE\\EfEgEhEiEnEoEvEzE{FCFDFFFGF"},
  {0,NULL,"LF]FcFhFiFlFmFoFwFxGFGMGSGWGdGeGgGkGlGoG{HBHHHIHJHNHRHSHUH^H_HeHm"},
  {0,NULL,"HnHpHrHsHxIGIHIQISIUIWIaIdIeInIoIpIqIuIvJGJIJKJMJOJVJaJdJfJmJpJqJ"},
  {0,NULL,"sJtKAKEKGKMKQKVK\\KcKdKfKiKnKtKzL?LALCLELILMLOLWL]L^LdLeLmLoLtLuLz"},
  {0,NULL,"M?MDMQM[MdMfMhMiMjMsMtMvNENFNNNPNUNVNWNZN`NdNhNnNoNzO?OAOCOFOHOIO"},
  {0,NULL,"JOTOXO]OfOlOnOoOpOtOzP?P@PAPHPJPOPUP^PgPhPlPoPpPuQBQGQNQPQRQVQXQ["},
  {0,NULL,"Q]Q^QaQeQuQyQ}R?RCRERJRORTRWRXR[R_RaRcRdRe_K?L?P?U?V?W?[?^?b?l?m?"},
  {0,NULL,"n?o?u?v?}@C@D@I@J@L@M@c@d@e@f@g@t@v@x@z@{AAAOARAWA\\A]AbAfAjAlAvA{"},
  {0,NULL,"A|A~B@BJBNBXB[B]B_BdBjBnBqBtByBzB~CBCCCHCICUCWCYC`CdCgCkCsCwC}DGD"},
  {0,NULL,"IDNDSDTDYD^DdDeDnDoDpE@EAEBEKERESE[E\\E_EcEeEhElEqErEuExEyFAFBFDFH"},
  {0,NULL,"FVFWFaFgFjFmFnFpFrG@GGGKGLGVGbGhGqGsGtGvG}H?HCHDHGHOHQHVH\\H]HaHfH"},
  {0,NULL,"lHmHnHqHtI@IFIHIPIQIRIXI_IcIfIkInIpIqIuIvJGJIJKJMJOJVJ\\J_JbJtJvJ}"},
  {0,NULL,"KAKBKCKEKJKLKTKWK[K]K`KdKeKjKqKxK{L@LCLDLELOLSLTLULVL[LgLkLnLoLyL"},
  {0,NULL,"|MCMNMSM^M_M`McMjMkMyM{M}N?N@NKNPNRNSN\\NaNcNhNjNmNxN|O@ODOEOFOIOJ"},
  {0,NULL,"OQOSOYOZO_OaObOeOiOnOzO|O}O~PFPIPQPXP\\PkPoPxPyPzP}QBQCQDQJQOQVQWQ"},
  {0,NULL,"[Q_QbQeQiQrQwQzQ{Q}R?RGRLRQRVRXR^R`RaRbRcReRl_K?M?O?T?U?Y?Z?]?a?j"},
  {0,NULL,"?k?m?o?r?u?|@E@F@I@J@K@V@\\@]@e@f@g@s@u@yA?A@ABAPAUAWAXA[A`AdAeAhA"},
  {0,NULL,"wA}BABEBGBIBQBUBVB^BbBdBfBkBlBrBvBzCACBCICKCLCMCXCZCaCbCiCkCoCqC~"},
  {0,NULL,"DFDHDIDKDMDQDgDmDoDpDsDuD|E?E@EPETEUEYEZE\\EfEgEhEjEsEtEuEwExFAFBF"},
  {0,NULL,"EFQFXF[FcFhFiFlFmFnFyGBGEG[G]G^GaGnGpGrGuGxG|G}H?HCHDHOHRHSHUHXH_"},
  {0,NULL,"H`HiHjHkHuH|I?IAIKILIMIOITI[I]I`IbIgIhIqIsIvJDJPJRJSJWJXJaJdJfJnJ"},
  {0,NULL,"oJrJsJtJwKFKHKMKNKSKVK_KbKeKgKhKoKuK{L@LHLKLLLRLTLXLYL_LaLjLlLnLp"},
  {0,NULL,"LrLsMAMGMTMVMWM[MaMhMkMzM|M}N@NDNJNKNUNVNWNZN`NdNhNnNoNyNzN~OAOFO"},
  {0,NULL,"JOMONOUO[O]O_O`OfOnOoOpOxO}O~P?PGPHPTPWPZPkPlPmPsPuPvQBQIQLQNQRQV"},
  {0,NULL,"QWQ]Q^Q`QkQlQpQqQyQ}RCRERJRNRSRXR\\R^RfRhRiRj_N?O?P?T?U?Y?^?b?c?i?"},
  {0,NULL,"j?n?r?u?v@B@C@D@G@H@L@M@a@d@e@f@g@o@p@wA?A@ABAMANATA[A`AaAiAkAoAx"},
  {0,NULL,"AzB?BBBKBMBQBRBSBUBWBZBhBiBsBuBxB|CDCECGCJCNCSC\\C]C^CcCjClCyCzD?D"},
  {0,NULL,"IDJDKDTDWD]D`DdDeDjDrDtD}D~EFEHESETEZE[E]EfEgEhEpEqErEuEwExFBFCFE"},
  {0,NULL,"FHFVFZF_FaFgFkFoFpFrF~GGGJGKGVGbGcGfGhGqGtG|H?HCHDHEHGHQHZH[H\\HaH"},
  {0,NULL,"fHmHnHpHrHsHxIFIIISIVIWIXIaIcIfIjIlIoIsItIvJGJHJLJMJNJTJaJdJfJmJn"},
  {0,NULL,"JqJrJ~KDKFKHKMKNKSKVK^KbKcKgKhKoKyK}LALGLHLKLRLXLYL^LaLdLhLjLkLpL"},
  {0,NULL,"uLyL}MKMLMVM\\M_MdMgMkMwMxMzN@NANDNNNONSNXNZN]N`NfNiNsNtNuNvNwO?OL"},
  {0,NULL,"OPOTOVOWO\\OcOkOlOrOtOvO{O|PAPIPLPMPPP]PbPgPmPvPwPxPyQ@QFQIQMQRQUQ"},
  {0,NULL,"]Q`QdQhQkQlQpQqQtQvRCRERGRMRURYR\\R^R`RaRbRcReRl_N?O?P?W?X?Y?Z?`?a"},
  {0,NULL,"?i?k?l?q?t?z?{?~@@@I@J@L@P@U@b@e@f@g@o@p@w@|@~ADALARATAVAZAaAgAmA"},
  {0,NULL,"nAzB@BCBDBEBMBOBPBWB[B`BbBiBjBkBmBqB|B~C?CLCNCOCUCXC]C`CgCiCmCsCw"},
  {0,NULL,"C}DKDODQDRDUD\\D_DaDfDlDmDrE@EAEBEJELENEWEZE^EcEeEhEiEkEoEzE{F@FAF"},
  {0,NULL,"EFFFGFKF]FbFcFhFkFlFnFwFxGDGMGRGWGgGkGlGmGoGwG{HAHFHHHIHNHRHUHXH_"},
  {0,NULL,"H`HeHlHmHnHqHtI@IGIIIPIRIUIVI_IdIeIjIkIlIsItIvJGJHJLJMJNJTJ\\J_JbJ"},
  {0,NULL,"nJuJ}K?KCKDKJKOKSKUKWKYK]KaKbKmKrKsKwKxK~LBLGLHLNLSLTLYL\\LbLgLhLl"},
  {0,NULL,"LmLrLtL~MEMRM\\M^MaMfMiMlMuM|M~NENLNONRNTNVN[N]NaNcNeNkNpNqNvNxNyN"},
  {0,NULL,"}OLOMOROWOYO[O_OeOgOhOjOkOxP@PFPJPLPNP[P`PdPjPlPpPwPzP{Q?Q@QJQLQQ"},
  {0,NULL,"QUQbQcQfQgQkQlQoQqQrQtQwR@RIRJRRRTR\\R]R_RaRcRdReRmRo_N?O?P?T?V?X?"},
  {0,NULL,"\\?_?e?l?m?n?p?w?x?|@A@E@H@J@K@N@T@[@e@f@g@o@p@w@}ACAEANAVAZA]A_A`"},
  {0,NULL,"AfAjAlAvA}B?B@BCBKBNBPBZB\\B_BaBhBjBkBoBrBsCCCDCFCMCOCRCVC[CaCdCgC"},
  {0,NULL,"lCtCxC|DGDMDODXD[D]D`DfDhDiDoDqE?ECEGEIELEOEPE\\E]EdEeEfEjEmEtE|E}"},
  {0,NULL,"E~FAFBFDFJFNFTFdFeFfFlFmFoFqFtF}GIGPGXGiGnGpGrGuGxGyG~H@HKHLHMHTH"},
  {0,NULL,"YHbHcHdHhHlHoHqHrHsHyIFIHIPIQIRIXIaIdIeInIoIpIsItIvJGJHJLJMJNJTJ["},
  {0,NULL,"J]JeJmJxJyJ~K?KCKMKOKPKQKTKXK_K`KdKfKhKsKxKyLBLCLFLKLMLQLSLVLXLcL"},
  {0,NULL,"fLrLuLvLxL{MCMNMSMWMYMaMbMdMeMyM{M}NHNINJNNNQNTN_NaNdNgNiNjNoNrNt"},
  {0,NULL,"N}O@OFOIOMOOOROTO\\ObOfOgOlOmOsOyO{PCPFPGPKPOPUP^PmPrPsPtPzP|QFQHQ"},
  {0,NULL,"JQMQQQVQ[Q]QcQfQhQjQoQpQrQsQ|RCRHRKRSRXRYR]R_R`RbRdRlRmRoRp_K?M?O"},
  {0,NULL,"?W?X?Y?[?b?c?i?k?l?s?w?x?{?~@@@H@J@L@Q@W@^@e@f@g@s@u@y@|@~ADALAPA"},
  {0,NULL,"SAUAVAYAgAmAnAwAyAzA|BEBHBOBPBWB[B`BbBkBlBpByB|B}B~C@CFCLCNCOCXC]"},
  {0,NULL,"C_C`CgCjCuDBDEDIDLDNDRD\\D]D_D`DcDhDlDpEBECEFEJEOETEVE^E_EcEdEgEiE"},
  {0,NULL,"kEnE|E~F?FBFCFDFMFPF\\F_FgFjFmFoFpF{G?GAGOG\\G_GdGeGgGkGlGwG~H@HKHL"},
  {0,NULL,"HMHPHQH[H\\H]HaHfHkHuHvH{H}H~ICIEIJIKIMINIYIZI[I\\I]I^IqIsIvJDJPJRJ"},
  {0,NULL,"SJWJXJ^J`JcJoJrJvJxJ{J|KGKHKJKKKUKZKfKgKiKjKkKpK{K|LFLILJLKLQLRLU"},
  {0,NULL,"L[L`LdLhLkLlLoLqL{M@MJMOMXMZMeMgMhMjMtMxM{N?NCNHNINONVNYN[NbNgNkN"},
  {0,NULL,"nNrNsN|OAOBOCOGOJONOSOVO\\OiOmOpOqOrOsOwPDPFPGPJPMPVPYP_PgPhPnPqPs"},
  {0,NULL,"P}QAQJQLQNQQQUQ_QaQbQfQkQlQwQyQ|Q~R@RERKRORVRYR[R^RfRgRjRkRn_N?O?"},
  {0,NULL,"P?W?X?Y?Z?`?a?i?j?n?r?u?v?|@A@F@G@I@L@R@V@\\@e@f@g@o@p@w@|@~ADALAR"},
  {0,NULL,"ATAVAZAaAiAkAoAxAzB?BBBKBMBRBTBWB]B`BeBiBmBqBuBxB|B~C?CECNCQCUCYC"},
  {0,NULL,"\\C]C^CcCmCpD@DCDFDGDJDKDRD[DdDlDoDqDrDsD~EAEEEJEQEXEYEZE[EdEeEfEj"},
  {0,NULL,"EmEtEwExEyFAFDFFFQFYF[FbFhFiFmFoFpFvFyGBGNG[G]GaGiGjGnGrGxG}H?HDH"},
  {0,NULL,"EHGHOHRHSH^H_H`HeHjHvHwHzH|H~IBIDIJINIOITIYIZI[I\\I]I^IqIrIuJEJJJQ"},
  {0,NULL,"JUJWJXJ[J]JeJmJxJyJ~K?KCKKKOKQKRKYKZK]KfKmKpKrKsKwKxK~LBLCLFLMLNL"},
  {0,NULL,"QLSLWLcLeLkLmLpLrLvMBMHMPMVMaMbMcMfMgMsMyM~N?NKNLNQNTNUN^NbNfNiNj"},
  {0,NULL,"NlNsNtNuO?O@OBOIOOOPOTOVO\\OaObOlOmOsOvOxO{O|O~P@PKPVPYP_PjPmPrPuP"},
  {0,NULL,"xP{QAQDQEQGQOQSQXQZQ\\Q_QaQnQuQzQ~RARDRFRHRLRNRPRXR[RfRhRiRjRr_N?O"},
  {0,NULL,"?P?T?U?Y?^?b?c?l?m?n?p?w?x?{?~@?@G@H@K@Q@W@`@e@f@g@o@p@wA?A@ABAMA"},
  {0,NULL,"NATA[A`AaAfAjAlAvA}B?B@BCBKBRBXBZB\\B^BdBhBoBrBsBuBxCACDCECGCMCSCV"},
  {0,NULL,"C[C\\CaCeClCrCvDDDJDPDQDXD\\D]D^D_D`DdDiDmD}EDEGEIEUEVE[E]E_EcEeEhE"},
  {0,NULL,"iEkEoE|E}F?FCFEFFFMFPF^FaFgFjFlFmFnF{G?GHGOGYG\\GdGeGgGlGmGoGyGzHK"},
  {0,NULL,"HLHMHPHVHZH[H\\H]HaHiHwHzH{H}I?IAIBICIDIEILI[I]I`IbIgIhIqIrIuJEJJJ"},
  {0,NULL,"QJUJWJXJ\\J_JbJnJuJ}K?KCKDKIKLKSKVKYK[K^KbKcKoKrKtKwK}K~LALGLHLNLP"},
  {0,NULL,"LYL\\L^LbLfLhLjLmLqLxMFMIMMMYM\\MeMfMjMkMuMvMwN@NCNGNLNONPN\\NaNcNhN"},
  {0,NULL,"jNmNoNxN}O@ODOFOIOMOOOROYO[O_ObOeOgOjOnOwPAPFPIPKPNPTPWPZPgPpPqPr"},
  {0,NULL,"PyPzQBQCQDQKQOQTQWQYQZQ^QiQnQxQzQ{Q}R?RDRJRLRORRRVRZRfRgRjRkRnRs_"},
  {0,NULL,"K?M?O?U?V?W?_?d?e?l?m?n?q?y?z?}@C@D@G@I@L@O@S@Y@e@f@g@s@u@y@z@{AA"},
  {0,NULL,"ALAOAWAYA[A^AfAjAlAyA|A}A~B?BIBNBXB[B]B_BdBfBxByBzB{B|B~CGCHCICPC"},
  {0,NULL,"UCWCYC\\C`CeCkCpD@DCDLDQDSDWDYDZDeDfDhDkDmDnD~EAEEEHEKELEOESEUEdEe"},
  {0,NULL,"EfElEpErEvE{F@FCFEFFFIFOFRFdFeFfFkFlFoFsFzGCGTGUG`GbGcGfGhGtGvG{H"},
  {0,NULL,"FHHHIHJHNHWHYHbHcHgHhHjHvHwHzH|H~IAIBICIDIEILIYI^IbIgIiImIqIsIvJD"},
  {0,NULL,"JPJRJSJWJXJ[J]JeJsJwJxJ{K?K@KFKLKPKRKTKZK^KkKlKmKnKoKuKwKzK|LHLIL"},
  {0,NULL,"NLPLWLZL`LaLgLiLkLsLwLzMFMIMMMUMWM]MdMgMlMuMvMwN?NENJNMNNNRN_NaNd"},
  {0,NULL,"NgNiNjNoNrNtNwN{N}OGOKOMO\\O]O^OdOfOgOhOlOsOyOzO}PJPKPLPRPcPfPhPiP"},
  {0,NULL,"rPtPvPwQBQJQMQOQQQVQWQ[Q_Q`QbQjQpQrQzQ|Q~RCRJRKRMRURWR]RgRhRiRkRn"},
  {0,NULL,"RrRsRt_N?O?P?T?V?X?\\?_?e?i?k?l?q?t?z?}@B@C@I@J@K@S@Y@Z@e@f@g@o@p@"},
  {0,NULL,"w@}ACAEANAVAZA]A_A`AgAmAnAzB@BCBDBEBMBPBVBYB\\B`BcBjBkBmBoBqBrC?CC"},
  {0,NULL,"CKCMCOCRCXC[CgChCiCmCoCqC~DODRDTDWDXDZDfDiDjDlDnDtD|E?E@EIEJEKELE"},
  {0,NULL,"MEREfEgEhEpEqErEvEzE{FBFCFDFOFRFUF`FdFeFkFnFpFzF|GCGTGUGZGbGcGqGs"},
  {0,NULL,"GtGvG{HAHBHFHIHJHTHWHYHcHdHgHiHjHkHuH|I?ICIEIJIKIMINIZI\\I`IhIiImI"},
  {0,NULL,"qIrIuJEJJJQJUJWJXJaJdJfJmJnJqJrJ~KDKEKGKMKQKVK\\K`KcKdKfKhKiKyK}LA"},
  {0,NULL,"LCLFLKLMLOLRLXL^LdLgLjLtLuLvLwM@MJMOM]M^MbMdMiMkMtMxM{N@NBNFNMNNN"},
  {0,NULL,"QNWNYN]NcNfNnNpNsNvNxNyN|OLOPOVOWOYO[O_O`OcOkOrOvOyO|PBPGPLPNPSPa"},
  {0,NULL,"PePoPpPsPtPwPxQAQCQKQNQPQSQXQYQ^QaQeQmQuQyQ}R?RBRFRGRMRQRWRZR[RgR"},
  {0,NULL,"hRiRkRnRrRsRt_L?M?N?T?V?X?[?^?c?f?g?h?r?s?t?}?~@E@R@Y@[@_@`@d@h@i"},
  {0,NULL,"@j@n@u@v@}@~A?AFAGAJAOA_AaAfAgAkAwBBBEBGBIBJBOBQBTB^BbBdBiBqBuBxB"},
  {0,NULL,"zB|B~CECGCHCICUC[CdCgChCjClCnCoCxDADBDDDHDOD\\D`DfDhDiDoDqE?ECEGEH"},
  {0,NULL,"EJEUEWEXE_EdEeEfEkEnEoE|E}E~FAFBFEFMF\\F^FaFfFiFvF}G?G@GCGDGJGMGNG"},
  {0,NULL,"UGXG_GbGcGkGoGpGuGzG}H?HAHBHPH_H`HaHbHfHhHjHmHnHoHvHwIAIMITI\\IhIj"},
  {0,NULL,"IlImInIwJ@JAJCJDJEJHJIJKJ\\JeJfJgJhJjJyJ{KDKEKKKPK]K_KcKeKiKsKuKvL"},
  {0,NULL,"ELGLHLJLNLRLULVLWLXLkLmLsLvLyLzMAMFMGMJMPMTMXM`MbMiMkMlMmMoMpNANE"},
  {0,NULL,"NGNQNSNVNWNZN`NeNhNmNqNrNtN}O@OBOLOSOVOWOYO[O_OcOdOeOiOrOyO{PCPFP"},
  {0,NULL,"GPKPQPUPVPWP\\PfPgPiPmQAQKQMQOQQQSQbQdQeQgQiQlQtQvQwQ{RARERLRMRORU"},
  {0,NULL,"RXR^R_RbRiRqRrRt_L?M?N?U?V?W?Z?]?`?f?g?h?r?s?t?{@A@C@N@O@]@_@`@c@"},
  {0,NULL,"i@k@m@p@r@x@z@~A?AHAIAKAPA]A^AdAjAnAzA{BBBGBKBMBRBUBWBZB`BeBkBlBp"},
  {0,NULL,"BrBsBvCACCCDCFCMCOCWC`CeCfCiCkCnCrCwCzDCDDDLDRDTDeDfDhDkDmDnD~EAE"},
  {0,NULL,"EENEPEREVE]E^EdEeEfEkEnEoEvE{F@FBFCFEFKFLF]FaFfFiFvF}G?G@GCGDGIGL"},
  {0,NULL,"GMGTG]G_GbGdGhGlGuGxGzG|HAHBHEHPHYH_H`HaHcHfHkHoHqHsHuHwIIISIXI[I"},
  {0,NULL,"]I_IcImInI{I~J@JDJHJOJQJUJZJ[J^JaJhJiJjJoK@KCKTKYK\\K]K^KcKeKiKkKy"},
  {0,NULL,"K{K~L?LDLKLMLQLYLZL\\LaLfLiLnLqLrLuL}MEMKMLMQMSMVM]M^McMeMjMnMqMrN"},
  {0,NULL,"BNINKNMNONUNXNZN\\N`NbNfNoNpNrN{N}OCOJONOSOVOYO[O_ObOeOiOnOrOyOzO}"},
  {0,NULL,"PJPKPLPPPSPUP`PePfPlPvP|Q?QCQHQJQPQVQYQ^QaQfQkQmQqQxQyQ}R@RDRPRSR"},
  {0,NULL,"TRURXR\\R`RgRhRlRpRu_K?L?P?T?V?X?]?`?a?f?g?h?p?u?y?}?~@E@P@R@T@Z@^"},
  {0,NULL,"@d@h@i@j@r@x@y@}@~A?AFAHAJATA]A^AfAgAkAwAxA}BABFBIBOBQBTB^BbBdBhB"},
  {0,NULL,"iBuBxB|B}B~C@CGCNCPCSCYC[CdCgChCmCnCwC|C~DBDEDQDSDXDfDiDjDlDnDtD|"},
  {0,NULL,"E?E@EQESEWE]E^E_EfEgEhEiEnEoEvEzE{FCFDFFFGFLF]F_F`FhFqFxFzF{GEGGG"},
  {0,NULL,"KGSGUGXGYG[GeGgGiGnGsGvH@HCHGHHHLHNHRHSHWHZH[HgHkHnHpHrHwHzIHIUIW"},
  {0,NULL,"I[I]IaIdIiIpIyIzJBJDJIJMJPJUJVJ[J_JaJiJkJlJoJqKCKHKTK\\K^K_KcKiKkK"},
  {0,NULL,"sKwKzK{K~L?LDLMLOLQLYL[LaLeLhLiLoLpLuM?MCMDMLMQMRMUM[MaMdMeMjMoMp"},
  {0,NULL,"MqNCNKNNNPNRNUN[N^NdNeNhNlNsNvNwNxN|ODOGOIOMOOORO\\OgOjOmOpOqOsOyO"},
  {0,NULL,"|PBPGPLPNPPPRPXP`PaPcPjPxP~Q@QFQKQMQQQSQWQZQ[Q_QbQiQwQzQ{Q~RARERG"},
  {0,NULL,"RHRIRNRPR\\R`RbRiRkRpRv_K?L?P?T?V?X?]?`?a?f?g?h?p?u?y?}?~@E@P@R@T@"},
  {0,NULL,"Z@^@d@h@l@m@o@s@t@{A@AEAHAIAJAQAVA\\AhAmAoA|A}B?B@BIBKBXBZB[B^B_Bd"},
  {0,NULL,"BhBiBlBnB|B}B~C@CLCNCOCSC^CbCfChCiCmCnCvCyC~D?DCDFDPDZDcDdDfDpDsD"},
  {0,NULL,"tD|EDEEEMEOEPEQEZE_EcEdEgEjEmEsEuEwEyFCFEFFFQFXFYFbFdFgFuFxF|G@GA"},
  {0,NULL,"GEGJGPGSGZG[G_GbGcGeGgGiGnGyGzHCHGHHHNHWHXHYH[H]H`HkHlHpHqHvH}IBI"},
  {0,NULL,"CILIZIcIdIfIhIiI~J?JBJCJLJNJSJUJVJ[J^J_JgJhJjJpJrKBKGKNKOK`KhKmKn"},
  {0,NULL,"KrKtKxK|K}L@LALILQLYLZL[L\\LaLkLlLtLxLyL{MAMFMHMIMMMOMXM`MbMiMkMlM"},
  {0,NULL,"mMnMrNANFNHNJNLNSN_NaNcNiNjNmNqNzO?OAOBOCOLOPOQOUO[O^O_O`OhOkOrOv"},
  {0,NULL,"OwOxO|O}PBPMPOPYPZP[P`PcPgPiPmQAQGQNQPQRQUQ\\Q`QcQgQkQnQpQqQtQvRDR"},
  {0,NULL,"FRJRTRVRXR[R]R_RaRgRlRnRsRw_K?L?P?W?X?Y?\\?d?e?f?g?h?p?u?y@@@B@F@R"},
  {0,NULL,"@S@T@U@W@c@h@i@j@r@x@y@|ABACAFAHAKANARAYAfAgAkAwAxA}BABFBIBQBUBVB"},
  {0,NULL,"^BaBcBhBoBrBsBxB{C@CGCMCPCRCSCYC]C`CdCgCmCnCqC{C}D@DEDKDNDWD_DaDf"},
  {0,NULL,"DlDmDrE@EAEBEKERESE[E\\E_EcEeEhElEqErEzE{F@FAFBFEFIFOFUFcFeFjFuFvF"},
  {0,NULL,"wF{F|GGGNGPGRGVG\\G`GcGfGkGrGwGxGyGzHBHDHJHOHUHXH\\HaHdHhHiHrHsHtHz"},
  {0,NULL,"H}IAIMITIYIZI[IaIkIoIwJ@JAJFJGJQJSJYJZJ]JbJdJhJiJkJmJ|J}KIKJKRKaK"},
  {0,NULL,"bKfKlKoKpKyKzK{L?LDLKLPLSLTL^L_LcLjLmLxLzL{L|MAMFMGMJMPMTMXM_MbMf"},
  {0,NULL,"MgMhMmMnMrNANFNHNJNLNSNWNZN^N_NdNnNqNvNwNxN}ODONOOOPOTOVO\\OmOpOqO"},
  {0,NULL,"rOsOvOxP@PFPJPLPNPRPSPTPXP[P\\PkPtPzQAQCQDQJQOQUQ\\Q`QdQhQjQmQpQsQv"},
  {0,NULL,"QxQ|RBRKRRRSRWRXRZRaRfRmRpRuRvRwRz_N?O?P?W?X?Y?Z?`?a?f?g?h?q?v?x@"},
  {0,NULL,"@@B@F@M@Q@S@U@V@[@j@k@l@p@r@y@z@}@~AGAIAJAPATA]AeAiAlAyA|BDBEBHBL"},
  {0,NULL,"BPBSBVBYB[BcBfBjBnBtByBzCBCHCICJCKCLCVC\\C^CaCbClCnCpCvCzC|D@DJDVD"},
  {0,NULL,"[DbDjDkDnDpDqD}EDEGEIEUEVE[E]E_EcEeEhEiEkEoEzE{F@FAFEFFFGFKF]FcFe"},
  {0,NULL,"FjFrFtFwF|GBGHGNGPGRGVG\\G`GaGcGfGjGkGwGyG{H?HDHIHKHUHVHXH]HdHhHkH"},
  {0,NULL,"lHmHtHuHzIGIRIVI[IeIiIkIlImIxJ?JAJDJGJNJPJQJTJ^J_JaJgJjJlJqK@KCKH"},
  {0,NULL,"KTKYK]K_KeKiKkKsKwKyKzK~L?LKLOLYLZL[L\\LaLgLhLnLoLrLwL~MDMEMKMNMRM"},
  {0,NULL,"ZM[M\\M]M^MaMmMpMrNDNINNNONRNTNWNYN]NgNkNnNtNuO?O@OEOFOKOUOWOXOZO]"},
  {0,NULL,"O`OdOfOhOoOuOyOzP?PBPEPIPPPTPUPVPXPZPhPrPyQBQDQEQGQOQTQ]Q`QdQhQjQ"},
  {0,NULL,"lQpQrQsQvQ|RCRNRPRXRZR[R^R`RbRjRlRsRt_L?M?N?U?V?W?Z?]?`?f?g?h?r?s"},
  {0,NULL,"?t?{@A@C@N@O@]@_@`@c@j@k@l@o@q@s@{ADAEAFAHAKAQA[A\\AeAiAlAwAyAzBCB"},
  {0,NULL,"EBMBOBPBWB\\B`BcBpBrBsBuBvBwCACDCECFCGCMCWCYCZCcCdCkCtCuCwCxC~DCDK"},
  {0,NULL,"DNDWD^DdDeDnDoDpE@EAEBEHEIEPEQEVEYEcEeEhEmEsEtEuExEyFBFCFDFXFYF[F"},
  {0,NULL,"cFeFjFsFtFvGDGGGHGMGQGVGYG]G`GdGlGtGuGvGxG|G~H@HAHBHEHRH\\HaHcHeHg"},
  {0,NULL,"HiHpHqHwHxH{IEIKINIYIbIcIdIeImIzI{I|JDJJJLJNJOJYJ^J_JaJgJkJlJpK?K"},
  {0,NULL,"BKLKNKOK`KgKhKjKmKnK|K}LALBLILLLMLOLQLYL[L\\LjLmLxLzL{L|M@MBMGMJMM"},
  {0,NULL,"MOMWMYM_MgMiMlMmMoMpNANENGNQNSNVNWNYN]NgNkNnNuN~O@ODOEOFOKOTOWOXO"},
  {0,NULL,"\\O]OcOdOfOgOlOsOzO|O}O~PFPIPPPYPZP\\P]PePoPqPuQBQEQIQMQOQTQXQZQ]Qd"},
  {0,NULL,"QhQlQoQsQuRARCRERIRJRNRORQR[RbRcRkRmRnRsRwR{_L?M?N?T?U?Y?\\?_?d?f?"},
  {0,NULL,"g?h?r?s?t?|@?@D@N@Q@Y@]@b@d@i@k@m@p@r@x@|AAABAHAIAJANAXAYAdAjAnAz"},
  {0,NULL,"A{BBBGBKBMBSBTBWB]B_BeBjBkBpByB|B}B~CCCDCFCHCOC[CaCeCfCiCkCqCrCsC"},
  {0,NULL,"wD@DADFDPDZD`DbDgDlDmDnD|EDEEELERESETEVEXEcEdEgElEpEqEvEzF@FAFDFF"},
  {0,NULL,"FIFRFUFbFdFgFsFtG?G@GEGFGJGOGQGWGZG^GaGmGnGoGqGtG}G~H?H@HHHIHTH[H"},
  {0,NULL,"]H^HbHeHrHsHuHvH{I@IDIJIOI]I_IbIhIkIoIxIyI}JCJFJGJJJMJPJ]JcJdJiJj"},
  {0,NULL,"JlJwJ|J}KIKJKMKbKdKfKoKpKqKwKyKzK~L?LDLSLTL_L`LcLdLkLlLtLxLyL{M@M"},
  {0,NULL,"BMHMIMPMTMWMYM`MfMhMkMmMoMpNANENGNQNSNVN]N`NfNiNjNlNpNrN{N|OCOEOI"},
  {0,NULL,"OJOMOUO[O]O_ObOeOfOgOnOwOyO~P?PJPNPOPRPSPUP]P_PnPwP{QBQKQLQNQQQTQ"},
  {0,NULL,"XQ[Q]QcQeQgQoQrQtQuQwR?RHRKRMRNRYRZR_R`RcRjRuRvRwRzR}_K?M?O?W?X?Y"},
  {0,NULL,"?[?b?c?f?g?h?o?w?z@@@B@F@M@O@T@V@W@b@j@k@l@n@u@w@z@}@~AHAIAJAOAUA"},
  {0,NULL,"aAeAiAlAzB@BCBDBFBHBPBSBVBYB[BcBhBjBnBsBtByCBCCCDCJCNCSCYC\\C^CaCb"},
  {0,NULL,"CkCoCpCtC{C|DDDFDPDZD^DiDkDqDrDuD|EDEEEKENEUEWEYE]EcEdEgEiEkEnE|E"},
  {0,NULL,"~F?FBFCFDFMFPF\\FbFdFgFsFuFyF~GAGFGLGOGPGWG[G`GgGlGqGrGsGxG|G~HCHF"},
  {0,NULL,"HJHMHQHWHYH\\H^HeHmHnHuHyH}H~IEIKINIZI]I^IjInIpIzI{I|JHJKJPJSJTJXJ"},
  {0,NULL,"\\J`JfJhJiJkJtJyJ{KKKPKSK]K^KcKiKkKsKuLCLELFLHLJLRLULVLXL]LbLkLlLt"},
  {0,NULL,"LxLyL{M@MBMGMJMMMOMXM_MbMfMgMhMpMqMrN?N@NENHNJNVN[N]NaNcNfNnNoNwN"},
  {0,NULL,"zN{N~ODOHOIOJOPOQOTOaObOlOmOtOvO~PAPBPCPEPKPWP]P`PaPbPfPkPtPzQDQE"},
  {0,NULL,"QFQGQHQTQWQ[Q]Q^Q`QkQpQrQzQ|Q}RCRGRLRQRRRUR\\R`RaRdRhRiRtRzR{R}R~_"},
  {0,NULL,"K?M?O?U?V?W?_?d?e?f?g?h?o?w?z?{@A@C@M@O@X@\\@^@_@h@l@m@p@x@yAAABAC"},
  {0,NULL,"AFAGAJARAXAYAhAmAoAvA~B?B@BCBJBNBPBRBZB\\BdBfBiBmBtBuBwC?CECJCNCQC"},
  {0,NULL,"UCXCZC_CbChCjCqCrCtCyCzDEDHDOD\\D^DaDbDjDlDsE?ECEGEMERETEYE[E^EdEe"},
  {0,NULL,"EfElEpErEvE{F@FCFEFFFIFOFRFaFfFiFqF~GAGBGCGDGIGLGMGTG]G_GbGdGhGiG"},
  {0,NULL,"jGlG{G|HCHKHNHPHVHYHZH_H`HcHsHtHwH|H~I@IBICILI^I_IaIgImIoI~J?JBJD"},
  {0,NULL,"JGJMJRJXJZJ]JbJcJgJkJlJmJwJ|KJKMKRKaKbKdKlKoKqKwKzK{K~L?LKLPLSL^L"},
  {0,NULL,"`LcLdLkLmLsLvLyLzMAMFMHMIMMMOMWMYM_MgMiMlMpMqMrN?N@NENHNJNVNXN\\Na"},
  {0,NULL,"NgNhNmNsNuNyN~OAOBOGOHOLOROWOXOcOjOkOlOoOtO{P?P@PBPDPNPQPSPTP_P`P"},
  {0,NULL,"dPoPqPuQ?Q@QEQGQPQSQ^QaQbQfQkQlQqQyQ}R@RCRERHRPRQRSRVRZRbRdReRfRj"},
  {0,NULL,"RvRwRzR}S?_K?M?O?T?U?Y?Z?]?a?f?g?h?o?w?z?|@?@D@W@X@Y@\\@a@b@h@i@j@"},
  {0,NULL,"q@s@tA@ADAEAGAIAKAVA[A\\AfAgAkAvBABDBFBGBJBNBTBVBaBbBeBgBjBkBmBoBq"},
  {0,NULL,"C?CBCCCRCTCUC\\C]C`CeCjClCuCvCzC{DADCDGDYD]D`DdDeDjDrDtD}D~EFEIEKE"},
  {0,NULL,"OEQEXE^EfEgEhEjEsEtEuEwExFAFBFEFQFXF[F_F`FhFqFrFyF{GCGFGIGKGUGWG\\"},
  {0,NULL,"G^GfGhGmGoGpGrG}HFHJHKHOHPHQHTHUH_HdHfHlHqHuHxH|I?IAIMITI]I`IdIeI"},
  {0,NULL,"fIgIwJ@JAJLJOJPJRJVJWJ[J_JaJiJjJlJpJrK?KGKLKNK`KgKhKjKrKtKxK|L@LB"},
  {0,NULL,"LILLLMLOLYLZL\\LaLjLlLsLtLvL|MAMFMGMJMPMTMWMYM`MfMhMkMpMqMrN?N@NEN"},
  {0,NULL,"HNJNVN[N^NdNeNhNlNrNsNtNvNwN|OIOMOOOROYOZObOeOjOmOoOuO{O|PAPIPLPM"},
  {0,NULL,"PQPXPYPbPcPePnPwP{Q@QCQDQFQKQSQWQ[Q_QbQfQjQrQwQyQ|Q~R@RIRMRPRRRTR"},
  {0,NULL,"[R`ReRgRkRoRsRwR{R~S?S@_L?M?N?T?U?Y?\\?_?d?f?g?h?r?s?t?|@?@D@N@Q@Y"},
  {0,NULL,"@]@b@d@h@i@j@n@u@vA@ADAEAGAIAJAMAWAZAfAgAkAwBBBEBGBIBJBNBTBVBaBbB"},
  {0,NULL,"eBjBkBmBqByB|B~CCCHCICOCUC[C\\CeChCjClCrCtCuD?DADBDJDVD[D^D_D`DdDi"},
  {0,NULL,"DmD}EDEGEOEREWEXEZE\\EcEeEhEmEsEtE|E}F?FCFDFFFJFSFTFcFeFjFsFtFvGDG"},
  {0,NULL,"GGHGKGQGRGZG\\G]GaGdGeGnGqGtG|G~H@HEHHHIHRHVH]HcHeHgHjHmHqH{H|I@IH"},
  {0,NULL,"IUIWIZI\\IbIcIlIoIyIzJBJFJJJOJRJSJTJ]JbJdJgJhJkJuJvJ~KFKUK[KgKhKmK"},
  {0,NULL,"nKrKtKuKvLCLELFLJLPLSLTL^L`LdLgLhLnLoLrLwM?MCMDMLMQMRMUMVMZM\\McMd"},
  {0,NULL,"MnMqMrNBNINKNMNONUNWNZN^N_NdNnNqNxN}O@OBODOKOPOTOVOWO\\OcOdOiOlOrO"},
  {0,NULL,"sOwPAPFPIPKPNPOPRPZP\\PdPfPpPsP}Q@QCQDQFQJQUQ\\Q_Q`QaQjQmQyQ|Q~R@RB"},
  {0,NULL,"RFRGRJRQRSRWR]RaReRfRgRqRtRxRyR|_L?M?N?T?V?X?[?^?c?f?g?h?r?s?t?}?"},
  {0,NULL,"~@E@R@Y@[@_@`@d@j@k@l@o@q@s@|AAACAFAGAKA`AbAcAeAiAlAwAyAzBCBEBMBO"},
  {0,NULL,"BXBYB[B`BbBgBqBuBvBxBzCACECGCICMCUCVCWCZCcCdClCsCxCyD@DBDCDIDMDUD"},
  {0,NULL,"bDeDgDiDoDrEBECEFEHEKEMEPEWE[EcEdEgElEpEqEuEwEyFAFEFFFVFWFZFbFdFg"},
  {0,NULL,"FsFtG?G@GEGFGJGPGSGZG[G_GbGcGiGkGnGoGzG}H?HHHIHPHTHXH[H]H`HbHiHoH"},
  {0,NULL,"pHvI?I@IGIRIVIYI^IdIhInIoIxJ?JAJCJFJHJVJWJXJ\\J`JfJiJkJlJxJzKAKVKX"},
  {0,NULL,"KZKaKbKdKfKlKoKxK|K}L@LBLLLNLRLULWL]LbLeLfLgLpLqLwL~MDMEMKMNMRMUM"},
  {0,NULL,"[MaMdMeMjMnMqMrNBNINKNMNONUN[N]NaNcNfNnNuNwN{N~ODOEOHOIOJOMOTO]Ob"},
  {0,NULL,"OfOgOlOnOsO{O~PCPHPIPJPQPSPWPZP[P]PjPxP~QDQFQGQHQRQVQWQ\\Q^Q`QkQnQ"},
  {0,NULL,"pQqQzQ~RDRFRGRRRTRVRYRZRdRfRhRkRmRoRxRyR|SB_K?L?P?U?V?W?[?^?b?f?g"},
  {0,NULL,"?h?p?u?y?{@A@C@P@S@X@]@^@c@h@l@m@o@s@tAAABACAGAIAJALAbAcAhAmAoA|A"},
  {0,NULL,"}B?B@BIBKBNBPBRBZB\\BdBfBiBkBlBmBtB~C?CKCLCNCOC^C_CbCfChCjCqCxCyC{"},
  {0,NULL,"C~DDDJDVD[DaDgDhDrDsDtD}EDEGEHELEMENEQETEcEeEhElEqErEuExEyFAFBFDF"},
  {0,NULL,"HFVFWFcFeFjFuFvFwF{F|GGGMGQGVGYG]G`GmGtGuGvGwGxH@HBHDHJHLHOHRH\\Ha"},
  {0,NULL,"HdHeHhHiHnHqHtHvH~IFIPIQIYI`IcIhIkIpIwI|I}JGJIJOJWJXJYJ\\J`JeJhJiJ"},
  {0,NULL,"jJnJzKAKVKWKZKdKfKlKoKpKqKxL@LALBLILLLNLRLULVLXLbLgLhLnLoLrLwL}L~"},
  {0,NULL,"M?MCMNMSMVM]M^McMeMjMoMpMqNCNKNNNPNRNUNYN\\N_NdNgNjNpNqNvNzO?OCONO"},
  {0,NULL,"OOPOUOVOZO_O`OmOpOrOvOxO{PEPHPMPNPRPVPYP[P]P^PlPvP|Q?Q@QEQIQLQSQX"},
  {0,NULL,"QZQ]Q_QaQlQuQyQ}RARCRERIRKRORRRURYR_RdRgRiRjRoRxRyR|SB_K?L?P?W?X?"},
  {0,NULL,"Y?\\?d?e?f?g?h?p?u?y@@@B@F@R@S@T@U@W@c@i@k@m@n@v@w@{A@ADAFAGAKASAW"},
  {0,NULL,"AZAdAjAnAxB?BABKBLBMBQBRBSBUBYB]BfBoBrBxBzB{C?CGCKCMCPCRCVCWCXC_C"},
  {0,NULL,"`CgCtCvC}D?DDDEDIDMDUD_D`DcDhDlDpEBECEFEIENESEXEYE\\EcEdEgEjEmEsE|"},
  {0,NULL,"E~F?FBFCFEFNFSFTFbFdFgFuFxF|G@GAGEGLGOGPGWG[G`GcGfGgGlGrGxGyGzHBH"},
  {0,NULL,"CHGHJHQHWHXHYH\\H`HjHpHtHyH|H}IIISIXIZIbIdIgIjIkI{I~J@JEJGJJJKJSJV"},
  {0,NULL,"J]JcJdJgJjJlJsJuJvKQKUK[K`KgKhKjKmKrKuKvLCLELGLHLPL^L_L`LcLdLeLfL"},
  {0,NULL,"gLpLqLwL}MEMKMLMQMSMZM[M\\M]M^MaMoMpMqNCNKNNNPNRNUN]N`NfNiNjNlNrN|"},
  {0,NULL,"OAOCOEOFOLOMOUO[O]O^O_O`OgOhOjOkOwPDPFPGPJPMPOPSPYP\\PaPbPhPrPyQ?Q"},
  {0,NULL,"HQKQLQQQTQWQXQ[Q]Q^QeQrQzQ{Q}R?RCRHRMRQRUR[R]RcReRjRkRqRrRxRyR|SC"},
  {0,NULL,"SD_K?L?P?U?V?W?[?^?b?f?g?h?p?u?y?{@A@C@P@S@X@]@^@c@i@k@m@n@v@w@z@"},
  {0,NULL,"~A?AGAIAKAOAUA_AdAjAnAxB?BABKBLBMBRBUBWBZB`BeBfBkBlBmBrBvC?CKCLCM"},
  {0,NULL,"COCRCVCWC_C`CeCfCpCwCyC}DBDDDGDYD]D_DhDiDnDsDuD}D~EFEJEMENEUEVE\\E"},
  {0,NULL,"fEgEhEiEnEoE}E~F?FAFDFFFPF\\F^F_F`FhFqFxFzF{GEGGGIGSGTGVGYG^GiGjGm"},
  {0,NULL,"GtGvGwH@HDHHHLHNHOHRHSHTHZH[HdHiHkHnHoHyH|IDIJIOIYIgIiIjIlIpIxIyI"},
  {0,NULL,"}JHJIJRJTJUJYJ`JeJfJgJkJlJtJ{KDKEKPKSK]K^K_KeKkKsKvLCLELFLGLJLNLR"},
  {0,NULL,"LWLXL]LbLjLlLsLtLvL|M@MBMHMIMPMTMWMYM_MgMiMlMmMnMrNANFNHNJNLNSNXN"},
  {0,NULL,"^NbNiNkNlNxNyN|OAOEOFOGOKOMORO\\O^OgOhOjOkOqOsOwPEPGPHPKPLPOPVPWPX"},
  {0,NULL,"P^PaPoPqPuQBQCQJQNQPQVQYQcQfQhQjQnQoQqQsQxR@RDRGRLRNRVRWR^ReRhRlR"},
  {0,NULL,"mRrRtRzR{R}R~S@SA_N?O?P?T?V?X?\\?_?e?f?g?h?q?v?x?}?~@E@P@V@Z@[@`@a"},
  {0,NULL,"@j@k@l@p@r@y@|AAACAGAIAKANARAXAeAiAlAyA|BDBEBHBLBOBXBYB[B`BbBgBlB"},
  {0,NULL,"nBqBvBzCACBCICKCLCTCVCWC\\C^CcClCrCxC|D?D@DEDGDYD]DaDbDcDkDmDoD}D~"},
  {0,NULL,"EFEHESETEZE[E]EfEgEhEpEqErEvEzE{FBFCFDFOFRFUF_F`FhFrFxFyFzF}GHGKG"},
  {0,NULL,"SGUGXGYG[GeGgGpGsGuGvHAHEHFHGHLHMHQHRHSHWHfHgHjHkHrHtI?I@IEIKINI\\"},
  {0,NULL,"I_I`IaIiIkIzI{I|JEJFJMJUJWJZJbJcJdJgJhJjJmJwJ}KIKMKRKaKdKfKlKpKqK"},
  {0,NULL,"wKyK{K~LDLKLPLTL^L_L`LdLjLlLsLtLvL|M@MBMGMJMMMOMXM`MbMiMkMlMnMoMq"},
  {0,NULL,"N?N@NFNGNLNQNYN[NbNcNeNkNoNtNzO?O@OFOKOQOSOYOZO^O`OaOdOhOiOuOzP?P"},
  {0,NULL,"@PAPHPJPPPRPTP^P_PbPgPiPmQFQHQIQMQRQVQWQYQZQ_QiQnQzQ{Q~RARDRFRHRK"},
  {0,NULL,"RORSR\\R]RfRjRlRoRqRuRwRzR}S?SASF_K?M?O?U?V?W?_?d?e?f?g?h?o?w?z?{@"},
  {0,NULL,"A@C@M@O@X@\\@^@_@j@k@l@n@u@w@{ADAEAFAHAJAMASAWAeAiAlAzB@BCBDBFBHBO"},
  {0,NULL,"BPBWB\\B`BcBiBpBsBtBuBwCDCECJCNCQCSCYCZCaCbCdCkCpCqCtC}DADCDQDSDXD"},
  {0,NULL,"^D`DaDcDeDqD|E?E@EPETEUEYEZE\\EfEgEhEjEsEtE}E~F?FAFEFFFJFNFSF_F`Fh"},
  {0,NULL,"FqFrFyF{GCGFGIGSGTGVGYG^GbGhGiGjGmGwG{G}HKHNHOHPHTHUHZH[H_HdHnHsH"},
  {0,NULL,"xH{H|H}IGIRIVIZI\\I_IfIgIpIxJ?JAJEJIJJJLJRJZJbJcJdJhJiJjJsJvJ~KFKQ"},
  {0,NULL,"K[K`KjKmKnKrKtKuKvLFLGLHLJLSLTL^L_LcLdLeLhLiLoLpLuL~MDMEMKMNMRMVM"},
  {0,NULL,"]M^McMeMjMmMnMoNBNCNDNMNPNTNYN[NbNcNeNkNoNtNwNzN{O?OIOOOQOSOYOZOa"},
  {0,NULL,"ObOeOmOuOvO|P?PAPCPDPFPOPTPWPbPcPdPlPvP|QBQIQMQOQRQVQYQZQcQhQiQnQ"},
  {0,NULL,"oQsQuQxRARDRKRMRTRWR]R^RaRcRiRnRqRuRxRyR|SCSD_K?M?O?T?U?Y?Z?]?a?f"},
  {0,NULL,"?g?h?o?w?z?|@?@D@W@X@Y@\\@a@b@h@l@m@p@x@y@z@}A?AFAGAKAPATA^AhAmAoA"},
  {0,NULL,"vA~B?B@BCBJBNBXB\\B]B_BaBgBmBoBqBwB{C?CECQCRCTCUCXCZC]C_CcCjCoCqCu"},
  {0,NULL,"CwCzC|DIDMDUDaDdDfDjDkDuEBECEFEJEOETEVE^E_EcEdEgEiEkEnEvEzF@FAFBF"},
  {0,NULL,"DFGFKFLFbFdFgFsFuFyF~GAGFGJGOGQGWGZG^GmGoGpGqGrGtG}G~HFHJHMHOHQHT"},
  {0,NULL,"H\\H^HbHeHuHwHxHyHzI@IFIPIQI]IfIiIjImIoIwI|I}JFJKJLJPJQJUJ[J^J_JgJ"},
  {0,NULL,"hJkJoJqK@KHKYK\\K]K^K_KcKeKsKwKyKzK{LDLKLMLOLQLZL[L\\LeLfLgLpLqLwL}"},
  {0,NULL,"L~M?MCMNMSMUMVMZM\\McMdMmMnMoNBNCNDNMNPNTN_NaNcNiNjNmNqNyNzN~OAOBO"},
  {0,NULL,"HOLOPOQOTO^OaOcOkOlOtOvOzP@PBPCPLPMPUPWPXPYP_P`PpPsP}QAQIQLQNQRQU"},
  {0,NULL,"QXQ\\QcQeQgQnQoQtQuR?RBRFRJRKRLRNRXR\\RbRfRlRnRpRrSBSCSDSESH_N?O?P?"},
  {0,NULL,"T?U?Y?^?b?c?f?g?h?q?v?x?|@?@D@N@Q@U@Z@\\@a@h@l@m@u@v@w@z@}A?AFAHAK"},
  {0,NULL,"AUA_AaAhAmAoAvAyA{A|A}A~BNBXB\\B]B_BaBgBoBpBwB{B}C@CACFCPCQCTCXCZC"},
  {0,NULL,"]CcCiCmCoCpCsCzD?DBDKDNDWDcDgDhDjDqDuE@EAEBEJELENEWEZE^EcEeEhEiEk"},
  {0,NULL,"EoE|E}F?FCFEFFFMFPF^FcFeFjFrFtFwF|GBGHGKGQGRGZG\\G]GaGdGeGfGhGnGyG"},
  {0,NULL,"{HEHGHIHKHUHVHXH]HcHgHmHoHyHzH{I?IBICILI[I`IbIlInIpI~J?JBJIJJJKJQ"},
  {0,NULL,"JTJWJ\\J`JeJiJjJlJtJyKDKEKKKSK^K_KcKeKiKkKuKvLCLFLGLHLNLULVLWL]LbL"},
  {0,NULL,"jLmLxLzL{L|MAMFMHMIMMMOMWMYM`MfMhMkMnMoMqN?N@NFNGNLNQNYN\\N_NdNgNj"},
  {0,NULL,"NpNsNuNvO?OCONOOOUOXOZO]O`OfOnOoOpOuOxOzPCPDPEPGPPPVP[PaPdPfPnPwP"},
  {0,NULL,"{Q?Q@QIQLQRQUQXQZQ\\Q_QaQmQuQyQ~R?RBRFRGRPRURYR]R^RcRhRiRoRpRrRzR{"},
  {0,NULL,"R}R~S@SASG_N?O?P?W?X?Y?Z?`?a?f?g?h?q?v?x@@@B@F@M@Q@S@U@V@[@i@k@m@"},
  {0,NULL,"o@q@t@{A@ADAFAGAJAQAVA[AdAjAnAxA{A~BBBHBLBQBRBSBUBYB]BfBtBxByBzB{"},
  {0,NULL,"CHCICJCKCPCQCVCXC[C_CaCgCsCuCvC|C}C~DHDOD\\D_DeDgDkDpDtE?ECEGEIELE"},
  {0,NULL,"OEPE\\E]EdEeEfEjEmEtEwExEyFAFDFFFQFYF[FaFfFiFwFzF}F~G?GBGLGNGOGRGT"},
  {0,NULL,"GXGaGjGkGqGsGwG{H?HDHIHLHMHSHVHZH^HbHhHjHlHpHxHzH~IDIJIOI[I\\I^IcI"},
  {0,NULL,"eIfIxIyI}JEJNJOJQJVJXJ[J^JaJhJiJkJrK?KBKGKLKOKgKjKmKnKrKtKxK}L@LA"},
  {0,NULL,"LBLLLMLOLQLZL[LaLkLmLsLvLyLzM@MBMHMIMPMTMXM_MbMfMgMhMnMoMqN?N@NFN"},
  {0,NULL,"GNLNQNXNZN\\N`NbNfNoNpNxNyN{N}OGOHOJONOSOVOaOiOnOpOqOtOyO}PDPHPIPM"},
  {0,NULL,"PUPZP^PcPdPePkPtPzQ?QHQJQLQQQVQYQ^QaQeQiQmQxQzQ{Q}R?RBRIRJRTRWRYR"},
  {0,NULL,"\\RdRgRkRnRpRqRwR{R~S?S@SFSGSJ_K?M?O?W?X?Y?[?b?c?f?g?h?o?w?z@@@B@F"},
  {0,NULL,"@M@O@T@V@W@b@h@i@j@q@s@t@|ABACAHAIAKALA`AbAfAgAkAvBABDBFBGBJBQBUB"},
  {0,NULL,"VB^BaBcBhBjBnBoBrBsCBCCCDCRCSCTCYC\\C]C`CeCmCpCsCuCyC{DEDLDRDTDdDl"},
  {0,NULL,"DoDqDrDsD~EAEEEHEKELEOESEUEdEeEfElEpErEwExEyFCFDFFFHFWFZFaFfFiFqF"},
  {0,NULL,"~GAGBGCGDGLGNGOGRGTGXGaGgGjGlGqGsG{G|G~HCHMHNHSHVHYHZH^HcHiHlHsHy"},
  {0,NULL,"H~I?IHIUIWI^I_I`IeIhIjIyIzJBJCJKJNJXJYJZJ\\JeJfJgJjJlJnJxJzKWKXKZK"},
  {0,NULL,"aKbKdKfKpKqK|K}L@LALILLLNLVLWLXL]LbLfLiLnLqLrLuM?MCMDMLMQMRMZM[M\\"},
  {0,NULL,"M]M^MaMmMnMoNBNCNDNMNPNTNWNZN`NeNhNmNrNsNtN|O@OBOLOROWOXOYO[OcOeO"},
  {0,NULL,"jOkOoOuOxO{O|O~P@PKPQP]P^P_PcPfPhPrPyQAQJQMQOQQQUQYQdQeQgQiQmQsQv"},
  {0,NULL,"QxQ{R?RBRHRJRORVRYR^R_RmRoRrRsRuRxRyR|SBSESHSI_N?O?P?T?U?Y?^?b?c?"},
  {0,NULL,"f?g?h?q?v?x?|@?@D@N@Q@U@Z@\\@a@i@k@m@o@q@t@|AAABAFAHAJALA`AcAdAjAn"},
  {0,NULL,"AxA{A~BBBHBLBSBTBWB]B_BeBpBwByB{B|B}C@CFCHCJCPCQCXC[CaCgCiCkCoCrC"},
  {0,NULL,"sCvCxC{DQDSDXDgDmDoDpDsDuD|E?E@EIEJEKELEMEREfEgEhEpEqErEuEwExFBFC"},
  {0,NULL,"FEFHFVFZF_F`FhFrFxFyFzF}GHGIGKGUGWG\\G^GdGeGfGhGpGrGyHAHEHFHGHKHQH"},
  {0,NULL,"UHWH_HfHgHmHrHvHxH~I?IIISIXIYI^I`IaIfIlI{I~J@JCJLJMJTJWJYJ`JeJfJg"},
  {0,NULL,"JhJkJnJxKAKVKWKXKaKbKlKoKpKqKxK|K}LALBLILRLULVLWLXL]LeLhLiLoLpLuL"},
  {0,NULL,"}MEMKMLMQMSMUMVMZM\\McMdMmMpMrNDNINNNONRNTNXN^NbNiNkNlNoNxNyN}OAOF"},
  {0,NULL,"OGOKOQOSO\\O^OaOdOhOiOqOtOxO}O~P?PGPHPQPTP[P^PaPePpPsP}QBQCQKQNQPQ"},
  {0,NULL,"TQ[QbQcQfQhQjQoQrQtQwQ|R@RLRORRRSRVR[R_RdRmRnRtRvRxRyR|SBSESHSI_N"},
  {0,NULL,"?O?P?T?V?X?\\?_?e?f?g?h?q?v?x?}?~@E@P@V@Z@[@`@a@h@l@m@u@v@w@{A@AEA"},
  {0,NULL,"HAIAKAMASAZAhAmAoAvAyA{A|A}A~BXBZB[B^B_BdBgBhBlBnBvB}C@CACBCFCLCT"},
  {0,NULL,"C]C^CcCfCiCmCoC}C~D?D@DADLDRDTD^D_DbDcDtDuD~EAEEEJEQEXEYEZE[EdEeE"},
  {0,NULL,"fEjEmEtE|E}E~FAFBFDFJFNFTFaFfFiFwFzF}F~G?GBGJGMGNGUGXG_GkGoGpGsGu"},
  {0,NULL,"GvH?HAHDHFHLHMHSH^HaHbHfHhHjHlHoHrH{H}IFIPIQI\\IaIbIeIgInIwI|I}JEJ"},
  {0,NULL,"HJMJNJRJSJ]JbJcJiJkJlJsJuJ~KFKQKUK`KgKhKjKnKtLCLELFLGLHLJLPLSLTL_"},
  {0,NULL,"L`LcLfLiLnLqLrLuL}L~M?MCMNMSMUM[MaMdMeMjMmMpMrNDNINNNONRNTNXN\\NaN"},
  {0,NULL,"gNhNmNpNsNuNvNyN~OGOHOJONOROXOfOnOoOpOqOtOwO}P@PAPDPEPVP\\P_PbPdPe"},
  {0,NULL,"PjPxP~QAQEQGQNQPQSQbQdQfQgQkQlQpQqQtQvQwRERIRLRMRQRWRZRaRcReRhRsR"},
  {0,NULL,"vRxRyR|SCSDSISLSM_L?M?N?Q?R?S?]?^?_?i?k?l?o?r?v?}@@@A@Q@X@Z@\\@a@b"},
  {0,NULL,"@h@i@j@n@u@v@|@}A@AOAWAYA[A]AbAgAjAoApAqAuAwBDBKBNBSBXB]B_BeBhBrB"},
  {0,NULL,"sBuBvBxC?CJCKCLCNCOCVC\\C^C_CaCbCnCqC{C}D@DEDKDODQDRDUD\\DcDfDoE@EA"},
  {0,NULL,"EBEHEIEPEQEVEYEcEeEhEmEsEtExF?F@FMFTFUFWFYF]FbFcFhFkFlFoFvGBGEGIG"},
  {0,NULL,"KGOGWGZG^GbGcGkGuGwGxHCHGHHHLHMHNHSHVHWHYHZH^HiHrHsHtHzH}IEIFIGIM"},
  {0,NULL,"INIXIYIgImIwJ@JAJCJDJEJHJIJKJ]JbJdJgJhJkJuJvJ~KEKFKNKRKTKZK_KaKbK"},
  {0,NULL,"rKsKtKyLALCLFLILKLMLQLRLUL`LdLgLhLlLmLrLtM?MGMHMIMQMRMUMVM\\MuM|M~"},
  {0,NULL,"N?N@NANBNINUNWN[N\\NoNqNsNzN|N}OGOHOTOUOZO\\ObOcOdOhOkOnP?PEPIPKPMP"},
  {0,NULL,"NPRPZP_PaPcPfPhPpPsPxP|P}QFQGQHQPQRQVQYQ^QaQfQkQnQsQvQ{RARCRERLRM"},
  {0,NULL,"RNRRRUR^R_RcRkRnRpRsRwR{R}SESHSN_K?M?O?Q?R?S?Z?b?d?l?m?n?q?y?z@?@"},
  {0,NULL,"C@E@Q@S@T@U@V@c@h@i@j@q@s@t@|@}A@AMAOARA\\A^AbAfAiAnApArAtAzA}BJBS"},
  {0,NULL,"BUBYB[B]BcBiBmBqBuBwB|CACDCFCLCMCOCWC^CcCfCiCmCnCoCxDADBDDDGDMDOD"},
  {0,NULL,"XD[D]D`DgDjE?ECEGEMERETEYE[E^EdEeEfElEpErEyE{E~FJFLFMFQFRFZFdFeFf"},
  {0,NULL,"FkFlFoFsFzGCGOGPGRGVG[G`GbGhGmGoGpGuG~H@HEHGHHHIHRHSHWH[H]HgHjHmH"},
  {0,NULL,"nHoHvHwIAIBICIIIQIVIYIgImIwJ@JAJLJOJPJRJVJWJ\\JeJfJgJjJlJnJxJzKEKF"},
  {0,NULL,"KJKLKWK\\K_KfKgKhKpKsK}K~L?LALGLHLZL\\L]L^LbLdLfLrLuLvLxL{M@MAMBMCM"},
  {0,NULL,"DMQMZM^MaMyM{M}NBNCNDNFNLNVN_NbNhNrNtNxO?OCODOJOKOLONOWO^OaOfOgOj"},
  {0,NULL,"OoOvO|O}P@PEPJPKPRPZP_PaPcPfPhPpPrPvPyP~QBQIQLQNQRQUQXQYQZQcQhQnQ"},
  {0,NULL,"qQwQyQ~R@RERIRQRRRTRXR[R`RdRfRjRqRvRwS@SASCSDSMSO_K?M?O?Q?R?S?Z?b"},
  {0,NULL,"?d?i?k?l?s?w?x?}@@@A@N@Q@U@Y@]@a@h@l@m@p@x@yA?AAAEARASATAVAaAbAdA"},
  {0,NULL,"kAmAqAsAtAyB@BABTBWB]BaBbBeBhBiBlBnBsBtCGCICKCMCPCRCVCWCcCdCgClCn"},
  {0,NULL,"CvCyC~D?DCDHDJDODPDSDTD^DnDsD|EDEEEKENEUEWEYE]EcEdEgEiEkEnEwEzE|F"},
  {0,NULL,"LFNFRFWFXF\\F_FgFjFmFoFpF{G?GAGKGQGRGUG\\G^GbGcGgGiGjGlH@HAHBHDHLHO"},
  {0,NULL,"HRHSHaHbHfHhHkHlHpHqHvH}ICIKINIRISIWIZI[I^I~J?JBJDJGJMJRJXJZJ[J^J"},
  {0,NULL,"_JgJhJkJoJqK@KJKOKQKSKYKZK_KeKlKnKoKtKyK|K}LCLDLELMLOLVLXL^LdLeLf"},
  {0,NULL,"LjLwLyL|L~MCMMMPMSMTMUMVM\\MuM|M~NDNGNJNMNPNQNYN`NaNpNvO@OAOBOFOMO"},
  {0,NULL,"POQOSOVO]OeOlOqOsOtOuP@PCPGPIPJPMPRPVPWPYP_PePhPpPsPxP|P}QBQIQJQM"},
  {0,NULL,"QOQVQYQdQeQhQiQmQpQqQzQ}RCRERHRPRRRSRZR]R_R`ReRhRiRtRxRyRzR|S?S@S"},
  {0,NULL,"OSP_L?M?N?Q?R?S?]?^?_?j?k?m?p?s?w?|?~@B@O@P@X@\\@^@c@j@k@l@o@q@s@{"},
  {0,NULL,"@~ACANAPAWA[A`AaAeAjAoArAsAtA{BEBFBRBUBWBZB\\BdBjBnBqByBzB|C@CFCPC"},
  {0,NULL,"QCRCTCXCYC]C`CgCmCnCpCvCzC|D@DIDODUDYDZD[DbDiDtD}EDEGEOEREWEXEZE\\"},
  {0,NULL,"EcEeEhEmEsEtExF?F@FMFTFUFWFYF]F`FeFfFkFoFpFtFuF}GIGLGMGTGYG^GaGcG"},
  {0,NULL,"fGkGnGoHAHCHFHGHLHMHQHSHWHYH\\H^HkHlHmHtHuHzIBIDIGIHIMIWIfIlIoIxJ?"},
  {0,NULL,"JAJCJFJHJVJWJXJ^J_JaJgJkJlJpK?KBKFKHKIKKKNKVK]K`KaKjKlKsKzL?LALCL"},
  {0,NULL,"FLILMLNLQLWL`LdLgLiLmLuL{L|L}M@MGMOMRMSMWM_MlMzM|M}NANCNENINPNQNe"},
  {0,NULL,"NjNnNoNsNuNzN|OEOKOLONOOOWO^O_OeOlOqOsOtOxOzO~PDPFPLPPP\\P]P^P`PbP"},
  {0,NULL,"gPoPqPtPuP{QAQKQMQNQQQSQXQ[QbQcQeQgQpQzQ|Q~RBRFRRRSRTRVRYR^RaReRg"},
  {0,NULL,"RhRjRqRzR|SASBSCSK_N?O?P?Q?R?S?\\?a?c?l?m?n?p?w?x@?@C@E@M@R@S@T@W@"},
  {0,NULL,"b@i@k@m@o@q@t@zABADAQASAXA]A_AcAeAgAjAqAsAuA{B?BEBPBQBVBYBaBcBgBk"},
  {0,NULL,"BlBpBvB}B~CECGCICNCUCZC_CbCdChCjCnCrCwCzDCDDDLDQDSDWDYDZDdDmDuD~E"},
  {0,NULL,"AEEEJEQEXEYEZE[EdEeEfEjEmEtEyE{E~FHFJFKFRF[F^FdFeFfFlFmFoFqFtF}GO"},
  {0,NULL,"GPGRGVG[G`GbGdGeGhGpGuG}G~H@HHHIHOHRHTHZH[HdHeHkHoHqHsHuHwIBIKIMI"},
  {0,NULL,"PIQIXIaIdInI{I~J@JCJLJMJTJWJYJ[J^JaJhJiJkJrK?KBKEKGKMKUKXK\\K^KbKk"},
  {0,NULL,"KmKoKrK{L@LELJLKLLLOLTLULVL[L_LgLiLkLsLwLzL}MBMDMIMPMRMXMfMgMuMvM"},
  {0,NULL,"wN@NCNGNLNONPNXNeNjNoNqNzN|N}OEOIOJOLONOOOWO`OlOqOsOtOuOyO{PBPDPF"},
  {0,NULL,"PHPOPUPXP]P^PdPkPmPnPoPtPzQ@QFQIQLQRQUQWQZQ\\Q_QiQnQoQqQtQwR@REROR"},
  {0,NULL,"RRURVRZR[RaRcReRsRtRuRxRzR}SASMSN_K?M?O?Q?R?S?Z?b?d?i?k?l?s?w?x?}"},
  {0,NULL,"@@@A@N@Q@U@Y@]@a@h@i@j@q@s@t@|@}A@AMAOARA\\A^AbAgAjAoApAqAtB?BEBFB"},
  {0,NULL,"NBSBXB]B_BeBhBiBsBtBuBxC?CACKCLCMCOCVCWC^CcCfClCnCwC|C~DBDEDODRDT"},
  {0,NULL,"DWDXDZDlDpDqD|E?E@EPETEUEYEZE\\EfEgEhEjEsEtEuEvE}FGFNFOFQFZF\\F`FdF"},
  {0,NULL,"eFmFnFpFqFuF}GJGQGWGZG\\G]GgGiGjGlGsGvGyGzH?HBHDHJHXH`HaHbHfHhHkHn"},
  {0,NULL,"HpHrHwHzIBIDIKIRIUIVI_IcIpIyIzJBJCJKJNJXJYJZJ[J_JaJiJjJlJpJrK?KLK"},
  {0,NULL,"PKRKTKWK[KcKfKgKhKiKpKvKwKxK~LBLGLSLZL\\L]LbLcLgLjLtLuLvLwL}MAMDMJ"},
  {0,NULL,"MSMTMYMhMkMtMxM{N?NCNHNINONVNXNeNnNqNsNuN|N}OEOIOJOKONOOO^O_O`OeO"},
  {0,NULL,"lOtOuOwOzO{PAPHPLPQPUPXP[P\\PbPiPnPuPwPzP{Q?QDQEQGQHQTQ]Q^QaQfQkQl"},
  {0,NULL,"QsQvQxQ{RARDRGRJRKRORVRYRaRcRnRqRrRvRyRzR}SHSKSL_L?M?N?Q?R?S?]?^?"},
  {0,NULL,"_?i?j?n?q?t?y?{@D@F@P@R@Z@[@^@a@j@k@l@o@q@s@{@~ACANAPAWA[A`AaAfAh"},
  {0,NULL,"AiAqAsAtAzBJBLBQBXBZB^BbBdBjBkBpBsBtByC?CPCQCRCTCUCVCXC]C_C`CgCoC"},
  {0,NULL,"pCtC{C|DDDKDLDNDXDZD[D^DnDsD|EDEEELERESETEVEXEcEdEgElEpEqEwEzE|FI"},
  {0,NULL,"FKFSFWFYF\\F`FdFfFlFmFnFsF|GCGKGNGSGUGXG_GdGlGqGrGtGxG{HDHKHNHOHPH"},
  {0,NULL,"UHVHXHZHdHhHmHnHuHyH}H~IDIHIIINIOIQI]I`IbIzI{I|JDJJJLJNJOJYJ\\J`Jf"},
  {0,NULL,"JiJkJlJxJzKAKMKNKSKVKYK[K`KaKiKjKkKlKwKxKzL@LCLELMLNLQLSLTLWLeLgL"},
  {0,NULL,"qLsLvL{L~M@MAMFMKMRM[MdMeMwMxMzNENFNINKNLNMN]N_NbNtNxNyN~O?ODOIOJ"},
  {0,NULL,"OLONOOO^OfOgOiOjOoOrP@PCPGPIPJPMPSPTPVPWPZPcPjPlPrPxP}P~Q?Q@QCQJQ"},
  {0,NULL,"PQVQ\\Q_QaQfQjQmQoQrQsQuR?RCRIRJRMROR[R\\R_RaRbRjRuRvR}R~S?SDSLSMSO"},
  {0,NULL,"SQ_L?M?N?Q?R?S?]?^?_?j?k?m?p?s?w?|?~@B@O@P@X@\\@^@c@i@k@m@p@r@x@zA"},
  {0,NULL,"BADANAOAQAZA]A`AdAlAmApArAtAyBABBBNBPBZB\\B`BcBqBxByBzB{B|C@CACBCL"},
  {0,NULL,"CSCTCYC\\C]C^C`CmCsCuCvC|C}C~DFDIDJDSDZD\\D`DgDjE?ECEGEHEJEUEWEXE_E"},
  {0,NULL,"dEeEfEkEnEoEyE{E~FIFKFMFTFZF[F_FaFjFkFnFpG?GAGHGIGSGVGYG]G`GaGkGn"},
  {0,NULL,"GoGqGsGyHEHFHGHJHKHQHUHWHXHYH\\HjHlHpHxHzH~IAIMIOIPIRIWI\\IhIiIxIyI"},
  {0,NULL,"}JCJFJGJJJMJPJ[J^JaJhJiJjJoK@KCKEKGKMKUKXK\\K^KkKmKpKqKrK{L@LGLHLK"},
  {0,NULL,"LLLRLSLTLULYL\\LiLjLkLqLrL|L}MKMMMOMPMQM]McMjMsMtMvNBNGNHNJNKNON^N"},
  {0,NULL,"`NaNpNvNwN{OAOFOPOQOROSOVOXO_O`OeOlOsOuO|O}P@PEPJPKPSPTPYPaPePfPj"},
  {0,NULL,"PlPsPvPyP|Q@QCQDQFQRQUQWQ\\Q_Q`QkQnQrQtQvQwQ{R?RHRKRNRORWRZRbRcRdR"},
  {0,NULL,"iRrRtRwRyR|R~SISKSOSPSU_K?M?O?Q?R?S?Z?b?d?j?k?m?o?r?u?|?~@B@N@S@]"},
  {0,NULL,"@^@_@c@j@k@l@n@u@w@{@~ACAMATAXA\\A`AaAeAjAoArAsAuAwA~BDBRBUBWBZB\\B"},
  {0,NULL,"dBgBjBnBoBqBzB~C@CFCHCPCQC[CdCgChCiCmCrCxC|D?D@DEDGDPDRDUDVDZD_Dk"},
  {0,NULL,"DrD}D~EFEIEKEOEQEXE^EfEgEhEjEsEtEuEvE}FGFNFOFQFZF\\FcFhFiFlFmFnFyG"},
  {0,NULL,"BGEGMGQGTGVG]G_GeGgGpGqGrGsGyGzG{H?HDHIHXH[H]H`HbHhHjHkHrHtI?I@IA"},
  {0,NULL,"IFIKITIUIXI]I`IbIzI{I|JHJKJPJSJTJXJbJcJdJhJiJjJsJvJ~KHKIKLKSKXK[K"},
  {0,NULL,"dKfKiKkKmKnKvKxK{LBLDLGLSLVLXLZL\\LcLeLmLoLtLuLzL~MDMEMHMIMJM]McMj"},
  {0,NULL,"MsMtMvN?NANCNMNSNTNWN[NiNoNqNuNzN}OEOGOUOYOZO[O\\ObOcOkOmOnOpO|O}P"},
  {0,NULL,"?PCPGPNPSPTPVPWPZPcPjPlPsPvPyP|QAQJQLQOQQQUQXQ\\QcQeQgQmQpQrQwQzQ|"},
  {0,NULL,"Q~RGRLRORPRQRURdReRgRkRlRsS?SASBSESGSNSPSQSUSV_L?M?N?Q?R?S?]?^?_?"},
  {0,NULL,"i?j?n?q?t?y?{@D@F@P@R@Z@[@^@a@h@i@j@n@u@v@|@}A@AOAWAYA[A]AbAkAlAm"},
  {0,NULL,"AqAsAuAxBCBGBOBXBYB[B_BdBjBkBoBpBrBsC?CECJCKCNCQCVCXC_CaCbCgCpCsC"},
  {0,NULL,"uCyC{DEDFDGDJDKDRD[DdDmDuD~EAEEENEPEREVE]E^EdEeEfEkEnEoEyE{E~FIFK"},
  {0,NULL,"FMFTFZF[FbFhFiFmFnFpFwGDGFGJGPGSGUGYG[GaGdGjGlGqGtGyG}HFHJHKHOHQH"},
  {0,NULL,"UHXH\\HdHhHiHlHsHyH~I?ICIEIIIOIWIXI_IcIpIyIzJBJFJJJOJRJSJTJ\\JeJfJg"},
  {0,NULL,"JhJjJyJ{KDKEKFKJKLKWK\\K_KfKpKrKsKtK{K}LALGLHLKLRLULYL\\L`LdLeLkLmL"},
  {0,NULL,"pLrLvL~MAMGMNMPMQM`MbMiMsMyM~NANBNGNNNRNVNZNgNlNvNwO@OAOBOFOGOHOU"},
  {0,NULL,"OYOZO[OaOfOgOiOrOvOyO{PBPDPFPHPQPUPXP[P\\PbPgPiPkPmPqPwQBQIQKQLQNQ"},
  {0,NULL,"TQXQZQ]QcQhQlQxQyQ|Q}R@RBRGRHRQRTRWR]R`RfRhRlRpRsRxS?SBSFSJSLSRSS"},
  {0,NULL,"ST_L?M?N?Q?R?S?]?^?_?i?k?l?o?r?v?}@@@A@Q@X@Z@\\@a@b@i@k@m@p@r@x@zA"},
  {0,NULL,"BADANAOAQAZA]A`AfAhAnApArAuBHBIBMBNBTBVB\\B_BaBfBrBuBvBxBzB~C@CBCL"},
  {0,NULL,"CNCSCYC\\C^CaCbCmCtCvC}D?DDDEDIDLDNDRD\\D]DaDeDhEBECEFEHEKEMEPEWE[E"},
  {0,NULL,"cEdEgElEpEqEwEzE|FIFKFSFWFYF\\F_FgFjFlFmFoF~G@GGGKGQGRGUG\\G^GbGcGg"},
  {0,NULL,"GlGuGxG{H@HDHLHNHOHSHVHZH^HdHhHjHpHtHyH|H}IAIGIIILINIRIaIdInI{I~J"},
  {0,NULL,"@JDJHJOJQJUJZJ]JcJdJiJjJlJwJ|J}KMKOKPKQKVK\\K^KgKjKkKpKqKuKwKxKzL@"},
  {0,NULL,"LHLNLSLTLWLYL\\LhLkLlLoLqL{M?M@MCMHMKMPMYMhMkMtMxM{NDNENGNKNSNTNfN"},
  {0,NULL,"kNmNrNtNxNyO?OCOMOPOQOROXO]ObOcOdOmOnOpOwOxOyO~PAPBPOPUPXP]P^PdPi"},
  {0,NULL,"PnPuPwPzP{QBQEQIQMQOQSQZQbQdQgQiQlQpQqQxQzQ}RDRGRPRSRXR[R\\RdRfRgR"},
  {0,NULL,"mRoRrRxR{S@SCSESGSRSSSTSX_K?L?P?Q?R?S?[?`?e?i?j?n?p?s?x?{@D@F@V@Z"},
  {0,NULL,"@[@_@`@d@h@l@m@o@s@tA?AAAEALATAUAVAYAZAeAgAoApArAuA{B?BFBOBTB[B^B"},
  {0,NULL,"`BbBfBmBoBrBwB{CBCCCDCHCJCSC[C\\CaCeCiCkCoCqCuCwCzC|DJDMDODVDWDYDa"},
  {0,NULL,"DeDhEBECEFEIENESEXEYE\\EcEdEgEjEmEsEwEzE|FIFLFPFSFVFXF`FdFfFkFlFnF"},
  {0,NULL,"qFtFuGKGNGSGUGXG_GmGqGrGtGwGxG{G|HEHKHNHPHUHVH]H_HcHgHuHwHxHyHzI@"},
  {0,NULL,"IDIFIIIKIMISIeIjIkIwI|I}JGJIJOJWJXJYJ[J^J_JgJhJjJpJrKBKJKOKQKSKYK"},
  {0,NULL,"ZK_KdKeKnKqKtKuKyK|K}LDLHLPLRLXLYL^LaLiLlLuLwLxLyMDMFMHMMMRMSM`Mb"},
  {0,NULL,"MiMsMyM~NFNINJNONPNSNXNjNnNoNqNsNuNzN}OIOJOKOLOWO^O_O`OeOqOsOuOwO"},
  {0,NULL,"xOyO~PAPBPOPPPQP[P`PdPgPiPkPmPqPwQBQCQJQOQPQVQYQ`QdQhQjQmQrQuQyQ}"},
  {0,NULL,"R?RCRHRIRLRORRRYRcReRfRiRkRqR}SASDSESISKSXSY_K?L?P?Q?R?S?[?`?e?l?"},
  {0,NULL,"m?n?o?u?v@?@C@E@M@O@U@V@W@[@h@i@j@r@x@y@|@}A@ALAWAYA\\A^A_AfAiAnAr"},
  {0,NULL,"AsAtAvBIBMBSBUBYB[B]BcBiBkBlBmBqB|CACDCECFCMCQCXCZC]CcCiCkCrCtCuD"},
  {0,NULL,"?DADBDJDPDQDXD\\D]DbDiDtD}EDEGEHELEMENEQETEcEeEhElEqErExF?F@FGFTFU"},
  {0,NULL,"FVFXF^FaFgFjFmFnFpFrG@GGGLGNGOGPGTGWGdGeGiGnGtGvGzG}H?HAHFHPHQHTH"},
  {0,NULL,"UH_HbHfHjHmHqH{H|I@IFIHIJILINIPI_IcIpIyIzJBJDJIJMJPJUJVJ]JbJdJhJi"},
  {0,NULL,"JkJmJ|J}KEKFKNKRKTKZKaKbKcKiKrKtKyLBLCLFLKLLLQLRLXL[L_LcLfLhLjLmL"},
  {0,NULL,"qLxM?MEMFMGMKMTMXMfMgMuMvMwNANDNFNHNTNUNdNkNmNrNtNxNyN~ODOPOQOSOV"},
  {0,NULL,"OXO]ObOhOkOmOnOpOxOzO~PDPFPLPQPUPXP[P\\PbPkPmPnPoPtPzQAQGQNQPQRQVQ"},
  {0,NULL,"YQcQfQhQkQnQuQwQyQ~RARERHRJRNRPRUR\\R_RdRjRkRoRtRyR~S@SBSDSGSRSSST"},
  {0,NULL,"SXSZ_K?L?P?Q?R?S?[?`?e?j?k?m?t?y?z?|?~@B@M@O@X@]@_@`@i@k@m@n@v@w@"},
  {0,NULL,"zABADANAVAZA^A_AcAdAlAmApAqAtAxA|BGBNBPBZB\\B`BcBhBxByB{B|B}CACBCI"},
  {0,NULL,"CLCTCUC\\C]CcCeCjClCoCrCsCvCxC{DFDHDIDKDMDQDlDpDqD|E?E@EQESEWE]E^E"},
  {0,NULL,"_EfEgEhEiEnEoEuEvE}FGFHFPFQFSFUFcFhFiFlFmFoFwFxGFGMGQGTGVG]G_GcGe"},
  {0,NULL,"GfGgGpGrG{G~H?HDHIHMHTHVH]H^HbHeHmHrHvHxH~I?ICIEIHISITIUIaIdInI{I"},
  {0,NULL,"~J@JEJGJJJKJSJVJ`JeJfJgJkJlJtJ{KDKGKIKPKQKTKXK]KbKeKgKjKoKwK|K~LF"},
  {0,NULL,"LILJLNLPLQL[L^LbLjLlLnLpLrLsL~MBMHMLMNMTMWM_MlMzM|M}NBNHNLNMNRNSN"},
  {0,NULL,"ZNcNlNpN{O@OAOBOFOGOHOTOYOZO\\OfOgOjOoOrOvOwOzO{PAPHPLPOPUPXP]P^Pd"},
  {0,NULL,"PgPoPqPtPuP{QAQDQGQJQOQUQ\\Q`QdQgQkQnQrQwQzQ{Q~R?RIRMRQRSRUR]R`RbR"},
  {0,NULL,"iRjRnRpRwRyS?SESJSMSRSSSTSYSZS[_N?O?P?Q?R?S?\\?a?c?i?j?n?r?u?v?{@D"},
  {0,NULL,"@F@P@R@T@Y@`@d@h@l@m@u@v@wA?AAAEALAPAQARASAUAeAgAoApArAtA~BDBKBOB"},
  {0,NULL,"TB[B^B`BbBfBmBtBwByB{CBCCCDCMCRCSCWCYC`CeCfCkCqCrCtCyCzDEDHDNDQDU"},
  {0,NULL,"DVDWD`DgDjE?ECEGEIELEOEPE\\E]EdEeEfEjEmEtEyE{E~FHFJFKFRF[F^FbFhFiF"},
  {0,NULL,"mFoFpFvFyGBGJGPGSGUGYG[GaGdGfGhGjGlG}G~H@HFHJHOHRHTH\\HaHdHeHsHtHw"},
  {0,NULL,"H|H~I@IBIGIJIOIUIXIZI[I^I~J?JBJIJJJKJQJTJWJ]JbJcJiJkJlJsJuJ~KGKJK"},
  {0,NULL,"KKUKWKYK^K`KcKhKlKoK~L?L@LELJLLLOLTLWL[L]L_LfLiLlLnLtLzL}MCMGMIMJ"},
  {0,NULL,"MNM[MdMeMwMxMzN@NANDNNNONSNWN\\NiNqNsNuNzN|OEOGOHOTOYO[O\\ObOdOhOmO"},
  {0,NULL,"nOpO|O}P@PEPJPKPRPVPWPYP_PePjPlPrPxP}P~QBQCQDQKQNQTQ[Q]Q`QdQhQjQu"},
  {0,NULL,"QxQyQ}R?RBRGRURVR\\R]R^RbRgRkRnRoRqS@SBSESHSJSKSPSQSUSV_N?O?P?Q?R?"},
  {0,NULL,"S?\\?a?c?i?k?l?q?t?z?}@@@A@N@W@Y@\\@b@d@i@k@m@o@q@t@zABADAQASAXA]A_"},
  {0,NULL,"AcAfAhAnArAsAuAzA}BLBNBTBVB\\B_BaBfBlBnBrBvBzB~C@CECGCNCSCYCZCbCdC"},
  {0,NULL,"hCkCpCwCyC}DBDDDHDLDMDYD[D\\D_DkDrD}D~EFEHESETEZE[E]EfEgEhEpEqErEu"},
  {0,NULL,"EvE}FHFNFOFPF[F]F`FdFeFkFnFpFzF|GCGJGQGWGZG\\G]GiGjGkGsGvGwGyGzG|H"},
  {0,NULL,"BHCHJHYH\\H_H`HaHcHiHkHnHoHyH|IEIHIJIKIQIVI\\IhIiIxIyI}JEJNJOJQJVJX"},
  {0,NULL,"J`JeJfJgJhJkJnJxKAKGKIKPKQKTKXK]KbKeKmKoKrK{K|LDLFLILJLOLPLULVL[L"},
  {0,NULL,"`LiLoLpLsLxL{L}MAMBMEMFMLMUMVM\\MuM|M~NENLNONRNTNVN]NbNhNrNxNyN~OC"},
  {0,NULL,"ODOIOKOLOOOWO^OaOfOiOoOrOvO|O}P?PCPGPNPSPTPYPaPePfPhPpPsPxP|P}QAQ"},
  {0,NULL,"DQEQGQOQTQ`QbQdQgQkQlQxQzQ{Q}RARDRIRJRNRTRYR]ReRfRjRoRpRuSCSDSFSG"},
  {0,NULL,"SKSLSOSQSVSWS]_N?O?P?Q?R?S?\\?a?c?l?m?n?p?w?x@?@C@E@M@R@S@T@W@b@j@"},
  {0,NULL,"k@l@p@r@y@{@~ACAMAPAUAXA[AcAdAkAlApAqAuAyB@BBBQBRBSBUBVB^BgBpBuBv"},
  {0,NULL,"BwB}B~C?CCCHCOCUC_CbCeCfChCjCtCuCwCxC~DCDGDIDNDSDTDYDcDfDoE@EAEBE"},
  {0,NULL,"JELENEWEZE^EcEeEhEiEkEoExF?F@FJFOFVFYF]F^FaFgFjFlFmFnF{G?GHGLGNGO"},
  {0,NULL,"GPGTGWGdGeGpGtGuGvGzG}H?HHHNHPHTHZH[H_H`HdHiHpHqHwHxH{IBIEILIPISI"},
  {0,NULL,"WI]I`IbIzI{I|JEJFJMJUJWJZJ^J_JaJgJjJlJqK@KCKFKHKIKKKNKVK]K`KdKfKj"},
  {0,NULL,"KsKuKvKzL?LALILPLWLZL]L`LaLgLkLnLoLyL|MEMNMOMPMRMTMZM^MaMyM{M}NHN"},
  {0,NULL,"INJNNNQNTNYN^NaNwN{O@OAOBOFOMOPOROVOXO]O_O`OeOqOtOuP?PEPIPKPMPNPS"},
  {0,NULL,"PTPVPWPZPcPhPpPrPvPyP~QAQGQKQNQPQSQ[QbQcQfQgQjQuQyQ~RARDRFRHRKRQR"},
  {0,NULL,"SRYR\\RhRiRmRpRqRrRxRyR}SGSISJSOSPSUSWS]S^_K?L?P?Q?R?S?[?`?e?i?j?n"},
  {0,NULL,"?p?s?x?{@D@F@V@Z@[@_@`@d@h@i@j@r@x@y@|@}A@ALAWAYA\\A^A_AkAlAmArAsA"},
  {0,NULL,"uB@BABBBOBXBYB[B_BdBfBjBkBmBoBrCDCECFCJCNCQCXCZC[CaCiCkCuCvCzC{DA"},
  {0,NULL,"DCDIDJDKDTDWD]D_DkDrD}D~EFEJEMENEUEVE\\EfEgEhEiEnEoEuEvE}FGFHFPFQF"},
  {0,NULL,"SFUF_FaFgFkFlFoF{GAGHGJGMGXGZG[G_GfGhGmGrGwGxG{G|G~HCHIHMHVH]H^Hc"},
  {0,NULL,"HeHgHlHqHuHxH|I?IDIJIPIRISITIYIgImIwJ@JAJFJGJQJSJYJZJ[J_JaJiJkJlJ"},
  {0,NULL,"oJqKCKLKPKRKTKWK[KaKbKcKgKhKiKwKxK~LBLFLJLNLQL[L_LbLcLhLjLkLpLuLy"},
  {0,NULL,"M?MDMLMMMOMTM[MdMeMwMxMzNCNGNHNQNRNUNYN^N`NpNvNwN{O@OBOMOQOROSOXO"},
  {0,NULL,"]O_O`OlOqOsOtO|O}P?PCPGPNPRPZP_PaPcPfPjPlPrPxP}P~Q?QEQHQLQQQTQXQZ"},
  {0,NULL,"Q]Q^QaQlQoQsQxQ|R@RBRKRMRSRVRXRZRaRhRlRoRrRtRxR{R|SASFSISOSPSUSWS"},
  {0,NULL,"]S^_K?L?P?Q?R?S?[?`?e?l?m?n?o?u?v@?@C@E@M@O@U@V@W@[@i@k@m@n@v@w@z"},
  {0,NULL,"ABADANAVAZA^A_AcAeAgAjAqAsAtAwA~BKBPBQBVBYBaBcBiBkBlBpB|B}CACECGC"},
  {0,NULL,"ICTCUCXCZC]CcCjClCqCrCsCwD@DADFDQDRDVDYD]D^DnDsD|EDEEEMEOEPEQEZE_"},
  {0,NULL,"EcEdEgEjEmEsEwEzE|FIFLFPFSFVFXFbFcFiFkFnFpFvFyGEGLGNGRGXG\\G`GiGmG"},
  {0,NULL,"nGoGtGvG|HAHBHEHKHPHQHUH_HcHfHgHrHsHuHvH{I@ICIDIFIGILIUI\\IhIiIxIy"},
  {0,NULL,"I}JHJIJRJTJUJYJ]JcJdJgJjJlJsJuJvKMKOKPKQKVK\\K]KeKgKjKpKqKuKwKzK|K"},
  {0,NULL,"}LHLNLPLYL^LaLbLlLmLpLqLwLzMGMHMJMKMLMSMZM^MaMyM{M}N?N@NKNPNRNSN["},
  {0,NULL,"N\\NiNoNsNuN|N}OEOHOTOUOYOZO[OcOdOhOkOmOpP@PCPGPIPJPMPSPTPYPaPePfP"},
  {0,NULL,"hPpPrPvPyP~Q?Q@QEQIQMQSQWQZQ_QbQiQlQoQqQtR@RDRFRGRLRWRXRYR^R`RaRg"},
  {0,NULL,"RmRnRsRzR~SBSFSHSNSPSQSUSVS^S_S`_K?L?P?Q?R?S?[?`?e?j?k?m?t?y?z?|?"},
  {0,NULL,"~@B@M@O@X@]@_@`@h@l@m@o@s@tA?AAAEALATAUAVAYAZAhAiAnApAqAuA}BJBLBO"},
  {0,NULL,"BPBRBWB`BeBgBhBoBxB{B}CBCCCHCICJCKC[C\\CaCeCjClCoCpCsCzD?DBDFDLDMD"},
  {0,NULL,"PDWDXDcDfDoE@EAEBEKERESE[E\\E_EcEeEhElEqErExF?F@FGFTFUFVFXF^F`FeFf"},
  {0,NULL,"FmFoFpFsFzF|GIGLGMGTGYG^GaGcGeGfGgGnG}H?HAHFHLHMHQHTH^HbHeHfHmHoH"},
  {0,NULL,"yHzH{I?IHIIILIMITIVIZI[I^I~J?JBJCJLJNJSJUJVJ\\J`JeJhJiJjJnJzKAKHKK"},
  {0,NULL,"KOKRKUKZK^KcKdKnKqKtKuKvKyLBLKLLLRLXLYL_LaLcLhLnLsLvLwLxM?M@MBMFM"},
  {0,NULL,"NMSM]McMjMsMtMvNENFNNNPNUNVN]N_NhNrNtNyN~O?OCOIOJOKONOOOWOaOgOiOj"},
  {0,NULL,"OrOvP?PEPIPKPMPNPRPVPWPYP_PePjPlPsPvPyP|QFQHQKQMQQQSQWQ[Q]Q^QeQiQ"},
  {0,NULL,"pQtQvQ|RBRFRJRPRTRVRWR[RcRfRlRmRuRvRzR{SCSJSLSMSOSQSVSWS]S_S`Sa_K"},
  {0,NULL,"?M?O?Q?R?S?Z?b?d?l?m?n?q?y?z@?@C@E@Q@S@T@U@V@c@j@k@l@n@u@w@{@~ACA"},
  {0,NULL,"MATAXA\\A`AaAdAkAlApArAuA|BCBGBQBRBSBUBVB^BgBmBqBuBvBwB~C@CCCFCHCO"},
  {0,NULL,"C[C^CfChCiCmCsCxCyD@DBDCDGDHDKDSDUDXDaDeDhEBECEFEJEOETEVE^E_EcEdE"},
  {0,NULL,"gEiEkEnEwEzE|FLFNFRFWFXF\\FbFcFiFkFoFpFxGDGFGLGNGRGXG\\G`GbGhGiGmGn"},
  {0,NULL,"GoG|H@HAHBHEHLHRHSHWHaHfHgHiHoHpHvI?I@ICIFIOIQIRITIfIlIoIxJ?JAJEJ"},
  {0,NULL,"IJJJLJRJZJ\\J`JfJhJiJkJtJyJ{KMKNKSKVKYK[KaKiKkKlKmKnKxKyL@LCLDLELM"},
  {0,NULL,"LOLSLVLXLcLeLnLrLtLyL{L~M@MJMLMMMQMXMfMgMuMvMwN?NENJNMNNNRNcNgNlN"},
  {0,NULL,"pNvNwN{O@OFOGOHOTOUO[O\\OaOiOjOoOrOvOwOxOyO~PAPBPPP\\P]P^P`PbPkPmPn"},
  {0,NULL,"PoPtPzQ?Q@QCQEQPQSQ[Q_QaQbQfQjQoQtQuRARDRFRJRMRWRZR]R^RbRkRlRpRrR"},
  {0,NULL,"uRwSCSFSHSISJSRSSSTSYSZS[_K?M?O?Q?R?S?Z?b?d?j?k?m?o?r?u?|?~@B@N@S"},
  {0,NULL,"@]@^@_@c@h@l@m@p@x@yA?AAAEARASATAVAaAbAhAiAnAqAsAuAvBHBIBOBPBRBWB"},
  {0,NULL,"`BeBgBhBjBnBoB}CGCHCICJCKCPCVC[CdCgChClCoC}C~D?D@DADMDNDPDTDUD]Dd"},
  {0,NULL,"DmDuD~EAEEEHEKELEOESEUEdEeEfElEpErEyE{E~FJFLFMFQFRFZF_FaFjFkFlFnF"},
  {0,NULL,"rF~G@GIGSGVGYG]G`GkGoGpGqGrGsGyHEHGHHHIHKHWHXH[H]H`HgHjHlHoHrH{H}"},
  {0,NULL,"IAIJINIQIUIWIeIjIkIwI|I}JFJKJLJPJQJUJ]JbJcJgJkJlJmJwJ|KGKJKKKUKWK"},
  {0,NULL,"YK_K`KeKhKlKoK}K~L?LALELJLMLOL]L^LbLdLfLhLoLvLyLzMAMCMEMIMKMMMWM_"},
  {0,NULL,"MlMzM|M}N@NDNJNKNUNVNdNfNmNxNyN~O?OCODOMOROSOVOXO]ObOcOdOhOkOmOyO"},
  {0,NULL,"{PBPDPFPHPOPPPQP[P`PdPgPoPqPtPuP{Q@QCQDQFQKQTQWQ[Q]Q^Q`QjQtQvQ{R?"},
  {0,NULL,"RBRFRIRKRNRXR\\R^R_RhRmRnRoRuR{R~SGSISLSNSRSSSTSXSZS\\Sc_N?O?P?Q?R?"},
  {0,NULL,"S?\\?a?c?i?k?l?q?t?z?}@@@A@N@W@Y@\\@b@d@h@l@m@u@v@wA?AAAEALAPAQARAS"},
  {0,NULL,"AUAdAkAmArAsAtAxA|BCBTBWB]BaBbBeBfBiBlBnBtBzCDCGCMCPCRCSCWCYCZC`C"},
  {0,NULL,"dCkCqCxCyC{C~DDDFDGDHDLDTDVDbDiDtD}EDEGEIEUEVE[E]E_EcEeEhEiEkEoEx"},
  {0,NULL,"F?F@FJFOFVFYF]F^FbFcFhFkFlFnFwFxGDGIGKGOGWGZG^GkGsGuGvGwGxGzHCHGH"},
  {0,NULL,"HHNHPHYHZH[H_H`HcHiHnHqHtHvH~IEIGIOIPITIVIeIjIkIwI|I}JEJHJMJNJRJS"},
  {0,NULL,"J\\J`JeJiJjJlJtJyKDKHKKKOKRKUKZK^K`KcKdKhKqKuKvKzL?LBLLLTLWLZL]L_L"},
  {0,NULL,"aLeLnLpLxLzL|MFMIMLMNMOMQMYMhMkMtMxM{N@NBNFNMNNNQNZNcNgNpNvNwN{OA"},
  {0,NULL,"OBOTOUOYOZO[O\\OaOfOgOiOjOoOxOzO~PDPFPLPOPPPQP[P`PdPiPnPuPwPzP{QFQ"},
  {0,NULL,"HQMQQQRQVQWQYQ^QeQiQmQpQqQsQvRCRERKRLRMRQRWR[R`RbRgRlRtRvRwR|S?SD"},
  {0,NULL,"SFSNSRSSSTSYSZS[Sd_N?O?P?Q?R?S?\\?a?c?i?j?n?r?u?v?{@D@F@P@R@T@Y@`@"},
  {0,NULL,"d@j@k@l@p@r@y@{@~ACAMAPAUAXA[AcAfAhAiApAqAtAvBHBMBQBXBZB^BbBdBpBs"},
  {0,NULL,"BtBwByB{C?CCCOCRCTCUCWC_C`CeCfCjCpCqCtC}DADCDNDPDSDVD[D\\DlDpDqD|E"},
  {0,NULL,"?E@EIEJEKELEMEREfEgEhEpEqErEuEvE}FHFNFOFPF[F]F_FaFgFkFoFpFrF~GGGJ"},
  {0,NULL,"GMGXGZG[G_GaGfGhGjGmGwG|G~HBHCHJHMHRHYH\\HaHcHeHnHsHxH{H|H}IAIJILI"},
  {0,NULL,"SIVIXIfIlIoIxJ?JAJDJGJNJPJQJTJbJcJdJgJhJjJmJwJ}KHKIKLKSKXK[K]KdKf"},
  {0,NULL,"KmKnKsKvK{K|LDLGLILPLULVLZL`LaLfLoLqLsLtL|M?MBMCMEMJMOM`MbMiMsMyM"},
  {0,NULL,"~N?NKNLNQNTNUNdNfNkNrNtN~O?OCODOMOPOQOROSOVOcOdOhOkOnOpOwOzO{PAPH"},
  {0,NULL,"PLPPP\\P]P^P`PbPgPiPkPmPqPwQ?QHQJQLQQQUQXQ\\Q_QaQeQmQoQrQsQ|R@RCRLR"},
  {0,NULL,"NRPRTRXRZR_RdRiRmRsRvR{R|R~S@SHSMSRSSSTSXSZS\\ScSe_H?I?J?T?U?Y?Z?_"},
  {0,NULL,"?c?l?m?n?u?x?z?{?~@?@O@[@]@_@`@d@h@i@j@n@s@xA@ADAEALANATAVAZA_AfA"},
  {0,NULL,"iAnAzBBBCBEBKBMBSBaBdBfBlBnBtByBzC@CPCQCRCSCTCVC^C_CbCfChCnCqC{C}"},
  {0,NULL,"D@DEDGDIDNDSDTDYDcDgDhDjDqDuDvDwD{E@EAEBEKEYE^EcEeEhEmEoEqE|E}F?F"},
  {0,NULL,"GFHFIFPFSFXFaFgFjFsF}G?G@GDGEGOGYG\\GgGiGjGlGqGsGyHDHFHJHKHOHRHSHW"},
  {0,NULL,"HYHZH[HiHrHsHtHzH}IAIBICIIIQIVI]I`IdIeIfIgIqIrIuIwJ@JAJEJQJWJ]JbJ"},
  {0,NULL,"dJmJnJqJyJ~K?KFKUK[KiKkKlKmKnKoK{L@LDLELJLLLWLZL\\L]L`LdLgLkLnLoLy"},
  {0,NULL,"L|M@MAMBMCMDMQMUMVMZMhMiMlMnMqMrMyM{M}NBNINKNdNkNmNoNyNzN~OAOBOGO"},
  {0,NULL,"HOKOQOSO^O`OjOmOoOpOuOxOzPCPDPEPGPQPXPYPbPcPePhPjPkPlPnPtQCQDQGQM"},
  {0,NULL,"QPQQQYQ\\Q]QlQmQnQoQtQyQzQ}Q~RIRMRTRXRYR[R`RcRhRiRmRrR{SASESHSJSNS"},
  {0,NULL,"OSPSYS_SdSf_H?I?J?T?U?Y?Z?_?c?i?j?n?p?t?v@B@C@D@M@O@V@W@X@_@h@l@m"},
  {0,NULL,"@t@w@y@z@}A?AYAZA\\A^A_AcAeAgAoBABCBDBFBHBJBRB_BbBqBrBuBvBxBzB~C@C"},
  {0,NULL,"FCHCLCOCVCWC_C`CdCgCnCvCyC~D?DCDKDLDNDXDZD[D`DbDgDlDmDnDwDxDzD|ED"},
  {0,NULL,"EEELEZE]EcEdEgElEnEsEvEzF@FGFPFQFTFUFVF`FdFfFqFyF{F~GCGDGUGZG`GkG"},
  {0,NULL,"pGsGuGvGwGyGzHEHGHHHIHRHSH\\HaHdHhHkHlHpHqHvH}IBIGIJIOIUIXI[I`IbIl"},
  {0,NULL,"InIpItIuIvI~J?JBJCJDJJJ[J^J_JuJwJyK@KAKBKHKYK\\K]KdKfKmKrKsK{LALGL"},
  {0,NULL,"HLILKLMLOLSLTLWL]LeLgLqLsLvL{L}MCMGMIMJMNMVM\\M_MdMgMkMmMnMoMwMxMz"},
  {0,NULL,"NCNDNMNXNjNnNoNxNyN}O@OFOKOSOTOVOWO\\O_O`OfOgOnOpOwOyO~P?PJPNPPPVP"},
  {0,NULL,"[PaPdPfPgPmPvPwPxPyQEQJQRQSQUQVQWQ^QcQdQgQhQuQ{Q|R?R@RARGRMRPRURV"},
  {0,NULL,"R^R`RaRjRoRuRvRxRyRzR|R~SJSQSRSSSTSUS]Sg_H?I?J?W?X?Y?a?b?e?i?j?n?"},
  {0,NULL,"p?t?v?|@A@F@O@X@\\@^@a@b@h@i@j@n@s@x@|ABACANAZA[A]A`AaAkAlAmAvAzB?"},
  {0,NULL,"B@BCBDBQB[BeBgBlBnBpBvB}B~CGCHCICKCPCWCcCeCfCiCkCnCoCxDADBDDDHDND"},
  {0,NULL,"QDUDVDWD_DeDgDkDpDtDvDxDyE?ECEGEME\\E_EdEeEfEkEpEtEwExEyFIFTFWFYF\\"},
  {0,NULL,"F]FbFhFiFqFrFsFyGAGFGNG[G]GeGgGiGnGtGvGyGzH?HAHBHDHRH[H]HcHeHgHjH"},
  {0,NULL,"mHnHoHvHwIDIJIPIRISITIYIZI[IaIkIoIqIrIuIwJ@JAJEJQJWJ\\JeJfJmJnJrJu"},
  {0,NULL,"KCKDKWKXKZK]KdKeKnKqKtKuKvK{K|LDLILOL[L]L_LbLcLfLiLlLnLtLzM?MDMLM"},
  {0,NULL,"MMOMTMWMXMYMZM[M^MmMnMoMwMxMzNCNDNMNZNgNlN|O?OAOCOEOFOKOUOXOZO]O^"},
  {0,NULL,"OiOnOpOqOrOsOyO}PDPHPIPMPRPSPTPXP[P\\PgPiPkPsP|P~Q@QAQBQFQNQOQXQZQ"},
  {0,NULL,"eQfQiQkQrQxRBRCRDRFRKRMRRRSRZR\\RaRbRdRgRkRnRwR{SCSDSKSMSPS\\S]S`Sc"},
  {0,NULL,"SeSgSh_H?I?J?U?V?W?[?]?d?l?m?n?u?x?z?}@C@D@N@R@Y@`@b@d@j@k@l@p@q@"},
  {0,NULL,"u@{ADAEAQARASAUA]AcAdAkAlAwA{BBBGBJBMBPBUBXBhBoBrBxB{B}C?CBCJCKCL"},
  {0,NULL,"CNCXC]CcCgCiCmCnCpCvCzC|D@DJDPDQDXD\\D]DaDgDhDrDsDtDxDyDzD}EDEGEOE"},
  {0,NULL,"TEUEcEeEhEmEoEqEuExEyFHFJFKFOFPF[FaFgFjFsF}G?G@GDGEGKGLGVGgGlGpGq"},
  {0,NULL,"GrGsGyG{HDHKHNHOHQHSHWH^HfHgHkHlHmHtHuHzICIFIOIQIRITIZI\\I_IfIgIpI"},
  {0,NULL,"qIuIvIxJ?JAJGJIJVJ^J_JaJmJpJqJtJvJzKLKNKOK_KeKfKgKhKpKuKwK|K}K~LH"},
  {0,NULL,"LMLQLRLSLXLcLfLhLjLmLqLxL~M@MJMLMMMQMUMWM]MdMgMlMmMoMpMuMvMwNANEN"},
  {0,NULL,"GNYN^NaNsNyN|N~OAOBOGOLOMORO\\O^O`OaOmOpOuOvOxO{PEPHPMPNPOPTPWPbPc"},
  {0,NULL,"PdPhPiPrPtPvPwQAQBQFQHQNQOQ[Q\\Q]QbQlQmQqQuQ{R?R@RARMRTRURWRZR]R_R"},
  {0,NULL,"dRgRoRtRuRzR|SASDSHSKSQSRSVS[S`Sc_H?I?J?W?X?Y?a?b?e?j?k?m?o?s?y?}"},
  {0,NULL,"@B@D@P@Q@Z@[@\\@a@i@k@m@o@r@v@{A@ADAOAPAWAYA[A`AdAlAmAyA|A}A~BEBHB"},
  {0,NULL,"PBTBUBiBmBqBtBuBwCCCDCMCOCRCSCZC[CdChCjClCnCrCwCzDCDDDMDNDPDTDUD]"},
  {0,NULL,"DdDlDoDqDrDsDwDzD{D~EAEEENEQESEdEeEfEkEpEtEwExEyFIFTFWFYF\\F]F_FaF"},
  {0,NULL,"jFrFtFwFyFzGHGJGLGVGiGmGnGtGvGwGzG|HBHCHJHPHRHTH[H]HbHeHkHoHqHsHu"},
  {0,NULL,"HwICIEIHISITIUIZIbIdIgIjIkIrItIuI{I~J@JKJLJZJ[J^JaJnJoJrJsJ{J|KGK"},
  {0,NULL,"LKOKcKdKiKnKqKtKvKxKyLBLDLGLOLPL[L]L^LbLfLhLoLvLyLzL~MBMHMLMNMTMU"},
  {0,NULL,"MXM^M_MdMfMnMoMqMzM|M}N@NLNQN^N`NaNqNvNwNxNzODOHOIOOOPOQOTO_OcOeO"},
  {0,NULL,"gOjOkOxO{O|O~P@PKPOPSPYP\\PaPbPiPlPoPwPyP|Q?Q@QBQFQHQNQYQ\\QbQlQmQn"},
  {0,NULL,"QpQuQ{Q|R?RARMRQRSR[R]R^R_RhRjRmRoRsRxRzR}SASESLSQSSS\\S_S`Sd_H?I?"},
  {0,NULL,"J?T?U?Y?Z?_?c?i?j?n?p?t?v@B@C@D@M@O@V@W@X@_@h@i@j@n@s@xA@ADAEALAN"},
  {0,NULL,"ATAVAZA_AkAlAmAvAzB?B@BCBDBTBUBXBfBgBlBnBvBzB~C@CFCGCHCPCVCWC^C_C"},
  {0,NULL,"`CfCnCwC|C~DBDEDNDPDSDVD[D\\DgDmDoDpDsDuDvDwDxD|E?E@EPEREWEfEgEhEi"},
  {0,NULL,"EjErEuEwExFLFSFUFVFXF^F_FaFgFuF~GAGBGCGFGJGKGVGbGcGkGoGuGxH@HEHGH"},
  {0,NULL,"HHIHLHXH\\H`HaHdHhHkHnHpHrHwHzICIEIIIOIWIXIZI\\IbIcIlIoIsItIvIyIzJB"},
  {0,NULL,"JMJNJTJ[J_JaJxJ}J~K?KCKDKGKLKNK^K`KaKjKkKlKzL?L@LELJLLLULVLZL\\L`L"},
  {0,NULL,"dLfLoLqLsLtL|L~MAMGMNMPMQMUMYM]M^M`MhMpMqMrMsMyM~N?NJNVNYN^N`NpNr"},
  {0,NULL,"NuN{OCOEOJONOUOXOZO]OdOhOiOqOrOsOxO}O~P?PGPHPOPRPZP\\PdPfPiPjPoPtP"},
  {0,NULL,"}P~Q?Q@QAQFQHQOQYQ[Q]QbQlQnQpQqQuQ|R?R@RHRJRLRQRWR]R_RdRfRiRmRnRy"},
  {0,NULL,"RzR}SBSKSMSQSTSVSXS_Sf_H?I?J?T?U?Y?Z?_?c?j?k?m?o?s?y?|@E@F@M@U@V@"},
  {0,NULL,"Z@[@`@i@k@m@o@r@v@|AAABALAUAVAWAYA^AdAlAmAyA|A}A~BEBHBQB\\BeBhBiBs"},
  {0,NULL,"BtBuBwC?CCCMCOCRCUCYCbCdCgChCmCpCwCyC}DBDDDGDPDRDUDVDZD`DdDeDjDrD"},
  {0,NULL,"tDyDzD{D}D~EFEHEVEXEfEgEhEiEjErEuEwExFLFSFUFVFXF^FcFhFiFwF|F}F~GB"},
  {0,NULL,"GHG[G]G^GbGcGdGlGuGxG}G~H@HHHNHOHWHXHYH\\H`HaHiHkHnHoHyH|IAIMIOIPI"},
  {0,NULL,"RIWI]I_IbIhIkIoIqIsIvIxIyI}JPJRJXJ`JeJfJoJvJwJxJ{K?KVKWKXK_K`KaKj"},
  {0,NULL,"KlKsK}K~L?LALCLELSLTLULVLZL\\LeLmLoLtLuLzL}MKMMMOMPMQMUMXMYM\\MbMcM"},
  {0,NULL,"mMpMrMsMtMvNNNONTNZNcNlNqN}N~O@OBODOHOLOPOQOTOWO_ObOeOgOjOmO{O|PA"},
  {0,NULL,"PIPLPMPOPRPSPUP]P_PoPqPrP{P|P~Q?QAQBQHQNQOQZQ`QfQiQjQkQrQwRBRCRER"},
  {0,NULL,"FRHRKRPRWRYRZRcRgRkRlRoRsR~SASCSDSFSLSVSWSXS^ScSeSgSh_H?I?J?W?X?Y"},
  {0,NULL,"?a?b?e?j?k?m?o?s?y?}@B@D@P@Q@Z@[@\\@a@j@k@l@p@q@u@z@}@~ANAOAQAWA]A"},
  {0,NULL,"bAeAjAoAvA{A|A~BBBLBRBbBcBfBiBkBlBmB|CDCECGCMCRCSC[CeCfChCjClCtCu"},
  {0,NULL,"CwCxC~DCDFDLDMDPDWDXD_DaDfDlDmDrDvDwD{E@EAEBEKEYE^EcEeEhEmEoEqEzE"},
  {0,NULL,"{F@FIFKFMFSFWF[F`FeFfFrFxFzF}G?GBGTGZG`GbGhGiGjGmGoG|G~H@HBHCHJHT"},
  {0,NULL,"H[H]H_H`HbHiHpHqHwHxH{IAIFIKITIUIXIZI]I^IjInIpIrIsItIzI{I|JSJUJYJ"},
  {0,NULL,"^J_JaJmJpJqJtJvJzKHKTKYK_KeKgKhKlKoKwK|K}K~LFLJLVLXLZL_LaLcLhLnLs"},
  {0,NULL,"LvLwLxL~MDMEMHMIMJMZM]M`MaMgMkMmMpMrMsMtMvNNNONTNeNjNnNrNsNtN|OAO"},
  {0,NULL,"BOLOMOROUO[O^ObOlOmOrOsOvOxP@PFPJPLPNPWP]P`PaPbPfPqPtPuPvPxP}QEQK"},
  {0,NULL,"QRQSQTQVQ_QaQcQdQgQhQpQqQ{Q|R?R@RGRLRORURWR\\RcRdRfRpRuRvRxRyR{R}S"},
  {0,NULL,"?SISSSTSWSZS_SbSgSiSm_H?I?J?W?X?Y?a?b?e?i?k?l?q?r?w?{?~@@@P@R@X@Z"},
  {0,NULL,"@^@c@i@k@m@o@r@v@{A@ADAOAPAWAYA[A`AfAhAnAwA|A}B?BABIBSB`BaBgBmBoB"},
  {0,NULL,"qBuBwCBCCCDCFCHCJCWCZCcCdCjClCqCrCsCwD@DADHDJDODPDSDTD^DiDkDqDrDu"},
  {0,NULL,"DwDxDzD|EDEEELEZE]EcEdEgElEnEsE|E~F?FKFMFTFUFYFZF_FgFjFqFvFxF{F|G"},
  {0,NULL,"GGOG\\G_GdGeGfGhGpGuG{G}G~H?HIHMH_H`HaHcHfHgHrHsHuHvH{I@IEIHIJIKIQ"},
  {0,NULL,"IVI[I\\I^IcIeIfIqIsIvIxIyI}JPJRJXJ]JcJdJrJsJtJwJxK@KQKUK[K^K`KcKdK"},
  {0,NULL,"fKhKvKxK~L?LBLGLOLPLVLXL[L^LeLfLjLwLyL|L}MAMBMEMFMLM\\M^MaMfMiMlMo"},
  {0,NULL,"MpMqMuM|M~NPNRNUNfNkNmNsNtNuO?O@OFOLOROWOXOYOZOaObOiOlOnOtO~PAPBP"},
  {0,NULL,"CPEPKPUPZP^PcPdPePjPlPpPwPzP{QCQIQLQMQPQQQ[Q\\Q]QbQlQnQsQvQyQzQ}Q~"},
  {0,NULL,"RIRJRNRRRTRWR_RaRhRiRpRtR~S?SBSHSKSNSQS[S^SaSdSfShSiSmSn_H?I?J?U?"},
  {0,NULL,"V?W?[?]?d?l?m?n?u?x?z?}@C@D@N@R@Y@`@b@d@i@k@m@o@r@v@z@~A?ALAPASAU"},
  {0,NULL,"AXA[AeAgAjAwAyAzBEBGBIBRB_BcBgBhBjBnBoBsC?CJCKCNCPCQC\\C]C^CcCiCmC"},
  {0,NULL,"sCuCvC|C}C~DGDMDODXD[D]D^DaDbDjDlDsDvDxDyE?ECEGEME\\E_EdEeEfEkEpEt"},
  {0,NULL,"EvE{F@FHFNFOFYF]F^FdFeFfFsFtFvG@GFGHGTGUG`GcGeGfGgGrGxG{HDHLHMHNH"},
  {0,NULL,"OHQHUHWHXHfHgHjHlHpHxHzH~ICIDIFIGILIUIYIgIiIjIlIpIqIsIvIxIyI}JPJR"},
  {0,NULL,"JXJ[J^JaJnJoJrJsJ{J|KTKYK\\KaKbKcKiKnKtKxKyLBLCLDLELNLYL\\L^LbLdLfL"},
  {0,NULL,"rLuLvLxL{MGMHMJMKMLMSM^M_M`McMjMkMnMqMrMyM{M}NBNINKNXNeNjNqNvNwNz"},
  {0,NULL,"O?OCOIOOOPOQOYOZOhOjOkOoOqOtO{P?P@PBPDPNPOPVPWPXP^PaPkPoPxPyPzP}Q"},
  {0,NULL,"JQKQRQTQUQVQWQ^Q_QaQdQgQpQqQuQ|R@RARGRLRNRQRYR^RbRfRjRmRqRvRyR|S@"},
  {0,NULL,"SFSISKSPSRSTSVSZSaSgSiSmSo_H?I?J?U?V?W?[?]?d?i?k?l?q?r?w@A@E@F@P@"},
  {0,NULL,"R@S@T@W@d@h@l@m@t@w@yAAABACAMAPAQAXA_AcAdAkAmAxBABFBIBKBLB[B\\BeBj"},
  {0,NULL,"BkBqByBzB|CACDCECFCQCTCVC[C\\C^CaClCoCpCsCzD?DBDKDODQDRDUD\\D^DdDeD"},
  {0,NULL,"nDoDpDvDwD{E@EAEBEKEYE^EcEeEhEmEoEqEuExEyFHFJFKFOFPF[FbFcFhFuFxFz"},
  {0,NULL,"F{G@GEGNG]G^GmGoGpGqGrGsG{G|HEHIHKHPHQHSH^HbHfHhHmHoHyHzH{I?ICIKI"},
  {0,NULL,"NIRISIWI^I_IaIgImIoItIuIvI~J?JBJCJDJJJ\\J`JeJpJyJzJ|J~K@KVKWKZKfKg"},
  {0,NULL,"KhKiKkKpKwKxKzL@LGLHLMLQLRLXL^LdLgLhLlLmLrLtL~MCMMMPMSMTMVMWMXM]M"},
  {0,NULL,"bMjMoMpMqMuM|M~NPNRNUNZNcNgNoNrNtNwNzN{OIOJOSOVOYO[OcOdOfOlOoOtOz"},
  {0,NULL,"O|O}O~PFPIPQPSPTP_P`PdPnPrPsPuPwP~Q?Q@QAQFQHQNQXQZQ`QeQiQjQrQwQxR"},
  {0,NULL,"CRDRERHRNRSRVRZR]ReRkRmRnRpRsR}S@SCSJSLSMSOSQSXS\\SbScSgShSnSoSp_H"},
  {0,NULL,"?I?J?U?V?W?[?]?d?i?j?n?p?t?v?{@?@@@M@T@W@Y@\\@b@j@k@l@p@q@u@{ADAEA"},
  {0,NULL,"QARASAUA]AcAfAhAiAvA~B@BFBGBJBSB`BdBhBiBxB{B|B}CACICKCLCMCOCXC[Ca"},
  {0,NULL,"CgCiCmCrCxC|D?D@DEDIDJDKDTDWD]D_DhDiDnDsDuDyDzD{D}D~EFEHEVEXEfEgE"},
  {0,NULL,"hEiEjErE}E~F?FJFRFVF[F]F^F_FaFgFuF~GAGBGCGFGYG\\G_GaGbGcGkGnGoH@HA"},
  {0,NULL,"HBHEHGHLHUHVHXH]HbHhHjHkHrHtI?I@IDIHIIINIOIQIYIbIcIdIeImIrIsItIzI"},
  {0,NULL,"{I|JSJUJYJbJcJdJpJvJ{J}KAKCKFKQK[K_KpKqKrKsKtKuKyK|K}LHLKLMLNLQLS"},
  {0,NULL,"LbLcLhLjLkLpLuLyL~M@MAMFMKMRM]McMeMfMhMlMmMnMoMwMxMzNCNDNMNdNfNkN"},
  {0,NULL,"pNqNrN{N}OCONOOOPOUOVO[OdOfOgOhOqOsOwPEPGPHPKPLPPPYPZP\\P]PePhPiPj"},
  {0,NULL,"PmPpPqQDQGQIQLQMQQQYQ[Q\\QbQmQnQoQsQtQvQyQ}RIRJRQRVR[R\\RbReRhRoRrR"},
  {0,NULL,"tR}SBSESFSGSNSUSWSYS[S`SdShSiSmSnSpSq_H?I?J?T?V?X?\\?^?`?i?k?l?q?r"},
  {0,NULL,"?w?}@B@C@S@T@U@]@^@c@h@i@j@n@s@x@}@~A?AMARATAVA`AaAgAjAoAxA}B?B@B"},
  {0,NULL,"KBMB_BbBcBpBtBwByB{B}CACBCCCICTCUCXCYCZCaCbCkCuCvCzC{DADCDHDLDMDY"},
  {0,NULL,"D[D\\DaDbDcDkDmDoDyDzD{D}D~EFEHEVEXEfEgEhEiEjErEvEzE{FJFLFRFXFZF\\F"},
  {0,NULL,"`FdFeFuFwF|GAGEGGGTGUGZGaGdGlGnGqGtG}H?HAHFHKHPHVHYHZH^HcHeHlHqHu"},
  {0,NULL,"HxH|I?IEIFIGIMINIXI\\IhIjIlImInIqIrIuIwJ@JAJEJQJWJ[J_JaJxJ}J~K?KCK"},
  {0,NULL,"DKHKTK\\K^K`KjKkKpKqKuKvKzL?L@LLLPLQLRLUL[L`LiLoLpLsLxL{M?MGMHMIMQ"},
  {0,NULL,"MRMUM[M_M`MeMgMoMpMqMuM|M~NPNRNUNXNeNnNpNuN{N~ODOEOGOHOJONOXO]OaO"},
  {0,NULL,"cOdOeOiOuOzP?P@PAPHPJPQPUPVPWP\\PfPiPnPvPyP{P}QEQJQKQSQTQUQWQ^Q_Qa"},
  {0,NULL,"QcQhQpQqQuQ{R?RARLRRRURXR]R^R_ReRfRjRlRuRwRxR|SASGSISOSRSSSZS^S`S"},
  {0,NULL,"gSiSmSoSqSr_H?I?J?T?V?X?\\?^?`?j?k?m?o?s?y?~@?@@@N@Q@S@U@V@a@h@l@m"},
  {0,NULL,"@t@w@y@{A@AEAMAXA\\A^AaAbAhAiAnAxAyA{BDBHBLB`BaBdBjBkBpBrBsBvB~C?C"},
  {0,NULL,"ECGCNCUCYC\\C]C`CeCkCqCrCtCyCzDEDFDIDJDSDZD\\D`DfDhDiDoDqDvDxDyE?EC"},
  {0,NULL,"EGEME\\E_EdEeEfEkEpEtE|E}E~FLFNFOFQFWF\\F_FaFjFrFtFwFyFzGHGOGYG_GmG"},
  {0,NULL,"rGtGvGwGxGzG|HCHHHNHPHQHTH\\H^HdHeHsHtHwH|H~I@IHIIILIMITIVIZIcIdIf"},
  {0,NULL,"IhIiItIuIvI~J?JBJCJDJJJ]JbJcJoJuJzJ|KBKDKFKQKUK]KaKbKeKgKjKwKzLAL"},
  {0,NULL,"CLFLILRLTLULYL_LaLiLjLkLqLrL|M?M@MBMFMNMSM[MdMfMhMiMjMmMpMrMsMtMv"},
  {0,NULL,"NNNONTNdNfNmNvNwNxN|ODOEOIOJOMOTO\\O]O_OcOeOkOrOvOyO{PCPFPGPKPOPYP"},
  {0,NULL,"ZP[P`PcPgPhPlPoPpPuQCQDQGQIQLQPQYQ[Q]QbQlQmQoQsQtQvQzQ~RJRORPRTR["},
  {0,NULL,"R]RdRiRlRqRrRtRwRzS@SBSESHSVSYS[S]SbSfShSiSmSnSpSqSs_H?I?J?T?V?X?"},
  {0,NULL,"\\?^?`?l?m?n?u?x?z?|@A@E@N@Q@Y@]@_@c@j@k@l@p@q@u@|AAACAOARASATA\\Ab"},
  {0,NULL,"AdAkAlAwA{BBBGBJBMBQB[B\\BfBmBoBrBxB{C@CBCJCLCNCSCXCZC]C_C`CjCoCpC"},
  {0,NULL,"tC{C|DDDFDQDRDVDYD]DcDdDfDpDsDtDwDxDzD|EDEEELEZE]EcEdEgElEnEsEuEw"},
  {0,NULL,"EyFGFMFNFQFRFZFbFcFiFtFvG?GCGDGGGNG[G^GaGfGhGjGkGwHCHFHGHJHLHMHTH"},
  {0,NULL,"UHVHZH_HdHmHnHuHyH}H~IBIEILIPISIWI\\I_I`IaIiIkIrIsItIzI{I|JSJUJYJ\\"},
  {0,NULL,"J`JfJqJsJtJ}KAKBKVKXKZK^KbKcKmKoKrKyLBLFLJLKLLLNLPLWLYL`LaLlLmLpL"},
  {0,NULL,"qLwLzMEMNMOMPMRMTMWMYMaMbMdMeMnMqMrMyM{M}NBNINKNcNgNlNpNsNuNvNxNy"},
  {0,NULL,"OGOMONOOORO\\O`OaOhOkOuOvOwOxO|O}PBPMPPPRPTP^P_PbPmPrPsPtPzP|Q?Q@Q"},
  {0,NULL,"BQFQHQOQXQ`QeQfQjQkQwQxRBRDRERFRHRKRORQRSRXR_R`RgRnRqRsRzS?SDSGSL"},
  {0,NULL,"SMSUSXS\\S_SaSeSgShSnSoSpSrSsSt_H?I?J?T?V?X?\\?^?`?l?m?n?u?x?z?|@A@"},
  {0,NULL,"E@N@Q@Y@]@_@c@h@i@j@n@s@x@}@~A?AMARATAVA`AaAfAiAnAzBBBCBEBKBMBNBY"},
  {0,NULL,"B^BfBtBwByBzB{C@CBCLCRCSCTCXCZC_CaCbCjCpCsCuCyC{DEDLDQDSDWDYDZD^D"},
  {0,NULL,"_DbDcDtDuDwDzD{D~EAEEENEQESEdEeEfEkEpEtE|E}E~FLFNFOFQFWF\\FdFeFfFs"},
  {0,NULL,"FtFvG@GFGHGIGPGXGcGfGmGrGwGxG{HCHGHLHMHNHQHTHUH\\H_HdHiHlHsHyH~I?I"},
  {0,NULL,"FIHIJILINIPI[I]IaIdIiIpIsItIvIyIzJBJMJNJTJ\\JeJfJmJnJrJuKCKDKEKKKP"},
  {0,NULL,"K]KdKeKgKjKqKuKvKzK|L?LILQLRLTLUL[L_LgLiLkLsLwLzM?MEMFMGMKMTMVMXM"},
  {0,NULL,"[M`McMiMmMoMpMuMvMwNANENGN_NbNhNqNzO?OAOCOFOKOQOSOUOZO^OjOmOoOpOq"},
  {0,NULL,"OtOwO}P@PAPDPEPPPRPXP`PaPcPhPkPuPyP{P~QCQDQIQLQMQQQ^QaQcQdQgQhQrQ"},
  {0,NULL,"wRCRDRERFRGRJRNRPRZR\\RaRcReRhRkRuRyS?SFSJSLSNSSSUSXS[S^SbSjSkSl_H"},
  {0,NULL,"?I?J?T?V?X?\\?^?`?j?k?m?o?s?y?~@?@@@N@Q@S@U@V@a@j@k@l@p@q@u@|AAACA"},
  {0,NULL,"OARASATA\\AbAeAjAoAvA{A|A~BBBLBOBVBZBfBkBlBmBoBrB~CDCECGCNCSC\\C]C_"},
  {0,NULL,"C`CeCjCpCqCtC}DADCDFDHDIDKDMDQDfDiDjDlDnDtDvDwDxD|E?E@EPEREWEfEgE"},
  {0,NULL,"hEiEjErEvEzE{FJFLFRFXFZF\\FcFhFiFwF|F}F~GBGHGMGSGWGdGlGqGtGuGxGzG}"},
  {0,NULL,"HHHNHOHPHQHYH\\H^HcHeHnHsHxH{H|H}IBIDIGIHIMIWIYI^IdIhInIoIqIuIvIxJ"},
  {0,NULL,"?JAJGJIJVJbJcJdJpJvJ{J}KAKCKIKMKRK^KkKpKqKrKtKuKyLBLHLKLLLNLPLQLW"},
  {0,NULL,"L[L`LjLlLnLpLrLsL}M@MGMOMRMSMZM\\M`MbMeMlMnMoMqMzM|M}N@NLNQNWN[NiN"},
  {0,NULL,"qNrN}O@OBOCOLOPOUOVO[O^ObOgOjOlOmOsOyO|PBPGPLPNPQPSPWPZP[P]PjPnPq"},
  {0,NULL,"PvPzP|QEQJQRQTQUQVQXQZQeQfQiQjQtQvQyQzQ}Q~RIRRRVRYRZR^R`RbRhRnRpR"},
  {0,NULL,"vRyR{R~S@SCSHSOSRS\\S]SaSfSjSkSlSv_H?I?J?U?V?W?[?]?d?i?k?l?q?r?w@A"},
  {0,NULL,"@E@F@P@R@S@T@W@d@i@k@m@o@r@v@z@~A?ALAPASAUAXA[AfAhAnAwA|A}B?BABIB"},
  {0,NULL,"NBWBYBgBjBmBnBoBqCDCECFCHCJCQCVC\\C]C^CcClCoCrCsCvCxC{DODRDTDWDXDZ"},
  {0,NULL,"D^D`DaDcDeDqDvDwDxD|E?E@EPEREWEfEgEhEiEjErE}E~F?FJFRFVF[F]F^F`FdF"},
  {0,NULL,"eFuFwF|GAGEGGGIGQGXGaGkGnGoGqGtG|HAHEHFHKHPHSHVH]H^HbHhHmHrHvHxH~"},
  {0,NULL,"I?IAIGIIILINIRI[I]I_IcImInIrItIuI{I~J@JKJLJZJ`JeJfJoJvJwJxJ{K?KEK"},
  {0,NULL,"PKSK_KaKlKrKsKtKyK}LALCLDLELNLSLYL\\LbLcLgLjLtLuLvLwM?M@MCMHMKMPMY"},
  {0,NULL,"M[M_MaMcMlMmMnMrMtMxM{NFNHNSN]NbNhNuN~O@OBODOEOHOLOROTOWOXOaObOeO"},
  {0,NULL,"iOnOuO|P?PAPCPDPFPPPSPUP`PePfPkPmPpP{P|P}QCQDQGQLQPQQQWQ_QcQdQgQh"},
  {0,NULL,"QxRBRCRDRERFRKRPRURXR[R\\RaRcRgRiRqRvRwRxS?SHSJSMSPSTSUSYS\\SbSjSkS"},
  {0,NULL,"lSw_H?I?J?U?V?W?[?]?d?i?j?n?p?t?v?{@?@@@M@T@W@Y@\\@b@h@l@m@t@w@yAA"},
  {0,NULL,"ABACAMAPAQAXA_AcAeAgAoBABCBDBFBHBJBOBZB]BqBuBxByBzB|C@CACFCLCMCOC"},
  {0,NULL,"VCXC[CaCgClCoC}C~D?D@DADFDGDJDKDRD[DeDfDhDkDmDnDwDzD{D~EAEEENEQES"},
  {0,NULL,"EdEeEfEkEpEtEvE{F@FHFNFOFYF]F^FbFhFiFqFrFsFyGAGFGMGRGSGcGeGfGgGiG"},
  {0,NULL,"nH?H@HAHBHDHLHUHVHWHXH]HgHjHlHoHrH{H}IDIFIIIKIMISIYI`IcIhIkIpIqIr"},
  {0,NULL,"IsIwI|I}JFJHJOJ]JbJcJoJuJzJ|KBKDKJKMKRKaKbKcKgKiKjKwKxKzL@LCLFLRL"},
  {0,NULL,"XLYL\\L^LdLeLkLmLpLrLvMDMFMHMMMRMSMWMZM\\M_MiMjMpMqMrMsMyM~N?NJNVNW"},
  {0,NULL,"N\\NiNxN|OAODOEOFOKOMOTOWO\\O]O_O`OiOnOpOrOyOzO}PJPKPLPRPVPYP[P]P^P"},
  {0,NULL,"gPlPnPxPzP~QEQKQRQSQTQUQ`QeQfQiQjQkQoQsQyQzQ}Q~RKRLRORRRTRYR`RiRl"},
  {0,NULL,"RpRsRuRxR{R~SDSGSNSOSWSXSZSaSdSjSkSlSvSx_H?I?J?T?V?X?\\?^?`?i?k?l?"},
  {0,NULL,"q?r?w?}@B@C@S@T@U@]@^@c@h@l@m@t@w@y@{A@AEAMAXA\\A^AaAbAdAkAmAxBABF"},
  {0,NULL,"BIBKBLBPBTBXBjBkBpBsByB|CACECICQCTCUCYC\\CaCbCeCkCoCqCuCwCzC|DIDLD"},
  {0,NULL,"NDRD\\D]DbDeDgDiDoDrDvDyD{EBECEFEIEJE[EcEdEgElEnEsEuEwEyFGFMFNFQFR"},
  {0,NULL,"FZF_FgFjFqFvFxF{F|GGGJGKGLGaGdGeGfGhGjG}G~H?HAHFHMHUHVHYHZH_HcHuH"},
  {0,NULL,"wHxHyHzI@IEIGIOIPITIVI\\IaIbIeIgInIqIrIsIwI|I}JFJHJOJ[J^J_JuJwJyK@"},
  {0,NULL,"KAKBKGKNKOK]KbKmKoKrKsK{LALCLFLILKLNLTLWLYL_LaLhLkLlLoLqL{MFMIMLM"},
  {0,NULL,"NMOMQM]M^MbMdMiMkMmMnMrMtMxM{NFNHNSNYN`NaNoNtN}O?O@OFOKOSOVOWOYO["},
  {0,NULL,"ObOfOlOnOoOtO{O~PCPHPIPJPVP\\P_PbPdPePoPpPsPtPwPxQ?Q@QAQBQNQOQYQ[Q"},
  {0,NULL,"\\Q]QmQnQpQqQ{Q|R@RARGRIRKRMRQRWRdRkRmRoRrRvR}SASCSISKSNSVSYSZS_S`"},
  {0,NULL,"SeSvSwSxSy_H?I?J?W?X?Y?a?b?e?i?k?l?q?r?w?{?~@@@P@R@X@Z@^@c@h@i@j@"},
  {0,NULL,"n@s@x@|ABACANAZA[A]A`AaAgAjAoAxA}B?B@BKBMBOBVB]BgBpBvBwB{B}CBCCCH"},
  {0,NULL,"CICJCUCWCZCcCdCiCkCrCtCuD?DADBDFDGDHDLDTDVDbDjDkDnDpDqDxDyDzD}EDE"},
  {0,NULL,"GEOETEUEcEeEhEmEoEqEzE{F@FIFKFMFSFWF[FbFcFhFuFxFzF{G@GEGMGRGWGbGh"},
  {0,NULL,"GmGoGpGrG{G|G~HEHIHMHTH_H`HaHbHfHjHmHqH{H|I@IBIDIKIRIUIVI^I_I`IeI"},
  {0,NULL,"hIjIsItIvIyIzJBJMJNJTJ]JbJdJmJnJqJyJ~K?KIKJKRK_KeKlKmKnKoK{K|LDLE"},
  {0,NULL,"LILJLZL]L_LaLbLcLeLnLpLxLzL|L}MAMDMJMSMTMXMZMeMgMhMjMmMnMrMtMxM{N"},
  {0,NULL,"FNHNSNWN[N\\NoNwNyNzN{N~OGOHOJONOQOSOcOdOeOfOoOuOyOzP?PBPEPIPQP]P^"},
  {0,NULL,"P_PcPfPgPhPnPqPsP}QJQKQRQSQUQVQXQZQ`QfQjQkQoQsQtQvQzQ}RGRHRORVRYR"},
  {0,NULL,"[R`RbRgRjRlRrR|R~S@SBSGSLSTSWS[S]SaSeSjSkSlSvSxSz_H?I?J?W?X?Y?a?b"},
  {0,NULL,"?e?i?j?n?p?t?v?|@A@F@O@X@\\@^@a@b@j@k@l@p@q@u@z@}@~ANAOAQAWA]AbAfA"},
  {0,NULL,"hAiAvA~B@BFBGBJBWBYB^BhBiBkBlB|B}CACGCICKCMCPC[CeCfChCiCkCsCxCyD@"},
  {0,NULL,"DBDCDJDMDODVDWDYD_D`DcDhDlDpDvDyD{EBECEFEIEJE[EcEdEgElEnEsE|E~F?F"},
  {0,NULL,"KFMFTFUFYFZF`FdFfFqFyF{F~GCGDGPGQGXGdGeGpGsGuGvGyGzH?HDHHHIHRHaHc"},
  {0,NULL,"HeHfHgHiHoHpHvI?I@IAIJILISIVIXI[IeIiIkIlImIqIuIvIxJ?JAJGJIJVJ\\J`J"},
  {0,NULL,"fJqJsJtJ}KAKBKKKPKSK^K`KbKcKhKoKwK~LBLFLJLLLPLVLXLZL^LaLiLlLuLwLx"},
  {0,NULL,"LyM?MBMCMEMJMOMVMaMbMcMfMgMpMqMrMsMyM~N?NJNVN]N_NbNoNpNvNxNyN}OGO"},
  {0,NULL,"NOOOPOVO\\O_O`OdOfOgOhOwPDPFPGPJPMPPPTPUPVPXPZPjPmPrPuPxP{QCQDQGQI"},
  {0,NULL,"QMQPQWQ^Q_QaQcQgQrQwQxRBRCRERHRNRPRTRXR^RcReRfRqRrRsRwR|SCSESFSJS"},
  {0,NULL,"PSZS^SbScSfSjSkSlSwSySzS{_H?I?J?T?U?Y?Z?_?c?l?m?n?u?x?z?{?~@?@O@["},
  {0,NULL,"@]@_@`@d@i@k@m@o@r@v@|AAABALAUAVAWAYA^AeAgAjAwAyAzBEBGBIBVBZB]BhB"},
  {0,NULL,"iBjBnBsBtC?CKCPCQCRCTCYC^CbCfChCmCtCvC}D?DDDEDGDHDKDSDUDXDaDdDfDj"},
  {0,NULL,"DkDuDvDyD{EBECEFEIEJE[EcEdEgElEnEsEvEzF@FGFPFQFTFUFVFbFcFiFtFvG?G"},
  {0,NULL,"CGDGGGRGSGWGaGjGkGsGvGwGyHCHFHGHJHKHRHSHZH[HdHhHjHpHtHyH|H}IBIKIM"},
  {0,NULL,"IPIQIXIYI^I`IaIfIlIrItIuI{I~J@JKJLJZJ]JcJdJrJsJtJwJxK@KIKJKMK]K`K"},
  {0,NULL,"dKfKhKsKvK}K~L?LALGLMLOLSLTLULVLeLnLrLtLyL{L}MBMDMIMPMRMYM\\MeMfMj"},
  {0,NULL,"MkMmMoMpMuMvMwNANENGN[N\\NiNpNsNtNuNvO?OIOOOROXOYOZOaOhOkOqOtOvOzP"},
  {0,NULL,"@PBPCPLPMPQPTP[P^PaPePgPpPqPrPyPzQEQJQKQSQTQVQXQZQ`QeQiQkQoQsQtQv"},
  {0,NULL,"QyQ~RJRORRRSRURVRbRfRkRlRpRtR{S@SESGSISMSOSSSWSYS]ScSjSkSlSvSxSzS"},
  {0,NULL,"|_H?I?J?T?U?Y?Z?_?c?j?k?m?o?s?y?|@E@F@M@U@V@Z@[@`@h@l@m@t@w@y@z@}"},
  {0,NULL,"A?AYAZA\\A^A_AcAhAiAnAxAyA{BDBHBLBNBWB^BpBrBsBuBvBxB~C?CCCNCOCUCWC"},
  {0,NULL,"YC`CdCgCmCqCxCyC{C~DDDIDODUDYDZD[D^D_D`DdDiDmDxDyDzD}EDEGEOETEUEc"},
  {0,NULL,"EeEhEmEoEqE|E}F?FGFHFIFPFSFXF`FeFfFrFxFzF}G?GBGIGPGQGbGgGhGiGjGlG"},
  {0,NULL,"}G~H@HBHJHOHWHXHYHZH[H`HiHnHqHtHvH~IAIJINIQIUIWI]IfIiIjImIoIqIrIs"},
  {0,NULL,"IwI|I}JFJHJOJ\\J`JeJpJyJzJ|J~K@KEKKKSKfKiKkKmKnKpKxK{L@LGLHLKLMLOL"},
  {0,NULL,"WL]L`LdLgLiLmLuL{L|MAMCMEMIMKMMMVMWM[MaMhMkMnMoMqMzM|M}N@NLNQN]N_"},
  {0,NULL,"NhNrNsNtNwN{N|OIOJOMOYO[O]OcOkOlOrOsOvOwPAPFPIPKPNPUPWPXPYP_P`PkP"},
  {0,NULL,"lPmPsPuPvQGQIQLQMQPQQQWQ^Q_QaQdQhQrQwQxRBRDRFRIRLRNRSRXR\\RaReRjRn"},
  {0,NULL,"RqRtRwS?SBSDSFSISPSRSUS^SdSeSjSkSlSwSySzS{S}_D?E?H?Q?[?`?a?b?e?h?"},
  {0,NULL,"q?r?s?t?w?|@?@C@D@E@H@I@J@L@e@i@j@m@n@v@|ABAIAMANAXAZAaAcAfAnAsAv"},
  {0,NULL,"AwA|A~BIBJBOBSBWB[B]B`BfBrBsBwBxC?CECPCRCSCYC^C_CbCeCnCoCvCxCzC|C"},
  {0,NULL,"~D?D@DCDIDNDZD[DaDfDsDtDzE?EAEBEFEIEUEYE]EbEcEeEgEmEsEzF@FFFIFJFL"},
  {0,NULL,"FRFSF[FgFjFpFqFrFvFyGGGHGJGMGOGTGWG_GcGgGkGpGxGyHAHDHGHJHSHWHZH]H"},
  {0,NULL,"hHiHnHoHsHwHxHyH|H~I?IAIIIOIWIYIaIiIpIvI|I~J@JAJEJKJNJXJ]JdJgJnJq"},
  {0,NULL,"JsJxJ~K@KEKMKNKOKPKRKcKeKjKlKsK{K|LALBLHLMLNLULYLZL]LaLbLpLqLzL|M"},
  {0,NULL,"AMJMKMSMXMZMcMdMeMgMjMmM{N?N@NPNQNRNSNVNZNdNfNjNlNnNqN{O?O@OAOJOR"},
  {0,NULL,"OWO\\O^O`OaOiOjOlOrOsOtPAPBPKPNPRPZP^PdPjPlPpPvPwP{P~Q@QGQNQOQTQYQ"},
  {0,NULL,"_QcQdQeQpQrQuQwQxR?RARERPRTRVRZR]R^ReRhRlRoRsRuRwR{R}SESISMSOSPSY"},
  {0,NULL,"SZS\\S_SgSiSnSxSzS}_D?F?I?R?\\?]?^?_?`?f?o?u?w?x?z?{@@@B@D@F@H@J@K@"},
  {0,NULL,"L@g@i@j@l@n@u@|ACAIALAOASAUAYAbAfAiAsAxAzBCBHBKBLBNBQBZB\\B^BaBgBq"},
  {0,NULL,"BuB{B|CACGCHCICQC[C\\CcCfCiCnCqCvCwCyCzC}C~DCDDDMDODPDTDeDgDmDnDzE"},
  {0,NULL,"@ECEFEGEJEQEZE_EbEdEeEgEkEnEwEyFCFGFHFMFPFZF[FdFfFmFsFuFwF|GFGHGI"},
  {0,NULL,"GKGNGTGXG^GbGiGoGuGwGzH?HBHHHOHRHYH[HaHgHjHmHrHtHxHzH{H|I?I@IAIKI"},
  {0,NULL,"UIVIYIbIcIoItI}J?J@JAJEJIJMJUJ\\JfJhJmJrJtJ}KBKDKFKVKWKYK[K\\K_KjKn"},
  {0,NULL,"KoKrKzLBLDLGLKLOLPLYL\\L`LaLcLdLmLpLvLwMAMEMNMPMWMYM_MbMdMeMhMnMyN"},
  {0,NULL,"ANBNGNNNPNRNTNWN[N]N`NaNhNsNzN{N}OCOKOQOROTOVO_ObOdOlOmOpOqOtO}O~"},
  {0,NULL,"PAPEPRP]P`PaPhPkPqPuPwPyP{QAQJQPQRQTQ]Q_QiQmQnQoQqQsQuQvQ{Q~R?RPR"},
  {0,NULL,"SRURVR[R]ReRgRjRlRoRtRwR{SCSHSISKSOSPSVSZScSfSgSiSpSwSzS|_F?G?H?Q"},
  {0,NULL,"?Z?[?]?b?d?h?p?q?t?v?x?|?}?~@B@E@H@I@J@K@f@h@k@l@p@y@{AEAKANARASA"},
  {0,NULL,"VAZA]AeAoAuAwBABDBEBHBIBSBUBZB]B_BdBmBpBtBwB|CDCECHCNCUC`CcCeCjCk"},
  {0,NULL,"CnCpCsCvCyC{C}DBDDDEDHDLDQDYD`DdDqDrD{E?E@ECEDEMENEREVE`EdEfEhEpE"},
  {0,NULL,"rE}E~FDFJFMFRFTFUFVFhFiFnFrFsFxFyG@GEGMGNGQGRG\\G_GcGhGjGlGwGyHCHN"},
  {0,NULL,"HOHPHSHYH\\HdHeHmHpHqHuHvHwHxHzH{I@IBIEIGIPIZI]IfIjIsIxJ?J@JBJDJGJ"},
  {0,NULL,"OJYJbJcJgJpJ{J|J}KBKDKHKUKWKXKYK[K]K_KiKoKrKuKxK}L?LILMLNLOLQLUL]"},
  {0,NULL,"LaLbLhLpLyLzMAMIMKMRMXM]McMfMhMkMlMmMzNDNINJNKNRNUNVNYN[N\\NaNbNhN"},
  {0,NULL,"pNtN|OBOFOKOLONOQOTO_O`OaOiOjOlOrOuOzPAPJPKPRPYP^PbPgPnPtPxPzP{P~"},
  {0,NULL,"QAQBQFQJQPQWQXQgQhQlQpQqQrQuQwQxQ|RERGRHRJRNRWRYRcRfRkRmRpRrRwRzR"},
  {0,NULL,"|S@SHSMSPSQSRS\\S]SfShSiSjStSwSxT?_E?G?I?R?Z?\\?_?a?c?f?o?p?s?u?y?{"},
  {0,NULL,"?}@@@A@C@I@J@K@L@f@h@k@m@o@t@zA?AGAOA\\A]A_AbAcAdAmArAzA|A}B@BCBEB"},
  {0,NULL,"QBUBWB^BbBeBoBsByB{B}CFCJCQCSCTC\\C]C_CaClCnCrCtCxD?D@DADBDCDEDJDK"},
  {0,NULL,"DQD]DbDcDkDqDyE?E@EBEEEKEOEREXEaEcEfEhEqErE}F?FDFHFIFNFPFWF\\FcFhF"},
  {0,NULL,"nFvFwF|F~GCGDGIGOGPGSG[G^GbGeGfGnGpGzHAHEHIHKHRH]H^HbHfHlHpHsHuHw"},
  {0,NULL,"HxHyHzH}H~ICIDIFISI[I\\IeInIsI{I~JAJBJCJFJLJPJ`JeJhJoJvJxJzJ~K@KGK"},
  {0,NULL,"IKKKOKPKRK`KbKiKmKtKyK{K|L?LHLMLOLPLYL[L`LcLdLiLmLpL{MAMEMLMMMVM["},
  {0,NULL,"M^MaMeMhMkMnM|NANENJNLNONTNVNXNdNgNjNkNlNoNqN|O?O@OHOMONOPOSO_O`O"},
  {0,NULL,"bOdOeOmOpOtO{PAPEPMPRPUPVP]PhPoPqPrPxP|P~QCQEQFQUQVQYQ\\QcQeQlQoQp"},
  {0,NULL,"QqQsQvQ~R?R@RGRHRJRORQR\\RbRdRfRkRqRrRxRzR{SHSJSMSOSQSSS\\SbSfSgShS"},
  {0,NULL,"kSqSwSxT@_E?G?I?R?[?]?`?d?e?f?q?r?v?w?x?|?~@?@B@D@G@H@K@L@g@i@l@m"},
  {0,NULL,"@v@wAAABAFAMANA_A`AaAcAhAnApAvAwA|A}BGBJBOBSBWBYB[BeBfBjBlBrBtC?C"},
  {0,NULL,"BCNCOCRCXCYC`CbCdCnCuCwCxC|C~D@DADBDCDNDSDYD[DfDlDrDtDvD}EEEFEGEP"},
  {0,NULL,"EUEVEYEbEeEgEhEiEoEuExFCFHFKFMFPFQFZF`FeFmFsFtFwF|GAGFGIGLGNGUGXG"},
  {0,NULL,"^GiGoGuGvGwH?H@HBHHHOHYH[H`HaHgHjHlHsHtHuHyH|H}H~I@IBIJIQIXIZIdIh"},
  {0,NULL,"IkItIyI|I}JAJDJHJRJZJ`JeJlJpJwJyJ{J|K?KHKQKTKUKXKZK]K`KfKgKtKwKyL"},
  {0,NULL,"?L@LJLMLPLQLTLZL[L^LdLgLlLrLsL~MBMCMTMWMXM]M`MbMfMjMpM|NBNDNHNINM"},
  {0,NULL,"NRNSNYN\\N^N_NbNiNoNuNvN|ODOLOMOSOUOXO`ObOeOkOnOpOsOuOxO|PCPDPPPSP"},
  {0,NULL,"[PfPgPkPmPpPtP{P}QBQEQKQMQUQ[Q\\Q^QfQlQoQpQtQvQ|Q}R@RARGRHRJRORQR\\"},
  {0,NULL,"RbRdRfRkRqRrR|R~SASDSFSNSRS^S`SaSdSeSjSmSoSsSyS~TA_E?F?J?S?\\?a?b?"},
  {0,NULL,"c?e?g?o?r?s?t?y?{@?@A@C@E@G@H@J@K@e@j@k@m@o@q@z@~AHAQA\\A]A^A_AbAd"},
  {0,NULL,"AlAqAyA}B?B@BCBEBRBTBUB^BbBeBjBmByBzB{CBCJCKCQCUCXC\\C]CkCmCnCqCyC"},
  {0,NULL,"}C~D?D@DADBDEDJDKDRD\\DbDcDjDuDwE?EDEFEGEKEOESE\\EaEcEeEfEmEtE{F@FB"},
  {0,NULL,"FKFLFRFSFXF[FaFjFlFqFtFyF{GGGHGJGLGTGWGZG_GaGcGiGkGsGyG{HDHHHLHQH"},
  {0,NULL,"SHWHXHaHmHnHuHvHxHyH|H~I?I@IIINIOIRI`IaIiIlIrIxI}JAJBJKJSJVJXJ^Ja"},
  {0,NULL,"JkJmJpJrJtJ{J|KFKHKUKVKXK\\K_KaKdKoKrKvKwL@LCLJLNLTLULVLXL_LcLdLhL"},
  {0,NULL,"kLsLwL~MDMIMPMYMZM`MaMgMiMkMrMvN@NCNLNMNONPNUNWNYN\\N]N`NbNrNuNvNy"},
  {0,NULL,"ODOGOKOQOTO[OaOcOdOfOgOjOkOpOzO|O~P@PPPYP\\PaPiPlPmPnPoPwP|QAQDQIQ"},
  {0,NULL,"JQPQZQ[Q^Q`QfQrQvQxQyQ}Q~RDRFRIRKRLRMRRRXR_R`RaRiRnRvR|S@SBSCSFSK"},
  {0,NULL,"SRSVS[S]S^ScSjSmSpStS{S|_E?F?J?S?[?]?^?_?d?g?q?u?v?x?z?|?~@@@B@F@"},
  {0,NULL,"G@I@J@L@g@i@k@l@p@r@{ADAJAQARATAVAZA]AeAjAtAyBABDBEBFBIBRBUBXB]B_"},
  {0,NULL,"BdBkBoBpBvBwCCCDCECMCTCZCaCeChCjCnCoCxCyC{C~D?DBDDDEDHDLDVDWD`DdD"},
  {0,NULL,"iDoDxE@EAEEEFEMENETE^E`EdEeEhEkEoExEyFAFGFKFPFQFZF[FeFfFkFtFuF|GA"},
  {0,NULL,"GFGHGKGLGTGUGXG^GbGdGgGuGvGzG|H@HBHGHRHTH[H`HhHrHsHuHxHyH{H|H}I?I"},
  {0,NULL,"@IJIKIVIXIbIdIhIoIqI{I|J@JBJIJRJUJZJ^JaJjJnJoJqJsJvJzKEKGKIKKKMKN"},
  {0,NULL,"K^KaKdKhKpKvK{K|LCLHLPLRLSLTLULXL]LcLiLjLqLxL}MJMMMQMUMWM[M\\M]MdM"},
  {0,NULL,"lMoMvN?NBNFNGNHNJNKNXNZNfNgNkNnNqNrNyO?O@OGOIOZO[O]ObOdOfOhOjOkOo"},
  {0,NULL,"OrO{P?PBPIPOPVPXPZPjPkPsPxPyPzP}Q?QDQIQQQSQYQZQ`QcQeQoQxQzQ}Q~RBR"},
  {0,NULL,"ERFRIRKRLRMRRRXR_R`RaRiRnRvRxR}SESGSJSLSSSWSXSYS_SbSkSnSqSrSvS}_F"},
  {0,NULL,"?G?H?Q?\\?^?`?a?c?h?o?s?w?y?z?{@A@C@D@F@G@H@I@L@e@j@l@m@u@wAAACAFA"},
  {0,NULL,"LAOARASAWAYAhAiApAxAzBDBHBKBMBNBQBVBZBaBdBgBkBnBqB}CACCCFCICLCZC["},
  {0,NULL,"CgCiClCnCuCvCwC{C|C}C~DDDEDODTDXD]DgDkDmDpDvD~EAEDEFEQEWEXE_EbEeE"},
  {0,NULL,"fEgEjEtEvE{FFFIFJFKFRFSFXF_FaFpFrFtFvFyF{GGGLGMGOGWGZG_GgGkGpGsGx"},
  {0,NULL,"HAHDHGHJHLHWHXHZH]HhHiHmHoHqHuHvHyH{I?I@ICINIQIRI[I`IkIlIvIzI|I}J"},
  {0,NULL,"@JCJHJSJVJbJcJiJoJuJvJzKAKCKGKIKJKKKLKSK]K^KhKiKpKxKyLELILLLNLOLQ"},
  {0,NULL,"LWLXL[L\\L]LfLjLlLnL}M@MCMGMVMZM\\M^M`MbMeMqMzN@NANENHNNNONSNXNcNeN"},
  {0,NULL,"gNkNmNoNpNwNxOBOIOLONOZO]O_OaOeOfOqOrOuOvOyP?PCPFPOPTP[PcPhPlPoPp"},
  {0,NULL,"PrPuP}Q?QBQFQQQSQWQ\\QaQhQkQqQrQ{Q|R@RCRERFRGRHRJRNRWRYRcRfRkRmRpR"},
  {0,NULL,"rRxS?SASDSGSNSSSUSWS`SdSeSkSrSsSuSyS~TB_E?G?I?R?Z?\\?_?a?c?f?o?p?s"},
  {0,NULL,"?u?y?{?}@@@A@C@I@J@K@L@g@i@l@m@v@wAAABAIALAOARAUAWAbAhAnAsAxAzBCB"},
  {0,NULL,"DBLBMBNBQBVB\\B^BdBgBuB{B|B}CACFCGCHCQC[C\\CcCfClCnCpCtCuCvCzC{C|DC"},
  {0,NULL,"DEDJDWDXD]DbDkDoDpDzD|E@EAECEOEWEXE^EbEeEgEhEiEoEuExFAFLFVFWFYF\\F"},
  {0,NULL,"^F`FeFkFqFxFzG?GCGDGJGPGQG[G]G`GaGeGfGlGrG{HCHEHFHKHQHVH^HbHdHjHo"},
  {0,NULL,"HpHrHsHvHwH{H}I@IDIFIIILI\\I^IaIeIqIzI~J?J@JFJJJKJPJ`JeJlJpJwJyJ{J"},
  {0,NULL,"|K?KHKQKTKUKXKZK`KaKcKgKmKuKwK{K}L?LQLSLTLZL\\L^L_LaLeLuLxLzMFMKMO"},
  {0,NULL,"MQMUMXMYM\\MbMgMiMpMtN@NBNCNKNMNNNQNYN\\N^N_NbNiNqNtNuN|OFOGOJOMOPO"},
  {0,NULL,"XOcOhOkOlOnOqOsOuOwPHPIPKPWPXP^P_PiPkPlPmPuPvPzQ@QDQEQKQVQXQYQ[Qg"},
  {0,NULL,"QlQtQuQyQzQ{Q|Q}RARMRRRTRXRZR^R_R`RaRhRsRuRyR}S@SESJSMSTSYS\\S]S_S"},
  {0,NULL,"bSlSnSqStSxS}TD_F?G?H?Q?Z?[?]?b?d?h?p?q?t?v?x?|?}?~@B@E@H@I@J@K@e"},
  {0,NULL,"@j@l@m@u@wAAACAIAMANAXAZA_A`AhAiAsAvAwA}A~BGBIBOBSBYB]B`BeBfBsBtB"},
  {0,NULL,"wBxC?CECNCPCSCYC^C_C`CeCnCrCsCuCvCwCzDADBDCDLDSDYD\\DdDjDlDrDzD|E?"},
  {0,NULL,"EBEGENEPEVE\\EbEeEfEgEjEtEvE{FBFGFNFOFTFUFYF_FaFlFuF~G?G@GBGEGKGRG"},
  {0,NULL,"SGYG\\G`GdGhGjGmGnG|G}HIHNHPHTH\\HcHeHfHiHmHnHpHtHvHyHzH}H~IEILIPIV"},
  {0,NULL,"I]I^IjIoIrIyI~J?JAJIJJJOJYJbJcJiJoJuJvJzKAKCKGKIKJKKKLKSK^K_KbKiK"},
  {0,NULL,"mKvKxKzK}LLLRLVLWLXLYLZL[L\\LeLkLmLoMDMEMFMHMUMWMZM\\M_MaMjMqMsN?NA"},
  {0,NULL,"NCNFNGNMNSNXNcNeNgNkNmNpNrNsNwOFOHOIOKONOPOeOfOgOoOqOsOtOvOwP@PEP"},
  {0,NULL,"LP\\P]P_PePhPiPjPmPpPsPyQ?QAQCQFQVQWQZQ]QaQgQ{R?R@RARBRCRDRFRMRRRS"},
  {0,NULL,"RURXR[R_R`RaRgRjRtRyS@SCSHSJSKSTSVS]SbScSfSlSpSqStSwS|TE_D?F?I?R?"},
  {0,NULL,"Z?a?b?d?e?f?p?r?s?t?v?}?~@?@C@E@G@I@K@L@f@h@j@k@q@s@}@~AGAOAQA^A_"},
  {0,NULL,"AbAcAkAlArAyAzA|A}B?BCBQBRBTBWB^BeBjBoBsByB}CBCFCJCSCTCXC]C_CaClC"},
  {0,NULL,"qCrCtCwCyC}C~D?DDDEDFDIDRD\\D^DaDjDuDyD~E@EDEEEIELESE\\EaEcEdEfElEp"},
  {0,NULL,"E|E~FEFJFMFUFVFZF^FbFiFoFrFsFxFzGEGFGMGNGQGXG\\G]GjGlGqGvGxH@HCHJH"},
  {0,NULL,"MHNHUHZH\\H`HdHkHlHmHqHrHuHxHzH{I?IEIGIMIWI]IfIgIpIuIzI{I}JBJGJNJQ"},
  {0,NULL,"JYJ\\JfJlJnJqJsJuKAKCKEKJKLKMKNKSK^KhKjKnKpKzK~LALDLFLPLQLTLZL\\L^L"},
  {0,NULL,"aLdLlLrLuLxMBMCMOMQMUMVMaMcMfMgMjMpMyNCNDNFNLNQNSNVNZNcNeNfNmNnNs"},
  {0,NULL,"N}N~OAOEOIOROVOZO]ObOkOlOnOpOqOsOuPCPDPHPIPSPWPXP[PgPiPpPsPvP|P~Q"},
  {0,NULL,"?QQQRQSQTQ]QbQdQjQnQoQtQuQvQ{Q|Q}RARPRSRURVR[R]ReRgRjRlRoRtRyR}R~"},
  {0,NULL,"S?SLSNSTSUSXS_SaSdSlSnSoSuSvSyT?TCTGTH_D?E?H?Q?Z?]?^?_?c?h?p?u?x?"},
  {0,NULL,"y?z?}@@@A@B@F@G@H@I@K@f@h@i@k@r@xA@ADAKANAQARASATAZAgAjAuAwAyBDBF"},
  {0,NULL,"BHBIBRBSBXBZB]BdBkBmBpBtB|CCCDCHCNCUCZC`CcCjCkCoCpCsCxCyC|C~D?D@D"},
  {0,NULL,"BDFDMDVDWD^DeDiDoD{D}E?EDEEEJELETE^E`EcEdEhElEqE|F?FEFHFIFNFOFSF\\"},
  {0,NULL,"FbFcFoFvFwF~GBGCGGGIGOGSGWGYG[GeGnGoGsGtG~H?HEHIHLHXH_HbHfHgHkHlH"},
  {0,NULL,"nHqHsHuHwHxH|H~IDISITIUI\\IcImInIuIxIyI|JBJLJMJPJWJ]JdJiJmJrJtJwJy"},
  {0,NULL,"K?KFKQKTKVKZK\\KcKkKnKqKsKwL@LALBLJLNLWLXLYLZL[L\\L]LkLlLnLoM@MCMDM"},
  {0,NULL,"HMUMVM_MbMhMiMlMqM{NCNDNENGNKNNNTNWN]N^N_N`NiNuNvN{OAODOJOOOVOYO^"},
  {0,NULL,"OaOeOfOqOrOsOtOvP@PCPFPLPTP[P\\PePgPiPqPrPuPyPzQ@QHQLQOQRQ[Q^Q_QdQ"},
  {0,NULL,"fQrQ{R?R@RARCRERFRPRTRVRZR]R^ReRhRlRoRsRuRyR~S?SBSDSKSTSUSVS[SaSe"},
  {0,NULL,"SlSoSpSuS{S~T@TFTGTH_E?F?J?S?\\?a?b?c?e?g?o?r?s?t?y?{@?@A@C@E@G@H@"},
  {0,NULL,"J@K@g@i@k@l@p@r@{ADAKAMAPAYA[A\\A^AeAjAuAvA{B?B@BBBKBOBPBTBaBbBcBi"},
  {0,NULL,"BnBxByBzB~CJCKCLCPCWC]C^CgCmCoCpCqCsCuCyCzC{DADBDKDODRD[DcDgDtDuD"},
  {0,NULL,"{D|D}ECEGEKESEUE_E`EdEeEhEkEoExEyFCFLFVFXFYF\\F]FeFfFmFqFxF{F}G?GC"},
  {0,NULL,"GJGQGVGZG[G`GaGfGkGmGqG{G}HDHKHMHQHUHWH^HcHjHkHnHpHrHtHvH|H}I@IDI"},
  {0,NULL,"GIIINI\\I`IaIfItIwIxIyJ?JGJKJPJSJ^JaJjJnJoJqJsJvJzKEKGKIKKKMKNKdKo"},
  {0,NULL,"KpKsKtKvKxKzLHLJLPLRLSLWL]L^L`LbLgLoLvLyMHMNMRMTMUMVMXM^MdMeMfMoM"},
  {0,NULL,"}NHNJNNNQNSNTNVNXNZNfNgNkNnNpNrNsO?ODOSOTOZO[O^ObOhOiOmOnOoOrOvOx"},
  {0,NULL,"O}PJPLP`PbPePfPpPqPuPvPxP}P~QIQOQPQQQUQWQZQ]QeQfQoQsQtQwQzRBRCRER"},
  {0,NULL,"GRHRJRPRVR]ReRfRkRlRoRrRwR|R~SDSHSKSPSRSVSaSeSfSiSjSoSpSwS~T?TBTF"},
  {0,NULL,"TI_E?F?J?S?[?]?^?_?d?g?q?u?v?x?z?|?~@@@B@F@G@I@J@L@e@j@k@m@o@q@z@"},
  {0,NULL,"~AGALAPATAVA[AaAdAlArAxA{BABBBFBJBNBPBXB[B_BcBhBlBpBuBvC@CDCGCMCO"},
  {0,NULL,"CVCdCfChCjCoCqCrCtCuCzC{D?DADEDHDNDTDVD`DfDiDmDyD|D~EAEBEMEQETEYE"},
  {0,NULL,"aEcEeEfEmEtE{F@FFFGFNFQFUFYF]FaFjFpFuF}F~G?GAGEGKGSGUGVG\\G`GdGhGr"},
  {0,NULL,"GtGuG|G~HBHFHPHTHVH[H_HeHiHkHnHoHpHrHvHyH}I?IEIJISIVI]IhInIoIvIwI"},
  {0,NULL,"zI{I~JIJLJRJYJ^JaJkJmJpJrJtJ{J|KFKHKUKVKXK\\K`KaKcKoKpLCLDLHLILJLN"},
  {0,NULL,"LVLWL^L_L`LbLdLfLuL{L|MGMLMOMSM_M`MbMcMhMjMkMrM}NANCNDNENINPNRNWN"},
  {0,NULL,"YN\\N]N`NbNyN}O?OBODOGOJOMOTOZOaOcOgOiOmOnOpOvOyPHPMPNPUPWPcPdPgPh"},
  {0,NULL,"PiPrPtPwP{Q@QDQEQPQQQ`QeQfQhQnQrQsQtQvQwQyRCRDRGRHRJRPRVR]ReRfRkR"},
  {0,NULL,"lRoRrRxR{R}S?SMSNSOSSSUS\\S_SdSgSkSnSuSxSyT@TATCTJ_D?E?H?Q?Z?]?^?_"},
  {0,NULL,"?c?h?p?u?x?y?z?}@@@A@B@F@G@H@I@K@e@i@j@m@n@v@|ABAFARASAUAWAYAbAfA"},
  {0,NULL,"nApBCBDBHBKBLBMBVBZB\\B^BaBdBkBnBqB|B}CCCFCHCICLCZCcCgCiClCpCqCtCu"},
  {0,NULL,"CwCyCzC|C~DCDJDMDPDWDbDeDnDoDvD|D~EDEGEJEOEZE^EbEcEeEgEmEsEzF@FBF"},
  {0,NULL,"NFOFQFTFUF]FgFjFlF}F~G@GAGBGEGRGSGUGVGYG\\GdGjGmGnGtG|G}G~HIHNHTH\\"},
  {0,NULL,"H_HcHfHjHkHlHmHnHoHrHvH~I?IHIJISITI_IhImInIrIyIzI}J?JLJRJTJWJ]JdJ"},
  {0,NULL,"gJnJqJsJxJ~K@KEKMKNKOKPKRKdKeKkKsKtK|K~L@LALFLMLOLQLRLULVLaLbLhLr"},
  {0,NULL,"LtLyM?MBMIMRMYM[M\\M]MeMjMkMmMuN?N@NANBNINJNLNZNdNfNjNlNnNvN~O@OAO"},
  {0,NULL,"EOOOSOWO[O^O_O`OgOiOjOlOoOuOzPDPGPJPQPSPYPbPhPjPkPlPtPxP|QHQIQNQO"},
  {0,NULL,"QUQ^QbQcQdQjQpQqQuQwQxQ|RBRDRIRKRLRORQR\\RbRdRiRnRqRvRzR|R~SBSFSLS"},
  {0,NULL,"QSRSXS[S^SaShSjSmSoSvS{TATBTE_F?G?H?Q?\\?^?`?a?c?h?o?s?w?y?z?{@A@C"},
  {0,NULL,"@D@F@G@H@I@L@f@h@k@l@p@y@{AEAJAMAWAXAYA[A^AeAoAtAvA~B?BBBKBMBOBTB"},
  {0,NULL,"VB`BaBcBgBhBnBrBzC@CACKCLCRCVC[CbCgCmCoCrCsCuCwCxC{DADBDDDGDODRDX"},
  {0,NULL,"D_DgDpDuDxD}D~EBEEEHESEWE_E`EdEfEhEpErE}E~FEFIFNFOFPFSFWFhFiFoFvF"},
  {0,NULL,"|F~GBGDGGGOGPGSGWGYG^GeGoGpGsGtG~H?HAHEHLHXH]H_HbHgHiHkHlHpHqHtHu"},
  {0,NULL,"HyHzH}ICIFIKIRI[IbIeIlIuIwIyI{I|JCJFJUJVJbJcJgJpJ{J|J}KBKDKHKUKWK"},
  {0,NULL,"XKYK[K]K^K_KfKgK}LCLDLILLLMLRLULVLYLZLaLbLqLrLtL|M?MBMJMSMYM[MdMf"},
  {0,NULL,"MgMhMiMmMsNBNKNLNPNQNTNUNYN[N\\NaNbNhNwNyN}OBOFOIOKOLOUOXO`OgOiOjO"},
  {0,NULL,"lOoOsOtPBPDPGPNPQPSPZPdPkPnPqPvPwPzP|Q?QAQBQKQMQ`QaQgQhQnQpQuQwQx"},
  {0,NULL,"R?RARBRDRMRRRSRURXR[R_R`RaRgRjRtR}SFSGSISLSNSWSXSZS^S_SdSmSnSrSvS"},
  {0,NULL,"ySzT?T@TDTGTM_D?G?J?S?Z?_?b?c?d?g?p?t?u?v?y?}?~@@@A@E@G@H@J@L@e@h"},
  {0,NULL,"@j@m@s@t@}A?AHAOAQA\\A]A^AcAkAmAqAyAzA|B?B@BEBQBRBTBUBWBbBjBmBoBzB"},
  {0,NULL,"{CBCKCQCTCUCXC\\CaCkCmCqCrCtCwCxC}D@DADCDDDFDIDQD]D^DaDkDqDwD~EBEF"},
  {0,NULL,"EGEIELEREXEaEcEfEgEjEsEvEzFFFGFOFQFTFYF]F_FgFpFuF}G?G@GAGBGKGRGUG"},
  {0,NULL,"VGYG`GhGmGrGtGuG}G~HBHFHPHVH[H_HcHeHiHjHlHmHoHtHyHzH~I?IHILIPITI^"},
  {0,NULL,"I_IjImIvIwI{I}JAJJJOJTJWJ[J_JjJwJyJ}K?KBKDKQKTKWKYKZK[K]KfKgKlKqK"},
  {0,NULL,"uLBLELGLKLPLRLSLTLWL]LbLcLgLjLqLvL}MJMNMTMVMXM\\M_MgMkMlMoMxN?NCNI"},
  {0,NULL,"NKNNNONVN[N^N_NaNhNiNtNxNzN{OCOLOUOXOYO\\ObOdOhOiOkOoOrOvOxO}P?PBP"},
  {0,NULL,"OPZP`PfPiPjPoPtPuPzP~QBQGQKQLQMQXQ_QiQkQmQoQwQzQ}Q~RBRCRERNRTRWRY"},
  {0,NULL,"RZR^RcRhRmRpRsRuRwSASDSESGSISPSWSYSZS`SeSiSrSsSzS}S~TATETGTJTK_D?"},
  {0,NULL,"G?J?S?[?\\?^?`?e?g?o?q?r?w?z?{?|@?@D@F@G@I@J@K@g@h@i@l@x@yA@AEAKAP"},
  {0,NULL,"AWAXA[A\\A^AgAoAuA{A~B?B@BBBMBPBTBVB`BbBcBhBiBnBxByB~C@CJCLCPCVCWC"},
  {0,NULL,"]C^CgCpCrCsCtCwCxCyDBDCDDDGDUDXDZD_DhDpDsD{D|E@EEEGEHEWE[E]E`EdEg"},
  {0,NULL,"EhEiEnEuEwFAFGFHFKFMFQF[F`FdFkFsFtFuFwGAGHGIGKGLGNGTGUGbGdGgGiGvG"},
  {0,NULL,"zG|H@HGHHHRHTH`HaHhHjHlHmHrHsHtHzH{H}H~IAIBIQIUIYIZIcIkIqIyI{J?JB"},
  {0,NULL,"JDJEJHJMJ[J_JkJuJxJ~K@KAKCKJKLKOKPKRKSKbKiKlKmKqKuK~LALELFLNLTLVL"},
  {0,NULL,"WL_LbLcLdLhLkLuL{MDMIMLMOMZM]M^MbMcMdMiMrMxN@NENGNHNQNRNUNcNdNeNj"},
  {0,NULL,"NlNmNtNxN~OAOEOHONOPOYO\\OaOcOdOgOiOkOpOvOzP@PHPMPUPWPYP\\PlPnPrPvP"},
  {0,NULL,"yP{P}QCQFQGQLQVQXQbQdQjQkQrQvQwQyQ}Q~RCRDRNRTRWRYRZR^RcRhRmRpRsRu"},
  {0,NULL,"RyRzS?S@SBSMSQSTSUS[S\\S]ShSlStSuSxS{T?TDTFTL_D?F?I?R?\\?]?^?_?`?f?"},
  {0,NULL,"o?u?w?x?z?{@@@B@D@F@H@J@K@L@f@h@j@k@q@s@}@~AHALAPAUAVA`AaAkAlAqAx"},
  {0,NULL,"A{BABGBJBLBNBPBYB[B\\B_BfBiBqBuBvB~C?CGCICMCWCYCfChCiCoCqCrCsCvCzC"},
  {0,NULL,"}D?D@DADHDPDTDUD`DhDmDnDwD}E?EBECEMEQEZE[EaEcEdEfElEpE|E~FDFHFOFP"},
  {0,NULL,"FSFWF\\FbFiFnFwF|GBGCGDGGGIGPGWGYG[G^GbGfGnGoGpGzH?HAHIHKHRH]H^HfH"},
  {0,NULL,"gHiHkHnHpHqHtHwHxHzH|IKIRITIUIbIcIlImIsIwIxI~JAJMJUJVJWJ\\JfJlJnJq"},
  {0,NULL,"JsJuKAKCKEKJKLKMKNKSKeKhKjKlKrKvKxKzK~LKLMLQLSLTLZL[L^L_LeLgLsLzL"},
  {0,NULL,"~MFMKMTMVM[M\\M]M`McMiMpMwN@NENFNHNINKNLNZNcNeNfNmNnNpNrNsNzOEOQOR"},
  {0,NULL,"OWO\\O]O`OcOeOhOkOnOsOuOwOxO|PKPPP^P_PfPlPrPsPtPzP|P}QGQJQNQSQTQWQ"},
  {0,NULL,"ZQ]QbQmQpQtQyQzQ|Q}R@RARIRKRLRNRWRYRcRiRmRnRpRvRwR|S@SASCSESPSRSY"},
  {0,NULL,"S]S`ScSiSjSsStS|S}TCTETFTGTMTP_D?F?I?R?Z?a?b?d?e?f?p?r?s?t?v?}?~@"},
  {0,NULL,"?@C@E@G@I@K@L@g@i@j@l@n@u@|ACAFAXAZA_A`AaAcAfAiApA|A}A~BGBIBJBWBY"},
  {0,NULL,"B[B]B`BeBjBlBrBsBtCBCNCOCRCSCXC_C`CbCdCoCrCsCuCvCwCzC|C~D?DIDLDZD"},
  {0,NULL,"\\DaDdDjDsDvD|D}EAEEEIENE\\E]EbEdEeEgEkEnEwEyFAFVFWFXF\\F]F^FdFfFkFx"},
  {0,NULL,"FzF{F}GCGDGPGQGVGZG[G]GaGeGlGqGrG{HCHEHFHMHQHUHVHbHdHiHkHnHqHrHsH"},
  {0,NULL,"tH{H|H}IGIHIMINI_I`IfIgIqIyIzI|I~JGJQJSJTJ\\JfJhJmJrJtJ}KBKDKFKVKW"},
  {0,NULL,"KYK[K\\KhKkKnKqKrK~LCLDLILKLMLOLSLYL[L_L`LcLiLnLtL{M?M@MLMMMWMXMYM"},
  {0,NULL,"ZM^MkMlMnMwN?NJNMNNNONRNUNWN[N]N`NaNhNyNzN}OBOEOOOQOVOYO]O_O`OcOd"},
  {0,NULL,"OeOhOmOtO{PFPGPMPQPTPUPVPjPmPnPoPuPxP{QHQJQLQRQSQ`QbQhQmQnQpQqQsQ"},
  {0,NULL,"yQzQ~R?R@RIRKRLRNRWRYRcRiRmRnRpRvRxRzS?SBSGSLSQSSSUSWSXS[ShSkSrSu"},
  {0,NULL,"SvS{TATBTDTO_D?E?H?Q?[?`?a?b?e?h?q?r?s?t?w?|@?@C@D@E@H@I@J@L@f@h@"},
  {0,NULL,"i@k@r@xA@ADAJAMAPAWAXAYA\\AgAjAtAvA{A~B@BKBMBOBPBVB`BaBbBgBhBrBxBz"},
  {0,NULL,"C@CACKCPCRCVC[C^CbCmCoCpCqCtCxCyCzC{DCDDDKDUDZD[DcDhDsDtDxD~E@EBE"},
  {0,NULL,"CEKEUE[E]E`EcEdEhElEqE|F?FDFJFRFTFUFZF^FbFcFnFrFyFzG@GEGFGMGRGXG\\"},
  {0,NULL,"G]G_GcGhGlGwGxGyHCHJHOHPHSHYHZHdHeHjHkHlHoHpHrHwHxHzI?IMIOIWIXIdI"},
  {0,NULL,"gIiIpIsIwI{J?J@JNJQJXJZJ]JdJiJmJrJtJwJyK?KFKQKTKVKZK\\K`KaKcKeKkK|"},
  {0,NULL,"L@LBLGLKLOLQLRLVLWLXL[L\\LeLfLjLmL}MEMFMGMWM^M`MaMfMiMlMqMuNDNFNHN"},
  {0,NULL,"MNONTNUNWN]N^N_N`NiNvNzN{O@OCOGOJOMOOOWO_OeOfOgOoOqOuOvOwOyP?PEPO"},
  {0,NULL,"P]P_PcPgPmPnPoPqPsP}Q@QDQEQHQNQ^Q_QcQiQmQqQ{Q|R@RBRCRDRFRIRKRLROR"},
  {0,NULL,"QR\\RbRdRiRnRqRvRxR{SASCSESJSOSSSYS`SbScSgSkSqSsS|S}TCTDTFTHTR_E?G"},
  {0,NULL,"?I?R?[?]?`?d?e?f?q?r?v?w?x?|?~@?@B@D@G@H@K@L@f@h@k@m@o@t@zA?AHALA"},
  {0,NULL,"TAUA[A`AaAdAmAqAxBBBFBGBJBLBNBXBYB[B\\BcBfBiBlBqBvB~C?CICMCOCWCYCd"},
  {0,NULL,"ChCiCpCqCtCuC{C|C}D@DADEDGDNDSDVD_DfDiDlDwD}D~ECEDEHEPETEYEaEcEfE"},
  {0,NULL,"hEqErE}F?FEFMFRFTFVFZF^FcFhFoFsFxFyFzG@GFGNGQGRGXG]G_GjGqGvGwGxH@"},
  {0,NULL,"HJHMHNHOHUHYHZH\\H`HjHkHlHoHpHqHuHvHwI@IBIOIPIXIZIdIiIjIuIwIxIzI}J"},
  {0,NULL,"DJOJXJZJ`JeJhJoJvJxJzJ~K@KGKIKKKOKPKRKdKgKmKsKtKwKyK{LELLLOLSLYL\\"},
  {0,NULL,"L_L`LaLcLnLtLvLwM?M@MNMPMZM[M_MaMcMdMlMnMtN?NENFNGNPNUNVNXNdNgNjN"},
  {0,NULL,"kNlNoNqNuNwNxOPOSOXO[O^O_OcOdOhOlOmOqOtO}O~PFPGPQPTP`PaPjPnPrPsPw"},
  {0,NULL,"PyP~QIQKQOQUQVQYQ[Q\\QaQkQqQsQuQyQzQ{Q~R?RMRRRTRXRZR^R_R`RaRhRsRuS"},
  {0,NULL,"BSDSFSGSISKSVSWSZS[S^SeSmSpSrSzS{S~T?T@TETHTPTR_D?G?J?S?Z?_?b?c?d"},
  {0,NULL,"?g?p?t?u?v?y?}?~@@@A@E@G@H@J@L@g@h@i@l@x@yA@AEAJANAQASATAVA]AgAoA"},
  {0,NULL,"tAwAyBABEBFBHBRBSBUBXBZB_BkBmBoBvBwCCCECMCTCUCZCaCeChCkCoCpCsCvCx"},
  {0,NULL,"C{C|C}D@DDDFDMDQDYD^DeDqDrDxD}EAECEFEJELEREVE`EdEgEhEiEnEuEwFCFLF"},
  {0,NULL,"WFXFYF]F^F`FdFmFqFzF{F}G?GDGJGPGVGZG]G`GfGkGmGqGrG}HDHFHKHMHUHVHW"},
  {0,NULL,"H^HcHiHjHoHqHsHtHwH{H|I@IFIHILIMI^I_IeIgItIwIxI|J@JFJJJQJTJ[J_JkJ"},
  {0,NULL,"uJxJ~K@KAKCKJKLKOKPKRKSKbKeKfKjKlKyLELFLGLLLNLULVLXL^L_L`LdLfLsLw"},
  {0,NULL,"L|L~MGMPMSMUMYM]M^MaMhMjMrM~NANDNGNJNLNMNQNcNdNeNjNlNmNoNwNxN~OCO"},
  {0,NULL,"HOROUOWO\\OaOcOfOgOjOmOnOpOyO|O~PNPPPaPcPdPgPhPmPvPxPyP|QCQGQMQNQT"},
  {0,NULL,"Q\\QaQiQjQkQrQsQtQvQxQyRDRFRORQRSRUR[R\\RbRdRgRjRqRtR{SASCSFSISNSOS"},
  {0,NULL,"ZS^S`ScSdSgSmSsSySzS|TBTDTHTITLTM_D?G?J?S?[?\\?^?`?e?g?o?q?r?w?z?{"},
  {0,NULL,"?|@?@D@F@G@I@J@K@e@h@j@m@s@t@}A?AGAPATAUAVA[A`AkAmArA{BABBBFBGBLB"},
  {0,NULL,"PBXBYB\\B_BcBhBiBlBpBuB~C@CDCGCOCVCWCdCfCjCpCrCsCtCvC|C}D?D@DEDGDP"},
  {0,NULL,"DSDUD_DhDlDnDyD|E?EAEDEHEPEZE[EaEcEfEgEjEsEvEzFBFIFJFKFLFXF[F_FgF"},
  {0,NULL,"lFqFrFtFvF{GHGJGLGMGOGTGZGaGcGgGiGsGyG{HGHHHLHQHSHXHaHhHiHmHnHoHq"},
  {0,NULL,"HsHvHwH{H~IAICIQIWIYI[IkIpIrIxIzI~JBJCJEJHJNJ[J_JjJwJyJ}K?KBKDKQK"},
  {0,NULL,"TKWKYKZK[KbKfKkKnKqKuK}L?LFLGLPLRLSLULXL]L^L`LiLoLxLyMHMMMQMRMWM["},
  {0,NULL,"M_M`MeMfMgMoM~NBNFNINONPNSNTN[N^N_NaNhNiNtN|N~OCOFOHOOOUOVOYObOfO"},
  {0,NULL,"hOjOmOnOoOrO{PIPJPLPVPXPbPePkPoPpPqPsPtPwQCQHQLQMQRQXQgQiQjQlQoQs"},
  {0,NULL,"QtQxQzRBRERFRORQRSRUR[R\\RbRdRgRjRqRtRyRzR~SHSJSLSQSTSXSaSbSfShSlS"},
  {0,NULL,"oSqSvSwT@TCTETKTNTS_D?E?H?Q?[?`?a?b?e?g?i?j?m?t?y?|@F@L@N@O@X@Y@]"},
  {0,NULL,"@b@g@n@p@q@r@uA?A@AAABAEAGAHAIAJAeAoAuA{A|A}B?BKBLBVBYB[B^BbBcBoB"},
  {0,NULL,"qBsBuBvC?CFCMCQCTCVC`CcCgCmCnCvC}DEDHDIDLDNDQDSDTDYD\\D]D^DeDiDoD{"},
  {0,NULL,"D}E?EDEEEJELETE^E`EcEdEhElEqE|F?FDFJFRFTFUFZF^F`FfFmFyFzF{G?GBGCG"},
  {0,NULL,"IGKGLGMGSGXGcGeGlGmGuGyG|H?HFHOHQHRHXHZH^HaHeHfHoHpHzI?ILIMIVIXI["},
  {0,NULL,"IeIgIhIiIkImIqJ?JLJNJSJTJUJVJZJ^J_JjJmJnJoJpJrJzKLKPKQKSKTKYK]KaK"},
  {0,NULL,"jKkKoKuK{L@LGLILMLTLWL[L`LeLfLjLmLpLrLtLuLvLzL}MGMPMQMWM[MiMjMrMu"},
  {0,NULL,"MxMzM}N?NLNMNTNXNZNeNkNlNmNpN|OBODOFOMOROSOTOUOXOZO[OhOlOmOnOoP@P"},
  {0,NULL,"CPFPLPRPWP]PaPbPePfPtPuP}P~QAQBQFQJQLQXQYQ`QbQjQkQmQnQuQvQ}Q~RDRG"},
  {0,NULL,"RKRQRXRYR[R_RaRbRjRnRtRxSASFSGSLSNSQSRSUS[S\\S]ShSiSjSoSwS~T?TATET"},
  {0,NULL,"ITJTTTU_D?F?I?R?\\?]?^?_?`?g?i?k?m?o?r?~@@@H@M@Q@V@W@a@b@e@s@t@u@w"},
  {0,NULL,"@y@z@|@~ABADAHAIAJAKAdAmArBABBBGBIBKBMBPBXBZB[B`BdBgBmBtBwBzCHCKC"},
  {0,NULL,"PCRCUCWC_CdChClCnCxDBDCDJDKDMDODQDWDXDYD[D]D^DaDjDuDyD~E@EDEEEIEL"},
  {0,NULL,"ESE\\EaEcEdEfElEpE|E~FDFHFOFPFSFWF\\F_FjFlFqFrFtFwFxGGGUGYG\\G]G^G`G"},
  {0,NULL,"aGbGmGpGxGzHDHFHIHNHSHTH^H`HdHeHgHhHpHtHwH|IIILIRITI_IcIdIfIhIiIl"},
  {0,NULL,"IvI~JDJHJOJQJSJUJWJ[J^JjJwJ}K?K@KAKCKEKFKGKHKNKUK_KbKhKlKtKvKyK~L"},
  {0,NULL,"BLHLOLQLXL^LbLeLgLmLnLoLpLsLtLzL|L~MDMJMTMYM\\McMlMrMwM|M}M~N@NFNN"},
  {0,NULL,"NUNWNYN[N^N_NbNoNqN|N~O@OHOKOOOUOWOYO[O^OfOhOjOrOtPCPDPHPIPVPXP\\P"},
  {0,NULL,"]P_PbPdPpPqPtPxQEQFQQQUQVQWQ_Q`QaQeQfQhQkQwQyR?RCRDRHRLRQRTRXRYR_"},
  {0,NULL,"RaRhRnRpRuR|SASBSDSFSGSOSQSSSUS\\SdShSkSoSqSvSwT@TBTDTITJTNTO_D?G?"},
  {0,NULL,"J?S?[?\\?^?`?e?f?k?m?n?o?u?~@?@I@U@V@W@\\@a@b@f@p@q@s@u@y@zA?A@ABAD"},
  {0,NULL,"AFAGAIAKAdAlAqAwAxBABGBKBMBOBXBZB[B\\B`BnBsBtBwB}CCCFCHCPCSCdCfChC"},
  {0,NULL,"kCmCnCyC~DBDJDKDLDODRDWDXDZD[D\\D^DaDkDqDwD~EBEFEGEIELEREXEaEcEfEg"},
  {0,NULL,"EjEsEvEzFBFIFJFKFLFXF[FcFiFnFvF|G?GBGCGHGLGMGQGRGVGXGfGiGlGsGtGyH"},
  {0,NULL,"EHHHMHPHQHYH[H\\HcHfHgHhHnHsHvH{ICIDIGIWIYI[I^IdIgIhInIuIxJFJHJIJN"},
  {0,NULL,"JTJUJYJ`JfJlJnJsJtJuKBKDKIKKKRKTKXKZKaKfKiKnKrKwL?LALCLGLMLRLSLVL"},
  {0,NULL,"\\LfLhLiLkLnLoLxLyLzL|MAMCMMMQM^M_MfMjMnMtMvMwM~NANINQNTNXNZNdNgNm"},
  {0,NULL,"NnNrNvNyNzODOJOMONOOOQOROWO]O`OaOeOnOsOxO}P?PBPPPRPTPYP_PbPfPlPmP"},
  {0,NULL,"sPzQAQDQIQKQPQYQ[Q\\QaQdQgQhQnQqQrQsQuQ{RGRKRMRVR[R\\RdReRfRkRlRtRx"},
  {0,NULL,"R{R}SJSLSNSVSWSZS[S^ScSjSmSsStS|S}T?TBTDTFTITOTPTW_D?G?J?S?[?\\?^?"},
  {0,NULL,"`?e?h?j?l?m?y?z?|@E@K@X@Y@\\@]@_@b@f@p@q@s@u@y@zA?A@ABADAFAGAIAKAe"},
  {0,NULL,"AjAtAxA|A~B?BKBLBOBQBVBYB[BbBjBsBtBuB|CFCHCNCOCQC^CaCgChCmCnC~D?D"},
  {0,NULL,"EDHDJDLDNDPDSDTDVDWD\\D^DeDqDrDxD}EAECEFEJELEREVE`EdEgEhEiEnEuEwFA"},
  {0,NULL,"FGFHFKFMFQF[FcFiFoFtFwF}F~GDGGGNGTG\\G]G_G`GbGfGgGjGtH@HGHIHMHPHTH"},
  {0,NULL,"VHWHZH]HaHbHdHmHrH}H~IBIEISIUI\\I_IaIcIiIjIkIsI{JDJEJGJJJSJVJWJcJd"},
  {0,NULL,"JgJuJvJ{J|KCKDKFKMKOKRKVKZK^KdKiKlKnKvK|L?LALELOLSLVLZL_LgLhLiLkL"},
  {0,NULL,"mLrLuLvLxL{MAMCMDMIMXM^M_McMqMsMuMvMxNENINNNQNWNYN\\N_N`NhNqNrNwNy"},
  {0,NULL,"O?OIOKOLOPOSOVOXO^O`ObOiOsOtOyO|O~PNPQPWPXPZP[P]PdPjPkPnP|QDQIQNQ"},
  {0,NULL,"QQSQWQ]Q^Q_QbQcQlQmQoQqQ{Q|RCRHRLRNRRRTR]RcRkRlRoRrRuRwR|S@SBSDSK"},
  {0,NULL,"SSSWSYS`SbScSmSnSrSvSzS}T@TATCTETJTUTVTX_D?F?I?R?Z?a?b?d?e?h?j?k?"},
  {0,NULL,"l?s?w?}@B@G@Q@Y@[@`@a@d@e@n@o@q@r@v@}A?AAACAEAFAGAJAKAhAnAsAvB?B@"},
  {0,NULL,"BABIBJBPBRBSBUBYB`BkBnBpBvByB~C@CCCLCTCYC\\C`CbCfCpCtC{DEDFDGDJDKD"},
  {0,NULL,"QDRDVDWDXD]DeDgDmDnDzE@ECEFEGEJEQEZE_EbEdEeEgEkEnEwEyFAFVFWFXF\\F]"},
  {0,NULL,"F^F_FjFpFvFyFzF{F|GHGIGKGQGRGSGVGaGiGlGpGtHBHCHFHIHLHRHSHTHUHYHbH"},
  {0,NULL,"eHhHkHqHsH}ICIHINISIZI`IbIgIjIkImIrI~JGJMJRJTJVJXJZJ]JcJgJmJqJtJw"},
  {0,NULL,"J~K@KGKIKLKUKWK[KcKgKkKpKrKwK}LFLILKLNLRLTLYLcLgLiLnLoLsLtLuLxL{L"},
  {0,NULL,"|M?M@MGMRMVMWM]MkMqMsMtMwM{NHNLNONRNdNeNgNkNlNnNqNtNuN{N|OJOLOUOW"},
  {0,NULL,"OYOZO\\O^O`OaOjOnOrO}O~PAPEPRPUPWPZP^PcPePjPvPwPzQAQDQEQKQVQWQZQ^Q"},
  {0,NULL,"`QaQfQgQjQtR@RBRCRDRHRLRQRTRXRYRbRcRdRkRrRvR|SASBSDSFSGSTSVSYS]Sb"},
  {0,NULL,"ScSiSnStSxSzS}T@TFTGTITKTMTUTW_D?E?H?Q?Z?]?^?_?c?f?j?k?n?p?s@B@D@"},
  {0,NULL,"G@O@S@T@W@X@c@g@t@v@w@x@y@{@|@~ACADAFAGAHAKAhAiAsAyAzA{BEBLBMBNBX"},
  {0,NULL,"B^B_BaBbBhBiBjBlBmCBCDCJCKCOC[C^CeCiClCrCsDADBDFDGDHDLDQDRDSDVDYD"},
  {0,NULL,"\\DaDfDsDtDzE?EAEBEFEIEUEYE]EbEcEeEgEmEsEzF@FBFNFOFQFTFUF]F`FfFkFq"},
  {0,NULL,"FrFxF}F~GDGNGTGUGYG^G_GkGlGmGnGvG|HGHIHMHOHQHRHSH\\H]H^H_HaHkHlHmH"},
  {0,NULL,"vIBIGIHIJI_I`IbIdIlInIpItJ?JCJFJHJQJRJWJXJ\\J`JlJpJxJzJ{J~K?KEKMKS"},
  {0,NULL,"KWKYK\\K^KeKmKqKtKzK|K~LJLLLPLULXL_LaLfLhLjLkLoLrLtLuLvLyM?MBMLMTM"},
  {0,NULL,"]M`MeMlMnMsMtMuMyN@NDNJNON[N\\N^N`NbNhNpNqNrNwOFOGOMOPOXOYOZO[O]Oc"},
  {0,NULL,"OhOnOuOvPAPBPKPNPUPXPYP\\P^P_P`PiPkPsPvQ?QAQCQFQTQ\\Q]QfQiQjQkQmQnQ"},
  {0,NULL,"oQqQvQ~RCRGRKRQRXRYR[RcRdRfRiRkRpRxSASFSGSLSNSOSVSZSbScSfSlSnSqSt"},
  {0,NULL,"S|S}T?TCTHTJTLTOTRTX_E?F?J?S?\\?a?b?c?e?f?i?k?n?r?v?{@@@H@P@R@]@_@"},
  {0,NULL,"`@c@f@n@q@r@s@x@z@{A?AAAEAFAHAIAKAkAmArAvAyA|A~BCBDBQBUBVB]BaBeBf"},
  {0,NULL,"BkBqBxB|C?CECICLCNCVCXC\\CaCjCpCsCvC|DGDMDODPDSDUDXDYDZD[D`DfDiDmD"},
  {0,NULL,"yD|D~EAEBEMEQETEYEaEcEeEfEmEtE{F@FBFKFLFRFSFXF[FbFhFoFsFyFzF{GAGE"},
  {0,NULL,"GIGJGKGPGSGWGaGcGhGoGvGzG{G~HLHOHTHVHWH\\HaHbHdHfHmH|H~I@IBIOIRIUI"},
  {0,NULL,"^I`IbIeIhIiIjIsJBJIJKJQJTJVJWJZJ\\JeJlJrJsJtJuKAKDKHKIKPKRKXKZKaKf"},
  {0,NULL,"KnKrKsKwKxL?LCLGLMLRLVL\\LdLhLjLkLlLoLpLqLsLwLyL~M@MKMPM\\MdMiMkMnM"},
  {0,NULL,"vMyM|M~N?NCNHNUNcNeNfNjNkNlNtN}N~OCOFOIOKOLOROVOXO]O^OkOlOqOrOuOy"},
  {0,NULL,"PHPMPNPRPSPTPWPXP\\PePgPkPpP|QCQEQHQLQMQWQYQ\\Q^Q_QcQlQmQpQ~R?R@RER"},
  {0,NULL,"IRQRSRXRYR^R_RcRiRpRsRuSASCSESFSGSISOSQSSSXSbSfSlSnSoSqSvSyT?TFTK"},
  {0,NULL,"TLTQTTTVTWTZT[_E?F?J?S?[?]?^?_?d?h?i?j?l?q?t@A@F@L@P@R@S@U@V@[@f@"},
  {0,NULL,"o@p@t@w@y@|@}@~A@ADAFAGAIAJAgAoAuAwBCBDBEBGBJBNBRBZB\\B]BeBgBlBrB{"},
  {0,NULL,"B}CACBCGCRCSCWCZC]CeCkCrCtCwDCDGDIDNDPDSDTDUDXDZD]DcDgDtDuD{D|D}E"},
  {0,NULL,"CEGEKESEUE_E`EdEeEhEkEoExEyFAFGFKFPFQFZF[FbFhFnFqFrFuFxG@GFGOGUGY"},
  {0,NULL,"GZG[G^GcGdGpGqGvGzG|HJHKHLHQH[H\\HbHcHdHfHhHsHyH{I?ICIKIWIXI_IaIdI"},
  {0,NULL,"gIlImIoIuJBJFJJJOJRJSJUJXJ]JbJgJoJuJvJ{J}KDKMKNKQKRKVKZK^K`KdKiKl"},
  {0,NULL,"KvK|LALDLELOLSLZL]L_LiLjLlLpLqLsLuLwLxL{L}MBMEMJMUMYM[M`MqMvMxMzM"},
  {0,NULL,"{NFNJNMNPN[N]N^NaNbNiNpNtNxN~OEOKOLOMONOQOROWO]O_OjOlOpOuOxO}PJPL"},
  {0,NULL,"PUPVPYP[P]P^PbPlPzP{P~QCQGQLQOQVQYQ[Q\\Q^Q_QaQdQnQvR?R@RARFRIRQRSR"},
  {0,NULL,"XRYR^RaRbRdRgRtRvSASCSESFSGSISTSUSVS[S]SeShSiSjStSxS{T@TCTKTLTNTP"},
  {0,NULL,"TSTXTYT\\_D?E?H?Q?Z?]?^?_?c?g?i?j?m?t?y?|@F@K@R@S@T@U@Z@[@g@t@v@w@"},
  {0,NULL,"x@y@{@|@~ACADAFAGAHAKAeAoAtAwAzBCBEBFBJBNBRBWB\\B]B_BfBiBlByB}B~CB"},
  {0,NULL,"CICJCSC[CbCeCjCkCrCuCwDADGDJDODPDRDSDTDXD\\D]DcDhDsDtDxD~E@EBECEKE"},
  {0,NULL,"UE[E]E`EcEdEhElEqE|F?FEFHFIFNFOFSF\\F`FfFmFyFzF{G?GBGCGIGKGLGMGSGX"},
  {0,NULL,"GeGiGkGlGtG{G~H?HGHOHUHVHXHZH[H`HeHfHnHqHuH~IDINIQIUIYI\\I]IfIiImI"},
  {0,NULL,"oIqI|JDJJJKJLJMJNJOJ^J_JkJwJxK?KAKBKCKEKFKGKHKKK\\K_KcKfKqKtK}K~LB"},
  {0,NULL,"LCLJLXL\\L^LaLcLiLkLlLnLoLpLrLsLtLzMDMHMLMTMbMcMeMlMoMsMvM{M~N@NDN"},
  {0,NULL,"NNVNXNZNeNkNlNmNwN}OBOCOFOHOQOROSOTOUOVO\\O`OaOcOmOnOwOyP?PEPSPVP["},
  {0,NULL,"PaPcPdPfPmPwPyP|Q?QAQBQDQKQXQYQZQ[Q`QbQeQlQoQpQ}Q~RERJRNRRRURZR]R"},
  {0,NULL,"cRfRlRmRrRsRwRyS@SHSKSMSWSXSYSZS_SbSgSmSnSySzS|TBTKTMTNTPTQTS_F?G"},
  {0,NULL,"?H?Q?Z?[?]?b?d?f?k?l?n?w?x?}@C@J@N@Y@Z@[@`@a@g@o@p@r@v@w@|@}A@ACA"},
  {0,NULL,"EAGAHAIAKAfAnApAvA}B?BABFBJBRBUBWBYB`BcBpBuByBzB{B~C@CGCQCUCYCZC_"},
  {0,NULL,"CbCgCpCqCtCyDFDHDJDKDMDPDQDUDVDWDgDkDmDpDvD~EAEDEFEQEWEXE_EbEeEfE"},
  {0,NULL,"gEjEtEvE{FBFGFNFOFTFUFYFdFeFmFtFuFwG@GFGGGOGZG[G\\G]G`GdGfGgGjGoGz"},
  {0,NULL,"G}HDHEHNHQHUHXHZH`HaHeHfHnHpHzH~IDILIUIVIYIeIgIjIlIoIpIqIyJCJJJKJ"},
  {0,NULL,"UJXJYJZJeJfJlJpJvJxJyJzK?KEKJKSKVKYK\\K^KeKmKoKtKuKzK|K~LLLPLULXL["},
  {0,NULL,"L_LeLgLhLkLmLoLqLyL{L|MEMFMNMOMUMZMgMhMnMsMuMwM|NGNKNPNSNWNYN]N_N"},
  {0,NULL,"aNiNoNvN~O@OAOHOMOROSOTOUOXO\\ObOiOkOpOsOyP?PCPFPPPSPUP[P`PbPePmPt"},
  {0,NULL,"P|P}QHQIQNQOQSQXQYQZQ`QbQeQmQnQsQwQyQzR?RIRMRSRVR\\R^R_ReRlRsRtRuR"},
  {0,NULL,"{R}SCSESISJSQSSSWSXS[S^SjSmSoSsSvSyT@TATFTGTLTMTOTWT^T__F?G?H?Q?\\"},
  {0,NULL,"?^?`?a?c?f?k?l?n?w?x?}@C@G@M@O@S@T@X@^@g@n@s@u@x@y@z@{AAABADAFAGA"},
  {0,NULL,"HAJAfAnAsAzA{BBBEBHBLBNBTB^B_BbBdBhBjBlBmBoCBCDCKCMCOC^CcCeCiClCo"},
  {0,NULL,"CxD?D@DFDGDIDKDNDRDUDVDZD[DdDjDlDrDzD|E?EBEGENEPEVE\\EbEeEfEgEjEtE"},
  {0,NULL,"vE{FFFIFJFKFRFSFXFdFeFmFtFuFwG@GFGGGOGZG[G\\G]G`GdGgGpGqGwG}H@HAHC"},
  {0,NULL,"HDHRHVHXHZH[H^HeHfHoHqHuI?IMINIQIXI\\IfIhIjIkIlInIqJ@JCJDJMJSJTJWJ"},
  {0,NULL,"YJeJfJhJnJrJtJuKAKBKHKIKKKPKTKZKfKhKiKjKsKxKyK{LALCLSLWL\\LbLdLfLh"},
  {0,NULL,"LjLlLnLqLwLxLyL|L~M@MCMMM\\M^MfMkMpMtMyMzM{NANHNINUNWNYN]N_NaNiNsN"},
  {0,NULL,"{O?O@OAOQOROSOTOUOVOZO[O_ObOdOjOpOwP@PEPLPPPRPXP]P`PcPdPuPwPyP~Q@"},
  {0,NULL,"QGQNQOQVQXQYQ[Q`QbQjQkQlQtQxQyQzQ|RHRLRORPRTRWRbRmRnRqRrRvRzR|R~S"},
  {0,NULL,"?SBSDSPSTSYS\\S]S_SgSiSpSwSxSzT?TCTDTHTNTRTVTWTXTZT__E?G?I?R?Z?\\?_"},
  {0,NULL,"?a?c?h?j?l?n?p?x@C@D@J@M@S@W@X@^@c@e@n@s@t@v@x@z@{@~AAACAGAIAJAKA"},
  {0,NULL,"fAiApAyBBBEBHBLBMBNBTBXBaBbBdBhBiBoBwBxCDCECJCMCPCXC[CcCdCiCoCrCs"},
  {0,NULL,"D?DFDHDIDKDLDQDRDUDZD\\DfDlDrDtDvD}EEEFEGEPEUEVEYEbEeEgEhEiEoEuExF"},
  {0,NULL,"AFLFVFWFYF\\F^FaFgFlFsG?GAGBGCGEGJGLGMGPGWGXGcGeGjGrGuG{HEHHHJHPHT"},
  {0,NULL,"HXH^H_H`HdHgHhHpHrHwH{IEIIILIWIZI\\I^IbIiIlIoIvIzJEJFJKJMJOJWJZJbJ"},
  {0,NULL,"dJgJmJqJsJwJyK@KGKJKLKUKXK[KbKcKgKkKrKwK}LHLILKLNLQLRLTLcLeLfLiLu"},
  {0,NULL,"LvLwLxLyLzL{MFMHMKMSMaMbMdMgMqMtMuMwMzNBNCNGNVNXNZNcNfNjNmNvNyNzN"},
  {0,NULL,"}OEOGOHOKOOOTOWO[O^OgOiOlOmOoOxO|PCPDPQPSPVPXPYPcPePlPnPtPxQBQJQL"},
  {0,NULL,"QRQSQWQXQ_QaQeQhQiQkQrQsQ{RERFRIRNRRRSR]R^RaRgRlRoRtRuRwS@SCSESIS"},
  {0,NULL,"KSSSUSWS[S`SeShSjSmSrSvS{T?TBTCTHTKTRTUTXT]T__E?G?I?R?[?]?`?d?e?g"},
  {0,NULL,"?i?m?n?u?v?{@?@H@M@Q@U@W@\\@a@e@o@p@q@u@w@|@}A?A@ABAFAHAJAKAkAlArA"},
  {0,NULL,"wAxBABBBIBMBOBPBXB\\B`BdBgBmBnBtBzCCCHCKCRCUCWC_CfChClCwCyC~DDDFDI"},
  {0,NULL,"DLDMDODRDYDZD[D\\DbDcDkDqDyE?E@EBEEEKEOEREXEaEcEfEhEqErE}F?FEFMFRF"},
  {0,NULL,"TFVFZF^FaFgFpFuF}F~G@GDGFGNGOGTGZG[G_GjGkGnGrGvG{G}H@HAHJHRHTHUHX"},
  {0,NULL,"HYH_HbHhHjHkHqI@IHINIOIPIYIaIcIdIeIjImIrIzJDJIJJJPJUJVJXJ_JaJkJmJ"},
  {0,NULL,"oJqJrJzJ|KLKOKPKQKYK[K]KdKjKmKpKzK{L@LELFLULWLYLZL`LeLfLlLnLrLtLv"},
  {0,NULL,"LwLyLzL}MIMNMPMXMZM[MiMoMtMyM}M~N?NENKNMN\\N]N`NaNhNiNsN}O?OAOEOGO"},
  {0,NULL,"JOLOTOWOZO\\O^OcOgOiOuOvO{PAPEPMPOPTPUPWP[PbPdPgPhPvPwQ?QCQRQSQTQW"},
  {0,NULL,"QXQZQ^QaQgQiQjQxQzQ|RERFRIRNRRRSR]R^R`RcRiRmRsRvRwS@SCSESISKSTSXS"},
  {0,NULL,"_SaSbSfSgSlSnSuSxSyTATBTCTDTITOTSTZT[T^T`_D?G?J?S?Z?_?b?c?d?h?j?l"},
  {0,NULL,"?m?y?z?|@E@L@P@R@T@U@V@Z@f@o@r@t@v@x@{@}@~ACAEAFAHAIAJAeAjAuAwAzB"},
  {0,NULL,"CBDBFBGBWBZB\\B]B_BeBfBgBlBrB{CACBCGCICRCWCZC]CeCjCqCuCzDADIDJDKDN"},
  {0,NULL,"DODRDTD[D\\D]D_DhDpDsD{D|E@EEEGEHEWE[E]E`EdEgEhEiEnEuEwFCFLFWFXFYF"},
  {0,NULL,"]F^FcFiFoFtFwF}F~GDGGGNGTG\\G]G_G`GbGfGmGsGxGyG}H@HAHMHTHVHWHYH\\Ha"},
  {0,NULL,"HfHgHiHoH|I@IFIMIOIRI]I_IbIeIkIoIpIsIxJCJEJJJLJQJRJZJcJdJiJmJsJtJ"},
  {0,NULL,"yJ~K@KIKJKLKUKWKXKbKeKgKpKsKxLFLHLKLLLNLPLQLYLdLfLgLiLnLsLvLwLxLz"},
  {0,NULL,"L|M?MFMGMSMWM]MaMgMmMzM{M}M~NBNGNLNONWNYN\\N_N`NhNrNsO?OAODOIOJOOO"},
  {0,NULL,"ROVOXO]O^OeOfOhOsOtOzP@PHPMPQP[P\\P^P`PaPePgPpPrPuQFQIQPQQQUQWQYQ\\"},
  {0,NULL,"QcQgQhQlQmQqQuQxQzQ|RGRKRMRVR[R\\R_R`RiRjRnRqRxR{R}SJSLSNSPSQSRS\\S"},
  {0,NULL,"aSfSlSoSpSuSwS~TGTKTNTOTPTRTST\\T]T`_E?F?J?S?\\?a?b?c?e?h?i?j?l?q?t"},
  {0,NULL,"@A@F@K@N@O@\\@]@_@b@f@n@q@r@s@x@z@{A?AAAEAFAHAIAKAgAoAtAxA{A|A}A~B"},
  {0,NULL,"KBOBQBVB[B^BcBjBqBtBuB|C?CHCNCOCQCVC^CaCgChCvC|C}D@DFDIDJDMDPDQDS"},
  {0,NULL,"DYD\\D]D`DdDiDoDxE@EAEEEFEMENETE^E`EdEeEhEkEoExEyFCFLFVFXFYF\\F]FbF"},
  {0,NULL,"hFnFqFrFuFxG@GFGOGUGYGZG[G^GhGkGnGqGvGzG~HDHKHNHQHYHZH[H]HcHgHhHj"},
  {0,NULL,"HnHtHvIDIGIPITIZI[IaIfIkInIoIuIwJEJMJNJPJRJSJYJ]JbJiJqJsJtJwJyJ~K"},
  {0,NULL,"GKIKJKWKXK[KbKeKpKrKsKwKxLFLHLLLPLQLRLYLdLeLgLoLsLtLuLvLwLyL{M@MH"},
  {0,NULL,"MKMRMVMbMdMkMmMsMuM}M~NCNHNRNVN[N]N^NaNbNiNoNxN~O@OCOJOMONOOOPOQO"},
  {0,NULL,"SOWO_OcOqOuOvO{P?PBPIPOPPPQP]P^PcPfPhPmPqPsQ?QCQGQMQTQ[Q]QaQbQdQg"},
  {0,NULL,"QhQnQpQwQyR?RARJRORPRURWRZReRfRhRmRpRsRyRzR~S?SHSMSOSXSZS^S_SdSgS"},
  {0,NULL,"kSqSsSyS|TATDTETGTJTRTUTYTa_E?F?J?S?[?]?^?_?d?f?i?k?n?r?v?{@@@I@M"},
  {0,NULL,"@Q@U@V@\\@b@f@o@p@t@w@y@|@}@~A@ADAFAGAIAJAkAmAqAwAxBBBGBIBKBOBPBZB"},
  {0,NULL,"[B\\BdBgBnBsBwB}CCCFCPCRCSCWCdCfCkCmCwCxDCDDDFDIDLDMDQDWDXDYDZD]Db"},
  {0,NULL,"DcDjDuDwE?EDEFEGEKEOESE\\EaEcEeEfEmEtE{F@FFFGFNFQFUFYF]FbFhFoFsFyF"},
  {0,NULL,"zF{GAGEGIGJGKGPGSGWGcGeGhGqGuG~HBHCHKHLHTHVHWHYHZH]HaHgHiHoHrH}IE"},
  {0,NULL,"IFIMISIYI\\I]I`IcIhIpIsIwJCJDJGJHJIJKJLJ\\JeJhJpJvJxJyJ{J~KJKMKSKVK"},
  {0,NULL,"WK\\K^K`KgKoKqKuK|LDLJLKLNL[L]L_LaLeLfLjLoLqLtLuLyL{L|MBMEMLMOMUM`"},
  {0,NULL,"MeMhMpMtMwMxM}NDNJNPNSNcNeNfNjNkNlNtNuNxN{OCOIOJOOOPOSOVOXO^O_OlO"},
  {0,NULL,"mOoOqOzO|O~P@PSPTPZP_P`PaPdPjPnPrPuQBQGQJQLQMQWQ]QbQcQgQhQlQmQpQt"},
  {0,NULL,"R@RARBRJRORPRURWRZRbRgRjRoRqRrRyRzR~S?SHSMSPSRSYS]S`SeSiSpSrSzS{S"},
  {0,NULL,"~TBTDTETHTITMTOTZT_Td_D?F?I?R?\\?]?^?_?`?h?j?k?l?s?w?}@B@J@M@O@T@W"},
  {0,NULL,"@^@c@e@s@t@u@w@y@z@|@~ABADAHAIAJAKAhAnApAyAzA{BBBHBMBTBXB^B_BaBdB"},
  {0,NULL,"iBmBoBwBxCECJCKCMCPCXC[CcCdClCxD@DADBDGDHDKDNDQDSDUDVDYD[DaDdDjDs"},
  {0,NULL,"DvD|D}EAEEEIENE\\E]EbEdEeEgEkEnEwEyFCFGFHFMFPFZF[F_FjFpFvFyFzF{F|G"},
  {0,NULL,"HGIGKGQGRGSGVGaGhGiGoGxGyH?HBHFHNHRHUHWHXHYH_HbHcHjHxHzI@IAIOIPIV"},
  {0,NULL,"IYI\\I]IaIbIgInIrI}JCJFJGJIJJJMJNJ]JcJiJoJvJ|J}KCKDKFKNKOKQKRKVK]K"},
  {0,NULL,"_K`KlKnKvL?L@LBLDLOLVL]L^L`LgLhLjLmLpLsLuLvLwLxMAMDMEMJMUMYM_McMm"},
  {0,NULL,"MuMyMzM|NFNNNPNQNdNeNgNkNlNnNoNuN|OBODOGOIOJOLONOTOZO\\OaOfOkOqOrO"},
  {0,NULL,"{PFPGPMPTPYPZP[P`PcPfPgPhPoP}QEQHQKQMQUQXQZQ^QcQdQgQiQjQuQwQ}RBRD"},
  {0,NULL,"RJRMRURVRZR\\R_R`ReRhRjRsRyR{R}SHSJSMSQSRSXS^SaSdSkSoSsSuSyS~T?TCT"},
  {0,NULL,"ETHTPTQTRTYT_TcTf_D?F?I?R?Z?a?b?d?e?g?i?k?m?o?r?~@@@I@R@^@_@`@c@d"},
  {0,NULL,"@e@n@o@q@r@v@}A?AAACAEAFAGAJAKAdAmAqAvAyA~B@BCBHBQBSBTBUB]BaBhBkB"},
  {0,NULL,"pBrB|C@CACDCLCNCYC\\C]CaCiCpCuC{C|DGDLDNDSDVDWDXDYDZD[D`DhDmDnDwD}"},
  {0,NULL,"E?EBECEMEQEZE[EaEcEdEfElEpE|E~FEFJFMFUFVFZF^F_FjFlFqFrFtFwFxGGGUG"},
  {0,NULL,"YG\\G]G^G`GdGiGpGqGxHBHGHIHMHNHWHXH^H_H`HcHdHgHlHrHuH{IEIJIQIWI[I^"},
  {0,NULL,"IcIeIfIoIpIvI}JEJKJLJPJQJUJYJ[J^JkJmJnJoJpJqJ|KLKOKQKSKTK[KdKjKkK"},
  {0,NULL,"mKpKzK{LELFLILTLULWLYLZLhLjLlLmLnLpLrLtLuLxMGMOMQMRMVMWMhMjMoMtMv"},
  {0,NULL,"MxMyNLNRNSNTNWNYN[N^N_NbNoNqNrNuNwOGOHOIOKONOOOTO[O_OaOfOjOpOwOxO"},
  {0,NULL,"|PKPOPPPQPSP\\PaPbPiPlPnPyQGQKQOQUQVQXQ_QcQdQeQhQiQkQoQqQwRBRCRJRM"},
  {0,NULL,"RURVRZR\\RdRfRgRlRqRrRyR{R}SHSJSMSPSVSWSYSZSeSmSpStSzS{S|TATLTQTRT"},
  {0,NULL,"STTTVT`TbTdTe_D?E?H?Q?[?`?a?b?e?f?j?k?n?p?s@B@D@J@N@Q@Y@Z@[@d@g@n"},
  {0,NULL,"@p@q@r@uA?A@AAABAEAGAHAIAJAhAiApA}B?B@BFBIBJBPBRBSBWBYBcBpBuBvBzB"},
  {0,NULL,"{C@CGCQCTCUCYCZC_C`CgC{C}DDDEDGDHDKDODQDRDTDUDXD]DbDeDnDoDvD|D~ED"},
  {0,NULL,"EGEJEOEZE^EbEcEeEgEmEsEzF@FFFIFJFLFRFSF[F`FfFkFqFrFxF}F~GDGNGTGUG"},
  {0,NULL,"YG^G_GbGeGkGmGxG|H?HGHJHKHSHUHVH[H\\H]H_H`HiHwHxHyIAIFIIIKIZI^IaIc"},
  {0,NULL,"IjInIpItI|JEJGJIJPJWJXJYJ\\J`JhJnJrJsKAKBKDKHKKKPKRKTKXKaKhKiKjKsK"},
  {0,NULL,"xKyK{LALGLMLSLWLbLdLfLiLjLkLoLpLqLsLzL|MAMKMPMQM_MdMiMjMpMwMzM{M|"},
  {0,NULL,"N?NCNQNTN[N\\N^N`NbNhNpNwNxOBOEOGOHOPOQOVOYO\\O]OcOfOhOmOtOzPDPGPJP"},
  {0,NULL,"OPPPQPTPUPXPZPoPrPxP{Q?QBQFQQQUQZQ[Q\\Q]QeQfQiQlQoQvQ}RARFRJRNRRRU"},
  {0,NULL,"RZR]R`RaRgRhRjRoRwRyS@SHSKSMSRSUS`SaSdSeShSkSrSuS{S~T@TDTFTGTMTST"},
  {0,NULL,"VTZTcTeTh_F?G?H?Q?\\?^?`?a?c?g?i?l?m?q?z@A@E@L@N@O@X@Y@\\@_@g@n@s@u"},
  {0,NULL,"@x@y@z@{AAABADAFAGAHAJAgAjAuAxA{A}A~B?BLBOBQBYB^BbBcBjBoBqBsBvC?C"},
  {0,NULL,"FCMCOCTCVC^C`CcCmC|C~D?D@DFDIDJDMDNDPDTDVDWD]D`DdDqDrD{E?E@ECEDEM"},
  {0,NULL,"ENEREVE`EdEfEhEpErE}E~FEFIFNFOFPFSFWFdFeFkFsFvF|GAGEGHGJGPGQGRGVG"},
  {0,NULL,"WGdGoGrGsGwG}HBHCHEHLHQHSHUH\\H]H_H`HaHiHkHlHyIFIHIJIKI[I]I^IaIbId"},
  {0,NULL,"IiItIyJEJFJIJNJOJQJVJ[JaJkJxJ}K?K@KAKBKEKHKKKNKUK\\K_KcKfKhKqKyK}L"},
  {0,NULL,"BLCLJL\\L^LaLbLcLeLgLlLmLnLqLrLtL{L|L~MJMMMSMYM\\MaMfMoMsMxM{M}NANB"},
  {0,NULL,"NFNUNcNdNfNgNjNnNtNuNvN{OAOGOHOMOPOXOYO\\O]OdOeOgOkOpOzPAPJPKPQPTP"},
  {0,NULL,"VPWPYP\\PfPiPrPvP{Q@QHQOQPQRQZQ\\Q]QeQfQiQmQnQsQtQzR@RBRIRMRSRVR\\R^"},
  {0,NULL,"R`RdRgRiRqRvR{R}SCSESISJSPSTSVSaSeSfSlSpStSuSxS{TATBTETFTJTQTUTYT"},
  {0,NULL,"\\T]TbTgTi_E?G?I?R?[?]?`?d?e?h?j?l?n?p?x@C@D@G@N@Q@Z@`@a@d@e@o@p@q"},
  {0,NULL,"@u@w@|@}A?A@ABAFAHAJAKAfAiAsAvA}B@BABFBIBPBSBUBWB`BcBkBnBvByBzB~C"},
  {0,NULL,"CCLCTCUC\\C_C`CbCfCqCyC}DDDFDGDHDMDODPDRDTDUDVDbDkDoDpDzD|E@EAECEO"},
  {0,NULL,"EWEXE^EbEeEgEhEiEoEuExFCFHFKFMFPFQFZFaFgFlFsG?GAGBGCGEGJGLGMGPGWG"},
  {0,NULL,"XGnGrGsGuGwG{G~HAHHHOHSHWH^H`HcHdHeHgHlHtHuH|IJIQIRITIZI[I\\I_IgIh"},
  {0,NULL,"IpIvJAJFJGJHJLJSJYJZJbJdJiJoJuJ{J|J}KCKFKMKNKOKQKZK]K_K`KdKnL?L@L"},
  {0,NULL,"BLDLELVLZL]L^L`LgLiLkLlLqLrLsLvLwL{L}MBMCMIMXM[M^M`MmMsMyM{M|NENI"},
  {0,NULL,"NJNMNXNZNcNfNjNmNsNzN}OCOFOHOIOKONOOOUOYO[OdOeOgOoOvOwPHPIPKPPPYP"},
  {0,NULL,"ZP]P_PaPePiPpPqPyQ@QJQPQRQTQ_Q`QcQdQeQfQhQkQpQrQxQ~RERGRKRORPRWR["},
  {0,NULL,"RfRiRmRnRpRqRxRzR~S?SLSNSOSPSZS\\S_SfSgSlSpSqSwS|T@TETFTGTMTPTTTWT"},
  {0,NULL,"XTYTfTh_E?G?I?R?Z?\\?_?a?c?g?i?m?n?u?v?{@?@I@P@]@^@`@c@d@e@n@s@t@v"},
  {0,NULL,"@x@z@{@~AAACAGAIAJAKAkAlAqAvAyA|B@BDBHBSBTBUBVBaBeBhBpBrBxB|C@CAC"},
  {0,NULL,"DCECNCXCYC]CaCiCoCsCvCzDHDLDMDODPDTDUDWDXDZD_DfDiDlDwD}D~ECEDEHEP"},
  {0,NULL,"ETEYEaEcEfEhEqErE}F?FDFHFIFNFPFWF\\FaFgFpFuF}F~G@GDGFGNGOGTGZG[G_G"},
  {0,NULL,"fGgGjGnGuG|HAHHHJHKHRHSHUHWHYHbHcHeHsHxHzH}IAICISIVI]I`IdIeIfIkIn"},
  {0,NULL,"IrJAJCJDJNJPJQJRJTJ_JaJjJwJxJ}K@KBKCKFKGKKKNKUK\\KbKcKhKlKtKvKyK}K"},
  {0,NULL,"~LHLOLQLXLbLcLeLiLkLlLmLpLqLrLzL{MHMLMMMSMaMbMeMfMrMvMwMxM|NANBND"},
  {0,NULL,"NVN\\N]N`NaNhNiNpNsNxNzOEOIOJOLONOUOYOZO\\ObOiOoOsOvO}O~PFPGPOPRP\\P"},
  {0,NULL,"^P`PdPfPjPoPzP}QIQJQNQSQTQZQ^Q`QcQdQfQgQjQrQvQxRARFRGRKRORPRWR[Rb"},
  {0,NULL,"ReRjRkRoRtRxRzR~S?SLSNSRS[S]S^S`ScSiSjSrSsS}S~TGTJTLTNTQTTTVT[T\\T"},
  {0,NULL,"aTdTeTg_D?G?J?S?Z?_?b?c?d?f?k?m?n?o?u?~@?@H@P@R@]@^@_@d@f@o@r@t@v"},
  {0,NULL,"@x@{@}@~ACAEAFAHAIAJAdAlArA|A~B@BCBDBHBQBSBTBVB]BeBfBkBqBrBxC?CAC"},
  {0,NULL,"ECICLCVCXC\\C]CjCoCuCzC{DHDLDMDNDODTDVDWDYD[D_DhDlDnDyD|E?EAEDEHEP"},
  {0,NULL,"EZE[EaEcEfEgEjEsEvEzFFFGFOFQFTFYF]FcFiFnFvF|G?GBGCGHGLGMGQGRGVGXG"},
  {0,NULL,"bGrGsGtGwGyH?H@HFHPHQHZH[H]HbHcHdHhHjHtHyI?IKIPITIXIYIZI^I`IfIlIm"},
  {0,NULL,"IuI{JHJKJMJOJPJTJXJ`JfJhJvJyJzJ{J~K?KEKJKMKVKWKYK`KeKgKoKqKuLDLJL"},
  {0,NULL,"KLLLNLPL[L]LaLfLgLhLjLkLmLqLrLvL|M?MFMNMTMZM]MgMlMpMxMyM|M}N@NGNK"},
  {0,NULL,"NONXNZNdNgNmNnNyN|O?OBODOKOLOMONOPOQOSOWO`OdOeOgOtO{PIPJPLPOPRPSP"},
  {0,NULL,"UPVP_PcPhPqP{P~Q@QDQPQQQRQ[Q]Q^Q_QaQbQdQnQuQ{Q|Q}RDRHRLRNRRRTR]R`"},
  {0,NULL,"RaRhRmRnRvRwR|S@SBSDSKSTSUS\\S_SaSdSgShSkSuSwSxTHTLTMTQTTTUTVT[T^T"},
  {0,NULL,"_TbTe_F?G?H?Q?Z?[?]?b?d?g?i?l?m?q?z@A@E@K@P@S@T@V@Z@[@g@o@p@r@v@w"},
  {0,NULL,"@|@}A@ACAEAGAHAIAKAgAjAtAzBDBEBFBGBJBNBRBWBZB_BeBfBiByB{B}B~CGCIC"},
  {0,NULL,"JCSCZC[CbCjCkCqCtCzDCDIDJDKDNDPDSDUDZD[D\\D_DgDpDuDxD}D~EBEEEHESEW"},
  {0,NULL,"E_E`EdEfEhEpErE}E~FDFJFMFRFTFUFVFdFeFkFsFvF|GAGEGHGJGPGQGRGVGWGaG"},
  {0,NULL,"gGhGoGwHCHDHEHHHPHRHSHVH[H\\H]H^H_HmHvHwHxIAIBIGIIIZI[I]I_I`IcImIt"},
  {0,NULL,"J@JGJHJLJOJPJRJVJ[JaJjJnJpJqJrJzJ|KOKPKSKTKYK[K]KaKkKmKoKuKzL@LGL"},
  {0,NULL,"ILMLTLUL[L`LeLhLlLmLnLpLwLxLyLzMIMNMOMRMVMXMZMhMrMuMvMzM~NENKNRNS"},
  {0,NULL,"NcNdNfNgNjNnNvNyNzN{O@OGOPOQOVOYOZO[O]ObOdOkOqOrPBPDPGPNPOPVPWPZP"},
  {0,NULL,"^P_PaPkPoPsPxQ@QEQHQMQNQ[Q\\Q]QfQiQjQkQlQrQsQtQyQ{RHRLRORPRTRWReRh"},
  {0,NULL,"RkRoRpRuRzR|R~S?SBSDSOSSS^S`ScSdSkSqSrSsSvS}THTITKTNTPTSTTT[T\\TfT"},
  {0,NULL,"iTkTm_D?F?I?R?\\?]?^?_?`?g?i?k?m?o?r?~@@@H@M@Q@V@W@a@b@g@i@j@l@n@u"},
  {0,NULL,"@|ACAIALAOASAUAYAbAjAoAuA}A~B@BBBKBLBNBUBWBXBZB]BgBmBrBuByCGCHCKC"},
  {0,NULL,"NCTCVC\\C^C_CdCeCiCjCnCqC}DCDKDMDODQD^DfDgDiDjDnDtDxE@EHEIEJEPEQES"},
  {0,NULL,"EVE`EiEjEnEpErExEyE|F?F@FBFCFDFFF`FeFkFsFtFuFvGEGGGMGSGTGUGXGYGhG"},
  {0,NULL,"jGkGmGpGyG}HDHIHJH[H`HaHbHdHoHpHvHwICIDIFIIILIOIPIRISITI_I`IfIgIq"},
  {0,NULL,"IyIzI|I~JGJQJSJTJ_JaJkJuJ~K?K@KBKDKGKHKIKMKVK\\KaKeKgKnKoKuKwKxLDL"},
  {0,NULL,"GLXLYLZLbLcLfLvLwLyL}MAMBMCMEMFMIMKMNMPMVMWMhMjMoMtMvMxMyNLNRNSNT"},
  {0,NULL,"NXNfNgNjNlNmNpNtNvNxN{N~OAODOJOMOPOXOYOgOiOpOuOvP?P@PAPHPJPKPMPQP"},
  {0,NULL,"TPUPVPiPlPnPyQ?QAQBQDQIQMQNQQQYQ[Q`QgQlQoQxQ|RERFRGRHRORPRQR[RaRb"},
  {0,NULL,"RkRoRtRuR~SDSFSISKSNSTSWSXSYS_SbSlSnStSuSxS{TFTGTKTMTQTRTUTWTYTcT"},
  {0,NULL,"fTgThTn_D?E?H?Q?[?`?a?b?e?g?i?j?m?t?y?|@F@L@N@O@X@Y@]@b@e@i@j@m@n"},
  {0,NULL,"@v@|ABAIAMANAXAZAaAcAlAmAqAvA|B?BCBEBHB[B\\B_B`BcBdBmBsBvBxB}C?CDC"},
  {0,NULL,"ICPCTCWC\\C]CbCcCeCfCgCnCoCvCxDHDIDNDQD_DaDeDiDkDpDtDyE?ELEQESEYE]"},
  {0,NULL,"E^E_EaEkElEmEpEtEuEvEzE}F?FAFCFDFFF_FaFlFwFxFzF{GGGHGJGLGNGOGXG[G"},
  {0,NULL,"bGlGoGrGuHBHEHFHKHOHWHXH\\HfHhHpHtHzH}IBIEIFIGIKILIMIPIVIXI_IhImIn"},
  {0,NULL,"IrIyIzI}J?JLJRJTJWJ[JaJkJoJpJqJsJtJ{KLKOKRKWKYKZK^K`KbKlKsKvLALHL"},
  {0,NULL,"KLLLTLUL\\L`LaLgLqL{L|L~M@MAMCMEMFMJMKMMMSMbMcMeMlMoMsMvM{M~N@NDNN"},
  {0,NULL,"NVNYN[N\\N]N_NaNoNqNrNuNxNyNzODOIOKONOPO[OaOdOeOkOpOwOxOzO{O~P@PKP"},
  {0,NULL,"QPSPYPbPmPwPyP|QCQEQLQMQQQRQSQTQWQ]QaQgQjQsQtQzR@RERGRHRPRTRWRYR_"},
  {0,NULL,"ReRkRpRtRuR}S?SDSGSISNSTSVSXSaSbSfSlSmSpStS{S|TCTHTLTMTOTRTSTXTZT"},
  {0,NULL,"_TeTiTjTl_E?G?I?R?Z?\\?_?a?c?h?j?l?n?p?x@C@D@J@M@S@W@X@^@c@f@h@k@m"},
  {0,NULL,"@o@t@zA?AGAOA\\A]A_AbAcAeAgAuBCBEBFBGBHBIBQB[B`BaBbBcBoBtBvBxB}B~C"},
  {0,NULL,"ECFCJCRCVCZC\\C_CdCgCiCjCnCrD?DCDKDLDQDZD`DbDgDlDmDqDtDxEEEJEKEVEX"},
  {0,NULL,"EYEZE[E`EiElEnEqEsExEyE{E}E~FAFBFDFFFbFiFoFtFvFwF}G?GBGJGSGUGWGZG"},
  {0,NULL,"^GcGgGhGiGrGyG{G|HBHPHUH]H`HfHgHmHrH{I?IAIEIGIHIIILIMINIVIWIZIdIi"},
  {0,NULL,"IjIuIwIxIzI}JDJOJXJZJ]JcJiJmJrJsJxJ~K?KHKIKJKKKYK[K^KaKiKjKtKuKyK"},
  {0,NULL,"zK|LALNLRLYL^L`LhLjLmLpL~MAMDMEMJMLMMMOMQMTMXM[M^M`MmMsMyM{M|NENI"},
  {0,NULL,"NJNMNWNYN[N]N^NhNpNrNtNvN{O?OAODOROVOZO]O^OaOeOfOkOrOzPBPCPFPHPLP"},
  {0,NULL,"MPQPTP`PaPiPpPqPyQ?QAQBQCQDQGQMQNQ]QaQbQjQnQpQwQ}RBRDRHRIRLRNRQRY"},
  {0,NULL,"RcRdRgRlRrRvRwR{R|SASCSHSXSZS^S_SaSdSlSoSpSuSyS~TATDTGTITOTSTTTZT"},
  {0,NULL,"\\T^TaTgTkTlTo_F?G?H?Q?Z?[?]?b?d?f?k?l?n?w?x?}@C@J@N@Y@Z@[@`@a@f@h"},
  {0,NULL,"@k@l@p@y@{AEAKANARASAVAZA]AdAkAqAwBABBBJBKBLBTBUBVBWB]B^BhBpBqBtB"},
  {0,NULL,"{CFCGCKCNCUCWCXC]CbCcCdCeCgCnCpCvCyDHDJDPDQD`DaDgDhDkDrDsDyEDEKEN"},
  {0,NULL,"EQEREUEWEYEaEmEoEqErEtEvEwEzE|E~FAFBFCFDFbFcFoFuFxFyF{GAGFGLGMGNG"},
  {0,NULL,"VG]G`GaGbGdGfGkGzG}HGHHHKHXHYHZH_HdHnHsH|H~IAIDIHIIIJILISITIUIVI["},
  {0,NULL,"IbIeIlIuIwIyI{I|JCJFJUJVJ\\J`JhJoJxJyJ{J|K@KEKLKNKVKWK[K]KbKcKnKrK"},
  {0,NULL,"vKwL?LBLILPLWL_LaLbLiLpLsLzL}MAMDMGMHMIMKMPMQMRM\\M^MfMkMpMtMyMzM{"},
  {0,NULL,"NANHNINUNXNZNdNeNfNlNoNqNrNtNuNxNzOCOJOOOXOYO^O_OcOfOhOmOzO|O}P@P"},
  {0,NULL,"FPGPIPQPSPZPdPuPwPyP~QCQDQEQPQQQRQSQTQ^Q_QdQfQnQoQvQ|Q}RFRGRIRKRQ"},
  {0,NULL,"RYR\\RcRdRfRiRlRsRwRxR{SASESMSTSUS_SaSdSeSpSrSuSzS{S~TBTETHTJTNTQT"},
  {0,NULL,"UTYT[T]TaTiTkTnTp_D?E?H?Q?[?`?a?b?e?f?j?k?n?p?s@B@D@J@N@Q@Y@Z@[@d"},
  {0,NULL,"@f@h@i@k@r@xA@ADAJAMAPAWAXAYA\\AlAmArAyAzA}A~B@BDBNBOBPBXBYBZBmBrB"},
  {0,NULL,"uBzB}C@CDCICQCRCXCZC[C^C`CaCdChCzC{DCDDDKDTDUD]DcDlDnDoDqDrDsDwD~"},
  {0,NULL,"EJEMENEOEUE[E\\EaEkElEmEpEtEuEvEzE}F?FAFCFDFFFhFiFoFqFxF{GAGEGFGLG"},
  {0,NULL,"NGRGTGVG]GbGdGfGkGuGzG}HFHGHKHXHYH\\H_HdHiHtHyH}IAICIFIIIKILINIQIR"},
  {0,NULL,"IVI\\IcImInIuIxIyI|JBJLJMJPJWJeJfJlJmJqJtKAKCKDKGKKKOKQKXKZK_K`KgK"},
  {0,NULL,"kKlK}L@LDLHLKLSLULXL\\LdLeLgLmL{L}MEMFMGMIMJMNMOMRMSM]M`MeMlMnMsMt"},
  {0,NULL,"MuMyN@NDNJNONcNgNjNkNmNnNsNtN|N}N~O?OCOEOIOKOLOUOVObOiOkOpOuOyO}P"},
  {0,NULL,"CPDPIPMPNPTP[P\\PePiPkPsPvQDQGQIQJQKQPQUQVQ[Q`QaQgQhQqQsQwQyQzRHRJ"},
  {0,NULL,"RLRNRORWR`RgRmRqRrRvRzR|S@SCSHSJSVSWSXSZS[S^SlSmSnSoSvSyT?TBTJTKT"},
  {0,NULL,"NTPTQTWT[T\\T`TfTkTm_D?F?I?R?Z?a?b?d?e?g?i?k?m?o?r?~@@@I@R@^@_@`@c"},
  {0,NULL,"@d@g@i@j@l@n@u@|ACAFAXAZA_A`AaAcAjAoAuA}A~B@BBBKBLBNBUBWBXBZB]BgB"},
  {0,NULL,"iBjBpBrC@CBCHCMCNCZC\\C_CdCgCiCkCmCrCuC|D?DGDLDVDZD`DjDkDnDpDqDsDx"},
  {0,NULL,"D}EIEKENEOEQE[E^E`EkElEmEoEqEuEvEwE}E~FAFBFEFFF`FeFmFqFrFyF}GBGCG"},
  {0,NULL,"PGRGWGZG\\G`GdGgGnGtGxG|HAHGHLHNHQHVHYH^HgHlHuHyH~IBICIEIJIOIPIQIS"},
  {0,NULL,"IWIXIYIbIcIoItI}J?J@JAJEJIJMJUJ_JaJjJoJpJrJsJtJvKJKOKRKTKWKYK^K`K"},
  {0,NULL,"fKqKrL?LALCLJLKLOLQLULWL`LiLkLqL{M?M@MBMCMFMHMKMLMMMSMYM\\McMlMrMw"},
  {0,NULL,"M|M}M~N@NFNNNUNXNfNgNjNlNmNpNrNtO?OAOBODOFOLOMOSOTOXOhOiOoOsOvOxO"},
  {0,NULL,"}P@PCPFPJPNPRP]P`PaPpPqPtPxQ?Q@QCQDQGQHQMQNQ[Q\\Q^QiQlQrQxQyRARFRI"},
  {0,NULL,"RMRNRRRZR^R`RfRiRmRqRsRxRzS@SESJSMSOSRS^S`ScSdSiSjSoSsSwS~T?T@TCT"},
  {0,NULL,"ETHTITPTXT[T]T_TjTlTmTqTrTs_D?F?I?R?\\?]?^?_?`?h?j?k?l?s?w?}@B@J@M"},
  {0,NULL,"@O@T@W@^@c@f@h@j@k@q@s@}@~AHALAPAUAVA`AaAjAoAtAvAxA{A|B?BMBRBSB\\B"},
  {0,NULL,"_BdBeBiBqBrBwByCICMCNCPCTCXCYCZCfCgCkClCmCvCzD@DADHDUDYD[DaDbDcDd"},
  {0,NULL,"DhDmDoD{D}EMEREWEXEZE\\E]E`EiEjEnEpErExEyE|F?F@FBFCFDFFFcFhFoFtFvF"},
  {0,NULL,"}GBGDGHGKGSGUGWGZG[GcGhGiGmGrGyG{HBHDHPHUH]H`HbHfHjHoHvI@IAIBIIIJ"},
  {0,NULL,"ILIOIPIQIVIXI]IfIgIpIuIzI{I}JBJGJNJQJYJbJdJgJpJuJvJ|KAKBKEKMKQKRK"},
  {0,NULL,"TK\\KeKhKmKoKsKxK{K~LGLLLTLVLZL]LcLeLfLyLzL~MFMHMKMLMMMNMPMSMTMVMW"},
  {0,NULL,"M]MkMqMsMtMwM{NHNLNONRN\\N_N`NaNbNiNrNwNyO?O@OBOCOFOIOPOSOXO[O`OgO"},
  {0,NULL,"iOmOoOyO|O~PBPDPGPLPSPWPXP[PjPvPwPzQ@QCQFQGQHQLQOQPQYQ[Q\\QdQkQrQs"},
  {0,NULL,"R@RERFRGRJRKRORWR\\R`RfRiRmRqRsRxRzS@SESJSMSTSUSVSWS[SeSmSnSrSvSzS"},
  {0,NULL,"{T@TATITLTSTTTVTXT[T\\TaTbTdTe_D?E?H?Q?Z?]?^?_?c?g?i?j?m?t?y?|@F@K"},
  {0,NULL,"@R@S@T@U@Z@[@e@i@j@m@n@v@|ABAFARASAUAWAYAbAlAmAqAvA|B?BCBEBHB[B\\B"},
  {0,NULL,"_B`BcBdBiBkBsBzB}C?C@CCCICJCXCaCbCcCdCeCgChCpCuCwCyDGDJDPDRD`DbDd"},
  {0,NULL,"DeDhDjDtDyD~EKEPEREVEZE]E^EaEiEjEqErEsEyE{E|E~F@FAFBFCFEF_FaFpG?G"},
  {0,NULL,"@GAGCGDGFGIGKGVG\\G]G^GaGeGiGvGwG{H?HCHHHMHTHZH]HcHeHqHuH{I@IBICID"},
  {0,NULL,"IFIGIKINIQIRIUIYIaIiIpIvI|I~J@JAJEJKJNJXJ[JaJjJyJ~K@KBKCKDKGKHKMK"},
  {0,NULL,"NKVKXKdKeKiKnKpKwKxK|LELFLML[L^LbLcLhLwLxLyM?M@MBMCMEMFMIMNMOMRMW"},
  {0,NULL,"M[MiMjMrMuMxMzM}N?NLNMNTNYN[N\\N]N_NaNrNsNtNuNxNzOCOEOIOLONO\\O]ObO"},
  {0,NULL,"dOkOoOqOxO~P?PBPFPGPHPRPZP^PdPtPuP}P~QCQDQEQPQQQRQUQVQWQ\\QaQeQhQs"},
  {0,NULL,"QtQyQ{RDRIRMRRRSRUR\\R`RgRmRqRrRvRzR|S@SCSHSJSOSSSUS\\S`SdSiSkSrSsS"},
  {0,NULL,"}S~T?T@TDTFTGTJTVTWT\\T^TcTdThTnTqTrTu_E?F?J?S?[?]?^?_?d?f?i?k?n?r"},
  {0,NULL,"?v?{@@@I@M@Q@U@V@\\@b@g@i@k@l@p@r@{ADAJAQARATAVAZA]AfAhApAvA|B?BFB"},
  {0,NULL,"GBIBQB\\B_BaBbBdBjBvBwBxB}CCCLCMCQCSCWCYC[CaCbCiCjCmCxD?DDDEDIDLDW"},
  {0,NULL,"D]DbDdDhDiDnDsDuDzEFEHEKEMEPEWE\\E^EbEiEjEoErEtEwEyEzE|F@FAFDFEFFF"},
  {0,NULL,"`FdFmFsFtF|G@GEGGGIGSGTGXGYG_GeGhGlGpGsGyG~HCHEHJHRHWH`HaHcHiHoHq"},
  {0,NULL,"HwICIEIFIHILIMIPISITIWI\\I`IaIfItIwIxIyJ?JGJKJPJSJ`JfJlJoJwJxJyJzJ"},
  {0,NULL,"|KEKFKNKSKWK[KbKcKdKhKjKvKyK{LFLILPLRLVL[LaLiLnLxLzL}MAMCMDMGMIMJ"},
  {0,NULL,"MMMQMSM\\MdMiMkMnMvMyM|M~N?NCNHNUNWN\\N^N_NaNhNoNuNvN|O@OAOBOEOHOSO"},
  {0,NULL,"UOWO\\O`OaOeOkOsOxOyO|P?PAPDPFP`PbPePfPgPkPpP|Q?Q@QAQFQJQRQTQVQ]Qa"},
  {0,NULL,"QiQjQkQqQrQuQ{Q~RLRNRRRTRWRZR`RhRjRmRnRqRyRzS@SBSJSLSOSVSZS^ScSfS"},
  {0,NULL,"jSmSoSsSyS|TATGTJTKTLTRTUTXTYT]T^TaTcTiTuTv_E?F?J?S?\\?a?b?c?e?h?i"},
  {0,NULL,"?j?l?q?t@A@F@K@N@O@\\@]@_@b@e@j@k@m@o@q@z@~AHAQA\\A]A^A_AbAfAhAsAwA"},
  {0,NULL,"}A~B@BABJBNBTBVBXBZB^BjBlBwBzB|CCCGCKCNCQCVCYC[C]CbChCiCkCyC}D@DB"},
  {0,NULL,"DJDMDYD\\D_D`DcDjDlDoDpDvEFENEOESETEZE[E]EbEkElEmEnEsEuEvExE{E}FBF"},
  {0,NULL,"CFDFEF_FgFpFrFxFzF|GGGHGLGOGPGXG[G_GbGjGnGoGqH@HIHKHNHOHSHVHXH[Hh"},
  {0,NULL,"HjHlHtHzIBIDIFIGIHILIMIPITIUI]IhInIoIvIwIzI{I~JIJLJRJYJcJdJgJmJnJ"},
  {0,NULL,"rJwJxJ~KHKJKKKSKUK[K]K_KaKqKtKuKzL@LBLCLNLQLSLYL_LhLkLmLrL~MAMCMD"},
  {0,NULL,"MIMMMNMPMQMTMUMYM[M`MqMvMxMzM{NFNJNMNPNZNdNeNgNjNmNqNsNuN{N|O@OAO"},
  {0,NULL,"FOJOUOXOYO\\O`ObOjOsOtO}O~PBPCPEPKPNPUPWPcPdPlPzP{P~Q?QBQFQHQJQRQS"},
  {0,NULL,"QUQXQhQiQkQmQoQqQ{Q|RFRKRMRORUR[R\\R`RhRjRmRnRqRyRzS@SBSJSLSSSUSWS"},
  {0,NULL,"YS`SeSiSnSrSxSzS}TBTHTITKTLTMTOTWTZT]T^TgTjTkTsTt_D?E?H?Q?Z?]?^?_"},
  {0,NULL,"?c?f?j?k?n?p?s@B@D@G@O@S@T@W@X@c@f@h@i@k@r@xA@ADAKANAQARASATAZAlA"},
  {0,NULL,"mArAyAzA}A~B@BDBNBOBPBXBYBZBlBmBsBzB|C?C@CBCDCHCWCZC[C\\C]C^C`CfCs"},
  {0,NULL,"C|C~DBDFDSDVD\\D^DfDgDmDoDsDuDwE?EHEIEJETEUEWEXEaEiEjEqErEsEyE{E|E"},
  {0,NULL,"~F@FAFBFCFEFhFiFnFvFwF}G?GDGHGJGKGUGWG[G^GgGiGmGqGvG{G|H@HDHMHSH]"},
  {0,NULL,"HbHeHgHmHvH{I@IBIEIGIHIJILINIPIQIVIdIgIiIpIsIwI{J?J@JNJQJXJZJeJfJ"},
  {0,NULL,"hJoJwJyJzJ{K@KFKLKNKSKVKWK]KcKdKnKrKwL?LBLFLILPLWL[L_LbLlLnLwLxL~"},
  {0,NULL,"M@MCMDMHMIMJMMMRMSM_MdMiMjMpMwMzM{M|N?NCNQNTNcNgNjNkNmNnNoNqNyN|N"},
  {0,NULL,"}N~O?ODOKOLOMONOTObOdOjOpOtO|PAPEPIPJPLPMPOP]P_PcPoPrPxP{QGQIQJQK"},
  {0,NULL,"QLQMQSQTQWQXQgQhQmQtQxQyQzRARMRSRVRXR[R^R_ReRkRpRtRuR}S?SDSGSISNS"},
  {0,NULL,"PSRSYS\\S]S`SgShSiSkSwSxTATETITMTSTTTUTYT]T_TaTbTgTiTo_F?G?H?Q?Z?["},
  {0,NULL,"?]?b?d?g?i?l?m?q?z@A@E@K@P@S@T@V@Z@[@e@j@l@m@u@wAAACAIAMANAXAZA_A"},
  {0,NULL,"`AdAkArAxA{BFBGBIBMBQBRBSBaBbBeBfBhBqBwByB~CECFCKCSCZC[C\\C^C`CaCf"},
  {0,NULL,"ChCsCzDBDCDKDSDUD\\D^DdDeDlDnDpDuDwEBEHEOETEVE\\E^E_EaEmEoEqErEtEvE"},
  {0,NULL,"wEzE|E~FAFBFCFDFgFjFpFsF~G?GAGDGFGKGQGVGYG]G^GaGeGfGiGwGzG{H?HCHH"},
  {0,NULL,"HTHZH]H_HcHsHwHxH|IAIBIDIGIIIMIOIUIWIXI[I`IkIlIvIzI|I}J@JCJHJSJVJ"},
  {0,NULL,"^J_JkJoJqJrJtJvJ{KJKLKOKTKWKZK^KbKlKrKsKvL?LALHLLLTLWL\\L`LaLiLkLo"},
  {0,NULL,"LsM?MAMBMDMEMFMHMKMLMTMYM\\MaMfMoMsMxM{M}NANBNFNUNWN^N`NbNhNiNsNyN"},
  {0,NULL,"|N}N~O?ODOEOJOROWOZO^O`OcOgOmOnOxOyO{PAPEPHPNPOPTP[PcPiPrPvP{QGQI"},
  {0,NULL,"QJQKQLQMQUQVQYQ_QcQdQkQoQpQ}Q~RBRKRLRORQRXR[RaRbRhRjRnRoRyR~SBSFS"},
  {0,NULL,"KSLSPSWSYSZS_SeSgSnSuSxSySzT?TATCTDTFTRTVTXT^T_T`TdTjTlTsTwTy_F?G"},
  {0,NULL,"?H?Q?\\?^?`?a?c?g?i?l?m?q?z@A@E@L@N@O@X@Y@\\@_@e@j@l@m@u@wAAACAFALA"},
  {0,NULL,"OARASAWAYAdAkArAxA{BFBGBIBMBQBRBSBaBbBeBfBnBoBpBqCFCLCMCSCUCWCXCZ"},
  {0,NULL,"C[C]C^C`CdC{C|C~DDDFDTDVD]DcDdDfDmDpDqDtDwEDEIEMEVEXE[E]E_EaEjElE"},
  {0,NULL,"nEpEsExE{E}F?F@FAFCFEFFFgFjFlFrFwFxF{F|GHGJGLGNGPG[G_GlGoGqGrGuH@"},
  {0,NULL,"HBHEHFHOHSHWH\\HfHhHjHkHlHrIDIFIHIJIKIMISITIUIXI]I^IjIoIrIyI~J?JAJ"},
  {0,NULL,"IJJJOJYJ^J_JjJuJyK?K@KCKDKGKIKNKVKXK\\KdKeKgKiKpKxK|LDLELFLMLXL[L^"},
  {0,NULL,"LcLfLjLuLvL}M?M@MAMBMCMGMKMPMQMVMXMZMhMrMuMvMzM~NENKNRNSNWN^N`NbN"},
  {0,NULL,"hNiNoNqNtN|N}N~O?OCOHOOOSOWO^OhOlOmOnOrO{O~PCPDPHPJPLP\\P]P_PePkPo"},
  {0,NULL,"PsPxQDQGQIQJQKQPQSQTQZQ^QbQcQdQrQuQvQ}Q~RJRNRVRZR]R^RcRdRfRiRlRsR"},
  {0,NULL,"wRxR{SASESMSQSRS[S]S^ScShSjSoSqSvSwT@TGTHTLTMTNTOTWTZTaTcTeThTnTq"},
  {0,NULL,"TsTuTy_E?G?I?R?Z?\\?_?a?c?g?i?m?n?u?v?{@?@I@P@]@^@`@c@d@g@i@l@m@v@"},
  {0,NULL,"wAAABAIALAOARAUAWAbAeAgAtAwAyAzBABDBJBOBPBTBVBYB^BhBtBvB{B|B~CACD"},
  {0,NULL,"CQCRCXCYC^CeCfCkClCmCtCvCzDEDHDUDWDXD_DdDfDjDkDoDuD{ECEIELEOEPETE"},
  {0,NULL,"WE]E`EiElEnEqEsExEyE{E}E~FAFBFDFFFdFfFmFqFyFzF}F~GBGOGQGRGWGZG`Gc"},
  {0,NULL,"GdGgGnGxG|HAHGHNHPHQHUHVHYHgHmHxHzI?IAICIEIKIRISITIUIVIWIZIdIhIkI"},
  {0,NULL,"tIyI|I}JAJDJHJRJZJ[J^JkJuJyJ~K?KBKCKHKIKMKNKXK\\KaKgKiKnKoKuKwK|LD"},
  {0,NULL,"LGLXLYLZL^LbLhLjLuLxM?M@MAMEMFMGMKMOMQMRMXMZM[MiMoMtMyM}M~N?NENKN"},
  {0,NULL,"MNZNcNdNeNkNnNwNxNyN~O@OBOCOFOKOQOROUOVO_OaOcOfOjOwO|O~P?PEPJPNPP"},
  {0,NULL,"PSP[PfPgPhPvPwQ@QFQHQIQLQOQPQQQ]Q_QfQmQnQqQwQzRBRCRKRLRTRWRXRYR_R"},
  {0,NULL,"eRhRjRnRpRyR}S?SBSGSLSPSVSZSaSeSfSgSmSpSySzS|T@TBTCTETFTMTPTWT]Tb"},
  {0,NULL,"TcThTmTnTuTxTy_E?G?I?R?[?]?`?d?e?h?j?l?n?p?x@C@D@G@N@Q@Z@`@a@d@f@"},
  {0,NULL,"h@k@m@o@t@zA?AHALATAUA[A`AaAeAgAuBCBEBFBGBHBIBQB[B`BaBbBcBfBnBoBv"},
  {0,NULL,"B|B~C?CACCCJC\\C^C_CdCeCiCkCmCqCuC|C}DGDMDODVD^DaDbDiDlDpDsDxECEHE"},
  {0,NULL,"NESEXEYE\\E^E`EkEoEpErEtEuEwEzE|F?FBFCFEFFFbFiFnFqFuFxFyGAGEGLGMGR"},
  {0,NULL,"GTG]G`GaGkGsGtGuG}G~HFHHHLHRHZH\\H^HdHiHnHtH|IAIHIJIKINIQIRITIUIVI"},
  {0,NULL,"[I\\IeInIsI{I~JAJBJCJFJLJPJ]JcJgJpJuJvJzJ}KBKFKMKPKRKTK\\KeKfKhKmKs"},
  {0,NULL,"KxK{K~LJLLLOLTLVL]LcLnLoLtL|L~M?M@MGMNMOMPMQMRMTMaMbMdMgMqMtMuMwM"},
  {0,NULL,"zNBNCNGNVNWNYN[N]N^NhNpNtNxN~OAOBODOFONOQORO\\O]OaOjOlOnOrOxOyOzO}"},
  {0,NULL,"PAPKPLPRPUPVP]PlPnPtPxQ?Q@QDQHQIQMQNQQQZQ]QbQcQmQtQ{RBRCRDRMRPRUR"},
  {0,NULL,"VRZR[R_ReRhRjRnRpRyR}S?SBSGSLSSSYS]S`SbScShSiSjStSxS}TBTCTJTLTNTQ"},
  {0,NULL,"TVT[T`TbTcTdTeTiToTpTtTwTz_D?G?J?S?Z?_?b?c?d?f?k?m?n?o?u?~@?@H@P@"},
  {0,NULL,"R@]@^@_@d@g@h@i@l@x@yA@AEAJANAQASATAVA]AiAnAsAxA{BCBEBHBMBRBSB[B`"},
  {0,NULL,"BcBeBfBkBnBoBuCECICOCPCTCVC[C]C_CbChCkClCoC{C}D@DMDNDTDYDeDgDhDjD"},
  {0,NULL,"lDqDuDvEAEHEKELEOEUEVEZEbEiEmEoEqEsEvEwEyE{E~FCFDFEFFFeFfFkFqFrFz"},
  {0,NULL,"F~GBGCGOGPGQGRGZG\\GcGoGtGwGxH?HAHLHOHPHQHTHUH^HhHuHxHyI?IEIJIKIOI"},
  {0,NULL,"PIRISITIVIXIYIZIcIkIqIyI{J?JBJDJEJHJMJ\\JeJlJwJxJzJ{J|K@KEKFKLKSKV"},
  {0,NULL,"K[K]KbKdKhKjKvKyK{LBLFLRLVL[L_LaLlLpLsLwL}L~M@MGMHMJMKMPMRMSM^M_M"},
  {0,NULL,"fMjMnMtMvMwM~NANINQNTNYN[N]N`NbNiNpNqNsNuNwN{N|OFOGOIOPOZO[OlOnOq"},
  {0,NULL,"OrOuOwPAPBPFPHPIPNPUPWPYP\\PlPmPsPzQBQHQJQNQOQRQSQUQZQ`QbQcQeQpQsR"},
  {0,NULL,"?R@RERHRJRORPRUR]RaRbRgRoRrRvR|R~SCSFSHSKSQSSSWSXS[SbSlSnSqStSvS}"},
  {0,NULL,"T@TATCTETJTOTPTYT]TaTdThTiTlTqTvTxTz_D?G?J?S?[?\\?^?`?e?h?j?l?m?y?"},
  {0,NULL,"z?|@E@K@X@Y@\\@]@_@b@e@h@j@m@s@t@}A?AGAPATAUAVA[A`AiAnApAyAzBBBDBK"},
  {0,NULL,"BLBOBPBUBWBYB]BhBkBtBuB{C@CBCECHCOCWC[C_CaCbCjClCmCpCsD?DEDLDPDSD"},
  {0,NULL,"WD^D_DbDcDnDrDtDzEAEJEPERESE[E\\E_EbEjEkEnEpEtEuExEzF?F@FAFBFDFEFa"},
  {0,NULL,"FjFpFrFwFzF{F|GGGJGNGOGPGXG_GbGjGlGnGqH@HEHIHKHNHSHVHWHXH[HkHpHrH"},
  {0,NULL,"}IBIDIEIGIJIKISIUIVIXI^I_IjImIvIwI{I}JAJJJOJTJWJ]JbJiJvJzJ|J}KAKB"},
  {0,NULL,"KEKFKMKPKQKTKcKfKkKmKoK}K~LGLILJLOLPLZL]LdLeLoLtLyL~M@MHMKMLMMMOM"},
  {0,NULL,"PMQMRMWM]MaMgMmMzM{M}M~NBNGNLNONXNcNfNkNlNnNoNpNuNvNwN|OBOEOGOLOM"},
  {0,NULL,"OTOZO_OcOfOqOuOyO{P?PCPGPKPMPOPZP`PfPgPpPrPuQ@QAQJQNQOQRQTQVQ_Q`Q"},
  {0,NULL,"eQfQnQpQxQyR?RARIRLRQRRRSRXRaRbRgRoRrRvR|R~SCSFSHSKSOSPSZS\\S_SdSg"},
  {0,NULL,"SkSsSuSyS~THTLTMTOTPTQTTTWTYT[TbTdTeTjToTsTw_E?F?J?S?[?]?^?_?d?h?"},
  {0,NULL,"i?j?l?q?t@A@F@L@P@R@S@U@V@[@e@j@k@m@o@q@z@~AGALAPATAVA[AaAfAhAsAw"},
  {0,NULL,"A}A~B@BABJBNBTBVBXBZB^BgBjBlBpBxCDCGCLCQCRCVC]C_C`CcChCkClCoCrCtC"},
  {0,NULL,"{DNDTDXDZD^D`DaDcDeDfDgDvD|EQERESETEUEVEXEbEiEjEoErEtEwEyEzE|F@FA"},
  {0,NULL,"FDFEFFF_FgFlFsF~G?G@GCGFGIGQGVGYG\\G^GeGfGpGvGxGzHAHCHJHMHQH_HaHcH"},
  {0,NULL,"eHqHsHwH{IAIBICIFIKIMIQIUIWIXI`IaIiIlIrIxI}JAJBJKJSJVJXJcJdJiJpJu"},
  {0,NULL,"JzJ|J}KAKEKFKPKQKRK\\KcKfKhKkKoK{K}LGLILJLOLPLVLZLdLfLnLzL|M?MFMGM"},
  {0,NULL,"LMMMNMOMQMSMTMVMbMdMkMmMsMuM}M~NCNHNRNVNZNdNeNgNjNmNpNqNsNwNzN{N}"},
  {0,NULL,"OFOHOKOUOVOYOeOhOsOtOvP@PEPGPHPIPKPLPPPYP\\PaPhPmPqPsQBQEQHQKQNQOQ"},
  {0,NULL,"SQUQXQ^QiQjQlQqQuQwQzQ|RHRNRTRYR]R^RcRdRkRlRtRuRwR{SASDSISNSQSRSX"},
  {0,NULL,"S^SaSfSlSoSpSqSwS|T?TDTETFTQTTTVT[T_TbTdTeTfTnToTrTyT~_E?F?J?S?\\?"},
  {0,NULL,"a?b?c?e?f?i?k?n?r?v?{@@@H@P@R@]@_@`@c@g@i@k@l@p@r@{ADAKAMAPAYA[A\\"},
  {0,NULL,"A^AfAhApAvA|B?BFBGBIBQB\\B_BaBbBdBlBqBwBxByC?CCCGCJCLCWC_C`CaCcCjC"},
  {0,NULL,"lCmCpCqCsDADODPDSD[DiDkDmDqDrDtDuDzD|EIEJEKELEMEYE_EbEkElEmEnEsEu"},
  {0,NULL,"EvExE{E}FBFCFDFEF`FdFkFrFyFzF}F~GCGOGPGQGWG\\G`GcGnGoGtGwH?HLHNHOH"},
  {0,NULL,"PHTHUHVH^HhHlHmHzH~IAIBICIOIPIQIRITIUIWIbIdIhIoIqI{I|J@JBJIJRJUJZ"},
  {0,NULL,"J`JfJhJmJnJqJ}KAKDKGKKKPKQKUKZK_KlKmKpKtKzK~L@LELHLMLNLSL\\L]LgLmL"},
  {0,NULL,"rLvM?MDMFMGMHMIMNMRMSMTMUM`MeMhMpMtMwMxM}NDNJNPNSNWN\\N^N_NaNhNoNp"},
  {0,NULL,"NvNwNzN}OBOEOHONOYO\\O]O`OeOgOmOtOwOzO{PDPFPJPMPOPVPXPZPjPnPrPuQ@Q"},
  {0,NULL,"AQEQKQNQOQTQVQXQYQdQjQkQtQuQ{Q|RDRGRQRSRVR[R\\RcRdRkRlRtRuRwR{SASD"},
  {0,NULL,"SISNSTSUSYS\\S]S_ShSkSrSuSxS{T@TCTDTETNTPTST\\T`TeTfThTlTmTpTqT{U?_"},
  {0,NULL,"D?F?I?R?Z?a?b?d?e?h?j?k?l?s?w?}@B@G@Q@Y@[@`@a@d@f@h@j@k@q@s@}@~AG"},
  {0,NULL,"AOAQA^A_AbAcAjAoAtAvAxA{A|B?BMBRBSB\\B_BdBeBgBiBkBsByCHCLCMCSCTCVC"},
  {0,NULL,"XCYC^CeCfCjClCtCwC~DEDFDRDWDXD_DaDeDlDmDrDuD{E@ELETEUEYEZE\\E_E`Ek"},
  {0,NULL,"ElEmEoEqEuEvEwE}E~FAFBFEFFFcFhFnFqFuFyF{GEGFGMGNGRGTGVG`GaGdGsGtG"},
  {0,NULL,"uG~HFHGHHHLHRHYHZH\\H^HsHyH}H~ICIDIFIHIIIJILINIQISIbIcIlImIsIwIxI~"},
  {0,NULL,"JAJMJUJVJWJbJdJiJnJrJsJwJ~K?KHKIKJKSKUKYK^KiKjKqKtKyKzK|LALCLNLQL"},
  {0,NULL,"RL^L`LkLlLqLrL}MBMCMIMLMMMNMOMPMQMUMYM_McMmMuMyMzM|NFNNNPNQN\\N_N`"},
  {0,NULL,"NaNbNiNvNwNxNyN{N~O@OCOHOMOPOSOWOdOgOoOqOvOwOyOzO{PBPEPIPPP^P_PfP"},
  {0,NULL,"gPhPoP}QAQBQFQIQLQOQPQQQWQYQ\\QeQlQrQuQxQ~RERRRSRTRXR]R^RaRbRkRoRt"},
  {0,NULL,"RuR~SDSFSISKSNSOSPSQSRS\\SfSgSkSqSsSwS|TBTDTJTNTOTQTRTZT^T`TgThTiT"},
  {0,NULL,"kTpTzT|T~UA_F?G?H?Q?\\?^?`?a?c?f?k?l?n?w?x?}@C@G@M@O@S@T@X@^@f@h@k"},
  {0,NULL,"@l@p@y@{AEAJAMAWAXAYA[A^AdAkAqAwBABBBJBKBLBTBUBVBWB]B^BfBgBhBjBpC"},
  {0,NULL,"ACKCOCSCUC\\CaCbCcCeCfCgChCoCuCwCxDGDIDNDRD_DbDgDiDjDoDrDyEBEJELEN"},
  {0,NULL,"EPESEWEZEaEjElEnEpEsExE{E}F?F@FAFCFEFFFbFcFnFtFwG?GBGDGHGJGKGSGZG"},
  {0,NULL,"[G^GgGmGqGrGvG|H@HBHDHMHSHbHeHfHgHjHoHrI?IAIHIIIJIMINIOIQIWIXIZI]"},
  {0,NULL,"IfIjIsIxJ?J@JBJDJGJOJYJ\\J`JlJnJqJtJ}KCKDKGKOKPKUKXKZK_K`KgKkKpK}L"},
  {0,NULL,"@LDLELKLMLSLULXLdLrLtLuLvL}M?MBMDMGMHMJMLMSMTMUMZMgMhMnMsMuMwM|NG"},
  {0,NULL,"NKNPNSNXNZNdNeNfNlNrNsNuNxNyNzODOEOGOJOOOQOWOcOhOnOsOvOwO|O}P?PBP"},
  {0,NULL,"KPMPRPYP^PbPmPtP|P}QCQEQLQMQQQRQUQVQ^Q_QcQiQlQoQvQ~R?RCRPRRRTRURZ"},
  {0,NULL,"R]RaRbRhRjRnRoRyR~SBSFSKSLSOSQSSSbScSfSjSqSsStS|S}TATFTITKTPTSTTT"},
  {0,NULL,"\\T`TbTfTgTjTmToTpTvTxT|U?_E?G?I?R?[?]?`?d?e?g?i?m?n?u?v?{@?@H@M@Q"},
  {0,NULL,"@U@W@\\@a@g@i@l@m@v@wAAABAFAMANA_A`AaAcAeAgAtAwAyAzBABDBJBOBPBTBVB"},
  {0,NULL,"YB^BlBoBtBzB|CACJCOCRCUCVCXCYCZCfCgCjClCwC~D@DADFDRDYD[DcDeDfDhDk"},
  {0,NULL,"DnDrD{EEEMEOEPEQEREUE_E`EkEoEpErEtEuEwEzE|F?FBFCFEFFFdFfFkFtFuFvF"},
  {0,NULL,"|G@GEGIGMGSGTGUG_GjGkGmGpGsG}G~HDHIHJHRH[HaHbHdHiHkHnHqIEIGIHIMIN"},
  {0,NULL,"IOIPIRITIWI\\I^IaIeIqIzI~J?J@JFJJJKJPJ[J^JjJpJqJrJsJvJ{KJKLKRKTKYK"},
  {0,NULL,"ZK`KfKqKrKsL?LCLJLKLLLOLQLTLULWLgLoLsL|L~M?M@MAMBMCMDMEMJMTMaMbMe"},
  {0,NULL,"MfMrMvMwMxM|NANBNDNVNZNcNdNeNkNnNrNvNwNyN{O?O@OCOGOOOQOVO]ObOfOjO"},
  {0,NULL,"rOtO{P?P@PDPGPIPNPWPXP^P_PjPoPzP}QAQBQCQFQGQLQOQPQXQbQhQmQnQvQwR?"},
  {0,NULL,"RCRDRJRSRURVR\\R]RcRdRgRlRrRvRwR{R|SASCSHSQSSSUS[S\\S]ShSkSqSrSvS}T"},
  {0,NULL,"?TGTHTKTRTTTUTXTYT_TfTjTkTlTrTsTuU?U@UB_D?G?J?S?[?\\?^?`?e?f?k?m?n"},
  {0,NULL,"?o?u?~@?@I@U@V@W@\\@a@b@g@h@i@l@x@yA@AEAKAPAWAXA[A\\A^AiAnAsAxA{BCB"},
  {0,NULL,"EBHBMBRBSB[B`BcBeBiBkBnBsB{B~CBCECFCPCVCYC]C`CcChCiCkCrCtCyDBDJDX"},
  {0,NULL,"DZD\\DaDfDhDiDoDpDqDvEGEHELEMENEQEXE]EbEjEkEnEpEtEuExEzF?F@FAFBFDF"},
  {0,NULL,"EFeFfFmFsFuFvF|G@GGGIGMGUGXGYG_GeGhGjGlGsGyG~HCHEHIHRHWH[H`HcHkHn"},
  {0,NULL,"HpHvICIDIEIGIIINIOIRISIWI^I_IeIgItIwIxI|J@JFJJJQJTJ\\JeJhJmJnJtJ}K"},
  {0,NULL,"AKCKKKOKPKQKUKXKkKlKmKpKtKzK}K~LELHLMLNL\\L]LdLeLtLuL{L}MBMDMEMHMI"},
  {0,NULL,"MJMLMOMRMZM]MgMlMpMxMyM|M}N@NGNKNONYN[N]N`NbNiNqNsNzN{N}O@OAOFORO"},
  {0,NULL,"TOZO[O^O_OdOlOoOqOwO}O~P@PAPDPLPPPaPcPdPhPqP{P~Q?QBQEQFQHQKQSQUQW"},
  {0,NULL,"QZQ\\QeQfQpQ}R@RARBRIRKRMRXRYR^R_ReRfRiRpRsRxR}S?SESGSMSPSRS`SaSdS"},
  {0,NULL,"eSgSiSpSwSzS~TGTKTNTRTSTUTVTXTZT\\T`TcTfTmTpTuTxT{T}U@_D?G?J?S?Z?_"},
  {0,NULL,"?b?c?d?h?j?l?m?y?z?|@E@L@P@R@T@U@V@Z@e@h@j@m@s@t@}A?AHAOAQA\\A]A^A"},
  {0,NULL,"cAiAnApAyAzBBBDBKBLBOBPBUBWBYB]BmBnBrBuB{CACBCOCPCUCWCYC`CaCcCiCj"},
  {0,NULL,"CmCqCxDADDDIDOD[D]D^D_D`DdDkDmDsDzEGEIERETEWEYE[E^EbEiEmEoEqEsEvE"},
  {0,NULL,"wEyE{E~FCFDFEFFFaFjFlFsF~G@GAGCGDGIGKGQGYG\\G]GfGpGvGwGxGzH?HAHJHM"},
  {0,NULL,"HQHTH_HaHeHuHxH|I@IDIFIGIIIKIMINIOIRIXIYI[IkIpIrIxIzI~JBJCJEJHJNJ"},
  {0,NULL,"]JbJgJmJnJsJwJxK?KIKKKSKUKYK[K]K_KaKjKqKuKyL@LBLCLQLRLSLYL_LjLlLp"},
  {0,NULL,"LqL}L~MBMEMJMLMNMOMPMTMXM^M_McMqMsMuMvMxNENINNNQNXNcNfNkNlNnNoNvN"},
  {0,NULL,"zN}O@OAOBOEOGOOOQOTO[O_OiOlOpOuOxOzO|PCPEPGPJPVPXPbPePjPkPnP|Q?Q@"},
  {0,NULL,"QAQEQFQKQTQVQZQ[Q`QfQgQvR?R@RARCRGRJRPRVRWRZR_ReRfRiRpRsRxR}S?SES"},
  {0,NULL,"GSMSTSVS[S]SbScShSjSmStSvS{T?TBTDTFTITUTVTZT^T_TgTkTmTnTrTtTwTyT|"},
  {0,NULL,"UA_D?F?I?S?T?U?W?_?d?f?o?u?w?x?z?{@?@H@O@P@Z@[@^@_@e@n@o@q@r@v@zA"},
  {0,NULL,"?AGAPARASATAXAaAhAiAkAmAoAqAsAtAuBVBYB]B_BaBcBmBrBxBzB|B~CFCMCOCS"},
  {0,NULL,"C[C`CeCkCmCnCxDBDCDFDIDRD\\DbDcDeDgDkDoDpDqDrDtDyD~E@EDEEEIELESE\\E"},
  {0,NULL,"aEcEdEfElEpEvF@FFFOFPFQFUFYF^FbFiFnFwF|GBGCGDGGGIGJGLGMGQGWGbGjGk"},
  {0,NULL,"GnGrGyG|H?H@HCHGHKHPHQHRHZH]HcHpHtHwH|IBIKIMINIPIQITI^IaIlImIrI~J"},
  {0,NULL,"GJMJRJTJVJXJZJ[J^JkJmJnJoJpJqJ|KFKHKTKXKZK[K`KiKmKpKtKxLBLCLELHLI"},
  {0,NULL,"LJLLLVLWLYL_LbLlLrLuLxMAMGMHMJMKMLMOM^M`MhMjMnMyNANBNGNNNPNRNTN[N"},
  {0,NULL,"^NcNeNiNjNoNrN{O?OEOHOKOSO\\O]O_OfOiOnOuOwOxO|PAPEPFPGPKPLPNPPPZP\\"},
  {0,NULL,"PfPlPnPsPuQAQCQHQIQLQMQNQOQYQ\\QcQjQlQxQzR?RERFRGRIRRRWRZR\\R_R`RcR"},
  {0,NULL,"iRsRuRxRzR~SHSJSLSRSWS[S^S`SeSgShSkSuSxSyT@TBTDTITJTNTOTWTXTYT[Tc"},
  {0,NULL,"TfTnTpT~U@UC_D?E?H?S?T?V?W?[?^?h?q?r?s?t?w@A@E@L@M@R@V@W@[@d@g@t@"},
  {0,NULL,"v@w@x@y@{AEAKAWA[A\\A`AaAbAeAfAiAjAlAqArAsAtBPBTBWB\\BaBeBfBoBvB{B}"},
  {0,NULL,"C@CHCKCLCNC_CaCfChCiCnCvC}DEDFDMDVDWD`DaDdDfDjDkDlDmDqDrD{D}E?EDE"},
  {0,NULL,"EEJELETE^E`EcEdEhElEqEuEyFAFGFHFJFKFNFZFbFcFnFrFyFzG@GEGFGYGZG[G]"},
  {0,NULL,"G_G`GcGdGoGrGwGzG{HHHIHJHKHLHPHSH[HbHcHdHoHpHzI?IHIKINIRISIWIXI^I"},
  {0,NULL,"dIgIoItJ?JCJFJHJQJRJWJXJ^J_JkJwJxK?KAKBKCKEKGKIKJKLKPK]K_KiKqKrKu"},
  {0,NULL,"K{K~LCLDLELFLKLTLVLaLcLdLkLlLnLoMDMFMIMKMLMNMQM^MbMcMkMmM{N?N@NPN"},
  {0,NULL,"QNRNSNVNWNXNYNZN`NgNqNtNvOBOCOGOLOOOROTO`OeOkOmOvOwOyO}P?PAPDPEPG"},
  {0,NULL,"PHPKPOPXPaPcPjPmPqP|QEQIQKQMQPQQQTQUQWQfQgQhQlQsQtQuQzRBRJRLRRRSR"},
  {0,NULL,"WR\\R_R`RgRiRjRqRwRzR|R~SDSHSSSWSXS^S`SdShSjStSuSxS{T?TATETITJTTTU"},
  {0,NULL,"TWTXTZT\\TeTjTlT|U@UBUE_D?G?J?Q?V?W?Y?[?b?g?o?q?r?w?z@A@F@K@T@V@W@"},
  {0,NULL,"[@`@d@f@o@r@t@v@x@{ADAJAMAOAWA\\A`AaAeAiAkAlAoApArAsAuBNBTBWB\\B`Ba"},
  {0,NULL,"BlBtB{B|B}CKCLCMCPCTCXC_C`CcCfCnC~D?DEDFDMDQDYD`DbDdDfDiDjDlDmDnD"},
  {0,NULL,"oDxD}EAECEFEJELEREVE`EdEgEhEiEnE~F?FDFMFRFUFYF[F^F`FdFkFsFtFuFwGA"},
  {0,NULL,"GHGIGLGPGSGVGWGgGhGnGqGvG|HAHCHDHEHFHHHJHRH\\H^H_HhHmHrH}H~IAIBIGI"},
  {0,NULL,"LINIRITIZI]IcInIuI{JHJKJMJOJPJTJXJcJdJiJmJsJtJyJ~K@KFKHKUKWKZK\\Ka"},
  {0,NULL,"KdKeKhKpKxKzK|K~L?L@LBLKLOLPLQLWL\\LfLsLwL|L}MAMBMFMGMLMMMWM\\MaMiM"},
  {0,NULL,"oM~NBNFNINONPNSNTN\\NbNeNhNkNmNrNxN|O@OAOIONOVO[O\\O_OcOgOhOsOxOzO{"},
  {0,NULL,"O}P@PDPEPHPIPMPRPYP[P\\PrPtPuPvQ?QAQBQKQOQRQUQVQYQZQ`QaQeQoQpQwR?R"},
  {0,NULL,"ARGRIRMRPRYRZReRfRlRmRrRsR}SESFSGSISLSPSRSVS[S]SeSkSqSrSsS|S}T@TA"},
  {0,NULL,"TCTETJTUTVTWTZT[TbTeTjTmToTqTsTzUG_D?G?J?R?U?W?X?d?e?g?o?q?r?w?z?"},
  {0,NULL,"{@@@I@X@Z@[@^@_@`@f@o@r@t@v@x@z@~AHAMASATAUAXAaAeAiAkAlAoApArAsAu"},
  {0,NULL,"BNBSBVBYB_BaBkBsBxB|B}CGCKCMCOCUC_C`CeCgClCnCyC~DBDFDIDQD]DbDcDdD"},
  {0,NULL,"gDjDoDpDsDtDuDwD~EBEFEGEIELEREXEaEcEfEgEjEsE~F?FEFJFKFTFVFZF]F_Fg"},
  {0,NULL,"FlFqFrFtFvF{GHGOGTGYG[G^G`GcGeGhGiGqG{G}H?HBHGHIHNHOHXH^H_HaHdHnH"},
  {0,NULL,"sHvH{IEIFIHIKIQIVIWI[I\\IfIpIsIxJCJEJJJLJQJRJZJ`JfJhJvJyJzJ{J~K?KE"},
  {0,NULL,"KGKJKKKNKRK_KaKdKgKoKwKyK{K}LALDLILLLNLOL\\L`LaLgLjLqLvM?MCMDMHMKM"},
  {0,NULL,"NMPMYMZM[MlMrMxN@NENGNHNQNRNUNZN]NaNfNhNmNuNyN|OAOCOGONOQOUOVO`Og"},
  {0,NULL,"OhOoOqOyOzO{P@PFPIPJPKPLPNPRPVPXP[PhPqPtPvQ@QEQFQHQJQNQSQTQZQ^Q`Q"},
  {0,NULL,"fQmQpQrQtR@RARJRLRORSRXR]RbReRjRkRoRrR|S@SASCSESFSOSSSXS_SbSdSmSp"},
  {0,NULL,"SrSzS{S|T?TBTDTFTITOTPTXTYT\\T`TcTdTfTtTyT{T}UH_D?F?I?Q?U?V?Y?Z?]?"},
  {0,NULL,"f?p?r?s?t?v@C@D@G@O@S@U@V@_@c@e@s@t@u@w@yAAABAIANAPAQAXA]A`AdAfAj"},
  {0,NULL,"AlAnApArAtAuBOBTB[B]B_BbBhBiBkBnBoC?CGCNCQCRCZC]CgChCjCpCtC{DEDMD"},
  {0,NULL,"ODPDTD^D_DbDcDiDkDoDpDqDuDzE@ECEFEGEJEQEZE_EbEdEeEgEkEnEvF@FBFGFH"},
  {0,NULL,"FNFTFVF]FdFfFkFxFzF{F}GCGDGOGTGZG]G^G_GlGnGrGsGuGyGzG|HEHGHMHOHPH"},
  {0,NULL,"QH]H_HaHdHkHqHsH}IGIHIJIOIRIUIXI[I_I`InIvI~JDJHJOJQJSJUJWJ]JcJiJo"},
  {0,NULL,"JvJ|J}KCKDKIKKKLKNKPKRK_K`KaKgKmKvKxK}L@LCLFLJLLLRLVLWL[L^LmLpLvL"},
  {0,NULL,"wMDMEMFMMMQMRMSMUMZM_MiMpMyNCNDNFNLNQNSNVNWN]NdNiNjNnNuNzN~OBOFOJ"},
  {0,NULL,"OOOQOXOZOaOdOkOoOtOxO{O|PFPGPHPIPLPMPNPQPTPbPcPoP{P|P}Q@QBQGQLQMQ"},
  {0,NULL,"NQOQQQXQYQ[Q_QlQpQrQtQxRERGRIRRRWRZR\\RbRfRmRnRqRrRwR}S@SESISMSRSW"},
  {0,NULL,"S[S^S`SeSlSpSqStS|S}T@TFTGTITKTMTUTXTZT[T^T`TiTkTyTzU?UAUH_E?F?J?"},
  {0,NULL,"Q?T?V?Y?^?c?g?q?u?v?x?z?|@E@L@N@Q@X@\\@^@c@f@n@q@r@s@xA@AEAKALAQAS"},
  {0,NULL,"AUAZA_AdAeAhAmAoApArAsAtBSBUBYB[B^BdBgBjBrBsBuB~CCCECJCUC[C\\CbCdC"},
  {0,NULL,"lCrCtCwDCDKDODRD[D_DaDfDhDkDlDmDnDpDsD{D|D}ECEGEKESEUE_E`EdEeEhEk"},
  {0,NULL,"EoE|E}FEFIFOFPFQFXF\\FeFfFkFtFuF|GAGFGHGJGKGMGQGRGXGbGdGfGsGxG{G}H"},
  {0,NULL,"BHCHEHGHIHNHSHTHUH]H`HsHyH{I?IFIJIKILINIOIPI[IbIdIpIsJBJIJKJQJTJV"},
  {0,NULL,"JWJZJ]JbJiJqJsJtJwJyJ~KQKTKVKXKYK[KbKlKmKqKsKwKyK{L@LALBLDLLLXLYL"},
  {0,NULL,"ZL[LdLgLoLvLyM@MAMBMDMHMOMQMVMZMbMlMrM}NANCNDNENINPNRNXN[NbNhNkNm"},
  {0,NULL,"NrNxN}O@OAOIOMONO[O\\O_OcOhOrOsO{O|O~P?PAPBPCPHPIPMPOPSPZP]PmPsPwP"},
  {0,NULL,"xQAQBQEQFQJQNQSQTQWQXQbQjQkQqQuQvQxQ|RKRRRTRURWR\\R_RbRjRnRqRtRwRz"},
  {0,NULL,"R|S@SBSMSWSYSZS^S`ScSlSpStSuS{S~T@TCTKTLTNTPTST[T]T^T_TbTdTnTyT{U"},
  {0,NULL,"BUDUGUJ_D?E?H?R?U?V?X?]?`?h?p?u?x?y?z?}@C@G@R@Z@\\@a@b@d@g@n@p@q@r"},
  {0,NULL,"@uAAACAIALATAVAYA\\AbAgAhAmAnAoApAqArAuBPBQBRBUBVB\\BjBlBpByBzCACEC"},
  {0,NULL,"FCICPCVCWCXCdCkCrCsDADBDIDNDZD[D^D_D`DdDiDjDlDqDrDuDzE?EAEBEFEIEU"},
  {0,NULL,"EYE]EbEcEeEgEmEsEuEyFCFMFOFPFQFRF[FgFjFlF}F~G@GAGBGEGJGMGPGQGSGVG"},
  {0,NULL,"dGgGnGqGwGyGzG{G~HAHHHKHNHWH`HcHdHfHkHlHmHvICIFIJIMIOIQITIZI_IfIh"},
  {0,NULL,"IqJ?JLJNJSJTJUJVJZJ\\J`JhJnJrJsKAKBKDKTKUKWKXK[K\\K^K_KbKiKjKyKzLDL"},
  {0,NULL,"ELFLGLJLKLOLPLWLcLdLpLqLzL|MAMEMHMOMPMRMTMYM_MaMdMqM{NCNDNENGNKNN"},
  {0,NULL,"NTNYN^NbNdNgNlNsNwO@ODOEOIOPOSOWOYObOcOfOjOlOyOzO}P?P@PDPGPHPJPLP"},
  {0,NULL,"QPSPUPfPgPlPoPxQDQEQIQKQLQQQSQVQWQYQZQaQgQtQyQzQ|RCRJRLRRRSRWR\\Rb"},
  {0,NULL,"RcRkRmRrRvRyR}S@SCSESJSSSWSXS^S`SdSgSpSqSwSzS|T?TCTHTJTLTOTRTWTYT"},
  {0,NULL,"\\T]TaTbTgToT}UAUFUGUL_E?F?J?R?T?U?X?\\?_?g?o?r?s?t?y?~@?@H@N@Q@S@T"},
  {0,NULL,"@W@b@f@o@p@t@w@y@}A?AGAOAWAYAZA]A_AfAgAjAkAlApAqAsAuBOBRBWB^B`BdB"},
  {0,NULL,"fBnBqBtBwC@CBCDCQCTCYCZC^CcCiCpCsCvC|DHDNDTDVD_DeDgDhDlDnDpDrDsDt"},
  {0,NULL,"DyD|D~EAEBEMEQETEYEaEcEeEfEmEtE|E}FDFGFHFLFNFSFWFaFjFlFqFtFyF{GGG"},
  {0,NULL,"HGNGUGZG\\G]G_GaGbGsGtGwG|HCHDHEHFHHHIHNHQHSH`HeHgHmH|H~I@IHIIIMIR"},
  {0,NULL,"ITIVIXIZIcIiIlIuJBJFJJJOJRJSJUJXJ\\JeJhJpJvJxJyJ{J~KIKLKMKOKPKSK`K"},
  {0,NULL,"bKfKkKqKxKyK{K|L?L@LBLKLMLYL[L]LcLfLuL{L|MCMEMIMKMLMMMRMWMaMeMhMo"},
  {0,NULL,"M}NHNJNNNQNSNTNVN]N`NcNfNhNmNpNuNyN|OCOGOQOUOVO^O`OgOoOpOqOzO|O~P"},
  {0,NULL,"?P@PAPBPCPJPLPPPTP^PaPiPjPnP}Q?QAQBQKQOQRQSQTQXQgQiQjQnQuQ{Q|Q}RE"},
  {0,NULL,"RKRRRTRURWR\\R`RcRhRmRsRvRyR}R~SJSLSNSWSYSZS^S`ScSgShSkSqSvSwT?TFT"},
  {0,NULL,"KTLTQTTTVT\\T]T^T`ThTlTmToTpTqTrUHUIUK_E?G?I?Q?V?X?Y?`?a?f?o?p?s?u"},
  {0,NULL,"?y?}@B@J@P@Y@Z@\\@b@d@e@o@p@q@u@w@|ACAFALARATAYA\\A^AfAgAkAmAnArAsA"},
  {0,NULL,"tAuBRBUBVBZB\\BcBpBvBwBxByCACBCHCICOCVCWC^CaCeCoCrCsD?DNDSDYD[D^D`"},
  {0,NULL,"DaDcDdDhDjDqDsDuDvD}EEEFEGEPEUEVEYEbEeEgEhEiEoEzE{FFFJFKFLFSFWFZF"},
  {0,NULL,"`FeFkFqFxFzG?GCGDGNGUGYG[G\\G`GaGeGhGiGxG|G~H?H@HCHGHKHLHSHVH[H\\Hb"},
  {0,NULL,"HpHrHwH{IAIFIIIPITIUIXI]I^IaIpIrIzJDJIJJJPJUJVJXJbJdJiJoJuJ{J|J}K"},
  {0,NULL,"CKEKGKJKMKOKSK]KhKnKqKrKuKxLBLELGLHLILLLNLXL\\L]L`LgLlLrLsL}M@MCML"},
  {0,NULL,"MOMRMSM\\M^M`MlMnM|NANENJNLNONTNVNWN_NfNiNjNnNuNzO?OBOFOHOJOOOQOXO"},
  {0,NULL,"aOdOkOoOuOwOyO{O}O~PHPIPJPKPMP^P_PdPePiPkPyP~QAQCQDQHQIQNQOQPQ^Q`"},
  {0,NULL,"QbQmQnQsQuQwRBRDRKRMRPRTRURYR_ReRjRlRsRtRzR|SBSFSGSLSPSVSYSZS]ScS"},
  {0,NULL,"kSrSsSuS{S~T?TBTCTHTKTRTUTZT\\T^TaTbTcTgTsT{T~U@UGUN_E?G?I?S?T?W?X"},
  {0,NULL,"?\\?e?f?q?r?v?w?x?~@@@H@O@P@X@Z@_@`@e@n@s@t@v@x@}@~AGAMAPARATAUAXA"},
  {0,NULL,"dAeAhAiAlApAqAtAuBNBSBVB]B_BcBkBmBrBzB|B~CFCGCMCSC[C`CgCkCmCwCyC~"},
  {0,NULL,"DDDJDKDQD]D^DaDdDeDgDjDrDsDtDuDyE?E@EBEEEKEOEREXEaEcEfEhEqErEzE{F"},
  {0,NULL,"BFIFMFRFXF[F\\FcFhFoFsFxFyFzG@GFGKGPGRGSGVGXGaGmGpGvGxGzG|G~HEHGHL"},
  {0,NULL,"HMHOHVHWH\\H`HfHjHkHqI@IBIDIKILIOIRIVI_I`IiIjIvIzJEJFJKJMJOJWJZJ_J"},
  {0,NULL,"aJjJwJxJ}K@KBKCKQKUKVKWKYK\\K^KbKhKjKnKuKvKxK}L@LFLGLLLQLSLULXL]Li"},
  {0,NULL,"LmLpL{M?MBMGMHMIMMMQMUM_MeMfMpM|NBNDNHNINMNRNSNWNXN\\N`NgNnNqNsNvN"},
  {0,NULL,"xN~OLOPOROZO[OjOmOsOtOvOwOyO}O~PCPDPFPGPJPKPOPYP`PaPjPmPrPzQ@QBQD"},
  {0,NULL,"QGQNQOQPQQQ]QbQdQeQnQwQyQ|RCRDRKRMRPRTRURYRaRhRmRnRpRvRyR{R}S?SMS"},
  {0,NULL,"NSPSVSYSZS]ScSlSnSoSqSvSwTATBTCTDTITOTSTXTYT_TbTcTfTjTrTvU?UAUIUK"},
  {0,NULL,"UL_D?G?J?Q?V?W?Y?[?b?g?p?t?u?v?y@A@F@L@N@Q@X@]@^@a@f@p@q@s@u@y@{A"},
  {0,NULL,"DAKASAUAVAZA_AcAdAgAjAmAnApAqAsAtBQBSBXBYB^BdBgBjBqBrBuB~CCCDCECJ"},
  {0,NULL,"CYC[C\\CbCdCqCuCzDADGDUDXDZDaDbDcDfDgDjDkDmDtDuD{D|E@EEEGEHEWE[E]E"},
  {0,NULL,"`EdEgEhEiEnE~F?FDFMFRFUFYF[F^F`FdFmFqFzF{F}G?GDGIGLGPGSGVGWGcGmGp"},
  {0,NULL,"GqGvG|H?HDHFHHHIHNHOHRHXHZH^HcHiHoH|I@IAICIJILIMISIXIeIgIiIlIuIxJ"},
  {0,NULL,"FJHJIJNJTJUJYJcJdJgJuJvJ{J|KCKDKFKHKUKWKZK\\KdKiKoKpKtKxKyK{K|K}L?"},
  {0,NULL,"LILKLOLQLSLULaLhLkLuL{L~M@MAMFMIMRMTMXMcMeMhMoMxN?NCNINKNNNONVNWN"},
  {0,NULL,"]N_NdNfNjNpNwNzN~O?OHOWOXOZO^OaObOpOtOuOxOyO{O|O}O~PFPIPKPNPQP_Pc"},
  {0,NULL,"PdPkPoPyP|Q?Q@QHQKQOQRQSQTQZQ]QdQeQfQzR?R@RARFRJRLRORSRXR]R`RaRdR"},
  {0,NULL,"gRiRvRyR~S?SDSHSKSOSSSXS_SbSdShSiSjSoSwSxTGTKTNTOTPTRTSTYT^T_TdTg"},
  {0,NULL,"TkTnTpTrTuT|UMUN_E?F?J?R?T?U?X?\\?_?g?q?u?v?x?z?~@?@I@O@P@X@[@^@`@"},
  {0,NULL,"f@n@q@r@s@x@}A?AHAMAPARASAUAaAdAeAhAmAoApArAsAtBNBSBYB]BaBcBkBrBs"},
  {0,NULL,"BxB}B~CGCKCOCUC[C_CeCgClCwCxDCDDDJDKDRD\\D^DaDdDeDkDoDpDqDrDsDwE?E"},
  {0,NULL,"DEFEGEKEOESE\\EaEcEeEfEmEtE|E}FDFGFHFLFNFSFWFaFjFpFuF}F~G?GAGEGNGU"},
  {0,NULL,"GZG\\G]G_GfGlGsGtGuG|H?HAHDHFHHHJHOHSHUH[HbHeHiHoHrH}IBICIGIIIQISI"},
  {0,NULL,"VI]IeIgInIuIwJEJMJNJPJRJSJYJ\\JeJlJrJsJtJuKAKDKIKLKMKOKPKSK]KfKlKq"},
  {0,NULL,"KrKxKzK|K}K~L?LILKLMLRLZL[L^LhLkLsLwL}L~M?MEMGMKMTMXM\\McMiMoMvN?N"},
  {0,NULL,"BNFNGNHNJNKNYN_NbNdNkNlNtNzN}O@ODOIOMOTOXOYOaOcOeOlOrOwOyP?PBPGPH"},
  {0,NULL,"PJPLPMPNPSPUPWP]PgPpPwPxQ?Q@QHQKQOQRQUQVQXQ[Q_QiQkQqQsQuQ{RBRHRNR"},
  {0,NULL,"QRVR[R^RdRfRgRlRqRtRwSBSDSGSISKSQSTSUS\\SaSfSiSjSsStS}S~TBTDTETHTI"},
  {0,NULL,"TMTOTXTYTaTcTeTfTiTsTuTzT|UIUQ_E?F?J?Q?T?V?Y?^?c?g?o?r?s?t?y?|@E@"},
  {0,NULL,"K@M@R@T@W@[@`@f@o@p@t@w@yA@AEAJAMAOAWA[AaAbAfAgAjAkAlApAqAsAuBNBP"},
  {0,NULL,"BWB`BaBeBfBlBtB{B|C@CLCMCPCTCXC`CcCfCiCvC|C}D@DHDLDVDWD^DaDbDeDjD"},
  {0,NULL,"kDlDnDqDrDxE@EAEEEFEMENETE^E`EdEeEhEkEoE|E}FEFIFOFPFQFXF\\FeFfFmFq"},
  {0,NULL,"FxF{F}G?GCGJGKGMGQGRGXGbGfGjGkGtG{G}H?HAHBHGHJHOHUHWH`HeHfHjHnHtH"},
  {0,NULL,"vIAIDIEIJINIUIWI\\IfIjImIsIwJCJDJGJHJIJKJLJ]JbJgJoJuJvJ{J}KDKQKTKV"},
  {0,NULL,"KXKYK[K^KbKfKjKlKwKzK}K~LALDLILLLMLYLZL_LbLiLjLqLxM@MBMFMJMNMPMSM"},
  {0,NULL,"YM[MfMjMrMvN@NCNLNMNONPNUN]N_NdNfNiNnNpNuNwN~O?OHOQOWOZO^ObOoOpOt"},
  {0,NULL,"OuOwOxO|O}O~PGPHPJPLPMPTP^PbPePiP{P}P~Q@QEQFQHQJQNQUQVQ\\QcQiQjQkQ"},
  {0,NULL,"qQyQ{Q|RCRHRNRQRVR[R^RcRhRkRoRpRuRxR{SASCSJSNSQSTSUS\\SaSfSgSmSnSv"},
  {0,NULL,"SySzTATDTETGTJTRTUTWTZTeTfTgTjTkTtTvT}UCUJ_D?F?I?S?T?U?W?_?d?f?p?"},
  {0,NULL,"r?s?t?v?{@?@I@Q@S@T@U@Y@b@e@s@t@u@w@y@zA?AHANAOAYAZA]A^AdAfAjAlAn"},
  {0,NULL,"ApArAtAuBOBRBZB^B`BbBgBhBnBpBtC?CICJCQCTCVCZCbCcCjCpCuC{C|DHDPDTD"},
  {0,NULL,"UD_DdDfDiDlDoDpDrDsDtDwD}E?EBECEMEQEZE[EaEcEdEfElEpEvF@FFFOFPFQFU"},
  {0,NULL,"FYF^FbFiFoFrFsFxFzGEGFGIGJGLGMGQGWGgGjGnGqGuG}G~H?H@HCHDHKHLHTHUH"},
  {0,NULL,"ZH]HaHlHrHuH{IAIDIEIIIKIMISI]IhIkIpIrI}JCJFJGJIJJJMJNJ[J^JjJwJ}K?"},
  {0,NULL,"K@KAKCKFKHKTKXKZK[KgKlKmKsKtKuK|LALBLELGLHLILOLPLRLWLbLeLgLsLzM@M"},
  {0,NULL,"CMGMIMJMNMTM\\MdMgMlMnMwN?NJNMNNNONRNUNWNXNYNZN\\NnNqNsNxN~OBOOOPOR"},
  {0,NULL,"OZO[OjOkOsOtOvOzP?PAPCPDPEPFPGPHPIPWPXPbPcPpPqP{P|Q?QAQCQDQFQHQIQ"},
  {0,NULL,"PQYQZQ[Q\\QaQqQrQvQxRFRHRORXR[R]R^RbRdReRfRkRtS@SBSCSFSISKSOSTS\\S_"},
  {0,NULL,"SbSfSiSpSrSzS}S~TATLTQTRTSTTTVT]T_TgThTjTlTmTsTwT{UFUOUQUS_D?F?I?"},
  {0,NULL,"Q?U?V?Y?Z?]?f?o?u?w?x?z@C@D@J@P@R@Y@Z@a@b@e@n@o@q@r@vAAABAFARATAV"},
  {0,NULL,"AYA^AbAhAiAkAmAoAqAsAtAuBPBQBRBVBZBcBvBwBxByBzCACBCFCHCOCWC^CaCeC"},
  {0,NULL,"kCxD@DADBDIDLDZD\\D_D`DcDfDhDiDlDqDrDtDvD|D}EAEEEIENE\\E]EbEdEeEgEk"},
  {0,NULL,"EnEvF@FBFGFHFNFTFVF]FdFfFmFsFuFwF|GFGHGOGTGZG]G^G_GcGjGoGrGuGzG}G"},
  {0,NULL,"~HDHEHLHMHOHQHZHaHeHgHjHxHzI@ICIFIGILIUIVIWIYIiIjIoIvI}JEJKJLJPJQ"},
  {0,NULL,"JUJYJ]JcJgJmJqJtJwJ~K@KIKKKLKNKPKRK`KfKgKkKtKuKvK|K}L@LALFLGLRLTL"},
  {0,NULL,"VLaLbLiLnLtL{L}L~M?MBMDMPMRM]MeMfMkMpMwN@NENFNHNINKNLNXN[N\\NeNhNk"},
  {0,NULL,"NrNvN{N|N}OKOLOMOVO\\O_OgOmOnOrOxOzO|O}O~P?PAPEPHPIPRPZP\\P]PsPuPvP"},
  {0,NULL,"wQ?Q@QBQDQFQGQPQQQ[Q\\QfQhQlQrQ{Q}RERFRHRORXR[R]R^R`RaRgRhRoRuRxR~"},
  {0,NULL,"S?SASDSNSOSTS\\S_SbSfShSjSmSoSvSyT?TCTETHTPTQTRT\\TaTbTdTeTgThTrTvT"},
  {0,NULL,"xUEUJUPUR_D?E?H?R?U?V?X?]?`?h?q?r?s?t?w?}@C@J@M@O@U@V@]@c@g@t@v@w"},
  {0,NULL,"@x@yAAACAFANAPAQA[A`AcAeAfAiAjAlAqArAsAtBTBXB[B]BbBeBhBmBoBuB{C?C"},
  {0,NULL,"CCLCNCSC\\CfChCjCmC{C}DDDEDJDMDPDWD_D`DcDgDhDkDmDpDqDuDvD|D~EDEGEJ"},
  {0,NULL,"EOEZE^EbEcEeEgEmEsEuEyFCFMFOFPFQFRF[FgFjFpFqFrFvFyGGGHGJGMGPGQGSG"},
  {0,NULL,"VGdGfGgGoGxGyG~H@HAHBHFHMHNHRHWHZHbHcHiHwHxHyIAIDIEIGIOITIVIYIaIb"},
  {0,NULL,"IeIqI|JDJJJKJLJMJNJOJ\\J`JlJpJxJzJ{J~K?KTKUKWKXK[K\\K]K^KiKpKtKvKwK"},
  {0,NULL,"yKzL?LGLHLJLPLTLXLZLdLhLrLtLyMBMCMGMMMPMSMTMVMXM]M`MqMuNDNFNHNMNO"},
  {0,NULL,"NTNUNZN`NaNcNfNhNoNpNqOAOCOGONORO]O^O`OhOiOpOvOyO{O|P?P@PAPBPKPLP"},
  {0,NULL,"NPRPXP^PaPiPjPqPvQCQDQGQJQLQRQSQVQWQaQbQhQkQsQyQzR?RFRHRMRPRYR[R^"},
  {0,NULL,"R_RaRgRlRtRuRxRzS?SBSDSGSPSTSVS\\S]SfSjSoSsSuSyS~T@TDTFTGTMTSTVT[T"},
  {0,NULL,"_T`TfTiTkTmTuTxT~UDUIUPUSUT_D?E?H?S?T?V?W?[?^?h?p?u?x?y?z@A@E@K@Q"},
  {0,NULL,"@X@\\@]@a@c@g@n@p@q@r@u@{AEAJALAQAUAVAZAcAgAhAmAnAoApAqArAuBQBSBUB"},
  {0,NULL,"XB[B^BiBjBqBsByCACDCECRCUCWCYC]CdClCrCuCwDADKDUDZD[D_DbDgDjDkDlDm"},
  {0,NULL,"DnDpDuDxD~E@EBECEKEUE[E]E`EcEdEhElEqEuEyFAFGFHFJFKFNFZFbFcFoFvFwF"},
  {0,NULL,"~GBGCGGGYGZG[G]G_G`GaGgGoGtGwH@HBHFHIHJHLHMHPHWH_HaHbHdHnHqHuH~IB"},
  {0,NULL,"IIILIPISIUIWI\\I`IcIkItI|JEJGJIJPJWJXJYJ^J_JjJmJnJoJpJrJzKEKGKIKJK"},
  {0,NULL,"LKPK]K^K_KaKgKuKvKwK{K~L?LCLHLMLPLTL]LcLeLfLjLmL}L~M?M@MJMLMQMUMW"},
  {0,NULL,"M[MgMmMuN?N@NANBNINJNLN^NaNcNeNiNlNyN{ODOEOFOJOKOSOUOYOdOfOlOnOqO"},
  {0,NULL,"{O|P@PAPCPDPFPGPKPLPUP\\PePfPgPlPuP~QCQGQJQMQPQRQTQUQaQgQhQiQnQpQr"},
  {0,NULL,"QsQtQyRHRMRPRYR[R^ReRfRhRkRmRpR{R}SCSFSISNSPSTSVS\\S]SfSnSqSrSvSzS"},
  {0,NULL,"}TBTKTMTNTPTQTST^T_TcTdThTiTnTqTtTwU?UOURUU_F?G?H?S?T?W?Y?b?c?h?o"},
  {0,NULL,"?s?w?y?z?|@F@L@M@R@T@V@`@d@g@o@p@r@v@wA@ADAKAMAOA[A\\A`AbAfAgAiAkA"},
  {0,NULL,"oApAqArAtBNBPBTB\\B`BeBfBlBoBvB}C@CHCKCNCPCXC_CaChCiC|C~D?D@DHDLDQ"},
  {0,NULL,"DYD^DaDbDeDfDiDkDmDnDoD{E?E@ECEDEMENEREVE`EdEfEhEpErEwExFCFLFSFTF"},
  {0,NULL,"VFWF]FhFiFoFvF|F~GBGDGGGNGOGTGUG\\G^GeGlGmGsGuGyG{G~H@HAHHHMHNHTHV"},
  {0,NULL,"HXHYHgHiHkHlHyIAIFIMIPIRIVIWI_IbIeIhIqIyJCJJJKJUJXJYJZJ[JaJjJnJpJ"},
  {0,NULL,"qJrJzJ|KKKMKNKOKRKSKcKkKnKoKsKvKyKzLDLGLHLJLKLRLSL[L^L`LhLpLyLzL~"},
  {0,NULL,"MBMCMHMLMNMRMVMXM_MdMqMzN@NANENHNNNONSN[N^NaNcNjNlNoNyN{ODOFOJOKO"},
  {0,NULL,"UOYO]OdOiOlOnOqOwOxPBPCPDPEPFPGPMPNPPPVPZPdPhPkPnPsQCQDQEQGQKQLQS"},
  {0,NULL,"QVQXQ[Q^Q_QdQvQ}Q~R@RDRKRORTRURXR]RaRbRdRnRtRvRyS?S@SBSKSMSOSYSZS"},
  {0,NULL,"_SbScSiSlSoSpSwS~TATBTETFTJTQTUTWTZT`TcTeThTjTuUAUDUFUJUMUNUOUUUV"},
  {0,NULL,"_F?G?H?R?U?X?Y?Z?a?h?p?q?t?v?x@B@D@J@M@S@V@]@_@c@g@n@s@u@x@y@|ABA"},
  {0,NULL,"FAQAXA[A]A`AcAdAeAhAjAnAqArAsAuBOBTBXB[B_BeBhBiBmBuB{C?CCCLCRCSC\\"},
  {0,NULL,"C]CfCjCmCpCqCtCyDODTDXD]D^D`DbDcDeDhDiDnDoDqDvD~EAEDEFEQEWEXE_EbE"},
  {0,NULL,"eEfEgEjEtEwExFAFIFUFXFYF\\F^F_FaFlFuF~G?G@GBGEGIGKGLGRGWGXGbGeGjGk"},
  {0,NULL,"GmG{H@HHHIHJHLHMHPHTH\\H^HgHhHnHpHzH~ICIEIIIKILIOIXI\\I^IcIoItIyJEJ"},
  {0,NULL,"FJIJNJOJQJVJeJfJhJnJrJtJuKAKBKFKHKQKVKYKZKdKeKhKkKsKuKvK{K~LCLDLH"},
  {0,NULL,"LKLSLYL_L`LbLfLjLlLnM?M@MDMIMMMOMTMWM[M^MkMmMzNDNINJNKNRNUNVNYN^N"},
  {0,NULL,"_NgNkNlNsNtNwO@OEOIOPOSOTOWObOcOeOfOjOwOxOzP@PBPEPJPLPMPNPWP]P_P`"},
  {0,NULL,"PpPwPyPzQCQEQGQKQMQPQTQUQ\\Q^QcQdQjQoQvQwQ}RARKRORTRURXR]R`ReRhRjR"},
  {0,NULL,"oRsR|R~SASFSLSNSOSYSZS_SbScShSkSmSrSvS{T@TATFTGTLTMTOTYT[T]T`TiTj"},
  {0,NULL,"TkTqTtU@UEUHULUPUQUTUW_E?G?I?Q?V?X?Y?`?a?f?q?r?v?w?x?}@B@G@M@O@S@"},
  {0,NULL,"U@]@_@e@n@s@t@v@x@|ACAIANAPAXA[A]AcAdAeAhAiAlApAqAtAuBOBXB]B_BbBe"},
  {0,NULL,"BiBkBmBnBoCGCNCQCRCSCZC]CgChCmCqCyC}DDDJDWDXD]D^D_D`DeDgDhDiDmDnD"},
  {0,NULL,"uDzD|E@EAECEOEWEXE^EbEeEgEhEiEoEzE{FFFJFKFLFSFWFZF`FeFmFsFtFwF|GA"},
  {0,NULL,"GFGNGUGYG[G\\G`GaGiGpGtGwGyG}H?H@HCHDHKHPHVHXHYH[HfHlHtHuH|IEIFIGI"},
  {0,NULL,"NIQISIXIhIkIlImIrJAJCJDJNJPJQJRJTJbJdJgJmJqJsJwJyK@KEKGKJKMKOKSKc"},
  {0,NULL,"KjKnKoKrK|LALBLCLELHLILJLMLNLUL]LcLeLuLxLzL}MAMDMKMNMSMTMdMgMhMjM"},
  {0,NULL,"nMtN?NENFNGNPNUNVNXN[N\\NbNeNmNvNxN{N|N}OKOLOMOVO[OgOmOnOrOsOxO{O|"},
  {0,NULL,"O}O~P@PBPCPDPMPOPSPYP[PmPrPtPxQ?QAQCQFQHQIQLQMQ]QgQiQmQnQ~R@RBRCR"},
  {0,NULL,"DRJRLRNRQRSRVRcRdRiRkRpRvRyR{SCSHSJSKSQSSSUSXSaSdSgSiSnSwSxSzT@TE"},
  {0,NULL,"TFTGTMTPTTT[T`TdTeTiTkTlTpTwUCUFUGUHUJURUT_E?G?I?S?T?W?X?\\?e?f?o?"},
  {0,NULL,"p?s?u?y?~@@@I@N@S@U@W@Y@b@e@o@p@q@u@w@}@~AHANAWAYA]A^A_AfAgAkAmAn"},
  {0,NULL,"ArAsAtAuBOBRBWBZBbBdBgBhBpBtBwC?CBCICJCTCVC^CbCcCjCoCsCvCzDGDNDSD"},
  {0,NULL,"VD`DdDeDgDhDmDnDoDpDsDwD}D~ECEDEHEPETEYEaEcEfEhEqErEzE{FBFIFMFRFX"},
  {0,NULL,"F[F\\FcFhFnFvFwF|F~GCGDGKGPGRGSGVGXGdGfGiGpGxGyGzG}HDHEHMHOHPH[H\\H"},
  {0,NULL,"^HfHhHsHxHzH}IBICIDIHIJIMIWIYI[InIoIvJAJFJGJHJLJSJYJZJ_JaJkJmJoJq"},
  {0,NULL,"JrJzJ|KQKUKVKWKYK\\KdKeKhKjKrKvK|K}L@LALCLFLJLNLULXLZLdLnLtLvLwL~M"},
  {0,NULL,"EMFMHMIMJMPMZM]MiMkMpMtN@NBNCNKNMNNNQN[NaNeNiNjNlNoNrO?OEOFOHOJOS"},
  {0,NULL,"O\\O]O_OdOfOiOuOwO{P@PAPBPCPDPEPKPMPUPVPdPePgPhPkP~Q?Q@QBQFQGQLQMQ"},
  {0,NULL,"QQWQ]QbQkQmQoQwRARBRCRJRLRNRQRSRVRgRjRlRoRqRrRwR|SASDSESGSQSSSUSX"},
  {0,NULL,"SaSdSjSmSsStS{S|TGTJTLTNTQTTTVTWT]ThTkTlTmTnTxTyTzUEUKUMUQUSUU_D?"},
  {0,NULL,"G?J?R?U?W?X?d?e?g?p?t?u?v?y?{@@@H@N@Q@T@U@W@Y@f@p@q@s@u@y@z@~AGAN"},
  {0,NULL,"AOAWAZA^A_AdAgAjAmAnApAqAsAtBWBZB^B`BbBdBfBgBnBqBwC@CBCDCJCQCYCZC"},
  {0,NULL,"^CbCiCoCuCzC{DGDPDSDUD`DdDeDfDgDiDmDoDrDtDyD|E?EAEDEHEPEZE[EaEcEf"},
  {0,NULL,"EgEjEsE~F?FEFJFKFTFVFZF]F_FgFpFuF}G?G@GAGBGOGTGYG[G^G`GcGhGoGrGvG"},
  {0,NULL,"{G}HAHBHCHEHGHJHRHVHXHYH_HjHtHyI?IDIHIIIOIPIQIUIbIdIjImIsI{JDJEJG"},
  {0,NULL,"JJJSJVJWJ`JfJlJnJsJtJuKBKDKEKGKJKKKNKRKaKcKnKoKpKwKzK~L@LALBLDLLL"},
  {0,NULL,"QLTLVL\\LaLiLoLxLyM?MCMEMJMOMQMSMVMbMfMjMrM~NANDNGNJNLNMNQN^N_NbNd"},
  {0,NULL,"NgNkNtNwNzN}ODOMOTOWOXOYOaObOeOlOrOxOyOzO}P?P@PBPDPEPNPQP_P`PfPlP"},
  {0,NULL,"oPyPzQAQBQEQFQJQNQUQVQ`QeQfQhQlQpQ~R?R@RDRGRIRMRPRYRZR_RaRiRnRpRu"},
  {0,NULL,"RxRzR{S?SHSMSPSRSVS[S]SeSlSnSoSuSxSyTHTLTMTQTTTUTVTZT]TaThTiTlTmT"},
  {0,NULL,"vUBUCUDUKULUOUSUW_F?G?H?R?U?X?Y?Z?a?h?o?s?w?y?z@B@D@G@P@R@Y@\\@a@d"},
  {0,NULL,"@g@o@p@r@v@w@|ABAIALARAVA\\A^AbAfAgAiAkAoApAqArAtBPBQBUBZB\\BcBjBlB"},
  {0,NULL,"pBvBzCECFCHCICPCVCXCaCdCkCoCxD?D@DLDSDYD\\D^D_DaDcDfDhDiDsDtDuDzD|"},
  {0,NULL,"E?EBEGENEPEVE\\EbEeEfEgEjEtEwExFAFIFUFXFYF\\F^F_FaFpFrFtFvFyF{GGGIG"},
  {0,NULL,"KGLGRGWGXGkGlGmGpGvGzHBHFHIHJHKHLHPHTHUHYH]HhHoHqHuI?IBICIEIHINIT"},
  {0,NULL,"IUI`IdIgIkItJ@JGJHJLJOJPJRJVJeJfJlJpJvJxJyJzK?KFKHKQKVKYKZKcKeKlK"},
  {0,NULL,"mKsKuKwK{K~L?LCLELFLQLSLUL^L_LeLkLmLoL}MFMJMKMMMOMPMUMbMcMgMmMsNB"},
  {0,NULL,"NKNLNPNQNTNUNZN]N`NaNcNmNoNpNqNyOAONOROUO]O^OhOiOpOqOvOyOzO~P?PBP"},
  {0,NULL,"CPFPIPJPNPPPTPVP[PhPnPtP}QIQJQMQPQQQRQTQUQ]Q_QcQdQeQoQqQvQxQ~RGRI"},
  {0,NULL,"RNRQRVRZRdRfRiRnRpRqRwR{SHSISKSMSQSRSUS[SaSeSiSlSnStSxS}T?TCTDTHT"},
  {0,NULL,"NTRTVT\\TaTbTfTgTmTnTwT|U?UBUGUHUIUSUWU[_F?G?H?S?T?W?Y?b?c?h?p?q?t"},
  {0,NULL,"?v?x?|@F@K@N@\\@]@^@a@c@g@n@s@u@x@yA@ADAJALAQASAVA_AcAdAeAhAjAnAqA"},
  {0,NULL,"rAsAuBQBUBXBYB[BdBiBqBsBuByCACCCDCRCUCWCYC\\C]ClCqCtCzDCDGDODRDXDa"},
  {0,NULL,"DbDcDfDhDjDlDnDsDtDxD}D~EBEEEHESEWE_E`EdEfEhEpErEwExFCFLFSFTFVFWF"},
  {0,NULL,"]FhFiFnFrFsFxFyG@GEGNGOGTGUG\\G^GeGhGiGkGlGyGzG~HAHBHFHKHNHQHYHeHg"},
  {0,NULL,"HhHmHvHwHxIDIGIJIPIQIRISIYIZIaIfIqJ@JCJDJMJSJTJWJYJ[JaJkJxJ}K?K@K"},
  {0,NULL,"AKBKKKMKNKOKRKSK`KcKeKfKkKwKyKzL?LELFLGLJLNL\\L^L_L`LqLrLtL|L~MAME"},
  {0,NULL,"MGMNMQMSMYM]M`MaMqMsN?NANCNFNGNMNSNYNZN\\N`NgNnNsNtNvOBOCOGOLOOOPO"},
  {0,NULL,"TO`OeOjOkOmOwOzO~PAPCPEPFPIPJPKPWPYP`PbPpPrPzP{QDQIQJQLQQQRQSQVQ^"},
  {0,NULL,"Q_Q`QcQmQoQ{Q}Q~RERGRIRNRQRVRZRcRlRoRrRsRuRxSASESGSJSLSQSRSUS[SaS"},
  {0,NULL,"eSgSkSmSsSyS|THTITKTNTPTSTTTXT^T_TaTdTlTnToTxT}T~UKUMURUVUZU\\_D?F"},
  {0,NULL,"?I?S?T?U?W?_?d?f?o?u?w?x?z?{@?@H@O@P@Z@[@^@_@g@i@j@l@n@uADAEAJALA"},
  {0,NULL,"SATAZA]AcAfAiAsAxAzBCBHBKBLB\\B`BaBbBcBeBoBtBuBzB|C@CDCECICOCPCQCS"},
  {0,NULL,"C[C]CbCfCkCnCqC}DCDGDIDMDRDSDTDYDcDeDgDqD{E@ELETEUEYEZE\\E_E`EkElE"},
  {0,NULL,"mEoEqEuExFAFJFNFOFQFZF[F_F`FdFhFiFlFmFnFpGKGLGNGOGWG\\GcGkGmGnGxH@"},
  {0,NULL,"HBHCHEHHHWH\\H]HcHeHoHpHvHwIGIHIMINI[I\\I^IaIeIiIjIlImInIqIyIzI|I~J"},
  {0,NULL,"GJQJSJTJ_JaJjJoJpJrJsJtJvKGKJKKKMKOKPK]K^K_KaKdKeKfKpKwK{K}L?LCLP"},
  {0,NULL,"LQLULXL]LeLfLhLiLmLqLxM?M@MLMMM\\MdMgMlMpMwN@NENFNHNINKNLN^NaNdNhN"},
  {0,NULL,"jNmNpNtNuN}OCOGOTOVOWOXOdOfOiOsOtOyO}O~PJPOPRPSPYP[P]P^P_P`PaPpPq"},
  {0,NULL,"P{P|Q@QEQKQLQVQWQXQ^Q_QdQfQjQkQvQwQ|RCRDRGRJRQRSRVR\\R_RjRlRqRrRsR"},
  {0,NULL,"yR}S?S@SBSMSVSZS^SaSdSeSlSnSqSrSvS}TFTGTKTMTQTRTUTWT^TaTmToTpTwTz"},
  {0,NULL,"UBUDUEUHUJUPURUTUUU^_D?E?H?S?T?V?W?[?^?h?q?r?s?t?w@A@E@L@M@R@V@W@"},
  {0,NULL,"[@d@e@i@j@m@n@v@~A?AGARAUAVAXA[AaAfAnAsAvAwA|A~BIBJBOBTBUBWBZB^Bf"},
  {0,NULL,"BoBpBqBxB~CECGCHCJCLCQCRC^C_ChCkClCnCoCvCxDFDNDODRDTDWDZD`DaDfDqD"},
  {0,NULL,"wE?EHEIEJETEUEWEXEaEiEjEqErEsEvE{FBFIFKFLFMFZF\\FaFbFfFiFjFkFmFnFp"},
  {0,NULL,"GIGQGTGWGZG]GeGfGrGuGwHDHGHIHLHNHRHVH[HdHgHpHtHzH}IHIJISITIZI]I^I"},
  {0,NULL,"bIdIeIfIgIjIoIrIyIzI}J?JLJRJTJWJ[JaJjJyJ~K@KBKCKDKHKUKVKYKZK[K`Kb"},
  {0,NULL,"KfKhKjKnKpKqKxKzK}LFLLLSL[L]L^L`LmLoLpLsLxLyL{M?MBMIMRMUMWM[MgMqM"},
  {0,NULL,"uNDNFNHNMNONTNUNXNYN]NbNfNnNrNwNzO?OAOHOIOMO\\O^OjOkOlOmOqOxPBPMPN"},
  {0,NULL,"PPPRPTPVPZP[P]P^P_PdPgPlPuP~Q?QAQFQIQVQYQZQ[Q\\Q`QfQkQmQrQvQ}Q~R@R"},
  {0,NULL,"GRJRNRVRWRZR`RcRjRoRrRsRyS@SBSCSFSKSUSWSZS_SdSeSlSoSpSqSvSwTCTHTL"},
  {0,NULL,"TMTOTRTSTYT[T^TlToTpTxTyT{T|U?UGUIUSUVUWUXU[_E?G?I?Q?V?X?Y?`?a?f?"},
  {0,NULL,"o?p?s?u?y?}@B@J@P@Y@Z@\\@b@d@f@h@k@m@o@t@{A@AJAOAXAYA[A\\AaAdAmArAz"},
  {0,NULL,"A|A}B@BCBEBUBXBYBZB]B^BiBrBwByB}C@CCCDCICLCOCQCSC^C`CaChClCnCrD?D"},
  {0,NULL,"CDKDMDNDPDUDYD]DcDdDqDsD{EEEMEOEPEQEREUE_E`EkEoEpErEtE|E~FEFLFNFP"},
  {0,NULL,"FQFSFXF`FbFcFdFgFkFlFnFpGIGLGOGVGYG`GaGcGdGhGuH?H@HAHIHMHSHVHaHeH"},
  {0,NULL,"hHmHrH{I?IBIOIPIXIYI]I^I_I`IaIfIgIoIpIuIwIxIzI}JDJOJXJZJ]JcJgJpJu"},
  {0,NULL,"JvJzJ}KBKFKHKTKVKWK[K]K^K_KaKbKeKfKlKzK~LDLFLLLMLRLTLVLbLiLjLkLrL"},
  {0,NULL,"tLxL|M?M@MNMPMdMgMhMjMpMtN@NBNCNKNMNNNQNWN^N`NdNfNlNoNsNtO@OAOGOI"},
  {0,NULL,"ONOROSOaOmOnOoOtOzP?PAPEPPPRPUPVPWPXPZP\\P]PfPmPrPtPxQOQQQRQSQTQWQ"},
  {0,NULL,"XQZQ^Q_QdQeQfQrQ}R@RERFRGRIRKRWRYR\\RbReRfRmRnRtRyR~S?SDSKSNSOSPSR"},
  {0,NULL,"S`ScSfSmSnSoSvSySzTATDTGTITOTSTTT^TiTjTmTqTuTyU?U@UCUDUIULUMUUUZU"},
  {0,NULL,"[U]U__F?G?H?R?U?X?Y?Z?a?h?p?q?t?v?x@B@D@J@M@S@V@]@_@c@f@h@k@l@p@y"},
  {0,NULL,"@z@}AGAWAZA]A^AbAcAeAoAuAwBABDBEBHBIBSB[B\\B_BaBcBmBtBuBzB}B~CBCEC"},
  {0,NULL,"HCJCLCOCRCVC\\C`CiCjCnCpCvCyDKDLDNDQDTDXD[D`DbDnDqDwEDEIEMEVEXE[E]"},
  {0,NULL,"E_EaEjElEnEpEsE|F?FEFJFKFMFYF]F^FaFcFeFhFjFkFlFmFnGKGQGUGXGZG_GbG"},
  {0,NULL,"fGgGiGmG~HCHJHLHOHQHRHTHWH^HnHsH|H~ICIFIKIRIYI\\I^I_IaIcIhImInIoIu"},
  {0,NULL,"IwIyI{I|JCJFJUJVJ\\J`JlJnJqJtJ}KCKDKEKGKLKMKPKRK`KaKbKhKjKnKoKpL@L"},
  {0,NULL,"ALBLDLJLPLQLTLXLdLiLlLoLrLuLwLyM?MBMJMSMUMbMcMgMqMsN?NANCNFNGNMNS"},
  {0,NULL,"NXN\\N_NbNjNlNrNuN{N|OBOHOJOLOQOVObOcOiOlOvO{O|PAPKPOPRPXPYP\\P^PaP"},
  {0,NULL,"bPcPePhPnPtP}Q@QHQKQLQOQXQYQZQ[Q\\QiQkQmQqQsQyQzRFRJRKRLRORWR\\RbRe"},
  {0,NULL,"RhRkRmRvS?SBSDSGSISKSOSPSSSYS\\S`SlSnSoSuSyS~TBTETHTJTNTQTUTYT^TbT"},
  {0,NULL,"hTrTsT{T}UAUBUEUJUKUNUVUZU]U^U`_D?F?I?Q?U?V?Y?Z?]?f?o?u?w?x?z@C@D"},
  {0,NULL,"@J@P@R@Y@Z@a@b@f@h@j@k@q@sADAEAKANAQARAUAVA_AkAlAqAxA{BABGBJBLBNB"},
  {0,NULL,"OBPBTBVBWBoBqBtBvBxC?CBCCCFCGCKCLCUCWC]CbCeCiCvCzD@DADHDPDQDXDZD\\"},
  {0,NULL,"D]D`DhDrDtDxD}EIEKENEOEQE[E^E`EkElEmEoEqE}F?FEFGFNFQFSFXF\\F_F`FdF"},
  {0,NULL,"hFiFlFmFnFpGLGOGPGTGVGYGaGcGhGkGuH@HAHEHIHMHSHVHaHcHeHjHoHvI@IEIG"},
  {0,NULL,"IMIWIYIZI^IaIdIhIiIjIkIoIuIzI{I}JBJGJNJQJYJbJdJiJnJrJsJwJ~K?KQKUK"},
  {0,NULL,"XKYKZK\\KbKcKiKkKlKoKqKsKwKyK{LALELNLXL[L]L`LgLkLlLnLvLyL|MBMCMOMQ"},
  {0,NULL,"MUMZM_MiMnMyNANBNGNNNPNRNTNYN\\NaNcNkNmNpNqNwOCOEOPOTOWO]O^OdOgOkO"},
  {0,NULL,"rOsOwOyPJPKPPPUPVP^P_P`PaPdPePfPoP{P|P}Q?QIQKQUQVQZQ`QaQcQeQgQhQi"},
  {0,NULL,"QpQsQwRBRDRHRJRLRNRORQRaRdRhRkRpRvR}SBSFSGSISLSQSSSYS\\S]SbSlSpSrS"},
  {0,NULL,"uS{S~T@TATITLTSTTTVTYT_T`TeTqTtTuTxTyUCUFUGUKUMUOUQUSU]_E?F?J?Q?T"},
  {0,NULL,"?V?Y?^?c?g?o?r?s?t?y?|@E@K@M@R@T@W@[@`@e@j@k@m@o@q@|AAAFALASATAWA"},
  {0,NULL,"^AbAdAlAqAyA}B?B@BCBEBSB[B_B`BbBeBkBtBuBzB{C?C@CACICJCMCRCUCXCcCd"},
  {0,NULL,"CeCmCyC}D@DBDJDLDPDRDUDVDZDbDeDjDrDzEFEHEKEMEPEWE\\E^EbEiEjEoErEtE"},
  {0,NULL,"vEzFFFIFKFRFWFZF\\FbFdFfFgFjFlFmFnFoGMGQGTGWG]G^GfGjGnGvGwGyHBHFHG"},
  {0,NULL,"HLHRHUH\\HfHgHjHlHtHzIEIJISIVIZI\\I^I_IcIeIfIgIjImIvIwIzI{I~JIJLJRJ"},
  {0,NULL,"YJcJdJiJpJuJzJ|J}KAKEKJKKKLKOKRK]K^KhKiKkKnKrKtKuLELGLILKLOLPLQLX"},
  {0,NULL,"L\\LfLgLjLnLpLrLsMGMLMOMSMVMZMbMlMoM}NHNJNNNQNSNTNVNWNZN`NdNiNlNsN"},
  {0,NULL,"tNvNyN{OGOKOLOSOYOaOcOhOtOuOzP@PDPEPPPRPVPXPYP[P\\P`PaPfPmPsPwPxQ@"},
  {0,NULL,"QGQKQLQMQYQ[Q]Q_QcQdQgQlQoQpQxR?RARLRORQRSRXR[RaRdRgRiRpRuRwR}SES"},
  {0,NULL,"GSISMSQSTSXS[S]SbSkSrSsSuS}S~TBTHTITKTLTMTOT_TaThTkTpTuTwTxT{T}U?"},
  {0,NULL,"UHUIULUNUUUXUZ_D?F?I?S?T?U?W?_?d?f?p?r?s?t?v?{@?@I@Q@S@T@U@Y@b@g@"},
  {0,NULL,"i@j@l@n@uADAEAJALASATAZA]AcAfAiApA|A}A~BGBIBJB\\B`BaBbBcBeBhBjBtBv"},
  {0,NULL,"B|CCCICKCLCOCQCSCUCWCXC[CbCjCrCuC|D?DIDJDKDLDTDUDWD_DdDiDsD{D}EME"},
  {0,NULL,"REWEXEZE\\E]E`EiEjEnEpErEuExFCFSFTFUFWFXFYFbFcFeFfFjFkFlFoFpGJGMGV"},
  {0,NULL,"GYG[G_GdGgGjGpGsG{H?HFHKHOHTHZH_HfHhHlHuHyH~IAIKIUIVIZI[I]IdIhIiI"},
  {0,NULL,"jIkInIpItI}J?J@JAJEJIJMJUJ_JaJkJuJ~K?K@KBKDKGKJKKKMKOKPK^KaKbKcKe"},
  {0,NULL,"KfKkKlKwKyL?L@LGLNLULXLZL_LfLoLqLrLsLtLwMAMEMNMPM^M`MhMjMpMyNCNDN"},
  {0,NULL,"FNLNQNSNVNXNYN]N`NfNkNyNzN|OAODOIOMOQOUOYO_OjOmOuOvO{P@PBPMPQPSPT"},
  {0,NULL,"PUPVP[P^P_PdPePlPnPsPuQBQEQKQPQUQWQXQZQdQeQfQgQhQwQzRARBRCRKRMRTR"},
  {0,NULL,"XRYR^RaRdRhRkRpRvRwR|R~SASDSHSQSSSYS\\S]SbSgSjSmSsSyS|T?T@TCTETHTI"},
  {0,NULL,"TPTdTfTiTjTtTuTvT{T|T~UAUGUKUNUWUXU[U\\UaUbUd_D?E?H?R?U?V?X?]?`?h?"},
  {0,NULL,"q?r?s?t?w?}@C@J@M@O@U@V@]@c@f@h@i@k@r@x@~A?AHALAMAPASATA`AgAjAtAv"},
  {0,NULL,"A{A~B@BKBMBQBRB`BbBdBeBhBpBqBrB{CACBCCCMCNCOCPCTCbCfCkClCmCzC{DCD"},
  {0,NULL,"DDHDJDLDMDUD[D\\DcDhDkDmDyD~EKEPEREVEZE]E^EaEiEjEqErEsE}E~FEFKFMFT"},
  {0,NULL,"F[F]F^FaFbFfFiFjFkFmFnFpGJGQGUGXGZG\\GbGfGgGmGrG~HCHLHNHOHRHTHWH[H"},
  {0,NULL,"^HiHtHyH}IDISITIUIYI[I^I`IaIbIeIkIlIoIuIxIyI|JBJLJMJPJWJeJfJhJoJw"},
  {0,NULL,"JyJzJ{K@KIKJKKKNKOKSKaKdKgKlKmKoKrKtKwK}LCLILLLOLSL_L`LbLgLjLnLqL"},
  {0,NULL,"tLuLwM@MCMDMHMYM_MaMdMmM{N?N@NPNQNRNSNVNWN]NcNeNhNnNvNzN}O?OFOKOM"},
  {0,NULL,"OOOXO\\OfOhOjOpOqOwOxPEPMPOPWPYPZP]P_P`PbPcPdPgPlPoPxQ?QAQBQMQRQXQ"},
  {0,NULL,"]QbQeQiQjQlQnQoQvQwQ|Q}RGRHRIRNRQRYRaRdRfRnRpRtRyR}R~SFSLSNSQSRS]"},
  {0,NULL,"SbScSfSmSpSrSvSzS{T?TBTJTKTNTPTQTcTeTgTmTrTsTvTwT}T~UBUHUKUMURUYU"},
  {0,NULL,"ZU\\UdUe_D?E?H?S?T?V?W?[?^?h?p?u?x?y?z@A@E@K@Q@X@\\@]@a@c@e@i@j@m@n"},
  {0,NULL,"@v@~A?AGARAUAVAXA[AaAfAnApBCBDBHBKBLBMBOBTBUBWBZB^BfBhBkBqByCBCEC"},
  {0,NULL,"HCLCMCOCRCTCWCZC_ClCmCpCuCwCyDKDPDQDSDWDYDZD_DbDnDuDwD~EJEMENEOEU"},
  {0,NULL,"E[E\\EaEkElEmEpEtEvE{FFFGFHFPFUF]F^F_F`FcFgFhFkFlFmFoGPGRGUGXG[G`G"},
  {0,NULL,"aGiGlGoGqG|G}HAHJHPHQHYH`HaHbHqHuH{I@IAIIIOIWIZI[I\\I`IbIcIeIfIkIl"},
  {0,NULL,"IvI|I~J@JAJEJKJNJXJ[JaJkJoJpJqJsJtJ{KHKUKVKYKZK[K`KaKbKmKnKoKpKtK"},
  {0,NULL,"xKyLHLILLLVL\\L^L_L`LfLlLrLvLxL{L|MAMJMKMSM^MbMcMkMqM{NCNDNENGNKNN"},
  {0,NULL,"NTN_NaNdNeNhNjNpNuNxN~O@ONOVOWOZO[O`OdOeOiOnOzO~PIPJPQPSPTPWPYP[P"},
  {0,NULL,"]P_P`PbPjPmPqP|Q?QBQFQGQSQXQZQ[Q]QbQiQkQmQoQ{Q}Q~RBRKRMRORURXR[Ra"},
  {0,NULL,"RdRfRnRpRtRwRxSASDSESGSQSRS]SbScSfSgSkSsSuSxSyT?T@TDTFTGTJTVTZTbT"},
  {0,NULL,"fThTsTtTvTzU@UDUFUHULUMUPUQUTU^UaUbUc_E?F?J?R?T?U?X?\\?_?g?q?u?v?x"},
  {0,NULL,"?z?~@?@I@O@P@X@[@^@`@g@i@k@l@p@r@|AAAIAOARAUAVAYA\\AeAjAtAyBABDBEB"},
  {0,NULL,"FBIBOBTBWBXBYB]BkBnBsBvB{B~C?CACDCICKCRCTCXC^CeChClCxD?DDDEDGDHDK"},
  {0,NULL,"DSDWDXD\\DaDdDkDoDvEFENEOESETEZE[E]EbEkElEmEnEsEuEwFCFHFNFOFRFZF[F"},
  {0,NULL,"_F`FaFeFhFkFnFoFpGLGNGRGWG\\G^GcGeGlGtGxGzG}H@HDHHHXH]HbHdHeHiHoHq"},
  {0,NULL,"HwIDIGIIINI[I]I^I_IeIgIjImInIpItIwIxIyJ?JGJKJPJSJ`JfJhJmJnJqJ}KAK"},
  {0,NULL,"DKFKTKUKWKYKZK^K_KcKiKjKmKnKrKzLELFLGLLLNLOL\\LaLcLlLmLqLvLwLzL|MH"},
  {0,NULL,"MNMRMTMWMaMeMhMrM}NANCNDNENINPNRNXN\\N_NgNiNlNoNqNrN~OBOHOJORO[O]O"},
  {0,NULL,"bOeOgOlOoO{PFPIPKPOPRPVPXPYPZP[P\\PcPdPiPjPnP}QCQGQMQNQUQ[Q\\Q^QbQc"},
  {0,NULL,"QdQhQlQpQrQ}R@RARIRMRNRYRZR^RaRdRgRiRpRuR|R~SASCSFSNSQSTSXS[S]SbS"},
  {0,NULL,"gSmSpSwSzS|TATGTJTKTLTRTUTgTiTlTnToTsTwTxUCUDUEUGUJULUNUPUVU]UcUg"},
  {0,NULL,"_E?G?I?Q?V?X?Y?`?a?f?q?r?v?w?x?}@B@G@M@O@S@U@]@_@f@h@k@m@o@t@{A@A"},
  {0,NULL,"JAOAXAYA[A\\AaAdAmAqAxBBBFBGBJBLBUBXBYBZB]B^BfBgBiBkByCECICKCOCPCQ"},
  {0,NULL,"CSCUCYCaCcCgChCqCuC|C}DGDLDNDRDWD\\D]D_DeDgDiD{ECEIELEOEPETEWE]E`E"},
  {0,NULL,"iElEnEqEsE|E~FDFJFKFTFYF[F^FaFeFfFhFiFlFmFoFpGJGKGQGUG\\G_GiGmGrGs"},
  {0,NULL,"GtGzHCHJHKHNHQHWHXH[H_HiHnHtH|ICIDIFISIYI_I`IbIcIhIkIlImIoIsI{I~J"},
  {0,NULL,"AJBJCJFJLJPJ]JcJiJmJrJsJxJ~K?KFKHKTKVKWK[K^KaKcKdKeKfKkKpKvKzK|K~"},
  {0,NULL,"LKLRLVLWL\\L^LeLjLmLsLwLyL|MAMEMLMMM\\M^M`MlMpM|NBNDNHNINMNRNSNYN[N"},
  {0,NULL,"aNgNkNmNpNqNwODOEOPOUOWO]O^O_OdOgOkOrPFPGPLPNPPPQPTPWPXP`PaPbPcPf"},
  {0,NULL,"PiPkPyP~QFQGQJQSQTQWQXQdQfQgQhQjQkQrQtQuQxRERSRVRXR[R]R^R`RcRgRiR"},
  {0,NULL,"oRuRwRzR|S@SESMSTSUSWSXS[S_SkSqSsStS|S}TBTCTJTLTNTQTVTWTaTdTfTrTs"},
  {0,NULL,"TxT|T}UBUFUKUOUPUQUSUVUYU_U`UeUh_D?G?J?Q?V?W?Y?[?b?g?p?t?u?v?y@A@"},
  {0,NULL,"F@L@N@Q@X@]@^@a@e@h@j@m@s@tABACAIAMAPAZA]A`AcAkAmAqAyAzA|B?B@BEBQ"},
  {0,NULL,"BRB\\BaBcBdBgBjBlBmBxB~C?CDCHCICKCNCTC\\CbCfCgCkCqCxDADDDIDNDQDUDVD"},
  {0,NULL,"WDXDaDgDkDtDvEGEHELEMENEQEXE]EbEjEkEnEpEtE{F@FBFGFHFOFUFVF^F`FcFe"},
  {0,NULL,"FgFjFmFnFoFpGNGPGRGSGUG[GbGoGpGqGxG{G|G~HHHPHYHZH]H^H`HuHxH|I@IAI"},
  {0,NULL,"CIQIWI\\I`IaIbIdIeIfIgIiIlIrIxIzI~JBJCJEJHJNJ]JbJiJvJzJ|J}KAKBKGKI"},
  {0,NULL,"KMKNKPKSK^K_K`KcKgKiKjKmKvKwK}LCLJLWLYLZL[LdLeLkLoLpLrLvLwMHMMMQM"},
  {0,NULL,"RMWM\\MaMiMrM~NANDNGNJNLNMNQNWNZN^NfNiNlNoNtNvNyN{OGOKOLOROYOcOhOo"},
  {0,NULL,"OtOuP?PAPBPCPOPPPSPUPWPZP]P`PaPfPrPtPuPvQDQHQIQJQPQ\\Q^QbQcQdQhQmQ"},
  {0,NULL,"nQqQuQvQwQ|RHRJRNRVR]R^R`RcRhRkRoRvRzR|S@SBSFSLSSSUSWSYS\\S_SlSpSq"},
  {0,NULL,"StS{S|T?TBTDTFTITUTVTWT`TgTlTuTvTzT}U@UEUFUIULUUUWUZU\\U^UbUeUh_E?"},
  {0,NULL,"G?I?S?T?W?X?\\?e?f?o?p?s?u?y?~@@@I@N@S@U@W@Y@b@g@i@l@m@v@w@{A@AKAM"},
  {0,NULL,"APAWA^A`AbAhAnAsAxAzBCBDBLBMBQBRBSB[B_BdBgBiBpBrB{C?CBCECFCGCKCPC"},
  {0,NULL,"UCVC\\C`CcChCtCvCzDEDFDIDJDSDVDXDZD`DhDoDpDxECEHENESEXEYE\\E^E`EkEo"},
  {0,NULL,"EpErEtEwEyFCFIFSFTFVFXFYF`FbFcFdFgFkFlFnFpGJGSGVGYG]G_GdGgGhGjGpG"},
  {0,NULL,"{H?HFHMHOHSHTHZHfHhHmHxHzI?IBIJIQIXIYI[I]IbIcIlImInIoIpItIyI|I}JA"},
  {0,NULL,"JDJHJRJZJ[J^JjJpJqJrJsJvJ{KEKIKLKNKRKSKcKdKiKkKoKpKqKsKzLBLDLJLKL"},
  {0,NULL,"OLRLSLWLbLfLgLhLoLpLvLzL~MBMCMTMUM_MeMfMnM|NANENJNLNONTNVN^N_NaNd"},
  {0,NULL,"NeNmNtNuN}O@OCOGONOTOVOXOfOiOnOsOtOzP?PHPIPQPRPTPWPXP]P^P_PbPcPjP"},
  {0,NULL,"mPrPzQAQJQMQRQTQ`QaQcQgQhQiQjQkQqQrQxQyRFRIRLRNRRRWRZR`RcRgRiRoRu"},
  {0,NULL,"R{SCSFSISKSNSTSUSWSXS[S_SiSoSpSwSzS~T@TBTCTETFTMTPTYT\\TeTnTpTtTzT"},
  {0,NULL,"|T}T~UAUHUNUOUPUTU\\U^UcUdUj_D?G?J?Q?V?W?Y?[?b?g?o?q?r?w?z@A@F@K@T"},
  {0,NULL,"@V@W@[@`@d@e@h@j@m@s@tABACAIAMAPAZA]A`AcAkAmArA{BABBBFBGBLBQBRB\\B"},
  {0,NULL,"aBcBdBhBjBlBwB|B~CACDCFCKCRCSCTCVCZC\\C`CfCpCsD?DEDMDODQDRDSDUD\\Dd"},
  {0,NULL,"DlDnDoDvEAEHEKELEOEUEVEZEbEiEmEoEqEsE{F@FFFIFLFMFRFWFZF_FaFdFfFiF"},
  {0,NULL,"kFlFnFoGIGMGWGZG]G^GeGfGjGnGvGyHBHDHFHLHRHUH\\HdHfHkHpHrH}IHILIPIT"},
  {0,NULL,"IZI\\I]IbIcIdIfIhInIoIvIwI{I}JAJJJOJTJWJ]JbJgJmJnJsJwJxK?KGKIKMKNK"},
  {0,NULL,"PKSK_KcKeKjKmKnKrKsLBLCLDLHLJLMLULYLZL_LeLnLpLqLuLxL|L}MJMNMTMXMc"},
  {0,NULL,"MeMhMrMxN@NENGNHNQNRNUN[N\\NaNcNgNkOBOCODOEOFOJOOOPOTOUO_ObOpOrOsO"},
  {0,NULL,"wPGPJPLPPPTPUPVPWPXP^PaPbPePkPoPyP|QBQDQEQPQQQWQ[Q\\Q^QaQbQhQlQqQy"},
  {0,NULL,"Q{Q|RFRIRKRMRRRUR\\R_RfRlRnRqRtRxR{S?SASDSNSRSVS^SaScSfSgSiSnSxSyS"},
  {0,NULL,"zTHTLTMTOTPTQTTTXTbTiTnTpTqTxT{T~U?UBUHUJUKUOUQUSUXU_UfUh_D?G?J?R"},
  {0,NULL,"?U?W?X?d?e?g?p?t?u?v?y?{@@@H@N@Q@T@U@W@Y@g@h@i@l@x@yABACAFANAQAXA"},
  {0,NULL,"[A_AaAgAoAtAwAyBABEBFBHBNBPBUBVBZB^BlBoBqBwBxC@CACFCJCMCRCSCUCYCZ"},
  {0,NULL,"CaCfCgCoC{C}D@DFDGDJDKDPDYD[DeDfDmDrDzEAEJEPERESE[E\\E_EbEjEkEnEpE"},
  {0,NULL,"tExEyFAFIFTFUFVFWFXF`FcFeFgFjFmFnFoFpGJGMGSGYG[G]GhGoGpGsGwG{G|HG"},
  {0,NULL,"HKHMHSHYHZH_HgHuHxHyI?IAIBIQIUI]IbIdIhIiIjIlImInIoIqIyI{J?JBJDJEJ"},
  {0,NULL,"HJMJ\\JeJhJmJnJtJ}KAKCKHKQKVKXK[K\\K]KeKhKkKnKrKsKtKvK|K~LCLHLMLYL["},
  {0,NULL,"L]L`LfLiLjLlLtLzL{MDMIMLMOMYMZM[MlMoMxN?NCNINKNNNONVN\\NbNgNiNjNlN"},
  {0,NULL,"oNqNrN{N~OHOLORO[O]OcOeOgOlOoO|O~PAPCPOPPPTPZP^PaPbPcPdPePhPqPtPv"},
  {0,NULL,"Q?QDQIQQQVQWQYQ[Q]Q_QaQgQlQtQuQ{Q|RERGRHRPRQRVR[R_RfRlRnRqRtRyR}S"},
  {0,NULL,"@SESJSLSRSVS^SaScSfShSkSqSrSvS{T@TATCTETJTOTPT[T_TaTcTsTtT|T~U?UA"},
  {0,NULL,"UCUJUNUQUTUVU[U]UaUdUg_E?F?J?Q?T?V?Y?^?c?g?q?u?v?x?z?|@E@L@N@Q@X@"},
  {0,NULL,"\\@^@c@e@j@k@m@o@q@|AAAFALASATAWA^AbAdAlArAxA{BABBBFBJBSB[B_B`BbBe"},
  {0,NULL,"BnBpBrBuB{C@CFCHCJCMCNCSCUCXC[C^CdCjCoCrCtC{DQDRDTDVDYD[D]DfDmDpD"},
  {0,NULL,"sDzD|EIEJEKELEMEYE_EbEkElEmEnEsEvEzFBFHFOFPFUFVF]F_F`FaFeFhFkFnFo"},
  {0,NULL,"FpGNGRGSGXG[G`GbGlGpGqGxG{G}G~HHHPHZH]H^H`HbHqHsHwH{IIINIOIRIYIZI"},
  {0,NULL,"[IbIcIdIeIgIkIpIrIxI}JAJBJKJSJVJXJcJdJgJmJnJrJwJxJ~KEKJKKKLKOKRK]"},
  {0,NULL,"K`KeKgKhKkKsKtKuL?L@LFLGLOLQLSLaLbLeLhLiLnLrLyL{L~MDMIMPMYM[MfMjM"},
  {0,NULL,"oMvN?NBNFNGNHNJNKNYN[N\\NcNgNmNqOBOCODOFOJOOOTOUO]O_ObOgOpOsOyPFPK"},
  {0,NULL,"PNPQPUPVPWPXP_P`PcPdPfPiP{P}P~QAQCQLQMQRQWQYQ]Q_QaQgQmQnQzR?R@RAR"},
  {0,NULL,"CRGRPRTRWRYRZRbReRjRmRrRsRyR~SCSHSJSKSOSPSZS`SdSeShSjSmSoSvSwT?TD"},
  {0,NULL,"TETFTQTTTVT[T\\TcTjTqTvTzU@UAUBUFUKUOUQURUSUWU^U_UbUm_E?F?J?R?T?U?"},
  {0,NULL,"X?\\?_?g?o?r?s?t?y?~@?@H@N@Q@S@T@W@b@g@i@k@l@p@r@|AAAIAOARAUAVAYA\\"},
  {0,NULL,"AeAjAuAvA{B?B@BBBKBOBTBWBXBYB]BfBkBnBuByB~CDCFCHCKCNCSCTC]C^CdCeC"},
  {0,NULL,"iCpCqCsDADFDHDIDKDMDNDODgDlDnDtDvD|EQERESETEUEVEXEbEiEjEoErEtEuEw"},
  {0,NULL,"FAFIFSFUFVFWFYFbFdFfFgFjFlFmFnFoGMGSGVG[G]G_GhGjGoGsGwG|HFHGHKHMH"},
  {0,NULL,"SHYH_HfHgHlHmHzH~IJIKIVIXIYIZI[IcIiIjIkIlImIpIqI{I|J@JBJIJRJUJZJ`"},
  {0,NULL,"JfJlJoJwJxJyJzJ|KFKTKUKWKYKZK_K`KcKeKgKjKmKsKuK{LALELFLQLVL\\L^LaL"},
  {0,NULL,"kLmLoLtLuLxLzL}MJMMMQMXM\\McMiMrMvN@NCNLNMNONPNUNWNZN[NcNhNnNsNvNx"},
  {0,NULL,"O?OEOKOPOSOZO\\O`OaOhOqOrOxO}PDPEPQPYP\\P_P`PbPcPdPePfPgPpPwPxQCQFQ"},
  {0,NULL,"GQLQSQWQ\\Q^QaQbQhQmQnQpQsR?R@RDRJRORSRUR\\R]RbReRjRmRrRsRxRzS?SBSG"},
  {0,NULL,"SMSOSPSZS`SdSeSlSnStSuSxS}T@TCTDTETNTPTSTWTXT`TbTrTtTyT|T~U@UAUMU"},
  {0,NULL,"RUSUTUYU[U\\U`UaUjUl_D?F?I?Q?U?V?Y?Z?]?f?p?r?s?t?v@C@D@G@O@S@U@V@_"},
  {0,NULL,"@c@f@h@j@k@q@sADAEAKANAQARAUAVA_AkAlArAyAzA|A}B?BCBNBOBPBTBVBWBnB"},
  {0,NULL,"oBsBvB|C?C@CBCDCECFCGCPCWCZC[C]C_CtCwC~DEDFDNDODPDVD[D\\D^DoDpDuDx"},
  {0,NULL,"E@EHEIEJEPEQESEVE`EiEjEnEpErE}F?FDFJFMFTFYF[F]FbFcFeFfFjFkFlFoFpG"},
  {0,NULL,"JGKGXGZG\\G_GgGiGrGsGtGzHJHKHNHOHQHTHXH[H_HsHyH}H~IKIRITIUI[I\\I^I_"},
  {0,NULL,"I`IaIeIhIkInIsIwIxI~JAJMJUJVJWJbJdJgJpJuJvJ|KAKBKQKUKXKYKZK\\K]K_K"},
  {0,NULL,"dKiKoKpKqKsKxKyK{L?LHLNLUL]LaLcLjLkLpLuLyLzL{L~MFMKMTM]MeMfMkMnMw"},
  {0,NULL,"N?NJNMNNNONRNUNZN^N`NdNfNiNoNsNyO@OAOIONOROSOYOaOmOnOoOuP@PBPCPDP"},
  {0,NULL,"OPSPUPVPWPXPYP[P`PaPsPuPvPwQCQEQNQUQVQ^Q_Q`QaQcQiQjQkQ{Q~RBRCRDRM"},
  {0,NULL,"RPRRRTRURZR_RjRlRqRrRsRxR{SASCSHSJSVSZS^SaSdSeSgShSiSjSwSxTBTDTJT"},
  {0,NULL,"NTOTQTRTZT\\T]TnToTrTsT}U?U@UBUIULUTUUUVUYUZU`UkUmUo_D?E?H?R?U?V?X"},
  {0,NULL,"?]?`?h?p?u?x?y?z?}@C@G@R@Z@\\@a@b@d@f@h@i@k@r@x@~A?AHALAMAPASATA`A"},
  {0,NULL,"gAjAuAwAyBDBFBHBIBQBRB`BbBdBeBfBhBjBpB|B~CACCCGCJCNCPCQC_CcCdCkCm"},
  {0,NULL,"CsC|C~DBDGDIDMDVDXD[D]D^DiDjDlDyE?ELEQESEYE]E^E_EaEkElEmEpEtE}E~F"},
  {0,NULL,"DFGFLFPFQFSF\\F_F`FcFgFhFkFlFmFoGIGOGPGTGVG`GaGdGkGqGvGyH?HAHEHPHU"},
  {0,NULL,"H`HaHcHhHmHvH{I@IMIOIWIXIZI]I^I_I`IfIhIjIkIoIsIwI{J?J@JNJQJXJZJeJ"},
  {0,NULL,"fJlJmJqJtKAKCKDKIKJKKKNKOKSKdKfKgKhKjKlKqKrKuKxK}LILKLSLULZL^L_Le"},
  {0,NULL,"LgLhLiLkLwLzL}MEMFMGMVMXM]M`MmMuN?N@NANBNINJNLNXN_NbNgNiNjNuN{N|N"},
  {0,NULL,"~OBOJOLOQOVO[ObOcOeOiOvO~PCPFPIPPPTPVPYPZP[P\\PbPdPePiPjPqPvQAQBQE"},
  {0,NULL,"QFQPQYQ\\Q`QeQfQjQlQnQoQvQxQ~R?RRRSRTRURXR]R`RcRjRoRrRsRwRxRzR{SHS"},
  {0,NULL,"MSUSWSZS_SdSeSiSjSsStSxS}TATETITMTSTTTUTXT]TdTkTpTqTuTyUAUCUEUJUN"},
  {0,NULL,"UOUUUVUWU]U_UjUkUn_F?G?H?R?U?X?Y?Z?a?h?o?s?w?y?z@B@D@G@P@R@Y@\\@a@"},
  {0,NULL,"d@f@h@k@l@p@y@z@}AGAWAZA]A^AbAcAeAoAtAvA~B?BBBKBMBSB[B\\B_BaBcBgBl"},
  {0,NULL,"BmBsBzCECGCHCLCMCQCRCTCVCXCYC[CjCoCuCwCxDFDLDMDPDRDSDXD_DaDfDuDwE"},
  {0,NULL,"BEHEOETEVE\\E^E_EaEmEoEqErEtE|F?FDFGFLFNFPFXF\\F_FbFdFgFiFkFmFoFpGI"},
  {0,NULL,"GLGPGTGYG`GdGkGqGuGvGyH?HEHIHPHUHVH`HcHhHjHoHrI?IBIEIGIPIYI_I`IaI"},
  {0,NULL,"dIgIhIiIkIpIsIxJ?J@JBJDJGJOJYJ\\J`JhJoJxJyJ{J|K@KEKGKLKMKPKRK`KbKf"},
  {0,NULL,"KmKnKpKqKtK|L?L@LBLGLPLWLYLcLdLfLgLiLmLpLuL|MAMIMKMRMWM[M^MkMqMzN"},
  {0,NULL,"@NANENHNNNONSNZN[N]NeNhNnNvNxNzN}OFOKOMOOOXOZO`OfOhOjOpO}PDPGPHPO"},
  {0,NULL,"PQPSPUPZP\\PcPdPePfPpPwPyPzQ@QDQHQJQNQZQ[Q]Q`QbQfQkQmQtQyQzRARCRMR"},
  {0,NULL,"PRVRZR[R^R_RgRiRlRqRuR|S@SASCSESJSTSVSXS[S^SaSgShSkSqSwS|TATFTITK"},
  {0,NULL,"TPTSTTTZT[TfTlTqTuTwTyTzT~UCUMUOURUUUXUYU\\U_U`UdUgUkUl_F?G?H?S?T?"},
  {0,NULL,"W?Y?b?c?h?p?q?t?v?x?|@F@K@N@\\@]@^@a@c@e@j@l@m@u@w@z@}AHANAOAQAYA\\"},
  {0,NULL,"A_AhAiAsAvAwA}A~BGBIBNBPBVBXBYB]BiBsBwBzB}CACCCGCMCNCPCQCTCVCYC]C"},
  {0,NULL,"eCiCsCzDBDCDGDJDODVDWDYD\\DcDhDjDlDyEBEJELENEPESEWEZEaEjElEnEpEsEz"},
  {0,NULL,"F@FFFGFOFPFVF]F^FaFcFeFhFjFkFlFmFnGNGPGSGUGXG`GaGbGiGlGoG|G}G~HAH"},
  {0,NULL,"JHQHYH^HaHbHsHwHxH|ICINIQIRIYIZI\\IaIcIdIfIgIiIpIvIzI|I}J@JCJHJSJV"},
  {0,NULL,"J^J_JjJuJyK?K@KCKDKFKQKTKWKXK\\KdKfKgKlKmKqKrKtK{K|LALBLELMLPLRLTL"},
  {0,NULL,"cLeLjLqLsLvLzL{L}M@MCMGMVMXM_MdMmMzNDNINJNKNRNUNVNXN]N`NbNkNnNrNw"},
  {0,NULL,"N|O?OAOHOIOQO\\O^OkOlOmOqOvO{O|P@PLPQPRPSPUP\\P]P^P_PePfPhPkPnPsQ@Q"},
  {0,NULL,"NQOQQQTQ]Q`QbQeQfQjQlQnQpQsQtQyRDRIRLRQRRRSR\\R_RgRiRlRqRuR{R}S?SI"},
  {0,NULL,"SMSNSTSVSXS[S^SaSiSnSrSzS}S~T?TATCTDTFTRTVTXTeTkTmToTvTzT|U@UCUFU"},
  {0,NULL,"GULUQUWUXUYU[UfUhUiUmUpUq_E?G?I?S?T?W?X?\\?e?f?q?r?v?w?x?~@@@H@O@P"},
  {0,NULL,"@X@Z@_@`@g@i@l@m@v@w@{A@AKAMAPAWA^A`AbAhAnApAvAwA|A}BGBJBQBRBSB[B"},
  {0,NULL,"_BdBgBlBmBrByC?C@CBCCCDCFCGCLC`CaCcCdCmCwC~D@DADHDJDODQDSDTD[D^Dr"},
  {0,NULL,"DtDuDxEEEJEKEVEXEYEZE[E`EiElEnEqEsEwEyFAFHFJFNFQFRF[FaFeFfFhFiFlF"},
  {0,NULL,"mFoFpGKGLGOGRG\\G^GkGmGnGtGxGzHBHCHEHHHWHXH\\H]HcHiHkHnHqIDIFIIILI]"},
  {0,NULL,"I_I`IfIgIiIjIlImIpIqIzI~J?J@JFJJJKJPJ[J^JkJuJyJ~K?KBKCKEKIKLKNKRK"},
  {0,NULL,"SK]K_KbKiKlKoKqKsKuK~LDLILKLVLWLYLbLdLhLlLnLoLqLuL{MFMKMOMQMZM]Mi"},
  {0,NULL,"MkMnMtN?NENFNGNPNUNVNYN`NbNfNkNnNwNyNzN|ODOMOQOUOYO^O_OjOkOuOvOxO"},
  {0,NULL,"|PLPNPPPQPRPSPTPZP[P\\P]PfPgPhPkP~QDQHQJQRQSQZQ^Q_Q`QaQcQeQiQoQxR?"},
  {0,NULL,"RERFRHRORPRUR[R]RbReRfRmRnRtRxRzSESGSJSLSOSPSRS`ScSfShSkStSuSxS{T"},
  {0,NULL,"?TGTHTKTRTTTUTZT]T_T`ToTqTvTwT{UDUEUGUJURUWUXUZU[UbUcUfUlUnUp_D?G"},
  {0,NULL,"?J?R?U?W?X?d?e?g?o?q?r?w?z?{@@@I@X@Z@[@^@_@`@g@h@i@l@x@yABACAFANA"},
  {0,NULL,"QAXA[A_AaAgAoAuA{A~B?B@BBBMBNBPBUBVBZB^BiBjBwBxB}C?C@CHCICJCMCNCU"},
  {0,NULL,"CWCZC\\C_CgCrCtCyDBDFDGDHDLDTDZD]DbDjDpDsDzEGEIERETEWEYE[E^EbEiEmE"},
  {0,NULL,"oEqEsExEyFCFHFJFOFQFRFZF_FaFdFfFiFkFlFnFoGKGNGOGRGWG^GcGeGlGnGtGz"},
  {0,NULL,"G}H@HBHDHXH\\HbHdHeHkHnHpHvIFIHILIMI[I\\I]I`IaIfIiIlInIpItIwIxI|J@J"},
  {0,NULL,"FJJJQJTJ\\JeJlJwJxJzJ{J|K@KHKQKVKXK[K\\K]K^K`KgKhKiKkKtKvKxKyLHLJLM"},
  {0,NULL,"LRLTLZL[LgLhLlLmLsLtLyL~MGMPMSMVMbMfMjMoM~NBNFNINONPNSNTNWNZN[N]N"},
  {0,NULL,"cNeNsNxO?OEOFOOOPOSOZO\\O`OaOpOqOrOwPGPHPMPOPSPUPWPYPZP\\P]PbPePlPo"},
  {0,NULL,"PyPzQIQOQPQQQTQYQ]Q_QcQdQgQmQnQqQuQ{Q~RBRKRLRRRTRWRXR`RcRhRkRoRvR"},
  {0,NULL,"wR{SDSHSISKSSSUSWSYS\\S_SiSjSoSsSyS~TGTKTNTRTSTUTVT\\ThTjTkToTrTwTy"},
  {0,NULL,"UDUEUFUGUIUMUPURUYU\\U`UcUdUiUn_F?G?H?S?T?W?Y?b?c?h?o?s?w?y?z?|@F@"},
  {0,NULL,"L@M@R@T@V@`@d@e@j@l@m@u@w@z@}AHANAOAQAYA\\A_AhAiApAxAzBDBHBKBMBNBP"},
  {0,NULL,"BVBXBYB]BmBnBsBvB}B~CACBCCCJCNCOCPCYCaCgCiCjC{C|C~DDDHDIDODUDYDZD"},
  {0,NULL,"]D^DiDkDmDyEDEKENEQEREUEWEYEaEmEoEqErEtEzF@FBFKFLFMFRFWF\\F_FbFdFg"},
  {0,NULL,"FiFkFmFoFpGIGMGQGTGZG^GeGrGuGvGwGyHDHGHIHNHUHVH[HdHgHjHkHlHrIEILI"},
  {0,NULL,"PIVI\\I_IbIcIdIeIgIhImInIrIyI~J?JAJIJJJOJYJ^J_JkJoJqJrJtJvJ{KFKQKT"},
  {0,NULL,"KWKXK\\KaKdKgKhKjKlKoKrKvK|K~L@LALNLTLaLcLdLhLkLnLsLtLvLxMDMEMFMHM"},
  {0,NULL,"YM]M`MaMmMsNBNKNLNPNQNTNUN^N_NeNhNjNmNpNxN}N~O@ONOWOXOZO[O`OdOeOf"},
  {0,NULL,"OnOyO}P?PHPOPQPRPSPTPXP[P^PaPcPpPrPzP{QCQHQNQOQUQXQYQ\\QeQiQjQlQnQ"},
  {0,NULL,"sQtQuQzRERHRPRTRYR]R^RbReRhRkRmRvRzR|R~SHSJSLSOSPSSSYS\\S`ShSjSmSt"},
  {0,NULL,"S{S|T@TGTHTLTMTNTOT]TcTdTgTpTrTtTxT{U?UDUHUIUPUSUTU]U^UaUcUfUoUqU"},
  {0,NULL,"u_E?G?I?Q?V?X?Y?`?a?g?i?m?n?u?v?|@A@L@O@Q@Y@\\@]@^@e@n@s@t@v@x@|AC"},
  {0,NULL,"AIANAPAXA[A]AcAkAlAqAvAyA|B@BDBHBRB\\B_B`BaBeBjBlBmBnBpBsBxB}CDCGC"},
  {0,NULL,"HCNCTCWC]CbCgCiCnCoCqCvDADBDDDHDUDWDXD_DeDgDiDxECEHENESEXEYE\\E^E`"},
  {0,NULL,"EkEoEpErEtE|E~FEFLFNFPFQFSFXFdFfFkFtFuFvF|G@GEGIGKGMGQGVGWGbGcGdG"},
  {0,NULL,"fGmGoGsGwG}HBHIHMHNHQHSH]HaHdHiHkHlHsH{H~I?IHINIOIPI]I^IaIpIvIzJE"},
  {0,NULL,"JFJKJMJOJWJZJ^J_J`JcJdJgJhJjJlKEKFKJKKKWKZK^K`KaKoKrKyK~LBLELFLML"},
  {0,NULL,"NLSLVL[LhLjLuLxL}MIMNMPMUMVMWM]M_MdMgMhMjMkMoMtMyM}M~N?NENKNMNZN`"},
  {0,NULL,"NbNeNhNlNoNpNsNwNyOJOMOOOVO\\ObOfOlOpOvPFPGPLPNP^P_PdPePjPlPnPoPpP"},
  {0,NULL,"qPzP{P|P}Q?QGQKQUQVQYQ[Q_Q`QlQoQpQyQ{Q}Q~R?RARHRLRORQRXR[RfRlRmRq"},
  {0,NULL,"RrRsRxR~SASDSHSJSOSQSRS\\S^SdSlSpStSuS{S|T?TETNTOTWT]TbTcThTmTnToT"},
  {0,NULL,"vTwT{T|T}UEUKUOUPUQUSUVUYUcUiUkUlUnUqUr_D?G?J?Q?V?W?Y?[?b?f?k?m?n"},
  {0,NULL,"?o?u?}@D@J@N@P@[@a@b@d@f@p@q@s@u@y@{ADAKASAUAVAZA_AcAdAlAqAwAxBAB"},
  {0,NULL,"GBKBMBNBOBTBXB]B^BhBoBpBqBrBtBvB}CCCFCGCJCLCXCbCdCeCmCnCpCyCzC|D@"},
  {0,NULL,"DADJDXDZD\\DaDgDkDtDzEGEIERETEWEYE[E^EbEiEmEoEqEsE{F@FFFIFLFMFRFWF"},
  {0,NULL,"ZFeFfFkFqFrFzF~GBGCGUGZG[G\\G^G_GaGeGiGjGkGmGoGxG~H?HBHKHLHSHTHUH\\"},
  {0,NULL,"H`HiHpHqHrHxHyH{IKIPITIXIZI]IcInIsI{JDJEJGJJJSJVJWJ[J]JcJeJfJgJjJ"},
  {0,NULL,"kJlKFKHKIKLKNKTKbKcKdKmKtKxLCLDLGLKLOLTLULXLYLeLtLuL{M?MFMNMTMUMV"},
  {0,NULL,"MXMYM[M`MbMcMeMhMpMxMyM|M}N@NGNKNONYN]NaNgNjNnNqNvN{OCODOHOIONOQO"},
  {0,NULL,"ZOeOiOmOnOqP?PAPBPCPRPYP[P\\PgPjPlPmPnPpPsPwPxPzQ@QGQJQLQMQWQXQYQj"},
  {0,NULL,"QkQrQtQxQyQzQ~RCRERQRSRVRXR[R^RbRjRmRnRqRrRyR~SASCSJSNSOSQSXSZS^S"},
  {0,NULL,"fSkSpSrSuS{S~T?TATGTQTXTZT\\T`TcTfTmTsTtT|UAUCUEUFUIULUUUWUZU\\U^U`"},
  {0,NULL,"UaUdUjUpUuUv_D?G?J?Q?V?W?Y?[?b?f?k?m?n?o?u?}@D@J@N@P@[@a@b@d@f@o@"},
  {0,NULL,"r@t@v@x@{ADAJAMAOAWA\\A`AaAdAlArA|A~B@BCBDBHBNBOBTBXB]B^BiBmBqBrBt"},
  {0,NULL,"ByBzB}CCCICLCMCQCXC^C`CdCjCnCrCwCzC{D?DDDMDNDTDYDdDlDnDoDzEAEJEPE"},
  {0,NULL,"RESE[E\\E_EbEjEkEnEpEtE{F@FBFGFHFOFUFVF^FeFfFmFsFuFvF|G@GGGUGZG[G\\"},
  {0,NULL,"G^G_GdGeGgGjGoGrGuGxGzG{G~HEHLHUHWHZH`HeHjHlHnHpHxH~I@ICIDIGIWIeI"},
  {0,NULL,"gIiIlIsIxJCJEJJJLJQJRJZJ\\J_J`JbJdJhJiJjJkKGKMKOKUKYK\\K_KhKjKlKpKu"},
  {0,NULL,"KwK|L?LJLQLWLZL`LbLlLpLsLwMAMCMMMQMVMWMYM[M\\MaMbMdMiMkMnMtMvMwM~N"},
  {0,NULL,"ANINQNTNXNZN^N`NbNeNsNtNyOBOFOMOWO[O\\O^O`OdOfOkOlOwPGPJPLPQP_PcPd"},
  {0,NULL,"PgPhPiPjPnPpPqP{P}P~QAQCQEQLQMQ]QcQiQjQkQoQtQvQxQ~RBRCRDRPRRRTRUR"},
  {0,NULL,"WRZRcRdRiRkRpRuRwRzSBSGSISMSTSUSYS]S`SeSjSmSnSoSvSyT@TBTHTSTYT]Ta"},
  {0,NULL,"TdThTiTlToTrTwTyT~U?UDUHUJUKUOUQUSUXUcUgUiUlUmUnUs_E?F?J?Q?T?V?Y?"},
  {0,NULL,"^?c?f?i?k?n?r?v@B@C@G@M@T@U@X@_@c@f@n@q@r@s@xA@AEAKALAQASAUAZA_Ak"},
  {0,NULL,"AmArAvAyA|A~BCBDBPBUBVBWBYBZBfBgBmBoBsBvBzB|B~C?CBCECPCVCZC[C\\CfC"},
  {0,NULL,"nCsCtCwC|DBDEDODPDSD[DfDmDpDsDvD|EQERESETEUEVEXEbEiEjEoErEtEvEzFF"},
  {0,NULL,"FIFKFRFWFZF\\F`FdFmFsFtF|G@GEGGGNGOGTGYG]G`GaGdGgGiGlGnGpGwGyH@HCH"},
  {0,NULL,"FHPHRHXH^HcHfHlHoHqHtHxH|I?IEIFIMISI\\IfIjImIuIwJEJMJNJPJRJSJYJ\\J]"},
  {0,NULL,"J^J`JcJiJjJkJlKHKLKNKRKTK[K]KbKdKmKtLALCLDLGLKLOLULXLYL^LgLmLrLvM"},
  {0,NULL,"BMEMLMOMVMWMXMZM]MaMbMcMgMlMpMtMwMxM}NDNJNPNSNXN^N`NeNhNlNoNtNyOB"},
  {0,NULL,"OFOVOWO[O\\O^O`OdOkOlOvOyPFPKPNPTP^PbPePgPhPkPlPoPpPqPyPzP|QBQDQPQ"},
  {0,NULL,"QQRQZQ\\QdQeQfQoQrQsQvQwQ}RERFRGRIRKRMRYR\\R`RaRgRhRoRvR|R}S@SESFSL"},
  {0,NULL,"SSSVSWS[SbScSgShSiSwSxSzTCTFTITJT\\T`TeTfThTlTmToTsU@UAUCUDUEUKUOU"},
  {0,NULL,"QURUSUWU^U`UcUiUlUnUoUv_D?F?I?S?T?U?W?_?d?h?j?k?l?s?w@E@F@L@M@P@T"},
  {0,NULL,"@U@[@d@e@n@o@q@r@v@zA?AGAPARASATAXAaAhAnAsAvB?B@BABIBJBOBUBVBXBYB"},
  {0,NULL,"^BfBjBlBmBnBpBqBxB~CFCJCLCRC\\C`CcChCkCnCrCsCtCvCxC{DFDRDWDXDcDeDg"},
  {0,NULL,"DqDxE@EHEIEJEPEQESEVE`EiEjEnEpErEuExFCFSFTFUFWFXFYFcFhFoFtFvF}GBG"},
  {0,NULL,"DGHGNGOGUG[G_G`GbGcGdGeGfGlGmGsGyG{HAHHHOHTHVH\\H`HfHkHlHnHoHyH|I@"},
  {0,NULL,"IAIOIPIVI]IhIkIpIvI}JEJKJLJPJQJUJYJ\\J]J^J_JbJgJhJkJlKEKGKPKTKWKXK"},
  {0,NULL,"^KfKhKiKmKwL@LBLHLKLSLWLXL_LaLkLlLqLrMAMDMEMJMXMZM[M^M`MeMfMhMiMj"},
  {0,NULL,"MmMuMyMzM|NFNNNPNQN]NbNcNiNkNlNtNwNzN|OCOJOSOZO[O]O`OeOoOpOrOyO}O"},
  {0,NULL,"~PJPWPXPbPcPiPjPmPrPtPvPwPxPyPzQ@QJQMQRQTQ]QaQbQeQnQoQpQsQtQyQ{R?"},
  {0,NULL,"RARIRLRNRQRRRSReRfRhRmRnRpRwRzR|SESGSLSSSUS[S]S`ScSlSoSpSqSwS~T?T"},
  {0,NULL,"LTNTUTZT^T`TgThTiTkToTqTxTyUBUCUFUHUJUPURUTUUU^U_UgUkUmUoUpUvUwUy"},
  {0,NULL,"Uz_D?E?H?R?U?V?X?]?`?g?i?j?m?t?y@?@@@H@M@N@T@U@a@b@g@n@p@q@r@uAAA"},
  {0,NULL,"CAIALATAVAYA\\AbAeAoAuA{A|A}B?BKBLBNBTBUBVBYB]BgBkBlBnBoBrBuByCECF"},
  {0,NULL,"CKCSCTCVC`CdCiCjCnCpCsCtC}DADCDHDIDNDQD^DiDjDlDwE?EHEIEJETEUEWEXE"},
  {0,NULL,"aEiEjEqErEsE}E~FEFKFMFTF[F]F^F_FaFpG?G@GAGCGDGFGNGOGZG\\G^G`GaGbGc"},
  {0,NULL,"GhGjGnGrGvG{G}HCHEHLHRHTHYH]HhHkHqHrHtHyI?I@IDINIQIUIYIaIbIeItI|J"},
  {0,NULL,"EJGJIJPJWJXJYJ[J\\J]J^JeJgJhJiJjKIKMKQKSKXK[KbKeKgKiKlKzL@LCLILJLO"},
  {0,NULL,"LQL]L_LdLgLqL{L|MDMHMLMTMUMYM\\M^M_MaMdMfMgMkMoMsMvM{M~N@NDNNNVNWN"},
  {0,NULL,"YN[NdNeNkNuNvNxN|OFOIOROTOWO]OgOkOnOoOtO~PCPFPIPRPXP^PaPhPkPnPrPs"},
  {0,NULL,"PtPuP{P}P~Q@QHQKQOQPQ]Q_QcQdQkQqQrQuQwQ{RARBRCRKRLRORTRWRXRdRfRgR"},
  {0,NULL,"iRlRqR|R~SASESJSLSOSQSSS[S^ScSlSnStSuSxSyT@TKTOTTTXTZT_TeTiTjTlTp"},
  {0,NULL,"TtTyTzU@UDUFUJUNUOUUUVUWU]U`UbUhUiUmUpUqUxUzU{_F?G?H?S?T?W?Y?b?c?"},
  {0,NULL,"f?k?l?n?w?x?{?~@H@O@R@Z@]@^@`@g@n@s@u@x@yA@ADAJALAQASAVA_AcAfAnAs"},
  {0,NULL,"AzA{BBBEBHBLBRB[B\\B`BbBdBkBlBnBoBtBuByB|C@CDCICOCRC]C^C_CkClCnCoC"},
  {0,NULL,"qC{D@DCDEDGDIDNDRDcDhDjDlDwEBEHEOETEVE\\E^E_EaEmEoEqErEtEzF@FBFKFL"},
  {0,NULL,"FMFRFWF\\FbFcFoFuFxFyF{GAGFGIGJGMGSGVGXGaGbGcGhGpGrGvGxGzG|HGHIHOH"},
  {0,NULL,"VHWH_HbHdHjHkHmHqH{H|H~IDILIUIVI_IbIeIhItIyJEJFJIJNJOJQJVJ[J^J`Jc"},
  {0,NULL,"JfJgJhJiJkKFKIKNKRKTK[K]K`KcKdKgKxKzK~LALGLNLTLYL]L^LrLtLuLvMEMFM"},
  {0,NULL,"NMOMWMYM[M]M`MaMbMcMeMlMnMsMuMwM|NGNKNPNSNWNZN\\N_NdNmNpNrNuO?O@OL"},
  {0,NULL,"OOOROUOYO_ObOgOhOuO{O|P@PLPPPVPZPdPgPiPlPoPuPvPwPxPyP~Q?QAQFQIQTQ"},
  {0,NULL,"[QaQgQhQiQqQrQuQxQ{RARBRFRJRLRNRRRWRZRdReRfRkRpRtRwRxRzSDSGSHSRSU"},
  {0,NULL,"S\\S]S`SdSlSnSoSqSvS}T@TDTTTUT\\T`TbTfTgTjTmTsTzT}UAUBUCUEUGULUQUWU"},
  {0,NULL,"XUYU[U`UdUeUlUrUsUtUwU|_D?F?I?Q?U?V?Y?Z?]?g?i?k?m?o?r@E@F@K@R@S@V"},
  {0,NULL,"@W@Z@`@e@n@o@q@r@vAAABAFARATAVAYA^AbAdAmAqAvAyA~B@BCBHBQBSB[BbBcB"},
  {0,NULL,"dBhBkBsBuBwBzB{B}C@CACJCOCRCYCaCcCeChCpCuCwC}D@DBDDDGDLDVDZD`DhDr"},
  {0,NULL,"DtD{D}EMEREWEXEZE\\E]E`EiEjEnEpErE}F?FDFJFMFTFYF[F]F`FeFkFsFtFuFvG"},
  {0,NULL,"EGGGJGLGPGRGSGXGgGhGkGoGqGtGvGwHAHDHHHJHKHVH[H\\H_HbHrHvHwHxH}H~I?"},
  {0,NULL,"IIILIRITI[I_I`InIrI~JGJMJRJTJVJXJZJ\\J]J^J_JbJgJhJkJlKIKPKQKSKVKXK"},
  {0,NULL,"fKgKiKnKqKvKzK{L@LHLRL\\L]L_LaLiLkLqL{L~MDMJMTM]M^M`MaMbMdMeMfMgMk"},
  {0,NULL,"MrMwM|M}M~N@NFNNNUNXNZN^NbNhNlNoNpNsNtNwOJOMOOOVO[O`ObOfOpOvOwOyP"},
  {0,NULL,"JPKPQPTPbPcPgPhPiPjPkPlPnPyPzP~QFQIQJQSQTQXQ^QbQmQnQqQuQvQzQ|Q}Q~"},
  {0,NULL,"R@RJRNRSRVR]R^R_RbReRjRnRtRyR{S?SCSKSNSPSXSZS_SaSfSkSqSrSsS}S~TAT"},
  {0,NULL,"DTMTPTXT[T]T_TjTlTmTpTtTuTwTzUDUEUGUKUMUOUQUSU]UbUcUeUfUiUlUn_E?F"},
  {0,NULL,"?J?Q?T?V?Y?^?c?f?i?k?n?r?v@B@C@G@M@T@U@X@_@c@f@o@p@t@w@yA@AEAJAMA"},
  {0,NULL,"OAWA[AaAbAkAmAqAwAxBBBGBIBKBPBUBVBWBYBZBfBgBhBiBpBsByB|CECOCPCSCT"},
  {0,NULL,"C\\CcCfCgCkCoCqCwCxCzC|C}DIDLDWD]DbDeDjDrDvEFENEOESETEZE[E]EbEkElE"},
  {0,NULL,"mEnEsEvEzFBFHFOFPFUFVF]F`FdFkFrFyFzF}F~GCGNGOGTGYG]G`GkGlGmGnGpGr"},
  {0,NULL,"GuGwGyHHHMHOHPHRH]H^H_HhHlHmHpHqHsHvH}IBIOIRIUI[IbIdIpIuJBJFJJJOJ"},
  {0,NULL,"RJSJUJXJaJbJdJeJfJgJhJjJkKGKJKOKQKYK\\KhKjKkKlKpKuKwL?LJLLLQLWLZLb"},
  {0,NULL,"LcLiLnLxLzL~M@MKMPMWMXMYM[M^M_MaMcMfMjMnMvMyM|M~N?NCNHNUNYN_NaNcN"},
  {0,NULL,"jNnNvN{OCODOEOHOIONOXOZOeOjOmOnOqOzP@PDPEPOPSPZP]PhPjPlPnPqPrPtPu"},
  {0,NULL,"PvPzQDQHQIQKQPQZQ`QaQbQeQsQwQyQzQ}RBRDRFRHRJRLRNROR]R_ReRfRlRsRtR"},
  {0,NULL,"xR{S?SDSHSKSPSRS\\S_SaSdSlSqSsStS|S}TMTNTRTTTXTYT]T^TaTcTiTrTtTwTx"},
  {0,NULL,"TyT|T~UHUIULUNUUUXUZUaUdUgUhUjUpUs_D?F?I?S?T?U?W?_?d?h?j?k?l?s?w@"},
  {0,NULL,"E@F@L@M@P@T@U@[@d@e@s@t@u@w@y@zA?AHANAOAYAZA]A^AhAnApAyAzA{BBBHBM"},
  {0,NULL,"BOBUBVBXBYB^BmBnBpBsBuBxB{B}B~C?CACJCPC`CaCcCdCjCqCxCyC{C|C~DADHD"},
  {0,NULL,"UDYD[D_DdDiDsDxD}EIEKENEOEQE[E^E`EkElEmEoEqEuExFAFJFNFOFQFZF[FcFh"},
  {0,NULL,"FnFqFuFyF{GEGFGNGOGUG[G_G`GcGdGmGoGqGsGvGwG{HEHHHJHLH[H\\H^HcHfHmH"},
  {0,NULL,"oHpHsHyHzH{ICIHINISI^IaIlImIvI~JDJHJOJQJSJUJWJ[JaJcJdJfJhJiJjJlKH"},
  {0,NULL,"KKKOKSKVKZKaKeKjKsKtK}L?LDLELILPLUL[LbLdLeLfLyLzM?M@MGMRMZM\\MaMbM"},
  {0,NULL,"dMeMfMgMiMlMqMsMtMwM{NHNLNONRNZN\\N_NdNgNhNuNyN}O@ODOHOLOPORO\\OaOg"},
  {0,NULL,"OhOlOqO{P@PBPMPPPZP\\PfPgPhPiPkPoPtPxPyP}P~QBQDQJQRQSQ]QbQcQkQmQoQ"},
  {0,NULL,"pQqQyQ{Q|Q}Q~RKRMRORPRUR[RcRgRlRoRrRuRyR{S?SCSKSNSPSXSZS_SaSfShSj"},
  {0,NULL,"SmStSxS{TETFTOTSTXT[T\\TaTbTdTeTrTsTtTuT}U?U@UGUKUNUWUXU[U\\U`UcUeU"},
  {0,NULL,"hUsUtUuUwUxV?_D?E?H?R?U?V?X?]?`?g?i?j?m?t?y@?@@@H@M@N@T@U@a@b@g@t"},
  {0,NULL,"@v@w@x@yAAACAFANAPAQA[A`AcAeAoAtAwAzBCBEBFBJBNBTBUBVBYB]BlBoBtBuB"},
  {0,NULL,"wBxByB|CFCJCLCSCUCVCYC[CfCjCoCwC{C}C~D?DADGDJDPDRDcDhDkDmDwD~EJEM"},
  {0,NULL,"ENEOEUE[E\\EaEkElEmEpEtE}E~FDFGFLFPFQFSF\\F_FaFlFwFxFzF{GGGHGNGOGZG"},
  {0,NULL,"\\G^G`GaGbGpGrGsGtGvGxHCHDHEHFHPHTH\\H`HgHhHmHpHsHtHwH~I@ILIMIVIXIZ"},
  {0,NULL,"I_IfIhItJ?JCJFJHJQJRJWJXJ_J`JaJdJfJgJiJkJlKFKJKKKRKUKWK^KdKpKrKsK"},
  {0,NULL,"uKyK}LBLGLPLSLVLYLZLhLwLxLyL}MGMPMQMUMVMXMZM]M^M`MgMhMkMrMuMxMzM}"},
  {0,NULL,"N?NLNMNTNXN\\NaNfNiNmNrNzN{N}OBONOPOSOUO^OaOdOmOrOuOwOxPEPMPQPSPUP"},
  {0,NULL,"fPkPmPpPrPsPwPyPzP{P|Q@QHQJQMQNQZQ\\Q^QcQdQpQqQrQxR@RARBRFRIRMRNRV"},
  {0,NULL,"RZR^RbReRhRjRkRoR{S?SBSISKSMSPSTSYS_SaSeShSkSqSrSvSwTCTDTQTUTWT\\T"},
  {0,NULL,"^TcTdThTnToTsTvTxT{T|U?UHUKUMURUYUZU\\UaUcUfUgUoUrUuUyU}V?V@_D?E?H"},
  {0,NULL,"?S?T?V?W?[?^?f?j?k?n?p?s@?@@@I@Q@S@V@W@Y@\\@g@n@p@q@r@u@{AEAJALAQA"},
  {0,NULL,"UAVAZAcAhAiApA}B?B@BFBIBJBQBSB_BaBcBeBiBjBtBvBwBxB{B|CACKCQCSCUCW"},
  {0,NULL,"CYCgCiCjCrCuCxC|D@DDDEDKDTDUD]D_DbDnDuDyD~EKEPEREVEZE]E^EaEiEjEqE"},
  {0,NULL,"rEsEvE{FBFIFKFLFMFZF\\FhFiFnFvFwF}G?GDGHGKGLGPGQGRGWGfGiGpGqGsGtGu"},
  {0,NULL,"GxG}HDHEHMHNHYH[HeHgHhHnHvHxHzH{H|H}IBIGIHIJI^IdIgIoIqJ?JLJNJSJTJ"},
  {0,NULL,"UJVJZJ[J\\J]J^JeJgJhJiJjKFKHKIKLKRK[K]K`KbKcKgKxKzK~LALCLNLOLTL]L^"},
  {0,NULL,"LeLgLmL{M?MBMLMTMUMVMWMXMYMZM[MaMgMhMnMsMtMuMyN@NDNJNON[NbNcNfNiN"},
  {0,NULL,"kNwNxN|N~OAOGOJOKOTO]OcOoOpOsOtOzO~PIPJPOPXPaPcPoPpPrPtPwPxPyPzP{"},
  {0,NULL,"P}QCQHQNQOQSQ^Q_Q`QcQlQpQxQ|R?R@RDRERFRHRORPRTRUR]R_RcRiRlRsRuR{S"},
  {0,NULL,"?SBSISKSMSPSTSYS_SaSeSjSmSsStSyS|TBTETRTVTWT[T\\T`TfTkTmTqTsTuTvUA"},
  {0,NULL,"UCUEUHULUMUPUQUTU^U_UdUfUgUkUlUvU~_E?F?J?R?T?U?X?\\?_?h?i?j?l?q?t@"},
  {0,NULL,"B@C@J@O@S@V@W@]@^@f@n@q@r@s@x@}A?AHAMAPARASAUAaAgAoAtAxA{A|A}A~BK"},
  {0,NULL,"BQBRBSB\\B`BcBhBiBpBqBrBtByB}CBCNCOCPCUCZCaCfCgClCuCvC{D@DADCDDDJD"},
  {0,NULL,"MDYD\\DaDdDkDoDzEFEHEKEMEPEWE\\E^EbEiEjEoErEtEuEwFAFIFSFUFVFWFYF_Fg"},
  {0,NULL,"FlFsF~G?G@GCGFGIGLGMGPGRGVGeGjGkGmGoGrGuGxH@HGHJHMHPHXH^H_HaHgHkH"},
  {0,NULL,"nHrHwHzH{H~ICIKIWIXIZIcIiIlIsJBJIJKJQJTJVJWJZJ\\J]J^J`JcJiJjJkJlKG"},
  {0,NULL,"KLKPKTKWK\\K]K_KfKmKoK|LALFLHLKLMLXL^L`LaLhLkLmLrL}MBMEMJMXMZM\\M^M"},
  {0,NULL,"_McMfMiMjMlMqMvMxMzM{NFNJNMNPNYN[N^NdNeNnNoNqNxO?OFOQOTOVOWOYO_Oi"},
  {0,NULL,"OkOtOvO{PFPIPKPPPTP^PaPhPkPmPqPrPsPtPuPvP|QDQIQNQQQVQZQ`QfQgQmQtQ"},
  {0,NULL,"xQyQzQ~RBRCRDRGRMRPRVRZR[RbRcRkRoRrRvRxR{S?SDSHSKSPSRS\\S_SaSdShSm"},
  {0,NULL,"SrSvSzS{TGTHTQTSTWTZT]T^TgTjTkTqTvTwTxTzUBUFUGUJULUNUPUVU]UbUdUeU"},
  {0,NULL,"hUkUmUqUwUxUyU}U~VB_E?G?I?S?T?W?X?\\?e?h?j?l?n?p?x?|@A@K@N@X@_@a@b"},
  {0,NULL,"@c@e@o@p@q@u@w@}@~AHANAWAYA]A^A_AfAiAsAvA}B@BABFBIBNBPBTBWBZB]BhB"},
  {0,NULL,"jBkBlBsBwBzB}CCCICMCNCTCVC[C]CbCfCsCxCyCzC}D@DCDGDMDODVD`DhDoDpD{"},
  {0,NULL,"ECEIELEOEPETEWE]E`EiElEnEqEsEwEyFAFHFJFNFQFRF[FbFiFoFtFvFwF}G?GBG"},
  {0,NULL,"TGYGZG\\G]G^GbGfGgGhGkGoGtGwHBHCHFHIHPHUHWHZH]HaHmHnHqHrHuHyH}IEII"},
  {0,NULL,"ILIWI_I`IiIjIrIzJDJIJJJPJUJVJXJ[J]JaJbJeJhJiJkJlKKKNKSKVKYKZKeKjK"},
  {0,NULL,"qKsKtKvK}L?LDLILPLUL\\LbLdLnLoLtL|MFMHMKMSMVMWMZM\\M]MhMiMjMkMlMqMt"},
  {0,NULL,"MuMwMzNBNCNGNVN[N]NbNcNfNlNtNzN|OAOCOKOSOZO[O]O`OcOeOoOrOzP?PHPIP"},
  {0,NULL,"OPYP`PaPiPoPpPqPvPwPyP{P|P}QAQEQKQLQVQYQZQ[Q\\QdQuQvQzQ}Q~R?R@RARG"},
  {0,NULL,"RJRVRWRZR\\RaRbRdRkRtRvRxR~SASDSHSJSOSQSRS\\S^SdSiSnSrSvSzS}TDTHTJT"},
  {0,NULL,"PT[T`TbTcTdTeTiTuTyT|T}U?U@UCUHUNUOUPUTU\\U^U_UgUhUiUkUuUvUxU|U~V?"},
  {0,NULL,"_D?G?J?R?U?W?X?d?e?h?j?l?m?y?z?}@D@G@Q@R@Y@Z@\\@`@f@p@q@s@u@y@z@~A"},
  {0,NULL,"GANAOAWAZA^A_AeAjAtAxA|A~B?BKBLB[B_BaBbBdBeBfBgBiBmBsByBzB|CDCGCH"},
  {0,NULL,"CLCQCXCYC^CeChCoCtCuCxC~DCDEDLDPDSDWDeDfDmDrDvEAEHEKELEOEUEVEZEbE"},
  {0,NULL,"iEmEoEqEsExEyFCFHFJFOFQFRFZFaFjFlFsF~G@GAGCGDGJGKGQGSGWGXGdGgGlGn"},
  {0,NULL,"GpGrGuGwGzG~HAHDHKHQHSH`HdHeHkHmHtHuHvHzH|IFIMIOIRI[I\\IfIpIuIxJFJ"},
  {0,NULL,"HJIJNJTJUJYJ[J]JcJeJfJgJjJkJlKHKKKNKOKVKYKaKcKkKqKtKvKxLDLELLLTLU"},
  {0,NULL,"L[L\\LcLeLoLtLyM?MFMGMSMVM\\MbMdMeMfMhMiMjMkMmMzM{M}M~NBNGNLNONWNYN"},
  {0,NULL,"^NeNkNnNoNqNvNxO?OIOQOTOVOYO_OiOnOtOvO|O~PAPCPRPVPXP[PiPjPkPmPnPs"},
  {0,NULL,"P{P|P}P~Q?QCQGQMQUQXQ^QiQjQnQoQsQvQwQ}RBRDRFRHRIRNRQRYR^R`ReRhRjR"},
  {0,NULL,"mRsRwRzSBSGSISMSTSUSYS]S`SeSgSkSpSqSwS|TCTITMTNTWTYT[TbTdTeTjTuTv"},
  {0,NULL,"TzT}T~U?U@UJUNUQUTUVU[U]U_UbUhUlUmUqUtUzU}V?VB_E?F?J?R?T?U?X?\\?_?"},
  {0,NULL,"h?i?j?l?q?t@B@C@J@O@S@V@W@]@^@f@o@p@t@w@y@}A?AGAOAWAYAZA]A_AgAoAu"},
  {0,NULL,"AwBCBDBEBGBJBQBRBSB\\B`BcBmBoBqBrBtBvBzB}C@CBCECOCRCWCZC\\CgCiCpCrC"},
  {0,NULL,"vCyC~D?DCDNDTDXDZDgDlDnDtDzD|EIEJEKELEMEYE_EbEkElEmEnEsEuEwFCFHFN"},
  {0,NULL,"FOFRFZF[F_FgFpFrFxFzF|GGGHGIGLGMGPGRGVGaGdGeGgGiGjGoGxGyG}H@HMHNH"},
  {0,NULL,"RHVHXH_HbHiHjHuHwHyHzI@IDIGIPITI]IeIgInIsIwJCJDJGJHJIJKJLJaJbJdJe"},
  {0,NULL,"JfJgJhJjJkKHKNKOKSKYKZKaKcKjKkKqKvKxL?LELLLTL[L\\LbLcLfLnLzL|M@MHM"},
  {0,NULL,"KMRMWMZM]MaMeMfMgMhMjMlMmMsMuM}M~NCNHNRNVNXN`NaNiNjNmNrNsN{N~OEOG"},
  {0,NULL,"OMONOUOXOfOjOmOsOuOxO}PDPEPSPUPWP]PkPlPoPrPuPyPzP{P|P~QFQIQPQQQTQ"},
  {0,NULL,"_Q`QeQfQlQoQrQtQvQxQ~RCRERLRRRSRTRXR]R_RfRiRnRpRqR|R}S@SESFSLSSSV"},
  {0,NULL,"SWS[SbScSlSoSsSuSyS~T?T@TATBT[T_TbTdTeTfTnTpTuT{T}U?U@UAUMURUSUTU"},
  {0,NULL,"YU[U\\U_UfUnUoUrUtUuUxUy_D?F?I?Q?U?V?Y?Z?]?g?i?k?m?o?r@E@F@K@R@S@V"},
  {0,NULL,"@W@Z@`@e@s@t@u@w@yAAABAIANAPAQAXA]A`AdAmArBABBBGBIBKBMBQBSB[BbBcB"},
  {0,NULL,"dBfBhBjBkBlBqBwBzB~CACKCQCRCZC`CaChClCoCpCzD?DBDCDEDKDMDODQD^DoDp"},
  {0,NULL,"DuD{E@ELETEUEYEZE\\E_E`EkElEmEoEqE}F?FEFGFNFQFSFXF\\F`FeFmFqFrFyF}G"},
  {0,NULL,"BGCGJGLGPGRGSGXGbGeGfGgGhGkGlGtG{H@HAHGHJHVHYH[HeHfHiHjHqHtHuHvH~"},
  {0,NULL,"IEIJIQIWIYIiIjIoIrI}JCJFJGJIJJJMJNJ[JaJcJdJfJhJiJjJlKEKKKRKUKWKZK"},
  {0,NULL,"`KaKoKrKsKyK}K~LELFLMLNLPLVL[LfLvLwLyMGMOMQMRMUMXMZM[M^M_M`MdMgMi"},
  {0,NULL,"MoMtMvMxMyNLNRNSNTNYN]N_NcNgNjNqO@OAODOEOHOKOLOQOXOcOhOiOjOqP@PBP"},
  {0,NULL,"CPDPRPZP\\P]PgPhPjPmPpPqPrPtPxPzQCQOQRQSQTQ]QfQgQmQnQsQtQuQvQzR?R@"},
  {0,NULL,"RARGRKRPRTRWRYR`RcRdRgRiRvRwRzR|SESGSLSSSUS[S]S`ScSgSmSnSxSySzTHT"},
  {0,NULL,"JTKTVTWTYTcTfTgThTnToTvT{T|T~UAUBUIULUTUUUVUYUZU_UaUdUjUpUqUrU}VD"},
  {0,NULL,"VEVF_D?E?H?S?T?V?W?[?^?f?j?k?n?p?s@?@@@I@Q@S@V@W@Y@\\@g@t@v@w@x@y@"},
  {0,NULL,"{AEAKAWA[A\\A`AaAbAhAiAsAyAzA{BEBLBMBQBSB_BaBcBeBgBiBjBkBnBrBvB{CB"},
  {0,NULL,"CFCKCNCUCVCYCeChCiCqCrCvCyCzDBDEDFDSDVD\\D`DaDfDqDyE?ELEQESEYE]E^E"},
  {0,NULL,"_EaEkElEmEpEtEvE{FFFGFHFPFUF]F^FhFiFoFqFxF{GAGEGFGKGLGPGQGRGWGcGf"},
  {0,NULL,"GhGiGjGnGqGuG}HAHCHDHKHTHXHYHaHgHiHjHlHoHuH{H}IAIFIIIKI\\I`IcIkIqI"},
  {0,NULL,"|JDJJJKJLJMJNJOJ_J`JaJdJfJgJiJkJlKGKJKMKQKUKYK_KkKnKpKrKuKyK{K|LL"},
  {0,NULL,"LRLVLZL`LcLlLnLwLxMAMKMPMQMVMXMYM\\M^MaMbMcMfMkMpMwMzM{M|N?NCNQNTN"},
  {0,NULL,"WN\\NdNgNhNmNpNrN}O?O@OLOOOPOUOYO_OaObOhOuOxPBPMPNPUP\\PePfPhPiPkPn"},
  {0,NULL,"PsPtPvPwPyP}Q@QNQOQQQVQXQ^Q_QdQnQuQwQ{Q|R?RCRDRERGRIRQRSRVR\\RaRbR"},
  {0,NULL,"hRmRnRvR|R~SASESJSLSOSQSSS[S^ScSiSpSrSwSzS~TGTITLTPTYT]T_TaTbTgTi"},
  {0,NULL,"TpTrTwTyT}T~UBUGUIUSUVUWUXU[U`UeUjUnUqUsUtUwVFVG_F?G?H?R?U?X?Y?Z?"},
  {0,NULL,"a?g?i?l?m?q?z?{?~@I@P@X@[@_@c@d@g@o@p@r@v@w@|ABAIALARAVA\\A^AbAgAj"},
  {0,NULL,"AtAzBDBEBFBGBJBOBPBWBXBZB^BiBjBkBnBtBvB{B|B~C?CDCICPCXCbCkClCmCtC"},
  {0,NULL,"vCxCzC}D?DDDKDSDUD\\D_DaDfDuDyEBEJELENEPESEWEZEaEjElEnEpEsE|F?FEFJ"},
  {0,NULL,"FKFMFYF]F^FgFjFlFrFwFxF{F|GHGTGUGYG[G]G_GcGfGhGiGpGqGuGxG~H?HBHGH"},
  {0,NULL,"OHWH^HcHdHfHlHnHrHsHuHvI@IFIHIJIKI\\I^IcIoIqIyJCJJJKJUJXJYJZJ\\J_Ja"},
  {0,NULL,"JbJeJgJiJjJlKIKMKPKQKVK[KbKeKiKlKnK{L@LCLILJLOLQLRL_LdLiLkLoLsL~M"},
  {0,NULL,"JMMMSMUM]M_M`MbMcMdMeMgMlMoMsMxM{M}NANBNFNUN\\N`NfNiNjNmNzN{N}N~OB"},
  {0,NULL,"OGONOPOSO^OaOdOmOrOsO}PDPGPHPWP]P_P`PgPkPlPmPoPsPuPxP|P~Q?QAQBQDQ"},
  {0,NULL,"RQWQYQaQgQjQuQxQ{Q|R?RDRERFRGRHRPRQRYR[R`RcRmRrRsRvRwRxRzSDSGSHSR"},
  {0,NULL,"SUS\\S]S`SdSgSmSpSzS{S|TETGTITVTXT^T_T`TdTjTlTpTtTxTzU?UCUDUMUOURU"},
  {0,NULL,"UUXUYU\\UfUiUoUpUrUsUuUyU{V?VBVDVH_E?G?I?S?T?W?X?\\?e?h?j?l?n?p?x?|"},
  {0,NULL,"@A@K@N@X@_@a@b@c@e@n@s@t@v@x@}@~AGAMAPARATAUAXAfAiApAyBBBEBHBLBMB"},
  {0,NULL,"NBPBTBWBZB]BfBhBkBqBuBwBzB{CECHCMCSCTCWCXC[CbCmCsCuCwCyC{D?DEDKDL"},
  {0,NULL,"DQDZD^DrDtDuD{EEEMEOEPEQEREUE_E`EkEoEpErEtEwEyFCFIFSFTFVFXFYFbFiF"},
  {0,NULL,"nFqFuFxFyGAGEGTGYGZG\\G]G^GeGgGhGkGlGqGtGvG~H?HBHFHNHQHRHZH]HhHjHm"},
  {0,NULL,"HnHoHtHwHxIJIQIRITIYI[InIoIrJAJCJDJNJPJQJRJTJ^J_J`JcJdJgJhJjJlKEK"},
  {0,NULL,"LKPKWKXK\\K^KhKiKmKoKwL@LBLFLKLMLSLWLXL_LhLjLmLpL}MBMCMIMUMYM\\M_Mc"},
  {0,NULL,"MeMfMhMjMlMmMsMyM{M|NENINJNMNWNZN_NgNhNmNpNuNyN}ODOHOOOPORO\\OaObO"},
  {0,NULL,"gOlOqOxO|PLPNPUPVPdPePlPnPoPsPtPuPvPwPxP}QEQHQKQPQUQWQYQ\\QjQlQqQs"},
  {0,NULL,"QtQuQvQzQ|R@RHRTRXRYR]R^R_R`RiRjRqRsR}S@SBSFSISMSTSVSWSYSbSeSgSkS"},
  {0,NULL,"sSuSyS|TATKTMTVTZT\\T^TaTgTkTlTqTrTsTxUBUDUFUGUJURUWUXUZU[U`UaUeUm"},
  {0,NULL,"UoUsUtUyUzU~VAVG_E?G?I?Q?V?X?Y?`?a?g?i?m?n?u?v?|@A@L@O@Q@Y@\\@]@^@"},
  {0,NULL,"e@o@p@q@u@w@|ACAFALARATAYA\\A^AkAlArAwAxBABBBIBMBRB\\B_B`BaBeBfBmBn"},
  {0,NULL,"BpBqBuBxB{CBCHCMCNCUCWC[C]C^C_CoCpCrCtC|C~DDDFDRDYD[DcDdDqDsDxEEE"},
  {0,NULL,"JEKEVEXEYEZE[E`EiElEnEqEsE|E~FDFJFKFTFYF[F^FdFfFmFqFyFzF}F~GBGIGK"},
  {0,NULL,"GMGQGVGWGcGdGeGlGmGqGsGvGzG|HFHIHNHQHXHZHaHgHiHpHvHzH|I?I@IAICISI"},
  {0,NULL,"VIhIkIlImIvJAJFJGJHJLJSJYJZJ[J]JaJbJeJhJiJkJlKMKPKSKVKXK[KeKfKgKn"},
  {0,NULL,"KqKvKzK{LHLILRL\\L]LaLdLgLoLsL|MHMLMMMSMUMYM\\M]M^M_M`McMkMlMrMvMwM"},
  {0,NULL,"xM|NANBNDNVN]N_NaNcNgNnNqO@OAOCOEOKOLOQOXOZOcOeOhOiOjOzP?PAPEPOPS"},
  {0,NULL,"PYP[PgPhPlPnPpPqPsPuPvPwQEQNQQQUQVQ[Q\\QhQiQlQoQpQqQsQtQyQ{Q|RIRMR"},
  {0,NULL,"RRURZR\\RaRhRkRoRpRuR}S@SBSFSISMSTSVSWSYSbSeShSiSjSoSvSwTFTLTSTUTX"},
  {0,NULL,"TYT_TfTjTkTlTpTqTtTzT~UAUDUIULUMUUUZU[U]UaUbUdUfUjUpUtU{V@VBVEVF_"},
  {0,NULL,"D?G?J?R?U?W?X?d?e?h?j?l?m?y?z?}@D@G@Q@R@Y@Z@\\@`@f@o@r@t@v@x@z@~AH"},
  {0,NULL,"AMASATAUAXAaAeAjAuAwAzBCBDBFBGB[B_BaBbBdBeBfBgBhBoBpBsBvB|CACCCGC"},
  {0,NULL,"KCQC]C^C_CdCeCqCsCuCvC}C~DBDIDOD[D]DbDjDpDsDvEGEHELEMENEQEXE]EbEj"},
  {0,NULL,"EkEnEpEtExEyFAFIFTFUFVFWFXFaFjFpFrFwFzF{F|GGGJGKGQGSGWGXGaGiGkGlG"},
  {0,NULL,"mGnGpGwGzG|HIHKHLHSHUHYH[HeHkHoHsHuHwH}I?IBIEISIUIbIdIjImIuI{JHJK"},
  {0,NULL,"JMJOJPJTJXJ\\J_J`JbJdJhJiJjJkKEKGKLKTKXK\\K]K_KfKhKoKwK|LALFLHLMLWL"},
  {0,NULL,"^L`LaLjLlLpLqMAMCMDMIMUMYMZM[M\\M`MeMhMiMlMqMsMuMvMxNENINNNQNXN\\N`"},
  {0,NULL,"NaNfNjNrNsN~OBOEOGOMOUOXO^OdOfOjOsOuOwPGPHPMPQP_P`PfPgPmPpPrPsPuP"},
  {0,NULL,"wPxP{P~QCQGQLQOQSQXQ[QhQiQkQrQsQwQyQzQ}RERFRJRKRORURWR\\RaRdRgRlRt"},
  {0,NULL,"RuRyR~SASCSJSNSOSQSXSZS^SfSiSjSnStSxS}TFTJTRTTTZT^T_TgTkTmTnTpTqT"},
  {0,NULL,"xT{UBUEUFUGUIUMUPURUYU\\UeUfUjUkUoUrUuUwUzU~V?VH_F?G?H?S?T?W?Y?b?c"},
  {0,NULL,"?f?k?l?n?w?x?{?~@H@O@R@Z@]@^@`@g@o@p@r@v@wA@ADAKAMAOA[A\\A`AbAfAnA"},
  {0,NULL,"pAvA}B?BABFBJBRB[B\\B`BbBdBgBlBoBrBuBwBxByC?C@CDCGCHCZC_CaClCmCpCq"},
  {0,NULL,"CrCsCwC~D@DHDJDPDQD^DiDkDmDwEDEIEMEVEXE[E]E_EaEjElEnEpEsEzF@FFFGF"},
  {0,NULL,"OFPFVF]F^FbFcFnFtFwG?GBGDGHGIGJGMGSGVGXGaGbGjGnGrGsGtGvG|H?H@HGHJ"},
  {0,NULL,"HQHSHbHcHdHjHpHwHyH|H}I?IMINIQIXIYIZIaIfItJ@JGJHJLJOJPJRJVJ\\J_JaJ"},
  {0,NULL,"bJeJgJiJjJlKJKMKOKQKUK\\K_KkKlKnKrKyK{K|LJLLLQLRLVL`LcLiLpLsLzL~M@"},
  {0,NULL,"MCMMMVMWMXM[M_MbMcMdMiMjMpMtMyMzM{NANHNINUN[N]NfNiNkNlNwNxNzN~OAO"},
  {0,NULL,"GOJOKOSOTOcOpOrOsOtOyO}P?PHPWPYP`PbPiPjPmPoPqPtPvPxP|P}Q?QBQFQGQU"},
  {0,NULL,"QWQfQgQhQmQpQqQrQwR@RARBRCRKRMRXRYR[R^R`RgRjRoRqRrRyR}S@SCSFSNSVS"},
  {0,NULL,"WSXSZSbSfSgShSkSuSxS{TCTKTOTQTYT[T]TaTiTkTnTqTrTuTwTyT{T~UHUIUPUS"},
  {0,NULL,"UTU]U^U_UbUgUjUkUnUvU|U~VAVFVKVL_F?G?H?R?U?X?Y?Z?a?g?i?l?m?q?z?{?"},
  {0,NULL,"~@I@P@X@[@_@c@d@g@n@s@u@x@y@|ABAFAQAXA[A]A`AcAgAjAuAxA{A}A~B?BLBO"},
  {0,NULL,"BPBWBXBZB^BgBiBjBrBvBwBxB{C?C@CCCICMC\\C_CcCkCmCtCuCyC|D?DADBDFDTD"},
  {0,NULL,"VD]D`DbDnDqDyEDEKENEQEREUEWEYEaEmEoEqErEtE|F?FDFGFLFNFPFXF\\FgFjFp"},
  {0,NULL,"FsF~G?GAGDGFGTGUGYG[G]G_GfGiGjGnGqGsGtGuGyG|H?HHHOHUHWHZHbHcHiHoH"},
  {0,NULL,"rHsHtHxHzIAIBIGIII`IdIgIkIqJ@JCJDJMJSJTJWJYJ[J^J`JcJfJgJhJiJkKEKF"},
  {0,NULL,"KJKRKUKZK^K`KdKpKsKuK}K~LBLGLNLPLSLYLZLfLjLuLvMIMNMOMRMWM[M]M^M_M"},
  {0,NULL,"`MdMiMjMkMrMuMvMzM~NENKNRNSNWN[N^NdNkNnNuNvN|O?OFOIOROWOYO]O_OgOk"},
  {0,NULL,"OnOoO{O|PAPKPPPTPVP[PiPjPmPqPrPuPvP{P|P~QAQBQEQFQLQWQaQbQeQhQpQwQ"},
  {0,NULL,"|R?R@RCRDRERJRRRSRUR\\R]R_RaRnRpRtRuRyR}S@SCSFSNSVSWSXSZSbSfSiSjSo"},
  {0,NULL,"SsS}S~TBTLTPTRTWTZTaTcTeThTnToTrTvT{T|U@UFUJUKUNUVUZU]U^UaUbUcUhU"},
  {0,NULL,"mUqUvUxUzV@VBVHVJ_C?F?H?J?K?L?X?\\?a?n?v?x@@@D@E@H@J@Q@R@V@Y@]@_@c"},
  {0,NULL,"@m@o@wA?ACADAFAGAOAPASAWAYAZA`AlAnAoApArA{B?BABCBFBHBJBVBWBXBcBdB"},
  {0,NULL,"eBiBjBsB|CACKCPCTCbCeChCkCnCxDADFDZD\\D^DjDsD{D}D~E@EAECEHEJEOEPEQ"},
  {0,NULL,"ERETEUEWEZE[E^EdEjElEmEnEsEuE{F?FCFEFMFNFYFZF`FaFcFkFnFtFyGCGDGMG"},
  {0,NULL,"OGQGUGVG^GfGiGnGwHCHDHEHFHJHLHOHTHUHVHZH^H`HeHkHmHnHoH{H~IAIBICIP"},
  {0,NULL,"IRIWI\\I_IaIhImIoIrI{I|JCJRJUJ_JdJeJgJjJrJuJwK@KEKNKRKXKYK[KcKdKgK"},
  {0,NULL,"jKvKxK~L?LCLELHLVLXL[L^L_L`LcLfLgLjLkLpL|L}M@MAMBMKMQMZM]MaMfMhMl"},
  {0,NULL,"MpMuM~NCNKNRN[N^NfNgNhNnNqNxNzOFOIOJOKOLOSOTOVO_OfOgOpOqOsOuOxOyP"},
  {0,NULL,"?P@PAPNPQPVPWP`PdPfPiPmPqPvPxP}QAQFQGQJQLQVQZQ[Q]Q_QdQfQqQtQuQxQz"},
  {0,NULL,"RBRVRWRXRaRbRdRgRnRsRwRzS@SBSHSNSPSRSSSTSVSaSkSvSySzS|S}TFTLTSTUT"},
  {0,NULL,"ZT]T_T`ToTtTvTxT|T~UCUIUNUWUYUcUfUhUiUlUpUsU{V?V@VBVDVEVI_C?D?H?I"},
  {0,NULL,"?O?P?T?^?_?i?r?t?{?|?}@I@K@S@T@U@Y@Z@]@^@k@q@r@{@}ABAHAJALAUAVAWA"},
  {0,NULL,"^A`AcAdAgAiAqAtAvA~B@BFBGBHBMBNBOBRBUB[BaBlBmBnBoCECFCGCHC\\C^C_C`"},
  {0,NULL,"CnCyD?DFDYD]D^DkDrDvD|EAEBECEGEHENEOEPEQESETEUEWEYE[E_EgEiEjEpEqE"},
  {0,NULL,"rExE{E|FBFCFLFUFXFZFaFbFeFkFpFuGAGCGGGPGRGTGVG^G_GaGdGsGvG{H?HBHF"},
  {0,NULL,"HIHKHPHTHWHZH^HcHdHeHiHjHlHpHqHuICIFIGIKINIUIZIhIiIjInIpIuJ@JAJEJ"},
  {0,NULL,"UJXJ^JbJeJgJhJvJwJ{KAKKKOKRKWK[K\\K`KbKoKsKxK|K~LALBLCLELRLTLVLWLZ"},
  {0,NULL,"L\\L]LeLhLiLlLmLzMKMLMMMPMSMTMUMVMWMXMYMZMrMsMtNDNONRN\\NaNdNhNlNnN"},
  {0,NULL,"pNtN}O?OMOOOQOROUOVO[OcOfOhOnOpOqOsOwOzO{PCPEPKPYPZP]P`PbPcPgPhPi"},
  {0,NULL,"PjPkPlQBQFQLQQQRQSQ\\Q^QdQfQjQlQsQuQwQzR?RDRYR\\R]R`RaRfRjRoRuRzS?S"},
  {0,NULL,"CSDSGSLSQSYS[S^SaSdSlSwSxSzS|S}TGTHTQTST_TaThTkToTyTzT}U?U@UFUTUW"},
  {0,NULL,"UZU]U`UkUmUoUpUrUuUwUxUyUzU{U|U}_C?E?I?J?K?M?Y?a?c?l?q?x@@@D@E@J@"},
  {0,NULL,"L@Q@R@W@X@Z@^@c@l@p@wA?ACADAFAKAPATAYAZA\\A^AcAlAnAoApAuAwA{A|BCBG"},
  {0,NULL,"BJBMBTBYBZBcBdBeBhBkBsB|CICKCQCTCYCfChCkCnC{C}DFDPDWD^DnDoDyD}D~E"},
  {0,NULL,"?EBEGEHEIENEPEQERESEUEWE[E\\E]EcEiEkElEnEsEvExE~FBFDFKFPFTFUF_FeFi"},
  {0,NULL,"FoFpFvFxG?GGGIGNGSGVGZG_GgGhGlGpG{G}G~H?HKHLHPH[H\\H]H`HcHfHgHkHrH"},
  {0,NULL,"sHtH{H~IEIHIIIMINIVIYIZI[IcIdIeIqIxI}JDJSJXJ[JbJfJhJkJqJyKAKBKLKP"},
  {0,NULL,"KRKUKVK\\K_KeKfKmKwKyKzK{LALHLILMLSLTLZL[L\\L]LfLgLpLsLvLxM?MGMHMIM"},
  {0,NULL,"NMSMUM\\M_M`McMkMmMwMxNBNDNPNWN`NhNjNkNlNsNwNyN{OGOMONOOOTOUO[OhOi"},
  {0,NULL,"OjOkOoOuOvOxOyO|O}PAPIPPPRPSPTP\\P]PkPoPrPzP|P~Q?Q@QDQQQRQTQYQcQgQ"},
  {0,NULL,"iQjQlQpQyQ~R?RCRDRPRQRRR`RcRhRiRmRtRxRyR{R|R}S?SOSQSXS\\SbSeSjSzS{"},
  {0,NULL,"S|S}S~TCTKTOTQTYT^TbThTsTuTxTyT|UCUEUJULUOUTU`UeUgUhUiUjUsU|U~V?V"},
  {0,NULL,"AVDVIVL_C?G?H?J?L?N?U?Z?d?k?o?w?|@@@C@I@J@M@N@U@X@Z@[@`@j@s@u@{@|"},
  {0,NULL,"A?AFAHAQARAUA[A\\A]AcAgAhAlApAqAwAxA}B@BDBKBMBRBTBYBZB[BaBfBlByB|C"},
  {0,NULL,"DCECRCTCVC[C^ChCoCrCvDSDVD[DiDlDtD{D~E@ECEEEFEJEKELEMEOESEXEZE\\E]"},
  {0,NULL,"E^E_EhEmEoEqEsEtEvEyE|FCFDFHFJFPFXF_FbFfFkFoFuFxFzGBGNGPGUGVGWG_G"},
  {0,NULL,"aGbGlGnGzG}H@HBHJHMHPHXHYHZH[HdHgHhHlHnHvH~I?I@IAIHIJILISIUI[I]Ia"},
  {0,NULL,"IfIiIlIrIwI|JFJTJVJ]J^JfJgJkJmJqJvK?KOKRKSKUKXK\\K_K`KjKpKuKwK}K~L"},
  {0,NULL,"BLILLLOLQLRLSLXLYL\\LfLjLoLqLzL{L~MBMJMLMNMOMWM]M^M_MdMiMpMuMvNENQ"},
  {0,NULL,"NSNYN\\NfNhNjNlNqN{N}N~OHONOQOSOUOZO\\ObOdOeOfOkOnOoOyP?PBPKPLPMPQP"},
  {0,NULL,"RP[P^PaPcPgPnPpPsPxPzQ@QCQLQOQRQVQWQ]QeQfQgQlQuQvQxQ|Q~RDRGRSRTRa"},
  {0,NULL,"ReRgRiRqRvRyRzSASBSKSMSRSWS\\S]SaSfSgSmSnSqSrSsTETFTOTSTYT_T`TeTqT"},
  {0,NULL,"sTxTzT}T~UBUJUSUWUYU_UgUhUkUlUrUtUwU}V?VAVEVGVKVPVQ_C?D?H?I?O?P?T"},
  {0,NULL,"?^?_?i?r?t?~@A@D@H@L@M@V@W@X@_@a@d@k@q@r@zA@ACAGAKANAOARASATAXA\\A"},
  {0,NULL,"eAkAnArAuAwAzA|A}B?BABLBPB]B^BcBdBeBhBiBwB{CACCCICOCXCYCbCgCoCqCu"},
  {0,NULL,"DSDUDXDhDlDpDzEAEDEEEFEGEKELEMENEOEREVEXEYE\\E^E_EgEiEjEpEqErExE{E"},
  {0,NULL,"|FBFCFLFUFXFZFaFbFeFkFpFuGAGCGGGNGOGQGSGTGVGfGhGkGuG|H?H@HDHGHIHL"},
  {0,NULL,"HQHXHZH[H`HaHdHmHpHsHuHwHzICIFIIIOISITIZIbIfIgIjIoIsIyIzJGJLJTJ^J"},
  {0,NULL,"bJeJgJhJvJwJ{KAKNKPKRKUKWKYK^KdKfKrKuKwK~LBLDLHLKLPLQLTLWL[L_LdLe"},
  {0,NULL,"LlLnLrLvL|M@MDMJMMMRMSMXMZM`MeMiMjMoMzM|N?NFNQN[N`NdNgNhNjNuNxNyO"},
  {0,NULL,"@OHOIOOOROTOWO^OaOeOfOnOoOrOuOwO}PCPDPFPNPSPUPXPYP`PaPhPkPsPuP{P}"},
  {0,NULL,"Q@QDQGQKQNQVQZQ]QaQgQiQmQoQpQqQrQxQ~RLRZR[R_RdRkRmRrRvR{R~S@SESIS"},
  {0,NULL,"MSPSUSZSbScSfShSmSoSrSsSuTCTFTITJTWTXT`TbTrTuTvTwT~UDUEUGUHUOUYUa"},
  {0,NULL,"UdUeUfUjUlUvU~VBVCVEVJVLVNVOVQ_C?F?I?J?K?P?V?]?^?j?s?t?~@A@D@G@L@"},
  {0,NULL,"N@P@S@U@V@_@a@i@n@r@zA@ACAIAKALAOASAUAXA[A_AeAkAnAsAuAvAzB?B@BABB"},
  {0,NULL,"BDBPBSB\\B]B^BbBhBtBwB}CICMCOCUCXCYCaCmCoC~D@DLDQDSDdDlDqDyD~EBECE"},
  {0,NULL,"DEGEHEKELEOEWEXEYEZE[E]E^E_EfEiEjEnEoErEyEzF?FDFFFJFRF\\F]FcFfFgFl"},
  {0,NULL,"FoF~GBGFGHGIGJGNGWG\\G`GeGgGtGxGzG}HBHIHJHNHOHQHSHUHYH_HcHeHjHmHpH"},
  {0,NULL,"sH{H}IBIKIMIQIUIWI^I`IaIeIhInIqIxJAJKJMJVJ]J_J`JkJlJoJxK?KDKHKLKM"},
  {0,NULL,"KSKUKZK]KaKeKtKvK}LALCLDLGLJLRLSLWLXLYLbLcLgLiLlLvLwL|MBMCMEMIMKM"},
  {0,NULL,"PMVMWMaMcMgMlMmMtMxNJNLNSNWNYNbNcNjNmNvNwOCOEOJONOQOROSOZO]O_O`Od"},
  {0,NULL,"OhOlOqOrOxO{O}O~PCPNP\\P_PbPcPdPfPiPjPrPtPwPxQ?QCQHQMQRQSQ\\Q`QcQeQ"},
  {0,NULL,"hQlQwQyQ{Q|Q}RDRHRIRUR`RbRiRpRsRuRwRyS?SJSLSNSQSSSVS\\S_SdSiSmSpSr"},
  {0,NULL,"SsStT@TKTOTTTYT[T^TlTuTvTwTzT{T|UFUJUKULU[UbUdUeUfUiUrUuUxU}U~VBV"},
  {0,NULL,"CVDVM_C?G?I?J?M?N?V?[?`?j?p?y?{@B@E@J@K@M@P@T@Y@\\@_@b@i@v@x@}AAAD"},
  {0,NULL,"AFAJAMAOARAVA_A`AaAdAfAoApAtAyA}A~BABBBEBHBRBVBWBXB[BaBgBnBpBsB~C"},
  {0,NULL,"?CGCKC\\C]CiCkCpCqDCDRDTDXDmDpDuDyD}E?EBEDEFEIEKELEMENETEVEYEZE\\E]"},
  {0,NULL,"E^EfEkEnEoEpEtEuE|F@FBFEFLFNFOF^F`FbFjFnFpFrFwFyGAGOGRGVGXGZG^GcG"},
  {0,NULL,"dGlGnH?H@HAHDHHHIHJHSHVHWHXH^H_HgHqHrHyH{H|H}IBIDIKISIVIXIYI^I_I`"},
  {0,NULL,"IfIpIqIwI}JOJTJZJ\\J^JdJhJjJnJrJ{KCKGKKKRKVKYK[K_KjKqKsKuK|L?LELGL"},
  {0,NULL,"ILJLNLQLTLULWLXL_LgLmLsLuLwLyM?MAMCMEMJMTMVM[MaMbMiMkMmMvMwNANQNV"},
  {0,NULL,"NaNgNhNiNkNnNpNqN{ODOHOIOOOPOROSOXO`OcOeOgOkOlOsOxO|O~PEPHPJPOPTP"},
  {0,NULL,"aPbPdPePlPoPsPtPvPwQ@QEQFQPQQQVQXQ]QdQgQjQnQxQzQ~R?R@RERGRSRTR`Rh"},
  {0,NULL,"RlRnRpRvRxS?SFSHSJSMSQSTSXS_S`SfSiSmSpSrSsStTCTDTQTUTZTbTfThTpTtT"},
  {0,NULL,"xTzT{T}UEUIUOURUTUbUcUhUjUkUqUrUwU}V?V@VHVLVMVOVP_C?E?H?J?K?O?U?]"},
  {0,NULL,"?_?k?r?s?~@A@D@G@H@N@P@S@T@W@X@d@j@n@q@zA@ACAGAIALANATAVA[A\\A_AeA"},
  {0,NULL,"kAnArAsAvAwA|A~BBBDBLBPBQB]B^B_B`BiBtB{B}CACCCMCUCaCbCgCmCqC~DDDJ"},
  {0,NULL,"DQDXDbDpDqD{D}EAEBECEEEHELEMENEPEVEYEZE[E\\E]E_EhEiEjErEsEtEwE~F@F"},
  {0,NULL,"AFEFSFVF[F^FdFiFjFmFnFwF|F}GEGKGMGOGXG[G`GiGjGoGqGzG|G~HAHFHKHMHS"},
  {0,NULL,"HVHWH]HbHdHgHiHmHpHsHvH~IGIJILINIPIVI[IcIiIkImIpIrI{J@JIJNJZJ[J\\J"},
  {0,NULL,"cJiJjJpJ}J~KCKEKGKIKQKYKZKgKhKkKlKzK|L?L@LBLILJLMLOLULVLYLZLdLfLh"},
  {0,NULL,"LlLqLvL|MFMGMLMNMQMTMUMYM^MdMfMkMpMsM~N@NHNVNXN]N^NgNiNmNoNrNzOBO"},
  {0,NULL,"GOPOVOZO[O\\O^OcOgOjOkOlOmOnOyOzO}PBPCPNPTPVPZP[P]P^PgPlPqPyPzP|QB"},
  {0,NULL,"QFQIQJQPQUQXQ[Q^QbQdQkQsQzR@RARBRFRJRKR^RaRcRjRnRqRtRzR|R}SDSHSKS"},
  {0,NULL,"OSTS[S]SaSeSgSmSnSqSrSsT?TLTNTUTZT\\T]TnTqTuTvTwT}U?UCUIUMUNU^UdUe"},
  {0,NULL,"UfUkUmUsUtUwUyU~VBVCVIVK_C?G?H?I?L?M?T?\\?c?i?q?v?}@?@F@I@K@T@U@]@"},
  {0,NULL,"^@a@c@d@k@o@p@~ABAEAHAJANAUAVAWAXAYA^AiAjAmAqAtAzA~B@BFBGBJBLBNBO"},
  {0,NULL,"BRBUB[BaBmBoBuBxCBCFCHCLCZC_C`CdC~DBDEDIDMDQDaDeDqDzD|D}D~EAEGEHE"},
  {0,NULL,"KEMEQEUEYEZE[E\\E]E^E_EgElEnEpEqEsEyE}F@FAFFFGFQFRFVFfFhFjFlFmFqF{"},
  {0,NULL,"F|F~GLGWGXGYG]G`GaGbGcGdG|G}G~HAHDHEHMHQHUHVHYH[H\\H_HkHoHtHwHxHzI"},
  {0,NULL,"CIEIRITIUIVIZI\\IaIdIgIpIsI|I}JHJVJZJ\\J]JaJiJlJsJtJxJ}KFKGKJKSKTKZ"},
  {0,NULL,"K`KpKqKsKvKwKyK}L?LDLGLMLOLSLUL_L`LdLkLnLpLrLtLxL}MBMDMHMSMTMWMZM"},
  {0,NULL,"\\MhMjMkMoMuMwNGNSNVNYNZN_NeNiNmNpN}N~ODOGOIOLONOPO\\O^O_O`OdOgOiOo"},
  {0,NULL,"OrP@PAPDPFPGPIPPPTPWPXP`PcPkPlPmPuPxP~QAQCQFQPQRQTQXQYQ_QdQeQlQtQ"},
  {0,NULL,"zQ|R@RCRDRGRSRTRdRfRiRmRnRoRyR{S@SCSGSHSPSTSYS\\S^SbShSmSoSrSsSuTM"},
  {0,NULL,"TNTRTTTgTiTlTnTqTsTtT{T~UAUEUUUVU[U^UbUcUgUjUlUnUtV@VAVEVFVKVLVM_"},
  {0,NULL,"C?G?I?J?M?N?V?[?`?j?p?y?~@C@F@G@L@N@Q@S@V@^@`@a@i@v@x@z@|AEAIAKAL"},
  {0,NULL,"APASAXA[A]A^AhAjAkAsAuAvAxAzB?BCBDBGBPBSB\\B]B^BbBqBtBwBzC@CMCOCSC"},
  {0,NULL,"XCaCjClCxC|D?DHDYD\\D`DjDrDwD|D~E@EBEDEIEJEKEOEQESETEUEWEZE[E_EfEk"},
  {0,NULL,"EnEoEpEtEuE|F@FBFEFLFNFOF^F`FbFjFnFpFrFwFyGAGKGOGQGRGTG[GkGoGtGxG"},
  {0,NULL,"yG|G~H@HCHHHPHTHVHZH\\H^HdHfHrHtHvHzH|I@IAIHIKIQITIVI\\I`IdIeIfIiIt"},
  {0,NULL,"I~JBJCJEJPJ\\J^JdJhJjJnJrJ{KCKIKKKNKQKWKYK^KaKkKtKxKyK{K~L?LBLELML"},
  {0,NULL,"NLQL\\L^LaLdLnLqLsLuLxL{L}MEMHMIMJMLMVM]M_MgMjMkMqMyM}NKNMNONXN[N]"},
  {0,NULL,"NaNdNgO@OBOCOEOGOHOKOUOXOYO^OfOgOiOnOpOsOvO|PBPFPHPIPMPQPRPTPXP_P"},
  {0,NULL,"bPgPmPrPsPwP~QBQGQJQMQNQSQZQ[Q\\Q^Q`QaQoQqQsQwQ{RBRMRNRORbReRiRoRr"},
  {0,NULL,"RtRwRyR|SASGSISVSWS\\S^ScSeSkSlSvSwSxSyTGTITLTPTXT]TdTkTrTsU?UAUBU"},
  {0,NULL,"CUDUGUNUQUZU_UaUgUmUnUsUvUyVAVFVGVIVJVNVSVV_C?E?I?J?K?M?Y?a?c?l?q"},
  {0,NULL,"?x?}@?@F@G@K@O@U@[@]@_@b@d@l@p@w@~ABAEAIAJANAOAQAUAWAaAbAiAjAmAsA"},
  {0,NULL,"tAyB@BABFBIBKBLBNBOBQBUB_B`BmBqBrBxC@CBCFCJCWC_CdCjCrCuDBDIDUD[Da"},
  {0,NULL,"DhDtDwD~E?E@EAEDEHEJELEMEQEREVEXEZE\\E^E_EcEiEkElEnEsEvExE~FBFDFKF"},
  {0,NULL,"PFTFUF_FeFiFoFpFvFxG?GGGKGPGSGTG]G_GjGmGoGsG{HAHCHGHJHKHNHSHXH[H`"},
  {0,NULL,"HdHeHhHjHoHtHxH{H|IBIDIFIHIMIPIYI`IcIhIlIoItI{I~JFJIJLJ[JbJfJhJkJ"},
  {0,NULL,"qJyKAKBKFKIKOKPKWK\\KhKiKkKoKuKwLBLCLHLJLLLPLULXLZL]L^LbLgLiLkLtLu"},
  {0,NULL,"LxM?M@MEMGMKMOMXM[M_MaMcMfMqMyM~N?NENHN\\N]N`NdNeNlNoNtOAOBOKOMOPO"},
  {0,NULL,"SOWO[O]ObOeOlOnOoOqOuOxO{P@PGPHPIPOPRPVPYP\\PdPiPoPpPwP|P}QBQGQKQL"},
  {0,NULL,"QOQUQWQZQ^QbQfQmQqQrQsQuQvRFRJRKR^RbRgRjRlRpRrRwSBSDSFSISJSRSVS[S"},
  {0,NULL,"_S`ScSgShSnSoSqSuTETGTITVTXTeTkTmToTpTqTvT{U?UAUGUSUZU\\UbUfUmUnUp"},
  {0,NULL,"UqUtUyU{VBVFVHVKVMVP_C?F?I?J?K?P?V?]?^?j?s?t?{?|?}@J@K@M@T@W@Y@\\@"},
  {0,NULL,"^@`@i@n@r@{@}ABAFAJAMARATAVA]A^A`AdAgAiApAtAxA|A}A~BEBGBHBRBVBWBX"},
  {0,NULL,"B[BaBfBgBmBnB~CDCFCGCVC\\C]C_CtCyCzDGDOD]D_DgDkDwE?EAEBEDEEEIEJELE"},
  {0,NULL,"NEOEPERETEUEVEYE[EfEiEjEnEoErEyEzF?FDFFFJFRF\\F]FcFfFgFlFoF~GBGFGH"},
  {0,NULL,"GLGPGUGWG\\G]GcGmGnGwGyGzG~HBHEHGHLHQHUHZH]HbHfHhHiHjHsHtHuI@IBIII"},
  {0,NULL,"JIOIQIVI^IcIeIfIgImItIzI{JQJRJYJ]J_J`JkJlJoJxK?KDKFKHKJKOKSKXKcKi"},
  {0,NULL,"KjKqKvKzK{K~L@LDLLLMLPLRLYL[L`LaLeLhLiLvLxL{MCMDMGMIMJMQM`MaMdMeM"},
  {0,NULL,"gMkMqM|M~NCNNNUNYN\\N_NcNeNfNqOAODOFOGOLOQOTOWOYOZO_ObOfOjOmOrOvOw"},
  {0,NULL,"OzO{O}PIPMPSPTPUP^P_PdPqPrPsPtPuP|QAQIQKQOQPQVQWQXQ]Q_QkQmQrQtQvQ"},
  {0,NULL,"xR@RARVRWRXRdRhRlRqRrRtRxR|S@SFSISKSPSXS]S`ScSeSkSlSvSwSxSyTBTETR"},
  {0,NULL,"TVTcTeTgTmToTqTrTyT~U@UCUPUSUUU\\U`UlUoUpUsUtUvUzU{U|VEVIVKVNVRVW_"},
  {0,NULL,"C?D?I?J?N?P?Y?Z?b?l?w?z?|@@@C@J@L@P@R@U@X@Z@b@c@l@u@y@{@|A?AFAKAU"},
  {0,NULL,"AYAZA\\A_AaAcAgAhAlApAuAwAyA{B@BBBJBMBTBYBZBcBdBeBfBkBzB|CDCQCSCTC"},
  {0,NULL,"VCfChClCvDDDEDJDMDVDbDeDiDwD|D~E?EBEEEHEKEMEPESEUEVEXEYE\\E]E_EcEi"},
  {0,NULL,"EkEmEoEqEwE{E}FEFFFGFIFMFSFaFdFhFlFnF{G@GDGEGLGMGQGUGYG[GhGkGpGwG"},
  {0,NULL,"|HAHEHFHIHMHNHRHTHXH_HaHbHeHjHlHnH|H}I@IDIGIIIKIMIRIYI^IdIhIjIkIt"},
  {0,NULL,"IzJBJGJHJNJaJcJeJjJlJpJtJzK@KEKJKNKQKTKXK^KcKfKmKuKxL@LCLFLGLKLOL"},
  {0,NULL,"ULVLWL`LbLdLiLjLuLwLzL{M?MCMFMHMKMMMVMYM[M`McMhMqM|M}N@NFNGNXNZN["},
  {0,NULL,"N^N_NfNsNyO@OFOLOPOROVO\\O]O^O`OaOeOmOpOqOtO{O~P?PHPKPMPOPSPWPZP\\P"},
  {0,NULL,"bPhPiPoPtPyP~QAQDQIQJQNQTQYQ[Q_QaQiQkQoQpQtRARBRCRLRZR[R`RbRfRkRl"},
  {0,NULL,"RtRwR|S?SCSESFSQSVSYSZS`SeSgShSnSoSqSuTBTLTPTRT]TcTdTgTpTvTzT~U@U"},
  {0,NULL,"BUDUNUPUQUUU_UaUfUlUoUqUrUzU}VBVEVGVHVJVO_C?E?H?J?K?O?U?]?_?k?r?s"},
  {0,NULL,"?{?|?}@I@J@M@U@V@Z@\\@]@`@j@n@q@{@}ABAFAHAMARASAUAWA]AcAdAgAiApAqA"},
  {0,NULL,"xA}B?B@BEBFBMBRBTBYBZB[BaBfBgBlBoB~CDCECHCVC]C^C`CsCzD?DGDNDYD_Df"},
  {0,NULL,"DrDxE@ECEDEEEGEIEJELENEOEQERESEWEXE[E_EhEiEjErEsEtEwE~F@FAFEFSFVF"},
  {0,NULL,"[F^FdFiFjFmFnFwF|F}GEGLGRGXGYGZG[GbGlGpGrG|G~H?HCHHHNHOHRHSHUHWH\\"},
  {0,NULL,"H`HaHiHjHmHoHuHyILIMIPISITIWI[I`IaIbIkIoIvIxIyJPJSJWJ[J\\JcJiJjJpJ"},
  {0,NULL,"}J~KCKGKJKKKQKTKVK_KmKnKpKvKyK|LFLHLJLKLMLNLTL^LbLcLdLeLhLiLkLyL|"},
  {0,NULL,"M@MBMEMFMNMRM^McMfMiMjMlMnMxMzNMNPNTNXNZN_NaNiNkNsN{N|N~OGOJOKOOO"},
  {0,NULL,"XO]O^O_OaOcOiOlOtOuOwOzO{P@PJPNPVPXP[P\\PaPfPwPxPyPzP{P}Q@QCQEQMQN"},
  {0,NULL,"QTQYQ`QaQeQgQnQoQ{Q|Q~RCRERPRQRRReRgRkRmRpRsR{SASBSESJSNSRSSSWSZS"},
  {0,NULL,"_SbSjSlSwSxS{S~TATDTMTPTdTfTiTjToTyT{T|U@UDUEUQURUVUXU`UaUbUiUjUo"},
  {0,NULL,"UpUzU{U|VDVJVLVMVUVWV[_C?F?H?I?L?P?W?b?d?m?o?z@?@A@B@H@K@O@P@Q@S@"},
  {0,NULL,"Z@[@\\@h@s@y@~A@AAAGAJALAMAPAQA_AbAcAeAfAmArAtAvBBBCBEBIBKBMBQBVBW"},
  {0,NULL,"BXB_B`BpBvBxB{C?CBCCCNCcCdCgCiCsC|C}DHDNDWD`DfDoDzD|D~EEEFEGEIEJE"},
  {0,NULL,"KEOEPERESEUEWEXE[E]EeElEmEoEqErEuEzE~FAFBFKFOFWF[F`FgFiFmFpFrFsF}"},
  {0,NULL,"G?GKGOGSGXGZG]GcGfGiGmG~H@HBHCHFHHHNHTH]H_H`HcHgHhHlHpHwHxH}I?IAI"},
  {0,NULL,"GIMIOIUIXI[I\\I^IjIlInIsIzI|JCJQJSJ[J`JdJhJiJnJyJ|J~KFKGKIKPKVKYKd"},
  {0,NULL,"KgKiKqKxKzLALGLHLILLLMLNLQLRLVL^LbLlLoLrLtLwLzL}MCMMMNMOMPMWMYM]M"},
  {0,NULL,"bMcMeMoMuM|NKNNNPN]N`NeNgNiNkNxNzOAODOGOHOKOQOVOXO]O`ObOhOjOkOpOu"},
  {0,NULL,"O~PCPDPGPKPLPQPUPZP\\PcPePhPjPmPpPtPzQ@QGQJQOQPQTQWQXQYQZQ[QgQqQvQ"},
  {0,NULL,"~R@RBRCRVRWRXRbRfRmRqRuRvRwR{SCSKSLSMSVSYS]SbSdSfSjSkSvSyS{S~TCTI"},
  {0,NULL,"TMTNTXTbTiTnTqTrTtTvTxU@UFUGUOUVU^UcUfUhUoUtUuUvUxUzV?V@VBVKVNVUV"},
  {0,NULL,"VVY_C?E?H?I?M?O?W?[?e?m?u?y?{@B@E@H@K@M@P@Q@[@\\@a@c@h@t@x@}AAADAG"},
  {0,NULL,"AJAMAPAQARAXAYA_AdAfAoArAtAzA}BBBCBEBJBKBQBVBWBXB_B`BjBnBpBvC?CGC"},
  {0,NULL,"NCPC\\CcCeCiCpCvD@DLDTDVDdDiDmDvD|E@EBEFEGEHEIEKELESEVEWEXEZE\\E]E_"},
  {0,NULL,"EeEkElEpErEtEvEwF?FCFFFHFIFYF]F_FcFdFkFlFtFzG@GHGJGMGPGUG\\G^GiGmG"},
  {0,NULL,"qGsGzG|G}HGHJHOHPHRHVH[HaHbHeHfHkHqHrHuHyHzIEIGIHIOITIWIZI\\IbIeIk"},
  {0,NULL,"IlIuI~J@JFJKJNJ_JcJfJgJlJmJuJzKDKEKHKMKOKXK[KgKiKlKoKwK{L?L@LCLFL"},
  {0,NULL,"KLPLSLXLYL\\LcLdLeLmLnLpLsLyL}MFMIMOMRMSMYM\\M_MeMjMlMrMsMyN@NENJN\\"},
  {0,NULL,"N^NbNcNfNnNrNtNzOAOJONOSOUOWOZO^OaOgOmOoOqOtOvOwO|PAPEPFPJPPPRPUP"},
  {0,NULL,"XPZPfPkPmPpPrPyP{QHQIQJQLQOQSQWQ[Q\\QfQhQkQuQvQwQ}RARBRJRKR^R_RgRm"},
  {0,NULL,"RoRtRuR{R|R~SBSGSLSRSUS^SbSdSeSgSiSnSpSqStT@TBTHTST[T_TaTcToTpTwT"},
  {0,NULL,"}UAUCUEUKUPUWU]UdUjUkUnUpUqUsUwU{VCVFVHVIVLVOVZ_C?F?H?J?K?L?X?\\?a"},
  {0,NULL,"?n?v?x?}@?@F@G@I@O@T@X@[@^@a@b@m@o@w@~ABAEAHAIAQAVAXA\\A^AaAbAiAjA"},
  {0,NULL,"mAqAsAwAyAzA~BGBIBKBNBOBSBUB\\BbBoBqBrBuC@CHCJCLCWCZC`CjCpCuDEDMDT"},
  {0,NULL,"DUDeDhDmDxD}E?E@EEEGEHEIEKELEREUEVEXEYE\\E]E^EdEjElEmEnEsEuE{F?FCF"},
  {0,NULL,"EFMFNFYFZF`FaFcFkFnFtFyGCGDGJGQGRGTGYG^GeGrGvGxGzH@HDHHHIHKHLHTHY"},
  {0,NULL,"HaHbHeHfHgHiHoHtHxH~I?IAIIIJINIWIXI[I]I_IeIjImIvIxJ?JGJKJOJ_JdJeJ"},
  {0,NULL,"gJjJrJuJwK@KKKMKNKTKWK[K]KbKnKtKxK{K}L@LCLILKLNLQLWLYLZL[L_LfLhLk"},
  {0,NULL,"LoLtLxL~MAMIMMMNMQMUM]M`MbMdMlMnMxM{NANFNJNZN[NaNbNdNnNvN|O?OEOHO"},
  {0,NULL,"IOROTOXOZO[OaOdOkOmOpOqOvOyOzP@PGPIPLPQPSP]P^PePfPhPnPqPrPvPzQDQE"},
  {0,NULL,"QHQNQQQSQ\\QaQhQiQjQnQoQpQwQ}R?RERHRIRURcReRhRkRqRuRxR}SASESKSLSOS"},
  {0,NULL,"WSXSZS]SdShSiSoSpStSuTDTHTJTPTWTaTdTfTqTuTyT{UAUBUFUHUQURU]U_U`Ub"},
  {0,NULL,"UeUnUtUuUxU|U~VFVGVKVMVPVX_C?G?H?I?L?M?T?\\?c?i?q?v@@@D@E@H@L@O@V@"},
  {0,NULL,"W@X@Y@Z@_@k@o@pA?ACADAGAKAOASATA\\A`AbAcAlAnAoArAuAwA|B?BABHBIBMBP"},
  {0,NULL,"B]B^BcBdBeBhBiBjBkCACICPCQCYCbCeCfCzC{DADGDPDZD_DnDsDvE?E@EAEFEGE"},
  {0,NULL,"IEJELENEOEQERESETEUE\\E^EgElEnEpEqEsEyE}F@FAFFFGFQFRFVFfFhFjFlFmFq"},
  {0,NULL,"F{F|F~GIGLGMG[G\\G`GkGqGtGuGyGzG{HAHBHEHHHRHSHTHWHYH\\HhHkHlHqHxH{H"},
  {0,NULL,"~IDIFIJITIUIXI]I`IgIjIlIpIuI~J?JJJPJYJ\\J]JaJiJlJsJtJxJ}KEKHKJKLKQ"},
  {0,NULL,"KZK^KaKlKrKxKyK|K}LFLJLLLNLRLULYL]L`LaLfLgLmLpLtLzL~MDMEMMMOMTMWM"},
  {0,NULL,"XM[MbMdMjMrMyM{NINMNUNWNXN^N_NcNmNrNuO@OCOLOMOPOQOXOYOZObOcOdOiOl"},
  {0,NULL,"OpOtOxOyPAPEPGPKPOPXPYP^PcPePhPlPnPpPuPwQHQIQKQMQNQUQ`QaQbQhQkQmQ"},
  {0,NULL,"oQrQ{Q}RARFRMRNROR_ReRjRlRuRvR~SASDSFSLSMSUSWS[S`SdSfSlSwSxSzS|S}"},
  {0,NULL,"T?T@TATBT[T\\TcTjTpTxT|U?UBUCUFUKUMUPUXU_UhUiUmUqUsUuUxUyV?VDVGVHV"},
  {0,NULL,"IVTVVV[_C?D?H?J?N?O?X?`?e?n?p?u?~@C@F@G@I@O@R@V@\\@^@a@b@m@t@v@z@|"},
  {0,NULL,"AEAHAIAMASAXAZA^AaAbAhAjAkAqAsAyAzA{B?BEBGBIBNBOBSBUB\\BbBqBtBuByC"},
  {0,NULL,"@CLCMCRCZC[CaCjCtC{C|DHDODPD`DgDnD{D}E@EBEEEFEIEKENEOEPERESETEUEV"},
  {0,NULL,"EWE\\EdEjEkEmEpEtExEzE}FAFDFQFTFWF\\FeFgFhFmFoFqFsFvGFGIGKGWG]G_G`G"},
  {0,NULL,"aGeGjGvGyH?HAHBHEHGHOHRH[H]H^H_H`HcHmHnHvHyHzH|IDINIOIRISIWIZI]I^"},
  {0,NULL,"I_IkIoIrIwJ@JJJQJXJ`JaJbJiJkJoJsJ|KBKFKIKLKSKZK\\K]K`KbKhKwKzLALEL"},
  {0,NULL,"FLGLHLPLRLTLUL`LaLcLjLnLqLuLyL|L~M@MAMCMFMSMUM[MeMhMiMlMpMsMvNDNI"},
  {0,NULL,"NNNWNYN]NeNlNmNoNvN}O?OJOLOOOPOQOWOYO`OhOjOoOsOtOuP?PBPFPHPJPNPOP"},
  {0,NULL,"UPWP]PaPfPkPnPtPvPyP}QHQOQPQQQRQUQWQXQbQhQjQlQvQ}R?R@RDRFRYR\\R]R_"},
  {0,NULL,"R`RgRkRnRqR~S?SBSESHSKSQSRSTSUSZS]SkSvSySzS|S}T?TETNTOTYT\\TeTnToT"},
  {0,NULL,"sTtTwTzU?UDUJUMUSU^UaUcUdUgUmUpUrUyU{U}V@VAVCVJVTVWVY_C?D?I?J?N?P"},
  {0,NULL,"?Y?Z?b?l?w?z@?@A@B@G@K@O@Q@W@[@]@`@d@l@u@y@~A@AAAIAJANAPAQATAWA]A"},
  {0,NULL,"bAeAfAmAsAtAxA|BCBFBIBKBLBNBOBQBUB_B`BpBrBxB}C?CBCJCUCWCdCiCmCsCw"},
  {0,NULL,"DADKDNDZDcDfDsDyD~E?ECEDEFEJEMENEOEPEQERESETEWEXE^EcEiEkEmEoEqEwE"},
  {0,NULL,"{E}FEFFFGFIFMFSFaFdFhFlFnF{G@GDGEGJGMGXGYG^G`GdGeGjGsGyHDHFHLHMHO"},
  {0,NULL,"HPHRHWHYHZH\\H]HaHrHsHwH}I?I@ICIDIHIIILIQI]IbIcIdIfIhIqIwJAJJJUJWJ"},
  {0,NULL,"aJcJeJjJlJpJtJzK@KEKGKMKTKZK[K]KhKoKsKyKzK|K}K~LFLKLOLVL[L\\L_LaLc"},
  {0,NULL,"LoLrLsLvLwL{L~MGMHMJMKMRMZM[M^M_M`MgMmMtMvNINRNTNZN^NbNiNmNnNoNpN"},
  {0,NULL,"tNvOIOJOTOUOVOYO\\OaOcOdOfOiOjOtO|O}O~PDPLPMPOPRPSP[P_P`PiPnPsP{P|"},
  {0,NULL,"P~QCQEQFQHQLQUQbQdQeQfQhQnQuQzQ|Q}RERFRYR\\R]R_RaRhRiRpRrRxRyRzR~S"},
  {0,NULL,"ISJSUSXS\\S_SaScSjSzS{S|S}S~T@TDTTTUTZT[TfTlTrTsTtTwTyT}UFUIUKURU["},
  {0,NULL,"U`UcUdUgUkUuUvUwUxU|V@VAVCVNVVVWV^V__C?D?H?J?N?O?X?`?e?n?p?u?{@B@"},
  {0,NULL,"E@H@J@N@Q@T@Y@[@_@c@m@t@v@}AAADAFAGAOAPAQAVAYA[A`AdAfAoApArA~BABC"},
  {0,NULL,"BDBHBJBKBVBWBXBcBdBeBgBjBsBvB~CKCNCPC]CcCeCkD@DBDCDIDLDRDaDdDuDxD"},
  {0,NULL,"|D}E@ECEDEHEKEMEQETEVEWEXEYEZE^E_EdEjEkEmEpEtExEzE}FAFDFQFTFWF\\Fe"},
  {0,NULL,"FgFhFmFoFqFsFvGFGIGLGSGZG\\G]GfGpGuGwGyG{H@HGHKHMHNHQHYH\\H_HbHcHdH"},
  {0,NULL,"iHqHrHvHyI?IAIFILINIQIRI]IdIiImInIoIvIyJBJHJLJMJ`JaJbJiJkJoJsJ|KB"},
  {0,NULL,"KFKHKJKLKPKVKcKdKmKrKyK}L@LALBLDLGLOLPLQLZL]LaLbLhLmLoLqLsLyL~M@M"},
  {0,NULL,"HMLMPMQMUMXM]M^MgMhMnMzM}N?NGNLNWN_N`NcNeNkNsNuNxOFOHOMOWOYO[O\\O]"},
  {0,NULL,"O`OdOhOiOmOnOrOzO|PBPEPJPLPQPWPYP[P]P_PgPjPnPqP}P~Q?QAQGQKQMQTQYQ"},
  {0,NULL,"ZQ_Q`QcQmQqQrQtQyQ{RCRLRZR[RaRcReRfRrRsRzR}SASCSISNSOSSSWSYSaScSh"},
  {0,NULL,"SiSoSpStSuTATKTMTVT^TiTjTmTpTrTuT}U@UBUEULUVUXU\\U_UeUjUkUoUqUvUwU"},
  {0,NULL,"zU~VGVHVLVNVQVZV]V`_C?F?H?I?L?P?W?b?d?m?o?z?|@@@C@I@L@M@N@R@`@b@c"},
  {0,NULL,"@d@h@s@y@{@|A?AHAKANARAYAZA[A]AaAgAhAlAqAuAxAyA{A}BDBJBLBSBTBYBZB"},
  {0,NULL,"\\BbBkBlByBzCECQCRCSC[C^CfClCrDCDDDJDRD[DbDtDuDvD|E?EAECEFEHEJELEM"},
  {0,NULL,"EPETEVEXEYEZE]E^EeElEmEoEqErEuEzE~FAFBFKFOFWF[F`FgFiFmFpFrFsF}G?G"},
  {0,NULL,"IGKGRGZG[G_GgGrGtGvGyG}HCHDHGHKHNHQHSHVH]H^HaHgHkHlHnHuHwI@ICIEIO"},
  {0,NULL,"IPIQIXI\\I_IbIcIgInIuJ?JAJIJMJOJ[J`JdJhJiJnJyJ|J~KIKKKLKQKVK\\KaKbK"},
  {0,NULL,"eKnKzL?LDLELILJLKLPLSLZL^L_LaLbLeLjLpLrLzL{L}MAMDMGMPMRMZM\\MbMeMf"},
  {0,NULL,"MgMrMtM{NANHNLNWNXN]NaNkNlNwN|O?OCOIOKONOWOYO[O]OaOgOjOkOlOrOsOwP"},
  {0,NULL,"?PAPDPKPMPPPUPVP_P`PePjPmPuPvP{P|Q?QBQEQMQQQUQ^Q`QbQcQjQnQsQyQ{R?"},
  {0,NULL,"RERFRHRIRUR_RdRhRjRoRsRxR~S@SDSGSNSPSSSUSXS[S^SgSiSnSpSqStT?TATGT"},
  {0,NULL,"QT\\ThTjTkTwTyTzT|T~UAUBUMUTUXUZU_U`UdUiUlUnUrU|U}VCVDVEVFVGVQVXV\\"},
  {0,NULL,"Va_C?E?H?I?M?O?W?[?e?m?u?y?~@C@F@I@L@N@O@R@S@Y@`@b@h@t@x@z@|AEAHA"},
  {0,NULL,"KALAZA[A]A`AaAbAhAjAkAqAuAvAxAyA{BDBHBIBSBTBYBZB\\BbBuBwByBzCLCOCR"},
  {0,NULL,"CSCXCZC[ClCtCwCxDKDOD\\DcDgDjDzD|D}EAEDEFEIEJEMENEPEQERETEVEWEZE[E"},
  {0,NULL,"eEkElEpErEtEvEwF?FCFFFHFIFYF]F_FcFdFkFlFtFzG@GHGJGNGQGUGWGYGbGgGh"},
  {0,NULL,"GrG{HFHHHJHLHMHOHUHWHXHbHcHfHhHpHqHvHxHzH|IBIEIFIGILIXIYIbIlImInI"},
  {0,NULL,"pIsIyI}JDJRJWJ_JcJfJgJlJmJuJzKDKMKNKSKTKUKXKeKfKnKpKuKvK{K|L@LALL"},
  {0,NULL,"LNLOLVLXL[L]LcLlLmLnLqLtLuM?MOMPMQMRMTMXMYM\\M^MaMbMoMwMzNBNCNTNYN"},
  {0,NULL,"ZN[NbNfNjNwNyN|N~OJOMOSOTOVOXO\\O_ObOcOeOhOmOvPBPCPEPFPGPHPPPYPZP["},
  {0,NULL,"PdPePjPlPoPpPqP{Q?QAQCQDQEQVQ]Q_QcQeQiQnQpQtQxQyQ|RERPRQRRRcRdRfR"},
  {0,NULL,"jRpRvR}S@SCSDSJSMSOSPSYS[S_SfSjSkSvSyS{S~TFTJTRTTTWT`TgTlTsTuTxT{"},
  {0,NULL,"U?U@UDUHUUUYU[UaUbUeUgUhUmUoUyUzU~V?VAVJVMVRVTV[V__C?G?H?J?L?N?U?"},
  {0,NULL,"Z?d?k?o?w@?@A@B@G@H@P@R@S@W@\\@]@d@j@s@u@~A@AAAGAIALAMANATAWAZA_Ae"},
  {0,NULL,"AfAmArAsAvA{A|BBBEBFBLBPBQB]B^B_B`BrBvB{B}CCCJCNCUCWCcCgCmCwCyC}D"},
  {0,NULL,"KDWD]DcDkDoDxD|D}E?ECEEEIEJEMENEPEQESETEUEYE[E]EhEmEoEqEsEtEvEyE|"},
  {0,NULL,"FCFDFHFJFPFXF_FbFfFkFoFuFxFzGBGJGNGPGSGTG\\GoGqGuGxG{G}H?HCHEHIHPH"},
  {0,NULL,"QHRHUHXH^HfHhHnHoHwHyH}I?IEIJIKIPIRISIYI_IaIgIiIkIvJ?JBJDJEJYJ]J^"},
  {0,NULL,"JfJgJkJmJqJvK?KHKMKOKPKUKWKkKlKrKtKuKvK{LDLELFLLLSLTLWL\\L]L^L`LjL"},
  {0,NULL,"kLoLrLwLyM?MAMBMDMFMLMVM\\MdMfMhMiMnM{M}NBNONUN\\N`NbNcNdNjNrNuOBOE"},
  {0,NULL,"OKOLOMONOOOROUO_ObOeOrOsOtOvO~P?P@PDPJPLPPPVPWP^PaPbPgPoPuPvPxPyQ"},
  {0,NULL,"?QBQDQIQKQSQ\\Q^QcQiQkQmQpQrQsQwQyRARMRNRORcRkRlRnRoRsR}SESFSGSHSN"},
  {0,NULL,"SOSSSTSZS^S`SjSlSwSxS{S~THTJTKTVTWT^TaTmTpTrTtT|UAUDUFUHULU\\U]UaU"},
  {0,NULL,"cUiUnUqUuUvUxV@VDVFVHVJVNVSVTVYV^_D?G?I?M?N?P?S?\\?_?g?r?v?{?|@?@D"},
  {0,NULL,"@F@I@S@T@Y@]@c@d@f@o@q@{@}@~ACAEAHALANAVAWAYA`AdAgAjAmAnAqAvA~BFB"},
  {0,NULL,"HBJBLBlBmBuBvBzCECFCLCNCSCZC^C_CcClCnCyC~DBDFDIDQD]D^DaDkDqDvDyDz"},
  {0,NULL,"D{D~EBEFEGEKENEOESEUEWE\\E]E^E_EaEcEfEgEpEqEvEzFDFIFOFPFYF[F\\F_FgF"},
  {0,NULL,"oFrFtFxF}G@GFGJGLGMGOGTGZGaGgGjGmGnGoGuGwG~HCHHHKHLHSHUHaHbHeHnHs"},
  {0,NULL,"HvH{IAICIJILIMISIXI]I_IbIeIkIoIpIrIxJCJGJNJPJ`JfJkJnJoJqJuJzJ~KEK"},
  {0,NULL,"JKMKVKWKYK`KcKeKhKiKjKkKrKvL@LCLJLKLMLNLZL[L^LgLjLqLvL~M@MAMFMIMR"},
  {0,NULL,"MTMZM]M^MbMcMdMiMpMxN@NFNKNMN^N_NbNdNgNkNoNqNuNwN}OAOBOFOGOKOTOXO"},
  {0,NULL,"[O_OaOlOmOqOxO}P?PBPQP[P\\P^P`PaPePlPnPrPvPyP{P}QDQFQJQMQRQ[Q`QdQi"},
  {0,NULL,"QlQpQzQ{RBRDRHRIRPRQRRRURfRgRlRoRqRrSBSCSFSGSISKSRSYS]S^S`ScSgSkS"},
  {0,NULL,"nSqSvSyT?TBTDTFTITOTPTXTYT\\T`TcTdTfTpTrTuT|UGUJUMUPUQURUYUeUiUqUv"},
  {0,NULL,"U~VDVHVNVOVVVYVZV\\V_VcVdVeVf_D?G?H?L?N?O?S?^?c?g?q?t?{?|@?@D@F@K@"},
  {0,NULL,"S@U@Z@^@a@c@f@p@r@{@}@~ACAEAJALAUAXAYA^AcAdAgAjAmAnAtAvAzB@BGBJBM"},
  {0,NULL,"BnBoBvBxBzCBCGCHCNCSC\\C`CcCdClCnC~D?DEDFDMDQDYD^DeDqDrDvDyDzD{D}E"},
  {0,NULL,"AECEFEMENEOEPEQETEYEZE\\E^E`EdEgEhEpEqEuEwFEFHFKFNFSFWF]F`FdFnFsFy"},
  {0,NULL,"FzG?GEGHGIGKGLGNGTGUGdGeGiGkGlGpGrGxGzG~HGHKHNHUH`HeHfHhHmHrH}H~I"},
  {0,NULL,"DIHIIIOIPIQIUIYIZI^I`IfIlImIqI{JDJLJMJYJcJdJjJmJpJrJyJ|KDKIKJKLKU"},
  {0,NULL,"KWKXK]K^K_KgKmKnKsKtKvK{LCLHLLLMLPLYLZLbLfLsLwL|M?MCMEMJMOMQMSMWM"},
  {0,NULL,"[M_M`MeMfMgMmM~N?NBNLNUNWN]N_NdNfNjNpNsNvNzN{N|O@OEOGOWOZO[O]O_Ob"},
  {0,NULL,"OqOuOvOyO|O~PNPOPRPSPUPVP_PcPkPoPpPqPsPtPwQ?QFQGQIQRQZQcQdQkQlQqQ"},
  {0,NULL,"yQzRARDRJRKRVRWRXR^ReRfRhRkRoRpRxSASCSESGSJSWSXSYSZS^S_SiSjSpStS{"},
  {0,NULL,"S~T@TATCTETJTUTVTWTZT[TbTeTjTmTvUBUCUDUHUIUKUOUSUXU\\U_UaUfUsVBVGV"},
  {0,NULL,"IVJVQVTVXVYVZV[V\\V]V^V__D?F?J?K?N?P?R?\\?e?f?u?v?{@@@B@D@F@H@N@R@T"},
  {0,NULL,"@Y@]@c@e@o@t@}A?AAACAEAGAVAWAYAZA[A`AdAfAjAlAnArA{A~BDBFBHBJBiBlB"},
  {0,NULL,"sBvB}CACECKCNCUC^CbCcCkCmCnCxDBDCDFDIDRD\\D^DaDjDuDwDxDzD{D~E@EDEE"},
  {0,NULL,"EJEKEOEREUEVEWEXE^E_EaEcEdEfEjEmE|E~FBFHFJFKFLFSFVFbFiFpFzF|G?GAG"},
  {0,NULL,"BGEGIGPGWGYG[G^GcGdGfGgGhGlGoGvGzG{G}HAHJHRHVHWH\\HfHpHtHwH|IGIHIJ"},
  {0,NULL,"IOIRIUIXIZI`IbIgIjIkImIsI~JJJKJVJWJ[J^JhJmJpJyJ{J}K?KLKOKQKSKTK[K"},
  {0,NULL,"_KbKdKeKfKkKqKsKyK{K|L?LFLSLULXLYL]LlLrLuLxMDMEMFMMMQMRMSMWMYM_Mb"},
  {0,NULL,"MdMeMhMoMyNINJNSNTNWNXNYNZN\\NnNpNwNxNyN{O?OBODOMONOPOSOZOcOgOiOtO"},
  {0,NULL,"vPCPDPHPIPRPUPWPZP^PcPePhPkPqPuPwPyP{QAQCQGQSQUQZQ\\Q_QbQeQqQtQwQ|"},
  {0,NULL,"RFRJRKRMRNROR^R`RaRhRmRsRvRxRzR{S?SMSNSQSSSXSaSbSfSjSmSrSsS{S~T@T"},
  {0,NULL,"BTDTITJTNTOTWTXTYT[TcTfTnTyTzU?UAUGUHUJUKUPURU^U`UmUnUrUyU|U}VFVP"},
  {0,NULL,"VQVUVVVWV^V`VdVeVfVh_D?E?J?K?N?O?Q?b?c?h?q?z?|@?@C@D@E@L@P@Q@U@Z@"},
  {0,NULL,"^@c@g@p@y@{@|@~ACADAKAPAUAYA^A_AcAgAhAmAnAoAuB@BBBCBGBJBMBhBnBtBz"},
  {0,NULL,"B|CGCICMCSCTCYC\\CaChClCnCvC}DEDFDMDVDWD^DeDiDoDwDxDyDzD}E?EDEEEIE"},
  {0,NULL,"MENEPEQEREVEXEYE\\E`EcEdEhEiEkE|F?FCFOFRFXFYF\\F^FbFcFkFrFtFuFwF~GF"},
  {0,NULL,"GMGRGXG\\G]G_GaGbGfGhGiGnGsGxGyG}HBHCHEHSHTHVHYHgHoHpHzI?ICIFIJIMI"},
  {0,NULL,"OIQITI_I`IbIdIlInIpIsJ?JIJJJQJZJ^J_JgJnJoJuJvJxKCKEKFKGKHKKK\\K`Kd"},
  {0,NULL,"KfKgKjKoKpKtKxK}L?LILJLRLSL^L`LaLkLlLnLoMAMEMHMOMPMRMTMXMZMcMdMeM"},
  {0,NULL,"gMjMoM{NHNINNNVN^NaNcNeNiNlNqNtNxNyNzN}N~OEOKOLONOQOYOdOgOkOlOpP@"},
  {0,NULL,"PCPFPLPUPXPYP\\P^P_P`PjPlPpPvPwP{P~QBQDQHQPQTQXQYQ^QhQiQpQsQ}R@RCR"},
  {0,NULL,"HRIRMRNRORUR`RaRdRgRtRvRzR|S?S@SBSMSPSQSRSaSeSfSkSmSrSsSvSyT?TATE"},
  {0,NULL,"TITJTTTUTWTXTZT\\TeTjTlToT}UAUFUGUHUIUMUSUXU[UkUnUpUuUwUxU{VFVOVPV"},
  {0,NULL,"RVTVWVXV]V^V`VdVg_E?G?H?L?M?O?R?Z?]?f?s?w?{?}@@@A@C@J@N@U@V@[@]@`"},
  {0,NULL,"@e@n@u@|@}A?A@ABAFAQASAUAWA[A]AdAeAhAiAlApAxB?B@BDBFBKBgBjBlBqB|B"},
  {0,NULL,"~C@CECPCTC]C^CeChCjCoCrCsD?DNDSDYD[DfDlDrDtDxDyDzD{D}EEEFEGEIEKEL"},
  {0,NULL,"EMENERESE[E\\E]EbEeEgEhEsEtEuExFBFMFOFQFUFYF\\F`FeFpFqFrFtGDGFGGGJG"},
  {0,NULL,"PGQG[G]G`GdGfGgGlGoGsGtGvGyHBHEHFHNHQHZHaHbHeHpHrHwH{IBIDIKILIOIR"},
  {0,NULL,"IVIYIaIcIdIeIjImIqIzJJJKJNJYJbJdJhJnJoJsJuK@KAKFKMKNKOKQKZK_KaKbK"},
  {0,NULL,"dKeKkKoKsK~L@LCLDLKLRLVL`LaLbLgLlLrLsM?MBMGMHMIMMMQMVM[M^MaMeMhMk"},
  {0,NULL,"MmM|N@NINJNUNXN[N\\NbNeNmNpNtNwNxN{O?OBOCOLOQOVOYO]OaOfOmOqOrOxO|P"},
  {0,NULL,"CPDPOPTPUPWP[PbPdPhPoPqPrPxP|P~Q@QCQHQJQKQ[QeQgQhQmQrQ|Q}Q~RBRLRV"},
  {0,NULL,"RWRXRZR[R`ReRgRhRjRoRxS?SASBSDSGSQSRSWSXS[S^SiSpStSzS|S}T?TBTCTHT"},
  {0,NULL,"KTRTUTZT\\T^TaTbTcTgTrTvU?UAUIULUMUOUPUUU]UfUmUnUvUyVBVFVNVOVPVTVX"},
  {0,NULL,"VYVZV[VbVcVdVi_E?G?J?K?M?N?R?_?d?f?o?r?{?}@@@A@C@I@M@V@X@Z@[@\\@e@"},
  {0,NULL,"q@s@|@}A?A@ABAHAMAQARASA\\AcAdAeAhAiAlAqAwA}B?BEBKBMBfBjBoBqByC@CD"},
  {0,NULL,"CHCPCRCVC[C`CeCjCoCsCvCzDGDNDSDVD_DfDiDlDxDyDzD{D}D~ECEDEJEMENEQE"},
  {0,NULL,"WEZE[E]E^E_EaEcEfEhEsEtE}F?FFFGFNFTFWFZF]FcFhFlFsFvFyF{GCGHGIGOGP"},
  {0,NULL,"GSG[G^GbGcGeGhGkGmGqGwHBHGHIHKHNHTHZH]H^HaHsHxHzH}IEIFIGINIQISIXI"},
  {0,NULL,"ZI[I\\I_IgIhIpIsJAJCJEJIJLJ_JaJlJrJtJwJ|KBKDKLKOKPKQKYK[K]K^KcKfKi"},
  {0,NULL,"KlKpKqKxKzK~LELKLPLRLWLZLbLnLtLvLwL}MAMDMKMNMSMTMUMXMYM\\MbMgMiMoM"},
  {0,NULL,"tN?NHNKNONWNXN\\N`NgNnNrNvNyN~O@OAODOFOQOROWO[O]OaOfOjOpOsO}O~PFPG"},
  {0,NULL,"PPPYPZP]P_PaPePiPkPlPmPuPvPzQ@QCQGQSQUQZQ\\QbQeQgQqQwQ|Q~RFRHRIRUR"},
  {0,NULL,"YR\\R]RdReRfRgRlRtR|S@SASBSCSFSPSRSWSYS`SeShSkSoSuSvSyTGTJTLTNTQTT"},
  {0,NULL,"TVTWT]ThTkTlTmTnTpTwUCUFUHUNUTUZU[U\\U^UdUqUsUuUxVCVHVIVPVSVZV[V]V"},
  {0,NULL,"^V_V`VaVd_F?G?I?L?M?P?Q?]?`?h?p?s?|?}?~@B@E@J@P@T@W@\\@^@b@g@n@v@z"},
  {0,NULL,"@{AAABADAFAMATAVA^A_AaAfAgAiAkAoApAyA|A~BBBEBGBfBkBnBrBsCDCGCJCKC"},
  {0,NULL,"QCVCWC\\CfCkCpCqCtCyDODTDXD]DgDkDmDpDwDyDzD{D~EAEDEFEJEKELEMEOERET"},
  {0,NULL,"EZE[E^EbEeEfEgEnEoEvE{FCFGFHFKFSFTFZF_FaFkFvFzF{G?GCGEGKGRGSGYG\\G"},
  {0,NULL,"`GaGhGiGnGqGsGvGxG|H?HGHKHNHRHWH\\HbHcHnHpHzH~IAIFIMIPIRIVIWI[I]I^"},
  {0,NULL,"IaIbIdIiIrIyJIJJJMJPJeJfJgJmJpJtJwJyKBKHKIKKKPKTKZK`KbKfKgKjKlKoK"},
  {0,NULL,"tKyK|L@LALFLPLTLZLbLdLfLjLlLnL~MBMCMHMLMNMRMXM]McMfMhMkMlMpMzNHNI"},
  {0,NULL,"NLNMNZN]N`NaNcNmNqNrNtNyNzN}O?OEOOOWO[O]O^OcOhOiOmOtOyP?PCPFPQPTP"},
  {0,NULL,"VPWPYP\\PfPgPnPtPxPzP{P~Q?QNQPQUQVQXQ]QaQbQcQoQxQyR@RFRLRPRQRRRZR["},
  {0,NULL,"RaRgRhRlRoRuRxRzSBSFSGSLSRSXS^S`SaSdSgSnSqSzS|S}T@TATFTGTLTMTOTYT"},
  {0,NULL,"[T]T`TiTjTkTuUAUDUFUJUKUNUVUXUYUZUaUeUnUuUxU~VFVJVPVQVVV[V\\V^V_Va"},
  {0,NULL,"VcVfVj_F?G?J?K?L?N?Q?[?^?h?t?y?|?}?~@B@E@K@M@W@Y@_@`@b@g@r@x@z@{A"},
  {0,NULL,"AABADAJAOARATA]A`AaAfAgAiAkAoAtAxAyA|A}BABHBgBkBmBpBrB~C?CFCJCQCW"},
  {0,NULL,"C]C_CfCiCqCtCzDCDGDODRDXD_DgDpDuDwDyDzD{D}D~EBEEEIEKEOEPEUEYEZE[E"},
  {0,NULL,"\\E]E`EdEfEhEnEoE}E~FAFIFMFPFQFUF[FhFiFmFqFxF}G@GDGGGMGNGQGRG\\G_Gb"},
  {0,NULL,"GcGfGjGpGrGtGuG{H?HGHOHPHWHaHbHdHeHmHvHwHxIBICIEIHINITIUI\\IfIhIjI"},
  {0,NULL,"kIlInIsJ@JDJEJGJKJ[JaJiJqJsJzJ~K@KAKEKHKKKNKUK\\KaKdKhKmKnKpKqKrK|"},
  {0,NULL,"L@LBLCLKLPLTL\\L]LcLqLrLtL|L}MFMJMKMMMOMPMUMWMZM\\M_MaMjMoMsNBNFNJN"},
  {0,NULL,"ON[N^NaNcNjNlNoNsNuNxN|N~OCODOJOMOOOUOWOaOcOmOnOqPBPDPGPNPPPRPXP]"},
  {0,NULL,"P`PcPdPhPiPjPmPpPsPyQBQDQHQPQVQXQ]Q^QhQiQpQsQxQ}R@RJRKRYR\\R]R^ReR"},
  {0,NULL,"fRhRlRmRsRxR{SASCSFSNSSSWSXSYS`SbShSjSoSuS{S~THTITKTNTPTSTTTXT^T_"},
  {0,NULL,"TaTdTlTnTwT|U?UBUGULUQUWU[U]U^U_UdUiUmUyVCVDVGVPVSVYV\\V^V`VbVcVdV"},
  {0,NULL,"e_D?G?H?L?N?O?S?^?c?g?q?t?}?~@@@A@E@L@M@O@W@Y@_@d@f@p@r@zA?A@ABAD"},
  {0,NULL,"AKANAOARATA`AbAeAiAkAlAoAuA|A}BABHBIBLBiBkBpBwByC?CACOCQCRCXC[CbC"},
  {0,NULL,"fCiCqCuCzDADGDUDXDZD_DhDpDsDvDwDxDzD|E@EEEGEIEKEOEQESEUEXEYE\\E_E`"},
  {0,NULL,"EdEgEhEpEqEuEwFEFHFKFNFSFWF]F`FdFnFsFyFzG?GEGHGJGPGVGZG]G`GdGiGjG"},
  {0,NULL,"kGnGoGrGwGzG}HJHKHLHSHUH]H`HcHiHoH|I@IEIFIHIKIQIVIWIYI[I^IdIgIhIn"},
  {0,NULL,"ItIxJFJQJVJXJcJdJjJmJpJrJyJ|KDKFKMKOKRKVKZK^KcKgKhKjKkKnKsKvKzLAL"},
  {0,NULL,"HLJLSLXLYLZL[LhLkLuL{M?MCMDMHMKMNMPMVMXM\\M_MgMkMlMqMxNDNENNNSN\\Nb"},
  {0,NULL,"NeNhNkNmNoNpNqNzN|O@OBOFONOSOTOZO[O_OhOjOlOuOzP@PHPMPPPRPTPYP_PbP"},
  {0,NULL,"fPiPjPoPtPuPzP~QCQKQNQOQQQWQaQeQjQmQoQrQvQ|R?RHRIRPRQRRRUR_RaRbRn"},
  {0,NULL,"RtRvRwRzR|R~SHSMSTSUSVSaSeSfSgSkSnSqSvSyTGTKTNTOTPTRTSTYT^T_TdTgT"},
  {0,NULL,"kTnTtTyT{T}UJULUQUUUWUZU^U`UbUcUkUwU|V@VMVOVQVTVUVVVYVZVbVdVeVlVm"},
  {0,NULL,"_E?F?H?K?L?O?S?[?b?g?y?z?{@?@A@C@E@K@P@Q@S@Z@a@c@f@x@y@|@}@~A@ADA"},
  {0,NULL,"JALAPAXAYA_AcAdAeAhAmAoAtAvAzBBBCBJBMBhBnBoBvBxCBCGCHCICNCYC\\C`Cc"},
  {0,NULL,"CdCvC|C}D@DHDLDVDWD`DdDiDoDvDwDzD{E@EAEEEFEIEJELEOEPEREVEXEZE\\E`E"},
  {0,NULL,"dEeEhElErExEyFDFGFJFLFTFVFZFeFfFoFvF{F|GAGBGCGJGQGVGZG[G`GaGgGmGo"},
  {0,NULL,"GpGuGwGxH@HDHIHMHPHRHWH\\H^H_HjHnHtHvIBICIGIIIQISIVIYI\\I]I`IcIhIpI"},
  {0,NULL,"tIwJGJOJPJWJ]JbJkJtJwJ{J}K?KBKMKNKQKRKVKZK`KcKeKiKkKmKrKtKyK|LELF"},
  {0,NULL,"LGLOLQLWL\\L_LiLjLqLxL}L~M?MEMGMKMTMYMZM`MaMgMiMkMqMvNANFNMNTNXN[N"},
  {0,NULL,"bNhNkNmNsNuNwN}OAOBOEOFOHOIOROUO\\O`OcOiOsOtO{P?PBPIPSPTPZP_P`PaPd"},
  {0,NULL,"PiPlPmPnPoPwP|QCQJQNQOQQQWQ[QaQeQjQoQvQ|R?RBRGRSRTRYR\\R]RcRlRmRrR"},
  {0,NULL,"sRuR{R}SFSISLSNSOSSS`SbScSdShSlSoSuSwSxTATDTETGTJTRTUTWTZTeTfTgTj"},
  {0,NULL,"TkTsTuTzT|UHUIURUSUUUXUZUeUgUiUrU}U~VAVDVPVQVTVUVWVXV[VbVcVfVgVl_"},
  {0,NULL,"E?G?H?L?M?O?R?Z?]?f?s?w?|?~@?@B@D@G@P@R@T@W@X@\\@e@n@u@z@{@~AAACAI"},
  {0,NULL,"AMATAVAZA\\A_AfAgAkAmAnAsAwA{A|A~BBBEBrBsBtBuB{CCCJCKCLCMCWCZCaCgC"},
  {0,NULL,"kCqCyC}DDDJDWDXD]DbDkDoDpDvDwDxD{D|E@EAECEHEJELEMEQESETEZE[E_EbEe"},
  {0,NULL,"EgEhEsEtEuExFBFMFOFQFUFYF\\F`FeFpFqFrFtGDGFGGGIGLGNGUGXG^GcGfGhGkG"},
  {0,NULL,"lGmGoGvHBHFHIHLHOHQHYH]H_HaHlHtHuH|IBICIDIHIJIMIWI]I`IdIeIfIkInIt"},
  {0,NULL,"JAJHJRJVJWJbJdJhJnJoJsJuK@KAKGKJKLKUKXK[K^K_KbKdKfKiKkKqKzK}LDLGL"},
  {0,NULL,"KLRLVLWL[LcLeLuLxLzL~MEMFMHMIMJMPMZM[M_MaMcMdMlMqMtNCNGNSNTNWN_Nf"},
  {0,NULL,"NiNjNnNxNyN{O?O@OAOBODOJOQOROTOVO`OaOdOjOrOwPHPIPKPOPRP\\P^P`PdPfP"},
  {0,NULL,"jPnPrPsPwPyP~QAQBQEQIQRQ^Q_QkQlQnQsQtRARDRERHRIRURYR\\R]RbRcRmRnRr"},
  {0,NULL,"RvRwR{R}SHSISMSOSTSVSbScSfShSkSoSuSvSyT@TETFTGTMTPTTT[T`TdTeTiTkT"},
  {0,NULL,"lTxTyTzUEUKUQUSUVUYUZU[U`UhUjUrU|U}V?VLVQVSVTVUVZV[V]V_VaVbVgViVj"},
  {0,NULL,"Vn_D?F?H?L?O?P?R?`?a?f?p?x?{@@@B@D@F@J@N@Q@V@[@]@_@e@v@w@}A?AAACA"},
  {0,NULL,"EAFAOAPAQASAWA[AdAfAjAlAnApB?BABCBDBFBKBgBjBlB|B}B~CECPCTCUC]C^Ce"},
  {0,NULL,"ChCmCxD@DADBDIDLDZD\\DaDdDjDsDwDxDzD{D|D}EAEEEHEKEMEPERETEUEVEYE[E"},
  {0,NULL,"bEdEeEgEjEmEwEyFFFIFPFRFXF[F^FdFfFlFuFwFxF}F~G@GIGKGNGTGXG^GbGeGk"},
  {0,NULL,"GmGqGsGtGwG{H?HHHJHPHSHVH[H\\HgHjHxHzI@IAIDIEIIIKIMISI[I^IcIeIfIoI"},
  {0,NULL,"pItI}JEJIJOJXJ]JcJlJqJvJxJzJ~KCKGKIKLKUKWK[K]K^KaKcKiKlKoKpKwKyL?"},
  {0,NULL,"LILJLNLTLXL\\L]LiLnLtL{M@MCMGMIMJMNMTMVM[M\\M]M`McMiMqMwNANDNHNONWN"},
  {0,NULL,"]NdNiNjNnNrNtNvN~O@OAOCOFOMOOOSOUOXOgOiOkOlOoO{PFPGPMPOPPPQPSP\\Pa"},
  {0,NULL,"PbPlPrPsPtPzP|P}QAQBQEQGQRQZQ^Q_QlQnQqQsQtRDRERGRPRQRRRSRTR_RaRlR"},
  {0,NULL,"sRtRuRzR|R~SFSLSNSSSUS`SaSdSeSgSlSnSqSwSxT?TCTETHTPTQTRT\\TaTbTdTe"},
  {0,NULL,"TgThTsTwT{UFUMUOUQUSUTUUU]UbUdUgUuUxVAVCVMVQVRVTVUVXVYV\\V^V`VbVgV"},
  {0,NULL,"l_D?F?H?L?O?P?R?`?a?f?p?x?}?~@?@C@E@G@R@T@X@\\@^@b@e@v@w@z@|@~ABAD"},
  {0,NULL,"AIAMAVAZA\\A^AaAhAiAkAmAoAsAwAyA{A~BEBGBfBrBtBuB{CCCDCJCLCMCVCWCZC"},
  {0,NULL,"aCgCpCtC{DEDMDODPDTDeDgDmDnDvDxDyD{E@ECEFEGEHEKELEOERESETEWEXE^Eb"},
  {0,NULL,"EdEeEgEjEmEwEyFFFIFPFRFXF[F^FdFfFlFuFwFxF}F~G@GPGQGVGZG[G]GbGcGdG"},
  {0,NULL,"eGgGhGqGwG{G~HAHCHHHVHXH[HdHfHkHqHsH}IBIKIMINIPIQITI_IcIdIfIhIiIl"},
  {0,NULL,"IqI~JCJLJSJTJ]JcJlJqJvJxJzJ~KCKFKNKOKQKRKVK]KcKeKfKlKpKqKsKuKwK{L"},
  {0,NULL,"?LBLMLNLUL]L^LmLpLvLwMAMGMHMJMKMLMOMUMVMaMcMfMgMjMmMyN?NKNPNQNXN["},
  {0,NULL,"N\\NeNhNkNpNrNvNwNyN~ODOFOGOKOMOPOXOeOgOnOoOvO}O~PAPEPVPXP\\P]P_PbP"},
  {0,NULL,"dPgPiPpPsPvP|P~Q@QHQJQKQQQ[QgQhQjQmQrQ}Q~R?RBRJRKRMRNROR^RdRfRiRk"},
  {0,NULL,"RpRqRyS@SCSESJSKSPSYSZS\\S]S_SjSmSrSsS{S~T@TFTGTITKTMTUTXTZT[T^T`T"},
  {0,NULL,"iTkTpT~U@UCUGUIUKULUVUYUZUlUoUqUsUzVEVHVIVQVUVVVWVXVYVZV[VeVfVjVl"},
  {0,NULL,"Vn_E?F?I?K?M?P?S?d?e?g?o?u?|?~@@@B@F@I@N@R@S@Y@c@d@f@s@t@z@{A?AAA"},
  {0,NULL,"EAHALANAYAZA[A`AfAgAjAkAlAqAvA{BDBHBJBLBiBlBmBuBzCACECFCLCSCZC^C_"},
  {0,NULL,"CbClCwCxDCDDDJDKDRD\\DbDcDjDuDvDxDyDzE?EDEFEGEIEJELENEREVEWEXE]E^E"},
  {0,NULL,"aEcEeEfElErE{F@FEFMFQFRFUFXF^FaFjFnFqFuFwF~GDGGGKGSGUGVG\\G`GdGiGk"},
  {0,NULL,"GoGpGrGwGxGyHBHEHMHPHXH[H^H_HdHiHoHrH}IAIDIEIJINIUIWIZI[IaIfIkInI"},
  {0,NULL,"oIvIwJFJLJQJYJ\\JeJjJsJvJxK@KAKCKHKIKPKRKXKZK^KcKgKkKmKnKsKtKuKwLB"},
  {0,NULL,"LELGLOLRL\\L`LaLhLkLsLwM@MBMFMJMNMPMSMUMWM[M\\M]MdMlMnMvN?NENNNUN]N"},
  {0,NULL,"`NcNfNhNmNpNsNzN|O@OBOEOFOLOQOUOYO\\O`OeOnOoOsOzO|O~P@POPPPQP]P^Pc"},
  {0,NULL,"PfPjPkPsPxPyPzP}Q?QEQKQLQPQXQcQfQmQnQrQuQyR@RERGRSRTRYR\\R]RbRdReR"},
  {0,NULL,"jRkRtRwR|S@SASDSESPSVSWSZS[SeShSlSoSuSwSxTBTDTETHTITMTOTXTYTaTcTe"},
  {0,NULL,"TfTiTtTvT}UCUGUJUPURUSUVU]UcUfUkUsUwV@VBVIVOVPVRVVVWVXV[VaVcVfVhV"},
  {0,NULL,"nVoVqVr_E?G?J?K?M?N?R?_?d?f?o?r?|?~@?@B@D@H@N@R@S@T@]@d@e@q@s@z@{"},
  {0,NULL,"@~AAACAGALANAVAWAZA[AfAgAkAmAnArAvA{A~BDBFBLBiBsBuBvB}CACKCLCNCUC"},
  {0,NULL,"ZCbCcCkCmCwCyC~DDDJDKDQD]DbDcDkDqDvDwDxD{E?E@EBEEEIEJELENESEUEVE\\"},
  {0,NULL,"E]E_EaEcEfEhEsEtE}F?FFFGFNFTFWFZF]FcFhFlFsFvFyF{GCGHGNGQGRGXG]G_G"},
  {0,NULL,"bGdGeGgGqGsGtGwH@HDHFHIHNHQHZH]H`HcHjHkHqI@IAIFIIIPITIUIXIZI\\I^Ib"},
  {0,NULL,"IiIlIoIuIzJOJSJTJXJ_JaJlJrJtJwJ|KBKDKFKGKKKNKUK\\K]KaKcKeKlKoKpKsK"},
  {0,NULL,"zK~LALDLHLQLVLWL_LbLiLmLpL{L}M@MCMLMOMRMSMWMXM]M`MbMfMjMrM|NANDNP"},
  {0,NULL,"NQN[NaNeNiNjNlNpNrNtNvNwN~OCOFOHOIOROVO]OfOhOjOrOuO{PAPEPMPQPSPVP"},
  {0,NULL,"XPYPcPePgPkPmPpPtP{P}QBQIQQQTQVQYQ]Q^QjQkQsQxR?RARCRLRVRWRXRZR[R_"},
  {0,NULL,"RcRiRnRpRuRyR}R~SHSJSLSOSTSUS\\S_SdSiSpStSzS|S}TATBTCTDTITOTSTXTYT"},
  {0,NULL,"_TbTcTfTjTsT{T~U@UGUJUOUPURUWUXUbUgUlUoUzVAVEVMVOVPVSVTVWV]VbVcVd"},
  {0,NULL,"VeVhVmVrVs_D?E?I?M?O?P?Q?Z?a?h?w?x?|@?@C@D@E@J@P@R@W@X@^@b@g@u@w@"},
  {0,NULL,"{@|@~ACADAFATAZA\\A^A_AaAgAhAmAnAoApAwAyA{A|BBBGBfBkBnBsBtCDCGCKCM"},
  {0,NULL,"CQCVC\\CaCfCkC{C}DDDEDJDMDPDWDbDeDnDoDwDxDyDzD|D~EDEGEHEKEMEQERESE"},
  {0,NULL,"WEXE[E_EbEcEeEgEiEkEzF@FAFJFLFNFVFWF]FgFjFmFsFyF|GAGBGHGJGMGOGTGW"},
  {0,NULL,"G_GcGjGpGqGrGtGuGvGzG}HDHEHJHTHZH^HgHhHiHwHxHyIBIIILIPISIUIWIYI\\I"},
  {0,NULL,"]IfIiImIoIvI|JEJFJKJUJ\\J`JiJrJ{J|J}K?KDKEKMKSKWKYK\\KaKbKhKlKmKnKq"},
  {0,NULL,"KrKxK~LELILLLSLXLYL_L`LhLrLtLyL}L~M?M@MJMLMQMWM^M`MaMfMiMlMnMuNEN"},
  {0,NULL,"JNONRNYN^NbNdNgNlNoNrNsNuN|O?OCODOIOLONOSOZObOfOkOpOsOzPDPGPJPSPV"},
  {0,NULL,"P[PaPcPdPfPgPmPnPoPqPsP}QDQFQOQSQTQWQYQ\\QdQiQpQvQwQzRCRGRSRTRVRWR"},
  {0,NULL,"XR_R`ReRjRsRtR|R~S?SASDSNSQSSSUSWS[SeSiSlSpStSwSxT@TDTFTGTMTSTVT["},
  {0,NULL,"T_T`TfTiTkTmTqTtTwU?UKURUVUWUYUZU\\UcUdUmUtUyV@VCVKVOVRVUVVVZV_V`V"},
  {0,NULL,"aVdVfVhVnVpVu_F?G?J?K?L?N?Q?[?^?h?t?y?{@A@C@D@F@L@P@Q@S@U@^@a@g@r"},
  {0,NULL,"@x@|@}A@ACAEAKALAPAUAXA^A_AdAeAhAjAnAuAvAzB@BBBCBGBhBtBxBzB|CBCIC"},
  {0,NULL,"MCSCTCYCaCdChClC|C~D?D@DHDLDQDYD`DdDqDrDvDwDxDyE?E@ECEDEIEJELEOEQ"},
  {0,NULL,"ETEXEYEZE^E`EdEfEhEnEoE}E~FAFIFMFPFQFUF[FhFiFmFqFxF}G@GDGGGOGPGSG"},
  {0,NULL,"WGYG^GaGcGiGjGpGqGtGvG|H?HFHLHOHXH[HbHcHdHiHkHlHyICIEIIIKILIOIXIY"},
  {0,NULL,"IeIgIjIlIoIpIuIyJFJRJTJUJ[JaJiJqJsJzJ~K@KAKOKPKSKTKYK[K`KaKbKgKhK"},
  {0,NULL,"lKmKqKuKwL@LALBLTLVL[LcLdLhLpLyLzM?M@MDMIMMMOMTMVMZM\\M^M`MbMeMrMz"},
  {0,NULL,"NCNENQNRNYNZN\\N`NgNnNoNrNsNzN}O?OCODOJOOOTOVO^OeOhOmOnOoOzPAPJPKP"},
  {0,NULL,"PPSPUP[P`PbPePhPlPoPpPrPuP}Q@QAQLQMQSQ\\Q_Q`QfQgQtQuQwQ{Q~RLRPRQRR"},
  {0,NULL,"RZR[R_RbRiRjRnRqRwRyR~SDSHSKSTSUSVS[S\\S]SgSnSqSzS|S}TATBTETFTJTQT"},
  {0,NULL,"UTWTZT`TcTeThTjTqTtU@UEUHUIUPUSUTUXUYUcUjUoUtUzV@VKVLVPVQVSVVVWV["},
  {0,NULL,"V]V^VaVeVgVkVrVv_D?E?J?K?N?O?Q?b?c?h?q?z?}@@@A@B@F@K@O@W@_@`@b@d@"},
  {0,NULL,"g@p@yA?A@AAABAEAJANAOATA]AaAbAeAfAiAjAlAtAxAyA|BABIBLBgBmBpBrBwB~"},
  {0,NULL,"C?CFCJCOCWCXC]C_CiCrCuCwDADKDUDZD[DcDhDsDtDvDwDyD{D~E@EBECEHEOEPE"},
  {0,NULL,"QESEWEXEZE\\E_E`EcEdEhEiEkE|F?FCFOFRFXFYF\\F^FbFcFkFrFtFuFwF~GFGIGO"},
  {0,NULL,"GSGWGYG[GhGnGqGrGsGuGvGxG~HCHDHEHHHQHYH_HgHhHnHqHuH~IAIDIEIGIOITI"},
  {0,NULL,"VIZI^IaIcIjInIpIuI|JHJMJPJSJ^J_JgJnJoJuJvJxKCKLKPKQKSKTKYKbKfKjKl"},
  {0,NULL,"KnKoKrKtK}LDLGLILLLMLNL^L_L`LeLfLjLmMBMCMGMMMPMSMTMYM[M\\M]MeMjMkM"},
  {0,NULL,"rMuNGNLNMNPNWNXNYNZN`NgNqNrNtNuNyN|O?OEOGOIOKOLOXO`ObOdOkOrOwOyP?"},
  {0,NULL,"PEPOPPPQPTPUPXPZPhPjPkPlPtPxP|Q@QAQLQMQUQ_Q`QbQfQgQtQuQ{Q~RFRGRSR"},
  {0,NULL,"TRVRWRXRcRkRoRpRrRuR}SESGSISJSLSOSZS^S_ScSdSiSlSpStSwSxTBTKTMTNTP"},
  {0,NULL,"TQTST^T_TcTdThTiTnTuTxT~UDULUPUQUTUVUWU^UaUeUhUlU~V?VEVJVSVUVWVZV"},
  {0,NULL,"]V_V`VdVeVfVkVmVrVt_E?F?H?K?L?O?S?[?b?g?y?z?|?~@@@B@F@L@M@O@Y@`@b"},
  {0,NULL,"@d@f@x@y@z@{A?AAAEAKANARA]A`AaAbAfAgAjAkAlAuAxAyA}BHBIBLBiBkBmBwB"},
  {0,NULL,"yCACFCOCQCRCXC[C_CbCfCrCtCwDCDKDODRD[DcDgDtDuDvDxDyDzD|D}ECEGEHEI"},
  {0,NULL,"EPEQEWEXEYEZE[E]E`EdEeEhElErExEyFDFGFJFLFTFVFZFeFfFoFvF{F|GAGBGCG"},
  {0,NULL,"KGLGTGUGXG^GaGeGgGjGlGmGnGuGyG|H@HAHMHRHTHXHZH^HsHyH{I?IHIIIMIRIT"},
  {0,NULL,"IVIXI^I`IbIeIhIiIjIqJBJCJNJUJZJ]JbJkJtJwJ{J}K?KBKGKIKJKWKXK[K]K_K"},
  {0,NULL,"`KeKhKiKjKrKuKxK~LELFLOLQLULaLdLgLoLvLyMCMEMIMKMLMMMRM_M`MbMcMhMj"},
  {0,NULL,"MkMmM}N@NKNRNVN]N_NdNfNiNnNoNqNuNvNwN{N}OAOHOPOYO\\O^OeOfOpOsOtOxO"},
  {0,NULL,"}PJPLPRPSPTPWPXP\\PePgPhPiPrPtPwP{Q?QEQFQGQIQZQcQdQkQnQqQyQzRARERL"},
  {0,NULL,"RMRNRORZR[R`RdRgRiRjRqRyS?S@SBSDSKSPSQSRS[S\\S]SmSrSsSzS|S}T@TCTKT"},
  {0,NULL,"LTNTPTST[T]T^T_TbTdTnToTpTqTrUKULUNUOUQUWU^UpUqUtUvU{VHVKVNVRVSVU"},
  {0,NULL,"VXVYVZV[V`VaVbVgViVmVu_F?G?I?L?M?P?Q?]?`?h?p?s?{@A@C@D@F@G@N@Q@U@"},
  {0,NULL,"V@_@`@g@n@v@|@}A@ACAEAIAOAPASAUA[A]AdAeAhAjAnAsAxB?B@BABCBDBqBwBx"},
  {0,NULL,"B|B}C@CBCOCTCUCXCdChCjCmCoCxD?D@DLDSDYD\\DdDjDlDrDvDwDxDyD|E?EBEGE"},
  {0,NULL,"HEIEKELESETEUEYE[E]EbEeEfEgEnEoEvE{FCFGFHFKFSFTFZF_FaFkFvFzF{G?GC"},
  {0,NULL,"GEGLGMGOGWGZG_GbGfGhGnGrGsGuGxG|HAHGHMHOHWH]H`HcHdHoHqHuI?IDIGIJI"},
  {0,NULL,"PIQIRISIZI[I]I_I`IcImIvJ@JHJQJSJZJeJfJgJmJpJtJwJyKBKEKJKSKVKYK\\Kd"},
  {0,NULL,"KfKjKnKoKpKrKtKzK|LALBLHLOLPLULcLdLeLkLmLoL~MAMEMGMNMQMSMYM[MdMfM"},
  {0,NULL,"gMhMiMnMsNGNNNPNVNYN^N_NgNkNlNqNtNuNxNyN|N~OEOJOPOWO\\O^OcOhOjOnOu"},
  {0,NULL,"OwP@PEPLPOPVPWPZP^P_PaPkPnPqPvPwPzP|QFQMQOQSQTQWQYQ\\Q`QdQvQwQzQ{R"},
  {0,NULL,"CRJRKRYR\\R]R^RbRcRdRiRkRvRwRyR}S@SESMSOSPSVSZS\\SfShSjSoSuS{S~T?TC"},
  {0,NULL,"TDTHTNTRTVT\\TaTbTfTgTmTnToTxT}T~UMUOURUUU\\U]U^UhUkUlUpUwU{V?VEVOV"},
  {0,NULL,"RVSVVVYV\\VaVbVcVeVhViVjVlVpVx_D?F?J?K?N?P?R?\\?e?f?u?v?}?~@?@C@E@I"},
  {0,NULL,"@O@V@X@[@\\@a@e@o@t@z@|@~ABADAHAMAQASAXA\\AbAhAiAkAmAoAqAwAzB?BEBIB"},
  {0,NULL,"KBfBoBqByB{C@CCCDCHCRCVC[C`CgCjCpCuC{C|DHDPDTDUD`DhDmDnDvDxDyD{D}"},
  {0,NULL,"E?EBECEHENEPETEUEVEWEYE]E^EaEcEdEfEjEmE|E~FBFHFJFKFLFSFVFbFiFpFzF"},
  {0,NULL,"|G?GAGBGEGMGNGQGXG\\G]GfGkGlGmGoGsGtGvG|HAHHHJHMHUH[H\\HfHhHlHrHuH{"},
  {0,NULL,"ICIFIGILIUIVIWIYI\\I]IaIbIgInIuI}JHJNJRJYJ[J^JhJmJpJyJ{J}K?KEKFKGK"},
  {0,NULL,"HKNKUK^K_KaKbKdKiKkKoKvKwKyK{LLLNLOLULXLdLeLgLsLzL}L~M?MBMDMPMRMW"},
  {0,NULL,"MXMYMZM^MkMlMrMwN@NCNGNUN[N^NcNeNiNjNtNxN{O?O@OAOBOCOPOSOXO\\O^O_O"},
  {0,NULL,"bOiOoOvOwOxO|PKPTPYPZP[P`PcPfPjPmPnPoPuPxP{QHQIQQQTQVQYQ]QhQjQkQx"},
  {0,NULL,"Q}R?RARCRGRPRQRRRSRTRbRjRkRoRqRrRwSDSESGSISKSVSZS[S]S^ScSgSlSnSqS"},
  {0,NULL,"wSxTATLTQTRTSTTTVT]T_TgThTjTlTmTrTvTxUEUNUTUUUWUXU[U\\UfUhUjUvV?VB"},
  {0,NULL,"VLVNVRVSVWVXVYV\\V]V^V`VeVkVmVoVpVqVv_D?G?I?M?N?P?S?\\?_?g?r?v?}?~@"},
  {0,NULL,"@@A@E@H@M@O@V@X@Z@a@f@o@q@zA?A@ABADAGARASAXA\\AbAcAeAiAkAlAoArAwAz"},
  {0,NULL,"A}B?BIBMBhBjBpByB{C?CCCICPCRCYC[CeCgCiCoCuCzC{DGDPDSDUD_DhDlDnDvD"},
  {0,NULL,"wDxDzD|E?EAEDEJEMENEQETEUEVEYE^E_EaEcEfEgEpEqEvEzFDFIFOFPFYF[F\\F_"},
  {0,NULL,"FgFoFrFtFxF}G@GFGKGRGUGVGYG`GaGeGgGlGmGpGuGxGzG~HFHLHOHSHVH`HeHgH"},
  {0,NULL,"jHtHyI?IAIBIGILINIRITI\\I_IaIcIiIjIkIvI{JOJUJWJZJ`JfJkJnJoJqJuJzJ~"},
  {0,NULL,"KIKKKRKTKXKZK]K_K`KeKiKmKrKtL?LCLHLILJLMLVLYL[LcLiLoLxLyL}MAMBMFM"},
  {0,NULL,"GMLMMMUMYM]M^MaMhMjMnM~NANRNTNVNZN]NaNfNhNmNsNuNvNwN{N}OAOEOGOJOT"},
  {0,NULL,"OVOZOgOkOlOqOuO{PIPJPLPQPWPXPZP[P]PdPgPhPmPvPxPyP|QEQKQLQNQPQXQaQ"},
  {0,NULL,"fQmQnQoQrQuR@RERJRKRVRWRXR^R_R`RcRiRsRvRyR}R~S?SMSNSOSQSSSUS\\SfSi"},
  {0,NULL,"SjSpStS{S~THTLTMTQTTTUTVTZT]TaThTiTlTmToTqTsTzUIUNUTUVU[U\\U]UgUpU"},
  {0,NULL,"rUtU{U}VAVKVOVQVRVTVVV\\V]V^V_VaVkVnVpVsVxVy_D?E?I?M?O?P?Q?Z?a?h?w"},
  {0,NULL,"?x?}@@@A@B@F@G@Q@U@[@]@_@`@g@u@wA?A@AAABAEAIAOAPAQAUAWA]AeAfAiAjA"},
  {0,NULL,"lAsAxB@BABCBFBKBgBqBwBxB}B~C@CBCOCUCXC]CdCjCmCrCsDADBDIDNDZD[DaDf"},
  {0,NULL,"DsDtDvDwDyD{E?EAEBEFEHELEMENEPERESETEVE\\EbEcEeEgEiEkEzF@FAFJFLFNF"},
  {0,NULL,"VFWF]FgFjFmFsFyF|GAGBGHGRGSGUGVGYG\\GaGbGcGfGiGjGpGtG}H@HCHDHIHTHU"},
  {0,NULL,"HYHfHhHkHlHmHvIHIKINIRISIWIXI[IeIgIhIiIkImIrJ?JDJGJRJTJ\\J`JiJrJ{J"},
  {0,NULL,"|J}K?KDKHKKKPKRKTKXK`KaKdKgKhKmKpKqKvKxK{K}LLLQLSLWL^L_LpLqLzL|MD"},
  {0,NULL,"MFMIMKMLMNMQMUMVM_MbMhMiMlMpM{NBNCNFNQNZN`NaNcNfNhNoNsNxNzN}N~OCO"},
  {0,NULL,"DOHOIOKONORO_ObOdOpOvPAPBPKPNPRPWP]PaPbPePfPgPiPqPrPuPyPzQ?QLQNQU"},
  {0,NULL,"QVQ]QaQbQcQfQoQuQxQyRFRHRIRMRNRORURfRmRnRpRqRrR{SCSHSISJSKSTSYS]S"},
  {0,NULL,"_SbScSkSmSrSsSvSyT?TCTHTJTLTOTRTWTYT\\T]TaTbTgT|U@UBUEUHUJUMUNUOUU"},
  {0,NULL,"U]U_UiUjUoUzVDVGVLVOVRVTVWVXV\\V]V_VcVfViVlVnVoVwVy_E?F?I?K?M?P?S?"},
  {0,NULL,"d?e?g?o?u?{@?@A@C@E@H@M@O@Z@[@\\@a@f@s@t@|@}@~A@ADAGAMAQARAXAbAcAd"},
  {0,NULL,"AeAhAmAoArAzA}BEBIBKBMBhBjBoBpB{C?CCCHCICPCYC`CeCgCiCpCsCvC|DHDND"},
  {0,NULL,"TDVD`DfDiDmDvDwDzD{D|D~EAEBEHEJEPEUEVEWEZE[E]E_EaEcEeEfElErE{F@FE"},
  {0,NULL,"FMFQFRFUFXF^FaFjFnFqFuFwF~GDGGGJGLGTGWGZG_GdGeGiGjGkGlGnGrGyG{H?H"},
  {0,NULL,"@HPHQHRHXHYH_HmH|H~I@IFIJIKILINIOIPI_IaIdIgIlImIoIrJBJDJMJVJXJ\\Je"},
  {0,NULL,"JjJsJvJxK@KAKCKJKMKSKVKWK\\K]K^K_KgKhKjKnKsKuK}LDLFLGLQLTL\\L]LaLfL"},
  {0,NULL,"uL{L|M@MAMBMDMHMOMQMUMVMXM^MdMeMfMpM}NBNDNLNSNYN_NbNdNkNlNoNpNqNv"},
  {0,NULL,"NzN{N|O@OHOMOOOUOYO`OdOeOrOtOyPHPMPNPUPVPYP[P]P^PbPpPqPuPvPxP}P~Q"},
  {0,NULL,"DQJQMQOQRQWQ[Q`QiQlQpQvQ{RBRDRLRMRNRORZR[RaRhRmRnRpRuRxRzR{SHSJSL"},
  {0,NULL,"STSXS_SaSbSdSmSrSsSzS|S}T?TFTKTLTQTTTVT\\T]T^T`ThTlTmTyT{UBUDULUMU"},
  {0,NULL,"NUTUYU[U\\U_U`UaUbU|VGVJVMVRVSVUV\\V_V`VaVbVcVfVhVjVkVoVsVw_E?F?G?K"},
  {0,NULL,"?L?M?T?X?Y?i?l?n@H@J@L@O@Q@R@V@W@Y@Z@]@^@k@l@mAFAGAKAPASATAWAZA^A"},
  {0,NULL,"`AbAcApArAuA{A|B?BCBFBGBHBIBMBPBTBVBWBXBYBZB]B^CnCxCzC{C}DADFDGDP"},
  {0,NULL,"DWDZD\\D^D_DjDnDoDsDvDyD{D}D~E?E@EAEBECEFEGEHELEZE\\E]E^E`EaEbElEnE"},
  {0,NULL,"sEwEzE|FHFJFOF[F]F^FbFdFgFrFwFzF}GBGHGIGMGTGVGYG]GaGdGeGjGsGvG{G|"},
  {0,NULL,"H@HEHLHNHQHTHXH\\H`HbHiHjHpHuHvHwHyHzH|H}I?I@IGIQISIfIkInIwJ@JAJGJ"},
  {0,NULL,"HJLJ^J`JcJmJnJ~K?KCKDKEKFKLKRKTKWK]K`KbKhKoKsKuKxKyL@LDLHLQL[L]L`"},
  {0,NULL,"LbLdLeLhLiLlLnLoLqLrLuLwLyL{MFMJMPMYMgMiMsMtMvN?NFNGNWNZN^NdNeNhN"},
  {0,NULL,"oNpNtNvN}O?OHOLOMOTO]O^OeOiOmOpOrOuOwOzO{O~PBPCPDPFPHPJPLPMPZP_Pa"},
  {0,NULL,"PjPsPyQBQCQEQOQPQSQWQXQ\\Q^QeQnQsQvQwQ|R@RERGRHRIRJRKRLRSRTRURZR[R"},
  {0,NULL,"^RfRkRrSCSESISYSZScSzS|S}TITJTMTPTRTVTWTXTdTgTiTmTwTxTzT|T}UCUGUH"},
  {0,NULL,"UQUUUVU\\UdUhUiUkUrUsUwU}V?VCVDVIVPVSVXVZV[V\\V]VaVbVcVeVfViVjVoVrV"},
  {0,NULL,"vV|_D?E?F?K?O?P?T?U?V?i?j?k@I@J@K@S@V@W@Y@Z@\\@]@^@`@i@j@kAFAHAJAL"},
  {0,NULL,"AMASATAWA]A^A`AcApAqAtAvAxA|B?BEBFBGBHBMBNBOBTBUBVBWBXBYBZCnCsCtC"},
  {0,NULL,"yCzD?DFDGDNDODYD]D^D_DfDgDkDrDvDwDxD|E?E@EAEBECEDEEEGEHELEVEXEYE_"},
  {0,NULL,"E`EaEbEiEjErEuEvE}FIFKFMFTFWFYF_F`FhFsFtFvG?G@GDGLGNGOGPGRG`GkGoG"},
  {0,NULL,"qGtGuGxG~H?HBHDHJHMHUHWHZH[H_HgHkHnHrHvHwHxHzH{H|H}H~I?IHIRIXI_Id"},
  {0,NULL,"IlI~J?JBJTJVJZJaJdJfJuJyJzJ|K@KBKJKKKOKUKYKZK^KaKkKlKrKtKvKwK|K~L"},
  {0,NULL,"GLILMLOLRLTLXL_LfLgLjLnLoLpLqLrLsLtLuLwMAMHMOM_MbMhMyM{M}NQNSNVN\\"},
  {0,NULL,"N_NaNgNjNmNrNuO@OBOCOEOGOIOOOQOSO\\O_O`OcOfOkOoOxOyO|O~P?PAPBPDPFP"},
  {0,NULL,"GPHPLPRPWPePpPvP~Q?QDQGQHQJQUQZQ[QbQcQhQiQpQqQyQ}RBRFRGRHRIRJRKRL"},
  {0,NULL,"RSRTRURZR[R^RiRnRvRySHSMSTS\\SfSlSwSxTCTFTNTOTTTUTYTZT`TbTlTnToTpT"},
  {0,NULL,"yU@UAUBUIUJUOUYU[U^U_U`UnUoUpUqUzU{U|VFVGVHVOVQVRVUVWVXV]V`VaVbVe"},
  {0,NULL,"VfVgVhVkVlVmVn_D?F?G?L?N?P?U?W?Y?k?l?m@G@H@K@O@Q@R@S@W@Z@\\@]@`@h@"},
  {0,NULL,"j@lAGAIAJALAMAPATAWAZA]AbAcArAsAtAvAxA{A|BCBEBFBIBMBNBOBPBUBVBWBX"},
  {0,NULL,"B]B^CsCwCyC|C}DADHDKDNDWDZD]D`DcDfDkDoDsDxDyDzD|D}D~E?ECEDEEEFEGE"},
  {0,NULL,"KEMEXEYE]E^E`EaEbEmEoEqExF?F@FLFNFQFRFZF\\FcFeFjFqFyF~GAGCGFGJGSGU"},
  {0,NULL,"GXG[G_GbGgGhGlGpGrGzHAHCHFHGHPHRHVH]HdHeHhHiHjHkHmHqHtHuHvHzH{H|H"},
  {0,NULL,"~IFIVIWIeIoIpIxIyI}JFJIJNJ\\J_JbJoJrJsJwJxJ{KGKMKPKQKXK\\K_KeKfKmKn"},
  {0,NULL,"KpKzL?LBLCLFLLLPLULVLYL\\L^LeLfLgLhLiLmLnLpLqLuLxL|M@MIMTMXMkMlMwM"},
  {0,NULL,"xMzN@NENHNXN`NbNfNiNlNsNwNyN{N|N~OKOPOUOVOWOZObOgOjOnOqOtOwOxOyOz"},
  {0,NULL,"O{PAPBPEPFPHPIPNPTPYPfPlPrP}QAQMQNQQQRQVQ]Q_Q`QaQjQlQoQtQxQ{R?RDR"},
  {0,NULL,"GRHRIRJRKRLRSRTRURZR[R^RgRjRtR|SBSDSRS[SeSjS{S~T?TBTETGTLTST\\T]T_"},
  {0,NULL,"TcTeTkTrTtTuT{UEUFUMUNUPUSUWUZUbUcUeUjUuUvUxU~V@VLVMVNVOVPVQVVVXV"},
  {0,NULL,"YVZV\\V^V`VaVeVpVqVuVxV}V~_D?E?F?K?O?P?T?U?V?i?j?k@G@H@L@M@N@P@T@U"},
  {0,NULL,"@X@_@a@d@i@j@kAGAIAKANAOARAUAVAXA[A\\A_ArAsAuAwAzA}A~B@BABBBDBLBQB"},
  {0,NULL,"SB\\B_B`BbBcBdBeCoCqCuC~D@DDDJDLDQDSDUDXDbDdDhDlDpDqDyDzD{D}D~EAEB"},
  {0,NULL,"ECEDEEEFEGENEOEPEREWE[E`EaEbEiEjErEuEvE}FIFKFMFTFWFYF_F`FhFsFtFvG"},
  {0,NULL,"?G@GDGLGNGOGPGRG`GaGbGcGdGlGnGyGzG{G|HCHIHQHRHSHTHdHfHkHlHnHoHqHr"},
  {0,NULL,"HtHxHyH|I?I@IAIDIEIYI\\I]IwI|I}JEJPJYJaJdJfJuJyJzJ|K@KBKJKKKOKUKYK"},
  {0,NULL,"ZK_K`KjKpKqKsKxK{LBLDLFLJLWLYL]L^LaLdLjLkLmLoLpLsLtLuLxLyLzL{L}L~"},
  {0,NULL,"M?M[M\\M]MuMvMwNMNONUN\\N_NaNgNjNmNpNqN{N}N~ODOKOMOROYOZO^OlOnOpOrO"},
  {0,NULL,"tOvO|P?P@PAPEPGPHPIPJPKPLPMPOPPPQPmPnPoQAQEQLQOQQQTQWQYQ_QfQjQnQt"},
  {0,NULL,"QuQvR?RCRERMRNRORPRQRRRVRWRXRYR\\R]ReRlRoSASFSGSWS^S`SmSrSsTATBTGT"},
  {0,NULL,"HTPTVTaTcTdTjTkTmTsTtTuTvTwTxUPUQUXUZU\\U]UcUdUeUfUgUhU~V?V@VAVBVC"},
  {0,NULL,"VRVUVWVXVYV[V^V_V`VcVdVfVoVqVuVwVzV|_D?E?G?M?N?O?V?W?X?j?m?n@G@I@"},
  {0,NULL,"L@O@Q@R@S@V@Y@\\@^@`@h@i@mAHAIAKALAMAPASAZA]A^A`AbAqAsAuAvAxA{B?BC"},
  {0,NULL,"BEBGBHBIBNBOBPBTBUBYBZB]B^CtCwCxC{C|D?DHDKDODPDYD\\D`DcDgDjDnDrDwD"},
  {0,NULL,"zD{D|D}D~E@EAEBEDEEEFEKEMEVEZE\\E_E`EaEbEkEpEtEyE{E~FGFPFSFUFVFXFa"},
  {0,NULL,"FfFiFuFxF{F|GEGGGKGQGWGZG\\G^GcGfGiGmGnGwGyG}HHHIHKHOHSHYH^HaHcHfH"},
  {0,NULL,"iHjHkHlHoHsHuHwH{H}H~I?IIIPIUIaIcIjIzI{I|JKJMJOJ[J]JeJpJqJtJvJ}KA"},
  {0,NULL,"KHKIKNKSKVK[KcKdKgKiKjKqK{K}LALELJLKLNLSLWLZLaLcLeLfLgLhLiLkLoLpL"},
  {0,NULL,"rLvLwLzMBMGMMMWM`MfMuM|M~NANJNLNYN[N]NcNkNnNqNxNzOAODOFOJONOROXOY"},
  {0,NULL,"O[OaOdOhOlOsOvOwOxOyOzO{O}O~P@PAPDPKPLPSPVPcPhPxP|Q@QFQIQKQLQTQYQ"},
  {0,NULL,"dQfQgQkQmQrQuQzQ~RARCRGRHRIRJRKRLRSRTRURZR[R^RhRsRuRxSLSNSSSXSdSk"},
  {0,NULL,"SvSyT@TATDTHTKTQT[T^TaTfThTjTqTsTvT~U?UDUKULURUTUXU]UaUfUgUlUmUtU"},
  {0,NULL,"yVAVBVEVJVKVOVPVQVTVZV\\V]V_V`VbVdVfVsVtVwVyVzV{_D?E?G?M?N?O?V?W?X"},
  {0,NULL,"?j?m?n@H@J@K@M@N@P@T@[@_@a@b@c@h@i@mAFAGAJAOAQARAVAXAYA[A_AaApArA"},
  {0,NULL,"tAyAzA}A~BABBBDBJBKBQBRB[B_B`BaBcBdBeCpCqCvD@DBDCDIDLDRDTDVDXDaDd"},
  {0,NULL,"DiDmDpDuDvDxDyD|D}E?E@EBECEDEFEGEIENEQESETEWE`EaEbEkEpEtEyE{E~FGF"},
  {0,NULL,"PFSFUFVFXFaFfFiFuFxF{F|GEGGGKGQGWGZG\\G^GeGgGrGtGvGxG~H@HEHFHGHJHV"},
  {0,NULL,"HZH_H`HbHhHjHlHmHnHoHpHsHtHwHxH~I@ICIJIMI[IgIhIxJ?JAJCJQJRJ[J]JeJ"},
  {0,NULL,"pJqJtJvJ}KAKHKIKNKSKVK[K]KaKbKeKnKtK~L?L@LGLHLLLMLPLQLVLXL`LfLiLj"},
  {0,NULL,"LkLlLrLtLvLxLzL{L|MDMKMNMZMcMdMtMxM{NCNKNNNYN[N]NcNkNnNvNwN|O?OCO"},
  {0,NULL,"EOGOHOLOSOVOWO`ObOfOgOmOuOyO{O}P?P@PCPDPGPIPKPMPNP\\P^P`PiPuPzQBQC"},
  {0,NULL,"QDQNQRQUQ^QaQbQeQiQlQoQpQsQ|RDRFRMRNRORPRQRRRVRWRXRYR\\R]RbRdRqRwS"},
  {0,NULL,"@SKSPSVS]SiSpStTETFTITLTNTRTXT]T`TeTgTnTpTyT|T}UEUFUGUNUSUUUYU^U`"},
  {0,NULL,"UiUjUkUqUuUwUxU|VDVHVLVOVRVSVTVVVWVYVZV[V]V_VdViVmVnVpVrV~_D?F?G?"},
  {0,NULL,"L?N?P?U?W?Y?k?l?m@I@J@L@M@N@P@U@X@[@b@c@d@h@j@lAFAHAKANAQARAUAYA["},
  {0,NULL,"A\\A_AaApAqAuAwAyA}B@BBBDBJBKBLBRBSB[B\\BaBbBcBdBeCoCrCvDCDDDEDJDMD"},
  {0,NULL,"RDSDVD[DbDeDiDlDtDuDvDwD{D|D~E?E@EAEBECEEEFEJEOEPESETEUE`EaEbEmEo"},
  {0,NULL,"EqExF?F@FLFNFQFRFZF\\FcFeFjFqFyF~GAGCGFGJGSGUGXG[G_GiGjGmGoGqGsG}H"},
  {0,NULL,"?HHHLHMHNHUHXH\\HaHcHgHiHmHoHpHqHrHsHtHxHyHzH{IBINITIZI`ImI{I~J@JD"},
  {0,NULL,"JSJWJ\\J_JbJoJrJsJwJxJ{KGKMKPKQKXK\\KgKhKiKkKlKoKuKvKyLALILKLNLOLSL"},
  {0,NULL,"TL[LbLgLhLkLlLmLnLsLtLvLxLyL|MEMQMSMUMaMjMsMyM~NBNPNTNXN`NbNfNiNl"},
  {0,NULL,"NoNrNtNzOAOBONOOOTOXO\\O]O_OaOeOhOiOkOxOzO|O}P@PCPEPFPGPIPJPNPXP]P"},
  {0,NULL,"dPkPqPwQFQGQHQKQPQSQXQZQ\\QdQhQmQqQrQwQzQ}R@RMRNRORPRQRRRVRWRXRYR\\"},
  {0,NULL,"R]RcRmRpR{R}SJSOS_SbSgSnSqTCTDTJTKTMTTTWT^TbTfTiTlToTzT~U?UBUCUHU"},
  {0,NULL,"LUOURUVU[U_UlUmUpUrUsUyU{U}VEVGVIVQVSVTVUVVVWVYV\\V^V_VcVeVjVkVlVt"},
  {0,NULL,"VvVy_E?F?G?K?L?M?T?X?Y?i?l?n@G@I@K@T@U@X@[@_@a@b@c@d@k@l@mAHAIAJA"},
  {0,NULL,"NAOAQAUAVAXAYA\\AaAqAsAtAwAyAzA~B@BABJBKBLBQBRBSB[B\\B_B`BaBbCpCrCu"},
  {0,NULL,"C~DBDEDIDMDQDTDUD[DaDeDhDmDqDtDwDxDzD|D}D~E?E@EAEDEEEGEIEJEQEREUE"},
  {0,NULL,"[E`EaEbElEnEsEwEzE|FHFJFOF[F]F^FbFdFgFrFwFzF}GBGHGIGMGTGVGYG]GfGh"},
  {0,NULL,"GkGpGuGwHAHBHDHKHOHPHWHYH[H]H^HeHlHmHnHpHqHrHsHuHvHyH}I@IKILIOI^I"},
  {0,NULL,"bIiIyIzJBJJJUJXJ^J`JcJmJnJ~K?KCKDKEKFKLKRKTKWK^KcKdKfKmKrKwKzK|K}"},
  {0,NULL,"LCLELRLULZL\\L_LcLeLjLlLmLqLsLvLwLyLzL{L|MCMLMRMVM^MeMzM|M}NDNINRN"},
  {0,NULL,"WNZN^NdNeNhNsNuNxNyO@OFOIOJOPOQOUO[OcOdOjOoOqOsOwO|O}O~P?PBPCPEPJ"},
  {0,NULL,"PKPMPNPUP[PbPgPtP{Q?Q@QIQJQMQVQ[Q]Q`QcQgQkQxQyQ{Q~RARBRMRNRORPRQR"},
  {0,NULL,"RRVRWRXRYR\\R]R_R`RaRzR~S?SQSUSaShSoSuT?T@TOTQTSTUTYTZT[T\\T_ThTqTr"},
  {0,NULL,"T{U@UAUDUIUJUKUMUTUWUaUbUnUoUtUvUzVFVJVKVMVNVPVRVSVTVUVVV[V^VaVbV"},
  {0,NULL,"cVdVgVhVsVxV{V}_C?D?H?I?O?P?T?^?_?i?r?t?{?|?}@I@K@S@T@U@Y@Z@]@^@h"},
  {0,NULL,"@t@u@v@w@y@z@{@|AHAKAZA\\A^AaAdAeAfArAtBABCBFBKBNBOBPBQBRBSBlBnBpB"},
  {0,NULL,"yCECHCICJCMCQCTC\\C_CbCeCjCkCmCnCuCwC|D@DDDPDRDTDXD\\D]DiDlDoDrDsDt"},
  {0,NULL,"DvEBECEQEUE[EeEkEmEwE{F?FCFFFGFHFIFMFPFXF^FeFgFiFmFpFqFrFsFvFyGAG"},
  {0,NULL,"BGVGWGXG^G_G`GmGrGsGvGzHEHIHPHSH\\H^HdHnHpHrIFIHIPI_IeIjIuIxI{J@JA"},
  {0,NULL,"JBJCJDJEJHJPJRJSJUJVJXJYJZJ`JaJcJiJlJzJ|J~KDKJKNKQKSKTKXK_KcKeKfK"},
  {0,NULL,"kKnKpKuKvK{L@LMLNLOLULVL]L`LgLjLmLuLwLxM?MAMEMHMKMOMVMYMaMcMfMkMo"},
  {0,NULL,"MzM|N?NFNQN_N`NcNeNiNkNqNsNxNzOAODOEOGOHOKO]O_O`ObOdOhOiOpOyO|P@P"},
  {0,NULL,"BPKPLPQPRPWP]P^PePgPjPqPrPxPzQHQIQKQLQOQVQ`QaQbQgQjQnQvQ|Q}R@RERF"},
  {0,NULL,"RHRJRLRMRQRWRsRtRvRwRyS?SFSLSNSOSTSWS[SaSeSgShSiSqSsStT?T@TATBTXT"},
  {0,NULL,"ZT\\T^TdTkTnTtTvT}UCUHUJUKUNU[U\\U]UeUgUiUrUxUyV?V@VAVKVMVSVWVZV\\V^"},
  {0,NULL,"VaVbVdVgVhVrVvW@_C?F?I?J?K?P?V?]?^?j?s?t?~@A@D@G@L@N@P@S@U@V@_@a@"},
  {0,NULL,"l@o@s@t@w@y@~A@ABAIAJAMAQAXAbAgAlAnApAuA{BDBHBJBUBYB\\B]BaBbBhBkBr"},
  {0,NULL,"B}C?CGCHCMCNCRCUCXCYCZC]C^CeCkCnCrCsCtD@DEDGDIDPDSDTDZDcDiDkDoDqD"},
  {0,NULL,"uDyECEGEKEZE_EcElEmExEzE~FBFDFHFJFKFOFPFVFWFaFcFdFlFnFqFtFuFyF{F~"},
  {0,NULL,"GDGIGJGRGTG[G\\GeGgGhGjG}H?H@HBHUHVHWHYHjHkI?IBIEILIZI]I^IqIxIyI|J"},
  {0,NULL,"@JAJCJEJFJHJKJLJMJNJPJTJVJZJ[JdJeJhJjJpJyK@KAKFKGKIKPKWKYKdKhKiKk"},
  {0,NULL,"KlKoKpKwLBLHLLLNLQLULXL^LbLdLgLmLnLoLtLzL}L~M?MOMPMTMWMXMYM^McMjM"},
  {0,NULL,"qM|M~NCNNNUNXN[N^NfNgNhNsNuNyNzN}O@OFOLOVO\\O^O`OeOgOnOpOqOsO~P?P@"},
  {0,NULL,"PAPBPJPOPPPQPWPaPfPgPiPkPxPyP}Q?Q@QDQKQQQVQXQbQdQhQkQnQoQpQsR?RER"},
  {0,NULL,"FRJRQRTRVR[R\\RaRlRmRzS?SCSGSLSMSRSSSTSWS_SbSjSwSySzS|S~TCTDTQTUT_"},
  {0,NULL,"TdTfTgTjTlTnT|U@UBUEUJUSUTUVUYUZU]UkUnUpUuUyU}VFVGVHVJVMVQVSVVVXV"},
  {0,NULL,"ZV_VbVdViVwVzV~WB_C?E?H?J?K?O?U?]?_?k?r?s?~@A@D@G@H@N@P@S@T@W@X@d"},
  {0,NULL,"@m@p@t@w@x@y@}ACADAFAGAPAYA_AcAiAjAkAqAsAxAyBIBLBUBVB[B^B_B`BiBjB"},
  {0,NULL,"qBtCACBCCCDCGCQCTC[C^C_CaCiClCmCnCpCsCtDBDDDHDQDRDVDYD\\D_DeDnDpDs"},
  {0,NULL,"DtD{EAEBEMEYE]EdEkElExEzE~FAFDFGFKFLFPFQFTFVFaFcFdFkFnFrFtFwFyFzF"},
  {0,NULL,"~G@GKGMGPGTG[G\\GeGfGiGjG}G~HAHBHVHWHXHZHiHkH|ICIDILI[I\\I^IrIzI{I}"},
  {0,NULL,"J@JAJDJEJGJHJIJMJNJOJTJVJYJZJ_JbJfJgJkJoJuJwKBKHKLKPKRKUKVK^KcKdK"},
  {0,NULL,"eKmKrKsKyLALDLGLOLQLSLWLZL\\L]LpLqLsLwLxL{L}L~M?MGMHMJMUMVMZM`MgMk"},
  {0,NULL,"MnMxMzNMNPNTNYNZN[NbNdNjNvNyN|O?OCODOEOIOROTOXObOdOeOkOmOrOvOyPDP"},
  {0,NULL,"EPGPHPKPOPPPQPZPcPePhPjPlPqPtPuQCQHQMQOQRQUQZQ[Q]QaQfQgQqQrQuQvQw"},
  {0,NULL,"Q}RHRPRSRWRYRZR`RdReRxRyR|S@SFSKSQSYS[S^SaSfSkSxSySzS}S~TETFTOTST"},
  {0,NULL,"ZT_TaTbTfTgTkTyTzU?UAUPUSUTUVU[U\\U^UlUoUqUsUwUxVFVGVHVKVNVOVSVTVY"},
  {0,NULL,"V\\V^VaVfVjVqVuVyWB_C?E?H?I?M?O?W?[?e?m?u?y?~@C@F@I@L@N@O@R@S@Y@`@"},
  {0,NULL,"b@k@n@p@q@u@w@}ABAEAHAJAQAUAWA]AkAnAoArAuAwA{A|BBBXBYBZBaBbBeBhBo"},
  {0,NULL,"BuBwB~C?CBCJCLCRCTCVCXCcCgCkClCmCnCqCvCwCzDBDLDNDQDSD\\D]DeDgDhDmD"},
  {0,NULL,"oDsDzD}EDEJEPETEgEiEsEvExE|FBFCFKFMFPFUFYFZF\\FdFhFjFlFmFyF|F}F~GB"},
  {0,NULL,"GEGHGIGJGNGRGYGZGaGbGhGkH@HCHJHLHUH]H_HbHoHqHsIGIIIRIaIfIlIsIwIyI"},
  {0,NULL,"{I}JBJCJDJEJIJJJMJOJQJRJUJWJYJ[J\\JbJhJiJsJ{J}KAKFKIKKKOKWK\\K]K`Kb"},
  {0,NULL,"KcKkKoKsK~LBLCLELRLVLZL]L^LaLbLgLiLkLlLwL{M?MBMCMGMKMMMVMXM[MaMgM"},
  {0,NULL,"hMrMsMyN@NENJNWNXN]N^NgNmNoNqNrNuO@OCOEOLOPOYOZObOcOjOkOlOpOsOyOz"},
  {0,NULL,"O}P?PGPLPQPSPVP[P^PcPgPlPnPqPsPvQ@QDQGQJQNQSQWQXQYQeQhQlQoQ{Q~R?R"},
  {0,NULL,"CRDRMRSRWR[R]R^RnRrRuRwRxSFSHSJSMSOSSSYS]SaScSmSnSoSpSrSuTCTITMTN"},
  {0,NULL,"TZT^TcTeTgTiTjTpTrTuT|UNUOURUTUWUYU\\U`UbUcUkUxUzU|U}V?VDVGVQVSVWV"},
  {0,NULL,"XV\\V^VaVdVqVtVyV}WCWH_C?D?H?I?O?P?T?^?_?i?r?t?~@A@D@H@L@M@V@W@X@_"},
  {0,NULL,"@a@d@h@t@u@v@w@y@z@{@|AHAKAZA\\A^AaAdAeAfArAtBABCBFBKBPBRBVBYBdBeB"},
  {0,NULL,"vBwBzB{C@CDCHCICKCLCOCWC]C_CbCdCgChCnCsCtCuCvDCDKDMDWDXD[D]D`DaDj"},
  {0,NULL,"DlDmDrDzEDEEELE\\E^EeEkEmExEzE~FAFBFJFLFNFOFQFTFWFaFcFdFkFlFuFwFxF"},
  {0,NULL,"zF{G@GDGLGQGSGTG[G\\GfGgGhGiG~H?H@HAHUHXHYHZHuH|I?IAIBICIYIZI[IsIw"},
  {0,NULL,"IxIyIzI{JFJGJIJJJKJLJOJPJTJVJYJZJ`JaJcJiJlJzJ|J~KDKIKLKQKSKZK\\KaK"},
  {0,NULL,"bKeKhKjKnKtKzLELILJLPLSLULYL_L`LaLfLjLkLrLuLyL}L~M?M@MAMBMaMdMeMf"},
  {0,NULL,"MiMlMrMsMtNDNONRN^NbNcNiNmNnNrNtNvNzN{OAOBOJOSOUOZOaOdOgOiOlOoOtO"},
  {0,NULL,"xO|PFPIPLPMPOPPPQPRPSPTPrPsPwPzP{P|QBQFQGQJQPQTQ\\Q_QcQeQiQlQtQyQ{"},
  {0,NULL,"RARBRCRGRRRURXR]R^RoRpRqR{SASBSESHSJSPSXS\\S]S`ScSlSvSySzS{S~TMTNT"},
  {0,NULL,"RTTTYT_T`TcTfTgTmToTpTqTrUIUOUQUSUTUVUXU_U`UaUbVDVEVFVGVHVIVLVPVT"},
  {0,NULL,"VVV[V]V`VcVeVoVsV|V}WB_C?F?H?I?L?P?W?b?d?m?o?z@?@A@B@H@K@O@P@Q@S@"},
  {0,NULL,"Z@[@\\@k@n@o@r@v@wA?A@ACAGAKAOAPASA[AgAiAmAqAtAyA~BEBGBTBVBWB[B_Bd"},
  {0,NULL,"BiBmBxB{B~CCCMCNCOCSCTCVCZC[CdCiCjCkCnCoCzC|DCDEDIDNDPDUD[D\\DbDgD"},
  {0,NULL,"oDpDqDrDzD~EEEIESEWEgEjEnEyEzE}FAFFFPFRFVF[F\\F]F^F`FaFbFkFpFtFvFy"},
  {0,NULL,"G?GCGEGGGKGMGOGPGUG]GcGdGfGuG~HMHNHOHXH`HfHgHlHmHtISIVIXIdInIoIsI"},
  {0,NULL,"wIxIzI|JBJCJDJEJFJJJKJNJPJQJSJWJXJ]J_JeJgJlJtJvJwJxKEKHKLKMKUKZK]"},
  {0,NULL,"K^K_KaKkKlKrKyK}LFLJLNLRLXLYL\\L]LcLgLiLsLtLuL|M?M@MCMEMIMTMVMWM[M"},
  {0,NULL,"_McMiMrMtM{NANHNLNZN\\NaNbNdNnNoNpNsNtN}O?OEOOOROUO[OcOhOmOpOqOtOv"},
  {0,NULL,"OyOzPBPCPIPJPQPTPYP[P]PfPgPhPnPyPzP~QAQCQEQFQPQUQZQ]Q^QcQiQmQrQtQ"},
  {0,NULL,"uQxQzRARMRQRTRURZR]RiRjRkRwR|S?SCSESJSOSRSWS\\S]SfSmSnSoSpSrSuTFTJ"},
  {0,NULL,"TRTTT^T_T`TbTdTeThToTqTsTzUJUNUPURUUUVUXU_UaUfUsUwUyUzU{V?VHVIVOV"},
  {0,NULL,"SVWVZV^VbVdVfVpVsVzV~WAWI_C?G?H?J?L?N?U?Z?d?k?o?w@?@A@B@G@H@P@R@S"},
  {0,NULL,"@W@\\@]@d@m@o@p@r@v@x@|@~AEAHAIALAUAXA^AfAlAoApArA|A}BABHBPBQBYB]B"},
  {0,NULL,"bBdBjBqBrBvCECFCHCICJCSCUCVCXC\\C]CcCfCgCoCxCyC{DCDEDLDODTDVDWDYD^"},
  {0,NULL,"D_DaDcDhDtDxD|E?ENEPE[EdEnEpEyEzE}FAFDFIFPFQFRFTFUFVF`FaFbFkFnFtF"},
  {0,NULL,"wFyFzG?GAGHGKGMGPGTG[G\\GeGfGuGxG{G}G~HNHWHXHaHfHnHqHtIFIIISIaIeIn"},
  {0,NULL,"IvIzI}J?JAJBJDJEJIJNJQJRJSJUJWJXJYJZJ\\JaJdJiJjJrJsJ|K@KFKGKIKSKTK"},
  {0,NULL,"ZK]K`KbKfKhKoKqKwKzLALGLMLTLULVL`LcLdLeLlLnLpLxLyM@MDMIMRMSMTMYMZ"},
  {0,NULL,"M\\M`MeMhMpMuMvNENQNSN^NgNhNiNkNnNpNqNwNxNzOAOFOIOSOTOVO_OcOgOjOlO"},
  {0,NULL,"sOuOxO{O}P@PEPHPTPYP\\PbPdPfPiPjPoPtPvP|Q@QGQKQMQOQTQ\\QaQeQfQhQnQo"},
  {0,NULL,"QqQ{Q}RBRFRIRLRPRSRXR\\RfRgRhRxR{S@SDSGSNSQSYSZS_S`SeShSmSoSpSqStT"},
  {0,NULL,"ATDTMTPTWT]T`TcTdThTlTpT~U@UCUJULUMUOUUUXUZU`UmUnUrUyU{VBVCVDVIVJ"},
  {0,NULL,"VRVVVXV]V_V`VbVcVhVnVqVuWAWHWK_C?F?I?J?K?P?V?]?^?j?s?t?{?|?}@J@K@"},
  {0,NULL,"M@T@W@Y@\\@^@`@l@o@s@t@w@y@~A@ABAIAJAMAQAXAbAgAlAnApAuA{BDBHBJBQBW"},
  {0,NULL,"BXB]BaBcBfBmBxB|C@CCCFCGCLCMCPCVCXC[C]CbCcClCtCuC}D@DADDDGDHDKDSD"},
  {0,NULL,"VD[DaDeDjDkDnDqDwEAEEEIENETEcElEmEwE{F?FEFFFGFMFNFQFRFXFYFeFgFiFo"},
  {0,NULL,"FpFrFsFxFzF|G?GBGOGUGVGWGXG]GmGpGsGwGzG|HEHHHQH^HdHhHnHsHxIFIQIRI"},
  {0,NULL,"eIkIlItIyIzI{J?J@JDJEJJJOJPJQJRJTJWJXJYJZJ[JdJeJhJjJpJyK@KAKGKKKM"},
  {0,NULL,"KTKWK[K]K`KhKnKoKrKsK|K}LFLKLNLQLTL[L\\L_LaLfLoLqLtLyL{L~MAMHMLMOM"},
  {0,NULL,"QMUMXM^M`MdMiMmMtMxNJNLNSNWNXNaNhNkNlNrNsNwNyN{N~O?OMONOOO[OcOgOi"},
  {0,NULL,"OjOkOsOvP?PAPDPEPFPIPPPRPUPWPXPePkPlPuPyP{P|QAQCQJQMQNQTQWQZQ\\Q^Q"},
  {0,NULL,"fQlQqQuQzQ~RBRCRIRORRRYRZR^RiRjRkR|R}SASDSHSKSPSUSZS^ScSfShSnSqSr"},
  {0,NULL,"StSuTGTITLTPTXT\\T^T`TaTbTmTuTxT~UDUHUIUKUNUPUXU^UcUdUmUtUwV?V@VAV"},
  {0,NULL,"IVLVNVOVPVTVUVYV[V\\V]VmVnVtV{W@_C?G?I?J?M?N?V?[?`?j?p?y?~@C@F@G@L"},
  {0,NULL,"@N@Q@S@V@^@`@a@l@o@p@q@s@u@|A?ADAFAKARASA\\AcAfAjAmAsAtAvA~BFBLBPB"},
  {0,NULL,"SBVB^B_BeBkBqBrBzB~CCCDCECOCPCSC\\C_C`CaCbCcCjCqCvC}D?DADBDFDGDHDM"},
  {0,NULL,"DTDUDbDfDjDkDtDuDwD|E@EOEWE[EcEqEsEvExE|FBFDFJFKFOFPFXFYF[FdFhFjF"},
  {0,NULL,"lFnFsFyF{F|F~GCGDGIGJGRGTG[G\\GhGjGkGoH@HBHCHGHTHUHVHbHlHoHrIGIPIV"},
  {0,NULL,"IfIjIoItIyI|I~J@JBJCJEJKJMJPJQJRJSJUJVJWJXJ]JaJfJkJlJqJtJzKBKLKRK"},
  {0,NULL,"SKUKXK\\K_K`KeKfKgKmKnKwLALHLILMLRLSLYL[L\\LcLfLhLoLxLzL|MBMGMLMMMN"},
  {0,NULL,"MQMUMYM]M^M_MlMmMvMwNANQNVNYNZNbNeNiNmNoNpNtNvNxN~O?OIOJOVO\\O_OdO"},
  {0,NULL,"fOhOiOjOrOwP@PAPCPDPMPSPUPVPXP`PcPjPkPmP{P}P~QBQKQOQPQQQUQ]Q_QaQi"},
  {0,NULL,"QkQnQpQrQyQ}RARFRKRLRRRTRVRYRfRgRhRzSASCSISKSNSPSRS^SbSdSeShSnSqS"},
  {0,NULL,"rStSuTBTETRTVTZT[T]T`TaTcTiToT}UAUFUGULUOUWUXU\\U^U_UiUjUoUxU|U~VC"},
  {0,NULL,"VDVIVNVTVUVYV[V`VaVeVfVgVlVwVzWCWIWK_C?E?H?J?K?O?U?]?_?k?r?s?{?|?"},
  {0,NULL,"}@I@J@M@U@V@Z@\\@]@`@m@p@t@w@x@y@}ACADAFAGAPAYA_AcAiAjAkAqAsAxAyBI"},
  {0,NULL,"BLBSBTBZB[B^BcBgBoBsBuB~C?CCCDCICNCSCWCXC^C`CdCfCmCsCuCxC{D@DDDID"},
  {0,NULL,"MDQDWDYDZD_D`DcDmDpDuDxEDEGEJEOESEdEkElEwE{F?FCFEFHFIFNFOFRFYF^Fe"},
  {0,NULL,"FgFiFmFoFqFvFxF{F|G?GAGNGVGWGXGYGZGpGrGvGwG|HHHIHPHQHSH\\HhHmHrHxI"},
  {0,NULL,"PIQIXIdIjIkIvIxIyIzI~JAJCJEJFJJJPJQJSJTJUJVJWJYJ_JbJfJgJkJoJuJwKB"},
  {0,NULL,"KEKHKOKRKXK[KaKcKdKgKjKoKqKxK~L?LCLRLSLXL\\L^L`LcLkLnLpLrLsLzL}MAM"},
  {0,NULL,"DMHMOMRMWMZMeMgMjMlMpMsM~N@NHNVNYN\\N]NdNeNlNoNpNvN}O?O@OAOPOQOWOY"},
  {0,NULL,"ObOeOfOoOsOtOuOxO~PGPHPJPMPOPRPWP\\PbPePhPiPsPtPwP}QBQDQEQFQQQSQXQ"},
  {0,NULL,"YQ_QcQkQmQpQtQxQyR?RDRKRNRURXR[R\\RnRrRuR{R~SESGSISMSSSVS\\S_S`SdSh"},
  {0,NULL,"SmSoSpSqStTHTJTKTVTXTYT\\T^TcTjTlTsTwT{UFUHUKUNUOUQUYUZUfUhUjUvU}V"},
  {0,NULL,"?V@VAVDVEVJVPVQVRVVVZV_VcVeVkVlVpVxW@_C?G?H?I?L?M?T?\\?c?i?q?v@@@D"},
  {0,NULL,"@E@H@L@O@V@W@X@Y@Z@_@h@n@s@u@v@x@~AAADAGAJAMATAVA_AhAjAlAqAuAxB?B"},
  {0,NULL,"@BDBUB\\B]B^B`BcBjBkBvBzB~CACFCGCJCMCPCVCYC^C`CfCjCmCpCrCwCzC|C~DJ"},
  {0,NULL,"DMDNDPDVD]DaDdDgDrDsDuDvE?E@ENEOEREeEoEtEuE~F@FAFBFLFMFOFQFWF\\F^F"},
  {0,NULL,"_FcFfFkFlFuFvFzF{G@GBGEGLGQGSGTG[G\\GgGiGqGtGyH?HAHKHRHYHZHeHxHyI@"},
  {0,NULL,"IQIUIWIcIkIpIuIwIxI{I~J?JGJJJLJPJQJRJSJTJUJWJXJYJ^JdJfJgJhJmJnJuJ"},
  {0,NULL,"yKGKPKRKVKYK[K]K_KcKdKgKiKqKzLGLHLILNLQLRLTLVLWL[LiLuLvLwLyLzMCME"},
  {0,NULL,"MFMJMKMPM[M`MaMbMcMlMoMuMwNGNSNVNYN[NfNhNjNlNoNqNsNwNyN|N~OJOSOTO"},
  {0,NULL,"\\ObOcOeOfOhOnOuOzPBPEPLPMPNPZP[P]P^P_PaPnPpPqPzP|P}Q?QBQMQQQRQTQ["},
  {0,NULL,"Q\\Q_QdQfQkQpQqQsQwQyRBRGRIRKRQRWR]RfRgRhS?SBSDSFSISJSWSXSZS]SaSdS"},
  {0,NULL,"gShSiSqSsStTGTHTQTSTWTZT[TaTdTeTlTyT{UBUDUGUJUMURUZU\\U^UpUqUtUvUx"},
  {0,NULL,"UyUzU~VBVJVNVOVQVSVWVXV^VdVfVkVmVoV|W?WHWI_C?G?I?J?M?N?V?[?`?j?p?"},
  {0,NULL,"y?{@B@E@J@K@M@P@T@Y@\\@_@b@l@o@p@q@s@u@|A?ADAFAKARASA\\AcAfAjAmAsAt"},
  {0,NULL,"AvA~BFBLBNBRBSBTBVB[BpBsBxB|B~CACHCICKCOCRCZC\\C^CaCgCiCmCqCrCwC{D"},
  {0,NULL,"?DEDHDJDNDSDTDWD^DhDjDqDsDuDyD}EFELEVEYEcEqEsEwE}F@FEFFFGFMFNFRFV"},
  {0,NULL,"FWFZF_FbFeFoFpFrFtFuFxF}G?GBGOGUGVGWGXG]GdGlGpGsGzHDHHHOHQH^HcHgH"},
  {0,NULL,"wH|H~ICIKINI[I`IbIqIwIyI}J?J@JGJIJKJLJMJNJOJQJRJTJYJZJ]JaJfJkJlJq"},
  {0,NULL,"JtJzKBKEKHKJKLKQKXK^KbKcKdKfKlKmKxL@LFLKLPLRLULWLYL`LbLeLfLlLtLwL"},
  {0,NULL,"zMDMKMMMNMPMTMUMXMYM[MbMeMqMyM}NKNMNON\\N`NbNcNdNeNoNtNuNzN|OAOBOK"},
  {0,NULL,"OMOWO[O_ObOeOlOmOqOrOxOzP?P@PDPNPVP\\P^P`PaPfPoPqPvPyP{P}QCQFQHQJQ"},
  {0,NULL,"LQSQYQZQ`QcQgQlQtQuQvQ|RCRDRIRJRORPR[R]R_RbRcR}S@SDSJSLSMSQSSSTSU"},
  {0,NULL,"SZS]SjSwSySzS|S~T@TKTOTTTWTYTeThTjTkTnTqTtTwU?UMUQURUUUYU[U]UaUeU"},
  {0,NULL,"hUlUzU{U}VBVEVKVMVQVRVWVXVZV^VbVcVmVnVuV|WDWGWLWP_C?E?I?J?K?M?Y?a"},
  {0,NULL,"?c?l?q?x@@@D@E@J@L@Q@R@W@X@Z@^@c@i@n@q@s@t@x@zACAEAIAKALANAZA[AdA"},
  {0,NULL,"iAoApAtA}BEBKBMBOBRBTBYB\\BdBgBhBsBwCCCECICJCLCQCUC[C`CcCdChCiCkCp"},
  {0,NULL,"CrCtC}C~D?DFDHDIDKDLDRDfDhDkDlDnDpDyD}EGEPESEUEfErEtEuE~F@FBFEFLF"},
  {0,NULL,"QFSFUFXF[F^F_FcFfFlFoFsFvFzG@GCGFGHGLGNGQGSGYGZGgGlGnGtH?HDHFHKHR"},
  {0,NULL,"HYH[HcHpHtHyIHISIUI_IcInIqIxI|I}J?J@JCJDJEJGJHJJJNJQJSJUJXJYJ\\J_J"},
  {0,NULL,"cJjJlJrJxKCKDKEKIKNKQKYKZK^K`KaKgKkKrKtKxL?LBLELMLOLVL\\L`LaLdLhLj"},
  {0,NULL,"LlLoLqLsL~MFMJMLMNMPMUMWM]MdMhMkMqMyM~N?NENHN\\N^N_NcNfNnNqNrNxO?O"},
  {0,NULL,"AODOFOLOQOWOZOaOfOjOmOpOtOvOwO}PDPFPJPKPPPUPZP_P`PaPhPkPmPrPuPvQ@"},
  {0,NULL,"QEQFQGQLQVQ`QbQcQeQhQmQoQtQxQ{Q|RERJRORSRURVRYRnRrRuRxRzR}SESKSLS"},
  {0,NULL,"TSUSYS\\S^SbSgSiSmSoSpSsT@TDTTTUTYT\\TaTeTgTiTlTqTtU@UEUHUQURUTUWUZ"},
  {0,NULL,"U^UaUeUnUuUzU|VAVEVGVJVNVOVTVUVYV[V\\V`VeVjVuVvV~W?WK_C?D?I?J?N?P?"},
  {0,NULL,"Y?Z?b?l?w?z@?@A@B@G@K@O@Q@W@[@]@`@d@i@o@q@r@t@v@{@}AAAFAJAVAWAYA`"},
  {0,NULL,"AeAhAkAsAuAwAzB?BIBNBUBZB[B`BbBnBpBtB}C?CBCECKCLCPCTCWCYC[C`CbCfC"},
  {0,NULL,"mCoCtD?DADCDEDFDGDJDKDQDXDdDfDiDjDmDnDyECEFEJEQEREfEjEpEyEzE}FDFF"},
  {0,NULL,"FIFQFTFYF[F\\F]F`FaFbFnFpFwFzF|GAGCGEGGGKGMGPG^G_G`GcGdGeGxG{G}HMH"},
  {0,NULL,"OHWH`HaHgHmHqI@IIIWIXIaIdIpIqIwIyI|J?JAJCJDJFJIJJJLJPJRJSJUJWJYJ^"},
  {0,NULL,"J`JbJhJkJnJoJ{K?KFKHKJKOKPKVKcKgKiKjKnKqKrKvL@LDLLLMLPLZL[L]L^LaL"},
  {0,NULL,"fLhLkLmLqLvL~M@MIMNMQMTM]M^MbMdMfMgMqM|M}N@NFNGN[N]N`NdNgNjNrNxN~"},
  {0,NULL,"O@OBOCOEOHOKOXO^ObOfOiOnOoOuOvOwO|PAPFPGPNPPPTPXPYP`PfPmPpPsPuPxP"},
  {0,NULL,"{Q?QDQHQIQRQSQXQYQ[QdQgQjQsQvQwR?R@RDRGRHRORRRVR[RsRtRvRyRzR}SASB"},
  {0,NULL,"SMSPSSSUSXS[SbSgSiSmSoSpSsTCTKTOTQT\\T`TdTfThTiTkTwT|U?UBUHUJUSUUU"},
  {0,NULL,"WUXU[UhUkUlUpUyU{U|VAVFVIVKVPVTVUVYV[V]VaVfViVxV|V}WAWI_C?F?H?I?L"},
  {0,NULL,"?P?W?b?d?m?o?z?|@@@C@I@L@M@N@R@`@b@c@d@k@n@o@r@v@wA?A@ACAGAKAOAPA"},
  {0,NULL,"SA[AgAiAmAqAtAyA~BEBGBOBSBTB\\B^B_BhBkBlBoC@CKCNCPCQCSCUCWC[C\\C]C^"},
  {0,NULL,"CaCiCuCyC|C~DADCDGDLDNDXDYD[D^DaDbDmDnDoDvE?ECEMEVEZEgEjEnEuE{E|F"},
  {0,NULL,"BFCFKFNFSFTFUFYFZFfFgFhFlFmFwFxF|F}F~GFGHGIGJGNGRGYGZGaGkGtGvHCHJ"},
  {0,NULL,"HKHPHRHSH]HbHiHwH{IDINIOI\\I`IiIuIwI{J?JAJBJDJFJHJIJLJMJNJOJRJTJWJ"},
  {0,NULL,"ZJ]J_JeJgJlJtJvJwJxKEKNKRKUKXKYK^KdKfKhKjKmKrKuK~LBLHLOLPLXL[L_Lc"},
  {0,NULL,"LdLeLgLkLqLyL|M@MAMEMFMQMSMZM[M^MfMhMiMoMuM|NKNNNPNYNZN\\N_NeNfNpN"},
  {0,NULL,"{N}N~OBODOFOGOLOPO\\O_OeOgOmOoOrOvOzO|O}PAPHPIPRPTPXP]P_PdPgPoPsPu"},
  {0,NULL,"P|P~Q@QLQOQQQRQSQYQ[Q`QaQhQkQoQpQwQ|Q}RDRGRLRORWR\\R^RaRlRmR}SBSFS"},
  {0,NULL,"GSHSNSUSXS_SaScSeSjSkSwSxS|S}T@TBTHTST[T\\T]TfTlTmTnTtTyT{T}UGUHUI"},
  {0,NULL,"ULUSUZU]UeUiUqUvU~VAVCVFVJVLVMVPVRVTV[V]V_V`VeVmVrVtVyWEWOWPWS_C?"},
  {0,NULL,"F?H?J?K?L?X?\\?a?n?v?x@@@D@E@H@J@Q@R@V@Y@]@_@c@j@n@r@s@x@y@{A?ABAF"},
  {0,NULL,"AHARA]A`AaAeAmAnArAsAvAzBBBCBNBRBVBXB`BeBfBiB{B|C?CFCKCLCRCSCTCXC"},
  {0,NULL,"\\CaCbCdCeCjCpCrCsCxCyC~DODSDUDXDYDZD^D`DbDcDeDiD{D~EAEQETEWEhEoEr"},
  {0,NULL,"EuE~F@FAFEFIFMFOFSFUFWF[F_FcFfFkFoFuF{GAGBGCGFGHGLGOGQGSGUG]GiGlG"},
  {0,NULL,"nGqGyHAHDHFHZH[HcHeHoHpI@IGIHIWI_IfIpIrI{I|I}I~JAJCJDJEJHJJJLJMJP"},
  {0,NULL,"JRJUJWJXJ[J]J`JiJkJqJ}J~K?KJKKKLKQKVK\\K_KaKfKmKnKoKpKyK|LJLKLPLTL"},
  {0,NULL,"]L^LaLbLcLeLmLnLrL{L|L}MFMJMPMRMSMXMZM\\M_MfMjMnMxM{NANFNJNWN`NbNc"},
  {0,NULL,"NjNmNpNrNuNwO@OBOEOMONOROUO_O`OhOiOrOsOtO{O|O~P?PCPHPOPZP_PaPbPdP"},
  {0,NULL,"iPlPoPwPxP~QHQIQJQNQPQUQWQ]QgQiQjQlQrQvQ~R@RARCRHRNRPRTR\\R^RiRjRk"},
  {0,NULL,"RyR~S@SCSGSHSQSRSVS[S_ScSgSiSnSrSsSuT?TETNTOTXT_TaTeThTlTmTrTvU?U"},
  {0,NULL,"AUIUKURUUUVUZU^UbUgUlUoUzU{V@VHVJVLVNVQVRVVVZV]V_V`VcViVrVwVyW?WK"},
  {0,NULL,"WR_C?G?H?I?L?M?T?\\?c?i?q?v?}@?@F@I@K@T@U@]@^@a@c@d@h@n@s@u@v@x@~A"},
  {0,NULL,"AADAGAJAMATAVA_AhAjAlAqAuAxB?B@BDBUBWBZB[BaBcBpBuBxByCACBCCCDCFCK"},
  {0,NULL,"CUCXCYCZC]C`CaChCvCxCzC}C~DCDHDLDMDODPDXDaDbDcDfDlDsDzD}D~EHEYE_E"},
  {0,NULL,"eEoEtEvEyF?FCFFFGFHFIFJFSFTFXF`FiFjFmFpFqFrFsFwGAGDGFGVGWGXG^G_G`"},
  {0,NULL,"GbGcGmGrHEHIHLHMH\\H_H`HdHkHvH}ILIMITI^IgImIsIxI{I|I}JBJEJGJHJIJKJ"},
  {0,NULL,"LJMJNJUJVJXJZJ^JdJfJgJhJmJnJuJyKHKMKOKPKWK[KgKhKiKlKmKoKtK{L@LCLF"},
  {0,NULL,"LPLSLTLWLZL\\LdLhLjLnLwLyL|M@MBMCMFMLMRMUM\\McMfMhMlMrMyM{NINMNUNXN"},
  {0,NULL,"[N]NaNdNlNvNwN|O?OBOCOFOKOYO[O]OaOfOgOnOqOrOsO{O|O}PBPDPMPSPTPUP["},
  {0,NULL,"P_PbPiPmPqPrP|P~QCQDQEQHQNQVQWQXQZQbQgQmQuQvQxQ~R?RERLRMRPRURVR^R"},
  {0,NULL,"_RbRcRwRzS@SESHSNSOSQS\\SbScSeSlSvSySzS{S~TCTFTITJTYT]TbThTiTjTmTs"},
  {0,NULL,"TuTzT|UIULUPUQUUUWUYUcUfUkUsUwU{U|U}VCVEVLVPVRVUVYV]V_V`VeVgVhVqV"},
  {0,NULL,"zWFWNWPWT_C?D?H?J?N?O?X?`?e?n?p?u?{@B@E@H@J@N@Q@T@Y@[@_@c@j@p@q@r"},
  {0,NULL,"@u@y@zA@AAAGAIANAOATAbAdAgAhApAqB@BGBJBMBTBWB\\B]BcBdBfBgBvB{C@CBC"},
  {0,NULL,"JCNCOCPCQCYCZC]C_C`CkClCoCwC{D?DBDDDGDODQDRDUD]D`DdDeDfDoDtDxD|ED"},
  {0,NULL,"EHEZE^EhEiEqEwE}F@FAFEFGFKFMFSFWF[F]F_FbFeFkFoFrFuF~GBGCGFGGGLGOG"},
  {0,NULL,"QGSGUG]GlGpGqGuGyHDHHHNHQHcHeHfHjHvHwIEIMINI]I`IgIvIyI}I~JAJBJCJF"},
  {0,NULL,"JHJIJKJLJMJOJRJUJVJZJ^JcJeJgJjJmJpJvKCKEKGKMKYKZK[KeKgKhKiKkKlKsK"},
  {0,NULL,"zK|L?LJLOLVLXLYLZL[L_LgLhLrLvLxL{MDMGMHMIMKMNM\\M^M_MaMgMkMpMsMvND"},
  {0,NULL,"NINNN\\NaNfNhNlNnNqNtN{N}N~OCODONOQOSOUOdOfOgOkOnOpOqO{PAPCPGPKPLP"},
  {0,NULL,"YP\\P^P`PcPePgPjPlPmPpPwQ@QEQNQPQQQTQWQ\\QhQiQkQmQoQpQxQ~RARBRHRKRM"},
  {0,NULL,"RRRSR\\RoRpRqRwRxRySASGSISOSPSYS[S_SdSjSlSvSwS{S|TDTHTJTPTWTYT[T^T"},
  {0,NULL,"`TgTkTsT{T~U@UGUMUNUQUTUXU[UfUmUnUvU~V?VBVEVGVIVKVOVSVUV[V\\V^VaVf"},
  {0,NULL,"VhViVrVxWDWLWNWQWS_C?D?I?J?N?P?Y?Z?b?l?w?z?|@@@C@J@L@P@R@U@X@Z@b@"},
  {0,NULL,"c@i@o@q@r@t@v@{@}AAAFAJAVAWAYA`AeAhAkAsAuAwAzB?BIBXBZB^B`BcBeBfBg"},
  {0,NULL,"BwBzCACBCDCFCHCNCTCWCZCeCfCgCjClCqCyC|D@DADEDIDJDKDODTD\\D_DfDhDiD"},
  {0,NULL,"qDrDwD|EEEHE\\E]EfEjEpEuE{E|FBFEFHFLFSFUFVFZF^FfFgFhFlFoFqFtFvF}G@"},
  {0,NULL,"GFGHGLGNGQGSGYGZGkGnGtGwG|HCHFHKHRH[HbHhHiHzH}IDIJITI\\IhImItIzI|J"},
  {0,NULL,"?J@JBJDJFJGJHJIJKJNJOJSJVJXJZJ^J`JbJhJkJnJoJ{K?KKKOKRKVK[K\\K_KbKj"},
  {0,NULL,"KlKpKqKsK|L?LELILSLTLULWLXLZL]LhLlLmLpLtLuMEMMMOMQMSMTMVMWMYM\\MbM"},
  {0,NULL,"dMmMtMvNINRNTNWNYN]NjNlNmNvNwNzN|N}OCOEOJONOQOZO`OhOkOlOoOqOuOyO{"},
  {0,NULL,"P@PFPJPNPVPWPXP]PdPfPmPtPvPxPyPzQBQEQGQMQNQUQWQ]Q_QeQfQmQqQrQxQyQ"},
  {0,NULL,"{Q~RIRJRMRTRXRYRoRpRqRwR{SCSDSKSLSOSRSTSZS^S`SkSlSvSxS{S}TETGTITV"},
  {0,NULL,"TWT[T^T_TcTmTnTuUAUDUFUGUIUMUNUOUVU]UcUjUoUtU~V?VBVDVHVLVMVQVRVSV"},
  {0,NULL,"XVZVbVcVdVgVjVvV{WEWJWPWQWV_C?D?H?J?N?O?X?`?e?n?p?u?~@C@F@G@I@O@R"},
  {0,NULL,"@V@\\@^@a@b@j@p@q@r@u@y@zA@AAAGAIANAOATAbAdAgAhApAqB@BGBJBMBOBUBWB"},
  {0,NULL,"\\B_BaBlBtByB}C?C@CACFCICMCPCZC[C\\CdCfChCkCqCsCvCyC{DBDJDODRDWDZD["},
  {0,NULL,"D^D_D`DdDlDqD{EBEFEIEREUEhEiEqEvExE|FCFDFJFOFRFUFXFZF\\FdFhFjFmFnF"},
  {0,NULL,"sF{F}G?GDGEGHGIGJGRG^G_G`GaGbGjGoHBHGHJHLHTHVH]H_HlHsHyIRIUIVIcIl"},
  {0,NULL,"IoIrIwIzI}I~J@JCJDJGJJJKJOJPJQJRJSJXJYJ^JcJeJgJjJmJpJvKCKMKNKPKUK"},
  {0,NULL,"WKYKaKfKkKlKqKrKtKuK{LDLLLNLTLWL[L^L_L`LeLjLpLrLtLvL}MBMDMGMMMSM\\"},
  {0,NULL,"MbMeMiMjMkMnMzM}N?NGNLNXNZN[N_NaNfNsNwN{N|N~O@OAOGOXO]O^O_OaOpOqO"},
  {0,NULL,"tOuOvOxO{O~PIPKPNPOPSPVP\\PcPdPoPpPrPtPwPyQ?QAQCQLQRQVQZQ[Q^Q`QbQd"},
  {0,NULL,"QsQuQwQzQ|RERGRJRNRPRXRZRsRtRvR{R|R~S@SBSLSQSTSVSXS`SfSgSiSnSrSsS"},
  {0,NULL,"uTFTLTSTUTXTZTcTfThTiTnTxTyTzUEUKUOUSUUUWU\\U]UdUqUsUuUxU{U|V@VDVF"},
  {0,NULL,"VMVPVRVVVXV_VbVcVeVjVoVsV{WCWHWUWW_C?F?H?J?K?L?X?\\?a?n?v?x?}@?@F@"},
  {0,NULL,"G@I@O@T@X@[@^@a@b@j@n@r@s@x@y@{A?ABAFAHARA]A`AaAeAmAnArAsAvAzBBBC"},
  {0,NULL,"BNBPBSBZBbBeBlBoBrB}B~CGCHCKCLCOCQCWCYCcCeCiCjClCoCpCxCzC}DDDKDND"},
  {0,NULL,"RDUDVDZD^DdDeDkDpDrDxE?EGEKEVE\\EhEoErEvEyF?FCFDFGFJFLFXFZF\\F]F`Fi"},
  {0,NULL,"FjFmFnFrFsF}G@GDGEGGGIGJGRG^G_G`GbGoGrGxG{HGHIHLHTH\\H_HaHuH}H~IAI"},
  {0,NULL,"KITIYIbImIvIxIzI}I~J?JFJGJHJJJKJLJNJOJQJTJXJZJ[J]J`JiJkJqJ}J~K?KF"},
  {0,NULL,"KJKOKSKXK\\K^K_K`KiKjKpKsKuKwK~LLLOLPLQLRLULYLaLeLoLsLuLvL{MCMHMIM"},
  {0,NULL,"JMLMRM[M_M`MdMjMkMpMuM~NCNKNRN]N`NeNgNiNmNoNrNtNyNzOBODOGOPOVO^O`"},
  {0,NULL,"OhOjOkOmOnOoOzO~PCPEPFPKPUPYPZP[PbPePhPkPlPoPpPzQ?QBQGQKQLQSQYQ_Q"},
  {0,NULL,"`QdQeQnQsQyQ{Q|RDRFRKRORQRSRXRZRaRlRmRxR{R|R}S?SISUSWSYS`SdSfSjSl"},
  {0,NULL,"SvSwS{S|TATKTMTVT[T\\T]TbTdTgTjTpTwUCUFUGUHUJULUPUTUYU`UhUjUrUwUyU"},
  {0,NULL,"}U~VAVCVGVOVTVWVYV\\VaVdVfVnVpVsV{WFWGWJWOWT_C?E?H?I?M?O?W?[?e?m?u"},
  {0,NULL,"?y?{@B@E@H@K@M@P@Q@[@\\@a@c@k@n@p@q@u@w@}ABAEAHAJAQAUAWA]AkAnAoArA"},
  {0,NULL,"uAwA{A|BBBNBQBXB]B`BbBiBjBmBnC?C@CDCECGCRCUCWCaCcCeCfChClCuCvCwC{"},
  {0,NULL,"C~D?DFDLDMDZD[D\\D_DbDgDkDlDmDvE@EBEKEXE]EgEiEsEwE}F@FAFFFJFNFRFSF"},
  {0,NULL,"VF[F]F_FbFeFkFpFtFxG?GCGDGFGGGKGMGOGPGUG]GdGqGsGuGyGzHNHOH^HeHfHg"},
  {0,NULL,"HjHzH~IEIJIKI]IbIhIuIwIxI~J@JBJCJFJGJHJKJMJNJOJQJSJTJVJ[J\\JbJhJiJ"},
  {0,NULL,"sJ{J}KAKFKGKJKKKTKVK`KjKmKpKqKsKtKvKyK}LGLMLQLSL^L_LbLdLiLjLkLoLp"},
  {0,NULL,"L|MAMBMDMFMKMNMVM]MhMiMjMlMoMwMzNBNCNTNWN`NgNhNjNkNuNvNxNyN{O@OFO"},
  {0,NULL,"HOOOROTO`OaOjOkOoOrOuOwOyO}O~PIPMPRPSP\\P^P_P`PkPnPrPsPtP~Q?QAQIQK"},
  {0,NULL,"QMQUQ]Q^QdQfQjQnQqQrQsQzR@RFRGRLRNRQRURYR`RdReR~S?SBSESKSNSVSWSXS"},
  {0,NULL,"\\S^SeSjSkSwSxS|S}T?TATGTQTWTXTYT]TaTfTkTvUBUCUDUKULUMUQUSU[U^UgUp"},
  {0,NULL,"UrUtV@VBVCVEVFVKVNVPVUVVVYV]V`VcVeVkVpVvV~WDWMWNWTWV_C?G?H?J?L?N?"},
  {0,NULL,"U?Z?d?k?o?w?|@@@C@I@J@M@N@U@X@Z@[@`@m@o@p@r@v@x@|@~AEAHAIALAUAXA^"},
  {0,NULL,"AfAlAoApArA|A}BABHBOBQBRBXBYBaBsBuByB|CBCECGCMCOCRCUCVCYC_CbCgChC"},
  {0,NULL,"iCoCpCyC|DADBDFDPDQDUDVDWDcDdDgDjDpDtD{D~EFELEXE_EdEnEpEuE{E|FCFE"},
  {0,NULL,"FHFKFLFNFYF]F^FfFgFhFmFoFqFvFxF|F~G@GGGNGVGWGXGYGZGaGnGvGwG|HFHJH"},
  {0,NULL,"PHSH[H]HhHzH{I?IBIJIOIZIhIiIrIwIzI|I~JAJFJGJIJKJLJMJNJPJSJTJVJWJ\\"},
  {0,NULL,"JaJdJiJjJrJsJ|K@KIKKKNKQKTKWK]K^KbKeKiKnKtKxK{LCLKLMLNLQLYLZLbLdL"},
  {0,NULL,"fLiLnLsLvLxMEMGMIMJMQMSM]M_M`McMeMgMnM{M}NBNONUNWNXN^N_NcNkNsNtNu"},
  {0,NULL,"NxNyOCOFOMOWOYO]OaOcOdOiOlOmOnOwOxPBPCPEPGPXPYPZP]PcPdPhPiPjPnPpP"},
  {0,NULL,"{QAQDQFQIQJQVQXQ^QbQcQjQlQtQzR?R@RCRERHRKRNRVRZR]R_RbRcRyRzR|R~SI"},
  {0,NULL,"SJSVS[S]SbSdSfSkSxSySzS}S~T?TLTNTUT[TbTeTiTkTmTnTrTvTxUEUGUIUPURU"},
  {0,NULL,"WU[U]UbUdUgUuUwUzU|U~VKVLVMVOVUVWV[V\\VaVdVfVkVlVoVwWEWGWJWNWS_C?E"},
  {0,NULL,"?I?J?K?M?Y?a?c?l?q?x?}@?@F@G@K@O@U@[@]@_@b@d@i@n@q@s@t@x@zACAEAIA"},
  {0,NULL,"KALANAZA[AdAiAoApAtA}BEBKBMBOBPBQBWB_BdBmBnBqBtC@CACJCNCQCRCSCVC^"},
  {0,NULL,"C_CdCeCgChCqCrCxCzC}D@DFDIDJDSDYD]D`DgDhDiDnDuDwE@EAEMEXE^EfErEtE"},
  {0,NULL,"vEyF?FDFFFHFIFTFWFZF\\F]F`FiFjFnFpFqFuFwF}GAGEGGGKGMGPG^G_G`GcGmGo"},
  {0,NULL,"GxG{HEHGHMHTH`HaHdHuHvH{IAIMIOIYIgIiItIyI{I|I~J?JFJGJHJIJJJLJMJOJ"},
  {0,NULL,"TJUJVJWJ\\J_JcJjJlJrJxKCKDKMKNKSKTKUKZK]KaKbKdKeKpKtKvK}LALDLOLVLW"},
  {0,NULL,"LXL_LbLcLiLlLmLqLrLzMCMLMMMOMPMRMWMXMZM]MaMbMmMwMxNBNDNPNZN_NaNiN"},
  {0,NULL,"kNnNpNqNuN{N|N}ODOHOIOOOXO`OaOcOdOeOlOtOwP?PHPJPLPNPUPVPWP[PaPbPn"},
  {0,NULL,"PuPvPwPxP}QAQIQOQPQRQTQ[Q\\Q^QaQiQjQwQzQ}R@RARBRIRNRRRTRWR[R`RdReR"},
  {0,NULL,"~SASCSDSFSMSPSRSSSVSZSaSkSlSvSxS{S}TBTLTPTRTWTXTZT]T_TbTjToTxT}T~"},
  {0,NULL,"UKULUMUPUVUYU\\U_UdUiUmUwUxU}V@VBVCVHVQVVVWVXVZV^V_VbVlVtVxV}WFWGW"},
  {0,NULL,"LWMWZ_E?G?H?L?M?O?R?Z?]?f?s?w?{?}@@@A@C@J@N@U@V@[@]@`@f@h@k@m@p@x"},
  {0,NULL,"@zA?AKASATAZA]A`AbAdAmAtAzA~B@BBBJBKBQBUBWB^BbBeBhBkBlBnBpBqBsB{C"},
  {0,NULL,"FCMCNCPCTCWC]CbCeClCnCrD?DCDHDJDODQDSDTD[DcDeDfDhDkDnDrDyEEEKENER"},
  {0,NULL,"E]E`ElEpEuEwEzE|F?FEFHFIFKFOFYF]FaFeFfFhFiFoFqF{F|F~GAGGGnGoGpGqG"},
  {0,NULL,"vGyHFHGHHHPHQHSHTH[HeHmHrH{I?IBIOIPIXIZIdIiIjIqIrIsIvIwIxIzI}JEJG"},
  {0,NULL,"JIJJJKJNJQJSJTJYJ]JcJlJmJpJtJ}K?KDKFKMKPKRKTK\\KhKjKnKpKsKuKvKxL@L"},
  {0,NULL,"ALBLHLJLNLTLXL[L]LhLlLnLoLqLuL{M?M@MNMPMUMXMYM\\MbMgMiMqMtNCNGNSNT"},
  {0,NULL,"NYN[NaNgNkNmNsNwN}N~OEOGOHOIOKOLOUOWO\\O`OgOiOkOoO{P?P@PDPGPIPNPQP"},
  {0,NULL,"TP`PaPiPkPlPmPuPvPzQ?QDQFQTQUQXQ\\Q]QcQdQrQsQtR?RBRJRKRLRNRORWRiRj"},
  {0,NULL,"RkRoRpRqR}R~SFSISLSNSTSUSVSaSdSeSgSiSjSsSwS|TATDTGTITOTSTTTZT]T_T"},
  {0,NULL,"`TqTuTyU?U@UCUDULUVUXU\\UaUcUlUnUqUrUtUxVCVHVIVRV\\V^V`VhVlVqVrVyVz"},
  {0,NULL,"V}WCWFWGWHWNWOWTWUWVWXWYW^_D?E?J?K?N?O?Q?b?c?h?q?z?|@?@C@D@E@L@P@"},
  {0,NULL,"Q@U@Z@^@c@e@i@j@m@q@t@|ABAHAMASA]A^AbAcAfAnArA~BABBBDBJBLBOBSBWB["},
  {0,NULL,"B]B`BiBnBrBuBwByB{B|CFCMCPCSCUCYC^CaCiCjCnCoCvCxDGDIDMDVDXD[D]D^D"},
  {0,NULL,"fDgDmDoDsDuDzE?EIEMEREYEaEjEtEyE{E|E~F@FBFHFSFVFXF[F^F_F`FcFgFhFl"},
  {0,NULL,"FqFsFtFvGCGFGgGjGkGnGsGzH?HBHCHFHVHYH[H^HbHpHtHzH}IHIJISITI_IhImI"},
  {0,NULL,"nIqIsItIvIyIzI}J?JDJFJGJIJJJOJQJUJYJZJ[JaJiJpJtJyJ|J}KBKGKHKMKNKV"},
  {0,NULL,"KXK^K_KdKiKmKvKwKyK{LCLELJLKLNLTL[LcLdLeLgLhLiLkLwLzM?MBMIMRMWM^M"},
  {0,NULL,"`MaMfMiMlMrMuNGNLNMNPN_NaNdNeNhNjNpNsNwN~OFOHOMOROUOVOYOZO]OeOhOm"},
  {0,NULL,"OnOrO|PAPEPIPJPLPMPQPSPYPbPgPmPnPoPqPsP}Q?QCQEQGQOQZQaQdQeQmQsQuQ"},
  {0,NULL,"xQ{Q}RHRJRNRYR]R^RaRfRgRhRlRmRyR~SHSJSKSLSTSVS[S]S^ScSnSrSuSySzS~"},
  {0,NULL,"TCTHTLTMTOTRTSTXT]TdTkToTpTxTyT{T|U?UJUKULU[U_U`UdUkUlUqUvUyV@VCV"},
  {0,NULL,"KVQVVV[VaVhViVlVpVvVwVxW@WDWGWHWLWOWQWUWVWWW\\W]_F?G?I?L?M?P?Q?]?`"},
  {0,NULL,"?h?p?s?|?}?~@B@E@J@P@T@W@\\@^@b@f@h@k@l@o@s@{AEAHANAUAVAYA[AaAeAoA"},
  {0,NULL,"rA|B?BCBEBIBMBSBUBZB]B_BdBiBjBlBnBrBwByB|C@CDCICNCQC`CfCkClCmCnCp"},
  {0,NULL,"CvCyDHDIDODUDYDZD]DcDdDfDmDpDqDtD{EDEMEOEREZEaElEqExE{E}F?F@FEFGF"},
  {0,NULL,"QFRFVFXFZF_FbFdFgFiFoFrFsFtFzF}G?GlGsGtGwGxGzG{G|HDHKHRH^HaHcHhHn"},
  {0,NULL,"HsH|H~ICIFIKIRI[IbIeIlIqIrIsItIwIyI{I|JEJIJJJKJLJMJPJRJTJWJ\\J`JiJ"},
  {0,NULL,"nJoJsJxJ~KCKGKOKPKUKXKZKcKgKkKqKsKuKvKwKyK{LELGLKLOLSLXL_L`LhLkLn"},
  {0,NULL,"LsLtLvLxM?MBMJMSMUMWMZM\\M_MaMjMnMsNGNNNPNVNZN[N]NeNhNnNvN{N}OAODO"},
  {0,NULL,"GOHOMOROTOVOZO]ObOfOkOpOuO{O~PCPDPHPJPLPQPSPZPdPhPiPjPmPpPsPyQ@QB"},
  {0,NULL,"QCQJQRQZQ[Q_QhQlQoQuQwQyRCRHRIRLRNRORQRnRoRpRqRrRuRyR}R~S?SDSNSUS"},
  {0,NULL,"VSWSZS[SeSgSiSkSsSxS}TBTETHTJTNTQTUT]TcTdTgTrTsT{T}UAUBUEUJULUOUT"},
  {0,NULL,"UbUfUiUoUpUuUvUyVCVDVGVUVZV`VdVgVnVqVsVvVzV~WAWFWGWIWMWPWSWXWYWZW"},
  {0,NULL,"[W\\W`_D?F?J?K?N?P?R?\\?e?f?u?v?{@@@B@D@F@H@N@R@T@Y@]@c@g@i@j@l@r@y"},
  {0,NULL,"@|ACAKAUAXAYA[A\\A_AfAiAtAxA|BEBFBHBIBNBQBZB\\B^BaBhBlBpBqBsBwBxB{C"},
  {0,NULL,"ACGCJCRCUC`CaCcCfCmCnCqC}DCDFDNDODPDVD[D\\D_DaDeDlDmDrDuDzE@EJEKER"},
  {0,NULL,"E_E`EiEoEuEvEwE}E~FAFGFIFKFMFSFUFbFcFeFfFjFkFrF~GAGBGFGHGeGiGlGuG"},
  {0,NULL,"vG}HAHDHNHPHSHWHZHcHfHoHpHvHwIGIHIMINI_I`IfIgIrIsItIvIyIzI|I~JCJF"},
  {0,NULL,"JJJKJLJOJPJVJWJXJ_JaJlJoJsJuJxJzK@KJKOKRKTKWKYK`KcKgKmKqKuKxL@LAL"},
  {0,NULL,"BLELFLJLQLVLWLbLdLjLkLpLuLyLzL{M?M@MLMMMVM[M\\M]M`McMiMrMwN@NCNGNU"},
  {0,NULL,"NXNYN]N`NfNkNqNuNyN|OFOGOIOKOLOUOWOZO[ObOfOjOrOuOwOyOzO{PBPEPIPQP"},
  {0,NULL,"TPUPVPlPrPsPtPzP|P}QDQKQNQPQRQWQXQ[QiQnQwQ~R?RARFRHRJRORUR\\R]R`Rd"},
  {0,NULL,"ReRfRgRhRyR}SESGSJSLSTSUS[S\\S]S_SmSoSpSySzS~TFTGTKTMTQTRTUTZT\\T]T"},
  {0,NULL,"nToTpTwTzUBUDUEUHULU\\U]U_U`UhUpUsUtUuUxVAVCVMVOVTVbVcVgVjVnVrVtVu"},
  {0,NULL,"V{W@WEWGWIWJWMWQWRWSWUWWW\\W__E?G?H?L?M?O?R?Z?]?f?s?w?|?~@?@B@D@G@"},
  {0,NULL,"P@R@T@W@X@\\@f@h@k@m@p@x@zA?AKASATAZA]A`AbAdAmAtAzA~B@BBBJBKBNBXBY"},
  {0,NULL,"B[B\\BcBlBmBqBsBwBxBzB{C?CHCLCMCTCWCYCZC[C]CqCuC|C}DFDIDJDSDVDXDZD"},
  {0,NULL,"_DdDfDjDkDoDuDwECEHEJETE_E`ElEpExEyE{E}E~FDFGFLFQFRFUFVF`FbFcFdFg"},
  {0,NULL,"FnFrFtFzG?G@GHGbGfGjGlGxG{G~HBHDHLHVHXH_HaHcHiHnHtH|ICIDIFISI[I\\I"},
  {0,NULL,"eInIrItIuIvI{I~JAJBJEJHJIJMJRJSJTJUJVJWJ]JcJlJmJpJtJ}K?KDKHKIKJKK"},
  {0,NULL,"KYK[KhKiKjKlKrKuKxK}LALELFLILJLNLUL]L^LaLfLgLhLoLpLvLzMAMEMLMMMWM"},
  {0,NULL,"XM]M`MbMfMjMmM|N@NINJNUNWN^N`NdNfNlNrNsNzO@OEOGOIOJOOOUOWOZO[OgOn"},
  {0,NULL,"OoOqOvOwO|O~P?PEPJPNPRPUPVP]PgPkPmPpPtP{P}QMQNQOQSQVQWQYQaQbQfQqQ"},
  {0,NULL,"}Q~RDRERPRRRSRTRUR]RaRlRmRsRtRvRxS@SASCSESJSPSQSRSYS\\S]SlSnSrSuSv"},
  {0,NULL,"S{TBTCTJTLTNTQTVTYT\\TeTnTrTsTxT|T}UBUFUHUQURU]UbUdUfUiUjUkUpUzVAV"},
  {0,NULL,"EVMVVVWVeVfVkVmVoVpVsVuVvW?WDWHWKWLWNWRWSWTWYWZW[W`Wb_D?G?I?M?N?P"},
  {0,NULL,"?S?\\?_?g?r?v?}?~@@@A@E@H@M@O@V@X@Z@a@g@h@i@l@u@vA@AEAIALAPASAWA]A"},
  {0,NULL,"bAgAoApAwAyA}A~BBBJBRBSBUBXBZB_BgBhBmBrBsBvByB}C?CCCGCLCTC^CaCdCe"},
  {0,NULL,"CiCoC{C}D@DMDODQDRDSDUD\\D^D_DbDcDnDrDtDxEAEJEQEVEYEbEkEoEuExEzF?F"},
  {0,NULL,"@FAFJFLFNFOF\\F^F_FaFdFfFiFkFvFxF{G@GDGEGaGdGfGgGqGyG~H?HJHOHXHYH]"},
  {0,NULL,"HeHgHuHxHyI?IAIBIQIUIYIZIcIkIsItIuIvIyI{J?JBJIJLJOJRJUJVJWJXJYJZJ"},
  {0,NULL,"\\JeJjJpJrJtJwJ{J}KKKOKPKQKUKXK^KaKdKmKpKwKxKzK{K}L?LBLLLQL\\L]L^La"},
  {0,NULL,"LeLnLpLqLuLxL|MDMIMLMOMVMXM\\M_MgMkMlMpMxN@NFNKNMNWNZN[N]NcNeNrNyO"},
  {0,NULL,"?O@OEOLOOOQOSOVOWO]O^O`OeOmOrOtOyO{P?PCPGPKPMPUPWPYP\\PiPjPoPtPuPz"},
  {0,NULL,"P~QBQCQIQSQTQYQZQ\\Q_QjQuQyR@RBRDRGRJRSRVR\\R]R`RdReRiRjRkRxRzSBSGS"},
  {0,NULL,"JSLSTSXSYS]S_SbSjSmSoSpSwS|T@TATCTETJTOTPTXTbTiTnTsTtT|T~U?UAUCUK"},
  {0,NULL,"UPUWU]UeUfUkUlUmUoUrUwU|V@VMVSVUV`VbVgVlVoVvVzV{V~WCWEWHWIWLWPWSW"},
  {0,NULL,"VWZW[W\\W]W__E?G?J?K?M?N?R?_?d?f?o?r?|?~@?@B@D@H@N@R@S@T@]@d@g@i@l"},
  {0,NULL,"@m@p@xAAABAJANAOAQARAVAaAhAnAuAvA{B?BCBGBMBOBSBWBYB[BeBfBhBjBkBnB"},
  {0,NULL,"pBuB}CHCKCNCOCTC[C]CbCdCkCwC~D@DADKDMDNDPDUDYD]D`DbDgDlDmDqDtDvEE"},
  {0,NULL,"ELESEUEVE`EkEnExEyE{E}E~FAFGFIFKFPFTFUF`FbFcFdFgFkFrFwFyF~GAGHGbG"},
  {0,NULL,"eGiGlGuG}HAHDHLHNHWHZH_HcHfHiHkHnHqIDIFIIILI\\I^IaIeIrItIuIvIzI~J?"},
  {0,NULL,"J@JGJNJOJQJSJTJVJWJXJYJ[J^JhJnJqJvJ~KAKCKHKIKMKNKXK\\KaKhKkKnKrKvK"},
  {0,NULL,"|L@LBLCLGLHLLLPLULXLYL]LiLjLkLrLtLxL|MFMKMOMQMZM[M_MaMcMdMlMoMtN?"},
  {0,NULL,"NHNKNON^N_NaNdNeNmNtNzN}OBOEOHOKOLONOTOYO\\O^OgOiOpOtOvOzPBPCPFPHP"},
  {0,NULL,"LPMPWPXP^P_PjPnPrPsPwPyP~QEQJQLQMQOQ`QaQfQlQmQqQxQ|Q}RCRGRPRQRSRV"},
  {0,NULL,"R[RiRjRkRoRpRqRxRzS?S@SBSMSQSSSWSXSYSbSgSiSjSsSwS|T?TGTHTKTRTTTUT"},
  {0,NULL,"^TiTjTmToTqTvTwT{UDUEUIUNUWUYU_UaUgUhUtUuUvU|U}V?VLVQVUVVVfVgViVl"},
  {0,NULL,"VqVtVwVxWCWFWGWHWJWKWLWTWUWVWWWXWa_F?G?I?L?M?P?Q?]?`?h?p?s?{@A@C@"},
  {0,NULL,"D@F@G@N@Q@U@V@_@`@f@h@k@l@o@s@{AEAHANAUAVAYA[AaAeAoArA|B?BCBEBIBM"},
  {0,NULL,"BOBTBVB`BaBcBnBoBrBuBvBwB{B|C?C@CACBCDC[C_CdCkCmCoCuCwCxDGDJDODVD"},
  {0,NULL,"WDYD\\D^DdDeDlDnDpDuDxEBEHEIESEYEaElEqEvEwEzE|E~FDFHFKFOFWFYF[FaFc"},
  {0,NULL,"FeFhFjFnFqFuF{F|F~GCGcGeGhGnGoG}H@HFHGHMHTHUHWH[H`HjHoHrI?IBIEIGI"},
  {0,NULL,"PIZI]IfIjIqItIuIvIxJ?J@JBJEJHJKJNJQJRJSJTJXJZJ\\J`JiJnJoJsJxJ~KCKE"},
  {0,NULL,"KLKNKVKWK[KaKcKeKkKrKvKwKzK~LCLELJLKLSLWLZL^L_LeLjLqLsLvLzL{MAMIM"},
  {0,NULL,"KMRMVMZM\\M^M`MbMeMpMzNHNINLNMNXN\\N_NbNjNlNvN{N|O@OCOHOMOPOSOUOVOY"},
  {0,NULL,"OZObOdOpOtOvOxOyO{PAPEPHPNPRPYP^PbPhPlPoPpPrPuP}QAQEQHQKQQQ^QgQkQ"},
  {0,NULL,"mQnQpQvQxQzRFRSRTRVRXR]R^R`RdReRsRtRvRxRzR{SCSHSJSRSYS]S`SbScSlSm"},
  {0,NULL,"SoSpSvS{TATFTITKTPTSTTTXTeTkTmTqTuTwTyTzT~UCUIUKURU[UaUcUhUmUqUrU"},
  {0,NULL,"sUzV@VKVLVTVWVXV]VkVmVrVtVwV|V}W?WEWIWJWKWPWTWVWXWZW]W^W`Wb_D?G?H"},
  {0,NULL,"?L?N?O?S?^?c?g?q?t?}?~@@@A@E@L@M@O@W@Y@_@d@e@h@j@m@u@v@}A?AFAOAQA"},
  {0,NULL,"RAUAYA[AkAmAsAvA{A|BEBGBIBQBRBTBUBWBbBfBiBoBpBqBtBzB|CGCLCQCRCUCX"},
  {0,NULL,"C[C^CdCkCqCxDADDDFDGDHDLDTDZD]DaDfDhDiDoDpDqDwEGEIEUEXE_EbEmEtEuE"},
  {0,NULL,"xEzF?F@FBFMFNFQFTFWF\\F_FaFdFfFiFlFuFwFxFzGBGEGaGdGhGiGtH@HAHJHKHO"},
  {0,NULL,"HRHUHZH]HgHuHxH|I@IAICIQIWIYI[IkIpIsItIuIvIxIzI~JBJFJGJKJPJQJSJUJ"},
  {0,NULL,"VJXJZJ]JbJkJoJqJsJvJxKAKEKFKMKPKQKTKaKdKkKoKrKyK|K~L@LALDLILKLOLQ"},
  {0,NULL,"LaLbLdLgLhLlLmLsLtLyMHMMMQMRMUMYM]M^MaMhMjMmM~N?NBNLNUN[N\\NaNcNgN"},
  {0,NULL,"kNrNuNyODOFOIOJOKOMONOPOROXOeOpOsOtOvOwO}O~P@PAPDPLPVPXPbPePgPhPm"},
  {0,NULL,"PvPxPyP|QAQBQDQLQTQXQ\\Q^Q_Q`QyQzQ|R?RBRGRHRPRTRYR]RaRlRmRnRrRuRyS"},
  {0,NULL,"@SBSCSJSKSQSRSXS[S]S^SkSnSrSuSxS}T?TBTDTFTITUTVT\\ThTjTkTuTvTzT}U@"},
  {0,NULL,"UEUFUHUUUYU[UcUgUiUjUnUsUuU{U}VAVKVRVSV`VaVhVnVqVrVxVyV|WAWDWHWIW"},
  {0,NULL,"JWNWRWSWTWUWVW^Wa_F?G?J?K?L?N?Q?[?^?h?t?y?{@A@C@D@F@L@P@Q@S@U@^@a"},
  {0,NULL,"@e@j@l@m@o@sAAACAGALAPATAWAZA`AhAiAqAwAyAzA}B@BKBNBQBVBZBaBdBgBiB"},
  {0,NULL,"jBkBlBtBxByC?CDCICLCTC_CgChCkClC{C|C~DDDKDLDNDQDTDXD[D`DaDgDhDkDr"},
  {0,NULL,"DsDvEDELEQETEXEaEmEsEvEwEzE|E~FBFHFJFPFVFXF[FaFcFeFhFjFlFqFsFtFyG"},
  {0,NULL,"CGDGcGgGjGkGnH?HBHCHFHMHVHYH[H`HbHjHkHlHrIEILIPIVI]I^IjIoIqItIuIv"},
  {0,NULL,"IyI~J?JAJFJLJMJPJQJRJTJUJWJZJ^J_JgJmJrJwJ{K?KDKJKLKOKTKWKZKbKeKkK"},
  {0,NULL,"sKtKuKyK{L?LDLFLGLHLSL]L^L`LaLiLlLoLrLuLwLyMDMEMFMHMYM[MdMfMgMhMi"},
  {0,NULL,"MoMsNBNFNJNONXN]N`NbNkNnNrNvO@OAOEOGOQOROTOXO[O\\O]OaOdOkOlOpOzO|O"},
  {0,NULL,"}P@PFPGPIP\\P]P_PePkPnPqPvPwPzP|QFQIQKQNQQQWQcQjQkQnQpQtQ~R@RFRGRP"},
  {0,NULL,"RTRVRWRZRnRoRpRqRrRuRzR|S@SBSCSFSQSRSXSaSbSfSgSiSkSsSxS}T@TGTHTLT"},
  {0,NULL,"MTNTOTYT^TbThTpTrTtTxT{U?UDUNUPUQUUU`UbUdUeUlUtUvUwU{V?VEVOVRVTVX"},
  {0,NULL,"VhVjVnVpVuVzV{WAWFWGWIWJWKWLWSWWWYWZW\\W__D?G?H?L?N?O?S?^?c?g?q?t?"},
  {0,NULL,"{?|@?@D@F@K@S@U@Z@^@a@c@e@h@j@m@u@v@}A?AFAOAQARAUAYA[AkAmAsAvA{A|"},
  {0,NULL,"BEBGBIBPBXBYB\\B_BcBgBiBoBpBrBsBzB}C@CCCGCNCQCVCXCcCdCeCpCsD?DEDFD"},
  {0,NULL,"GDJDKDPDYD[DeDgDhDjDlDqDuDyEAENEPEZE^EbEmEtEvEwEyE{E~FFFHFJFPFSFX"},
  {0,NULL,"F^F`FcFeFgFjFpFqFsFvFyGDGFGcGkGrGsGuGzHCHIHMHNH\\H^H`HbHfHkHpHrH}I"},
  {0,NULL,"HILIPITI^I_IjImIqIrIsIuIwI{I}JAJDJGJIJLJMJPJRJUJYJZJ]JbJkJoJqJsJv"},
  {0,NULL,"JxKAKIKKKSKUKYK[K]K`KaKoKpKwKxKyK~L?L@LILLLOLQLXL\\L_LfLiLjLlLtLzL"},
  {0,NULL,"{L}MJMNMTMZM]M^MbMcMdMiMqMxNDNENNNSNWNZN^NfNiNlNyN{N}O?ODOJOKOPOQ"},
  {0,NULL,"OROVOWO^O`OcOjOsOtOwPAPBPFPHPIPNPOPZP`PfPlPnPrPvPyP{P}Q@QHQMQPQVQ"},
  {0,NULL,"bQfQgQhQiQoQqQvRARERKRLRMRORXR[R`RdReRiRjRkRwR{R}SISMSNSOSSSUS`Sd"},
  {0,NULL,"SeSjSmSoSpSwS|THTLTMTOTPTQTTT[T_TaTcTpTqTxT{T~U?UBUGUOUVU^U`UaUdU"},
  {0,NULL,"lUmUpUvU~VDVHVNVPVWVcVfVgVjVkVoVpVsVwWCWEWHWLWNWOWPWSWYW[W\\W^WbWe"},
  {0,NULL,"Wf_E?F?H?K?L?O?S?[?b?g?y?z?|?~@@@B@F@L@M@O@Y@`@b@d@e@j@k@m@n@w@z@"},
  {0,NULL,"~AIANAVAXA\\A_AaAdAlApAxB?BCBFBHBMBNBPBXB[B_BcBhBmBsBtBvByB|B}CACB"},
  {0,NULL,"CDCOCPC\\CbCfCgCjCoCrCtC{DFDHDIDKDMDNDODiDkDmDqDrDtDuDyD|EQEWEYE]E"},
  {0,NULL,"bEjEsEuEvExE{E}FBFMFNFTFYFZF\\FbFdFfFgFjFlFwFxF|F}GBGEGaGhGiGmGtH@"},
  {0,NULL,"HAHEHJHKHRHUHZH]HdHqHsHwH{IIINIOIRI`IaIiIlIqIsIuIvIxI}JAJBJCJDJEJ"},
  {0,NULL,"FJHJMJNJQJUJZJcJdJjJnJuJzJ~K@KCKHKJKKKSKUK[K_KbKfKnKqKxKzK{K}LBLD"},
  {0,NULL,"LKLLLSLWLYLZL[LkLmLoLtLuLxLzL~MDMIMPMUMWM[M\\M]MdMlMqMvNANFNMNTNWN"},
  {0,NULL,"ZN`NdNiNlNtNvN|N~OCOLOMOOOSOWOXO]O^O_OhOiOlOuOwOzO{PDPFPJPMPPPYP\\"},
  {0,NULL,"PaPjPkPsPxPyPzP}Q@QHQMQPQSQYQfQgQhQiQoQqQvRARDRJRNRVRWRZR^RfRgRhR"},
  {0,NULL,"oRpRqRzR|R~SFSHSLSTSVSaSbScSfSgSiSsSySzS~T?TDTETFTQTTTVTWTXT`TbTq"},
  {0,NULL,"TvTzU@UAUBUFUKUMUPUXUaUgUjUnUoUpUsUwV@VBVIVOVVVdVeVkVnVoVpVsVtVxW"},
  {0,NULL,"@WFWKWNWOWQWRWTWYWZW]W^WaWbWdWe_D?F?H?L?O?P?R?`?a?f?p?x?}?~@?@C@E"},
  {0,NULL,"@G@R@T@X@\\@^@b@f@h@j@k@r@y@}@~AJALAMAPAWA^AcAkAlAuAwAyA}BABDBLBQB"},
  {0,NULL,"RBTBWB^BeBfBhBjBpBuBwBxB}B~CACCCJCSC_CaCcCgChCtCwC~DEDGDIDMDRDSDT"},
  {0,NULL,"DYD^DfDgDiDjDnDtDyE@ELESEWE^E`EqErExEyE|F?F@FDFGFLFRFUFXFZF_F`FdF"},
  {0,NULL,"hFiFnFrFsF}G?G@GHGbGfGjGwGxG{G|G~HBHLHVHXH_HaHhHsHyH}H~IKIRITIUIb"},
  {0,NULL,"IcIlImIqIrIuIvIwIxI~JAJCJFJHJJJKJLJPJRJSJTJbJdJhJrJwJyJ{J|KBKEKMK"},
  {0,NULL,"QKRKTK\\K`KbKeKmKtK|L@LBLCLELFLGLLLRLVLWL\\LcLeLfLhLiLmLqLxL~MFMKMT"},
  {0,NULL,"MWMXMYMZM^MkMlMqMwNANDNHNONYN\\NaNcNkNmNoNpNqN|O?OKOLONOTOYOZO[O^O"},
  {0,NULL,"aOdOjOlOrP?P@PAPHPJPKPMPPP^P_PfPjPmPnPoPuPxP{Q?QFQLQTQUQ\\Q]Q`QcQd"},
  {0,NULL,"QrQsQtQ|RBRMRVRXRZR[R^R`RdReRfRgRhRwRzR{R|SHSMSOSSS`SbScSfSmSoSpS"},
  {0,NULL,"ySzS~TBTDTJTNTOTQTRTWT^TaTmToTrTsT}U?U@UBUIUMUNU^U_UbUfUiUlUnUpV?"},
  {0,NULL,"VBVLVNVSV]V_VaVhVmVqVrVvVyV{W@WEWIWJWMWNWOWRWSWWWYW^W`WdWe_D?F?H?"},
  {0,NULL,"L?O?P?R?`?a?f?p?x?{@@@B@D@F@J@N@Q@V@[@]@_@f@h@j@k@r@y@}@~AJALAMAP"},
  {0,NULL,"AWA^AcAkAlAuAwAyA}BABDBLBNBPBYB[B\\B_BfBjBkBmBnBuBzB}B~CECICJCRC^C"},
  {0,NULL,"`CaChCiCvCzD@DADIDJDKDLDTDUDWD`DjDkDnDpDqDsDwD}EMEUEVE[E`EqErEuEv"},
  {0,NULL,"EwE}E~FEFIFKFOFWF[F]FbFcFeFfFjFoFuF{F~GAGCGGGeGnGpGqGvGyG}HFHHHPH"},
  {0,NULL,"QHSHWH[HeHjHoHvI@IEIGIMIWI]IfIgIpIrIsItIvIzI{I}JBJDJEJHJIJJJKJOJR"},
  {0,NULL,"JXJZJbJdJhJrJwJyJ{J|KBKHKIKJKSKUKYK^KdKgKmKtKvK|K}LCLGLHLILLLMLRL"},
  {0,NULL,"VL`LbLfLoLqLrLsLtLwMBMCMOMQMWMYM_MbMdMeMhMmMyN?NKNPNQNZN^N`NdNfNi"},
  {0,NULL,"NoNqNuNxOAOHOJONOOOTOYO\\O^OaOeOfOmOrOxO}P@PCPFPJPNPSPWPXP[PhPkPqP"},
  {0,NULL,"uPwPyP{QNQOQPQSQVQWQYQaQbQiQ}Q~RARDRERGRHRIRQRYR\\R_RbRcRnRrRuRyS?"},
  {0,NULL,"SBSDSGSKSWSXSZS[S^S_ShSkSqStSxS}T@TATITLTSTTTVTdTfTiTjTqTtTuTxTyU"},
  {0,NULL,"CUFUJUSUWUYUaUcUdUeUjUqUrUyU|U}VFVOVPVcVdViVkVoVpVsVzV}WAWBWHWOWP"},
  {0,NULL,"WQWRWSWTW\\W]W^WeWh_D?F?J?K?N?P?R?\\?e?f?u?v?}?~@?@C@E@I@O@V@X@[@\\@"},
  {0,NULL,"a@g@i@j@l@r@y@|ACAKAUAXAYA[A\\A_AfAiAtAxA|BEBFBHBIBWBYB[B]B`BeBkBl"},
  {0,NULL,"BmBnBqBsBzB{B~CACBCDCRCVCXC`CcChCrCuC|D?DHDPDQDXDZD\\D]DaDbDcDdDhD"},
  {0,NULL,"mDoDvD}EHENETE]E`EiEoExEyE|F?F@FCFJFLFOFRF\\F]F_F`FdFhFiFmF{G?G@GD"},
  {0,NULL,"GEGGGaGfGoGrGwG|G~HGHIHJHTHXH\\H]HhHlHuHyH~IAIKIUIVIYIbIcIoIqIrIuI"},
  {0,NULL,"vI}J?J@JAJCJDJHJLJNJOJRJXJYJZJ_JaJlJoJsJuJxJzK@KGKHKIKMKVK\\K]K`Kg"},
  {0,NULL,"KoKtKuKvKxK}LALHLILJLRLSLWLZLbLgLkLlLnLvLyL|MAMEMNMPMUMVMaMcMfMgM"},
  {0,NULL,"jMoMyNINJNSNTN^NaNdNhNjNmNoNuNvN|OCOGOHOIOJOOOUOWO\\OaOcOfOjOsOyO|"},
  {0,NULL,"O~PBPDPGPLPRP]P`PaPgPiPpPsPvP|P~Q?QEQJQLQMQ`QdQfQlQmQqQsQxQ|RCRLR"},
  {0,NULL,"RRTRWRXRZR_RbRcRnRrRuR{R|SASCSFSNSPSRS`SaSeSfShSkSqStSxS}T?T@TCTE"},
  {0,NULL,"THTITPTYT_T`TeTtTuTvT{T|T~UAUQURUVUXUcUeUgUkUmUoUvUzVEVHVIVZV[V_V"},
  {0,NULL,"aViVlVsVwVxV|V~WAWBWJWKWLWOWPWQWWW\\W]W^W_WaWcWg_E?F?I?K?M?P?S?d?e"},
  {0,NULL,"?g?o?u?{@?@A@C@E@H@M@O@Z@[@\\@a@g@i@k@l@n@w@{ADAFAMATAZA^A`AcAeAjA"},
  {0,NULL,"sAzB@BABDBKBLBOBPBTBaBbBcBiBoBpBsBtBzB|B}CECICJCOCPCYCZC]CfCgCpCq"},
  {0,NULL,"CsDADQDRDTDVDYD[D]D^D`DaDcDeDfDgD{D|EPEUEZE_EbEiEnEwEyEzE|F@FAFJF"},
  {0,NULL,"NFRF\\F]F^F_F`FaFeFhFkFvFxG?GDGEGGGdGfGgGqGrGyG~H?HIHOHXHYH\\HeHgHl"},
  {0,NULL,"HmHzH~IJIKIVIXIbIdIhIoIrIsItIuI{I|J@JBJCJDJEJHJMJNJOJVJWJXJ`JfJkJ"},
  {0,NULL,"mJyJ|K?KBKDKEKFKNKSKWK[KbKhKiKlKqKxKyK~L@LDLILKLLLMLVLYL[L`LeLhLi"},
  {0,NULL,"LnLrLyL{L}MJMMMQMYMZM`MaMgMiMkMnMvN?NENNNUNXN\\N_NgNiNlNqNtNxN~OAO"},
  {0,NULL,"JOKOMOPOROWOXO^OgOlOnOqOuP@PEPGPHPIPKPLPOPVPXPZPiPlPmPnPoPwP|QAQG"},
  {0,NULL,"QQQUQVQ]Q^QbQeQkQpQrQzQ{RERHRORPRQRUR[RfRgRhRoRpRqRyR}S?S@SESMSQS"},
  {0,NULL,"SSUSWS[S\\SgSiSsSySzS~T@TCTDTETNTPTST[T\\TcTjTrTtTyT|T~U@UAUGUHUOUY"},
  {0,NULL,"UbUeUkUmUnUoUqU}U~VAVDVQVTV]V^VlVmVpVtV{V|V}W@WFWKWMWPWQWRWTWXWZW"},
  {0,NULL,"[W]W_W`WgWhWiWk_E?G?J?K?M?N?R?_?d?f?o?r?{?}@@@A@C@I@M@V@X@Z@[@\\@g"},
  {0,NULL,"@i@l@m@p@xAAABAJANAOAQARAVAaAhAnAuAvA{B?BCBGBMBNBQBVB\\B^BdBfBjBmB"},
  {0,NULL,"uBwBxBzB}C@CHCMCNCQCWC[C\\CbCjCtCvCzDEDGDLDNDRDWD\\D]D^DaDbDiDlDpDs"},
  {0,NULL,"DzECEMEWE[E^E`EkEnEuEwEzE|F?FCFLFNFOFRF]F^FaFeFfFhFiFmFvFxF{G?G@G"},
  {0,NULL,"GGaGoGqGrGwGyG|HGHIHJHTH\\H]HeHhHmHxHzI?IBIJIQIXIZIdIhIkIqIrIsIvIy"},
  {0,NULL,"I|I}JAJCJEJIJLJMJNJUJVJWJYJ[J^JhJnJqJvJ~KAKCKJKLKRKTKYKZK_KfKjKnK"},
  {0,NULL,"rK|K}LCLELFLGLILLLNLOLULXL_LeLjLmLsLwLyL|L~MBMCMTMVM[M^MaMeMhMkMr"},
  {0,NULL,"M|NANDNPNQNYN`NbNfNkNnNsNzN{N}ODOJONOOOTOYOZO[O^O_OhOiOoOvOxOyOzO"},
  {0,NULL,"}PAPKPLPPPSP[PfPhPoPqPrPxP|P~QDQFQKQPQRQXQ[QcQiQnQtQwR?RARFRIRKRM"},
  {0,NULL,"RNRYR^RaRlRmRsRtRvRwR~SDSHSISKSOSVSZS^ScSdSlSnSrSuSvS{T@TBTCTETFT"},
  {0,NULL,"MTPTWTaTdTfTpTtTzT|T}T~UAUJUMUSU^U`UeUiUkUmUoUsUyVBVFVNVRVXVYV\\Vj"},
  {0,NULL,"VkVnVuV{V|V~W?WDWGWKWLWNWQWUWYWZW[W\\WfWgWkWl_D?E?I?M?O?P?Q?Z?a?h?"},
  {0,NULL,"w?x?}@@@A@B@F@G@Q@U@[@]@_@`@f@h@i@k@q@tA@ADAGAOAQARAXA\\A_AgAjAqAv"},
  {0,NULL,"AxA{BFBGBHBRBSBXBZB]BdBgBiBkBtBuBxByB{CHCKCOCSCUCVCXCYCcCjCsC|C~D"},
  {0,NULL,"BDFDNDODRDTDWDZD_DaDeDiDkDpDtD{E?ELEPETE\\EaEpErEuEvEzE}F?FDFHFIFW"},
  {0,NULL,"FYF[F]FaFbFfFiFjFnFqFuF|GAGCGGGcGeGhGoGpG}H@HGHHHMHQHTHUHWH`HmHvH"},
  {0,NULL,"{I@IMIOIWIXIdIgIiIpIqIrItIuIwI{J?J@JDJGJHJIJJJOJRJSJTJYJeJfJgJqJu"},
  {0,NULL,"JvJzK@KAKGKKKOKQKXKZK]K_K`KiKoKyK{L?LCLDLFLHLJLPLULYLcLdLmLoLpLsL"},
  {0,NULL,"xLyL{L}MEMFMGMYM[M\\M]MeMjMkMnMuNENJNONRNWN]NcNeNhNnNpNtNzOBOFOQOR"},
  {0,NULL,"OUOXOYO[O\\O]OcOhOjOnOsOwOxOzO{O~P@PKPOP]P_PcPhPjPkPlPtPxP|Q@QBQIQ"},
  {0,NULL,"JQRQ[Q_QhQjQlQoQwQyR@RCRMRPRRRURZR[RaRfRgRhRlRmRwR|S@SASESMSOSPSQ"},
  {0,NULL,"SSS\\SfSnSrSuSySzS~TATETITMTSTTTUTYT[T^TlTpTqTuTyUAUCUEUGUNUQUZU`U"},
  {0,NULL,"aUcUoUqUrUuU~V?VEVJVSVYVbVeVgVkVrVvVxVzV~W@WDWHWLWMWOWPWVWWWXW[W]"},
  {0,NULL,"WbWgWhWjWo_F?G?J?K?L?N?Q?[?^?h?t?y?|?}?~@B@E@K@M@W@Y@_@`@b@e@j@l@"},
  {0,NULL,"m@o@sAAACAGALAPATAWAZA`AhAiAqAwAyAzA}B@BKBOBSBYB]B`BeBgBkBoBtBuBv"},
  {0,NULL,"BxB{C?C@CECICJCWC_CeClCmCsCzDBDCDFDLDMDPDRDSDXD_DbDgDiDjDoDrDzEBE"},
  {0,NULL,"KEPE[E\\EaEmEsExE{E}F?F@FFFMFNFQFWFYFZF_FbFdFgFiFpFuFxFzF|F}GBGdGm"},
  {0,NULL,"GpGtGxG{HEHHHKHOHQHRHaHdHgHsHwHxH|ICINIQIRI[I`IkIlIqIrIsItIzI|I}J"},
  {0,NULL,"@JDJEJGJKJMJNJPJQJXJZJ^J_JgJmJrJwJ{K?KDKGKIKNKVKXK\\KcKeKjKpKsKzK~"},
  {0,NULL,"L?LCLDLFLHLJLMLVL^L_L`LfLgLiLmLpLuL|L}M@MCMGMXM]McMfMhMkMlMrMzNCN"},
  {0,NULL,"ENQNRN^N_NeNhNjNmNqNxN{O@OAOPOQOSOUOXOYO[O\\O`ObOdOkOoOwO|O}P?PBPK"},
  {0,NULL,"PMPOPTP[PcPgPnPtPxPzP{P~Q?QCQGQJQOQZQaQdQeQlQsQuQ{Q}RCRIRKRMRORUR"},
  {0,NULL,"\\R`RdReRsRtRvRwR}SDSESGSISOSUSZS\\S_SdSlSmSoSpSvS{T?TATCTDTFTRTVTZ"},
  {0,NULL,"T[TfTlToTvTzT|U@UCUFUGUSUZU\\U_UgUjUkUnUrUsUxU~VFVJVUVZV_VfViVlVmV"},
  {0,NULL,"oVwVxVyW?WEWGWJWKWPWQWTWUWXW\\W^WcWdWkWp_E?F?H?K?L?O?S?[?b?g?y?z?{"},
  {0,NULL,"@?@A@C@E@K@P@Q@S@Z@a@c@e@j@k@m@n@w@z@~AIANAVAXA\\A_AaAdAlApAxB?BCB"},
  {0,NULL,"FBHBMBRBTBUB^BbBeBfBgBhBmBqBrBvByCBCECHCKCOCZC\\C`CfCmCyC}D@DBDGDH"},
  {0,NULL,"DKDSDWDXD\\DbDdDhDiDnDsDuDwEFEJEOEVE\\EbEjEsEwEyEzE|F@FFFJFPFSFVF[F"},
  {0,NULL,"^F_F`FaFeFhFpFtFvFyGCGDGFGcGgGrGsGuGzH?HIHMHNHYH\\H^H`HfHjHlHtHzIE"},
  {0,NULL,"IJISIVI]IhInIoIrIsItIuIwIzI{I~JDJFJGJJJMJOJPJQJTJWJcJdJjJnJuJzJ~K"},
  {0,NULL,"@KCKEKFKPKQKRK\\KcKfKgKlKqKwKzK{K|K}L?LALBLMLPLULYLZLlLmLqLvLwLzL|"},
  {0,NULL,"MGMLMOMSMUMVMXM^MdMeMfMmM}N@NKNRNVNYN[N\\NcNgNmNtNxNzOBOCOIOLONOOO"},
  {0,NULL,"QOSOVO]O_ObOfOqOuOxOyO|P?PAPDPFPUPWPcPdPpPqPuPvPxP}P~QAQBQDQLQUQX"},
  {0,NULL,"Q]Q^Q_Q`QrQyQzQ|R?RIRQRRRSRUR\\R_RbRcRsRtRvRxS?SASDSESGSPSWSYSZS\\S"},
  {0,NULL,"_ShSlSqStSvS{TBTHTITKTLTMTOTgTiTlTnTpTuTwTxT{T}U?UTUWUZU]U`UcUdUh"},
  {0,NULL,"UiUlUvU|VGVJVMV\\V]V^V_VhVjVqVrVwVyV~W?WBWGWHWMWOWRWSWTWWWXWYWdWfW"},
  {0,NULL,"mWo_D?E?J?K?N?O?Q?b?c?h?q?z?}@@@A@B@F@K@O@W@_@`@b@d@e@i@j@m@q@t@|"},
  {0,NULL,"ABAHAMASA]A^AbAcAfAnArA~BABBBDBJBLBVBZB\\B^BaBdBjBlBnBoBrBvBwB|B~C"},
  {0,NULL,"CCFCKCSCVCYCZC]CiCpCuCwCyDHDJDLDMDUD[D\\DcDlDnDoDqDrDsDvD~EHEOESEZ"},
  {0,NULL,"EaEjEtEuEvEzE}F?FFFQFTFWFYFZF\\FaFbFfFiFjFpFuFwFzF|F}GEGdGhGmGpGxG"},
  {0,NULL,"{H@HEHHHOHQHUHaHdHgHqHuH{I@IAIIIOIWIYIaIiIpIqIrItIuI|I~J@JAJCJDJF"},
  {0,NULL,"JGJHJMJPJSJUJVJ[JaJiJpJtJyJ|J}KBKLKOKRKWKYKZK]K^KhKiKlKuKvKwKzK~L"},
  {0,NULL,"ELGLKLPLRLTL\\LcLgLjLnLqLtLuLwMAMJMKMSMUMVM_MbMhMiMlMoM{NHNINNNVNX"},
  {0,NULL,"NYN]NbNfNnNoNpNwO?OBOGOHOMOPOSOTOVOZOcOgOmOnOqOyO}PCPDPIPMPNPRPZP"},
  {0,NULL,"^PdPgPiPqPrPuPyPzQFQIQNQQQRQWQ[QcQjQkQpQtQwQ~R@RLRQRRRSRXR[R_RbRc"},
  {0,NULL,"RiRjRkRxR{S?SASMSNSPSSSWSYS`SeShSjSqStSwS|T?T@TDTFTGTJTVTcTeTgTmT"},
  {0,NULL,"sTtTvTzU@UDUFUIUOURUTUeUfUgUjUnUsUtUzVDVGVLVYV\\VbVcVjVnVoVuVyV{V}"},
  {0,NULL,"WBWCWJWKWLWMWNWQWRWUWWW[W_WaWdWfWl_D?G?I?M?N?P?S?\\?_?g?r?v?{?|@?@"},
  {0,NULL,"D@F@I@S@T@Y@]@c@d@g@h@i@l@u@vA@AEAIALAPASAWA]AbAgAoApAwAyA}A~BBBJ"},
  {0,NULL,"BPBTBVB`BbBcBfBhBmBqBtBvByB|B~CCCLCQCSCWCXC^CeClCrCtCyDBDIDNDQDUD"},
  {0,NULL,"VDWDXD^D_D`DdDkDmDsD{EGEOEWE\\E]EbEkEoEvEwEyE{E~FCFGFIFMFPFSFTF`Fc"},
  {0,NULL,"FeFgFjFmFrFwFyGAGBGFGbGkGmGuGvHCHEHLHNHPHSH_HbHdHfHkHnHpHvIFIHILI"},
  {0,NULL,"MI^I_IeIgIqIrIsIuIwIxI|J@JCJGJKJLJNJPJSJVJXJYJ\\JeJjJpJrJtJwJ{J}KE"},
  {0,NULL,"KFKLKSKVK[KdKjKoKpKsKzK{K|K}LALBLDLKLOLRL\\LaLcLeLkLoLpLrLvLwL~MGM"},
  {0,NULL,"PMSMWM[M_M`MeMfMgMnM~NANRNTNVN\\NbNgNiNjNlNoNpNrO?ODOIOLOMONOOOSOX"},
  {0,NULL,"O]O`OeOkOoOsOxOzO|PCPEPGPJPPPaPcPdPkPoPpPqPsPtPwQGQHQQQUQVQ]QbQeQ"},
  {0,NULL,"gQkQpQrQvQ{RERIRLRMRNRRRZRaRlRmRnRrRuRwR|R~SASDSNSOSPSVSZSeSfSkSn"},
  {0,NULL,"SrSuSxS}TGTKTNTRTSTUTVTWT`TgTlToTrTwTyUDUEUFUMUTUXUZU_UbUhUjUqUtU"},
  {0,NULL,"uVBVGVIVJVPVWVXV[VhViVmVtVuV|V}WAWDWIWJWMWNWPWUWVWXW[W^W`WcWhWjWl"},
  {0,NULL,"Wr_D?E?I?M?O?P?Q?Z?a?h?w?x?|@?@C@D@E@J@P@R@W@X@^@b@f@h@i@k@q@tA@A"},
  {0,NULL,"DAGAOAQARAXA\\A_AgAjAqAvAxA{BFBGBHBOBPBVB`BaBbBgBjBkBlBoBtBvBxCFCG"},
  {0,NULL,"CKCRCUCVC\\CbCiCjCzC{DCDDDKDPDQDSDWDYDZD`DbDdDeDhDjDtDxD~EKEQEXE[E"},
  {0,NULL,"aEpErEyE{E|E~F@FEFLFQFUFVFXFZF_F`FcFgFhFoFsFtFzF}G@GHGjGlGsGtGwGz"},
  {0,NULL,"G|HBHDHKHRHVH^HcHhHiHtHyH}IDISITIUI\\IcImInIqIsItIvIxIyI|JBJCJEJFJ"},
  {0,NULL,"HJIJJJKJSJUJVJeJfJgJqJuJvJzK@KAKFKLKNKSKVKWK]K^K_KfKnKuKzK~L?LDLF"},
  {0,NULL,"LGLHLPLQLTLbLdLfLlLrLvLxL{L|M@MCMDMHMXMZMcMdMeMgMjMpM{NBNCNFNQNXN"},
  {0,NULL,"_NbNgNiNjNuNwNyOBOFOGOPOQOSOTOXO[O\\O_OcOhOiOmOxO~P?PBPFPGPHPTP[P\\"},
  {0,NULL,"PePjPlPpPvPwP{P~QAQEQGQHQKQ^QeQgQmQnQvQxQzQ{RFRGRJRKRWRYR\\R_RbRcR"},
  {0,NULL,"iRjRkSBSFSGSISKSLSTSXS^S_SaSdShSjSqStSwS|T?TBTJTKTNTPTQTZTbTfThTr"},
  {0,NULL,"TsTvTwT}T~UBUPUSUUU\\UbUfUgUhUiUmUpUwUxU{VFVPVQV[V^VjVmVqVsVtV|V}W"},
  {0,NULL,"BWCWIWMWNWQWRWUWVWZW[W]WeWhWiWmWqWr_E?F?I?K?M?P?S?d?e?g?o?u?|?~@@"},
  {0,NULL,"@B@F@I@N@R@S@Y@c@d@g@i@k@l@n@w@{ADAFAMATAZA^A`AcAeAjAsAzB@BABDBKB"},
  {0,NULL,"LBRBUBXB]B_BdBfBgBiBoBpBqBrBzCBCECFCMCPCZC\\C_CgChCxD?DDDEDJDLDPDR"},
  {0,NULL,"DUDVDZD_D`DcDjDlDoDpDxEFEIENEXE^EbEiEnEuEvExE{E}FCFKFMFPFSFTFUFbF"},
  {0,NULL,"dFfFgFjFmFwFyF~GBGFGHGbGiGkGmGvHAHCHEHLHPHSHZH_HbHdHiHoHqHwIDIGII"},
  {0,NULL,"INI\\I`IaIfIqIsIuIvIwIxIyJ?JCJFJJJLJNJOJQJTJWJYJ`JfJkJmJyJ|K?KBKDK"},
  {0,NULL,"GKKKPKQKUKZKbKeKfKlKtKwKyK|K~L?L@LALILMLNLTLZL[LfLgLjLnLpLrLsMHMN"},
  {0,NULL,"MRMTM_M`MbMcMhMjMkMpM}NBNDNLNSNWNZN[NcNhNnNsNwNxN~OCOIOJOKONOPOQO"},
  {0,NULL,"ROVO_OaOdOlOqO}O~PBPCPEPKPNP`PbPePfPgPhPiPrPtPwP{Q@QCQIQSQTQYQZQ\\"},
  {0,NULL,"QhQjQoQuR@RBRDRKRTRWRXRYR^R_RbRcRsRtRvR{SCSFSHSISKSRS^S`SaScSdShS"},
  {0,NULL,"lSqStSvS{TATGTJTKTLTRTUT_TaThTkToTsTwTxUCUDUEUUUVU[U^U_UdUfUhUrUt"},
  {0,NULL,"UuU{VHVKVNVYVZVdVeVgViVuVvVyVzV~W?WBWGWIWMWOWVWWWXWYWZW]WcWgWiWlW"},
  {0,NULL,"qWs_D?F?G?L?N?P?U?W?Y?k?l?m@I@J@L@M@N@P@U@X@[@b@c@d@e@f@g@o@r@v@z"},
  {0,NULL,"ABADAMARATA\\AaAbAdAjAnAvB@BCBDBFBJBOBXB[B^BbBdBiBjBmBnBqBtB~CBCIC"},
  {0,NULL,"LCNCUCWCXC`CgCiCkCnCrCsCtCvCwCxCzC{C}D?DDDMDRDSDeDlDuE@EAEBEJEPES"},
  {0,NULL,"EdEfEgFBFCFEFHFKFLFNFSFTFVFZF]FlFmFoFqFtFwFxF}F~G@GFGGGIGJGLGQGRG"},
  {0,NULL,"SGVGWGXHiHwHzH{H}I?IBIDIJINIOITIZI\\I`IhIiImIrItIuIwIzI{I|I~J?J@JA"},
  {0,NULL,"JBJDJPJRJSJWJXJ[JcJfJmJpJqJyJzJ~KFKHKKKNKRKZK^KbKgKjKkKoKvKyK}LAL"},
  {0,NULL,"DLGLRLXLZL`LaLdLjLzL{L}L~M?MBMCMDMHMKMLMNMPMRMXMkMlMwMxMzN@NENHNW"},
  {0,NULL,"NYN_NdNgNnNoNrN}OAOCOFOHOIOOOROTOXOfOlOmOoOpOsP?PKPMPOPPPQPSPUP[P"},
  {0,NULL,"\\P^P`PaPbPePlPrP}Q?QCQHQKQPQTQZQ\\QdQgQiQnQsQuQvRARBRFRSRUR[RfRgRh"},
  {0,NULL,"RiRjRkRnRrRsRtRuRvRxSESMSSSYS\\SkSxS}TCTDTJTKTMTTTXTZT[TaTmTnTpTqT"},
  {0,NULL,"sTwT|U@UGUIUKU\\U]U^U`UaUfUhUkUnUxU~V@VLVMVNVRV[VdVhViVnVsVzV|WAWB"},
  {0,NULL,"WDWFWHWIWJWKWPWRWSWWWXW[W\\W^W_W`WjWoWuWv_E?F?G?K?L?M?T?X?Y?i?l?n@"},
  {0,NULL,"G@I@K@T@U@X@[@_@a@b@c@d@e@f@g@n@s@x@|@}A@APAQASAUAXAcAfAgAkAyA{A|"},
  {0,NULL,"A~BHBLBPBRBWBZB\\B`BfBgBvBwBzB{C?CACECKCMCQCYC[C\\CeChCmCnCsCtCuCwC"},
  {0,NULL,"yC{C|D?DADBDEDQDTD[DmDqDtD|EDEEEQEREUEeEfEhFCFDFFFGFHFJFLFSFTFWFZ"},
  {0,NULL,"F]FmFnFpFqFrFuFwF}G@GDGFGGGIGJGKGMGPGRGVGWGXHkHuHvH{H}H~IAIKILIMI"},
  {0,NULL,"OITIYI^IbIgIiImIsItIvIxIyIzI{I|I}I~J?JBJEJJJQJUJWJXJaJbJeJsJtJwK@"},
  {0,NULL,"KAKBKMKOKQKSKVKYKcKfKiKpKrKtKzK|L?LELILJLMLNLOLPLWL^LkLtLxL}L~M?M"},
  {0,NULL,"AMDMEMGMKMNMQMSMTMYMgMiMsMtMvN?NFNGN]NaNcNfNiNjNsNxN|O@OBODOJONOQ"},
  {0,NULL,"OSOUOZO_O`OaObOnOvP@PGPIPOPPPQPRPXP\\P]P^P`PcPdPfPjPsPyQ@QFQJQMQQQ"},
  {0,NULL,"UQ]QcQfQhQkQlQoQpQqQrQtRCRGRHRJRfRgRhRiRjRkRnRrRsRtRuRvRySBSLSTSX"},
  {0,NULL,"S[SlSvS{T?T@TOTQTSTUT]T^T`TbTcTjTtTvTyU?UBUEULUNUOUPUXUYUeUgUlUpU"},
  {0,NULL,"qUuUwU}V?VCVDVIVWVYV_VkVmVuVwVyV~W?WBWDWEWGWHWIWKWRWTWUWXWYWZW\\W]"},
  {0,NULL,"WiWkWmWpWsWt_D?E?G?M?N?O?V?W?X?j?m?n@H@J@K@M@N@P@T@[@_@a@b@c@e@f@"},
  {0,NULL,"g@p@q@u@{@~ACALAVAYAZA^A_AeAiAlAxA}B?BABIBKBNBTB]B_BaBeBhBkBlBoBr"},
  {0,NULL,"B}C@CCCFCOCRCTCVCZCaCbCdClCnCpCsCtCxCyCzC|C}D@DADCDIDVDXDaDiDpE?E"},
  {0,NULL,"CEGEIETEWEcEgEhFAFEFFFGFJFKFNFSFVFWFZF]FkFoFpFrFtFuFxF}F~GDGFGGGK"},
  {0,NULL,"GLGMGPGQGSGVGWGXHjHvHwHzH|H~ICIEIJIKIMINI[I]I`IbIgIhIqIuIvIwIxIyI"},
  {0,NULL,"}I~J?J@JAJBJCJQJRJSJUJYJ_J`JdJnJoJrJuJ|KDKEKGKJKUKWK\\K]KaKlKmKnKs"},
  {0,NULL,"KuKwK~LBLHLLLTLYL\\L]L_LbLmLsLyL}L~M?M@MCMEMJMLMOMQMRMSMWM`MfMuM|M"},
  {0,NULL,"~NANJNLNXNZN\\N`NhNmNtNuNwN{O?OEOGOLOPOVO\\O^OcOiOkOqOrOtO|PEPJPOPP"},
  {0,NULL,"PQPTPUPWPXPZP[P]PbPdPhPxP|QBQDQGQOQRQVQXQ[Q_QaQbQeQwQyQ{Q}R?RERTR"},
  {0,NULL,"ZR^RfRgRhRiRjRkRnRrRsRtRuRvR|SCSHSRScSfSjSwS|TETFTITLTNTRTWTYT\\Td"},
  {0,NULL,"TkTlToTrTuTxTzUAUHUJUMUQUZU[U_UbUcUdUoUsUyVAVBVEVJVKVUV^VcVgVjVlV"},
  {0,NULL,"oVqV}WBWCWEWFWHWIWKWLWNWUWVWWWYW[W]W^WaWbWlWnWqWr_E?F?G?K?L?M?T?X"},
  {0,NULL,"?Y?i?l?n@H@J@L@O@Q@R@V@W@Y@Z@]@^@e@f@g@n@s@x@|@}A@APAQASAUAXAcAfA"},
  {0,NULL,"gAkAyA{A|A~BHBLBPBRBWBZB\\B`BlBnBpBtByB}CDCFCJCLCNCOC]C`CdCgCjClCn"},
  {0,NULL,"CoCqCuCvC{D@DADBDCDDDEDGDWD\\D_DjDoEBECEFEHE\\E^EeEfEhFAFBFEFIFMFOF"},
  {0,NULL,"QFUFXF[F\\F^FkFlFoFsFvFzF{GAGBGCGEGHGNGOGTGUGYGZG[G\\G]HoHpHtHxHyI@"},
  {0,NULL,"IGIHIQISIUIWI_IcIfIkInIpIqIrIuIwIxI{I|I}I~J?J@JAJGJHJLJMJNJTJaJbJ"},
  {0,NULL,"eJsJtJwK@KAKBKMKOKQKSKVKYK_KaKbKgKhKsKuKvK{L@LDLLLSLTLVLXLYLaLfLg"},
  {0,NULL,"LpM?M@MAMBMDMGMHMIMMMOMQMTMVM^MeMzM|M}NDNINRN]NaNcNfNiNjNqNrNtNvN"},
  {0,NULL,"wN}OGOHOKOXO]O^OfOgOhOkOlOtOxOyPAPQPRPSPTPVPWPXPYP\\PcPePfPgPtP{QA"},
  {0,NULL,"QCQDQKQOQSQXQYQZQ^QaQnQuQzQ}R?RDRFRMRRRXR_R`RaRbRcRdReRlRmRoRpRqR"},
  {0,NULL,"wR{SASOSPS`SgSiSsTITJTMTPTRTVTaTeTfTkTlTnToTpTsTuT~UFURUSUZU[U]U^"},
  {0,NULL,"U_U`UcUfUjUmUzVFVJVKVMVNVOVQV`VlVnVpVqVtVzW@WAWCWFWGWJWKWLWMWNWOW"},
  {0,NULL,"PWTWXWYWZW`WbWdWgWlWu_D?E?F?K?O?P?T?U?V?i?j?k@I@J@K@S@V@W@Y@Z@\\@]"},
  {0,NULL,"@^@`@e@f@g@t@w@yA?AAAEANAOAWA[A]A`AhAmAoAwAzBBBEBGBMBQBSBUBVBYBcB"},
  {0,NULL,"jBkBqBrBvBzCBCCCICKCMCRCXCZCbChCiCmCoCpCqCrCvCyCzC~D?DBDCDEDFDNDO"},
  {0,NULL,"D^DfDgD|E?E@ELEYE_EcEdEeFCFEFFFIFMFOFPFQFRFXFYF^FmFoFpFsFvFyFzF{F"},
  {0,NULL,"|G?GAGBGNGOGUGYGZG]G^G_G`HmHnHpHrHsHxIFIHIPIQIRIXI_IdIeIjIkIlItIu"},
  {0,NULL,"IvIxIyIzI{I~J?J@JAJBJFJHJOJTJVJZJ\\J]J^JvJxJ{J}K?KCKIKLKPKTKXK[K^K"},
  {0,NULL,"cKlKnKoKtKwKzLALGLHLILNLPLZL\\L`LbLeLhLiM@MBMCMFMGMIMJMMMNMPMSMTM["},
  {0,NULL,"M\\M]MuMvMwNMNONUN[N^NbNeNkNlNsNuO?OAOBOCOIOJOSOTOVO\\OaObOiOmOqOsO"},
  {0,NULL,"wOzO{PSPTPVPYPZP[P_P`PaPcPdPfPmPnPoQ?Q@QGQPQRQUQ[Q]QdQeQhQiQoQrQs"},
  {0,NULL,"QwQ{RARPRVR]R_R`RaRbRcRdReRlRmRoRpRqRzS@SJSQS]SbShSqStTCTFTNTOTTT"},
  {0,NULL,"UTWTXT[T\\T]T^TqTrTzT|U?UEUGUHUKULUMUNUaUbUkUlUsUuU~V?V@VAVBVCVPVZ"},
  {0,NULL,"V\\ViVjVsVyV}V~W?WAWBWCWJWLWMWOWQWRWSWTWVWWWZW]W_WaWiWoWqWt_D?E?G?"},
  {0,NULL,"M?N?O?V?W?X?j?m?n@G@I@L@O@Q@R@S@V@Y@\\@^@`@e@f@g@p@q@u@{@~ACALAVAY"},
  {0,NULL,"AZA^A_AeAiAlAxA}B?BABIBKBNBTB]B_BaBeBfBiBmBxB{B|B~C?CHCPCQCUCWCYC"},
  {0,NULL,"\\C^CcCkCoCpCrCtCuCxC|C~D@DCDDDEDKDPDYDcDnDrD~EAEEEKEVEZEcEgEhFBFC"},
  {0,NULL,"FDFMFOFPFRFUFXFYF[F\\FlFmFnFsFyF{F|G?GBGCGEGHGNGTGYGZG[G\\G^G_G`HlH"},
  {0,NULL,"oHqHrHsHyIGIIIPIRIUIVIaIcIfIjIlIoIrIsItIwIyIzI{I|I}I~J@JBJGJIJKJM"},
  {0,NULL,"JOJVJ_J`JdJnJoJrJuJ|KDKEKGKJKUKWK\\K`KdKfKiKjKkKyK|K}LFLJLKLOLRLUL"},
  {0,NULL,"[L^LdLnLqLuL~M@MAMEMFMHMIMJMOMPMRMTMZMcMdMtMxM{NCNKNNNXNZN\\N`NhNm"},
  {0,NULL,"NoNzN~O@ODOFOMONOOOROUO[O_OeOjOnOoOpPBPFPHPPPRPTPWPYPZP]P_PaPbPeP"},
  {0,NULL,"fPiPuPzQEQFQHQIQMQTQ\\QcQfQgQjQmQqQtQvQxR@RBRORQR\\R_R`RaRbRcRdReRl"},
  {0,NULL,"RmRoRpRqR}S?SGSUSWS_SnSrSuT@TATDTHTKTQTZT_TbTcTiTmTtTwT{U@UBUCUIU"},
  {0,NULL,"OUPUVUWU\\UeUhUnUpUrUvUwUxU|VDVHVLVXVaVeVhVkVuVvVxV|W?W@WAWDWGWHWL"},
  {0,NULL,"WMWNWPWQWSWTWUWVW[WfWhWjWkWmWv_D?E?F?K?O?P?T?U?V?i?j?k@G@H@L@M@N@"},
  {0,NULL,"P@T@U@X@_@a@d@e@f@g@t@w@yA?AAAEANAOAWA[A]A`AhAmAoAwAzBBBEBGBMBQBS"},
  {0,NULL,"BUBVBYBcBpBsBuBxByB|CDCGCHCJCPCSC]C^C_CcCfCjCoCqCwCxCyCzC{C|C}C~D"},
  {0,NULL,"?DADJDLDUDbDdDhD}D~EFENEOE[EcEdEeFAFBFDFGFHFJFKFLFNFTFVFWFkFlFnFq"},
  {0,NULL,"FrFtFuFwFxF~G@GDGIGJGKGLGMGPGQGRGSHiHjHkHuH|I?IAIBICIDIEILIYIZI[I"},
  {0,NULL,"\\I]I^IqIrIsIwIxIyIzI{I|I}J@JAJCJDJEJJJPJYJ\\J]J^JvJxJ{J}K?KCKIKLKP"},
  {0,NULL,"KTKXK[K_K`KdKeKhKqKxK{L@LCLFLKLQLSLULVL[LcLlLvL|MCMDMEMFMIMKMLMMM"},
  {0,NULL,"NMQMRMSM_MbMhMyM{M}NQNSNVN[N^NbNeNkNlNpNqNvNyNzN~OKOMOWOYO[O]OdOe"},
  {0,NULL,"OgOhOjOuO}PCPNPUPVPXPYP[P\\P]P^P_P`PbPdPpPvP~QAQEQIQLQNQSQWQYQ^Q`Q"},
  {0,NULL,"jQmQxQzQ|Q~R@RDRIRKRLRfRgRhRiRjRkRnRrRsRtRuRvSDSISNSZSdSeSySzS~TA"},
  {0,NULL,"TBTGTHTPTVT_TeTfTgThTiT{T}T~UCUDUFURUSUTUUUVUWUiUjUmUrUtUvUzU{U|V"},
  {0,NULL,"FVGVHVSVTVVVpVrVtVvVxV{W@WDWEWFWMWOWQWRWUWWWXWYW[W\\W]W^WcWdWeWfWg"},
  {0,NULL,"Wh_D?F?G?L?N?P?U?W?Y?k?l?m@G@H@K@O@Q@R@S@W@Z@\\@]@`@e@f@g@o@r@v@zA"},
  {0,NULL,"BADAMARATA\\AaAbAdAjAnAvB@BCBDBFBJBOBXB[B^BbBdBgBhBoBsBuBwC@CACECG"},
  {0,NULL,"CSCTCVC[C_CaCeCfCpCqCrCsCuCvCwC}C~D@DBDDDHDZD]D`DkDsD}EDEGEMEXE]E"},
  {0,NULL,"dEfEgFAFDFFFIFPFQFRFUFYF[F\\F^FkFnFpFvFyFzF|G?GAGCGEGHGOGTGUG[G\\G]"},
  {0,NULL,"G^G_G`HlHmHnHqHtI@IFIIISIVIWIXIaIdIeInIoIpIqIsIvIwIxIyIzI|I}J?JAJ"},
  {0,NULL,"BJFJIJKJLJNJZJ[JcJfJmJpJqJyJzJ~KFKHKKKNKRKZK]KeKmKpKqKrKxK~L?LBLC"},
  {0,NULL,"LELMLQLWL]L_LcLoLrLwL}MAMBMFMGMHMJMKMLMMMOMPMUMaMjMsMyM~NBNPNTNWN"},
  {0,NULL,"YN_NdNgNnNpNxNyN{N|OEOLOPOQOWOYOZO`OcOdOrOuOvO~PDPLPOPRPSPUPVPWPZ"},
  {0,NULL,"P^P_PaPcPePkPqPwQBQJQLQNQQQVQWQ_Q`QbQkQlQpQyQ|Q~RCRERNRWRYR_R`RaR"},
  {0,NULL,"bRcRdReRlRmRoRpRqR~SFSKSVS^SaSmSoSpT?TBTETGTLTSTYT`TdTgThTjTvTxTy"},
  {0,NULL,"T}UAUDUJUQUTUUUXUYUdUgUiUoUqUtUyU{U}VEVGVIV]VbVfVgVmVoVrVwV{W?W@W"},
  {0,NULL,"CWEWGWIWJWNWOWPWQWSWVWZW\\W^WcWeWnWpWrWs_C?G?H?J?L?N?U?Z?d?n?p?q?t"},
  {0,NULL,"?v?y@@@B@E@H@J@M@W@Y@_@j@s@u@~A@AAAGAIALAMANATAWAZA_AhAjAmAqAsAvA"},
  {0,NULL,"zB@BGBTB\\B]B^B`BcBfBgBkBnBvBwB{C@CJCNCPCWCYC^C_C`ClCmCnCrCuCwCzDB"},
  {0,NULL,"DMDPDRDSD\\D]DdDgDiDmDoDrDxD|E?ENEPE[EdEnEpEuE{E|FCFEFHFKFLFNFYF]F"},
  {0,NULL,"^F`FhFjFmFnFqFsFyGDGMGOGVGXGZG^GdGfGgGiGmGnGwHDHFHJHLHSHUHVHWH]H^"},
  {0,NULL,"H`HjHoHqHsH{H|IBIFIKIMIVIWIYI^I_IcIhInIrIwI|JFJTJVJ]J`JaJiJkJqJsJ"},
  {0,NULL,"xJzJ}KAKBKEKHKIKOKQKWK]KdKrKtKuK{K|LKLMLSL]LbLjLmLxMBMIMPMXM`MiMn"},
  {0,NULL,"MtMwM{M|M}N@NBNCNDNHNNNONPNRNTNUNVNYNZN]NeNiNmNoNtNvNyN}O?ODOGOJO"},
  {0,NULL,"LOOOPOVO^O`OhOjOoOwPAPCPFPIPJPPPSPUPWPZP`PkPlPrPuP{P}QCQEQHQLQNQS"},
  {0,NULL,"QZQ[Q`QaQbQhQqQrQvQ{Q~RCRQRTRURWRZR]R`RfRkRlRpRtRxSBSCSPSSSXS[S^S"},
  {0,NULL,"bSgShSiSpSrSuT?TATCTGTKTOTRTdTfTiTjTyTzU?UAUHUNUPUQUTUYU[UaUdUfUi"},
  {0,NULL,"UmUpUsUzVEVHVIVRVVVXV]V_V`VbVcVhVnVqVuWAWMWPWRWUWVWWWYWZW_WgWhWoW"},
  {0,NULL,"w_C?G?I?J?M?N?V?[?`?l?o?q?r?v?w@?@B@F@G@K@S@T@]@d@i@v@x@}AAADAFAJ"},
  {0,NULL,"AMAOARAVA_A`AaAhAlAoApAuAwA}B?BMBUBWBZB[BaBbBlBnBpBtBuB{B}C?CBCKC"},
  {0,NULL,"TCXCYC[C]C`CbCkCnCuCxC~DADCDKDMDPDXDYD[D`DbDfDlDmDoDyD}EFELEVEYEc"},
  {0,NULL,"EqEsEvExE|FBFDFJFKFOFPFXFYF[F_FfFhFlFoFvFxF{G@GJGPGSGTG\\G]GiGjGmG"},
  {0,NULL,"oGrGsGuG{HCHGHKHQHSHUHXHbHeHhHiHmHnHoHwH{ICIJIMIPISIWIYI_IbIkImIo"},
  {0,NULL,"ItI~JBJCJEJPJ\\JaJcJjJlJrJtJwJxJ|J}K@KFKGKRKSKXKYK_KmKoKsLALDLELIL"},
  {0,NULL,"NLYL_LcLfLrLuMEMNMRMUMVMZMmMsMvMwMzM{N?N@NANCNFNHNJNLNNNQNUNVNWNX"},
  {0,NULL,"N^N_NcNfNrNsNxNyO?O@OFOLOPOQOROWOZO]OaOmOpOtOwOyO~PCPGPKPOPUPYPZP"},
  {0,NULL,"]PePhPiPjPlPuPzQ?Q@QGQMQRQTQWQYQ_QeQfQlQuQwQzQ|Q}RBRLRNRQRURYR^R_"},
  {0,NULL,"R`RkRnRqRsRwR}R~SOSPS[S_SdSfSjSvSxSzS{S}T?TDTFTHTPTRTTTYT[T^TlTuT"},
  {0,NULL,"xT~UDUHUJUSUTUXUZU^UbUfUlUoUpUrUtUyV@VCVKVQVRVWVXVZV^VbVcVmVnVuV|"},
  {0,NULL,"WDWHWJWMWQWRWYWZW^WfWhWoWtW|_C?F?H?I?L?P?W?b?d?i?p?s?t?v?x?|?}@?@"},
  {0,NULL,"I@K@T@\\@^@b@h@s@y@{@|A?AHAKANARAYAZA[A]AaAeAlAnArAuB?BABCBDBNBPBQ"},
  {0,NULL,"BSBZBbBgBlBnBpBrBtByCECHCICQCcCeCfCjCkClCmCnCpC{C}DBDDDHDQDRDUDZD"},
  {0,NULL,"]D_DdDfDpDrDtDvE?ECEMEVEZEgEjEnEyEzE}FAFFFPFRFVF[F\\F]F^FaFcFfFkFl"},
  {0,NULL,"FuF{F~GCGLGPGUGWGYG]GaGbGcGdGlGoGwG~HAHEHMHQHUHVHXH[HbHfHiHkHrHsH"},
  {0,NULL,"tH|IBIHINIQITIVIYIcIdIfIgIiIsIzI|JCJQJSJ^JdJeJgJhJpJrJuJwJyKAKBKK"},
  {0,NULL,"KLKMKTKUKVK^K`KaKbKzL@LFLJLXLZL\\L^LgLhLrL}MEMLMUM[MeMrMtMvM{M}M~N"},
  {0,NULL,"?N@NANBNCNENGNHNLNQNTNVN[N^NfNgNhNjNoNqNsNuNxNyO@OIOJOSOTOWO\\O^Oe"},
  {0,NULL,"OfOnOuOwOxP@PBPJPNPOPVPWP[P`PaPkPqPvPwPyP}QHQIQJQMQNQTQ\\QaQeQhQiQ"},
  {0,NULL,"lQuQvQwQ~R?RDRKRNRSRVRZR]R_RaRhRpRrRtRzR{SFSOSRSSSTS^S`SlSxSySzS{"},
  {0,NULL,"S|TETGTHTITJTKTUT[T_TaTcTpTrTuT|UKUMUNURU[U\\U^UaUbUdUeUgUjUnUwU|V"},
  {0,NULL,"@VMVPVRVTV[V]V_V`VeVmVrVtVyWEWKWMWNWTWUWVWWW\\WfWkWnWrW~_C?F?H?J?K"},
  {0,NULL,"?L?X?\\?a?k?o?s?t?y?z@?@A@D@G@H@P@Q@S@a@m@o@wA?ACADAFAGAOAPASAWAYA"},
  {0,NULL,"ZA`AgAiAlApAqAxAyA}BHBUBVBWB[B_BdBiBjBnBqBtBwBxCACCCDCTCZC[C_ChCi"},
  {0,NULL,"CkClCnCvCwC|DDDEDNDQDTD[D\\D]DgDhDlDpDrDsD{D~EAEQETEWEhEoErEvEyF?F"},
  {0,NULL,"CFDFGFJFLFXFZF\\F]FfFgFiFmFoFxF|F}GBGIGJGNGSG\\G`GdGgGkGoGqGuGxG{G}"},
  {0,NULL,"HIHPHQHRHUH\\H^H_HcHjHnHpHrH|H}IBIDIGIKIQISIYI`IaIdIhIpIvIxJ?JGJKJ"},
  {0,NULL,"OJ[J\\JdJiJjJnJpJzJ|J~K@KAKFKJKNKPKXKYK_KgKjKlKwK~LALCLULVL_LaLkLl"},
  {0,NULL,"L{MAMJMTMYM_MlMpMtMuMwMyM~N?NBNCNDNGNINKNLNMNONRNTNWNXN_NaNkNlNsN"},
  {0,NULL,"tNyN{N|N~OCOJOKOMOOOWOYO]OaOcOiOlOwPDPEPFPMPNPPPRPVPXPYP`PjPkPmPs"},
  {0,NULL,"PyP{Q@QDQOQQQRQVQWQXQYQgQkQmQoQ}R@RARBRFRGRIRKRMRQR]R`RbRgRjRpRrR"},
  {0,NULL,"ySDSESPSTSUSYS\\S^SmSnSoSqSsStT@TDTGTMTNTRTUTYT\\TeTnTsT{T~U@UGUSUT"},
  {0,NULL,"UWU[U\\U]UaUcUjUoUpUqUvUyVBVFVNVQVRVVVZV]V_V`VcViVrVwVyW?WHWMWPWUW"},
  {0,NULL,"VWWWZW^WkWmWqWrWxX@_C?D?H?J?N?O?X?`?e?k?q?r?t?w?z?{?|@C@I@J@U@Z@^"},
  {0,NULL,"@c@m@t@v@z@|AEAHAIAMASAXAZA^AaAbAeAfAkArAsA|BABIBLBNBOBQBRBSBXBkB"},
  {0,NULL,"nBsBuBxByB|CECMCRCUCYC_CaCbCeCiCjCnCoCzC|C~D@DIDNDPDVDXD]DbDgDoDs"},
  {0,NULL,"DtDuD{EBEFEIEREUEhEiEqEwE}F@FAFEFGFKFMFSFWF[F]FaFbFdFkFnFuFwFzGEG"},
  {0,NULL,"LGQGRGUGYG[GbGgGkGlGmGpGrG|G~HHHNHRHTHUH`HaHeHfHjHlHmHtH{H}IBIDII"},
  {0,NULL,"IMIPIUIYI^I`IeIkIlIvIyJBJHJLJMJ^JbJfJgJkJnJoJvJwJxK?KAKKKLKMKZK[K"},
  {0,NULL,"\\K`KhKkKpKxKzL?LGLPLRLXL[LvLyLzM@MGMOMWMhMkMpMsMvMwMyM|NANBNCNDNF"},
  {0,NULL,"NINJNKNMNNNPNUN[N`NbNdNgNjNrNuNyOBOCODOEOIOKOLOOOROTOXObOeOrOvOwO"},
  {0,NULL,"}P?PAPDPGPPPTPUPXPaPePhPkPmPuPxP|QBQFQGQJQMQUQ\\Q^QdQeQfQnQtQuQxQy"},
  {0,NULL,"Q|RDRMRQRSRWR[R^R`RbRhRlRnRvR|SMSNSPSRSUSbSdSeSmSnSoSqSsStT@TCTET"},
  {0,NULL,"HTRTSTVTZT]T_T`TpTwUCUFUGUIUPURUTUVU^U`UbUcUiUnUpUuU|U}V?VLVPVRVV"},
  {0,NULL,"VXV_VbVcVeVjVoVsV{WCWKWMWPWRWVWYWZW\\WbWiWlWsWyXA_C?F?H?J?K?L?X?\\?"},
  {0,NULL,"a?k?o?s?t?y?z@?@A@D@G@H@P@Q@S@a@m@o@w@~ABAEAHAIAQAVAXA\\A^AaAbAgAi"},
  {0,NULL,"AlApAqAxAyA}BHBUBYB\\B]BbBdBhBjBpBqBrBvBzCECHCJCUCXCZC\\C]C`CfCkCnC"},
  {0,NULL,"qCyD?D@DEDGDJDSDTDWD\\DcDfDhDiDsDuDxE?EGEKEVE\\EhEoErEuE~F@FAFEFIFM"},
  {0,NULL,"FOFSFUFWF[FfFgFiFmFoFxF|F}GBGKGOGSGXG]G`GcGhGiGjGoGqGsG|G~HAHFH[H"},
  {0,NULL,"]H_HbHcHdHgHiHlHpHqHzH}IFIGIKILIOIXIYIZI[IjIlIpIrI{I|JCJRJUJ]J_Jf"},
  {0,NULL,"JgJkJoJtJvJwJ{K?KDKKKLKMKZK[K\\KkKnKpKtKxKyLGLKLPLWL[L]LeLfLwM?MQM"},
  {0,NULL,"RMVM]MjMnMwMxMyM{M|N?N@NANDNENFNGNINJNNNQNVNYN\\N_NeNfNlNpNqN{N}N~"},
  {0,NULL,"O@OAOHOPOQOWOYOZO\\ObOeOfOoOwO|O}PHPLPMPOPRPSPTPXP^PgPrPsPtP{P~QAQ"},
  {0,NULL,"CQEQFQMQTQ^Q`QbQcQeQlQqQrQsQuQwQyRJRNRRRTRWR[R_ReRfRlRuRvRzR{SFSO"},
  {0,NULL,"SQSXSbScSeSkSwSxSzS{S~TBTFTITJTKTOTQT^TiTjTmTxTyTzUEUKUMUNUOUQUUU"},
  {0,NULL,"XU_UdUeUgUkUmUrUxVCVHVIVOVTVWVYV\\VaVdVfVnVpVsV{WFWIWLWNWQWSWXW[W]"},
  {0,NULL,"WbWhWjWlWz_C?D?H?I?O?P?T?^?_?m?p?u?w?x?z?{@A@B@H@K@Q@[@]@_@k@q@r@"},
  {0,NULL,"{@}ABAHAJALAUAVAWA^A`AcAgAhAkAqAuAwAyA{BGBNBUB[B]B`BbBiBjBmBnBqBs"},
  {0,NULL,"B}C?CECGCRCWCYC^C`CaCfChCoCrCvC}D?DADFDHDJDKDLDUDjDkDmDnDpDuDvEBE"},
  {0,NULL,"CEQEUE[EeEkEmExEzE~FAFBFJFLFNFOFQFTFWFdFgFhFlFmFsF}G@GHGLGSGXGZG\\"},
  {0,NULL,"G]GcGfGiGmGnGpGxG~H@HCHNHTHUHYH\\H_HcHhHlHoHrHvH~I?IAIHIJINIRIXI[I"},
  {0,NULL,"aIeIiImInIsIyIzJGJLJTJ_JcJeJgJlJmJqJtJvJzK@KCKGKRKSKZK[K\\KbKiKnKo"},
  {0,NULL,"KyLBLELJLWLYL\\L`LjLlLsMAMIMMMXM_MfMrMsMtMxM}M~NBNCNDNGNKNMNONPNRN"},
  {0,NULL,"SNUNVNXNYNZN[N_NfNwNyN{N|N~OBOFOGOLOMOPOVOXO\\O_OeOmOvOxO~P?PEPHPI"},
  {0,NULL,"PTPVPZP\\PbPdPiPoPpPvPwP~Q@QEQMQNQQQUQWQXQbQeQhQnQrQuQvQxQ}RARIROR"},
  {0,NULL,"RRVRZR^RaRcReRjRnRtR|SMSNSQSSSVS\\S`SdSgSmSnSpStSuT@THTJTLTOTTTVT["},
  {0,NULL,"T\\TcTjTsTuTzT|UGUIULUMUQUZU^UbUcUgUhUmUtUuUwV@VBVIVSVWVZV\\V^VaVbV"},
  {0,NULL,"dVgVhVrVvW@WGWHWIWJWLWQWXWYWdWgWkWpW}X@XD_C?F?I?J?K?P?V?]?^?l?o?u"},
  {0,NULL,"?v?x?z?|@@@D@J@L@N@R@Y@c@i@n@r@{@}ABAFAJAMARATAVA]A^A`AeAiAmAsAtA"},
  {0,NULL,"zBEBIBKBRBVBXB^B`BeBfBgBiBvBwByBzCBCDCFCTCZC\\C_CaCeCgCjCxCyC{C~DB"},
  {0,NULL,"DEDJDLDODUDWDZD_D`DcDiDlDtDwEAEEEIENETEcElEmExEzE~FBFDFHFJFKFOFPF"},
  {0,NULL,"VFWF`FaFiFnFpG?GDGEGGGIGRGVGZG[G_GbGgGhGlGpGqGvG{G}H?HKHVHWH\\H]H^"},
  {0,NULL,"HfHgHkHnHqHtHwHzIEIHIOIRITIXIZIbIcIgIkIpIqIxJAJKJMJVJ_JcJeJjJlJrJ"},
  {0,NULL,"sJtJuJvJxK@KFKGKRKSKXKYKcKiKmKoLBLDLELLLNLYL`LdLjLtLvMFMIMOMXMgMh"},
  {0,NULL,"MqMsMzM{M|M~NANBNCNDNINMNNNONQNTNUNVNZNaNbNdNiNnNoNpNtNuNvN|N}OHO"},
  {0,NULL,"IOOOTOUOXOYOaOcOdOtOyPBPGPJPLPMPSPYP[P]P^PaPgPnPpPqPvP~QBQGQLQOQR"},
  {0,NULL,"QSQYQZQ[QdQfQgQoQtQ{Q|RBRCRKRNRPRUR[R\\R_RdRkRoRrRvRySDSESOSTSWS[S"},
  {0,NULL,"]SeSgSoSpSqSsSuT@TATBTJTLTNTUTXT]TdTkTqTtTwU?UGULUMUOUYU\\U]UcUgUh"},
  {0,NULL,"UjUkUsUvU~V?VEVJVOVPVTVUVYV[V\\V]VmVnVtV{W@WIWKWNWOWSWTWUW[WbWfWhW"},
  {0,NULL,"nW}_C?G?I?J?M?N?V?[?`?l?o?q?r?v?w@?@B@F@G@K@S@T@]@d@i@v@x@z@|AEAI"},
  {0,NULL,"AKALAPASAXA[A]A^AhAlAoApAuAwA}B?BMBPBQBWB]BbBdBiBmBnBoBqBtBvC@CJC"},
  {0,NULL,"QCSCVCXC]C^CeCgClCrCsCxCyDCDDDIDVDWDXDYDZD^D_D`DeDhDmDwD|E@EOEWE["},
  {0,NULL,"EcEqEsEwE}F@FEFFFGFMFNFRFVFWFZF_FfFhFlFoFvFxF{G@GJGWGXGYG]G`GbGdG"},
  {0,NULL,"eGfGjGsGvHDHFHMHOHQHUHYHZH\\H]HcHkHoHpHuHwI@ICIIIOIPITIUIZI\\IbIdIn"},
  {0,NULL,"IoIqIwI}JOJTJZJ^JbJfJhJkJnJqJuJvJyJ~K?KHKKKLKMKQKWK^KfKhKkKvKxL?L"},
  {0,NULL,"@LPLQLRL^LkLsLzM@MJMMMYMfMkMqMsMuMyMzM}NCNDNJNKNLNMNNNONPNRNSNTNW"},
  {0,NULL,"NYNfNhNjNlNsNwNyNzN{N|N}OGOJONOQOTOUOZOhOkOoOuOyOzPIPKPLPNPQPRPZP"},
  {0,NULL,"[P]PfPgPhPqPxPzP|QAQDQEQIQNQVQbQcQhQiQkQmQrQsQvR?R@RFRGRJRPRXRZR\\"},
  {0,NULL,"RdRgRmRoRtRuRxSBSCSSSWSYS]SaScSgSoSpSqSsSuTATCTITKTNTSTVTcTeTgTmT"},
  {0,NULL,"|U@UBUEUIUKUNUPUVUYU]U`UdUeUiUsUuUvUwUxU{VFVTVUVYV[V`VaVeVfVgVlVw"},
  {0,NULL,"VzWCWNWOWSWTWWWXW\\W]WaWdWeWqWyXAXD_C?E?H?J?K?O?U?]?_?n?q?u?x?y?z?"},
  {0,NULL,"}?~@F@G@I@O@`@b@d@j@n@q@{@}ABAFAHAMARASAUAWA]AcAdAnAoApArBBBCBJBM"},
  {0,NULL,"BPBYBZBaBbBeBkBlBoBrBwBxB}B~CHCKCLCVCYC]CcCgCiClCpCqCwCzC|DCDJDLD"},
  {0,NULL,"NDPDUD\\DaDeDoDqDrDsDxEDEGEJEOESEdEkElExEzE~FAFDFGFKFLFPFQFTFVF_Fc"},
  {0,NULL,"FeFkFoFtFvGCGFGKGPGTGWG]G_GaGdGeGjGkGmGvGyHAHBHGHRHXHZH[H^H`HhHxH"},
  {0,NULL,"yH{H|H}I@IDIHIKIMIRIXI^I`IfIhIjIoIrI{J@JIJNJZJ_JcJeJgJjJmJnJrJuJx"},
  {0,NULL,"JzKCKGKRKSKTKUKVKbKcKmKnKyLDLJLLLNLWL\\LdLsLtL|MFMHMMMbMfMgMnMtMxM"},
  {0,NULL,"yMzM|NENINKNMNNNONPNQNRNSNTNUN\\N^NcNfNhNnNqNtNxNzOCODOFOJOKOLONOQ"},
  {0,NULL,"OSOUOfOgOpOqO|P@PAPDPFPKPUPXP_P`PcPfPmPpPuPvP{P~Q?QAQIQKQPQTQ]Q_Q"},
  {0,NULL,"cQiQjQlQpQsQwQzR?RERHRJRLRMRWR]RbRiRlRpRsRuSHSISLSUSZS^SbScSfSgSh"},
  {0,NULL,"SiSpSrSuT@TCTFTGTJTLTPTWT^TaTmTrTvTxUEUGUJULUMUPUXU[UaUcUgUhUiUlU"},
  {0,NULL,"rUxVAVCVMVPVQVRVVVZV_VcVeVkVlVpVxW@WHWKWMWPWVWZW\\W^W`WcWeWjW}X@XA"},
  {0,NULL,"_C?G?H?I?L?M?T?\\?c?m?o?p?s?w?y@@@C@F@I@L@N@U@V@`@k@o@pA?ACADAGAKA"},
  {0,NULL,"OASATA\\A`AbAcAfAmAoArAtA|A~BBBEBOBPBSB^B_BeBfBhBkBlBoBqB}CNCPCQCS"},
  {0,NULL,"CWC\\C]C_CaCbCeCtD?D@DADBDCDGDHDKDQDTD[DbDeDfDiDkDnDvE?E@ENEOEREeE"},
  {0,NULL,"oEtEvEyF?FCFFFGFHFIFJFSFTFXF_F`FbFkFpFrFtFzG?GNGQGUGVGWG_GbGgGhGj"},
  {0,NULL,"GnGpGrHJHLHMHOHWHXHZH`HcHdHhHiHmHqHvI?I@IGIJILINIQISI[I]IcIlImIoI"},
  {0,NULL,"sI|I}JHJVJZJ[J\\JdJhJiJnJoJsJ{J|K@KCKHKJKNKPKQKWKaKeKgKlK}K~LCLFLT"},
  {0,NULL,"LULZLaLtLyL{MFMGMTMWMgMlMrMvMxMyM{M~N?NCNDNFNINMNNNPNQNRNTNUN`NgN"},
  {0,NULL,"hNiNkNnNvNxNzN{OAODOFOHOOOQOROTOVOXO`OjOkOuO{O}O~PHPJPKPOPSP\\PdPe"},
  {0,NULL,"PfPiPjPsPtPwPyQAQFQIQJQLQSQZQ[Q\\Q^QcQiQsQyQ{R?RCRDRJRRRSRURVRYRaR"},
  {0,NULL,"eRhRkRqRuRxSBSCSQSRS[S_S`ScSgSmSnSpStSuT?TDTGTITNTOTVT_TaThTkToTp"},
  {0,NULL,"TqTrUHUIUKUQUSU[U]UaUeUfUmUoUuUvU|VGVJVMVOVQVSVWVXV^VdVfVkVmVoV|W"},
  {0,NULL,"?WGWJWLWQWRW[W]W^WcWfWiWtWx_C?E?I?J?K?M?Y?a?c?j?o?r?s?u?y?{?}@E@J"},
  {0,NULL,"@K@M@Z@[@\\@l@p@wA?ACADAFAKAPATAYAZA\\A^AcAjAkAnAsAuAvA{BDBLBNBSBTB"},
  {0,NULL,"ZB[BcBoBpBsBvBxByB|B~CICKCOCWCYCZC^CfCgCmCoCqCsCuCyC{DODQDTDWDYD["},
  {0,NULL,"D^D`DaDcDdDuDyD}EGEPESEUEfErEtEvEyF?FDFFFHFIFTFWFZF\\F]FcFdFjFlFnF"},
  {0,NULL,"wFyF~GHGLGMGPGUG\\G^GcGfGmGnGqGvGwGzHBHEHGHRHTHZH]HaHbHfHlHsHuHwHy"},
  {0,NULL,"HzICIEIGIOIQISIZI\\I_IeIgIjItI{I~JFJIJLJ[J\\JdJhJjJpJsJvJ{J~KAKCKJK"},
  {0,NULL,"NKPKTKUKVK_KaKeKjKwK}LALFLTLVLZL_LlLxLyMAMGMPMWM_MiMmMsMuMwMxM{N@"},
  {0,NULL,"NBNDNFNGNINKNNNONPNRNUNXN[N]N^NgNmNuNzN}O@OBOCOEOGOLOUOVOYO\\O^OgO"},
  {0,NULL,"nOpOsOzO|P?PBPCPLPQPTPWP]P^PcPgPjPnPsPyPzQ?QCQHQKQMQUQ]Q_Q`QaQeQn"},
  {0,NULL,"QqQuQxQzQ~RERHRNRTRXR\\R^R_RfRiRmRnRoSHSISLSOSXSZS]SaSdShSiSmSnSrS"},
  {0,NULL,"tTDTGTJTNTPTQTSTZT[TfTlTuUAUDUFUJUMUSUUUVU[U]U_U`UaUgUlUoUvUzV@VK"},
  {0,NULL,"VLVOVTVUVYV[V\\V`VeVjVuVvV~W?WIWNWOWSWTWWW[W\\WoWpWsWvWxXA_C?F?I?J?"},
  {0,NULL,"K?P?V?]?^?l?o?u?v?x?z?|@@@D@J@L@N@R@Y@c@i@n@r@zA@ACAIAKALAOASAUAX"},
  {0,NULL,"A[A_AeAiAmAsAtAzBEBIBKBOBRBSBTB\\B^BgBhBjBlBsBuBwCICJCQCUC[C\\C`CaC"},
  {0,NULL,"cCiCmCvCwCyC}C~DCDFDLDMDNDOD[D_DaDlDmDnDsDyECEGEKEZE_EcElEmEwE{F?"},
  {0,NULL,"FEFFFGFMFNFQFRFXFYF`FaFiFnFpG?GDGEGGGMGOGQGUGVG[GaGhGiGkGpGuGwG|H"},
  {0,NULL,"EHFHMHTHVHXH^H_HdHeHkHnHoHvHyH}IAIDIEIRISIWIZIaIhIiIkIoItIzI{JQJR"},
  {0,NULL,"JYJ[J`JbJhJkJmJnJqJyJ|J}K?KHKKKLKMKQKWK]KeKfKhKvK|K}L?LQLRLSLTLiL"},
  {0,NULL,"oLpL~MCMSM\\M^MaMmMsMtMuMxMzN?N@NENGNJNKNLNMNONQNSNVN]N`NdNeNgNiNo"},
  {0,NULL,"NrNtNxN~OAOBOHOKOPOSOXO]O^ObOnOoOuOxPEPFPGPKPLPXPYPZP[P\\PcPjPlPmP"},
  {0,NULL,"nPoPpQEQFQHQIQPQUQ^QaQbQiQjQnQpQrQxQyQ~R?RGRLRRRXR]R^ReRgRmRnRpRs"},
  {0,NULL,"RzR{SFSQSYS^SaSdSfSjSvSxSzS{S}TETFTGTHTMTOTQTZTbTfThToT}UAUFUQURU"},
  {0,NULL,"UUWUXU[U^U_UaUbUmUnUqUrUzVDVGVLVQVSVVVXVZV_VbVdViVwVzV~WBWGWHWLWP"},
  {0,NULL,"WRWVWYW^WaWmWqWvW{X?XCXI_C?D?I?J?N?P?Y?Z?b?j?p?r?t?u?v?~@A@C@G@L@"},
  {0,NULL,"O@V@X@a@l@u@y@~A@AAAIAJANAPAQATAWA]AbAdAfAgApAtA~BFBHBJBOBUBYB\\B_"},
  {0,NULL,"BaBhBiBkBoBrByB}C?CGCMCUCZC^CdCeChCiCkCpCsCvCxC{D@DMDODRDSDYDZD^D"},
  {0,NULL,"_DbDcDpDqDyECEFEJEQEREfEjEpEuE{E|FBFEFHFLFSFUFVFZF^FbFeFgFoFpFrGA"},
  {0,NULL,"GBGFGKGNGOGQGSGTGbGfGkGoGqGtGxG|H@HCHHHZH[H\\H`HdHfHhHkHmHrHuHxHzI"},
  {0,NULL,"CIEIFITIVIWI\\IaIbIfIgIlItIzJBJGJHJNJ]J`JaJkJlJoJsJuJzJ~KBKDKEKIKO"},
  {0,NULL,"KZK[K\\K]KqKsKtK|LHLILKLOLSL]LcLmL{L|MBMHMTM`MbMlMmMtMuMvMzM{N?NBN"},
  {0,NULL,"CNENHNINKNMNPNRNTNUN\\N_N`NcNeNkNqNuNzN|OAODOFOGOKOMOTOWOYO[O_ObOm"},
  {0,NULL,"OrOyOzO}P@PBPEPQPVP[P^P_PePlPnPqPrPzP}Q@QFQJQPQQQTQWQXQ\\Q^QjQlQpQ"},
  {0,NULL,"wQyQ}RARDRIRLRNRPRSRXR_RdRhRjRmRsR|SMSNSOSRSWS\\SaSfShSiSmSnSrStTA"},
  {0,NULL,"TETJTOTRTSTTTYT^TbThToTxT}T~UMUQURUTUVUYUZU`UgUmUnUpUsUtUyVCVDVGV"},
  {0,NULL,"PVTVUVYV[V]VaVfViVxV|V}WAWKWNWOWSWTWUWXW]W`WmWtWuWwXD_C?E?H?J?K?O"},
  {0,NULL,"?U?]?_?n?q?u?x?y?z?}?~@F@G@I@O@`@b@d@j@n@q@zA@ACAGAIALANATAVA[A\\A"},
  {0,NULL,"_AdAnAoApArBBBCBJBMBOBPBQBWB_BaBlBmBpBtByBzB}C@CACMCPCVC\\CbCdCfCg"},
  {0,NULL,"ChCqCrCzC{DADEDFDIDJDNDODTD`DiDjDqDrDuD{EAEBEMEYE]EdEkElEwE{F?FCF"},
  {0,NULL,"EFHFIFNFOFRFYF^F_FcFeFkFoFtFvGCGFGJGNGQGTGWGYGcGeGhGrGtGvGxHDHHHI"},
  {0,NULL,"HLHQHXHYHbHfHgHhHlHqHwHxH|H~IAIDIEIGIUIXI^IgIjImInIpIvIxIyJPJSJWJ"},
  {0,NULL,"[J`JbJiJkJqJsJtJyJ{J}KBKEKHKIKOKQKWK]KdKgKhKuK|K~L?LMLRLSLULhLpLu"},
  {0,NULL,"L}MCMNMZM[M^MpMsMtMwM|M~N@NANBNFNGNHNLNONQNSNUNVNWN`NcNhNjNkNpNsN"},
  {0,NULL,"uNwNxO@OFOHOMONOROUO[O\\O`OhOiOrO|O~PAPBPIPMPSPTP]P_P`PbPmPnPoPsP|"},
  {0,NULL,"P~Q@QGQJQLQNQVQWQZQ\\QfQhQmQvQ{Q|Q}RDRFRIRQRTRVR[R\\R`RaRfRjRoRvS?S"},
  {0,NULL,"@SASPSXS\\S]S`SeSjSlSvSyS|S}TBTETMTNTQTTTVTYT_T`TeTpT~U@UCUIUOURUU"},
  {0,NULL,"UWUZU]U_UkUnUqUtUuUvUyU|U}VFVOVSVTVYV\\V^VaVfVjVqVuVyWBWGWIWJWNWSW"},
  {0,NULL,"XW[W]W_WoWrWsW{XGXIXL_C?E?H?I?M?O?W?[?e?i?q?r?s?w?x?~@D@E@H@L@P@R"},
  {0,NULL,"@W@X@h@t@x@z@|AEAHAKALAZA[A]A`AaAbAdAiAjAqAtAxB@BFBKBRBTBVBYB\\BdB"},
  {0,NULL,"fBsBvBwBzB{B}CHCICLCOCWCZC[C]CdChCiCpCtCuC}DADEDFDGDIDKDVDXDdDfDj"},
  {0,NULL,"DkDlDqDzD}EDEJEPETEgEiEsEwE}F@FAFFFJFNFRFSFVF[F]FeFiFjFmFpFqF|GAG"},
  {0,NULL,"GGIGKGMGOG[G`GjGkGnGqGtGuGxGyGzHAHEHSHTHWH]H^HgHhHiHnHsHxH~I?IAII"},
  {0,NULL,"IJILIPIUI]I_IfIiImIpIuI~J@JFJKJNJ^JbJfJgJhJoJqJuJwJyK@KAKKKLKMKTK"},
  {0,NULL,"UKVK^K`KfKpKvKzL@LGLQLXL[L^LkLmLvMBMJMOMYM`MhMoMvMwMzM}M~NANBNCNH"},
  {0,NULL,"NINKNLNNNONRNTNUN\\N]NaNdNeNlNpNtNvN}O?OBOFOKOMOQOVOYO[O]OfOnOqOsO"},
  {0,NULL,"xO{O~P@PCPMPOPWPYP_PbPdPhPiPoPtPxP|QCQHQOQPQRQTQYQ`QaQgQjQlQoQpQq"},
  {0,NULL,"QwQ~RBRKRLRORTRVRYRaRcRfRqRrRsSHSISLSTSVSXS_S`SfShSiSoSqSrSsTCTDT"},
  {0,NULL,"FTLTQTSTVTXTbTiTnTtTyT{T}UIULUPUSUUUVUXU_U`UhUiUoUrUuU~VDVHVNVQVS"},
  {0,NULL,"VWVXV\\V^VaVdVqVtVyV}WCWGWIWJWLWQWRWXW^W_WnWrWuWyXDXK_C?G?H?I?L?M?"},
  {0,NULL,"T?\\?c?m?o?p?s?w?y@@@C@F@I@L@N@U@V@`@k@o@p@~ABAEAHAJANAUAVAWAXAYA^"},
  {0,NULL,"AfAmAoArAtA|A~BBBEBOBRBXBYBaBeBgBhBoBtBuBwB|C?CBCLCRCVC_CbCdCgCkC"},
  {0,NULL,"mCoCsCwDADBDDDGDQDRDVDWD\\D`DdDeDgDnDpDzD}D~EHEYE_EeEoEtEuE~F@FAFB"},
  {0,NULL,"FLFMFOFQFWF\\F^F_F`FbFkFpFrFtFzG?GKGQGRGTG[G_GeGgGoGrGtGvGwGyHCHKH"},
  {0,NULL,"NHQHVHZH^HaHdHeHjHrHsHvHwI@IIIKILIOIQIVI\\IcIdIeIhImIuI~J?JJJPJYJ]"},
  {0,NULL,"J_JfJgJlJmJpJtJvJzK?KBKGKRKSKZK[K\\KiKnKpKqKyLBLGLHLOLWL[L`LpLqLwM"},
  {0,NULL,"CMDMQM^McMjMoMuMwMxM}M~N?N@NDNFNGNHNJNLNONRNSNVN\\N`NbNcNdNnNoNrNs"},
  {0,NULL,"NtNzOAOEONOOOROUOWO[O^OmOqOtOvOzO~P?PFPJPNPPPVPWP\\P]PfPgPtPxPyP{P"},
  {0,NULL,"}Q@QGQKQOQPQUQWQ]QfQgQjQnQoQpQxQ|Q}RERHRKRORQRXRZR`RcRiRmRrRtRwR}"},
  {0,NULL,"R~SPSSSTSVSZSaSjSkSvSwS}S~TBTFTKTPTRTSTUTWTXT`TbTtTvT}UCUJUNUOUTU"},
  {0,NULL,"VUXU\\U`UdUjUkUlUpUrU}U~VAVDVPVRVUVYV]V_V`VeVgVhVqVzWFWKWMWOWSWUWV"},
  {0,NULL,"WWW\\W_WaWdWgWzXCXFXHXL_C?D?H?J?N?O?X?`?e?k?q?r?t?w?z?{?|@C@I@J@U@"},
  {0,NULL,"Z@^@c@m@t@v@}AAADAFAGAOAPAQAVAYA[A`AeAfAkArAsA|BABIBLBSBXBZB^BcBe"},
  {0,NULL,"BgBhBmBoBsBuBzB~CCCDCNCWCXCcCdCeCfCjCrCsC|C}D@DEDIDJDKDPDSDYD_DgD"},
  {0,NULL,"hDkDqDuDxD|EDEHEZE^EhEiEqEvExE|FCFDFJFOFRFUFXFZF\\FaFbFdFkFnFuFwFz"},
  {0,NULL,"GEGPGRGUGVG^G_GaGbGcGlGnGsGtG}HBHJHPHTHVHYHZHdHeHgHjHkHlHpHxI?ICI"},
  {0,NULL,"FIJIMIUIXI\\I`IiIlInIpIrIwJ@JJJQJXJ\\JaJcJiJjJpJtJyJ|J~K@KDKFKJKNKP"},
  {0,NULL,"KXKYK_KlKmKrK{LALCLDLNL_LaLbLiLqLrL~MDMEMUM\\McMnMtMwMyMzM}N?NANCN"},
  {0,NULL,"ENGNHNJNKNLNRNSNVN^NbNgNiNmNnNoNpNrNwNzOAOBOIOSOTOVOZO[O\\OcOgOjOl"},
  {0,NULL,"OxOzO}PDPIPMPPPRPTP[P_PdPiPrPuPzP|P~QDQHQIQKQOQSQ[Q]QaQgQiQkQoQ~R"},
  {0,NULL,"?R@RCRERIRJRORPRTR]RcRdRfRjRpRuSGSJSKSVSWSXS\\S^ScSkSwSxSzS{S~T?TA"},
  {0,NULL,"TITLTPTQTTTWTaTdTfTrTvU?UAUHUJUKULUUUYUZU_UeUfUhUlUsUtUzVAVEVMVOV"},
  {0,NULL,"SVUV[V\\V^VaVfVhViVrVxWDWGWIWJWOWTWXW[W]W`WgWkWmW|XFXIXJ_C?D?I?J?N"},
  {0,NULL,"?P?Y?Z?b?j?p?r?t?u?v?~@A@C@G@L@O@V@X@a@l@u@y@{@|A?AFAKAUAYAZA\\A_A"},
  {0,NULL,"aAcAdAfAgApAtA~BFBHBJBPBVBYB_BdBeBjBkBqBrBuBzB{B~CDCOCSCVC_C`CbCc"},
  {0,NULL,"CdChCsCuCvCzC~D?DHDLDMDXDZD]DaDbDcDgDjDmDwD|EEEHE\\E]EfEjEpEyEzE}F"},
  {0,NULL,"DFFFIFQFTFYF[F\\F]FbFeFgFoFpFrGAGBGFGIGKGNGWG_G`GaGeGgGiGrGtGxGzG}"},
  {0,NULL,"HBHOHSH[H_H`HcHeHgHjHmHoHyHzH~IBINIPIRITIWI[I\\I^I_IaIkIqIwJAJJJUJ"},
  {0,NULL,"WJ^JdJeJhJjJmJpJwJ{J}KAKCKJKNKPKTKUKVK^KaKcKjKwL@LFLLLVLZL^LdLhLn"},
  {0,NULL,"LwL}MKMQM[MdMjMqMsMuM{M|M}N@NANBNDNENFNGNHNJNPNSNVN\\NaNhNkNlNnNpN"},
  {0,NULL,"qNrN{N~O?ODOMONOOOPOROSO[OcOgOkOsOzPAPCPEPGPHPPPZP^PbPcPePhPkPlPp"},
  {0,NULL,"PqPwQAQCQKQLQOQVQZQ]Q`QcQgQmQoQqQsQ{RERFRGRORURWR\\R^RcRgRkRlRnRoS"},
  {0,NULL,"GSJSKSVSYS[S]SbSdSkSlSwSyS|S~T?TCTHTITLTMTUTXTeTkTmTqTtU@UEUHUKUL"},
  {0,NULL,"UPUWU\\U^UbUeUfUhUiUjUqUxU~VFVJVQVRVSVXVZVbVcVdVgVjVvV{WEWGWHWLWMW"},
  {0,NULL,"RWYWZW^WbWdWpWsW~XBXHXIXN_C?D?H?I?O?P?T?^?_?m?p?u?w?x?z?{@A@B@H@K"},
  {0,NULL,"@Q@[@]@_@k@q@r@zA@ACAGAKANAOARASATAXA\\AgAhAkAqAuAwAyA{BGBTBWB[B]B"},
  {0,NULL,"cBdBgBiBmBrBxB{B|CCCNCOCSCVCXCYCZC`CjCkCoCpCxC|D?DBDFDNDODRDUDVDc"},
  {0,NULL,"DeDkDoDpDtDzEDEEELE\\E^EeEkEmEwE{F?FCFFFGFHFIFMFPFXF^FdFgFhFlFmFsF"},
  {0,NULL,"}G@GHGJGMGXG\\G^G`GeGiGlGmGoGqGsGzHJHOHPHRHSHVHYH[H\\HaHrHtHzH{I?I@"},
  {0,NULL,"IAIDIEIHIIIVI[I`IbIcIeIfIuJ@JAJEJUJXJ[J`JbJhJiJnJrJsJ{J|K?KBKHKJK"},
  {0,NULL,"NKPKQKWKdKeKfKgKuKvK}K~LMLQLTLULeLoLuM?MNMSMZM]MaMoMvMxMzM|M~N?NA"},
  {0,NULL,"NENFNHNINJNMNQNSNUNVNWNXNYN]NlNmNoNqNwN|O?OCOEOIOLONOPOWOYOZOjOkO"},
  {0,NULL,"lOsOyP?P@PDPHPJPUPVP^PaPdPfPmPnPoPvPxP}Q?QAQCQDQRQSQYQ[Q_Q`QcQkQq"},
  {0,NULL,"QsQzR@RBRCRHRKRPRSRWRYRdRhRiRlRqRrSGSJSKSRSTSWSZS_SbSjSkSvSwS}S~T"},
  {0,NULL,"ATCTETMTPTQTUTgTiTlTnTyT{UBUDUJUPURUUUWUYU\\U_UiUjUlUnUqUsU{VHVKVN"},
  {0,NULL,"VPVTVVV[V]V`VcVeVoVsV|V}WBWKWNWPWTWUWWWZW\\WiWlWtWuW{X?XBXGXJ_C?F?"},
  {0,NULL,"H?I?L?P?W?b?d?i?p?s?t?v?x?|?}@?@I@K@T@\\@^@b@h@s@y@~A@AAAGAJALAMAP"},
  {0,NULL,"AQA_AbAcAeAlAnArAuB?BABCBDBQBWBXBZBaBcBfBpBqBsBuBxByCACBCCCFCXC]C"},
  {0,NULL,"aCcCgChClCqCtC}C~D?DDDFDGDHDMDRDSDaDfDhDjDnDtDzD~EEEIESEWEgEjEnEu"},
  {0,NULL,"E{E|FBFCFKFNFSFTFUFYFZFaFcFfFkFlFuF{F~GCGJGPGRGTGYG^GaGdGjGpGsGvG"},
  {0,NULL,"xH?HIHKHPHRHTHWHbHcHeHfHiHpHtHvHyH~IAIFILINIVIWI[I]IdIiIjIkIuJ?JA"},
  {0,NULL,"JIJMJOJ]J`JaJiJlJoJqJxJ}J~KCKDKEKFKIKOKXKYKdKqKrKsKuK{LHLILMLOLbL"},
  {0,NULL,"cLxLzL|M@MHMPMbMiMkMoMuMvMxM|M}N@NBNDNENINJNKNMNNNONPNTNWN^NbNcNj"},
  {0,NULL,"NmNrNuNvN{O@OBOCOJOMOQOSOUOXOZOdOiOlOtOxO{O|PGPHPNPOPRP\\PaPbPcPlP"},
  {0,NULL,"oPrPtPwP}Q?QBQDQGQKQVQ]Q_QdQfQkQmQtQzQ|R@RERFRGRHRORRRYR[RcReRgRi"},
  {0,NULL,"RqRvRySDSESQSVSYSZS_SeShSiSoSqSrSsTATBTDTLTMTOTRTWT`TgTlTvUBUCUDU"},
  {0,NULL,"LUOUQUSUTUWUYUhUkUmUoUpUqUsU{U}VAVKVOVSVWVZV^VbVdVfVpVsVzV~WAWGWH"},
  {0,NULL,"WJWLWQWYW[W]WaWjWlWvWwX@XMXP_C?E?H?I?M?O?W?[?e?i?q?r?s?w?x?~@D@E@"},
  {0,NULL,"H@L@P@R@W@X@h@t@x@}AAADAGAJAMAPAQARAXAYA_AdAiAjAqAtAxB@BFBKBUBVB\\"},
  {0,NULL,"B^B_B`BjBkBrBtBvBzB|CACFCGCPCVC[C\\C^CiCjCmCoCpCtCyCzDDDKDPDQDUDVD"},
  {0,NULL,"YD^DdDeDjDsDtDvE@EBEKEXE]EgEiEsEvExE|FBFCFKFMFPFUFYFZF\\FeFiFjFmFp"},
  {0,NULL,"FqF|GAGGGIGNGOGSGVGZGeGfGhGkGlGuGwH?H@HIHLHQH[H]H_H`HaHgHsHtHuH}H"},
  {0,NULL,"~I@ICIHIIIJIMIQIZI]I^IdIeIfIsIyI}JDJRJWJ\\JaJcJiJlJpJrJxJ}J~K?KDKE"},
  {0,NULL,"KFKIKOKXKYKlKoKrKsK{LCLELILYLaLbLcLfLiLnL~MKMRMVM\\MdMrMsMvMxMyM}N"},
  {0,NULL,"@NANENFNGNJNKNLNNNPNQNSNZN_NaNeNiNkNpNqNsN}N~ODOEOGOHOIOKONO]O^O_"},
  {0,NULL,"O`OdOiO{P?P@PAPLPNPQPWPXPaPbPfPiPuPvPxPyPzQBQEQFQLQQQVQXQZQ^QbQdQ"},
  {0,NULL,"mQrQtQyQ{RARFRHRMRRRSRZR\\RbReRhRiRoRtS?S@SASQSRSSSUSZS]SlSxSySzS{"},
  {0,NULL,"S|T?T@TETKTNTPTTT\\ThTjTkToTqTsTzUGUHUJUNURUZU]UcUdUfUlUnUtUvVBVGV"},
  {0,NULL,"IVJVPVUVVVYV]V`VcVeVkVpVvV~WDWKWOWPWSWUWWWZW\\WcWjWpWvW|X?XBXFXL_C"},
  {0,NULL,"?G?H?J?L?N?U?Z?d?n?p?q?t?v?y@@@B@E@H@J@M@W@Y@_@j@s@u@{@|A?AFAHAQA"},
  {0,NULL,"RAUA[A\\A]AcAhAjAmAqAsAvAzB@BGBNBRBTBVB[B`BfBhBiBmBpB{B|CKCLCRCTCX"},
  {0,NULL,"C[C\\C^CaCdCmCqCrCtCwCxD@DHDIDSDTDZD]D^DhDiDnDoDqD{D~EFELEXE_EdEnE"},
  {0,NULL,"pEyEzE}FAFDFIFPFQFRFTFUFVF`FhFjFmFnFqFsFyGDGIGLGMGZG[G\\GfGhGpGsGt"},
  {0,NULL,"GuGwGyG{HGHNHSHWHYH\\HaHbHdHpHqHuHvHxH{IBIFIGINITIUI]IbIhIjIlInIvJ"},
  {0,NULL,"?JBJDJEJYJ^JdJeJgJjJmJrJuJyJ{KCKDKGKRKSKTKUKVK`KbKcKjKwKzLJLLLVLX"},
  {0,NULL,"L\\LdLgLnLoMKMLMSMaMdMeMpMtMuMvMyM|N?N@NENFNHNJNLNMNPNQNSNTNXNZN[N"},
  {0,NULL,"]NaNdNvNwN|O?O@OAOEOGOHOXOZO[O]O^OaOpOqOvOyO{O|O}PFPIPQPRPSPUP\\P_"},
  {0,NULL,"PkPqPrPsPwP|Q?QBQPQQQRQUQXQYQ_QdQjQnQpQtQxQzRARBRIRJRMRXRYR[RbRjR"},
  {0,NULL,"mRqRuRvRwR}R~SUS\\S_SaScSeSjSlSvSyS|S}TBTDTHTITSTTTUTZT\\T]TnTsTwT{"},
  {0,NULL,"UFUKUOUSUVUZU\\U^U`UbUeUjUkUoUtV?VBVLVNVOVUVWV[V\\VaVdVfVkVlVoVwWEW"},
  {0,NULL,"IWLWOWQWTWXW[W]WcWeWiWqW~XEXFXJXN_C?E?I?J?K?M?Y?a?c?j?o?r?s?u?y?{"},
  {0,NULL,"?}@E@J@K@M@Z@[@\\@l@p@w@~ABAEAIAJANAOAQAUAWAaAbAjAkAnAsAuAvA{BDBLB"},
  {0,NULL,"NBQBXB]B`BcBfBjBlBmBxB{B|C@CFCGCMCWC[CbCcCfCjClCtCuCvC{C|DCDGDLDW"},
  {0,NULL,"DXD[D\\D^DaDbDkDlDrDwE@EAEMEXE^EfErEtEuE~F@FBFEFLFQFSFUFXF[F^FcFdF"},
  {0,NULL,"jFlFnFwFyF~GHGLGRGXGYGZG^GaGcGdGlGnGrGuH?H@HDHHHRHSHWHXHYH_HaHmHn"},
  {0,NULL,"HuHyH|I?IKILIOIPIRISI]I_I`IaIgIoIqIxI}JDJSJXJ]J_JfJkJlJmJoJwJzJ|K"},
  {0,NULL,"BKDKEKIKOKZK[K\\KiKkKqKtKxLBLHLKLOLPL]L`LeLgLqM?MDMLM]McMeMqMuMyMz"},
  {0,NULL,"M{M~N?NANENFNGNHNINLNQNRNSNTNYNZN[NbNjNmNvNwNxN~O?OCOEOIOJOROSOVO"},
  {0,NULL,"\\O]O_OdOhOrO{PBPCPDPEPKPQPYP`PcPdPePgPhPjPpPtP{QBQDQJQNQQQSQXQ[Q\\"},
  {0,NULL,"QdQhQkQtQvR@RARCRDRGRLRMRPRURVRaRbRdRgRkRsS?S@SASUSWSYS[S`SfSkSlS"},
  {0,NULL,"wSyS|S~T?T@TBTFTKTMTVT]TcTdTgTwT|U?UBUGUHUIUNUOUWUXUcUdUfUkUqUrUu"},
  {0,NULL,"UwU{V?VEVQVVVWVXVZV^V_VbVlVtVxV}WFWHWJWPWQWRWVWYW^W`WeWnWuWzX?XCX"},
  {0,NULL,"EXS_D?G?I?M?N?P?S?\\?_?h?j?l?m?p?w?|@E@J@M@P@T@X@b@c@f@o@q@zA?A@AB"},
  {0,NULL,"ADAGARASAXA\\AbAcAeAjAsAvAxB?BCBFBIBOBQBVBYB[BbBjBlBpBtBxB~CFCICJC"},
  {0,NULL,"KCNCRCUCZC\\CgChCiCnCrCwCzC{D?DDDLDPDSDWDeDgDhDjDlDqDuDxEAEJEQEVEY"},
  {0,NULL,"EbEkEoEvEwEyE{E~FCFGFIFMFPFSFTFaFjFnFyF{F|GAGCGEGIGKGQGYG\\G]GhGkG"},
  {0,NULL,"qGvGxG|H?HBHEHFHGHJHNHQHRHXH_HbHjHlHnHpHxH~I@IFIMIOIRIYI[I^IdIgIh"},
  {0,NULL,"InIrIxJCJGJNJPJ\\J_J`JbJdJiJnJoJrJ{K?KCK`KdKeKlKsKuKzK}LCLILMLTLXL"},
  {0,NULL,"aLcLeLoLtLyM?MFMGMSMWM]MaMgMnMoMqMrMzM{M}M~N?NANCNDNHNRNSNTNUNVNX"},
  {0,NULL,"N\\N`NaNfNjNsNxN~O@OCOHOKOMOUOYObOdOgOjOnOoOpOvOwPAPBPFPHPIPNPPPRP"},
  {0,NULL,"TPYP_PbPfPgPpPrPuQAQGQQQSQTQXQ[QcQfQlQsQwQ|RARCRSRTRXRYR]R^RfRhRm"},
  {0,NULL,"RnRpRqRyS?S@SASDSESRSXS^S_SaSdShSiSrSxSzS{T@TBTHTSTWTYT[TbTdTeTjT"},
  {0,NULL,"uTvTzT}T~U?U@UGUOUVU^U`UbUcUkUyV@VAVDVEVFVIVSVUV`VbVgVlVoVvVzV{V~"},
  {0,NULL,"WCWEWGWOWWWYWaWbWdWeWiWpWvWyW~XBXCXDXHXJXKXMXSXTXU_F?G?I?L?M?P?Q?"},
  {0,NULL,"]?`?g?i?l?m?o?v@A@E@H@O@Q@V@W@Z@\\@g@n@v@|@}A@ACAEAIAOAPASAUA[A]Ag"},
  {0,NULL,"AjAqAyA~B@BDBJBLBNBRBWBZB_BeBmBsBxByB}CCCGCHCJCLCNCOCTCVCbCdCiCjC"},
  {0,NULL,"nCoCqC{D@DCDEDKDSDUD\\D_DbDgDiDjDoDrDxEBEHEIESEYEaElEqExE{E}F?F@FE"},
  {0,NULL,"FGFQFRFVFXFZFgFjFmFqFrFwF}F~GFGJGLGNGPG[G_GeGkGlGrGtGyGzG{H@HAHFH"},
  {0,NULL,"JHPHRHTHYHfHhHjHkHmHqH{H|H~IFIHIJIKIYIeIgIjIlIoIpIrIyJIJJJMJPJ[J^"},
  {0,NULL,"J`JcJfJkJmJnJuJyJ|J~K]KfKjKkKqKvKwKxK|LHLOLPLQLSLVLiLkLoLsL~MJMMM"},
  {0,NULL,"SMYM\\MaMfMmMnMqMrMsMxM{M}N@NCNDNGNJNNNONPNQNVNWN[N^NdNkNnNuNwOBOC"},
  {0,NULL,"OFOIOKONORO[O_OaOfOjOlOoOqOsOwO|O}P?PBPKPMPPPSPUP[P`PbPePiPrPvP{Q"},
  {0,NULL,"@QBQEQIQKQWQ]QbQdQiQrQtQ}R?RERGRKRTRWRXRYRfRgRlRmRqRrR|S?S@SASMSN"},
  {0,NULL,"STSXSYS_SaSbShSiSkSrSwS~T@TDTTTUTXT^T_T`TdTjTlTpTtTxTzU?UCUDUGUSU"},
  {0,NULL,"ZU\\UcUjUoUtU|U}U~VCVEVIVKVTVWVXV]VkVmVrVtVwV|V}W?WEWNWQWRWUWcWfWk"},
  {0,NULL,"WnWqWtWuWxW~XBXCXHXLXMXNXPXRXUXV_D?F?H?L?O?P?R?`?a?g?i?k?m?t?z?~@"},
  {0,NULL,"@@L@M@N@X@_@b@d@e@v@w@z@|@~ABADAIAMAVAZA\\A^AaAdAmAtAvBCBEBFBGBMBP"},
  {0,NULL,"BXBZB[B`BdBmBtBvB{B|C?CBCDCICLCOCPCUCWC]CbCgClCnCrCsCtCvCxC{DKDMD"},
  {0,NULL,"ODQD_DaDeDlDmDrDuDyE@ELESEWE^E`EqErEuEvEwE}E~FEFIFKFOFWF[F]F`FeFp"},
  {0,NULL,"FsFvFyG?GAGCGPGRGWGZG\\G`GdGjGnGrGvGyGzG|G}HCHEHKHLHQHSHYH]HaHkHlH"},
  {0,NULL,"nHoHyH|I@IEIJIQIWIYI\\I]IaIbIgInItI}JEJIJOJXJ\\J]J^J_JbJkJtJvJwJxJ{"},
  {0,NULL,"KAKcKdKhKpKtKuL?LGLKLLLMLRL[L]LdLfLvLwLyMGMOMQMRMVMWMhMjMmMnMpMrM"},
  {0,NULL,"tMvMxMyN?NCNENGNINJNKNMNPNQNXNZN^NbNhNlNsNwN}O?OEOJOQOROUOVO`ObOc"},
  {0,NULL,"OmOnOqOsOtOwOyOzO{PBPEPIPTPYPZP[P`PcPfPiPlPnPyQ?QFQMQSQVQ[Q^Q_QeQ"},
  {0,NULL,"mQuQyQzRCRFRKRLRORWRXR[RcRlRmRrRsRvRxS?S@SASBSCSTSVSaSbSeSfShSiSj"},
  {0,NULL,"SrSvS}T?TLTNTUTWTYTcTfTgThTnToTvT{T|T~UAUBUHULU\\U]UfUhUjUvUwUyUzU"},
  {0,NULL,"{VAVGVNVSV]V_VaVhVmVqVrVvVyV{W@WEWGWUWVWXW_WbWfWgWkWpWrW}W~X?X@XF"},
  {0,NULL,"XGXJXMXNXOXQXVXW_E?F?I?K?M?P?S?d?e?h?i?j?l?s?x@A@F@G@N@U@[@_@a@d@"},
  {0,NULL,"f@s@t@|@}@~A@ADAGAMAQARAXAbAcAgAoApA{A|BEBGBHBMBNBRBZB\\B]BeBgBhBk"},
  {0,NULL,"BuB{C?CACHCKCMCSCTCUCWCXCYC^CeCnCsCtCwC|DBDEDNDTDXDZDiDkDmDqDrDtD"},
  {0,NULL,"uD{D|EPEUEZE_EbEiEnEuEvExE{E}FCFKFMFPFSFTFUF_FgFoFsFvFzG?GBGHGLGO"},
  {0,NULL,"GPGXG[G_GbGfGmGnGsG{G|HAHCHGHHHIHOHSHVH`HdHeHlHoHqHtHxH|I?IDIGIPI"},
  {0,NULL,"TIYI\\I]I`IcIhIpIvIwJFJLJQJYJ\\J]J^J`JcJiJoJrJxK?KCKDKdKeKlKnKsKuKy"},
  {0,NULL,"K}LCLILMLTLWLaLcLfLnLzL|M@MHMKMRMVMbMdMkMoMpMqMrMsMuM}M~N@NANBNDN"},
  {0,NULL,"GNKNLNONSNTNYN[N^NdNeNnNoNrO?OAODOGOLOTOVOZOaObOfOiOkOmOpOrOwOzO{"},
  {0,NULL,"PDPFPJPMPSPTPZP_P`PaPdPhPmPqPsQBQCQIQUQVQ`QdQiQmQnQqQtQxR?RFRHRIR"},
  {0,NULL,"LRNRQRRR_R`ReRiRjRsRxSBSCSGSJSKSOSPSQSZS\\SfSjSmSnStSvS}TCTFTITJT["},
  {0,NULL,"T_TbTdTeTfTnTpTuT{T}U?U@UAUKUMUPUXUeUgUiUrUzU|V@VDVEVFVNVQVTV]V^V"},
  {0,NULL,"lVmVpVtV{V|V}W@WFWJWNWUW^WbWeWfWjWnWtWuWzW}X?X@XCXDXHXIXLXPXRXUXY"},
  {0,NULL,"_E?G?J?K?M?N?R?_?d?h?j?l?n?q?y@C@D@L@Q@R@S@V@Z@^@e@q@s@|@}A?A@ABA"},
  {0,NULL,"HAMAQARASA\\AcAfAiAtAyA}A~BABKBLBPBSBUBWB`BcBiBnBqBrByCBCDCFCLCOCP"},
  {0,NULL,"CSCUC`CaCcCfCjCnCoCqCvDADBDDDGDMDODVD_DdDfDjDkDoDuDzECEMEWE[E^E`E"},
  {0,NULL,"kEnExEyE{E}E~FAFGFIFKFPFTFUFbFiFpFrFuFwFxF}GGGJGSGUGWGZG^GaGcGiGl"},
  {0,NULL,"GpGyGzG|G}H?HKHLHOHUH[H\\HcHfHiHkHlHsH{H~I?IEIIILIWIYIaIcIdIeIjImI"},
  {0,NULL,"uIzJOJSJTJXJ^J_J`JcJdJgJnJrJxJ{KCKDK`KcKkKlKnKxKyKzLCLLLPLWLXLaLd"},
  {0,NULL,"LnLoLtL|MFMHMKMSMaMbMdMgMmMnMoMpMtMuMwMzN?N@NHNKNLNONRNSNTNUNWNZN"},
  {0,NULL,"_NgNhNmNqNuNyN{N|OIOPOSOXO\\O`ObOcOdOkOqOsOtOwO|O~P?PEPJPNPOPTPUPW"},
  {0,NULL,"P[PbPdPlPnPtPxQ?QDQEQJQPQ\\Q_QbQjQkQpQrQzR@RDRJRKRMRORUR\\RbRcRkRoR"},
  {0,NULL,"rRuRzR{R|SFSMSNSTSUSVS[S]ScSkSoSqSsSwS~T?TETNTOT[T`TbTcTdTeTiTuTy"},
  {0,NULL,"T|T}U?U@UCUHUQURU]UfUmUnUvUwU}V@VDVEVFVHVRVXVYV\\VjVkVnVuV{V|V~W?W"},
  {0,NULL,"DWIWMWRWSWbWcWhWoWsWtWvWxW|XAXCXDXEXFXIXQXRXSXTXXXY_D?E?J?K?N?O?Q"},
  {0,NULL,"?b?c?f?j?k?n?r?u@B@D@H@N@P@T@_@c@d@g@p@y@{@|@~ACADAKAPAUAYA^A_AcA"},
  {0,NULL,"hAiAqAxB?BEBGBIBMBNBXB^B_BaBbBhBlBpBqBtCACCCGCJCLCOCRCTC_CaCeClCm"},
  {0,NULL,"CnCpCsCtC}DADCDFDSDVD\\D_DaDeDiDkDpDtDzE?EIEMEREYEaEjEtEuEvEzE}F?F"},
  {0,NULL,"FFQFTFWFYFZF\\FhFiFmFsFvF{F|G?GEGLGNGRGTGVG]GbGdGgGpGwGyGzG{H@HFHI"},
  {0,NULL,"HNHPHQHXHbHcHdHkHqHrHtHyI?I@IAIFIIIKIYI\\I]IfIiImIoIuI|JHJMJPJSJ[J"},
  {0,NULL,"\\J]J^JeJhJmJpJvJ}J~KCK^KeKhKjKoKwK}L?L@LELRLTLVLYL^LlLnLwLxMAMKMP"},
  {0,NULL,"MQM_MdMiMjMmMnMoMqMwMzM{M|NANBNENFNHNINNNRNUNVN[NbNcNfNiNkNsNxN{O"},
  {0,NULL,"@OAOJOOOTOXO^O_OaOiOlOoOqOsOvOwOxOzO{O~P@PKPSPVP[PaPcPdPfPoPrPxP{"},
  {0,NULL,"QCQFQGQKQNQ]Q^Q`QfQhQqQvQyQ|RERIRKRMRYR\\R^RbRjRnRoRqRrRxRzR{SBSCS"},
  {0,NULL,"FSTSUS\\S]S_SdSjSoSqSsSvS}T@TKTOTTTYT]T_TaTbTgTiTpTrTwTyT}T~UBUGUN"},
  {0,NULL,"UQUZUcUdUmUtUyU{U|V?VDVHVMVQVVV[VaVhViVlVpVvVwVxW@WDWPWTWXW^W`WeW"},
  {0,NULL,"gWjWmWpWqW|W}XAXBXEXGXIXKXOXSXTXUXXXYXZ_D?G?I?M?N?P?S?\\?_?h?j?l?m"},
  {0,NULL,"?p?w?|@E@J@M@P@T@X@b@c@f@o@q@{@}@~ACAEAHALANAVAWAYA`AeAjAsAvAxB?B"},
  {0,NULL,"CBFBIBWBZB\\B]B_BeBjBlBrBwBzC@CDCFCICMCNCRCTCZC]CfCgClCnCpCyCzC|D@"},
  {0,NULL,"DADIDOD[D]DaDfDhDiDoDpDqD{EGEOEWE\\E]EbEkEoEuExEzF?F@FAFJFLFNFOF\\F"},
  {0,NULL,"^FaFjFnFyF{F|GAGCGEGJGNGOGPGXG_GcGdGjGqGvG{G}H?HDHEHHHJHNHXH[H^H_"},
  {0,NULL,"HgHiHpHqHrHxHyH{IBIEISIUIYIZI^I`IfIlImIvI{JOJUJWJZJ[J]JcJeJfJgJpJ"},
  {0,NULL,"qJtJzK@KBK^KbKiKpKrK{L@LBLGLJL[L\\L^L`LbLjLlLpLqMAMCMDMIMXM^M_McMm"},
  {0,NULL,"MoMpMrMsMuMvMxN?N@NDNFNJNKNMNPNSNUNWNYN^NeNkNnNpNqNtNxN~OJOQOUOYO"},
  {0,NULL,"\\OaOcOdOhOjOnOrOvOwO}O~P@PAPDPLPOPRPSPUPVP_PcPjPkPnP|Q@QCQIQUQVQW"},
  {0,NULL,"Q`QiQmQnQqQxQ}R?RFRMRORPRURZR[RbRcRdRkRtRvRzR{SFSHSISLSSSUSVSWS[S"},
  {0,NULL,"eSlSoSqSsSyS|T?TATGTQTZT^T_TgTkTmTnTpTqTxT{UBUEUFUHUUUYU[U_UaUfUs"},
  {0,NULL,"UxU{U|VCVJVLVNVPVWVXV[VhViVmVtVuV|V}WAWDWKWQWRWTWfWgWmWnWoWtWuWwW"},
  {0,NULL,"|X?XAXBXDXFXHXMXNXPXVX\\_E?G?H?L?M?O?R?Z?]?g?i?m?n?q?y?{@?@K@P@T@U"},
  {0,NULL,"@[@a@c@e@n@u@z@{@~AAACAIAMATAVAZA\\A_AkAlAuAxA{A|B?BHBIBSBTBUBVBaB"},
  {0,NULL,"eBgBhBrBuByC@CBCCCECFCKCOCSCZC`CaChCiCsCxCyCzC}D@DCDHDUDWDXD^DaDb"},
  {0,NULL,"DiDlDpDsDwECEHEJETE_E`ElEpEuEwEzE|F?FEFHFIFKFOFYF]FdFfFlFzF{F|GBG"},
  {0,NULL,"EGHGIGMGSGTGUG_GiGkGpGqGxGzG~H?HDHGHKHOHPHVH[HdHeHfHmHnHqHrHuHyH}"},
  {0,NULL,"IHINIOIPIZI\\I^IbIiIlIoIqIzJJJKJNJYJ[J]JaJbJeJkJsJtJxJ{J}KAK_KdKhK"},
  {0,NULL,"pKtKuL?LALGLKLMLRL[L]L_LhLjLuLxL}MIMNMPMXMZM[MiMnMpMqMrMtMyM}M~NC"},
  {0,NULL,"NGNHNLNONPNQNRNSNTN]N_NaNcNgNnNoNqNrNuOAOKOMOPOXOYOdOeOhOkOlOpOsO"},
  {0,NULL,"tOxOyOzO}PAPKPLPQPSPVPXPYPcPePgPhPvPwQLQNQOQTQUQZQgQhQlQnQoQvQwQx"},
  {0,NULL,"Q{RGRHRPRQRTRYR`RdRfRgRiRqRzR{R|SFSMSNSPSWSXSYSZS_SkSoSqSsSwS~TDT"},
  {0,NULL,"HTJTPTWT]TbTcThTmTnToTvTwT{T|T}UEUJUMUSU^UbUgUlUoUwUxV?VAVDVGVNVV"},
  {0,NULL,"VWVeVfVkVmVoVpVsVuVvW?WDWPWQW\\W]WcWfWiWjWlWoWpWxW|X@XCXDXFXJXKXLX"},
  {0,NULL,"QXRXSX\\X]_E?G?J?K?M?N?R?_?d?h?j?l?n?q?y@C@D@L@Q@R@S@V@Z@^@e@q@s@z"},
  {0,NULL,"@{@~AAACAGALANAVAWAZA[AfAiAtAyA}A~BABKBLBNBTBXBaBbBdBgBiBsBxByC?C"},
  {0,NULL,"DCGCICLCPCQCUCXC`CcChCkCoCpCrCtC|C~DDDKDLDQDZDcDeDfDhDkDnDrDvEEEL"},
  {0,NULL,"ESEUEVE`EkEnEuEwEzE|F?FCFLFNFOFRF]F^FbFiFpFrFuFwFxF}GGGLGMGRGTG]G"},
  {0,NULL,"`GaGiGoGsGxGyG|G}H@HCHEHLHMHRHTHVH\\HfHiHpHvHzH|I?I@IJIQIRITI]I`Id"},
  {0,NULL,"IeIfIkInIsJAJCJEJIJLJ[J]JaJbJeJiJqJtJyJzKAKBK]K_KgKpKrK{K|K~LALGL"},
  {0,NULL,"SLUL[L_LbLhLjLmLpL}MBMCMIMXM[M^M`MnMpMqMrMsMyM{M|N@NANDNFNNNPNQNS"},
  {0,NULL,"NTNUN[N]NbNcNfNlNoNuN|OBOCOMOPOSOWOZO_O`ObOcOmOnOqOuO{P?P@PDPGPIP"},
  {0,NULL,"NPOPRP\\P^P`PdPfPiPpPqPyQKQLQMQNQRQYQZQ]QeQhQuQvQ{RBRERLRQRRRSRTRX"},
  {0,NULL,"R`ReRfRhRmRsRySDSESGSJSKSPSQSRSXSaSfSmSnStSxSzS{TFTLTSTUTZT\\T^TaT"},
  {0,NULL,"gTkTlTqTrTsTxUBUDUFULUVUXU\\U`UhUjUrU{VBVCVJVKVLVMVQVUVVVfVgViVlVq"},
  {0,NULL,"VtVwVxWCWFWOWPW]W^W_W`WdWeWmWnWqWyWzXAXBXEXKXLXNXOXPXRXSXY_D?G?H?"},
  {0,NULL,"L?N?O?S?^?c?f?k?m?n?p?w?~@?@G@O@R@S@W@\\@^@f@p@r@zA?A@ABADAKANAOAR"},
  {0,NULL,"ATA`AbAdAlApA}B@BABDBJBKBOBXBZB[B\\B`BlBsBwBxByC?C@CACDCHCMCSCTCZC"},
  {0,NULL,"[C\\CfCmCqCsCuCvC}C~DBDJDXDZD\\D^D_D`DdDkDmDsDwEGEIEUEXE_EbEmEtEvEw"},
  {0,NULL,"EyE{E~FFFHFJFPFSFXF^FeFfFoFqFuFxF~GFGGGOGPGQGRGZG\\GcGhGqGuGwG{G}H"},
  {0,NULL,"AHCHDHHHIHOHRHTHXH^HfHkHoHsHuHwH}I?IKIPITIXI\\I_IaIcIiIjIkIqI{JDJL"},
  {0,NULL,"JMJYJ\\J_J`JbJdJhJoJrJsJ|K@KBK`KaKfKgKsKvKzK~LFLILQLULXLZLcLeLtLuL"},
  {0,NULL,"{M?MFMNMTMZM]MgMlMnMoMqMrMxMyM|M}NDNENFNJNMNNNPNRNSNVNXNZN^N`NbNe"},
  {0,NULL,"NtNuNxOBOCOHOYO\\O]O^OaOcOfOhOiOkOmOrOxOzO|PCPEPGPJPQPWPXPZP[P]PdP"},
  {0,NULL,"hPqP{P~QAQBQMQPQSQ[QcQdQeQjQpQsQtQuRCRGRIRQRSRYR\\R`RgRhRjRoRqRzR{"},
  {0,NULL,"SFSHSISLSPSRSYS\\S]S_SlSoSqSsSyS|TFTJTRTTTXTZT\\T`TcTfTmTsTtT|UAUCU"},
  {0,NULL,"EUFUMUTUXUZUgUpUrUtUwUxUzU}U~VBVLVRVSV`VaVhVnVqVrVxVyV|WAWDWGWMWW"},
  {0,NULL,"WXW_W`WgWhWkWrWtWwW|X@XAXBXFXJXKXLXMXNXVXZX[_F?G?J?K?L?N?Q?[?^?f?"},
  {0,NULL,"k?l?n?o?v?}@C@I@M@U@X@[@a@b@g@r@x@|@}A@ACAEAKALAPAUAXA^A_AfAnArAv"},
  {0,NULL,"A{A|BCBFBHBRBUBWBYB`BcBmBsBzB{B|B~CACBCECMCPCQCRCVCYCZChCiCtCuCyC"},
  {0,NULL,"|D?DADBDHDJDPDQDcDdDfDmDpDqDtDvEDELEQETEXEaEmEsExE{E}F?F@FFFMFNFQ"},
  {0,NULL,"FWFYFZFbFcFkFyFzGAGBGCGHGJGKGSGZG[G^GeGkGmGqGxG~HBHHHIHKHLHMHNHSH"},
  {0,NULL,"THYHaHgHiHoHrHsHtHxHzIMINIQIXIZI[I]I_I`IcImIsJ@JDJEJGJKJ[J^J`JcJf"},
  {0,NULL,"JhJmJqJvJ}J~K?K^KeKhKjKqKwK}L?L@LHLOLRLTLVL^LiLpLsLzL~M@MCMMM\\M^M"},
  {0,NULL,"fMkMmMnMqMrMtMyMzM{N?NCNENLNMNNNQNRNTNVNWNZN\\N_NdNmNpNwO?OBOEOKOL"},
  {0,NULL,"OMONOYO`OeOgOiOrOtOuOvO{O~PCPDPHPJPLPOPVPWPZP^P_PaPuPwPyP~Q?QEQIQ"},
  {0,NULL,"OQQQXQ_QbQgQiQoQrQzR?RARGRQRSRVRXR[R`RaRgRhRmRvSGSHSISJSKSLSPSRSY"},
  {0,NULL,"S`SaSeSlSmSnStSyS|TBTLTPTRTYT[T]TaTiTkTnTqTrTuTwTyT{T~UJULUOUTUhU"},
  {0,NULL,"kUlUpUyV?V@VHVJVMVNVOVRVTVXVhVjVnVpVuVzV{WAWFWMWNWRW[WaWbWgWhWjWo"},
  {0,NULL,"WsWwWzXCXEXJXMXNXOXQXRXSXTXZX]_D?G?H?L?N?O?S?^?c?f?k?m?n?p?w?~@?@"},
  {0,NULL,"G@O@R@S@W@\\@^@f@p@r@{@}@~ACAEAJALAUAXAYA^AcAdAlApA}B@BABDBJBKBQBS"},
  {0,NULL,"BTBVB]BeBfBjBvBwBxB~C?CACHCJCKCSCUC\\CcCfCgCjCoCtCuCxC~DCDEDMDNDTD"},
  {0,NULL,"YD^D_DbDcDnDrDtDyEAENEPEZE^EbEmEtEuExEzF?F@FBFMFNFQFTFWF\\FeFfFoFq"},
  {0,NULL,"FuFxF~GFGGGIGMGUGXGYG_GaGcGhGlGvG|HAHBHCHFHGHIHOHRHWH]H^H_HkHmHtH"},
  {0,NULL,"uHvHzH|ICIDIGIWI]I_IbIeIkIoIpItIxJFJQJVJXJ[J]JcJeJfJlJmJpJqJvK?KC"},
  {0,NULL,"K^KnKoKqKrKyK{L@LELHLOLWLYL^LbLlLpLsLwMAMCMMMQM^M_MfMjMmMoMpMrMtM"},
  {0,NULL,"vMwM~N?NBNCNFNHNLNMNRNUNVNYN]NaNgNjNnNtNvN}N~OCOHOIOSOUO\\ObOfOgOi"},
  {0,NULL,"OkOmOoOpOyO{P?PCPGPKPMPQP[P\\P^P`PaPePlPmPsPzQ@QDQHQLQUQWQZQaQkQnQ"},
  {0,NULL,"xQ{Q}Q~R@RJRLRNRORWRZR_RcRlRsRtRuRyS?S@SASDSESOSSSVSbScSfShSiSrSx"},
  {0,NULL,"SzS{TCTITMTNTYT]TaTdThTiTlToTrTwTyT~U?UDUKUPUWU]UeUiUqUvUyV?VEVGV"},
  {0,NULL,"HVKVMVPVWVcVfVgVjVkVoVpVsVwWCWEWKWQWZW]WcWdWiWjWlWqWsWyW~XDXFXGXH"},
  {0,NULL,"XJXKXQXSXTXVXXXZX__E?F?H?K?L?O?S?[?b?f?i?k?n?s?x?{@@@J@Q@V@Y@Z@]@"},
  {0,NULL,"`@f@x@y@z@{A?AAAEAKANARA]A`AaAbAkAmAsAwAyAzA~BBBLBQBUBVB]BaBeBiBk"},
  {0,NULL,"BnBqB{CFCICKCMCNCRCTCUCVCXCbCdCeCpCrCvCyC~D?DCDODPDSD[D^D`DaDcDeD"},
  {0,NULL,"fDgDyD|EQEWEYE]EbEjEsEwEyEzE|F@FFFJFPFSFVF[F^F`FdFnFrFtFwF}G@GDGI"},
  {0,NULL,"GSGTGXGYG_GbGeGrGsGtG{G|H?HEHGHHHJHNHSHUH\\H`HcHiHjHuHwHyHzI@IEIFI"},
  {0,NULL,"MISIZI[IaIfIkInIoItIwJGJOJPJWJaJbJdJeJfJhJoJrJuJwK@KBK`KaKfKgKiKv"},
  {0,NULL,"KzK~LBLFLQLULXLZL`LgLmLrLvMBMEMLMOMUM`MeMhMmMnMoMrMtMwMxM}N@NBNEN"},
  {0,NULL,"GNKNLNNNONRNVNYN_NaNcNjNnNyN{N|O?ODONOROTOZO[OaObOdOjOnOpOrOvP@PE"},
  {0,NULL,"PGPHPIPKPLPOPPPQP]P^PcPfPjPnPrPuQ@QDQHQLQTQWQZQaQkQlQwQ{Q}Q~R@RKR"},
  {0,NULL,"MRVRXR[R^RaRbRmRnRrRvRxSBSCSGSJSKSTSUS`SaSdSeSjSmSnStSvS}T?T@TATB"},
  {0,NULL,"T\\T`TeTfThTlTmToTsU@UAUCUDUEUGUHUOUYUcUfUkUsUxUzU}VBVFVGVKVOVVVdV"},
  {0,NULL,"eVkVnVoVpVsVtVxW@WFWLWPW[W\\W`WcWhWiWjWlWnWzW}X@XCXFXGXIXLXQXRXUXV"},
  {0,NULL,"XWX]X__E?G?H?L?M?O?R?Z?]?g?i?m?n?q?y?{@?@K@P@T@U@[@a@c@e@n@u@|@}A"},
  {0,NULL,"?A@ABAFAQASAUAWA[A]AkAlAuAxA{A|B?BHBIBOBPBXB\\B`BdBgBiBjBrBzC?C@CC"},
  {0,NULL,"CECGCICKCQC_CaCcCeChCsCuCwCyC{D?DEDFDRDYD[D`DbDgDlDmDqDtDyEEEKENE"},
  {0,NULL,"RE]E`ElEpExEyE{E}E~FDFGFLFQFRFUFVFdFfFlFzF{F|GBGEGHGOGQGRGWGZG`Ga"},
  {0,NULL,"GbGgGpGxG~H@HCHDHEHGHMHPHVH[H\\H_HgHjHmHnHoHtHwHxIAICISIVIZI[I\\I_I"},
  {0,NULL,"gIhIpItJAJHJRJVJWJ^J_J`JcJdJjJmJnJuJyJzKDKbKjKkKlKmKwKxLCLDLJLNLP"},
  {0,NULL,"LVL\\LaLgLoLsL|MHMLMMMSMaMbMeMfMmMnMoMpMvMwMxM|N@NFNHNINJNNNONPNQN"},
  {0,NULL,"UNZN`NbNeNhNlNoNpNqN|N~OMOOOSOTOXO_OeOhOlOmOnOpOuOzPBPCPFPHPLPMPP"},
  {0,NULL,"PYPZP]P_PaPePjPoPzP}Q?QFQPQSQVQ[Q^Q_QjQmQpQyQzRCRFRJRMRNRVRZR^R_R"},
  {0,NULL,"aRbRnRtRuRySDSESGSJSKSOSSSUS`ScSdSmSnStSxSzS{TATKTMTVTXTYT_TfTjTk"},
  {0,NULL,"TlTpTqTtTzT~UAUDUIUNUWUYUdUqUsUuUyUzU|U~VIVJVKVRV\\V^V`VhVlVqVrVyV"},
  {0,NULL,"zV}WCWFWIWJWMWWW_WaWeWgWkWrWuWyWzXAXBXEXFXGXKXLXPXQXVXWXZXa_D?F?H"},
  {0,NULL,"?L?O?P?R?`?a?g?i?k?m?t?z?~@@@L@M@N@X@_@b@d@e@v@w@}A?AAACAEAFAOAPA"},
  {0,NULL,"QASAWA[AdAmAtAvBCBEBFBGBMBQBSBTBUB]BaBlBoBpBtB|CDCFCGCLCPCQCSCUCW"},
  {0,NULL,"CYC[C]C^CqCxCyC{C|C~DADGDLDVDZDaDbDcDdDhDmDoDwD}EMEUEVE[E`EqErExE"},
  {0,NULL,"yE|F?F@FDFGFLFRFUFXFZF`FeFpFsFvFyG?GAGCGMGSGTGUGXGYGfGjGmGnGuGyG|"},
  {0,NULL,"G}H?H@HLHMHOHQHXHZHaHbHmHoHpHsHyHzH{IIILIRITIZI`IbIgIjIkImIqI~JCJ"},
  {0,NULL,"LJSJTJ[JaJcJdJfJjJnJyJzJ|J~KDK]KbKjKlKmKwK|LCLDLJLNLSLVL\\LaLiLkLq"},
  {0,NULL,"L{L~MDMJMTMYM\\McMlMnMoMpMqMwM|M}M~NANBNCNDNGNHNINJNONVNYN]N_NcNgN"},
  {0,NULL,"jNsNxNzO@OEOGOLOQOVO]O_O`ObOcOdOkOqOuOyO|O~PBPDPGPLPRPUPWPZP^PcPe"},
  {0,NULL,"PpPqPtPxQDQNQOQTQUQgQhQkQlQnQoQvQwQxR@RIRRRSRUR\\R]ReRhRjRkRoRpRwR"},
  {0,NULL,"}R~SHSISLSQSRS[S\\S]S^SgSlSpSuSyS|TETFTOTSTXT[T]T_TjTlTmTpTtTuTwTz"},
  {0,NULL,"UDUEUQURUVUXU`UmUnUrUxU|U~V?V@VIVKVOVPVcVdViVkVoVpVsVzV}WAWBWKWLW"},
  {0,NULL,"ZW[WaWcWiWjWlWmWuWwW{X@XGXHXIXJXKXLXTXUXVX[X]X_Xa_D?F?J?K?N?P?R?\\"},
  {0,NULL,"?e?h?j?k?l?t?z?}@B@K@O@W@Y@\\@]@`@e@o@t@z@|@~ABADAHAMAQASAXA\\AbAhA"},
  {0,NULL,"nAuAwAzB@BBBDBJBTBXB^B_BaBdBfBoBvBwB|C@CCCECFCGCKCQCSCVC[C]CbCdCp"},
  {0,NULL,"CuCwC}D@DBDDDHDUDYD[D`DjDkDnDpDqDsDvD}EHENETE]E`EiEoEuEvEwE}E~FAF"},
  {0,NULL,"GFIFKFMFSFUFcFhFlFqFtF~G@GDGFGMGNGRGTGVG`GeGjGrGtGuG~H?H@HDHGHMHO"},
  {0,NULL,"HPHWHZH]H^HaHrHvHwHxH}H~I?ICIHINISI_IcIdIfIhIiIlIsI~JJJKJVJWJ\\J]J"},
  {0,NULL,"^J_JbJgJnJoJxJ{K?KDK`KcKdKkKnKuKxKyKzLLLMLPLWLXLdLeLfLyLzM?M@MGMR"},
  {0,NULL,"MVMWM]MkMmMnMpMrMsMtMwM{N?N@NANBNCNDNGNKNUNVN]NbNcNiNkNlNtNvNzN}O"},
  {0,NULL,"EONOQORO[O]O_OdOeOhOkOlOpOuOxO}P@PCPFPJPNPVPXP\\P]P_PbPdPjPvPwPzQF"},
  {0,NULL,"QKQLQMQRQYQZQ]Q^QeQuQyQ{RBRERGRPRVRWRZR[RaRdRgRlRtRvRwR}R~SHSISLS"},
  {0,NULL,"SSWSYS`SbSeSgSlSpSuSyS|TATDTMTPTXT[T\\TaTbTdTeTrTsTtTuT}U?U@UJUSUW"},
  {0,NULL,"UYUlUoUqUsU~V@VBVDVEVFVMVZV[V_VaViVlVsVwVxV|V~WAWBWHWTWVWXW`WeWlW"},
  {0,NULL,"mWqWtWvWwW{XGXHXIXNXOXRXSXTXUXVX^X`Xd_D?E?I?M?O?P?Q?Z?a?g?i?j?m?r"},
  {0,NULL,"?u?|@F@I@R@S@Y@]@^@`@g@u@wA?A@AAABAEAIAOAPAQAUAWA]AeAoArAwAzA}BAB"},
  {0,NULL,"BBKBVBYB[B^BbBcBfBhBqBvBwB~CACBCCCLCMCQCRCXC`CkClCmCqCrCvCyCzDBDE"},
  {0,NULL,"DHDIDNDQD^DfDgDmDoDsDuD{E?ELEPETE\\EaEpErEyE{E|E~F@FEFLFQFUFVFXFZF"},
  {0,NULL,"_FaFkFtFuFxG@GDGGGIGKGVG\\G]G^GdGiGoGsGwGyHBHHHIHKHMHNHPHWH]H^HcHd"},
  {0,NULL,"HiHjHlHoHuH{H}IDINIQIUIZI^IaIcIjInIpIvI|JEJFJKJUJ_J`JaJdJfJkJmJuJ"},
  {0,NULL,"zJ|J~KDK]KfKkKmKqKvKxK|LDLHLNLOLPLQLSLgLqL{L|MDMHMLMTMbMcMeMlMmMp"},
  {0,NULL,"MqMrMsMvM{M~NANBNCNFNGNHNINPNQNUNXN\\NaNfNiNmNtNvN{N}OAOJOPOWOZO^O"},
  {0,NULL,"gOiOlOqOrOtOuOvO|PAPEPIPJPLPMPOPPPQPTPUPXPZPmPwPyP|QAQHQJQQQRQXQY"},
  {0,NULL,"Q\\QaQcQsQ~RARBRDRHRLRORPRQR[R`RcRdRiRsRvRxRzR{SBSCSFSPSVSWSZSeSfS"},
  {0,NULL,"jSoSqSsSvS}TGTITLTPTXTZT_TeTiTjTlTpTtTyTzU@UDUFUJUKULU[UaUeUhUlU|"},
  {0,NULL,"U~VFVHVIVKVLVSVYVbVeVgVkVrVvVxVzV~W@WDWGWSWYW\\W`WaWcWdWkWpWvW|W}X"},
  {0,NULL,"?XBXDXGXHXKXOXPXSXUX[X`XaXc_F?G?J?K?L?N?Q?[?^?f?k?l?n?o?v?}@C@I@M"},
  {0,NULL,"@U@X@[@a@b@g@r@x@z@{AAABADAJAOARATA]A`AaAfAnArAvA{A|BCBFBHBNBTB^B"},
  {0,NULL,"_BbBdBjBmBrBzB}B~CBCCCHCLCMCNCQCWCYC^CiCjCtCvCxCzC}D?DDDGDIDNDRD^"},
  {0,NULL,"DdDeDlDnDpDuDzEBEKEPE[E\\EaEmEsEvEwEzE|E~FBFHFJFPFVFXF[FbFcFkFyFzG"},
  {0,NULL,"AGBGCGHGLGMGNGVG]G`GfGkGlGmGnGyHAHBHHHJHKHMHPHYH[H_HgHhHlHnHrHsHu"},
  {0,NULL,"HvI@IDILIUIVI[I]I^IaIbIdIiIuIyJFJRJTJUJ\\J_JaJbJeJlJrJsJuJwJ|K@KaK"},
  {0,NULL,"iKmKsKtLBLDLFLILKLNLZL]L`LcLrLtLuLvMEMFMNMOMUMZMgMhMmMoMpMqMsMuMw"},
  {0,NULL,"M|N@NBNDNFNJNLNMNNNONVN[N]NfNiNkNlNpNqNwN~OFOGOIOKOLOVOfOgOjOlOqO"},
  {0,NULL,"rOtOuOxOyO{PAPEPHPNPQPTPVPWPYP\\PfPmPtP|P}QCQFQGQNQRQYQ^Q`QfQhQqQv"},
  {0,NULL,"QyQ|RBRHRJRNRORUR]R_RcRiRkRpRuR|S?S@SASMSNSOSVSZS[S^ScShSiSkSrSwS"},
  {0,NULL,"~TETGTITVT\\T`TbTfTgTjTmTsTzT}UAUBUCUEUIUKURU[UaUeUnUuUxUzU{U}VBVD"},
  {0,NULL,"VIVUVZV_VfViVlVmVoVwVxVyW?WEWHWOWVW]W`WeWfWiWmWqWrWxW~XAXEXHXIXLX"},
  {0,NULL,"NXPXRXTXVXWXYX^Xg_E?F?H?K?L?O?S?[?b?f?i?k?n?s?x?{@@@J@Q@V@Y@Z@]@`"},
  {0,NULL,"@f@x@y@|@}@~A@ADAJALAPAXAYA_AcAkAmAsAwAyAzA~BBBLBOBPBZB[B\\BdBkBnB"},
  {0,NULL,"oBuB}B~C@CDCFCICJCNCRCXC^C`CdCkCuCvC{D@DADCDDDIDLDWD]D_D`DcDjDlDo"},
  {0,NULL,"DpDwEFEJEOEVE\\EbEjEsEuEvExE{E}FBFMFNFTFYFZF\\F`FdFnFrFtFwF}G@GDGOG"},
  {0,NULL,"PGQGWG\\G`GfGiGoGsGtG}H?HBHDHEHFHJHNHUHZH`HeHhHkHnHrHwHzH{H~IBIOIR"},
  {0,NULL,"IUI_IaIdIgIlImIoIqJBJCJNJUJZJ\\J]J^J`JcJlJpJqJ}J~K?KCKeKnKoKqKrKyK"},
  {0,NULL,"{K}LELHLOLTLWLYLbLiLnLxLzL~M@MKMPM\\MdMiMkMoMpMqMrMvMyM|M~NANBNENF"},
  {0,NULL,"NINLNMNNNQNTNXN^N`NeNhNlNrNyNzODOFOGOPOWOZO[OcOdOgOhOjOnOoOvO}O~P"},
  {0,NULL,"BPCPEPKPNPUPVPYP[P]P^PbPgPkPpP|QAQBQMQPQVQcQdQeQjQmQpQsQtQuRFRHRP"},
  {0,NULL,"RRRTRUR]RdReRfRiRkRpRwR|R}R~SMSNSQSWSXSZS[S^SgSkSpSuSwS~TGTHTQTST"},
  {0,NULL,"XTYT]T^TaTcTiTrTtTwTxTyT|T~UUUVU[U^U_U`UaUbUwUyU~V?VCVHVMV\\V]V^V_"},
  {0,NULL,"VhVjVqVrVwVyV~W?WBWIWJWUWVW_WgWkWqWrWsWvWxW{X?X@XEXGXJXKXLXOXPXQX"},
  {0,NULL,"WXXX[X]Xf_F?G?I?L?M?P?Q?]?`?g?i?l?m?o?v@A@E@H@O@Q@V@W@Z@\\@g@n@v@z"},
  {0,NULL,"@{AAABADAFAMATAVA^A_AaAgAjAqAyA~B@BDBJBLBOBQBYB^BbBcBkBoBsBzB}CAC"},
  {0,NULL,"ECGCJCOCPCRCTCVCYCcCfCjCpCqCrCsCwC~D@DFDTDVD]D`DaDgDhDkDrDsD{EDEM"},
  {0,NULL,"EOEREZEaElEqEvEwEzE|E~FDFHFKFOFWFYF[FgFjFmFqFrFwF}F~GFGKGQGVGYG]G"},
  {0,NULL,"^GaGcGeGlGmGzG{G~H@HFHIHLHNHTHZH`HgHhHjHpHwHyH|H}I?IAIBIGIII\\IfIh"},
  {0,NULL,"IjIkIlInIvJ@JHJQJSJZJ\\J_JaJbJeJjJsJtJvJwJxJ}K_KaKcKoKtLALELFLKLLL"},
  {0,NULL,"YLZL]L_LdLfLjLuLvMIMNMOMRMVMXMZMhMmMoMpMqMuMvMzM~N?NCNHNINJNLNMNO"},
  {0,NULL,"NQNTN\\N`NfNiNjNmNpNzOBODOFOIOLONOSO\\O_O`OaOeOiOoOsOvOzO|O}P@PFPGP"},
  {0,NULL,"IPPPRPXP]P`PcPdPkPoPsPxQAQGQHQJQRQYQ\\QaQcQfQsQ|Q~RBRDRIRMRNRRRURZ"},
  {0,NULL,"R_RbReRjRkRtSGSHSISJSKSLSOSQSSSUS[S\\SlSmSnStSyS|TCTKTOTQTWTZTaTcT"},
  {0,NULL,"eThTnToTrTvT{T|U@UFUNUPUQUUU_UdUiUmUwVAVFVGVLVMVNVUVZV`VdVgVnVqVs"},
  {0,NULL,"VvVzV~WAWFWHWLWOWWW_WaWdWhWlWpWvWwWzX?XCXDXEXHXJXMXPXQXTX\\X_X`XcX"},
  {0,NULL,"f_D?F?J?K?N?P?R?\\?e?h?j?k?l?t?z?}@B@K@O@W@Y@\\@]@`@e@o@t@}A?AAACAE"},
  {0,NULL,"AGAVAWAYAZA[A`AhAnAuAwAzB@BBBDBJBPBRBSBUBYB`BkBoBtBvB}C?C@CBCCCEC"},
  {0,NULL,"ICKCOCWC[C\\CbCmCoCpCzD?DBDCDEDFDRDWDXD^DfDgDiDjDnDtDzE@EJEKERE_E`"},
  {0,NULL,"EiEoExEyE|F?F@FCFJFLFOFRF\\F]FcFhFlFqFtF~G@GDGFGKGSGUGWGZG[GhGnGrG"},
  {0,NULL,"uGwGzG~HCHDHEHGHKHPHQHZH]H`HhHiHjHqHtHuHvH~IAIOIPIVI[I^IcIeIfIoIp"},
  {0,NULL,"IuI}JHJNJRJYJ[JaJcJdJfJiJpJtJyJzK@KAK]K_KbKgKrK{K|K~LALJLSLUL\\L_L"},
  {0,NULL,"bLkLlLqLrMAMDMEMJMUMYM_McMnMoMpMqMuMyMzM|N?NANDNENINJNKNMNSNTNZN\\"},
  {0,NULL,"N_NdNgNhNsNzN}ODOFOHOROVO]O^OeOhOlOmOnOpOsOtP?P@PAPHPJPKPMPOPPPQP"},
  {0,NULL,"SP\\PaPbPgPhPoP}QDQEQJQOQPQ\\QbQgQjQkQoQpQrR@RDRHRIRNRYR]R^R_RiRjRn"},
  {0,NULL,"RpRqRxS?S@SASBSCSOSZS\\S^S_SdShSiSjSrSvS}THTJTKTVTZT^T`TgThTiTkToT"},
  {0,NULL,"qTxTyUBUCUFUIUMUNU^UbUdUgUuU{U}VCVGVHVJVLVOVTVbVcVgVjVnVrVtVuV{W@"},
  {0,NULL,"WEWNWYWZW[WbWdWhWkWnWoWsW}W~X?X@XAXEXIXJXMXNXOXTXXX^XbXcXdXg_D?E?"},
  {0,NULL,"J?K?N?O?Q?b?c?f?j?k?n?r?u@B@D@H@N@P@T@_@c@d@g@p@yA?A@AAABAEAJANAO"},
  {0,NULL,"ATA]AaAbAhAiAqAxB?BEBGBIBMBPBRBSBWBYBcBfBgBhBpBuCECGCHCJCNCOCPCTC"},
  {0,NULL,"]C_CgCkClCoCwC{C}C~D?DADKDTDUD]D`DbDdDeDhDjDtDvD~EHEOESEZEaEjEtEy"},
  {0,NULL,"E{E|E~F@FBFHFSFVFXF[F^FhFiFmFsFvF{F|G?GEGJGKGUGWG[G^GdGgGjGoGvGzG"},
  {0,NULL,"{G~H@HAHFHJHLHVHWHbHdHeHmHpHsHtHwH~I@IBIGIHIJI[IeIgIhIiIkImIsJ?JI"},
  {0,NULL,"JJJQJZJ_J`JaJdJfJlJoJsJuJwJ|KBKfKiKmKsKtKvLBLDLILKLNLQL]L`LcLeLgL"},
  {0,NULL,"mL{M?MBMLMTM]M`MeMlMmMpMqMrMsMtMuMyNBNENFNGNKNLNMNPNRNSNWN\\NdNgNh"},
  {0,NULL,"NmNoNrNvO@OAOJOOOQOUOWO_O`OaOeOfOjOoOsOxO~P?PBPFPGPHPRPWP]PaPbPeP"},
  {0,NULL,"fPiPkPsPvQ?QIQJQOQQQXQ\\Q_QgQiQoQzR?RARDRLRPRRRTRWRZRdReRfRlRsRtRw"},
  {0,NULL,"RyR}R~SDSESQSSSWSXSbSfSgSpSuSxSzS{TCTDTQTUTWT[T\\T`TfTkTmTqTsTuTvU"},
  {0,NULL,"AUCUEUPUSUUU\\U_UiUjUoUxUzU}V@VAVBVJVYV\\VbVcVjVnVoVuVyV{V}WBWCWIWS"},
  {0,NULL,"WYWZWbWhWiWoWrWsWuWyW{X?X@XAXDXFXIXNXOXRXSXWXXXdXeXj_D?E?I?M?O?P?"},
  {0,NULL,"Q?Z?a?g?i?j?m?r?u?|@F@I@R@S@Y@]@^@`@g@u@w@{@|@~ACADAFATAZA\\A^A_Aa"},
  {0,NULL,"AeAoArAwAzA}BABBBKBNBRBWB\\B]B_BfBiBnBpBqB~CBCECHCMCNCPCQC[C\\C_CkC"},
  {0,NULL,"mCrCuCxC|D@DDDEDGDJDPDRDcDlDnDoDqDrDsDxD~EKEQEXE[EaEpErEuEvEzE}F?"},
  {0,NULL,"FDFHFIFWFYF[F]F_FaFkFtFuFxG@GDGGGJGLGNGOGXG[GgGhGoGuGwG~HAHBHHHJH"},
  {0,NULL,"KHLHMHUHWH\\HbHcHnHvHxHzH{H|H}ILIMIVIXI_I`IbIdIlInIpIrJ?JDJGJRJTJ["},
  {0,NULL,"J\\J]J^JeJjJsJvJwJ{J}KAK_KaKcKhKoL?LALELFLLLRLYLZL_LdLhLwLxLyL}MGM"},
  {0,NULL,"PMQMWM[MiMjMmMnMoMqMuMxMzM}NENGNHNINJNKNONPNRNSNWNYN[NdNeNkNvNyN{"},
  {0,NULL,"N|O@OHOOOWO]O^O`OeOfOgOjOrOtOuOyO}PCPDPIPMPNPUPXPYP\\P^P_P`PtPuP}P"},
  {0,NULL,"~Q@QBQCQEQKQWQ]Q`QbQdQqQrQtQ}RERJRSRVR\\R]R^RaRhRnRoRpRuRwRyR}R~SD"},
  {0,NULL,"SESRS]S^S`ScSdSgSpSuSxSzS{TBTETRTVTWT\\T^TcTdThTnToTsTvTxT{T|U?UIU"},
  {0,NULL,"OURUTUkUnUpUuUwVAVBVCVEVGVNVPVQV[V^VjVmVqVsVtV|V}WBWCWJWKWTW^W_Wf"},
  {0,NULL,"WlWnWsWtWuWyW{X?X@XAXBXCXDXFXIXMXUX_XaXbXfXhXi_E?F?I?K?M?P?S?d?e?"},
  {0,NULL,"h?i?j?l?s?x@A@F@G@N@U@[@_@a@d@f@s@t@z@{A?AAAEAHALANAYAZA[A`AgAoAp"},
  {0,NULL,"A{A|BEBGBHBMBOBQBVB[B^BcBmBnBuB{B|B~C?C@CACDCHCJCSC^C_CaCdCeCoCqC"},
  {0,NULL,"wCxCzC|C}DJDMDYD\\DbDdDhDiDnDsDuDxEFEIENEXE^EbEiEnEwEyEzE|F@FAFJFN"},
  {0,NULL,"FRF\\F]F^F_FgFoFsFvFzG?GBGHGIGQGVGYG\\G^GbGfGgGpGtG}HAHBHCHDHFHIHOH"},
  {0,NULL,"SHUHYHaHeHlHmHpHqHsHvH}ICIKIWIXI^I`IbIeIhIiIjIrJBJDJMJVJXJaJbJdJe"},
  {0,NULL,"JfJgJpJqJyK@KAKBK^KbKgKiKpK~L@LBLGLJLUL[L\\L^L`LhLkLmLrL}MBMEMJMUM"},
  {0,NULL,"YM[M`MmMnMoMrMvMxMzM{N?N@NANENINKNNNQNTNUNXN`NaNiNjNmNrNwNyO?OEOG"},
  {0,NULL,"OOOTOXO[OcOfOgOhOiOkOmOoOxOyO|P?PAPDPFPRPSPTPWPXP\\PePlPzP{P~QGQHQ"},
  {0,NULL,"QQSQTQXQ[QaQfQlQwQ|Q~RARCRGRJRKRVRWR\\RaRgRlRoRrRuRwR|R}R~SMSNSTSY"},
  {0,NULL,"S]S`SbScSgSkSpSuSwS~TMTNTRTTTWTZT]T^TgTjTkTqTvTwTxTzUBUFUTUWUZU]U"},
  {0,NULL,"pUqUtUvU{V?VAVCVIVJVLVYVZVdVeVgViVuVvVyVzV~W?WBWHWLWSW\\WaWdWmWoWp"},
  {0,NULL,"WrWvWxW{X?XBXCXEXGXMXOXPXQXUX^X`XbXeXhXl_D?E?F?K?O?P?T?U?V?f?g?h?"},
  {0,NULL,"u?x?z@?@C@E@P@X@Z@\\@^@a@i@j@kAFAHAJALAMASATAWA]A^A`AcAfAjAlAxBABD"},
  {0,NULL,"BFBHBLBOBTBWB`BbBeBiBpBuBwB|B}C@CJCNCPCQCSCYC[CaCdCgCkCnCsCtDGDID"},
  {0,NULL,"MDQDRDSDTDVDXDYD[D]D^DfDgD|E?E@ELEYE_EcEdEeFAFBFDFGFHFJFKFLFNFTFV"},
  {0,NULL,"FWFbFfFjFuFwF|F~GAGBGJGMGQGZG]G_GmGoGpGtGuGvHDHFHJHLHMHOH\\H^HaHbH"},
  {0,NULL,"eHhHiHjHuIBICIFIGIIILIPIQISIUIVIWIYI\\I]IwI|I}JEJPJYJgJjJlJnJqJsJu"},
  {0,NULL,"JvJxJzK@KCKFKTKUKVKXKYKZK[K\\LjLlLsLtLvL|MAMFMHMIMMMOMXM_MbMfMgMhM"},
  {0,NULL,"nMqMrMsMtMxMyMzM{M|M}M~NANENGNQNSNVNWNZN]N`NfNnNrNtN|O@OEOFOLOUOW"},
  {0,NULL,"OXO[O]O`OhOjOkOoOuOwOzO{POPPPQPhPjPkPlPrPsPtPxPyPzP|P}QCQDQFQHQJQ"},
  {0,NULL,"VQ\\Q^Q`QaQkQmQqQyQ~R@RDRFRQRXRYR`RmRqRwRzR{R}R~S?S@SASFSGSJSKSPS_"},
  {0,NULL,"SaSgSpSuT?T@TITJTKTLTYTZT`TbTlTnT{T}T~UCUDUFUGUHUKULUMUNUcUdUeUfU"},
  {0,NULL,"gUhUyU}VDVKVLVNVPVZV\\ViVjVsVyV}V~W?WAWBWCWHWIWKWlWmWrWsWuWvWwWxWy"},
  {0,NULL,"W{X?X@XBXCXGXIXJXLXNXOXSXUX[X]XbXdXhXj_D?F?G?L?N?P?U?W?Y?f?g?h?p?"},
  {0,NULL,"t?v?{@D@F@N@Q@S@U@]@c@h@j@lAFAHAKANAQARAUAYA[A\\A_AaAiAkAoAwAyA|A}"},
  {0,NULL,"BEBIBNBPBVB\\BaBcBoBpBrBsBwB{C@CACFCGCMCPCYCZC]CcCdCmCoDCDEDFDGDJD"},
  {0,NULL,"KDNDODPDVDWDYD[D\\DeDlDuE@EAEBEJEPESEdEfEgFAFDFFFIFPFQFRFUFYF[F\\F^"},
  {0,NULL,"F_FdFiFxFzF}G?G@GEGIGLGOGTGWG^GaGjGmGqGtGwH?H@HDHHHIHLHSHTHZH[H^H"},
  {0,NULL,"bHlHnI@IAICIDIEIIIJIKILIMIOISIXIeIoIpIxIyI}JFJIJNJgJhJjJmJpJrJwJy"},
  {0,NULL,"J{J}KBKDKGKJKKKLKMKNKPKRKSLgLhLnLoLrLwL}MEMKMLMQMSMUM[MaMdMeMjMpM"},
  {0,NULL,"qMrMsMtMuMvMyM{M|M}M~NBNCNDNMNPNTN[NaNcNeNhNmNqNtNzO?O@OBOLOQOSOY"},
  {0,NULL,"O[O^O_O`OdOhOiOrP?PKPMPTPYPfPgPiPjPmPnPoPtPuPxPzP{P~Q@QDQEQFQGQSQ"},
  {0,NULL,"WQ[Q^QbQfQkQrQyQ|Q}R@RCRHRLRTRfRiRsRxRyR|SBSCSDSESHSISLSMSNSXSZSf"},
  {0,NULL,"SlSyS|T@THTITNTUTVTWT^TbTfTiTlTvTxTyT}UAUDUGUIUKU\\U]U^UbUcUeUjUuU"},
  {0,NULL,"vUzVAVCVDVHVKVRV[VdVhViVnVsVzV|WAWBWDWFWLWMWTWaWgWhWlWmWtWwWzW{W|"},
  {0,NULL,"X@XDXHXJXKXMXNXOXPXRXTXVX[X\\XcXdXmXn_E?F?G?K?L?M?T?X?Y?f?g?h?o?s?"},
  {0,NULL,"y?|?~@B@R@T@W@Y@b@d@k@l@mAHAIAJANAOAQAUAVAXAYA\\AaAdAeAhAzB?B@BCBK"},
  {0,NULL,"BMBSBXBYB[B]B_BhBjBnByB|B}B~CCCDCNCOCSC^CaCbCfCiCkCpCrC~DFDHDIDKD"},
  {0,NULL,"MDNDODPDUDYDZD]DmDqDtD|EDEEEQEREUEeEfEhFAFBFEFIFMFOFQFUFXF[F\\F^Fa"},
  {0,NULL,"FeFhFqFvF{GCGDGGGKGNGRGUGXG\\GcGfGkGoGpGrGzG}HBHJHOHPHUH_HaHdHfHhH"},
  {0,NULL,"oHtHxIAIBICIDIEIHIJIMINITIUIWIfIkInIwJ@JAJGJHJLJgJkJlJmJpJtJwJ{J|"},
  {0,NULL,"K?KBKDKEKGKIKKKLKMKOKRKSLeLfLgLpLqLwM?MCMDMLMQMRMVM]M^McMeMjMnMoM"},
  {0,NULL,"qMuMwMxMyMzM{M|M}M~NDNINNNONRNTNXNYN\\NbNgNkNuNyN~OAOEOFOGOKOROWOX"},
  {0,NULL,"O\\OcOgOjOkOlOsP@PGPIPZP_PaPiPkPlPmPnPoPqPuPvPwPzP|Q?QHQIQLQRQVQYQ"},
  {0,NULL,"ZQ_QaQiQmQzQ{Q~R?RBRFRIRSR^RhRjRnRxRyR|SBSCSDSESHSISLSMSNSRS\\SdSk"},
  {0,NULL,"SwS~TATBTCTFTKTLTYTZT[T\\T_ThToTpTsTuT~UFULUNUOUPUXUYUdUhUiUkUrUsU"},
  {0,NULL,"yU|V@VBVGVLVWVYV_VkVmVuVwVyV~W?WBWDWEWQWSWVWcWfWoWqWrWvWxW{W|W~X@"},
  {0,NULL,"XAXCXEXKXLXMXPXQXRXTXUXYX]XbXfXgXl_D?E?G?M?N?O?V?W?X?f?g?h?q?r?w?"},
  {0,NULL,"}@@@A@M@O@V@[@_@`@h@i@mAFAGAJAOAQARAVAXAYA[A_AaAgAmAnAvA{A~BBBGBJ"},
  {0,NULL,"BQBRBUBZB^BdBfBiBtBuBxBzCECHCICJCQCUCXC[C_CgChCjCqCvDBDFDGDHDLDND"},
  {0,NULL,"ODRDTDWDZD\\D]DaDiDpE?ECEGEIETEWEcEgEhFBFCFDFMFOFPFRFUFXFYF[F\\F`Fc"},
  {0,NULL,"FgFrFsFtFyGFGHGPGSGVGYG[G`GgGlGsGuGvGxG|G~HAHEHFHMHQHRHWH\\HeHgHqH"},
  {0,NULL,"rHyIAIBIDIEIGIKILINIOIRITIVIaIcIjIzI{I|JKJMJOJiJjJlJpJrJtJwJyJ|J}"},
  {0,NULL,"K?KDKEKGKIKJKNKOKPKRKSLfLiLnLqLrLuL~MDMEMKMNMRMUMVMZM\\McMdMmMnMrM"},
  {0,NULL,"sMtMvMwMxMyMzM{M}NCNKNNNPNRNUN^N_NdNiNjNlNpNrNsNvN|OCOIOMOOOUOZO]"},
  {0,NULL,"ObOeOfOnOoOuO|PEPJPSPVPcPgPkPmPnPoPpPqPsPtPwP{P}QAQCQJQNQPQUQ\\Q`Q"},
  {0,NULL,"cQhQjQnQpQqQsQvQxRDRGRKR[RgRrRvRxRyR|SBSCSDSESHSISLSMSNSTSYSeSxSz"},
  {0,NULL,"S{T?TGTJTOTPTTTXT]T`TeTgTnTtTwT{U@UBUCUHUJUMUQUZU[UaUfUgUlUmUtU{U"},
  {0,NULL,"}U~V?VFVNVUV^VcVgVjVlVoVqV}WBWCWEWFWJWOWZW_WdWeWiWsWuWyWzW{W~XAXB"},
  {0,NULL,"XDXFXKXMXOXQXRXSXUXVXZXeXhXiXjXk_D?E?G?M?N?O?V?W?X?f?g?h?q?r?w?}@"},
  {0,NULL,"@@A@M@O@V@[@_@`@h@i@mAHAIAKALAMAPASAZA]A^A`AbAgAmAnAvA{A~BBBGBJBQ"},
  {0,NULL,"BRBUBZB^BdBhBlBnBrBsBvCACBCCCDCFCTC]C`CeCfCiCmCwC{D?DHDJDLDMDODQD"},
  {0,NULL,"RDSDTDUD[D\\DcDnDrD~EAEEEKEVEZEcEgEhFAFEFFFGFJFKFNFSFVFWFZF]F`FcFg"},
  {0,NULL,"FrFsFtFyGFGHGPGSGVGYG[G`GbGcGiGjGkGwG{G}H?HIHKHPHTHUHXH[H]HdHvHzH"},
  {0,NULL,"|IEIFIGIHIKINIQIRISIVIWIXI[IgIhIxJ?JAJCJQJRJgJhJkJnJoJqJuJvJxJ~K@"},
  {0,NULL,"KAKHKQKTKUKVKWKZK[K\\LkLmLsLvLyLzM@MBMGMJMMMOMWMYM`MfMhMkMoMpMqMsM"},
  {0,NULL,"uMvMwMyMzM|M}M~NANFNHNJNLNSN^N_NdNiNjNlNqNxNyN}OAOBOKOPOQOTO\\O^Oa"},
  {0,NULL,"OcOdOiOlOtPBPFPHP\\P^P`PjPlPnPpPrPsPvPwPyP{P}P~Q?Q@QKQLQQQSQWQXQZQ"},
  {0,NULL,"[Q]Q_QzQ{Q}RARCRERNRRR]R_ReRpRwRzR{R}R~S?S@SASFSGSJSKSOSQS^SoSqSs"},
  {0,NULL,"TBTCTMTSTUTVT[T^TaTfThTjToTrTuTxTzUAUIUOUPUVUWU\\U`UiUjUkUqUuUzV@V"},
  {0,NULL,"CVGVIVMVXVaVeVhVkVuVvVxV|W?W@WAWDWRWXW\\W`WcWgWoWpWtWwWxW|W}X?XAXB"},
  {0,NULL,"XDXEXFXHXIXJXKXLXSXXXYXaXcXfXn_D?E?F?K?O?P?T?U?V?f?g?h?u?x?z@?@C@"},
  {0,NULL,"E@P@X@Z@\\@^@a@i@j@kAGAIAKANAOARAUAVAXA[A\\A_AfAjAlAxBABDBFBHBLBOBT"},
  {0,NULL,"BWB`BbBeBgBkBlBmBqBvC?CBCKCLCRCTCVCWC\\C`CeClCuD@DDDGDHDKDPDQDSDWD"},
  {0,NULL,"XDYDZD\\D]DbDdDhD}D~EFENEOE[EcEdEeFCFEFFFIFMFOFPFQFRFXFYF^FbFfFjFu"},
  {0,NULL,"FwF|F~GAGBGJGMGQGZG]G_GbGdGeGhGiGnGyG{HCHGHKHNHVHXHYH]H`HcHmHpHsI"},
  {0,NULL,"BICIFIJIKILIMINIOIPIQITI_IdIlI~J?JBJTJVJZJhJiJkJmJrJtJyJ{J|J}K?KB"},
  {0,NULL,"KEKIKJKKKLKMKNKOKPLeLhLiLoLpLuL}L~M?MCMNMSMZM[M\\M]M^MaMmMoMpMsMtM"},
  {0,NULL,"uMvMwMxMzM|M~NBNINKNMNONUNWNZN]N`NfNnNoNwNxN{N}ODOHOJONOPOTOVOaOm"},
  {0,NULL,"OpOqOtOvO}PCPNPRPWPePgPhPiPkPqPrPtPuPwPyPzP{QBQKQMQOQQQTQXQ]QdQeQ"},
  {0,NULL,"gQlQoQtQuQwRARERJRURZRkRtRuRxRyR|SBSCSDSESHSISLSMSNSSS[ScSjSvS}TD"},
  {0,NULL,"TETMTQTRTSTaTcTdTjTkTmTqTrTzT|U?UEURUSUTUUUVUWU_U`UnUoUpUqUwUxVEV"},
  {0,NULL,"IVJVMVSVTVVVpVrVtVvVxV{W@WDWEWFWGWNWPW`WbWjWkWnWpWzW|W}W~X?X@XAXD"},
  {0,NULL,"XGXIXOXPXQXTXUXVXWXXX^X_X`Xa_E?F?G?K?L?M?T?X?Y?f?g?h?o?s?y?|?~@B@"},
  {0,NULL,"R@T@W@Y@b@d@k@l@mAFAGAKAPASATAWAZA^A`AbAcAdAeAhAzB?B@BCBKBMBSBXBY"},
  {0,NULL,"B[B]B_BgBoBqBxBzB{C?CECGCMCRCUCVCWCXCZC_CcCxCzC}DFDIDJDLDMDPDRDSD"},
  {0,NULL,"UDVDXDZD_DjDoEBECEFEHE\\E^EeEfEhFCFDFFFGFHFJFLFSFTFWFZF]FaFeFhFqFv"},
  {0,NULL,"F{GCGDGGGKGNGRGUGXG\\GaGeGgGnGqGsG|G~H@HCHHHNHRHSHVHZHcHgHkH{H~IAI"},
  {0,NULL,"FIHIIIMIPIRITIUIVIWIXI^IbIiIyIzJBJJJUJXJhJiJjJnJoJsJvJzJ~K@KAKCKF"},
  {0,NULL,"KHKQKTKUKVKWKXKYLkLlLtLxLyL{MAMFMGMJMPMTMWMYM_MgMiMlMmMpMrMsMtMuM"},
  {0,NULL,"vMwMxMyM{M~N?N@NFNGNLNQNXNYN\\NbNgNkNoNpNzN{O?OCONOOOSOVOYOZO_ObOe"},
  {0,NULL,"OmOrOvOxOyPAPUP[PbPhPlPoPpPqPrPuPvPxP|P}P~QBQEQGQNQPQTQbQdQfQhQjQ"},
  {0,NULL,"lQpQrQtQvQwQ|RORPRWRcRdRlRwRzR{R}R~S?S@SASFSGSJSKSVSWSbSmSnStTDTE"},
  {0,NULL,"TGTHTNTTTWTXTdTgTiTmTtTvTyU?UBUEURUSUZU[U]U^UaUbUnUoUtUvUxU{U~VAV"},
  {0,NULL,"EVHVOVQV`VlVnVpVqVtVzW@WAWCWFWWW[W^W_WaWeWhWjWnWwWyWzW}X?XCXEXFXG"},
  {0,NULL,"XHXLXNXPXQXRXSXWX\\X`XeXkXm_D?F?G?L?N?P?U?W?Y?f?g?h?p?t?v?{@D@F@N@"},
  {0,NULL,"Q@S@U@]@c@h@j@lAGAIAJALAMAPATAWAZA]AbAcAiAkAoAwAyA|A}BEBIBNBPBVB\\"},
  {0,NULL,"BaBcBfBjBkBmBtByB~CHCICKCLCOC\\C^CbChCjClCyC|DADIDJDKDLDNDQDTDUDVD"},
  {0,NULL,"WDXD[D`DkDsD}EDEGEMEXE]EdEfEgFBFCFEFHFKFLFNFSFTFVFZF]F_FdFiFxFzF}"},
  {0,NULL,"G?G@GEGIGLGOGTGWG^GdGfGhGlGrGxGyGzHAHBHEHGHQHWHYH_H`HfHwH}I?IDIGI"},
  {0,NULL,"HIIIJIOIPIQIRISIUIXIZI`ImI{I~J@JDJSJWJiJkJlJoJqJsJuJxJzJ~KAKCKFKH"},
  {0,NULL,"KQKWKXKYKZK[K\\LjLmLxLzL{L|M@MBMHMIMPMTMXM`MbMiMkMlMmMnMoMtMuMvMwM"},
  {0,NULL,"xMzM{M|M}N?N@NENHNJNVN[NaNcNeNhNmNsNuNvNwN~ODOGOHOIOJOMOROfOgOnOp"},
  {0,NULL,"OqOsO~PDPLPXP]PdPgPhPiPjPmPpPsPvPxPyP|P~QAQIQMQOQRQUQYQcQeQgQiQnQ"},
  {0,NULL,"oQsQuQxR?RBRMRVR\\RaRbRoRwRzR{R}R~S?S@SASFSGSJSKSUS]S`ShSiSrTATFTO"},
  {0,NULL,"TPTQTRT\\T]T_TcTeTkTpTqTsTwT|U@UJUQUTUUUXUYU_UlUmUpUrUsUwU|V?VBVFV"},
  {0,NULL,"JV]VbVfVgVmVoVrVwV{W?W@WCWEWUWYW]WbWdWfWiWkWqWxWyW}W~XBXCXEXFXGXH"},
  {0,NULL,"XIXJXMXNXTXVXZX^X_XgXiXl_B?C?I?R?Z?\\?]?_?`?a?d?e?g?h?k?n@M@Q@W@^@"},
  {0,NULL,"`@a@c@d@f@g@j@mALAOAUA_A`AaAbAcAhAkAlAnAtAuA~BEBFBKBZB]BbBcCVCZC\\"},
  {0,NULL,"C^C_CdCeCgCiCjCkCmCnCqCrCuC|C}D?DCDGDKDLDMDODQDVDZD^D`DgDiDpDqDsD"},
  {0,NULL,"tDxD{EHEJEKENESEVE[E^EaEbEdEhFHFMFPFVFWFZF\\F^F`FbFeFiFlFpF{F~G@GH"},
  {0,NULL,"GKGOGVG_HRHSHTHUHWHXHYH_HbHcHeHhHjHkHqHsHxHzH}I@IAICIHINIOIPISIVI"},
  {0,NULL,"YI]I`IaIjIkImInIrIvJCJIJJJNJRJTJVJXJ]J_JaJcJhJlJnJyJ{KAKEKSKXKZLM"},
  {0,NULL,"LPLQLSLTLZL[L\\L^L_LaLdLeLgLlLrLsLuLxLzL~MBMCMFMKMOMQMTMUM\\M]M`MfM"},
  {0,NULL,"gMiMjMnMpN@NCNDNHNINKNQNSNYN\\N]N^NeNfNgNhNiNlNmNnNsNuNwNyN|O@OCOE"},
  {0,NULL,"OHOKOMOOOROXO[O]O_OaOdOiOmOrOtOvOzP@PJPLPOPZPcPdPkPmPsP|QEQFQKQLQ"},
  {0,NULL,"OQPQSQTQ[Q]Q_QbQeQhQkQlQqQsQxQ~R?RBRDRFSOSPSQSSSUSVSWSZS[S\\SeSfSg"},
  {0,NULL,"ShSkSmSpSqSrSvSwSzS{S|T@TBTRTTTXTbThTkTuT|UBUDURUVU\\U]UbUoUqUuU|V"},
  {0,NULL,"FVLVNVOVRVVVaVgVmV}V~WMWPWXW[WdWfWuWvX?XDXHXPXWXXXmXn_B?C?H?Q?Z?["},
  {0,NULL,"?]?^?`?a?b?c?f?g?j?l@N@O@S@T@X@Y@Z@[@e@f@i@lAMANARASAWAXAYAZAgAhA"},
  {0,NULL,"iAjAqArA|BABBBCBTBUB[B\\CWCXC\\C]CaCbCcCdCeCfCgChCnCoCpCuCvCwCxCyDG"},
  {0,NULL,"DHDIDJDNDPDQDRD_D`DaDbDhDiDjDkDwDyEKELEPEQERESEYEZE`EbEcEfFIFJFNF"},
  {0,NULL,"OFRFSFTFUF_FaFbFcFkFmFqFsF|F}GPGQGTGUHQHRHSHUHVH[H\\H]H^H_H`HaHiHk"},
  {0,NULL,"HlHmHvHwHxHyIAIBIFIGIHIIIJIKIZI^I_I`IaIbIcIdIqItJEJFJGJHJIJPJQJRJ"},
  {0,NULL,"[J\\J`JaJgJiJmJuJvJwKFKIKJKQLNLOLQLRLVLWLXLYLZL[L\\L]LeLfLjLkLlLmLn"},
  {0,NULL,"LoL}M@MCMDMEMFMGMHMUMVMWM^M_M`MaMbMmMqNCNENFNGNHNMNNNONXN[N\\N]N^N"},
  {0,NULL,"_N`NcNdNeNfNgNpNvNwN{N|N}N~O?OIOJONOOOROSOTOUO`OcOdOhOiOjOkOlOxO|"},
  {0,NULL,"O}O~PUPVPWPXPgPhPpPqQ?Q@QFQGQHQIQJQKQWQXQYQ^Q_Q`QaQbQoQpQsQtQuQvQ"},
  {0,NULL,"wQxSPSQSRSWSXSYSZS[S\\S]S^S_SgShSiSjSmSnSoSvSwSxSySzT?TATMTNTWT_T`"},
  {0,NULL,"TaTsTyTzT{UIUKULUOUcUdUiUjUwUxU~V?VXVYVZV[VoVpVqVrWHWRWSWTW_WiWjW"},
  {0,NULL,"kX@XJXKXLXYXbXcXd_B?C?H?Q?Z?[?]?^?`?a?b?c?f?g?j?l@N@O@S@T@X@Y@Z@["},
  {0,NULL,"@e@f@i@lAMANARASAWAXAYAZAeAfAnAoAqArAxAyB@BGBPBQBXBeCWCXCZC[C\\C]C"},
  {0,NULL,"^C`CaCdCfChCsCzC{C|C~DBDCDDDFDKDSDTDUDVD\\D]D^DcDfDlDmDnDqDuDwDyEH"},
  {0,NULL,"EIEMEOETEXE[E\\E`EbEcEfFIFJFNFOFRFSFTFUFgFhFiFjFkFmFtFuFzGCGIGXGZG"},
  {0,NULL,"`HQHRHUHVHXHZH[H^H`HaHeHfHnHoHpHqHuHzH~I?IDILIMINIQIUIVIXIYI\\IeIf"},
  {0,NULL,"IgIhIkIoIqItJDJJJKJMJSJTJUJZJ^J_JeJfJgJiJsJ|J}J~KMKRKUK[LMLNLOLQL"},
  {0,NULL,"RLULVLYLZL]LaLbLhLpLqLrLtLyLzL|M?MAMBMIMJMKMRMSMXMYM[M]McMdMgMkMm"},
  {0,NULL,"MqNBNINJNLNPNQNRNVNWNYNZNaNbNhNiNjNkNlNmNnNrNuNxNzO@OAOBOFOGOKOLO"},
  {0,NULL,"POWOYO]O^ObOeOfOmOnOpOqOvO{PHPIPMPPP`PaPfPjPlPnPzQAQBQCQEQNQOQQQR"},
  {0,NULL,"Q\\Q]QcQdQfQgQhQiQyQzQ{Q}Q~R@RCRFSOSSSTSUSVS`SaSbScSdSeSfSkSlSpSqS"},
  {0,NULL,"rSsStSuS{S|S}S~TFTHTJTST\\TiTjTnTpTrTvUCUQUSUUUZUaUlUnUpUyUzVGVKVQ"},
  {0,NULL,"VTVUVbVhVkVsVyWNWOWYW^WcWgWlWrXFXGXQXVX^X`XeXi_B?C?J?S?[?\\?^?_?b?"},
  {0,NULL,"c?d?e?f?h?i?m@P@R@U@V@\\@]@_@b@e@g@h@kAPAQATAVA[A\\A]A^AeAjAkAmApAs"},
  {0,NULL,"A}BHBJBMBNBSB^B`CVCYC[C]C_C`CbCcChCiCkClCoCrCtCyC{C}D@DBDJDMDNDTD"},
  {0,NULL,"XDYDZD\\DaDeDfDgDjDlDoDpDvDzENEOEQEUEVEXEZE]E`EaEeEgFGFKFLFQFXFYF["},
  {0,NULL,"F]F_FeFfFgFnFoFwFyGDGEGNGSGWG]HTHVHWHYHZH\\H]HaHbHdHfHgHiHmHoHrH|H"},
  {0,NULL,"}H~I@IBIEIFIMIOIRISIUI\\I]IbIcIeIiIjIpIsIuJCJDJGJLJQJVJWJZJ\\JcJdJe"},
  {0,NULL,"JjJkJoJqK?KBKGKNKTKYLPLRLSLTLULWLXL]L^L`LbLcLgLiLjLoLqLvLxLyL}MHM"},
  {0,NULL,"JMMMNMQMRMTMVMWMXM[M\\MeMfMlMoMrN?NBNFNKNNNSNTNVNYNZN[N_N`NeNfNgNh"},
  {0,NULL,"NiNjNkNoNrNtNvO?OBOCOEOMONOQOUOWOYOZO[OaOcOgOlOpOqOsOtOwPAPEPKPQP"},
  {0,NULL,"SPTP[PoPtPxP}Q@QAQIQLQMQQQTQVQXQZQ[QaQdQeQiQnQpQqQrQvQyQ|R@RDSOST"},
  {0,NULL,"SUSVSZS[S\\S]S^S_ScSdSgShSjSkSmSsStSuSxSyS{S|TDTLTPTUTYT^TeTmTwU?U"},
  {0,NULL,"AUFUPUTUWUXU_U`UkUsU{U}VDVHVSVWV]VeViVjVlVnWGWQWUW\\WeWhWmWsXAXEXI"},
  {0,NULL,"XTX_XaXfXl_B?C?J?S?[?\\?^?_?b?c?d?e?f?h?i?m@P@R@U@V@\\@]@_@b@e@g@h@"},
  {0,NULL,"kAPAQATAVA[A\\A]A^AdAgAlAoApAsAvAzBIBLBWBYBaBdCWCYC[C_C`CaCbCcCiCj"},
  {0,NULL,"ClCmCpCqCsCxD?DADDDEDIDLDODPDSDWD[D]DbDdDkDmDnDrDsDtDvDzEIEJEPEWE"},
  {0,NULL,"YE\\E^E_E`EaEeEgFGFKFLFQFXFYF[F]F`FaFdFjFnFoFvFxGBGFGMGRG[G^HQHYHZ"},
  {0,NULL,"H[H\\H]HbHcHdHfHgHhHjHnHsHtHvHyH{I?ICIDIGIKIPITIWIXIZI[IdIfIgIlImI"},
  {0,NULL,"nIsIuJFJMJNJOJPJUJXJYJ]J`JbJfJjJkJpJrK@KCKHKLKOK\\LNLTLULVLWLXL^L_"},
  {0,NULL,"L`LbLcLdLfLhLkLsLuLwL{L|L~MDMGMIMLMOMPMSMYMZMaMbMcMhMiMjMoMrN@NAN"},
  {0,NULL,"DNENLNMNRNUNWNXN\\N]N^NaNbNcNdNlNmNnNqNsNxNyN{N~ODOFOGOHOIOTOVOXO\\"},
  {0,NULL,"O^O_O`ObOeOhOoOrOuPCPDPFPGPRP]P^P_PiPvPwPyQBQCQDQGQHQPQSQUQWQ`QcQ"},
  {0,NULL,"fQjQkQlQmQoQuQzQ{R?RARBRESPSQSRSSSWSXSYS`SaSbSeSfSiSlSnSoSpSqSrSv"},
  {0,NULL,"SwSzS}S~TETKTOTVTZT]TdTfTxT~U@UEUGUHU[U^UeUgUtUvV@VBVJVMVPV^V`VdV"},
  {0,NULL,"uVwVxV{WJWKWLWWW`WbWoWqXNXOXRXSX[X\\XhXk_B?C?I?R?Z?\\?]?_?`?a?d?e?g"},
  {0,NULL,"?h?k?n@M@Q@W@^@`@a@c@d@f@g@j@mALAOAUA_A`AaAbAcAdAfAiAmAtAuAwA{B?B"},
  {0,NULL,"DBOBRBVB_CVCXCYCZC^CeCfCgCjCkClCmCtCvCwCzC~D@DADEDFDHDRDUDWDXDYD["},
  {0,NULL,"D_DcDdDeDhDoDrDuDxD{ELEMERETEUEWE]E_EaEbEdEhFHFMFPFVFWFZF\\F^FcFdF"},
  {0,NULL,"fFhFlFpFrG?GAGGGJGLGYG\\HSHTHWHXH^H_H`HcHdHeHgHhHlHpHrHtHuHwH{H|IE"},
  {0,NULL,"IIIJILIQIRITIWI[I^I_IhIiIlIoIpIrIvJEJHJKJLJOJSJWJYJ[J^JbJdJhJlJtJ"},
  {0,NULL,"xJzKDKKKPKVKWLMLOLPLSLYL[L\\L_L`LaLcLdLiLmLnLpLtLvLwL{M?M@MAMEMLMM"},
  {0,NULL,"MNMPMZM^M_MdMeMhMkMlMnMpN?NANGNJNONPNTNUNWNXNZN[N_N`NaNbNcNdNjNkN"},
  {0,NULL,"oNpNqNtNzN}OAODOJOLOPOQOSOVOZO\\OfOgOjOkOnOoOsOuOyP?PBPNPYP\\PbPePr"},
  {0,NULL,"PuP{P~Q?QDQJQMQNQRQUQVQYQZQ\\Q^QgQjQmQnQrQtQwQ|Q}RARCRESRSTSXSYS]S"},
  {0,NULL,"^S_S`SaSbScSdSiSjSlSnSoSsStSuSxSyS}S~TCTGTITQT[TcTgTlToTqTtT}UJUM"},
  {0,NULL,"UNUYUfUhUmUrVAVCVEVIV\\V_VcVfVtVvVzV|WIWVWZW]WaWnWpWtXBXCXMXUXZX]X"},
  {0,NULL,"gXj_B?I?M?T?U?V?W?Y?Z?]?_?d?f?n?t?z?{@?@C@D@O@Y@_@b@e@m@r@y@zA?AA"},
  {0,NULL,"ABAPAXAYA^AjAoAqAsA|A}BBBDBFBMBRBZB]B_BrBvBxByBzB|B~CACFCHCMCOCWC"},
  {0,NULL,"[C`CaCeCkCnD@DADCDFDLDRDZD`DbDeDfDgDhDkDlDmDnD|D~EAECEDEEELENESE]"},
  {0,NULL,"E`EhEjEmEuExE}F?FJFSFXF[F_FjFkFoFqFwFyF|G?G@GKGVGYG\\GgGiGjGpGrGsG"},
  {0,NULL,"{HFHJHKHNHOHQHTHZH[H_HfHlHsHuH}IAIRITIVIZI\\I]I_I`IdIeIfIgIpIwIxIz"},
  {0,NULL,"J?J@JAJEJIJVJWJ\\JfJiJjJmJqJuJxJ{KBKEKSKVKWK`KaKjKrKsKtKyK}K~L?LDL"},
  {0,NULL,"ELNLPLULVL[LbLeLvLwLzM?M@MOMQMUMXMYM[M\\M_MaMbMcMlMsMtMvMxM{M|NHNO"},
  {0,NULL,"NSNTN[N_N`NeNfNgNpNtNwNxN~OBOCOFOGOJOOOTOWOZO[O^O`ObOdOeOkOpOsOtO"},
  {0,NULL,"xO|P@PAPBPEPSPUPVPZP[P\\PgPhPsPtPuPxQ@QEQIQRQSQUQXQ\\Q]QaQlQmQpQvRB"},
  {0,NULL,"RCRERFRJRLRNRQRSRVRbReRfRmRnRtR}S@SBSFSISMSlSpSqSrS}S~TGTTTkTlTqU"},
  {0,NULL,"DUJUKUMUOUPURUTU]U_UbUcUfUiUkUmUoUwU{U~VAVDVEVFVNVPVTVbVdVlVqW?WD"},
  {0,NULL,"WKWLWNWYW_WeWxW|XFXQXRXSX_XdXqXsXxXz_B?H?L?T?U?V?W?X?[?]?^?`?h?l?"},
  {0,NULL,"r?u?}@A@C@E@R@]@c@d@g@l@q@t@{AAACAEAQA\\AbAcAlAmAsAtA}B?BBBDBGBHBP"},
  {0,NULL,"BXB[B\\BfBhBmBoB{B}C?C@CKCLCNCSC_CfChCiCjCmCnCvC{DDDFDJDPDVDaDcDdD"},
  {0,NULL,"fDgDhDpDrDsDtD|D}EBEDEEEGELEOETEZEaEfEiEkEvE{E}E~FLF\\F]F^F`FfFlFo"},
  {0,NULL,"FrFuFyF|G?GDGIGTGUGXGaGdGkGlGoGqG|G}H?HAHEHPHYH`HaHbHcHhHmHqHuHvI"},
  {0,NULL,"AIIIMIXI[I\\I]I_IcIhIjIlImInIwIyI{I~J@JAJEJKJQJZJ]JdJhJjJqJtJuJxJ|"},
  {0,NULL,"K?KFKMKQKRK]KbKcKeKgKiKxKzL@LALCLILOLTL]L^L_LdLeLmLqL|M?MBMDMHMWM"},
  {0,NULL,"ZM[M\\M_MdMfMhMiMjMsMtMvMyMzM~NJNNNONVNZN[N_N`NjNkNrNsNyNzN}O?ODOE"},
  {0,NULL,"OHOMOPOSOUOXOYO\\O_OaOfOjOlOqOrOuOyO~P?PAPIPKPTPXPYP[PaPbPjPqPrPtP"},
  {0,NULL,"{P}QBQFQHQMQOQVQWQZQ_QcQhQnQoQrQsQzQ|Q~RGRIRNRQRVRZRbReRhRkRmRvRy"},
  {0,NULL,"R}S@SCSFSNSpSqSrSvSwSzTHTNTaTnTrT{UIUKUMUSUWUXUYUZU`UaUcUfUjUnUrU"},
  {0,NULL,"sUxUzU}U~VAVHVIVKVPVVV^VaVnVzW?WEWJWKWPWXWaWhWxW~XHXNXPXRXaXjXqXv"},
  {0,NULL,"XzX|_B?J?K?U?V?W?X?Y?[?b?d?e?g?i?p?w?{@@@A@F@T@W@X@^@f@k@u@v@z@{@"},
  {0,NULL,"~ADAOASAUAWAiAnAqAtA{A}BBBCBDBIBSBWBYB`BgBjBnBqBuBwCBCCCDCECJCQCY"},
  {0,NULL,"CZC\\C^CbCdCoCqC{DADPDSDXDZD^D`DaDcDeDiDkDqDrDuD|E?E@EDEEEFEPEWEZE"},
  {0,NULL,"]EbEeEpEqExEyE{F@FHFIFOFWFcFiFkFlFyF|F}G?GFGGGMGNGRG]GcGeGfGnGtGv"},
  {0,NULL,"GyGzH@HBHDHLHRHUHXH\\HdHeHnHrHvH}IFIMIPITIYIZI[I`IaIcIhIkIoIpIwI|I"},
  {0,NULL,"}J@JAJBJFJOJQJWJ[J_JhJiJpJqJuJwJxKDKLKOKTKYK_KfKhKlKoKpKuKwK|LFLH"},
  {0,NULL,"LJLMLQLWLZL`LaLjLqLsLwMDMIMMMQMUMWMZM]M`MaMdMgMkMlMsMtMuMvMwM}NAN"},
  {0,NULL,"ENNNTNXN[N_N`NcNdNoNqNuNvN{N|O@OAOIOKOLONOQOROVO]OcOgOhOiOmOnOoOv"},
  {0,NULL,"OwOxOyO}PGPNPQPUPWP_PbPePgPoPpPyP{P~Q?QCQJQLQPQQQYQ^QeQfQiQkQqQtQ"},
  {0,NULL,"wQ{R?R@RHRNRQRVR[R^RbReRjRmRrRsR|R}S@SESFSLSkSpSqSrS{S|TDTETeTfU@"},
  {0,NULL,"UAUIUJULUNUTUWU[U^U_U`UdUhUjUmUtUvUxU{V?VCVEVHVJVMVRVUVaVbVpVtW?W"},
  {0,NULL,"BWMWOWXWYWjWnWxW{X?XGXPXQXZXcXoXqXxX|_B?I?P?T?V?W?X?Y?\\?`?a?e?f?k"},
  {0,NULL,"?q?y?}?~@@@B@P@S@U@Z@e@j@p@x@|@}@~ACANARATA]AeAgApAqAzA{A~BABCBIB"},
  {0,NULL,"OBVBbBcBiBkBmBoBrB|B~CGCMCNCRCSC[C]C`CgChCmCqCwC}C~DKDQDWDXD_DaDf"},
  {0,NULL,"DiDjDlDmDnDrDtD|D}E?E@EAEBEKEREWE^E`EdEsEtEwEyE|E~FNFQFTFYFaFgFkF"},
  {0,NULL,"nFsF{F}GBGFGGGJGLGOG_GaGdGhGjGpGuG{H?HAHFHIHMHSHVHZHaHfHhHrHxHzH{"},
  {0,NULL,"IJIOIPIQI[I\\I^IaIbIcIeIfIgInIwIxIyI|I}I~JHJOJRJXJ`JeJiJkJnJpJvJwK"},
  {0,NULL,"@KDKKKPKXKZKeKgKjKnKqKtKvKzK{L?LDLILRLUL\\L]LbLdLgLnLsLtMFMKMLMMMV"},
  {0,NULL,"MWMXMYMZM[M^M`McMiMuMvMwMxMyMzNANCNDNGNXN\\N]N^NcNdNpNrNwNyO?OBODO"},
  {0,NULL,"FOHOJOOOUOWOYO\\O^O_ObOdOkOlOpOqOuOzO}O~P?PCPDPOPRPWPXPYP]PmPpPqPr"},
  {0,NULL,"PvPwQEQGQHQRQTQVQWQ[Q\\Q]Q`QnQoQrQuRCRDRFRHRORXR[R]R^R_RjRlRqRrRsR"},
  {0,NULL,"wRzR|SESGSLSkSsStSuS{S|TQTRTgThToUBUGUJUKUOURUVUYU[UcUeUiUmUoUqUr"},
  {0,NULL,"UtUwU|U~V@VEVFVIVJVQVUVWVeVrV{WAWBWOWQW\\W^WbWkWwW{XGXIXTXVXYXkXoX"},
  {0,NULL,"pXxX{_B?H?O?T?U?W?X?Y?Z?a?b?c?h?j?o?v?|@B@D@F@M@V@\\@a@g@i@o@s@|A@"},
  {0,NULL,"ABADALAVA[A`AdAkApAtAwA{B@BCBIBLBQBTBUBeBfBlBpBvBzB}C@CFCHCICKCPC"},
  {0,NULL,"VCXC_CaCiCkCoCxC|C~DHDQDSD\\D_DeDgDkDmDoDpDsDtDuD|D~E?E@ECEGEMEPER"},
  {0,NULL,"E\\EaEcEnEoEzE|F?F@FGFKFMFPFdFeFlFnFvFzF}GAGFGGGPGQGZG`GbGgGiGlGmG"},
  {0,NULL,"oG|G}G~HCHJHOHQHTHWHYH^HbHnHwHxH~IFIKINIQIZI]I^IfIiIjImInIoIpIwIz"},
  {0,NULL,"I{I|I}J?JFJHJSJUJbJcJhJkJpJsJwJzKCKDKIKJKUK[K]K^K`KcKdKsKxK}K~LAL"},
  {0,NULL,"BLGLNLPLSLTLYL^LfLjLrLtMEMFMIMRMYM\\M^MaMeMfMiMjMkMlMuMvMwM{M|M~NE"},
  {0,NULL,"NGNPNRNWNXNaNbNcNdNsNtNxNzN}N~OCOEOGOMOPOSOTOXOZO[O`OaOeOfOjOrOsO"},
  {0,NULL,"tO{O|PBPCPFPNPPPRPVP\\P^PePhPiPnPuPvP~Q@QAQDQFQOQUQ_QaQdQhQjQmQsQv"},
  {0,NULL,"QyQ~RARERHRMRPRYR[R^R`RcRjRoRrRsR|R~SASESJSLSgShSkSmS{S|TMTST_TiT"},
  {0,NULL,"pTyUHUIUMUOUSUUUYU^UfUgUiUjUnUpUrUvUwUxUzVAVBVGVIVMVOVRVWV]VvVxWB"},
  {0,NULL,"WCWMWQWUW[W`WpWyW{X?XAXDXIX\\XgXoXrX{X|_B?J?N?T?U?V?X?Y?\\?^?_?c?g?"},
  {0,NULL,"m?s?x?|?~@?@E@N@Q@[@`@f@h@n@w@}A?A@AEAMAZA_AaAfAhAqAuAzA|A~BABFBM"},
  {0,NULL,"BNB^BaBdBfBlBnBtBwB{C@CBCLCPCQCTCXCZC^CcCfCiCpCsC}D@DLDNDTDWD^D_D"},
  {0,NULL,"bDcDgDhDjDqDtDuD~E@EAEBEEEGENEQEYE^EbEgElErEuEvEwEzFRFUFVFZFbFhFk"},
  {0,NULL,"FpFqFsFwF{G@GBGSGWG[G^GbGcGlGqGtGxGzG}G~H@HHHPHXH]H^H`HbHeHiHoHsH"},
  {0,NULL,"{IDIGIOIRIYI]I^I_IbIdIhIkInIoIxIyI{I}J?JAJGJPJVJXJ^JaJiJlJmJnJvJ{"},
  {0,NULL,"K@KBKGKHKNK\\K]KbKdKfKmKoLALCLFLGLHLKLMLOLXLYL^LaLgLhLkLvL}MJMLMOM"},
  {0,NULL,"VM\\M]M^M_MbMdMgMiMkMtMwMxMzM{M~NDNFNMNSN\\N]N^NeNfNgNsNvNzN{N}O@OA"},
  {0,NULL,"OEOIOKOLOMONOPOSOXOaOcOfOhOjOmOnOrO|O~PFPJPKPLPTPVPXP^PcPdPhPiPkP"},
  {0,NULL,"qP|P}QCQDQFQKQMQQQZQ_QbQfQiQjQsQxQ{Q|R@RARJRLRORSRXR]R_RfRlRnRqRt"},
  {0,NULL,"RwRzSBSGSISMSlSsStSuS}S~TOTPTYTdT~U?UHUIULURUTUXU[U\\U_UdUgUjUoUsU"},
  {0,NULL,"tUuUxU{U}V?VBVFVJVLVQVTV\\V_VgVoWAWDWIWNWVW^WdWiWwW|XBXFXMXVXWXbXp"},
  {0,NULL,"XsXwXx_B?I?P?T?V?W?X?Y?\\?`?a?e?f?k?q?y?}?~@@@B@P@S@U@Z@e@j@p@x@|@"},
  {0,NULL,"}@~ACANARATA]AeAgArAsAyB?BGBHBJBKBOBVBbBcBgBpBtBvBwByCACBCHCICJCT"},
  {0,NULL,"CVCWC^CaCbCcCrCvCzD?DGDVDYD[DaDbDcDjDkDmDnDoDpDqD}D~E@EDEFEGEHETE"},
  {0,NULL,"UEVE`EdEsEtEwEyE|E~FNFQFTFYFaFgFmFoFrFuGCGDGEGHGJGLGOG_GiGmGnGrGt"},
  {0,NULL,"GxGzHBHCHHHJHNHQHWHXH[H\\H]HkHqHtH|ICIIILISIZIbIcIdIfIgIhIiIjIkI{I"},
  {0,NULL,"}I~J?J@JBJCJJJKJLJ`JeJgJjJoJtJ|J~K?KAKKKPKXKZK^K`KhKmKoKrKwKyK~LB"},
  {0,NULL,"LFLKLMLNLSLVLWLXLmLpLuLxMBMCMNMPMVMWMYMaMbMcMdMeMfMgMsMwMyM{M}M~N"},
  {0,NULL,"?NINJNKNYNZNhNiNjNkNtNvNxN{N~O@OAOCOGOIOKOLONOTOZO[O`OcOeOhOmOnOs"},
  {0,NULL,"OtOwO{PKPLPMPNPPPQPTPdPePfPkPlPnPoP}P~QAQJQKQQQSQUQYQbQdQiQlQmQwQ"},
  {0,NULL,"xQyR@RBRERGRIRRRWRZR\\RaRdRhRkRpRvRyR{S?SCSKSNSiSnSoSvSwSzT@TITXT["},
  {0,NULL,"TtTuUMUNUPUTUUUZU\\U]U_UaUbUfUhUkUpUuU{VAVCVDVGVKVLVNVXVYV^V`ViVsW"},
  {0,NULL,"@WEWJWRWSWWWlWmW}W~X@XJXNXOXeXfXtXvXyXz_B?H?L?T?U?V?W?X?[?]?^?`?h"},
  {0,NULL,"?l?r?u?}@A@C@E@R@]@c@d@g@l@q@t@{AAACAEAQA\\AbAcAlAmApAuAvAxAzA~BAB"},
  {0,NULL,"EBPBXB[B\\BjBpBqBsByBzCACDCECFCICUCVCWCYCdCkClCsCuCwDBDIDKDNDUD^Db"},
  {0,NULL,"DdDeDgDiDnDoDpDrE@EAEBECEDEFEIEKEYE[EaEfEiEkEvE{E}E~FLF\\F]F^F`FfF"},
  {0,NULL,"nFpFsFtFxF{F~GBGIGTGUGXGeGfGgGmGrGwHCHDHGHLHNHOHRHTHWH[HdHgHiHpHy"},
  {0,NULL,"HzIDIHIJIUIYI[I]IaIdIgIiIjIlIpIxIyIzI}J@JBJMJPJRJTJ]JdJkJlJnJrJvJ"},
  {0,NULL,"yJ}K@KFKMKQKRK^K_KkKpKrKsKuKyK|K}LBLLLPLSLVLZL`LcLhLlLnLyL}MAMGMK"},
  {0,NULL,"MZM\\M]M`MbMcMeMfMhMlMsMwMxMzM|M}NCNLNMNQN\\N]N^NlNmNnNoNqNtNuNxN|N"},
  {0,NULL,"~OCOGOQOROTOVOZO[O]O`OeOgOiOoOsOtOvOxP@PDPGPLPMPUPZP]P_PdPfPgPkPl"},
  {0,NULL,"PsPwPyQ?Q@QAQNQPQSQ^QaQdQgQkQlQtQvQyQ}R?RBRKRORTRURXR]R_RgRiRlRqR"},
  {0,NULL,"uRwRxRzSDSGSHSjSsStSuSxSyTATFT`TjTzUCUHULUOUQUUUVU]U^UbUdUgUiUlUp"},
  {0,NULL,"UqUvUwUyU|V?VBVGVMVNVSV\\VcVeVmVwWAWFWGWIWZW\\WfWqWwWzXCXEXMXTXXXhX"},
  {0,NULL,"pXuXwX{_B?H?O?T?U?W?X?Y?Z?a?b?c?h?j?o?v?|@B@D@F@M@V@\\@a@g@i@o@s@|"},
  {0,NULL,"A@ABADALAVA[A`AdAkAsAuAyA|BFBJBKBMBQBTBUBeBhBiBmBqBsBuC?CCCDCRCSC"},
  {0,NULL,"UCYC\\C]CjClCmCpCyCzDCDGDRDTD]D`DdDeDjDlDoDqDrDsDtD}D~E?EAEEEFEHEQ"},
  {0,NULL,"ESEXEaEcEnEoEzE|F?F@FGFKFMFPFdFeFoFpFqFwG@GCGEGHGPGQGZG`GdGeGkGuG"},
  {0,NULL,"vGwGyH?HDHEHGHIHUHVHcHdHgHhHkHlHoI?IBIGILIVI[I`IbIeIiIkIlImInIpIx"},
  {0,NULL,"I|I~J?JAJBJDJGJIJJJbJcJjJlJmJoJ{J~KAKBKIKJKUK[K_KeKiKkKlKnK{K|L@L"},
  {0,NULL,"ILJLLLQLRL_L`LcLdLkLoLpLzM@MCMJMSMUMVMXMZMeMgMhMiMjMlMtMuMxMyM{M}"},
  {0,NULL,"NBNFNHNINYNeNfNgNhNiNoNqNrNuNyN|O?ODOHOQOROUOVOYO\\O]O_OgOiOlOoOqO"},
  {0,NULL,"uOvOwOzO}PEPHPJPOPQPSPWP`PcPmPoPpPxPzP|Q?QBQHQLQNQTQWQ[Q^QcQeQgQo"},
  {0,NULL,"QqQtQzQ}RDRJRLRRRSRWR\\RaRdRfRnRpRtR{S?SBSISKSMSiSlSnSoS}S~T?TJTWT"},
  {0,NULL,"\\TsTvUKULUQUVUWUXUZU]U`UaUbUcUdUlUqUsUyU|U}U~V?VHVKVNV_V`VdVfVjV}"},
  {0,NULL,"W@WDWLWVWWW]WsWuW|W}XBXOXSXUXlXmXsXtXwXz_B?I?M?T?U?V?W?Y?Z?]?_?d?"},
  {0,NULL,"f?n?t?z?{@?@C@D@O@Y@_@b@e@m@r@y@zA?AAABAPAXAYA^AjAoApArAvAwAxB@BE"},
  {0,NULL,"BLBRBZB]B_BgBhBiBnBoBtC?CJCNCQCRCTCZC]CbCcChCjCtCuC|DEDHDMDODUD^D"},
  {0,NULL,"aDbDdDfDjDkDlDsDuE?EBECEEEFEGEJEME[E_E`EhEjEmEuExE}F?FJFSFXF[F_Fj"},
  {0,NULL,"FmFnFtFvFxFzF~GAGKGVGYG\\GaGcGkGnGuGxH@HAHBHEHHHIHVH\\H]HaHcHeHjHpH"},
  {0,NULL,"wI@IEIHINIWIYIZI\\IbIcIdIeIlImIoIyIzI{I|JAJBJNJSJTJYJ\\JfJgJkJrJsJy"},
  {0,NULL,"JzJ}KCKEKSKVKWKfKgKhKiKmKnKwKzK{L@LHLKLRLWLXL]L_LaLiLlLrL{L~MAMEM"},
  {0,NULL,"TMVMWMXM[M]MaMbMhMjMkMtMuMzM|M}M~N@NPNQNUNWNaNbNlNmNnNrNvNyN{O?O@"},
  {0,NULL,"OAODOHOIOKOLONOUOYO\\O_OcOhOlOmOnOqOuOyPFPGPHPIPJP^P_P`PaPbPcPiPjP"},
  {0,NULL,"yPzP{P|QBQCQJQKQTQVQYQ[QbQcQfQnQrQwQxQzQ{RDRKRMRPRTRURYR`RcRgRiRo"},
  {0,NULL,"RuRxR~SASDSHSJSgShSjSmSxSyTBTCTbTcT|T}UGUNUUUVUYUZU[U\\UaUeUhUpUqU"},
  {0,NULL,"rUtUuU|V@VCVGVIVJVKVLVSVZV[V]VkVuWCWFWGWHWTWUWcWoWyWzXAXEXKXLX[X^"},
  {0,NULL,"XrXuXyX{_B?J?K?U?V?W?X?Y?[?b?d?e?g?i?p?w?{@@@A@F@T@W@X@^@f@k@u@v@"},
  {0,NULL,"z@{@~ADAOASAUAWAiAnArAuAvAxAyBEBJBKBSBWBYB`BkBlBxB{B|B}CGCKCLCMCO"},
  {0,NULL,"CPCXC_C`CeCfCgCyD?DBDEDIDMDYD]D_D`DcDhDiDlDnDpDsDuD|D}D~EBECEFEIE"},
  {0,NULL,"JEVEXEbEeEpEqExEyE{F@FHFIFOFWFcFiFmFpFtFxF~GCGEGHGMGNGRG]GbGhGoGp"},
  {0,NULL,"GqGsG{G|G~HKHMHPHSHYHZH^H_H`HyH|I?I@IBICIUIWI^I_I`IaIeIgIhIjImIoI"},
  {0,NULL,"wIyIzI~J?JBJCJDJMJNJ[J_JgJlJoJrJyJ}J~KAKLKOKTKYKaKbKcKdKqKtKvKxLC"},
  {0,NULL,"LDLELGLOLTLULYL[L\\LoLuLyL{MGMNMSMTMUMXM^M_M`McMdMfMjMkMvMyMzM{M|M"},
  {0,NULL,"}N@NBNKNLNYNhNiNlNmNnNpNsNwNzN}OBOEOFOJOMOOOPOSOWOXO^OaObOdOfOjOk"},
  {0,NULL,"OpOrOzO{P@PAPCPIPOPPPRPZP[PaPjPmPnPsPtPvQDQEQGQIQMQOQXQZQ]Q`QhQjQ"},
  {0,NULL,"pQuQ|Q~RARFRKRRRTRURWR\\RaRdRgRiRpRuRxR{S?SDSHSKSiSjSnSoSxSyTKTLT]"},
  {0,NULL,"T^TwTxUGUHUPUQURUSUXU\\UeUgUkUlUnUoUsUuUyUzU}V@VBVDVFVLVXV[VcVfVyV"},
  {0,NULL,"~W@WFWRWTWZW]WrWvWzW}X@XCXLXUXiXnXtXuXwXy_B?J?N?T?U?V?X?Y?\\?^?_?c"},
  {0,NULL,"?g?m?s?x?|?~@?@E@N@Q@[@`@f@h@n@w@}A?A@AEAMAZA_AaAfAhArAtAwB?B@BGB"},
  {0,NULL,"HBLBNB^BaBdBjBkBrBsBuBxB~CCCECGCOCUC[C\\CdCeCgClCrCtCxDDDJDOD[D\\D^"},
  {0,NULL,"D_D`DdDfDhDiDmDoDqD}E?EAECEDEGEOEUE\\E_EbEgElErEuEvEwEzFRFUFVFZFbF"},
  {0,NULL,"hFlFmFrFuFvFzGAGDGSGWG[G^GfGhGjGsGvGwGyHFHGHKHLHMHRHSHUH_HfHgHjHm"},
  {0,NULL,"HtH~IEIKISIXIYI\\I^I_I`IaIfIiIkIlIxIzI{I|I~J@JLJUJYJZJ^JaJgJhJsJtJ"},
  {0,NULL,"zJ|K?KCKGKHKNK\\KaKjKkKlKpKqKuKvL?LELJLLLQLZL[L\\LbLcLfLiLxL|L~MHMP"},
  {0,NULL,"MRMUMYM[M]M^M_M`MeMgMhMsMuMxMyM|M~N?NRNUNVNWNZNaNbNjNkNoNpNqNuNwN"},
  {0,NULL,"|OBOFOJOOOQOROVOWO]O^ObOdOgOiOkOoOpOvP?PBPDPEPHPMPSPYP\\P]P`PfPlPr"},
  {0,NULL,"PuPwPxPzQGQIQLQNQPQRQXQ\\Q`QeQgQkQpQqQuQ}R?RCRGRIRMRPRYRZR`RcRhRkR"},
  {0,NULL,"oRvRyR~SASCSJSNSgShSmSvSwSzTUTVTZTmUEUFUGUJUNUPUQUSUWU^U`UeUhUkUl"},
  {0,NULL,"UmUnUvUyUzV@VCVDVEVHVMVOVVVYVZVhV|WCWEWHWPWSW[WgWtWyW~XDXHXJXKX]X"},
  {0,NULL,"`XrXvXyX|_B?G?L?R?S?W?X?[?\\?`?d?e?j?r?x?z?|@D@G@K@X@Z@_@`@i@q@w@y"},
  {0,NULL,"A@ABAFAKANAWA^A_AhAjAkArA|B@BEBHBJBKBOBQBYB[B_BdBeBfBgBjBmBrBtByC"},
  {0,NULL,"DCFCGCLCNCOCQCXCYCaCmCnCuCxC~DADCDHDJDNDSDTDWD^DfDrDvDxD}EFEJEKEU"},
  {0,NULL,"EVEWEZEcEjEkErEzF?FBFEFIFTFVFXF_FbFeFmFqFzF~GDGEGHGLGMGTGYGZG^G`G"},
  {0,NULL,"aGcGeGgGhGqGsG}H?HBHFHHHLHNHQH^HdHhHiHmHnHoHwH{IAIHIKIQITIVIYI[I\\"},
  {0,NULL,"IrIsI~JBJCJLJNJOJQJRJ\\JaJcJgJmJoJsJyK?KAKOKPKQKUKVK[K\\K]KeKhKjKmK"},
  {0,NULL,"pKrKvKzK|K}LCLELHLNLYL`LdLeLfLlLtLwLzL}MEMHMIMJMLMZM[M]MoMpMyM}N?"},
  {0,NULL,"N@NANCNKNNNWNXNaNbNcNdNpNqN{N|O?ODOIOJOROUOVO\\OhOiOkOlOoOuOxO{O~P"},
  {0,NULL,"?PEPGPHPJPPPSPUPXPYP_P`PcPgPnPqPrPxPyPzP|QAQOQPQVQdQhQkQnQrQyQ~R?"},
  {0,NULL,"RKRNRORSRWRZR_RaRbRfRuRvRwR{R}SBSHSNSRSXSYSZS[S\\SiSnSoT?TDTFTHTPT"},
  {0,NULL,"RTTTWTYTeThTjTkTnTrTsU?UAUBUCUDUPUYU\\U^UkUrUuUvVDVIVLVMVOVXV]VgVl"},
  {0,NULL,"VsVyWDWRWUW[WdWeWlWrW|X@XAXDXWX_XeXiXsXxYEYFYH_B?G?M?Q?S?W?Y?Z?[?"},
  {0,NULL,"b?c?d?k?t?u?x?}?~@H@J@N@]@^@a@j@r@t@w@}ACAHAIAMAOA\\A`AgAhAlAtA~B?"},
  {0,NULL,"BBBCBIBLBNBOBSBVBXB]BeBfBiBsBtBxBzB}C?CACCCECLCMCQCVC]C^C`CnCrCuC"},
  {0,NULL,"wCzDBDLDODTDVDWDYDdDhDlDyDzD|E?EJEPESEXEZE\\EdEiEmErEwE~FCFDFLFMFR"},
  {0,NULL,"FWF`FaFbFlFrFvF{F|F}GFGIGJGLGSGVG]G`GcGfGkGpGqGrGvG|G}HGHHHIHKHOH"},
  {0,NULL,"VHWHXHZHjHoHqHsH{H|IAIHIJILISIUI_IeIlItIuIwI|JDJFJIJNJQJUJ]J`JaJh"},
  {0,NULL,"JnJpJtJuJwKCKKKMKNKPKSKYK[K]KaKcKkKmKnKsKuKyL@LCLDLHLJLMLRLSLULeL"},
  {0,NULL,"lLnLpLxLyL~MBMJMLMNMOMXM_MhMqMrMuMvN@NBNENHNNNRNYNZNhNiNjNkNrNuNw"},
  {0,NULL,"NyOBOEOHOMOOOWOYO]O_OaOdOpOqOvO~P?P@PAPDPHPJPNPXPYPZP[P]P`PcPePqP"},
  {0,NULL,"rPsPtPwPzP|P~QBQIQJQUQXQYQcQmQpQwQzRERORSRTRVRYR^R_RfRgRmRoRrRwRx"},
  {0,NULL,"SBSFSJSLSOSPSQSUSVSWSkS{S|T?TATCTGTKTOTRTWT]T`TcTdThTlTqTsTxTzT}T"},
  {0,NULL,"~UBUIUPUZU^UaUjUkUvUxVDVKVMVRVYV^VoVtVvVwWAWJWMWSWiWnWpWqWwX?XJXN"},
  {0,NULL,"XZXbXgXhXpXwX~Y@YH_B?F?P?Q?S?T?Y?\\?^?a?b?c?n?r?w?y?{@C@G@H@M@R@T@"},
  {0,NULL,"`@m@q@u@x@zAAAFAHALAQASA_AiAjAmAuA|BABDBEBJBMBPBQBVBYBZB]BaBgBkBm"},
  {0,NULL,"BqBsBvB}B~CBCECICLCNCPCZC[CaCjCnCvCwC|DDDEDODSDUDXDYDZDiDmDpDvDyD"},
  {0,NULL,"~EAEQEREUEXEYE\\EhEkEpEsExE}FCFEFOFPFVF]F_FcFfFpFqFsFwF~G?GEGJGKGM"},
  {0,NULL,"GVGXGZG[GaGbGfGjGmGqGtG|H?HBHDHGHJHMHQHcHeHfHjHnHpHrH|H}IAIIIJINI"},
  {0,NULL,"WIXIaIfIjIsItIxJ?JDJGJHJLJPJUJ[J\\JdJlJmJoJvJxJyKBKEKHKKKOKRKSKUK_"},
  {0,NULL,"K`KcKeKhKkKqKuKzL?LBLCLFLGLNL_LaLbLeLmLnLrL{L|L~MAMIMMMNMQMYM`MfM"},
  {0,NULL,"oMqMxM{N?NBNFNGNMNRNWNaNbNlNmNnNpNqNtNxNzOFOGOJOPOVOZO^ObOeOfOkOo"},
  {0,NULL,"OsOxO{P?P@PAPDPJPNPPPUPYPZP[P]PcPePgPnPrPsPtPwP|P~QAQGQKQTQ[Q`QbQ"},
  {0,NULL,"dQuQxQyRDRHRIRLRORRRVR_RdRjRkRmRtRwRyS?SESFSMS]S^S_S`SaSbSlS}S~T@"},
  {0,NULL,"TDTGTMTNTRTUTXT_TaTeThTlTmTqTuTyT{UAUBUFUGULUUUXUdUeUpUsU}V?V@VGV"},
  {0,NULL,"SV[V_VgVnVpV}W?WGWTWVWdWhWjWuWxXBXEXLXWXaXcXmXqX|X}YDYGYI_B?D?P?Q"},
  {0,NULL,"?S?V?W?[?^?`?b?e?n?o?q?s@?@D@I@J@V@W@[@d@m@n@p@sA?ABAGAIAUAVAZAcA"},
  {0,NULL,"dAfAoAuAvAwAxAyAzBFBOBTBZB[B]B^B`BfBoBpBqBrBsBwCCCGCHCJCLCPCSCbCe"},
  {0,NULL,"ChCkCnCoCzC|C~D@DJDODRDWDZD[DaDqDtDwDzEBEFEIETEWEXEYEZEhElEnEtEuF"},
  {0,NULL,"?FAFDFGFHFUF^FdFhFjFpFtFxG@GAGBGCGKGLGNGPGTGVGWGbGdGhGiGnGqGvGzG}"},
  {0,NULL,"HAHCHDHFHGHTH\\H_HaHjHlHmHtH{H}IAIFILINIQIRIcIkInIqIuIyJBJDJKJMJOJ"},
  {0,NULL,"PJQJ^JbJfJlJrJzJ{J}J~K@KEKGKIKPKQKSKTK]K^K_KgKjKkKoKvKwK~LCLGLILJ"},
  {0,NULL,"LPLWL[L]LeLjLpLrLtLvL~M@MHMLMPMQMWMgMiMmMrMzM}NANBNJNLNMNNN[N_N`N"},
  {0,NULL,"eNfNgNoNvN}O?OAODOLONOQOSOUO\\OcOgOjOlOnOuOwO~P?P@PFPHPJPNPQPXPYPZ"},
  {0,NULL,"P^P`PcPePiPoPqPrPsPzP|P~QEQHQQQSQWQ]QiQlQoR@RBRFRORRRURYRZR[R_RdR"},
  {0,NULL,"iRoRsRvRwR|S?SDSJSNS]S^S_S`SaSbSjSxSyT@TCTETHTRTSTVTXTZTcTfThTiTn"},
  {0,NULL,"TpTrTuT}U@UBUEUHUKUQUTU_UcUgUlUyU{U~VBVTVcVdVhVmVxV~WCWLWNWZW`WfW"},
  {0,NULL,"gWvWyXCXFXSXXX\\X`XnXrX|YBYEYF_B?F?K?Q?R?U?Y?Z?]?a?b?d?m?p?q?r?~@E"},
  {0,NULL,"@I@K@S@V@_@c@h@p@q@v@}AEAGAKARAVA^AbAeAfAmApAwAxAzA{B@BHBSBUB[B]B"},
  {0,NULL,"aBcBdBmBpBuBwBzB|B}CACDCJCLCNCOCRC\\CcCeCiCnCpC{C}DBDDDGDLDNDXDYD["},
  {0,NULL,"D`DnDrDwD{E?ECEMERESEXE[E]EgEkEqEtEvEwFAFBFGFNFXF\\FfFgFhFnFtFzGAG"},
  {0,NULL,"BGDGGGQGTGVG[G]G^G_GaGeGnGqGrGsGuGyGzG{G|H?HCHOHUH]H_HbHiHkHrHsHt"},
  {0,NULL,"H|IAIGIMIOIUIXI[I`IgIqIvIzI|JDJHJIJSJTJWJ^JdJeJkJsJzJ}K?K@KDKHKJK"},
  {0,NULL,"QKSKYKZK\\K^KcKeKlKoKsKtKwKyKzK{K|LCLELQLXL[L^LeLgLkLqLyL|L}MCMMMN"},
  {0,NULL,"MOMPMUMZMcMmMnMuM|NBNGNHNPNQNTN\\N]N^NeNfNgNoNwN|O?OBOCOOOQOROUOWO"},
  {0,NULL,"[OdOgOiOlOpOtOwO}P?P@PAPDPFPMPQPWPYPZP[P]P^PfPiPlPoPpPrPsPtPwQ?QC"},
  {0,NULL,"QDQEQ]Q^QfQjQtQ{RARFRIRPRTRVRWR[R`RaRgRkRmRsRxRyR{R|SASFSTSZS[S\\S"},
  {0,NULL,"cSdSgShSmTETGTHTITJTKTUT[T\\T]TfTlTmTnTqTrTtTvTxU@UFULURUUUYUdUoUp"},
  {0,NULL,"UrV?VFVGVIVQV\\V]VsVuVxVzWEWIWUW^W`WaWlWoW~XAXMXVX[X\\XeXjXvXzY@YDY"},
  {0,NULL,"HYL_B?F?P?Q?S?T?Y?\\?^?a?b?c?n?r?w?y?{@C@G@H@M@R@T@`@m@q@u@x@zAAAF"},
  {0,NULL,"AHALAQASA_AlAnAoAtB@BDBEBGBIBLBRBTB[B^B_B`BbBjBkBmBtBuByB{C@CBCDC"},
  {0,NULL,"ICKCMCRC]CcCeCkCnCqCyD?D@DEDKDNDRDUDVDZDcDjDrDwDzE?EGEHEOEPEQE\\E^"},
  {0,NULL,"EhEkEpEsExE}FCFEFOFPFVF]F`FiFjFlFuFvFzF~G?GFGNGOGPGTGWGYG\\GeGlGmG"},
  {0,NULL,"oGpGtGuGyH?HHHLHMHNHPHTHVH]H_HiHlHpHqHzH}IAIBICIPIRIWI[IbIhIqIuI{"},
  {0,NULL,"I|JFJGJJJUJXJZJ]J_JfJhJpJsJxJyJ|KCKGKIKQKTKVKWKXKbKeKlKmKpKqKrKxK"},
  {0,NULL,"{K|LALBLDLFLPLRLXL[LeLoLsLuLvL{L}M@MAMBMKMQMVMZMdMmMrMuM~NDNENFNI"},
  {0,NULL,"NRNVN[N_N`NeNfNgNvNyN|O?O@OEOHOKOMONOROUO_OaOcOiOlOmOyOzO}PBPGPIP"},
  {0,NULL,"KPLPOPTPWP\\P_PaPbPdPjPkPmPpPuPyP{P}QHQQQRQUQWQ\\QiQmQoR@RCRERGRURW"},
  {0,NULL,"RXRYR^RaRhRiRlRoRrRzR{SCSDSJSLSSSZS[S\\SeSfSgShSmTBTFTITJTKTOTQT[T"},
  {0,NULL,"\\T]TbTdTgTjToTtTvTxT|T~UCUKUSUTU^U_UcUnUvUzU{U~VMVOVPVbVvVwVyV|WF"},
  {0,NULL,"WKWYW[WpWqWrWtWzXDXQXRX]XgXhXiXuXwX~Y?YF_B?E?O?R?S?T?X?\\?_?a?c?e?"},
  {0,NULL,"l?o?p?t@A@C@J@K@N@S@W@b@l@r@s@v@{AAAIAKAMAPARAUAiAjAmArAwAxB?BBBH"},
  {0,NULL,"BJBPBTBWBXB]BaBbBfBiBkBnBuBxBzCDCHCJCMCPCSCTCWCdCiCmCoCqCsCuCyC{D"},
  {0,NULL,"FDHDIDKDLDRDlDtDuDvD{D}EGEQEREUEVE^E_EfEmEnEqE{E}FBFDFHFNFRF[F_Fc"},
  {0,NULL,"FfFmFrFtF|GAGDGEGIGOGPGRGVGXG[GbGdGeGiGnGpGxGyG}H@HIHKHMHOHRH[HbH"},
  {0,NULL,"hHlHsHuHwHyHzIBIDIFIHIMIPIeInIoIsIvI{I~JCJGJHJLJXJYJ[J\\JdJgJoJtJu"},
  {0,NULL,"JzJ}K?KHKIKLKMKRKSKXK]KaKfKlKnKqKsKwK|K~LDLGLILKLVLZL^LdLhLjLlLoL"},
  {0,NULL,"qLsM?M@MEMGMKMOMXMiMkMnMoMyM~N?NDNFNGNKNUN\\N]N^NlNmNnNsNwNyN{N}O?"},
  {0,NULL,"OHOIOOOSOUOXO_OdOhOjOlOrOyOzO|O}PAPFPIPMPOPVPWP[P^PaPbPfPhPiPjPlP"},
  {0,NULL,"mPpPtP{QAQDQNQTQ[QdQgQjQyQ}RARDRJRMRQRWRZR^RaRcReRnRrRvR{R~S@SISL"},
  {0,NULL,"SNSPSQSWS]S^S_SvSwSzTDTGTJTNTPTQTSTYT\\TaTeTgTiTlToTpTqTvT{U?UAUHU"},
  {0,NULL,"NUPUVUgUhUkUqU|VBVCVDVSVYVcVhVlVsVtW?WGWSWZWeWgWlWnWxXCXEXJXZX_X`"},
  {0,NULL,"XeXqXxX~YFYGYM_B?D?O?R?S?U?W?Z?_?b?d?e?l?s?v?y?}@E@G@L@Q@T@U@Y@l@"},
  {0,NULL,"n@o@xACAEAFAJASATAXAaAgAhAlArAvBABEBGBKBLBPBRBSBUBVBXB^BkBlBmBqBv"},
  {0,NULL,"BwBxB~C@CCCFCJCRCTCYCfChCkCpCsCvCxC{D@DFDGDJDKDQDXDeDmDqDxDzECEFE"},
  {0,NULL,"JEPESEVE]E_EfElEoEsEvE~FEFFFJFOFQFZF`FaFbFmFsFuFvFxF~GHGIGJGQGWGX"},
  {0,NULL,"G\\G]GgGjGlGnGuGvGxGzG~H?HDHJHKHMHTH`HaHdHkHmHrHuHxHzIDIGIIIKIMIRI"},
  {0,NULL,"fIkIpIrIuIzJBJCJFJIJNJWJYJ]J`JaJgJrJvJyJ|KAKCKGKJKKKMKRKWKYK_K`Ka"},
  {0,NULL,"KdKeKoKqKwK{K}L?LALJLKLOLPL]L`LfLhLkLmLqLvM?MCMFMHMKMMMYMgMlMpMrM"},
  {0,NULL,"|M}N@NENHNKNTNUNZN[N_N`NjNkNoNpNtNvN|N~OJONOQOROTOZO`OcOgOiOkOsOw"},
  {0,NULL,"O|O}PBPDPIPLPMPQPVPWP\\P]PaPdPfPhPjPkPlPoPpPuPwQBQLQOQUQcQeQhQmQqQ"},
  {0,NULL,"zQ~RERKRLRMRWR[R]RaRcRqRsRtRuR{R|R~SGSHSMSPSQSWS]S^S_SjSxSyTATETJ"},
  {0,NULL,"TOTRTSTTT\\T`TdTfThTiTkTpTvTzT~U@UBUDUGUMUWU\\U`UeUfUuV@VAVHVLVVV[V"},
  {0,NULL,"^VgVkVyV{WAWJWPWTWbWcWdWrWwXHXLXNXWX^XiXkXpXxYCYDYHYN_B?G?N?Q?R?X"},
  {0,NULL,"?Y?Z?\\?`?a?c?i?s?u?z?{@A@I@L@P@Y@\\@d@k@n@t@y@z@{AGAJAXA[A]AcAlAnA"},
  {0,NULL,"oAsAvAyA}BFBGBKBSBTBVB\\B_B`BaBhBlBmBnBrBsBzC@CACECGCHCNCTCXCYCbCg"},
  {0,NULL,"CoCsCwDADBDDDHDLDMDODPDXD_DfDgDwDxD}D~EHERESETE\\E^EeEiEjElExE{FAF"},
  {0,NULL,"FFJFKFYF^F`FiFjFoFuFxFyG@GCGHGJGNGPGUGYG[G]GaGfGhGiGlGrGxG~H?H@HE"},
  {0,NULL,"HFHGHOHSH\\H^HdHjHrHsHvHwI@IDIFIJITIUIXI\\I]I^IqIrI~J?JHJIJJJKJUJXJ"},
  {0,NULL,"]J_JfJjJqJrJ{J|J~KAKFKHKIKKKTKVKYKdKeKfKiKjKkKsKuKvKyKzK~LALKLWLY"},
  {0,NULL,"L\\L`LhLjLnLwLyL|L~MDMEMMMOMTM[M\\M^MmMpMyM{NDNGNHNINJNRNXN[N_N`NcN"},
  {0,NULL,"dNpNsN}N~ODOFOJOSOTOXO\\O^O`ObOjOkOrOuOwO|P?P@PAPDPFPIPQPVPYPZP[P]"},
  {0,NULL,"P^PaPhPiPjPoPrPsPtPwQFQLQQQRQ\\Q_QeQiQqQsR@RCRIRJRMRORTR\\R_RcRgRkR"},
  {0,NULL,"nRpRwRxRyR~SISKSRSSSXSYSeSfSiSnSoTBTFTKTPTRTSTUTYT]TbThTiTjTmTpTx"},
  {0,NULL,"T|U?UBUCUFUIUJUZU]UaUbUjUmUxVEVKVNV`VaVbViVjVkVmWFWWWXWYWcWfWmWsW"},
  {0,NULL,"zXOXPXQXXX^XfXlXuX{X}X~YGYLYP_B?E?K?Q?R?V?X?[?]?`?a?e?m?t?v?w?|@?"},
  {0,NULL,"@H@L@M@O@U@]@h@o@r@uA?A@AHAJALATAYA\\AdAfAoAsAyB?BDBGBLBMBNBUBYB[B"},
  {0,NULL,"]B^BcBgBiBkBlBqBvByC?CECFCKCMCQCSCcCdCgCiCpCtCuC}DADEDLDNDQDSD\\D]"},
  {0,NULL,"DeDiDlDwD{D}EDEHEIEKELETEWEgEmEoEpEuEzFCFFFLFPFQFSFdFhFjFoFrFuFvF"},
  {0,NULL,"wG?GCGMGQGSGTGVGWG_GcGdGfGgGkGoGpG~HBHDHIHJHMHNHRHSH]HbHiHnHsHxH~"},
  {0,NULL,"I?IEIGIHIOITIWIaIeIpIqIvI~J@JEJJJKJMJOJRJ^JbJfJjJtJxJ|J~KBKCKGKJK"},
  {0,NULL,"NKOKQKSKZK_K`KdKhKnKqKrKuKxK}L@LDLHLILXLZL\\L^LgLiLkLlLwL{L}MFMIMO"},
  {0,NULL,"MRMSMXM`MlMmMnMsMyNANCNINJNLNON\\N]N^NeNfNgNqNwNyN|N~OFOHOOOROTOVO"},
  {0,NULL,"^O_O`ObOdOiOoOxOzPBPCPEPGPHPKPOPRPSPTPUP\\P_P`PgPmPuPvPxPyPzP}Q?QE"},
  {0,NULL,"QMQQQZQ]Q^QiQtQ|R@RFRIRKRNRPR\\R^R`RbRkRpRrRuRyR}SASHSKSLSPSQSWS`S"},
  {0,NULL,"aSbSvSwSzTCTDTFTLTQTSTVTZT^TcTeTgTiTjToTpTwT}UAUCUEULUMURUZUaUdUf"},
  {0,NULL,"UoV?VAVFVKVTV^V_ViVkVnVvWCWJWNWVWcWhWmWpWyXBXFXNX^XaXfXgXrX{X}YEY"},
  {0,NULL,"HYN_B?G?N?Q?R?X?Y?Z?\\?`?a?c?i?s?u?z?{@A@I@L@P@Y@\\@d@k@n@t@y@z@{AG"},
  {0,NULL,"AJAXA[A]AcAiAjAmApAvAwA{A}BABCBQBWBXBYBZB^BbBiBoBrBsBwByB{C?C@CCC"},
  {0,NULL,"FCICOCTC\\C^C_C`CtD?D@DADBDCDJDMDNDPDVD]DbDdDqDyD{E?E@EHEKEMEQEREU"},
  {0,NULL,"EeEiEjElExE{FAFFFJFKFYF^F_FcFfFnFsFxFyF}GAGGGIGKGMGOGRGWGZGgGkGlG"},
  {0,NULL,"mGsGvGxGzHAHFHGHIHNHPHUHXHYHZHiHmHqHvI?I@ICIEIRITIUIVIdIkIlItIvI|"},
  {0,NULL,"I}JGJHJJJLJRJSJ[J\\JdJkJqJrJvJwJzKDKEKGKLKMKOKUKXKbKgKjKkKnKoKrK}L"},
  {0,NULL,"@LALBLELJLKLMLQLTLULiLuLvLwLyLzL}MBMDMHMSMTMbMgMhMnMqMuMwN?NCNFNG"},
  {0,NULL,"NINPNYNhNiNlNmNnNoNrNuNvO@OCOKONOQOYO[O]OcOgOmOqOtOvOxOyPCPEPGPHP"},
  {0,NULL,"KPLPRPSPTPUP_P`PbPdPgPkPvPxPyPzP{P}QDQGQKQNQ`QbQgQjQuQxQ}RARGRNRP"},
  {0,NULL,"RSRXR[R`RbRfRhRlRsRzR|R}SASBSCSOSUSVS]S^S_SkS{S|T?TDTGTITNTOTVTWT"},
  {0,NULL,"ZT[TaTdTeTlTqTsTtT{T~UAUEUOUQUYU\\UiUlUrUuUwUyVIVLVWV[VcVqVxVzV{W?"},
  {0,NULL,"WQWTWZW_W`WaWbWxXCXIXLX\\XdXjXkXqXzY?YDYF_B?F?K?Q?R?U?Y?Z?]?a?b?d?"},
  {0,NULL,"m?p?q?r?~@E@I@K@S@V@_@c@h@p@q@v@}AEAGAKARAVA^AbAgAhAlAsAzA|BBBFBH"},
  {0,NULL,"BKBNBOBPBRBWB^BeBjBnBoBvByB|B}C?CDCGCICJCPCSCXCZC[ClCqCtC}C~D?DDD"},
  {0,NULL,"IDNDPDUD[D\\DaDpDuDxDyD~EEEHEJELEMEPESEgEkEqEtEvEwFAFBFGFNFXF\\F`Fa"},
  {0,NULL,"FbFoFqF|G@GBGDGHGLGRGSGWGXG\\G`GbGdGeGhGkGmGnG{G|H@HAHJHLHNH^HeHfH"},
  {0,NULL,"gHiHpHtHvHyH~ICIEIOIPIQIXIcIjIoIrItJ?JAJEJFJIJJJNJSJ]J`JaJjJmJuJ{"},
  {0,NULL,"K?K@KAKGKLKNKPKRKWK[K`KcKfKgKpKrKtKvKwK|L@LBLGLILYLaLbLcLgLiLsLtL"},
  {0,NULL,"uL|L}MAMDMGMPMRMWMfMkMpMqMtM{N@NENHNINONPNWNZNaNbNjNkNsNxNzN{OAOD"},
  {0,NULL,"OGOIOLOPOXO\\OeOfOhOnOrOuOyO{O~PCPEPGPKPLPPPRPSPTPXP_PbPdPkPnPqPvP"},
  {0,NULL,"xPyP{P}QIQJQLQOQXQYQeQhQpQqQwQ~RHRJRNRURXR\\RbRiRjRlRnRpRzR}SDSESI"},
  {0,NULL,"SKSPSQSWS`SaSbSlS}S~TATBTDTLTMTOTRT^T_T`TbTdTeThTwTyTzT|T~UAUBUKU"},
  {0,NULL,"NUSU]UbUcUhUnUzU~VCVNVVVYVdVjVlVmVrWAWLWPWSWeWfWkWsWwXHXJXSXXXYX_"},
  {0,NULL,"XlXpX{X~YBYCYI_B?G?L?R?S?W?X?[?\\?`?d?e?j?r?x?z?|@D@G@K@X@Z@_@`@i@"},
  {0,NULL,"q@w@yA@ABAFAKANAWA^A_AdAfAoAqAzA{A|B@BDBIBNBPBTBUBZB`BcBhBjBnBwBx"},
  {0,NULL,"ByB}B~CICLCMCNCTCUCVC\\C]C_CrCsCxCyDCDDDFDGDHDMDTDUDbDhDpDzD{D|E@E"},
  {0,NULL,"IETEVEWE]E^EcEjEkErEzF?FBFEFIFTFVFXFdFhFjFkFqFzG?GBGFGGGKGNGPGQGS"},
  {0,NULL,"GXG_GaGjGmGpGqGwGxGzG|H@HEHKHLHNHUHVHWHYHkHoHpHuHwI@IBIDIKISIVIXI"},
  {0,NULL,"_IdIjIuIvIwI}JCJKJMJOJWJXJ^JbJfJiJmJpJsJxK@KDKEKIKJKNKRKTKZKaKcKf"},
  {0,NULL,"KiKoKpKrKzL?LBLCLDLKLLLQLRLSLTLfLhLoLxLzL|M?MAMCMEMJMTM_MbMfMnMrM"},
  {0,NULL,"vMwNANDNJNKNLNTNYNeNfNgNhNiNxNzO@OBOCOEOGOKOMOPOWO[OaOeOfOmOpOtO|"},
  {0,NULL,"O}PAPBPFPIPLPMPVPWP[P\\P^PaPdPfPhPiPjPkPlPpPtPuQ?QHQMQSQWQZQ^QlQoQ"},
  {0,NULL,"tQ|RBRGRHRMRQRTR]RcReRgRhRjRqRxR~S@SCSESGSOSUSVS`SaSbSkS{S|TATCTI"},
  {0,NULL,"TKTNTSTVTZT[T]T`TaTcTiTpTtTxTzT{T}UEUJUXU[U]UbUmUsUtU}VEVJVNVUV_V"},
  {0,NULL,"dVpVrVuV|WCWLWOWVWjWkWoWtWyXBXGXSXYX[X]XcXrXyX}YAYBYMYN_B?G?M?Q?S"},
  {0,NULL,"?W?Y?Z?[?b?c?d?k?t?u?x?}?~@H@J@N@]@^@a@j@r@t@w@}ACAHAIAMAOA\\A`AeA"},
  {0,NULL,"fAmAuAxAyA~B?BJBMBRBUBWB\\BbBcBdBgBjBlBoBxBzB{B~C?C@CDCHCQCUCaCbCg"},
  {0,NULL,"CmCqCrCtCwCxD@DFDPDQDUDVDWD^DgDkDvDwD~EFEIEMEPEQEXE]EdEiEmErEwE~F"},
  {0,NULL,"CFDFLFMFRFWFfFgFhFpFrFtFwF{GCGEGOGQGRGUG\\G^G_GcGeGiGjGkGlGwG~HAHB"},
  {0,NULL,"HKHLHOHPHQHSH\\HhHpHqHuHvHxH{IEIJIKIPIRISIYIZI]IqIsJ?JBJDJFJGJMJSJ"},
  {0,NULL,"WJ^JdJeJlJnJoJtJ}J~KBKFKJKLKWKXKZK\\KaKbKdKgKhKpKsK|K~L?L@LALHLLLN"},
  {0,NULL,"LWL\\LdLfLiLnLsLvLxM?MAMBMDMFMLM\\M]MaMmMoM{M}NBNENFNLNPNTNXN\\N]N^N"},
  {0,NULL,"cNdNqNtN{N}N~OAOIOLOSOTOVOZO`OhOjOnOoOsOyOzO|PBPGPKPLPMPOPTPVP\\P_"},
  {0,NULL,"PbPdPfPhPkPlPmPuPyP{P}Q@QCQEQTQ[Q]QaQfQvQ{RDRFRGRLRMRNRRRURbRcRdR"},
  {0,NULL,"hRiRtR}R~S?SCSDSMSRSTSXSYScSdSiSnSoTBTDTHTITSTTTUT[TbTeTiTkTmTnTp"},
  {0,NULL,"TrTtT|UAUDUFUOUQUXU[UiUlUsUtUwUyU}VJVQVeVfVhVnV}V~WEW\\W]W^WgWhWuW"},
  {0,NULL,"vW~XTXUXVX`XaXmXnXvX|YBYCYDYOYR_B?F?L?R?S?T?U?\\?]?^?_?d?j?q?u?w@B"},
  {0,NULL,"@F@J@L@O@P@[@^@i@p@t@u@|ADAIAJAOAYAZA]AdAgAiArAvAwAyB?BCBLBNBQBZB"},
  {0,NULL,"\\B`BcBeBgBoBqBtBzB{B|C@CACBCECGCOCSC\\C]CiCkCvCwCyC}C~DCDGDIDPDSDT"},
  {0,NULL,"DZDcDgDnDzD{ECEGEJELENEUEYE_EcEiEpEtE|F@FDFFFSFUFWFYFaFcFdFmFrFvF"},
  {0,NULL,"xF}GAGCGKGNGSGUGZG_G`GdGfGhGlGrGsGtG{HAHBHDHHHOHPHTHUHVHbHkHnHoHv"},
  {0,NULL,"HyH}IBIIIJIOIQIVI]IgIhIuIvIzI{JEJLJNJPJVJYJ[J`JbJgJrJtJwJzJ~KCKEK"},
  {0,NULL,"FKNKTKUKZK[K_KbKgKhKmKsKtKuKvKyLALELFLILPLQLRL^LgLmLnLoLtLzMCMDMG"},
  {0,NULL,"MIMJMQM\\McMdMnMrM|M~N?N@NMNONSNUNYNeNfNgNhNiNvNwN}N~OCOEOMONOOOSO"},
  {0,NULL,"TO[O`OaOcOdOjOtOxO{O~P@PCPHPKPNPPPRPTPUPXPZP`PePgPnPqPsPvPzP}P~QB"},
  {0,NULL,"QMQNQSQZQcQgQlQzQ|Q}RBRHRKRMRVRXRZRcRjRlRmRuRvRzR~SESFSHSNSRSXSYS"},
  {0,NULL,"ZS[S\\SgShSmTETFTGTHTMTOTQT_TdTfTgTjTlTnToTqTrTyT~U@UCUGUNUXU]UbUe"},
  {0,NULL,"UhUsU}V@VCVNVZV`VfVhVkVtV{WBWHWWW]WbWcWgWnW{XKXOXUXZX^X`XkXoXxYAY"},
  {0,NULL,"CYGYJYLYRYS_B?E?M?Q?S?T?V?[?]?^?_?c?k?p?v?z@@@B@G@I@Q@X@\\@c@j@o@v"},
  {0,NULL,"@y@|@~AFAGAWA[AaAbAdAgAiAuAvAzA{A|BABKBNBSBXB_BbBcBeBhBlBnBrBuBvB"},
  {0,NULL,"{CDCFCJCKCNCOCUCVC[C^ChCqCrCzC{DADEDHDQDRDVDYD\\D`DfDsDyDzEAEBEIEL"},
  {0,NULL,"EOEQEYE_EdEjEoEqEyE|FAFEFIFKFZF\\FaFcFdFpFqFsFxGBGGGHGIGOGSGYG]G_G"},
  {0,NULL,"`GaGeGgGnGoGsGwGyG~H@HEHFHJHPHWHXHaHfHlHqHwHxH|H~ILIMIPISITIWI\\I`"},
  {0,NULL,"ImItIuIxIyJEJGJMJPJYJZJ[J`JbJlJmJrJvK@KAKDKMKNKVKXKYKZK[K`KbKdKfK"},
  {0,NULL,"iKjKlKwKxKzK|K}LELLLMLSL]LbLpLqLsLwLxL{M@MBMEMFMNMRMUM[MjMqMrMxMz"},
  {0,NULL,"NFNLNMNONUNVNYNZNhNiNjNkNoNpNrNzOBODOJOPOQOWOYO\\OfOgOkOpOqOuOyOzO"},
  {0,NULL,"}PBPCPEPIPLPOPRPSPWP\\PaPbPdPjPkPmPpPuPvPxP{QBQIQKQSQXQbQcQlQpQxQz"},
  {0,NULL,"RBRLRORPRQRUR^R_R`ReRiRrRtRwS@SASDSLSMSRSTSXSYScSdSsStSuTBTETMTNT"},
  {0,NULL,"QTTTVTZT_TaTbTfTgTkToTyT{T|U@UDUEUHULUPUZUaUdUgUkV?VBVDVKVXV\\V`Vg"},
  {0,NULL,"VmVpVxWBWIWRWWW`WdWfWjW{X@XMXOXWXXX\\XcXoX|Y@YEYGYPYSYTYU_B?D?P?Q?"},
  {0,NULL,"S?V?W?[?^?`?b?e?n?o?q?s@?@D@I@J@V@W@[@d@m@n@p@sA?ABAGAIAUAVAZAcAh"},
  {0,NULL,"AjAkAtAwA}BBBCBFBHBPBQBRBYB_BaBcBiBjBlBpBuBwB|C@CACGCKCSCTCUCWCZC"},
  {0,NULL,"`CjCrCsC|C}D@DEDGDODQDRDUD]D_DnDoDvDyD|EDEIEKEOEPEVEZEhElEnEtEuF?"},
  {0,NULL,"FAFDFGFHFUF^F_FbFeFlFyF|F}G@GAGDGMGXGYGZG[G\\G_GdGhGlGoGrGwGxGyGzG"},
  {0,NULL,"{G~HCHIHLHZH[HcHeHjHkHlHpHxI?IDINIOIRISIWI^IgIiIsItIwJ@JCJFJMJQJR"},
  {0,NULL,"JZJ\\JaJcJhJqJuJwJzJ{K?KHKOKRKUKVKWKZK^KdKlKnKoKpKtKvKxKyLALILKLLL"},
  {0,NULL,"ULVL_LaLgLhLrLvLxL{L~M@MAMCMFMSM^McMeMoMqMsMvNCNENKNLNNNVNWNaNbNl"},
  {0,NULL,"NmNnNsNuNwNxOCOFOGOOOXO[O]O^ObOdOeOrOtOvOyOzO|PBPCPEPLPMPOPRPSPVP"},
  {0,NULL,"\\PbPdPfPhPkPlPmPuPvPxP{QAQGQJQVQYQ`QdQnQrQuQwQyRGRLRVR\\R]R^RhRmRp"},
  {0,NULL,"RqRrRtSCSFSGSKSLSMSSSZS[S\\SeSfSpSqSrT?TATITLTPTQTTTWTYT[T^T`TgTkT"},
  {0,NULL,"oTsTtTwTzU?UDUGUIUUUWU`UeUjUpUxV@VGVHVZV]VaVjVoVtVzWDWHWUWXWaWiWn"},
  {0,NULL,"WsW|XAXKXPXZXbXjXlXsXwX}YAYHYOYSYT_B?D?N?Q?R?U?V?Z?]?^?_?`?i?o?x?"},
  {0,NULL,"y@@@F@H@K@R@Z@a@b@k@s@w@x@~ADAHAKANAPAQA`AeAkAnApAxA~B@BEBIBJBNBT"},
  {0,NULL,"BVBWBYB\\B_BfBiBoBtBuBvBxB~CBCFCICLCSCUCYCbCeCfCoCrCvC}D?DADPDRDTD"},
  {0,NULL,"XD\\D]DhDmDtDwDxEBECEKELEMENEOE[EeEnErEsEyF@FBFCFMFTF[F]FeFgFiFnFt"},
  {0,NULL,"FzF{F~GEGFGJGMGPGRGSGUGYGdGgGjGmGqGtGwGyG}HAHHHIHJHKH\\H_H`HdHlHoH"},
  {0,NULL,"rHvH~I?ICIFIIIOISITI_IfInIqIrIyIzJEJRJSJTJVJZJ_JcJeJkJnJoJpJsJyJ}"},
  {0,NULL,"KFKIKKKLKNKOKVK]K`KaKgKlKmKnK}L?LBLCLFLILLLOLWL[L`LgLjLmLuLwLxM@M"},
  {0,NULL,"DMJMMMRMSMYM_MiMmMpMzM|NCNONPNQNSNVNXN[N_N`NcNdNpNtN}O?OBOEOJOMOS"},
  {0,NULL,"OUOWOZOaOjOkOlOpOsOzO{O~PBPCPEPGPKPOPPPRPSPTPXP\\P_PmPnPqPuPvPxPyP"},
  {0,NULL,"}QCQFQPQRQ\\Q_QfQkQsQ{R?RCRLRPRTRXRZR\\R`RgRlRpRtRvRxRzSASKSMSNSOSU"},
  {0,NULL,"SVS]S^S_SjSxSyT@THTJTLTOTTTVTXTZT\\T^TdTkTnTrTuTvTwT~UDUEUIUJUUUVU"},
  {0,NULL,"jUmUpUqUxU|VEVGVRVSVUVsVuVwV}W@WGWMWOWlWoWqWuW}X?XEXGX[XeXhXmXtXz"},
  {0,NULL,"Y@YAYGYIYNYV_B?F?L?R?S?T?U?\\?]?^?_?d?j?q?u?w@B@F@J@L@O@P@[@^@i@p@"},
  {0,NULL,"t@u@|ADAIAJAOAYAZA]AeAkAnAqAyA}A~BCBFBMBOBTBUBXBYB_BdBkBnBoBpBsBw"},
  {0,NULL,"B{B~C?CACECJCKCMCXCaCjClCxCyC{C~DBDEDGDHDKDSDVD[DaDdDiDvDxEAEEENE"},
  {0,NULL,"OE[E]E^E_EcEiEpEtE|F@FDFFFSFUFWFYFeFgFiFkFwFyF{F}G@GCGIGLGMGPGQGY"},
  {0,NULL,"G^GfGjGkGnGoGpGrGzH@HAHCHGHMHPHQH^HcHgHkHnHqHtHwHzIBIKIMIQIUIWIaI"},
  {0,NULL,"cIlIrIsIxJAJTJVJWJXJYJZJ_JcJeJiJnJqJwJ{J~KBKIKJKMKOKPKVK\\K^KbKfKg"},
  {0,NULL,"KkKoKqKuKwKxKyL?L@LDLNLYL_LcLfLoLqLtLyL{MBMCMEMIMKMPMWM`MhMoMpMtM"},
  {0,NULL,"xNDNQNSNTNUNVNWNXNaNbNcNdNqNrNuOAODOFOLOVOYO\\O]O^ObOnOoOqOuOvOwOy"},
  {0,NULL,"OzO|O}PDPIPMPOPQPVPWP]PaPbPfPhPjPlPmPoPpPwP{Q@QFQPQVQ_QaQkQnQrQsQ"},
  {0,NULL,"vR?RIRQRSRURWR]RaReRfRiRkRqRyR{S@SBSDSGSOSUSVS`SaSbSlS}S~T@TATBTJ"},
  {0,NULL,"TLTNTUTXT\\T^T`TaTbTmTuTvTwTzT{T|UFURUTUYU^U_UoUrUvU{VFVIVMVRVTVWV"},
  {0,NULL,"iVoVqV~W@WMWNWQW_WiWmWvW}X?XFXIXbXdXfXnXtXyY?Y@YEYQYVYY_B?D?O?R?S"},
  {0,NULL,"?U?W?Z?_?b?d?e?l?s?v?y?}@E@G@L@Q@T@U@Y@l@n@o@xACAEAFAJASATAXAaAeA"},
  {0,NULL,"fAmAqA{A}BABDBGBMBWB[B\\B]BaBbBeBhBlBrBsBtBvB|CBCCCGCICKCQCRCWC_Cd"},
  {0,NULL,"CjCsCuCvCzC~D?DIDJDKDODTD\\D_DjDsDvD{D|EEEJEMENEWEXE]EfElEoEsEvE~F"},
  {0,NULL,"EFFFJFOFQFZFfFgFhFkFsFuFwFyG?GGGOGRGTGUGVG[G`GcGhGmGoGtGuGvG{G~HE"},
  {0,NULL,"HFHGHHHJHRHYH[HcHjHmHoHyHzH~ICIDIHIIILIQI^IbImIsIvIwJAJDJNJOJSJVJ"},
  {0,NULL,"WJ^JdJeJiJqJvJxJ|KBKDKFKHKLKQKSKXK[K`KdKiKjKkKmKtKvKxK{LBLFLHLJLT"},
  {0,NULL,"LVLZL_LhLlLmLpLtLuL~MGMHMJMKMRMVM^MjMnMoMtMvN@NANBNPNSNTN\\N]N^NlN"},
  {0,NULL,"mNnNrNsNyNzO@OFOHOKOPOXOYO^O_ObOfOmOqOrOxO{O~P?PCPHPJPKPPPRPTPUPX"},
  {0,NULL,"PYP`PcPgPnPqPrPvPzP|P}Q?Q@QDQTQ[Q^QaQjQtQvRARDRHRQRSRYRZR\\ReRfRjR"},
  {0,NULL,"oRpRvS@SBSESJSKSNSSSTScSdSeSfSpSqSrT?TCTHTITLTMTUTWT[T^T_TcTmTnTr"},
  {0,NULL,"TsTtTwTyT}UFUHUJUTUVU_UgUmUqU{U|VBVEV\\VbVeViVpVqV|WEWIWYW\\W_WjWmW"},
  {0,NULL,"tW~XMXQXTX]XcXdXfXvXyX~Y@YBYKYRYS_B?E?O?R?S?T?X?\\?_?a?c?e?l?o?p?t"},
  {0,NULL,"@A@C@J@K@N@S@W@b@l@r@s@v@{AAAIAKAMAPARAUAlAnAoAqAxAzA~BBBFBIBQBRB"},
  {0,NULL,"SBVB[B\\B^BgBiBpBrBuB|B}C?CBCHCOCPCQCUCVCfChClCtCuCvC{C|DCDFDIDJDS"},
  {0,NULL,"DYD]D`DkDoDxDzE@EAEHENEUEWE\\E^EfEmEnEqE{E}FBFDFHFNFRF[F`FiFjFkFtF"},
  {0,NULL,"{F|G@GBGFGJGTGUGWGZG\\G]GbGcGiGkGsGtGwGyG{G|HBHCHFHIHWH`HaHgHmHnHu"},
  {0,NULL,"HyH|I?IEIHIIIMINIVIZI`IiIrIuIxI}JJJLJOJUJVJXJ]J_JfJiJnJpJuJ{J}K@K"},
  {0,NULL,"FKGKKKQKUKWKYK^KcKhKjKlKnKtK~L@LELFLGLHLLLOLSL]LcLiLlLmLqLrLzM?MG"},
  {0,NULL,"MHMIMNMSMUMaMeMpMrMwMxN?NANDNINRNSNZN[N_N`NjNkNoNtNuNxOAOBOGOLOQO"},
  {0,NULL,"WOZO]OeOgOnOpOsOvOxO{O~P@PEPGPHPNPPPSPUPXPZP_P`PePgPnPqPsPxPyPzP~"},
  {0,NULL,"QFQHQLQUQWQ_QeQmQoQqQsRERHRKRPRRRSR]R`RdRfRjRqRuS?SASBSESGSHSSSTS"},
  {0,NULL,"cSdSeSfSsStSuT?T@TBTFTKTMTVTWTXTZT]T_TbTjTsTuTxTyT|UCUEUMURUWU[U`"},
  {0,NULL,"UfUoUtVAVFVHVJVPVQVaVoVrVuV~WFWKWXW^WiWkWoWvWzXPXRXVXYX[XbXnXuXyX"},
  {0,NULL,"}Y?YDYJYLYTYZ_B?E?M?Q?S?T?V?[?]?^?_?c?k?p?v?z@@@B@G@I@Q@X@\\@c@j@o"},
  {0,NULL,"@v@y@|@~AFAGAWA[AaAbAeAkAnAtA{A}B@BGBHBKBOBUBVBWBZB\\BdBfBhBnBqByB"},
  {0,NULL,"|B}CCCECFCOCPCRCTCWCcCgCmCpCqCwCzC|DCDIDMDQDWDYDZDbDeDuDvDwEDEGEN"},
  {0,NULL,"EOEYEZE[E\\EdEjEoEqEyE|FAFEFIFKFZF\\FeFgFiFlFuFyFzGDGGGHGJGKGLGQGRG"},
  {0,NULL,"UG^GbGfGgGsGuGvGxG{G|G}H@HDHEHNHSH[H]HhHxHyH{H|H}I@IGIJILINIPIVId"},
  {0,NULL,"IoIpIqIsI{J@JPJQJTJUJVJZJ_JcJeJhJqJsJ|K?KAKDKEKFKJKKKLKPK\\K]K_KcK"},
  {0,NULL,"fKiKrKtKuK{K}LELGLJLKLVLXL\\LdLkLnLpLrLsLzMFMGMLMNMQMTMbMkMlMmMoMs"},
  {0,NULL,"M~NMNNNQNRNSNVNXN\\N]N^NcNdNsN{N|N~O@OCOIOKOROTOXO[O`OhOiOmOrOtOwO"},
  {0,NULL,"xO{P?P@PFPJPNPPPQPUPYPZP^PcPePgPiPnPoPrPsP|P~Q@QCQRQVQ\\QaQfQnQrQv"},
  {0,NULL,"Q{RCRGRJRKRRRVRYRdRhRmRnRoRuS?SCSFSHSISJSOSPSQSUSVSWSvSwSzT@TCTFT"},
  {0,NULL,"GTJTLTPTXTYT\\T^TcTjTlTqTuTvTwT}U?UCUOUSUWU[U`UiUnUtUwUzVHVJVUVVVW"},
  {0,NULL,"VjVyVzV|W@WOWPWQWaWrWsWtW}XGXHXIX]XiXjXlXtXwY?YAYCYIYMYQY\\_B?E?K?"},
  {0,NULL,"Q?R?V?X?[?]?`?a?e?m?t?v?w?|@?@H@L@M@O@U@]@h@o@r@uA?A@AHAJALATAYA\\"},
  {0,NULL,"AhAjAkApA~BABCBEBLBMBOBPBRB`BaBdBeBgBhBpBqBxBzB{CBCCCHCKCMCNCRC[C"},
  {0,NULL,"^CfClCoCpCtCyCzDDDFDLDMDZD[D\\DcDkDsDxDyE@EBEKERETEVEZE[EgEmEoEpEu"},
  {0,NULL,"EzFCFFFLFPFQFSF_FbFeFnFsFvFwF{F}F~GLGNGXG[G\\G^G`GaGiGoGpGtGuGvHBH"},
  {0,NULL,"CHDHEHKHOHPHXH`HfHgHsHtHuH}H~I@IBIEIFIGILIXIZIhImIrItIyI}JCJHJKJQ"},
  {0,NULL,"JRJTJ\\JaJcJkJnJvJwJyKBKCKHKPKRKTKWK[K\\K^K_KaKbKhKiKsKxKzK{K~LDLFL"},
  {0,NULL,"JLMLOLbLcLiLjLkLoLpL|M?MOMPMQMRMTMaMdMjMpMqMwMzNCNGNJNKNNNQNWNZNa"},
  {0,NULL,"NbNjNkNrNtNvNzOAOEOLOMONOPOYOZOaOcOfOnOqOsOwO|PAPDPFPIPJPNPQPVP[P"},
  {0,NULL,"]P^PaPcPePhPiPjPoPtPwP|P~QGQJQOQPQYQ`QhQkQuQwQ~R?RJRQRRRTRXR[RdRe"},
  {0,NULL,"RgRlRnRsRxRzR|S?S@SISTSZS[S\\ScSdSsStSuT?T@TETKTNTPTTTWTXTYT]TaTfT"},
  {0,NULL,"kTsTuTxT{U?U@UDUNUOUSUVUhUiUnUqUwUzU|VCVOVZVeVqVwV{V}WDWHW[W\\W_Wb"},
  {0,NULL,"WqWuW|XDXKXTXdXhXkXmXsXzYAYBYFYJYKYPY[_B?D?N?Q?R?U?V?Z?]?^?_?`?i?"},
  {0,NULL,"o?x?y@@@F@H@K@R@Z@a@b@k@s@w@x@~ADAHAKANAPAQA`AdAgAiAsA|B?BBBDBIBJ"},
  {0,NULL,"BQBSBXBZB`BbBdBfBhBjBkBmBpBtB~CACHCPCQCRCUCZC_C`CdCoCpCxC|D?DBDKD"},
  {0,NULL,"MDWDXD[D]D^DjDoDyD{EDEEELESETEYE[E_EeEnErEsEyF@FBFCFMFTF[F]FaFcFd"},
  {0,NULL,"FoFqFrF|G?GEGFGIGKGNGOGZG]G^GbGcGiGjGrGuGwG}H?HCHEHHHLHMHRHYHZHeH"},
  {0,NULL,"rHtHzH{I?I@ICIFIGIKINIUIYIbIiItIvJ@JAJEJIJKJPJTJYJ[J`JbJjJmJoJpJt"},
  {0,NULL,"JuJxKEKMKTKUKXKYK\\K]K^KeKiKmKpKqKyK{K~L?LGLHLLLTLULZLaLfLjLkLrLuL"},
  {0,NULL,"yMKMLMMMPMSMTMVM]MeMnMqMsMtNHNJNMNONQNUNYNhNiNlNmNnNqNuNxNyN{O@OG"},
  {0,NULL,"OHOIOKOVO]O_OeOhOmOoOvOwO}PAPDPFPJPMPNPQPWP[P]P^PcPePfPiPlPoPpPtP"},
  {0,NULL,"wP|P~QIQKQMQNQXQZQbQgQpQxQ|Q}RIRJRNRYR[R]RbRkRnRoRqRsRyR|R}SGSISJ"},
  {0,NULL,"SRSSSXSYSeSfSpSqSrTATCTETMTPTQTUTYT_T`TcTfTgTmToTyTzT}U?U@UFUKUMU"},
  {0,NULL,"QU\\UcUfUlUuUyU~VAVLVPVXVfVlVnVrVvWBWKWRW]WeWhWkWpW{X@XRXUXYX_XaXg"},
  {0,NULL,"XoX{Y?YCYEYJYKYOYU_C?G?I?J?M?N?Y?Z?\\?_?c?d?j?p?y@@@C@E@J@L@M@V@X@"},
  {0,NULL,"Z@i@v@x@~AAAEAIAJALANAVAWAhAjAkAsAuAvAxAzB?BCBDBGBXB\\B]B^B`BcBfBg"},
  {0,NULL,"BjBlBwBzB{C@CACFCGCHCMCNCWCfCjClCnCpCuCzC|DEDJDNDRD[D\\D]DaDiDoDpD"},
  {0,NULL,"rDsDwD|E@EOEWE[EcEqEsEvEyE}FDFFFGFIFPFTF_FbFeFoFpFrFtFuFxF}G?GBGI"},
  {0,NULL,"GNGUGVGWG_GaGgGhGiGlGpGrGzG}G~HBHLHOHPH[H`HcHgHiHlHmHtH~I?IAIGIHI"},
  {0,NULL,"LINIWI[IaIcIiIjImIqIwI}JOJTJZJ\\JaJcJjJlJrJtJwJxJ|J}K@KFKGKMKSKTKZ"},
  {0,NULL,"K]KbKdKhKoKpKsKvKyKzK}K~LALDLOLVL_LcLeLkLlLpLrL{L}M@MHMPMRMSMWMZM"},
  {0,NULL,"`MeMfMjMmMvMwNANQNVNWNXNaNbNcNdNoNyO@OBOHOKOQOWO_OgOmOpO|P@PKPTPV"},
  {0,NULL,"PZPhPsP}Q?QDQHQIQKQUQWQXQ^QbQjQmQoQpQtQxRARERQRSRWR[R]R^RaReRfRqR"},
  {0,NULL,"rRsR{R|S@SBSGSLSRSXSYSgShSiSmSnSoT@TBTFTHTLTMTUTXT^T_TbTjTmTnTrTu"},
  {0,NULL,"TwTyT|UCUFUPUSUUU\\UkUnUpUuUzVDVGVLVTVUVYV[V`VaVeVfVgVlVwVzWCWNWOW"},
  {0,NULL,"SWTWWWXW\\W]WaWdWeWqWyXFXGXJXLXOXPXTXUXWX_XhXjXrXxX~YAYCYDYGYIYLYM"},
  {0,NULL,"YNYRYXYYY[Y\\Y]Y_Y`_C?E?I?J?K?M?V?[?]?_?d?e?l?q?x?~@D@F@G@L@N@R@S@"},
  {0,NULL,"d@l@p@w@}ABADAFAJAMAQARAcAiAjAmAsAtAyB@BABFBIBKBLBUBVB^B_B`BeBiBk"},
  {0,NULL,"BqBrBvByBzCBCCCDCECFCPCTC\\C_CaCjCnCoCyD?DBDDDHDODPDRDUDVD_DdDjDoD"},
  {0,NULL,"pDtDwE@EAEMEXE^EfErEtEwF?F@FEFFFNFRF]F^F_FcFfFlFoFsFvFzG@GCGFGHGJ"},
  {0,NULL,"GNGQGWGYG`GbGeGfGgGtGvGxHDHFHIHJHMHNHOHQHUHYHcHjHlHpHqHvHwIAIBICI"},
  {0,NULL,"FIUIXI^IbIiIjIlInIqIxI}JDJSJXJ[J\\JdJhJjJpJsJvJ{J~KAKCKGKJKKKTKVK["},
  {0,NULL,"K_K`KjKnKqKrKsKuK|K}LFLGLJLKLNLQLTL_LeLjLoLuLyL|L~M@MAMBMDMEMVM^M"},
  {0,NULL,"eMfMhMiMmMwMxNBNDNPN\\N]N^NlNmNnOAOBODOEOLOMOWO\\OaOnOpOuOwOxPBPQPU"},
  {0,NULL,"P\\PgPoPuQFQHQIQJQPQSQWQXQYQ_QkQlQoQpQsQwR?RBRHRORQRSRXRZR_ReRfRjR"},
  {0,NULL,"lRvRwRzS@SBSESNSPSQSWSjSvSwSxSySzTATCTITJTLTSTUT[T\\T^T`TcTiTmTpTt"},
  {0,NULL,"TvTwTzT}UFUNUPUQUUUhUkUlUpUyVCVDVGVQVVVWVXVZV^V_VbVlVtVxV}WFWHWJW"},
  {0,NULL,"PWQWRWVWYW^W`WeWnWuWzX@XBXHXIXKXNXQXVXZX\\X_XmXuXxYAYCYDYEYHYJYKYL"},
  {0,NULL,"YNYOYQYSYTYUYZY[Y\\_C?E?I?J?K?M?V?[?]?_?d?e?l?q?x?~@D@F@G@L@N@R@S@"},
  {0,NULL,"d@l@p@w@}ABADAFAJAMAQARAcAlAnAoApAuAwA{A|BCBGBJBMBUBYBZBaBbBeBhBk"},
  {0,NULL,"BlBrBuB{B}C?CBCHCKCNCRCTCXCYC]CkCnCwC|D@DBDCDNDPDSDUDXD]DgDmDoDqD"},
  {0,NULL,"rDtDyD}EGEPESEUEfErEtEwF?F@FEFFFNFRF]F^F`FiFjFnFpFqFuFwF}GAGEGGGK"},
  {0,NULL,"GMGOGQG[G`GaGiGkGoGtGuGxGyG|G~HEHFHMHPHTHVH^HdHiHnHpHrHvI?IAIJINI"},
  {0,NULL,"RIUIVI[I]IfIiIkInItI{I~JFJIJLJ]J_JfJkJlJmJoJwJzJ|KBKDKEKHKJKOKXK["},
  {0,NULL,"KbKcKdKiKjKlKqKxKzK{K~L@LFLKLPLRLYL`LeLnLrLvLyLzL}MAMDMIMMMSMYMZM"},
  {0,NULL,"\\MeMgMiMqMyM~N?NENHNZN[N_N`NjNkNqNwN{OCOIOOOVO[OdOhOoOtPCPIPJPRPa"},
  {0,NULL,"PcPjPvP|QAQCQEQMQNQVQZQ]QdQfQgQnQrQyQ{Q|Q}RFRGRIRKRMRWR]RaRcRhRkR"},
  {0,NULL,"qRuRyR{R~SCSGSHSTScSdSpSqSrSsStSuT?TETHTMTOTRTTTWT_TdTfThTkTnTrTs"},
  {0,NULL,"TyT~U@UBUDUIUKURU[UcUjUoUtUxU~VFVJVOVTVUVYV[V\\V`VeVjVuVvV~W?WIWNW"},
  {0,NULL,"OWSWTWWW[W\\WoWpWsWvWxXDXFXGXJXLXMXOXTX[XgXlXnXqXyX~Y@YAYBYEYIYKYM"},
  {0,NULL,"YNYPYQYSYVYWYYY]Y`_C?E?H?I?M?O?T?Z?]?_?a?c?m?u?y?{?}@F@I@K@U@[@]@"},
  {0,NULL,"`@h@t@x@zACADAGAKATAZA\\A_AdAfAoArAtAzA}BBBCBEBJBKBOBPBQBSBWB_BfBl"},
  {0,NULL,"BnBpBqByB}CJCMCNCPCQCSCTC\\C_CbCeCnCrCxD@DADEDGDJDODSDTD]DcDhDiDnD"},
  {0,NULL,"qDrDvE@EBEKEXE]EgEiEsExE~F@FAFBFLFQFUFVFdFhFjFlFmFyF|F}F~GBGEGHGL"},
  {0,NULL,"GRGXGYGZG]GaGbGcGdGnGpGxG|G}G~H@HCHDHNHUHYH\\H_HjHkHmHnHoI?IAIKIRI"},
  {0,NULL,"SITIWI[I_IaIgIhIkIsIyI}JDJRJWJ^JbJfJgJhJoJqJuJwJyK@KAKLKPKRKUKVKY"},
  {0,NULL,"K]K^K_KcKdKfKrKwKzLDLGLHLILKLQLTLWL[LeLfLvLwLxL{L~MCMHMIMJMSMZM_M"},
  {0,NULL,"`McMdMgMoMwMzNBNCNTN\\N]N^NeNfNgNpNrNtNuOJOYOZO]OkOqOsOvOyO{PFPPP^"},
  {0,NULL,"PbPiPnP{QBQFQGQKQPQUQ_Q`QbQcQkQmQsQuQxQzR?RERIRORPRTR[R]R_R`RgRkR"},
  {0,NULL,"qRsRwRxRyR|SASGSPSQSWSlSvSwSzS}S~TDTGTHTITJTLTOT[T\\T^TdTeTlTnTqTr"},
  {0,NULL,"TtTvTwT~UAUMUTUXUZU_UaUfUsU{U}VAVKVPVUVVVYV]V`VcVeVkVpVvV~WDWKWOW"},
  {0,NULL,"PWSWUWWWZW\\WcWjWpWvW|XAXCXGXHXJXOXRXTX^XcXgXnXsX{X~Y?YBYCYGYIYJYK"},
  {0,NULL,"YLYMYPYRYSYUYYYZY[_C?G?H?J?L?N?X?[?\\?^?`?c?k?o?w@?@C@F@G@I@S@U@^@"},
  {0,NULL,"a@j@s@uA?AAADAFAGAOARATA`AgAhAlApAqAwAxA}B@BDBKBMBUBWBZB[B_BaBlBn"},
  {0,NULL,"BtBwBxByB}C?CACCCDCFCICTCZC[ChCkCnCuCvC{C}C~DKDLDODXD[D\\D`DaDkDlD"},
  {0,NULL,"mDsD{D~EFELEXE_EdEnEpEuE}F@FAFEFMFNFQFWF`FaFbFkFnFtFwFyFzG?GAGHGK"},
  {0,NULL,"GQGRGTGYG[GeGgGkGmGrGvGxGzG|G~H@HHHKHNHTHaHeHfHjHrHsHtHzH~IAIHIII"},
  {0,NULL,"MIOIQIZI`IcIeIfImIvJ?JBJDJEJYJ]J`JaJiJkJqJsJxJzJ}KAKBKEKHKJKLKQKV"},
  {0,NULL,"KaKcKdKfKmKoKrKyK|K}L@LBLJLKLPL]LaLbLeLgLlLmLqLtL~MKMMMOMPMRMUMWM"},
  {0,NULL,"XMYMaMjMnM{M}NBNONUNYNZNhNiNjNkNqN}O?OFOSOUOVO^ObOjOlOoOxPFPLPUP^"},
  {0,NULL,"PdPgPiPkQAQEQFQPQQQTQ[Q]Q_QdQiQkQsQyR?R@RDRFRLRORURWR\\R^R_RaRiRpR"},
  {0,NULL,"rRtRwR{SDSKSLSMSOSUSVSkSvSwSzS{S|T@TCTETGTMTNTVTXTZT_TaTcTfTlTqTu"},
  {0,NULL,"TyT{T}U@UEUIUMUNU^UfUhUjUvUxVAVCVMVOVUVWV[V\\VaVdVfVkVlVoVwWEWIWLW"},
  {0,NULL,"OWQWTWXW[W]WcWeWiWqW~XDXGXIXLXMXPXSXUX^X_XbXhXvXwX}Y?YAYCYFYJYKYL"},
  {0,NULL,"YMYOYPYRYTYXYZY[Y\\Yc_C?D?I?J?N?P?V?\\?^?_?`?e?l?w?z?{?|@B@J@K@T@Y@"},
  {0,NULL,"]@c@l@u@y@z@|A@AIAKASAXA\\AbAeAfAmAsAtAxA|BCBFBIBKBLBNBOBQBRBSBTBj"},
  {0,NULL,"BlBpBsBuBxB|CACHCICJCQCRCUC\\CaCiCmCnCqCwCzC~DDDLDNDPDTDVD\\DeDgDlD"},
  {0,NULL,"rDsDuDyECEFEJEQEREfEjEpExEzE|FBFDFJFLFOF\\FfFgFhFlFoFqFtFvF}G@GFGH"},
  {0,NULL,"GLGPGSGZG\\G]GcGiGmGnGrGuGwGyG{G~HCHGHKHLHQHUHbHhHiHoHqHsHvH~IAIJI"},
  {0,NULL,"LIPIQIXI[I]IeImIoIpItIzJBJGJHJNJ^JdJeJhJjJmJpJwJ{J}KAKCKIKNKPKUKW"},
  {0,NULL,"KYK^KaKdKkKlKpKtKwKyK{K~LBLHLLLNLQL^LdLeLnLpLsLtL|L}MBMDMJMOMRMXM"},
  {0,NULL,"ZM\\MjMkMlMqM|M}N@NFNGN\\N]N^NlNmNnNpNvODOEOJOMONO\\OaOcOkOuPEPMPNPS"},
  {0,NULL,"PePfPlPxP~QBQOQPQQQRQSQ\\QcQhQiQkQlQzQ~R?R@RBRCRMRQRTRURWRZRaRcReR"},
  {0,NULL,"gRiRvRxR{R~S@SDSNSSSeSfSpSqSrSsStSuT?TDTFTGTMTPTQTWTYT_TeTgTjTlTo"},
  {0,NULL,"TqTsTyU?UAUCUJULUOUTU_UdUiUmUwU{V?VEVPVTVUVYV[V]VaVfViVxV|V}WAWKW"},
  {0,NULL,"NWOWSWTWUWXW]W`WmWtWuWwXAXFXGXJXLXPXRXUX\\X]XfXmXpXyX}Y?YAYDYEYIYJ"},
  {0,NULL,"YMYNYOYQYTYVYWYXY\\Y_Yd_C?F?I?J?K?P?Y?\\?a?b?d?e?j?s?t?}@?@A@G@K@O@"},
  {0,NULL,"[@\\@a@i@n@r@{A?ACAFAKAYAZA[A`AdAgAiApAtAxA|A}A~BEBGBHBPBVBWB[B_Bd"},
  {0,NULL,"BjBmBnBqBtBuB{B~CACDCNCOCRCSCVC_CdChCoCrCvCwCzC|DIDMDPDQD\\D]DbDdD"},
  {0,NULL,"gDhDoDsDwEAEEEIENETEcElEmEuE{E~FBFEFKFMFSFUFaFcFdFlFnFqFtFuFyF{F~"},
  {0,NULL,"GDGJGRGTGXGYG^GaGdGeGjGrGsGuGyH?H@HDHHHLHPHRHWHYHaHvHxHyH~I?I@IFI"},
  {0,NULL,"IIJILINISI]I_IdIiIlImIqIxJAJKJMJVJ[J`JbJhJkJmJnJqJyJ|J}K?KKKLKQKR"},
  {0,NULL,"KVK\\K_KbKeKfKlKmKpKyKzK{K|L?LELILSLTLZL]LjLmLnLpLrLxMDMFMGMRMSMTM"},
  {0,NULL,"\\M_MbMeMhMjMmMtMxNJNLNSNYNeNfNgNhNiNsNtOAOFOLOXOZO^ObOnOrOsO}P?PG"},
  {0,NULL,"PWPYP_PpPrPyQ@QFQGQJQLQTQYQ[Q_Q`QaQeQqQsQuQvQwRDRHRJRLRMRQR]RcReR"},
  {0,NULL,"jRnRqRtR~S@SESGSISMSZS[S\\SgShSiSmSnSoT?TCTFTHTITKTVTWTZT[T]TcTjTn"},
  {0,NULL,"TrTsTtTxT}UCUEUGUNUQUZUaUeUhUlUyV@VCVKVOVPVTVUVYV[V\\V]VmVnVtV{W@W"},
  {0,NULL,"IWKWNWOWSWTWUW[WbWfWhWnW}XAXDXFXGXJXLXMXRXXXZXaXkXtXxX~YDYEYFYHYQ"},
  {0,NULL,"YUYVYWYXYYYZY\\Y]Y^Y_Y`YdYe_C?G?H?J?L?N?X?[?\\?^?`?c?k?o?w@?@C@F@G@"},
  {0,NULL,"I@S@U@^@a@j@s@uA?AAADAFAGAOARATA`AeAfAmArAsAvA{A|BBBEBFBLBPBSBZB^"},
  {0,NULL,"B_BeBhBlBmBoBrBzB}B~CCCDCGCNCOCQCWCcCeCjCpCtCvC}D?D@DFDGDIDKDUD[D"},
  {0,NULL,"eDjDkDlDnDuDxD|E?ENEPE[EdEnEpEuE}F@FAFEFMFNFQFWFfFgFhFmFoFqFvFxF|"},
  {0,NULL,"F~G@GGGKGWGXGYG]G`GaGcGeGhGjGsGvG|G~H?HAHEHFHOH[H]H_HcHkHpHtHuHyH"},
  {0,NULL,"zICIEIGIIIOIRIZIbIeIgIoIpIrIwI|JFJTJVJ^JdJeJgJjJmJrJuJyJ{KCKDKEKG"},
  {0,NULL,"KRKVKYK[KcKdKeKgKiKjKsKvKzK|L?LELHLJLVLXL[L_LgLiLkLmLuLvM?MAMCMGM"},
  {0,NULL,"KMPMVMXMaMcMkMlMpMuMvNENQNSNXN\\N]N^NcNdNuNvNxOEOGOMONO]OaOcOeOvP?"},
  {0,NULL,"PEPIPSPYPaPjPrPxQGQHQJQMQNQUQWQYQZQ`QgQmQoQuQwQ|Q}RERGRHRRRVRYR[R"},
  {0,NULL,"dRhRjRmRoRsR|S?SCSESFSJSRSXSYSiSnSoSsStSuTBTFTJTLTPTQTTTYT\\T^TbTg"},
  {0,NULL,"TjTkToTvTwT|U?UCUDUQURUVUXUlUoUqUsUyU|U}VFVRVVVXV]V_V`VbVcVhVnVqV"},
  {0,NULL,"uWAWMWPWRWUWVWWWYWZW_WgWhWoWwX?X@XAXBXCXHXOXQX[X`XaXdXpX|X}Y@YEYF"},
  {0,NULL,"YGYMYNYPYTYVYWYYY\\Y]Y^Y_Y`YbYd_C?D?H?I?O?P?W?Z?`?a?b?e?i?r?t?|?~@"},
  {0,NULL,"C@I@L@R@X@^@b@k@q@r@}A@AAAGAJAOAPAQAWAdAgAiAqAtAvA~B@BFBGBHBMBOBU"},
  {0,NULL,"B\\B^B_BaBhBkBlBoBrBtB|C@CACFCGCKCPCUC[C\\C^CiCpCqCxCyC{DCDSDVDWDYD"},
  {0,NULL,"ZD[D^D`DbDcDdDhDvEBECEQEUE[EeEkEmEwEzE}FAFFFIFWF[F]FaFcFdFkFlFuFw"},
  {0,NULL,"FxFzF{G@GDGLGQGUGWGYG[GbGgGhGlGoGrGwG{G~HAHEHFHHHMHUHXHbHfHnHqHtH"},
  {0,NULL,"{H|H}IBIGIKIMIPIVIYI_I`IdIhIlIsIyIzJGJLJTJ[J`JbJhJiJnJrJsJ{J|K?KB"},
  {0,NULL,"KFKGKHKJKPKVKdKgKiKjKmKqKtKvKxKyK}LALGLLLMLQL^LbLfLkLoLqLsLzMBMIM"},
  {0,NULL,"LMNMPMQMUM]M_MbMdMhMoMzM|N?NFNQNYNhNiNlNmNnNtN|O?OAOLOROUOZOiOlOn"},
  {0,NULL,"OsO|P?PCPRPVPYPhPrPvQCQEQHQOQPQUQWQ]QfQhQkQmQoQ{Q~R?RERFRKRNRPRUR"},
  {0,NULL,"XR[R`RbRiRlRsRuRzR|R}SASDSHSSSeSfSiSnSoSpSqSrT?TGTITKTNTPTUTWTYT["},
  {0,NULL,"T]TaTlTmTqTsTtTxT{U?UFUKUMUPUXUcUfUkUsU}U~VAVDVSVWVZV\\V^VaVbVdVgV"},
  {0,NULL,"hVrVvW@WGWHWIWJWLWQWXWYWdWgWkWpW}XEXIXKXMXNXPXQXSXWXYX`XgXtX{X}X~"},
  {0,NULL,"YBYGYHYIYMYNYSYVYWYXY[Y]Y^Y_Y`YbYe_C?E?H?J?K?O?X?[?a?b?c?e?k?r?s?"},
  {0,NULL,"{@D@E@H@J@P@Q@Z@c@j@n@q@zABAEAHAIANA]AaAbAdAgAiApAqAxA}B?B@BEBFBM"},
  {0,NULL,"BRBTBYB\\B]BdBfBgBhBpBvBzB{CBCECHCJCOCQCUCZC]C`CkC}C~D?DADBDEDGDHD"},
  {0,NULL,"KDRDTDXDbDdDfDhDjDnDxEDEGEJEOESEdEkElEvExF?FCFDFTFYFZF\\FaFcFdFkFn"},
  {0,NULL,"FrFtFwFyFzF~G@GMGPGUGVG\\G^GcGfGiGnGsGtGwG}HBHCHEHJHOHPHTHVHZHeHkH"},
  {0,NULL,"lHoHrHwHzICIOIQITIUIWI\\I_IbIdIgIlIrI{J@JIJNJZJ[J`JbJiJkJqJsJtJyJ{"},
  {0,NULL,"J}KBKFKIKOKSKWK\\K]K^K`KbKhKiKsKuKwK~LELFLHLLLPLRLULaLgLtLuLwLyL{M"},
  {0,NULL,"@MCMEMJMKMMMVM[M_MbMcMhMpMsM~N@NHNVNYNZNhNiNjNkNsN|O?OFOROUOXO^Ob"},
  {0,NULL,"OiOlOrO|PGPNPVP_PePhPyP~Q?QAQDQQQRQVQ\\Q^QdQiQjQnQrQtQyR@RARCRIROR"},
  {0,NULL,"VRYRZR^R_RkRmRoRrRvRwRySFSJSLSNSTScSdSiSnSoSsStSuT?TATBTITKTOTTTW"},
  {0,NULL,"T[T]T`TbTdTkTsTtTxTzT|T~UDUHULU\\U]UbUdUgUuV?VBVLVNVPVQVRVVVZV_VcV"},
  {0,NULL,"eVkVlVpVxW@WHWKWMWPWVWZW\\W^W`WcWeWjW}X?XBXCXHXKXRXTXVX\\X^X_XcXtX|"},
  {0,NULL,"X}YBYCYDYFYIYJYMYNYQYWYXYYYZY[Y\\Y`_C?G?H?I?L?M?W?Z?[?]?`?d?i?q?v@"},
  {0,NULL,"?@B@E@H@K@P@T@W@\\@k@o@p@|A?AEAHAKASAUA[A]AlAnAoArAuAwA|B?BABHBIBM"},
  {0,NULL,"BNBPBQB]BbBdBgBiBjBmBnBrBtC@CDCECHCICQCUCcCeCfClCsCvCyC{DDDEDIDLD"},
  {0,NULL,"ODRDYDZD_D`DcDmDqDtDvE?E@ENEOEREeEoEtEuEvE|FBFCFHFKFOFYF`FiFjFmFp"},
  {0,NULL,"FqFrFsFwGAGDGFGOGSGVGXGZG^GcGeGfGiGlGmGwH?H@HBHFHHHIHLH]H_H`HgHjH"},
  {0,NULL,"lHsHyH|H}IBIDIIIMIWIXI^I`IfIhIkInIsI|I}JHJVJZJ]J_JfJgJlJmJpJtJvJz"},
  {0,NULL,"K?KBKNKRKSKUKXK\\KeKfKhKjKmKnKpKuK|K~LALBLHLLLOLXL[LcLhLmLoLqL{L|L"},
  {0,NULL,"~M@MGMNMOMQMUMYM^MdMgMiMoMuMwNGNSNVNXN[N_N`NcNdNrNwNzOCOOOPOYO[Od"},
  {0,NULL,"OfOqOtPGPJPMP_PcPfPlPyP|Q?QBQDQGQJQSQYQ^Q`QcQjQlQtQuQwQzRARBRHRPR"},
  {0,NULL,"TRXR\\R^R`RgRjRlRpRrRxRzSASESKSLSRSXSYSiSnSoSpSqSrT@TETHTJTPTTTUTX"},
  {0,NULL,"TYT\\TfTkTmTnTrTuTvU?U@UDUFUTUWUZU]U_U`UaUbU{VHVKVNVOVQVSVWVXV^VdV"},
  {0,NULL,"fVkVmVoV|W?WGWJWLWQWRW[W]W^WcWfWiWtWxX@XDXEXIXNXSXUXVXXX]X^XbXqX{"},
  {0,NULL,"Y?YBYCYEYHYKYMYNYOYQYWYXYYYZY\\Y]Y__C?D?I?J?N?P?V?\\?^?_?`?e?l?w?z?"},
  {0,NULL,"{?|@B@J@K@T@Y@]@c@l@u@y@z@|A@AIAKASAXA\\AbAgAhAlApAuAwAyA{B@BBBJBM"},
  {0,NULL,"BQBTBWB]BcBdBfBiBmBoBvBxB|C@CCCJCLCPCQCSCVCXC]ClCpCtCwCxDBDDDGDND"},
  {0,NULL,"QDUDVDYD`DdDeDkDpDsDwD|EEEHE\\E]EfEjEpExEzE|FBFDFJFLFOF\\F`FaFbFnFp"},
  {0,NULL,"FwFzF|GAGCGEGGGPGRGVGZG^G_GbGcGdGlGnGqGvG{G}H?HAHIHJHKHVHWH^HgHiH"},
  {0,NULL,"kHpHqHxH|IEIGIJIKIUIXIZI`IjIlImIpIqIwJAJJJUJWJ]J`JaJkJlJoJsJuJzJ~"},
  {0,NULL,"KBKDKIKLKSKUKZK\\K]K`KaKeKgKnKtKwLALCLGLHLILJLRLSLYLcLfLiLkLnLyL|L"},
  {0,NULL,"}MAMBMCMFMNMUMaMfMhMjMlMmMtMvNINRNTNZN[N_N`NjNkNqO@OCOFOKOVO[O^Ob"},
  {0,NULL,"OmOoOtOzO~PFPOPXP^PiPmPqQ?Q@QGQKQMQVQZQ^Q`QaQbQnQrQtQuQvQxQ|RHRKR"},
  {0,NULL,"NRSRVR]RbRfRjRmRqRuR}SBSESFSGSHS]S^S_SjSvSwSxSySzT@TBTJTKTNTSTVTX"},
  {0,NULL,"TZT\\T]TaTbTiTpTuTvTxT{T|UEUGUSUZU\\UaUeUnUuUzV@VKVLVQVRVSVXVZVbVcV"},
  {0,NULL,"dVgVjVvV{WEWGWHWLWMWRWYWZW^WbWdWpWsW~X?X@XCXEXKXQXSXVXWXgXkXlXvXx"},
  {0,NULL,"X~YAYEYFYGYJYKYMYPYRYSYTYUYVY[Y]Y^YjYk_C?E?H?J?K?O?X?[?a?b?c?e?k?"},
  {0,NULL,"r?s?{@D@E@H@J@P@Q@Z@c@j@n@q@zABAEAHAIANA]AaAbAeAkAnArAsAvAwA|A~BB"},
  {0,NULL,"BDBLBNBQBRBXB]B`BfBiBkBnBxB{B|C?CECFCMCRCSCUCaCbCeCjCvCxC|C~D?DCD"},
  {0,NULL,"GDMDPDXDZD[D^DaDbDfDgDmD{EAEBEMEYE]EdEkElEvExF?FCFDFTFYFZF\\FeFgFi"},
  {0,NULL,"FmFoFqFvFxF{F|G?GAGIGNGSGVGZG\\GdGfGgGkGpGuGwG{G}H@HIHKHMHPHQH\\H_H"},
  {0,NULL,"cHkHrHtHvH}I@ICIIIKINIQIVIYI\\I]IcIdIfIvIxIyJPJSJWJ_JcJeJgJjJmJnJr"},
  {0,NULL,"JuJxJzKCKMKNKSKTKUKWK]KaKbKfKnKqKtKuK{K}L@LDLILLLNLWL[L_LfLmLrLtL"},
  {0,NULL,"uLzMCMDMMMPMQMTMWMYM[M\\M]MbMnMxMzNMNPNTNXN\\N]N^NcNdNoNvNxNzOGONOP"},
  {0,NULL,"OQOcOeOfOgOzPAPHPOP[P`PmPtPzQGQHQKQLQOQSQWQ`QbQeQhQlQoQqQuQxQ~RBR"},
  {0,NULL,"GRLRRRURXR]RdRhRiRlRqRtRzS?SCSDSGSMSPSQSWSkSvSwSzS{S|TCTDTGTHTRTS"},
  {0,NULL,"TUTcTeThTiTlTmTnTpTqTrT}UAUBUFUJUSUWUYU`UmUnUrUzVEVHVIVOVSVTVYV\\V"},
  {0,NULL,"^VaVfVjVqVuVyWBWGWIWJWNWSWXW[W]W_WoWrWsW{XDXEXFXJXMXNXPXUX[XdXiXl"},
  {0,NULL,"XoXwX}X~Y@YFYHYKYLYPYSYTYUYVYWYZY[Y^Y`YaYfYk_C?F?H?I?L?P?T?\\?]?^?"},
  {0,NULL,"`?a?m?o?z@@@A@D@H@L@N@Q@V@_@h@s@y@{@~ABAHAJAMAVA^AaAgAhAlAqAuAxAy"},
  {0,NULL,"A{A}BDBJBLBUBYB\\B]B`BbBjBkBqBsBvBzB}B~C?CECGCJCMCRCYC^C`CfCqCrCsC"},
  {0,NULL,"zD?D@DFDIDJDPDTDWD`DhDkDqDsDuDvE?ECEMEVEZEgEjEnEyE{F?FCFFFGFRFXFZ"},
  {0,NULL,"F`FaFbFkFpFtFvFyG?GCGEGGGMGNGOGQGUGVGfGhGjGkGnGpGuG|HDHGHJHLHMHOH"},
  {0,NULL,"XHZH`HdHmHoHuHvHyH{ICIDILIPIRISIZI_I`IkImIoIsIzI|JCJQJSJ]J`JaJiJl"},
  {0,NULL,"JoJqJxJ}J~KCKDKFKJKOKSKTKXK_K`KcKkKpKqKsKuKvKwK{L?L@LDLMLOLUL`LhL"},
  {0,NULL,"pLsLuLvLxM?MDMGMHMJMLMUM_MaMgMjMkMoMuM|NKNNNPNWNZNaNbNjNkN}O?O@OC"},
  {0,NULL,"OKOSOUO[OjOlOmOtOxOzPDPOPUP]PgPmPwQCQDQHQNQRQSQWQ\\QfQgQjQlQoQ{Q}R"},
  {0,NULL,"ARBRCRJRMRTRXRYR[RcRgRlRnRoRsRxRzR|R~SISJS`SaSbSlSvSwSzS}S~T?T@TD"},
  {0,NULL,"TLTNTTTVTWTXTZT^TaTeTkTsTuTwT{UAUDUEUKUPUWU]U`UbUcUkU~VDVHVNVPVRV"},
  {0,NULL,"TV[V]V_V`VeVmVrVtVyWEWKWMWNWTWUWVWWW\\WfWkWnWrW~X?XAXBXFXLXOXRXTXX"},
  {0,NULL,"XYXZXiXvX{X}Y?YEYGYHYJYLYOYPYSYTYUYVYZY\\Y^Y_YaYcYj_C?E?H?I?M?O?T?"},
  {0,NULL,"Z?]?_?a?c?m?u?y?{?}@F@I@K@U@[@]@`@h@t@x@zACADAGAKATAZA\\A_AhAjAkAq"},
  {0,NULL,"AuAvAxAyA{BDBHBIBSBTBWBZB[BcBgBpBrBuBxByB|CCCDCKCNCOCSCUCXCYCZC`C"},
  {0,NULL,"oCsCxCyC~D@DMDODTDUDWDZD^D_DaDcDiDpDzD}EDEJEPETEgEiEsExE~F@FAFBFL"},
  {0,NULL,"FQFUFVF_FbFeFkFpFtFxG?GCGDGFGGGKGPGRGTG]G_GaGdGeGoGsGvGwGyG{HBHCH"},
  {0,NULL,"FHKHNHZH^HdHeHjHoHpH{H}I@IBIDIFIKIQIRIYI^IaIcIhIjIuI~J@JFJKJNJ\\Ja"},
  {0,NULL,"JcJiJlJpJrJxJ}J~K?KDKEKIKLKQKYKZK^KaKhKjKlKrKtKxKzK|LELILJLLLULYL"},
  {0,NULL,"`LaLfLhLjLoLtLvL~MAMJMLMQMTMWM]M^M`MdMfMrMsMyN@NENJNWNZNaNbNjNkNy"},
  {0,NULL,"N}N~O@OHOKOSOTO_O`OjOmO}P@PEPSPWPZPpPsPxQ@QMQNQQQRQTQZQ[Q\\QaQgQiQ"},
  {0,NULL,"vQ|Q}R@RCRDRGRJRNRXRZR\\RbRhRlRnRpRvRzR}SCSISKSNSTScSdSgShSmSsStSu"},
  {0,NULL,"TATBTETKTMTRTUT]T_T`TbTfThTmTxTyTzT|U@UBUFUGUOUVU^UeUiUqUvUwU|V@V"},
  {0,NULL,"MVQVSVWVXV\\V^VaVdVqVtVyV}WCWGWIWJWLWQWRWXW^W_WnWrWuWyX@XEXIXMXNXP"},
  {0,NULL,"XSXVXZXdXiXmXrXzY?Y@YDYGYHYIYLYNYQYTYUYVYWYYY\\Y_Y`YeYl_C?F?H?J?K?"},
  {0,NULL,"L?U?[?]?^?b?d?n?v?x?|?}@@@I@J@M@Y@`@b@m@o@w@~A@ACAGAIALAPAXA_AlAn"},
  {0,NULL,"AoApArA{B?BABCBFBHBJBOBQBWBXBaBcBmBpBsBuByBzB|C@CACBCGCMCOCPCVCbC"},
  {0,NULL,"gChCoCqCtCuD?DADFDHDJDKDMDVDfDjDkDmDqDtD{D~EAEQETEWEhEoErEyEzE~FA"},
  {0,NULL,"FDFJFPFVF[F`FiFjFmFnFrFsF}G@GDGEGGGIGLGRGZG[G_GbGhGlGpGrGsGtGyG{H"},
  {0,NULL,"?HCHGHNHOHSHWH\\HaHmHqHuHwHzI@ICIEIFIHIPITIZI\\IbIfIkInIvIxJ?JGJKJO"},
  {0,NULL,"J]J_JfJgJkJoJtJvJwJ{K?KDKHKLKMKPKUKZK^KeKkKlKrKsKtKvKyLALDLELFLGL"},
  {0,NULL,"SLWL\\L]LiLjLlLsLuLwM?MBMEMHMKMTMVMYM[MaMgMiMnMxM{NANFNJN[N_N`NeNf"},
  {0,NULL,"NgNqNrNzN{OIOPOVOYOfOhOoOqP@PCPMPRPZPfPlPsPvQ@QIQKQOQPQTQXQ[QaQbQ"},
  {0,NULL,"hQkQpQvQxQ~R?RDRJRORRRSRURYR_RdRfRiRnRoRwS?SBSDSISJSZS[S\\SgShSmSp"},
  {0,NULL,"SqSrTETHTITQTSTTTVTZT[TfTgTiTkTnToTpTrTtU@UDUEUJUMUSU^UfUmUnUvUzV"},
  {0,NULL,"AVEVMVQVRVVVZV]V_V`VcViVrVwVyW?WHWMWPWUWVWWWZW^WkWmWqWrWxX?XAXBXC"},
  {0,NULL,"XHXKXOXVXYXfXhXiXqXwX}Y@YAYCYHYIYLYNYOYQYSYVYXY\\Y]Y_Y`YdYl_C?G?H?"},
  {0,NULL,"I?L?M?W?Z?[?]?`?d?i?q?v@?@B@E@H@K@P@T@W@\\@k@o@p@|A?AEAHAKASAUA[A]"},
  {0,NULL,"AiAjAmAqAtAzA~B@BFBGBJBLBNBRBTBVB[BdBfBiBmBsBxB{B}B~CHCICLCMCOCTC"},
  {0,NULL,"ZC[CdCiCqCtC{C|D@DEDIDJDKDNDSDZD_DiDjDoDqDuDzD}D~EHEYE_EeEoEtEuEv"},
  {0,NULL,"E|FBFCFHFKFOFYF_FcFfFkFlFuFvFzF{G@GBGEGJGPGSGTG\\G^GiGjGmGpGqGsGxG"},
  {0,NULL,"|G}H?HGHIHKHPHRHbHeHfHiHmHnHyHzH}IEIMINIPIRIWI^IaIbIiIkIoIuI~J?JJ"},
  {0,NULL,"JPJYJ[J\\JdJhJiJnJoJsJ{J|K@KCKIKKKNKQKWK\\K]KaKbKcKeKkKnK~L?LBLCLDL"},
  {0,NULL,"ELKLZL^LaLbLiLqLrLsLvL{L}MGMHMIMKMQMVM^M`MeMgMkMrMyM{NINMNUNYNhNi"},
  {0,NULL,"NlNmNnN|N~OAODOLOROTO\\O`OiOnOuO~PAPBPXP[P\\PqPtPuQ@QEQLQOQQQVQ]QaQ"},
  {0,NULL,"eQhQiQnQqQrQvQ~R@RFRIRJRNRRRWR[RaRbRdRkRnRsRyR{R|R}S?SISOSUSVSjSk"},
  {0,NULL,"SxSyS{S|TATCTLTMTOTQTVTZT^T_T`TcTdTgToTwTyTzT}T~UEUGUHUOUYUeUgUiU"},
  {0,NULL,"rUwV@VBVIVPVRVUVYV]V_V`VeVgVhVqVzWFWKWMWOWSWUWVWWW\\W_WaWdWgWzX?XA"},
  {0,NULL,"XBXGXJXOXRXTXWX`XdXjXuXzY@YAYBYGYHYKYLYNYOYPYRYSYTY[Y]Y^Y`YfYgYj_"},
  {0,NULL,"C?D?H?J?N?O?U?Z?^?_?b?c?n?p?u?~@A@B@G@H@O@W@_@d@m@t@v@{@|@}AFAHAU"},
  {0,NULL,"AYA^AcAdAfAoApArA~BABCBDBHBJBKBPBVBYBbBdBeBjBkBqBrBvBwBxB~CFCHCIC"},
  {0,NULL,"KCLCSCVC]CcCgCtCuCyCzC~DCDHDLDMDNDWD[DaDbDcDlDnDrDxD|EDEHEZE^EhEi"},
  {0,NULL,"EqEwE{E|FCFEFHFSFXF^FdFhFjFmFnFsF{F}G?GDGEGHGJGMGOGXG^G`GdGgGiGjG"},
  {0,NULL,"mGoGqGzHDHFHJHKHLHMHSHVHWH]HiHsHtHwH{I@IBIEIHILIQIVI[IcIdIeIgIhIr"},
  {0,NULL,"IwJ@JJJQJXJ^JbJfJgJkJnJoJvJwJxK?KAKKKOKRKXK[K\\K_K`KaKjKoKpKqKxK}K"},
  {0,NULL,"~L?LBLCLILRLSLXL\\LiLlLoLpLtLzL}MEMLMOMPMTMWMXMZMbMcMdMpMsMvNDNINN"},
  {0,NULL,"N[N_N`NeNfNgNrNsNuN{OIOXOYO]OhOqOrOvO{PBPDPPP\\P]PnPuPwQ@QDQIQJQNQ"},
  {0,NULL,"VQXQYQaQgQjQnQpQrQvQwQ}RARGRNRQRURYR^RbReRhRiRoRrR}S@SCSDSJSLS]S^"},
  {0,NULL,"S_SjSlSxSyS}S~T@TFTGTJTKTOTRTXT\\T]TdThTjTlTqTuTvTxT~UBUCUHUQURU]U"},
  {0,NULL,"bUgUlUoUyVBVFVNVOVSVUV[V\\V^VaVfVhViVrVxWDWGWIWJWOWTWXW[W]W`WgWkWm"},
  {0,NULL,"W|XDXEXGXLXMXNXPXUXYX\\X`XfXsX|X}Y@YCYDYGYIYJYLYNYOYRYSYTYUY[Y^Y_Y"},
  {0,NULL,"cYgYk_C?D?H?J?N?O?U?Z?^?_?b?c?n?p?u?~@A@B@G@H@O@W@_@d@m@t@v@{@|@}"},
  {0,NULL,"AFAHAUAYA^AcAhAjAkAqAsAyAzA{B?BEBGBIBNBUBVB[B`BbBhBiBjBmBpBqBtCBC"},
  {0,NULL,"GCKCLCQCRCTC[C^CaCmCrCtC}DADCDDDFDGDHDLDQDSDaDfDiDkDnDpD{EBEFEIER"},
  {0,NULL,"EUEhEiEqEwE{E|FCFEFHFSFXF^F_FbFeFkFoFrFuF~GBGCGFGGGJGNGOGQGSGTGcG"},
  {0,NULL,"hGoGqGtGuGxH?HCHDHEHHHIHLHQHXHfHhHkHnHsHuHwHxIEIOISITIVIXIZI\\IaIc"},
  {0,NULL,"IgIjIvIyJBJHJLJMJ\\JaJcJiJjJpJtJyJ|J~K@KDKJKKKNKQKTKXK^K_KeKiKmKnK"},
  {0,NULL,"pKvKxK{LCLFLHLKLMLNLbLdLgLiLwLxLzL|M?MCMEMFMIMOMWM[M`MaMcMfMnMzM}"},
  {0,NULL,"N?NGNLNWNaNbNlNmNnNoN}N~OBOQOSOTOWO`OgOjOpO}PJPKPTPWPcPpP|P}QBQCQ"},
  {0,NULL,"EQFQLQSQ]Q_QcQeQfQlQqQsQzQ{RBRFRKRLRORRRTRVR_RdRgRmRtRuRwRxS?SFSH"},
  {0,NULL,"SMSSSeSfSgShSmSpSqSrTBTDTITMTNTQTUT[T_TaTbTeTgTmToTtTyT{T|UAUFUIU"},
  {0,NULL,"NUWUYU`UhUjUrUxVCVHVIVPVRVVVXV_VbVcVeVjVoVsV{WCWKWMWPWRWVWYWZW\\Wb"},
  {0,NULL,"WiWlWsWyX?X@XBXCXHXQXRXTXbXeXkXlXrXwX~Y?Y@YCYFYIYKYMYQYRYUYVYWYXY"},
  {0,NULL,"YY]Y_YbYnYq_C?G?I?J?M?N?Y?Z?\\?_?c?d?j?p?y@@@C@E@J@L@M@V@X@Z@i@v@x"},
  {0,NULL,"@~AAAEAIAJALANAVAWAdAfAoApAtAyA}A~BABBBEBHBOBRBXBYB\\BaBgBhBiBoBsB"},
  {0,NULL,"wByC?CCCECGCLCMCUCdChCiCkCoCpCsC|C}DDDFDQDRDUDZD\\DcDeDnDpDrDtDyD}"},
  {0,NULL,"EFELEVEYEcEqEsEvEyE}FDFFFGFIFPFTFdFhFjFlFnFsFyF{F|F~GCGDGIGLGMGUG"},
  {0,NULL,"[G\\GfGhGkGpGqGvGwGzHAHBHEHGHIHNHRHTHaHbHlHpHuHxH}H~IDIFIGINIOIXI["},
  {0,NULL,"IgIhIjInIpItI~JBJCJEJPJ^JbJfJhJkJnJqJuJvJyJ~K?KFKHKMKOKPKWKgKhKiK"},
  {0,NULL,"kKnKoKrKuKvL@LCLDLJLLLPLZL]L^LgLhLjLkLrL|M?M@MAMFMQMRMZMcMdMfMiMl"},
  {0,NULL,"MqMyM}NKNMNONYNeNfNgNhNiNpNsNtN{OIOJOXOZOhOkOrOsOyPDPHP]P`PbPwPzP"},
  {0,NULL,"{QAQCQLQOQRQTQ[Q\\QdQeQfQhQqQyQ{Q~RCRDRHRKRMRRRZR\\RcRdRjRpRuRvR~S?"},
  {0,NULL,"SESHSKSNSOSUSVSkSlS{S|S}S~TATETGTJTNTOTQT\\T`TaTdTfTgTlToTqTvTzT{T"},
  {0,NULL,"~U@UJUKULU[UcUdUmUtU~V?VEVJVQVRVWVXVZV^VbVcVmVnVuV|WDWHWJWMWQWRWY"},
  {0,NULL,"WZW^WfWhWoWtW|X?X@XCXIXKXNXQXVXXX[X]XaXsXyX~Y?Y@YDYEYKYLYOYPYRYTY"},
  {0,NULL,"UYWYYYZY^Y_YiYjYp_C?F?H?J?K?L?U?[?]?^?b?d?n?v?x?|?}@@@I@J@M@Y@`@b"},
  {0,NULL,"@m@o@w@~A@ACAGAIALAPAXA_AiAjAmAqAsAwAyAzA~BGBIBKBOBSBTB\\B^BcBgBkB"},
  {0,NULL,"nBoBsBuBwC?C@CICJCNCPCSCWC^C`CmCsCuCvCwDADCDFDLDMDXDYD]D_DbDjDlDm"},
  {0,NULL,"DoDxE?EGEKEVE\\EhEoErEyEzE~FAFDFJFPFVF[F_FcFfFkFoFuF{GAGBGCGFGHGLG"},
  {0,NULL,"PGUGWG]G_GaGbGdGkGlGmGnGyGzH@HAHBHGHMHXHZH[HhHrHsHuH|I?I@IDIHIIIJ"},
  {0,NULL,"ITIVI^IbIdIeIfIiIrI{I|JCJRJUJ[J\\JdJiJjJnJpJzJ|J~K@KAKFKGKIKPKYKZK"},
  {0,NULL,"fKgKhKkKlKoKqKwKzL@LALBLGLILMLULVLdLhLlLmLnLwLzM?MMMNMOMSMTMVMXMY"},
  {0,NULL,"M^MbMeMpMuM~NCNKNRNWNaNbNlNmNnN|N~OBOEOMOROTOWO`OaOiOpOwOyO~PQPXP"},
  {0,NULL,"bPoPqP{Q?QBQCQMQRQUQZQ\\Q^QcQfQmQtQzQ{Q|RCRERGRLRMRPRVR^R`RcRhRmRr"},
  {0,NULL,"RtR~SASCSFSLSMS`SaSbSjSlSxSyS}S~T?T@TATCTLTPTRTWTXTYT^T`TcThTsTuT"},
  {0,NULL,"wTzT}U?UBULUVUXU\\UdUqUsUuU|U}V?VLVOVTVWVYV\\VaVdVfVnVpVsV{WFWIWLWN"},
  {0,NULL,"WQWSWXW[W]WbWhWjWlWzXDXFXIXJXMXPXSXUXaXcXeXkXuX|Y@YBYCYEYFYJYKYOY"},
  {0,NULL,"PYQYRYSYUYYYZY]Y^YaYfYiYo_C?D?H?I?O?P?W?Z?`?a?b?e?i?r?t?|?~@C@I@L"},
  {0,NULL,"@R@X@^@b@k@q@r@}A@AAAGAJAOAPAQAWAeAkAnArAuAwAzA|A}B?BABLBXBZB^BaB"},
  {0,NULL,"cBeBfBhBoBqBsBuBwB~CACBCCCFCJCTCXCcCgClCqCrCwCyC}DEDHDIDSDTDYD\\D^"},
  {0,NULL,"DfDgDhDiDuDzEDEEELE\\E^EeEkEmEwEzE}FAFFFIFWF[F]FeFgFiFmFpFqFrFsFvF"},
  {0,NULL,"yGAGBGIGKGWG[G_G`GgGjGnGrGtGvGxGyGzG}HAHDHEHGHSH]H^HgHnHoHwHyH|H~"},
  {0,NULL,"IBIJIOIPISIWIYI\\I]I_IaIoIuJ@JAJEJUJXJ_JcJeJgJlJmJqJtJvJzK@KCKEKGK"},
  {0,NULL,"HKMKZK[K]K_KgKiKkKlKoKwKyK}L?LFLJLKLXLYL\\LcLgLnLoLsLxL{MEMGMIMJMN"},
  {0,NULL,"MRM[M\\M]M_M`MkMrMsMtNDNONRNXN[N_N`NcNdNwNxNyNzOGOHOOOPO_OdOeOfOwP"},
  {0,NULL,"HPLPQP`PdPkPoPzQ?QAQIQJQMQTQXQYQZQ[Q^QdQpQtQwQyQ|RDRIRJRQRTRVR\\Re"},
  {0,NULL,"RgRkRmRnRpRxRyS@SFSISKS]S^S_SjSkSxSyS{S|TBTDTFTOTRTSTVTZTbTdTeThT"},
  {0,NULL,"iTjTpT|T~UAUBUCUEUUUVU[U^UpUqUtUvU|VGVJVMVPVTVVV[V]V`VcVeVoVsV|V}"},
  {0,NULL,"WBWKWNWPWTWUWWWZW\\WiWlWtWuW{XAXCXFXHXLXOXRXTX]XbXeXmXoXzY?YBYDYFY"},
  {0,NULL,"HYJYKYOYQYRYTYUYWYXYZY[Y^YaYcYhYp_C?F?H?I?L?P?T?\\?]?^?`?a?m?o?z@@"},
  {0,NULL,"@A@D@H@L@N@Q@V@_@h@s@y@{@~ABAHAJAMAVA^AaAeAfAmArAtAvBBBCBEBIBKBMB"},
  {0,NULL,"RBVBXBYB`BeBgBtBvBwBzB{B|C?C@CBCDCKCLCRC_CbCdCgCrCsCuCxC{DBDJDODQ"},
  {0,NULL,"DWDXDYD^D_D`DeDlDuDzD~EEEIESEWEgEjEnEyE{F?FCFFFGFRFXFZFfFgFhFlFmF"},
  {0,NULL,"wFxF|F}F~GFGHGIGJGMGNG\\G`GeGkGlGoGqGtGuGzG{HBHHHJHOHPHRHSHYH\\HjHm"},
  {0,NULL,"HrHxH{H|IDIHIKIMISIUIYI^I`IeIoIpIuJ?JAJIJMJOJ^JdJeJgJhJpJrJuJwJyK"},
  {0,NULL,"AKBKKKMKOKTKWK[K`KbKhKmKoKsKtKxK{K|L@LALCLFLTLWLZL\\LfLhLlLqLxLyL~"},
  {0,NULL,"MFMHMLMMMNMUMXM]M^MkMlMrMtM{NANHNLN\\N]N^NeNfNgNpNuNxODOGOJO\\O]OeO"},
  {0,NULL,"kOuOvPIPKPNPTPaPePjP}P~QAQFQIQKQLQVQXQ_QbQdQeQnQpQqQrQsQxQyRIRLRN"},
  {0,NULL,"RPRSR\\R`RbRfRkRpRtRyR}SASBSKSMSZS[S\\SgShSmSsStSuTCTETFTKTPTQTSTYT"},
  {0,NULL,"]TcTfTgTiTjToTpTxT}U?U@UCUHUUUYU[UgUpUrUtVBVGVIVJVOVSVWVZV^VbVdVf"},
  {0,NULL,"VpVsVzV~WAWGWHWJWLWQWYW[W]WaWjWlWvWwXDXEXIXKXNXQXSXUXcXeXjXnXpXzY"},
  {0,NULL,"?YAYBYFYGYIYJYMYPYQYRYVYXYYY\\Y]Y`YbYmYrYt_C?F?I?J?K?P?Y?\\?a?b?d?e"},
  {0,NULL,"?j?s?t?}@?@A@G@K@O@[@\\@a@i@n@r@{A?ACAFAKAYAZA[A`AeAkAnAsAuAvAzB?B"},
  {0,NULL,"@BABBBDBNBPBSBZB[BbBnBoBpBtBvByB}B~CECICKCLCOCPCWCYCfCmCoCpCzC{DA"},
  {0,NULL,"DBDKDQDRDVDWD]D^DdDeDfDgDtDyECEGEKEZE_EcElEmEuE{E~FBFEFKFMFSFUFeF"},
  {0,NULL,"gFiFoFpFrFsFxFzF|G?GBGKGOGSGTGXG]GbGfGjGmGoGqGsG|H@HAHCHHHJHNH[H`"},
  {0,NULL,"HdHhHlHqHxHzH{I?IFIGILIMITIUIYI\\I]IlInIpItIzI{JQJRJYJ_JcJeJjJlJrJ"},
  {0,NULL,"sJtJuJvJxK@KEKNKQKRKXKYK^K`KcKfKgKmKrKuKxL?LBLCLELGLOLVL`LdLjLkLp"},
  {0,NULL,"LqLwLyM@MBMFMKMLMSM[M\\M]MhMiMlMqM|M~NCNNNUNWNXNaNbNcNdNoNvNwNyOHO"},
  {0,NULL,"NOOOQO_OcOdOgO{PAPLPPP[PdPkPnPtQBQDQEQNQQQUQ]QcQgQiQjQmQzQ}R@RARE"},
  {0,NULL,"RFRKRPRSRWRYRZR`RaRfRoRuRvR{SASBSHSJSNS`SaSbSkSlS{S|S}S~TATDTNTPT"},
  {0,NULL,"RTSTTTYT`TaTeThTiTkTpTzT{U?UAUBUDUIUOURUTU_UiUjUoUwUxU{VFVQVSVVVX"},
  {0,NULL,"VZV_VbVdViVwVzV~WBWGWHWLWPWRWVWYW^WaWmWqWvW{X@XBXEXHXKXQXSXVXfXhX"},
  {0,NULL,"jXnXoXyX}X~YAYBYDYIYJYLYOYPYRYSYXYZY[Y^Y`YhYkYoYs_E?G?H?L?M?O?S?T"},
  {0,NULL,"?W?X?[?c?f?s?w?~@@@L@O@R@V@W@Y@`@e@n@u@}@~AJAQAUAVAXAYA_AfAgAkAmA"},
  {0,NULL,"nAsAwA{A|A~BBBEBOBRBWBZBbBdBoBpBtBuB|B~CICJCLCRCXC^C_CdCgCjCkClCn"},
  {0,NULL,"CoCqCvDADBDDDGDLDNDRDWD\\D]D`DhDoDpDwECEHEJETE_E`ElEpEwEyFFFGFHFJF"},
  {0,NULL,"SFVF]FaFeFfFhFiFoFqF{F|F~GAGGGKGLGOGRG\\G^GjGmGnGqGuGyG{HAHCHHHRHS"},
  {0,NULL,"HTHXHYH^HcHgHiHkHlHsH{H~I?IAIFIIIPITIUIXI_I`IiIjIqIzJJJKJNJYJ^J_J"},
  {0,NULL,"`JcJdJjJmJnJuJyJzKDKEKLKPKWKXK\\K^KgKlKmKtKwK{L?LBLCLMLPLTLYLZL\\L_"},
  {0,NULL,"LcLeLjLmLsLwLyL|L}M@MCMLMOMRMSMUM_MeMfMmM|N@NINJNUNoNxN{N~OEOGOIO"},
  {0,NULL,"MOQOTO`OaOeOgOhOzP?PHPIPOPYP`PaPjPmPrPzQ@QEQGQHQRQWQ\\Q]Q`QaQoQuQv"},
  {0,NULL,"RCRFRGRIRQRRRSR\\RdReRfRhRkRpRyS?S@SBSCSKSSS`SaSbSeSfSgShSjSmSxSyT"},
  {0,NULL,"?TETNTOTWTaTdTfTsT{T~U@UHUNUOUPUTU\\U^U_UgUhUiUkUuUvUwU{VBVCVDVLVM"},
  {0,NULL,"VVVWVeVfVkVmVoVpVsVuVvW?WDWPWQW\\W]WcWfWiWjWlWoWpWxW|XHXIXTXUXXX[X"},
  {0,NULL,"^XbXcXeXgXqXsXwXxX{X|X}YCYGYHYLYMYNYSYTYZY[Y\\Y_Y`YcYfYgYlYsYtYuYv"},
  {0,NULL,"YwYx_D?G?H?L?N?O?R?U?W?X?Z?`?g?q?t?{@@@J@M@N@U@[@_@c@f@p@r@z@~AIA"},
  {0,NULL,"LAMATAZA^AbAeAiAkAlAoAuA|A}BABHBIBLBNBSBVBYB_BaBkBnBuByB}CBCECKCO"},
  {0,NULL,"CRCVC`CaCbChCiCjClCnCpCyCzC|D@DADIDNDQDUDVDWDXDbDjDpDsDwEGEIEUEXE"},
  {0,NULL,"_EbEmEtExEyFDFPFQFRFUFXF\\F`FcFeFgFjFpFqFsFvFyGDGFGJGMGSGYG[G]GfGo"},
  {0,NULL,"GsGtGuGyG|H@HMHNHQHWHZH\\HaHbHcHgHiHpHqHrHxHyH{IAIBIGILINIRITIbIdI"},
  {0,NULL,"jImIqI{JDJLJMJYJ[J]JcJeJfJlJmJpJqJvK?KCKHKKKNKOKVKYKcKfKlKqKrKuKx"},
  {0,NULL,"K{LELFLNLSLULWL]L^L_LcLeLkLoLpLrLvLwL}MAMBMFMGMLMMMVMbMfMjMmM~N?N"},
  {0,NULL,"BNLNUNpNyNzN}OCOHOJOPOSO[O_OfOjOkOtOwPGPHPMPQP_P`PfPlPoPyPzQ?QCQF"},
  {0,NULL,"QJQQQYQ^Q_QfQiQsQtQwQ{R@RRRSRTRUR\\R]RdRfRgRiRpRqRxS?SBSDSGSKSTS`S"},
  {0,NULL,"aSbScSdSgShSmSvSwSzT?TATGTQTWT`TgTlToTqTsTzUGUIUMUPURUYU\\UeUfUjUk"},
  {0,NULL,"UoUrUuUxV@VAVDVFVIVLVRVSV`VaVhVnVqVrVxVyV|WAWDWGWMWWWXW_W`WgWhWkW"},
  {0,NULL,"rWtWwW|X?XEXOXPXYX\\X]X`XaXdXiXpXsXxXzX{X|YBYCYFYGYJYKYMYNYRYXYYY["},
  {0,NULL,"Y]Y^YbYcYfYgYmYnYoYpYtYx_D?E?I?M?O?P?S?T?V?W?_?e?h?w?x@A@E@H@M@P@"},
  {0,NULL,"X@[@_@a@g@u@w@{AEAHALAWAZA]A^A`AeAfAiAjAlAsAxB@BABCBFBKBPBTBWB\\Ba"},
  {0,NULL,"BeBoBsBwBzB}C@CDCICNCOCZC[C]CaCbCdCfCgCnCpCsCtC}DADCDGDIDMDVDXD[D"},
  {0,NULL,"]D`DaDfDqD{E?ELEPETE\\EaEpErEvE{FCFIFMFPFUFXFYF_F`FcFgFhFoFsFtFzF}"},
  {0,NULL,"G@GHGPGRGUGXG[G`GaGeGlGmGsGzG|HAHGHOHQHRHSHVH\\H`HeHfHkHqHrHtHyI?I"},
  {0,NULL,"@IAIDIEIGIOITIVI\\I`IcIkIvI|JEJFJKJUJ[J\\J]J^JeJjJsJvJwJ{J}KAKFKHKI"},
  {0,NULL,"KLKRK[KcKgKkKoKsKzK|LALBLELNLOLRLWLZL\\LaLbLeLgLhLiLkLwLzMBMCMGMMM"},
  {0,NULL,"PMSMTMUMWM[MgMnMuNENJNONRNsNvNyOBODOHONOWOXO\\O_OcOpOrOuOxPBPMPNPU"},
  {0,NULL,"P\\PePfPgPlPuP~Q?QNQPQSQTQ[Q^QgQkQlQtQ}R?RBRDRIRLRNRQRRRZRbRdReRkR"},
  {0,NULL,"tRvRyR}S?S@SMSNSRSXSYS`SaSbSgShSkSmS{S|T@TKTOTTTXT]TdTkTuTxT~UDUG"},
  {0,NULL,"UIUSUVUWUXU[U`UeUjUnUqUsUtUxUzU|U}V@VHVJVSVYVbVeVgVkVrVvVxVzV~W@W"},
  {0,NULL,"DWGWSWYW\\W`WaWcWdWkWpWvW|W}XEXJXQXTXWXYX\\X^XgXjXnXsXtXwXxXyX{X~Y?"},
  {0,NULL,"YEYHYKYMYQYSYTYUYVYWYZY_YaYeYhYjYpYqYrYuYwYxYz_F?G?J?K?L?N?R?U?X?"},
  {0,NULL,"Y?\\?d?h?t?y@B@D@H@Q@R@S@W@Y@]@g@r@x@|ABAHAQARAUAXA\\AaAfAgAiAkAoAt"},
  {0,NULL,"AxAyA|A}BABHBPBQBUBZB\\BcBhBlBpBqBrCFCJCPCSCUCZC]C`CaCcCdCfCgCnCoC"},
  {0,NULL,"qC{D@DCDEDGDJDODVDWDYD\\D_DaDfDuDzEBEKEPE[E\\EaEmEsE|F?FCFHFJFLFNFZ"},
  {0,NULL,"F]FaFcFeFhFjFlFqFsFtFyGCGDGKGQGUGXGZG_GbGdGgGnGwG~HCHDHEHFHQHRHSH"},
  {0,NULL,"VHZH]H`HeHjHkHmHqH{H|H~IAIFIMIPIRIVIWI\\I^IcIoIuIyJFJRJTJUJ[J^J`Jc"},
  {0,NULL,"JfJhJmJqJvJ}J~K?KEKFKJKRKUKZK^K_KdKiKjKwK}LGLILLLNLOLRLULXLZL\\LaL"},
  {0,NULL,"eLjLqLsLvLzL{L~MBMCMHMLMNMRMWM[M^MkMrMzNCNENQNRNpNsOAOCOEOJOLOMOX"},
  {0,NULL,"O[OaOkOnOrOtO}PDPGPHPWP]P_P`PpPwPyPzQBQHQLQMQTQWQZQ[QcQeQoQqQzQ|R"},
  {0,NULL,"DRHRIRMRNRYR^RbRcRjRkRoRrRyR}R~SESJSLSPSQSSSWSeSfSjSsStSuSxSyT@TD"},
  {0,NULL,"TTTUTXTeTkTmTuUAUDUFUMUOURUUUXUYU\\UfUiUoUpUrUsUuUwU}VAVFVGVIVLVUV"},
  {0,NULL,"ZV_VfViVlVmVoVwVxVyW?WEWHWOWVW]W`WeWfWiWmWqWrWxW~XBXGXKXUXXX\\X_Xb"},
  {0,NULL,"XfXhXiXqXvXwXxXyXzX~Y@YAYFYKYLYPYRYVYXYYY]Y^Y`YbYdYfYiYjYkYnYoYrY"},
  {0,NULL,"vYyY{_D?F?J?K?N?P?Q?U?V?Y?^?b?f?u?v@C@D@L@N@P@U@X@a@c@e@o@tAAABAJ"},
  {0,NULL,"AMATAWA]A`AbAdAfAjAlAnArA{A~BDBFBHBJBOBTB[B]B_BbBiBnBrByB}CHCMCNC"},
  {0,NULL,"QCUCXCYC^CdCgCiCjCkCnCrCsCtCvCxC{DGDIDMDRDSDTDYD^DoDpDuDzE@EJEKER"},
  {0,NULL,"E_E`EiEoE}F?FFFIFMFQFRFYF\\F_F`FdFhFiFmF{G?G@GDGEGGGLGOGPGTGVGYGaG"},
  {0,NULL,"cGiGpGwG|H@HFHIHNHRHSHTHXH^HbHcHdHkHlHnHoHyH|I@IAIDIEIIIKIMISIYIi"},
  {0,NULL,"IjIoIuI}JHJNJRJYJ\\J]J^J_JbJgJnJoJxJ{K?KDKIKPKQKSKVKXKcKfKjKnKrKzK"},
  {0,NULL,"~LDLHLLLMLPLYLZL\\L^L_L`LeLfLhLiLmLqLxM@MCMGMIMJMNMTM]MeMfMkMrMwN@"},
  {0,NULL,"NCNGNUNuNvNzN{O?OIONOPOUO]OcOfOhOlOvP@PBPCPDPRPZP\\P]PsPuPvPwQ@QIQ"},
  {0,NULL,"QQSQUQXQaQiQlQmQpQvR@RBRERIRKRMRURYR\\RcRiRkRoRpRuRyR~SDSHSJSKSPSQ"},
  {0,NULL,"SRSWSXSYSkSsStSuS{S|T?TLTNTUTWT^TaTmTsTwT{UFUIULUTUUUVUYUZU_UaUdU"},
  {0,NULL,"jUpUqUrUxU{U|V?VGVIVKVOVTVbVcVgVjVnVrVtVuV{W@WEWNWYWZW[WbWdWhWkWn"},
  {0,NULL,"WoWsW}W~XCXDXFXQXWXYXZX[XaXkXlXtXvXwXxXzX|YAYCYDYFYIYJYOYQYRYUYXY"},
  {0,NULL,"[Y\\Y]YcYdYhYiYkYmYnYoYqYtYyY{_D?G?H?L?N?O?R?U?W?X?Z?`?g?q?t?{@@@J"},
  {0,NULL,"@M@N@U@[@_@c@f@p@r@z@~AIALAMATAZA^AbAdAgAjAmAnAtAvAzB@BGBJBMBWBZB"},
  {0,NULL,"^B`BbBdBkBnBqBvB{CBCDCNCOCPCWC]C`CbCiCkClCmCnCrCwCzC{D?DDDMDODQDR"},
  {0,NULL,"DSDUD\\DeDfDmDrDyEAENEPEZE^EbEmEtExEyFDFPFQFRFUFXF\\F_FaFdFfFiFlFuF"},
  {0,NULL,"wFxFzGBGEGKGNGOGRGWG^GaGbGeGsGtH@HDHJHMHPHTHVHZH[H\\HbHgHhHjHlHnHp"},
  {0,NULL,"HxH~I@IAICIJILIMISIXI[I\\IfIpItIxJFJQJVJXJ\\J_J`JbJdJhJoJrJsJ|K@KBK"},
  {0,NULL,"EKGKLKTKXK\\K_K`KbKfKqKzK|LELFLGLPLRLULVLWL^LcLdLeLnLpLqLuLxL|L~M@"},
  {0,NULL,"MAMFMIMRMTMYMZM[MlMqMxNDNENNNSNtNuN|O@ODOKOROZO\\O]OiOmOsOuOvO|O~P"},
  {0,NULL,"APCPRPVPXP[PhPqPtPvQEQGQIQNQOQXQ]Q`QgQhQpQuQ}Q~RFRMRNRVRZR[R^RbRc"},
  {0,NULL,"RmRrRsRvR|R}R~SFSLSNSPSQSWSZS[S\\SlSsStSuS}S~T@TBTHTSTXTbTiTnTpTrT"},
  {0,NULL,"uT|UJUNUQUTUVU[U]U_UbUhUlUmUqUtUyU{U|VCVEVJVNVPVWVcVfVgVjVkVoVpVs"},
  {0,NULL,"VwWCWEWKWQWZW]WcWdWiWjWlWqWsWyW~XCXIXRXUXWX^XbXcXeXhXlXrXvXwXyXzX"},
  {0,NULL,"{X}Y?Y@YHYKYLYNYOYTYVYWYXY^Y_YaYbYcYdYgYjYlYuYwYxY}_E?F?H?K?L?O?R"},
  {0,NULL,"?T?U?X?]?a?g?y?z?~@?@G@P@T@X@a@b@d@f@x@y@}A?AFAPASAWA]A`AcAfAgAjA"},
  {0,NULL,"kAlAuAxAyA}BHBIBLBOBRBWB^B`BdBfBiBjBwBxC@CACCCGCQCYC[C_CaCcChCkCm"},
  {0,NULL,"CnCsCtCwC|DBDEDQDRDTDVDYD[D]DgDlDnDtDyD|EQEWEYE]EbEjEsEuEwFEFIFMF"},
  {0,NULL,"OFYF[F^F_F`FaFeFhFpFtFvFyGCGDGFGLGNGRGWG\\G^GcGhGlGrGvGzG}HIHKHLHQ"},
  {0,NULL,"HTHYH]HaHdHfHhHlHoHqHtHxH|I?IAIDIEIJINIUIWI]IeIgInItIwJGJOJPJWJ\\J"},
  {0,NULL,"]J^J`JcJlJpJqJ}J~K?KCKGKLKPKTKWK\\K]KaKnKoKpKvKyLALHLJLNLPLTLXL]L`"},
  {0,NULL,"LbLdLeLhLiLnLrLyL{M@MBMFMJMNMPMSMXM\\McMiMqMvNANFNMNTNyNzN}OAOCOHO"},
  {0,NULL,"LOPOSO[O_OfOjOnOtOxO}PDPEPSPUPWP]PgPpPwPxQGQIQNQOQRQXQ\\Q`QgQhQpQu"},
  {0,NULL,"Q}Q~RCRJRKRLRORWRXR_RaRlRnRtRuRwRzR{SHSISMSRSXSYS]S^S_SkSpSqSrS{S"},
  {0,NULL,"|TCTFTITJT[T\\TcTjTtTvT}UCUMURUSUTUYU[U\\U_UfUnUoUrUtUuUzU{VAVFVIVJ"},
  {0,NULL,"VLVOVVVdVeVkVnVoVpVsVtVxW@WFWLWPW[W\\W`WcWhWiWjWlWnWzW}XDXHXSXTXZX"},
  {0,NULL,"\\X^XaXbXcXeXtXuXyXzX{X|X}Y@YBYGYIYJYLYNYPYSYVYYY^Y`YaYbYeYfYgYkYl"},
  {0,NULL,"YsYtYvY{Y}_D?G?I?M?N?P?Q?V?W?Y?Z?`?g?r?v@A@F@G@O@Q@S@V@]@`@f@o@q@"},
  {0,NULL,"{ADAFARAVAYA\\A_AaAeAiAkAlAoArAwAzA}B?BIBMBNBTBWB\\B`BaBnBpBuB{B|C?"},
  {0,NULL,"CBCECMCPCWCYC[C]C_CcCkCmCoCtCuCxC~DCDEDFDGDJDKDPDYD[DdDlDnDoDxEAE"},
  {0,NULL,"JEQEVEYEbEkEoE{F@FEFGFLFNFSFVFZF`FcFeFgFjFmFrFwFyGAGBGFGNGPGRGSGU"},
  {0,NULL,"G[GbGfGkGpGtGyG{H@HCHPHTHVHYH[H]HdHfHhHkHmHtHuHvHzH|IEIFIHIKIQIVI"},
  {0,NULL,"WIeIgIiIlIrIxJCJGJNJPJ[J]JcJeJfJgJpJqJtJzK@KBKFKHKIKLKNKTK^KbKfKl"},
  {0,NULL,"KtKuL@LDLFLGLPLRLTLVLXL`LbLdLfLiLjLlLtLzL{M?MCMDMHMKMNMPMXMcMeMhM"},
  {0,NULL,"pMxN@NFNKNMNpNrNwNxN}OGOJOOOSOYOdOeOjOkOqOwPGPJPLPQP_PcPdPkPoPyP|"},
  {0,NULL,"Q?QJQLQPQRQYQ\\Q^QeQkQqQtQwR?RCRGRKRTRWRYR\\RaRgRhRoRpRuRxR{SCSHSJS"},
  {0,NULL,"KSPSQSWSZS[S\\SlSsStSuS}S~TCTITMTNT[T_TaTcTtTyT{T}UHUJUKUOUQUSUXUc"},
  {0,NULL,"UgUiUlUmUnUsUwUyUzU}U~VBVEVSVUV`VbVgVlVoVvVzV{V~WCWEWGWOWWWYWaWbW"},
  {0,NULL,"dWeWiWpWvWyW~XEXGXOXQXWX_XbXgXjXkXnXrXvXxXzX{X|YDYEYGYHYNYOYTYUYW"},
  {0,NULL,"Y[Y\\Y]Y^Y_YcYdYeYjYmYpYsYuYwYxY|Z?_E?G?J?K?M?N?Q?V?X?Y?[?c?f?o?r?"},
  {0,NULL,"}@B@K@M@T@[@_@b@d@e@q@s@|ACAKALAPASAZA^AcAfAgAkAmAnArAvA{A~BDBFBL"},
  {0,NULL,"BRBUBVBZB\\BcBoBsBvBwB|B~CACBCKCRCVCYCZC\\CeCfCiCmCsCuCwCyC{D?DEDHD"},
  {0,NULL,"JDODQDSDTD[DcDdDqDsDvEEELESEUEVE`EkEnE|E~FBFOFPFUFXF[F^FaFeFfFhFi"},
  {0,NULL,"FmFvFxF{G?G@GGGJGKGQGUG\\G_GjGoGrGtGuGzG{HAHGHJHUHWH_H`HbHdHeHhHjH"},
  {0,NULL,"mHnHoHtHwHxIBICIDIHIJIMIWIhIkIlImIsJAJCJEJIJLJ^J_J`JcJdJgJnJrJxJ{"},
  {0,NULL,"KCKDKEKFKJKKKWKZK`KgKkKoKtKxKyK{L?LFLOLQLSL[L^L`LaLdLhLlLnLoLqLuL"},
  {0,NULL,"{L~MEMFMHMIMJMPMdMgMhMjMoMtN?NHNKNONuNvNzN{N~OIONOPOTO]O`OcOfOhOv"},
  {0,NULL,"OzP?PAPEPOPSPYP[PmPrPtPxQCQGQHQTQVQWQ[Q`QfQnQoQrQuQ{RDRGRPRRRTRWR"},
  {0,NULL,"ZR`RaRdRgRhRvRxR{S?SASCSNSZS[S\\S]S^S_SlSpSqSrS}S~TATKTMTVTZT]T_T`"},
  {0,NULL,"TxTyTzUEUIULUMUUUZU[U]UaUbUdUfUjUpUtUxV?VAVGVJVKVNVQVUVVVfVgViVlV"},
  {0,NULL,"qVtVwVxWCWFWOWPW]W^W_W`WdWeWmWnWqWyWzXGXHXUXVXWXZX\\X_XdXfXhXrXuXw"},
  {0,NULL,"XxX{X|X~YCYEYFYKYMYPYUYWYYYZY[Y\\Y]YfYiYnYoYpYqYrYvYwYxY~Z?_F?G?I?"},
  {0,NULL,"L?M?P?S?T?W?Y?\\?d?h?p?s?|@F@I@N@T@U@b@c@d@g@n@vA@ADAGAMAPASATAbAc"},
  {0,NULL,"AdAeAhAjAnAsAxB?B@BABCBDBQBUBXBYB[BdBfBiBpBqBxCBCFCKCRCUCWCXCZC\\C"},
  {0,NULL,"`CcCgChCtCvCxCzC}D?DDDFDLDMDPDRDSDXDcDhDjDlDxEBEHEIESEYEaElEqEzF@"},
  {0,NULL,"FAFOFQFRF[F\\F^F_FbFdFgFiFoFrFsFtFzF}G?GIGMGQGTGZG^GgGoGtGuGwG}HCH"},
  {0,NULL,"DHIHKHSHUHZH[H]H^HaHeHlHnHrHsHuHvI@ICIEIIIKILIOIXI_IbIeIhIrIyJIJJ"},
  {0,NULL,"JMJPJ\\J_JaJbJeJjJsJtJvJwJxJ}KJKMKOKQKUK\\K]K^K_KaKnKxK{K}LFLLLQLUL"},
  {0,NULL,"VLXLYL\\L]LaLfLgLiLmLpLuL|M?M@MDMIMMMOMTMVMXM_MdMpMzNHNINLNMNqNvNy"},
  {0,NULL,"OBODOHONOVOWO\\O_OcOoOpOuO{O|P@PLPPPVPZPdPhPkPnPsQDQFQOQUQVQ_QhQjQ"},
  {0,NULL,"mQnQrQsQ~RARERGRJRSRVRWR\\RaRfRhRmRnRpR{SBSCSFSISKSPSQSSSWSeSfSjSs"},
  {0,NULL,"StSuSxSyTETGTITVTZT[TfTlTqTtU@UEUGULUQUWUXUYU[U`UdUeUlUrUsUtUyU}V"},
  {0,NULL,"?V@VHVIVJVTVWVXV]VkVmVrVtVwV|V}W?WEWNWQWRWUWcWfWkWnWqWtWuWxW~X@XA"},
  {0,NULL,"XFXIXXXYXZX]X^XhXmXqXvXxXyX{X|X~YBYEYGYMYPYRYSYYYZY]Y^Y_Y`YbYeYfY"},
  {0,NULL,"jYmYoYpYrYsYvY}Y~_F?G?J?K?L?N?R?U?X?Y?\\?d?h?t?y@B@D@H@Q@R@S@W@Y@]"},
  {0,NULL,"@g@r@x@|ABAHAQARAUAXA\\AaAdAeAhAjAnAuAvAzB@BBBCBGBOBTBXB[B_BeBfBhB"},
  {0,NULL,"pBuB|CCCFCKCSCTC[C]C^CaCbCdCeCfCpCqCrCsCwC~D@DHDIDODUDYDZD]D`DbDn"},
  {0,NULL,"DqDvEDELEQETEXEaEmEsE|F?FCFHFJFLFNFZF]F_FbFdFgFiFpFuFxFzF|F}GBGIG"},
  {0,NULL,"LGPGTGYG`GdGgGoGvGxGyG{G}HCHEHQHRHVHXH\\H_H`HfHjHpHwHyH|H}I?IDIGIJ"},
  {0,NULL,"IPIQIRISI`IdIgIkIsJ@JDJEJGJKJ\\J_JaJbJeJlJrJsJuJwJ|K@KIKMKPKQKVK[K"},
  {0,NULL,"]K^KiKlKtKxK}LILJLKLMLNLOLRLWLZL[LbLhLkLnLsLtLvLxL~MAMEMGMNMQMSMU"},
  {0,NULL,"MbMcMgMoMsNBNFNJNONoNqNwO@ODOKOOOQOVO\\OdOgOmOoOuO{O|PAPKPPPTPVP[P"},
  {0,NULL,"hPnPtP}Q@QAQDQPQUQaQdQjQkQmQvQyR?RARERLRRRSRTRWRXRaRdRfRgRlRtRxRz"},
  {0,NULL,"R{S?SBSMSTS]S^S_ScSdSpSqSrSvSwSzTCTKTOTQT]TcTdTgToTxT}T~UJUKUNUVU"},
  {0,NULL,"ZU]U^UaUbUcUhUmUqUvU|U~VCVEVKVMVNVOVRVTVXVhVjVnVpVuVzV{WAWFWMWNWR"},
  {0,NULL,"W[WaWbWgWhWjWoWsWwWzX?X@XDXFX[X`XaXcXjXkXlXpXuXxXyX{X|X}YCYDYEYJY"},
  {0,NULL,"LYNYOYXYYYZY\\Y^Y_YcYdYiYlYmYoYqYsYvYwY{_D?F?H?L?O?P?S?T?U?W?^?b?f"},
  {0,NULL,"?p?x?{@?@K@Q@S@Z@\\@]@^@e@v@w@zA?AKANAOARA[A\\AaAdAfAjAlAnApB?BABCB"},
  {0,NULL,"DBFBKBOBRBZB^B`BbBgBhBlBrByC?CECHCMCTCVCZC\\C_CeCfClCmCpCuCwC}D@DB"},
  {0,NULL,"DDDHDPDQDXDZD\\D]D_DdDiDsDwD}EMEUEVE[E`EqErEuExFBFKFLFNFTFWFZF_F`F"},
  {0,NULL,"dFhFiFnFrFsF}G?G@GHGKGLGNGOGWG\\GfGiGkGpGxG~HBHEHFHNHUHWHYH_H`HeHg"},
  {0,NULL,"HhHrHvHwHxH}H~I?IGIHIJIOIRIUIXI^IaIlImIqI~JCJLJSJTJ\\J]J^J_JbJkJtJ"},
  {0,NULL,"vJwJxJ{KAKEKGKPKTKWKXKdKhKiKjKrKuK~L@LDLKLOLQLSLTL[LaLcLdLgLkLlLn"},
  {0,NULL,"LvLyL|MDMEMFMMMQMRMSM^M`MhMjMmMyN?NKNPNQNqNrNsNvO?ONOUOVOXOYOcOlO"},
  {0,NULL,"oOqOrO{P@PBPMPPPZP\\PfPlPnPsPuQ@QEQHQIQRQWQXQ\\Q]QaQoQpQvRCRFRHRPRT"},
  {0,NULL,"RURYR]R`RgRiRjRoRqRxSASDSESGSJSOSTSUSVScSdSiSnSoSvSwSzTATDTMTPTYT"},
  {0,NULL,"_T`TeTyTzU?UAUGUKUNUWUXU[U\\U`UcUeUhUsUtUuU}U~V@VCVHVJVLVOVPVcVdVi"},
  {0,NULL,"VkVoVpVsVzV}WAWBWKWLWZW[WaWcWiWjWlWmWuWwW{XCXDXRXSX^XbXcXeXfXjXmX"},
  {0,NULL,"oXpXwXxXzX|Y@YFYGYHYQYRYSYTYUYVY]Y^Y_Y`YaYbYcYdYeYfYjYkYtYxZAZC_E"},
  {0,NULL,"?F?I?K?M?P?Q?T?V?Y?]?a?g?o?u?|@E@J@R@W@Y@Z@\\@^@f@s@tA@AEAIANAOAQA"},
  {0,NULL,"UAXA[AdAeAhAmAoArAzA}BEBIBKBMBSBUBYB[B^BdBhBjBlBrBwB~CCCICLCQC`Ca"},
  {0,NULL,"CbChCiCkClCmCpCrCvCyC~D?DCDFDHDIDKDMDNDODfDmDpDsD{D|EPEUEZE_EbEiE"},
  {0,NULL,"nEvEzFDFHFJFKFTFWF]FbFdFfFgFjFmFwFyF~GBGFGHGMGQGTGWG]G^GcGjGmGqGv"},
  {0,NULL,"GzG~HEHFHLHQHTHZH\\HaHbHgHhHiHjHuHwHyHzI@IBICIGIIIQISIVI\\IfIjImIvI"},
  {0,NULL,"wJFJLJQJYJaJbJdJeJfJgJpJqJyK@KAKBKGKJKOKQKYK\\KdKiKjKoKpL?LBLCLHLJ"},
  {0,NULL,"LNLPLULWL]L^LcLdLkLmLoLtLuLxLzL}L~M?MEMGMKMTMYM[MfMjMnMvN?NENNNUN"},
  {0,NULL,"pNrNwNxN|OGOJOOOROYOdOeOiOkOqOyPFPKPNPTP^PbPePiP{P}P~QDQEQFQKQMQZ"},
  {0,NULL,"Q]Q_QbQjQsQxQ|RARFRIRMRPRRRURZR`RcRdRiRkRvRyR~S?SASDSNSRSXSYS]S^S"},
  {0,NULL,"_SkSpSqSrS{S|T?T@TATBTWTXT`TbTsTuTzT|UKUOUQURUSUWU^U`UcUiUlUnUoUv"},
  {0,NULL,"UwUyUzU~VFVHVMVQVTV]V^VlVmVpVtV{V|V}W@WFWJWNWUW^WbWeWfWjWnWtWuWzW"},
  {0,NULL,"}XAXFXNXVXXXZX]X_XcXkXmXtXuXwXxXzX{X~YAYGYHYIYLYPYSYUYVY[Y\\Y]Y`Ye"},
  {0,NULL,"YfYhYjYkYrYsYtYuYvYzY~ZC_D?E?J?K?N?O?R?U?V?X?_?e?h?q?z?}@C@I@O@V@"},
  {0,NULL,"Z@\\@^@`@g@p@yAAACAGANAOAVAYA[A_AgAhAmAnAoAuB@BBBCBGBJBMBPBQBRBUBV"},
  {0,NULL,"B\\BjBmBtBzB}C?C@CECICMCWCXCZC[C\\CbCgChCqCrCvCyCzDBDEDFDNDODRDTDWD"},
  {0,NULL,"ZD^DiDjDlDzE?EIEMEREYEaEjEtE}E~FAFGFKFSFTFVFWFaFbFfFiFjFpFuFwFzF|"},
  {0,NULL,"F}GEGJGQGUGXGZG\\GfGkGlGmGpG|H?HHHLHOHSHUH[H\\H^HaHeHfHiHjHlHoHuH{H"},
  {0,NULL,"}IBIIILIPISIUIWIYIaIbIeIuI|JHJMJPJSJ_J`JaJdJfJlJoJsJuJwJ|KBKFKJKK"},
  {0,NULL,"KRKUKWKcKeKmKpKsKuL@LALBLDLQLVLWLYL\\L]LaLbLmLoLpLsLxLyL{L}L~M?M@M"},
  {0,NULL,"JMLMQMVMXM]M`MrMuNGNLNMNPNoNqNtNwO@OKOOOQOVOZOdOgOmOoOsO~PCPFPIPR"},
  {0,NULL,"PXP^PaPiPjPqPvQBQHQLQMQVQWQZQcQeQnQoQqQrQzQ|RJRKRORUR\\R]R_RiRnRpR"},
  {0,NULL,"qRuRwSDSGSHSISKSRSXSYS`SaSbSgShSkSmS{S|TGTITLTPTYT[T^TlTqTtTwU?UJ"},
  {0,NULL,"UNUOUUUVUWU]U`UbUhUiUmUpUqUwU|VCVEVGVHVNVQVVV[VaVhViVlVpVvVwVxW@W"},
  {0,NULL,"DWPWTWXW^W`WeWgWjWmWpWqW|W}XHXLXPXVX\\X_X`XcXfXgXhXsXtXxXyXzX|Y@YD"},
  {0,NULL,"YEYFYJYKYNYQYTYUYVYWYYY^YaYdYeYiYkYnYpYqYwYxYyZBZE_E?F?H?K?L?O?R?"},
  {0,NULL,"T?U?X?]?a?g?y?z?~@?@G@P@T@X@a@b@d@f@x@y@}A?AFAPASAWA]A`AcAdAeAhAm"},
  {0,NULL,"AoAtAvAzBBBCBJBMBNBSBYB]BaBcBlBoBsBwBxCGCHCLCQCUCVCWCYC[C]C_CcCjC"},
  {0,NULL,"oCqCwCxCzC|C}DJDLDPDRDUDVDZDaDdDkDoDwEFEJEOEVE\\EbEjEsEuEwFEFIFMFO"},
  {0,NULL,"FYF[F^FbFdFfFgFjFlFwFxF|F}GBGEGMGSGVG[G]G_GcGhGiGqGwGzG~HAHGHKHVH"},
  {0,NULL,"WHYH[H]HcHdHfHlHmHpHqHsHvH}IFIJIKILINIOIPIZIcIiIlIqJBJCJNJUJZJaJb"},
  {0,NULL,"JdJeJfJhJoJrJuJwK@KBKHKNKOKSKYKZKaKdKgKkKoKvK~LCLHLLLRLSLTLVLXL_L"},
  {0,NULL,"`LbLfLgLjLnLpLrLsM@MAMBMDMHMOMQMWMaMeMhMmM}N@NKNRNVNtNuNwN|ODOOOR"},
  {0,NULL,"OZO\\O]OdOiOsOuOvO{PFPIPKPPPTP^PaPiPjPnP}Q?QCQFQKQQQ^Q_QbQfQiQsQtQ"},
  {0,NULL,"xQ{R@RGRHRIRPRQRYR`ReRhRjRkRoRyS@SASCSESJSOSSSUSVSeSfSiSjSnSoSxSy"},
  {0,NULL,"TMTNTRTTT_TaThTkTyT{UBUDUGUJULUNUPUVU]UbUdUeUhUkUmUqU|V?V@VCVDVEV"},
  {0,NULL,"NV\\V]V^V_VhVjVqVrVwVyV~W?WBWIWJWUWVW_WgWkWqWrWsWvWxW{XAXBXMXNXYX`"},
  {0,NULL,"XdXhXiXlXnXoXqXwXxXzX{Y?YCYFYHYJYKYLYQYUYVYXYYYZY\\YaYcYfYhYiYlYqY"},
  {0,NULL,"rYtYxZ@ZB_F?G?I?L?M?P?S?T?W?Y?\\?d?h?p?s?|@F@I@N@T@U@b@c@d@g@n@vA@"},
  {0,NULL,"ADAGAMAPASATAbAcAfAgAiAkAoApAyA|A~BBBEBGBNBPBTB\\B`BeBfBhBkBqBvCHC"},
  {0,NULL,"KCQCSCUCWCXC[C\\C^CbCeChCtCuCyC|D?DADBDKDLDNDQDTDXD[D^DiDkDmD{EDEM"},
  {0,NULL,"EOEREZEaElEqEzF@FAFOFQFRF[F\\F^FaFcFeFhFjFnFqFuF{F|F~GCGNGPGSGUGXG"},
  {0,NULL,"`GcGdGiGoGwG}HDHEHJHMHUHXH[H\\H^H_HaHfHiHoHrHsHtHxHzIBICIEIHINITIU"},
  {0,NULL,"IYIZIaIfIvJ@JHJQJSJZJ[J^J`JcJfJkJmJnJuJyJ|J~KFKIKNKRKTK[K]K_K`KiK"},
  {0,NULL,"qKxK~LHLILLLMLQLVLWLYL[L]LbLiLlLoLrLuLwLyL}MFMJMKMMMOMPMYM]M`MaMn"},
  {0,NULL,"MsNGNNNPNVNtN{OCOEOFOIOMOZO[O^OaObOhOsOtOyO}P?PHPWPYP`PbPpPrPzP{Q"},
  {0,NULL,"?QLQNQSQTQ[Q^QeQgQlQqQtQ}RBRDRHRMRORPRUR[R_R`RcRiRjRsRwR|R~SASDSE"},
  {0,NULL,"STS]S^S_ScSdSpSqSrSvSwSzTBTLTPTRTYT^TbThTwT|U?UBUHUIUPUSUTU]U^U_U"},
  {0,NULL,"bUgUjUkUnUvUxUzU{VBVDVMVNVUVZV`VdVgVnVqVsVvVzV~WAWFWHWLWOWWW_WaWd"},
  {0,NULL,"WhWlWpWvWwWzXGXKXOXSXWXaXdXeXgXjXnXpXuXwXxXyXzY?YAYDYHYLYOYQYRYTY"},
  {0,NULL,"XYZY\\Y_Y`YcYdYhYiYjYlYmYrYsYuYzZ?ZAZF_D?E?J?K?N?O?R?U?V?X?_?e?h?q"},
  {0,NULL,"?z?}@C@I@O@V@Z@\\@^@`@g@p@yAAACAGANAOAVAYA[A_AeAfAiAjAlAtAxAyA|BAB"},
  {0,NULL,"IBLBTBXB[B]BbBeBgBmBsBzB{B~C?CDCICLCWCXC\\C^C`CcCeChCrCuCxC|D@DDDE"},
  {0,NULL,"DKDPDQDSDWDYDZDcDhDkDmDvD~EHEOESEZEaEjEtE}E~FAFGFKFSFTFVFWF_F`FcF"},
  {0,NULL,"gFhFlFqFsFtFvGCGFGIGOGPGTGVG`GeGjGkGmGqH?HBHGHOHPHUHXHZH[H]H^H_Ha"},
  {0,NULL,"HnHvHxHzH{H|H}IHIKINIRISIWIXIZI_IfIhIsJ?JIJJJQJZJ[J\\J]J^JeJhJmJpJ"},
  {0,NULL,"vJ}J~KCKIKMKQKSKXK[KbKeKhKkKsK|L?L@LBLCLMLQLULVLXLYL[L]LfLlLrLvLx"},
  {0,NULL,"L{L|MDMFMIMKMLMNMQMYM_MaMdMoM{NHNINNNVNpNsNyOAOEOHOJOLOMOXO_OaOkO"},
  {0,NULL,"nOrOwOxPEPMPQPSPUPfPgPlPoPxQ@QAQDQPQSQaQdQjQkQlQvQyR?RARBRGRPRQRV"},
  {0,NULL,"RZR[R`ReRhRmRsRvR|S@SASCSFSNSOSUSVSZS[S\\SiSlSnSoS}S~TBTETRTVTZTbT"},
  {0,NULL,"fThT|U@UBUEUHUKUMURUYUZU\\UaUcUfUgUoUrUuU~VAVBVFVIVKVLVYV\\VbVcVjVn"},
  {0,NULL,"VoVuVyV{V}WBWCWIWSWYWZWbWhWiWoWrWsWuWyW{XCXJXMXQX[XaXbXiXkXlXmXoX"},
  {0,NULL,"rXwXxXyX{X}X~YAYCYIYJYKYLYMYNYSYVYXY[YgYhYkYnYoYqYtYuYvYwZ@ZBZDZH"},
  {0,NULL,"_D?E?I?M?O?P?S?T?V?W?_?e?h?w?x@A@E@H@M@P@X@[@_@a@g@u@w@{AEAHALAWA"},
  {0,NULL,"ZA]A^A`AgAhAmAnAoApAwAyA{A|BBBGBQBSBUBXB[B^BmBnBsByB}C?C@CACDCGC]"},
  {0,NULL,"C^C`CaCcCdCeCfCoCwC{C}C~D?DADHDJDLDMDUD[D\\D_DbDnDuDxD~EKEQEXE[EaE"},
  {0,NULL,"pErEvE{FCFIFMFPFUFXFYFaFbFfFiFjFnFqFuF|GAGCGGGIGQGTGWGZG]GeGhGkGl"},
  {0,NULL,"GrG|H?H@HGHNHQHRHVHXHZH]H_H`HmHpHsHtHwH~I@ICIFIJIMIOIQITI^IdIgIoI"},
  {0,NULL,"rJ?JDJGJRJTJ_J`JaJdJfJkJmJuJzJ|J~KDKGKJKMKQKUKYKcKeKfKkKrKvKyK|L@"},
  {0,NULL,"LALMLNLOLRLULXLZL[LgLjLnLqLtLuLwMAMEMHMOMPMRMTM^MbMcMkMpM{NBNCNFN"},
  {0,NULL,"QNoNtN{OCOFOIOQOZO[O^ObOgOhOsOtOzO~PIPJPOPXPaPcPjPmPqP|QFQMQOQUQV"},
  {0,NULL,"QZQ_QhQmQnQrQsQ|Q~RERKRTRXRYR]R^RgRlRoRqRrRuRxRzSGSHSJSLSOSUSVSZS"},
  {0,NULL,"[S\\SiSlSnSoS}S~TCTDTQTUTcTeTgTmToT}UAUFUHULUMUPUQUTU^U_UdUfUgUkUl"},
  {0,NULL,"UvUyU{V?VAVBVDVMVPVQV[V^VjVmVqVsVtV|V}WBWCWJWKWTW^W_WfWlWnWsWtWuW"},
  {0,NULL,"yW{XLXNXRXVXXXZX]XdXeXlXmXoXrXxXyXzX|YAYBYDYGYIYJYMYNYQYRYSYTY[Y`"},
  {0,NULL,"YeYgYhYkYmYnYpYsYtYuY|Y~ZAZCZG_D?F?J?K?N?P?Q?U?V?Y?^?b?f?u?v@C@D@"},
  {0,NULL,"L@N@P@U@X@a@c@e@o@tAAABAJAMATAWA]A`AbAhAiAkAmAoAqAwAzB?BEBIBKBPBQ"},
  {0,NULL,"BRBVBZBcBfBgBiBxByCDCHCNCOCTC\\C^C_CfCgCjCkClCqCxCyC{C|C~DADIDJDKD"},
  {0,NULL,"LDTDUDWD`DhDrDtDvD}EHENETE]E`EiEoE}F?FFFIFMFQFRFYF\\FbFcFeFfFjFkFr"},
  {0,NULL,"F~GAGBGFGHGJGKGXGZG\\G_GaGeGiGsGxG}HBHIHKHNHSHTHUHXHYH`HcHgHmHoHpH"},
  {0,NULL,"sHyHzH{IBIKIMINIPIQITI[I_I`InIsI~JJJKJVJWJ[JaJcJdJfJiJpJtJyJzK@KA"},
  {0,NULL,"KEKKKRKUKWKZK]KaKhKnKrKzK|K~LELKLMLOLPLQLTL\\L_LcLfLoLqLrLsLtLwMAM"},
  {0,NULL,"GMHMJMKMLMOMUMZM_MiMoMyNINJNSNTNxN|N}OBOFOGOROSOWO^ObOeOiOjOpOwOy"},
  {0,NULL,"PJPKPQPTPbPcPoP{P|P}QBQCQGQTQVQ[Q`QcQfQnQrQuQzQ{RDRLRQRSRVRXR[ReR"},
  {0,NULL,"fRlRmRsRtRzR|S@SBSFSMSOSTSUSVScSdSiSnSoSvSwSzTETFTOTSTdTfTiTjTpT~"},
  {0,NULL,"U@UCUGUKUMUOUQUSU]UbUcUeUfUiUlUnUwUyUzU~V@VAVNVZV[V_VaViVlVsVwVxV"},
  {0,NULL,"|V~WAWBWHWTWVWXW`WeWlWmWqWtWvWwW{XBXKXLXPX\\X]X_XeXfXhXnXoXpXwXyX{"},
  {0,NULL,"X|X}X~Y@YEYIYOYPYSYUYVYWY]Y^Y_YaYbYdYeYjYkYoYqYvYwYyYzZGZHZJ_E?G?"},
  {0,NULL,"J?K?M?N?Q?V?X?Y?[?c?f?o?r?}@B@K@M@T@[@_@b@d@e@q@s@|ACAKALAPASAZA^"},
  {0,NULL,"AcAdAeAhAiAlAqAwA}B?BEBKBMBOBXB]B_BbBeBkBoBqBtBvC@CACGCJCRCVCXCZC"},
  {0,NULL,"_CdCeClCmCsCxCyCzC}D@DCDFDIDJDSDVDXDZD_DeDgDiDzECEMEWE[E^E`EkEnE|"},
  {0,NULL,"E~FBFOFPFUFXF[F^F`FbFcFdFgFkFrFwFyF~GAGHGIGLGOGVGYG`GhGlGnGrGuHAH"},
  {0,NULL,"DHHHJHMHRHWHYH^H_HeHgHhHmHnHqHrHuHyH}IBIDIKILIOIRIVI]I^IaIpIuIzJO"},
  {0,NULL,"JSJTJXJ[J]JaJbJeJiJqJtJyJzKAKBKMKPKSKVKXK[K_K`KgKmKqKvKwKyK{LALSL"},
  {0,NULL,"TLYLZL[LaLcLdLfLgLhLoLpLvLzM?MBMGMHMIMMMQM\\M^M`MlMrM|NANDNPNQNrN|"},
  {0,NULL,"N}OBOFOROSOWOYO^ObOiOjOpOqPFPGPLPNP^P_PdPePiPkPyP~QAQIQQQSQUQXQdQ"},
  {0,NULL,"iQlQmQpQyR@RBRERHRJRNROR]R^R_RbRjRnRqRrRwR}SESGSISLSSS`SaSbSeSfSg"},
  {0,NULL,"ShSjSmSxSyTDTHTJTPTYT\\TeTnTrTvU?UAUKUOUPUQUSUVUYUcUiUkUlUnUqUrUwU"},
  {0,NULL,"yUzU|U~VDVIVRVXVYV\\VjVkVnVuV{V|V~W?WDWIWMWRWSWbWcWhWoWsWtWvWxW|X?"},
  {0,NULL,"X@XJXMX[X]X^XaXkXlXnXqXsXwXyXzX|X}Y@YAYDYIYLYNYOYPYTYWY[Y\\Y`YdYgY"},
  {0,NULL,"iYkYlYnYsYuYvYwYzY{ZBZDZG_E?G?H?L?M?O?S?T?W?X?[?c?f?s?w?~@@@L@O@R"},
  {0,NULL,"@V@W@Y@`@e@n@u@}@~AJAQAUAVAXAYA_AdAeAhAiAlApAxB?B@BDBFBKBNBSBVB]B"},
  {0,NULL,"_BcBjBmBtBvB|B~CACJCPCSCYC\\C^CfCgCiCjCkCoCpCrCtC|C~DDDKDMDNDPDUDY"},
  {0,NULL,"D]D^DrDtDuDyEEEKENERE]E`ElEpEwEyFFFGFHFJFSFVF]F`FbFcFdFgFnFrFtFzG"},
  {0,NULL,"?G@GHGJGSGVGYG]G_GbGdGjGnGrG{H?HHHJHLHSHTHUHXH`HbHcHdHiHpHvHzH|I?"},
  {0,NULL,"I@IEIFIGINIQISIXIYI[InIoItJAJHJRJVJWJ[J]JaJbJeJkJsJtJxJ{J}KAKKKNK"},
  {0,NULL,"SKVKYKZK`KeKmKpKtKwKyL?LGLILMLOLPLQL\\L^L_L`LiLjLkLrLtLxL|L}MAMDMK"},
  {0,NULL,"MNMSMTMZM]MiMkMqMtNCNGNSNTNqNrNsO?OBOUOVOWOXOYOlOoOpOqOrOxO|PLPNP"},
  {0,NULL,"UPVPdPePgPhPkP~QAQBQJQKQQQYQbQcQdQiQwQxQyQzR@RKRMRORXR[R^R_RcRlRr"},
  {0,NULL,"RsRuRwRzR|R~SHSLSZS[S\\S]S^S_SlSpSqSrS}S~TFTLTSTUT^TiTjTmTpTwUCUFU"},
  {0,NULL,"GUJURUWUXUZU[U`UaUeUmUoUsUtU}V@VEVFVHVJVKVRV\\V^V`VhVlVqVrVyVzV}WC"},
  {0,NULL,"WFWIWJWMWWW_WaWeWgWkWrWuWyWzX?XMXNXOXYX_X`XdXiXjXmXrXuXwXyXzX|Y?Y"},
  {0,NULL,"@YBYFYKYMYPYQYRYTYWYYYZY`YaYbYfYgYiYlYnYpYrYxY}Z@ZCZEZIZK_D?G?I?M"},
  {0,NULL,"?N?P?Q?V?W?Y?Z?`?g?r?v@A@F@G@O@Q@S@V@]@`@f@o@q@{ADAFARAVAYA\\A_AaA"},
  {0,NULL,"dAgAjAmAnAqAvA~BFBHBJBLBQBSBXBYB^BdBgBkBuBzB{CECJCOCPCSCVCYC[C_Ca"},
  {0,NULL,"CcChCjCqCsCuCvC}C~DBDFDGDHDLDTDZD]DaDgDkDtD{EGEOEWE\\E]EbEkEoE{F@F"},
  {0,NULL,"EFGFLFNFSFVFZF_FaFdFfFiFkFvFxF{G@GDGEGIGMGWGZG]G^GbGdGfGnGsGyHBHM"},
  {0,NULL,"HOHPHQHWHYH]HaHcHdHfHkHoHsHuHwH}I?IDIHIIIOIPIQIUIZI]IcInIvI{JOJUJ"},
  {0,NULL,"WJZJ\\J_J`JbJdJiJnJoJrJ{K?KCKGKMKOKUKYK\\KbKhKlKqKsKuKwLELGLILNLSLT"},
  {0,NULL,"LXL]L_L`LbLgLhLlLmLsLtLyM?MCMEMJMOMQMSMWM\\MaMiMnM~NANRNTNVNuN~O?O"},
  {0,NULL,"@OAOKOLOTOUO]O`OlOmOnOvP?PAPBPCPRPYP[P\\PrPtPuPvQDQEQKQMQOQZQ]QbQh"},
  {0,NULL,"QjQxQ|Q~RARFRHRLRNRORQR[R_RbReRjRsRtRwR|R}S@SESMSTS`SaSbScSdSgShS"},
  {0,NULL,"mSvSwSzTFTJTRTTT\\ThTjTkTvUBUCUDUIULUUUWUZU\\U^U`UaUdUjUpUuUvUxV?VG"},
  {0,NULL,"VHVKVLVMVPVWVXV[VhViVmVtVuV|V}WAWDWKWQWRWTWfWgWmWnWoWtWuWwW|X@XIX"},
  {0,NULL,"LXRXXXZX[X]X`XfXmXpXsXwXyXzX{X~Y?YAYBYIYKYMYOYPYRYWYXY[Y]YbYgYhYj"},
  {0,NULL,"YmYnYoYpYrYuYyZ?ZCZDZFZG_D?F?H?L?O?P?S?T?U?W?^?b?f?p?x?{@?@K@Q@S@"},
  {0,NULL,"Z@\\@]@^@e@v@w@zA?AKANAOARA[A\\AaAhAiAkAmAoAsAwAyA{A~BEBGBVBYB]B_Ba"},
  {0,NULL,"BcBgBiBrBzB{CCCFCMCNCTCVCXCYCZCdCeCiCmCoCpCzD?DBDCDEDFDNDODPDVD[D"},
  {0,NULL,"\\DcDeDgDqDyE@ELESEWE^E`EqErEuExFBFKFLFNFTFWFZFbFcFeFfFjFoFuF{F~GA"},
  {0,NULL,"GCGGGJGMGVGYG[G_GaGgGpGvGxHBHFHIHOHPHRHWH^H_HbHdHeHhHiHjHqHtHuHvH"},
  {0,NULL,"~ICIFIGILIUIVIWI]IhIkIpItI}JEJIJOJXJ[JaJcJdJfJjJnJyJzJ|J~KDKHKKKO"},
  {0,NULL,"KSKVKZKbKhKjKnKsKzK}LDLJLKLSLYLZL[L^L`LaLdLjLkLpLuLyLzL{L}L~M?MBM"},
  {0,NULL,"DMPMRM\\MdMgMlMqMwNANDNHNONoNxN~OEOFOGOMOQOTO^O`OaObOeOgOyO}O~PJPW"},
  {0,NULL,"PXPbPcPpPqP{P|QAQBQCQJQKQYQbQcQdQfQwQxQyQzQ{RJRLRNRVRWRZRaRbRmRnR"},
  {0,NULL,"tRvR{R}SFSISMSNSPSQSRSWSXSYSkSsStSuS{S|THTJTKTVTZT\\T]TnTrTvTxUEUH"},
  {0,NULL,"UJUPURUTUUU^U_UgUkUmUoUpUvU{VBVDVEVFVGVMVSV]V_VaVhVmVqVrVvVyV{W@W"},
  {0,NULL,"EWGWUWVWXW_WbWfWgWkWpWrW}W~XAXBXEXPXXXYX`XdXgXiXkXtXvXwXyX{X|X}Y?"},
  {0,NULL,"YBYCYIYJYMYOYQYRYSYXYZY_YaYbYcYgYhYlYmYoYqYtY|Z@ZAZEZFZL_E?F?I?K?"},
  {0,NULL,"M?P?Q?T?V?Y?]?a?g?o?u?|@E@J@R@W@Y@Z@\\@^@f@s@tA@AEAIANAOAQAUAXA[Af"},
  {0,NULL,"AgAjAkAlAqAvA{BDBHBJBLBNBPBWB`BaBeBjBlBmBtBxCCCFCGCLCTCVCWC]C`CbC"},
  {0,NULL,"iCjClCuCvC{D@DADCDDDGDHDKDSDWDXD\\DbDeDjDrDxEFEIENEXE^EbEiEnEvEzFD"},
  {0,NULL,"FHFJFKFTFWF]F_F`FaFeFhFkFvFxG?GDGEGGGNGRGSGXG[G`GgGhGqGvGxG~H?HHH"},
  {0,NULL,"KHLHVHWHZH[H\\HbHcHgHkHnHrHwHzH{H~IHIIIMIRITIVIXI[IbIdIpIrJBJDJMJV"},
  {0,NULL,"JXJ\\J]J^J`JcJiJoJrJxK?KCKDKHKLKNKRKTK[KaKdKeKmKpKvK}LCLJLKLRLSLUL"},
  {0,NULL,"VLWL^L_LcLlLmLqLvLwLzL|MCMEMIMKMLMMMRMVMZMbMlMpM}NBNDNLNSNzN~O?O@"},
  {0,NULL,"OAOKOLOPOTOUO`OfOlOmOnOzP@PDPEPOPSPZP]PmPsPwPxQJQLQNQPQRQYQ\\QeQgQ"},
  {0,NULL,"kQqQwQ}R?RCRJRSRVRXR]R^RfRlRmRnRqRrRzSBSFSGSISLSOSSSUSVSeSfSiSjSn"},
  {0,NULL,"SoSxSyTGTHTQTSTgTiTlTnToTpTqTrUHUIULUNUUUXUZUaUdUgUhUjUpUsUxU}V?V"},
  {0,NULL,"BVCVGVKVYVZVdVeVgViVuVvVyVzV~W?WBWHWLWSW\\WaWdWmWoWpWrWvWxW{XJXKXS"},
  {0,NULL,"XTXWX[XfXgXiXjXnXoXqXyXzX{X|Y?YBYDYEYIYJYOYPYQYUYWYYYZY\\YaYeYhYiY"},
  {0,NULL,"lYmYpYqYrYsYyYzY|Y~ZDZI_D?E?F?K?O?P?Q?R?S?a?b?e?i?j?k@@@B@F@N@Y@]"},
  {0,NULL,"@_@`@d@i@j@k@|@~ADAMAXA\\A^A_AcApAqAtAvAxA|B?BEBFBGBHBMBNBXBZB\\B_B"},
  {0,NULL,"dBhBsBtBxByB{C?CACLCOCTCUCWCcCeCfCjClCnCsCtDFDNDOD_DaDeDiDkDlDmDp"},
  {0,NULL,"DqDrDtDuD|E?E@ELEYE_EcEdEeEyE|F@FJFLFRFVFXF^FkFlFnFqFrFtFuFwFxF~G"},
  {0,NULL,"@GDGIGKGSGUGYG^GkGqGrGsGwGxHEHGHHHKHNHPH[H]H_H`HcHgHiHjHuIAIDIEIZ"},
  {0,NULL,"I[I^IaIcIeIfIjIkInIoIpIwI|I}JEJPJYJhJiJkJmJrJtJyJ{J|J}K?KBKEKFKMK"},
  {0,NULL,"NKVK\\KaKbKiKkKmKrKyL@LCLELKLLLOLVLXL[L_LcLeLhLiL}L~M?MWMXMYMZM^M`"},
  {0,NULL,"MaMfMgMiMkMlMuMvMwNMNONUNZNeNfNgNjNkNlNmNnO|O}P?PCPGPNPRPVPWPYP_P"},
  {0,NULL,"ePhPpPrPvPyP~QBQIQKQMQNQSQXQZQbQcQgQlQpQxQzQ|Q}RBRRRWR\\RaRdRpR{S?"},
  {0,NULL,"SKSOSPSQSUSVSWS]S^S_S`SaSbSiSnSoT?T@TITJTKTLTWTXT[T\\T]T^TsTtTuTvT"},
  {0,NULL,"wTxUIUJUOUYU[U^UiUjUmUrUtUvUwUxVEVIVJVMVPVZV\\ViVjVsVyV}V~W?WAWBWC"},
  {0,NULL,"WHWIWKWlWmWrWsWuWvWwWxWyW{XKXMXRXeXfXiXlXmXnXoXpXqXrXxX{X|X}X~YBY"},
  {0,NULL,"CYDYEYFYGYHYJYSYUYZY[Y^YaYcYeYfYhYkYoYpYqYsYtYwY|Y~ZHZLZMZN_D?F?G"},
  {0,NULL,"?L?N?P?Q?R?S?\\?^?`?k?l?m?}?~@E@M@O@W@X@\\@b@h@j@l@}ACAEALAPAUAWAYA"},
  {0,NULL,"[ApAqAuAwAyA}B@BBBDBJBKBLBRBSBUBWB]BeBgBhBuBvBxB}C?CCCHCJCKCOC\\C_"},
  {0,NULL,"CaCbCeCjCoDCDEDMDRDSD^D_DbDcDfDgDiDjDnDoDrDtE@EAEBEJEPESEdEfEgEvE"},
  {0,NULL,"wE~FHFIFKFPFSF[FkFnFpFvFyFzF|G?GAGCGEGHGQGRGVG\\G]G`GiGkGnGoGsGvGy"},
  {0,NULL,"G|HBHEHJHKHQHUHYH\\H_HcHlHnI@IFIVIWIYI[I\\I]I^IaIbIdIgIhIiInIxIyI}J"},
  {0,NULL,"FJIJNJiJkJlJoJqJsJuJxJzJ~KAKCKJKLKSKWKYK[K`KaKcKhKiKlKwKxK~L@LELJ"},
  {0,NULL,"LNLQLTLWL[L_LjLzL{M@MIMTMVMZM[M\\M]M^M`MbMcMdMeMiMwMxMzN@NENHNWNYN"},
  {0,NULL,"[N_N`NaNbNhNiOxOzO~PDPFPLPOPUPXP]P^PdPgPiPkPmPqPwQBQIQJQLQOQUQXQY"},
  {0,NULL,"QcQeQhQmQpQqQwQzQ~RERGRIRZRhRkRvRySCSNSRSSSTSXSYSZS[S\\ScSdSeSfSvS"},
  {0,NULL,"wSzT@THTITNTUTVTXTZT[TaTmTnTrTtTuT{UEUFUHULUOURUVU[UdUgUiUoUqUtUw"},
  {0,NULL,"U|V?VBVFVJVRV[VdVhViVnVsVzV|WAWBWDWFWLWMWTWaWgWhWlWmWtWwWzW{W|X?X"},
  {0,NULL,"LXSX]X`XaXeXfXjXoXpXsXuXwXxX{X}X~Y?YAYCYEYFYGYHYMYVYXY\\Y]Y_YbYcYd"},
  {0,NULL,"YjYmYoYqYrYtYuYvYxZ?ZFZJZLZMZP_E?F?G?K?L?M?Q?R?S?[?]?d?i?l?n?{@A@"},
  {0,NULL,"C@Q@U@V@Z@[@a@k@l@m@z@{AAANATAVAZA`AaAqAsAtAwAyAzA~B@BABJBKBLBQBT"},
  {0,NULL,"BVB^BaBbBiBkBlBpBsBtCGCICPCRCTCUCVCXC]CcCgClCpCrC~DQDTD[D^D`DaDcD"},
  {0,NULL,"eDfDgDhDkDnDrDsD|EDEEEQEREUEeEfEhExE{E}FGFMFQFTFUFZFkFlFoFsFvFzF{"},
  {0,NULL,"GAGBGCGEGHGJGOGPGWGZG[GbGhGmGuGwGxG~HCHGHHHIHMHSHVHWH]H^HgHoHtHxI"},
  {0,NULL,"GIQISIYIZI[I\\I]I_I`IcIgIhImIpIwJ@JAJGJHJLJhJiJjJnJoJsJvJzJ~K@KAKC"},
  {0,NULL,"KGKHKIKKKUKXK^KdKkKmKnKqKvK{LBLGLKLLLRLSLXLYL\\LcLkLtLxMFMJMPMUMWM"},
  {0,NULL,"ZM[M\\M]M_MaMcMdMjMlMsMtMvN?NFNGNWNYN\\N]N^NaNbNhNiOwOxOyO~PAPBPQPU"},
  {0,NULL,"PXP[P\\PbPgPoPqPtPuP{QAQDQGQKQNQTQ[Q`QbQdQgQjQuQxQyQ}RARDRKRTRURgR"},
  {0,NULL,"iRuRxSDSHSRSSSTSXSYSZS[S\\ScSdSeSfSjSxSyTATBTCTFTKTLT]T^T`TbTcTjTw"},
  {0,NULL,"TxTzT|T}UCUIUJUKUMUTUWU_U`UcUfUjUmUxU{U~VAVEVHVWVYV_VkVmVuVwVyV~W"},
  {0,NULL,"?WBWDWEWQWSWVWcWfWoWqWrWvWxW{W|W~XBXIXJXXX[X^XhXiXnXoXqXsXvXxXzX|"},
  {0,NULL,"Y@YAYBYCYDYEYFYGYHYNYQYYY\\Y]Y`YdYeYfYiYlYmYnYrYsYtYvYxY{Y~ZIZKZNZ"},
  {0,NULL,"O_D?E?G?M?N?O?Q?R?S?Z?_?c?j?m?n?|@?@D@P@R@S@T@^@c@h@i@mA?A@ABAOAQ"},
  {0,NULL,"ARASA]AbApArAtAyAzA}A~BABBBDBJBKBOBPBYB[B`BcBmBqBwByB{B|CACBCDCLC"},
  {0,NULL,"MCSCWCYC^C`CfCmCqCvDBDIDVDXD^D_D`DdDfDgDjDkDmDoDsDuE?ECEGEIETEWEc"},
  {0,NULL,"EgEhEuEzF?FNFOFWFYF\\F]FlFmFnFsFyF{F|G?GBGCGEGHGLGMGNGTGXG_GdGeGpG"},
  {0,NULL,"qGrGtGzG{H?HDHNHPHXHZH[H`HdHhHqHrHyIIIPIUIYIZI\\I]I^I`IbIfIiIlImIo"},
  {0,NULL,"IzI{I|JKJMJOJgJhJkJnJoJqJuJvJxJ~K@KAKOKPKQKRKTKZK_KbKeKoKrKtKyK|L"},
  {0,NULL,"CLDLFLILMLOLULVL`LdLmLsLyMBMGMMMUMVMYM[M\\M]M^MaMeMhMjMkMuM|M~NANJ"},
  {0,NULL,"NLNYN[N\\N]N^N_N`NhNiOyO{PBPDPFPHPPP\\P]P^P`PbPiPnPuPwPzP{Q?QEQHQMQ"},
  {0,NULL,"QQSQWQZQ]Q^QiQlQoQtQ|R@RBRFRJRLRSRfRnRtSBSISMSRSSSTSXSYSZS[S\\ScSd"},
  {0,NULL,"SeSfSlS}S~T?TGTJTOTPTTTWTYT\\TdTkTlTqTsTvT~U?UDUGUNUSUUUYU^UeUhUnU"},
  {0,NULL,"pUrUvUzV@VCVGVIVMVUV^VcVgVjVlVoVqV}WBWCWEWFWJWOWZW_WdWeWiWsWuWyWz"},
  {0,NULL,"W{W~XCXGXNXWX_XbXdXlXmXoXrXuXvXyX{X|X}X~Y?Y@YBYCYDYEYGYIYMYNYWYYY"},
  {0,NULL,"_YbYeYgYlYmYnYpYqYuYvYwYxY|Y}ZDZEZGZH_D?E?G?M?N?O?Q?R?S?Z?_?c?j?m"},
  {0,NULL,"?n?|@?@D@P@R@S@T@^@c@h@i@mA?A@ABAOAQARASA]AbAqAsAuAvAxA{B?BCBEBGB"},
  {0,NULL,"HBIBOBPBYB[B`BcBgBjBkBoBpB}CECGCICJCKCNCVC_CbCdCgChCwC{D?DKDPDYD`"},
  {0,NULL,"DbDdDeDgDhDjDlDmDqDtDuD~EAEEEKEVEZEcEgEhEuEzF?FNFOFWFYF\\F]FkFoFpF"},
  {0,NULL,"rFtFuFxF}F~GDGFGGGLGMGNGTGXG_GaGfGhGmGnGoG|HAHBHCHLHMHRHSHWHYH\\Ha"},
  {0,NULL,"HvHzH|ICIJIMI]I_I`IbIdIeIfIkIlInIoIpIxJ?JAJCJQJRJiJjJlJpJrJtJwJyJ"},
  {0,NULL,"|J}K?KDKOKPKQKRKTKZK^KcKgKhKpKqKuKvKwKxKzLBLSLTLWLZL\\L]LnLqLuMDMK"},
  {0,NULL,"MNMUMVMXMYM\\M_MbMgMhMiMkMlMtMxM{NCNKNNNXNZNcNdNjNkNlNmNnO|O}P@PEP"},
  {0,NULL,"JPKPSPTPVPWPZPcPhPpPsPxP|P}QAQGQJQOQPQVQYQ`QdQhQkQnQrQuQwQyQ~R?RM"},
  {0,NULL,"RPRYR`RcRoR~SASJSOSPSQSUSVSWS]S^S_S`SaSbSgShSmTBTCTMTSTUTVTZT_TbT"},
  {0,NULL,"cTiTmTpTyT|T}UEUFUKULURUTUXU]U_UbUcUdUoUsU{U}U~V?VFVNVXVaVeVhVkVu"},
  {0,NULL,"VvVxV|W?W@WAWDWRWXW\\W`WcWgWoWpWtWwWxW|W}X@XPXTX[X\\X]X^X`XgXpXqXsX"},
  {0,NULL,"tXwXxXzX~Y?Y@YAYCYDYFYGYHYKYLYRYTYUY[YcYfYgYhYiYjYkYnYpYuYwYxZ?ZB"},
  {0,NULL,"ZCZKZOZP_D?E?F?K?O?P?Q?R?S?a?b?e?i?j?k@@@B@F@N@Y@]@_@`@d@i@j@k@|@"},
  {0,NULL,"~ADAMAXA\\A^A_AcArAsAuAwAzA}A~B@BABBBDBLBNBXBZB\\B_BdBfBjBnBoBrBzB~"},
  {0,NULL,"C@CECFCNCQCZC[CdChCiCkCuD@DDDJDLDUD_D`DcDjDkDlDnDoDpDqDrDsD}D~EFE"},
  {0,NULL,"NEOE[EcEdEeEyE|F@FJFLFRFVFXF^FmFoFpFsFvFyFzF{F|G?GAGBGIGKGSGUGYG^"},
  {0,NULL,"GaGcGfGgGjGlG}H@HAHFHLHOHRHTHaHbHeHfHmHpHsIHIRIXIZI[I^I`IbIeIgIhI"},
  {0,NULL,"iIjIkImI~J?JBJTJVJZJgJjJlJnJqJsJuJvJxJzK@KCKEKFKMKNKVK\\K]KfKgKjKp"},
  {0,NULL,"KsKuKzK}L?LALHLPLZL]L^LaLbLlLvL|MAMHMOMUMVMXMZM^MaMcMdMeMfMgMjMyM"},
  {0,NULL,"{M}NQNSNVNWN[N\\N]N^N_N`NaNbOwOzO{PAPHPLPOPPPQP[P`PdPkPmPnPoPtPzQ@"},
  {0,NULL,"QCQFQPQRQVQ\\Q_QaQfQkQnQrQsQvQ{R?RCRHR[R^RjRrRsR|SESLSRSSSTSXSYSZS"},
  {0,NULL,"[S\\ScSdSeSfSkS{S|TDTETMTQTRTST_TeTfTgThTiToTpTyU@UAUBUPUQUXUZU\\U]"},
  {0,NULL,"UaUbUkUlUsUuUyU}VDVKVLVNVSVTVVVpVrVtVvVxV{W@WDWEWFWGWNWPW`WbWjWkW"},
  {0,NULL,"nWpWzW|W}W~XEXFXHXYXZX\\XcXgXkXsXtXuXvXwXyXzX}X~Y?Y@YAYBYDYFYHYIYQ"},
  {0,NULL,"YVYWYXY`YaYbYdYeYhYkYlYnYqYrYtYuYyYzZ@ZAZBZC_D?F?G?L?N?P?Q?R?S?\\?"},
  {0,NULL,"^?`?k?l?m?}?~@E@M@O@W@X@\\@b@h@j@l@}ACAEALAPAUAWAYA[ArAsAtAvAxA{A|"},
  {0,NULL,"BCBEBFBIBMBRBSBUBWB]BeBiBlBnBqBzB|CDCFCMCPCQCRCXCYCZC]C`CkCyC|DAD"},
  {0,NULL,"HDZD]DaDbDcDdDfDhDiDmDoDpDqDtD}EDEGEMEXE]EdEfEgEvEwE~FHFIFKFPFSF["},
  {0,NULL,"FlFmFoFqFtFwFxF}F~G@GFGGGQGRGVG\\G]G`GbGcGeGgGpGuG{G~H@HDHIHOHTHVH"},
  {0,NULL,"ZH^HdHeHwH}I?IBINITI\\I_IaIcIdIfIhIiIjIkIlInI{I~J@JDJSJWJgJhJjJmJp"},
  {0,NULL,"JrJwJyJ{J}KBKDKJKLKSKWKYK[K_KdKfKnKsKtK{K|K}LDLGLHLPLRLULYL`LaLoL"},
  {0,NULL,"rLwMEMQMSMWMYM[M_M`MbMdMeMfMgMhMiMsMyM~NBNPNTNXNcNdNeNfNgNlNmNnP?"},
  {0,NULL,"PEPIPKPMPNPSPTPYPaPePfPjPlPrPxP}P~Q?Q@QCQDQEQTQ[Q]Q^QaQfQjQtQvQ{R"},
  {0,NULL,"ARDRFRORXR]R_RlRqRwRzSGSOSPSQSUSVSWS]S^S_S`SaSbSsStSuTATFTOTPTQTR"},
  {0,NULL,"TYT`TdTgThTjToTzT~U?UBUCUMUNUPUSUWUZU`UaUfUhUkUnUzVAVCVDVHVKV]VbV"},
  {0,NULL,"fVgVmVoVrVwV{W?W@WCWEWUWYW]WbWdWfWiWkWqWxWyW}W~XAXQXUXWXXXYXbXhXk"},
  {0,NULL,"XqXrXtXvXyXzX|X}Y?Y@YAYBYDYEYFYGYJYOYPYRYTY^YaYbYcYdYgYiYjYkYmYoY"},
  {0,NULL,"pYsYyY{ZAZEZGZI_E?F?G?K?L?M?Q?R?S?[?]?d?i?l?n?{@A@C@Q@U@V@Z@[@a@k"},
  {0,NULL,"@l@m@z@{AAANATAVAZA`AaApArAuA{A|B?BCBFBGBHBIBMBQBTBVB^BaBbBfBmBrB"},
  {0,NULL,"uBvBwB~C@CBCCCHCSC[C\\C^CaCiCmCxCzC}DGDWD\\D^DaDbDdDeDhDiDlDnDpDsDu"},
  {0,NULL,"EBECEFEHE\\E^EeEfEhExE{E}FGFMFQFTFUFZFmFnFpFqFrFuFwF}G@GDGFGGGJGOG"},
  {0,NULL,"PGWGZG[GdGiGjGlGtGvGyGzG}H?HFHJHQHUHXHbHfHhHkH{H~IKILIOIYI_IaIcId"},
  {0,NULL,"IeIgIjIlImIoIpIyIzJBJJJUJXJgJkJlJmJpJtJwJ{J|K?KBKDKGKHKIKKKUKXK]K"},
  {0,NULL,"`KeKjKlKoK~L?LALFLILJLMLNLQL^LbLdLfLgLpMCMLMRMWMXM]M_M`MbMcMfMhMj"},
  {0,NULL,"MkMlMzM|M}NDNINRNXNZNcNdNeNfNgNjNkP@PCPGPIPJPMPRPZP_PaPcPfPjPlPsP"},
  {0,NULL,"vPyP|QFQHQLQQQRQUQWQ\\Q_QeQiQmQoQqQsR@RCRERNRQRVRbReRmR}S@SFSOSPSQ"},
  {0,NULL,"SUSVSWS]S^S_S`SaSbSpSqSrTDTETGTHTNTTTaTeTfTkTlTnTqTrT{U@UAUDUGUHU"},
  {0,NULL,"QUUUVU\\UeUgUlUpUqUuUyU|V@VBVGVLVOVQV`VlVnVpVqVtVzW@WAWCWFWWW[W^W_"},
  {0,NULL,"WaWeWhWjWnWwWyWzW}XDXOXVXZX_XaXcXdXjXpXrXtXuXwXyX{X}X~Y?Y@YAYBYCY"},
  {0,NULL,"EYHYKYLYOYPYSYZYaYfYgYhYiYjYlYoYrYsYvYwYzY}Z@ZDZFZJ_C?K?M?N?O?P?Q"},
  {0,NULL,"?Y?Z?a?b?c?h?l?q?w?x?z@?@@@Q@U@W@b@g@l@p@u@w@y@~A?APATAUAaAlAmAyA"},
  {0,NULL,"|B@BCBTBYBZBcBdBeBfBhBnBsBtBzCDCGCICKCMCSCVCYC\\CaCkClCnCvC{DDDFDJ"},
  {0,NULL,"DPDVD^DbDiDnDxDzD|D}EBEDEEEGEIEKENEUEVEWEYE[E]E_EaEfEjEpErEtEuEyF"},
  {0,NULL,"HFQFZF[F`FfFqFzF}GCGKGMGPG^G_G`GdGeGhGmGoGpG}H@HEHGHHHOHQHTHUHWHd"},
  {0,NULL,"HgHmHqHuHvIAIIIMIXIYIaIdIgIrIuIwIyI{I~J@JAJCJLJMJOJPJRJTJVJWJYJ]J"},
  {0,NULL,"dJmJsJwJ~KEKIKOKZK[K\\K]KfKiKkKmKsKvKxK|LBLDLILNLPLQLSL`LcLeLmLqL|"},
  {0,NULL,"M?MBMDMHM]M`MbMcMpMrMsMtMvMyMzM~N?NANCNKNLNMNQNSNTNUN\\N]N^NlNmNnN"},
  {0,NULL,"pNsNvNyOAOBOHOJOLONOWOXO_OcOkOnOpOrOwPBPEPNPQPSP\\PePoPuPxP~QCQEQG"},
  {0,NULL,"QKQLQMQUQVQZQ]Q`QbQeQfQmQnQqQrQuQxQ{Q|RERFRJRKRYR\\R]R^RnRoRpRqRrR"},
  {0,NULL,"uSGSHSISJSKSLSTS]S^S_ScSdTHTNTaTnTrT{U]U^UbUvVMVNVOVRVYV`VbVdVhVm"},
  {0,NULL,"VpVqVsVwVxV}W?WEWLWMWSWWWYW[W_W`WfWgWjWlWqWuWxW~X?XDXJXOXQXSXXX\\X"},
  {0,NULL,"`XcXdXeXhXmXqXvXwX{X}X~Y?YCYDYHYIYLYOYUYWYXYZY[Y\\Y_YcYhYlYqYuYwYz"},
  {0,NULL,"Y|Z?ZBZDZFZJZMZSZW_C?K?L?N?O?P?R?X?\\?`?a?e?f?n?p?u?v?x@E@F@R@T@V@"},
  {0,NULL,"[@e@m@o@t@v@wADAEAQASAVAZAjAoA{A~B?BKBVBWBXBcBdBeBgBiBlBvB|B}B~CA"},
  {0,NULL,"CECNCTCUC]C^CbCcChCmCnD@DADCDFDLDRDZD^DdDsDuDwDzD|D~EAECEDEEEJEME"},
  {0,NULL,"OEPEQEXEYEZE[E_E`EhEiEoEqErEvF@FGFOFUF]F_FjFrF{GGGHGIGJGRG^G_G`Ga"},
  {0,NULL,"GfGjGrGwGxG{G|G~HBHIHJHVHXH\\H]HaHhHlHsHuH}IAIRITIVIYIlImIoIqIuIwI"},
  {0,NULL,"xIzJ?J@JAJDJFJGJNJPJQJSJTJYJZJ\\JfJnJtKAKDKKKLKMKZK[K\\K`KcKdKhKnKt"},
  {0,NULL,"KuKyKzL?LKLLLMLRLWLXL]LdLeLvLwLzM?M@MOMQM]MhMjMkMmMrMsMtMvMxM{M|N"},
  {0,NULL,"@NBNENFNMNNNPNQNUNVNWNaNbNlNmNnNoNxN|N}OEOFOGOMOQOROSO^OaObOeOgOi"},
  {0,NULL,"OjOwO}O~PKPQPTPWPXPoPpPqP}Q@QDQHQIQNQOQPQQQWQXQaQgQhQiQjQkQoQpQvQ"},
  {0,NULL,"}Q~R?R@RARHRIRURYR\\R]RiRjRkRoRpRqRySDSESGSJSKSZS[S\\S]S^S_TGTTTkTl"},
  {0,NULL,"TqUDUZU[UaUtVJVKVQVUV^V_V`VaVgVkVsVtVuVzV{V}W?WDWJWOWVWWWXW^WaWbW"},
  {0,NULL,"cWdWlWnWoWuWxW|XBXGXNXOXPXVXWXZX[X^XeXjXkXmXqXsXyX{X}X~Y?YBYEYFYJ"},
  {0,NULL,"YKYMYPYVYWYXYYYZY^YaYbYoYpYqYrYyY}Z@ZDZEZHZJZLZSZU_C?K?L?M?N?O?R?"},
  {0,NULL,"U?Z?]?_?d?f?k?o?r?s?w?|@A@N@X@\\@]@e@j@n@q@s@u@{A@AMAWA[A\\AeAgAwBD"},
  {0,NULL,"BEBFBRBTBYBZB[BaBgBjBoBqByB|B~C@CHCPCRCTC[C]C`CeChCjCrCvCzD?DGDVD"},
  {0,NULL,"YD[D_DiDrDtDyDzD}D~E@EDEFEGEIEKEOEQEREWEXEZE\\E^E`EdEkElEnEpEzE{FI"},
  {0,NULL,"FKFLFRFaFgF~G?G@GAGKGMGPGTG[G\\GbGiGjGlGuGxG{HAHBHDHLHNHVHZH_HaHcH"},
  {0,NULL,"fHkHqHtH|ICIIILISI[I^IaInItIuI{I}I~J?J@JBJDJGJHJMJOJQJRJUJXJZJ`Je"},
  {0,NULL,"JxJyJzJ{KEKHKIKOKQKWK_KgKhKpKrKtK{K~L?LALGLKLRLUL[L]L_LbLmLpLuLxM"},
  {0,NULL,"BMCMNMPMZM^M`MiMqMrMsMwMyM{M}M~NANBNCNDNFNGNLNNNRNVNXN\\N]N^NcNdNo"},
  {0,NULL,"NuNzN{N~OEOIOMOPOQOTO]O`OaOfOgOhOvPAPEPHPIPSP[P`PaPjPtPxPzQ?QAQBQ"},
  {0,NULL,"DQFQIQPQQQXQ^Q_QcQdQiQjQkQpQsQtQyQzR?R@RARJRKRMRNROR^R_RbRcRnRrRu"},
  {0,NULL,"RwR}R~SHSISLSOSTSUSVScSdT@TITXT[TtTuUGUKUcUeU~V@VPVVVZV[VdVfVqVrV"},
  {0,NULL,"uVzV{V|V}V~W@WEWHWKWLWPWTW]W_WaWbWkWoWtWuWvW}W~XHXKXLXRXSXUXYX[X]"},
  {0,NULL,"XdXjXkXmXnXtXvXxX{X~Y@YCYEYGYHYKYLYNYSYUYVYYY]Y^Y_YeYfYjYvYwYxY}Z"},
  {0,NULL,"HZJZLZMZNZOZPZVZW_C?K?L?N?O?P?R?X?\\?`?a?e?f?n?p?u?v?x@E@F@R@T@V@["},
  {0,NULL,"@e@m@o@t@v@wADAEAQASAVAZAjAoA{A~B?BKBNBOBSBUB\\BbBfBoBrBtByB{CCCDC"},
  {0,NULL,"HCJCMCRCVCWC[C`CaCgCtCuC|DEDHDMDODUD`DeDgDhDvDyE?EBECEEEFEGEIELEN"},
  {0,NULL,"EOEPESEXEYE\\E]E`EhEiEoEqErEvF@FGFOFUF]F_FjFrF{GGGHGLGOGQGSGUG]GeG"},
  {0,NULL,"iGnGpGuGvG}HAHFHHHNHPHQHSHWHZH[HfHjHpHwI@IEIHINIWI]I_I`IpIsItIyIz"},
  {0,NULL,"I{I|JAJBJDJEJFJIJMJPJUJVJWJZJ\\JfJnJtKAKDKFKJKNKPKXKYK]KbKgKjKmKrK"},
  {0,NULL,"wK{K|K~LDLJLNLSLULVL\\LbLiLlLrL{L~MAMEMTMUM\\M_MlMoMqMtMuMzM|M}M~NB"},
  {0,NULL,"NENHNLNMNONRNSNTNVN[N_N`NeNfNgNqNsNuNvNzO?ONOPOUOVOXO]OcOfOlOoOrO"},
  {0,NULL,"vO{PCPDPMPPPRP]PfPlPnPvPwQ?QAQBQCQFQGQLQMQZQ^Q_Q`QcQdQeQfQqQsQtQu"},
  {0,NULL,"QyQzQ{Q|RLRVRWRXRZR[RaRlRmRsRtRvRzR{R|SFSMSNSSS`SaSbSeSfTBTCTbTcT"},
  {0,NULL,"|T}UOUPUiUkUwVDVOVWVXVYVcVeViVlVmVqVrVvV|V~WCWFWQWRWSWZW[W\\W_WeWf"},
  {0,NULL,"WkWmWpWtWvWyWzX@XCXDXIXJXTXXXYX]X_XdXfXgXnXrXuXxXzX}YAYDYFYGYHYJY"},
  {0,NULL,"LYNYTYVYXY[Y\\Y^Y`YcYdYkYsYtYuY{ZAZBZKZMZNZOZPZTZX_C?K?L?M?O?P?S?W"},
  {0,NULL,"?[?b?d?e?g?m?o?u?y?z@B@C@M@O@S@c@f@h@s@t@x@y@|AAALARAYAbAfAhAvA}B"},
  {0,NULL,"IBJBSBTBYBZB\\BbBiBkBlBmBuBwCACECFCLCOCQCXCZC^C_CbCfCrCtCxDDDJDOD["},
  {0,NULL,"D\\DbDgDjDtDxDyD}E?EAECEDEGEHELEMENEQERETEYE[E^EbEgEiEjEnEsE|E}FNF"},
  {0,NULL,"PFSF\\FbFhFxFyGEGFGKGMGOGPGUG]GcGfGgGqGrGsGyGzG~H?HIHMHXHYH\\H^H`He"},
  {0,NULL,"HjHmHtH~IEIKISIXI]IbIdInIrItIxIzI{I|I~J@JEJGJHJJJKJPJSJTJVJXJ^JaJ"},
  {0,NULL,"oJpJqJrKEKFKIKOKXKYKdKeKlKnKoKqKuKyK}LCLELHLMLOLTLWLYLaLfLiLxL|L~"},
  {0,NULL,"MHMPMRMVM\\MbMiMpMqMsMuMxMyM|M~NDNFNGNINJNMNONPNQNSN\\N]N^NeNfNgNrN"},
  {0,NULL,"tNwNxN|ODOGOOOROYOZO\\OdOeOiOqOsOuOyO{PIPNPPPaPbPePjPnP{P~Q@QHQJQN"},
  {0,NULL,"QOQRQSQTQWQYQ[Q\\QaQgQhQlQoQvQwQ}Q~RBRCRDRJRKRVRWRXR^RaRlRmRnRrRuR"},
  {0,NULL,"zR{SFSHSISLSTS`SaSbScSdTUTVTZTmUEUFUIU\\UjUuUxVLVRVXV[V]V^VaVgViVn"},
  {0,NULL,"VoVpVuVxV~WCWEWJWMWRWTWUWXW`WdWhWiWjWmWoWvWyW~X?X@XAXLXNXPXWX[X\\X"},
  {0,NULL,"aXbXcXfXnXrXvXwXxX~YAYBYCYFYHYKYMYQYRYSYXYZY[Y]Y`YfYhYnYoYrYtY~Z?"},
  {0,NULL,"Z@ZCZFZKZLZPZTZW_C?L?M?N?O?P?S?T?\\?^?_?c?g?i?q?r?t?v?}@D@Y@Z@a@d@"},
  {0,NULL,"f@k@o@p@q@rABACANAXA`AcAiAnAzBHBLBMBNBOBRBUB[BaBlBnBuBvBxBzCBCECG"},
  {0,NULL,"CLCNCSCZC\\C^CcCdClCyD?DBDEDIDMDYD]DaDeDkDrDyD{D|D}D~EBECEFEHEKEME"},
  {0,NULL,"PESETEWEZE[E]EbEeEkEmEoEtE~F?FJFMFTF^FcFiFvFwGBGDGLGQGSGTG[G\\GaGd"},
  {0,NULL,"GfGhGqGtGyG~H@HJHKHOHRHUHXH]HeHgHyH|I?I@IBICIUIWIZI[IcIpItIvIwIyI"},
  {0,NULL,"zI~J?JBJFJIJJJKJOJQJRJSJTJWJ[J_K?K@KBKCKHKJKNKPKQKWK`KaKdKfKlKsKu"},
  {0,NULL,"KvKzLCLFLILMLQLXLZLaLcLoLuLyL{MGMNMSMTMWMZMaMlMnMqMvMyMzM{M|M}NAN"},
  {0,NULL,"CNENHNINJNNNPNQNTNXN[N_N`NcNdNpNrNxNyN}OCOGOHOJOSOYO[O_OeOjOkOqOt"},
  {0,NULL,"PHPJPLPMP`PcPdPfPkPlPzP|Q@QEQHQKQNQOQUQVQWQ]QaQbQgQhQmQnQoQrQvQxQ"},
  {0,NULL,"}Q~RERFRLRMRNRORZR[R_RbRcRsRtRvRwR|R}R~SMSNSOSSSUSVSeSfTKTLT]T^Tw"},
  {0,NULL,"TxULUNUdUhV?VCVSVYVZV\\V_V`ViVjVoVpVtVuVwV|W@WFWGWHWIWSWVWWWiWjWmW"},
  {0,NULL,"nWoWqWsWtWzW}XBXEXJXKXMXOXZX[X]XbXcXfXhXlXtXuXxX|Y?YCYDYEYFYGYJYM"},
  {0,NULL,"YQYRYTYUYYYZY\\Y_YcYiYmYpYqYxY|Y~Z?ZEZIZKZLZNZVZX_C?K?M?N?O?P?Q?Y?"},
  {0,NULL,"Z?a?b?c?h?l?q?w?x?z@?@@@Q@U@W@b@g@l@p@u@w@y@~A?APATAUAaAlAmAyA|B@"},
  {0,NULL,"BCBNBOBQBUB_B`BgBmBpBqBwB}B~C?C@CFCOCUCXC]C_CiCjCmCsCuCwDBDIDKDND"},
  {0,NULL,"UDaDcDfDhDvD{E@EAEBECEDEFEJELENEOETEVEWEZE^E_EaEfEjEpErEtEuEyFHFQ"},
  {0,NULL,"FZF[F`FfFqFzF}GCGLGNGQGSGYGZGgGjGkGlGsGwGzG|H?HBHCHDHVHYH^HbHcHhH"},
  {0,NULL,"iHpHyHzIDIHIJIUI\\I_IcIhIsIvIxIyIzI}J@JBJCJEJKJNJOJQJVJXJYJZJ]JdJm"},
  {0,NULL,"JsJwJ~KJKNKPKTKUKVK^K_KcKeKhKoK}L?L@LALELLLRLTLYL^L_LdLhLlLnLyL}M"},
  {0,NULL,"AMGMKMWM[M_MdMnMoMsMwMxMzM|M}N@NANDNJNKNNNONSNUNVNZN[N_N`NjNkNoNt"},
  {0,NULL,"NwN{O@OFOIOKOOOQOZO^ObOdOgOhOmOsOzPCPFPJPOPRP^PcPiPmPvP|QDQIQJQPQ"},
  {0,NULL,"QQRQSQTQXQYQ[Q\\QiQjQkQlQpQwR?R@RARBRCRDRLRPRQRRRZR[R`RdReRsRtRvR|"},
  {0,NULL,"S?S@SASMSNSPSQSSSWSeSfTATFT`TjTzUCUXUYUrUsU}VIVQVWV[V]V_VfVjVkVnV"},
  {0,NULL,"oVrVvVyVzWAWFWQWTWUWVW]W^WaWcWhWiWkWpWrWsWwWzXAXBXIXLXUXVXYX^XaXb"},
  {0,NULL,"XgXiXjXlXpXuXzX|X~Y@YBYDYFYGYIYPYRYUYWYYY[Y]Y^Y`YbYeYfYkYnYpYyY{Y"},
  {0,NULL,"~ZCZGZHZIZOZRZX_C?K?L?M?O?P?S?W?[?b?d?e?g?m?o?u?y?z@B@C@M@O@S@c@f"},
  {0,NULL,"@h@s@t@x@y@|AAALARAYAbAfAhAvA}BIBJBQBVBWBXB_B`BhBjBnBoBxB{CBCCCGC"},
  {0,NULL,"HCICPCYC\\C`CdCeCgCpCsC}D@DLDNDTDWDdDfDmDoDwD{D~E@EAEBEEEGEHEKELEO"},
  {0,NULL,"ERESEUE[E\\E_EbEgEiEjEnEsE|E}FNFPFSF\\FbFhFxFyGEGFGIGJGNGRGYGZGbGhG"},
  {0,NULL,"iGmGtGvH@HAHEHKHLHPHRHSHUHZH_HdHiHoHsH{IDIGIOIRI\\IfIiIlIqIvIxIyI{"},
  {0,NULL,"I}J?JAJEJHJIJJJLJRJTJUJYJZJ^JaJoJpJqJrKKKLKMKTKUKVKaKbKfKgKiKpKvK"},
  {0,NULL,"~LBLFLGLJLQLULZL[L\\L`LgLhLkLvL}MJMLMOMYM[MeMhMmMnMtMwMxMzM{M~N?NC"},
  {0,NULL,"NGNHNINONQNRNUNVNWNZNaNbNjNkNyNzN~O?OAOCOHOLOPOTOUO[O_O`OfOlOnOtO"},
  {0,NULL,"xOzO}P@POPUPWPZPgPmPpPsQ?QAQBQEQFQKQUQVQ]Q^Q_QbQcQdQmQnQrQsQtQxQy"},
  {0,NULL,"QzRERFRHRIRPRQRRRUR`RdReRiRjRkRyS?S@SASDSESPSQSWSZS[S\\TOTPTYTdT~U"},
  {0,NULL,"?UJUQUlUmUyVEVUVbVcVdVeVfVhVjVlVtVwVyV{V|WAWDWLWOWYWZW\\W]WbWeWgWn"},
  {0,NULL,"WqWrWsWtWwW|XCXGXQXSXTXUXZX]X_X`XhXiXkXlXpXsXyX|X}Y@YBYDYEYHYNYOY"},
  {0,NULL,"QYSYTYWYZY^Y_Y`YaYdYeYlYsYwYzY|Y}ZAZEZGZIZNZRZU_C?K?L?M?N?P?Q?V?["},
  {0,NULL,"?]?^?`?h?j?p?s?t?y?{?~@P@^@_@`@g@i@n@r@v@x@z@}AOA]A^A_AdAkAxBABBB"},
  {0,NULL,"GBRBVBWBXB[BaBfBkBmBpBrBsC?CDCFCJCKCQCVCWC_CfCiCkCpCyCzDCDGDRDTD]"},
  {0,NULL,"D_DkDmDuDzD{D}D~E?EAEEEFEJEMENEPEREUEVE\\E]E^EaEcElEmEqEsEwExFVFWF"},
  {0,NULL,"XFYFdFeFsFtFuF|GIGJGRGTG[G\\GcGeGgGkGnGoG}H?HCHFHGHMHTHWHYH[H`HbHk"},
  {0,NULL,"HlHoI?IBIGILIVIZI^IfIoIuIvIxI|I~J?JAJBJCJFJHJLJNJSJUJVJWJXJbJcJuJ"},
  {0,NULL,"vJ|J}KHKKKLKMKQKWK]K^KeKjKkKqKwKxK|K}L@LHLOLPLSLTLVL^LkLoLpLzM@MC"},
  {0,NULL,"MJMSMYM^MaMkMnMrMtMuMxMyM{M}N?N@NDNENGNKNPNRNSNTNWNXNaNbNcNdNqNvN"},
  {0,NULL,"wO@OBODOKONOOOVOWO\\OcOdOmOoOpOuP@PAPKPLPTPZP[PdPkPsPtP}QCQGQJQLQM"},
  {0,NULL,"QRQSQTQYQZQ[Q\\Q`QeQfQlQqQuQwQ{Q|RBRCRDRHRIRMRNRORUR_RbRcRiRjRkRwR"},
  {0,NULL,"yR}R~SDSESOSUSVSZS[S\\T?TJTWT\\TsTvUHUMUfUgVAVBVPVTVXV\\V^VcVoVqVsVv"},
  {0,NULL,"VwVxVyVzW@WDWIWJWKWNWRWZW_W`WaWiWlWpWqWrW|W}X@XCXFXMXNXRX\\XbXdXeX"},
  {0,NULL,"gXhXiXjXsXtX{X|X}YAYBYCYEYGYIYJYMYNYOYPYSY[Y\\Y]YgYmYoYsYtYvY{Y|Y~"},
  {0,NULL,"ZDZFZGZHZMZUZV_C?L?M?N?O?P?S?T?\\?^?_?c?g?i?q?r?t?v?}@D@Y@Z@a@d@f@"},
  {0,NULL,"k@o@p@q@rABACANAXA`AcAiAnAzBHBLBMBPB]B^BcBdBeBjBkBpBwByB{C?CCCOCP"},
  {0,NULL,"CQCRCXC[CeCfCgCiCoCqC{DADPDSDXDZDlDnDpDsDwDxD|E?E@EDEEEFEIEJEKELE"},
  {0,NULL,"MERESETEVEXEbEeEkEmEoEtE~F?FJFMFTF^FcFiFvFwGBGDGVGWGXG^G_G`GbGcGk"},
  {0,NULL,"GsGuGvGzHCHLHMHNHPHSH^H_H`HbHfHnHrHvH}IFIMIPITIeIgIjImIqIrIwI|I}J"},
  {0,NULL,"@JAJBJCJDJEJHJIJKJMJNJRJSJ[J_K?K@KBKCKGKRKSKZK[K\\K^KbKoKpKqKrK{L@"},
  {0,NULL,"LELGLHLJLOLYL[L\\L^LbLjLqLsLwMDMIMMMQMXMcMfMjMmMpMsMtMuMvMwM}N@NBN"},
  {0,NULL,"CNGNHNJNKNLNONPNYNhNiNlNmNnNtNuN~O?O@ODOKOTOUOZO\\O]O`OlOmOsOuOvO|"},
  {0,NULL,"O~P?PBPVPXPYP\\PhPqPrPuQ?QAQBQFQJQRQSQTQYQ[Q\\Q^Q_QcQdQlQsQtQwQyQzR"},
  {0,NULL,"BRCRDRGRSRTRYR\\R]RfRgRhRoRpRqRxSBSCSGSJSKSRSXSYS]S^S_TDTETeTfU@UA"},
  {0,NULL,"URUSUnUoUzVFVOVPVQVTVVVWVgVhVlVnVxVyV{V~W?WBWKWNWPWQW[W^W`WbWdWeW"},
  {0,NULL,"gWhWrWvWxW{XDXFXHXIXRXVXWX\\X_X`XaXiXkXnXoXqXwXyX}X~Y?Y@YAYGYIYLYM"},
  {0,NULL,"YPYRYSYTYVY_Y`YbYgYjYkYuYvYzY}Z@ZAZCZFZGZPZQZS_C?K?L?M?N?P?Q?V?[?"},
  {0,NULL,"]?^?`?h?j?p?s?t?y?{?~@P@^@_@`@g@i@n@r@v@x@z@}AOA]A^A_AdAkAxBABBBG"},
  {0,NULL,"BPBSB\\B]B^BbBhBqBxBzB|B}C@CBCICSCTCUCYCdChCjClCmCoCxC|C~DHDQDSD\\D"},
  {0,NULL,"`DjDlDqDvDxD|D~E?E@ECEGEHEJEQESEUEWEXE]E^E_EaEcElEmEqEsEwExFVFWFX"},
  {0,NULL,"FYFdFeFsFtFuF|GOGUGVGWGXG]GdGlGmGtGwGxG{G|HDHEHKHOHRHaHcHdHgHhHnH"},
  {0,NULL,"wHxH~IFIKINIQI`IbIeIkIrIsIwIzI{I|I}J?JDJGJIJJJLJNJOJWJXJYJbJcJuJv"},
  {0,NULL,"J|J}KFKGKRKSKXKYK_KaKcKiKsKtLALBLFLILKLLLZL]L_L`LcLdLfLjLrLtMEMFM"},
  {0,NULL,"IMRMUMVMXMgMoMpMuMvMwM{M|M~N?N@NANBNDNFNHNINTNUNYNeNfNgNhNiNpN{OA"},
  {0,NULL,"OCOEOFOIOJOLOMO[O^OaObOhOkOnOtOyP?PDPGPYP]P_PbPrPwPyP{QDQEQIQKQPQ"},
  {0,NULL,"QQUQVQXQ]QbQiQjQkQmQnQpQrQxR?R@RARERFRGRSRTRVRWRXRaRfRgRhRlRmRxRz"},
  {0,NULL,"R{SBSCSFSRSXSYS`SaSbTMTST_TiTpTyUVUWU`UqU|VHVSVUVVVZVaVeVhVjVkVmV"},
  {0,NULL,"nVpVrV}WBWCWGWHWOWPWXW\\WcWfWgWhWjWkWsWuWyW{XEXGXHXKXPXTXXXYX^X`Xa"},
  {0,NULL,"XcXlXmXoXrXwXzY?Y@YAYEYFYHYKYOYPYQYTYUYVYWY\\Y]YaYdYiYjYrYxYyYzZ?Z"},
  {0,NULL,"BZCZIZJZOZQZT_C?K?L?M?N?O?R?U?Z?]?_?d?f?k?o?r?s?w?|@A@N@X@\\@]@e@j"},
  {0,NULL,"@n@q@s@u@{A@AMAWA[A\\AeAgAwBDBEBFBPBQB]B^B_B`BiBrBsBtBuBvCACJCKCLC"},
  {0,NULL,"MCNCWCZCaCbCcCkCqCwC}C~DKDQDWDXDcDoDpDqDvDwD|D}E?E@EAEBEHEIEPEQET"},
  {0,NULL,"EUEVEYEZE\\E`EdEkElEnEpEzE{FIFKFLFRFaFgF~G?G@GAGNGVGWGXGYGZGaGnGoG"},
  {0,NULL,"pGqGrGyHFHGHHHIHJHQHTH[H\\H]HeHrHxHzH{IJIOIPIQIhIiIjIkIqIsIwIxIyI|"},
  {0,NULL,"I}I~JCJFJGJJJKJLJMJPJQJUJ`JeJxJyJzJ{KGKRKSKTKUKVK`KjKkKlKmKnKwKxK"},
  {0,NULL,"yKzLCLDLNLPLVLWLXLaLgLnLsLtMFMKMLMMMdMeMfMgMmMoMuMvMwMxMyMzN?NENF"},
  {0,NULL,"NINJNKNLNMNNNRNYNZNhNiNjNkNqNrNsN|N}OBOROSOVOWOXOYOiOjOoOpOqOrOxO"},
  {0,NULL,"|PFPGPUPVP^P_PgPhPiPyQ@QCQGQHQLQMQNQOQWQZQ`QaQeQfQgQhQoQqQuQvQ{Q|"},
  {0,NULL,"Q}Q~RGRPRQRRRSRTR`RdReRfRgRhRxS?S@SASBSCSPSQSRSWSXSYTQTRTgThToUBU"},
  {0,NULL,"TUUU_UpU{VGVRVSVTV\\V]VbVgViVkVlVmVsVtVvWAWBWGWIWMWNWUWYWcWdWeWfWl"},
  {0,NULL,"WmWnWpWwW{X?XAXEXFXMXQXWXXXZX^X_XeXfXgXoXpXyXzY?Y@YAYBYCYDYIYJYKY"},
  {0,NULL,"LYNYOYQYRYXYYYgYhYiYlYmYnYyY{Z@ZAZBZDZEZKZQZR_K?L?M?N?O?P?T?U?V?W"},
  {0,NULL,"?X?Y?i?j?k?l?m?n@G@H@I@J@K@L@h@i@j@k@l@mAFAGAHAIAJAKApAqArAsAtAuC"},
  {0,NULL,"nCsCtCwCxCyCzC{C|C}D?DADFDGDHDKDNDODPDWDYDZD\\D]D^D_D`DcDfDgDjDkDn"},
  {0,NULL,"DoDrDsDvDwDxDyDzD{EHEKELEMEVEXEYEZE\\E]E^E_EcEdEeEfEgEhFAFBFCFDFEF"},
  {0,NULL,"FFkFlFmFnFoFpHiHjHkHuHvHwHzH{H|H}H~I?IAIBICIDIEIJIKILIMINIOITIYIZ"},
  {0,NULL,"I[I\\I]I^I`IbIgIhIiImIqIrIsItIuIvJCJDJEJJJPJQJRJSJUJWJXJYJgJhJiJjJ"},
  {0,NULL,"kJlLeLfLgLhLiLnLoLpLqLrLuLwL}L~M?MCMDMEMKMLMNMQMRMSMUMVMZM[M\\M]M^"},
  {0,NULL,"MaMcMdMeMjMmMnMoMpMqMrNBNCNDNINKNMNNNONPNRNTNUOwOxOyOzO{O~PAPBPDP"},
  {0,NULL,"FPHPLPOPPPQPUPXP[P\\P]P^P`PbPdPgPiPkPmPnPoPqPtPuPwPzP{RMRNRORPRQRR"},
  {0,NULL,"RVRWRXRYR\\R]R_R`RaRbRcRdReRlRmRoRpRqRwRzR{R}R~S?S@SASFSGSJSKSOSPS"},
  {0,NULL,"QSUSVSWS]S^S_S`SaSbSgShSiSmSnSoSpSqSrSsStSuVOVPVQVXVZV\\V]V`VaVbVe"},
  {0,NULL,"VfWBWDWEWFWHWIWKWRWUWWWXWYW[W\\W]W^WzW{W|W~X@XAXDXKXMXOXPXQXRXTXUX"},
  {0,NULL,"VXoXsXuXvXwXxXyXzX{X|YIYMYNYQYVYWYXYYY\\Y]Y_Y`YbYdYeYlYmYnYqYrYtYu"},
  {0,NULL,"YvYxZQZUZWZX_K?L?M?N?O?P?T?U?V?W?X?Y?i?j?k?l?m?n@G@H@I@J@K@L@h@i@"},
  {0,NULL,"j@k@l@mAFAGAHAIAJAKApAqArAsAtAuCoCpCqCrCuCvC~D@DBDCDDDEDIDJDLDMDQ"},
  {0,NULL,"DRDSDTDUDVDXD[DaDbDdDeDhDiDlDmDpDqDtDuDvDwDxDyDzD{EIEJENEOEPEQERE"},
  {0,NULL,"SETEUEWE[EcEdEeEfEgEhFAFBFCFDFEFFFkFlFmFnFoFpHlHmHnHoHpHqHrHsHtHx"},
  {0,NULL,"HyI@IFIGIHIIIPIQIRISIUIVIWIXI_IaIcIdIeIfIjIkIlInIoIpIqIrIsItIuIvJ"},
  {0,NULL,"FJGJHJIJKJLJMJNJOJTJVJZJgJhJiJjJkJlLjLkLlLmLsLtLvLxLyLzL{L|M@MAMB"},
  {0,NULL,"MFMGMHMIMJMMMOMPMTMWMXMYM_M`MbMfMgMhMiMkMlMmMnMoMpMqMrN?N@NANENFN"},
  {0,NULL,"GNHNJNLNQNSNVO|O}P?P@PCPEPGPIPJPKPMPNPRPSPTPVPWPYPZP_PaPcPePfPhPj"},
  {0,NULL,"PlPpPrPsPvPxPyP|P}P~RGRHRIRJRKRLRSRTRURZR[R^RfRgRhRiRjRkRnRrRsRtR"},
  {0,NULL,"uRvRxRyR|SBSCSDSESHSISLSMSNSRSSSTSXSYSZS[S\\ScSdSeSfSjSkSlSvSwSxSy"},
  {0,NULL,"SzS{S|S}S~VRVSVTVUVVVWVYV[V^V_VcVdW?W@WAWCWGWJWLWMWNWOWPWQWSWTWVW"},
  {0,NULL,"ZWwWxWyW}X?XBXCXEXFXGXHXIXJXLXNXSXpXqXrXtXwXxXyXzX{X|YJYKYLYOYPYR"},
  {0,NULL,"YSYTYUYZY[Y^YaYcYfYgYhYiYjYkYoYpYsYwZRZSZTZV_D?E?F?H?I?J?T?U?V?]?"},
  {0,NULL,"^?_?i?j?k?r?s?t@M@S@T@U@V@W@i@j@k@n@q@rALARASATAUAVAvA|A}A~B?B@BN"},
  {0,NULL,"BOBTBUBVBWBXBYBZBfBgBlBmBnBoB~CDCECFCGCHCVC\\C]C^C_C`CnCsCtDFDNDOD"},
  {0,NULL,"^DfDgDvDwDxD|E?E@EHEIEJEPEQERESETEUEVEWEXEcEdEeEkElEmFGFHFNFOFPFQ"},
  {0,NULL,"FqFrFxFyFzF{GIGJGKGLGMGPGQGRGSGeGfGgGhGiGjG}G~H?H@HAHBHUHVHWHXHYH"},
  {0,NULL,"ZHiHjHuIAIDIEIYI\\I]IqIrIsIwI|I}JCJDJFJGJHJIJJJKJLJMJNJOJmJnJqJrJs"},
  {0,NULL,"JtKEKIKJKKKLKMKNKOKPK]KdKeKfKgKhKuKvK|K}K~L?LMLQLRLSLTLULeLhLiL}L"},
  {0,NULL,"~M?M[M\\M]MmMoMpMuMvMwN?N@NANBNENFNGNHNINJNKNLNWN[N\\N]N^N_N`NaNbNo"},
  {0,NULL,"NvNwNxNyNzOGOHONOOOPOQO_OcOdOeOfOgOwOzO{POPPPQPmPnPoRMRNROR_RbRcR"},
  {0,NULL,"wR}R~SOSUSVSgShSiSmSnSoSpSqSrSsStSuT?T@TITJTKTLTWTXT[T\\T]T^TsTtTu"},
  {0,NULL,"TvTwTxUGUHUKULUMUNUcUdUeUfUgUhU~V?V@VAVBVCVRVSVTVUVVVWVgVhVkVlVmV"},
  {0,NULL,"nW?WAWBWCWGWMWNWOWPWQWcWdWeWfWgWhWwWxWyW{X?XEXFXGXHXIXWXXX^X_X`Xa"},
  {0,NULL,"XoXpXqXrXwXyXzY?Y@YAYIYJYKYLYOYPYQYRYSYTYUYVYaYgYhYiYjYkYyYzZ@ZAZ"},
  {0,NULL,"BZCZQZRZSZTZYZZZ[Z\\Z]Z^Z_Z`ZaZe_D?F?G?H?I?J?U?W?Y?Z?b?d?k?l?m?o?w"},
  {0,NULL,"?z@P@R@Z@[@`@d@h@j@l@s@u@yANAQAZA]A_AcAxA{BBBKBLBMBNBOBPBUBVBWBXB"},
  {0,NULL,"]B^BpBrBvBxB{B}C?CBCCCJCNCUCWCcCdCgCiCmCyC|DADHDZD]D`DkDsDxDyDzD}"},
  {0,NULL,"EDEGEIEKENEOEQERETEUEWEYE[E^EdEfEgEjEnEpFTFUFVFYF]F^FtFvFwF|GGGHG"},
  {0,NULL,"IGJGLGQGRGSGVGWGXGaGkGnGtGvGwG|HCHFHJHKHPHRHSH[H]HbHhHwH}I?IBINIT"},
  {0,NULL,"IZI`ImIrItIuI{I~J@JGJHJKJLJMJOJPJRJTJVJXJZJuJ}KAKBKCKDKGKJKKKLKMK"},
  {0,NULL,"NKPKRKSK^K`KaKbKcKjKwKzL@LFLJLLLVLXLZL\\L^LdLoLrLwMEMQMSMUMaMjMpMq"},
  {0,NULL,"MrMsMyM~N?NANCNDNFNGNJNLNMNQNSNVNWNYN[N_N`NaNbNhNiNqN}O?O@OCOFOKO"},
  {0,NULL,"SOUOVO[O^ObOjOlOmOoOtO~PDPLPXP]PdPkPqPwRPRQRRR`RdReS?S@SASPSQSWSg"},
  {0,NULL,"ShSiSmSnSoSpSqSrSsStSuTATFTOTPTQTRTYT`TdTgThTjToTzT~U?UBUCUJUQUTU"},
  {0,NULL,"UUXUYU_UlUmUpUrUsUyU{U}VEVGVIVRVVVYV[V^VdVpVqVuVxV}V~W?W@WCWEWJWL"},
  {0,NULL,"WMWPWSWTW_W`WjWoWuWvWxWyW}W~X?XHXJXLXNXSX[X\\XcXdXmXnXqXrXtXvXwXxX"},
  {0,NULL,"{X~YCYHYKYLYOYRYSYUYXYZY[Y]Y^Y_YcYfYhYjYoYwZ?ZFZJZLZMZPZSZTZVZWZZ"},
  {0,NULL,"Z\\Z^Z_Z`ZaZbZcZdZe_E?F?G?H?I?J?T?X?Y?\\?a?c?i?l?n?q?v?x@O@X@]@^@_@"},
  {0,NULL,"c@k@l@m@o@p@wAOAWAYA\\A^AbAwBABFBGBIBJBPBTBVBWBXBYBZB]B^BhBiBjBkBs"},
  {0,NULL,"B|CACICKCPCQCTCYCbCeCfChCkCxCzC}DGDWD\\D_DjDoDvDyD{EBECEFEIEJELENE"},
  {0,NULL,"OEPESETEWEZE[E]EeEfEhEoErEtFIFLFSFWFXF\\FsFuG@GAGEGFGIGJGKGMGPGRGV"},
  {0,NULL,"GWGXGbGcGmGoGrGxG{HEHGHIHLHMHTH\\H_H`HaHdHkH{H~IKILIOI^IbIiIsItIvI"},
  {0,NULL,"yIzJBJEJFJIJKJMJNJOJQJTJVJWJZJoJpJvJzJ{J|KEKGKIKKKLKMKOKRKSKiKkKn"},
  {0,NULL,"KpKqKtKxKyLBLGLHLKLOLPLWL[L]L`LfLgLpMCMLMRMVM^MeMnMoMqMzM|M}N@NAN"},
  {0,NULL,"ENHNJNLNNNONQNSNTNVNWNYN\\N]N^NaNbNhNiN|N~OAOBODOEOLOMOROTOWO\\O`Oa"},
  {0,NULL,"OiOnOpOuOxOyPAPUP[PbPgPtP{RYR\\R]RoRpRqSGSJSKS]S^S_SgShSiSmSnSoSpS"},
  {0,NULL,"qSrSsStSuTDTETGTHTNTTTaTeTfTkTlTnTqTrT{U@UAUDURUSUZU[U]U^UaUbUnUo"},
  {0,NULL,"UtUvUzVFVJVKVMVNVSVWVYV[V_VcViVjVoVrVvV|W@WAWCWFWGWQWSWTWVWZWiWkW"},
  {0,NULL,"mWpWsWtWwWyWzW}XBXCXEXIXJXLXYX]XbXfXgXlXpXrXtXuXxXzX|YDYFYGYJYLYP"},
  {0,NULL,"YRYTYUYYYZY[Y\\Y^Y`YcYfYiYkYpYsY{Y~ZIZKZNZOZRZTZVZXZYZZZ[Z]Z`ZaZbZ"},
  {0,NULL,"cZdZe_D?E?G?H?I?J?V?W?X?[?`?e?j?m?n?p?u?y@N@Q@Y@\\@a@b@h@i@m@t@v@x"},
  {0,NULL,"AMAPAXA[A`AaAyAzBCBDBEBHBQBRB[B_B`BaBcBdBeBgBjBnBpBsBvB~C?CGCKCNC"},
  {0,NULL,"PC\\C]CcCeCiCkCqCvDBDIDVDXDaDiDpDvDxDyE?ECEGEHELEMENEQESEXEYE\\E]E^"},
  {0,NULL,"E_EcEgEhEiEqEsFJFKFMFRFZF[F}F~G?GBGCGDGNGTGYGZG[G\\G^G_G`GaGbGhGjG"},
  {0,NULL,"kGoH@HBHCHGHJHLHTHUHVH]H_HbHqHrHyIIIPIUIaIcIjIrIsItIzI{I|JDJEJGJI"},
  {0,NULL,"JJJPJSJUJVJWJXJYJwJxJyJ~K?K@KHKQKTKUKVKWKZK[K\\K^K`KfKhKkKpKvKxKzL"},
  {0,NULL,"?L@LGLPLQLRLXL[L^LmLsLyMBMGMMMWM`MfMoMpMqMuM|M~NBNDNFNHNINMNONPNR"},
  {0,NULL,"NSNTNUNXNZNcNdNjNkNlNmNnNoNyN}N~O@OBOHOKOQOSOTOWO_O`OgOjOmOpO|PEP"},
  {0,NULL,"JPSPVPcPhPxP|RHRIRURiRjRkRySDSESZS[S\\SjSkSlSvSwSxSySzS{S|S}S~T?TG"},
  {0,NULL,"TJTOTPTTTWTYT\\TdTkTlTqTsTvT~U?UDUHUJUMUQUZU[UaUfUgUlUmUtUyVAVBVEV"},
  {0,NULL,"JVKVOVXVZV]VaVeViVmVnVpVrV~WBWCWEWFWHWRWUWXW[W\\WfWhWjWkWmWvWyWzW{"},
  {0,NULL,"W~X@XAXDXKXPXTXXXYXaXcXfXnXoXrXuXvXwXxXzYAYFYHYKYMYNYQYTYVYWYXY[Y"},
  {0,NULL,"\\Y]Y`YdYnYrYtYuYxZ?ZBZCZKZOZPZQZTZWZXZYZZZ[Z^Z_Z`ZaZbZdZf_D?E?F?H"},
  {0,NULL,"?I?J?T?U?V?]?^?_?i?j?k?r?s?t@M@S@T@U@V@W@i@j@k@n@q@rALARASATAUAVA"},
  {0,NULL,"vA|A}A~B?B@BQBSB\\B_B`BbBcBdBeBhBiBtBwB{B}CACCCICMCOCUCXCYCaCbCgCm"},
  {0,NULL,"CuD@DDDJDLDUDbDdDhDyDzD{D}D~EFEHEKEMEPEREVEWEXEZE\\E]E^EcEdEeEkElE"},
  {0,NULL,"mFGFHFNFOFPFQFqFrFxFyFzF{GNGOGUGYGZG]G^G_G`GmGpGrGsGvGwGzG|HEHHHI"},
  {0,NULL,"HPHQHSH\\H^HdHhHmHpHsIHIRIXI_IdIlItIuIvI~J?JBJCJDJFJHJJJOJQJRJSJUJ"},
  {0,NULL,"WJXJmJnJqJrJsJtKFKTKUKVKXKYKZK[K\\KbKcKiKmKnKoKyLBLDLELJLLLNLWLYL\\"},
  {0,NULL,"L`LdLlLvL|MAMHMOM_MbMhMnMqMrMyM{M}NANBNCNDNENGNINKNNNPNRNTNZNeNfN"},
  {0,NULL,"gNjNkNlNmNnNsNtN|O?OAOFOLOROUOXOZO^ObOiOlOnOrOsO}PCPNPRPWPePpPvP~"},
  {0,NULL,"RGRSRTRfRgRhRxSBSCSRSXSYSjSkSlSvSwSxSySzS{S|S}S~TDTETMTQTRTST_TeT"},
  {0,NULL,"fTgThTiToTpTyU@UAUBURUSUTUUUVUWU_U`UnUoUpUqUzU{U|VFVGVHVPVXVZV\\V`"},
  {0,NULL,"VfVoVqVuVwVzV|W@WDWEWFWHWIWKWRWWW]W_WaWiWoWqWtWzW|W}W~X@XKXMXOXRX"},
  {0,NULL,"UX[X]XbXdXhXjXsXtXuXvXxX{X|YCYEYGYIYJYMYNYQYSYUYVYYY\\Y]Y_YeYmYqYt"},
  {0,NULL,"YvYxY|Y~ZHZLZMZNZUZVZWZXZYZZZ\\Z]Z_Z`ZbZcZdZf_E?F?G?H?I?J?T?X?Y?\\?"},
  {0,NULL,"a?c?i?l?n?q?v?x@O@X@]@^@_@c@k@l@m@o@p@wAOAWAYA\\A^AbAwBABFBGBIBJBQ"},
  {0,NULL,"BRBSB[B\\B_B`BaBbBmBoBqBrBuBxC@CBCFCHCJCLCWCZC_C`CdCjCpCrC~DQDTD[D"},
  {0,NULL,"mDqDtDwDxDzD|EDEEEIEJEKELEMEVEXEYEZE[E]E_EeEfEhEoErEtFIFLFSFWFXF\\"},
  {0,NULL,"FsFuG@GAGEGFGNGOGTGUGYGZG[G\\G]GgGiGlGnGqGtGyH?HAHDHFHKHRHYHZH[HcH"},
  {0,NULL,"eHoHtHxIGIQISIfIkInIqIrIuIwJ@JAJCJDJEJMJNJPJQJRJSJTJWJYJoJpJvJzJ{"},
  {0,NULL,"J|KFKHKQKTKUKVKWKXKYK_KaKeKgKjKlKwK}K~LALCLFLTLULVLZL_LaLkLtLxMFM"},
  {0,NULL,"JMPMYMgMiMmMpMrMsMtMvN@NBNCNKNLNMNNNONPNQNTNUNXNZNcNdNeNfNgNjNkNq"},
  {0,NULL,"NrNwNzN{OCOIOOOPOVOYO[OdOfOhOoOqOtP@PGPIPZP_PaPjPsPyRLRZR[RsRtRvR"},
  {0,NULL,"|SMSNSSSeSfSjSkSlSvSwSxSySzS{S|S}S~TATBTCTFTKTLT]T^T`TbTcTjTwTxTz"},
  {0,NULL,"T|T}UCULUNUOUPUXUYUdUhUiUkUrUsUwU}V?VCVDVIVOVPVQV`VaVbVgVhVsVxV{V"},
  {0,NULL,"}W?WBWDWEWKWWWXWYW[W^W`WbWdWgWlWuWxW{W|W~XDXOXPXQXRXVXWX\\X`XeXkXm"},
  {0,NULL,"XoXqXsXvXwXyX{X}X~Y?YIYLYMYPYVYWYXYYYZY\\Y_Y`YbYlYqYrYuYvYzY}Z@ZDZ"},
  {0,NULL,"FZJZQZSZUZWZ[Z\\Z]Z^Z_Z`ZaZcZdZf_D?E?G?H?I?J?V?W?X?[?`?e?j?m?n?p?u"},
  {0,NULL,"?y@N@Q@Y@\\@a@b@h@i@m@t@v@xAMAPAXA[A`AaAyAzBCBDBEBHBNBOBPBTBUBYBZB"},
  {0,NULL,"]B^BqBtBuBwByBzC@CLCMCOCRCSCXCZC[CaCjClCwC{D?DKDPDYDcDnDrDwDzD{D~"},
  {0,NULL,"EAEEEJEMENEOEPEQERESEUE[E\\E_EcEgEhEiEqEsFJFKFMFRFZF[F}F~G?GBGCGDG"},
  {0,NULL,"KGLGMGPGQGSGVGWGXGdGlGpGqGsGuGyGzHDHHHNHOHQH^HcHeHfHgHvHzH|ICIJIM"},
  {0,NULL,"I[IgIhIqIuIvIxJ?JAJFJGJHJIJLJNJSJTJUJVJYJZJwJxJyJ~K?K@KEKGKIKJKNK"},
  {0,NULL,"OKPKRKSK_KlKmKoKrKsK{LALCLDLELILNLYL_LaLbLcLnLqLuMDMKMNMZMcMdMmMn"},
  {0,NULL,"MrMtMxM{N?N@NENFNGNHNPNQNRNSNUNVNYN[N\\N]N^N_N`NhNiNpNrNsNtNuN{OIO"},
  {0,NULL,"JOXOYOZO]OhOkOqOrOsOvPBPFPHP\\P^P`PiPuPzRVRWRXRaRlRmRzR{SFS`SaSbSg"},
  {0,NULL,"ShSiSmSnSoSpSqSrSsStSuTBTCTMTSTUTVTZT_TbTcTiTmTpTyT|T}UEUFUIUOUPU"},
  {0,NULL,"VUWU\\U`UiUjUkUqUuUwUxU|VDVHVLVTVUV^V_VcVdVsVtVwVyVzV{W?W@WAWDWJWL"},
  {0,NULL,"WNWOWVWZWaWbWlWnWqWrWwWxW|W}XBXCXFXGXNXSXZXeXhXiXjXkXpXqXsXtXyX{X"},
  {0,NULL,"|X}YBYEYJYKYMYNYOYPYSYTYWYZY[Y^YaYgYoYpYsYwY|Y}ZDZEZGZHZRZSZUZVZY"},
  {0,NULL,"Z[Z\\Z]Z^Z_ZbZcZdZe_D?F?G?H?I?J?U?W?Y?Z?b?d?k?l?m?o?w?z@P@R@Z@[@`@"},
  {0,NULL,"d@h@j@l@s@u@yANAQAZA]A_AcAxA{BBBKBLBMBRBSB[B\\BaBbBcBdBeBfBkBlByBz"},
  {0,NULL,"B|CDCECQCRCSCTCVC[C^CfChClCoDCDEDMDRDSDeDlDuDvDwD{E@EAEBEHEKELEOE"},
  {0,NULL,"TEUEVEYEZE\\E^E_EdEfEgEjEnEpFTFUFVFYF]F^FtFvFwF|GGGHGOGTGUG[G\\G]G^"},
  {0,NULL,"G_G`GcGdGeGfGuGxG{G}G~HMHNHOHWHXH`HaHfHgHlHnI@IFIVIWIeIoIpIqIsIvI"},
  {0,NULL,"xIyI}JCJEJJJKJLJPJQJRJUJXJYJZJuJ}KAKBKCKDKFKHKQKWKXKYKZK[K\\K]KdKq"},
  {0,NULL,"KrKsKtKuK{K|LHLILKLMLOLSL]LbLcLjLzL{M@MIMTMXMkMlMmMnMoMwMxMzN?NCN"},
  {0,NULL,"DNINJNKNMNNNONRNUNVNXNcNdNeNfNgNlNmNnNpNuNvNxODOEOGOJOMONO\\O]OaOc"},
  {0,NULL,"OeOkOuOvP?PKPMPTPYPfPlPrP}RJRKR^RnRrRuSHSISLSTScSdSjSkSlSvSwSxSyS"},
  {0,NULL,"zS{S|S}S~T@THTITNTUTVTXTZT[TaTmTnTrTtTuT{UEUFUGUIUKU\\U]U^UbUcUeUj"},
  {0,NULL,"UuUvUxU~V@VLVMVNVQV\\V]VbVeVfVjVkVlVtVvVyWAWBWDWFWIWUWYW\\W]W^WcWeW"},
  {0,NULL,"nWpWrWsWwWzW{W|XAXMXQXTXUXVXZX^X_XgXiXlXoXpXsXuXyXzX|Y@YBYDYIYNYO"},
  {0,NULL,"YQYRYWYXYYY]Y^Y_Y`YbYdYeYlYmYnYyY{ZAZEZGZIZQZRZUZXZYZZZ[Z\\Z]Z^ZaZ"},
  {0,NULL,"bZcZf_D?E?F?G?I?J?R?S?\\?_?d?e?f?g?o?r?u?v?{?~@?@@@H@I@e@f@o@q@s@t"},
  {0,NULL,"@z@}@~A?AGAHAdAkAlAmAqArBmBsBzB}CFCKCSCUC_CkClCmCnCwCxCyC~DBDCDDD"},
  {0,NULL,"FDIDJDKDQDRD\\D]D^DaDbDcDjDkDqDuDwDyD~E?E@EBEDEEEFEGEIEKELEOERESEX"},
  {0,NULL,"E\\E`EbEiEkEnEoEuEwExEyFAFCF`FdFeFfFkFmGdGgGoGwG|H?HGHOHTHYHgHhHlH"},
  {0,NULL,"mHuHxHyHzH~I?IAIBIJIKIQIUIVIXIYIZIbIcIdIhIkIoIqItIyI{I|I}J?J@JAJB"},
  {0,NULL,"JDJEJHJIJMJRJUJZJ]JbJcJdJgJiKcKeKkKsKxK}LILLLPLTLcLdLeLfLnLoLtLyL"},
  {0,NULL,"zL|M?M@MFMGMHMKMRMSMVMWM]MaMbMdMgMkMmMqMsMtMuMwMzM{M}M~NBNCNGNHNL"},
  {0,NULL,"NONRNVNpNwOBOFOJOOOWO^ObOdOkOpOwOyPFPGPJPKPLPNPQPTP^P_PbPcPdPePiP"},
  {0,NULL,"kPoPyP{P|P}P~Q@QHQNQOQWQaQgQhQoQvQ}Q~TGTKTLTQTRTTTUTVTZT]T^TgThTk"},
  {0,NULL,"TlTmToTqTwTxUBUDUEUFUIULUNUTUUUZU[U\\U_UaUdUhUjUpUtUuUxU{V?VCVGVJV"},
  {0,NULL,"KVLVOVPVVVWVcVdVeVfVhVlVqVrVyV{V|V~WKWLWPWQWZW[W\\W]W_WbWeWgWkWrWt"},
  {0,NULL,"WvXCXDXHXIXRXSXTXUXYX]X_X`XdXiXkXnXxXyX}X~Y@YAYDYEYGYHYLYNYSYTYVY"},
  {0,NULL,"^Y_Y`YdYeYjYkYsYuYvYwYzY}ZAZGZMZNZOZPZYZZZ]Z^Z_ZaZcZdZeZf_D?E?F?G"},
  {0,NULL,"?H?J?Q?S?[?^?b?c?g?h?q?t?y?z?|@A@E@F@K@L@f@g@p@r@x@y@{A@ADAEAJAKA"},
  {0,NULL,"eAgAjAoAtAuBoBtBvB|CHCMCNCTC`CaCcChCnCvC|C}C~D?D@DEDFDHDLDMDQDVDW"},
  {0,NULL,"DYD^D`DdDeDiDoDqDrDxD{D}E?E@EAECEDEEEFEJELEMENERETEVE^EaEbEjEmEsE"},
  {0,NULL,"tEvEzE{F@FBFFF_FaFgFjFlFpGaGiGpGxG{HAHHHJHQHZH]HaHqHsHuHwHxH{H|I@"},
  {0,NULL,"IAICIIINIOIQIRIWIYI[I`IaIiIkIlIpIrIvIxIzI|I}I~J@JAJBJCJEJHJKJNJSJ"},
  {0,NULL,"VJXJ\\J`JeJfJhJlK`KgKmKtKzK~LDLKLNLULXL]LeLgLmLrLtLuLvL{M?MBMEMFML"},
  {0,NULL,"MNMOMTMUMZM]M`MeMgMhMlMnMpMsMtMuMwMxMyM|M}N@NDNGNJNKNONPNSNsNzN}O"},
  {0,NULL,"EOMOPOSOXOaOfOjOrOwOxO}PDPEPGPHPMPQPSPUPWP]P_P`PfPgPlPoPpPwPxPyPz"},
  {0,NULL,"QEQKQUQVQ]QbQmQnQrQxRERFTHTKTLTMTNTOTPTSTYT]T^T_TaTdTiTnTpTrTwTxT"},
  {0,NULL,"yT{T~U?UJULUNUQUVUWU]U^U`UbUdUhUlUmUqUvUyU|V?VCVEVHVMVNVPVQVTVWVX"},
  {0,NULL,"V[V]V^VgVnVoVvVxVyVzV~WJWKWNWQWRWTWUW^W`WaWdWhWiWpWrWvX@XAXFXIXLX"},
  {0,NULL,"NXRXVXWX\\XaXbXgXiXjXnXwX|X}X~Y@YAYBYCYFYGYIYMYPYRYSY[Y]Y`YbYfYgYk"},
  {0,NULL,"YnYoYtYvY{Y~Z@ZCZFZGZHZPZYZZZ[Z\\Z^Z`ZcZdZeZf_D?E?F?G?I?J?R?S?\\?_?"},
  {0,NULL,"d?e?f?g?o?r?u?v?{?~@?@@@H@I@e@f@o@q@s@t@z@}@~A?AGAHAdAkAlAmAqArBf"},
  {0,NULL,"BhBpBqC?C@CDCICVCYCiCjCoCpCsCuCvCzC{C|DGDHDNDPDSDTDUDVD_D`DfDhDiD"},
  {0,NULL,"lDmDnDwDyD|D}D~E?EAEBECEDEHEMEPEQETEYEZE[E`EbEiEkEnEoEuEwExEyFAFC"},
 