/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.util;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.codec.util.KNNVectorAsArraySerializer;
import org.opensearch.knn.index.codec.util.KNNVectorAsCollectionOfFloatsSerializer;
import org.opensearch.knn.index.codec.util.KNNVectorSerializer;
import org.opensearch.knn.index.codec.util.SerializationMode;

public class KNNVectorSerializerFactory {
    private static Map<SerializationMode, KNNVectorSerializer> VECTOR_SERIALIZER_BY_TYPE = ImmutableMap.of((Object)((Object)SerializationMode.ARRAY), (Object)new KNNVectorAsArraySerializer(), (Object)((Object)SerializationMode.COLLECTION_OF_FLOATS), (Object)new KNNVectorAsCollectionOfFloatsSerializer());
    private static final int ARRAY_HEADER_OFFSET = 27;
    private static final int BYTES_IN_FLOAT = 4;
    private static final int BITS_IN_ONE_BYTE = 8;
    private static final byte[] SERIALIZATION_PROTOCOL_HEADER_PREFIX = new byte[]{KNNVectorSerializerFactory.highByte((short)-21267), KNNVectorSerializerFactory.lowByte((short)-21267), KNNVectorSerializerFactory.highByte((short)5), KNNVectorSerializerFactory.lowByte((short)5), 117, 114};

    public static KNNVectorSerializer getSerializerBySerializationMode(SerializationMode serializationMode) {
        return VECTOR_SERIALIZER_BY_TYPE.getOrDefault((Object)serializationMode, new KNNVectorAsCollectionOfFloatsSerializer());
    }

    public static KNNVectorSerializer getDefaultSerializer() {
        return KNNVectorSerializerFactory.getSerializerBySerializationMode(SerializationMode.COLLECTION_OF_FLOATS);
    }

    public static KNNVectorSerializer getSerializerByBytesRef(BytesRef bytesRef) {
        SerializationMode serializationMode = KNNVectorSerializerFactory.getSerializerModeFromBytesRef(bytesRef);
        return KNNVectorSerializerFactory.getSerializerBySerializationMode(serializationMode);
    }

    public static SerializationMode getSerializerModeFromBytesRef(BytesRef bytesRef) {
        int numberOfAvailableBytes = bytesRef.length;
        if (numberOfAvailableBytes < 27) {
            return KNNVectorSerializerFactory.getSerializerOrThrowError(numberOfAvailableBytes, SerializationMode.COLLECTION_OF_FLOATS);
        }
        for (int i = 0; i < SERIALIZATION_PROTOCOL_HEADER_PREFIX.length; ++i) {
            if (bytesRef.bytes[i + bytesRef.offset] == SERIALIZATION_PROTOCOL_HEADER_PREFIX[i]) continue;
            return KNNVectorSerializerFactory.getSerializerOrThrowError(numberOfAvailableBytes, SerializationMode.COLLECTION_OF_FLOATS);
        }
        int numberOfAvailableBytesAfterHeader = numberOfAvailableBytes - 27;
        return KNNVectorSerializerFactory.getSerializerOrThrowError(numberOfAvailableBytesAfterHeader, SerializationMode.ARRAY);
    }

    private static SerializationMode getSerializerOrThrowError(int numberOfRemainingBytes, SerializationMode serializationMode) {
        if (numberOfRemainingBytes % 4 == 0) {
            return serializationMode;
        }
        throw new IllegalArgumentException(String.format("Byte stream cannot be deserialized to array of floats due to invalid length %d", numberOfRemainingBytes));
    }

    private static byte highByte(short shortValue) {
        return (byte)(shortValue >> 8);
    }

    private static byte lowByte(short shortValue) {
        return (byte)shortValue;
    }
}

