/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InvalidSignatureException;
import org.bouncycastle.crypto.OutputSigner;
import org.bouncycastle.crypto.OutputValidator;
import org.bouncycastle.crypto.OutputVerifier;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SignatureOperatorFactory;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;

abstract class GuardedSignatureOperatorFactory<T extends Parameters>
implements SignatureOperatorFactory<T> {
    GuardedSignatureOperatorFactory() {
        FipsStatus.isReady();
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved only mode");
        }
    }

    @Override
    public final OutputSigner<T> createSigner(AsymmetricPrivateKey asymmetricPrivateKey, T t) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", t.getAlgorithm());
        }
        return this.doCreateSigner(asymmetricPrivateKey, t);
    }

    @Override
    public final OutputVerifier<T> createVerifier(AsymmetricPublicKey asymmetricPublicKey, T t) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", t.getAlgorithm());
        }
        return this.doCreateVerifier(asymmetricPublicKey, t);
    }

    @Override
    public final OutputValidator<T> createValidator(AsymmetricPublicKey asymmetricPublicKey, T t, byte[] byArray) throws InvalidSignatureException {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", t.getAlgorithm());
        }
        return this.doCreateValidator(asymmetricPublicKey, t, byArray);
    }

    protected abstract OutputSigner<T> doCreateSigner(AsymmetricPrivateKey var1, T var2);

    protected abstract OutputVerifier<T> doCreateVerifier(AsymmetricPublicKey var1, T var2);

    protected abstract OutputValidator<T> doCreateValidator(AsymmetricPublicKey var1, T var2, byte[] var3) throws InvalidSignatureException;
}

