/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class AutoCompletion
extends KeyAdapter {
    private ArrayList<String> suggestions;
    private int counter;
    private JTextComponent textArea;
    private SuggestionProvider provider;
    private int wordBegin;
    private int wordEnd;
    private State state;
    private char[] delimiters;

    public AutoCompletion(JTextComponent textPane, SuggestionProvider provider, char ... delimiters) {
        this.textArea = textPane;
        textPane.addKeyListener(this);
        this.provider = provider;
        this.suggestions = new ArrayList();
        this.delimiters = delimiters;
        this.state = State.INIT;
    }

    private boolean isLimit(char c) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        for (char d : this.delimiters) {
            if (d != c) continue;
            return true;
        }
        return false;
    }

    private boolean isTrigger(KeyEvent e) {
        return e.getKeyCode() == 9 || e.getKeyCode() == 32 && e.isShiftDown() && e.isControlDown();
    }

    private String findPrefix() {
        char c;
        int pos;
        StringBuffer prefix = new StringBuffer();
        this.wordEnd = pos + 1;
        String text = this.textArea.getText();
        for (pos = this.textArea.getCaretPosition() - 1; pos >= 0 && !this.isLimit(c = text.charAt(pos)); --pos) {
            prefix.insert(0, c);
        }
        this.wordBegin = pos + 1;
        String pref = prefix.toString().trim();
        return pref;
    }

    private boolean tabPressed() {
        boolean act = false;
        if (this.state == State.INIT) {
            String prefix = this.findPrefix();
            if (prefix.length() > 0) {
                this.suggestions.clear();
                this.suggestions.addAll(this.provider.getSuggestions(prefix));
                if (this.suggestions.size() > 0) {
                    this.replaceBy(this.suggestions.get(0));
                    act = true;
                }
                if (this.suggestions.size() > 1) {
                    this.counter = 0;
                    this.state = State.CHOOSING;
                }
            }
        } else if (this.suggestions.size() > 0) {
            act = true;
            this.counter = (this.counter + 1) % this.suggestions.size();
            this.replaceBy(this.suggestions.get(this.counter));
        }
        return act;
    }

    private void replaceBy(final String suggestion) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AutoCompletion.this.textArea.setSelectionStart(AutoCompletion.this.wordBegin);
                AutoCompletion.this.textArea.setSelectionEnd(AutoCompletion.this.wordEnd);
                AutoCompletion.this.textArea.replaceSelection(suggestion);
                AutoCompletion.this.wordEnd = AutoCompletion.this.wordBegin + suggestion.length();
            }
        });
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.isTrigger(e)) {
            String text = this.textArea.getText();
            int i = this.textArea.getCaretPosition();
            if (text.length() > 0 && !Character.isWhitespace(text.charAt(i - 1)) && (i == text.length() || this.isLimit(text.charAt(i))) && this.tabPressed()) {
                e.consume();
            }
        } else {
            this.state = State.INIT;
        }
    }

    public static interface SuggestionProvider {
        public List<String> getSuggestions(String var1);
    }

    private static enum State {
        INIT,
        CHOOSING;

    }
}

