/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.slides;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.core.windows.view.ui.slides.ResizeGestureRecognizer;
import org.netbeans.core.windows.view.ui.slides.SlideBar;
import org.netbeans.core.windows.view.ui.slides.SlideBarActionEvent;
import org.netbeans.core.windows.view.ui.slides.SlideOperation;
import org.netbeans.core.windows.view.ui.slides.SlideOperationFactory;
import org.netbeans.core.windows.view.ui.slides.TabbedSlideAdapter;
import org.netbeans.swing.tabcontrol.SlideBarDataModel;
import org.netbeans.swing.tabcontrol.SlidingButton;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.customtabs.Tabbed;
import org.netbeans.swing.tabcontrol.customtabs.TabbedComponentFactory;
import org.netbeans.swing.tabcontrol.customtabs.TabbedType;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

final class CommandManager
implements ActionListener {
    private final SlideBar slideBar;
    private Tabbed slidingTabbed;
    private Component curSlidedComp;
    private SlidingButton curSlideButton;
    private int curSlideOrientation;
    private int curSlidedIndex;
    private ResizeGestureRecognizer recog;
    private static final boolean NO_POPUP_PLACEMENT_HACK = Boolean.getBoolean("netbeans.popup.no_hack");
    private AWTEventListener awtListener = null;
    private final Action escapeAction = new EscapeAction();

    public CommandManager(SlideBar slideBar) {
        this.slideBar = slideBar;
        this.recog = new ResizeGestureRecognizer(this);
    }

    ResizeGestureRecognizer getResizer() {
        return this.recog;
    }

    public void slideResize(int n) {
        if (!this.isCompSlided()) {
            return;
        }
        SlideOperation slideOperation = SlideOperationFactory.createSlideResize(this.getSlidingTabbed().getComponent(), this.curSlideOrientation);
        Rectangle rectangle = this.getSlidingTabbed().getComponent().getBounds(null);
        String string = CommandManager.orientation2Side(this.curSlideOrientation);
        if ("bottom".equals(string)) {
            rectangle.height -= n;
            rectangle.y += n;
        }
        if ("right".equals(string)) {
            rectangle.width -= n;
            rectangle.x += n;
        }
        if ("left".equals(string)) {
            rectangle.width += n;
        }
        if ("top".equals(string)) {
            rectangle.height += n;
        }
        slideOperation.setFinishBounds(rectangle);
        this.postEvent(new SlideBarActionEvent((Object)this.slideBar, "slideResize", slideOperation));
    }

    public void slideIn(int n) {
        SlideBarDataModel slideBarDataModel = this.slideBar.getModel();
        if (this.isCompSlided() && this.curSlidedComp != slideBarDataModel.getTab(n).getComponent()) {
            this.slideOut(false, false);
        }
        this.curSlidedIndex = n;
        this.curSlidedComp = slideBarDataModel.getTab(n).getComponent();
        this.curSlideOrientation = slideBarDataModel.getOrientation();
        this.curSlideButton = this.slideBar.getButton(n);
        Tabbed tabbed = this.updateSlidedTabContainer(n);
        SlideOperation slideOperation = SlideOperationFactory.createSlideIn(tabbed.getComponent(), this.curSlideOrientation, true, true);
        boolean bl = false;
        for (AWTEventListener aWTEventListener : Toolkit.getDefaultToolkit().getAWTEventListeners()) {
            if (aWTEventListener != this.getAWTListener()) continue;
            bl = false;
            break;
        }
        if (!bl) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.getAWTListener(), 16L);
        }
        this.curSlideButton.setSelected(true);
        this.postEvent(new SlideBarActionEvent((Object)this.slideBar, "slideIn", slideOperation));
        this.recog.attachResizeRecognizer(CommandManager.orientation2Side(this.curSlideOrientation), tabbed.getComponent());
    }

    public void slideOut(boolean bl, boolean bl2) {
        if (!this.isCompSlided()) {
            return;
        }
        SlideOperation slideOperation = SlideOperationFactory.createSlideOut(this.getSlidingTabbed().getComponent(), this.curSlideOrientation, bl2, bl);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.getAWTListener());
        this.curSlideButton.setSelected(false);
        this.recog.detachResizeRecognizer(CommandManager.orientation2Side(this.curSlideOrientation), this.getSlidingTabbed().getComponent());
        this.curSlidedComp = null;
        this.curSlideButton = null;
        this.curSlideOrientation = -1;
        this.curSlidedIndex = -1;
        this.postEvent(new SlideBarActionEvent((Object)this.slideBar, "slideOut", slideOperation));
    }

    public void slideIntoDesktop(int n, boolean bl) {
        SlideOperation slideOperation = null;
        if (this.isCompSlided()) {
            slideOperation = SlideOperationFactory.createSlideIntoDesktop(this.getSlidingTabbed().getComponent(), this.curSlideOrientation, bl);
        }
        this.recog.detachResizeRecognizer(CommandManager.orientation2Side(this.curSlideOrientation), this.getSlidingTabbed().getComponent());
        this.postEvent(new SlideBarActionEvent((Object)this.slideBar, "disableAutoHide", slideOperation, null, n));
    }

    public void toggleTransparency(int n) {
    }

    public void showPopup(MouseEvent mouseEvent, int n) {
        this.postEvent(new SlideBarActionEvent((Object)this.slideBar, "popup", mouseEvent, n));
    }

    protected static String orientation2Side(int n) {
        String string = "left";
        if (n == 2) {
            string = "left";
        } else if (n == 1) {
            string = "right";
        } else if (n == 3) {
            string = "bottom";
        } else if (n == 4) {
            string = "top";
        }
        return string;
    }

    public void setActive(boolean bl) {
        this.getSlidingTabbed().setActive(bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("popup".equals(actionEvent.getActionCommand())) {
            TabActionEvent tabActionEvent = (TabActionEvent)actionEvent;
            if (this.curSlidedComp instanceof TopComponent) {
                TopComponent topComponent = (TopComponent)this.curSlidedComp;
                Action[] actionArray = this.slideBar.getTabbed().getPopupActions(topComponent.getActions(), this.curSlidedIndex);
                if (actionArray == null) {
                    actionArray = topComponent.getActions();
                }
                if (actionArray == null || actionArray.length == 0) {
                    return;
                }
                CommandManager.showPopupMenu(Utilities.actionsToPopup((Action[])actionArray, (Lookup)topComponent.getLookup()), tabActionEvent.getMouseEvent().getPoint(), tabActionEvent.getMouseEvent().getComponent());
            }
        } else if ("disableAutoHide".equals(actionEvent.getActionCommand())) {
            if (this.curSlidedIndex >= 0) {
                this.slideIntoDesktop(this.curSlidedIndex, true);
            }
        } else if ("enableAutoHide".equals(actionEvent.getActionCommand())) {
            this.slideBar.getSelectionModel().setSelectedIndex(-1);
        } else if ("toggleTransparency".equals(actionEvent.getActionCommand())) {
            TabActionEvent tabActionEvent = (TabActionEvent)actionEvent;
            this.toggleTransparency(tabActionEvent.getTabIndex());
        } else if ("maximize".equals(actionEvent.getActionCommand())) {
            this.postEvent(new SlideBarActionEvent((Object)this.slideBar, "slideMaximize", null, null, this.curSlidedIndex));
        } else {
            TabActionEvent tabActionEvent = (TabActionEvent)actionEvent;
            if ("close".equals(tabActionEvent.getActionCommand()) && this.curSlidedIndex < 0) {
                return;
            }
            TabActionEvent tabActionEvent2 = new TabActionEvent(tabActionEvent.getSource(), tabActionEvent.getActionCommand(), this.curSlidedIndex, tabActionEvent.getMouseEvent());
            this.postEvent((ActionEvent)tabActionEvent2);
        }
    }

    private Rectangle getScreenCompRect(Component component) {
        Rectangle rectangle = new Rectangle(component.getLocationOnScreen(), component.getSize());
        return rectangle;
    }

    private static void showPopupMenu(JPopupMenu jPopupMenu, Point point, Component component) {
        if (NO_POPUP_PLACEMENT_HACK) {
            jPopupMenu.show(component, point.x, point.y);
            return;
        }
        SwingUtilities.convertPointToScreen(point, component);
        Dimension dimension = jPopupMenu.getPreferredSize();
        Rectangle rectangle = Utilities.getUsableScreenBounds((GraphicsConfiguration)component.getGraphicsConfiguration());
        if (point.x + dimension.width > rectangle.x + rectangle.width) {
            point.x = rectangle.x + rectangle.width - dimension.width;
        }
        if (point.y + dimension.height > rectangle.y + rectangle.height) {
            point.y = rectangle.y + rectangle.height - dimension.height;
        }
        SwingUtilities.convertPointFromScreen(point, component);
        jPopupMenu.show(component, point.x, point.y);
    }

    private Tabbed getSlidingTabbed() {
        if (this.slidingTabbed == null) {
            TabbedComponentFactory tabbedComponentFactory = (TabbedComponentFactory)Lookup.getDefault().lookup(TabbedComponentFactory.class);
            this.slidingTabbed = tabbedComponentFactory.createTabbedComponent(TabbedType.VIEW, this.slideBar.createWinsysInfo());
            this.slidingTabbed.addActionListener((ActionListener)this);
            Border border = null;
            String string = CommandManager.orientation2Side(this.slideBar.getModel().getOrientation());
            border = UIManager.getBorder("floatingBorder-" + string);
            if (border == null) {
                border = UIManager.getBorder("floatingBorder");
            }
            if (border != null && this.slidingTabbed.getComponent() instanceof JComponent) {
                ((JComponent)this.slidingTabbed.getComponent()).setBorder(border);
            }
            if (this.slidingTabbed.getComponent() instanceof JComponent) {
                this.registerEscHandler((JComponent)this.slidingTabbed.getComponent());
            }
        }
        return this.slidingTabbed;
    }

    private Tabbed updateSlidedTabContainer(int n) {
        Tabbed tabbed = this.getSlidingTabbed();
        SlideBarDataModel slideBarDataModel = this.slideBar.getModel();
        TabData tabData = slideBarDataModel.getTab(n);
        TopComponent topComponent = (TopComponent)tabData.getComponent();
        tabbed.setTopComponents(new TopComponent[]{topComponent}, topComponent);
        return tabbed;
    }

    private void registerEscHandler(JComponent jComponent) {
        jComponent.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "slideOut");
        jComponent.getActionMap().put("slideOut", this.escapeAction);
    }

    private AWTEventListener getAWTListener() {
        if (null == this.awtListener) {
            this.awtListener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent aWTEvent) {
                    TopComponent topComponent;
                    if (aWTEvent.getID() == 500 && aWTEvent.getSource() instanceof Component && !SwingUtilities.isDescendingFrom((Component)aWTEvent.getSource(), CommandManager.this.getSlidingTabbed().getComponent()) && !SwingUtilities.isDescendingFrom((Component)aWTEvent.getSource(), CommandManager.this.slideBar) && null != (topComponent = CommandManager.this.slideBar.getTabbed().getSelectedTopComponent()) && TopComponent.getRegistry().getActivated() != topComponent) {
                        CommandManager.this.slideBar.getSelectionModel().setSelectedIndex(-1);
                    }
                }
            };
        }
        return this.awtListener;
    }

    boolean isCompSlided() {
        return this.curSlidedComp != null;
    }

    Component getSlidedComp() {
        if (!this.isCompSlided()) {
            return null;
        }
        return this.slidingTabbed.getComponent();
    }

    void syncWithModel() {
        if (this.curSlidedComp == null) {
            return;
        }
        if (!this.slideBar.containsComp(this.curSlidedComp)) {
            this.slideOut(false, false);
        } else {
            SlideBarDataModel slideBarDataModel = this.slideBar.getModel();
            if (this.curSlidedIndex < slideBarDataModel.size()) {
                String string = slideBarDataModel.getTab(this.curSlidedIndex).getText();
                this.getSlidingTabbed().setTitleAt(0, string);
                this.slideBar.repaint();
                this.curSlideButton = this.slideBar.getButton(this.curSlidedIndex);
                this.curSlideButton.setSelected(true);
            }
        }
    }

    private void postEvent(ActionEvent actionEvent) {
        ((TabbedSlideAdapter)this.slideBar.getTabbed()).postActionEvent(actionEvent);
    }

    private final class EscapeAction
    extends AbstractAction {
        private EscapeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CommandManager.this.slideBar.getSelectionModel().setSelectedIndex(-1);
        }
    }
}

