/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.BaseBuilders;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.Bundle;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.Utils;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public final class AwtDetailsProvider
extends DetailsProvider.Basic {
    private static final String FONT_MASK = "java.awt.Font+";
    private static final String COLOR_MASK = "java.awt.Color+";
    private static final String POINT_MASK = "java.awt.Point+";
    private static final String DIMENSION_MASK = "java.awt.Dimension+";
    private static final String RECTANGLE_MASK = "java.awt.Rectangle+";
    private static final String INSETS_MASK = "java.awt.Insets+";
    private static final String TEXTATTRIBUTE_MASK = "java.text.AttributedCharacterIterator$Attribute+";
    private static final String CURSOR_MASK = "java.awt.Cursor+";

    public AwtDetailsProvider() {
        super(FONT_MASK, COLOR_MASK, POINT_MASK, DIMENSION_MASK, RECTANGLE_MASK, INSETS_MASK, TEXTATTRIBUTE_MASK, CURSOR_MASK);
    }

    @Override
    public String getDetailsString(String className, Instance instance) {
        switch (className) {
            case "java.awt.Font+": {
                String name = Utils.getFontName(instance);
                if (name == null) {
                    name = "Default";
                }
                int size = DetailsUtils.getIntFieldValue(instance, "size", 10);
                name = name + ", " + size + "pt";
                int style = DetailsUtils.getIntFieldValue(instance, "style", 0);
                if ((style & 1) != 0) {
                    name = name + ", bold";
                }
                if ((style & 2) != 0) {
                    name = name + ", italic";
                }
                return name;
            }
            case "java.awt.Color+": {
                Color color = (Color)new BaseBuilders.ColorBuilder(instance).createInstance();
                return color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ", " + color.getAlpha();
            }
            case "java.awt.Point+": {
                Point point = (Point)new BaseBuilders.PointBuilder(instance).createInstance();
                return point.x + ", " + point.y;
            }
            case "java.awt.Dimension+": {
                Dimension dimension = (Dimension)new BaseBuilders.DimensionBuilder(instance).createInstance();
                return dimension.width + ", " + dimension.height;
            }
            case "java.awt.Rectangle+": {
                Rectangle rectangle = (Rectangle)new BaseBuilders.RectangleBuilder(instance).createInstance();
                return rectangle.x + ", " + rectangle.y + ", " + rectangle.width + ", " + rectangle.height;
            }
            case "java.awt.Insets+": {
                Insets insets = (Insets)new BaseBuilders.InsetsBuilder(instance).createInstance();
                return insets.top + ", " + insets.left + ", " + insets.bottom + ", " + insets.right;
            }
            case "java.text.AttributedCharacterIterator$Attribute+": 
            case "java.awt.Cursor+": {
                return DetailsUtils.getInstanceFieldString(instance, "name");
            }
        }
        return null;
    }

    @Override
    public DetailsProvider.View getDetailsView(String className, Instance instance) {
        if (FONT_MASK.equals(className)) {
            return new FontView(instance);
        }
        if (COLOR_MASK.equals(className)) {
            return new ColorView(instance);
        }
        return null;
    }

    private static class ColorView
    extends Utils.View<BaseBuilders.ColorBuilder> {
        ColorView(Instance instance) {
            super(0, true, true, instance);
        }

        @Override
        protected BaseBuilders.ColorBuilder getBuilder(Instance instance) {
            return new BaseBuilders.ColorBuilder(instance);
        }

        @Override
        protected Component getComponent(BaseBuilders.ColorBuilder builder) {
            final Color color = (Color)builder.createInstance();
            JPanel panel = new JPanel(null){

                @Override
                public void paint(Graphics g) {
                    g.setColor(color);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
            };
            panel.setOpaque(false);
            return panel;
        }
    }

    private static class FontView
    extends Utils.View<BaseBuilders.FontBuilder> {
        FontView(Instance instance) {
            super(0, false, true, instance);
        }

        @Override
        protected BaseBuilders.FontBuilder getBuilder(Instance instance) {
            return new BaseBuilders.FontBuilder(instance);
        }

        @Override
        protected Component getComponent(BaseBuilders.FontBuilder builder) {
            JLabel label = new JLabel();
            label.setHorizontalAlignment(0);
            label.setFont((Font)builder.createInstance());
            label.setText(Bundle.FontView_Preview());
            return label;
        }
    }
}

