/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.memorylint;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.profiler.heapwalk.memorylint.Utils;
import org.openide.util.NbBundle;

public final class Distribution {
    private Entry allEntry = new Entry(null);
    private HashMap<JavaClass, Entry> map = new HashMap();
    private Set<Instance> counted = new HashSet<Instance>();

    public Set<JavaClass> getClasses() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public boolean isCounted(Instance in) {
        return this.counted.contains(in);
    }

    public Entry getResults(JavaClass cls) {
        return this.map.get(cls);
    }

    public void add(Instance in) {
        if (!this.counted.add(in)) {
            return;
        }
        JavaClass cls = in.getJavaClass();
        Entry en = this.map.get(cls);
        if (en == null) {
            en = new Entry(cls);
            this.map.put(cls, en);
        }
        en.count(in);
        this.allEntry.count(in);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(NbBundle.getMessage(Distribution.class, (String)"FMT_DistEntry", (Object)this.allEntry.getCount(), (Object)this.allEntry.getSize()));
        for (JavaClass key : this.getClasses()) {
            result.append("  ").append(this.getResults(key)).append("\n");
        }
        return result.toString();
    }

    public static class Entry {
        private JavaClass type;
        private int count;
        private int size;

        private Entry(JavaClass cls) {
            this.type = cls;
        }

        public final int getCount() {
            return this.count;
        }

        public final int getSize() {
            return this.size;
        }

        public String toString() {
            return Utils.printClass(null, this.type.getName()) + ": " + this.getCount() + "/" + this.getSize() + "B";
        }

        private void count(Instance in) {
            assert (this.type == null || this.type.equals(in.getJavaClass()));
            ++this.count;
            this.size = (int)((long)this.size + in.getSize());
        }
    }
}

