/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.server;

import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import org.graalvm.visualvm.lib.jfluid.global.CalibrationDataFileIO;
import org.graalvm.visualvm.lib.jfluid.global.Platform;
import org.graalvm.visualvm.lib.jfluid.global.ProfilingSessionStatus;
import org.graalvm.visualvm.lib.jfluid.server.ProfilerInterface;
import org.graalvm.visualvm.lib.jfluid.server.ProfilerRuntime;
import org.graalvm.visualvm.lib.jfluid.server.ProfilerRuntimeCPU;
import org.graalvm.visualvm.lib.jfluid.server.ProfilerRuntimeCPUCodeRegion;
import org.graalvm.visualvm.lib.jfluid.server.ProfilerRuntimeCPUFullInstr;
import org.graalvm.visualvm.lib.jfluid.server.ProfilerRuntimeCPUSampledInstr;
import org.graalvm.visualvm.lib.jfluid.server.ProfilerServer;
import org.graalvm.visualvm.lib.jfluid.server.ThreadInfo;
import org.graalvm.visualvm.lib.jfluid.server.system.Timers;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.InternalStatsResponse;

class ProfilerCalibrator
extends ProfilerRuntime {
    private static String CANNOT_SAVE_CALIBRATION_DATA_MSG = "Performed calibration successfully, but could not save calibration data:\n{0}";
    private static String CALIBRATION_SUCCESS_MSG = "Calibration performed successfully";
    private static String CALIBRATION_RESULTS_PREFIX = "For your reference, obtained results are as follows:";
    private static String CALIBRATION_RESULTS_MSG = "Approximate time in one methodEntry()/methodExit() call pair:\nWhen getting absolute timestamp only: {0} microseconds\nWhen getting thread CPU timestamp only: {1} microseconds\nWhen getting both timestamps: {2} microseconds\n\nApproximate time in one methodEntry()/methodExit() call pair\nin sampled instrumentation mode: {3} microseconds\n";
    private static String STARTING_CALIBRATION_MSG = "Starting calibration...";
    private static String TIMER_COUNTS_MSG = "*** timerCountsInSecond = {0}";
    private static String TIMER_VALUE_MSG = "*** sample value returned by timer = {0}";
    private static String INJECTION_CALIBRATION_MSG = "----------- Injected profiler code calibration -----------";
    private static String TIME_getCurrentTimeInCounts_MSG = "Time per each getCurrentTimeInCounts() call";
    private static String TIME_getThreadCPUTimeInNanos_MSG = "Time per each getThreadCPUTimeInNanos() call";
    private static String TIME_COUNTS_MCS_MSG = "{0} counts, {1} mcs";
    private static String TIME_SUCCESS_PAIRS_MSG = "Time per each successful methodEntry()/methodExit() pair of calls ({0}, {1})";
    private static String MINIMUM_TIME_MSG = "Minimum time: {0} counts, or {1} mcs.";
    private static String INNER_OUTER_TIME_MSG = "Inner/outer time for a successful methodEntry()/methodExit() pair of calls";
    private static String INNER_TIME_MCS_MSG = "Inner time: {0} mcs.";
    private static String OUTER_TIME_MCS_MSG = "Outer time: {0} mcs.";
    private static String SAMPLED_TIME_MSG = "Time per each sampled instrumentation methodEntry()/methodExit() pair of calls";
    private static String REGION_TIME_MSG = "Time per each codeRegionEntry()/codeRegionExit() pair of calls";
    private static ProfilingSessionStatus status;
    private static boolean printResults;
    private static byte[] buf;
    private static double minTimePerMethodEntryExitCallInCounts;
    private static double minTimePerMethodEntryExitCallInMCS;
    private static double innerTimeInCounts;
    private static double outerTimeInCounts;
    private static long cntInSecond;
    private static int nCall;
    private static int cycleWhenMinResultDetected;

    ProfilerCalibrator() {
    }

    public static void init(ProfilingSessionStatus status) {
        ProfilerCalibrator.status = status;
    }

    public static void main(String[] args) {
        boolean inDevelMode;
        if (args.length > 0 && args[0].equals("-develmode")) {
            inDevelMode = true;
            System.out.println("Loader for this class is " + ProfilerCalibrator.class.getClassLoader());
        } else {
            inDevelMode = false;
            ProfilingSessionStatus localStatus = new ProfilingSessionStatus();
            localStatus.targetJDKVersionString = Platform.getJDKVersionString();
            localStatus.remoteProfiling = true;
            ProfilerCalibrator.init(localStatus);
        }
        if (Platform.getJDKVersionNumber() == 5) {
            System.loadLibrary("profilerinterface");
        }
        Timers.initialize();
        ProfilerCalibrator.measureBCIOverhead(inDevelMode);
        if (!inDevelMode) {
            if (!CalibrationDataFileIO.saveCalibrationData(status)) {
                System.err.println(MessageFormat.format(CANNOT_SAVE_CALIBRATION_DATA_MSG, CalibrationDataFileIO.getErrorMessage()));
                System.exit(-1);
            }
            System.out.println(CALIBRATION_SUCCESS_MSG);
            System.out.println(CALIBRATION_RESULTS_PREFIX);
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(4);
            long cntsInSec = ProfilerCalibrator.status.timerCountsInSecond[0];
            double m0 = ProfilerCalibrator.status.methodEntryExitCallTime[0] * 1000000.0 / (double)cntsInSec;
            double m1 = ProfilerCalibrator.status.methodEntryExitCallTime[1] * 1000000.0 / (double)cntsInSec;
            double m2 = ProfilerCalibrator.status.methodEntryExitCallTime[2] * 1000000.0 / (double)cntsInSec;
            double m4 = ProfilerCalibrator.status.methodEntryExitCallTime[4] * 1000000.0 / (double)cntsInSec;
            StringBuilder s = new StringBuilder();
            s.append(MessageFormat.format(CALIBRATION_RESULTS_MSG, nf.format(m0), nf.format(m1), nf.format(m2), nf.format(m4)));
            System.out.println(s.toString());
        }
    }

    public static void measureBCIOverhead(boolean printRes) {
        printResults = printRes;
        System.out.println(STARTING_CALIBRATION_MSG);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        cntInSecond = Timers.getNoOfCountsInSecond();
        ProfilerCalibrator.printResults(MessageFormat.format(TIMER_COUNTS_MSG, "" + cntInSecond));
        ProfilerCalibrator.printResults(MessageFormat.format(TIMER_VALUE_MSG, "" + Timers.getCurrentTimeInCounts()));
        if (status != null) {
            ProfilerCalibrator.status.timerCountsInSecond = new long[2];
            ProfilerCalibrator.status.timerCountsInSecond[0] = cntInSecond;
            ProfilerCalibrator.status.timerCountsInSecond[1] = 1000000000L;
        }
        ProfilerRuntime.resetProfilerCollectors(3);
        ProfilerRuntimeCPU.setNProfiledThreadsLimit(1);
        ProfilerRuntimeCPU.setInstrMethodsInvoked(new boolean[]{true, true, true, true});
        ProfilerRuntimeCPU.createThreadInfoForCurrentThread();
        ProfilerCalibrator.printResults(INJECTION_CALIBRATION_MSG + "\n");
        if (printResults) {
            ProfilerCalibrator.measureTimerCall(true);
            ProfilerCalibrator.measureTimerCall(false);
        }
        nCall = -1;
        ProfilerCalibrator.measureMethodEntryExitCalls();
        for (nCall = 0; nCall < 4; ++nCall) {
            ProfilerCalibrator.measureMethodEntryExitCalls();
            if (status == null) continue;
            ProfilerCalibrator.status.methodEntryExitCallTime[ProfilerCalibrator.nCall] = minTimePerMethodEntryExitCallInCounts;
            ProfilerCalibrator.status.methodEntryExitInnerTime[ProfilerCalibrator.nCall] = innerTimeInCounts;
            ProfilerCalibrator.status.methodEntryExitOuterTime[ProfilerCalibrator.nCall] = outerTimeInCounts;
        }
        nCall = -1;
        ProfilerCalibrator.measureSampledMethodEntryExitCalls();
        nCall = 0;
        ProfilerCalibrator.measureSampledMethodEntryExitCalls();
        if (status != null) {
            ProfilerCalibrator.status.methodEntryExitCallTime[4] = minTimePerMethodEntryExitCallInCounts;
            ProfilerCalibrator.status.methodEntryExitInnerTime[4] = innerTimeInCounts;
            ProfilerCalibrator.status.methodEntryExitOuterTime[4] = outerTimeInCounts;
        }
        ProfilerCalibrator.measureCodeRegionCalls();
        ProfilerCalibrator.printResults("----------------------------------------------------------\n");
        buf = null;
        ProfilerRuntimeCPUCodeRegion.setCPUResBufSize(0);
        ThreadInfo.setDefaultEvBufParams();
        ProfilerRuntime.resetProfilerCollectors(3);
        ProfilerRuntime.resetProfilerCollectors(4);
    }

    static InternalStatsResponse getInternalStats() {
        InternalStatsResponse r = new InternalStatsResponse();
        r.nTotalInstrMethods = ProfilerInterface.nTotalInstrMethods;
        r.nClassLoads = ProfilerInterface.nClassLoads;
        r.nFirstMethodInvocations = ProfilerInterface.nFirstMethodInvocations;
        r.nNonEmptyInstrMethodGroupResponses = ProfilerInterface.nNonEmptyInstrMethodGroupResponses;
        r.nEmptyInstrMethodGroupResponses = ProfilerInterface.nEmptyInstrMethodGroupResponses;
        r.nSingleMethodInstrMethodGroupResponses = ProfilerInterface.nSingleMethodInstrMethodGroupResponses;
        long cntsInSec = Timers.getNoOfCountsInSecond();
        r.clientInstrTime = (double)ProfilerInterface.clientInstrTime * 1000.0 / (double)cntsInSec;
        r.clientDataProcTime = (double)ProfilerInterface.clientDataProcTime * 1000.0 / (double)cntsInSec;
        if (r.nNonEmptyInstrMethodGroupResponses > 0) {
            r.totalHotswappingTime = (double)ProfilerInterface.totalHotswappingTime * 1000.0 / (double)cntsInSec;
            r.averageHotswappingTime = (double)ProfilerInterface.totalHotswappingTime * 1000.0 / (double)cntsInSec / (double)ProfilerInterface.nNonEmptyInstrMethodGroupResponses;
            r.minHotswappingTime = (double)ProfilerInterface.minHotswappingTime * 1000.0 / (double)cntsInSec;
            r.maxHotswappingTime = (double)ProfilerInterface.maxHotswappingTime * 1000.0 / (double)cntsInSec;
        }
        r.methodEntryExitCallTime0 = ProfilerCalibrator.status.methodEntryExitCallTime[0] * 1000000.0 / (double)cntsInSec;
        r.methodEntryExitCallTime1 = ProfilerCalibrator.status.methodEntryExitCallTime[1] * 1000000.0 / (double)cntsInSec;
        r.methodEntryExitCallTime2 = ProfilerCalibrator.status.methodEntryExitCallTime[2] * 1000000.0 / (double)cntsInSec;
        return r;
    }

    static void resetInternalStatsCollectors() {
        ProfilerInterface.totalHotswappingTime = 0L;
        ProfilerInterface.clientInstrTime = 0L;
        ProfilerInterface.clientDataProcTime = 0L;
    }

    private static void measureCodeRegionCalls() {
        ProfilerCalibrator.printResults("\n" + REGION_TIME_MSG);
        ProfilerRuntimeCPUCodeRegion.setCPUResBufSize(100);
        ProfilerRuntimeCPUCodeRegion.resetProfilerCollectors();
        int noOfInnerIterations = 50;
        for (int i = 0; i < 50; ++i) {
            long time = Timers.getCurrentTimeInCounts();
            for (int j = 0; j < noOfInnerIterations; ++j) {
                ProfilerRuntimeCPUCodeRegion.codeRegionEntry();
                ProfilerRuntimeCPUCodeRegion.codeRegionExit();
                ProfilerRuntimeCPUCodeRegion.codeRegionEntry();
                ProfilerRuntimeCPUCodeRegion.codeRegionExit();
            }
            time = Timers.getCurrentTimeInCounts() - time;
            if (!printResults || i % 5 != 0) continue;
            double timeInCounts = (double)time / (double)(noOfInnerIterations * 2);
            double timePerMethodInMCS = (double)time * 1000000.0 / (double)cntInSecond / (double)(noOfInnerIterations * 2);
            ProfilerCalibrator.printResults(MessageFormat.format(TIME_COUNTS_MCS_MSG, "" + timeInCounts, "" + timePerMethodInMCS));
        }
    }

    private static void measureMethodEntryExitCalls() {
        boolean absolute = false;
        boolean threadCPU = false;
        switch (nCall) {
            case -1: 
            case 0: {
                absolute = true;
                threadCPU = false;
                break;
            }
            case 1: {
                absolute = false;
                threadCPU = true;
                break;
            }
            case 2: 
            case 3: {
                absolute = true;
                threadCPU = true;
            }
        }
        ProfilerCalibrator.printResults("\n" + MessageFormat.format(TIME_SUCCESS_PAIRS_MSG, "" + absolute, "" + threadCPU));
        ProfilerRuntimeCPU.setTimerTypes(absolute, threadCPU);
        int noOfOuterIterations = 300;
        int noOfInnerIterations = 200;
        int innerIterationBufferSize = 17 * (noOfInnerIterations * 4 + 2) * 5 / 4;
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (nCall == -1) {
            buf = new byte[2 * innerIterationBufferSize];
        }
        ti.setEvBuf(buf);
        ProfilerRuntime.eventBuffer = buf;
        ProfilerRuntime.globalEvBufPosThreshold = buf.length;
        if (nCall != 3) {
            minTimePerMethodEntryExitCallInMCS = 100000.0;
            minTimePerMethodEntryExitCallInCounts = 1000000.0;
            cycleWhenMinResultDetected = 1;
            for (int i = 0; i < noOfOuterIterations; ++i) {
                ti.evBufPos = (cycleWhenMinResultDetected + 1) % 2 * innerIterationBufferSize;
                ProfilerRuntimeCPUFullInstr.rootMethodEntry('\u0001');
                long time = Timers.getCurrentTimeInCounts();
                for (int j = 0; j < noOfInnerIterations; ++j) {
                    ProfilerRuntimeCPUFullInstr.methodEntry('\u0002');
                    ProfilerRuntimeCPUFullInstr.methodExit('\u0002');
                    ProfilerRuntimeCPUFullInstr.methodEntry('\u0003');
                    ProfilerRuntimeCPUFullInstr.methodExit('\u0003');
                }
                time = Timers.getCurrentTimeInCounts() - time;
                ProfilerRuntimeCPUFullInstr.methodExit('\u0001');
                double timeInCounts = (double)time / (double)(noOfInnerIterations * 2);
                double timeInMCS = (double)time * 1000000.0 / (double)cntInSecond / (double)(noOfInnerIterations * 2);
                if (timeInCounts < minTimePerMethodEntryExitCallInCounts) {
                    minTimePerMethodEntryExitCallInCounts = timeInCounts;
                    minTimePerMethodEntryExitCallInMCS = timeInMCS;
                    cycleWhenMinResultDetected = (cycleWhenMinResultDetected + 1) % 2;
                }
                if (!printResults || i % 5 != 0) continue;
                ProfilerCalibrator.printResults(MessageFormat.format(TIME_COUNTS_MCS_MSG, "" + timeInCounts, "" + timeInMCS));
            }
            ProfilerCalibrator.printResults(MessageFormat.format(MINIMUM_TIME_MSG, "" + minTimePerMethodEntryExitCallInCounts, "" + minTimePerMethodEntryExitCallInMCS));
        }
        ProfilerCalibrator.printResults("\n" + INNER_OUTER_TIME_MSG);
        if (nCall != 1 && nCall != 3) {
            int recordSize = 10 + (nCall >= 2 ? 7 : 0);
            int curPos = cycleWhenMinResultDetected * innerIterationBufferSize + 1 * recordSize;
            int totalCalls = noOfInnerIterations * 4;
            long innerTime = 0L;
            long outerTime = 0L;
            long prevTimeStamp = 0L;
            boolean inner = false;
            int prefixEls = 3 + (nCall == 3 ? 7 : 0);
            int suffixEls = nCall == 2 ? 7 : 0;
            for (int i = 0; i < totalCalls; ++i) {
                long time;
                byte eventType = buf[curPos];
                if (inner && eventType != 7) {
                    System.out.println("Problem with inner! " + eventType + ", curPos = " + curPos);
                } else if (!inner && eventType != 6) {
                    System.out.println("Problem with outer! " + eventType + ", curPos = " + curPos);
                }
                curPos += prefixEls;
                long timeStamp = ((long)buf[curPos++] & 0xFFL) << 48 | ((long)buf[curPos++] & 0xFFL) << 40 | ((long)buf[curPos++] & 0xFFL) << 32 | ((long)buf[curPos++] & 0xFFL) << 24 | ((long)buf[curPos++] & 0xFFL) << 16 | ((long)buf[curPos++] & 0xFFL) << 8 | (long)buf[curPos++] & 0xFFL;
                long l = time = i > 0 ? timeStamp - prevTimeStamp : 0L;
                if (inner) {
                    innerTime += time;
                } else {
                    outerTime += time;
                }
                inner = !inner;
                prevTimeStamp = timeStamp;
                curPos += suffixEls;
            }
            innerTimeInCounts = (double)innerTime / ((double)totalCalls / 2.0);
            outerTimeInCounts = (double)outerTime / ((double)totalCalls / 2.0 - 1.0);
        } else {
            innerTimeInCounts = outerTimeInCounts = minTimePerMethodEntryExitCallInCounts / 2.0;
        }
        double innerTimeInMCS = innerTimeInCounts * 1000000.0 / (double)cntInSecond;
        double outerTimeInMCS = outerTimeInCounts * 1000000.0 / (double)cntInSecond;
        ProfilerCalibrator.printResults(MessageFormat.format(INNER_TIME_MCS_MSG, "" + innerTimeInMCS));
        ProfilerCalibrator.printResults(MessageFormat.format(OUTER_TIME_MCS_MSG, "" + outerTimeInMCS));
    }

    private static void measureSampledMethodEntryExitCalls() {
        ProfilerCalibrator.printResults("\n" + SAMPLED_TIME_MSG);
        int noOfOuterIterations = nCall == -1 ? 200 : 80;
        int noOfInnerIterations = 200;
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        ti.setEvBuf(buf);
        minTimePerMethodEntryExitCallInMCS = 100000.0;
        minTimePerMethodEntryExitCallInCounts = 1000000.0;
        for (int i = 0; i < noOfOuterIterations; ++i) {
            ti.evBufPos = 0;
            ProfilerRuntimeCPUSampledInstr.rootMethodEntry('\u0001');
            long time = Timers.getCurrentTimeInCounts();
            for (int j = 0; j < noOfInnerIterations; ++j) {
                ProfilerRuntimeCPUSampledInstr.methodEntry('\u0002');
                ProfilerRuntimeCPUSampledInstr.methodExit('\u0002');
                ProfilerRuntimeCPUSampledInstr.methodEntry('\u0003');
                ProfilerRuntimeCPUSampledInstr.methodExit('\u0003');
                ProfilerRuntimeCPUSampledInstr.methodEntry('\u0002');
                ProfilerRuntimeCPUSampledInstr.methodExit('\u0002');
                ProfilerRuntimeCPUSampledInstr.methodEntry('\u0003');
                ProfilerRuntimeCPUSampledInstr.methodExit('\u0003');
            }
            time = Timers.getCurrentTimeInCounts() - time;
            ProfilerRuntimeCPUSampledInstr.methodExit('\u0001');
            double timeInCounts = (double)time / (double)(noOfInnerIterations * 4);
            double timeInMCS = (double)time * 1000000.0 / (double)cntInSecond / (double)(noOfInnerIterations * 4);
            if (timeInCounts < minTimePerMethodEntryExitCallInCounts) {
                minTimePerMethodEntryExitCallInCounts = timeInCounts;
                minTimePerMethodEntryExitCallInMCS = timeInMCS;
            }
            if (!printResults || i % 5 != 0) continue;
            System.out.println(MessageFormat.format(TIME_COUNTS_MCS_MSG, "" + timeInCounts, "" + timeInMCS));
        }
        innerTimeInCounts = outerTimeInCounts = minTimePerMethodEntryExitCallInCounts / 2.0;
    }

    private static void measureTimerCall(boolean absolute) {
        if (absolute) {
            ProfilerCalibrator.printResults(TIME_getCurrentTimeInCounts_MSG);
        } else {
            ProfilerCalibrator.printResults(TIME_getThreadCPUTimeInNanos_MSG);
        }
        int noOfInnerIterations = 1000;
        for (int i = 0; i < 50; ++i) {
            long time = Timers.getCurrentTimeInCounts();
            for (int j = 0; j < noOfInnerIterations; ++j) {
                long res = absolute ? Timers.getCurrentTimeInCounts() : Timers.getThreadCPUTimeInNanos();
            }
            time = Timers.getCurrentTimeInCounts() - time;
            if (!printResults || i % 5 != 0) continue;
            double timeInCounts = (double)time / (double)(noOfInnerIterations + 2);
            double timePerMethodInMCS = (double)time * 1000000.0 / (double)cntInSecond / (double)(noOfInnerIterations + 2);
            ProfilerCalibrator.printResults(MessageFormat.format(TIME_COUNTS_MCS_MSG, "" + timeInCounts, "" + timePerMethodInMCS));
        }
    }

    private static void printResults(String str) {
        if (printResults) {
            System.out.println(str);
        }
    }

    static {
        ResourceBundle messages = ProfilerServer.getProfilerServerResourceBundle();
        if (messages != null) {
            CANNOT_SAVE_CALIBRATION_DATA_MSG = messages.getString("ProfilerCalibrator_CannotSaveCalibrationDataMsg");
            CALIBRATION_SUCCESS_MSG = messages.getString("ProfilerCalibrator_CalibrationSuccessMsg");
            CALIBRATION_RESULTS_PREFIX = messages.getString("ProfilerCalibrator_CalibrationResultsPrefix");
            CALIBRATION_RESULTS_MSG = messages.getString("ProfilerCalibrator_CalibrationResultsMsg");
            STARTING_CALIBRATION_MSG = messages.getString("ProfilerCalibrator_StartingCalibrationMsg");
            TIMER_COUNTS_MSG = messages.getString("ProfilerCalibrator_TimerCountsMsg");
            TIMER_VALUE_MSG = messages.getString("ProfilerCalibrator_TimerValueMsg");
            INJECTION_CALIBRATION_MSG = messages.getString("ProfilerCalibrator_InjectionCalibrationMsg");
            TIME_getCurrentTimeInCounts_MSG = messages.getString("ProfilerCalibrator_TimeGetCurrentTimeInCountsMsg");
            TIME_getThreadCPUTimeInNanos_MSG = messages.getString("ProfilerCalibrator_TimeGetThreadCPUTimeInNanosMsg");
            TIME_COUNTS_MCS_MSG = messages.getString("ProfilerCalibrator_TimeCountsMcsMsg");
            TIME_SUCCESS_PAIRS_MSG = messages.getString("ProfilerCalibrator_TimeSuccessPairsMsg");
            MINIMUM_TIME_MSG = messages.getString("ProfilerCalibrator_MinimumTimeMsg");
            INNER_OUTER_TIME_MSG = messages.getString("ProfilerCalibrator_InnerOuterTimeMsg");
            INNER_TIME_MCS_MSG = messages.getString("ProfilerCalibrator_InnerTimeMcsMsg");
            OUTER_TIME_MCS_MSG = messages.getString("ProfilerCalibrator_OuterTimeMcsMsg");
            SAMPLED_TIME_MSG = messages.getString("ProfilerCalibrator_SampledTimeMsg");
            REGION_TIME_MSG = messages.getString("ProfilerCalibrator_RegionTimeMsg");
        }
    }
}

