/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.server.system;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.management.openmbean.CompositeData;

public class ThreadDump {
    private static final String[][] methods = new String[][]{{"sun.management.ThreadInfoCompositeData", "toCompositeData"}, {"com.ibm.lang.management.ManagementUtils", "toThreadInfoCompositeData"}};
    private static Method toCompositeDataMethod;
    private static ThreadMXBean threadBean;
    private static boolean runningOnJdk15;

    public static void initialize(boolean jdk15) {
        runningOnJdk15 = jdk15;
        threadBean = ManagementFactory.getThreadMXBean();
        for (String[] method : methods) {
            String className = method[0];
            String methodName = method[1];
            try {
                Class<?> clazz = Class.forName(className);
                toCompositeDataMethod = clazz.getMethod(methodName, ThreadInfo.class);
                if (toCompositeDataMethod == null) continue;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public static Object[] takeThreadDump() {
        ThreadInfo[] threads = runningOnJdk15 ? ThreadDump.takeThreadDump15() : ThreadDump.takeThreadDump16();
        ArrayList<CompositeData> compositeData = new ArrayList<CompositeData>(threads.length);
        for (int i = 0; i < threads.length; ++i) {
            ThreadInfo ti = threads[i];
            if (ti == null) continue;
            compositeData.add(ThreadDump.toCompositeData(ti));
        }
        return compositeData.toArray(new CompositeData[0]);
    }

    public static boolean isJDK15() {
        return runningOnJdk15;
    }

    private static CompositeData toCompositeData(ThreadInfo tinfo) {
        try {
            return (CompositeData)toCompositeDataMethod.invoke(null, tinfo);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static ThreadInfo[] takeThreadDump15() {
        long[] tids = threadBean.getAllThreadIds();
        return threadBean.getThreadInfo(tids, Integer.MAX_VALUE);
    }

    private static ThreadInfo[] takeThreadDump16() {
        return threadBean.dumpAllThreads(true, true);
    }
}

