/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.watcher.macosx;

import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Exchanger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.providers.Notifier;

public final class OSXNotifier
extends Notifier<Void> {
    private static final Level DEBUG_LOG_LEVEL = Level.FINE;
    private static final Level PERF_LOG_LEVEL = Level.FINE;
    private static final long kFSEventStreamEventIdSinceNow = -1L;
    private static final int kFSEventStreamCreateFlagNoDefer = 2;
    private static final int kFSEventStreamEventFlagMustScanSubDirs = 1;
    private static final int kFSEventStreamEventFlagMount = 64;
    private static final int kFSEventStreamEventFlagUnmount = 128;
    private static final double LATENCY = 1.0;
    private static final int ENC_MAC_ROMAN = 0;
    private static final String DEFAULT_RUN_LOOP_MODE = "kCFRunLoopDefaultMode";
    private static final Logger LOG = Logger.getLogger(OSXNotifier.class.getName());
    private final CoreFoundation cf = (CoreFoundation)Native.load((String)"CoreFoundation", CoreFoundation.class);
    private final CoreServices cs = (CoreServices)Native.load((String)"CoreServices", CoreServices.class);
    private final EventCallback callback = new EventCallbackImpl();
    private final BlockingQueue<String> events = new LinkedBlockingQueue<String>();
    private ExecutorService worker;
    private Pointer[] rtData;
    private static final String ALL_CHANGE = "ALL-CHANGE";

    public Void addWatch(String string) throws IOException {
        return null;
    }

    public void removeWatch(Void void_) throws IOException {
    }

    public String nextEvent() throws IOException, InterruptedException {
        String string = this.events.take();
        return ALL_CHANGE.equals(string) ? null : string;
    }

    public synchronized void start() throws IOException {
        Object var2_2;
        if (this.worker != null) {
            throw new IllegalStateException("FileSystemWatcher already started.");
        }
        this.worker = Executors.newSingleThreadExecutor(new DaemonThreadFactory());
        final Exchanger<Object> exchanger = new Exchanger<Object>();
        this.worker.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Pointer[] pointerArray = null;
                    try {
                        pointerArray = OSXNotifier.this.createFSEventStream();
                    }
                    catch (Throwable throwable) {
                        exchanger.exchange(throwable);
                    }
                    finally {
                        if (pointerArray != null) {
                            exchanger.exchange(pointerArray);
                            OSXNotifier.this.cf.CFRunLoopRun();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    LOG.log(Level.WARNING, "Watcher interruped during start", interruptedException);
                }
            }
        });
        try {
            var2_2 = exchanger.exchange(null);
        }
        catch (InterruptedException interruptedException) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(interruptedException);
        }
        assert (var2_2 != null);
        if (var2_2 instanceof Throwable) {
            this.worker.shutdown();
            this.worker = null;
            throw new IOException(var2_2);
        }
        this.rtData = var2_2;
    }

    public synchronized void stop() throws IOException {
        if (this.worker == null) {
            throw new IllegalStateException("FileSystemWatcher is not started.");
        }
        assert (this.rtData != null);
        assert (this.rtData.length == 2);
        assert (this.rtData[0] != null);
        assert (this.rtData[1] != null);
        this.cs.FSEventStreamStop(this.rtData[0]);
        this.cs.FSEventStreamInvalidate(this.rtData[0]);
        this.cs.FSEventStreamRelease(this.rtData[0]);
        this.cf.CFRunLoopStop(this.rtData[1]);
        this.worker.shutdown();
        this.worker = null;
        this.rtData = null;
    }

    private Pointer[] createFSEventStream() throws IOException {
        Pointer pointer = this.cf.CFStringCreateWithCString(Pointer.NULL, "/", 0);
        if (pointer == Pointer.NULL) {
            throw new IOException("Path creation failed.");
        }
        Pointer pointer2 = this.cf.CFArrayCreateMutable(Pointer.NULL, new NativeLong(1L), Pointer.NULL);
        if (pointer2 == Pointer.NULL) {
            throw new IOException("Path list creation failed.");
        }
        this.cf.CFArrayAppendValue(pointer2, pointer);
        Pointer pointer3 = this.cs.FSEventStreamCreate(Pointer.NULL, this.callback, Pointer.NULL, pointer2, -1L, 1.0, 2);
        if (pointer3 == Pointer.NULL) {
            throw new IOException("Creation of FSEventStream failed.");
        }
        Pointer pointer4 = this.cf.CFRunLoopGetCurrent();
        if (pointer3 == Pointer.NULL) {
            throw new IOException("Cannot find run loop for caller.");
        }
        Pointer pointer5 = this.findDefaultMode(pointer4);
        if (pointer5 == null) {
            throw new IOException("Caller has no defaul run loop mode.");
        }
        this.cs.FSEventStreamScheduleWithRunLoop(pointer3, pointer4, pointer5);
        if (LOG.isLoggable(DEBUG_LOG_LEVEL)) {
            LOG.log(DEBUG_LOG_LEVEL, this.getStreamDescription(pointer3));
        }
        this.cs.FSEventStreamStart(pointer3);
        return new Pointer[]{pointer3, pointer4};
    }

    private Pointer findDefaultMode(Pointer pointer) {
        Pointer pointer2 = this.cf.CFRunLoopCopyAllModes(pointer);
        if (pointer2 != Pointer.NULL) {
            int n = this.cf.CFArrayGetCount(pointer2).intValue();
            for (int i = 0; i < n; ++i) {
                Pointer pointer3 = this.cf.CFArrayGetValueAtIndex(pointer2, new NativeLong((long)i));
                if (pointer3 == Pointer.NULL || !DEFAULT_RUN_LOOP_MODE.equals(this.cf.CFStringGetCStringPtr(pointer3, 0))) continue;
                return pointer3;
            }
        }
        return null;
    }

    private String getStreamDescription(Pointer pointer) {
        Pointer pointer2 = this.cs.FSEventStreamCopyDescription(pointer);
        return pointer2 == Pointer.NULL ? "" : this.cf.CFStringGetCStringPtr(pointer2, 0);
    }

    private class EventCallbackImpl
    implements EventCallback {
        private EventCallbackImpl() {
        }

        @Override
        public void invoke(Pointer pointer, Pointer pointer2, NativeLong nativeLong, Pointer pointer3, Pointer pointer4, Pointer pointer5) {
            int[] nArray;
            long l = System.currentTimeMillis();
            int n = nativeLong.intValue();
            Pointer[] pointerArray = pointer3.getPointerArray(0L, n);
            if (pointer4 == null) {
                nArray = new int[n];
                LOG.log(DEBUG_LOG_LEVEL, "FSEventStreamCallback eventFlags == null, expected int[] of size {0}", n);
            } else {
                nArray = pointer4.getIntArray(0L, n);
            }
            for (int i = 0; i < n; ++i) {
                Pointer pointer6 = pointerArray[i];
                int n2 = nArray[i];
                String string = pointer6.getString(0L);
                if ((n2 & 1) == 1 || (n2 & 0x40) == 64 || (n2 & 0x80) == 128) {
                    OSXNotifier.this.events.add(OSXNotifier.ALL_CHANGE);
                } else {
                    OSXNotifier.this.events.add(string);
                }
                LOG.log(DEBUG_LOG_LEVEL, "Event on {0}", new Object[]{string});
            }
            LOG.log(PERF_LOG_LEVEL, "Callback time: {0}", System.currentTimeMillis() - l);
        }
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    }

    public static interface CoreServices
    extends Library {
        public Pointer FSEventStreamCreate(Pointer var1, EventCallback var2, Pointer var3, Pointer var4, long var5, double var7, int var9);

        public Pointer FSEventStreamCopyDescription(Pointer var1);

        public void FSEventStreamScheduleWithRunLoop(Pointer var1, Pointer var2, Pointer var3);

        public void FSEventStreamUnscheduleFromRunLoop(Pointer var1, Pointer var2, Pointer var3);

        public void FSEventStreamStart(Pointer var1);

        public void FSEventStreamStop(Pointer var1);

        public void FSEventStreamInvalidate(Pointer var1);

        public void FSEventStreamRelease(Pointer var1);
    }

    public static interface CoreFoundation
    extends Library {
        public Pointer CFRunLoopGetCurrent();

        public void CFRunLoopRun();

        public void CFRunLoopStop(Pointer var1);

        public Pointer CFRunLoopCopyAllModes(Pointer var1);

        public Pointer CFArrayCreateMutable(Pointer var1, NativeLong var2, Pointer var3);

        public void CFArrayAppendValue(Pointer var1, Pointer var2);

        public Pointer CFArrayGetValueAtIndex(Pointer var1, NativeLong var2);

        public NativeLong CFArrayGetCount(Pointer var1);

        public Pointer CFStringCreateWithCString(Pointer var1, String var2, int var3);

        public String CFStringGetCStringPtr(Pointer var1, int var2);
    }

    public static interface EventCallback
    extends Callback {
        public void invoke(Pointer var1, Pointer var2, NativeLong var3, Pointer var4, Pointer var5, Pointer var6);
    }
}

