/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import com.sun.java.help.impl.ViewAwareComponent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.netbeans.modules.javahelp.CopyLinkLocationAction;
import org.netbeans.modules.javahelp.HyperlinkEventProcessor;
import org.netbeans.modules.javahelp.Utils;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbBundle;

public class BrowserDisplayer
extends JButton
implements ActionListener,
ViewAwareComponent,
CopyLinkLocationAction.LinkOwner {
    private View myView;
    private SimpleAttributeSet textAttribs;
    private HTMLDocument doc;
    private URL base;
    private static final Cursor handCursor = Cursor.getPredefinedCursor(12);
    private Cursor origCursor;
    private JPopupMenu popupMenu;
    private String content = "";

    public BrowserDisplayer() {
        this.setMargin(new Insets(0, 0, 0, 0));
        this.createLinkLabel();
        this.addActionListener(this);
        this.origCursor = this.getCursor();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowserDisplayer.class, (String)"ACSD_Label"));
        this.popupMenu = HyperlinkEventProcessor.getPopupMenu(new CopyLinkLocationAction(this));
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                BrowserDisplayer.this.setToolTipText(null);
                if (Utils.isMouseRightClick(mouseEvent)) {
                    Utils.showPopupMenu(mouseEvent, BrowserDisplayer.this.popupMenu, BrowserDisplayer.this);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                BrowserDisplayer.this.setCursor(handCursor);
                BrowserDisplayer.this.setToolTipText(BrowserDisplayer.this.getContent());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                BrowserDisplayer.this.setCursor(BrowserDisplayer.this.origCursor);
                BrowserDisplayer.this.setToolTipText(null);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
    }

    public void setViewData(View view) {
        this.myView = view;
        this.doc = (HTMLDocument)this.myView.getDocument();
        this.base = this.doc.getBase();
        Font font = this.getFont();
        this.textAttribs = new SimpleAttributeSet();
        this.textAttribs.removeAttribute(StyleConstants.FontSize);
        this.textAttribs.removeAttribute(StyleConstants.Bold);
        this.textAttribs.removeAttribute(StyleConstants.Italic);
        this.textAttribs.addAttribute(StyleConstants.FontFamily, font.getName());
        this.textAttribs.addAttribute(StyleConstants.FontSize, new Integer(font.getSize()));
        this.textAttribs.addAttribute(StyleConstants.Bold, font.isBold());
        this.textAttribs.addAttribute(StyleConstants.Italic, font.isItalic());
    }

    public void setContent(String string) {
        this.content = string;
    }

    public String getContent() {
        return this.content;
    }

    private void createLinkLabel() {
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setAlignmentY(this.getPreferredAlignmentY());
        this.setContentAreaFilled(false);
        this.setHorizontalAlignment(2);
        this.setBackground(UIManager.getColor("EditorPane.background"));
        if (this.textAttribs != null && this.textAttribs.isDefined(StyleConstants.Foreground)) {
            this.setForeground((Color)this.textAttribs.getAttribute(StyleConstants.Foreground));
        } else {
            this.setForeground(Color.blue);
        }
        this.invalidate();
    }

    private float getPreferredAlignmentY() {
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(font);
        float f = fontMetrics.getHeight();
        float f2 = fontMetrics.getDescent();
        return (f - f2) / f;
    }

    public void setTextFontFamily(String string) {
        this.textAttribs.removeAttribute(StyleConstants.FontFamily);
        this.textAttribs.addAttribute(StyleConstants.FontFamily, string);
        this.setFont(this.getAttributeSetFont(this.textAttribs));
        Font font = this.getFont();
    }

    public String getTextFontFamily() {
        return StyleConstants.getFontFamily(this.textAttribs);
    }

    public void setTextFontSize(String string) {
        Object object;
        int n;
        StyleSheet styleSheet = this.doc.getStyleSheet();
        try {
            if (string.equals("xx-small")) {
                n = (int)styleSheet.getPointSize(0);
            } else if (string.equals("x-small")) {
                n = (int)styleSheet.getPointSize(1);
            } else if (string.equals("small")) {
                n = (int)styleSheet.getPointSize(2);
            } else if (string.equals("medium")) {
                n = (int)styleSheet.getPointSize(3);
            } else if (string.equals("large")) {
                n = (int)styleSheet.getPointSize(4);
            } else if (string.equals("x-large")) {
                n = (int)styleSheet.getPointSize(5);
            } else if (string.equals("xx-large")) {
                n = (int)styleSheet.getPointSize(6);
            } else if (string.equals("bigger")) {
                n = (int)styleSheet.getPointSize("+1");
            } else if (string.equals("smaller")) {
                n = (int)styleSheet.getPointSize("-1");
            } else if (string.endsWith("pt")) {
                object = string.substring(0, string.length() - 2);
                n = Integer.parseInt((String)object);
            } else {
                n = (int)styleSheet.getPointSize(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        if (n == 0) {
            return;
        }
        this.textAttribs.removeAttribute(StyleConstants.FontSize);
        this.textAttribs.addAttribute(StyleConstants.FontSize, new Integer(n));
        this.setFont(this.getAttributeSetFont(this.textAttribs));
        object = this.getFont();
    }

    public String getTextFontSize() {
        return Integer.toString(StyleConstants.getFontSize(this.textAttribs));
    }

    public void setTextFontWeight(String string) {
        boolean bl = false;
        bl = "bold".equals(string);
        this.textAttribs.removeAttribute(StyleConstants.Bold);
        this.textAttribs.addAttribute(StyleConstants.Bold, bl);
        this.setFont(this.getAttributeSetFont(this.textAttribs));
        Font font = this.getFont();
    }

    public String getTextFontWeight() {
        if (StyleConstants.isBold(this.textAttribs)) {
            return "bold";
        }
        return "plain";
    }

    public void setTextFontStyle(String string) {
        boolean bl = false;
        bl = "italic".equals(string);
        this.textAttribs.removeAttribute(StyleConstants.Italic);
        this.textAttribs.addAttribute(StyleConstants.Italic, bl);
        this.setFont(this.getAttributeSetFont(this.textAttribs));
        Font font = this.getFont();
    }

    public String getTextFontStyle() {
        if (StyleConstants.isItalic(this.textAttribs)) {
            return "italic";
        }
        return "plain";
    }

    public void setTextColor(String string) {
        Color color = null;
        if ("black".equals(string)) {
            color = Color.black;
        } else if ("blue".equals(string)) {
            color = Color.blue;
        } else if ("cyan".equals(string)) {
            color = Color.cyan;
        } else if ("darkGray".equals(string)) {
            color = Color.darkGray;
        } else if ("gray".equals(string)) {
            color = Color.gray;
        } else if ("green".equals(string)) {
            color = Color.green;
        } else if ("lightGray".equals(string)) {
            color = Color.lightGray;
        } else if ("magenta".equals(string)) {
            color = Color.magenta;
        } else if ("orange".equals(string)) {
            color = Color.orange;
        } else if ("pink".equals(string)) {
            color = Color.pink;
        } else if ("red".equals(string)) {
            color = Color.red;
        } else if ("white".equals(string)) {
            color = Color.white;
        } else if ("yellow".equals(string)) {
            color = Color.yellow;
        }
        if (color == null) {
            return;
        }
        this.textAttribs.removeAttribute(StyleConstants.Foreground);
        this.textAttribs.addAttribute(StyleConstants.Foreground, color);
        this.setForeground(color);
    }

    public String getTextColor() {
        Color color = this.getForeground();
        return color.toString();
    }

    private Font getAttributeSetFont(AttributeSet attributeSet) {
        int n = 0;
        if (StyleConstants.isBold(attributeSet)) {
            n |= 1;
        }
        if (StyleConstants.isItalic(attributeSet)) {
            n |= 2;
        }
        String string = StyleConstants.getFontFamily(attributeSet);
        int n2 = StyleConstants.getFontSize(attributeSet);
        if (StyleConstants.isSuperscript(attributeSet) || StyleConstants.isSubscript(attributeSet)) {
            n2 -= 2;
        }
        return this.doc.getStyleSheet().getFont(string, n, n2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        URL uRL;
        try {
            uRL = new URL(this.content);
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
    }

    @Override
    public String getURLExternalForm() {
        return this.getContent();
    }

    @Override
    public Clipboard getClipboard() {
        return this.getToolkit().getSystemClipboard();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

