/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.graalvm.visualvm.lib.profiler.api.java.ProfilerTypeUtils;
import org.graalvm.visualvm.lib.profiler.api.java.SourceClassInfo;
import org.graalvm.visualvm.lib.profiler.utils.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class MainClassChooser
extends JPanel {
    public static Boolean unitTestingSupport_hasMainMethodResult = null;
    private JLabel jLabel1;
    private JList jMainClassList;
    private JScrollPane jScrollPane1;
    private ChangeListener changeListener;
    private Collection<String> possibleMainClasses;
    private String dialogSubtitle = null;

    public MainClassChooser(Lookup.Provider project) {
        this(project, null);
    }

    public MainClassChooser(Lookup.Provider project, String subtitle) {
        this.dialogSubtitle = subtitle;
        this.initComponents();
        this.initClassesView(project);
    }

    public String getSelectedMainClass() {
        if (this.isValidMainClassName(this.jMainClassList.getSelectedValue())) {
            return (String)this.jMainClassList.getSelectedValue();
        }
        return null;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListener = l;
    }

    public static boolean hasMainMethod(FileObject classFO) {
        return false;
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListener = null;
    }

    private boolean isValidMainClassName(Object value) {
        return this.possibleMainClasses != null && this.possibleMainClasses.contains(value);
    }

    private Object[] getWarmupList() {
        return new Object[]{Bundle.LBL_ChooseMainClass_WARMUP_MESSAGE()};
    }

    private void initClassesView(final Lookup.Provider project) {
        this.possibleMainClasses = new ArrayList<String>();
        this.jMainClassList.setSelectionMode(0);
        this.jMainClassList.setListData(this.getWarmupList());
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                for (SourceClassInfo sci : ProfilerTypeUtils.getMainClasses((Lookup.Provider)project)) {
                    MainClassChooser.this.possibleMainClasses.add(sci.getQualifiedName());
                }
                if (MainClassChooser.this.possibleMainClasses.isEmpty()) {
                    MainClassChooser.this.jMainClassList.setListData(new String[]{Bundle.LBL_ChooseMainClass_NO_CLASSES_NODE()});
                } else {
                    Object[] arr = MainClassChooser.this.possibleMainClasses.toArray();
                    Arrays.sort(arr);
                    MainClassChooser.this.jMainClassList.setListData(arr);
                    MainClassChooser.this.jMainClassList.setSelectedIndex(0);
                }
            }
        });
        this.jMainClassList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (MainClassChooser.this.changeListener != null) {
                    MainClassChooser.this.changeListener.stateChanged(new ChangeEvent(evt));
                }
            }
        });
        this.jMainClassList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isDoubleClick((MouseEvent)e) && MainClassChooser.this.getSelectedMainClass() != null && MainClassChooser.this.changeListener != null) {
                    MainClassChooser.this.changeListener.stateChanged(new ChangeEvent(e));
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        if (this.dialogSubtitle != null) {
            Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)this.dialogSubtitle);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jMainClassList = new JList();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(380, 300));
        this.getAccessibleContext().setAccessibleDescription(Bundle.AD_MainClassChooser());
        this.jLabel1.setLabelFor(this.jMainClassList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)Bundle.CTL_AvaialableMainClasses());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 2, 12);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(100, 200));
        this.jScrollPane1.setViewportView(this.jMainClassList);
        this.jMainClassList.getAccessibleContext().setAccessibleDescription(Bundle.AD_jMainClassList());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }
}

