/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.TreeSet;
import org.graalvm.visualvm.lib.jfluid.heap.AbstractLongMap;
import org.graalvm.visualvm.lib.jfluid.heap.CacheDirectory;
import org.graalvm.visualvm.lib.jfluid.heap.LongIterator;
import org.graalvm.visualvm.lib.jfluid.heap.NumberList;

class LongMap
extends AbstractLongMap {
    private NumberList referenceList;

    LongMap(int size, int idSize, int foffsetSize, CacheDirectory cacheDir) throws FileNotFoundException, IOException {
        super(size, idSize, foffsetSize, foffsetSize + 4 + 1 + idSize + foffsetSize, cacheDir);
        this.referenceList = cacheDir.createNumberList(this.ID_SIZE);
    }

    @Override
    Entry createEntry(long index) {
        return new Entry(index);
    }

    @Override
    Entry createEntry(long index, long value) {
        return new Entry(index, value);
    }

    @Override
    Entry get(long key) {
        return (Entry)super.get(key);
    }

    @Override
    Entry put(long key, long value) {
        return (Entry)super.put(key, value);
    }

    void flush() {
        this.referenceList.flush();
    }

    long[] getBiggestObjectsByRetainedSize(int number) {
        TreeSet<RetainedSizeEntry> bigObjects = new TreeSet<RetainedSizeEntry>();
        long[] bigIds = new long[number];
        long min = 0L;
        for (long index = 0L; index < this.fileSize; index += (long)this.ENTRY_SIZE) {
            long id = this.getID(index, 0);
            if (id == 0L) continue;
            long retainedSize = this.createEntry(index).getRetainedSize();
            if (bigObjects.size() < number) {
                bigObjects.add(new RetainedSizeEntry(id, retainedSize));
                min = ((RetainedSizeEntry)bigObjects.last()).retainedSize;
                continue;
            }
            if (retainedSize <= min) continue;
            bigObjects.remove(bigObjects.last());
            bigObjects.add(new RetainedSizeEntry(id, retainedSize));
            min = ((RetainedSizeEntry)bigObjects.last()).retainedSize;
        }
        int i = 0;
        for (RetainedSizeEntry rse : bigObjects) {
            bigIds[i++] = rse.instanceId;
        }
        return bigIds;
    }

    @Override
    void writeToStream(DataOutputStream out) throws IOException {
        super.writeToStream(out);
        this.referenceList.writeToStream(out);
    }

    LongMap(DataInputStream dis, CacheDirectory cacheDir) throws IOException {
        super(dis, cacheDir);
        this.referenceList = new NumberList(dis, cacheDir);
    }

    private static class RetainedSizeEntry
    implements Comparable<RetainedSizeEntry> {
        private final long instanceId;
        private final long retainedSize;

        private RetainedSizeEntry(long id, long size) {
            this.instanceId = id;
            this.retainedSize = size;
        }

        @Override
        public int compareTo(RetainedSizeEntry other) {
            int diff = Long.compare(other.retainedSize, this.retainedSize);
            if (diff == 0) {
                return Long.compare(this.instanceId, other.instanceId);
            }
            return diff;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RetainedSizeEntry other = (RetainedSizeEntry)obj;
            return this.instanceId == other.instanceId;
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + (int)(this.instanceId ^ this.instanceId >>> 32);
            return hash;
        }
    }

    class Entry
    extends AbstractLongMap.Entry {
        private static final byte NUMBER_LIST = 1;
        private static final byte GC_ROOT = 2;
        private static final byte TREE_OBJ = 4;
        private static final byte DEEP_OBJ = 8;
        private long offset;

        private Entry(long off) {
            this.offset = off;
        }

        private Entry(long off, long value) {
            this.offset = off;
            LongMap.this.putFoffset(this.offset, LongMap.this.KEY_SIZE, value);
        }

        void setIndex(int index) {
            LongMap.this.dumpBuffer.putInt(this.offset, LongMap.this.KEY_SIZE + LongMap.this.FOFFSET_SIZE, index);
        }

        int getIndex() {
            return LongMap.this.dumpBuffer.getInt(this.offset, LongMap.this.KEY_SIZE + LongMap.this.FOFFSET_SIZE);
        }

        void setTreeObj() {
            byte flags = (byte)(this.getFlags() | 4);
            this.setFlags(flags);
        }

        boolean isTreeObj() {
            return (this.getFlags() & 4) != 0;
        }

        void setDeepObj() {
            byte flags = (byte)(this.getFlags() | 8);
            this.setFlags(flags);
        }

        boolean isDeepObj() {
            return (this.getFlags() & 8) != 0;
        }

        boolean hasOnlyOneReference() {
            return (this.getFlags() & 1) == 0;
        }

        void setNearestGCRootPointer(long instanceId) {
            byte flags = (byte)(this.getFlags() | 2);
            this.setFlags(flags);
            if ((flags & 1) != 0) {
                try {
                    LongMap.this.referenceList.putFirst(this.getReferencesPointer(), instanceId);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }

        long getNearestGCRootPointer() {
            try {
                byte flag = this.getFlags();
                if ((flag & 2) != 0) {
                    long ref = this.getReferencesPointer();
                    if ((flag & 1) != 0) {
                        return LongMap.this.referenceList.getFirstNumber(ref);
                    }
                    return ref;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return 0L;
        }

        void addReference(long instanceId) {
            try {
                byte flags = this.getFlags();
                long ref = this.getReferencesPointer();
                if ((flags & 1) == 0) {
                    if (ref == 0L) {
                        this.setReferencesPointer(instanceId);
                    } else if (ref != instanceId) {
                        this.setFlags((byte)(flags | 1));
                        long list = LongMap.this.referenceList.addFirstNumber(ref, instanceId);
                        this.setReferencesPointer(list);
                    }
                } else {
                    long newRef = LongMap.this.referenceList.addNumber(ref, instanceId);
                    if (newRef != ref) {
                        this.setReferencesPointer(newRef);
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        LongIterator getReferences() {
            byte flags = this.getFlags();
            long ref = this.getReferencesPointer();
            if ((flags & 1) == 0) {
                if (ref == 0L) {
                    return LongIterator.EMPTY_ITERATOR;
                }
                return LongIterator.singleton(ref);
            }
            try {
                return LongMap.this.referenceList.getNumbersIterator(ref);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return LongIterator.EMPTY_ITERATOR;
            }
        }

        long getOffset() {
            return LongMap.this.getFoffset(this.offset, LongMap.this.KEY_SIZE);
        }

        void setRetainedSize(long size) {
            if (LongMap.this.FOFFSET_SIZE == 4) {
                LongMap.this.dumpBuffer.putInt(this.offset, LongMap.this.KEY_SIZE + LongMap.this.FOFFSET_SIZE + 4 + 1 + LongMap.this.ID_SIZE, (int)size);
            } else {
                LongMap.this.dumpBuffer.putLong(this.offset, LongMap.this.KEY_SIZE + LongMap.this.FOFFSET_SIZE + 4 + 1 + LongMap.this.ID_SIZE, size);
            }
        }

        long getRetainedSize() {
            if (LongMap.this.FOFFSET_SIZE == 4) {
                return LongMap.this.dumpBuffer.getInt(this.offset, LongMap.this.KEY_SIZE + LongMap.this.FOFFSET_SIZE + 4 + 1 + LongMap.this.ID_SIZE);
            }
            return LongMap.this.dumpBuffer.getLong(this.offset, LongMap.this.KEY_SIZE + LongMap.this.FOFFSET_SIZE + 4 + 1 + LongMap.this.ID_SIZE);
        }

        private void setReferencesPointer(long instanceId) {
            LongMap.this.putID(this.offset, LongMap.this.KEY_SIZE + LongMap.this.FOFFSET_SIZE + 4 + 1, instanceId);
        }

        private long getReferencesPointer() {
            return LongMap.this.getID(this.offset, LongMap.this.KEY_SIZE + LongMap.this.FOFFSET_SIZE + 4 + 1);
        }

        private void setFlags(byte flags) {
            LongMap.this.dumpBuffer.putByte(this.offset, LongMap.this.KEY_SIZE + LongMap.this.FOFFSET_SIZE + 4, flags);
        }

        private byte getFlags() {
            return LongMap.this.dumpBuffer.getByte(this.offset, LongMap.this.KEY_SIZE + LongMap.this.FOFFSET_SIZE + 4);
        }
    }
}

