import { Connection } from "vscode-languageserver";
import { AnsibleConfig } from "./ansibleConfig";
import { WorkspaceFolderContext } from "./workspaceManager";
import { IContainerEngine } from "../interfaces/extensionSettings";
import { IVolumeMounts } from "../interfaces/extensionSettings";
export declare class ExecutionEnvironment {
    isServiceInitialized: boolean;
    private settings;
    private connection;
    private context;
    private useProgressTracker;
    private successFileMarker;
    private settingsVolumeMounts;
    private settingsContainerOptions;
    private _container_engine;
    private _container_image;
    private _container_image_id;
    private _container_volume_mounts;
    constructor(connection: Connection, context: WorkspaceFolderContext);
    initialize(): Promise<void>;
    fetchPluginDocs(ansibleConfig: AnsibleConfig): Promise<void>;
    wrapContainerArgs(command: string, mountPaths?: Set<string>): string | undefined;
    private pullContainerImage;
    private setContainerEngine;
    private cleanUpContainer;
    private doesContainerNameExist;
    private updateContainerVolumeMountFromSettings;
    private isPluginInPath;
    private runContainer;
    private copyPluginDocFiles;
    private updateCachePaths;
    private isPluginDocCacheValid;
    get getBasicContainerAndImageDetails(): {
        containerEngine: IContainerEngine | undefined;
        containerImage: string | undefined;
        containerImageId: string | undefined;
        containerVolumeMounts: IVolumeMounts[] | undefined;
    };
}
