<?php
// phpcs:ignoreFile
/**
 * @file
 * A database agnostic dump for testing purposes.
 *
 * This file was generated by the Drupal 10.0.0-dev db-tools.php script.
 */

use Drupal\Core\Database\Database;

$connection = Database::getConnection();
// Ensure any tables with a serial column with a value of 0 are created as
// expected.
if ($connection->databaseType() === 'mysql') {
  $sql_mode = $connection->query("SELECT @@sql_mode;")->fetchField();
  $connection->query("SET sql_mode = '$sql_mode,NO_AUTO_VALUE_ON_ZERO'");
}

$connection->schema()->createTable('accesslog', array(
  'fields' => array(
    'aid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'sid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'path' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'url' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '128',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'timer' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('accesslog')
->fields(array(
  'aid',
  'sid',
  'title',
  'path',
  'url',
  'hostname',
  'uid',
  'timer',
  'timestamp',
))
->values(array(
  'aid' => '473',
  'sid' => '7PfrMmQ6Js0s34_qZRjuqkz0YPWgN9ORFqzS7w9V_FE',
  'title' => 'Configuration',
  'path' => 'admin/config',
  'url' => 'http://migrate-fixture-drupal7.ddev.site:7006/',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '96',
  'timestamp' => '1647480381',
))
->values(array(
  'aid' => '474',
  'sid' => '7PfrMmQ6Js0s34_qZRjuqkz0YPWgN9ORFqzS7w9V_FE',
  'title' => 'Performance',
  'path' => 'admin/config/development/performance',
  'url' => 'http://migrate-fixture-drupal7.ddev.site:7006/admin/config',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '67',
  'timestamp' => '1647480385',
))
->values(array(
  'aid' => '475',
  'sid' => '7PfrMmQ6Js0s34_qZRjuqkz0YPWgN9ORFqzS7w9V_FE',
  'title' => 'Performance',
  'path' => 'admin/config/development/performance',
  'url' => 'http://migrate-fixture-drupal7.ddev.site:7006/admin/config/development/performance',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '540',
  'timestamp' => '1647480386',
))
->values(array(
  'aid' => '476',
  'sid' => '7PfrMmQ6Js0s34_qZRjuqkz0YPWgN9ORFqzS7w9V_FE',
  'title' => 'Performance',
  'path' => 'admin/config/development/performance',
  'url' => 'http://migrate-fixture-drupal7.ddev.site:7006/admin/config/development/performance',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '90',
  'timestamp' => '1647480387',
))
->values(array(
  'aid' => '477',
  'sid' => '7PfrMmQ6Js0s34_qZRjuqkz0YPWgN9ORFqzS7w9V_FE',
  'title' => 'Performance',
  'path' => 'admin/config/development/performance',
  'url' => 'http://migrate-fixture-drupal7.ddev.site:7006/admin/config/development/performance',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '952',
  'timestamp' => '1647480388',
))
->values(array(
  'aid' => '478',
  'sid' => '7PfrMmQ6Js0s34_qZRjuqkz0YPWgN9ORFqzS7w9V_FE',
  'title' => 'Performance',
  'path' => 'admin/config/development/performance',
  'url' => 'http://migrate-fixture-drupal7.ddev.site:7006/admin/config/development/performance',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '231',
  'timestamp' => '1647480389',
))
->values(array(
  'aid' => '479',
  'sid' => '7PfrMmQ6Js0s34_qZRjuqkz0YPWgN9ORFqzS7w9V_FE',
  'title' => '',
  'path' => 'node',
  'url' => 'http://migrate-fixture-drupal7.ddev.site:7006/admin/content',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '65',
  'timestamp' => '1647480393',
))
->values(array(
  'aid' => '480',
  'sid' => '7PfrMmQ6Js0s34_qZRjuqkz0YPWgN9ORFqzS7w9V_FE',
  'title' => 'Structure',
  'path' => 'admin/structure',
  'url' => 'http://migrate-fixture-drupal7.ddev.site:7006/',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '80',
  'timestamp' => '1647480400',
))
->values(array(
  'aid' => '481',
  'sid' => '7PfrMmQ6Js0s34_qZRjuqkz0YPWgN9ORFqzS7w9V_FE',
  'title' => 'Blocks',
  'path' => 'admin/structure/block',
  'url' => 'http://migrate-fixture-drupal7.ddev.site:7006/admin/structure',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '145',
  'timestamp' => '1647480402',
))
->values(array(
  'aid' => '482',
  'sid' => '7PfrMmQ6Js0s34_qZRjuqkz0YPWgN9ORFqzS7w9V_FE',
  'title' => 'Are you sure you want to delete the block Limerick?',
  'path' => 'admin/structure/block/manage/block/1/delete',
  'url' => 'http://migrate-fixture-drupal7.ddev.site:7006/admin/structure/block',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '90',
  'timestamp' => '1647480406',
))
->values(array(
  'aid' => '483',
  'sid' => '7PfrMmQ6Js0s34_qZRjuqkz0YPWgN9ORFqzS7w9V_FE',
  'title' => 'Are you sure you want to delete the block Limerick?',
  'path' => 'admin/structure/block/manage/block/1/delete',
  'url' => 'http://migrate-fixture-drupal7.ddev.site:7006/admin/structure/block/manage/block/1/delete',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '28',
  'timestamp' => '1647480408',
))
->values(array(
  'aid' => '484',
  'sid' => '7PfrMmQ6Js0s34_qZRjuqkz0YPWgN9ORFqzS7w9V_FE',
  'title' => 'Blocks',
  'path' => 'admin/structure/block',
  'url' => 'http://migrate-fixture-drupal7.ddev.site:7006/admin/structure/block/manage/block/1/delete',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '60',
  'timestamp' => '1647480408',
))
->values(array(
  'aid' => '485',
  'sid' => '7PfrMmQ6Js0s34_qZRjuqkz0YPWgN9ORFqzS7w9V_FE',
  'title' => 'Blocks',
  'path' => 'admin/structure/block/list/seven',
  'url' => 'http://migrate-fixture-drupal7.ddev.site:7006/admin/structure/block',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '72',
  'timestamp' => '1647480411',
))
->values(array(
  'aid' => '486',
  'sid' => '7PfrMmQ6Js0s34_qZRjuqkz0YPWgN9ORFqzS7w9V_FE',
  'title' => 'Performance',
  'path' => 'admin/config/development/performance',
  'url' => 'http://migrate-fixture-drupal7.ddev.site:7006/admin/config/development/performance',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '797',
  'timestamp' => '1647480465',
))
->values(array(
  'aid' => '487',
  'sid' => '7PfrMmQ6Js0s34_qZRjuqkz0YPWgN9ORFqzS7w9V_FE',
  'title' => 'Performance',
  'path' => 'admin/config/development/performance',
  'url' => 'http://migrate-fixture-drupal7.ddev.site:7006/admin/config/development/performance',
  'hostname' => '172.18.0.6',
  'uid' => '1',
  'timer' => '110',
  'timestamp' => '1647480466',
))
->execute();
$connection->schema()->createTable('actions', array(
  'fields' => array(
    'aid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '0',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'parameters' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('actions')
->fields(array(
  'aid',
  'type',
  'callback',
  'parameters',
  'label',
))
->values(array(
  'aid' => '2',
  'type' => 'comment',
  'callback' => 'comment_unpublish_by_keyword_action',
  'parameters' => 'a:1:{s:8:"keywords";a:1:{i:0;s:6:"drupal";}}',
  'label' => 'Unpublish comment containing keyword(s)',
))
->values(array(
  'aid' => '3',
  'type' => 'node',
  'callback' => 'node_assign_owner_action',
  'parameters' => 'a:1:{s:9:"owner_uid";s:1:"2";}',
  'label' => 'Change the author of content',
))
->values(array(
  'aid' => '4',
  'type' => 'node',
  'callback' => 'node_unpublish_by_keyword_action',
  'parameters' => 'a:1:{s:8:"keywords";a:1:{i:0;s:6:"drupal";}}',
  'label' => 'Unpublish content containing keyword(s)',
))
->values(array(
  'aid' => '5',
  'type' => 'system',
  'callback' => 'system_message_action',
  'parameters' => 'a:1:{s:7:"message";s:21:"Drupal migration test";}',
  'label' => 'Display a message to the user',
))
->values(array(
  'aid' => '6',
  'type' => 'system',
  'callback' => 'system_send_email_action',
  'parameters' => 'a:3:{s:9:"recipient";s:16:"test@example.com";s:7:"subject";s:21:"Drupal migration test";s:7:"message";s:21:"Drupal migration test";}',
  'label' => 'Send e-mail',
))
->values(array(
  'aid' => '7',
  'type' => 'system',
  'callback' => 'system_goto_action',
  'parameters' => 'a:1:{s:3:"url";s:22:"https://www.drupal.org";}',
  'label' => 'Redirect to URL',
))
->values(array(
  'aid' => 'comment_publish_action',
  'type' => 'comment',
  'callback' => 'comment_publish_action',
  'parameters' => '',
  'label' => 'Publish comment',
))
->values(array(
  'aid' => 'comment_save_action',
  'type' => 'comment',
  'callback' => 'comment_save_action',
  'parameters' => '',
  'label' => 'Save comment',
))
->values(array(
  'aid' => 'comment_unpublish_action',
  'type' => 'comment',
  'callback' => 'comment_unpublish_action',
  'parameters' => '',
  'label' => 'Unpublish comment',
))
->values(array(
  'aid' => 'node_make_sticky_action',
  'type' => 'node',
  'callback' => 'node_make_sticky_action',
  'parameters' => '',
  'label' => 'Make content sticky',
))
->values(array(
  'aid' => 'node_make_unsticky_action',
  'type' => 'node',
  'callback' => 'node_make_unsticky_action',
  'parameters' => '',
  'label' => 'Make content unsticky',
))
->values(array(
  'aid' => 'node_promote_action',
  'type' => 'node',
  'callback' => 'node_promote_action',
  'parameters' => '',
  'label' => 'Promote content to front page',
))
->values(array(
  'aid' => 'node_publish_action',
  'type' => 'node',
  'callback' => 'node_publish_action',
  'parameters' => '',
  'label' => 'Publish content',
))
->values(array(
  'aid' => 'node_save_action',
  'type' => 'node',
  'callback' => 'node_save_action',
  'parameters' => '',
  'label' => 'Save content',
))
->values(array(
  'aid' => 'node_unpromote_action',
  'type' => 'node',
  'callback' => 'node_unpromote_action',
  'parameters' => '',
  'label' => 'Remove content from front page',
))
->values(array(
  'aid' => 'node_unpublish_action',
  'type' => 'node',
  'callback' => 'node_unpublish_action',
  'parameters' => '',
  'label' => 'Unpublish content',
))
->values(array(
  'aid' => 'system_block_ip_action',
  'type' => 'user',
  'callback' => 'system_block_ip_action',
  'parameters' => '',
  'label' => 'Ban IP address of current user',
))
->values(array(
  'aid' => 'user_block_user_action',
  'type' => 'user',
  'callback' => 'user_block_user_action',
  'parameters' => '',
  'label' => 'Block current user',
))
->execute();
$connection->schema()->createTable('authmap', array(
  'fields' => array(
    'aid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'authname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('batch', array(
  'fields' => array(
    'bid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'token' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'batch' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('block', array(
  'fields' => array(
    'bid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '0',
    ),
    'theme' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'region' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'custom' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'visibility' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'pages' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('block')
->fields(array(
  'bid',
  'module',
  'delta',
  'theme',
  'status',
  'weight',
  'region',
  'custom',
  'visibility',
  'pages',
  'title',
  'cache',
))
->values(array(
  'bid' => '1',
  'module' => 'system',
  'delta' => 'main',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'content',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '2',
  'module' => 'search',
  'delta' => 'form',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '-1',
  'region' => 'sidebar_first',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '3',
  'module' => 'node',
  'delta' => 'recent',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '10',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '4',
  'module' => 'user',
  'delta' => 'login',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'sidebar_first',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => 'User login title',
  'cache' => '-1',
))
->values(array(
  'bid' => '5',
  'module' => 'system',
  'delta' => 'navigation',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'sidebar_first',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '6',
  'module' => 'system',
  'delta' => 'powered-by',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '10',
  'region' => 'footer',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '7',
  'module' => 'system',
  'delta' => 'help',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'help',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '8',
  'module' => 'system',
  'delta' => 'main',
  'theme' => 'seven',
  'status' => '1',
  'weight' => '0',
  'region' => 'content',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '9',
  'module' => 'system',
  'delta' => 'help',
  'theme' => 'seven',
  'status' => '1',
  'weight' => '0',
  'region' => 'help',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '10',
  'module' => 'user',
  'delta' => 'login',
  'theme' => 'seven',
  'status' => '1',
  'weight' => '10',
  'region' => 'content',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => 'User login title',
  'cache' => '-1',
))
->values(array(
  'bid' => '11',
  'module' => 'user',
  'delta' => 'new',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '12',
  'module' => 'search',
  'delta' => 'form',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '-10',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '13',
  'module' => 'comment',
  'delta' => 'recent',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '14',
  'module' => 'node',
  'delta' => 'syndicate',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '15',
  'module' => 'node',
  'delta' => 'recent',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '16',
  'module' => 'shortcut',
  'delta' => 'shortcuts',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '17',
  'module' => 'system',
  'delta' => 'management',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '18',
  'module' => 'system',
  'delta' => 'user-menu',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '19',
  'module' => 'system',
  'delta' => 'main-menu',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '20',
  'module' => 'user',
  'delta' => 'new',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '21',
  'module' => 'user',
  'delta' => 'online',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '22',
  'module' => 'comment',
  'delta' => 'recent',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '23',
  'module' => 'node',
  'delta' => 'syndicate',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '24',
  'module' => 'shortcut',
  'delta' => 'shortcuts',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '25',
  'module' => 'system',
  'delta' => 'powered-by',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '10',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '26',
  'module' => 'system',
  'delta' => 'navigation',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '27',
  'module' => 'system',
  'delta' => 'management',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '28',
  'module' => 'system',
  'delta' => 'user-menu',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '29',
  'module' => 'system',
  'delta' => 'main-menu',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '30',
  'module' => 'user',
  'delta' => 'online',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '42',
  'module' => 'statistics',
  'delta' => 'popular',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '44',
  'module' => 'statistics',
  'delta' => 'popular',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '51',
  'module' => 'menu',
  'delta' => 'menu-fixedlang',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '52',
  'module' => 'menu',
  'delta' => 'menu-fixedlang',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->execute();
$connection->schema()->createTable('block_custom', array(
  'fields' => array(
    'bid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'body' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'info' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('block_node_type', array(
  'fields' => array(
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'delta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
  ),
  'primary key' => array(
    'module',
    'delta',
    'type',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('block_role', array(
  'fields' => array(
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'delta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'rid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'module',
    'delta',
    'rid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('blocked_ips', array(
  'fields' => array(
    'iid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'ip' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '40',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'iid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_block', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_bootstrap', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_field', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_filter', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_form', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_image', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_menu', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_page', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_path', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_views', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_views_data', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('comment', array(
  'fields' => array(
    'cid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'pid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'subject' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
      'unsigned' => TRUE,
    ),
    'thread' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '60',
    ),
    'mail' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '64',
    ),
    'homepage' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('contact', array(
  'fields' => array(
    'cid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'category' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'recipients' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'reply' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'selected' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('ctools_css_cache', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ),
    'filename' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'css' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'filter' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('ctools_object_cache', array(
  'fields' => array(
    'sid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ),
    'obj' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'updated' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'sid',
    'name',
    'obj',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('date_format_locale', array(
  'fields' => array(
    'format' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
      'binary' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
    ),
  ),
  'primary key' => array(
    'type',
    'language',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('date_format_type', array(
  'fields' => array(
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'type',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('date_format_type')
->fields(array(
  'type',
  'title',
  'locked',
))
->values(array(
  'type' => 'long',
  'title' => 'Long',
  'locked' => '1',
))
->values(array(
  'type' => 'medium',
  'title' => 'Medium',
  'locked' => '1',
))
->values(array(
  'type' => 'short',
  'title' => 'Short',
  'locked' => '1',
))
->execute();
$connection->schema()->createTable('date_formats', array(
  'fields' => array(
    'dfid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'format' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'dfid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('date_formats')
->fields(array(
  'dfid',
  'format',
  'type',
  'locked',
))
->values(array(
  'dfid' => '1',
  'format' => 'Y-m-d H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '2',
  'format' => 'm/d/Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '3',
  'format' => 'd/m/Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '4',
  'format' => 'Y/m/d - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '5',
  'format' => 'd.m.Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '6',
  'format' => 'm/d/Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '7',
  'format' => 'd/m/Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '8',
  'format' => 'Y/m/d - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '9',
  'format' => 'M j Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '10',
  'format' => 'j M Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '11',
  'format' => 'Y M j - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '12',
  'format' => 'M j Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '13',
  'format' => 'j M Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '14',
  'format' => 'Y M j - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '15',
  'format' => 'D, Y-m-d H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '16',
  'format' => 'D, m/d/Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '17',
  'format' => 'D, d/m/Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '18',
  'format' => 'D, Y/m/d - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '19',
  'format' => 'F j, Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '20',
  'format' => 'j F, Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '21',
  'format' => 'Y, F j - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '22',
  'format' => 'D, m/d/Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '23',
  'format' => 'D, d/m/Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '24',
  'format' => 'D, Y/m/d - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '25',
  'format' => 'F j, Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '26',
  'format' => 'j F Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '27',
  'format' => 'Y, F j - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '28',
  'format' => 'j. F Y - G:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '29',
  'format' => 'l, F j, Y - H:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '30',
  'format' => 'l, j F, Y - H:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '31',
  'format' => 'l, Y,  F j - H:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '32',
  'format' => 'l, F j, Y - g:ia',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '33',
  'format' => 'l, j F Y - g:ia',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '34',
  'format' => 'l, Y,  F j - g:ia',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '35',
  'format' => 'l, j. F Y - G:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '36',
  'format' => 'r',
  'type' => 'custom',
  'locked' => '0',
))
->execute();
$connection->schema()->createTable('field_config', array(
  'fields' => array(
    'id' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'field_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'active' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'storage_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ),
    'storage_module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'storage_active' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'cardinality' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'translatable' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'id',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_config')
->fields(array(
  'id',
  'field_name',
  'type',
  'module',
  'active',
  'storage_type',
  'storage_module',
  'storage_active',
  'locked',
  'data',
  'cardinality',
  'translatable',
  'deleted',
))
->values(array(
  'id' => '1',
  'field_name' => 'comment_body',
  'type' => 'text_long',
  'module' => 'text',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:6:{s:12:"entity_types";a:1:{i:0;s:7:"comment";}s:12:"translatable";b:0;s:8:"settings";a:0:{}s:7:"storage";a:4:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";i:1;}s:12:"foreign keys";a:1:{s:6:"format";a:2:{s:5:"table";s:13:"filter_format";s:7:"columns";a:1:{s:6:"format";s:6:"format";}}}s:7:"indexes";a:1:{s:6:"format";a:1:{i:0;s:6:"format";}}}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '2',
  'field_name' => 'body',
  'type' => 'text_with_summary',
  'module' => 'text',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:6:{s:12:"entity_types";a:1:{i:0;s:4:"node";}s:12:"translatable";b:0;s:8:"settings";a:0:{}s:7:"storage";a:4:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";i:1;}s:12:"foreign keys";a:1:{s:6:"format";a:2:{s:5:"table";s:13:"filter_format";s:7:"columns";a:1:{s:6:"format";s:6:"format";}}}s:7:"indexes";a:1:{s:6:"format";a:1:{i:0;s:6:"format";}}}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '4',
  'field_name' => 'field_image',
  'type' => 'image',
  'module' => 'image',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:6:{s:7:"indexes";a:1:{s:3:"fid";a:1:{i:0;s:3:"fid";}}s:8:"settings";a:2:{s:10:"uri_scheme";s:6:"public";s:13:"default_image";b:0;}s:7:"storage";a:4:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";i:1;}s:12:"entity_types";a:0:{}s:12:"translatable";b:0;s:12:"foreign keys";a:1:{s:3:"fid";a:2:{s:5:"table";s:12:"file_managed";s:7:"columns";a:1:{s:3:"fid";s:3:"fid";}}}}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '6',
  'field_name' => 'field_boolean',
  'type' => 'list_boolean',
  'module' => 'list',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";s:1:"0";s:12:"entity_types";a:0:{}s:8:"settings";a:2:{s:14:"allowed_values";a:2:{i:0;s:3:"Off";i:1;s:1:"1";}s:23:"allowed_values_function";s:0:"";}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:24:"field_data_field_boolean";a:1:{s:5:"value";s:19:"field_boolean_value";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:28:"field_revision_field_boolean";a:1:{s:5:"value";s:19:"field_boolean_value";}}}}}s:12:"foreign keys";a:0:{}s:7:"indexes";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:2:"id";s:1:"6";}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '11',
  'field_name' => 'field_file',
  'type' => 'file',
  'module' => 'file',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";s:1:"0";s:12:"entity_types";a:0:{}s:8:"settings";a:3:{s:13:"display_field";i:0;s:15:"display_default";i:0;s:10:"uri_scheme";s:6:"public";}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:21:"field_data_field_file";a:3:{s:3:"fid";s:14:"field_file_fid";s:7:"display";s:18:"field_file_display";s:11:"description";s:22:"field_file_description";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:25:"field_revision_field_file";a:3:{s:3:"fid";s:14:"field_file_fid";s:7:"display";s:18:"field_file_display";s:11:"description";s:22:"field_file_description";}}}}}s:12:"foreign keys";a:1:{s:3:"fid";a:2:{s:5:"table";s:12:"file_managed";s:7:"columns";a:1:{s:3:"fid";s:3:"fid";}}}s:7:"indexes";a:1:{s:3:"fid";a:1:{i:0;s:3:"fid";}}s:2:"id";s:2:"11";}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '14',
  'field_name' => 'field_integer',
  'type' => 'number_integer',
  'module' => 'number',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";b:1;s:12:"entity_types";a:0:{}s:8:"settings";a:1:{s:23:"entity_translation_sync";b:0;}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:24:"field_data_field_integer";a:1:{s:5:"value";s:19:"field_integer_value";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:28:"field_revision_field_integer";a:1:{s:5:"value";s:19:"field_integer_value";}}}}}s:12:"foreign keys";a:0:{}s:7:"indexes";a:0:{}s:2:"id";s:2:"14";}',
  'cardinality' => '1',
  'translatable' => '1',
  'deleted' => '0',
))
->values(array(
  'id' => '15',
  'field_name' => 'field_link',
  'type' => 'link_field',
  'module' => 'link',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";s:1:"0";s:12:"entity_types";a:0:{}s:8:"settings";a:7:{s:10:"attributes";a:3:{s:6:"target";s:7:"default";s:5:"class";s:0:"";s:3:"rel";s:0:"";}s:3:"url";i:0;s:5:"title";s:8:"optional";s:11:"title_value";s:0:"";s:15:"title_maxlength";i:128;s:13:"enable_tokens";i:1;s:7:"display";a:1:{s:10:"url_cutoff";i:80;}}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:21:"field_data_field_link";a:3:{s:3:"url";s:14:"field_link_url";s:5:"title";s:16:"field_link_title";s:10:"attributes";s:21:"field_link_attributes";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:25:"field_revision_field_link";a:3:{s:3:"url";s:14:"field_link_url";s:5:"title";s:16:"field_link_title";s:10:"attributes";s:21:"field_link_attributes";}}}}}s:12:"foreign keys";a:0:{}s:7:"indexes";a:0:{}s:2:"id";s:2:"15";}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '40',
  'field_name' => 'title_field',
  'type' => 'text',
  'module' => 'text',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:6:{s:12:"translatable";b:1;s:12:"entity_types";a:0:{}s:8:"settings";a:2:{s:10:"max_length";i:255;s:23:"entity_translation_sync";b:0;}s:7:"storage";a:4:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";i:1;}s:12:"foreign keys";a:1:{s:6:"format";a:2:{s:5:"table";s:13:"filter_format";s:7:"columns";a:1:{s:6:"format";s:6:"format";}}}s:7:"indexes";a:1:{s:6:"format";a:1:{i:0;s:6:"format";}}}',
  'cardinality' => '1',
  'translatable' => '1',
  'deleted' => '0',
))
->values(array(
  'id' => '41',
  'field_name' => 'subject_field',
  'type' => 'text',
  'module' => 'text',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:6:{s:12:"translatable";b:1;s:12:"entity_types";a:0:{}s:8:"settings";a:2:{s:10:"max_length";i:255;s:23:"entity_translation_sync";b:0;}s:7:"storage";a:4:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";i:1;}s:12:"foreign keys";a:1:{s:6:"format";a:2:{s:5:"table";s:13:"filter_format";s:7:"columns";a:1:{s:6:"format";s:6:"format";}}}s:7:"indexes";a:1:{s:6:"format";a:1:{i:0;s:6:"format";}}}',
  'cardinality' => '1',
  'translatable' => '1',
  'deleted' => '0',
))
->values(array(
  'id' => '48',
  'field_name' => 'field_color',
  'type' => 'list_text',
  'module' => 'list',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";b:1;s:12:"entity_types";a:0:{}s:8:"settings";a:3:{s:14:"allowed_values";a:3:{i:0;s:5:"Green";i:1;s:5:"Black";i:2;s:5:"White";}s:23:"allowed_values_function";s:0:"";s:23:"entity_translation_sync";b:0;}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:22:"field_data_field_color";a:1:{s:5:"value";s:17:"field_color_value";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:26:"field_revision_field_color";a:1:{s:5:"value";s:17:"field_color_value";}}}}}s:12:"foreign keys";a:0:{}s:7:"indexes";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:2:"id";s:2:"48";}',
  'cardinality' => '1',
  'translatable' => '1',
  'deleted' => '0',
))
->values(array(
  'id' => '49',
  'field_name' => 'field_rating',
  'type' => 'list_text',
  'module' => 'list',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";b:1;s:12:"entity_types";a:0:{}s:8:"settings";a:3:{s:14:"allowed_values";a:3:{i:1;s:4:"High";i:2;s:6:"Medium";i:3;s:3:"Low";}s:23:"allowed_values_function";s:0:"";s:23:"entity_translation_sync";b:0;}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:23:"field_data_field_rating";a:1:{s:5:"value";s:18:"field_rating_value";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:27:"field_revision_field_rating";a:1:{s:5:"value";s:18:"field_rating_value";}}}}}s:12:"foreign keys";a:0:{}s:7:"indexes";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:2:"id";s:2:"49";}',
  'cardinality' => '1',
  'translatable' => '1',
  'deleted' => '0',
))
->values(array(
  'id' => '59',
  'field_name' => 'field_file_mfw',
  'type' => 'file',
  'module' => 'file',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";i:0;s:12:"entity_types";a:0:{}s:8:"settings";a:4:{s:13:"display_field";i:0;s:15:"display_default";i:0;s:10:"uri_scheme";s:6:"public";s:23:"entity_translation_sync";a:1:{i:0;s:3:"fid";}}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:25:"field_data_field_file_mfw";a:3:{s:3:"fid";s:18:"field_file_mfw_fid";s:7:"display";s:22:"field_file_mfw_display";s:11:"description";s:26:"field_file_mfw_description";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:29:"field_revision_field_file_mfw";a:3:{s:3:"fid";s:18:"field_file_mfw_fid";s:7:"display";s:22:"field_file_mfw_display";s:11:"description";s:26:"field_file_mfw_description";}}}}}s:12:"foreign keys";a:1:{s:3:"fid";a:2:{s:5:"table";s:12:"file_managed";s:7:"columns";a:1:{s:3:"fid";s:3:"fid";}}}s:7:"indexes";a:1:{s:3:"fid";a:1:{i:0;s:3:"fid";}}s:2:"id";s:2:"56";}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '60',
  'field_name' => 'field_image_miw',
  'type' => 'image',
  'module' => 'image',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";i:0;s:12:"entity_types";a:0:{}s:8:"settings";a:3:{s:10:"uri_scheme";s:6:"public";s:13:"default_image";i:0;s:23:"entity_translation_sync";a:1:{i:0;s:3:"fid";}}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:26:"field_data_field_image_miw";a:5:{s:3:"fid";s:19:"field_image_miw_fid";s:3:"alt";s:19:"field_image_miw_alt";s:5:"title";s:21:"field_image_miw_title";s:5:"width";s:21:"field_image_miw_width";s:6:"height";s:22:"field_image_miw_height";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:30:"field_revision_field_image_miw";a:5:{s:3:"fid";s:19:"field_image_miw_fid";s:3:"alt";s:19:"field_image_miw_alt";s:5:"title";s:21:"field_image_miw_title";s:5:"width";s:21:"field_image_miw_width";s:6:"height";s:22:"field_image_miw_height";}}}}}s:12:"foreign keys";a:1:{s:3:"fid";a:2:{s:5:"table";s:12:"file_managed";s:7:"columns";a:1:{s:3:"fid";s:3:"fid";}}}s:7:"indexes";a:1:{s:3:"fid";a:1:{i:0;s:3:"fid";}}s:2:"id";s:2:"57";}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '62',
  'field_name' => 'field_event',
  'type' => 'datetime',
  'module' => 'date',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";i:0;s:12:"entity_types";a:0:{}s:8:"settings";a:7:{s:11:"granularity";a:6:{s:5:"month";s:5:"month";s:3:"day";s:3:"day";s:4:"hour";s:4:"hour";s:6:"minute";s:6:"minute";s:4:"year";s:4:"year";s:6:"second";i:0;}s:11:"tz_handling";s:4:"site";s:11:"timezone_db";s:3:"UTC";s:13:"cache_enabled";i:0;s:11:"cache_count";s:1:"4";s:6:"todate";s:8:"optional";s:23:"entity_translation_sync";b:0;}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:22:"field_data_field_event";a:2:{s:5:"value";s:17:"field_event_value";s:6:"value2";s:18:"field_event_value2";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:26:"field_revision_field_event";a:2:{s:5:"value";s:17:"field_event_value";s:6:"value2";s:18:"field_event_value2";}}}}}s:12:"foreign keys";a:0:{}s:7:"indexes";a:0:{}s:2:"id";s:2:"54";}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->execute();
$connection->schema()->createTable('field_config_instance', array(
  'fields' => array(
    'id' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'field_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'field_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'id',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_config_instance')
->fields(array(
  'id',
  'field_id',
  'field_name',
  'entity_type',
  'bundle',
  'data',
  'deleted',
))
->values(array(
  'id' => '1',
  'field_id' => '1',
  'field_name' => 'comment_body',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_page',
  'data' => 'a:6:{s:5:"label";s:7:"Comment";s:8:"settings";a:2:{s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:8:"required";b:1;s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:6:"module";s:4:"text";}}s:6:"widget";a:4:{s:4:"type";s:13:"text_textarea";s:8:"settings";a:1:{s:4:"rows";i:5;}s:6:"weight";i:0;s:6:"module";s:4:"text";}s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '2',
  'field_id' => '2',
  'field_name' => 'body',
  'entity_type' => 'node',
  'bundle' => 'page',
  'data' => 'a:6:{s:5:"label";s:4:"Body";s:6:"widget";a:4:{s:4:"type";s:26:"text_textarea_with_summary";s:8:"settings";a:2:{s:4:"rows";i:20;s:12:"summary_rows";i:5;}s:6:"weight";i:-4;s:6:"module";s:4:"text";}s:8:"settings";a:3:{s:15:"display_summary";b:1;s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:7:"display";a:2:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"weight";i:0;}s:6:"teaser";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:6:"module";s:4:"text";s:6:"weight";i:0;}}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '3',
  'field_id' => '1',
  'field_name' => 'comment_body',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_article',
  'data' => 'a:6:{s:5:"label";s:7:"Comment";s:8:"settings";a:2:{s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:8:"required";b:1;s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:6:"module";s:4:"text";}}s:6:"widget";a:4:{s:4:"type";s:13:"text_textarea";s:8:"settings";a:1:{s:4:"rows";i:5;}s:6:"weight";i:0;s:6:"module";s:4:"text";}s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '4',
  'field_id' => '2',
  'field_name' => 'body',
  'entity_type' => 'node',
  'bundle' => 'article',
  'data' => 'a:6:{s:5:"label";s:4:"Body";s:6:"widget";a:4:{s:4:"type";s:26:"text_textarea_with_summary";s:8:"settings";a:2:{s:4:"rows";i:20;s:12:"summary_rows";i:5;}s:6:"weight";s:2:"-4";s:6:"module";s:4:"text";}s:8:"settings";a:4:{s:15:"display_summary";b:1;s:15:"text_processing";i:1;s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:7:"display";a:3:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"weight";i:0;}s:6:"teaser";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:6:"module";s:4:"text";s:6:"weight";i:0;}s:6:"custom";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:6:"module";s:4:"text";s:6:"weight";i:11;}}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '6',
  'field_id' => '4',
  'field_name' => 'field_image',
  'entity_type' => 'node',
  'bundle' => 'article',
  'data' => 'a:6:{s:5:"label";s:5:"Image";s:11:"description";s:40:"Upload an image to go with this article.";s:8:"required";b:0;s:8:"settings";a:10:{s:14:"file_directory";s:11:"field/image";s:15:"file_extensions";s:16:"png gif jpg jpeg";s:12:"max_filesize";s:0:"";s:14:"max_resolution";s:0:"";s:14:"min_resolution";s:0:"";s:9:"alt_field";b:1;s:11:"title_field";s:0:"";s:13:"default_image";i:0;s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:6:"widget";a:4:{s:4:"type";s:11:"image_image";s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}s:6:"weight";s:2:"-1";s:6:"module";s:5:"image";}s:7:"display";a:2:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:5:"image";s:8:"settings";a:2:{s:11:"image_style";s:5:"large";s:10:"image_link";s:0:"";}s:6:"weight";i:-1;s:6:"module";s:5:"image";}s:6:"teaser";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:5:"image";s:8:"settings";a:2:{s:11:"image_style";s:6:"medium";s:10:"image_link";s:7:"content";}s:6:"weight";i:-1;s:6:"module";s:5:"image";}}}',
  'deleted' => '0',
))
->values(array(
  'id' => '7',
  'field_id' => '1',
  'field_name' => 'comment_body',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_blog',
  'data' => 'a:6:{s:5:"label";s:7:"Comment";s:8:"settings";a:2:{s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:8:"required";b:1;s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:6:"module";s:4:"text";}}s:6:"widget";a:4:{s:4:"type";s:13:"text_textarea";s:8:"settings";a:1:{s:4:"rows";i:5;}s:6:"weight";i:0;s:6:"module";s:4:"text";}s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '8',
  'field_id' => '2',
  'field_name' => 'body',
  'entity_type' => 'node',
  'bundle' => 'blog',
  'data' => 'a:6:{s:5:"label";s:4:"Body";s:6:"widget";a:4:{s:4:"type";s:26:"text_textarea_with_summary";s:8:"settings";a:2:{s:4:"rows";i:20;s:12:"summary_rows";i:5;}s:6:"weight";s:2:"-4";s:6:"module";s:4:"text";}s:8:"settings";a:4:{s:15:"display_summary";b:1;s:15:"text_processing";i:1;s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:7:"display";a:2:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"weight";i:0;}s:6:"teaser";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:6:"module";s:4:"text";s:6:"weight";i:0;}}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '12',
  'field_id' => '1',
  'field_name' => 'comment_body',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_forum',
  'data' => 'a:6:{s:5:"label";s:7:"Comment";s:8:"settings";a:2:{s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:8:"required";b:1;s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:6:"module";s:4:"text";}}s:6:"widget";a:4:{s:4:"type";s:13:"text_textarea";s:8:"settings";a:1:{s:4:"rows";i:5;}s:6:"weight";i:0;s:6:"module";s:4:"text";}s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '13',
  'field_id' => '2',
  'field_name' => 'body',
  'entity_type' => 'node',
  'bundle' => 'forum',
  'data' => 'a:6:{s:5:"label";s:4:"Body";s:6:"widget";a:4:{s:4:"type";s:26:"text_textarea_with_summary";s:8:"settings";a:2:{s:4:"rows";i:20;s:12:"summary_rows";i:5;}s:6:"weight";i:1;s:6:"module";s:4:"text";}s:8:"settings";a:3:{s:15:"display_summary";b:1;s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:7:"display";a:2:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"weight";i:11;}s:6:"teaser";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:6:"module";s:4:"text";s:6:"weight";i:11;}}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '14',
  'field_id' => '1',
  'field_name' => 'comment_body',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'data' => 'a:6:{s:5:"label";s:7:"Comment";s:8:"settings";a:2:{s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:8:"required";b:1;s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:6:"module";s:4:"text";}}s:6:"widget";a:4:{s:4:"type";s:13:"text_textarea";s:8:"settings";a:1:{s:4:"rows";i:5;}s:6:"weight";s:1:"0";s:6:"module";s:4:"text";}s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '21',
  'field_id' => '11',
  'field_name' => 'field_file',
  'entity_type' => 'node',
  'bundle' => 'test_content_type',
  'data' => 'a:6:{s:5:"label";s:4:"File";s:6:"widget";a:5:{s:6:"weight";s:1:"5";s:4:"type";s:12:"file_generic";s:6:"module";s:4:"file";s:6:"active";i:1;s:8:"settings";a:1:{s:18:"progress_indicator";s:8:"throbber";}}s:8:"settings";a:5:{s:14:"file_directory";s:0:"";s:15:"file_extensions";s:15:"txt pdf ods odf";s:12:"max_filesize";s:5:"10 MB";s:17:"description_field";i:1;s:18:"user_register_form";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:12:"file_default";s:6:"weight";s:1:"5";s:8:"settings";a:0:{}s:6:"module";s:4:"file";}}s:8:"required";i:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '32',
  'field_id' => '14',
  'field_name' => 'field_integer',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'data' => 'a:7:{s:5:"label";s:7:"Integer";s:6:"widget";a:5:{s:6:"weight";s:1:"2";s:4:"type";s:6:"number";s:6:"module";s:6:"number";s:6:"active";i:0;s:8:"settings";a:0:{}}s:8:"settings";a:5:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:18:"user_register_form";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:14:"number_integer";s:8:"settings";a:4:{s:18:"thousand_separator";s:1:" ";s:17:"decimal_separator";s:1:".";s:5:"scale";i:0;s:13:"prefix_suffix";b:1;}s:6:"module";s:6:"number";s:6:"weight";i:1;}}s:8:"required";i:0;s:11:"description";s:0:"";s:13:"default_value";N;}',
  'deleted' => '0',
))
->values(array(
  'id' => '33',
  'field_id' => '11',
  'field_name' => 'field_file',
  'entity_type' => 'user',
  'bundle' => 'user',
  'data' => 'a:6:{s:5:"label";s:4:"File";s:6:"widget";a:5:{s:6:"weight";s:1:"8";s:4:"type";s:12:"file_generic";s:6:"module";s:4:"file";s:6:"active";i:1;s:8:"settings";a:1:{s:18:"progress_indicator";s:8:"throbber";}}s:8:"settings";a:5:{s:14:"file_directory";s:0:"";s:15:"file_extensions";s:3:"txt";s:12:"max_filesize";s:0:"";s:17:"description_field";i:0;s:18:"user_register_form";i:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:12:"file_default";s:8:"settings";a:0:{}s:6:"module";s:4:"file";s:6:"weight";i:0;}}s:8:"required";i:0;s:11:"description";s:0:"";}',
  'deleted' => '1',
))
->values(array(
  'id' => '34',
  'field_id' => '15',
  'field_name' => 'field_link',
  'entity_type' => 'node',
  'bundle' => 'article',
  'data' => 'a:7:{s:5:"label";s:4:"Link";s:6:"widget";a:5:{s:6:"weight";s:2:"10";s:4:"type";s:10:"link_field";s:6:"module";s:4:"link";s:6:"active";i:0;s:8:"settings";a:0:{}}s:8:"settings";a:13:{s:12:"absolute_url";i:1;s:12:"validate_url";i:1;s:3:"url";i:0;s:5:"title";s:8:"disabled";s:11:"title_value";s:19:"Unused Static Title";s:27:"title_label_use_field_label";i:0;s:15:"title_maxlength";s:3:"128";s:7:"display";a:1:{s:10:"url_cutoff";s:2:"81";}s:10:"attributes";a:6:{s:6:"target";s:6:"_blank";s:3:"rel";s:8:"nofollow";s:18:"configurable_class";i:0;s:5:"class";s:7:"classes";s:18:"configurable_title";i:1;s:5:"title";s:0:"";}s:10:"rel_remove";s:19:"rel_remove_external";s:13:"enable_tokens";i:1;s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:12:"link_default";s:6:"weight";s:1:"9";s:8:"settings";a:0:{}s:6:"module";s:4:"link";}}s:8:"required";i:0;s:11:"description";s:0:"";s:13:"default_value";N;}',
  'deleted' => '0',
))
->values(array(
  'id' => '37',
  'field_id' => '15',
  'field_name' => 'field_link',
  'entity_type' => 'node',
  'bundle' => 'blog',
  'data' => 'a:7:{s:5:"label";s:4:"Link";s:6:"widget";a:5:{s:6:"weight";s:2:"10";s:4:"type";s:10:"link_field";s:6:"module";s:4:"link";s:6:"active";i:0;s:8:"settings";a:0:{}}s:8:"settings";a:14:{s:12:"absolute_url";i:1;s:12:"validate_url";i:1;s:3:"url";i:0;s:5:"title";s:8:"required";s:11:"title_value";s:19:"Unused Static Title";s:20:"title_allowed_values";s:0:"";s:27:"title_label_use_field_label";i:0;s:15:"title_maxlength";s:3:"128";s:7:"display";a:1:{s:10:"url_cutoff";s:2:"81";}s:10:"attributes";a:6:{s:6:"target";s:6:"_blank";s:3:"rel";s:8:"nofollow";s:18:"configurable_class";i:0;s:5:"class";s:7:"classes";s:18:"configurable_title";i:1;s:5:"title";s:0:"";}s:10:"rel_remove";s:19:"rel_remove_external";s:13:"enable_tokens";i:1;s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:12:"link_default";s:6:"weight";s:1:"9";s:8:"settings";a:0:{}s:6:"module";s:4:"link";}}s:8:"required";i:0;s:11:"description";s:0:"";s:13:"default_value";a:1:{i:0;a:3:{s:5:"title";s:6:"Drupal";s:3:"url";s:23:"https://www.drupal.org/";s:10:"attributes";a:1:{s:5:"title";s:14:"Home - Drupal ";}}}}',
  'deleted' => '0',
))
->values(array(
  'id' => '67',
  'field_id' => '40',
  'field_name' => 'title_field',
  'entity_type' => 'node',
  'bundle' => 'test_content_type',
  'data' => 'a:6:{s:5:"label";s:5:"Title";s:11:"description";s:0:"";s:8:"required";b:1;s:8:"settings";a:4:{s:15:"text_processing";i:0;s:10:"hide_label";a:2:{s:4:"page";b:0;s:6:"entity";b:0;}s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:6:"widget";a:4:{s:6:"weight";i:-5;s:4:"type";s:14:"text_textfield";s:8:"settings";a:1:{s:4:"size";i:60;}s:6:"module";s:4:"text";}s:7:"display";a:1:{s:7:"default";a:4:{s:4:"type";s:6:"hidden";s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:6:"weight";i:20;}}}',
  'deleted' => '0',
))
->values(array(
  'id' => '68',
  'field_id' => '41',
  'field_name' => 'subject_field',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_article',
  'data' => 'a:6:{s:5:"label";s:7:"Subject";s:11:"description";s:0:"";s:8:"required";b:1;s:8:"settings";a:4:{s:15:"text_processing";i:0;s:10:"hide_label";a:2:{s:4:"page";b:0;s:6:"entity";b:0;}s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:6:"widget";a:4:{s:6:"weight";i:-5;s:4:"type";s:14:"text_textfield";s:8:"settings";a:1:{s:4:"size";i:60;}s:6:"module";s:4:"text";}s:7:"display";a:1:{s:7:"default";a:4:{s:4:"type";s:6:"hidden";s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:6:"weight";i:1;}}}',
  'deleted' => '0',
))
->values(array(
  'id' => '71',
  'field_id' => '41',
  'field_name' => 'subject_field',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'data' => 'a:6:{s:5:"label";s:7:"Subject";s:11:"description";s:0:"";s:8:"required";b:1;s:8:"settings";a:4:{s:15:"text_processing";i:0;s:10:"hide_label";a:2:{s:4:"page";b:0;s:6:"entity";b:0;}s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:6:"widget";a:4:{s:6:"weight";i:-5;s:4:"type";s:14:"text_textfield";s:8:"settings";a:1:{s:4:"size";i:60;}s:6:"module";s:4:"text";}s:7:"display";a:1:{s:7:"default";a:4:{s:4:"type";s:6:"hidden";s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:6:"weight";i:1;}}}',
  'deleted' => '0',
))
->values(array(
  'id' => '76',
  'field_id' => '48',
  'field_name' => 'field_color',
  'entity_type' => 'node',
  'bundle' => 'blog',
  'data' => 'a:7:{s:5:"label";s:5:"Color";s:6:"widget";a:5:{s:6:"weight";s:2:"11";s:4:"type";s:14:"options_select";s:6:"module";s:7:"options";s:6:"active";i:1;s:8:"settings";a:0:{}}s:8:"settings";a:2:{s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:12:"list_default";s:8:"settings";a:0:{}s:6:"module";s:4:"list";s:6:"weight";i:10;}}s:8:"required";i:0;s:11:"description";s:0:"";s:13:"default_value";N;}',
  'deleted' => '0',
))
->values(array(
  'id' => '77',
  'field_id' => '49',
  'field_name' => 'field_rating',
  'entity_type' => 'node',
  'bundle' => 'blog',
  'data' => 'a:7:{s:5:"label";s:6:"Rating";s:6:"widget";a:5:{s:6:"weight";s:2:"12";s:4:"type";s:15:"options_buttons";s:6:"module";s:7:"options";s:6:"active";i:1;s:8:"settings";a:0:{}}s:8:"settings";a:2:{s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:12:"list_default";s:8:"settings";a:0:{}s:6:"module";s:4:"list";s:6:"weight";i:11;}}s:8:"required";i:0;s:11:"description";s:0:"";s:13:"default_value";N;}',
  'deleted' => '0',
))
->values(array(
  'id' => '78',
  'field_id' => '6',
  'field_name' => 'field_boolean',
  'entity_type' => 'node',
  'bundle' => 'blog',
  'data' => 'a:6:{s:5:"label";s:7:"Boolean";s:6:"widget";a:4:{s:4:"type";s:13:"options_onoff";s:6:"weight";s:2:"14";s:8:"settings";a:1:{s:13:"display_label";i:0;}s:6:"module";s:7:"options";}s:8:"settings";a:2:{s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:12:"list_default";s:8:"settings";a:0:{}s:6:"module";s:4:"list";s:6:"weight";i:12;}}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '91',
  'field_id' => '59',
  'field_name' => 'field_file_mfw',
  'entity_type' => 'node',
  'bundle' => 'blog',
  'data' => 'a:6:{s:5:"label";s:8:"file_mfw";s:6:"widget";a:5:{s:6:"weight";s:2:"17";s:4:"type";s:8:"file_mfw";s:6:"module";s:28:"multiupload_filefield_widget";s:6:"active";i:1;s:8:"settings";a:1:{s:18:"progress_indicator";s:8:"throbber";}}s:8:"settings";a:6:{s:14:"file_directory";s:0:"";s:15:"file_extensions";s:3:"txt";s:12:"max_filesize";s:0:"";s:17:"description_field";i:0;s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:12:"file_default";s:8:"settings";a:0:{}s:6:"module";s:4:"file";s:6:"weight";i:15;}}s:8:"required";i:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '92',
  'field_id' => '60',
  'field_name' => 'field_image_miw',
  'entity_type' => 'node',
  'bundle' => 'blog',
  'data' => 'a:6:{s:5:"label";s:9:"image_miw";s:6:"widget";a:5:{s:6:"weight";s:2:"18";s:4:"type";s:9:"image_miw";s:6:"module";s:29:"multiupload_imagefield_widget";s:6:"active";i:1;s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}}s:8:"settings";a:10:{s:14:"file_directory";s:0:"";s:15:"file_extensions";s:16:"png gif jpg jpeg";s:12:"max_filesize";s:0:"";s:14:"max_resolution";s:0:"";s:14:"min_resolution";s:0:"";s:9:"alt_field";i:0;s:11:"title_field";i:0;s:13:"default_image";i:0;s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:5:"image";s:8:"settings";a:2:{s:11:"image_style";s:0:"";s:10:"image_link";s:0:"";}s:6:"module";s:5:"image";s:6:"weight";i:16;}}s:8:"required";i:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '94',
  'field_id' => '62',
  'field_name' => 'field_event',
  'entity_type' => 'node',
  'bundle' => 'forum',
  'data' => 'a:6:{s:5:"label";s:5:"event";s:6:"widget";a:5:{s:6:"weight";s:1:"2";s:4:"type";s:9:"date_text";s:6:"module";s:4:"date";s:6:"active";i:1;s:8:"settings";a:7:{s:12:"input_format";s:13:"m/d/Y - H:i:s";s:19:"input_format_custom";s:0:"";s:10:"year_range";s:5:"-3:+3";s:9:"increment";i:1;s:14:"label_position";s:5:"above";s:10:"text_parts";a:0:{}s:11:"no_fieldset";i:0;}}s:8:"settings";a:6:{s:13:"default_value";s:3:"now";s:18:"default_value_code";s:0:"";s:14:"default_value2";s:4:"same";s:19:"default_value_code2";s:0:"";s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:12:"date_default";s:8:"settings";a:6:{s:11:"format_type";s:4:"long";s:15:"multiple_number";s:0:"";s:13:"multiple_from";s:0:"";s:11:"multiple_to";s:0:"";s:6:"fromto";s:4:"both";s:19:"show_remaining_days";b:0;}s:6:"module";s:4:"date";s:6:"weight";i:12;}}s:8:"required";i:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->execute();
$connection->schema()->createTable('field_data_body', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'body_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'body_summary' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'body_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_data_body')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'body_value',
  'body_summary',
  'body_format',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'et',
  'deleted' => '0',
  'entity_id' => '11',
  'revision_id' => '18',
  'language' => 'und',
  'delta' => '0',
  'body_value' => '2nd',
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->execute();
$connection->schema()->createTable('field_data_comment_body', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'comment_body_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'comment_body_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('field_data_field_boolean', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_boolean_value' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('field_data_field_file', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_file_fid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_file_display' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
      'unsigned' => TRUE,
    ),
    'field_file_description' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_data_field_file')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'field_file_fid',
  'field_file_display',
  'field_file_description',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '0',
  'field_file_fid' => '2',
  'field_file_display' => '1',
  'field_file_description' => 'file desc',
))
->execute();
$connection->schema()->createTable('field_data_field_image', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_image_fid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_image_alt' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '512',
    ),
    'field_image_title' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '1024',
    ),
    'field_image_width' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_image_height' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('field_data_field_integer', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_integer_value' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_data_field_integer')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'field_integer_value',
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'en',
  'delta' => '0',
  'field_integer_value' => '1000000',
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'fr',
  'delta' => '0',
  'field_integer_value' => '2000000',
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'is',
  'delta' => '0',
  'field_integer_value' => '3000000',
))
->execute();
$connection->schema()->createTable('field_data_field_link', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_link_url' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '2048',
    ),
    'field_link_title' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'field_link_attributes' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('field_data_subject_field', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'subject_field_value' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'subject_field_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'subject_field_format' => array(
      array(
        'subject_field_format',
        '191',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_data_subject_field')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'subject_field_value',
  'subject_field_format',
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'en',
  'delta' => '0',
  'subject_field_value' => 'Subject field in English',
  'subject_field_format' => NULL,
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'fr',
  'delta' => '0',
  'subject_field_value' => 'Subject field in French',
  'subject_field_format' => NULL,
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'is',
  'delta' => '0',
  'subject_field_value' => 'Subject field in Icelandic',
  'subject_field_format' => NULL,
))
->execute();
$connection->schema()->createTable('field_data_title_field', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'title_field_value' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'title_field_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'title_field_format' => array(
      array(
        'title_field_format',
        '191',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_data_title_field')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'title_field_value',
  'title_field_format',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'en',
  'delta' => '0',
  'title_field_value' => 'An English Node',
  'title_field_format' => NULL,
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'fr',
  'delta' => '0',
  'title_field_value' => 'A French Node',
  'title_field_format' => NULL,
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'is',
  'delta' => '0',
  'title_field_value' => 'An Icelandic Node',
  'title_field_format' => NULL,
))
->execute();
$connection->schema()->createTable('field_revision_body', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'body_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'body_summary' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'body_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'revision_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_revision_body')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'body_value',
  'body_summary',
  'body_format',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'et',
  'deleted' => '0',
  'entity_id' => '11',
  'revision_id' => '15',
  'language' => 'und',
  'delta' => '0',
  'body_value' => '1st',
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'et',
  'deleted' => '0',
  'entity_id' => '11',
  'revision_id' => '16',
  'language' => 'und',
  'delta' => '0',
  'body_value' => '1st',
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'et',
  'deleted' => '0',
  'entity_id' => '11',
  'revision_id' => '17',
  'language' => 'und',
  'delta' => '0',
  'body_value' => '2nd',
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'et',
  'deleted' => '0',
  'entity_id' => '11',
  'revision_id' => '18',
  'language' => 'und',
  'delta' => '0',
  'body_value' => '2nd',
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->execute();
$connection->schema()->createTable('field_revision_comment_body', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'comment_body_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'comment_body_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'revision_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('field_revision_field_boolean', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_boolean_value' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'revision_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('field_revision_field_file', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_file_fid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_file_display' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
      'unsigned' => TRUE,
    ),
    'field_file_description' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'revision_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_revision_field_file')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'field_file_fid',
  'field_file_display',
  'field_file_description',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '0',
  'field_file_fid' => '2',
  'field_file_display' => '1',
  'field_file_description' => 'file desc',
))
->execute();
$connection->schema()->createTable('field_revision_field_image', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_image_fid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_image_alt' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '512',
    ),
    'field_image_title' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '1024',
    ),
    'field_image_width' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_image_height' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'revision_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('field_revision_field_integer', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_integer_value' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'revision_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_revision_field_integer')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'field_integer_value',
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'en',
  'delta' => '0',
  'field_integer_value' => '1000000',
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'fr',
  'delta' => '0',
  'field_integer_value' => '2000000',
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'is',
  'delta' => '0',
  'field_integer_value' => '3000000',
))
->execute();
$connection->schema()->createTable('field_revision_field_link', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_link_url' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '2048',
    ),
    'field_link_title' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'field_link_attributes' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'deleted',
    'entity_id',
    'revision_id',
    'language',
    'delta',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('field_revision_subject_field', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'subject_field_value' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'subject_field_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'subject_field_format' => array(
      array(
        'subject_field_format',
        '191',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_revision_subject_field')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'subject_field_value',
  'subject_field_format',
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'en',
  'delta' => '0',
  'subject_field_value' => 'Subject field in English',
  'subject_field_format' => NULL,
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'fr',
  'delta' => '0',
  'subject_field_value' => 'Subject field in French',
  'subject_field_format' => NULL,
))
->values(array(
  'entity_type' => 'comment',
  'bundle' => 'comment_node_test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'is',
  'delta' => '0',
  'subject_field_value' => 'Subject field in Icelandic',
  'subject_field_format' => NULL,
))
->execute();
$connection->schema()->createTable('field_revision_title_field', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'entity_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'title_field_value' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'title_field_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'title_field_format' => array(
      array(
        'title_field_format',
        '191',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('field_revision_title_field')
->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'title_field_value',
  'title_field_format',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'en',
  'delta' => '0',
  'title_field_value' => 'An English Node',
  'title_field_format' => NULL,
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'fr',
  'delta' => '0',
  'title_field_value' => 'A French Node',
  'title_field_format' => NULL,
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'test_content_type',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'is',
  'delta' => '0',
  'title_field_value' => 'An Icelandic Node',
  'title_field_format' => NULL,
))
->execute();
$connection->schema()->createTable('file_managed', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'filename' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'uri' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'filemime' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'filesize' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('file_usage', array(
  'fields' => array(
    'fid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'id' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'count' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'fid',
    'module',
    'type',
    'id',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('filter', array(
  'fields' => array(
    'format' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'settings' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'format',
    'name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('filter')
->fields(array(
  'format',
  'module',
  'name',
  'weight',
  'status',
  'settings',
))
->values(array(
  'format' => 'custom_text_format',
  'module' => 'filter',
  'name' => 'filter_autop',
  'weight' => '0',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'custom_text_format',
  'module' => 'filter',
  'name' => 'filter_html',
  'weight' => '-10',
  'status' => '1',
  'settings' => 'a:3:{s:12:"allowed_html";s:82:"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd> <table>";s:16:"filter_html_help";i:1;s:20:"filter_html_nofollow";i:1;}',
))
->values(array(
  'format' => 'custom_text_format',
  'module' => 'filter',
  'name' => 'filter_htmlcorrector',
  'weight' => '10',
  'status' => '0',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'custom_text_format',
  'module' => 'filter',
  'name' => 'filter_html_escape',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'custom_text_format',
  'module' => 'filter',
  'name' => 'filter_url',
  'weight' => '0',
  'status' => '0',
  'settings' => 'a:1:{s:17:"filter_url_length";s:2:"72";}',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_autop',
  'weight' => '2',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_html',
  'weight' => '1',
  'status' => '1',
  'settings' => 'a:3:{s:12:"allowed_html";s:37:"<div> <span> <ul> <li> <ol> <a> <img>";s:16:"filter_html_help";i:1;s:20:"filter_html_nofollow";i:0;}',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_htmlcorrector',
  'weight' => '10',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_html_escape',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_url',
  'weight' => '0',
  'status' => '1',
  'settings' => 'a:1:{s:17:"filter_url_length";s:3:"128";}',
))
->values(array(
  'format' => 'full_html',
  'module' => 'filter',
  'name' => 'filter_autop',
  'weight' => '1',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'full_html',
  'module' => 'filter',
  'name' => 'filter_html',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:3:{s:12:"allowed_html";s:74:"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd>";s:16:"filter_html_help";i:1;s:20:"filter_html_nofollow";i:0;}',
))
->values(array(
  'format' => 'full_html',
  'module' => 'filter',
  'name' => 'filter_htmlcorrector',
  'weight' => '10',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'full_html',
  'module' => 'filter',
  'name' => 'filter_html_escape',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'full_html',
  'module' => 'filter',
  'name' => 'filter_url',
  'weight' => '0',
  'status' => '1',
  'settings' => 'a:1:{s:17:"filter_url_length";i:72;}',
))
->values(array(
  'format' => 'php_code',
  'module' => 'filter',
  'name' => 'filter_autop',
  'weight' => '0',
  'status' => '0',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'php_code',
  'module' => 'filter',
  'name' => 'filter_html',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:3:{s:12:"allowed_html";s:74:"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd>";s:16:"filter_html_help";i:1;s:20:"filter_html_nofollow";i:0;}',
))
->values(array(
  'format' => 'php_code',
  'module' => 'filter',
  'name' => 'filter_htmlcorrector',
  'weight' => '10',
  'status' => '0',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'php_code',
  'module' => 'filter',
  'name' => 'filter_html_escape',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'php_code',
  'module' => 'filter',
  'name' => 'filter_url',
  'weight' => '0',
  'status' => '0',
  'settings' => 'a:1:{s:17:"filter_url_length";i:72;}',
))
->values(array(
  'format' => 'php_code',
  'module' => 'php',
  'name' => 'php_code',
  'weight' => '0',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_autop',
  'weight' => '2',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_html',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:3:{s:12:"allowed_html";s:74:"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd>";s:16:"filter_html_help";i:1;s:20:"filter_html_nofollow";i:0;}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_htmlcorrector',
  'weight' => '10',
  'status' => '0',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_html_escape',
  'weight' => '0',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_url',
  'weight' => '1',
  'status' => '1',
  'settings' => 'a:1:{s:17:"filter_url_length";i:72;}',
))
->execute();
$connection->schema()->createTable('filter_format', array(
  'fields' => array(
    'format' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
      'unsigned' => TRUE,
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'format',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('filter_format')
->fields(array(
  'format',
  'name',
  'cache',
  'status',
  'weight',
))
->values(array(
  'format' => 'custom_text_format',
  'name' => 'Custom Text format',
  'cache' => '1',
  'status' => '1',
  'weight' => '0',
))
->values(array(
  'format' => 'filtered_html',
  'name' => 'Filtered HTML',
  'cache' => '1',
  'status' => '1',
  'weight' => '0',
))
->values(array(
  'format' => 'full_html',
  'name' => 'Full HTML',
  'cache' => '1',
  'status' => '1',
  'weight' => '1',
))
->values(array(
  'format' => 'php_code',
  'name' => 'PHP code',
  'cache' => '0',
  'status' => '0',
  'weight' => '11',
))
->values(array(
  'format' => 'plain_text',
  'name' => 'Plain text',
  'cache' => '1',
  'status' => '1',
  'weight' => '10',
))
->execute();
$connection->schema()->createTable('flood', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'event' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'identifier' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'expiration' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('history', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'uid',
    'nid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('image_effects', array(
  'fields' => array(
    'ieid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'isid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'ieid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('image_effects')
->fields(array(
  'ieid',
  'isid',
  'weight',
  'name',
  'data',
))
->values(array(
  'ieid' => '3',
  'isid' => '1',
  'weight' => '1',
  'name' => 'image_scale_and_crop',
  'data' => 'a:2:{s:5:"width";s:2:"55";s:6:"height";s:2:"55";}',
))
->values(array(
  'ieid' => '4',
  'isid' => '1',
  'weight' => '2',
  'name' => 'image_desaturate',
  'data' => 'a:0:{}',
))
->values(array(
  'ieid' => '5',
  'isid' => '2',
  'weight' => '1',
  'name' => 'image_resize',
  'data' => 'a:2:{s:5:"width";s:2:"55";s:6:"height";s:3:"100";}',
))
->values(array(
  'ieid' => '6',
  'isid' => '2',
  'weight' => '2',
  'name' => 'image_rotate',
  'data' => 'a:3:{s:7:"degrees";s:2:"45";s:7:"bgcolor";s:7:"#FFFFFF";s:6:"random";i:0;}',
))
->values(array(
  'ieid' => '7',
  'isid' => '3',
  'weight' => '1',
  'name' => 'image_scale',
  'data' => 'a:3:{s:5:"width";s:3:"150";s:6:"height";s:0:"";s:7:"upscale";i:0;}',
))
->values(array(
  'ieid' => '8',
  'isid' => '3',
  'weight' => '2',
  'name' => 'image_crop',
  'data' => 'a:3:{s:5:"width";s:2:"50";s:6:"height";s:2:"50";s:6:"anchor";s:8:"left-top";}',
))
->execute();
$connection->schema()->createTable('image_styles', array(
  'fields' => array(
    'isid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'isid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('image_styles')
->fields(array(
  'isid',
  'name',
  'label',
))
->values(array(
  'isid' => '1',
  'name' => 'custom_image_style_1',
  'label' => 'Custom image style 1',
))
->values(array(
  'isid' => '2',
  'name' => 'custom_image_style_2',
  'label' => 'Custom image style 2',
))
->values(array(
  'isid' => '3',
  'name' => 'custom_image_style_3',
  'label' => 'Custom image style 3',
))
->execute();
$connection->schema()->createTable('menu_custom', array(
  'fields' => array(
    'menu_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'menu_name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('menu_custom')
->fields(array(
  'menu_name',
  'title',
  'description',
))
->values(array(
  'menu_name' => 'main-menu',
  'title' => 'Main menu',
  'description' => 'The <em>Main</em> menu is used on many sites to show the major sections of the site, often in a top navigation bar.',
))
->values(array(
  'menu_name' => 'management',
  'title' => 'Management',
  'description' => 'The <em>Management</em> menu contains links for administrative tasks.',
))
->values(array(
  'menu_name' => 'menu-fixedlang',
  'title' => 'FixedLang',
  'description' => '',
))
->values(array(
  'menu_name' => 'navigation',
  'title' => 'Navigation',
  'description' => 'The <em>Navigation</em> menu contains links intended for site visitors. Links are added to the <em>Navigation</em> menu automatically by some modules.',
))
->values(array(
  'menu_name' => 'user-menu',
  'title' => 'User menu',
  'description' => "The <em>User</em> menu contains links related to the user's account, as well as the 'Log out' link.",
))
->execute();
$connection->schema()->createTable('menu_links', array(
  'fields' => array(
    'menu_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'mlid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'plid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'link_path' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'router_path' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'link_title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'options' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => 'system',
    ),
    'hidden' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'external' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'has_children' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'expanded' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'depth' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'customized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'p1' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p2' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p3' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p4' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p5' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p6' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p7' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p8' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p9' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'updated' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'mlid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('menu_links')
->fields(array(
  'menu_name',
  'mlid',
  'plid',
  'link_path',
  'router_path',
  'link_title',
  'options',
  'module',
  'hidden',
  'external',
  'has_children',
  'expanded',
  'weight',
  'depth',
  'customized',
  'p1',
  'p2',
  'p3',
  'p4',
  'p5',
  'p6',
  'p7',
  'p8',
  'p9',
  'updated',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '1',
  'plid' => '0',
  'link_path' => 'admin',
  'router_path' => 'admin',
  'link_title' => 'Administration',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '9',
  'depth' => '1',
  'customized' => '0',
  'p1' => '1',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '2',
  'plid' => '0',
  'link_path' => 'user',
  'router_path' => 'user',
  'link_title' => 'User account',
  'options' => 'a:1:{s:5:"alter";b:1;}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '1',
  'customized' => '0',
  'p1' => '2',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '3',
  'plid' => '0',
  'link_path' => 'comment/%',
  'router_path' => 'comment/%',
  'link_title' => 'Comment permalink',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '3',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '4',
  'plid' => '0',
  'link_path' => 'filter/tips',
  'router_path' => 'filter/tips',
  'link_title' => 'Compose tips',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '4',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '5',
  'plid' => '0',
  'link_path' => 'node/%',
  'router_path' => 'node/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '5',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '6',
  'plid' => '0',
  'link_path' => 'node/add',
  'router_path' => 'node/add',
  'link_title' => 'Add content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '6',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '7',
  'plid' => '1',
  'link_path' => 'admin/appearance',
  'router_path' => 'admin/appearance',
  'link_title' => 'Appearance',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:33:"Select and configure your themes.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-6',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '8',
  'plid' => '1',
  'link_path' => 'admin/config',
  'router_path' => 'admin/config',
  'link_title' => 'Configuration',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:20:"Administer settings.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '9',
  'plid' => '1',
  'link_path' => 'admin/content',
  'router_path' => 'admin/content',
  'link_title' => 'Content',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:32:"Administer content and comments.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '9',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '10',
  'plid' => '2',
  'link_path' => 'user/register',
  'router_path' => 'user/register',
  'link_title' => 'Create new account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '10',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '12',
  'plid' => '1',
  'link_path' => 'admin/index',
  'router_path' => 'admin/index',
  'link_title' => 'Index',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-18',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '12',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '13',
  'plid' => '2',
  'link_path' => 'user/login',
  'router_path' => 'user/login',
  'link_title' => 'Log in',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '13',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '14',
  'plid' => '0',
  'link_path' => 'user/logout',
  'router_path' => 'user/logout',
  'link_title' => 'Log out',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '1',
  'customized' => '0',
  'p1' => '14',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '15',
  'plid' => '1',
  'link_path' => 'admin/modules',
  'router_path' => 'admin/modules',
  'link_title' => 'Modules',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:26:"Extend site functionality.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '16',
  'plid' => '0',
  'link_path' => 'user/%',
  'router_path' => 'user/%',
  'link_title' => 'My account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '16',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '17',
  'plid' => '1',
  'link_path' => 'admin/people',
  'router_path' => 'admin/people',
  'link_title' => 'People',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Manage user accounts, roles, and permissions.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-4',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '18',
  'plid' => '1',
  'link_path' => 'admin/reports',
  'router_path' => 'admin/reports',
  'link_title' => 'Reports',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:34:"View reports, updates, and errors.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '19',
  'plid' => '2',
  'link_path' => 'user/password',
  'router_path' => 'user/password',
  'link_title' => 'Request new password',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '19',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '20',
  'plid' => '1',
  'link_path' => 'admin/structure',
  'router_path' => 'admin/structure',
  'link_title' => 'Structure',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Administer blocks, content types, menus, etc.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-8',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '21',
  'plid' => '1',
  'link_path' => 'admin/tasks',
  'router_path' => 'admin/tasks',
  'link_title' => 'Tasks',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '21',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '22',
  'plid' => '0',
  'link_path' => 'comment/reply/%',
  'router_path' => 'comment/reply/%',
  'link_title' => 'Add new comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '22',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '23',
  'plid' => '3',
  'link_path' => 'comment/%/approve',
  'router_path' => 'comment/%/approve',
  'link_title' => 'Approve',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '2',
  'customized' => '0',
  'p1' => '3',
  'p2' => '23',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '24',
  'plid' => '3',
  'link_path' => 'comment/%/delete',
  'router_path' => 'comment/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '3',
  'p2' => '24',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '25',
  'plid' => '3',
  'link_path' => 'comment/%/edit',
  'router_path' => 'comment/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '3',
  'p2' => '25',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '26',
  'plid' => '3',
  'link_path' => 'comment/%/view',
  'router_path' => 'comment/%/view',
  'link_title' => 'View comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '3',
  'p2' => '26',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '27',
  'plid' => '17',
  'link_path' => 'admin/people/create',
  'router_path' => 'admin/people/create',
  'link_title' => 'Add user',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '27',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '28',
  'plid' => '20',
  'link_path' => 'admin/structure/block',
  'router_path' => 'admin/structure/block',
  'link_title' => 'Blocks',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:79:\"Configure what block content appears in your site's sidebars and other regions.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '29',
  'plid' => '16',
  'link_path' => 'user/%/cancel',
  'router_path' => 'user/%/cancel',
  'link_title' => 'Cancel account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '16',
  'p2' => '29',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '30',
  'plid' => '9',
  'link_path' => 'admin/content/comment',
  'router_path' => 'admin/content/comment',
  'link_title' => 'Comments',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:59:"List and edit site comments and the comment approval queue.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '9',
  'p3' => '30',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '32',
  'plid' => '9',
  'link_path' => 'admin/content/node',
  'router_path' => 'admin/content/node',
  'link_title' => 'Content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '9',
  'p3' => '32',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '33',
  'plid' => '8',
  'link_path' => 'admin/config/content',
  'router_path' => 'admin/config/content',
  'link_title' => 'Content authoring',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:53:"Settings related to formatting and authoring content.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '33',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '34',
  'plid' => '20',
  'link_path' => 'admin/structure/types',
  'router_path' => 'admin/structure/types',
  'link_title' => 'Content types',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:92:"Manage content types, including default status, front page promotion, comment settings, etc.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '36',
  'plid' => '5',
  'link_path' => 'node/%/delete',
  'router_path' => 'node/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '36',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '37',
  'plid' => '8',
  'link_path' => 'admin/config/development',
  'router_path' => 'admin/config/development',
  'link_title' => 'Development',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:18:"Development tools.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '37',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '38',
  'plid' => '16',
  'link_path' => 'user/%/edit',
  'router_path' => 'user/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '16',
  'p2' => '38',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '39',
  'plid' => '5',
  'link_path' => 'node/%/edit',
  'router_path' => 'node/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '39',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '40',
  'plid' => '15',
  'link_path' => 'admin/modules/list',
  'router_path' => 'admin/modules/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '40',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '41',
  'plid' => '17',
  'link_path' => 'admin/people/people',
  'router_path' => 'admin/people/people',
  'link_title' => 'List',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:50:"Find and manage people interacting with your site.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '41',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '42',
  'plid' => '7',
  'link_path' => 'admin/appearance/list',
  'router_path' => 'admin/appearance/list',
  'link_title' => 'List',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:31:"Select and configure your theme";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-1',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '42',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '43',
  'plid' => '8',
  'link_path' => 'admin/config/media',
  'router_path' => 'admin/config/media',
  'link_title' => 'Media',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:12:"Media tools.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '44',
  'plid' => '20',
  'link_path' => 'admin/structure/menu',
  'router_path' => 'admin/structure/menu',
  'link_title' => 'Menus',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:86:"Add new menus to your site, edit existing menus, and rename and reorganize menu links.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '45',
  'plid' => '8',
  'link_path' => 'admin/config/people',
  'router_path' => 'admin/config/people',
  'link_title' => 'People',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:24:"Configure user accounts.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '46',
  'plid' => '17',
  'link_path' => 'admin/people/permissions',
  'router_path' => 'admin/people/permissions',
  'link_title' => 'Permissions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:64:"Determine access to features by selecting permissions for roles.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '46',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '48',
  'plid' => '8',
  'link_path' => 'admin/config/regional',
  'router_path' => 'admin/config/regional',
  'link_title' => 'Regional and language',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:48:"Regional settings, localization and translation.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '49',
  'plid' => '5',
  'link_path' => 'node/%/revisions',
  'router_path' => 'node/%/revisions',
  'link_title' => 'Revisions',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '49',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '50',
  'plid' => '8',
  'link_path' => 'admin/config/search',
  'router_path' => 'admin/config/search',
  'link_title' => 'Search and metadata',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:36:"Local site search, metadata and SEO.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '51',
  'plid' => '7',
  'link_path' => 'admin/appearance/settings',
  'router_path' => 'admin/appearance/settings',
  'link_title' => 'Settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:46:"Configure default and theme specific settings.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '51',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '52',
  'plid' => '18',
  'link_path' => 'admin/reports/status',
  'router_path' => 'admin/reports/status',
  'link_title' => 'Status report',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:74:\"Get a status report about your site's operation and any detected problems.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-60',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '52',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '53',
  'plid' => '8',
  'link_path' => 'admin/config/system',
  'router_path' => 'admin/config/system',
  'link_title' => 'System',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:37:"General system related configuration.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '53',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '56',
  'plid' => '15',
  'link_path' => 'admin/modules/uninstall',
  'router_path' => 'admin/modules/uninstall',
  'link_title' => 'Uninstall',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '56',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '57',
  'plid' => '8',
  'link_path' => 'admin/config/user-interface',
  'router_path' => 'admin/config/user-interface',
  'link_title' => 'User interface',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:38:"Tools that enhance the user interface.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '57',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '58',
  'plid' => '5',
  'link_path' => 'node/%/view',
  'router_path' => 'node/%/view',
  'link_title' => 'View',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '58',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '59',
  'plid' => '16',
  'link_path' => 'user/%/view',
  'router_path' => 'user/%/view',
  'link_title' => 'View',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '16',
  'p2' => '59',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '60',
  'plid' => '8',
  'link_path' => 'admin/config/services',
  'router_path' => 'admin/config/services',
  'link_title' => 'Web services',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:30:"Tools related to web services.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '60',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '61',
  'plid' => '8',
  'link_path' => 'admin/config/workflow',
  'router_path' => 'admin/config/workflow',
  'link_title' => 'Workflow',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Content workflow, editorial workflow tools.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '61',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '66',
  'plid' => '45',
  'link_path' => 'admin/config/people/accounts',
  'router_path' => 'admin/config/people/accounts',
  'link_title' => 'Account settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:109:"Configure default behavior of users, including registration requirements, e-mails, fields, and user pictures.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '67',
  'plid' => '53',
  'link_path' => 'admin/config/system/actions',
  'router_path' => 'admin/config/system/actions',
  'link_title' => 'Actions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:41:"Manage the actions defined for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '53',
  'p4' => '67',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '68',
  'plid' => '28',
  'link_path' => 'admin/structure/block/add',
  'router_path' => 'admin/structure/block/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '68',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '69',
  'plid' => '34',
  'link_path' => 'admin/structure/types/add',
  'router_path' => 'admin/structure/types/add',
  'link_title' => 'Add content type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '69',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '70',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/add',
  'router_path' => 'admin/structure/menu/add',
  'link_title' => 'Add menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '70',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '71',
  'plid' => '51',
  'link_path' => 'admin/appearance/settings/bartik',
  'router_path' => 'admin/appearance/settings/bartik',
  'link_title' => 'Bartik',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '51',
  'p4' => '71',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '72',
  'plid' => '50',
  'link_path' => 'admin/config/search/clean-urls',
  'router_path' => 'admin/config/search/clean-urls',
  'link_title' => 'Clean URLs',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Enable or disable clean URLs for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '72',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '73',
  'plid' => '53',
  'link_path' => 'admin/config/system/cron',
  'router_path' => 'admin/config/system/cron',
  'link_title' => 'Cron',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:40:"Manage automatic site maintenance tasks.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '53',
  'p4' => '73',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '74',
  'plid' => '48',
  'link_path' => 'admin/config/regional/date-time',
  'router_path' => 'admin/config/regional/date-time',
  'link_title' => 'Date and time',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:44:"Configure display formats for date and time.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '76',
  'plid' => '43',
  'link_path' => 'admin/config/media/file-system',
  'router_path' => 'admin/config/media/file-system',
  'link_title' => 'File system',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:68:"Tell Drupal where to store uploaded files and how they are accessed.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '76',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '78',
  'plid' => '51',
  'link_path' => 'admin/appearance/settings/garland',
  'router_path' => 'admin/appearance/settings/garland',
  'link_title' => 'Garland',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '51',
  'p4' => '78',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '79',
  'plid' => '51',
  'link_path' => 'admin/appearance/settings/global',
  'router_path' => 'admin/appearance/settings/global',
  'link_title' => 'Global settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-1',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '51',
  'p4' => '79',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '80',
  'plid' => '45',
  'link_path' => 'admin/config/people/ip-blocking',
  'router_path' => 'admin/config/people/ip-blocking',
  'link_title' => 'IP address blocking',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:28:"Manage blocked IP addresses.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '80',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '81',
  'plid' => '43',
  'link_path' => 'admin/config/media/image-toolkit',
  'router_path' => 'admin/config/media/image-toolkit',
  'link_title' => 'Image toolkit',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:74:"Choose which image toolkit to use if you have installed optional toolkits.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '81',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '82',
  'plid' => '40',
  'link_path' => 'admin/modules/list/confirm',
  'router_path' => 'admin/modules/list/confirm',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '40',
  'p4' => '82',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '83',
  'plid' => '34',
  'link_path' => 'admin/structure/types/list',
  'router_path' => 'admin/structure/types/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '83',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '84',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/list',
  'router_path' => 'admin/structure/menu/list',
  'link_title' => 'List menus',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '84',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '85',
  'plid' => '37',
  'link_path' => 'admin/config/development/logging',
  'router_path' => 'admin/config/development/logging',
  'link_title' => 'Logging and errors',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:154:\"Settings for logging and alerts modules. Various modules can route Drupal's system events to different destinations, such as syslog, database, email, etc.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '37',
  'p4' => '85',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '86',
  'plid' => '37',
  'link_path' => 'admin/config/development/maintenance',
  'router_path' => 'admin/config/development/maintenance',
  'link_title' => 'Maintenance mode',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:62:"Take the site offline for maintenance or bring it back online.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '37',
  'p4' => '86',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '89',
  'plid' => '37',
  'link_path' => 'admin/config/development/performance',
  'router_path' => 'admin/config/development/performance',
  'link_title' => 'Performance',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:101:"Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '37',
  'p4' => '89',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '90',
  'plid' => '46',
  'link_path' => 'admin/people/permissions/list',
  'router_path' => 'admin/people/permissions/list',
  'link_title' => 'Permissions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:64:"Determine access to features by selecting permissions for roles.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-8',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '46',
  'p4' => '90',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '93',
  'plid' => '30',
  'link_path' => 'admin/content/comment/new',
  'router_path' => 'admin/content/comment/new',
  'link_title' => 'Published comments',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '9',
  'p3' => '30',
  'p4' => '93',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '94',
  'plid' => '60',
  'link_path' => 'admin/config/services/rss-publishing',
  'router_path' => 'admin/config/services/rss-publishing',
  'link_title' => 'RSS publishing',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:114:"Configure the site description, the number of items per feed and whether feeds should be titles/teasers/full-text.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '60',
  'p4' => '94',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '95',
  'plid' => '48',
  'link_path' => 'admin/config/regional/settings',
  'router_path' => 'admin/config/regional/settings',
  'link_title' => 'Regional settings',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:54:\"Settings for the site's default time zone and country.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '95',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '96',
  'plid' => '46',
  'link_path' => 'admin/people/permissions/roles',
  'router_path' => 'admin/people/permissions/roles',
  'link_title' => 'Roles',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:30:"List, edit, or add user roles.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '46',
  'p4' => '96',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '97',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/settings',
  'router_path' => 'admin/structure/menu/settings',
  'link_title' => 'Settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '97',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '98',
  'plid' => '51',
  'link_path' => 'admin/appearance/settings/seven',
  'router_path' => 'admin/appearance/settings/seven',
  'link_title' => 'Seven',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '51',
  'p4' => '98',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '99',
  'plid' => '53',
  'link_path' => 'admin/config/system/site-information',
  'router_path' => 'admin/config/system/site-information',
  'link_title' => 'Site information',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:104:"Change site name, e-mail address, slogan, default front page, and number of posts per page, error pages.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '53',
  'p4' => '99',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '100',
  'plid' => '51',
  'link_path' => 'admin/appearance/settings/stark',
  'router_path' => 'admin/appearance/settings/stark',
  'link_title' => 'Stark',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '51',
  'p4' => '100',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '101',
  'plid' => '33',
  'link_path' => 'admin/config/content/formats',
  'router_path' => 'admin/config/content/formats',
  'link_title' => 'Text formats',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:127:"Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '33',
  'p4' => '101',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '102',
  'plid' => '30',
  'link_path' => 'admin/content/comment/approval',
  'router_path' => 'admin/content/comment/approval',
  'link_title' => 'Unapproved comments',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '9',
  'p3' => '30',
  'p4' => '102',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '103',
  'plid' => '56',
  'link_path' => 'admin/modules/uninstall/confirm',
  'router_path' => 'admin/modules/uninstall/confirm',
  'link_title' => 'Uninstall',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '56',
  'p4' => '103',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '104',
  'plid' => '38',
  'link_path' => 'user/%/edit/account',
  'router_path' => 'user/%/edit/account',
  'link_title' => 'Account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '16',
  'p2' => '38',
  'p3' => '104',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '105',
  'plid' => '101',
  'link_path' => 'admin/config/content/formats/%',
  'router_path' => 'admin/config/content/formats/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '33',
  'p4' => '101',
  'p5' => '105',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '110',
  'plid' => '101',
  'link_path' => 'admin/config/content/formats/add',
  'router_path' => 'admin/config/content/formats/add',
  'link_title' => 'Add text format',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '33',
  'p4' => '101',
  'p5' => '110',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '111',
  'plid' => '28',
  'link_path' => 'admin/structure/block/list/bartik',
  'router_path' => 'admin/structure/block/list/bartik',
  'link_title' => 'Bartik',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '111',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '112',
  'plid' => '67',
  'link_path' => 'admin/config/system/actions/configure',
  'router_path' => 'admin/config/system/actions/configure',
  'link_title' => 'Configure an advanced action',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '53',
  'p4' => '67',
  'p5' => '112',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '113',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/manage/%',
  'router_path' => 'admin/structure/menu/manage/%',
  'link_title' => 'Customize menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '113',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '114',
  'plid' => '34',
  'link_path' => 'admin/structure/types/manage/%',
  'router_path' => 'admin/structure/types/manage/%',
  'link_title' => 'Edit content type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '116',
  'plid' => '74',
  'link_path' => 'admin/config/regional/date-time/formats',
  'router_path' => 'admin/config/regional/date-time/formats',
  'link_title' => 'Formats',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:51:"Configure display format strings for date and time.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-9',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '116',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '117',
  'plid' => '28',
  'link_path' => 'admin/structure/block/list/garland',
  'router_path' => 'admin/structure/block/list/garland',
  'link_title' => 'Garland',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '117',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '118',
  'plid' => '101',
  'link_path' => 'admin/config/content/formats/list',
  'router_path' => 'admin/config/content/formats/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '33',
  'p4' => '101',
  'p5' => '118',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '119',
  'plid' => '67',
  'link_path' => 'admin/config/system/actions/manage',
  'router_path' => 'admin/config/system/actions/manage',
  'link_title' => 'Manage actions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:41:"Manage the actions defined for your site.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '53',
  'p4' => '67',
  'p5' => '119',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '124',
  'plid' => '66',
  'link_path' => 'admin/config/people/accounts/settings',
  'router_path' => 'admin/config/people/accounts/settings',
  'link_title' => 'Settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '124',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '125',
  'plid' => '28',
  'link_path' => 'admin/structure/block/list/seven',
  'router_path' => 'admin/structure/block/list/seven',
  'link_title' => 'Seven',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '125',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '126',
  'plid' => '28',
  'link_path' => 'admin/structure/block/list/stark',
  'router_path' => 'admin/structure/block/list/stark',
  'link_title' => 'Stark',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '126',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '127',
  'plid' => '74',
  'link_path' => 'admin/config/regional/date-time/types',
  'router_path' => 'admin/config/regional/date-time/types',
  'link_title' => 'Types',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:44:"Configure display formats for date and time.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '127',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '128',
  'plid' => '49',
  'link_path' => 'node/%/revisions/%/delete',
  'router_path' => 'node/%/revisions/%/delete',
  'link_title' => 'Delete earlier revision',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '5',
  'p2' => '49',
  'p3' => '128',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '129',
  'plid' => '49',
  'link_path' => 'node/%/revisions/%/revert',
  'router_path' => 'node/%/revisions/%/revert',
  'link_title' => 'Revert to earlier revision',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '5',
  'p2' => '49',
  'p3' => '129',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '130',
  'plid' => '49',
  'link_path' => 'node/%/revisions/%/view',
  'router_path' => 'node/%/revisions/%/view',
  'link_title' => 'Revisions',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '5',
  'p2' => '49',
  'p3' => '130',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '136',
  'plid' => '117',
  'link_path' => 'admin/structure/block/list/garland/add',
  'router_path' => 'admin/structure/block/list/garland/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '117',
  'p5' => '136',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '141',
  'plid' => '125',
  'link_path' => 'admin/structure/block/list/seven/add',
  'router_path' => 'admin/structure/block/list/seven/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '125',
  'p5' => '141',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '142',
  'plid' => '126',
  'link_path' => 'admin/structure/block/list/stark/add',
  'router_path' => 'admin/structure/block/list/stark/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '126',
  'p5' => '142',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '143',
  'plid' => '127',
  'link_path' => 'admin/config/regional/date-time/types/add',
  'router_path' => 'admin/config/regional/date-time/types/add',
  'link_title' => 'Add date type',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:18:"Add new date type.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '127',
  'p6' => '143',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '144',
  'plid' => '116',
  'link_path' => 'admin/config/regional/date-time/formats/add',
  'router_path' => 'admin/config/regional/date-time/formats/add',
  'link_title' => 'Add format',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Allow users to add additional date formats.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '116',
  'p6' => '144',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '145',
  'plid' => '113',
  'link_path' => 'admin/structure/menu/manage/%/add',
  'router_path' => 'admin/structure/menu/manage/%/add',
  'link_title' => 'Add link',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '113',
  'p5' => '145',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '146',
  'plid' => '28',
  'link_path' => 'admin/structure/block/manage/%/%',
  'router_path' => 'admin/structure/block/manage/%/%',
  'link_title' => 'Configure block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '146',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '147',
  'plid' => '29',
  'link_path' => 'user/%/cancel/confirm/%/%',
  'router_path' => 'user/%/cancel/confirm/%/%',
  'link_title' => 'Confirm account cancellation',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '16',
  'p2' => '29',
  'p3' => '147',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '148',
  'plid' => '114',
  'link_path' => 'admin/structure/types/manage/%/delete',
  'router_path' => 'admin/structure/types/manage/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '148',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '149',
  'plid' => '80',
  'link_path' => 'admin/config/people/ip-blocking/delete/%',
  'router_path' => 'admin/config/people/ip-blocking/delete/%',
  'link_title' => 'Delete IP address',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '80',
  'p5' => '149',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '150',
  'plid' => '67',
  'link_path' => 'admin/config/system/actions/delete/%',
  'router_path' => 'admin/config/system/actions/delete/%',
  'link_title' => 'Delete action',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:17:"Delete an action.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '53',
  'p4' => '67',
  'p5' => '150',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '151',
  'plid' => '113',
  'link_path' => 'admin/structure/menu/manage/%/delete',
  'router_path' => 'admin/structure/menu/manage/%/delete',
  'link_title' => 'Delete menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '113',
  'p5' => '151',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '152',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/item/%/delete',
  'router_path' => 'admin/structure/menu/item/%/delete',
  'link_title' => 'Delete menu link',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '152',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '153',
  'plid' => '96',
  'link_path' => 'admin/people/permissions/roles/delete/%',
  'router_path' => 'admin/people/permissions/roles/delete/%',
  'link_title' => 'Delete role',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '46',
  'p4' => '96',
  'p5' => '153',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '154',
  'plid' => '105',
  'link_path' => 'admin/config/content/formats/%/disable',
  'router_path' => 'admin/config/content/formats/%/disable',
  'link_title' => 'Disable text format',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '33',
  'p4' => '101',
  'p5' => '105',
  'p6' => '154',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '155',
  'plid' => '114',
  'link_path' => 'admin/structure/types/manage/%/edit',
  'router_path' => 'admin/structure/types/manage/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '155',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '156',
  'plid' => '113',
  'link_path' => 'admin/structure/menu/manage/%/edit',
  'router_path' => 'admin/structure/menu/manage/%/edit',
  'link_title' => 'Edit menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '113',
  'p5' => '156',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '157',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/item/%/edit',
  'router_path' => 'admin/structure/menu/item/%/edit',
  'link_title' => 'Edit menu link',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '157',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '158',
  'plid' => '96',
  'link_path' => 'admin/people/permissions/roles/edit/%',
  'router_path' => 'admin/people/permissions/roles/edit/%',
  'link_title' => 'Edit role',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '46',
  'p4' => '96',
  'p5' => '158',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '159',
  'plid' => '113',
  'link_path' => 'admin/structure/menu/manage/%/list',
  'router_path' => 'admin/structure/menu/manage/%/list',
  'link_title' => 'List links',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '113',
  'p5' => '159',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '160',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/item/%/reset',
  'router_path' => 'admin/structure/menu/item/%/reset',
  'link_title' => 'Reset menu link',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '160',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '161',
  'plid' => '114',
  'link_path' => 'admin/structure/types/manage/%/comment/display',
  'router_path' => 'admin/structure/types/manage/%/comment/display',
  'link_title' => 'Comment display',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '4',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '161',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '162',
  'plid' => '114',
  'link_path' => 'admin/structure/types/manage/%/comment/fields',
  'router_path' => 'admin/structure/types/manage/%/comment/fields',
  'link_title' => 'Comment fields',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '3',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '162',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '163',
  'plid' => '146',
  'link_path' => 'admin/structure/block/manage/%/%/configure',
  'router_path' => 'admin/structure/block/manage/%/%/configure',
  'link_title' => 'Configure block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '146',
  'p5' => '163',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '164',
  'plid' => '146',
  'link_path' => 'admin/structure/block/manage/%/%/delete',
  'router_path' => 'admin/structure/block/manage/%/%/delete',
  'link_title' => 'Delete block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '146',
  'p5' => '164',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '165',
  'plid' => '116',
  'link_path' => 'admin/config/regional/date-time/formats/%/delete',
  'router_path' => 'admin/config/regional/date-time/formats/%/delete',
  'link_title' => 'Delete date format',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:47:"Allow users to delete a configured date format.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '116',
  'p6' => '165',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '166',
  'plid' => '127',
  'link_path' => 'admin/config/regional/date-time/types/%/delete',
  'router_path' => 'admin/config/regional/date-time/types/%/delete',
  'link_title' => 'Delete date type',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Allow users to delete a configured date type.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '127',
  'p6' => '166',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '167',
  'plid' => '116',
  'link_path' => 'admin/config/regional/date-time/formats/%/edit',
  'router_path' => 'admin/config/regional/date-time/formats/%/edit',
  'link_title' => 'Edit date format',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Allow users to edit a configured date format.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '116',
  'p6' => '167',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '168',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/manage/main-menu',
  'router_path' => 'admin/structure/menu/manage/%',
  'link_title' => 'Main menu',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '168',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '169',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/manage/management',
  'router_path' => 'admin/structure/menu/manage/%',
  'link_title' => 'Management',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '169',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '170',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/manage/navigation',
  'router_path' => 'admin/structure/menu/manage/%',
  'link_title' => 'Navigation',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '170',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '171',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/manage/user-menu',
  'router_path' => 'admin/structure/menu/manage/%',
  'link_title' => 'User menu',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '171',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '172',
  'plid' => '0',
  'link_path' => 'search',
  'router_path' => 'search',
  'link_title' => 'Search',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '172',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '173',
  'plid' => '172',
  'link_path' => 'search/node',
  'router_path' => 'search/node',
  'link_title' => 'Content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '172',
  'p2' => '173',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '176',
  'plid' => '0',
  'link_path' => 'taxonomy/term/%',
  'router_path' => 'taxonomy/term/%',
  'link_title' => 'Taxonomy term',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '176',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '177',
  'plid' => '173',
  'link_path' => 'search/node/%',
  'router_path' => 'search/node/%',
  'link_title' => 'Content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '172',
  'p2' => '173',
  'p3' => '177',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '178',
  'plid' => '18',
  'link_path' => 'admin/reports/fields',
  'router_path' => 'admin/reports/fields',
  'link_title' => 'Field list',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:39:"Overview of fields on all entity types.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '178',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '179',
  'plid' => '16',
  'link_path' => 'user/%/shortcuts',
  'router_path' => 'user/%/shortcuts',
  'link_title' => 'Shortcuts',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '16',
  'p2' => '179',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '180',
  'plid' => '20',
  'link_path' => 'admin/structure/taxonomy',
  'router_path' => 'admin/structure/taxonomy',
  'link_title' => 'Taxonomy',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:67:"Manage tagging, categorization, and classification of your content.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '210',
  'plid' => '176',
  'link_path' => 'taxonomy/term/%/edit',
  'router_path' => 'taxonomy/term/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '176',
  'p2' => '210',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '211',
  'plid' => '176',
  'link_path' => 'taxonomy/term/%/view',
  'router_path' => 'taxonomy/term/%/view',
  'link_title' => 'View',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '176',
  'p2' => '211',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '212',
  'plid' => '180',
  'link_path' => 'admin/structure/taxonomy/%',
  'router_path' => 'admin/structure/taxonomy/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '213',
  'plid' => '180',
  'link_path' => 'admin/structure/taxonomy/add',
  'router_path' => 'admin/structure/taxonomy/add',
  'link_title' => 'Add vocabulary',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '213',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '214',
  'plid' => '43',
  'link_path' => 'admin/config/media/image-styles',
  'router_path' => 'admin/config/media/image-styles',
  'link_title' => 'Image styles',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:78:"Configure styles that can be used for resizing or adjusting images on display.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '215',
  'plid' => '180',
  'link_path' => 'admin/structure/taxonomy/list',
  'router_path' => 'admin/structure/taxonomy/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '215',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '216',
  'plid' => '50',
  'link_path' => 'admin/config/search/settings',
  'router_path' => 'admin/config/search/settings',
  'link_title' => 'Search settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:67:"Configure relevance settings for search and other indexing options.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '216',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '217',
  'plid' => '57',
  'link_path' => 'admin/config/user-interface/shortcut',
  'router_path' => 'admin/config/user-interface/shortcut',
  'link_title' => 'Shortcuts',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:29:"Add and modify shortcut sets.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '57',
  'p4' => '217',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '218',
  'plid' => '50',
  'link_path' => 'admin/config/search/path',
  'router_path' => 'admin/config/search/path',
  'link_title' => 'URL aliases',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:46:\"Change your site's URL paths by aliasing them.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '218',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '219',
  'plid' => '218',
  'link_path' => 'admin/config/search/path/add',
  'router_path' => 'admin/config/search/path/add',
  'link_title' => 'Add alias',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '218',
  'p5' => '219',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '220',
  'plid' => '217',
  'link_path' => 'admin/config/user-interface/shortcut/add-set',
  'router_path' => 'admin/config/user-interface/shortcut/add-set',
  'link_title' => 'Add shortcut set',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '57',
  'p4' => '217',
  'p5' => '220',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '221',
  'plid' => '214',
  'link_path' => 'admin/config/media/image-styles/add',
  'router_path' => 'admin/config/media/image-styles/add',
  'link_title' => 'Add style',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:22:"Add a new image style.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '221',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '222',
  'plid' => '212',
  'link_path' => 'admin/structure/taxonomy/%/add',
  'router_path' => 'admin/structure/taxonomy/%/add',
  'link_title' => 'Add term',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '222',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '223',
  'plid' => '216',
  'link_path' => 'admin/config/search/settings/reindex',
  'router_path' => 'admin/config/search/settings/reindex',
  'link_title' => 'Clear index',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '216',
  'p5' => '223',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '224',
  'plid' => '212',
  'link_path' => 'admin/structure/taxonomy/%/edit',
  'router_path' => 'admin/structure/taxonomy/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '224',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '225',
  'plid' => '217',
  'link_path' => 'admin/config/user-interface/shortcut/%',
  'router_path' => 'admin/config/user-interface/shortcut/%',
  'link_title' => 'Edit shortcuts',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '57',
  'p4' => '217',
  'p5' => '225',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '226',
  'plid' => '212',
  'link_path' => 'admin/structure/taxonomy/%/list',
  'router_path' => 'admin/structure/taxonomy/%/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '226',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '227',
  'plid' => '218',
  'link_path' => 'admin/config/search/path/list',
  'router_path' => 'admin/config/search/path/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '218',
  'p5' => '227',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '228',
  'plid' => '214',
  'link_path' => 'admin/config/media/image-styles/list',
  'router_path' => 'admin/config/media/image-styles/list',
  'link_title' => 'List',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:42:"List the current image styles on the site.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '228',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '229',
  'plid' => '225',
  'link_path' => 'admin/config/user-interface/shortcut/%/add-link',
  'router_path' => 'admin/config/user-interface/shortcut/%/add-link',
  'link_title' => 'Add shortcut',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '57',
  'p4' => '217',
  'p5' => '225',
  'p6' => '229',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '230',
  'plid' => '218',
  'link_path' => 'admin/config/search/path/delete/%',
  'router_path' => 'admin/config/search/path/delete/%',
  'link_title' => 'Delete alias',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '218',
  'p5' => '230',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '231',
  'plid' => '225',
  'link_path' => 'admin/config/user-interface/shortcut/%/delete',
  'router_path' => 'admin/config/user-interface/shortcut/%/delete',
  'link_title' => 'Delete shortcut set',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '57',
  'p4' => '217',
  'p5' => '225',
  'p6' => '231',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '232',
  'plid' => '218',
  'link_path' => 'admin/config/search/path/edit/%',
  'router_path' => 'admin/config/search/path/edit/%',
  'link_title' => 'Edit alias',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '218',
  'p5' => '232',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '233',
  'plid' => '225',
  'link_path' => 'admin/config/user-interface/shortcut/%/edit',
  'router_path' => 'admin/config/user-interface/shortcut/%/edit',
  'link_title' => 'Edit set name',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '57',
  'p4' => '217',
  'p5' => '225',
  'p6' => '233',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '234',
  'plid' => '217',
  'link_path' => 'admin/config/user-interface/shortcut/link/%',
  'router_path' => 'admin/config/user-interface/shortcut/link/%',
  'link_title' => 'Edit shortcut',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '57',
  'p4' => '217',
  'p5' => '234',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '235',
  'plid' => '214',
  'link_path' => 'admin/config/media/image-styles/edit/%',
  'router_path' => 'admin/config/media/image-styles/edit/%',
  'link_title' => 'Edit style',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:25:"Configure an image style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '235',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '236',
  'plid' => '225',
  'link_path' => 'admin/config/user-interface/shortcut/%/links',
  'router_path' => 'admin/config/user-interface/shortcut/%/links',
  'link_title' => 'List links',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '57',
  'p4' => '217',
  'p5' => '225',
  'p6' => '236',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '237',
  'plid' => '214',
  'link_path' => 'admin/config/media/image-styles/delete/%',
  'router_path' => 'admin/config/media/image-styles/delete/%',
  'link_title' => 'Delete style',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:22:"Delete an image style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '237',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '238',
  'plid' => '214',
  'link_path' => 'admin/config/media/image-styles/revert/%',
  'router_path' => 'admin/config/media/image-styles/revert/%',
  'link_title' => 'Revert style',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:22:"Revert an image style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '238',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '239',
  'plid' => '234',
  'link_path' => 'admin/config/user-interface/shortcut/link/%/delete',
  'router_path' => 'admin/config/user-interface/shortcut/link/%/delete',
  'link_title' => 'Delete shortcut',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '57',
  'p4' => '217',
  'p5' => '234',
  'p6' => '239',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '240',
  'plid' => '235',
  'link_path' => 'admin/config/media/image-styles/edit/%/add/%',
  'router_path' => 'admin/config/media/image-styles/edit/%/add/%',
  'link_title' => 'Add image effect',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:28:"Add a new effect to a style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '235',
  'p6' => '240',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '241',
  'plid' => '235',
  'link_path' => 'admin/config/media/image-styles/edit/%/effects/%',
  'router_path' => 'admin/config/media/image-styles/edit/%/effects/%',
  'link_title' => 'Edit image effect',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:39:"Edit an existing effect within a style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '235',
  'p6' => '241',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '242',
  'plid' => '241',
  'link_path' => 'admin/config/media/image-styles/edit/%/effects/%/delete',
  'router_path' => 'admin/config/media/image-styles/edit/%/effects/%/delete',
  'link_title' => 'Delete image effect',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:39:"Delete an existing effect from a style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '235',
  'p6' => '241',
  'p7' => '242',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'shortcut-set-1',
  'mlid' => '243',
  'plid' => '0',
  'link_path' => 'node/add',
  'router_path' => 'node/add',
  'link_title' => 'Add content',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '1',
  'customized' => '0',
  'p1' => '243',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'shortcut-set-1',
  'mlid' => '244',
  'plid' => '0',
  'link_path' => 'admin/content',
  'router_path' => 'admin/content',
  'link_title' => 'Find content',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-19',
  'depth' => '1',
  'customized' => '0',
  'p1' => '244',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'main-menu',
  'mlid' => '245',
  'plid' => '0',
  'link_path' => '<front>',
  'router_path' => '',
  'link_title' => 'Home',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '1',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '245',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '246',
  'plid' => '6',
  'link_path' => 'node/add/article',
  'router_path' => 'node/add/article',
  'link_title' => 'Article',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:89:"Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '6',
  'p2' => '246',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '247',
  'plid' => '6',
  'link_path' => 'node/add/page',
  'router_path' => 'node/add/page',
  'link_title' => 'Basic page',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:77:\"Use <em>basic pages</em> for your static content, such as an 'About us' page.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '6',
  'p2' => '247',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '298',
  'plid' => '66',
  'link_path' => 'admin/config/people/accounts/display',
  'router_path' => 'admin/config/people/accounts/display',
  'link_title' => 'Manage display',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '298',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '300',
  'plid' => '66',
  'link_path' => 'admin/config/people/accounts/fields',
  'router_path' => 'admin/config/people/accounts/fields',
  'link_title' => 'Manage fields',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '300',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '302',
  'plid' => '298',
  'link_path' => 'admin/config/people/accounts/display/default',
  'router_path' => 'admin/config/people/accounts/display/default',
  'link_title' => 'Default',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '298',
  'p6' => '302',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '303',
  'plid' => '114',
  'link_path' => 'admin/structure/types/manage/%/display',
  'router_path' => 'admin/structure/types/manage/%/display',
  'link_title' => 'Manage display',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '303',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '304',
  'plid' => '114',
  'link_path' => 'admin/structure/types/manage/%/fields',
  'router_path' => 'admin/structure/types/manage/%/fields',
  'link_title' => 'Manage fields',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '304',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '306',
  'plid' => '298',
  'link_path' => 'admin/config/people/accounts/display/full',
  'router_path' => 'admin/config/people/accounts/display/full',
  'link_title' => 'User account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '298',
  'p6' => '306',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '308',
  'plid' => '300',
  'link_path' => 'admin/config/people/accounts/fields/%',
  'router_path' => 'admin/config/people/accounts/fields/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '300',
  'p6' => '308',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '309',
  'plid' => '303',
  'link_path' => 'admin/structure/types/manage/%/display/default',
  'router_path' => 'admin/structure/types/manage/%/display/default',
  'link_title' => 'Default',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '303',
  'p6' => '309',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '310',
  'plid' => '303',
  'link_path' => 'admin/structure/types/manage/%/display/full',
  'router_path' => 'admin/structure/types/manage/%/display/full',
  'link_title' => 'Full content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '303',
  'p6' => '310',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '311',
  'plid' => '303',
  'link_path' => 'admin/structure/types/manage/%/display/rss',
  'router_path' => 'admin/structure/types/manage/%/display/rss',
  'link_title' => 'RSS',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '303',
  'p6' => '311',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '312',
  'plid' => '303',
  'link_path' => 'admin/structure/types/manage/%/display/search_index',
  'router_path' => 'admin/structure/types/manage/%/display/search_index',
  'link_title' => 'Search index',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '3',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '303',
  'p6' => '312',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '313',
  'plid' => '303',
  'link_path' => 'admin/structure/types/manage/%/display/search_result',
  'router_path' => 'admin/structure/types/manage/%/display/search_result',
  'link_title' => 'Search result highlighting input',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '4',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '303',
  'p6' => '313',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '314',
  'plid' => '303',
  'link_path' => 'admin/structure/types/manage/%/display/teaser',
  'router_path' => 'admin/structure/types/manage/%/display/teaser',
  'link_title' => 'Teaser',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '303',
  'p6' => '314',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '315',
  'plid' => '304',
  'link_path' => 'admin/structure/types/manage/%/fields/%',
  'router_path' => 'admin/structure/types/manage/%/fields/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '304',
  'p6' => '315',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '320',
  'plid' => '308',
  'link_path' => 'admin/config/people/accounts/fields/%/delete',
  'router_path' => 'admin/config/people/accounts/fields/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '300',
  'p6' => '308',
  'p7' => '320',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '321',
  'plid' => '308',
  'link_path' => 'admin/config/people/accounts/fields/%/edit',
  'router_path' => 'admin/config/people/accounts/fields/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '300',
  'p6' => '308',
  'p7' => '321',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '322',
  'plid' => '308',
  'link_path' => 'admin/config/people/accounts/fields/%/field-settings',
  'router_path' => 'admin/config/people/accounts/fields/%/field-settings',
  'link_title' => 'Field settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '300',
  'p6' => '308',
  'p7' => '322',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '323',
  'plid' => '308',
  'link_path' => 'admin/config/people/accounts/fields/%/widget-type',
  'router_path' => 'admin/config/people/accounts/fields/%/widget-type',
  'link_title' => 'Widget type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '300',
  'p6' => '308',
  'p7' => '323',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '324',
  'plid' => '161',
  'link_path' => 'admin/structure/types/manage/%/comment/display/default',
  'router_path' => 'admin/structure/types/manage/%/comment/display/default',
  'link_title' => 'Default',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '161',
  'p6' => '324',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '325',
  'plid' => '161',
  'link_path' => 'admin/structure/types/manage/%/comment/display/full',
  'router_path' => 'admin/structure/types/manage/%/comment/display/full',
  'link_title' => 'Full comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '161',
  'p6' => '325',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '326',
  'plid' => '162',
  'link_path' => 'admin/structure/types/manage/%/comment/fields/%',
  'router_path' => 'admin/structure/types/manage/%/comment/fields/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '162',
  'p6' => '326',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '327',
  'plid' => '315',
  'link_path' => 'admin/structure/types/manage/%/fields/%/delete',
  'router_path' => 'admin/structure/types/manage/%/fields/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '304',
  'p6' => '315',
  'p7' => '327',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '328',
  'plid' => '315',
  'link_path' => 'admin/structure/types/manage/%/fields/%/edit',
  'router_path' => 'admin/structure/types/manage/%/fields/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '304',
  'p6' => '315',
  'p7' => '328',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '329',
  'plid' => '315',
  'link_path' => 'admin/structure/types/manage/%/fields/%/field-settings',
  'router_path' => 'admin/structure/types/manage/%/fields/%/field-settings',
  'link_title' => 'Field settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '304',
  'p6' => '315',
  'p7' => '329',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '330',
  'plid' => '315',
  'link_path' => 'admin/structure/types/manage/%/fields/%/widget-type',
  'router_path' => 'admin/structure/types/manage/%/fields/%/widget-type',
  'link_title' => 'Widget type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '304',
  'p6' => '315',
  'p7' => '330',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '331',
  'plid' => '326',
  'link_path' => 'admin/structure/types/manage/%/comment/fields/%/delete',
  'router_path' => 'admin/structure/types/manage/%/comment/fields/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '162',
  'p6' => '326',
  'p7' => '331',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '332',
  'plid' => '326',
  'link_path' => 'admin/structure/types/manage/%/comment/fields/%/edit',
  'router_path' => 'admin/structure/types/manage/%/comment/fields/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '162',
  'p6' => '326',
  'p7' => '332',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '333',
  'plid' => '326',
  'link_path' => 'admin/structure/types/manage/%/comment/fields/%/field-settings',
  'router_path' => 'admin/structure/types/manage/%/comment/fields/%/field-settings',
  'link_title' => 'Field settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '162',
  'p6' => '326',
  'p7' => '333',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '334',
  'plid' => '326',
  'link_path' => 'admin/structure/types/manage/%/comment/fields/%/widget-type',
  'router_path' => 'admin/structure/types/manage/%/comment/fields/%/widget-type',
  'link_title' => 'Widget type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '162',
  'p6' => '326',
  'p7' => '334',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '337',
  'plid' => '0',
  'link_path' => 'contact',
  'router_path' => 'contact',
  'link_title' => 'Contact',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '337',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '340',
  'plid' => '0',
  'link_path' => 'tracker',
  'router_path' => 'tracker',
  'link_title' => 'Recent content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '1',
  'customized' => '0',
  'p1' => '340',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '341',
  'plid' => '340',
  'link_path' => 'tracker/all',
  'router_path' => 'tracker/all',
  'link_title' => 'All recent content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '340',
  'p2' => '341',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '345',
  'plid' => '340',
  'link_path' => 'tracker/%',
  'router_path' => 'tracker/%',
  'link_title' => 'My recent content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '340',
  'p2' => '345',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '352',
  'plid' => '16',
  'link_path' => 'user/%/contact',
  'router_path' => 'user/%/contact',
  'link_title' => 'Contact',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '16',
  'p2' => '352',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '353',
  'plid' => '20',
  'link_path' => 'admin/structure/contact',
  'router_path' => 'admin/structure/contact',
  'link_title' => 'Contact form',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:71:"Create a system contact form and set up categories for the form to use.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '353',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '354',
  'plid' => '8',
  'link_path' => 'admin/config/date',
  'router_path' => 'admin/config/date',
  'link_title' => 'Date API',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:42:"Settings for modules the use the Date API.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '354',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '359',
  'plid' => '18',
  'link_path' => 'admin/reports/hits',
  'router_path' => 'admin/reports/hits',
  'link_title' => 'Recent hits',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"View pages that have recently been visited.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '359',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '360',
  'plid' => '18',
  'link_path' => 'admin/reports/pages',
  'router_path' => 'admin/reports/pages',
  'link_title' => 'Top pages',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:41:"View pages that have been hit frequently.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '360',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '361',
  'plid' => '18',
  'link_path' => 'admin/reports/referrers',
  'router_path' => 'admin/reports/referrers',
  'link_title' => 'Top referrers',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:19:"View top referrers.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '361',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '362',
  'plid' => '18',
  'link_path' => 'admin/reports/visitors',
  'router_path' => 'admin/reports/visitors',
  'link_title' => 'Top visitors',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:34:"View visitors that hit many pages.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '362',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '363',
  'plid' => '5',
  'link_path' => 'node/%/track',
  'router_path' => 'node/%/track',
  'link_title' => 'Track',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '363',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '364',
  'plid' => '16',
  'link_path' => 'user/%/track',
  'router_path' => 'user/%/track',
  'link_title' => 'Track',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '16',
  'p2' => '364',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '389',
  'plid' => '353',
  'link_path' => 'admin/structure/contact/add',
  'router_path' => 'admin/structure/contact/add',
  'link_title' => 'Add category',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '353',
  'p4' => '389',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '391',
  'plid' => '18',
  'link_path' => 'admin/reports/access/%',
  'router_path' => 'admin/reports/access/%',
  'link_title' => 'Details',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:16:"View access log.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '391',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '402',
  'plid' => '53',
  'link_path' => 'admin/config/system/statistics',
  'router_path' => 'admin/config/system/statistics',
  'link_title' => 'Statistics',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:68:"Control details about what and how your site logs access statistics.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '53',
  'p4' => '402',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '411',
  'plid' => '364',
  'link_path' => 'user/%/track/content',
  'router_path' => 'user/%/track/content',
  'link_title' => 'Track content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '16',
  'p2' => '364',
  'p3' => '411',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '412',
  'plid' => '364',
  'link_path' => 'user/%/track/navigation',
  'router_path' => 'user/%/track/navigation',
  'link_title' => 'Track page visits',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '3',
  'customized' => '0',
  'p1' => '16',
  'p2' => '364',
  'p3' => '412',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '421',
  'plid' => '353',
  'link_path' => 'admin/structure/contact/delete/%',
  'router_path' => 'admin/structure/contact/delete/%',
  'link_title' => 'Delete contact',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '353',
  'p4' => '421',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '423',
  'plid' => '353',
  'link_path' => 'admin/structure/contact/edit/%',
  'router_path' => 'admin/structure/contact/edit/%',
  'link_title' => 'Edit contact category',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '353',
  'p4' => '423',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '465',
  'plid' => '6',
  'link_path' => 'node/add/test-content-type',
  'router_path' => 'node/add/test-content-type',
  'link_title' => 'Test content type',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:49:"This is the description of the test content type.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '6',
  'p2' => '465',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'shortcut-set-2',
  'mlid' => '473',
  'plid' => '0',
  'link_path' => 'admin/people',
  'router_path' => 'admin/people',
  'link_title' => 'People',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-50',
  'depth' => '1',
  'customized' => '0',
  'p1' => '473',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '474',
  'plid' => '4',
  'link_path' => 'filter/tips/%',
  'router_path' => 'filter/tips/%',
  'link_title' => 'Compose tips',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '4',
  'p2' => '474',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '478',
  'plid' => '20',
  'link_path' => 'admin/content',
  'router_path' => 'admin/content',
  'link_title' => 'custom link test',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:0:"";}}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '1',
  'p1' => '1',
  'p2' => '20',
  'p3' => '478',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '712',
  'plid' => '33',
  'link_path' => 'admin/config/content/link',
  'router_path' => 'admin/config/content/link',
  'link_title' => 'Link settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:29:"Settings for the link module.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '33',
  'p4' => '712',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->execute();
$connection->schema()->createTable('menu_router', array(
  'fields' => array(
    'path' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'load_functions' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'to_arg_functions' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'access_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'access_arguments' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'page_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'page_arguments' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'delivery_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'fit' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'number_parts' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'context' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'tab_parent' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'tab_root' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'title_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'title_arguments' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'theme_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'theme_arguments' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'position' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'include_file' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'path',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('menu_router')
->fields(array(
  'path',
  'load_functions',
  'to_arg_functions',
  'access_callback',
  'access_arguments',
  'page_callback',
  'page_arguments',
  'delivery_callback',
  'fit',
  'number_parts',
  'context',
  'tab_parent',
  'tab_root',
  'title',
  'title_callback',
  'title_arguments',
  'theme_callback',
  'theme_arguments',
  'type',
  'description',
  'position',
  'weight',
  'include_file',
))
->values(array(
  'path' => 'admin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin',
  'title' => 'Administration',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '9',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_themes_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/appearance',
  'title' => 'Appearance',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Select and configure your themes.',
  'position' => 'left',
  'weight' => '-6',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/default',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_theme_default',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/appearance/default',
  'title' => 'Set default theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/disable',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_theme_disable',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/appearance/disable',
  'title' => 'Disable theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/enable',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_theme_enable',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/appearance/enable',
  'title' => 'Enable theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_themes_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/appearance',
  'tab_root' => 'admin/appearance',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Select and configure your theme',
  'position' => '',
  'weight' => '-1',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"system_theme_settings";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/appearance',
  'tab_root' => 'admin/appearance',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'Configure default and theme specific settings.',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/bartik',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:25:"themes/bartik/bartik.info";s:4:"name";s:6:"bartik";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:18:{s:4:"name";s:6:"Bartik";s:11:"description";s:48:"A flexible, recolorable theme with many regions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:7:"regions";a:17:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:7:"content";s:7:"Content";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:14:"triptych_first";s:14:"Triptych first";s:15:"triptych_middle";s:15:"Triptych middle";s:13:"triptych_last";s:13:"Triptych last";s:18:"footer_firstcolumn";s:19:"Footer first column";s:19:"footer_secondcolumn";s:20:"Footer second column";s:18:"footer_thirdcolumn";s:19:"Footer third column";s:19:"footer_fourthcolumn";s:20:"Footer fourth column";s:6:"footer";s:6:"Footer";}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"0";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:28:"themes/bartik/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1626883669;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:6:"bartik";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Bartik',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:18:{s:4:"name";s:7:"Garland";s:11:"description";s:111:"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:8:"settings";a:1:{s:13:"garland_width";s:5:"fluid";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:6:"engine";s:11:"phptemplate";s:7:"regions";a:9:{s:13:"sidebar_first";s:12:"Left sidebar";s:14:"sidebar_second";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";s:11:"highlighted";s:11:"Highlighted";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";}s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1626883669;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:7:"garland";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/global',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"system_theme_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Global settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-1',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/seven',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:23:"themes/seven/seven.info";s:4:"name";s:5:"seven";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:18:{s:4:"name";s:5:"Seven";s:11:"description";s:65:"A simple one-column, tableless, fluid width administration theme.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"1";}s:7:"regions";a:5:{s:7:"content";s:7:"Content";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:13:"sidebar_first";s:13:"First sidebar";}s:14:"regions_hidden";a:3:{i:0;s:13:"sidebar_first";i:1;s:8:"page_top";i:2;s:11:"page_bottom";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:27:"themes/seven/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1626883669;s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:5:"seven";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Seven',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/stark',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => "a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:23:\"themes/stark/stark.info\";s:4:\"name\";s:5:\"stark\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:17:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal's default HTML markup and CSS styles. To learn how to build your own theme and override Drupal's default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.82\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1626883669\";s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:9:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1626883669;s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}",
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:5:"stark";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Stark',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/compact',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_compact_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/compact',
  'title' => 'Compact mode',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_config_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config',
  'title' => 'Configuration',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Administer settings.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/content',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content',
  'title' => 'Content authoring',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Settings related to formatting and authoring content.',
  'position' => 'left',
  'weight' => '-15',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"filter_admin_overview";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content/formats',
  'title' => 'Text formats',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats/%',
  'load_functions' => 'a:1:{i:4;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_format_page',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content/formats/%',
  'title' => '',
  'title_callback' => 'filter_admin_format_title',
  'title_arguments' => 'a:1:{i:0;i:4;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats/%/disable',
  'load_functions' => 'a:1:{i:4;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_filter_disable_format_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:20:"filter_admin_disable";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content/formats/%/disable',
  'title' => 'Disable text format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_format_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/content/formats',
  'tab_root' => 'admin/config/content/formats',
  'title' => 'Add text format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"filter_admin_overview";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/content/formats',
  'tab_root' => 'admin/config/content/formats',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/link',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"link_admin_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content/link',
  'title' => 'Link settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Settings for the link module.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/link/link.admin.inc',
))
->values(array(
  'path' => 'admin/config/date',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/date',
  'title' => 'Date API',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Settings for modules the use the Date API.',
  'position' => 'left',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/development',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/development',
  'title' => 'Development',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Development tools.',
  'position' => 'right',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/development/logging',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:23:"system_logging_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/development/logging',
  'title' => 'Logging and errors',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Settings for logging and alerts modules. Various modules can route Drupal's system events to different destinations, such as syslog, database, email, etc.",
  'position' => '',
  'weight' => '-15',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/development/maintenance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:28:"system_site_maintenance_mode";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/development/maintenance',
  'title' => 'Maintenance mode',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Take the site offline for maintenance or bring it back online.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/development/performance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:27:"system_performance_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/development/performance',
  'title' => 'Performance',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.',
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/media',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media',
  'title' => 'Media',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Media tools.',
  'position' => 'left',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/file-system',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:27:"system_file_system_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/file-system',
  'title' => 'File system',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Tell Drupal where to store uploaded files and how they are accessed.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'image_style_list',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles',
  'title' => 'Image styles',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure styles that can be used for resizing or adjusting images on display.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"image_style_add_form";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/media/image-styles',
  'tab_root' => 'admin/config/media/image-styles',
  'title' => 'Add style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => 'Add a new image style.',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/delete/%',
  'load_functions' => 'a:1:{i:5;a:1:{s:16:"image_style_load";a:2:{i:0;N;i:1;s:1:"1";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"image_style_delete_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/delete/%',
  'title' => 'Delete style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Delete an image style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/edit/%',
  'load_functions' => 'a:1:{i:5;s:16:"image_style_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:16:"image_style_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/edit/%',
  'title' => 'Edit style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure an image style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/edit/%/add/%',
  'load_functions' => 'a:2:{i:5;a:1:{s:16:"image_style_load";a:1:{i:0;i:5;}}i:7;a:1:{s:28:"image_effect_definition_load";a:1:{i:0;i:5;}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:17:"image_effect_form";i:1;i:5;i:2;i:7;}',
  'delivery_callback' => '',
  'fit' => '250',
  'number_parts' => '8',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/edit/%/add/%',
  'title' => 'Add image effect',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Add a new effect to a style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/edit/%/effects/%',
  'load_functions' => 'a:2:{i:5;a:1:{s:16:"image_style_load";a:2:{i:0;i:5;i:1;s:1:"3";}}i:7;a:1:{s:17:"image_effect_load";a:2:{i:0;i:5;i:1;s:1:"3";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:17:"image_effect_form";i:1;i:5;i:2;i:7;}',
  'delivery_callback' => '',
  'fit' => '250',
  'number_parts' => '8',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/edit/%/effects/%',
  'title' => 'Edit image effect',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Edit an existing effect within a style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/edit/%/effects/%/delete',
  'load_functions' => 'a:2:{i:5;a:1:{s:16:"image_style_load";a:2:{i:0;i:5;i:1;s:1:"3";}}i:7;a:1:{s:17:"image_effect_load";a:2:{i:0;i:5;i:1;s:1:"3";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:24:"image_effect_delete_form";i:1;i:5;i:2;i:7;}',
  'delivery_callback' => '',
  'fit' => '501',
  'number_parts' => '9',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/edit/%/effects/%/delete',
  'title' => 'Delete image effect',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Delete an existing effect from a style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'image_style_list',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/media/image-styles',
  'tab_root' => 'admin/config/media/image-styles',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'List the current image styles on the site.',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/revert/%',
  'load_functions' => 'a:1:{i:5;a:1:{s:16:"image_style_load";a:2:{i:0;N;i:1;s:1:"2";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"image_style_revert_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/revert/%',
  'title' => 'Revert style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Revert an image style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-toolkit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:29:"system_image_toolkit_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-toolkit',
  'title' => 'Image toolkit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Choose which image toolkit to use if you have installed optional toolkits.',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/people',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people',
  'title' => 'People',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure user accounts.',
  'position' => 'left',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"user_admin_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Account settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure default behavior of users, including registration requirements, e-mails, fields, and user pictures.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"user";i:2;s:4:"user";i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Manage display',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/display/default',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:7:"default";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"user";i:2;s:4:"user";i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/display',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Default',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/display/full',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:4:"full";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"user";i:2;s:4:"user";i:3;s:4:"full";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/display',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'User account',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:4:"user";i:2;s:4:"user";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => '',
  'title_callback' => 'field_ui_menu_title',
  'title_arguments' => 'a:1:{i:0;i:5;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%/delete',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%/edit',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%/field-settings',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Field settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%/widget-type',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Widget type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"user_admin_settings";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/ip-blocking',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"block IP addresses";}',
  'page_callback' => 'system_ip_blocking',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/ip-blocking',
  'title' => 'IP address blocking',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage blocked IP addresses.',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/ip-blocking/delete/%',
  'load_functions' => 'a:1:{i:5;s:15:"blocked_ip_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"block IP addresses";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"system_ip_blocking_delete";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/ip-blocking/delete/%',
  'title' => 'Delete IP address',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional',
  'title' => 'Regional and language',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Regional settings, localization and translation.',
  'position' => 'left',
  'weight' => '-5',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_date_time_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Date and time',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure display formats for date and time.',
  'position' => '',
  'weight' => '-15',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_date_time_formats',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Formats',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'Configure display format strings for date and time.',
  'position' => '',
  'weight' => '-9',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats/%/delete',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:30:"system_date_delete_format_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/formats/%/delete',
  'title' => 'Delete date format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Allow users to delete a configured date format.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats/%/edit',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:34:"system_configure_date_formats_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/formats/%/edit',
  'title' => 'Edit date format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Allow users to edit a configured date format.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:34:"system_configure_date_formats_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time/formats',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Add format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => 'Allow users to add additional date formats.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats/lookup',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_date_time_lookup',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/formats/lookup',
  'title' => 'Date and time lookup',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/types',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_date_time_settings";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Types',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Configure display formats for date and time.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/types/%/delete',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:35:"system_delete_date_format_type_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/types/%/delete',
  'title' => 'Delete date type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Allow users to delete a configured date type.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/types/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"system_add_date_format_type_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time/types',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Add date type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => 'Add new date type.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_regional_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/settings',
  'title' => 'Regional settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Settings for the site's default time zone and country.",
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search',
  'title' => 'Search and metadata',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Local site search, metadata and SEO.',
  'position' => 'left',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/clean-urls',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_clean_url_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/clean-urls',
  'title' => 'Clean URLs',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Enable or disable clean URLs for your site.',
  'position' => '',
  'weight' => '5',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/clean-urls/check',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_json_output',
  'page_arguments' => 'a:1:{i:0;a:1:{s:6:"status";b:1;}}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/clean-urls/check',
  'title' => 'Clean URL check',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/path',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_overview',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/path',
  'title' => 'URL aliases',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Change your site's URL paths by aliasing them.",
  'position' => '',
  'weight' => '-5',
  'include_file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/path/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_edit',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/search/path',
  'tab_root' => 'admin/config/search/path',
  'title' => 'Add alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/path/delete/%',
  'load_functions' => 'a:1:{i:5;s:9:"path_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"path_admin_delete_confirm";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/path/delete/%',
  'title' => 'Delete alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/path/edit/%',
  'load_functions' => 'a:1:{i:5;s:9:"path_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_edit',
  'page_arguments' => 'a:1:{i:0;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/path/edit/%',
  'title' => 'Edit alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/path/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_overview',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/search/path',
  'tab_root' => 'admin/config/search/path',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer search";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"search_admin_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/settings',
  'title' => 'Search settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure relevance settings for search and other indexing options.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/search/search.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/settings/reindex',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer search";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:22:"search_reindex_confirm";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/settings/reindex',
  'title' => 'Clear index',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/search/search.admin.inc',
))
->values(array(
  'path' => 'admin/config/services',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/services',
  'title' => 'Web services',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Tools related to web services.',
  'position' => 'right',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/services/rss-publishing',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_rss_feeds_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/services/rss-publishing',
  'title' => 'RSS publishing',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure the site description, the number of items per feed and whether feeds should be titles/teasers/full-text.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system',
  'title' => 'System',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'General system related configuration.',
  'position' => 'right',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_manage',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/actions',
  'title' => 'Actions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage the actions defined for your site.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_actions_configure";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/actions/configure',
  'title' => 'Configure an advanced action',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions/delete/%',
  'load_functions' => 'a:1:{i:5;s:12:"actions_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"system_actions_delete_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/actions/delete/%',
  'title' => 'Delete action',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Delete an action.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions/manage',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_manage',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/system/actions',
  'tab_root' => 'admin/config/system/actions',
  'title' => 'Manage actions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Manage the actions defined for your site.',
  'position' => '',
  'weight' => '-2',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions/orphan',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_remove_orphans',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/actions/orphan',
  'title' => 'Remove orphans',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/cron',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"system_cron_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/cron',
  'title' => 'Cron',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage automatic site maintenance tasks.',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/site-information',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"system_site_information_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/site-information',
  'title' => 'Site information',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Change site name, e-mail address, slogan, default front page, and number of posts per page, error pages.',
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/statistics',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer statistics";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"statistics_settings_form";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/statistics',
  'title' => 'Statistics',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Control details about what and how your site logs access statistics.',
  'position' => '',
  'weight' => '-15',
  'include_file' => 'modules/statistics/statistics.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/user-interface',
  'title' => 'User interface',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Tools that enhance the user interface.',
  'position' => 'right',
  'weight' => '-15',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface/shortcut',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer shortcuts";}',
  'page_callback' => 'shortcut_set_admin',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/user-interface/shortcut',
  'title' => 'Shortcuts',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Add and modify shortcut sets.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface/shortcut/%',
  'load_functions' => 'a:1:{i:4;s:17:"shortcut_set_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_set_edit_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:22:"shortcut_set_customize";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/user-interface/shortcut/%',
  'title' => 'Edit shortcuts',
  'title_callback' => 'shortcut_set_title_callback',
  'title_arguments' => 'a:1:{i:0;i:4;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface/shortcut/%/add-link',
  'load_functions' => 'a:1:{i:4;s:17:"shortcut_set_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_set_edit_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:17:"shortcut_link_add";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/user-interface/shortcut/%',
  'tab_root' => 'admin/config/user-interface/shortcut/%',
  'title' => 'Add shortcut',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface/shortcut/%/add-link-inline',
  'load_functions' => 'a:1:{i:4;s:17:"shortcut_set_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_set_edit_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'shortcut_link_add_inline',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/user-interface/shortcut/%/add-link-inline',
  'title' => 'Add shortcut',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface/shortcut/%/delete',
  'load_functions' => 'a:1:{i:4;s:17:"shortcut_set_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_set_delete_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"shortcut_set_delete_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/user-interface/shortcut/%/delete',
  'title' => 'Delete shortcut set',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface/shortcut/%/edit',
  'load_functions' => 'a:1:{i:4;s:17:"shortcut_set_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_set_edit_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:22:"shortcut_set_edit_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/user-interface/shortcut/%',
  'tab_root' => 'admin/config/user-interface/shortcut/%',
  'title' => 'Edit set name',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface/shortcut/%/links',
  'load_functions' => 'a:1:{i:4;s:17:"shortcut_set_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_set_edit_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:22:"shortcut_set_customize";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/user-interface/shortcut/%',
  'tab_root' => 'admin/config/user-interface/shortcut/%',
  'title' => 'List links',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface/shortcut/add-set',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer shortcuts";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"shortcut_set_add_form";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/user-interface/shortcut',
  'tab_root' => 'admin/config/user-interface/shortcut',
  'title' => 'Add shortcut set',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface/shortcut/link/%',
  'load_functions' => 'a:1:{i:5;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_link_access',
  'access_arguments' => 'a:1:{i:0;i:5;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"shortcut_link_edit";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/user-interface/shortcut/link/%',
  'title' => 'Edit shortcut',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface/shortcut/link/%/delete',
  'load_functions' => 'a:1:{i:5;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_link_access',
  'access_arguments' => 'a:1:{i:0;i:5;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:20:"shortcut_link_delete";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/user-interface/shortcut/link/%/delete',
  'title' => 'Delete shortcut',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
))
->values(array(
  'path' => 'admin/config/workflow',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/workflow',
  'title' => 'Workflow',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Content workflow, editorial workflow tools.',
  'position' => 'right',
  'weight' => '5',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/content',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"access content overview";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"node_admin_content";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/content',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Administer content and comments.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/content/comment',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/content',
  'tab_root' => 'admin/content',
  'title' => 'Comments',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '134',
  'description' => 'List and edit site comments and the comment approval queue.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'admin/content/comment/approval',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:1:{i:0;s:8:"approval";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/content/comment',
  'tab_root' => 'admin/content',
  'title' => 'Unapproved comments',
  'title_callback' => 'comment_count_unpublished',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'admin/content/comment/new',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/content/comment',
  'tab_root' => 'admin/content',
  'title' => 'Published comments',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'admin/content/node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"access content overview";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"node_admin_content";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/content',
  'tab_root' => 'admin/content',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/index',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_index',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'admin',
  'tab_root' => 'admin',
  'title' => 'Index',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '-18',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/modules',
  'title' => 'Modules',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Extend site functionality.',
  'position' => '',
  'weight' => '-2',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/modules',
  'tab_root' => 'admin/modules',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules/list/confirm',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/modules/list/confirm',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules/uninstall',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_modules_uninstall";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/modules',
  'tab_root' => 'admin/modules',
  'title' => 'Uninstall',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules/uninstall/confirm',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_modules_uninstall";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/modules/uninstall/confirm',
  'title' => 'Uninstall',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/people',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:4:"list";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/people',
  'title' => 'People',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage user accounts, roles, and permissions.',
  'position' => 'left',
  'weight' => '-4',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/create',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:6:"create";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/people',
  'tab_root' => 'admin/people',
  'title' => 'Add user',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/people',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:4:"list";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/people',
  'tab_root' => 'admin/people',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Find and manage people interacting with your site.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:22:"user_admin_permissions";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/people',
  'tab_root' => 'admin/people',
  'title' => 'Permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'Determine access to features by selecting permissions for roles.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:22:"user_admin_permissions";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/people/permissions',
  'tab_root' => 'admin/people',
  'title' => 'Permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Determine access to features by selecting permissions for roles.',
  'position' => '',
  'weight' => '-8',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions/roles',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:16:"user_admin_roles";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/people/permissions',
  'tab_root' => 'admin/people',
  'title' => 'Roles',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'List, edit, or add user roles.',
  'position' => '',
  'weight' => '-5',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions/roles/delete/%',
  'load_functions' => 'a:1:{i:5;s:14:"user_role_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_role_edit_access',
  'access_arguments' => 'a:1:{i:0;i:5;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:30:"user_admin_role_delete_confirm";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/people/permissions/roles/delete/%',
  'title' => 'Delete role',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions/roles/edit/%',
  'load_functions' => 'a:1:{i:5;s:14:"user_role_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_role_edit_access',
  'access_arguments' => 'a:1:{i:0;i:5;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:15:"user_admin_role";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/people/permissions/roles/edit/%',
  'title' => 'Edit role',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/reports',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"access site reports";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports',
  'title' => 'Reports',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'View reports, updates, and errors.',
  'position' => 'left',
  'weight' => '5',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/access/%',
  'load_functions' => 'a:1:{i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access statistics";}',
  'page_callback' => 'statistics_access_log',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'delivery_callback' => '',
  'fit' => '14',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/access/%',
  'title' => 'Details',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'View access log.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/statistics/statistics.admin.inc',
))
->values(array(
  'path' => 'admin/reports/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'field_ui_fields_list',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/fields',
  'title' => 'Field list',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Overview of fields on all entity types.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/reports/hits',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access statistics";}',
  'page_callback' => 'statistics_recent_hits',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/hits',
  'title' => 'Recent hits',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'View pages that have recently been visited.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/statistics/statistics.admin.inc',
))
->values(array(
  'path' => 'admin/reports/pages',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access statistics";}',
  'page_callback' => 'statistics_top_pages',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/pages',
  'title' => 'Top pages',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'View pages that have been hit frequently.',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/statistics/statistics.admin.inc',
))
->values(array(
  'path' => 'admin/reports/referrers',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access statistics";}',
  'page_callback' => 'statistics_top_referrers',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/referrers',
  'title' => 'Top referrers',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'View top referrers.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/statistics/statistics.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_status',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status',
  'title' => 'Status report',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Get a status report about your site's operation and any detected problems.",
  'position' => '',
  'weight' => '-60',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status/php',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_php',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/php',
  'title' => 'PHP',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status/rebuild',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"node_configure_rebuild_confirm";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/rebuild',
  'title' => 'Rebuild permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status/run-cron',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_run_cron',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/run-cron',
  'title' => 'Run cron',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/visitors',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access statistics";}',
  'page_callback' => 'statistics_top_visitors',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/visitors',
  'title' => 'Top visitors',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'View visitors that hit many pages.',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/statistics/statistics.admin.inc',
))
->values(array(
  'path' => 'admin/structure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure',
  'title' => 'Structure',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Administer blocks, content types, menus, etc.',
  'position' => 'right',
  'weight' => '-8',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:6:"bartik";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block',
  'title' => 'Blocks',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Configure what block content appears in your site's sidebars and other regions.",
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/demo/bartik',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:25:"themes/bartik/bartik.info";s:4:"name";s:6:"bartik";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:18:{s:4:"name";s:6:"Bartik";s:11:"description";s:48:"A flexible, recolorable theme with many regions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:7:"regions";a:17:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:7:"content";s:7:"Content";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:14:"triptych_first";s:14:"Triptych first";s:15:"triptych_middle";s:15:"Triptych middle";s:13:"triptych_last";s:13:"Triptych last";s:18:"footer_firstcolumn";s:19:"Footer first column";s:19:"footer_secondcolumn";s:20:"Footer second column";s:18:"footer_thirdcolumn";s:19:"Footer third column";s:19:"footer_fourthcolumn";s:20:"Footer fourth column";s:6:"footer";s:6:"Footer";}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"0";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:28:"themes/bartik/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1626883669;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:6:"bartik";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/bartik',
  'title' => 'Bartik',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:6:"bartik";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/demo/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:18:{s:4:"name";s:7:"Garland";s:11:"description";s:111:"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:8:"settings";a:1:{s:13:"garland_width";s:5:"fluid";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:6:"engine";s:11:"phptemplate";s:7:"regions";a:9:{s:13:"sidebar_first";s:12:"Left sidebar";s:14:"sidebar_second";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";s:11:"highlighted";s:11:"Highlighted";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";}s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1626883669;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:7:"garland";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/garland',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:7:"garland";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/demo/seven',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:23:"themes/seven/seven.info";s:4:"name";s:5:"seven";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:18:{s:4:"name";s:5:"Seven";s:11:"description";s:65:"A simple one-column, tableless, fluid width administration theme.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"1";}s:7:"regions";a:5:{s:7:"content";s:7:"Content";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:13:"sidebar_first";s:13:"First sidebar";}s:14:"regions_hidden";a:3:{i:0;s:13:"sidebar_first";i:1;s:8:"page_top";i:2;s:11:"page_bottom";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:27:"themes/seven/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1626883669;s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:5:"seven";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/seven',
  'title' => 'Seven',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:5:"seven";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/demo/stark',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => "a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:23:\"themes/stark/stark.info\";s:4:\"name\";s:5:\"stark\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:17:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal's default HTML markup and CSS styles. To learn how to build your own theme and override Drupal's default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.82\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1626883669\";s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:9:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1626883669;s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}",
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:5:"stark";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/stark',
  'title' => 'Stark',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:5:"stark";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/bartik',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:25:"themes/bartik/bartik.info";s:4:"name";s:6:"bartik";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:18:{s:4:"name";s:6:"Bartik";s:11:"description";s:48:"A flexible, recolorable theme with many regions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:7:"regions";a:17:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:7:"content";s:7:"Content";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:14:"triptych_first";s:14:"Triptych first";s:15:"triptych_middle";s:15:"Triptych middle";s:13:"triptych_last";s:13:"Triptych last";s:18:"footer_firstcolumn";s:19:"Footer first column";s:19:"footer_secondcolumn";s:20:"Footer second column";s:18:"footer_thirdcolumn";s:19:"Footer third column";s:19:"footer_fourthcolumn";s:20:"Footer fourth column";s:6:"footer";s:6:"Footer";}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"0";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:28:"themes/bartik/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1626883669;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:6:"bartik";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Bartik',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:18:{s:4:"name";s:7:"Garland";s:11:"description";s:111:"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:8:"settings";a:1:{s:13:"garland_width";s:5:"fluid";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:6:"engine";s:11:"phptemplate";s:7:"regions";a:9:{s:13:"sidebar_first";s:12:"Left sidebar";s:14:"sidebar_second";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";s:11:"highlighted";s:11:"Highlighted";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";}s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1626883669;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:7:"garland";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/garland/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/block/list/garland',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/seven',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:23:"themes/seven/seven.info";s:4:"name";s:5:"seven";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:18:{s:4:"name";s:5:"Seven";s:11:"description";s:65:"A simple one-column, tableless, fluid width administration theme.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"1";}s:7:"regions";a:5:{s:7:"content";s:7:"Content";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:13:"sidebar_first";s:13:"First sidebar";}s:14:"regions_hidden";a:3:{i:0;s:13:"sidebar_first";i:1;s:8:"page_top";i:2;s:11:"page_bottom";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:27:"themes/seven/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1626883669;s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:5:"seven";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Seven',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/seven/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/block/list/seven',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/stark',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => "a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:23:\"themes/stark/stark.info\";s:4:\"name\";s:5:\"stark\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:17:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal's default HTML markup and CSS styles. To learn how to build your own theme and override Drupal's default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.82\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1626883669\";s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:9:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1626883669;s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}",
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:5:"stark";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Stark',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/stark/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/block/list/stark',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/manage/%/%',
  'load_functions' => 'a:2:{i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:21:"block_admin_configure";i:1;i:4;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '60',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/manage/%/%',
  'title' => 'Configure block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/manage/%/%/configure',
  'load_functions' => 'a:2:{i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:21:"block_admin_configure";i:1;i:4;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '121',
  'number_parts' => '7',
  'context' => '2',
  'tab_parent' => 'admin/structure/block/manage/%/%',
  'tab_root' => 'admin/structure/block/manage/%/%',
  'title' => 'Configure block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/manage/%/%/delete',
  'load_functions' => 'a:2:{i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"block_custom_block_delete";i:1;i:4;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '121',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => 'admin/structure/block/manage/%/%',
  'tab_root' => 'admin/structure/block/manage/%/%',
  'title' => 'Delete block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/contact',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer contact forms";}',
  'page_callback' => 'contact_category_list',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/contact',
  'title' => 'Contact form',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Create a system contact form and set up categories for the form to use.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/contact/contact.admin.inc',
))
->values(array(
  'path' => 'admin/structure/contact/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer contact forms";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:26:"contact_category_edit_form";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/contact',
  'tab_root' => 'admin/structure/contact',
  'title' => 'Add category',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/contact/contact.admin.inc',
))
->values(array(
  'path' => 'admin/structure/contact/delete/%',
  'load_functions' => 'a:1:{i:4;s:12:"contact_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer contact forms";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"contact_category_delete_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/contact/delete/%',
  'title' => 'Delete contact',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/contact/contact.admin.inc',
))
->values(array(
  'path' => 'admin/structure/contact/edit/%',
  'load_functions' => 'a:1:{i:4;s:12:"contact_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer contact forms";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"contact_category_edit_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/contact/edit/%',
  'title' => 'Edit contact category',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/contact/contact.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_overview_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu',
  'title' => 'Menus',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Add new menus to your site, edit existing menus, and rename and reorganize menu links.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"menu_edit_menu";i:1;s:3:"add";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/menu',
  'tab_root' => 'admin/structure/menu',
  'title' => 'Add menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/item/%/delete',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_item_delete_page',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/item/%/delete',
  'title' => 'Delete menu link',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/item/%/edit',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:14:"menu_edit_item";i:1;s:4:"edit";i:2;i:4;i:3;N;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/item/%/edit',
  'title' => 'Edit menu link',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/item/%/reset',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"menu_reset_item_confirm";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/item/%/reset',
  'title' => 'Reset menu link',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_overview_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/menu',
  'tab_root' => 'admin/structure/menu',
  'title' => 'List menus',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/manage/%',
  'load_functions' => 'a:1:{i:4;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"menu_overview_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/manage/%',
  'title' => 'Customize menu',
  'title_callback' => 'menu_overview_title',
  'title_arguments' => 'a:1:{i:0;i:4;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/manage/%/add',
  'load_functions' => 'a:1:{i:4;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:14:"menu_edit_item";i:1;s:3:"add";i:2;N;i:3;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/menu/manage/%',
  'tab_root' => 'admin/structure/menu/manage/%',
  'title' => 'Add link',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/manage/%/delete',
  'load_functions' => 'a:1:{i:4;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_delete_menu_page',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/manage/%/delete',
  'title' => 'Delete menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/manage/%/edit',
  'load_functions' => 'a:1:{i:4;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:14:"menu_edit_menu";i:1;s:4:"edit";i:2;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '3',
  'tab_parent' => 'admin/structure/menu/manage/%',
  'tab_root' => 'admin/structure/menu/manage/%',
  'title' => 'Edit menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/manage/%/list',
  'load_functions' => 'a:1:{i:4;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"menu_overview_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '3',
  'tab_parent' => 'admin/structure/menu/manage/%',
  'tab_root' => 'admin/structure/menu/manage/%',
  'title' => 'List links',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/parents',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_parent_options_js',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/parents',
  'title' => 'Parent menu items',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'admin/structure/menu/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"menu_configure";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/menu',
  'tab_root' => 'admin/structure/menu',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '5',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"taxonomy_overview_vocabularies";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/taxonomy',
  'title' => 'Taxonomy',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage tagging, categorization, and classification of your content.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"taxonomy_overview_terms";i:1;i:3;}',
  'delivery_callback' => '',
  'fit' => '14',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => '',
  'title_callback' => 'entity_label',
  'title_arguments' => 'a:2:{i:0;s:19:"taxonomy_vocabulary";i:1;i:3;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/add',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:18:"taxonomy_form_term";i:1;a:0:{}i:2;i:3;}',
  'delivery_callback' => '',
  'fit' => '29',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'Add term',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/edit',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"taxonomy_form_vocabulary";i:1;i:3;}',
  'delivery_callback' => '',
  'fit' => '29',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/list',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"taxonomy_overview_terms";i:1;i:3;}',
  'delivery_callback' => '',
  'fit' => '29',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"taxonomy_form_vocabulary";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy',
  'tab_root' => 'admin/structure/taxonomy',
  'title' => 'Add vocabulary',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"taxonomy_overview_vocabularies";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy',
  'tab_root' => 'admin/structure/taxonomy',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'node_overview_types',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types',
  'title' => 'Content types',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage content types, including default status, front page promotion, comment settings, etc.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"node_type_form";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/types',
  'tab_root' => 'admin/structure/types',
  'title' => 'Add content type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'node_overview_types',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/types',
  'tab_root' => 'admin/structure/types',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Edit content type',
  'title_callback' => 'node_type_page_title',
  'title_arguments' => 'a:1:{i:0;i:4;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/display',
  'load_functions' => 'a:1:{i:4;s:22:"comment_node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:7:"comment";i:2;i:4;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Comment display',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '4',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/display/default',
  'load_functions' => 'a:1:{i:4;s:22:"comment_node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:7:"comment";i:1;i:4;i:2;s:7:"default";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:7:"comment";i:2;i:4;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '247',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Default',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/display/full',
  'load_functions' => 'a:1:{i:4;s:22:"comment_node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:7:"comment";i:1;i:4;i:2;s:4:"full";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:7:"comment";i:2;i:4;i:3;s:4:"full";}',
  'delivery_callback' => '',
  'fit' => '247',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Full comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/fields',
  'load_functions' => 'a:1:{i:4;s:22:"comment_node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:7:"comment";i:2;i:4;}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Comment fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '3',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/fields/%',
  'load_functions' => 'a:2:{i:4;a:1:{s:22:"comment_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '246',
  'number_parts' => '8',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types/manage/%/comment/fields/%',
  'title' => '',
  'title_callback' => 'field_ui_menu_title',
  'title_arguments' => 'a:1:{i:0;i:7;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/fields/%/delete',
  'load_functions' => 'a:2:{i:4;a:1:{s:22:"comment_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '493',
  'number_parts' => '9',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/comment/fields/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/fields/%/edit',
  'load_functions' => 'a:2:{i:4;a:1:{s:22:"comment_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '493',
  'number_parts' => '9',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/comment/fields/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/fields/%/field-settings',
  'load_functions' => 'a:2:{i:4;a:1:{s:22:"comment_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '493',
  'number_parts' => '9',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/comment/fields/%',
  'title' => 'Field settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/fields/%/widget-type',
  'load_functions' => 'a:2:{i:4;a:1:{s:22:"comment_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '493',
  'number_parts' => '9',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/comment/fields/%',
  'title' => 'Widget type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/delete',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types/manage/%/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Manage display',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display/default',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:7:"default";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Default',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display/full',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:4:"full";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:4:"full";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Full content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display/rss',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:3:"rss";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:3:"rss";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display/search_index',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:12:"search_index";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:12:"search_index";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Search index',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '3',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display/search_result',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:13:"search_result";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:13:"search_result";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Search result highlighting input',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '4',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display/teaser',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:6:"teaser";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:6:"teaser";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Teaser',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/edit',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:4:"node";i:2;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '122',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => '',
  'title_callback' => 'field_ui_menu_title',
  'title_arguments' => 'a:1:{i:0;i:6;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%/delete',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%/edit',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%/field-settings',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Field settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%/widget-type',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Widget type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/tasks',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'admin',
  'tab_root' => 'admin',
  'title' => 'Tasks',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'batch',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'system_batch_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'batch',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_system_batch_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'comment/%',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"access comments";}',
  'page_callback' => 'comment_permalink',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '2',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'comment/%',
  'title' => 'Comment permalink',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'comment/%/approve',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_approve',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'comment/%/approve',
  'title' => 'Approve',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/comment/comment.pages.inc',
))
->values(array(
  'path' => 'comment/%/delete',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_confirm_delete_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'comment/%',
  'tab_root' => 'comment/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'comment/%/edit',
  'load_functions' => 'a:1:{i:1;s:12:"comment_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'comment_access',
  'access_arguments' => 'a:2:{i:0;s:4:"edit";i:1;i:1;}',
  'page_callback' => 'comment_edit_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'comment/%',
  'tab_root' => 'comment/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'comment/%/view',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"access comments";}',
  'page_callback' => 'comment_permalink',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'comment/%',
  'tab_root' => 'comment/%',
  'title' => 'View comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => '',
))
->values(array(
  'path' => 'comment/reply/%',
  'load_functions' => 'a:1:{i:2;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:2;}',
  'page_callback' => 'comment_reply',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '6',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'comment/reply/%',
  'title' => 'Add new comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/comment/comment.pages.inc',
))
->values(array(
  'path' => 'contact',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"access site-wide contact form";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:17:"contact_site_form";}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'contact',
  'title' => 'Contact',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '20',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/contact/contact.pages.inc',
))
->values(array(
  'path' => 'ctools/autocomplete/%',
  'load_functions' => 'a:1:{i:2;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_content_autocomplete_entity',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '6',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/autocomplete/%',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/contrib/ctools/includes/content.menu.inc',
))
->values(array(
  'path' => 'ctools/context/ajax/access/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_access_ajax_add',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/context/ajax/access/add',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/contrib/ctools/includes/context-access-admin.inc',
))
->values(array(
  'path' => 'ctools/context/ajax/access/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_access_ajax_edit',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/context/ajax/access/configure',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/contrib/ctools/includes/context-access-admin.inc',
))
->values(array(
  'path' => 'ctools/context/ajax/access/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_access_ajax_delete',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/context/ajax/access/delete',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/contrib/ctools/includes/context-access-admin.inc',
))
->values(array(
  'path' => 'ctools/context/ajax/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_context_ajax_item_add',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/context/ajax/add',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/contrib/ctools/includes/context-admin.inc',
))
->values(array(
  'path' => 'ctools/context/ajax/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_context_ajax_item_edit',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/context/ajax/configure',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/contrib/ctools/includes/context-admin.inc',
))
->values(array(
  'path' => 'ctools/context/ajax/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_context_ajax_item_delete',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/context/ajax/delete',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/contrib/ctools/includes/context-admin.inc',
))
->values(array(
  'path' => 'entityreference/autocomplete/single/%/%/%',
  'load_functions' => 'a:3:{i:3;N;i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'entityreference_autocomplete_access_callback',
  'access_arguments' => 'a:4:{i:0;i:2;i:1;i:3;i:2;i:4;i:3;i:5;}',
  'page_callback' => 'entityreference_autocomplete_callback',
  'page_arguments' => 'a:4:{i:0;i:2;i:1;i:3;i:2;i:4;i:3;i:5;}',
  'delivery_callback' => '',
  'fit' => '56',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'entityreference/autocomplete/single/%/%/%',
  'title' => 'Entity Reference Autocomplete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'entityreference/autocomplete/tags/%/%/%',
  'load_functions' => 'a:3:{i:3;N;i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'entityreference_autocomplete_access_callback',
  'access_arguments' => 'a:4:{i:0;i:2;i:1;i:3;i:2;i:4;i:3;i:5;}',
  'page_callback' => 'entityreference_autocomplete_callback',
  'page_arguments' => 'a:4:{i:0;i:2;i:1;i:3;i:2;i:4;i:3;i:5;}',
  'delivery_callback' => '',
  'fit' => '56',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'entityreference/autocomplete/tags/%/%/%',
  'title' => 'Entity Reference Autocomplete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'file/ajax',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'file_ajax_upload',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => 'ajax_deliver',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'file/ajax',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'file/progress',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'file_ajax_progress',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'file/progress',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'filter/tips',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'filter_tips_long',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'filter/tips',
  'title' => 'Compose tips',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '20',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.pages.inc',
))
->values(array(
  'path' => 'filter/tips/%',
  'load_functions' => 'a:1:{i:2;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'filter_access',
  'access_arguments' => 'a:1:{i:0;i:2;}',
  'page_callback' => 'filter_tips_long',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '6',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'filter/tips/%',
  'title' => 'Compose tips',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.pages.inc',
))
->values(array(
  'path' => 'node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'node_page_default',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'node/%',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:1;}',
  'page_callback' => 'node_page_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '2',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%',
  'title' => '',
  'title_callback' => 'node_page_title',
  'title_arguments' => 'a:1:{i:0;i:1;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'node/%/delete',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"delete";i:1;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:19:"node_delete_confirm";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '2',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/edit',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"update";i:1;i:1;}',
  'page_callback' => 'node_page_edit',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'node_revision_overview',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Revisions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions/%/delete',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:6:"delete";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"node_revision_delete_confirm";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/delete',
  'title' => 'Delete earlier revision',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions/%/revert',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:6:"update";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"node_revision_revert_confirm";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/revert',
  'title' => 'Revert to earlier revision',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions/%/view',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'node_show',
  'page_arguments' => 'a:2:{i:0;i:1;i:1;b:1;}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/view',
  'title' => 'Revisions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'node/%/track',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access statistics";}',
  'page_callback' => 'statistics_node_tracker',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Track',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/statistics/statistics.pages.inc',
))
->values(array(
  'path' => 'node/%/view',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:1;}',
  'page_callback' => 'node_page_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => '',
))
->values(array(
  'path' => 'node/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_node_add_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'node_add_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add',
  'title' => 'Add content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/article',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:7:"article";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;s:7:"article";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add/article',
  'title' => 'Article',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/page',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:4:"page";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;s:4:"page";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add/page',
  'title' => 'Basic page',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Use <em>basic pages</em> for your static content, such as an 'About us' page.",
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/test-content-type',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:17:"test_content_type";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;s:17:"test_content_type";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add/test-content-type',
  'title' => 'Test content type',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'This is the description of the test content type.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'rss.xml',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'node_feed',
  'page_arguments' => 'a:2:{i:0;b:0;i:1;a:0:{}}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'rss.xml',
  'title' => 'RSS feed',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'search_is_active',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'search_view',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'search',
  'title' => 'Search',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '20',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/search/search.pages.inc',
))
->values(array(
  'path' => 'search/node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_search_menu_access',
  'access_arguments' => 'a:1:{i:0;s:4:"node";}',
  'page_callback' => 'search_view',
  'page_arguments' => 'a:2:{i:0;s:4:"node";i:1;s:0:"";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'search',
  'tab_root' => 'search',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/search/search.pages.inc',
))
->values(array(
  'path' => 'search/node/%',
  'load_functions' => 'a:1:{i:2;a:1:{s:14:"menu_tail_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}',
  'to_arg_functions' => 'a:1:{i:2;s:16:"menu_tail_to_arg";}',
  'access_callback' => '_search_menu_access',
  'access_arguments' => 'a:1:{i:0;s:4:"node";}',
  'page_callback' => 'search_view',
  'page_arguments' => 'a:2:{i:0;s:4:"node";i:1;i:2;}',
  'delivery_callback' => '',
  'fit' => '6',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'search/node',
  'tab_root' => 'search/node/%',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/search/search.pages.inc',
))
->values(array(
  'path' => 'sites/default/files/styles/%',
  'load_functions' => 'a:1:{i:4;s:16:"image_style_load";}',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'image_style_deliver',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'sites/default/files/styles/%',
  'title' => 'Generate image style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'system/ajax',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'ajax_form_callback',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => 'ajax_deliver',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/ajax',
  'title' => 'AHAH callback',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'includes/form.inc',
))
->values(array(
  'path' => 'system/files',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'file_download',
  'page_arguments' => 'a:1:{i:0;s:7:"private";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/files',
  'title' => 'File download',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'system/files/styles/%',
  'load_functions' => 'a:1:{i:3;s:16:"image_style_load";}',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'image_style_deliver',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'delivery_callback' => '',
  'fit' => '14',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/files/styles/%',
  'title' => 'Generate image style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'system/temporary',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'file_download',
  'page_arguments' => 'a:1:{i:0;s:9:"temporary";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/temporary',
  'title' => 'Temporary files',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'system/timezone',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'system_timezone',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/timezone',
  'title' => 'Time zone',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'taxonomy/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'taxonomy_autocomplete',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'taxonomy/autocomplete',
  'title' => 'Autocomplete taxonomy',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.pages.inc',
))
->values(array(
  'path' => 'taxonomy/term/%',
  'load_functions' => 'a:1:{i:2;s:18:"taxonomy_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'taxonomy_term_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '6',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'taxonomy/term/%',
  'title' => 'Taxonomy term',
  'title_callback' => 'taxonomy_term_title',
  'title_arguments' => 'a:1:{i:0;i:2;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.pages.inc',
))
->values(array(
  'path' => 'taxonomy/term/%/edit',
  'load_functions' => 'a:1:{i:2;s:18:"taxonomy_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'taxonomy_term_edit_access',
  'access_arguments' => 'a:1:{i:0;i:2;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:18:"taxonomy_form_term";i:1;i:2;i:2;N;}',
  'delivery_callback' => '',
  'fit' => '13',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'taxonomy/term/%',
  'tab_root' => 'taxonomy/term/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'taxonomy/term/%/feed',
  'load_functions' => 'a:1:{i:2;s:18:"taxonomy_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'taxonomy_term_feed',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '13',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'taxonomy/term/%/feed',
  'title' => 'Taxonomy term',
  'title_callback' => 'taxonomy_term_title',
  'title_arguments' => 'a:1:{i:0;i:2;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.pages.inc',
))
->values(array(
  'path' => 'taxonomy/term/%/view',
  'load_functions' => 'a:1:{i:2;s:18:"taxonomy_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'taxonomy_term_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '13',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'taxonomy/term/%',
  'tab_root' => 'taxonomy/term/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.pages.inc',
))
->values(array(
  'path' => 'toolbar/toggle',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access toolbar";}',
  'page_callback' => 'toolbar_toggle_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'toolbar/toggle',
  'title' => 'Toggle drawer visibility',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'tracker',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'tracker_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'tracker',
  'title' => 'Recent content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/tracker/tracker.pages.inc',
))
->values(array(
  'path' => 'tracker/%',
  'load_functions' => 'a:1:{i:1;s:22:"user_uid_optional_load";}',
  'to_arg_functions' => 'a:1:{i:1;s:24:"user_uid_optional_to_arg";}',
  'access_callback' => '_tracker_myrecent_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'tracker_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '2',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'tracker',
  'tab_root' => 'tracker',
  'title' => 'My recent content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/tracker/tracker.pages.inc',
))
->values(array(
  'path' => 'tracker/all',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'tracker_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'tracker',
  'tab_root' => 'tracker',
  'title' => 'All recent content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/tracker/tracker.pages.inc',
))
->values(array(
  'path' => 'user',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user',
  'title' => 'User account',
  'title_callback' => 'user_menu_title',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_view_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_view_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '2',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/%',
  'title' => 'My account',
  'title_callback' => 'user_page_title',
  'title_arguments' => 'a:1:{i:0;i:1;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'user/%/cancel',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_cancel_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"user_cancel_confirm_form";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/%/cancel',
  'title' => 'Cancel account',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/cancel/confirm/%/%',
  'load_functions' => 'a:3:{i:1;s:9:"user_load";i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_cancel_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_cancel_confirm',
  'page_arguments' => 'a:3:{i:0;i:1;i:1;i:4;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '44',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/%/cancel/confirm/%/%',
  'title' => 'Confirm account cancellation',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/contact',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_contact_personal_tab_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"contact_personal_form";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'Contact',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/contact/contact.pages.inc',
))
->values(array(
  'path' => 'user/%/edit',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_edit_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/edit/account',
  'load_functions' => 'a:1:{i:1;a:1:{s:18:"user_category_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_edit_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '11',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'user/%/edit',
  'tab_root' => 'user/%',
  'title' => 'Account',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/shortcuts',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_set_switch_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:19:"shortcut_set_switch";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'Shortcuts',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
))
->values(array(
  'path' => 'user/%/track',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_tracker_user_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'tracker_page',
  'page_arguments' => 'a:2:{i:0;i:1;i:1;b:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'Track',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/tracker/tracker.pages.inc',
))
->values(array(
  'path' => 'user/%/track/content',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_tracker_user_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'tracker_page',
  'page_arguments' => 'a:2:{i:0;i:1;i:1;b:1;}',
  'delivery_callback' => '',
  'fit' => '11',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'user/%/track',
  'tab_root' => 'user/%',
  'title' => 'Track content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/tracker/tracker.pages.inc',
))
->values(array(
  'path' => 'user/%/track/navigation',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access statistics";}',
  'page_callback' => 'statistics_user_tracker',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '11',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'user/%/track',
  'tab_root' => 'user/%',
  'title' => 'Track page visits',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/statistics/statistics.pages.inc',
))
->values(array(
  'path' => 'user/%/view',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_view_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_view_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => '',
))
->values(array(
  'path' => 'user/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"access user profiles";}',
  'page_callback' => 'user_autocomplete',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/autocomplete',
  'title' => 'User autocomplete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/login',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_anonymous',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Log in',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/logout',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_logged_in',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_logout',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/logout',
  'title' => 'Log out',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/password',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:9:"user_pass";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Request new password',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/register',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_register_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"user_register_form";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Create new account',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'user/reset/%/%/%',
  'load_functions' => 'a:3:{i:2;N;i:3;N;i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:15:"user_pass_reset";i:1;i:2;i:2;i:3;i:3;i:4;}',
  'delivery_callback' => '',
  'fit' => '24',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/reset/%/%/%',
  'title' => 'Reset password',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->execute();
$connection->schema()->createTable('node', array(
  'fields' => array(
    'nid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'comment' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'promote' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'sticky' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'tnid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'translate' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node')
->fields(array(
  'nid',
  'vid',
  'type',
  'language',
  'title',
  'uid',
  'status',
  'created',
  'changed',
  'comment',
  'promote',
  'sticky',
  'tnid',
  'translate',
))
->values(array(
  'nid' => '1',
  'vid' => '1',
  'type' => 'test_content_type',
  'language' => 'en',
  'title' => 'A Node',
  'uid' => '2',
  'status' => '1',
  'created' => '1421727515',
  'changed' => '1421727536',
  'comment' => '2',
  'promote' => '1',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->execute();
$connection->schema()->createTable('node_access', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'gid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'realm' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'grant_view' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'grant_update' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'grant_delete' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'nid',
    'gid',
    'realm',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node_access')
->fields(array(
  'nid',
  'gid',
  'realm',
  'grant_view',
  'grant_update',
  'grant_delete',
))
->values(array(
  'nid' => '0',
  'gid' => '0',
  'realm' => 'all',
  'grant_view' => '1',
  'grant_update' => '0',
  'grant_delete' => '0',
))
->execute();
$connection->schema()->createTable('node_comment_statistics', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'cid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'last_comment_timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'last_comment_name' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '60',
    ),
    'last_comment_uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'comment_count' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('node_counter', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'totalcount' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'daycount' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node_counter')
->fields(array(
  'nid',
  'totalcount',
  'daycount',
  'timestamp',
))
->values(array(
  'nid' => '1',
  'totalcount' => '2',
  'daycount' => '0',
  'timestamp' => '1421727536',
))
->execute();
$connection->schema()->createTable('node_revision', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'log' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
    'comment' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'promote' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'sticky' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node_revision')
->fields(array(
  'nid',
  'vid',
  'uid',
  'title',
  'log',
  'timestamp',
  'status',
  'comment',
  'promote',
  'sticky',
))
->values(array(
  'nid' => '1',
  'vid' => '1',
  'uid' => '1',
  'title' => 'A Node',
  'log' => '',
  'timestamp' => '1441032132',
  'status' => '1',
  'comment' => '2',
  'promote' => '1',
  'sticky' => '0',
))
->execute();
$connection->schema()->createTable('node_type', array(
  'fields' => array(
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'base' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'help' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'has_title' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'title_label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'custom' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'modified' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'disabled' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'orig_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'type',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('node_type')
->fields(array(
  'type',
  'name',
  'base',
  'module',
  'description',
  'help',
  'has_title',
  'title_label',
  'custom',
  'modified',
  'locked',
  'disabled',
  'orig_type',
))
->values(array(
  'type' => 'article',
  'name' => 'Article',
  'base' => 'node_content',
  'module' => 'node',
  'description' => 'Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.',
  'help' => 'Help text for articles',
  'has_title' => '1',
  'title_label' => 'Title',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'disabled' => '0',
  'orig_type' => 'article',
))
->values(array(
  'type' => 'blog',
  'name' => 'Blog entry',
  'base' => 'blog',
  'module' => 'blog',
  'description' => 'Use for multi-user blogs. Every user gets a personal blog.',
  'help' => 'Blog away, good sir!',
  'has_title' => '1',
  'title_label' => 'Title',
  'custom' => '0',
  'modified' => '1',
  'locked' => '1',
  'disabled' => '1',
  'orig_type' => 'blog',
))
->values(array(
  'type' => 'forum',
  'name' => 'Forum topic',
  'base' => 'forum',
  'module' => 'forum',
  'description' => 'A <em>forum topic</em> starts a new discussion thread within a forum.',
  'help' => 'No name-calling, no flame wars. Be nice.',
  'has_title' => '1',
  'title_label' => 'Subject',
  'custom' => '0',
  'modified' => '1',
  'locked' => '1',
  'disabled' => '1',
  'orig_type' => 'forum',
))
->values(array(
  'type' => 'page',
  'name' => 'Basic page',
  'base' => 'node_content',
  'module' => 'node',
  'description' => "Use <em>basic pages</em> for your static content, such as an 'About us' page.",
  'help' => 'Help text for basic pages',
  'has_title' => '1',
  'title_label' => 'Title',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'disabled' => '0',
  'orig_type' => 'page',
))
->values(array(
  'type' => 'test_content_type',
  'name' => 'Test content type',
  'base' => 'node_content',
  'module' => 'node',
  'description' => 'This is the description of the test content type.',
  'help' => 'Help text for test content type',
  'has_title' => '1',
  'title_label' => 'Title',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'disabled' => '0',
  'orig_type' => 'test_content_type',
))
->execute();
$connection->schema()->createTable('picture_mapping', array(
  'fields' => array(
    'label' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'machine_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'breakpoint_group' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'mapping' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'machine_name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('picture_mapping')
->fields(array(
  'label',
  'machine_name',
  'breakpoint_group',
  'mapping',
))
->values(array(
  'label' => 'Narrow',
  'machine_name' => 'narrow',
  'breakpoint_group' => 'responsive_image',
  'mapping' => 'a:2:{s:38:"breakpoints.theme.my_theme_id.computer";a:3:{s:12:"multiplier_1";a:2:{s:12:"mapping_type";s:11:"image_style";s:11:"image_style";s:20:"custom_image_style_1";}s:12:"multiplier_2";a:3:{s:12:"mapping_type";s:5:"sizes";s:5:"sizes";i:2;s:18:"sizes_image_styles";a:2:{i:0;s:20:"custom_image_style_1";i:1;s:20:"custom_image_style_2";}}s:12:"multiplier_3";a:1:{s:12:"mapping_type";s:5:"_none";}}s:41:"breakpoints.theme.my_theme_id.computertwo";a:1:{s:12:"multiplier_2";a:3:{s:12:"mapping_type";s:5:"sizes";s:5:"sizes";i:2;s:18:"sizes_image_styles";a:2:{i:0;s:20:"custom_image_style_1";i:1;s:20:"custom_image_style_2";}}}}',
))
->execute();
$connection->schema()->createTable('queue', array(
  'fields' => array(
    'item_id' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'item_id',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('rdf_mapping', array(
  'fields' => array(
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ),
    'mapping' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'type',
    'bundle',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('rdf_mapping')
->fields(array(
  'type',
  'bundle',
  'mapping',
))
->values(array(
  'type' => 'node',
  'bundle' => 'article',
  'mapping' => 'a:11:{s:11:"field_image";a:2:{s:10:"predicates";a:2:{i:0;s:8:"og:image";i:1;s:12:"rdfs:seeAlso";}s:4:"type";s:3:"rel";}s:10:"field_tags";a:2:{s:10:"predicates";a:1:{i:0;s:10:"dc:subject";}s:4:"type";s:3:"rel";}s:7:"rdftype";a:2:{i:0;s:9:"sioc:Item";i:1;s:13:"foaf:Document";}s:5:"title";a:1:{s:10:"predicates";a:1:{i:0;s:8:"dc:title";}}s:7:"created";a:3:{s:10:"predicates";a:2:{i:0;s:7:"dc:date";i:1;s:10:"dc:created";}s:8:"datatype";s:12:"xsd:dateTime";s:8:"callback";s:12:"date_iso8601";}s:7:"changed";a:3:{s:10:"predicates";a:1:{i:0;s:11:"dc:modified";}s:8:"datatype";s:12:"xsd:dateTime";s:8:"callback";s:12:"date_iso8601";}s:4:"body";a:1:{s:10:"predicates";a:1:{i:0;s:15:"content:encoded";}}s:3:"uid";a:2:{s:10:"predicates";a:1:{i:0;s:16:"sioc:has_creator";}s:4:"type";s:3:"rel";}s:4:"name";a:1:{s:10:"predicates";a:1:{i:0;s:9:"foaf:name";}}s:13:"comment_count";a:2:{s:10:"predicates";a:1:{i:0;s:16:"sioc:num_replies";}s:8:"datatype";s:11:"xsd:integer";}s:13:"last_activity";a:3:{s:10:"predicates";a:1:{i:0;s:23:"sioc:last_activity_date";}s:8:"datatype";s:12:"xsd:dateTime";s:8:"callback";s:12:"date_iso8601";}}',
))
->values(array(
  'type' => 'node',
  'bundle' => 'blog',
  'mapping' => 'a:9:{s:7:"rdftype";a:2:{i:0;s:9:"sioc:Post";i:1;s:14:"sioct:BlogPost";}s:5:"title";a:1:{s:10:"predicates";a:1:{i:0;s:8:"dc:title";}}s:7:"created";a:3:{s:10:"predicates";a:2:{i:0;s:7:"dc:date";i:1;s:10:"dc:created";}s:8:"datatype";s:12:"xsd:dateTime";s:8:"callback";s:12:"date_iso8601";}s:7:"changed";a:3:{s:10:"predicates";a:1:{i:0;s:11:"dc:modified";}s:8:"datatype";s:12:"xsd:dateTime";s:8:"callback";s:12:"date_iso8601";}s:4:"body";a:1:{s:10:"predicates";a:1:{i:0;s:15:"content:encoded";}}s:3:"uid";a:2:{s:10:"predicates";a:1:{i:0;s:16:"sioc:has_creator";}s:4:"type";s:3:"rel";}s:4:"name";a:1:{s:10:"predicates";a:1:{i:0;s:9:"foaf:name";}}s:13:"comment_count";a:2:{s:10:"predicates";a:1:{i:0;s:16:"sioc:num_replies";}s:8:"datatype";s:11:"xsd:integer";}s:13:"last_activity";a:3:{s:10:"predicates";a:1:{i:0;s:23:"sioc:last_activity_date";}s:8:"datatype";s:12:"xsd:dateTime";s:8:"callback";s:12:"date_iso8601";}}',
))
->values(array(
  'type' => 'node',
  'bundle' => 'forum',
  'mapping' => 'a:10:{s:7:"rdftype";a:2:{i:0;s:9:"sioc:Post";i:1;s:15:"sioct:BoardPost";}s:15:"taxonomy_forums";a:2:{s:10:"predicates";a:1:{i:0;s:18:"sioc:has_container";}s:4:"type";s:3:"rel";}s:5:"title";a:1:{s:10:"predicates";a:1:{i:0;s:8:"dc:title";}}s:7:"created";a:3:{s:10:"predicates";a:2:{i:0;s:7:"dc:date";i:1;s:10:"dc:created";}s:8:"datatype";s:12:"xsd:dateTime";s:8:"callback";s:12:"date_iso8601";}s:7:"changed";a:3:{s:10:"predicates";a:1:{i:0;s:11:"dc:modified";}s:8:"datatype";s:12:"xsd:dateTime";s:8:"callback";s:12:"date_iso8601";}s:4:"body";a:1:{s:10:"predicates";a:1:{i:0;s:15:"content:encoded";}}s:3:"uid";a:2:{s:10:"predicates";a:1:{i:0;s:16:"sioc:has_creator";}s:4:"type";s:3:"rel";}s:4:"name";a:1:{s:10:"predicates";a:1:{i:0;s:9:"foaf:name";}}s:13:"comment_count";a:2:{s:10:"predicates";a:1:{i:0;s:16:"sioc:num_replies";}s:8:"datatype";s:11:"xsd:integer";}s:13:"last_activity";a:3:{s:10:"predicates";a:1:{i:0;s:23:"sioc:last_activity_date";}s:8:"datatype";s:12:"xsd:dateTime";s:8:"callback";s:12:"date_iso8601";}}',
))
->values(array(
  'type' => 'node',
  'bundle' => 'page',
  'mapping' => 'a:9:{s:7:"rdftype";a:1:{i:0;s:13:"foaf:Document";}s:5:"title";a:1:{s:10:"predicates";a:1:{i:0;s:8:"dc:title";}}s:7:"created";a:3:{s:10:"predicates";a:2:{i:0;s:7:"dc:date";i:1;s:10:"dc:created";}s:8:"datatype";s:12:"xsd:dateTime";s:8:"callback";s:12:"date_iso8601";}s:7:"changed";a:3:{s:10:"predicates";a:1:{i:0;s:11:"dc:modified";}s:8:"datatype";s:12:"xsd:dateTime";s:8:"callback";s:12:"date_iso8601";}s:4:"body";a:1:{s:10:"predicates";a:1:{i:0;s:15:"content:encoded";}}s:3:"uid";a:2:{s:10:"predicates";a:1:{i:0;s:16:"sioc:has_creator";}s:4:"type";s:3:"rel";}s:4:"name";a:1:{s:10:"predicates";a:1:{i:0;s:9:"foaf:name";}}s:13:"comment_count";a:2:{s:10:"predicates";a:1:{i:0;s:16:"sioc:num_replies";}s:8:"datatype";s:11:"xsd:integer";}s:13:"last_activity";a:3:{s:10:"predicates";a:1:{i:0;s:23:"sioc:last_activity_date";}s:8:"datatype";s:12:"xsd:dateTime";s:8:"callback";s:12:"date_iso8601";}}',
))
->values(array(
  'type' => 'taxonomy_term',
  'bundle' => 'forums',
  'mapping' => 'a:5:{s:7:"rdftype";a:2:{i:0;s:14:"sioc:Container";i:1;s:10:"sioc:Forum";}s:4:"name";a:1:{s:10:"predicates";a:2:{i:0;s:10:"rdfs:label";i:1;s:14:"skos:prefLabel";}}s:11:"description";a:1:{s:10:"predicates";a:1:{i:0;s:15:"skos:definition";}}s:3:"vid";a:2:{s:10:"predicates";a:1:{i:0;s:13:"skos:inScheme";}s:4:"type";s:3:"rel";}s:6:"parent";a:2:{s:10:"predicates";a:1:{i:0;s:12:"skos:broader";}s:4:"type";s:3:"rel";}}',
))
->execute();
$connection->schema()->createTable('registry', array(
  'fields' => array(
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '9',
      'default' => '',
    ),
    'filename' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'name',
    'type',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('registry')
->fields(array(
  'name',
  'type',
  'filename',
  'module',
  'weight',
))
->values(array(
  'name' => 'AccessDeniedTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'AdminMetaTagTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ArchiverInterface',
  'type' => 'interface',
  'filename' => 'includes/archiver.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'ArchiverTar',
  'type' => 'class',
  'filename' => 'modules/system/system.archiver.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ArchiverZip',
  'type' => 'class',
  'filename' => 'modules/system/system.archiver.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'Archive_Tar',
  'type' => 'class',
  'filename' => 'modules/system/system.tar.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'BatchMemoryQueue',
  'type' => 'class',
  'filename' => 'includes/batch.queue.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'BatchQueue',
  'type' => 'class',
  'filename' => 'includes/batch.queue.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockAdminThemeTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '-5',
))
->values(array(
  'name' => 'BlockCacheTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '-5',
))
->values(array(
  'name' => 'BlockHashTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '-5',
))
->values(array(
  'name' => 'BlockHiddenRegionTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '-5',
))
->values(array(
  'name' => 'BlockHTMLIdTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '-5',
))
->values(array(
  'name' => 'BlockInvalidRegionTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '-5',
))
->values(array(
  'name' => 'BlockTemplateSuggestionsUnitTest',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '-5',
))
->values(array(
  'name' => 'BlockTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '-5',
))
->values(array(
  'name' => 'BlockViewModuleDeltaAlterWebTest',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '-5',
))
->values(array(
  'name' => 'BreakpointGroupAdminTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/breakpoints/breakpoints.test',
  'module' => 'breakpoints',
  'weight' => '0',
))
->values(array(
  'name' => 'BreakpointGroupCRUDTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/breakpoints/breakpoints.test',
  'module' => 'breakpoints',
  'weight' => '0',
))
->values(array(
  'name' => 'BreakpointGroupTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/breakpoints/breakpoints.test',
  'module' => 'breakpoints',
  'weight' => '0',
))
->values(array(
  'name' => 'BreakpointMultipliersTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/breakpoints/breakpoints.test',
  'module' => 'breakpoints',
  'weight' => '0',
))
->values(array(
  'name' => 'BreakpointsAdminTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/breakpoints/breakpoints.test',
  'module' => 'breakpoints',
  'weight' => '0',
))
->values(array(
  'name' => 'BreakpointsCRUDTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/breakpoints/breakpoints.test',
  'module' => 'breakpoints',
  'weight' => '0',
))
->values(array(
  'name' => 'BreakpointsTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/breakpoints/breakpoints.test',
  'module' => 'breakpoints',
  'weight' => '0',
))
->values(array(
  'name' => 'BreakpointsThemeTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/breakpoints/breakpoints.test',
  'module' => 'breakpoints',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentActionsTestCase',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentAnonymous',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentApprovalTest',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentBlockFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentContentRebuild',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentController',
  'type' => 'class',
  'filename' => 'modules/comment/comment.module',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentFieldsTest',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentHelperCase',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentInterfaceTest',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentNodeAccessTest',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentNodeChangesTestCase',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentPagerTest',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentPreviewTest',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentRSSUnitTest',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentThreadingTestCase',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentTokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentUninstallTestCase',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'ConfirmFormTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ContactPersonalTestCase',
  'type' => 'class',
  'filename' => 'modules/contact/contact.test',
  'module' => 'contact',
  'weight' => '0',
))
->values(array(
  'name' => 'ContactSitewideTestCase',
  'type' => 'class',
  'filename' => 'modules/contact/contact.test',
  'module' => 'contact',
  'weight' => '0',
))
->values(array(
  'name' => 'CronQueueTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'CronRunTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsContextIDTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/contrib/ctools/tests/context.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsContextKeywordsSubstitutionTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/contrib/ctools/tests/context.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsContextUnitTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/contrib/ctools/tests/context.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CToolsCssCache',
  'type' => 'class',
  'filename' => 'sites/all/modules/contrib/ctools/includes/css-cache.inc',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsCSSObjectCache',
  'type' => 'class',
  'filename' => 'sites/all/modules/contrib/ctools/tests/css_cache.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsCssTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/contrib/ctools/tests/css.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsMathExpressionStackTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/contrib/ctools/tests/math_expression_stack.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsMathExpressionTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/contrib/ctools/tests/math_expression.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsModuleTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/contrib/ctools/tests/ctools.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsObjectCache',
  'type' => 'class',
  'filename' => 'sites/all/modules/contrib/ctools/tests/object_cache.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsPageTokens',
  'type' => 'class',
  'filename' => 'sites/all/modules/contrib/ctools/tests/page_tokens.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsPluginsGetInfoTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/contrib/ctools/tests/ctools.plugins.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'CtoolsUnitObjectCachePlugins',
  'type' => 'class',
  'filename' => 'sites/all/modules/contrib/ctools/tests/object_cache_unit.test',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'ctools_context',
  'type' => 'class',
  'filename' => 'sites/all/modules/contrib/ctools/includes/context.inc',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'ctools_context_optional',
  'type' => 'class',
  'filename' => 'sites/all/modules/contrib/ctools/includes/context.inc',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'ctools_context_required',
  'type' => 'class',
  'filename' => 'sites/all/modules/contrib/ctools/includes/context.inc',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'ctools_export_ui',
  'type' => 'class',
  'filename' => 'sites/all/modules/contrib/ctools/plugins/export_ui/ctools_export_ui.class.php',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'ctools_math_expr',
  'type' => 'class',
  'filename' => 'sites/all/modules/contrib/ctools/includes/math-expr.inc',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'ctools_math_expr_stack',
  'type' => 'class',
  'filename' => 'sites/all/modules/contrib/ctools/includes/math-expr.inc',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'ctools_stylizer_image_processor',
  'type' => 'class',
  'filename' => 'sites/all/modules/contrib/ctools/includes/stylizer.inc',
  'module' => 'ctools',
  'weight' => '0',
))
->values(array(
  'name' => 'Database',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseCondition',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnection',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnectionNotDefinedException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnection_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnection_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnection_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseDriverNotSpecifiedException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseLog',
  'type' => 'class',
  'filename' => 'includes/database/log.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchema',
  'type' => 'class',
  'filename' => 'includes/database/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchemaObjectDoesNotExistException',
  'type' => 'class',
  'filename' => 'includes/database/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchemaObjectExistsException',
  'type' => 'class',
  'filename' => 'includes/database/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchema_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchema_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchema_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatementBase',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatementEmpty',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatementInterface',
  'type' => 'interface',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatementPrefetch',
  'type' => 'class',
  'filename' => 'includes/database/prefetch.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatement_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTaskException',
  'type' => 'class',
  'filename' => 'includes/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTasks',
  'type' => 'class',
  'filename' => 'includes/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTasks_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTasks_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTasks_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransaction',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionCommitFailedException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionExplicitCommitNotAllowedException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionNameNonUniqueException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionNoActiveException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionOutOfOrderException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DateApiTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/date/date_api/tests/DateApiTestCase.test',
  'module' => 'date_api',
  'weight' => '0',
))
->values(array(
  'name' => 'DateApiUnitTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/date/date_api/tests/DateApiUnitTestCase.test',
  'module' => 'date_api',
  'weight' => '0',
))
->values(array(
  'name' => 'DateEmwTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/date/tests/DateEmwTestCase.test',
  'module' => 'date',
  'weight' => '0',
))
->values(array(
  'name' => 'DateFieldTestBase',
  'type' => 'class',
  'filename' => 'sites/all/modules/date/tests/DateFieldTestBase.test',
  'module' => 'date',
  'weight' => '0',
))
->values(array(
  'name' => 'DateFieldTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/date/tests/DateFieldTestCase.test',
  'module' => 'date',
  'weight' => '0',
))
->values(array(
  'name' => 'DateFormatTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DateFormTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/date/tests/DateFormTestCase.test',
  'module' => 'date',
  'weight' => '0',
))
->values(array(
  'name' => 'DateMigrateFieldHandler',
  'type' => 'class',
  'filename' => 'sites/all/modules/date/date.migrate.inc',
  'module' => 'date',
  'weight' => '0',
))
->values(array(
  'name' => 'DateMigrateTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/date/tests/DateMigrateTestCase.test',
  'module' => 'date',
  'weight' => '0',
))
->values(array(
  'name' => 'DateNowUnitTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/date/tests/DateNowUnitTestCase.test',
  'module' => 'date',
  'weight' => '0',
))
->values(array(
  'name' => 'DateObject',
  'type' => 'class',
  'filename' => 'sites/all/modules/date/date_api/date_api.module',
  'module' => 'date_api',
  'weight' => '0',
))
->values(array(
  'name' => 'DateTimeFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DateTimezoneTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/date/tests/DateTimezoneTestCase.test',
  'module' => 'date',
  'weight' => '0',
))
->values(array(
  'name' => 'DateUiTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/date/tests/DateUiTestCase.test',
  'module' => 'date',
  'weight' => '0',
))
->values(array(
  'name' => 'DateValidationTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/date/tests/DateValidationTestCase.test',
  'module' => 'date',
  'weight' => '0',
))
->values(array(
  'name' => 'date_sql_handler',
  'type' => 'class',
  'filename' => 'sites/all/modules/date/date_api/date_api_sql.inc',
  'module' => 'date_api',
  'weight' => '0',
))
->values(array(
  'name' => 'DefaultMailSystem',
  'type' => 'class',
  'filename' => 'modules/system/system.mail.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DeleteQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DeleteQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalCacheArray',
  'type' => 'class',
  'filename' => 'includes/bootstrap.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalCacheInterface',
  'type' => 'interface',
  'filename' => 'includes/cache.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalDatabaseCache',
  'type' => 'class',
  'filename' => 'includes/cache.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalDefaultEntityController',
  'type' => 'class',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalEntityControllerInterface',
  'type' => 'interface',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalFakeCache',
  'type' => 'class',
  'filename' => 'includes/cache-install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalLocalStreamWrapper',
  'type' => 'class',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalPrivateStreamWrapper',
  'type' => 'class',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalPublicStreamWrapper',
  'type' => 'class',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalQueue',
  'type' => 'class',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalQueueInterface',
  'type' => 'interface',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalReliableQueueInterface',
  'type' => 'interface',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalRequestSanitizer',
  'type' => 'class',
  'filename' => 'includes/request-sanitizer.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalSetMessageTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalStreamWrapperInterface',
  'type' => 'interface',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalTemporaryStreamWrapper',
  'type' => 'class',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalUpdateException',
  'type' => 'class',
  'filename' => 'includes/update.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalUpdaterInterface',
  'type' => 'interface',
  'filename' => 'includes/updater.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'EnableDisableTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'Entity',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityAPICommentNodeAccessTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityAPIController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.controller.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityAPIControllerExportable',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.controller.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityAPIControllerInterface',
  'type' => 'interface',
  'filename' => 'sites/all/modules/entity/includes/entity.controller.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityAPIControllerRevisionableInterface',
  'type' => 'interface',
  'filename' => 'sites/all/modules/entity/includes/entity.controller.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityAPIi18nItegrationTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityAPIRulesIntegrationTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityAPITestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityBundleableUIController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.ui.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityContentUIController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.ui.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDB',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDBExtendable',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDefaultExtraFieldsController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.info.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDefaultFeaturesController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.features.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDefaultI18nStringController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.i18n.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDefaultMetadataController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.info.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDefaultRulesController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.rules.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDefaultUIController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.ui.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDefaultViewsController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/entity.views.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDrupalWrapper',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityExtendable',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityExtraFieldsControllerInterface',
  'type' => 'interface',
  'filename' => 'sites/all/modules/entity/entity.info.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityFieldHandlerHelper',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_field_handler_helper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityFieldQuery',
  'type' => 'class',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityFieldQueryException',
  'type' => 'class',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityInterface',
  'type' => 'interface',
  'filename' => 'sites/all/modules/entity/includes/entity.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityListWrapper',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMalformedException',
  'type' => 'class',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataArrayObject',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataIntegrationTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataNodeAccessTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataNodeCreateAccessTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataNodeRevisionAccessTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataTaxonomyAccessTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataWrapper',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataWrapperException',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataWrapperIterator',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityPropertiesTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityReferenceAdminTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entityreference/tests/entityreference.admin.test',
  'module' => 'entityreference',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityReferenceBehavior_TaxonomyIndex',
  'type' => 'class',
  'filename' => 'sites/all/modules/entityreference/plugins/behavior/EntityReferenceBehavior_TaxonomyIndex.class.php',
  'module' => 'entityreference',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityReferenceHandlersTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entityreference/tests/entityreference.handlers.test',
  'module' => 'entityreference',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityReferenceTaxonomyTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entityreference/tests/entityreference.taxonomy.test',
  'module' => 'entityreference',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityReference_BehaviorHandler',
  'type' => 'interface',
  'filename' => 'sites/all/modules/entityreference/plugins/behavior/abstract.inc',
  'module' => 'entityreference',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityReference_BehaviorHandler_Abstract',
  'type' => 'class',
  'filename' => 'sites/all/modules/entityreference/plugins/behavior/abstract.inc',
  'module' => 'entityreference',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityReference_BehaviorHandler_Broken',
  'type' => 'class',
  'filename' => 'sites/all/modules/entityreference/plugins/behavior/abstract.inc',
  'module' => 'entityreference',
  'weight' => '0',
))
->values(array(
  'name' => 'entityreference_plugin_display',
  'type' => 'class',
  'filename' => 'sites/all/modules/entityreference/views/entityreference_plugin_display.inc',
  'module' => 'entityreference',
  'weight' => '0',
))
->values(array(
  'name' => 'entityreference_plugin_row_fields',
  'type' => 'class',
  'filename' => 'sites/all/modules/entityreference/views/entityreference_plugin_row_fields.inc',
  'module' => 'entityreference',
  'weight' => '0',
))
->values(array(
  'name' => 'entityreference_plugin_style',
  'type' => 'class',
  'filename' => 'sites/all/modules/entityreference/views/entityreference_plugin_style.inc',
  'module' => 'entityreference',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityReference_SelectionHandler',
  'type' => 'interface',
  'filename' => 'sites/all/modules/entityreference/plugins/selection/abstract.inc',
  'module' => 'entityreference',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityReference_SelectionHandler_Broken',
  'type' => 'class',
  'filename' => 'sites/all/modules/entityreference/plugins/selection/abstract.inc',
  'module' => 'entityreference',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityReference_SelectionHandler_Generic',
  'type' => 'class',
  'filename' => 'sites/all/modules/entityreference/plugins/selection/EntityReference_SelectionHandler_Generic.class.php',
  'module' => 'entityreference',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityReference_SelectionHandler_Generic_comment',
  'type' => 'class',
  'filename' => 'sites/all/modules/entityreference/plugins/selection/EntityReference_SelectionHandler_Generic.class.php',
  'module' => 'entityreference',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityReference_SelectionHandler_Generic_file',
  'type' => 'class',
  'filename' => 'sites/all/modules/entityreference/plugins/selection/EntityReference_SelectionHandler_Generic.class.php',
  'module' => 'entityreference',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityReference_SelectionHandler_Generic_node',
  'type' => 'class',
  'filename' => 'sites/all/modules/entityreference/plugins/selection/EntityReference_SelectionHandler_Generic.class.php',
  'module' => 'entityreference',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityReference_SelectionHandler_Generic_taxonomy_term',
  'type' => 'class',
  'filename' => 'sites/all/modules/entityreference/plugins/selection/EntityReference_SelectionHandler_Generic.class.php',
  'module' => 'entityreference',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityReference_SelectionHandler_Generic_user',
  'type' => 'class',
  'filename' => 'sites/all/modules/entityreference/plugins/selection/EntityReference_SelectionHandler_Generic.class.php',
  'module' => 'entityreference',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityStructureWrapper',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityTokenTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityTranslationCommentHandler',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/includes/translation.handler.comment.inc',
  'module' => 'entity_translation',
  'weight' => '11',
))
->values(array(
  'name' => 'EntityTranslationDefaultHandler',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/includes/translation.handler.inc',
  'module' => 'entity_translation',
  'weight' => '11',
))
->values(array(
  'name' => 'EntityTranslationHandlerFactory',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/includes/translation.handler_factory.inc',
  'module' => 'entity_translation',
  'weight' => '11',
))
->values(array(
  'name' => 'EntityTranslationHandlerInterface',
  'type' => 'interface',
  'filename' => 'sites/all/modules/entity_translation/includes/translation.handler.inc',
  'module' => 'entity_translation',
  'weight' => '11',
))
->values(array(
  'name' => 'EntityTranslationNodeHandler',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/includes/translation.handler.node.inc',
  'module' => 'entity_translation',
  'weight' => '11',
))
->values(array(
  'name' => 'EntityTranslationTaxonomyTermHandler',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/includes/translation.handler.taxonomy_term.inc',
  'module' => 'entity_translation',
  'weight' => '11',
))
->values(array(
  'name' => 'EntityTranslationUserHandler',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/includes/translation.handler.user.inc',
  'module' => 'entity_translation',
  'weight' => '11',
))
->values(array(
  'name' => 'EntityValueWrapper',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityWebTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_translation_handler_field_field',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/views/entity_translation_handler_field_field.inc',
  'module' => 'entity_translation',
  'weight' => '11',
))
->values(array(
  'name' => 'entity_translation_handler_field_label',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/views/entity_translation_handler_field_label.inc',
  'module' => 'entity_translation',
  'weight' => '11',
))
->values(array(
  'name' => 'entity_translation_handler_field_translate_link',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/views/entity_translation_handler_field_translate_link.inc',
  'module' => 'entity_translation',
  'weight' => '11',
))
->values(array(
  'name' => 'entity_translation_handler_filter_entity_type',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/views/entity_translation_handler_filter_entity_type.inc',
  'module' => 'entity_translation',
  'weight' => '11',
))
->values(array(
  'name' => 'entity_translation_handler_filter_language',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/views/entity_translation_handler_filter_language.inc',
  'module' => 'entity_translation',
  'weight' => '11',
))
->values(array(
  'name' => 'entity_translation_handler_filter_translation_exists',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/views/entity_translation_handler_filter_translation_exists.inc',
  'module' => 'entity_translation',
  'weight' => '11',
))
->values(array(
  'name' => 'entity_translation_handler_relationship',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/views/entity_translation_handler_relationship.inc',
  'module' => 'entity_translation',
  'weight' => '11',
))
->values(array(
  'name' => 'entity_views_handler_area_entity',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_area_entity.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_boolean',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_boolean.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_date',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_date.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_duration',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_duration.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_entity',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_entity.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_field',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_field.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_numeric',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_numeric.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_options',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_options.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_text',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_text.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_uri',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_uri.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_relationship',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_relationship.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_relationship_by_bundle',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_relationship_by_bundle.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_plugin_row_entity_view',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/plugins/entity_views_plugin_row_entity_view.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'FeedsMapperFieldTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entityreference/tests/entityreference.feeds.test',
  'module' => 'entityreference',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldAttachOtherTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldAttachStorageTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldAttachTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldBulkDeleteTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldCrudTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldDisplayAPITestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldException',
  'type' => 'class',
  'filename' => 'modules/field/field.module',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldFormTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldInfo',
  'type' => 'class',
  'filename' => 'modules/field/field.info.class.inc',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldInfoTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldInstanceCrudTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldsOverlapException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldSqlStorageTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/field_sql_storage/field_sql_storage.test',
  'module' => 'field_sql_storage',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldTranslationsTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUIAlterTestCase',
  'type' => 'class',
  'filename' => 'modules/field_ui/field_ui.test',
  'module' => 'field_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUIManageDisplayTestCase',
  'type' => 'class',
  'filename' => 'modules/field_ui/field_ui.test',
  'module' => 'field_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUIManageFieldsTestCase',
  'type' => 'class',
  'filename' => 'modules/field_ui/field_ui.test',
  'module' => 'field_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUITestCase',
  'type' => 'class',
  'filename' => 'modules/field_ui/field_ui.test',
  'module' => 'field_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUpdateForbiddenException',
  'type' => 'class',
  'filename' => 'modules/field/field.module',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldValidationException',
  'type' => 'class',
  'filename' => 'modules/field/field.attach.inc',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldAnonymousSubmission',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldDisplayTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldPathTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldRevisionTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldValidateTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldWidgetTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileManagedFileElementTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FilePrivateTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileScanDirectory',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTaxonomyTermTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransfer',
  'type' => 'class',
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferChmodInterface',
  'type' => 'interface',
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferException',
  'type' => 'class',
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferFTP',
  'type' => 'class',
  'filename' => 'includes/filetransfer/ftp.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferFTPExtension',
  'type' => 'class',
  'filename' => 'includes/filetransfer/ftp.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferLocal',
  'type' => 'class',
  'filename' => 'includes/filetransfer/local.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferSSH',
  'type' => 'class',
  'filename' => 'includes/filetransfer/ssh.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterCRUDTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterDefaultFormatTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterDOMSerializeTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterFormatAccessTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterHooksTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterNoFormatTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterSecurityTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterSettingsTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterUnitTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FloodFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'FrontPageTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'HookRequirementsTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageAdminStylesUnitTest',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageAdminUiTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageDimensionsScaleTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageDimensionsTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageEffectsUnitTest',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageFieldDefaultImagesTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageFieldDisplayTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageFieldValidateTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageStyleFlushTest',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageStylesPathAndUrlTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageThemeFunctionWebTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'InfoFileParserTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'InsertQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'InsertQuery_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'InsertQuery_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'InsertQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'InvalidMergeQueryException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'IPAddressBlockingTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'LinkBaseTestClass',
  'type' => 'class',
  'filename' => 'sites/all/modules/link/tests/LinkBaseTestClass.test',
  'module' => 'link',
  'weight' => '0',
))
->values(array(
  'name' => 'LinkConvertInternalPathsTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/link/tests/LinkConvertInternalPathsTest.test',
  'module' => 'link',
  'weight' => '0',
))
->values(array(
  'name' => 'LinkDefaultProtocolTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/link/tests/LinkDefaultProtocolTest.test',
  'module' => 'link',
  'weight' => '0',
))
->values(array(
  'name' => 'LinkEntityTokenTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/link/tests/LinkEntityTokenTest.test',
  'module' => 'link',
  'weight' => '0',
))
->values(array(
  'name' => 'LinkFieldAttributesTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/link/tests/LinkFieldAttributesTest.test',
  'module' => 'link',
  'weight' => '0',
))
->values(array(
  'name' => 'LinkFieldCrudTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/link/tests/LinkFieldCrudTest.test',
  'module' => 'link',
  'weight' => '0',
))
->values(array(
  'name' => 'LinkFieldValidateTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/link/tests/LinkFieldValidateTest.test',
  'module' => 'link',
  'weight' => '0',
))
->values(array(
  'name' => 'LinkPathPrefixesTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/link/tests/LinkPathPrefixesTest.test',
  'module' => 'link',
  'weight' => '0',
))
->values(array(
  'name' => 'LinkSanitizeTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/link/tests/LinkSanitizeTest.test',
  'module' => 'link',
  'weight' => '0',
))
->values(array(
  'name' => 'LinkTokenTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/link/tests/LinkTokenTest.test',
  'module' => 'link',
  'weight' => '0',
))
->values(array(
  'name' => 'LinkUnitTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/link/tests/LinkUnitTestCase.test',
  'module' => 'link',
  'weight' => '0',
))
->values(array(
  'name' => 'LinkValidationApiTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/link/tests/LinkValidationApiTest.test',
  'module' => 'link',
  'weight' => '0',
))
->values(array(
  'name' => 'link_views_handler_argument_target',
  'type' => 'class',
  'filename' => 'sites/all/modules/link/views/link_views_handler_argument_target.inc',
  'module' => 'link',
  'weight' => '0',
))
->values(array(
  'name' => 'link_views_handler_filter_protocol',
  'type' => 'class',
  'filename' => 'sites/all/modules/link/views/link_views_handler_filter_protocol.inc',
  'module' => 'link',
  'weight' => '0',
))
->values(array(
  'name' => 'ListDynamicValuesTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/list/tests/list.test',
  'module' => 'list',
  'weight' => '0',
))
->values(array(
  'name' => 'ListDynamicValuesValidationTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/list/tests/list.test',
  'module' => 'list',
  'weight' => '0',
))
->values(array(
  'name' => 'ListFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/list/tests/list.test',
  'module' => 'list',
  'weight' => '0',
))
->values(array(
  'name' => 'ListFieldUITestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/list/tests/list.test',
  'module' => 'list',
  'weight' => '0',
))
->values(array(
  'name' => 'MailSystemInterface',
  'type' => 'interface',
  'filename' => 'includes/mail.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'MemoryQueue',
  'type' => 'class',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'MenuNodeTestCase',
  'type' => 'class',
  'filename' => 'modules/menu/menu.test',
  'module' => 'menu',
  'weight' => '0',
))
->values(array(
  'name' => 'MenuTestCase',
  'type' => 'class',
  'filename' => 'modules/menu/menu.test',
  'module' => 'menu',
  'weight' => '0',
))
->values(array(
  'name' => 'MergeQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'MigrateEntityReferenceFieldHandler',
  'type' => 'class',
  'filename' => 'sites/all/modules/entityreference/entityreference.migrate.inc',
  'module' => 'entityreference',
  'weight' => '0',
))
->values(array(
  'name' => 'MigrateLinkFieldHandler',
  'type' => 'class',
  'filename' => 'sites/all/modules/link/link.migrate.inc',
  'module' => 'link',
  'weight' => '0',
))
->values(array(
  'name' => 'MigrateTranslationEntityHandler',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity_translation/includes/translation.migrate.inc',
  'module' => 'entity_translation',
  'weight' => '11',
))
->values(array(
  'name' => 'ModuleDependencyTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ModuleRequiredTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ModuleTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ModuleUpdater',
  'type' => 'class',
  'filename' => 'modules/system/system.updater.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ModuleVersionTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'MultiStepNodeFormBasicOptionsTest',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NewDefaultThemeBlocks',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '-5',
))
->values(array(
  'name' => 'NodeAccessBaseTableTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessPagerTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessRebuildTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessRecordsTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeBlockFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeBlockTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeBuildContent',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeController',
  'type' => 'class',
  'filename' => 'modules/node/node.module',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeCreationTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeEntityFieldQueryAlter',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeEntityViewModeAlterTest',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeFeedTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeLoadHooksTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeLoadMultipleTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeMultiByteUtf8Test',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodePageCacheTest',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodePostSettingsTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeQueryAlter',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeRevisionPermissionsTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeRevisionsTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeRSSContentTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeSaveTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTitleTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTitleXSSTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTypePersistenceTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTypeTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeWebTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NoFieldsException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'NonDefaultBlockAdmin',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '-5',
))
->values(array(
  'name' => 'NumberFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/number/number.test',
  'module' => 'number',
  'weight' => '0',
))
->values(array(
  'name' => 'OptionsSelectDynamicValuesTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/options/options.test',
  'module' => 'options',
  'weight' => '0',
))
->values(array(
  'name' => 'OptionsWidgetsTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/options/options.test',
  'module' => 'options',
  'weight' => '0',
))
->values(array(
  'name' => 'PageEditTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'PageNotFoundTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'PagePreviewTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'PagerDefault',
  'type' => 'class',
  'filename' => 'includes/pager.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'PageTitleFiltering',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'PageViewTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'PathLanguageTestCase',
  'type' => 'class',
  'filename' => 'modules/path/path.test',
  'module' => 'path',
  'weight' => '0',
))
->values(array(
  'name' => 'PathLanguageUITestCase',
  'type' => 'class',
  'filename' => 'modules/path/path.test',
  'module' => 'path',
  'weight' => '0',
))
->values(array(
  'name' => 'PathMonolingualTestCase',
  'type' => 'class',
  'filename' => 'modules/path/path.test',
  'module' => 'path',
  'weight' => '0',
))
->values(array(
  'name' => 'PathTaxonomyTermTestCase',
  'type' => 'class',
  'filename' => 'modules/path/path.test',
  'module' => 'path',
  'weight' => '0',
))
->values(array(
  'name' => 'PathTestCase',
  'type' => 'class',
  'filename' => 'modules/path/path.test',
  'module' => 'path',
  'weight' => '0',
))
->values(array(
  'name' => 'Query',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueryAlterableInterface',
  'type' => 'interface',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueryConditionInterface',
  'type' => 'interface',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueryExtendableInterface',
  'type' => 'interface',
  'filename' => 'includes/database/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueryPlaceholderInterface',
  'type' => 'interface',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueueTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'RdfCommentAttributesTestCase',
  'type' => 'class',
  'filename' => 'modules/rdf/rdf.test',
  'module' => 'rdf',
  'weight' => '0',
))
->values(array(
  'name' => 'RdfCrudTestCase',
  'type' => 'class',
  'filename' => 'modules/rdf/rdf.test',
  'module' => 'rdf',
  'weight' => '0',
))
->values(array(
  'name' => 'RdfGetRdfNamespacesTestCase',
  'type' => 'class',
  'filename' => 'modules/rdf/rdf.test',
  'module' => 'rdf',
  'weight' => '0',
))
->values(array(
  'name' => 'RdfMappingDefinitionTestCase',
  'type' => 'class',
  'filename' => 'modules/rdf/rdf.test',
  'module' => 'rdf',
  'weight' => '0',
))
->values(array(
  'name' => 'RdfMappingHookTestCase',
  'type' => 'class',
  'filename' => 'modules/rdf/rdf.test',
  'module' => 'rdf',
  'weight' => '0',
))
->values(array(
  'name' => 'RdfRdfaMarkupTestCase',
  'type' => 'class',
  'filename' => 'modules/rdf/rdf.test',
  'module' => 'rdf',
  'weight' => '0',
))
->values(array(
  'name' => 'RdfTrackerAttributesTestCase',
  'type' => 'class',
  'filename' => 'modules/rdf/rdf.test',
  'module' => 'rdf',
  'weight' => '0',
))
->values(array(
  'name' => 'RetrieveFileTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SchemaCache',
  'type' => 'class',
  'filename' => 'includes/bootstrap.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchAdvancedSearchForm',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchBlockTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchCommentCountToggleTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchCommentTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchConfigSettingsForm',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchEmbedForm',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchExactTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchExcerptTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchExpressionInsertExtractTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchKeywordsConditions',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchLanguageTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchMatchTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchNodeAccessTest',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchNodeTagTest',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchNumberMatchingTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchNumbersTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchPageOverride',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchPageText',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchQuery',
  'type' => 'class',
  'filename' => 'modules/search/search.extender.inc',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchRankingTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchSetLocaleTest',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchSimplifyTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchTokenizerTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQuery',
  'type' => 'class',
  'filename' => 'includes/database/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQueryExtender',
  'type' => 'class',
  'filename' => 'includes/database/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQueryInterface',
  'type' => 'interface',
  'filename' => 'includes/database/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQuery_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'ShortcutLinksTestCase',
  'type' => 'class',
  'filename' => 'modules/shortcut/shortcut.test',
  'module' => 'shortcut',
  'weight' => '0',
))
->values(array(
  'name' => 'ShortcutSetsTestCase',
  'type' => 'class',
  'filename' => 'modules/shortcut/shortcut.test',
  'module' => 'shortcut',
  'weight' => '0',
))
->values(array(
  'name' => 'ShortcutTestCase',
  'type' => 'class',
  'filename' => 'modules/shortcut/shortcut.test',
  'module' => 'shortcut',
  'weight' => '0',
))
->values(array(
  'name' => 'ShutdownFunctionsTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SiteMaintenanceTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SkipDotsRecursiveDirectoryIterator',
  'type' => 'class',
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'StatisticsAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/statistics/statistics.test',
  'module' => 'statistics',
  'weight' => '0',
))
->values(array(
  'name' => 'StatisticsBlockVisitorsTestCase',
  'type' => 'class',
  'filename' => 'modules/statistics/statistics.test',
  'module' => 'statistics',
  'weight' => '0',
))
->values(array(
  'name' => 'StatisticsLoggingTestCase',
  'type' => 'class',
  'filename' => 'modules/statistics/statistics.test',
  'module' => 'statistics',
  'weight' => '0',
))
->values(array(
  'name' => 'StatisticsReportsTestCase',
  'type' => 'class',
  'filename' => 'modules/statistics/statistics.test',
  'module' => 'statistics',
  'weight' => '0',
))
->values(array(
  'name' => 'StatisticsTestCase',
  'type' => 'class',
  'filename' => 'modules/statistics/statistics.test',
  'module' => 'statistics',
  'weight' => '0',
))
->values(array(
  'name' => 'StatisticsTokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/statistics/statistics.test',
  'module' => 'statistics',
  'weight' => '0',
))
->values(array(
  'name' => 'StreamWrapperInterface',
  'type' => 'interface',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SummaryLengthTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemAuthorizeCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemBlockTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemIndexPhpTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemInfoAlterTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemMainContentFallback',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemQueue',
  'type' => 'class',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemThemeFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemValidTokenTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'TableSort',
  'type' => 'class',
  'filename' => 'includes/tablesort.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyEFQTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyHooksTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyLegacyTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyLoadMultipleTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyQueryAlterTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyRSSTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyTermController',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.module',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyTermFieldMultipleVocabularyTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyTermFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyTermFunctionTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyTermIndexTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyTermTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyThemeTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyTokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyVocabularyController',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.module',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyVocabularyFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyVocabularyTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyWebTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TestingMailSystem',
  'type' => 'class',
  'filename' => 'modules/system/system.mail.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'TextFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/text/text.test',
  'module' => 'text',
  'weight' => '0',
))
->values(array(
  'name' => 'TextSummaryTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/text/text.test',
  'module' => 'text',
  'weight' => '0',
))
->values(array(
  'name' => 'TextTranslationTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/text/text.test',
  'module' => 'text',
  'weight' => '0',
))
->values(array(
  'name' => 'ThemeRegistry',
  'type' => 'class',
  'filename' => 'includes/theme.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'ThemeUpdater',
  'type' => 'class',
  'filename' => 'modules/system/system.updater.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'TokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'TokenScanTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'TrackerTest',
  'type' => 'class',
  'filename' => 'modules/tracker/tracker.test',
  'module' => 'tracker',
  'weight' => '0',
))
->values(array(
  'name' => 'TruncateQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'TruncateQuery_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'TruncateQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateQuery_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateQuery_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'Updater',
  'type' => 'class',
  'filename' => 'includes/updater.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdaterException',
  'type' => 'class',
  'filename' => 'includes/updater.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdaterFileTransferException',
  'type' => 'class',
  'filename' => 'includes/updater.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateScriptFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'UserAccountLinksUnitTests',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserAuthmapAssignmentTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserAutocompleteTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserBlocksUnitTests',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserCancelTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserController',
  'type' => 'class',
  'filename' => 'modules/user/user.module',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserCreateTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserEditedOwnAccountTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserEditRebuildTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserEditTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserLoginTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserPasswordResetTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserPermissionsTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserPictureTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserRegistrationTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserRoleAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserRolesAssignmentTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserSaveTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserSignatureTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserTimeZoneFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserTokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserUserSearchTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserValidateCurrentPassCustomForm',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserValidationTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->execute();
$connection->schema()->createTable('registry_file', array(
  'fields' => array(
    'filename' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'hash' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
  ),
  'primary key' => array(
    'filename',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('registry_file')
->fields(array(
  'filename',
  'hash',
))
->values(array(
  'filename' => 'includes/actions.inc',
  'hash' => 'f36b066681463c7dfe189e0430cb1a89bf66f7e228cbb53cdfcd93987193f759',
))
->values(array(
  'filename' => 'includes/ajax.inc',
  'hash' => '8d5ebead219c48d5929ee6a5a178a331471ee6ceb38653094514c952457eaebd',
))
->values(array(
  'filename' => 'includes/archiver.inc',
  'hash' => 'bdbb21b712a62f6b913590b609fd17cd9f3c3b77c0d21f68e71a78427ed2e3e9',
))
->values(array(
  'filename' => 'includes/authorize.inc',
  'hash' => '6d64d8c21aa01eb12fc29918732e4df6b871ed06e5d41373cb95c197ed661d13',
))
->values(array(
  'filename' => 'includes/batch.inc',
  'hash' => '3480548cff18a67cf26072e041058cabe64bb839c6320a9050dc32eb87534aef',
))
->values(array(
  'filename' => 'includes/batch.queue.inc',
  'hash' => '554b2e92e1dad0f7fd5a19cb8dff7e109f10fbe2441a5692d076338ec908de0f',
))
->values(array(
  'filename' => 'includes/bootstrap.inc',
  'hash' => '8a62bcca75a615107ec00e67e41c36ff62ad35f86d89a8d91de9657a0c19be7e',
))
->values(array(
  'filename' => 'includes/cache-install.inc',
  'hash' => 'e7ed123c5805703c84ad2cce9c1ca46b3ce8caeeea0d8ef39a3024a4ab95fa0e',
))
->values(array(
  'filename' => 'includes/cache.inc',
  'hash' => '033c9bf2555dba29382b077f78cc00c82fd7f42a959ba31b710adddf6fdf24fe',
))
->values(array(
  'filename' => 'includes/common.inc',
  'hash' => '2753cfc73593c885f6bc4552a3caac37803c76c30266ab23150cfe2e7954baa4',
))
->values(array(
  'filename' => 'includes/database/database.inc',
  'hash' => 'b335c1866792dbec12f35ad175baa2dad423756264d1340f348c68f2d6107a30',
))
->values(array(
  'filename' => 'includes/database/log.inc',
  'hash' => '9feb5a17ae2fabcf26a96d2a634ba73da501f7bcfc3599a693d916a6971d00d1',
))
->values(array(
  'filename' => 'includes/database/mysql/database.inc',
  'hash' => '2112e646839a821dfd1c808402149eef44654605f48b9dbb2de6a68ce7b0b476',
))
->values(array(
  'filename' => 'includes/database/mysql/install.inc',
  'hash' => '6ae316941f771732fbbabed7e1d6b4cbb41b1f429dd097d04b3345aa15e461a0',
))
->values(array(
  'filename' => 'includes/database/mysql/query.inc',
  'hash' => 'cddf695f7dbd483591f93af805e7118a04eac3f21c0105326642c6463587670c',
))
->values(array(
  'filename' => 'includes/database/mysql/schema.inc',
  'hash' => 'c34aa7b7d2cb4662965497ff86f242224116bbd9b72ca6287c12039a65feb72e',
))
->values(array(
  'filename' => 'includes/database/pgsql/database.inc',
  'hash' => '27131a7199c04225105b1bfdebe4bda33bf3855289160db8bf2073627560fd30',
))
->values(array(
  'filename' => 'includes/database/pgsql/install.inc',
  'hash' => '39587f26a9e054afaab2064d996af910f1b201ef1c6b82938ef130e4ff8c6aab',
))
->values(array(
  'filename' => 'includes/database/pgsql/query.inc',
  'hash' => '0df57377686c921e722a10b49d5e433b131176c8059a4ace4680964206fc14b4',
))
->values(array(
  'filename' => 'includes/database/pgsql/schema.inc',
  'hash' => '1588daadfa53506aa1f5d94572162a45a46dc3ceabdd0e2f224532ded6508403',
))
->values(array(
  'filename' => 'includes/database/pgsql/select.inc',
  'hash' => '1e509bc97c58223750e8ea735145b316827e36f43c07b946003e41f5bca23659',
))
->values(array(
  'filename' => 'includes/database/prefetch.inc',
  'hash' => 'b5b207a66a69ecb52ee4f4459af16a7b5eabedc87254245f37cc33bebb61c0fb',
))
->values(array(
  'filename' => 'includes/database/query.inc',
  'hash' => '982d44a294eea1c9619687c14df2987257e3776fcabeba05f01432e934cf61c6',
))
->values(array(
  'filename' => 'includes/database/schema.inc',
  'hash' => 'da9d48f26c3a47a91f1eb2fa216e9deab2ec42ba10c76039623ce7b6bc984a06',
))
->values(array(
  'filename' => 'includes/database/select.inc',
  'hash' => 'a6cc53e57d7b401998c1ef73f0cca0012021c9fa74fc07a346a8bfa6041dfb61',
))
->values(array(
  'filename' => 'includes/database/sqlite/database.inc',
  'hash' => '22e80c5a02c143eace3628e196dded78552e6f2889d1989d052e2a37f46e7f0f',
))
->values(array(
  'filename' => 'includes/database/sqlite/install.inc',
  'hash' => '6620f354aa175a116ba3a0562c980d86cc3b8b481042fc3cc5ed6a4d1a7a6d74',
))
->values(array(
  'filename' => 'includes/database/sqlite/query.inc',
  'hash' => '5d4dc3ac34cb2dbc0293471e85e37c890da3da6cd8c0c540c6f33313e4c0cbe9',
))
->values(array(
  'filename' => 'includes/database/sqlite/schema.inc',
  'hash' => '223f150f314374835c636ba3ada9a1ccd5159a6e09adfc22570953c3c4d855e2',
))
->values(array(
  'filename' => 'includes/database/sqlite/select.inc',
  'hash' => '8d1c426dbd337733c206cce9f59a172546c6ed856d8ef3f1c7bef05a16f7bf68',
))
->values(array(
  'filename' => 'includes/date.inc',
  'hash' => '1de2c25e3b67a9919fc6c8061594442b6fb2cdd3a48ddf1591ee3aa98484b737',
))
->values(array(
  'filename' => 'includes/entity.inc',
  'hash' => 'f06b508f93e72ba70f979d8391be57662c018a03a32fac0a6d3baa752740133d',
))
->values(array(
  'filename' => 'includes/errors.inc',
  'hash' => '27b1535bf2937e2fe2dc57a51afc694e3a9fa0063d8ba78cdbde19226feeaac6',
))
->values(array(
  'filename' => 'includes/file.inc',
  'hash' => '8c4b185c5805ee811e7d6292e2924de24ebf30080f74c173bf8d5cc771c4fff6',
))
->values(array(
  'filename' => 'includes/file.mimetypes.inc',
  'hash' => '33266e837f4ce076378e7e8cef6c5af46446226ca4259f83e13f605856a7f147',
))
->values(array(
  'filename' => 'includes/file.phar.inc',
  'hash' => '544df23f736ce49f458033d6515a301a8ca1c7a7d1bfd3f388caef910534abb3',
))
->values(array(
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'hash' => '68442c03fd8612297a0d1ab86437ff9072fe1b71516f4c1e9f581d137a774698',
))
->values(array(
  'filename' => 'includes/filetransfer/ftp.inc',
  'hash' => '51eb119b8e1221d598ffa6cc46c8a322aa77b49a3d8879f7fb38b7221cf7e06d',
))
->values(array(
  'filename' => 'includes/filetransfer/local.inc',
  'hash' => '7cbfdb46abbdf539640db27e66fb30e5265128f31002bd0dfc3af16ae01a9492',
))
->values(array(
  'filename' => 'includes/filetransfer/ssh.inc',
  'hash' => '92f1232158cb32ab04cbc93ae38ad3af04796e18f66910a9bc5ca8e437f06891',
))
->values(array(
  'filename' => 'includes/form.inc',
  'hash' => 'b60eb9f0d9992a2f0a3ba01064d527b08631029cb23ae566b6e6015781ba159e',
))
->values(array(
  'filename' => 'includes/graph.inc',
  'hash' => '8e0e313a8bb33488f371df11fc1b58d7cf80099b886cd1003871e2c896d1b536',
))
->values(array(
  'filename' => 'includes/image.inc',
  'hash' => 'bcdc7e1599c02227502b9d0fe36eeb2b529b130a392bc709eb737647bd361826',
))
->values(array(
  'filename' => 'includes/install.core.inc',
  'hash' => '189653e4bb7d4828bd6e1b61015fabcc7182e23d9dd8858170f98114d99400c8',
))
->values(array(
  'filename' => 'includes/install.inc',
  'hash' => '4d0b8c1532a8829051e17f275fa27e9c379ab826aee2e27229a9679ea6775da7',
))
->values(array(
  'filename' => 'includes/iso.inc',
  'hash' => '0ce4c225edcfa9f037703bc7dd09d4e268a69bcc90e55da0a3f04c502bd2f349',
))
->values(array(
  'filename' => 'includes/json-encode.inc',
  'hash' => '02a822a652d00151f79db9aa9e171c310b69b93a12f549bc2ce00533a8efa14e',
))
->values(array(
  'filename' => 'includes/language.inc',
  'hash' => '4e08f30843a7ccaeea5c041083e9f77d33d57ff002f1ab4f66168e2c683ce128',
))
->values(array(
  'filename' => 'includes/locale.inc',
  'hash' => 'ca50acc0780cbffeca17f99a0997f91b8b9402f0eec1898c3122e1d73664d01d',
))
->values(array(
  'filename' => 'includes/lock.inc',
  'hash' => 'a181c8bd4f88d292a0a73b9f1fbd727e3314f66ec3631f288e6b9a54ba2b70fa',
))
->values(array(
  'filename' => 'includes/mail.inc',
  'hash' => 'a7bef724e057f7410e42c8f33b00c9a0246a2ca2e856a113c9e20eecc49fc069',
))
->values(array(
  'filename' => 'includes/menu.inc',
  'hash' => 'cc578019be3301a6bb6294508b91b97d9ac24e410920fca5af312931097d82d2',
))
->values(array(
  'filename' => 'includes/module.inc',
  'hash' => '943626f94bc69e95e36fde030475d57893f3296f0f8df461e2ee9f122dd37473',
))
->values(array(
  'filename' => 'includes/pager.inc',
  'hash' => '7d8d827eb2baace7031a02fd4b15a5e684928cd8345f878dd707adce11f93bd2',
))
->values(array(
  'filename' => 'includes/password.inc',
  'hash' => 'fd9a1c94fe5a0fa7c7049a2435c7280b1d666b2074595010e3c492dd15712775',
))
->values(array(
  'filename' => 'includes/path.inc',
  'hash' => 'acfd48f5582893af86cbb5ccf331ddb43bbf2671e879e5424a21c928d06d949f',
))
->values(array(
  'filename' => 'includes/registry.inc',
  'hash' => '2067cc87973e7af23428d3f41b8f8739d80092bc3c9e20b5a8858e481d03f22c',
))
->values(array(
  'filename' => 'includes/request-sanitizer.inc',
  'hash' => '770e8ece7b53d13e2b5ef99da02adb9a3d18071c6cd29eb01af30927cf749a73',
))
->values(array(
  'filename' => 'includes/session.inc',
  'hash' => 'b762ae828625b350a146ef18301a47ca54ff7ff9c3a1a4b62e1310719030afd7',
))
->values(array(
  'filename' => 'includes/stream_wrappers.inc',
  'hash' => 'b8a5a53f3d3ef26ea868037547f76af8049ce0c55b464810c627310a84f24924',
))
->values(array(
  'filename' => 'includes/tablesort.inc',
  'hash' => '2d88768a544829595dd6cda2a5eb008bedb730f36bba6dfe005d9ddd999d5c0f',
))
->values(array(
  'filename' => 'includes/theme.inc',
  'hash' => 'ae46daba6419ca613bc6a08ba4d7f9bbab9b19889937099d2e4c1737e9e7b2df',
))
->values(array(
  'filename' => 'includes/theme.maintenance.inc',
  'hash' => '39f068b3eee4d10a90d6aa3c86db587b6d25844c2919d418d34d133cfe330f5a',
))
->values(array(
  'filename' => 'includes/token.inc',
  'hash' => '5e7898cd78689e2c291ed3cd8f41c032075656896f1db57e49217aac19ae0428',
))
->values(array(
  'filename' => 'includes/unicode.entities.inc',
  'hash' => '2b858138596d961fbaa4c6e3986e409921df7f76b6ee1b109c4af5970f1e0f54',
))
->values(array(
  'filename' => 'includes/unicode.inc',
  'hash' => 'e18772dafe0f80eb139fcfc582fef1704ba9f730647057d4f4841d6a6e4066ca',
))
->values(array(
  'filename' => 'includes/update.inc',
  'hash' => '25c30f1e61ef9c91a7bdeb37791c2215d9dc2ae07dba124722d783ca31bb01e7',
))
->values(array(
  'filename' => 'includes/updater.inc',
  'hash' => 'd2da0e74ed86e93c209f16069f3d32e1a134ceb6c06a0044f78e841a1b54e380',
))
->values(array(
  'filename' => 'includes/utility.inc',
  'hash' => '3458fd2b55ab004dd0cc529b8e58af12916e8bd36653b072bdd820b26b907ed5',
))
->values(array(
  'filename' => 'includes/xmlrpc.inc',
  'hash' => 'ea24176ec445c440ba0c825fc7b04a31b440288df8ef02081560dc418e34e659',
))
->values(array(
  'filename' => 'includes/xmlrpcs.inc',
  'hash' => '925c4d5bf429ad9650f059a8862a100bd394dce887933f5b3e7e32309a51fd8e',
))
->values(array(
  'filename' => 'modules/block/block.test',
  'hash' => '40d9de00589211770a85c47d38c8ad61c598ec65d9332128a882eb8750e65a16',
))
->values(array(
  'filename' => 'modules/comment/comment.module',
  'hash' => 'db858137ff6ce06d87cb3b8f5275bed90c33a6d9aa7d46e7a74524cc2f052309',
))
->values(array(
  'filename' => 'modules/comment/comment.test',
  'hash' => '9c05ad98e4c2e1b00c95c6a3ef71d97c5aaa87f1bc5f9c3ae5d3378b05b16c2f',
))
->values(array(
  'filename' => 'modules/contact/contact.test',
  'hash' => '655e8d5fe7536a972c2233e438a142166b15a118cc644e94b756c2814c375634',
))
->values(array(
  'filename' => 'modules/field/field.attach.inc',
  'hash' => '2df4687b5ec078c4893dc1fea514f67524fd5293de717b9e05caf977e5ae2327',
))
->values(array(
  'filename' => 'modules/field/field.info.class.inc',
  'hash' => 'cf18178e119d43897d3abd882ba3acc0cf59d1ad747663437c57b1ec4d0a4322',
))
->values(array(
  'filename' => 'modules/field/field.module',
  'hash' => '48b5b83f214a8d19e446f46c5d7a1cd35faa656ccb7b540f9f02462a440cacdd',
))
->values(array(
  'filename' => 'modules/field/modules/field_sql_storage/field_sql_storage.test',
  'hash' => '6a5af7ced221d48e06395a7d99053ed462b9f1fe747320f3b91bdafd0027e2f6',
))
->values(array(
  'filename' => 'modules/field/modules/list/tests/list.test',
  'hash' => 'c1a214d7efd3247dd947d742a8514ec9649da62593608dfdccee6913d48e5709',
))
->values(array(
  'filename' => 'modules/field/modules/number/number.test',
  'hash' => '4392f6fadf67c7533725e12bbe15ee2624cd54158e153f42f6cad3c28144395e',
))
->values(array(
  'filename' => 'modules/field/modules/options/options.test',
  'hash' => '1b30956b6f46840ccb41b99bda08f328172f008f1fb4164c65fe9e4047fffa5f',
))
->values(array(
  'filename' => 'modules/field/modules/text/text.test',
  'hash' => '5c28b9da26417d2ed8a169850989c0b59f2b188a0161eb58e2b87c67994d602d',
))
->values(array(
  'filename' => 'modules/field/tests/field.test',
  'hash' => '57564727e284c7936821430d87ea9f4fd293ce53969ec5d6c12673c9609fa90f',
))
->values(array(
  'filename' => 'modules/field_ui/field_ui.test',
  'hash' => 'f535e5627c969e9083a63aaf72d4ac645e30709d7b87af15c6c3b870481f283a',
))
->values(array(
  'filename' => 'modules/file/tests/file.test',
  'hash' => 'c5f7592b47329f7a3ab44f9c218eebcef639760cd78180b566551c53bcfe9473',
))
->values(array(
  'filename' => 'modules/filter/filter.test',
  'hash' => 'b8aa5e6b832422c6ad5fe963898ec9526c814614f27ecccb67107ce194997d6a',
))
->values(array(
  'filename' => 'modules/image/image.test',
  'hash' => '3e2bb37305f9453ac35360fc334203ba62e55ef6bd6e161f89a46d3cd19dcc93',
))
->values(array(
  'filename' => 'modules/menu/menu.test',
  'hash' => 'db0600ff4e9d2159ecf26c991cbb81931edb32513a0bb7716964ee84006dd912',
))
->values(array(
  'filename' => 'modules/node/node.module',
  'hash' => 'a0431f275b291779ffd1061d7d98b6942106235350b807828e94c6929ad04a41',
))
->values(array(
  'filename' => 'modules/node/node.test',
  'hash' => '3bda67d59aecead1d17f9275097c684602ac98e47e7e4ec5df7d47f23dece338',
))
->values(array(
  'filename' => 'modules/path/path.test',
  'hash' => 'e7dabb4bbb7afd1b09adf1e64438b74726fc122422b31c7ae6d8e0ed2f7df6b6',
))
->values(array(
  'filename' => 'modules/rdf/rdf.test',
  'hash' => '9849d2b717119aa6b5f1496929e7ac7c9c0a6e98486b66f3876bda0a8c165525',
))
->values(array(
  'filename' => 'modules/search/search.extender.inc',
  'hash' => '1a92d28913cd9d7cd0d2ec007848e079c14e84a8bcb9423e70ad97309ac14eb6',
))
->values(array(
  'filename' => 'modules/search/search.test',
  'hash' => 'e43c21510d510885dfad6484afa931382083b75b7e67286bda56a6aafe265f28',
))
->values(array(
  'filename' => 'modules/shortcut/shortcut.test',
  'hash' => '0d78280d4d0a05aa772218e45911552e39611ca9c258b9dd436307914ac3f254',
))
->values(array(
  'filename' => 'modules/statistics/statistics.test',
  'hash' => '7abe4cce7ef548637d709e22cf340f9973b6d77615a470949d20a6426f5b08f2',
))
->values(array(
  'filename' => 'modules/system/system.archiver.inc',
  'hash' => '05caceec7b3baecfebd053959c513f134a5ae4070749339495274a81bebb904a',
))
->values(array(
  'filename' => 'modules/system/system.mail.inc',
  'hash' => 'd2f4fca46269981db5edb6316176b7b8161de59d4c24c514b63fe3c536ebb4d6',
))
->values(array(
  'filename' => 'modules/system/system.queue.inc',
  'hash' => 'a77a5913d84368092805ac551ca63737c1d829455504fcccb95baa2932f28009',
))
->values(array(
  'filename' => 'modules/system/system.tar.inc',
  'hash' => '80e6ea94b67b260e055562eb1bc222a64d5258b6da86b4754a2dd2e435f84e74',
))
->values(array(
  'filename' => 'modules/system/system.test',
  'hash' => '6315d4c3306d99f6143a3b59b6556d15d4b60dfc28239a91ee1b0c0c48828704',
))
->values(array(
  'filename' => 'modules/system/system.updater.inc',
  'hash' => '9433fa8d39500b8c59ab05f41c0aac83b2586a43be4aa949821380e36c4d3c48',
))
->values(array(
  'filename' => 'modules/taxonomy/taxonomy.module',
  'hash' => '010e2eba7166174b1d188330e8368c6022d3f790c46d9ae79f63f69b5f8d1df8',
))
->values(array(
  'filename' => 'modules/taxonomy/taxonomy.test',
  'hash' => 'ce91ff8a2879d65fdb3477d3f437cad8ef50b8963dadb75ae203854987b2c23a',
))
->values(array(
  'filename' => 'modules/tracker/tracker.test',
  'hash' => '5669b4d8f6ea7f652a4dd47f31de6b68f2cbc087e30fedbf7db0df5bef1470c2',
))
->values(array(
  'filename' => 'modules/user/user.module',
  'hash' => '615a2e5a894a9aa4c206834f3e1592ea21b2be7399906504f14c6eaf801200eb',
))
->values(array(
  'filename' => 'modules/user/user.test',
  'hash' => '9f72176ec0d23baa50a36e5a62a52d28b073dcbc23231006d371581200ea860c',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/includes/context.inc',
  'hash' => '6a5acd0653649817b69c8aa43216184eedce8fb41abec727105bd89cdcd70ac5',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/includes/css-cache.inc',
  'hash' => 'db90ff67669d9fa445e91074ac67fb97cdb191a19e68d42744f0fd4158649cfa',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/includes/math-expr.inc',
  'hash' => '0573737d85980dedf76cc9c82fbc2654ed07fce8ff7a8da4be2e2cd7de67b99f',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/includes/stylizer.inc',
  'hash' => 'a19b912a79e6d982a6bfbb660c108a047e41283a23e1b12e4b9c22af51771add',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/plugins/export_ui/ctools_export_ui.class.php',
  'hash' => 'e52390387db144ae2125882f0b2739360450f26e1180aaf4907cd1b3b4038982',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/tests/context.test',
  'hash' => 'bc23a86c5c32a0335c970f1e51ad6d60cc02d006de3d5cb5ee0bbdaa84d5bcd3',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/tests/css.test',
  'hash' => '832c58634157083e988797bf878c5fd6b9640e187802a397763e25771eced028',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/tests/css_cache.test',
  'hash' => '331564b96148bb666b306ead748b8b18a7baf746e96d6564b9685a23ca47a888',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/tests/ctools.plugins.test',
  'hash' => '2dbabab681d5a9e15e093aef5a48732dcdb030680b932c7a0c7260e444751919',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/tests/ctools.test',
  'hash' => '427659c5c3db1e8638539b6dd1a440451e043129172a42f66f3f9bbd15e8db0b',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/tests/math_expression.test',
  'hash' => '0fa0cd1f54c9a3791a5d77220bfee16baa868d0911f0c834b9682346ba8c0df6',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/tests/math_expression_stack.test',
  'hash' => '203b98c797d7eaa787c6481c1ab9482c0ca45559314f79632d7c5efb51d7d170',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/tests/object_cache.test',
  'hash' => '0af88e1d17b8265ac621799922934dded7c44073c001acf8c1c47d0187cb52fa',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/tests/object_cache_unit.test',
  'hash' => '9fd7871c5f0307247469bcdd488f3086126f5f7978d6a470f8ecb8a6dc4b5a1e',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/tests/page_tokens.test',
  'hash' => '078f82bd0957d8821521388fa270e70e10e9f143c1012ebac60f2dfd4d9ab1a4',
))
->values(array(
  'filename' => 'sites/all/modules/date/date.migrate.inc',
  'hash' => '3fec62a1b4d4860bb56f65834f210f7eaf88834fa3eace42ca23e758366c3d0c',
))
->values(array(
  'filename' => 'sites/all/modules/date/date_api/date_api.module',
  'hash' => '1749b063a1ee3c9739a1441aa4263b1cf1b0cede29c5b7b62110ed232a85eda9',
))
->values(array(
  'filename' => 'sites/all/modules/date/date_api/date_api_sql.inc',
  'hash' => '4dd9067c481a6dba23c2c7c0c750bd486094492ffef27e5390aafea8bb9abd40',
))
->values(array(
  'filename' => 'sites/all/modules/date/date_api/tests/DateApiTestCase.test',
  'hash' => 'bbe155f782d0f140502c9ff789948f1b6818c3cf50b8403eb956dd082c4101be',
))
->values(array(
  'filename' => 'sites/all/modules/date/date_api/tests/DateApiUnitTestCase.test',
  'hash' => '20eb5343a9c9630d938cfc0942c7df93d8e51057ab8248e9787e82be3988dd34',
))
->values(array(
  'filename' => 'sites/all/modules/date/tests/DateEmwTestCase.test',
  'hash' => '31e0232337fdd1421ab56fa3b8222f3c00f10adcd9acc4b33f958a953e975602',
))
->values(array(
  'filename' => 'sites/all/modules/date/tests/DateFieldTestBase.test',
  'hash' => '14e918424afec18ad78ec4fbd45c19d0ac4a5bd899c4934bf435640d03b2518b',
))
->values(array(
  'filename' => 'sites/all/modules/date/tests/DateFieldTestCase.test',
  'hash' => 'e824b2de4b3a102c37ab05296302b69e65d5b614ba16e30cc25b5783ab26a1a8',
))
->values(array(
  'filename' => 'sites/all/modules/date/tests/DateFormTestCase.test',
  'hash' => 'a2c0c2f9419f719d225e2682a3b0ca3db8303152890f90158cf35e95c0141929',
))
->values(array(
  'filename' => 'sites/all/modules/date/tests/DateMigrateTestCase.test',
  'hash' => '475831fa64600a19403cbdef4197259c8fcb18a503cc79c6ae7ed6da9406f7f2',
))
->values(array(
  'filename' => 'sites/all/modules/date/tests/DateNowUnitTestCase.test',
  'hash' => '5c581060bc03b5e3aed5662e68490d35c16361ceb05626a338dcd7a1c9fdc781',
))
->values(array(
  'filename' => 'sites/all/modules/date/tests/DateTimezoneTestCase.test',
  'hash' => '4e11a7788b7d855c5cd8a1f1728f89437f09ceb63056895275fcff2bb329036b',
))
->values(array(
  'filename' => 'sites/all/modules/date/tests/DateUiTestCase.test',
  'hash' => 'a37fdb3e7d970777a4a37a191d5b3a51b7a6b4af2c23018983b8a4cc987c036f',
))
->values(array(
  'filename' => 'sites/all/modules/date/tests/DateValidationTestCase.test',
  'hash' => 'c91aca108cc33706e6912d773f5caf2ad0cafb186c13440d72f81b9857807c61',
))
->values(array(
  'filename' => 'sites/all/modules/entity/entity.features.inc',
  'hash' => '53f537caf6ad9355fb92b2c6db019959abdf399d80764151dd976b0891f37436',
))
->values(array(
  'filename' => 'sites/all/modules/entity/entity.i18n.inc',
  'hash' => '41e0e62af7e2774f62b162d597bb3244551c280296b692b29d039a2c243d7059',
))
->values(array(
  'filename' => 'sites/all/modules/entity/entity.info.inc',
  'hash' => '8799080b9393c9560e64feae1276fb7d26fef4d92bb0edacc863ee3e7b67bf04',
))
->values(array(
  'filename' => 'sites/all/modules/entity/entity.rules.inc',
  'hash' => '774199059d1b3ebe6d3fe7a49dbb1550df489055a3d066b5de54edda8dd7ba84',
))
->values(array(
  'filename' => 'sites/all/modules/entity/entity.test',
  'hash' => 'aba6490cd2041438d832dc8f63b213e0d171a5a218f6d51a9fe00c51e95069ce',
))
->values(array(
  'filename' => 'sites/all/modules/entity/includes/entity.controller.inc',
  'hash' => 'b85d1882fae38ee8a0e82bf75952f44f65a58fd95e3bf0c3cb2a1321cf4d308a',
))
->values(array(
  'filename' => 'sites/all/modules/entity/includes/entity.inc',
  'hash' => '02c3c8b1d4b7230f875c4fae8e6ba3bd57431e01f312b32f3ed305a7be734774',
))
->values(array(
  'filename' => 'sites/all/modules/entity/includes/entity.ui.inc',
  'hash' => '49653cbbccc4b4e51f957727aa95803c149fac9565f53ed553e2cd1c1c3580ff',
))
->values(array(
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'hash' => 'c728444ea73d4d5a7f0ec4cc80c7b749ab3134e1d0b973f8c001936c3dd5b861',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/entity.views.inc',
  'hash' => '089b8ed3103f62778be3395a99ddfbd84da4235f5ad431392f8984eaa4bf349f',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_field_handler_helper.inc',
  'hash' => '88e4cbbbeab9bbaa4c928118bdefb158ea99f343f813cf88cce01ed7fbf8bf6a',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_area_entity.inc',
  'hash' => '39ac643c4365394ac54190c4d130ea5787de423b9dadc14a470687a64cfbc8ab',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_boolean.inc',
  'hash' => 'b28b8eee8761ba7a6af35d97ab7aaee28406e6c227271f9769818560626c5791',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_date.inc',
  'hash' => 'b0f5be5b399de94934b24e84c8cf6053a043f6b00c60dcffa752daeafdd38778',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_duration.inc',
  'hash' => 'ed7bb64cb63b94a20c8cde98cfb053b5ea252804396cf61ac562faf1d850266b',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_entity.inc',
  'hash' => '4f255918a22fefebe9c7734f200751457a7ca4d3648e32a98511bb51968d7521',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_field.inc',
  'hash' => '893121efbce2a7181e31147bade260c9cc657cbd33b0d254cb28b2650e57566d',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_numeric.inc',
  'hash' => 'f14e2b063930e8820af381b4f5e83c7278440e7804ab88cfde865b6c94e7c0f6',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_options.inc',
  'hash' => '27ef31b8ee7b9999930380d6a5fdb477772329c4ddbd5c70cc34bcdc7543ce56',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_text.inc',
  'hash' => '5fb0a85d35d29944c699ceaf6efed5eda2df757009e44caba8ff2be397568b60',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_uri.inc',
  'hash' => '79ecaa3eb17dfdd0ca077351b75a2c0adf411ebc04720e7cc0e2397674225f24',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_relationship.inc',
  'hash' => 'b69bc538d1e1e0f91f8485ca54c3b6e2be025caa47619734c467377cf89041b9',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_relationship_by_bundle.inc',
  'hash' => '65300c793c4591d60ad908dc02cf3148fe4e899fa6ad218e875fd92d411374dc',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/plugins/entity_views_plugin_row_entity_view.inc',
  'hash' => 'e489ca209c66b76228383864b8267067e7cf3a1e375d9a195339f89932fed71f',
))
->values(array(
  'filename' => 'sites/all/modules/entityreference/entityreference.migrate.inc',
  'hash' => '6dfe7be97f3198bff6c145dce9a0f521c3695c380d24fe6d3feb97362363407d',
))
->values(array(
  'filename' => 'sites/all/modules/entityreference/plugins/behavior/abstract.inc',
  'hash' => 'a7959ddece2ce3490f92d916162e07aed313e28ca299ca0375bad633b42d93e3',
))
->values(array(
  'filename' => 'sites/all/modules/entityreference/plugins/behavior/EntityReferenceBehavior_TaxonomyIndex.class.php',
  'hash' => '29e0f80ac52c1c313455a531404a3040c9160ecd173afd2e200ff99ffbab491c',
))
->values(array(
  'filename' => 'sites/all/modules/entityreference/plugins/selection/abstract.inc',
  'hash' => '9c8cdf704c8e42cc2a63d4c8271d28c7b0aa7e0b1ec081ed7bd84712631e3e72',
))
->values(array(
  'filename' => 'sites/all/modules/entityreference/plugins/selection/EntityReference_SelectionHandler_Generic.class.php',
  'hash' => '3516c65d6048e182dcd1b7209ccf6838e17b1d342617d06e7a07ffed8bd549c6',
))
->values(array(
  'filename' => 'sites/all/modules/entityreference/plugins/selection/views.inc',
  'hash' => '7bbe8900b6b71c2d41e370deaccca869884d0fe9ca81772d7d5bca5f58ec1cd8',
))
->values(array(
  'filename' => 'sites/all/modules/entityreference/tests/entityreference.admin.test',
  'hash' => 'f9e581f0fd8481b12ae74779f28942b26d29b0df828ba092b7be87cab29e1172',
))
->values(array(
  'filename' => 'sites/all/modules/entityreference/tests/entityreference.feeds.test',
  'hash' => 'b19193542031d2e1a247ffac8852e9219e5f7f0ed38298207ffe27cd1af9352a',
))
->values(array(
  'filename' => 'sites/all/modules/entityreference/tests/entityreference.handlers.test',
  'hash' => 'be2ea3fab2b6a5116a5ff1292ec3d916fb48ae36001e064503ef3db952c99b99',
))
->values(array(
  'filename' => 'sites/all/modules/entityreference/tests/entityreference.taxonomy.test',
  'hash' => '28aed16bd109189d6b2bfc8f59d914c8e237190738fa23d81dbd6cf2c2bced9b',
))
->values(array(
  'filename' => 'sites/all/modules/entityreference/views/entityreference_plugin_display.inc',
  'hash' => '369e6ef46c06cc651ed209f94aa64ff6a4bbb3f2af678b2f1a8b23e42c81e648',
))
->values(array(
  'filename' => 'sites/all/modules/entityreference/views/entityreference_plugin_row_fields.inc',
  'hash' => '7f5a58c099c2df6fd1c3ae285197a4648841d44fa107bcb2064bc1edf435ea8b',
))
->values(array(
  'filename' => 'sites/all/modules/entityreference/views/entityreference_plugin_style.inc',
  'hash' => 'fef62f9375cbcadbfd1918227434193f45e4cc62964cb4fee22ab1d8d3b3bb26',
))
->values(array(
  'filename' => 'sites/all/modules/link/link.migrate.inc',
  'hash' => '329488d6a88a0cbcd68ebeffbb88cc12da3518b61e28744cd612474cf8e8a165',
))
->values(array(
  'filename' => 'sites/all/modules/link/tests/LinkBaseTestClass.test',
  'hash' => 'b857164c3b80ab2460d2170529f7d4b0e16fd88b54b32eb7d1fc4f26665d395a',
))
->values(array(
  'filename' => 'sites/all/modules/link/tests/LinkConvertInternalPathsTest.test',
  'hash' => '5696b4cdaaf8253659a11395f79673a26c9596de58a6552532638807cf632050',
))
->values(array(
  'filename' => 'sites/all/modules/link/tests/LinkDefaultProtocolTest.test',
  'hash' => '5e47e7b73381a3739218228a1a17cd13ad31a4ed60561d562b5bb303472b5253',
))
->values(array(
  'filename' => 'sites/all/modules/link/tests/LinkEntityTokenTest.test',
  'hash' => '37efc9d5193f71decc36c29779580c79d54abbfecad2caf14bd05b710176204b',
))
->values(array(
  'filename' => 'sites/all/modules/link/tests/LinkFieldAttributesTest.test',
  'hash' => '86340cffba7b12771238d55517015c5581547b82c8eda5284f14d3c29c096761',
))
->values(array(
  'filename' => 'sites/all/modules/link/tests/LinkFieldCrudTest.test',
  'hash' => '1471a0e6239e17c583bc2c3f3f67bf5bb6ba399e2a54960748a51788d117f7c7',
))
->values(array(
  'filename' => 'sites/all/modules/link/tests/LinkFieldValidateTest.test',
  'hash' => '46281a764f666d6edbc6f7efcd2d2e166fa35fe59e7a41d3c4a12eeca8995165',
))
->values(array(
  'filename' => 'sites/all/modules/link/tests/LinkPathPrefixesTest.test',
  'hash' => '123de62937cfe27d097454409d93b170e7925ee0a56158beb50b32d119206641',
))
->values(array(
  'filename' => 'sites/all/modules/link/tests/LinkSanitizeTest.test',
  'hash' => '3a4b4f9f6220125e1db5c84327ecd9ff8a49b274b06401e1defc4cf3f1e4d35d',
))
->values(array(
  'filename' => 'sites/all/modules/link/tests/LinkTokenTest.test',
  'hash' => '04523630d058b3ceb0509dbc4cacc90b81f3c8d1c04cafeb8d1db20606969fa7',
))
->values(array(
  'filename' => 'sites/all/modules/link/tests/LinkUnitTestCase.test',
  'hash' => 'bd17da003cc7887ccb907f5b78ef8462e10319ad950495fb03692608bc74297a',
))
->values(array(
  'filename' => 'sites/all/modules/link/tests/LinkValidationApiTest.test',
  'hash' => '268760ccc967bc8ae69b7f8bdc8dcb5b9d8f8bbdd347eb122652f5ed88f08a62',
))
->values(array(
  'filename' => 'sites/all/modules/link/views/link_views_handler_argument_target.inc',
  'hash' => '99203a8b7c5a6e39c75104836aada6d4034ab010c95f4dbdc28b020f32383da7',
))
->values(array(
  'filename' => 'sites/all/modules/link/views/link_views_handler_filter_protocol.inc',
  'hash' => '7135d542a2f9bb7263870024324d5398208e3b6f1ddff7e3142e6b0de757d5ad',
))
->execute();
$connection->schema()->createTable('role', array(
  'fields' => array(
    'rid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'rid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('role')
->fields(array(
  'rid',
  'name',
  'weight',
))
->values(array(
  'rid' => '1',
  'name' => 'anonymous user',
  'weight' => '0',
))
->values(array(
  'rid' => '2',
  'name' => 'authenticated user',
  'weight' => '1',
))
->values(array(
  'rid' => '3',
  'name' => 'administrator',
  'weight' => '2',
))
->execute();
$connection->schema()->createTable('role_permission', array(
  'fields' => array(
    'rid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'permission' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'rid',
    'permission',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('role_permission')
->fields(array(
  'rid',
  'permission',
  'module',
))
->values(array(
  'rid' => '1',
  'permission' => 'access comments',
  'module' => 'comment',
))
->values(array(
  'rid' => '1',
  'permission' => 'access content',
  'module' => 'node',
))
->values(array(
  'rid' => '1',
  'permission' => 'use text format filtered_html',
  'module' => 'filter',
))
->values(array(
  'rid' => '2',
  'permission' => 'access comments',
  'module' => 'comment',
))
->values(array(
  'rid' => '2',
  'permission' => 'access content',
  'module' => 'node',
))
->values(array(
  'rid' => '2',
  'permission' => 'post comments',
  'module' => 'comment',
))
->values(array(
  'rid' => '2',
  'permission' => 'skip comment approval',
  'module' => 'comment',
))
->values(array(
  'rid' => '2',
  'permission' => 'use text format custom_text_format',
  'module' => 'filter',
))
->values(array(
  'rid' => '2',
  'permission' => 'use text format filtered_html',
  'module' => 'filter',
))
->values(array(
  'rid' => '3',
  'permission' => 'access administration pages',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'access all views',
  'module' => 'views',
))
->values(array(
  'rid' => '3',
  'permission' => 'access comments',
  'module' => 'comment',
))
->values(array(
  'rid' => '3',
  'permission' => 'access content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'access content overview',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'access dashboard',
  'module' => 'dashboard',
))
->values(array(
  'rid' => '3',
  'permission' => 'access overlay',
  'module' => 'overlay',
))
->values(array(
  'rid' => '3',
  'permission' => 'access site in maintenance mode',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'access site reports',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'access site-wide contact form',
  'module' => 'contact',
))
->values(array(
  'rid' => '3',
  'permission' => 'access statistics',
  'module' => 'statistics',
))
->values(array(
  'rid' => '3',
  'permission' => 'access toolbar',
  'module' => 'toolbar',
))
->values(array(
  'rid' => '3',
  'permission' => 'access user contact forms',
  'module' => 'contact',
))
->values(array(
  'rid' => '3',
  'permission' => 'access user profiles',
  'module' => 'user',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer actions',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer blocks',
  'module' => 'block',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer comments',
  'module' => 'comment',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer contact forms',
  'module' => 'contact',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer content types',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer filters',
  'module' => 'filter',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer image styles',
  'module' => 'image',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer menu',
  'module' => 'menu',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer modules',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer nodes',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer permissions',
  'module' => 'user',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer search',
  'module' => 'search',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer shortcuts',
  'module' => 'shortcut',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer site configuration',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer software updates',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer statistics',
  'module' => 'statistics',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer taxonomy',
  'module' => 'taxonomy',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer themes',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer url aliases',
  'module' => 'path',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer users',
  'module' => 'user',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer views',
  'module' => 'views',
))
->values(array(
  'rid' => '3',
  'permission' => 'block IP addresses',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'bypass node access',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'cancel account',
  'module' => 'user',
))
->values(array(
  'rid' => '3',
  'permission' => 'change own username',
  'module' => 'user',
))
->values(array(
  'rid' => '3',
  'permission' => 'create article content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'create page content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'create url aliases',
  'module' => 'path',
))
->values(array(
  'rid' => '3',
  'permission' => 'customize shortcut links',
  'module' => 'shortcut',
))
->values(array(
  'rid' => '3',
  'permission' => 'delete any article content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'delete any page content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'delete own article content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'delete own page content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'delete revisions',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'delete terms in 1',
  'module' => 'taxonomy',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit any article content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit any page content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit own article content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit own comments',
  'module' => 'comment',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit own page content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit terms in 1',
  'module' => 'taxonomy',
))
->values(array(
  'rid' => '3',
  'permission' => 'post comments',
  'module' => 'comment',
))
->values(array(
  'rid' => '3',
  'permission' => 'revert revisions',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'search content',
  'module' => 'search',
))
->values(array(
  'rid' => '3',
  'permission' => 'select account cancellation method',
  'module' => 'user',
))
->values(array(
  'rid' => '3',
  'permission' => 'skip comment approval',
  'module' => 'comment',
))
->values(array(
  'rid' => '3',
  'permission' => 'switch shortcut sets',
  'module' => 'shortcut',
))
->values(array(
  'rid' => '3',
  'permission' => 'translate admin strings',
  'module' => 'i18n_string',
))
->values(array(
  'rid' => '3',
  'permission' => 'translate user-defined strings',
  'module' => 'i18n_string',
))
->values(array(
  'rid' => '3',
  'permission' => 'use advanced search',
  'module' => 'search',
))
->values(array(
  'rid' => '3',
  'permission' => 'use text format custom_text_format',
  'module' => 'filter',
))
->values(array(
  'rid' => '3',
  'permission' => 'use text format filtered_html',
  'module' => 'filter',
))
->values(array(
  'rid' => '3',
  'permission' => 'use text format full_html',
  'module' => 'filter',
))
->values(array(
  'rid' => '3',
  'permission' => 'view own unpublished content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'view post access counter',
  'module' => 'statistics',
))
->values(array(
  'rid' => '3',
  'permission' => 'view revisions',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'view the administration theme',
  'module' => 'system',
))
->execute();
$connection->schema()->createTable('search_dataset', array(
  'fields' => array(
    'sid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '16',
    ),
    'data' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'reindex' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'sid',
    'type',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('search_dataset')
->fields(array(
  'sid',
  'type',
  'data',
  'reindex',
))
->values(array(
  'sid' => '1',
  'type' => 'node',
  'data' => ' a node 1 default examplecom another examplecom 99999999 monday january 19 2015 2215 monday january 19 2015 2215 prefix value120suffix value abc5xyz click here some more text 9 a comment permalink submitted by admin on mon 1192015 2218 this is a comment log in or register to post comments  ',
  'reindex' => '1647479172',
))
->execute();
$connection->schema()->createTable('search_index', array(
  'fields' => array(
    'word' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '50',
      'default' => '',
    ),
    'sid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '16',
    ),
    'score' => array(
      'type' => 'numeric',
      'not null' => FALSE,
      'precision' => '10',
      'scale' => '0',
    ),
  ),
  'primary key' => array(
    'word',
    'sid',
    'type',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('search_index')
->fields(array(
  'word',
  'sid',
  'type',
  'score',
))
->values(array(
  'word' => '1',
  'sid' => '1',
  'type' => 'node',
  'score' => '1',
))
->values(array(
  'word' => '1192015',
  'sid' => '1',
  'type' => 'node',
  'score' => '1',
))
->values(array(
  'word' => '19',
  'sid' => '1',
  'type' => 'node',
  'score' => '2',
))
->values(array(
  'word' => '2015',
  'sid' => '1',
  'type' => 'node',
  'score' => '2',
))
->values(array(
  'word' => '2215',
  'sid' => '1',
  'type' => 'node',
  'score' => '2',
))
->values(array(
  'word' => '2218',
  'sid' => '1',
  'type' => 'node',
  'score' => '1',
))
->values(array(
  'word' => '9',
  'sid' => '1',
  'type' => 'node',
  'score' => '1',
))
->values(array(
  'word' => '99999999',
  'sid' => '1',
  'type' => 'node',
  'score' => '1',
))
->values(array(
  'word' => 'abc5xyz',
  'sid' => '1',
  'type' => 'node',
  'score' => '1',
))
->values(array(
  'word' => 'admin',
  'sid' => '1',
  'type' => 'node',
  'score' => '1',
))
->values(array(
  'word' => 'another',
  'sid' => '1',
  'type' => 'node',
  'score' => '11',
))
->values(array(
  'word' => 'click',
  'sid' => '1',
  'type' => 'node',
  'score' => '11',
))
->values(array(
  'word' => 'comment',
  'sid' => '1',
  'type' => 'node',
  'score' => '27',
))
->values(array(
  'word' => 'comments',
  'sid' => '1',
  'type' => 'node',
  'score' => '1',
))
->values(array(
  'word' => 'default',
  'sid' => '1',
  'type' => 'node',
  'score' => '11',
))
->values(array(
  'word' => 'examplecom',
  'sid' => '1',
  'type' => 'node',
  'score' => '22',
))
->values(array(
  'word' => 'here',
  'sid' => '1',
  'type' => 'node',
  'score' => '11',
))
->values(array(
  'word' => 'january',
  'sid' => '1',
  'type' => 'node',
  'score' => '2',
))
->values(array(
  'word' => 'monday',
  'sid' => '1',
  'type' => 'node',
  'score' => '2',
))
->values(array(
  'word' => 'more',
  'sid' => '1',
  'type' => 'node',
  'score' => '1',
))
->values(array(
  'word' => 'node',
  'sid' => '1',
  'type' => 'node',
  'score' => '26',
))
->values(array(
  'word' => 'permalink',
  'sid' => '1',
  'type' => 'node',
  'score' => '11',
))
->values(array(
  'word' => 'post',
  'sid' => '1',
  'type' => 'node',
  'score' => '1',
))
->values(array(
  'word' => 'prefix',
  'sid' => '1',
  'type' => 'node',
  'score' => '1',
))
->values(array(
  'word' => 'register',
  'sid' => '1',
  'type' => 'node',
  'score' => '2',
))
->values(array(
  'word' => 'some',
  'sid' => '1',
  'type' => 'node',
  'score' => '1',
))
->values(array(
  'word' => 'submitted',
  'sid' => '1',
  'type' => 'node',
  'score' => '1',
))
->values(array(
  'word' => 'text',
  'sid' => '1',
  'type' => 'node',
  'score' => '1',
))
->values(array(
  'word' => 'this',
  'sid' => '1',
  'type' => 'node',
  'score' => '1',
))
->values(array(
  'word' => 'value',
  'sid' => '1',
  'type' => 'node',
  'score' => '1',
))
->values(array(
  'word' => 'value120suffix',
  'sid' => '1',
  'type' => 'node',
  'score' => '1',
))
->execute();
$connection->schema()->createTable('search_node_links', array(
  'fields' => array(
    'sid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '16',
      'default' => '',
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'caption' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'sid',
    'type',
    'nid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('search_total', array(
  'fields' => array(
    'word' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '50',
      'default' => '',
    ),
    'count' => array(
      'type' => 'numeric',
      'not null' => FALSE,
      'precision' => '10',
      'scale' => '0',
    ),
  ),
  'primary key' => array(
    'word',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('search_total')
->fields(array(
  'word',
  'count',
))
->values(array(
  'word' => '1',
  'count' => '0',
))
->values(array(
  'word' => '1192015',
  'count' => '0',
))
->values(array(
  'word' => '19',
  'count' => '0',
))
->values(array(
  'word' => '2015',
  'count' => '0',
))
->values(array(
  'word' => '2215',
  'count' => '0',
))
->values(array(
  'word' => '2218',
  'count' => '0',
))
->values(array(
  'word' => '9',
  'count' => '0',
))
->values(array(
  'word' => '99999999',
  'count' => '0',
))
->values(array(
  'word' => 'abc5xyz',
  'count' => '0',
))
->values(array(
  'word' => 'about',
  'count' => '0',
))
->values(array(
  'word' => 'absolute',
  'count' => '0',
))
->values(array(
  'word' => 'admin',
  'count' => '0',
))
->values(array(
  'word' => 'another',
  'count' => '0',
))
->values(array(
  'word' => 'benjamin',
  'count' => '0',
))
->values(array(
  'word' => 'best',
  'count' => '0',
))
->values(array(
  'word' => 'click',
  'count' => '0',
))
->values(array(
  'word' => 'comment',
  'count' => '0',
))
->values(array(
  'word' => 'comments',
  'count' => '0',
))
->values(array(
  'word' => 'deep',
  'count' => '0',
))
->values(array(
  'word' => 'default',
  'count' => '0',
))
->values(array(
  'word' => 'ever',
  'count' => '0',
))
->values(array(
  'word' => 'examplecom',
  'count' => '0',
))
->values(array(
  'word' => 'here',
  'count' => '0',
))
->values(array(
  'word' => 'january',
  'count' => '0',
))
->values(array(
  'word' => 'know',
  'count' => '0',
))
->values(array(
  'word' => 'monday',
  'count' => '0',
))
->values(array(
  'word' => 'more',
  'count' => '0',
))
->values(array(
  'word' => 'node',
  'count' => '0',
))
->values(array(
  'word' => 'permalink',
  'count' => '0',
))
->values(array(
  'word' => 'post',
  'count' => '0',
))
->values(array(
  'word' => 'prefix',
  'count' => '0',
))
->values(array(
  'word' => 'quark',
  'count' => '0',
))
->values(array(
  'word' => 'register',
  'count' => '0',
))
->values(array(
  'word' => 'show',
  'count' => '0',
))
->values(array(
  'word' => 'sisko',
  'count' => '0',
))
->values(array(
  'word' => 'some',
  'count' => '0',
))
->values(array(
  'word' => 'space',
  'count' => '0',
))
->values(array(
  'word' => 'submitted',
  'count' => '0',
))
->values(array(
  'word' => 'text',
  'count' => '0',
))
->values(array(
  'word' => 'that',
  'count' => '0',
))
->values(array(
  'word' => 'thing',
  'count' => '0',
))
->values(array(
  'word' => 'this',
  'count' => '0',
))
->values(array(
  'word' => 'trust',
  'count' => '0',
))
->values(array(
  'word' => 'value',
  'count' => '0',
))
->values(array(
  'word' => 'value120suffix',
  'count' => '0',
))
->values(array(
  'word' => 'would',
  'count' => '0',
))
->execute();
$connection->schema()->createTable('semaphore', array(
  'fields' => array(
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'value' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'expire' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '10',
      'scale' => '0',
    ),
  ),
  'primary key' => array(
    'name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('sequences', array(
  'fields' => array(
    'value' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'value',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('sequences')
->fields(array(
  'value',
))
->values(array(
  'value' => '3',
))
->execute();
$connection->schema()->createTable('sessions', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'sid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ),
    'ssid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'session' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'sid',
    'ssid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('shortcut_set', array(
  'fields' => array(
    'set_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'set_name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('shortcut_set')
->fields(array(
  'set_name',
  'title',
))
->values(array(
  'set_name' => 'shortcut-set-1',
  'title' => 'Default',
))
->values(array(
  'set_name' => 'shortcut-set-2',
  'title' => 'Alternative shortcut set',
))
->execute();
$connection->schema()->createTable('shortcut_set_users', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'set_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'uid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('shortcut_set_users')
->fields(array(
  'uid',
  'set_name',
))
->values(array(
  'uid' => '2',
  'set_name' => 'shortcut-set-2',
))
->execute();
$connection->schema()->createTable('system', array(
  'fields' => array(
    'filename' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
    'owner' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'bootstrap' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'schema_version' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '-1',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'info' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'filename',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('system')
->fields(array(
  'filename',
  'name',
  'type',
  'owner',
  'status',
  'bootstrap',
  'schema_version',
  'weight',
  'info',
))
->values(array(
  'filename' => 'modules/aggregator/aggregator.module',
  'name' => 'aggregator',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:10:"Aggregator";s:11:"description";s:57:"Aggregates syndicated content (RSS, RDF, and Atom feeds).";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:15:"aggregator.test";}s:9:"configure";s:41:"admin/config/services/aggregator/settings";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:14:"aggregator.css";s:33:"modules/aggregator/aggregator.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/aggregator/tests/aggregator_test.module',
  'name' => 'aggregator_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:23:"Aggregator module tests";s:11:"description";s:46:"Support module for aggregator related testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/block/block.module',
  'name' => 'block',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7009',
  'weight' => '-5',
  'info' => 'a:13:{s:4:"name";s:5:"Block";s:11:"description";s:140:"Controls the visual building blocks a page is constructed with. Blocks are boxes of content rendered into an area, or region, of a web page.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:10:"block.test";}s:9:"configure";s:21:"admin/structure/block";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/block/tests/block_test.module',
  'name' => 'block_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Block test";s:11:"description";s:21:"Provides test blocks.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/blog/blog.module',
  'name' => 'blog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:4:"Blog";s:11:"description";s:25:"Enables multi-user blogs.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"blog.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/book/book.module',
  'name' => 'book',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:4:"Book";s:11:"description";s:66:"Allows users to create and organize related content in an outline.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"book.test";}s:9:"configure";s:27:"admin/content/book/settings";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:8:"book.css";s:21:"modules/book/book.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/color/color.module',
  'name' => 'color',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:5:"Color";s:11:"description";s:70:"Allows administrators to change the color scheme of compatible themes.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:10:"color.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/comment/comment.module',
  'name' => 'comment',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7009',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:7:"Comment";s:11:"description";s:57:"Allows users to comment on and discuss published content.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:4:"text";}s:5:"files";a:2:{i:0;s:14:"comment.module";i:1;s:12:"comment.test";}s:9:"configure";s:21:"admin/content/comment";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:11:"comment.css";s:27:"modules/comment/comment.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/contact/contact.module',
  'name' => 'contact',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7003',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:7:"Contact";s:11:"description";s:61:"Enables the use of both personal and site-wide contact forms.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:12:"contact.test";}s:9:"configure";s:23:"admin/structure/contact";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/contextual/contextual.module',
  'name' => 'contextual',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:16:"Contextual links";s:11:"description";s:75:"Provides contextual links to perform actions related to elements on a page.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:15:"contextual.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/dashboard/dashboard.module',
  'name' => 'dashboard',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:9:"Dashboard";s:11:"description";s:136:"Provides a dashboard page in the administrative interface for organizing administrative tasks and tracking information within your site.";s:4:"core";s:3:"7.x";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:5:"files";a:1:{i:0;s:14:"dashboard.test";}s:12:"dependencies";a:1:{i:0;s:5:"block";}s:9:"configure";s:25:"admin/dashboard/customize";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/dblog/dblog.module',
  'name' => 'dblog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:16:"Database logging";s:11:"description";s:47:"Logs and records system events to the database.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:10:"dblog.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/field.module',
  'name' => 'field',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7003',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:5:"Field";s:11:"description";s:57:"Field API to add fields to entities like nodes and users.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:4:{i:0;s:12:"field.module";i:1;s:16:"field.attach.inc";i:2;s:20:"field.info.class.inc";i:3;s:16:"tests/field.test";}s:12:"dependencies";a:1:{i:0;s:17:"field_sql_storage";}s:8:"required";b:1;s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:15:"theme/field.css";s:29:"modules/field/theme/field.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/field_sql_storage/field_sql_storage.module',
  'name' => 'field_sql_storage',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7002',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:17:"Field SQL storage";s:11:"description";s:37:"Stores field data in an SQL database.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:22:"field_sql_storage.test";}s:8:"required";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/list/list.module',
  'name' => 'list',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7002',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:4:"List";s:11:"description";s:69:"Defines list field types. Use with Options to create selection lists.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:12:"dependencies";a:2:{i:0;s:5:"field";i:1;s:7:"options";}s:5:"files";a:1:{i:0;s:15:"tests/list.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:8:"required";b:1;s:11:"explanation";s:73:"Field type(s) in use - see <a href="/admin/reports/fields">Field list</a>";}',
))
->values(array(
  'filename' => 'modules/field/modules/list/tests/list_test.module',
  'name' => 'list_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:9:"List test";s:11:"description";s:41:"Support module for the List module tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/number/number.module',
  'name' => 'number',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:6:"Number";s:11:"description";s:28:"Defines numeric field types.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:11:"number.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:8:"required";b:1;s:11:"explanation";s:73:"Field type(s) in use - see <a href="/admin/reports/fields">Field list</a>";}',
))
->values(array(
  'filename' => 'modules/field/modules/options/options.module',
  'name' => 'options',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:7:"Options";s:11:"description";s:82:"Defines selection, check box and radio button widgets for text and numeric fields.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:12:"options.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/text/text.module',
  'name' => 'text',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7000',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:4:"Text";s:11:"description";s:32:"Defines simple text field types.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:9:"text.test";}s:8:"required";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:11:"explanation";s:73:"Field type(s) in use - see <a href="/admin/reports/fields">Field list</a>";}',
))
->values(array(
  'filename' => 'modules/field/tests/field_test.module',
  'name' => 'field_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:14:"Field API Test";s:11:"description";s:39:"Support module for the Field API tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:5:"files";a:1:{i:0;s:21:"field_test.entity.inc";}s:7:"version";s:4:"7.82";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field_ui/field_ui.module',
  'name' => 'field_ui',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:8:"Field UI";s:11:"description";s:33:"User interface for the Field API.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:13:"field_ui.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/file/file.module',
  'name' => 'file',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:4:"File";s:11:"description";s:26:"Defines a file field type.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:15:"tests/file.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:8:"required";b:1;s:11:"explanation";s:73:"Field type(s) in use - see <a href="/admin/reports/fields">Field list</a>";}',
))
->values(array(
  'filename' => 'modules/file/tests/file_module_test.module',
  'name' => 'file_module_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:9:"File test";s:11:"description";s:53:"Provides hooks for testing File module functionality.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/filter/filter.module',
  'name' => 'filter',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7010',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:6:"Filter";s:11:"description";s:43:"Filters content in preparation for display.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"filter.test";}s:8:"required";b:1;s:9:"configure";s:28:"admin/config/content/formats";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/forum/forum.module',
  'name' => 'forum',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '1',
  'info' => 'a:14:{s:4:"name";s:5:"Forum";s:11:"description";s:27:"Provides discussion forums.";s:12:"dependencies";a:2:{i:0;s:8:"taxonomy";i:1;s:7:"comment";}s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:10:"forum.test";}s:9:"configure";s:21:"admin/structure/forum";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"forum.css";s:23:"modules/forum/forum.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/help/help.module',
  'name' => 'help',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:4:"Help";s:11:"description";s:35:"Manages the display of online help.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"help.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/image/image.module',
  'name' => 'image',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7005',
  'weight' => '0',
  'info' => 'a:15:{s:4:"name";s:5:"Image";s:11:"description";s:34:"Provides image manipulation tools.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:4:"file";}s:5:"files";a:1:{i:0;s:10:"image.test";}s:9:"configure";s:31:"admin/config/media/image-styles";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:8:"required";b:1;s:11:"explanation";s:73:"Field type(s) in use - see <a href="/admin/reports/fields">Field list</a>";}',
))
->values(array(
  'filename' => 'modules/image/tests/image_module_test.module',
  'name' => 'image_module_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Image test";s:11:"description";s:69:"Provides hook implementations for testing Image module functionality.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:24:"image_module_test.module";}s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/locale/locale.module',
  'name' => 'locale',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:6:"Locale";s:11:"description";s:119:"Adds language handling functionality and enables the translation of the user interface to languages other than English.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"locale.test";}s:9:"configure";s:30:"admin/config/regional/language";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/locale/tests/locale_test.module',
  'name' => 'locale_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:11:"Locale Test";s:11:"description";s:42:"Support module for the locale layer tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/menu/menu.module',
  'name' => 'menu',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7003',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:4:"Menu";s:11:"description";s:60:"Allows administrators to customize the site navigation menu.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"menu.test";}s:9:"configure";s:20:"admin/structure/menu";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/node/node.module',
  'name' => 'node',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7015',
  'weight' => '0',
  'info' => 'a:15:{s:4:"name";s:4:"Node";s:11:"description";s:66:"Allows content to be submitted to the site and displayed on pages.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:11:"node.module";i:1;s:9:"node.test";}s:8:"required";b:1;s:9:"configure";s:21:"admin/structure/types";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:8:"node.css";s:21:"modules/node/node.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/node/tests/node_access_test.module',
  'name' => 'node_access_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:24:"Node module access tests";s:11:"description";s:43:"Support module for node permission testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/node/tests/node_test.module',
  'name' => 'node_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:17:"Node module tests";s:11:"description";s:40:"Support module for node related testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/node/tests/node_test_exception.module',
  'name' => 'node_test_exception',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:27:"Node module exception tests";s:11:"description";s:50:"Support module for node related exception testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/openid/openid.module',
  'name' => 'openid',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '7000',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:6:"OpenID";s:11:"description";s:48:"Allows users to log into your site using OpenID.";s:7:"version";s:4:"7.82";s:7:"package";s:4:"Core";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"openid.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/openid/tests/openid_test.module',
  'name' => 'openid_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:21:"OpenID dummy provider";s:11:"description";s:33:"OpenID provider used for testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:6:"openid";}s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/overlay/overlay.module',
  'name' => 'overlay',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:7:"Overlay";s:11:"description";s:59:"Displays the Drupal administration interface in an overlay.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/path/path.module',
  'name' => 'path',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:4:"Path";s:11:"description";s:28:"Allows users to rename URLs.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"path.test";}s:9:"configure";s:24:"admin/config/search/path";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/php/php.module',
  'name' => 'php',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:10:"PHP filter";s:11:"description";s:50:"Allows embedded PHP code/snippets to be evaluated.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:8:"php.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/poll/poll.module',
  'name' => 'poll',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:4:"Poll";s:11:"description";s:95:"Allows your site to capture votes on different topics in the form of multiple choice questions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"poll.test";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:8:"poll.css";s:21:"modules/poll/poll.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/profile/profile.module',
  'name' => 'profile',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:7:"Profile";s:11:"description";s:36:"Supports configurable user profiles.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:12:"profile.test";}s:9:"configure";s:27:"admin/config/people/profile";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/rdf/rdf.module',
  'name' => 'rdf',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:3:"RDF";s:11:"description";s:148:"Enriches your content with metadata to let other applications (e.g. search engines, aggregators) better understand its relationships and attributes.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:8:"rdf.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/rdf/tests/rdf_test.module',
  'name' => 'rdf_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:16:"RDF module tests";s:11:"description";s:38:"Support module for RDF module testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:4:"blog";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/search/search.module',
  'name' => 'search',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7000',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:6:"Search";s:11:"description";s:36:"Enables site-wide keyword searching.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:19:"search.extender.inc";i:1;s:11:"search.test";}s:9:"configure";s:28:"admin/config/search/settings";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:10:"search.css";s:25:"modules/search/search.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/search/tests/search_embedded_form.module',
  'name' => 'search_embedded_form',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:20:"Search embedded form";s:11:"description";s:59:"Support module for search module testing of embedded forms.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/search/tests/search_extra_type.module',
  'name' => 'search_extra_type',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:16:"Test search type";s:11:"description";s:41:"Support module for search module testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/search/tests/search_node_tags.module',
  'name' => 'search_node_tags',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:21:"Test search node tags";s:11:"description";s:44:"Support module for Node search tags testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/shortcut/shortcut.module',
  'name' => 'shortcut',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:8:"Shortcut";s:11:"description";s:60:"Allows users to manage customizable lists of shortcut links.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:13:"shortcut.test";}s:9:"configure";s:36:"admin/config/user-interface/shortcut";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/simpletest.module',
  'name' => 'simpletest',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:7:"Testing";s:11:"description";s:53:"Provides a framework for unit and functional testing.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:51:{i:0;s:15:"simpletest.test";i:1;s:24:"drupal_web_test_case.php";i:2;s:18:"tests/actions.test";i:3;s:15:"tests/ajax.test";i:4;s:16:"tests/batch.test";i:5;s:15:"tests/boot.test";i:6;s:20:"tests/bootstrap.test";i:7;s:16:"tests/cache.test";i:8;s:17:"tests/common.test";i:9;s:24:"tests/database_test.test";i:10;s:22:"tests/entity_crud.test";i:11;s:32:"tests/entity_crud_hook_test.test";i:12;s:23:"tests/entity_query.test";i:13;s:16:"tests/error.test";i:14;s:15:"tests/file.test";i:15;s:23:"tests/filetransfer.test";i:16;s:15:"tests/form.test";i:17;s:16:"tests/graph.test";i:18;s:16:"tests/image.test";i:19;s:15:"tests/lock.test";i:20;s:15:"tests/mail.test";i:21;s:15:"tests/menu.test";i:22;s:17:"tests/module.test";i:23;s:16:"tests/pager.test";i:24;s:19:"tests/password.test";i:25;s:15:"tests/path.test";i:26;s:19:"tests/registry.test";i:27;s:28:"tests/request_sanitizer.test";i:28;s:17:"tests/schema.test";i:29;s:18:"tests/session.test";i:30;s:20:"tests/tablesort.test";i:31;s:16:"tests/theme.test";i:32;s:18:"tests/unicode.test";i:33;s:17:"tests/update.test";i:34;s:17:"tests/xmlrpc.test";i:35;s:26:"tests/upgrade/upgrade.test";i:36;s:34:"tests/upgrade/upgrade.comment.test";i:37;s:33:"tests/upgrade/upgrade.filter.test";i:38;s:32:"tests/upgrade/upgrade.forum.test";i:39;s:33:"tests/upgrade/upgrade.locale.test";i:40;s:31:"tests/upgrade/upgrade.menu.test";i:41;s:31:"tests/upgrade/upgrade.node.test";i:42;s:35:"tests/upgrade/upgrade.taxonomy.test";i:43;s:34:"tests/upgrade/upgrade.trigger.test";i:44;s:39:"tests/upgrade/upgrade.translatable.test";i:45;s:33:"tests/upgrade/upgrade.upload.test";i:46;s:31:"tests/upgrade/upgrade.user.test";i:47;s:36:"tests/upgrade/update.aggregator.test";i:48;s:33:"tests/upgrade/update.trigger.test";i:49;s:31:"tests/upgrade/update.field.test";i:50;s:30:"tests/upgrade/update.user.test";}s:9:"configure";s:41:"admin/config/development/testing/settings";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/actions_loop_test.module',
  'name' => 'actions_loop_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:17:"Actions loop test";s:11:"description";s:39:"Support module for action loop testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/ajax_forms_test.module',
  'name' => 'ajax_forms_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:26:"AJAX form test mock module";s:11:"description";s:25:"Test for AJAX form calls.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/ajax_test.module',
  'name' => 'ajax_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:9:"AJAX Test";s:11:"description";s:40:"Support module for AJAX framework tests.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/batch_test.module',
  'name' => 'batch_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:14:"Batch API test";s:11:"description";s:35:"Support module for Batch API tests.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/boot_test_1.module',
  'name' => 'boot_test_1',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:21:"Early bootstrap tests";s:11:"description";s:39:"A support module for hook_boot testing.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/boot_test_2.module',
  'name' => 'boot_test_2',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:21:"Early bootstrap tests";s:11:"description";s:44:"A support module for hook_boot hook testing.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/common_test.module',
  'name' => 'common_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:11:"Common Test";s:11:"description";s:32:"Support module for Common tests.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:15:"common_test.css";s:40:"modules/simpletest/tests/common_test.css";}s:5:"print";a:1:{s:21:"common_test.print.css";s:46:"modules/simpletest/tests/common_test.print.css";}}s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/common_test_cron_helper.module',
  'name' => 'common_test_cron_helper',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:23:"Common Test Cron Helper";s:11:"description";s:56:"Helper module for CronRunTestCase::testCronExceptions().";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/database_test.module',
  'name' => 'database_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:13:"Database Test";s:11:"description";s:40:"Support module for Database layer tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/drupal_autoload_test/drupal_autoload_test.module',
  'name' => 'drupal_autoload_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:25:"Drupal code registry test";s:11:"description";s:45:"Support module for testing the code registry.";s:5:"files";a:2:{i:0;s:34:"drupal_autoload_test_interface.inc";i:1;s:30:"drupal_autoload_test_class.inc";}s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/drupal_system_listing_compatible_test/drupal_system_listing_compatible_test.module',
  'name' => 'drupal_system_listing_compatible_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:37:"Drupal system listing compatible test";s:11:"description";s:62:"Support module for testing the drupal_system_listing function.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/drupal_system_listing_incompatible_test/drupal_system_listing_incompatible_test.module',
  'name' => 'drupal_system_listing_incompatible_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:39:"Drupal system listing incompatible test";s:11:"description";s:62:"Support module for testing the drupal_system_listing function.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/entity_cache_test.module',
  'name' => 'entity_cache_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:17:"Entity cache test";s:11:"description";s:40:"Support module for testing entity cache.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:28:"entity_cache_test_dependency";}s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/entity_cache_test_dependency.module',
  'name' => 'entity_cache_test_dependency',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:28:"Entity cache test dependency";s:11:"description";s:51:"Support dependency module for testing entity cache.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/entity_crud_hook_test.module',
  'name' => 'entity_crud_hook_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:22:"Entity CRUD Hooks Test";s:11:"description";s:35:"Support module for CRUD hook tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/entity_query_access_test.module',
  'name' => 'entity_query_access_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:24:"Entity query access test";s:11:"description";s:49:"Support module for checking entity query results.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/error_test.module',
  'name' => 'error_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Error test";s:11:"description";s:47:"Support module for error and exception testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/file_test.module',
  'name' => 'file_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:9:"File test";s:11:"description";s:39:"Support module for file handling tests.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:16:"file_test.module";}s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/filter_test.module',
  'name' => 'filter_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:18:"Filter test module";s:11:"description";s:33:"Tests filter hooks and functions.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/form_test.module',
  'name' => 'form_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:12:"FormAPI Test";s:11:"description";s:34:"Support module for Form API tests.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/image_test.module',
  'name' => 'image_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Image test";s:11:"description";s:39:"Support module for image toolkit tests.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/menu_test.module',
  'name' => 'menu_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:15:"Hook menu tests";s:11:"description";s:37:"Support module for menu hook testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/module_test.module',
  'name' => 'module_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:11:"Module test";s:11:"description";s:41:"Support module for module system testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/path_test.module',
  'name' => 'path_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:15:"Hook path tests";s:11:"description";s:37:"Support module for path hook testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/psr_0_test/psr_0_test.module',
  'name' => 'psr_0_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:16:"PSR-0 Test cases";s:11:"description";s:44:"Test classes to be discovered by simpletest.";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/psr_4_test/psr_4_test.module',
  'name' => 'psr_4_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:16:"PSR-4 Test cases";s:11:"description";s:44:"Test classes to be discovered by simpletest.";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/requirements1_test.module',
  'name' => 'requirements1_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => "a:13:{s:4:\"name\";s:19:\"Requirements 1 Test\";s:11:\"description\";s:80:\"Tests that a module is not installed when it fails hook_requirements('install').\";s:7:\"package\";s:7:\"Testing\";s:7:\"version\";s:4:\"7.82\";s:4:\"core\";s:3:\"7.x\";s:6:\"hidden\";b:1;s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1626883669\";s:5:\"mtime\";i:1626883669;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:5:\"files\";a:0:{}s:9:\"bootstrap\";i:0;}",
))
->values(array(
  'filename' => 'modules/simpletest/tests/requirements2_test.module',
  'name' => 'requirements2_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => "a:13:{s:4:\"name\";s:19:\"Requirements 2 Test\";s:11:\"description\";s:98:\"Tests that a module is not installed when the one it depends on fails hook_requirements('install).\";s:12:\"dependencies\";a:2:{i:0;s:18:\"requirements1_test\";i:1;s:7:\"comment\";}s:7:\"package\";s:7:\"Testing\";s:7:\"version\";s:4:\"7.82\";s:4:\"core\";s:3:\"7.x\";s:6:\"hidden\";b:1;s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1626883669\";s:5:\"mtime\";i:1626883669;s:3:\"php\";s:5:\"5.2.4\";s:5:\"files\";a:0:{}s:9:\"bootstrap\";i:0;}",
))
->values(array(
  'filename' => 'modules/simpletest/tests/session_test.module',
  'name' => 'session_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:12:"Session test";s:11:"description";s:40:"Support module for session data testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_dependencies_test.module',
  'name' => 'system_dependencies_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:22:"System dependency test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:19:"_missing_dependency";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_incompatible_core_version_dependencies_test.module',
  'name' => 'system_incompatible_core_version_dependencies_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:50:"System incompatible core version dependencies test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:37:"system_incompatible_core_version_test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_incompatible_core_version_test.module',
  'name' => 'system_incompatible_core_version_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:37:"System incompatible core version test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"5.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_incompatible_module_version_dependencies_test.module',
  'name' => 'system_incompatible_module_version_dependencies_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:52:"System incompatible module version dependencies test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:46:"system_incompatible_module_version_test (>2.0)";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_incompatible_module_version_test.module',
  'name' => 'system_incompatible_module_version_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:39:"System incompatible module version test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_project_namespace_test.module',
  'name' => 'system_project_namespace_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:29:"System project namespace test";s:11:"description";s:58:"Support module for testing project namespace dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:13:"drupal:filter";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_test.module',
  'name' => 'system_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:11:"System test";s:11:"description";s:34:"Support module for system testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:18:"system_test.module";}s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/taxonomy_test.module',
  'name' => 'taxonomy_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:20:"Taxonomy test module";s:11:"description";s:45:""Tests functions and hooks not used in core".";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:8:"taxonomy";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/theme_test.module',
  'name' => 'theme_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Theme test";s:11:"description";s:40:"Support module for theme system testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/update_script_test.module',
  'name' => 'update_script_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:18:"Update script test";s:11:"description";s:41:"Support module for update script testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/update_test_1.module',
  'name' => 'update_test_1',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:11:"Update test";s:11:"description";s:34:"Support module for update testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/update_test_2.module',
  'name' => 'update_test_2',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:11:"Update test";s:11:"description";s:34:"Support module for update testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/update_test_3.module',
  'name' => 'update_test_3',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:11:"Update test";s:11:"description";s:34:"Support module for update testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/url_alter_test.module',
  'name' => 'url_alter_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:15:"Url_alter tests";s:11:"description";s:45:"A support modules for url_alter hook testing.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/xmlrpc_test.module',
  'name' => 'xmlrpc_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:12:"XML-RPC Test";s:11:"description";s:75:"Support module for XML-RPC tests according to the validator1 specification.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/statistics/statistics.module',
  'name' => 'statistics',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '1',
  'schema_version' => '7000',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Statistics";s:11:"description";s:37:"Logs access statistics for your site.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:15:"statistics.test";}s:9:"configure";s:30:"admin/config/system/statistics";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/syslog/syslog.module',
  'name' => 'syslog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:6:"Syslog";s:11:"description";s:41:"Logs and records system events to syslog.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"syslog.test";}s:9:"configure";s:32:"admin/config/development/logging";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/system/system.module',
  'name' => 'system',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7080',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:6:"System";s:11:"description";s:54:"Handles general site configuration for administrators.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:6:{i:0;s:19:"system.archiver.inc";i:1;s:15:"system.mail.inc";i:2;s:16:"system.queue.inc";i:3;s:14:"system.tar.inc";i:4;s:18:"system.updater.inc";i:5;s:11:"system.test";}s:8:"required";b:1;s:9:"configure";s:19:"admin/config/system";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/system/tests/cron_queue_test.module',
  'name' => 'cron_queue_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:15:"Cron Queue test";s:11:"description";s:41:"Support module for the cron queue runner.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/system/tests/system_cron_test.module',
  'name' => 'system_cron_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:16:"System Cron Test";s:11:"description";s:45:"Support module for testing the system_cron().";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/taxonomy/taxonomy.module',
  'name' => 'taxonomy',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7011',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:8:"Taxonomy";s:11:"description";s:38:"Enables the categorization of content.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:7:"options";}s:5:"files";a:2:{i:0;s:15:"taxonomy.module";i:1;s:13:"taxonomy.test";}s:9:"configure";s:24:"admin/structure/taxonomy";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/toolbar/toolbar.module',
  'name' => 'toolbar',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:7:"Toolbar";s:11:"description";s:99:"Provides a toolbar that shows the top-level administration menu items and links from other modules.";s:4:"core";s:3:"7.x";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/tracker/tracker.module',
  'name' => 'tracker',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7000',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:7:"Tracker";s:11:"description";s:45:"Enables tracking of recent content for users.";s:12:"dependencies";a:1:{i:0;s:7:"comment";}s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:12:"tracker.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/translation/tests/translation_test.module',
  'name' => 'translation_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:24:"Content Translation Test";s:11:"description";s:49:"Support module for the content translation tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/translation/translation.module',
  'name' => 'translation',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:19:"Content translation";s:11:"description";s:57:"Allows content to be translated into different languages.";s:12:"dependencies";a:1:{i:0;s:6:"locale";}s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:16:"translation.test";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/trigger/tests/trigger_test.module',
  'name' => 'trigger_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:12:"Trigger Test";s:11:"description";s:33:"Support module for Trigger tests.";s:7:"package";s:7:"Testing";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"version";s:4:"7.82";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/trigger/trigger.module',
  'name' => 'trigger',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:7:"Trigger";s:11:"description";s:90:"Enables actions to be fired on certain system events, such as when new content is created.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:12:"trigger.test";}s:9:"configure";s:23:"admin/structure/trigger";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/tests/aaa_update_test.module',
  'name' => 'aaa_update_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:15:"AAA Update test";s:11:"description";s:41:"Support module for update module testing.";s:7:"package";s:7:"Testing";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"version";s:4:"7.82";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/tests/bbb_update_test.module',
  'name' => 'bbb_update_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:15:"BBB Update test";s:11:"description";s:41:"Support module for update module testing.";s:7:"package";s:7:"Testing";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"version";s:4:"7.82";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/tests/ccc_update_test.module',
  'name' => 'ccc_update_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:15:"CCC Update test";s:11:"description";s:41:"Support module for update module testing.";s:7:"package";s:7:"Testing";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"version";s:4:"7.82";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/tests/update_test.module',
  'name' => 'update_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:11:"Update test";s:11:"description";s:41:"Support module for update module testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/update.module',
  'name' => 'update',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:14:"Update manager";s:11:"description";s:104:"Checks for available updates, and can securely install or update modules and themes via a web interface.";s:7:"version";s:4:"7.82";s:7:"package";s:4:"Core";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"update.test";}s:9:"configure";s:30:"admin/reports/updates/settings";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/user/tests/user_flood_test.module',
  'name' => 'user_flood_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:31:"User module flood control tests";s:11:"description";s:46:"Support module for user flood control testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/user/tests/user_form_test.module',
  'name' => 'user_form_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:22:"User module form tests";s:11:"description";s:37:"Support module for user form testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/user/tests/user_session_test.module',
  'name' => 'user_session_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:25:"User module session tests";s:11:"description";s:40:"Support module for user session testing.";s:7:"package";s:7:"Testing";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/user/user.module',
  'name' => 'user',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7018',
  'weight' => '0',
  'info' => 'a:15:{s:4:"name";s:4:"User";s:11:"description";s:47:"Manages the user registration and login system.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:11:"user.module";i:1;s:9:"user.test";}s:8:"required";b:1;s:9:"configure";s:19:"admin/config/people";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:8:"user.css";s:21:"modules/user/user.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'profiles/standard/standard.profile',
  'name' => 'standard',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '1000',
  'info' => 'a:15:{s:4:"name";s:8:"Standard";s:11:"description";s:51:"Install with commonly used features pre-configured.";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:12:"dependencies";a:21:{i:0;s:5:"block";i:1;s:5:"color";i:2;s:7:"comment";i:3;s:10:"contextual";i:4;s:9:"dashboard";i:5;s:4:"help";i:6;s:5:"image";i:7;s:4:"list";i:8;s:4:"menu";i:9;s:6:"number";i:10;s:7:"options";i:11;s:4:"path";i:12;s:8:"taxonomy";i:13;s:5:"dblog";i:14;s:6:"search";i:15;s:8:"shortcut";i:16;s:7:"toolbar";i:17;s:7:"overlay";i:18;s:8:"field_ui";i:19;s:4:"file";i:20;s:3:"rdf";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:5:"mtime";i:1626883669;s:7:"package";s:5:"Other";s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;s:6:"hidden";b:1;s:8:"required";b:1;s:17:"distribution_name";s:6:"Drupal";}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/bulk_export/bulk_export.module',
  'name' => 'bulk_export',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:11:"Bulk Export";s:11:"description";s:67:"Performs bulk exporting of data objects known about by Chaos tools.";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:7:"package";s:16:"Chaos tool suite";s:7:"version";s:8:"7.x-1.19";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1611988843";s:5:"mtime";i:1611988843;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/ctools.module',
  'name' => 'ctools',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '6008',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:11:"Chaos tools";s:11:"description";s:46:"A library of helpful tools by Merlin of Chaos.";s:4:"core";s:3:"7.x";s:7:"package";s:16:"Chaos tool suite";s:5:"files";a:14:{i:0;s:20:"includes/context.inc";i:1;s:22:"includes/css-cache.inc";i:2;s:22:"includes/math-expr.inc";i:3;s:21:"includes/stylizer.inc";i:4;s:18:"tests/context.test";i:5;s:14:"tests/css.test";i:6;s:20:"tests/css_cache.test";i:7;s:25:"tests/ctools.plugins.test";i:8;s:17:"tests/ctools.test";i:9;s:26:"tests/math_expression.test";i:10;s:32:"tests/math_expression_stack.test";i:11;s:23:"tests/object_cache.test";i:12;s:28:"tests/object_cache_unit.test";i:13;s:22:"tests/page_tokens.test";}s:7:"version";s:8:"7.x-1.19";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1611988843";s:5:"mtime";i:1611988843;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/ctools_access_ruleset/ctools_access_ruleset.module',
  'name' => 'ctools_access_ruleset',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:15:"Custom rulesets";s:11:"description";s:81:"Create custom, exportable, reusable access rulesets for applications like Panels.";s:4:"core";s:3:"7.x";s:7:"package";s:16:"Chaos tool suite";s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:7:"version";s:8:"7.x-1.19";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1611988843";s:5:"mtime";i:1611988843;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/ctools_ajax_sample/ctools_ajax_sample.module',
  'name' => 'ctools_ajax_sample',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:33:"Chaos Tools (CTools) AJAX Example";s:11:"description";s:41:"Shows how to use the power of Chaos AJAX.";s:7:"package";s:16:"Chaos tool suite";s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:4:"core";s:3:"7.x";s:7:"version";s:8:"7.x-1.19";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1611988843";s:5:"mtime";i:1611988843;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/ctools_custom_content/ctools_custom_content.module',
  'name' => 'ctools_custom_content',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:20:"Custom content panes";s:11:"description";s:79:"Create custom, exportable, reusable content panes for applications like Panels.";s:4:"core";s:3:"7.x";s:7:"package";s:16:"Chaos tool suite";s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:7:"version";s:8:"7.x-1.19";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1611988843";s:5:"mtime";i:1611988843;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/ctools_plugin_example/ctools_plugin_example.module',
  'name' => 'ctools_plugin_example',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:35:"Chaos Tools (CTools) Plugin Example";s:11:"description";s:75:"Shows how an external module can provide ctools plugins (for Panels, etc.).";s:7:"package";s:16:"Chaos tool suite";s:12:"dependencies";a:4:{i:0;s:6:"ctools";i:1;s:6:"panels";i:2;s:12:"page_manager";i:3;s:13:"advanced_help";}s:4:"core";s:3:"7.x";s:7:"version";s:8:"7.x-1.19";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1611988843";s:5:"mtime";i:1611988843;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/page_manager/page_manager.module',
  'name' => 'page_manager',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:12:"Page manager";s:11:"description";s:54:"Provides a UI and API to manage pages within the site.";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:7:"package";s:16:"Chaos tool suite";s:5:"files";a:1:{i:0;s:21:"tests/head_links.test";}s:7:"version";s:8:"7.x-1.19";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1611988843";s:5:"mtime";i:1611988843;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/stylizer/stylizer.module',
  'name' => 'stylizer',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:8:"Stylizer";s:11:"description";s:53:"Create custom styles for applications such as Panels.";s:4:"core";s:3:"7.x";s:7:"package";s:16:"Chaos tool suite";s:12:"dependencies";a:2:{i:0;s:6:"ctools";i:1;s:5:"color";}s:7:"version";s:8:"7.x-1.19";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1611988843";s:5:"mtime";i:1611988843;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/term_depth/term_depth.module',
  'name' => 'term_depth',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:17:"Term Depth access";s:11:"description";s:48:"Controls access to context based upon term depth";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:7:"package";s:16:"Chaos tool suite";s:7:"version";s:8:"7.x-1.19";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1611988843";s:5:"mtime";i:1611988843;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/tests/ctools_export_test/ctools_export_test.module',
  'name' => 'ctools_export_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:18:"CTools export test";s:11:"description";s:25:"CTools export test module";s:4:"core";s:3:"7.x";s:7:"package";s:16:"Chaos tool suite";s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:6:"hidden";b:1;s:5:"files";a:1:{i:0;s:18:"ctools_export.test";}s:7:"version";s:8:"7.x-1.19";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1611988843";s:5:"mtime";i:1611988843;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/tests/ctools_plugin_test.module',
  'name' => 'ctools_plugin_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:24:"Chaos tools plugins test";s:11:"description";s:42:"Provides hooks for testing ctools plugins.";s:7:"package";s:16:"Chaos tool suite";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:6:"hidden";b:1;s:7:"version";s:8:"7.x-1.19";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1611988843";s:5:"mtime";i:1611988843;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/views_content/tests/modules/views_content_test.module',
  'name' => 'views_content_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:24:"Views content panes Test";s:11:"description";s:36:"Test module for Views content panes.";s:7:"package";s:5:"Views";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:13:"views_content";}s:6:"hidden";b:1;s:7:"version";s:8:"7.x-1.19";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1611988843";s:5:"mtime";i:1611988843;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/ctools/views_content/views_content.module',
  'name' => 'views_content',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:19:"Views content panes";s:11:"description";s:104:"Allows Views content to be used in Panels, Dashboard and other modules which use the CTools Content API.";s:7:"package";s:16:"Chaos tool suite";s:12:"dependencies";a:2:{i:0;s:6:"ctools";i:1;s:5:"views";}s:4:"core";s:3:"7.x";s:5:"files";a:4:{i:0;s:61:"plugins/views/views_content_plugin_display_ctools_context.inc";i:1;s:57:"plugins/views/views_content_plugin_display_panel_pane.inc";i:2;s:59:"plugins/views/views_content_plugin_style_ctools_context.inc";i:3;s:28:"tests/src/views_content.test";}s:7:"version";s:8:"7.x-1.19";s:7:"project";s:6:"ctools";s:9:"datestamp";s:10:"1611988843";s:5:"mtime";i:1611988843;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/devel/devel.module',
  'name' => 'devel',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:5:"Devel";s:11:"description";s:52:"Various blocks, pages, and functions for developers.";s:7:"package";s:11:"Development";s:4:"core";s:3:"7.x";s:9:"configure";s:30:"admin/config/development/devel";s:4:"tags";a:1:{i:0;s:9:"developer";}s:5:"files";a:2:{i:0;s:10:"devel.test";i:1;s:14:"devel.mail.inc";}s:7:"version";s:7:"7.x-1.7";s:7:"project";s:5:"devel";s:9:"datestamp";s:10:"1550852892";s:5:"mtime";i:1550852892;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/devel/devel_generate/devel_generate.module',
  'name' => 'devel_generate',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:14:"Devel generate";s:11:"description";s:48:"Generate dummy users, nodes, and taxonomy terms.";s:7:"package";s:11:"Development";s:4:"core";s:3:"7.x";s:4:"tags";a:1:{i:0;s:9:"developer";}s:9:"configure";s:33:"admin/config/development/generate";s:5:"files";a:1:{i:0;s:19:"devel_generate.test";}s:7:"version";s:7:"7.x-1.7";s:7:"project";s:5:"devel";s:9:"datestamp";s:10:"1550852892";s:5:"mtime";i:1550852892;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/devel/devel_node_access.module',
  'name' => 'devel_node_access',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:17:"Devel node access";s:11:"description";s:68:"Developer blocks and page illustrating relevant node_access records.";s:7:"package";s:11:"Development";s:12:"dependencies";a:1:{i:0;s:4:"menu";}s:4:"core";s:3:"7.x";s:9:"configure";s:30:"admin/config/development/devel";s:4:"tags";a:1:{i:0;s:9:"developer";}s:7:"version";s:7:"7.x-1.7";s:7:"project";s:5:"devel";s:9:"datestamp";s:10:"1550852892";s:5:"mtime";i:1550852892;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/schemaorg/example/schemaorg_event/schemaorg_event.module',
  'name' => 'schemaorg_event',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:25:"Schema.org example: Event";s:11:"description";s:65:"Example of an event content type with fields mapped to schema.org";s:4:"core";s:3:"7.x";s:7:"package";s:10:"Schema.org";s:12:"dependencies";a:14:{i:0;s:6:"ctools";i:1;s:4:"date";i:2;s:8:"date_api";i:3;s:10:"date_popup";i:4;s:10:"date_views";i:5;s:8:"features";i:6;s:17:"field_sql_storage";i:7;s:4:"node";i:8;s:3:"rdf";i:9;s:9:"schemaorg";i:10;s:9:"strongarm";i:11;s:4:"text";i:12;s:5:"views";i:13;s:8:"views_ui";}s:8:"features";a:6:{s:6:"ctools";a:2:{i:0;s:21:"strongarm:strongarm:1";i:1;s:23:"views:views_default:3.0";}s:5:"field";a:3:{i:0;s:35:"node-schemaorg_event-field_location";i:1;s:41:"node-schemaorg_event-field_schemaorg_date";i:2;s:48:"node-schemaorg_event-field_schemaorg_description";}s:4:"node";a:1:{i:0;s:15:"schemaorg_event";}s:9:"schemaorg";a:1:{i:0;s:20:"node-schemaorg_event";}s:8:"variable";a:12:{i:0;s:33:"comment_anonymous_schemaorg_event";i:1;s:36:"comment_default_mode_schemaorg_event";i:2;s:40:"comment_default_per_page_schemaorg_event";i:3;s:37:"comment_form_location_schemaorg_event";i:4;s:31:"comment_preview_schemaorg_event";i:5;s:23:"comment_schemaorg_event";i:6;s:37:"comment_subject_field_schemaorg_event";i:7;s:28:"menu_options_schemaorg_event";i:8;s:27:"menu_parent_schemaorg_event";i:9;s:28:"node_options_schemaorg_event";i:10;s:28:"node_preview_schemaorg_event";i:11;s:30:"node_submitted_schemaorg_event";}s:10:"views_view";a:1:{i:0;s:6:"events";}}s:5:"mtime";i:1641972237;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/schemaorg/example/schemaorg_person/schemaorg_person.module',
  'name' => 'schemaorg_person',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:26:"Schema.org example: Person";s:11:"description";s:65:"Example of a person content type with fields mapped to schema.org";s:4:"core";s:3:"7.x";s:7:"package";s:10:"Schema.org";s:3:"php";s:5:"5.2.4";s:12:"dependencies";a:5:{i:0;s:8:"features";i:1;s:5:"image";i:2;s:3:"rdf";i:3;s:9:"schemaorg";i:4;s:9:"strongarm";}s:8:"features";a:5:{s:6:"ctools";a:1:{i:0;s:21:"strongarm:strongarm:1";}s:5:"field";a:4:{i:0;s:49:"node-schemaorg_person-field_schemaorg_affiliation";i:1;s:41:"node-schemaorg_person-field_schemaorg_bio";i:2;s:46:"node-schemaorg_person-field_schemaorg_jobtitle";i:3;s:43:"node-schemaorg_person-field_schemaorg_photo";}s:4:"node";a:1:{i:0;s:16:"schemaorg_person";}s:9:"schemaorg";a:1:{i:0;s:21:"node-schemaorg_person";}s:8:"variable";a:12:{i:0;s:34:"comment_anonymous_schemaorg_person";i:1;s:37:"comment_default_mode_schemaorg_person";i:2;s:41:"comment_default_per_page_schemaorg_person";i:3;s:38:"comment_form_location_schemaorg_person";i:4;s:32:"comment_preview_schemaorg_person";i:5;s:24:"comment_schemaorg_person";i:6;s:38:"comment_subject_field_schemaorg_person";i:7;s:29:"menu_options_schemaorg_person";i:8;s:28:"menu_parent_schemaorg_person";i:9;s:29:"node_options_schemaorg_person";i:10;s:29:"node_preview_schemaorg_person";i:11;s:31:"node_submitted_schemaorg_person";}}s:5:"mtime";i:1641972237;s:7:"version";N;s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/schemaorg/example/schemaorg_recipe/schemaorg_recipe.module',
  'name' => 'schemaorg_recipe',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:26:"Schema.org example: Recipe";s:11:"description";s:65:"Example of a recipe content type with fields mapped to schema.org";s:4:"core";s:3:"7.x";s:7:"package";s:10:"Schema.org";s:12:"dependencies";a:5:{i:0;s:8:"features";i:1;s:5:"image";i:2;s:3:"rdf";i:3;s:6:"recipe";i:4;s:9:"schemaorg";}s:8:"features";a:2:{s:5:"field";a:1:{i:0;s:33:"node-recipe-field_schemaorg_image";}s:9:"schemaorg";a:1:{i:0;s:11:"node-recipe";}}s:5:"mtime";i:1641972237;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/schemaorg/modules/schemaorg_contrib/schemaorg_contrib.module',
  'name' => 'schemaorg_contrib',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:42:"Schema.org support for contributed modules";s:11:"description";s:82:"Add support for fields from contributed modules such as addressfield and fivestar.";s:7:"package";s:10:"Schema.org";s:12:"dependencies";a:1:{i:0;s:9:"schemaorg";}s:4:"core";s:3:"7.x";s:5:"mtime";i:1641972237;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/schemaorg/modules/schemaorg_ui/schemaorg_ui.module',
  'name' => 'schemaorg_ui',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:13:"Schema.org UI";s:11:"description";s:58:"User interface for setting the schema.org module mappings.";s:7:"package";s:10:"Schema.org";s:12:"dependencies";a:2:{i:0;s:3:"rdf";i:1;s:9:"schemaorg";}s:4:"core";s:3:"7.x";s:5:"mtime";i:1641972237;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/schemaorg/schemaorg.module',
  'name' => 'schemaorg',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"Schema.org";s:11:"description";s:60:"Allows to annotate content using the schema.org vocabularies";s:7:"package";s:10:"Schema.org";s:12:"dependencies";a:1:{i:0;s:3:"rdf";}s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:14:"schemaorg.test";}s:5:"mtime";i:1641972237;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/views/tests/views_test.module',
  'name' => 'views_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Views Test";s:11:"description";s:22:"Test module for Views.";s:7:"package";s:5:"Views";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"views";}s:6:"hidden";b:1;s:7:"version";s:8:"7.x-3.25";s:7:"project";s:5:"views";s:9:"datestamp";s:10:"1631208790";s:5:"mtime";i:1631208790;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/views/views.module',
  'name' => 'views',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '7301',
  'weight' => '10',
  'info' => 'a:13:{s:4:"name";s:5:"Views";s:11:"description";s:55:"Create customized lists and queries from your database.";s:7:"package";s:5:"Views";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:13:"css/views.css";s:45:"sites/all/modules/contrib/views/css/views.css";}}s:12:"dependencies";a:1:{i:0;s:6:"ctools";}s:5:"files";a:316:{i:0;s:31:"handlers/views_handler_area.inc";i:1;s:40:"handlers/views_handler_area_messages.inc";i:2;s:38:"handlers/views_handler_area_result.inc";i:3;s:36:"handlers/views_handler_area_text.inc";i:4;s:43:"handlers/views_handler_area_text_custom.inc";i:5;s:36:"handlers/views_handler_area_view.inc";i:6;s:35:"handlers/views_handler_argument.inc";i:7;s:40:"handlers/views_handler_argument_date.inc";i:8;s:43:"handlers/views_handler_argument_formula.inc";i:9;s:47:"handlers/views_handler_argument_many_to_one.inc";i:10;s:40:"handlers/views_handler_argument_null.inc";i:11;s:43:"handlers/views_handler_argument_numeric.inc";i:12;s:42:"handlers/views_handler_argument_string.inc";i:13;s:52:"handlers/views_handler_argument_group_by_numeric.inc";i:14;s:32:"handlers/views_handler_field.inc";i:15;s:40:"handlers/views_handler_field_counter.inc";i:16;s:40:"handlers/views_handler_field_boolean.inc";i:17;s:49:"handlers/views_handler_field_contextual_links.inc";i:18;s:48:"handlers/views_handler_field_ctools_dropdown.inc";i:19;s:39:"handlers/views_handler_field_custom.inc";i:20;s:37:"handlers/views_handler_field_date.inc";i:21;s:39:"handlers/views_handler_field_entity.inc";i:22;s:38:"handlers/views_handler_field_links.inc";i:23;s:39:"handlers/views_handler_field_markup.inc";i:24;s:37:"handlers/views_handler_field_math.inc";i:25;s:40:"handlers/views_handler_field_numeric.inc";i:26;s:47:"handlers/views_handler_field_prerender_list.inc";i:27;s:46:"handlers/views_handler_field_time_interval.inc";i:28;s:43:"handlers/views_handler_field_serialized.inc";i:29;s:45:"handlers/views_handler_field_machine_name.inc";i:30;s:36:"handlers/views_handler_field_url.inc";i:31;s:33:"handlers/views_handler_filter.inc";i:32;s:50:"handlers/views_handler_filter_boolean_operator.inc";i:33;s:57:"handlers/views_handler_filter_boolean_operator_string.inc";i:34;s:41:"handlers/views_handler_filter_combine.inc";i:35;s:38:"handlers/views_handler_filter_date.inc";i:36;s:42:"handlers/views_handler_filter_equality.inc";i:37;s:47:"handlers/views_handler_filter_entity_bundle.inc";i:38;s:50:"handlers/views_handler_filter_group_by_numeric.inc";i:39;s:45:"handlers/views_handler_filter_in_operator.inc";i:40;s:45:"handlers/views_handler_filter_many_to_one.inc";i:41;s:41:"handlers/views_handler_filter_numeric.inc";i:42;s:40:"handlers/views_handler_filter_string.inc";i:43;s:48:"handlers/views_handler_filter_fields_compare.inc";i:44;s:39:"handlers/views_handler_relationship.inc";i:45;s:53:"handlers/views_handler_relationship_groupwise_max.inc";i:46;s:31:"handlers/views_handler_sort.inc";i:47;s:36:"handlers/views_handler_sort_date.inc";i:48;s:39:"handlers/views_handler_sort_formula.inc";i:49;s:48:"handlers/views_handler_sort_group_by_numeric.inc";i:50;s:46:"handlers/views_handler_sort_menu_hierarchy.inc";i:51;s:38:"handlers/views_handler_sort_random.inc";i:52;s:17:"includes/base.inc";i:53;s:21:"includes/handlers.inc";i:54;s:20:"includes/plugins.inc";i:55;s:17:"includes/view.inc";i:56;s:60:"modules/aggregator/views_handler_argument_aggregator_fid.inc";i:57;s:60:"modules/aggregator/views_handler_argument_aggregator_iid.inc";i:58;s:69:"modules/aggregator/views_handler_argument_aggregator_category_cid.inc";i:59;s:64:"modules/aggregator/views_handler_field_aggregator_title_link.inc";i:60;s:62:"modules/aggregator/views_handler_field_aggregator_category.inc";i:61;s:70:"modules/aggregator/views_handler_field_aggregator_item_description.inc";i:62;s:57:"modules/aggregator/views_handler_field_aggregator_xss.inc";i:63;s:67:"modules/aggregator/views_handler_filter_aggregator_category_cid.inc";i:64;s:54:"modules/aggregator/views_plugin_row_aggregator_rss.inc";i:65;s:56:"modules/book/views_plugin_argument_default_book_root.inc";i:66;s:59:"modules/comment/views_handler_argument_comment_user_uid.inc";i:67;s:47:"modules/comment/views_handler_field_comment.inc";i:68;s:53:"modules/comment/views_handler_field_comment_depth.inc";i:69;s:52:"modules/comment/views_handler_field_comment_link.inc";i:70;s:60:"modules/comment/views_handler_field_comment_link_approve.inc";i:71;s:59:"modules/comment/views_handler_field_comment_link_delete.inc";i:72;s:57:"modules/comment/views_handler_field_comment_link_edit.inc";i:73;s:58:"modules/comment/views_handler_field_comment_link_reply.inc";i:74;s:57:"modules/comment/views_handler_field_comment_node_link.inc";i:75;s:56:"modules/comment/views_handler_field_comment_username.inc";i:76;s:61:"modules/comment/views_handler_field_ncs_last_comment_name.inc";i:77;s:56:"modules/comment/views_handler_field_ncs_last_updated.inc";i:78;s:52:"modules/comment/views_handler_field_node_comment.inc";i:79;s:57:"modules/comment/views_handler_field_node_new_comments.inc";i:80;s:62:"modules/comment/views_handler_field_last_comment_timestamp.inc";i:81;s:57:"modules/comment/views_handler_filter_comment_user_uid.inc";i:82;s:57:"modules/comment/views_handler_filter_ncs_last_updated.inc";i:83;s:53:"modules/comment/views_handler_filter_node_comment.inc";i:84;s:53:"modules/comment/views_handler_sort_comment_thread.inc";i:85;s:60:"modules/comment/views_handler_sort_ncs_last_comment_name.inc";i:86;s:55:"modules/comment/views_handler_sort_ncs_last_updated.inc";i:87;s:48:"modules/comment/views_plugin_row_comment_rss.inc";i:88;s:49:"modules/comment/views_plugin_row_comment_view.inc";i:89;s:52:"modules/contact/views_handler_field_contact_link.inc";i:90;s:43:"modules/field/views_handler_field_field.inc";i:91;s:59:"modules/field/views_handler_relationship_entity_reverse.inc";i:92;s:51:"modules/field/views_handler_argument_field_list.inc";i:93;s:57:"modules/field/views_handler_filter_field_list_boolean.inc";i:94;s:58:"modules/field/views_handler_argument_field_list_string.inc";i:95;s:49:"modules/field/views_handler_filter_field_list.inc";i:96;s:57:"modules/filter/views_handler_field_filter_format_name.inc";i:97;s:52:"modules/locale/views_handler_field_node_language.inc";i:98;s:53:"modules/locale/views_handler_filter_node_language.inc";i:99;s:54:"modules/locale/views_handler_argument_locale_group.inc";i:100;s:57:"modules/locale/views_handler_argument_locale_language.inc";i:101;s:51:"modules/locale/views_handler_field_locale_group.inc";i:102;s:54:"modules/locale/views_handler_field_locale_language.inc";i:103;s:55:"modules/locale/views_handler_field_locale_link_edit.inc";i:104;s:52:"modules/locale/views_handler_filter_locale_group.inc";i:105;s:55:"modules/locale/views_handler_filter_locale_language.inc";i:106;s:54:"modules/locale/views_handler_filter_locale_version.inc";i:107;s:51:"modules/locale/views_handler_sort_node_language.inc";i:108;s:53:"modules/node/views_handler_argument_dates_various.inc";i:109;s:53:"modules/node/views_handler_argument_node_language.inc";i:110;s:48:"modules/node/views_handler_argument_node_nid.inc";i:111;s:49:"modules/node/views_handler_argument_node_type.inc";i:112;s:48:"modules/node/views_handler_argument_node_vid.inc";i:113;s:57:"modules/node/views_handler_argument_node_uid_revision.inc";i:114;s:59:"modules/node/views_handler_field_history_user_timestamp.inc";i:115;s:41:"modules/node/views_handler_field_node.inc";i:116;s:46:"modules/node/views_handler_field_node_link.inc";i:117;s:53:"modules/node/views_handler_field_node_link_delete.inc";i:118;s:51:"modules/node/views_handler_field_node_link_edit.inc";i:119;s:50:"modules/node/views_handler_field_node_revision.inc";i:120;s:55:"modules/node/views_handler_field_node_revision_link.inc";i:121;s:62:"modules/node/views_handler_field_node_revision_link_delete.inc";i:122;s:62:"modules/node/views_handler_field_node_revision_link_revert.inc";i:123;s:46:"modules/node/views_handler_field_node_path.inc";i:124;s:46:"modules/node/views_handler_field_node_type.inc";i:125;s:55:"modules/node/views_handler_field_node_version_count.inc";i:126;s:60:"modules/node/views_handler_filter_history_user_timestamp.inc";i:127;s:49:"modules/node/views_handler_filter_node_access.inc";i:128;s:49:"modules/node/views_handler_filter_node_status.inc";i:129;s:47:"modules/node/views_handler_filter_node_type.inc";i:130;s:55:"modules/node/views_handler_filter_node_uid_revision.inc";i:131;s:56:"modules/node/views_handler_filter_node_version_count.inc";i:132;s:54:"modules/node/views_handler_sort_node_version_count.inc";i:133;s:51:"modules/node/views_plugin_argument_default_node.inc";i:134;s:52:"modules/node/views_plugin_argument_validate_node.inc";i:135;s:42:"modules/node/views_plugin_row_node_rss.inc";i:136;s:43:"modules/node/views_plugin_row_node_view.inc";i:137;s:52:"modules/profile/views_handler_field_profile_date.inc";i:138;s:52:"modules/profile/views_handler_field_profile_list.inc";i:139;s:58:"modules/profile/views_handler_filter_profile_selection.inc";i:140;s:48:"modules/search/views_handler_argument_search.inc";i:141;s:51:"modules/search/views_handler_field_search_score.inc";i:142;s:46:"modules/search/views_handler_filter_search.inc";i:143;s:50:"modules/search/views_handler_sort_search_score.inc";i:144;s:47:"modules/search/views_plugin_row_search_view.inc";i:145;s:57:"modules/statistics/views_handler_field_accesslog_path.inc";i:146;s:65:"modules/statistics/views_handler_field_node_counter_timestamp.inc";i:147;s:61:"modules/statistics/views_handler_field_statistics_numeric.inc";i:148;s:50:"modules/system/views_handler_argument_file_fid.inc";i:149;s:43:"modules/system/views_handler_field_file.inc";i:150;s:53:"modules/system/views_handler_field_file_extension.inc";i:151;s:52:"modules/system/views_handler_field_file_filemime.inc";i:152;s:47:"modules/system/views_handler_field_file_uri.inc";i:153;s:50:"modules/system/views_handler_field_file_status.inc";i:154;s:51:"modules/system/views_handler_filter_file_status.inc";i:155;s:52:"modules/taxonomy/views_handler_argument_taxonomy.inc";i:156;s:57:"modules/taxonomy/views_handler_argument_term_node_tid.inc";i:157;s:63:"modules/taxonomy/views_handler_argument_term_node_tid_depth.inc";i:158;s:68:"modules/taxonomy/views_handler_argument_term_node_tid_depth_join.inc";i:159;s:72:"modules/taxonomy/views_handler_argument_term_node_tid_depth_modifier.inc";i:160;s:58:"modules/taxonomy/views_handler_argument_vocabulary_vid.inc";i:161;s:67:"modules/taxonomy/views_handler_argument_vocabulary_machine_name.inc";i:162;s:49:"modules/taxonomy/views_handler_field_taxonomy.inc";i:163;s:54:"modules/taxonomy/views_handler_field_term_node_tid.inc";i:164;s:55:"modules/taxonomy/views_handler_field_term_link_edit.inc";i:165;s:55:"modules/taxonomy/views_handler_filter_term_node_tid.inc";i:166;s:61:"modules/taxonomy/views_handler_filter_term_node_tid_depth.inc";i:167;s:66:"modules/taxonomy/views_handler_filter_term_node_tid_depth_join.inc";i:168;s:56:"modules/taxonomy/views_handler_filter_vocabulary_vid.inc";i:169;s:65:"modules/taxonomy/views_handler_filter_vocabulary_machine_name.inc";i:170;s:62:"modules/taxonomy/views_handler_relationship_node_term_data.inc";i:171;s:65:"modules/taxonomy/views_plugin_argument_validate_taxonomy_term.inc";i:172;s:63:"modules/taxonomy/views_plugin_argument_default_taxonomy_tid.inc";i:173;s:67:"modules/tracker/views_handler_argument_tracker_comment_user_uid.inc";i:174;s:65:"modules/tracker/views_handler_filter_tracker_comment_user_uid.inc";i:175;s:65:"modules/tracker/views_handler_filter_tracker_boolean_operator.inc";i:176;s:51:"modules/system/views_handler_filter_system_type.inc";i:177;s:56:"modules/translation/views_handler_argument_node_tnid.inc";i:178;s:63:"modules/translation/views_handler_field_node_link_translate.inc";i:179;s:65:"modules/translation/views_handler_field_node_translation_link.inc";i:180;s:54:"modules/translation/views_handler_filter_node_tnid.inc";i:181;s:60:"modules/translation/views_handler_filter_node_tnid_child.inc";i:182;s:62:"modules/translation/views_handler_relationship_translation.inc";i:183;s:48:"modules/user/views_handler_argument_user_uid.inc";i:184;s:55:"modules/user/views_handler_argument_users_roles_rid.inc";i:185;s:41:"modules/user/views_handler_field_user.inc";i:186;s:50:"modules/user/views_handler_field_user_language.inc";i:187;s:46:"modules/user/views_handler_field_user_link.inc";i:188;s:53:"modules/user/views_handler_field_user_link_cancel.inc";i:189;s:51:"modules/user/views_handler_field_user_link_edit.inc";i:190;s:46:"modules/user/views_handler_field_user_mail.inc";i:191;s:46:"modules/user/views_handler_field_user_name.inc";i:192;s:53:"modules/user/views_handler_field_user_permissions.inc";i:193;s:49:"modules/user/views_handler_field_user_picture.inc";i:194;s:47:"modules/user/views_handler_field_user_roles.inc";i:195;s:50:"modules/user/views_handler_filter_user_current.inc";i:196;s:47:"modules/user/views_handler_filter_user_name.inc";i:197;s:54:"modules/user/views_handler_filter_user_permissions.inc";i:198;s:48:"modules/user/views_handler_filter_user_roles.inc";i:199;s:59:"modules/user/views_plugin_argument_default_current_user.inc";i:200;s:51:"modules/user/views_plugin_argument_default_user.inc";i:201;s:52:"modules/user/views_plugin_argument_validate_user.inc";i:202;s:43:"modules/user/views_plugin_row_user_view.inc";i:203;s:31:"plugins/views_plugin_access.inc";i:204;s:36:"plugins/views_plugin_access_none.inc";i:205;s:36:"plugins/views_plugin_access_perm.inc";i:206;s:36:"plugins/views_plugin_access_role.inc";i:207;s:41:"plugins/views_plugin_argument_default.inc";i:208;s:45:"plugins/views_plugin_argument_default_php.inc";i:209;s:47:"plugins/views_plugin_argument_default_fixed.inc";i:210;s:45:"plugins/views_plugin_argument_default_raw.inc";i:211;s:42:"plugins/views_plugin_argument_validate.inc";i:212;s:50:"plugins/views_plugin_argument_validate_numeric.inc";i:213;s:46:"plugins/views_plugin_argument_validate_php.inc";i:214;s:30:"plugins/views_plugin_cache.inc";i:215;s:35:"plugins/views_plugin_cache_none.inc";i:216;s:35:"plugins/views_plugin_cache_time.inc";i:217;s:32:"plugins/views_plugin_display.inc";i:218;s:43:"plugins/views_plugin_display_attachment.inc";i:219;s:38:"plugins/views_plugin_display_block.inc";i:220;s:40:"plugins/views_plugin_display_default.inc";i:221;s:38:"plugins/views_plugin_display_embed.inc";i:222;s:41:"plugins/views_plugin_display_extender.inc";i:223;s:37:"plugins/views_plugin_display_feed.inc";i:224;s:37:"plugins/views_plugin_display_page.inc";i:225;s:43:"plugins/views_plugin_exposed_form_basic.inc";i:226;s:37:"plugins/views_plugin_exposed_form.inc";i:227;s:52:"plugins/views_plugin_exposed_form_input_required.inc";i:228;s:42:"plugins/views_plugin_localization_core.inc";i:229;s:37:"plugins/views_plugin_localization.inc";i:230;s:42:"plugins/views_plugin_localization_none.inc";i:231;s:30:"plugins/views_plugin_pager.inc";i:232;s:35:"plugins/views_plugin_pager_full.inc";i:233;s:35:"plugins/views_plugin_pager_mini.inc";i:234;s:35:"plugins/views_plugin_pager_none.inc";i:235;s:35:"plugins/views_plugin_pager_some.inc";i:236;s:30:"plugins/views_plugin_query.inc";i:237;s:38:"plugins/views_plugin_query_default.inc";i:238;s:28:"plugins/views_plugin_row.inc";i:239;s:35:"plugins/views_plugin_row_fields.inc";i:240;s:39:"plugins/views_plugin_row_rss_fields.inc";i:241;s:30:"plugins/views_plugin_style.inc";i:242;s:38:"plugins/views_plugin_style_default.inc";i:243;s:35:"plugins/views_plugin_style_grid.inc";i:244;s:35:"plugins/views_plugin_style_list.inc";i:245;s:40:"plugins/views_plugin_style_jump_menu.inc";i:246;s:38:"plugins/views_plugin_style_mapping.inc";i:247;s:34:"plugins/views_plugin_style_rss.inc";i:248;s:38:"plugins/views_plugin_style_summary.inc";i:249;s:48:"plugins/views_plugin_style_summary_jump_menu.inc";i:250;s:50:"plugins/views_plugin_style_summary_unformatted.inc";i:251;s:36:"plugins/views_plugin_style_table.inc";i:252;s:34:"tests/handlers/views_handlers.test";i:253;s:43:"tests/handlers/views_handler_area_text.test";i:254;s:47:"tests/handlers/views_handler_argument_null.test";i:255;s:39:"tests/handlers/views_handler_field.test";i:256;s:47:"tests/handlers/views_handler_field_boolean.test";i:257;s:46:"tests/handlers/views_handler_field_custom.test";i:258;s:47:"tests/handlers/views_handler_field_counter.test";i:259;s:44:"tests/handlers/views_handler_field_date.test";i:260;s:54:"tests/handlers/views_handler_field_file_extension.test";i:261;s:49:"tests/handlers/views_handler_field_file_size.test";i:262;s:44:"tests/handlers/views_handler_field_math.test";i:263;s:43:"tests/handlers/views_handler_field_url.test";i:264;s:43:"tests/handlers/views_handler_field_xss.test";i:265;s:48:"tests/handlers/views_handler_filter_combine.test";i:266;s:45:"tests/handlers/views_handler_filter_date.test";i:267;s:49:"tests/handlers/views_handler_filter_equality.test";i:268;s:52:"tests/handlers/views_handler_filter_in_operator.test";i:269;s:48:"tests/handlers/views_handler_filter_numeric.test";i:270;s:47:"tests/handlers/views_handler_filter_string.test";i:271;s:43:"tests/handlers/views_handler_manytoone.test";i:272;s:45:"tests/handlers/views_handler_sort_random.test";i:273;s:43:"tests/handlers/views_handler_sort_date.test";i:274;s:38:"tests/handlers/views_handler_sort.test";i:275;s:46:"tests/test_handlers/views_test_area_access.inc";i:276;s:60:"tests/test_plugins/views_test_plugin_access_test_dynamic.inc";i:277;s:59:"tests/test_plugins/views_test_plugin_access_test_static.inc";i:278;s:59:"tests/test_plugins/views_test_plugin_style_test_mapping.inc";i:279;s:39:"tests/plugins/views_plugin_display.test";i:280;s:46:"tests/styles/views_plugin_style_jump_menu.test";i:281;s:36:"tests/styles/views_plugin_style.test";i:282;s:41:"tests/styles/views_plugin_style_base.test";i:283;s:44:"tests/styles/views_plugin_style_mapping.test";i:284;s:48:"tests/styles/views_plugin_style_unformatted.test";i:285;s:23:"tests/views_access.test";i:286;s:24:"tests/views_analyze.test";i:287;s:22:"tests/views_basic.test";i:288;s:21:"tests/views_ajax.test";i:289;s:33:"tests/views_argument_default.test";i:290;s:35:"tests/views_argument_validator.test";i:291;s:29:"tests/views_exposed_form.test";i:292;s:31:"tests/field/views_fieldapi.test";i:293;s:25:"tests/views_glossary.test";i:294;s:24:"tests/views_groupby.test";i:295;s:31:"tests/views_handler_filter.test";i:296;s:25:"tests/views_handlers.test";i:297;s:23:"tests/views_module.test";i:298;s:22:"tests/views_pager.test";i:299;s:40:"tests/views_plugin_localization_test.inc";i:300;s:29:"tests/views_translatable.test";i:301;s:22:"tests/views_query.test";i:302;s:24:"tests/views_upgrade.test";i:303;s:34:"tests/views_test.views_default.inc";i:304;s:58:"tests/comment/views_handler_argument_comment_user_uid.test";i:305;s:56:"tests/comment/views_handler_filter_comment_user_uid.test";i:306;s:45:"tests/node/views_node_revision_relations.test";i:307;s:61:"tests/taxonomy/views_handler_relationship_node_term_data.test";i:308;s:45:"tests/user/views_handler_field_user_name.test";i:309;s:43:"tests/user/views_user_argument_default.test";i:310;s:44:"tests/user/views_user_argument_validate.test";i:311;s:26:"tests/user/views_user.test";i:312;s:22:"tests/views_cache.test";i:313;s:22:"tests/views_clone.test";i:314;s:21:"tests/views_view.test";i:315;s:19:"tests/views_ui.test";}s:7:"version";s:8:"7.x-3.25";s:7:"project";s:5:"views";s:9:"datestamp";s:10:"1631208790";s:5:"mtime";i:1631208790;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/contrib/views/views_ui.module',
  'name' => 'views_ui',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => "a:14:{s:4:\"name\";s:8:\"Views UI\";s:11:\"description\";s:93:\"Administrative interface to views. Without this module, you cannot create or edit your views.\";s:7:\"package\";s:5:\"Views\";s:4:\"core\";s:3:\"7.x\";s:9:\"configure\";s:21:\"admin/structure/views\";s:12:\"dependencies\";a:1:{i:0;s:5:\"views\";}s:34:\"# @codingStandardsIgnoreLine\nfiles\";a:1:{i:0;s:15:\"views_ui.module\";}s:5:\"files\";a:1:{i:0;s:57:\"plugins/views_wizard/views_ui_base_views_wizard.class.php\";}s:7:\"version\";s:8:\"7.x-3.25\";s:7:\"project\";s:5:\"views\";s:9:\"datestamp\";s:10:\"1631208790\";s:5:\"mtime\";i:1631208790;s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}",
))
->values(array(
  'filename' => 'sites/all/modules/date/date.module',
  'name' => 'date',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7004',
  'weight' => '0',
  'info' => 'a:15:{s:4:"name";s:4:"Date";s:11:"description";s:33:"Makes date/time fields available.";s:12:"dependencies";a:1:{i:0;s:13:"date:date_api";}s:7:"package";s:9:"Date/Time";s:4:"core";s:3:"7.x";s:5:"files";a:10:{i:0;s:16:"date.migrate.inc";i:1;s:26:"tests/DateEmwTestCase.test";i:2;s:27:"tests/DateFormTestCase.test";i:3;s:30:"tests/DateMigrateTestCase.test";i:4;s:30:"tests/DateNowUnitTestCase.test";i:5;s:28:"tests/DateFieldTestBase.test";i:6;s:28:"tests/DateFieldTestCase.test";i:7;s:31:"tests/DateTimezoneTestCase.test";i:8;s:25:"tests/DateUiTestCase.test";i:9;s:33:"tests/DateValidationTestCase.test";}s:17:"test_dependencies";a:4:{i:0;s:13:"entity:entity";i:1;s:23:"features:features (2.x)";i:2;s:15:"migrate:migrate";i:3;s:11:"views:views";}s:7:"version";s:8:"7.x-2.12";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1633627650";s:5:"mtime";i:1633627650;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:8:"required";b:1;s:11:"explanation";s:73:"Field type(s) in use - see <a href="/admin/reports/fields">Field list</a>";}',
))
->values(array(
  'filename' => 'sites/all/modules/date/date_all_day/date_all_day.module',
  'name' => 'date_all_day',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => "a:12:{s:4:\"name\";s:12:\"Date All Day\";s:11:\"description\";s:142:\"Adds 'All Day' functionality to date fields, including an 'All Day' theme and 'All Day' checkboxes for the Date select and Date popup widgets.\";s:7:\"package\";s:9:\"Date/Time\";s:4:\"core\";s:3:\"7.x\";s:12:\"dependencies\";a:2:{i:0;s:13:\"date:date_api\";i:1;s:9:\"date:date\";}s:5:\"files\";a:2:{i:0;s:31:\"tests/DateAllDayUiTestCase.test\";i:1;s:32:\"tests/DateAllDayUpdatesTest.test\";}s:7:\"version\";s:8:\"7.x-2.12\";s:7:\"project\";s:4:\"date\";s:9:\"datestamp\";s:10:\"1633627650\";s:5:\"mtime\";i:1633627650;s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}",
))
->values(array(
  'filename' => 'sites/all/modules/date/date_all_day/tests/date_all_day_test_feature/date_all_day_test_feature.module',
  'name' => 'date_all_day_test_feature',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:25:"Date All Day Test Feature";s:11:"description";s:57:"Example content type for testing the Date All Day module.";s:4:"core";s:3:"7.x";s:7:"package";s:9:"Date/Time";s:12:"dependencies";a:3:{i:0;s:9:"date:date";i:1;s:17:"date:date_all_day";i:2;s:17:"features:features";}s:8:"features";a:4:{s:12:"features_api";a:1:{i:0;s:5:"api:2";}s:10:"field_base";a:2:{i:0;s:4:"body";i:1;s:18:"field_date_all_day";}s:14:"field_instance";a:2:{i:0;s:27:"node-date_all_day_test-body";i:1;s:41:"node-date_all_day_test-field_date_all_day";}s:4:"node";a:1:{i:0;s:17:"date_all_day_test";}}s:6:"hidden";s:1:"1";s:7:"version";s:8:"7.x-2.12";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1633627650";s:5:"mtime";i:1633627650;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/date/date_api/date_api.module',
  'name' => 'date_api',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7001',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:8:"Date API";s:11:"description";s:45:"A Date API that can be used by other modules.";s:7:"package";s:9:"Date/Time";s:4:"core";s:3:"7.x";s:5:"files";a:4:{i:0;s:15:"date_api.module";i:1;s:16:"date_api_sql.inc";i:2;s:26:"tests/DateApiTestCase.test";i:3;s:30:"tests/DateApiUnitTestCase.test";}s:7:"version";s:8:"7.x-2.12";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1633627650";s:5:"mtime";i:1633627650;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/date/date_context/date_context.module',
  'name' => 'date_context',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:12:"Date Context";s:11:"description";s:99:"Adds an option to the Context module to set a context condition based on the value of a date field.";s:7:"package";s:9:"Date/Time";s:4:"core";s:3:"7.x";s:12:"dependencies";a:2:{i:0;s:9:"date:date";i:1;s:15:"context:context";}s:5:"files";a:1:{i:0;s:39:"plugins/date_context_date_condition.inc";}s:7:"version";s:8:"7.x-2.12";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1633627650";s:5:"mtime";i:1633627650;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/date/date_migrate/date_migrate.module',
  'name' => 'date_migrate',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:14:"Date Migration";s:11:"description";s:73:"Obsolete data migration module. Disable if no other modules depend on it.";s:4:"core";s:3:"7.x";s:7:"package";s:9:"Date/Time";s:6:"hidden";b:1;s:7:"version";s:8:"7.x-2.12";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1633627650";s:5:"mtime";i:1633627650;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/date/date_popup/date_popup.module',
  'name' => 'date_popup',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Date Popup";s:11:"description";s:84:"Enables jquery popup calendars and time entry widgets for selecting dates and times.";s:7:"package";s:9:"Date/Time";s:4:"core";s:3:"7.x";s:9:"configure";s:28:"admin/config/date/date_popup";s:12:"dependencies";a:1:{i:0;s:13:"date:date_api";}s:5:"files";a:3:{i:0;s:33:"tests/DatePopupFieldTestCase.test";i:1;s:38:"tests/DatePopupValidationTestCase.test";i:2;s:37:"tests/DatePopupWithViewsTestCase.test";}s:7:"version";s:8:"7.x-2.12";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1633627650";s:5:"mtime";i:1633627650;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/date/date_repeat/date_repeat.module',
  'name' => 'date_repeat',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:15:"Date Repeat API";s:11:"description";s:73:"A Date Repeat API to calculate repeating dates and times from iCal rules.";s:7:"package";s:9:"Date/Time";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:13:"date:date_api";}s:5:"files";a:2:{i:0;s:22:"tests/date_repeat.test";i:1;s:27:"tests/date_repeat_form.test";}s:7:"version";s:8:"7.x-2.12";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1633627650";s:5:"mtime";i:1633627650;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/date/date_repeat_field/date_repeat_field.module',
  'name' => 'date_repeat_field',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:17:"Date Repeat Field";s:11:"description";s:97:"Creates the option of Repeating date fields and manages Date fields that use the Date Repeat API.";s:7:"package";s:9:"Date/Time";s:4:"core";s:3:"7.x";s:12:"dependencies";a:3:{i:0;s:13:"date:date_api";i:1;s:9:"date:date";i:2;s:16:"date:date_repeat";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:21:"date_repeat_field.css";s:62:"sites/all/modules/date/date_repeat_field/date_repeat_field.css";}}s:7:"version";s:8:"7.x-2.12";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1633627650";s:5:"mtime";i:1633627650;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/date/date_tools/date_tools.module',
  'name' => 'date_tools',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Date Tools";s:11:"description";s:52:"Tools to import and auto-create dates and calendars.";s:7:"package";s:9:"Date/Time";s:4:"core";s:3:"7.x";s:9:"configure";s:23:"admin/config/date/tools";s:12:"dependencies";a:1:{i:0;s:9:"date:date";}s:5:"files";a:1:{i:0;s:28:"tests/DateToolsTestCase.test";}s:7:"version";s:8:"7.x-2.12";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1633627650";s:5:"mtime";i:1633627650;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/date/date_views/date_views.module',
  'name' => 'date_views',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:10:"Date Views";s:11:"description";s:57:"Views integration for date fields and date functionality.";s:7:"package";s:9:"Date/Time";s:4:"core";s:3:"7.x";s:12:"dependencies";a:2:{i:0;s:13:"date:date_api";i:1;s:11:"views:views";}s:5:"files";a:7:{i:0;s:40:"includes/date_views_argument_handler.inc";i:1;s:47:"includes/date_views_argument_handler_simple.inc";i:2;s:38:"includes/date_views_filter_handler.inc";i:3;s:45:"includes/date_views_filter_handler_simple.inc";i:4;s:36:"includes/date_views_plugin_pager.inc";i:5;s:28:"tests/date_views_filter.test";i:6;s:27:"tests/date_views_pager.test";}s:7:"version";s:8:"7.x-2.12";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1633627650";s:5:"mtime";i:1633627650;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/date/tests/date_migrate_test/date_migrate_test.module',
  'name' => 'date_migrate_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => "a:13:{s:4:\"name\";s:26:\"Date Migration Test Helper\";s:11:\"description\";s:53:\"Helper for the Date module's Migrate API integration.\";s:7:\"package\";s:9:\"Date/Time\";s:4:\"core\";s:3:\"7.x\";s:6:\"hidden\";b:1;s:12:\"dependencies\";a:2:{i:0;s:22:\"date:date_test_feature\";i:1;s:15:\"migrate:migrate\";}s:5:\"files\";a:1:{i:0;s:29:\"date_migrate_test.migrate.inc\";}s:7:\"version\";s:8:\"7.x-2.12\";s:7:\"project\";s:4:\"date\";s:9:\"datestamp\";s:10:\"1633627650\";s:5:\"mtime\";i:1633627650;s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}",
))
->values(array(
  'filename' => 'sites/all/modules/date/tests/date_test/date_test.module',
  'name' => 'date_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:17:"Date module tests";s:11:"description";s:40:"Support module for date related testing.";s:7:"package";s:9:"Date/Time";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:9:"date:date";}s:7:"version";s:8:"7.x-2.12";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1633627650";s:5:"mtime";i:1633627650;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/date/tests/date_test_feature/date_test_feature.module',
  'name' => 'date_test_feature',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:17:"Date Test Feature";s:11:"description";s:73:"Examples of migrating with the Date module, primarily for use with tests.";s:4:"core";s:3:"7.x";s:7:"package";s:9:"Date/Time";s:6:"hidden";b:1;s:12:"dependencies";a:4:{i:0;s:9:"date:date";i:1;s:16:"date:date_repeat";i:2;s:22:"date:date_repeat_field";i:3;s:17:"features:features";}s:8:"features";a:4:{s:12:"features_api";a:1:{i:0;s:5:"api:2";}s:10:"field_base";a:8:{i:0;s:4:"body";i:1;s:10:"field_date";i:2;s:16:"field_date_range";i:3;s:17:"field_date_repeat";i:4;s:15:"field_datestamp";i:5;s:21:"field_datestamp_range";i:6;s:14:"field_datetime";i:7;s:20:"field_datetime_range";}s:14:"field_instance";a:8:{i:0;s:19:"node-date_test-body";i:1;s:25:"node-date_test-field_date";i:2;s:31:"node-date_test-field_date_range";i:3;s:32:"node-date_test-field_date_repeat";i:4;s:30:"node-date_test-field_datestamp";i:5;s:36:"node-date_test-field_datestamp_range";i:6;s:29:"node-date_test-field_datetime";i:7;s:35:"node-date_test-field_datetime_range";}s:4:"node";a:1:{i:0;s:9:"date_test";}}s:7:"version";s:8:"7.x-2.12";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1633627650";s:5:"mtime";i:1633627650;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/email/email.module',
  'name' => 'email',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:5:"Email";s:11:"description";s:28:"Defines an email field type.";s:4:"core";s:3:"7.x";s:7:"package";s:6:"Fields";s:5:"files";a:1:{i:0;s:17:"email.migrate.inc";}s:7:"version";s:7:"7.x-1.3";s:7:"project";s:5:"email";s:9:"datestamp";s:10:"1397134155";s:5:"mtime";i:1397134155;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entity/entity.module',
  'name' => 'entity',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7003',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:10:"Entity API";s:11:"description";s:69:"Enables modules to work with any entity type and to provide entities.";s:4:"core";s:3:"7.x";s:5:"files";a:24:{i:0;s:19:"entity.features.inc";i:1;s:15:"entity.i18n.inc";i:2;s:15:"entity.info.inc";i:3;s:16:"entity.rules.inc";i:4;s:11:"entity.test";i:5;s:19:"includes/entity.inc";i:6;s:30:"includes/entity.controller.inc";i:7;s:22:"includes/entity.ui.inc";i:8;s:27:"includes/entity.wrapper.inc";i:9;s:22:"views/entity.views.inc";i:10;s:52:"views/handlers/entity_views_field_handler_helper.inc";i:11;s:51:"views/handlers/entity_views_handler_area_entity.inc";i:12;s:53:"views/handlers/entity_views_handler_field_boolean.inc";i:13;s:50:"views/handlers/entity_views_handler_field_date.inc";i:14;s:54:"views/handlers/entity_views_handler_field_duration.inc";i:15;s:52:"views/handlers/entity_views_handler_field_entity.inc";i:16;s:51:"views/handlers/entity_views_handler_field_field.inc";i:17;s:53:"views/handlers/entity_views_handler_field_numeric.inc";i:18;s:53:"views/handlers/entity_views_handler_field_options.inc";i:19;s:50:"views/handlers/entity_views_handler_field_text.inc";i:20;s:49:"views/handlers/entity_views_handler_field_uri.inc";i:21;s:62:"views/handlers/entity_views_handler_relationship_by_bundle.inc";i:22;s:52:"views/handlers/entity_views_handler_relationship.inc";i:23;s:53:"views/plugins/entity_views_plugin_row_entity_view.inc";}s:7:"version";s:7:"7.x-1.9";s:7:"project";s:6:"entity";s:9:"datestamp";s:10:"1518620551";s:5:"mtime";i:1518620551;s:12:"dependencies";a:0:{}s:7:"package";s:5:"Other";s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entity/entity_token.module',
  'name' => 'entity_token',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:13:"Entity tokens";s:11:"description";s:99:"Provides token replacements for all properties that have no tokens and are known to the entity API.";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:23:"entity_token.tokens.inc";i:1;s:19:"entity_token.module";}s:12:"dependencies";a:1:{i:0;s:6:"entity";}s:7:"version";s:7:"7.x-1.9";s:7:"project";s:6:"entity";s:9:"datestamp";s:10:"1518620551";s:5:"mtime";i:1518620551;s:7:"package";s:5:"Other";s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entity/tests/entity_feature.module',
  'name' => 'entity_feature',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:21:"Entity feature module";s:11:"description";s:31:"Provides some entities in code.";s:7:"version";s:7:"7.x-1.9";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:21:"entity_feature.module";}s:12:"dependencies";a:1:{i:0;s:11:"entity_test";}s:6:"hidden";b:1;s:7:"project";s:6:"entity";s:9:"datestamp";s:10:"1518620551";s:5:"mtime";i:1518620551;s:7:"package";s:5:"Other";s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entity/tests/entity_test.module',
  'name' => 'entity_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:23:"Entity CRUD test module";s:11:"description";s:46:"Provides entity types based upon the CRUD API.";s:7:"version";s:7:"7.x-1.9";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:18:"entity_test.module";i:1;s:19:"entity_test.install";}s:12:"dependencies";a:1:{i:0;s:6:"entity";}s:6:"hidden";b:1;s:7:"project";s:6:"entity";s:9:"datestamp";s:10:"1518620551";s:5:"mtime";i:1518620551;s:7:"package";s:5:"Other";s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entity/tests/entity_test_i18n.module',
  'name' => 'entity_test_i18n',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:28:"Entity-test type translation";s:11:"description";s:37:"Allows translating entity-test types.";s:12:"dependencies";a:2:{i:0;s:11:"entity_test";i:1;s:11:"i18n_string";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"version";s:7:"7.x-1.9";s:7:"project";s:6:"entity";s:9:"datestamp";s:10:"1518620551";s:5:"mtime";i:1518620551;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entityreference/entityreference.module',
  'name' => 'entityreference',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7002',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:16:"Entity Reference";s:11:"description";s:51:"Provides a field that can reference other entities.";s:7:"package";s:6:"Fields";s:4:"core";s:3:"7.x";s:12:"dependencies";a:2:{i:0;s:6:"entity";i:1;s:6:"ctools";}s:17:"test_dependencies";a:2:{i:0;s:5:"feeds";i:1;s:5:"views";}s:5:"files";a:12:{i:0;s:27:"entityreference.migrate.inc";i:1;s:30:"plugins/selection/abstract.inc";i:2;s:27:"plugins/selection/views.inc";i:3;s:29:"plugins/behavior/abstract.inc";i:4;s:40:"views/entityreference_plugin_display.inc";i:5;s:38:"views/entityreference_plugin_style.inc";i:6;s:43:"views/entityreference_plugin_row_fields.inc";i:7;s:35:"tests/entityreference.handlers.test";i:8;s:35:"tests/entityreference.taxonomy.test";i:9;s:32:"tests/entityreference.admin.test";i:10;s:32:"tests/entityreference.feeds.test";i:11;s:45:"tests/entityreference.entity_translation.test";}s:7:"version";s:7:"7.x-1.5";s:7:"project";s:15:"entityreference";s:9:"datestamp";s:10:"1502895850";s:5:"mtime";i:1502895850;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entityreference/examples/entityreference_behavior_example/entityreference_behavior_example.module',
  'name' => 'entityreference_behavior_example',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:33:"Entity Reference Behavior Example";s:11:"description";s:71:"Provides some example code for implementing Entity Reference behaviors.";s:4:"core";s:3:"7.x";s:7:"package";s:6:"Fields";s:12:"dependencies";a:1:{i:0;s:15:"entityreference";}s:7:"version";s:7:"7.x-1.5";s:7:"project";s:15:"entityreference";s:9:"datestamp";s:10:"1502895850";s:5:"mtime";i:1502895850;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entityreference/tests/modules/entityreference_feeds_test/entityreference_feeds_test.module',
  'name' => 'entityreference_feeds_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:41:"Entityreference - Feeds integration tests";s:11:"description";s:65:"Support module for the Entityreference - Feeds integration tests.";s:7:"package";s:7:"Testing";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:3:{i:0;s:5:"feeds";i:1;s:8:"feeds_ui";i:2;s:15:"entityreference";}s:7:"version";s:7:"7.x-1.5";s:7:"project";s:15:"entityreference";s:9:"datestamp";s:10:"1502895850";s:5:"mtime";i:1502895850;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entity_translation/entity_translation.module',
  'name' => 'entity_translation',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '11',
  'info' => 'a:14:{s:4:"name";s:18:"Entity Translation";s:11:"description";s:58:"Allows entities to be translated into different languages.";s:7:"package";s:33:"Multilingual - Entity Translation";s:4:"core";s:3:"7.x";s:9:"configure";s:40:"admin/config/regional/entity_translation";s:12:"dependencies";a:1:{i:0;s:14:"locale (>7.14)";}s:17:"test_dependencies";a:2:{i:0;s:17:"pathauto:pathauto";i:1;s:29:"title:title (=7.x-1.0-alpha9)";}s:5:"files";a:15:{i:0;s:40:"includes/translation.handler_factory.inc";i:1;s:32:"includes/translation.handler.inc";i:2;s:40:"includes/translation.handler.comment.inc";i:3;s:37:"includes/translation.handler.node.inc";i:4;s:46:"includes/translation.handler.taxonomy_term.inc";i:5;s:37:"includes/translation.handler.user.inc";i:6;s:32:"includes/translation.migrate.inc";i:7;s:29:"tests/entity_translation.test";i:8;s:49:"views/entity_translation_handler_relationship.inc";i:9;s:57:"views/entity_translation_handler_field_translate_link.inc";i:10;s:48:"views/entity_translation_handler_field_label.inc";i:11;s:55:"views/entity_translation_handler_filter_entity_type.inc";i:12;s:52:"views/entity_translation_handler_filter_language.inc";i:13;s:62:"views/entity_translation_handler_filter_translation_exists.inc";i:14;s:48:"views/entity_translation_handler_field_field.inc";}s:7:"version";s:7:"7.x-1.1";s:7:"project";s:18:"entity_translation";s:9:"datestamp";s:10:"1574630892";s:5:"mtime";i:1574630892;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entity_translation/entity_translation_i18n_menu/entity_translation_i18n_menu.module',
  'name' => 'entity_translation_i18n_menu',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:23:"Entity Translation Menu";s:11:"description";s:54:"Allows menu items to be translated on the entity form.";s:7:"package";s:33:"Multilingual - Entity Translation";s:4:"core";s:3:"7.x";s:12:"dependencies";a:3:{i:0;s:18:"entity_translation";i:1;s:4:"i18n";i:2;s:9:"i18n_menu";}s:5:"files";a:1:{i:0;s:33:"entity_translation_i18n_menu.test";}s:7:"version";s:7:"7.x-1.1";s:7:"project";s:18:"entity_translation";s:9:"datestamp";s:10:"1574630892";s:5:"mtime";i:1574630892;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entity_translation/entity_translation_upgrade/entity_translation_upgrade.module',
  'name' => 'entity_translation_upgrade',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:26:"Entity Translation Upgrade";s:11:"description";s:80:"Provides an upgrade path from node-based translation to field-based translation.";s:7:"package";s:33:"Multilingual - Entity Translation";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:18:"entity_translation";}s:5:"files";a:1:{i:0;s:31:"entity_translation_upgrade.test";}s:7:"version";s:7:"7.x-1.1";s:7:"project";s:18:"entity_translation";s:9:"datestamp";s:10:"1574630892";s:5:"mtime";i:1574630892;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/entity_translation/tests/entity_translation_test.module',
  'name' => 'entity_translation_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:26:"Entity Translation testing";s:11:"description";s:61:"Tests Entity Translation module functionality. Do not enable.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:18:"entity_translation";}s:5:"files";a:1:{i:0;s:30:"entity_translation_test.module";}s:7:"version";s:7:"7.x-1.1";s:7:"project";s:18:"entity_translation";s:9:"datestamp";s:10:"1574630892";s:5:"mtime";i:1574630892;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n.module',
  'name' => 'i18n',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '10',
  'info' => 'a:13:{s:4:"name";s:20:"Internationalization";s:11:"description";s:49:"Extends Drupal support for multilingual features.";s:12:"dependencies";a:2:{i:0;s:6:"locale";i:1;s:8:"variable";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:15:"i18n_object.inc";i:1;s:9:"i18n.test";}s:9:"configure";s:26:"admin/config/regional/i18n";s:7:"version";s:8:"7.x-1.31";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1619398284";s:5:"mtime";i:1619398284;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_block/i18n_block.module',
  'name' => 'i18n_block',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '100',
  'info' => 'a:12:{s:4:"name";s:15:"Block languages";s:11:"description";s:68:"Enables language selector for blocks and optional block translation.";s:12:"dependencies";a:2:{i:0;s:5:"block";i:1;s:11:"i18n_string";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:14:"i18n_block.inc";i:1;s:15:"i18n_block.test";}s:7:"version";s:8:"7.x-1.31";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1619398284";s:5:"mtime";i:1619398284;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_contact/i18n_contact.module',
  'name' => 'i18n_contact',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:19:"Contact translation";s:11:"description";s:63:"Makes contact categories and replies available for translation.";s:12:"dependencies";a:2:{i:0;s:7:"contact";i:1;s:11:"i18n_string";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:7:"version";s:8:"7.x-1.31";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1619398284";s:5:"mtime";i:1619398284;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_field/i18n_field.module',
  'name' => 'i18n_field',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:17:"Field translation";s:11:"description";s:26:"Translate field properties";s:12:"dependencies";a:2:{i:0;s:5:"field";i:1;s:11:"i18n_string";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:14:"i18n_field.inc";i:1;s:15:"i18n_field.test";}s:7:"version";s:8:"7.x-1.31";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1619398284";s:5:"mtime";i:1619398284;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_forum/i18n_forum.module',
  'name' => 'i18n_forum',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:18:"Multilingual forum";s:11:"description";s:60:"Enables multilingual forum, translates names and containers.";s:12:"dependencies";a:3:{i:0;s:5:"forum";i:1;s:13:"i18n_taxonomy";i:2;s:9:"i18n_node";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:15:"i18n_forum.test";}s:7:"version";s:8:"7.x-1.31";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1619398284";s:5:"mtime";i:1619398284;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_menu/i18n_menu.module',
  'name' => 'i18n_menu',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '5',
  'info' => 'a:12:{s:4:"name";s:16:"Menu translation";s:11:"description";s:40:"Supports translatable custom menu items.";s:12:"dependencies";a:4:{i:0;s:4:"i18n";i:1;s:4:"menu";i:2;s:11:"i18n_string";i:3;s:16:"i18n_translation";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:13:"i18n_menu.inc";i:1;s:14:"i18n_menu.test";}s:7:"version";s:8:"7.x-1.31";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1619398284";s:5:"mtime";i:1619398284;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_node/i18n_node.module',
  'name' => 'i18n_node',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:20:"Multilingual content";s:11:"description";s:46:"Extended node options for multilingual content";s:12:"dependencies";a:3:{i:0;s:11:"translation";i:1;s:4:"i18n";i:2;s:11:"i18n_string";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:9:"configure";s:31:"admin/config/regional/i18n/node";s:5:"files";a:2:{i:0;s:14:"i18n_node.test";i:1;s:22:"i18n_node.variable.inc";}s:7:"version";s:8:"7.x-1.31";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1619398284";s:5:"mtime";i:1619398284;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_path/i18n_path.module',
  'name' => 'i18n_path',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:16:"Path translation";s:11:"description";s:37:"Define translations for generic paths";s:12:"dependencies";a:1:{i:0;s:16:"i18n_translation";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:13:"i18n_path.inc";i:1;s:14:"i18n_path.test";}s:7:"version";s:8:"7.x-1.31";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1619398284";s:5:"mtime";i:1619398284;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_redirect/i18n_redirect.module',
  'name' => 'i18n_redirect',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:20:"Translation redirect";s:11:"description";s:71:"Redirect to translated page when available. SEO for multilingual sites.";s:12:"dependencies";a:1:{i:0;s:4:"i18n";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:7:"version";s:8:"7.x-1.31";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1619398284";s:5:"mtime";i:1619398284;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_select/i18n_select.module',
  'name' => 'i18n_select',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:19:"Multilingual select";s:11:"description";s:45:"API module for multilingual content selection";s:12:"dependencies";a:1:{i:0;s:4:"i18n";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:9:"configure";s:33:"admin/config/regional/i18n/select";s:5:"files";a:1:{i:0;s:16:"i18n_select.test";}s:7:"version";s:8:"7.x-1.31";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1619398284";s:5:"mtime";i:1619398284;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_string/i18n_string.module',
  'name' => 'i18n_string',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:18:"String translation";s:11:"description";s:57:"Provides support for translation of user defined strings.";s:12:"dependencies";a:2:{i:0;s:6:"locale";i:1;s:4:"i18n";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:3:{i:0;s:21:"i18n_string.admin.inc";i:1;s:15:"i18n_string.inc";i:2;s:16:"i18n_string.test";}s:9:"configure";s:34:"admin/config/regional/i18n/strings";s:7:"version";s:8:"7.x-1.31";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1619398284";s:5:"mtime";i:1619398284;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_sync/i18n_sync.module',
  'name' => 'i18n_sync',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:24:"Synchronize translations";s:11:"description";s:73:"Synchronizes taxonomy and fields across translations of the same content.";s:12:"dependencies";a:2:{i:0;s:4:"i18n";i:1;s:11:"translation";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:5:{i:0;s:16:"i18n_sync.module";i:1;s:17:"i18n_sync.install";i:2;s:20:"i18n_sync.module.inc";i:3;s:18:"i18n_sync.node.inc";i:4;s:14:"i18n_sync.test";}s:7:"version";s:8:"7.x-1.31";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1619398284";s:5:"mtime";i:1619398284;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_taxonomy/i18n_taxonomy.module',
  'name' => 'i18n_taxonomy',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '5',
  'info' => 'a:12:{s:4:"name";s:20:"Taxonomy translation";s:11:"description";s:30:"Enables multilingual taxonomy.";s:12:"dependencies";a:3:{i:0;s:8:"taxonomy";i:1;s:11:"i18n_string";i:2;s:16:"i18n_translation";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:4:{i:0;s:17:"i18n_taxonomy.inc";i:1;s:23:"i18n_taxonomy.pages.inc";i:2;s:23:"i18n_taxonomy.admin.inc";i:3;s:18:"i18n_taxonomy.test";}s:7:"version";s:8:"7.x-1.31";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1619398284";s:5:"mtime";i:1619398284;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_translation/i18n_translation.module',
  'name' => 'i18n_translation',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:16:"Translation sets";s:11:"description";s:47:"Simple translation sets API for generic objects";s:12:"dependencies";a:1:{i:0;s:4:"i18n";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:20:"i18n_translation.inc";}s:7:"version";s:8:"7.x-1.31";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1619398284";s:5:"mtime";i:1619398284;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_user/i18n_user.module',
  'name' => 'i18n_user',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:21:"User mail translation";s:11:"description";s:43:"Translate emails sent from the User module.";s:4:"core";s:3:"7.x";s:7:"package";s:35:"Multilingual - Internationalization";s:12:"dependencies";a:1:{i:0;s:13:"i18n_variable";}s:7:"version";s:8:"7.x-1.31";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1619398284";s:5:"mtime";i:1619398284;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/i18n_variable/i18n_variable.module',
  'name' => 'i18n_variable',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '-900',
  'info' => 'a:13:{s:4:"name";s:20:"Variable translation";s:11:"description";s:71:"Multilingual variables that switch language depending on page language.";s:12:"dependencies";a:3:{i:0;s:4:"i18n";i:1;s:24:"variable_store (7.x-2.x)";i:2;s:24:"variable_realm (7.x-2.x)";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:9:"configure";s:35:"admin/config/regional/i18n/variable";s:5:"files";a:2:{i:0;s:23:"i18n_variable.class.inc";i:1;s:18:"i18n_variable.test";}s:7:"version";s:8:"7.x-1.31";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1619398284";s:5:"mtime";i:1619398284;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/i18n/tests/i18n_test.module',
  'name' => 'i18n_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:26:"Internationalization tests";s:11:"description";s:55:"Helper module for testing i18n (do not enable manually)";s:12:"dependencies";a:3:{i:0;s:6:"locale";i:1;s:11:"translation";i:2;s:4:"i18n";}s:7:"package";s:7:"Testing";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:7:"version";s:8:"7.x-1.31";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1619398284";s:5:"mtime";i:1619398284;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/link/link.module',
  'name' => 'link',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7001',
  'weight' => '0',
  'info' => 'a:16:{s:4:"name";s:4:"Link";s:11:"description";s:32:"Defines simple link field types.";s:4:"core";s:3:"7.x";s:7:"package";s:6:"Fields";s:9:"configure";s:25:"admin/config/content/link";s:5:"files";a:15:{i:0;s:16:"link.migrate.inc";i:1;s:44:"views/link_views_handler_argument_target.inc";i:2;s:44:"views/link_views_handler_filter_protocol.inc";i:3;s:28:"tests/LinkBaseTestClass.test";i:4;s:39:"tests/LinkConvertInternalPathsTest.test";i:5;s:34:"tests/LinkDefaultProtocolTest.test";i:6;s:30:"tests/LinkEntityTokenTest.test";i:7;s:34:"tests/LinkFieldAttributesTest.test";i:8;s:28:"tests/LinkFieldCrudTest.test";i:9;s:32:"tests/LinkFieldValidateTest.test";i:10;s:31:"tests/LinkPathPrefixesTest.test";i:11;s:27:"tests/LinkSanitizeTest.test";i:12;s:24:"tests/LinkTokenTest.test";i:13;s:32:"tests/LinkValidationApiTest.test";i:14;s:27:"tests/LinkUnitTestCase.test";}s:17:"test_dependencies";a:2:{i:0;s:13:"entity:entity";i:1;s:11:"token:token";}s:7:"version";s:7:"7.x-1.9";s:7:"project";s:4:"link";s:9:"datestamp";s:10:"1618831239";s:5:"mtime";i:1618831239;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:8:"required";b:1;s:11:"explanation";s:73:"Field type(s) in use - see <a href="/admin/reports/fields">Field list</a>";}',
))
->values(array(
  'filename' => 'sites/all/modules/multiupload_filefield_widget/multiupload_filefield_widget.module',
  'name' => 'multiupload_filefield_widget',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:28:"Multiupload Filefield Widget";s:11:"description";s:76:"Creates a widget for filefield to upload multiple files at once using html5.";s:7:"package";s:6:"Fields";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:4:"file";}s:5:"files";a:2:{i:0;s:35:"multiupload_filefield_widget.module";i:1;s:33:"multiupload_filefield_widget.test";}s:7:"version";s:8:"7.x-1.13";s:7:"project";s:28:"multiupload_filefield_widget";s:9:"datestamp";s:10:"1388873905";s:5:"mtime";i:1388873905;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/multiupload_imagefield_widget/multiupload_imagefield_widget.module',
  'name' => 'multiupload_imagefield_widget',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:29:"Multiupload Imagefield Widget";s:11:"description";s:77:"Creates a widget for imagefield to upload multiple files at once using html5.";s:7:"package";s:6:"Fields";s:12:"dependencies";a:2:{i:0;s:28:"multiupload_filefield_widget";i:1;s:5:"image";}s:4:"core";s:3:"7.x";s:7:"version";s:7:"7.x-1.3";s:7:"project";s:29:"multiupload_imagefield_widget";s:9:"datestamp";s:10:"1388874206";s:5:"mtime";i:1388874206;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/phone/phone.module',
  'name' => 'phone',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:5:"Phone";s:11:"description";s:80:"The phone module allows administrators to define a field type for phone numbers.";s:7:"package";s:6:"Fields";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:30:{i:0;s:17:"phone.migrate.inc";i:1;s:19:"tests/phone.au.test";i:2;s:19:"tests/phone.be.test";i:3;s:19:"tests/phone.br.test";i:4;s:19:"tests/phone.ca.test";i:5;s:19:"tests/phone.ch.test";i:6;s:19:"tests/phone.cl.test";i:7;s:19:"tests/phone.cn.test";i:8;s:19:"tests/phone.cr.test";i:9;s:19:"tests/phone.cs.test";i:10;s:19:"tests/phone.eg.test";i:11;s:19:"tests/phone.es.test";i:12;s:19:"tests/phone.fr.test";i:13;s:19:"tests/phone.hu.test";i:14;s:19:"tests/phone.il.test";i:15;s:20:"tests/phone.int.test";i:16;s:19:"tests/phone.it.test";i:17;s:19:"tests/phone.jo.test";i:18;s:19:"tests/phone.nl.test";i:19;s:19:"tests/phone.nz.test";i:20;s:19:"tests/phone.pa.test";i:21;s:19:"tests/phone.ph.test";i:22;s:19:"tests/phone.pk.test";i:23;s:19:"tests/phone.pl.test";i:24;s:19:"tests/phone.ru.test";i:25;s:19:"tests/phone.se.test";i:26;s:19:"tests/phone.sg.test";i:27;s:19:"tests/phone.ua.test";i:28;s:19:"tests/phone.uk.test";i:29;s:19:"tests/phone.za.test";}s:4:"core";s:3:"7.x";s:7:"version";s:13:"7.x-1.0-beta1";s:7:"project";s:5:"phone";s:9:"datestamp";s:10:"1389732224";s:5:"mtime";i:1389732224;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/references/node_reference/node_reference.module',
  'name' => 'node_reference',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:14:"Node Reference";s:11:"description";s:59:"Defines a field type for referencing one node from another.";s:7:"package";s:6:"Fields";s:4:"core";s:3:"7.x";s:12:"dependencies";a:3:{i:0;s:5:"field";i:1;s:10:"references";i:2;s:7:"options";}s:5:"files";a:1:{i:0;s:19:"node_reference.test";}s:7:"version";s:7:"7.x-2.2";s:7:"project";s:10:"references";s:9:"datestamp";s:10:"1492534745";s:5:"mtime";i:1492534745;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/references/references.module',
  'name' => 'references',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:10:"References";s:11:"description";s:67:"Defines common base features for the various reference field types.";s:7:"package";s:6:"Fields";s:4:"core";s:3:"7.x";s:12:"dependencies";a:2:{i:0;s:5:"field";i:1;s:7:"options";}s:5:"files";a:5:{i:0;s:41:"views/references_handler_relationship.inc";i:1;s:37:"views/references_handler_argument.inc";i:2;s:35:"views/references_plugin_display.inc";i:3;s:33:"views/references_plugin_style.inc";i:4;s:38:"views/references_plugin_row_fields.inc";}s:7:"version";s:7:"7.x-2.2";s:7:"project";s:10:"references";s:9:"datestamp";s:10:"1492534745";s:5:"mtime";i:1492534745;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/references/references_uuid/references_uuid.module',
  'name' => 'references_uuid',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:15:"References UUID";s:4:"core";s:3:"7.x";s:7:"package";s:6:"Fields";s:12:"dependencies";a:2:{i:0;s:10:"references";i:1;s:4:"uuid";}s:7:"version";s:7:"7.x-2.2";s:7:"project";s:10:"references";s:9:"datestamp";s:10:"1492534745";s:5:"mtime";i:1492534745;s:11:"description";s:0:"";s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/references/user_reference/user_reference.module',
  'name' => 'user_reference',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:14:"User Reference";s:11:"description";s:56:"Defines a field type for referencing a user from a node.";s:7:"package";s:6:"Fields";s:4:"core";s:3:"7.x";s:12:"dependencies";a:3:{i:0;s:5:"field";i:1;s:10:"references";i:2;s:7:"options";}s:7:"version";s:7:"7.x-2.2";s:7:"project";s:10:"references";s:9:"datestamp";s:10:"1492534745";s:5:"mtime";i:1492534745;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/telephone/telephone.module',
  'name' => 'telephone',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:9:"Telephone";s:11:"description";s:43:"Defines a field type for telephone numbers.";s:7:"package";s:6:"Fields";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:21:"telephone.migrate.inc";}s:7:"version";s:14:"7.x-1.0-alpha1";s:7:"project";s:9:"telephone";s:9:"datestamp";s:10:"1389736105";s:5:"mtime";i:1389736105;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/title/tests/title_test.module',
  'name' => 'title_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Title Test";s:11:"description";s:61:"Testing module for Title module functionality. Do not enable.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:6:"hidden";b:1;s:12:"dependencies";a:4:{i:0;s:5:"title";i:1;s:8:"taxonomy";i:2;s:6:"entity";i:3;s:18:"entity_translation";}s:7:"version";s:13:"7.x-1.0-beta4";s:7:"project";s:5:"title";s:9:"datestamp";s:10:"1614446628";s:5:"mtime";i:1614446628;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/title/title.module',
  'name' => 'title',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '100',
  'info' => 'a:14:{s:4:"name";s:5:"Title";s:11:"description";s:50:"Replaces entity legacy fields with regular fields.";s:4:"core";s:3:"7.x";s:7:"package";s:6:"Fields";s:9:"configure";s:26:"admin/config/content/title";s:12:"dependencies";a:1:{i:0;s:14:"system (>7.14)";}s:5:"files";a:4:{i:0;s:35:"views/views_handler_title_field.inc";i:1;s:37:"tests/TitleAdminSettingsTestCase.test";i:2;s:40:"tests/TitleFieldReplacementTestCase.test";i:3;s:35:"tests/TitleTranslationTestCase.test";}s:17:"test_dependencies";a:2:{i:0;s:6:"entity";i:1;s:18:"entity_translation";}s:7:"version";s:13:"7.x-1.0-beta4";s:7:"project";s:5:"title";s:9:"datestamp";s:10:"1614446628";s:5:"mtime";i:1614446628;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/variable/variable.module',
  'name' => 'variable',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:8:"Variable";s:11:"description";s:43:"Variable Information and basic variable API";s:7:"package";s:8:"Variable";s:4:"core";s:3:"7.x";s:5:"files";a:9:{i:0;s:27:"includes/forum.variable.inc";i:1;s:28:"includes/locale.variable.inc";i:2;s:26:"includes/menu.variable.inc";i:3;s:26:"includes/node.variable.inc";i:4;s:28:"includes/system.variable.inc";i:5;s:30:"includes/taxonomy.variable.inc";i:6;s:33:"includes/translation.variable.inc";i:7;s:26:"includes/user.variable.inc";i:8;s:13:"variable.test";}s:7:"version";s:7:"7.x-2.5";s:7:"project";s:8:"variable";s:9:"datestamp";s:10:"1398250128";s:5:"mtime";i:1398250128;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/variable/variable_admin/variable_admin.module',
  'name' => 'variable_admin',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:14:"Variable admin";s:11:"description";s:26:"Variable Administration UI";s:12:"dependencies";a:1:{i:0;s:8:"variable";}s:7:"package";s:8:"Variable";s:4:"core";s:3:"7.x";s:7:"version";s:7:"7.x-2.5";s:7:"project";s:8:"variable";s:9:"datestamp";s:10:"1398250128";s:5:"mtime";i:1398250128;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/variable/variable_example/variable_example.module',
  'name' => 'variable_example',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:16:"Variable example";s:11:"description";s:83:"An example module showing how to use the Variable API and providing some variables.";s:12:"dependencies";a:2:{i:0;s:8:"variable";i:1;s:14:"variable_store";}s:7:"package";s:15:"Example modules";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:29:"variable_example.variable.inc";}s:7:"version";s:7:"7.x-2.5";s:7:"project";s:8:"variable";s:9:"datestamp";s:10:"1398250128";s:5:"mtime";i:1398250128;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/variable/variable_realm/variable_realm.module',
  'name' => 'variable_realm',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '-1000',
  'info' => 'a:12:{s:4:"name";s:14:"Variable realm";s:11:"description";s:49:"API to use variable realms from different modules";s:12:"dependencies";a:1:{i:0;s:8:"variable";}s:7:"package";s:8:"Variable";s:4:"core";s:3:"7.x";s:7:"version";s:7:"7.x-2.5";s:5:"files";a:2:{i:0;s:24:"variable_realm.class.inc";i:1;s:30:"variable_realm_union.class.inc";}s:7:"project";s:8:"variable";s:9:"datestamp";s:10:"1398250128";s:5:"mtime";i:1398250128;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/variable/variable_store/variable_store.module',
  'name' => 'variable_store',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '-1000',
  'info' => 'a:12:{s:4:"name";s:14:"Variable store";s:11:"description";s:60:"Database storage for variable realms. This is an API module.";s:12:"dependencies";a:1:{i:0;s:8:"variable";}s:7:"package";s:8:"Variable";s:4:"core";s:3:"7.x";s:7:"version";s:7:"7.x-2.5";s:5:"files";a:2:{i:0;s:24:"variable_store.class.inc";i:1;s:19:"variable_store.test";}s:7:"project";s:8:"variable";s:9:"datestamp";s:10:"1398250128";s:5:"mtime";i:1398250128;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'sites/all/modules/variable/variable_views/variable_views.module',
  'name' => 'variable_views',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:14:"Variable views";s:11:"description";s:78:"Provides views integration for variable, included a default variable argument.";s:12:"dependencies";a:2:{i:0;s:8:"variable";i:1;s:5:"views";}s:7:"package";s:8:"Variable";s:4:"core";s:3:"7.x";s:5:"files";a:3:{i:0;s:51:"includes/views_plugin_argument_default_variable.inc";i:1;s:47:"includes/views_handler_field_variable_title.inc";i:2;s:47:"includes/views_handler_field_variable_value.inc";}s:7:"version";s:7:"7.x-2.5";s:7:"project";s:8:"variable";s:9:"datestamp";s:10:"1398250128";s:5:"mtime";i:1398250128;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'themes/bartik/bartik.info',
  'name' => 'bartik',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:18:{s:4:"name";s:6:"Bartik";s:11:"description";s:48:"A flexible, recolorable theme with many regions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:7:"regions";a:17:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:7:"content";s:7:"Content";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:14:"triptych_first";s:14:"Triptych first";s:15:"triptych_middle";s:15:"Triptych middle";s:13:"triptych_last";s:13:"Triptych last";s:18:"footer_firstcolumn";s:19:"Footer first column";s:19:"footer_secondcolumn";s:20:"Footer second column";s:18:"footer_thirdcolumn";s:19:"Footer third column";s:19:"footer_fourthcolumn";s:20:"Footer fourth column";s:6:"footer";s:6:"Footer";}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"0";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:28:"themes/bartik/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1626883669;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}',
))
->values(array(
  'filename' => 'themes/garland/garland.info',
  'name' => 'garland',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:18:{s:4:"name";s:7:"Garland";s:11:"description";s:111:"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:8:"settings";a:1:{s:13:"garland_width";s:5:"fluid";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:6:"engine";s:11:"phptemplate";s:7:"regions";a:9:{s:13:"sidebar_first";s:12:"Left sidebar";s:14:"sidebar_second";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";s:11:"highlighted";s:11:"Highlighted";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";}s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1626883669;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}',
))
->values(array(
  'filename' => 'themes/seven/seven.info',
  'name' => 'seven',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:18:{s:4:"name";s:5:"Seven";s:11:"description";s:65:"A simple one-column, tableless, fluid width administration theme.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.82";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"1";}s:7:"regions";a:5:{s:7:"content";s:7:"Content";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:13:"sidebar_first";s:13:"First sidebar";}s:14:"regions_hidden";a:3:{i:0;s:13:"sidebar_first";i:1;s:8:"page_top";i:2;s:11:"page_bottom";}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1626883669";s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:27:"themes/seven/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1626883669;s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}',
))
->values(array(
  'filename' => 'themes/stark/stark.info',
  'name' => 'stark',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => "a:17:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal's default HTML markup and CSS styles. To learn how to build your own theme and override Drupal's default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.82\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1626883669\";s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:9:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1626883669;s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}",
))
->execute();
$connection->schema()->createTable('taxonomy_index', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'tid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'sticky' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('taxonomy_term_data', array(
  'fields' => array(
    'tid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'tid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('taxonomy_term_hierarchy', array(
  'fields' => array(
    'tid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'parent' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'tid',
    'parent',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('taxonomy_vocabulary', array(
  'fields' => array(
    'vid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'machine_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'hierarchy' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('tracker_node', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'published' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'default' => '0',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('tracker_node')
->fields(array(
  'nid',
  'published',
  'changed',
))
->values(array(
  'nid' => '1',
  'published' => '1',
  'changed' => '1421727536',
))
->execute();
$connection->schema()->createTable('tracker_user', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'published' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'default' => '0',
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'nid',
    'uid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('tracker_user')
->fields(array(
  'nid',
  'uid',
  'published',
  'changed',
))
->values(array(
  'nid' => '1',
  'uid' => '2',
  'published' => '1',
  'changed' => '1421727536',
))
->execute();
$connection->schema()->createTable('url_alias', array(
  'fields' => array(
    'pid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'source' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'alias' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'pid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('users', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '60',
      'default' => '',
    ),
    'pass' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'mail' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '254',
      'default' => '',
    ),
    'theme' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'signature' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'signature_format' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'access' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'login' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'timezone' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '32',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
    'picture' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'init' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '254',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'uid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('users')
->fields(array(
  'uid',
  'name',
  'pass',
  'mail',
  'theme',
  'signature',
  'signature_format',
  'created',
  'access',
  'login',
  'status',
  'timezone',
  'language',
  'picture',
  'init',
  'data',
))
->values(array(
  'uid' => '1',
  'name' => 'admin',
  'pass' => '$S$D/HVkgCg1Hvi7DN5KVSgNl.2C5g8W6oe/OoIRMUlyjkmPugQRhoB',
  'mail' => 'admin@local.host',
  'theme' => '',
  'signature' => '',
  'signature_format' => NULL,
  'created' => '0',
  'access' => '1647480381',
  'login' => '1647478081',
  'status' => '1',
  'timezone' => NULL,
  'language' => '',
  'picture' => '0',
  'init' => '',
  'data' => 'a:1:{s:7:"contact";i:1;}',
))
->values(array(
  'uid' => '2',
  'name' => 'Odo',
  'pass' => '$S$DGFZUE.FhrXbe4y52eC7p0ZVRGD/gOPtVctDlmC89qkujnBokAlJ',
  'mail' => 'odo@local.host',
  'theme' => '',
  'signature' => '',
  'signature_format' => 'filtered_html',
  'created' => '1440532218',
  'access' => '0',
  'login' => '0',
  'status' => '1',
  'timezone' => 'America/Chicago',
  'language' => 'is',
  'picture' => '0',
  'init' => 'odo@local.host',
  'data' => 'a:1:{s:7:"contact";i:1;}',
))
->execute();
$connection->schema()->createTable('users_roles', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'rid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'uid',
    'rid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('users_roles')
->fields(array(
  'uid',
  'rid',
))
->values(array(
  'uid' => '1',
  'rid' => '3',
))
->values(array(
  'uid' => '2',
  'rid' => '3',
))
->execute();
$connection->schema()->createTable('variable', array(
  'fields' => array(
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'value' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('variable')
->fields(array(
  'name',
  'value',
))
->values(array(
  'name' => 'actions_max_stack',
  'value' => 'i:28;',
))
->values(array(
  'name' => 'additional_settings__active_tab_article',
  'value' => 's:15:"edit-submission";',
))
->values(array(
  'name' => 'additional_settings__active_tab_blog',
  'value' => 's:13:"edit-workflow";',
))
->values(array(
  'name' => 'additional_settings__active_tab_book',
  'value' => 's:13:"edit-workflow";',
))
->values(array(
  'name' => 'additional_settings__active_tab_forum',
  'value' => 's:15:"edit-submission";',
))
->values(array(
  'name' => 'additional_settings__active_tab_page',
  'value' => 's:15:"edit-submission";',
))
->values(array(
  'name' => 'additional_settings__active_tab_test_content_type',
  'value' => 's:13:"edit-workflow";',
))
->values(array(
  'name' => 'admin_compact_mode',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'admin_theme',
  'value' => 's:5:"seven";',
))
->values(array(
  'name' => 'allow_insecure_derivatives',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'allow_insecure_uploads',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'anonymous',
  'value' => 's:9:"Anonymous";',
))
->values(array(
  'name' => 'authorize_filetransfer_default',
  'value' => 's:3:"ftp";',
))
->values(array(
  'name' => 'block_cache',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'cache',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'cache_flush_cache',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'cache_flush_cache_block',
  'value' => 'i:1647480388;',
))
->values(array(
  'name' => 'cache_flush_cache_field',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'cache_flush_cache_filter',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'cache_flush_cache_form',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'cache_flush_cache_image',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'cache_flush_cache_menu',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'cache_flush_cache_page',
  'value' => 'i:1647480388;',
))
->values(array(
  'name' => 'cache_flush_cache_path',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'cache_flush_cache_variable',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'cache_lifetime',
  'value' => 's:3:"300";',
))
->values(array(
  'name' => 'clean_url',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'color_bartik_files',
  'value' => 'a:2:{i:0;s:39:"public://color/bartik-e0e23ad7/logo.png";i:1;s:41:"public://color/bartik-e0e23ad7/colors.css";}',
))
->values(array(
  'name' => 'color_bartik_logo',
  'value' => 's:39:"public://color/bartik-e0e23ad7/logo.png";',
))
->values(array(
  'name' => 'color_bartik_palette',
  'value' => 'a:9:{s:3:"top";s:7:"#d0d0d0";s:6:"bottom";s:7:"#c2c4c5";s:2:"bg";s:7:"#ffffff";s:7:"sidebar";s:7:"#ffffff";s:14:"sidebarborders";s:7:"#cccccc";s:6:"footer";s:7:"#24272c";s:11:"titleslogan";s:7:"#000000";s:4:"text";s:7:"#4a4a4a";s:4:"link";s:7:"#019dbf";}',
))
->values(array(
  'name' => 'color_bartik_screenshot',
  'value' => 's:72:"/var/www/drupal/sites/default/files/color/bartik-b69cfcec/screenshot.png";',
))
->values(array(
  'name' => 'color_bartik_stylesheets',
  'value' => 'a:1:{i:0;s:41:"public://color/bartik-e0e23ad7/colors.css";}',
))
->values(array(
  'name' => 'color_garland_files',
  'value' => 'a:19:{i:0;s:50:"public://color/garland-b69cfcec/menu-collapsed.gif";i:1;s:54:"public://color/garland-b69cfcec/menu-collapsed-rtl.gif";i:2;s:49:"public://color/garland-b69cfcec/menu-expanded.gif";i:3;s:45:"public://color/garland-b69cfcec/menu-leaf.gif";i:4;s:67:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/body.png";i:5;s:69:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-bar.png";i:6;s:75:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-bar-white.png";i:7;s:69:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-tab.png";i:8;s:76:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-navigation.png";i:9;s:78:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-content-left.png";i:10;s:79:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-content-right.png";i:11;s:73:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-content.png";i:12;s:81:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-navigation-item.png";i:13;s:87:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-navigation-item-hover.png";i:14;s:77:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/gradient-inner.png";i:15;s:67:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/logo.png";i:16;s:73:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/screenshot.png";i:17;s:41:"public://color/garland-b69cfcec/style.css";i:18;s:45:"public://color/garland-b69cfcec/style-rtl.css";}',
))
->values(array(
  'name' => 'color_garland_logo',
  'value' => 's:40:"public://color/garland-b69cfcec/logo.png";',
))
->values(array(
  'name' => 'color_garland_palette',
  'value' => 'a:5:{s:4:"base";s:7:"#d0cb9a";s:4:"link";s:7:"#917803";s:3:"top";s:7:"#efde01";s:6:"bottom";s:7:"#e6fb2d";s:4:"text";s:7:"#494949";}',
))
->values(array(
  'name' => 'color_garland_screenshot',
  'value' => 's:73:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/screenshot.png";',
))
->values(array(
  'name' => 'color_garland_stylesheets',
  'value' => 'a:2:{i:0;s:41:"public://color/garland-b69cfcec/style.css";i:1;s:45:"public://color/garland-b69cfcec/style-rtl.css";}',
))
->values(array(
  'name' => 'comment_anonymous_article',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_blog',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_forum',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_page',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_test_content_type',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_article',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'comment_blog',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'comment_default_mode_article',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_default_mode_blog',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_default_mode_forum',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_default_mode_page',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_default_mode_test_content_type',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_default_per_page_article',
  'value' => 's:2:"50";',
))
->values(array(
  'name' => 'comment_default_per_page_blog',
  'value' => 's:2:"50";',
))
->values(array(
  'name' => 'comment_default_per_page_forum',
  'value' => 's:2:"50";',
))
->values(array(
  'name' => 'comment_default_per_page_page',
  'value' => 's:2:"50";',
))
->values(array(
  'name' => 'comment_default_per_page_test_content_type',
  'value' => 's:2:"30";',
))
->values(array(
  'name' => 'comment_form_location_article',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_form_location_blog',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_form_location_forum',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_form_location_page',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_form_location_test_content_type',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_forum',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'comment_page',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'comment_preview_article',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_preview_blog',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_preview_forum',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_preview_page',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_preview_test_content_type',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_subject_field_article',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_subject_field_blog',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_subject_field_forum',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_subject_field_page',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_subject_field_test_content_type',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_test_content_type',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'configurable_timezones',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'contact_default_status',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'contact_threshold_limit',
  'value' => 'i:33;',
))
->values(array(
  'name' => 'contact_threshold_window',
  'value' => 'i:7200;',
))
->values(array(
  'name' => 'cron_key',
  'value' => 's:43:"_vWFj-dRR2rNoHDwl7N__J9uZNutDcLz3w4tlPJzRAM";',
))
->values(array(
  'name' => 'cron_last',
  'value' => 'i:1647478053;',
))
->values(array(
  'name' => 'cron_threshold_error',
  'value' => 'i:1209600;',
))
->values(array(
  'name' => 'cron_threshold_warning',
  'value' => 'i:172800;',
))
->values(array(
  'name' => 'css_js_query_string',
  'value' => 's:6:"r8v829";',
))
->values(array(
  'name' => 'ctools_last_cron',
  'value' => 'i:1647478054;',
))
->values(array(
  'name' => 'dashboard_stashed_blocks',
  'value' => 'a:5:{i:0;a:3:{s:6:"module";s:4:"node";s:5:"delta";s:6:"recent";s:6:"region";s:14:"dashboard_main";}i:1;a:3:{s:6:"module";s:4:"user";s:5:"delta";s:3:"new";s:6:"region";s:17:"dashboard_sidebar";}i:2;a:3:{s:6:"module";s:6:"search";s:5:"delta";s:4:"form";s:6:"region";s:17:"dashboard_sidebar";}i:3;a:3:{s:6:"module";s:7:"comment";s:5:"delta";s:6:"recent";s:6:"region";s:18:"dashboard_inactive";}i:4;a:3:{s:6:"module";s:4:"user";s:5:"delta";s:6:"online";s:6:"region";s:18:"dashboard_inactive";}}',
))
->values(array(
  'name' => 'date_api_version',
  'value' => 's:3:"7.2";',
))
->values(array(
  'name' => 'date_default_timezone',
  'value' => 's:15:"America/Chicago";',
))
->values(array(
  'name' => 'date_first_day',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'default_nodes_main',
  'value' => 's:2:"10";',
))
->values(array(
  'name' => 'drupal_css_cache_files',
  'value' => 'a:6:{s:64:"823ba1006db72809515d2221cd02ec1075d7b49b0c07f49307b3a7930bfdd9e4";s:64:"public://css/css_xE-rWrJf-fncB6ztZfd2huxqgxu4WO-qwma6Xer30m4.css";s:64:"592db66916e1dd3416cbe95bcb34a5a68775eb0b7cf95e4c858671de35290cc9";s:64:"public://css/css_LS9OUalDR9-d_lCAvF3yUWjNU6yF8ZBm84jEPRvoyuQ.css";s:64:"8d430bccf24c5d546e444dcd23fc6c61a49de1ed9c1e404d82c78c0f9ac0f1bc";s:64:"public://css/css_Vn_p7xhZmS8yWWx26P0Cc7Tm0GG2K1gLWEoVrhw5xxg.css";s:64:"08e73ee5bdc709cedbe8f3d38be9de6e3b4909f6159bd6bd206af8afa7c5deb2";s:64:"public://css/css_SvIzNpQoZgd_Pyw46TTtFEInuTqfS4K0wd8wnN2cJKk.css";s:64:"f3f74dcad951a1a986b64eeabc10d3141b1f70cd67b02447398b004b5706789c";s:64:"public://css/css_Hex-pwCTDDfQD41aRswi2OFNCxosYgUEBnZsKNQ5BWo.css";s:64:"ebb3f433ad4107b1ac31e9d7de0f9a5d399040e9f82b6364211dcfaadea158c0";s:64:"public://css/css_Nv0ct-zkzztuah_LbaPFF8ZkdSEk-LxBtTWMm9mN_F8.css";}',
))
->values(array(
  'name' => 'drupal_http_request_fails',
  'value' => 'b:0;',
))
->values(array(
  'name' => 'drupal_private_key',
  'value' => 's:43:"Wo8622hsBXUj6lDfm4SXQId2ZELMpl2KVS7DcdX0tPY";',
))
->values(array(
  'name' => 'drupal_weight_select_max',
  'value' => 'i:40;',
))
->values(array(
  'name' => 'email__active_tab',
  'value' => 's:27:"edit-email-pending-approval";',
))
->values(array(
  'name' => 'empty_timezone_message',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'entityreference:base-tables',
  'value' => 'a:6:{s:7:"comment";a:2:{i:0;s:7:"comment";i:1;s:3:"cid";}s:4:"node";a:2:{i:0;s:4:"node";i:1;s:3:"nid";}s:4:"file";a:2:{i:0;s:12:"file_managed";i:1;s:3:"fid";}s:13:"taxonomy_term";a:2:{i:0;s:18:"taxonomy_term_data";i:1;s:3:"tid";}s:19:"taxonomy_vocabulary";a:2:{i:0;s:19:"taxonomy_vocabulary";i:1;s:3:"vid";}s:4:"user";a:2:{i:0;s:5:"users";i:1;s:3:"uid";}}',
))
->values(array(
  'name' => 'entity_cache_tables_created',
  'value' => 'N;',
))
->values(array(
  'name' => 'error_level',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'feed_default_items',
  'value' => 'i:27;',
))
->values(array(
  'name' => 'feed_item_length',
  'value' => 's:8:"fulltext";',
))
->values(array(
  'name' => 'field_bundle_settings_comment__comment_node_test_content_type',
  'value' => 'a:2:{s:10:"view_modes";a:0:{}s:12:"extra_fields";a:2:{s:4:"form";a:2:{s:6:"author";a:1:{s:6:"weight";s:2:"-2";}s:7:"subject";a:1:{s:6:"weight";s:2:"-1";}}s:7:"display";a:0:{}}}',
))
->values(array(
  'name' => 'field_bundle_settings_node__article',
  'value' => 'a:2:{s:10:"view_modes";a:0:{}s:12:"extra_fields";a:2:{s:4:"form";a:1:{s:5:"title";a:1:{s:6:"weight";s:2:"-5";}}s:7:"display";a:0:{}}}',
))
->values(array(
  'name' => 'field_bundle_settings_node__blog',
  'value' => 'a:2:{s:10:"view_modes";a:0:{}s:12:"extra_fields";a:2:{s:4:"form";a:1:{s:5:"title";a:1:{s:6:"weight";s:2:"-5";}}s:7:"display";a:0:{}}}',
))
->values(array(
  'name' => 'field_bundle_settings_node__test_content_type',
  'value' => 'a:2:{s:10:"view_modes";a:6:{s:6:"teaser";a:1:{s:15:"custom_settings";b:1;}s:4:"full";a:1:{s:15:"custom_settings";b:0;}s:3:"rss";a:1:{s:15:"custom_settings";b:0;}s:12:"search_index";a:1:{s:15:"custom_settings";b:0;}s:13:"search_result";a:1:{s:15:"custom_settings";b:0;}s:5:"print";a:1:{s:15:"custom_settings";b:0;}}s:12:"extra_fields";a:2:{s:4:"form";a:1:{s:5:"title";a:1:{s:6:"weight";s:1:"0";}}s:7:"display";a:0:{}}}',
))
->values(array(
  'name' => 'field_bundle_settings_user__user',
  'value' => 'a:2:{s:10:"view_modes";a:0:{}s:12:"extra_fields";a:2:{s:4:"form";a:2:{s:7:"account";a:1:{s:6:"weight";s:3:"-10";}s:8:"timezone";a:1:{s:6:"weight";s:1:"6";}}s:7:"display";a:0:{}}}',
))
->values(array(
  'name' => 'file_default_scheme',
  'value' => 's:6:"public";',
))
->values(array(
  'name' => 'file_description_length',
  'value' => 'i:256;',
))
->values(array(
  'name' => 'file_description_type',
  'value' => 's:9:"textfield";',
))
->values(array(
  'name' => 'file_directory_path',
  'value' => 's:19:"sites/default/files";',
))
->values(array(
  'name' => 'file_icon_directory',
  'value' => 's:25:"sites/default/files/icons";',
))
->values(array(
  'name' => 'file_private_path',
  'value' => 's:21:"sites/default/private";',
))
->values(array(
  'name' => 'file_public_path',
  'value' => 's:19:"sites/default/files";',
))
->values(array(
  'name' => 'file_temporary_path',
  'value' => 's:4:"/tmp";',
))
->values(array(
  'name' => 'filter_fallback_format',
  'value' => 's:10:"plain_text";',
))
->values(array(
  'name' => 'forum_nav_vocabulary',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'i18n_node_options_blog',
  'value' => 'a:2:{i:0;s:8:"required";i:1;s:4:"lock";}',
))
->values(array(
  'name' => 'i18n_string_allowed_formats',
  'value' => 'a:5:{s:13:"filtered_html";s:13:"filtered_html";s:10:"plain_text";s:10:"plain_text";s:18:"custom_text_format";i:0;s:9:"full_html";i:0;s:8:"php_code";i:0;}',
))
->values(array(
  'name' => 'i18n_string_source_language',
  'value' => 's:2:"en";',
))
->values(array(
  'name' => 'i18n_string_textgroup_class_blocks',
  'value' => 's:29:"i18n_string_textgroup_default";',
))
->values(array(
  'name' => 'i18n_string_textgroup_class_taxonomy',
  'value' => 's:29:"i18n_string_textgroup_default";',
))
->values(array(
  'name' => 'i18n_sync_node_type_article',
  'value' => 'a:1:{i:0;s:16:"field_text_plain";}',
))
->values(array(
  'name' => 'i18n_sync_source_article',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'image_jpeg_quality',
  'value' => 'i:80;',
))
->values(array(
  'name' => 'image_style_preview_image',
  'value' => 's:33:"core/modules/image/testsample.png";',
))
->values(array(
  'name' => 'image_toolkit',
  'value' => 's:2:"gd";',
))
->values(array(
  'name' => 'install_profile',
  'value' => 's:8:"standard";',
))
->values(array(
  'name' => 'install_task',
  'value' => 's:4:"done";',
))
->values(array(
  'name' => 'install_time',
  'value' => 'i:1421694923;',
))
->values(array(
  'name' => 'language_content_type_a_thirty_two_character_type_name',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'language_content_type_blog',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'language_content_type_et',
  'value' => 's:1:"4";',
))
->values(array(
  'name' => 'language_content_type_forum',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'mail_system',
  'value' => 'a:1:{s:14:"default-system";s:17:"DefaultMailSystem";}',
))
->values(array(
  'name' => 'maintenance_mode',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'maintenance_mode_message',
  'value' => 's:42:"This is a custom maintenance mode message.";',
))
->values(array(
  'name' => 'menu_default_active_menus',
  'value' => 'a:5:{i:0;s:14:"menu-fixedlang";i:1;s:9:"main-menu";i:2;s:10:"management";i:3;s:10:"navigation";i:5;s:9:"user-menu";}',
))
->values(array(
  'name' => 'menu_expanded',
  'value' => 'a:0:{}',
))
->values(array(
  'name' => 'menu_masks',
  'value' => 'a:31:{i:0;i:501;i:1;i:493;i:2;i:250;i:3;i:247;i:4;i:246;i:5;i:245;i:6;i:125;i:7;i:123;i:8;i:122;i:9;i:121;i:10;i:63;i:11;i:62;i:12;i:61;i:13;i:60;i:14;i:56;i:15;i:44;i:16;i:31;i:17;i:30;i:18;i:29;i:19;i:24;i:20;i:21;i:21;i:15;i:22;i:14;i:23;i:13;i:24;i:11;i:25;i:7;i:26;i:6;i:27;i:5;i:28;i:3;i:29;i:2;i:30;i:1;}',
))
->values(array(
  'name' => 'menu_options_article',
  'value' => 'a:1:{i:0;s:9:"main-menu";}',
))
->values(array(
  'name' => 'menu_options_blog',
  'value' => 'a:1:{i:0;s:9:"main-menu";}',
))
->values(array(
  'name' => 'menu_options_book',
  'value' => 'a:1:{i:0;s:9:"main-menu";}',
))
->values(array(
  'name' => 'menu_options_forum',
  'value' => 'a:1:{i:0;s:9:"main-menu";}',
))
->values(array(
  'name' => 'menu_options_page',
  'value' => 'a:1:{i:0;s:9:"main-menu";}',
))
->values(array(
  'name' => 'menu_options_test_content_type',
  'value' => 'a:4:{i:0;s:9:"main-menu";i:1;s:10:"management";i:2;s:10:"navigation";i:3;s:9:"user-menu";}',
))
->values(array(
  'name' => 'menu_override_parent_selector',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'menu_parent_article',
  'value' => 's:11:"main-menu:0";',
))
->values(array(
  'name' => 'menu_parent_blog',
  'value' => 's:11:"main-menu:0";',
))
->values(array(
  'name' => 'menu_parent_book',
  'value' => 's:11:"main-menu:0";',
))
->values(array(
  'name' => 'menu_parent_forum',
  'value' => 's:11:"main-menu:0";',
))
->values(array(
  'name' => 'menu_parent_page',
  'value' => 's:11:"main-menu:0";',
))
->values(array(
  'name' => 'menu_parent_test_content_type',
  'value' => 's:11:"main-menu:0";',
))
->values(array(
  'name' => 'minimum_word_size',
  'value' => 's:1:"4";',
))
->values(array(
  'name' => 'node_admin_theme',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'node_cron_last',
  'value' => 's:10:"1564543706";',
))
->values(array(
  'name' => 'node_options_article',
  'value' => 'a:2:{i:0;s:6:"status";i:1;s:7:"promote";}',
))
->values(array(
  'name' => 'node_options_blog',
  'value' => 'a:2:{i:0;s:6:"status";i:1;s:7:"promote";}',
))
->values(array(
  'name' => 'node_options_book',
  'value' => 'a:2:{i:0;s:6:"status";i:1;s:8:"revision";}',
))
->values(array(
  'name' => 'node_options_page',
  'value' => 'a:1:{i:0;s:6:"status";}',
))
->values(array(
  'name' => 'node_options_test_content_type',
  'value' => 'a:3:{i:0;s:6:"status";i:1;s:7:"promote";i:2;s:8:"revision";}',
))
->values(array(
  'name' => 'node_preview_article',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'node_preview_blog',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'node_preview_forum',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'node_preview_page',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'node_preview_test_content_type',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'node_rank_comments',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'node_rank_promote',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'node_rank_relevance',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'node_rank_sticky',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'node_rank_views',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'node_submitted_article',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'node_submitted_blog',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'node_submitted_book',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'node_submitted_forum',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'node_submitted_page',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'node_submitted_test_content_type',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'overlap_cjk',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'page_cache_maximum_age',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'page_compression',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'path_alias_whitelist',
  'value' => 'a:3:{s:8:"taxonomy";b:1;s:4:"node";b:1;s:5:"admin";b:1;}',
))
->values(array(
  'name' => 'preprocess_css',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'preprocess_js',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'save_continue_test_content_type',
  'value' => 's:19:"Save and add fields";',
))
->values(array(
  'name' => 'search_active_modules',
  'value' => 'a:2:{s:4:"node";s:4:"node";s:4:"user";i:0;}',
))
->values(array(
  'name' => 'search_and_or_limit',
  'value' => 'i:7;',
))
->values(array(
  'name' => 'search_cron_limit',
  'value' => 's:3:"100";',
))
->values(array(
  'name' => 'search_default_module',
  'value' => 's:4:"node";',
))
->values(array(
  'name' => 'search_tag_weights',
  'value' => 'a:12:{s:2:"h1";i:25;s:2:"h2";i:18;s:2:"h3";i:15;s:2:"h4";i:12;s:2:"h5";i:9;s:2:"h6";i:6;s:1:"u";i:3;s:1:"b";i:3;s:1:"i";i:3;s:6:"strong";i:3;s:2:"em";i:3;s:1:"a";i:10;}',
))
->values(array(
  'name' => 'site_403',
  'value' => 's:4:"node";',
))
->values(array(
  'name' => 'site_404',
  'value' => 's:4:"node";',
))
->values(array(
  'name' => 'site_default_country',
  'value' => 's:2:"US";',
))
->values(array(
  'name' => 'site_frontpage',
  'value' => 's:4:"node";',
))
->values(array(
  'name' => 'site_mail',
  'value' => 's:23:"joseph@flattandsons.com";',
))
->values(array(
  'name' => 'site_name',
  'value' => 's:13:"The Site Name";',
))
->values(array(
  'name' => 'site_slogan',
  'value' => 's:10:"The Slogan";',
))
->values(array(
  'name' => 'statistics_count_content_views',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'statistics_count_content_views_ajax',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'statistics_day_timestamp',
  'value' => 'i:1647478053;',
))
->values(array(
  'name' => 'statistics_enable_access_log',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'statistics_flush_accesslog_timer',
  'value' => 's:4:"3600";',
))
->values(array(
  'name' => 'suppress_itok_output',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'taxonomy_override_selector',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'taxonomy_terms_per_page_admin',
  'value' => 'i:84;',
))
->values(array(
  'name' => 'teaser_length',
  'value' => 'i:1024;',
))
->values(array(
  'name' => 'theme_bartik_settings',
  'value' => 'a:18:{s:11:"toggle_logo";i:1;s:11:"toggle_name";i:1;s:13:"toggle_slogan";i:1;s:24:"toggle_node_user_picture";i:1;s:27:"toggle_comment_user_picture";i:1;s:32:"toggle_comment_user_verification";i:1;s:14:"toggle_favicon";i:1;s:16:"toggle_main_menu";i:1;s:21:"toggle_secondary_menu";i:1;s:12:"default_logo";i:0;s:9:"logo_path";s:16:"public://gnu.png";s:15:"default_favicon";i:1;s:12:"favicon_path";s:0:"";s:14:"favicon_upload";s:0:"";s:6:"scheme";s:7:"default";s:7:"palette";a:9:{s:3:"top";s:7:"#0779bf";s:6:"bottom";s:7:"#48a9e4";s:2:"bg";s:7:"#ffffff";s:7:"sidebar";s:7:"#f6f6f2";s:14:"sidebarborders";s:7:"#f9f9f9";s:6:"footer";s:7:"#292929";s:11:"titleslogan";s:7:"#fffeff";s:4:"text";s:7:"#3b3b3b";s:4:"link";s:7:"#0071B3";}s:5:"theme";s:6:"bartik";s:4:"info";a:12:{s:6:"fields";a:9:{s:3:"top";s:10:"Header top";s:6:"bottom";s:13:"Header bottom";s:2:"bg";s:15:"Main background";s:7:"sidebar";s:18:"Sidebar background";s:14:"sidebarborders";s:15:"Sidebar borders";s:6:"footer";s:17:"Footer background";s:11:"titleslogan";s:16:"Title and slogan";s:4:"text";s:10:"Text color";s:4:"link";s:10:"Link color";}s:7:"schemes";a:6:{s:7:"default";a:2:{s:5:"title";s:21:"Blue Lagoon (default)";s:6:"colors";a:9:{s:3:"top";s:7:"#0779bf";s:6:"bottom";s:7:"#48a9e4";s:2:"bg";s:7:"#ffffff";s:7:"sidebar";s:7:"#f6f6f2";s:14:"sidebarborders";s:7:"#f9f9f9";s:6:"footer";s:7:"#292929";s:11:"titleslogan";s:7:"#fffeff";s:4:"text";s:7:"#3b3b3b";s:4:"link";s:7:"#0071B3";}}s:9:"firehouse";a:2:{s:5:"title";s:9:"Firehouse";s:6:"colors";a:9:{s:3:"top";s:7:"#cd2d2d";s:6:"bottom";s:7:"#cf3535";s:2:"bg";s:7:"#ffffff";s:7:"sidebar";s:7:"#f1f4f0";s:14:"sidebarborders";s:7:"#ededed";s:6:"footer";s:7:"#1f1d1c";s:11:"titleslogan";s:7:"#fffeff";s:4:"text";s:7:"#3b3b3b";s:4:"link";s:7:"#d6121f";}}s:3:"ice";a:2:{s:5:"title";s:3:"Ice";s:6:"colors";a:9:{s:3:"top";s:7:"#d0d0d0";s:6:"bottom";s:7:"#c2c4c5";s:2:"bg";s:7:"#ffffff";s:7:"sidebar";s:7:"#ffffff";s:14:"sidebarborders";s:7:"#cccccc";s:6:"footer";s:7:"#24272c";s:11:"titleslogan";s:7:"#000000";s:4:"text";s:7:"#4a4a4a";s:4:"link";s:7:"#019dbf";}}s:4:"plum";a:2:{s:5:"title";s:4:"Plum";s:6:"colors";a:9:{s:3:"top";s:7:"#4c1c58";s:6:"bottom";s:7:"#593662";s:2:"bg";s:7:"#fffdf7";s:7:"sidebar";s:7:"#edede7";s:14:"sidebarborders";s:7:"#e7e7e7";s:6:"footer";s:7:"#2c2c28";s:11:"titleslogan";s:7:"#ffffff";s:4:"text";s:7:"#301313";s:4:"link";s:7:"#9d408d";}}s:5:"slate";a:2:{s:5:"title";s:5:"Slate";s:6:"colors";a:9:{s:3:"top";s:7:"#4a4a4a";s:6:"bottom";s:7:"#4e4e4e";s:2:"bg";s:7:"#ffffff";s:7:"sidebar";s:7:"#ffffff";s:14:"sidebarborders";s:7:"#d0d0d0";s:6:"footer";s:7:"#161617";s:11:"titleslogan";s:7:"#ffffff";s:4:"text";s:7:"#3b3b3b";s:4:"link";s:7:"#0073b6";}}s:0:"";a:2:{s:5:"title";s:6:"Custom";s:6:"colors";a:0:{}}}s:3:"css";a:1:{i:0;s:14:"css/colors.css";}s:4:"copy";a:1:{i:0;s:8:"logo.png";}s:9:"gradients";a:1:{i:0;a:3:{s:9:"dimension";a:4:{i:0;i:0;i:1;i:0;i:2;i:0;i:3;i:0;}s:9:"direction";s:8:"vertical";s:6:"colors";a:2:{i:0;s:3:"top";i:1;s:6:"bottom";}}}s:4:"fill";a:0:{}s:6:"slices";a:0:{}s:12:"blend_target";s:7:"#ffffff";s:11:"preview_css";s:17:"color/preview.css";s:10:"preview_js";s:16:"color/preview.js";s:12:"preview_html";s:18:"color/preview.html";s:10:"base_image";s:14:"color/base.png";}}',
))
->values(array(
  'name' => 'theme_default',
  'value' => 's:6:"bartik";',
))
->values(array(
  'name' => 'theme_settings',
  'value' => 'a:16:{s:11:"toggle_logo";i:0;s:11:"toggle_name";i:1;s:13:"toggle_slogan";i:0;s:24:"toggle_node_user_picture";i:0;s:27:"toggle_comment_user_picture";i:0;s:32:"toggle_comment_user_verification";i:0;s:14:"toggle_favicon";i:0;s:16:"toggle_main_menu";i:0;s:21:"toggle_secondary_menu";i:0;s:12:"default_logo";i:1;s:9:"logo_path";s:23:"public://customlogo.png";s:11:"logo_upload";s:0:"";s:15:"default_favicon";i:0;s:12:"favicon_path";s:24:"public://somefavicon.png";s:14:"favicon_upload";s:0:"";s:16:"favicon_mimetype";s:9:"image/png";}',
))
->values(array(
  'name' => 'theme_seven_settings',
  'value' => 'a:15:{s:11:"toggle_logo";i:1;s:11:"toggle_name";i:1;s:13:"toggle_slogan";i:1;s:24:"toggle_node_user_picture";i:1;s:27:"toggle_comment_user_picture";i:0;s:32:"toggle_comment_user_verification";i:1;s:14:"toggle_favicon";i:1;s:16:"toggle_main_menu";i:1;s:21:"toggle_secondary_menu";i:0;s:12:"default_logo";i:1;s:9:"logo_path";s:0:"";s:11:"logo_upload";s:0:"";s:15:"default_favicon";i:1;s:12:"favicon_path";s:0:"";s:14:"favicon_upload";s:0:"";}',
))
->values(array(
  'name' => 'tracker_batch_size',
  'value' => 'i:999;',
))
->values(array(
  'name' => 'user_admin_role',
  'value' => 's:1:"3";',
))
->values(array(
  'name' => 'user_cancel_method',
  'value' => 's:17:"user_cancel_block";',
))
->values(array(
  'name' => 'user_default_timezone',
  'value' => 'i:2;',
))
->values(array(
  'name' => 'user_email_verification',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'user_failed_login_identifier_uid_only',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'user_failed_login_ip_limit',
  'value' => 'i:30;',
))
->values(array(
  'name' => 'user_failed_login_ip_window',
  'value' => 'i:7200;',
))
->values(array(
  'name' => 'user_failed_login_user_limit',
  'value' => 'i:22;',
))
->values(array(
  'name' => 'user_failed_login_user_window',
  'value' => 'i:86400;',
))
->values(array(
  'name' => 'user_mail_cancel_confirm_body',
  'value' => 's:55:"A little birdie said you wanted to cancel your account.";',
))
->values(array(
  'name' => 'user_mail_cancel_confirm_subject',
  'value' => 's:13:"Are you sure?";',
))
->values(array(
  'name' => 'user_mail_password_reset_body',
  'value' => "s:32:\"Nope! You're locked out forever.\";",
))
->values(array(
  'name' => 'user_mail_password_reset_subject',
  'value' => 's:17:"Fix your password";',
))
->values(array(
  'name' => 'user_mail_register_admin_created_body',
  'value' => 's:30:"...and it could be taken away.";',
))
->values(array(
  'name' => 'user_mail_register_admin_created_subject',
  'value' => 's:24:"Gawd made you an account";',
))
->values(array(
  'name' => 'user_mail_register_no_approval_required_body',
  'value' => 's:59:"You can now log in if you can figure out how to use Drupal!";',
))
->values(array(
  'name' => 'user_mail_register_no_approval_required_subject',
  'value' => 's:8:"Welcome!";',
))
->values(array(
  'name' => 'user_mail_register_pending_approval_body',
  'value' => 's:61:"...you will join our Circle. Let the Drupal flow through you.";',
))
->values(array(
  'name' => 'user_mail_register_pending_approval_subject',
  'value' => 's:7:"Soon...";',
))
->values(array(
  'name' => 'user_mail_status_activated_body',
  'value' => 's:57:"Your account was activated, and there was much rejoicing.";',
))
->values(array(
  'name' => 'user_mail_status_activated_notify',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'user_mail_status_activated_subject',
  'value' => 's:25:"Your account is approved!";',
))
->values(array(
  'name' => 'user_mail_status_blocked_body',
  'value' => 's:72:"You no longer please the robot overlords. Go to your room and chill out.";',
))
->values(array(
  'name' => 'user_mail_status_blocked_notify',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'user_mail_status_blocked_subject',
  'value' => 's:7:"BEGONE!";',
))
->values(array(
  'name' => 'user_mail_status_canceled_body',
  'value' => 's:75:"The gates of Drupal are closed to you. Now you will work in the salt mines.";',
))
->values(array(
  'name' => 'user_mail_status_canceled_notify',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'user_mail_status_canceled_subject',
  'value' => 's:12:"So long, bub";',
))
->values(array(
  'name' => 'user_pictures',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'user_picture_default',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'user_picture_dimensions',
  'value' => 's:9:"1024x1024";',
))
->values(array(
  'name' => 'user_picture_file_size',
  'value' => 's:3:"800";',
))
->values(array(
  'name' => 'user_picture_guidelines',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'user_picture_path',
  'value' => 's:8:"pictures";',
))
->values(array(
  'name' => 'user_picture_style',
  'value' => 's:9:"thumbnail";',
))
->values(array(
  'name' => 'user_register',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'user_signatures',
  'value' => 'i:0;',
))
->execute();

// Reset the SQL mode.
if ($connection->databaseType() === 'mysql') {
  $connection->query("SET sql_mode = '$sql_mode'");
}
