/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.time.Instant;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.date.DateUtils;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractParser
extends DefaultHandler {
    protected HistoryOsmPrimitive currentPrimitive;
    protected Locator locator;
    protected boolean useAnonymousUser;

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    protected abstract void throwException(String var1) throws SAXException;

    protected abstract void throwException(String var1, Exception var2) throws SAXException;

    protected final long getMandatoryAttributeLong(Attributes attr, String name) throws SAXException {
        String v = attr.getValue(name);
        if (v == null) {
            this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", name));
        }
        long l = 0L;
        try {
            l = Long.parseLong(v);
        }
        catch (NumberFormatException e) {
            this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type long. Got ''{1}''.", name, v), e);
        }
        if (l < 0L) {
            this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type long (>=0). Got ''{1}''.", name, v));
        }
        return l;
    }

    protected final Long getAttributeLong(Attributes attr, String name) throws SAXException {
        String v = attr.getValue(name);
        if (v == null) {
            return null;
        }
        Long l = 0L;
        try {
            l = Long.valueOf(v);
        }
        catch (NumberFormatException e) {
            this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type long. Got ''{1}''.", name, v), e);
        }
        if (l < 0L) {
            this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type long (>=0). Got ''{1}''.", name, v));
        }
        return l;
    }

    protected final Double getAttributeDouble(Attributes attr, String name) throws SAXException {
        String v = attr.getValue(name);
        if (v == null) {
            return null;
        }
        double d = 0.0;
        try {
            d = Double.parseDouble(v);
        }
        catch (NumberFormatException e) {
            this.throwException(I18n.tr("Illegal value for attribute ''{0}'' of type double. Got ''{1}''.", name, v), e);
        }
        return d;
    }

    protected final String getMandatoryAttributeString(Attributes attr, String name) throws SAXException {
        String v = attr.getValue(name);
        if (v == null) {
            this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", name));
        }
        return v;
    }

    protected boolean getMandatoryAttributeBoolean(Attributes attr, String name) throws SAXException {
        String v = attr.getValue(name);
        if (v == null) {
            this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", name));
        }
        if ("true".equals(v)) {
            return true;
        }
        if ("false".equals(v)) {
            return false;
        }
        this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type boolean. Got ''{1}''.", name, v));
        return false;
    }

    protected final HistoryOsmPrimitive createPrimitive(Attributes atts, OsmPrimitiveType type) throws SAXException {
        long id = this.getMandatoryAttributeLong(atts, "id");
        long version = this.getMandatoryAttributeLong(atts, "version");
        Long changeset = this.getAttributeLong(atts, "changeset");
        long changesetId = changeset != null ? changeset : 0L;
        boolean visible = this.getMandatoryAttributeBoolean(atts, "visible");
        User user = null;
        if (!this.useAnonymousUser) {
            Long uid = this.getAttributeLong(atts, "uid");
            String userStr = atts.getValue("user");
            if (userStr != null) {
                if (uid != null) {
                    user = User.createOsmUser(uid, userStr);
                    user.setPreferredName(userStr);
                } else {
                    user = User.createLocalUser(userStr);
                }
            }
        }
        if (user == null) {
            user = User.getAnonymous();
        }
        String v = this.getMandatoryAttributeString(atts, "timestamp");
        Instant timestamp = DateUtils.parseInstant(v);
        HistoryOsmPrimitive primitive = null;
        if (type == OsmPrimitiveType.NODE) {
            Double lat = this.getAttributeDouble(atts, "lat");
            Double lon = this.getAttributeDouble(atts, "lon");
            LatLon coor = lat != null && lon != null ? new LatLon(lat, lon) : null;
            primitive = new HistoryNode(id, version, visible, user, changesetId, timestamp, coor, changeset != null);
        } else if (type == OsmPrimitiveType.WAY) {
            primitive = new HistoryWay(id, version, visible, user, changesetId, timestamp, changeset != null);
        } else if (type == OsmPrimitiveType.RELATION) {
            primitive = new HistoryRelation(id, version, visible, user, changesetId, timestamp, changeset != null);
        }
        return primitive;
    }

    protected final void startNode(Attributes atts) throws SAXException {
        this.currentPrimitive = this.createPrimitive(atts, OsmPrimitiveType.NODE);
    }

    protected final void startWay(Attributes atts) throws SAXException {
        this.currentPrimitive = this.createPrimitive(atts, OsmPrimitiveType.WAY);
    }

    protected final void startRelation(Attributes atts) throws SAXException {
        this.currentPrimitive = this.createPrimitive(atts, OsmPrimitiveType.RELATION);
    }

    protected final void handleTag(Attributes atts) throws SAXException {
        String key = this.getMandatoryAttributeString(atts, "k");
        String value = this.getMandatoryAttributeString(atts, "v");
        this.currentPrimitive.put(key, value);
    }

    protected final void handleNodeReference(Attributes atts) throws SAXException {
        long ref = this.getMandatoryAttributeLong(atts, "ref");
        ((HistoryWay)this.currentPrimitive).addNode(ref);
    }

    protected void handleMember(Attributes atts) throws SAXException {
        long ref = this.getMandatoryAttributeLong(atts, "ref");
        String v = this.getMandatoryAttributeString(atts, "type");
        OsmPrimitiveType type = null;
        try {
            type = OsmPrimitiveType.fromApiTypeName(v);
        }
        catch (IllegalArgumentException e) {
            this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type OsmPrimitiveType. Got ''{1}''.", "type", v), e);
        }
        String role = this.getMandatoryAttributeString(atts, "role");
        RelationMemberData member = new RelationMemberData(role, type, ref);
        ((HistoryRelation)this.currentPrimitive).addMember(member);
    }

    protected final boolean doStartElement(String qName, Attributes atts) throws SAXException {
        switch (qName) {
            case "node": {
                this.startNode(atts);
                return true;
            }
            case "way": {
                this.startWay(atts);
                return true;
            }
            case "relation": {
                this.startRelation(atts);
                return true;
            }
            case "tag": {
                this.handleTag(atts);
                return true;
            }
            case "nd": {
                this.handleNodeReference(atts);
                return true;
            }
            case "member": {
                this.handleMember(atts);
                return true;
            }
        }
        return false;
    }
}

