/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ComposedChanged;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;

public class ChangedExtensions
implements ComposedChanged {
    private final Map<String, Object> oldExtensions;
    private final Map<String, Object> newExtensions;
    private final DiffContext context;
    private Map<String, Changed> increased;
    private Map<String, Changed> missing;
    private Map<String, Changed> changed;

    public ChangedExtensions(Map<String, Object> oldExtensions, Map<String, Object> newExtensions, DiffContext context) {
        this.oldExtensions = oldExtensions;
        this.newExtensions = newExtensions;
        this.context = context;
        this.increased = new LinkedHashMap<String, Changed>();
        this.missing = new LinkedHashMap<String, Changed>();
        this.changed = new LinkedHashMap<String, Changed>();
    }

    @Override
    public List<Changed> getChangedElements() {
        return Stream.of(this.increased, this.missing, this.changed).map(Map::values).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public DiffResult isCoreChanged() {
        return DiffResult.NO_CHANGES;
    }

    public Map<String, Object> getOldExtensions() {
        return this.oldExtensions;
    }

    public Map<String, Object> getNewExtensions() {
        return this.newExtensions;
    }

    public DiffContext getContext() {
        return this.context;
    }

    public Map<String, Changed> getIncreased() {
        return this.increased;
    }

    public Map<String, Changed> getMissing() {
        return this.missing;
    }

    public Map<String, Changed> getChanged() {
        return this.changed;
    }

    public void setIncreased(Map<String, Changed> increased) {
        this.increased = increased;
    }

    public void setMissing(Map<String, Changed> missing) {
        this.missing = missing;
    }

    public void setChanged(Map<String, Changed> changed) {
        this.changed = changed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedExtensions that = (ChangedExtensions)o;
        return Objects.equals(this.oldExtensions, that.oldExtensions) && Objects.equals(this.newExtensions, that.newExtensions) && Objects.equals(this.context, that.context) && Objects.equals(this.increased, that.increased) && Objects.equals(this.missing, that.missing) && Objects.equals(this.changed, that.changed);
    }

    public int hashCode() {
        return Objects.hash(this.oldExtensions, this.newExtensions, this.context, this.increased, this.missing, this.changed);
    }

    public String toString() {
        return "ChangedExtensions(oldExtensions=" + this.getOldExtensions() + ", newExtensions=" + this.getNewExtensions() + ", context=" + this.getContext() + ", increased=" + this.getIncreased() + ", missing=" + this.getMissing() + ", changed=" + this.getChanged() + ")";
    }
}

