/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.ratelimit;

import java.io.IOException;
import org.opensearch.ad.model.AnomalyResult;
import org.opensearch.ad.ratelimit.QueuedRequest;
import org.opensearch.ad.ratelimit.RequestPriority;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public class ResultWriteRequest
extends QueuedRequest
implements Writeable {
    private final AnomalyResult result;
    private final String resultIndex;

    public ResultWriteRequest(long expirationEpochMs, String detectorId, RequestPriority priority, AnomalyResult result, String resultIndex) {
        super(expirationEpochMs, detectorId, priority);
        this.result = result;
        this.resultIndex = resultIndex;
    }

    public ResultWriteRequest(StreamInput in) throws IOException {
        this.result = new AnomalyResult(in);
        this.resultIndex = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.result.writeTo(out);
        out.writeOptionalString(this.resultIndex);
    }

    public AnomalyResult getResult() {
        return this.result;
    }

    public String getResultIndex() {
        return this.resultIndex;
    }
}

