/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.model;

import com.google.common.base.Objects;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.timeseries.annotation.Generated;
import org.opensearch.timeseries.constant.CommonValue;
import org.opensearch.timeseries.model.Entity;
import org.opensearch.timeseries.model.FeatureData;
import org.opensearch.timeseries.model.IndexableResult;
import org.opensearch.timeseries.util.ParseUtils;

public class ForecastResult
extends IndexableResult {
    public static final String PARSE_FIELD_NAME = "ForecastResult";
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(ForecastResult.class, new ParseField("ForecastResult", new String[0]), it -> ForecastResult.parse(it));
    public static final String FEATURE_ID_FIELD = "feature_id";
    public static final String VALUE_FIELD = "forecast_value";
    public static final String LOWER_BOUND_FIELD = "forecast_lower_bound";
    public static final String UPPER_BOUND_FIELD = "forecast_upper_bound";
    public static final String INTERVAL_WIDTH_FIELD = "confidence_interval_width";
    public static final String FORECAST_DATA_START_TIME_FIELD = "forecast_data_start_time";
    public static final String FORECAST_DATA_END_TIME_FIELD = "forecast_data_end_time";
    public static final String HORIZON_INDEX_FIELD = "horizon_index";
    private final String featureId;
    private final Float forecastValue;
    private final Float lowerBound;
    private final Float upperBound;
    private final Float confidenceIntervalWidth;
    private final Instant forecastDataStartTime;
    private final Instant forecastDataEndTime;
    private final Integer horizonIndex;
    protected final Double dataQuality;
    private final String entityId;

    public ForecastResult(String forecasterId, String taskId, List<FeatureData> featureData, Instant dataStartTime, Instant dataEndTime, Instant executionStartTime, Instant executionEndTime, String error, Optional<Entity> entity, User user, Integer schemaVersion) {
        this(forecasterId, taskId, Double.NaN, featureData, dataStartTime, dataEndTime, executionStartTime, executionEndTime, error, entity, user, schemaVersion, null, null, null, null, null, null, null);
    }

    public ForecastResult(String forecasterId, String taskId, Double dataQuality, List<FeatureData> featureData, Instant dataStartTime, Instant dataEndTime, Instant executionStartTime, Instant executionEndTime, String error, Optional<Entity> entity, User user, Integer schemaVersion, String featureId, Float forecastValue, Float lowerBound, Float upperBound, Instant forecastDataStartTime, Instant forecastDataEndTime, Integer horizonIndex) {
        super(forecasterId, featureData, dataStartTime, dataEndTime, executionStartTime, executionEndTime, error, entity, user, schemaVersion, taskId);
        this.featureId = featureId;
        this.dataQuality = dataQuality;
        this.forecastValue = forecastValue;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.confidenceIntervalWidth = this.safeAbsoluteDifference(lowerBound, upperBound);
        this.forecastDataStartTime = forecastDataStartTime;
        this.forecastDataEndTime = forecastDataEndTime;
        this.horizonIndex = horizonIndex;
        this.entityId = ForecastResult.getEntityId(entity, this.configId);
    }

    public static List<ForecastResult> fromRawRCFCasterResult(String forecasterId, long intervalMillis, Double dataQuality, List<FeatureData> featureData, Instant dataStartTime, Instant dataEndTime, Instant executionStartTime, Instant executionEndTime, String error, Optional<Entity> entity, User user, Integer schemaVersion, String modelId, float[] forecastsValues, float[] forecastsUppers, float[] forecastsLowers, String taskId) {
        int inputLength = featureData.size();
        int numberOfForecasts = 0;
        if (forecastsValues != null && dataQuality > 0.0) {
            numberOfForecasts = forecastsValues.length / inputLength;
        }
        ArrayList<ForecastResult> convertedForecastValues = new ArrayList<ForecastResult>(numberOfForecasts + 1);
        convertedForecastValues.add(new ForecastResult(forecasterId, taskId, Math.min(1.0, dataQuality), featureData, dataStartTime, dataEndTime, executionStartTime, executionEndTime, error, entity, user, schemaVersion, null, null, null, null, null, null, null));
        Instant forecastDataStartTime = dataEndTime;
        for (int i = 0; i < numberOfForecasts; ++i) {
            Instant forecastDataEndTime = forecastDataStartTime.plusMillis(intervalMillis);
            for (int j = 0; j < inputLength; ++j) {
                int k = i * inputLength + j;
                convertedForecastValues.add(new ForecastResult(forecasterId, taskId, Math.min(1.0, dataQuality), null, dataStartTime, dataEndTime, executionStartTime, executionEndTime, error, entity, user, schemaVersion, featureData.get(j).getFeatureId(), Float.valueOf(forecastsValues[k]), Float.valueOf(forecastsLowers[k]), Float.valueOf(forecastsUppers[k]), forecastDataStartTime, forecastDataEndTime, i + 1));
            }
            forecastDataStartTime = forecastDataEndTime;
        }
        return convertedForecastValues;
    }

    public ForecastResult(StreamInput input) throws IOException {
        super(input);
        this.featureId = input.readOptionalString();
        this.dataQuality = input.readOptionalDouble();
        this.forecastValue = input.readOptionalFloat();
        this.lowerBound = input.readOptionalFloat();
        this.upperBound = input.readOptionalFloat();
        this.confidenceIntervalWidth = input.readOptionalFloat();
        this.forecastDataStartTime = input.readOptionalInstant();
        this.forecastDataEndTime = input.readOptionalInstant();
        this.horizonIndex = input.readOptionalInt();
        this.entityId = input.readOptionalString();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject().field("forecaster_id", this.configId).field("schema_version", this.schemaVersion);
        if (this.dataStartTime != null) {
            xContentBuilder.field("data_start_time", this.dataStartTime.toEpochMilli());
        }
        if (this.dataEndTime != null) {
            xContentBuilder.field("data_end_time", this.dataEndTime.toEpochMilli());
        }
        if (this.featureData != null) {
            xContentBuilder.field("feature_data", (Object)this.featureData.toArray());
        }
        if (this.executionStartTime != null) {
            xContentBuilder.field("execution_start_time", this.executionStartTime.toEpochMilli());
        }
        if (this.executionEndTime != null) {
            xContentBuilder.field("execution_end_time", this.executionEndTime.toEpochMilli());
        }
        if (this.error != null) {
            xContentBuilder.field("error", this.error);
        }
        if (this.optionalEntity.isPresent()) {
            xContentBuilder.field("entity", (ToXContent)this.optionalEntity.get());
        }
        if (this.user != null) {
            xContentBuilder.field("user", (ToXContent)this.user);
        }
        if (this.dataQuality != null && !this.dataQuality.isNaN()) {
            xContentBuilder.field("data_quality", this.dataQuality);
        }
        if (this.taskId != null) {
            xContentBuilder.field("task_id", this.taskId);
        }
        if (this.entityId != null) {
            xContentBuilder.field("entity_id", this.entityId);
        }
        if (this.forecastValue != null) {
            xContentBuilder.field(VALUE_FIELD, this.forecastValue);
        }
        if (this.lowerBound != null) {
            xContentBuilder.field(LOWER_BOUND_FIELD, this.lowerBound);
        }
        if (this.upperBound != null) {
            xContentBuilder.field(UPPER_BOUND_FIELD, this.upperBound);
        }
        if (this.confidenceIntervalWidth != null) {
            xContentBuilder.field(INTERVAL_WIDTH_FIELD, this.confidenceIntervalWidth);
        }
        if (this.forecastDataStartTime != null) {
            xContentBuilder.field(FORECAST_DATA_START_TIME_FIELD, this.forecastDataStartTime.toEpochMilli());
        }
        if (this.forecastDataEndTime != null) {
            xContentBuilder.field(FORECAST_DATA_END_TIME_FIELD, this.forecastDataEndTime.toEpochMilli());
        }
        if (this.horizonIndex != null && this.horizonIndex > 0) {
            xContentBuilder.field(HORIZON_INDEX_FIELD, this.horizonIndex);
        }
        if (this.featureId != null) {
            xContentBuilder.field(FEATURE_ID_FIELD, this.featureId);
        }
        return xContentBuilder.endObject();
    }

    public static ForecastResult parse(XContentParser parser) throws IOException {
        String forecasterId = null;
        Double dataQuality = null;
        ArrayList<FeatureData> featureData = null;
        Instant dataStartTime = null;
        Instant dataEndTime = null;
        Instant executionStartTime = null;
        Instant executionEndTime = null;
        String error = null;
        Entity entity = null;
        User user = null;
        Integer schemaVersion = CommonValue.NO_SCHEMA_VERSION;
        String taskId = null;
        String featureId = null;
        Float forecastValue = null;
        Float lowerBound = null;
        Float upperBound = null;
        Instant forecastDataStartTime = null;
        Instant forecastDataEndTime = null;
        Integer horizonIndex = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block42: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "forecaster_id": {
                    forecasterId = parser.text();
                    continue block42;
                }
                case "data_quality": {
                    dataQuality = parser.doubleValue();
                    continue block42;
                }
                case "feature_data": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    featureData = new ArrayList<FeatureData>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        featureData.add(FeatureData.parse(parser));
                    }
                    continue block42;
                }
                case "data_start_time": {
                    dataStartTime = ParseUtils.toInstant(parser);
                    continue block42;
                }
                case "data_end_time": {
                    dataEndTime = ParseUtils.toInstant(parser);
                    continue block42;
                }
                case "execution_start_time": {
                    executionStartTime = ParseUtils.toInstant(parser);
                    continue block42;
                }
                case "execution_end_time": {
                    executionEndTime = ParseUtils.toInstant(parser);
                    continue block42;
                }
                case "error": {
                    error = parser.text();
                    continue block42;
                }
                case "entity": {
                    entity = Entity.parse(parser);
                    continue block42;
                }
                case "user": {
                    user = User.parse((XContentParser)parser);
                    continue block42;
                }
                case "schema_version": {
                    schemaVersion = parser.intValue();
                    continue block42;
                }
                case "feature_id": {
                    featureId = parser.text();
                    continue block42;
                }
                case "forecast_lower_bound": {
                    lowerBound = Float.valueOf(parser.floatValue());
                    continue block42;
                }
                case "forecast_upper_bound": {
                    upperBound = Float.valueOf(parser.floatValue());
                    continue block42;
                }
                case "forecast_value": {
                    forecastValue = Float.valueOf(parser.floatValue());
                    continue block42;
                }
                case "forecast_data_start_time": {
                    forecastDataStartTime = ParseUtils.toInstant(parser);
                    continue block42;
                }
                case "forecast_data_end_time": {
                    forecastDataEndTime = ParseUtils.toInstant(parser);
                    continue block42;
                }
                case "task_id": {
                    taskId = parser.text();
                    continue block42;
                }
                case "horizon_index": {
                    horizonIndex = parser.intValue();
                    continue block42;
                }
            }
            parser.skipChildren();
        }
        return new ForecastResult(forecasterId, taskId, dataQuality, featureData, dataStartTime, dataEndTime, executionStartTime, executionEndTime, error, Optional.ofNullable(entity), user, schemaVersion, featureId, forecastValue, lowerBound, upperBound, forecastDataStartTime, forecastDataEndTime, horizonIndex);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ForecastResult that = (ForecastResult)o;
        return Objects.equal((Object)this.featureId, (Object)that.featureId) && Objects.equal((Object)this.dataQuality, (Object)that.dataQuality) && Objects.equal((Object)this.forecastValue, (Object)that.forecastValue) && Objects.equal((Object)this.lowerBound, (Object)that.lowerBound) && Objects.equal((Object)this.upperBound, (Object)that.upperBound) && Objects.equal((Object)this.confidenceIntervalWidth, (Object)that.confidenceIntervalWidth) && Objects.equal((Object)this.forecastDataStartTime, (Object)that.forecastDataStartTime) && Objects.equal((Object)this.forecastDataEndTime, (Object)that.forecastDataEndTime) && Objects.equal((Object)this.horizonIndex, (Object)that.horizonIndex) && Objects.equal((Object)this.entityId, (Object)that.entityId);
    }

    @Override
    @Generated
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode((Object[])new Object[]{this.featureId, this.dataQuality, this.forecastValue, this.lowerBound, this.upperBound, this.confidenceIntervalWidth, this.forecastDataStartTime, this.forecastDataEndTime, this.horizonIndex, this.entityId});
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return super.toString() + ", " + new ToStringBuilder((Object)this).append("featureId", (Object)this.featureId).append("dataQuality", (Object)this.dataQuality).append("forecastValue", (Object)this.forecastValue).append("lowerBound", (Object)this.lowerBound).append("upperBound", (Object)this.upperBound).append("confidenceIntervalWidth", (Object)this.confidenceIntervalWidth).append("forecastDataStartTime", (Object)this.forecastDataStartTime).append("forecastDataEndTime", (Object)this.forecastDataEndTime).append("horizonIndex", (Object)this.horizonIndex).append("entityId", (Object)this.entityId).toString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.featureId);
        out.writeOptionalDouble(this.dataQuality);
        out.writeOptionalFloat(this.forecastValue);
        out.writeOptionalFloat(this.lowerBound);
        out.writeOptionalFloat(this.upperBound);
        out.writeOptionalFloat(this.confidenceIntervalWidth);
        out.writeOptionalInstant(this.forecastDataStartTime);
        out.writeOptionalInstant(this.forecastDataEndTime);
        out.writeOptionalInt(this.horizonIndex);
        out.writeOptionalString(this.entityId);
    }

    public static ForecastResult getDummyResult() {
        return new ForecastResult("dummy_forecaster_id", null, null, null, null, null, null, null, Optional.empty(), null, CommonValue.NO_SCHEMA_VERSION);
    }

    @Override
    public boolean isHighPriority() {
        return this.getError() != null;
    }

    public Double getDataQuality() {
        return this.dataQuality;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public Float getForecastValue() {
        return this.forecastValue;
    }

    public Float getLowerBound() {
        return this.lowerBound;
    }

    public Float getUpperBound() {
        return this.upperBound;
    }

    public Float getConfidenceIntervalWidth() {
        return this.confidenceIntervalWidth;
    }

    public Instant getForecastDataStartTime() {
        return this.forecastDataStartTime;
    }

    public Instant getForecastDataEndTime() {
        return this.forecastDataEndTime;
    }

    public Integer getHorizonIndex() {
        return this.horizonIndex;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public Float safeAbsoluteDifference(Float a, Float b) {
        if (a == null || b == null) {
            return null;
        }
        float diff = a.floatValue() - b.floatValue();
        if (Float.isNaN(diff) || Float.isInfinite(diff)) {
            return Float.valueOf(Float.MAX_VALUE);
        }
        return Float.valueOf(Math.abs(diff));
    }
}

