"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SYSTEM_INDEX = exports.SYSTEM_ALIAS = exports.REQUEST = exports.NODE_API = exports.BASE_API_PATH = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const BASE_API_PATH = exports.BASE_API_PATH = "/api/ism";
const NODE_API = exports.NODE_API = Object.freeze({
  _SEARCH: `${BASE_API_PATH}/_search`,
  _SEARCH_SAMPLE_DATA: `${BASE_API_PATH}/_searchSampleData`,
  _INDICES: `${BASE_API_PATH}/_indices`,
  _DATA_STREAMS: `${BASE_API_PATH}/_data_streams`,
  _ALIASES: `${BASE_API_PATH}/_aliases`,
  _MAPPINGS: `${BASE_API_PATH}/_mappings`,
  APPLY_POLICY: `${BASE_API_PATH}/applyPolicy`,
  EDIT_ROLLOVER_ALIAS: `${BASE_API_PATH}/editRolloverAlias`,
  POLICIES: `${BASE_API_PATH}/policies`,
  _RECOVERY: `${BASE_API_PATH}/_recovery`,
  ROLLUPS: `${BASE_API_PATH}/rollups`,
  TRANSFORMS: `${BASE_API_PATH}/transforms`,
  MANAGED_INDICES: `${BASE_API_PATH}/managedIndices`,
  CHANNELS: `${BASE_API_PATH}/_notifications/channels`,
  RETRY: `${BASE_API_PATH}/retry`,
  CHANGE_POLICY: `${BASE_API_PATH}/changePolicy`,
  REMOVE_POLICY: `${BASE_API_PATH}/removePolicy`,
  SMPolicies: `${BASE_API_PATH}/smPolicies`,
  _SNAPSHOTS: `${BASE_API_PATH}/_snapshots`,
  _REPOSITORIES: `${BASE_API_PATH}/_repositores`,
  PUT_INDEX: `${BASE_API_PATH}/putIndex`,
  API_CALLER: `${BASE_API_PATH}/apiCaller`,
  ACCOUNT_INFO: `${BASE_API_PATH}/accountInfo`
});
const REQUEST = exports.REQUEST = Object.freeze({
  PUT: "PUT",
  DELETE: "DELETE",
  GET: "GET",
  POST: "POST",
  HEAD: "HEAD"
});
const SYSTEM_INDEX = exports.SYSTEM_INDEX = [".plugins-ml-model", ".plugins-ml-task", ".opendistro-alerting-config", ".opendistro-alerting-alert*", ".opendistro-anomaly-results*", ".opendistro-anomaly-detector*", ".opendistro-anomaly-checkpoints", ".opendistro-anomaly-detection-state", ".opendistro-reports-*", ".opensearch-notifications-*", ".opensearch-notebooks", ".opensearch-observability", ".opendistro-asynchronous-search-response*", ".opendistro_security", ".opendistro-job-scheduler-lock", ".opendistro-ism-config", ".replication-metadata-store", "kibana*", ".kibana*", ".tasks"];
const SYSTEM_ALIAS = exports.SYSTEM_ALIAS = [".plugins*", ".opendistro*", ".opensearch*", ".replication-metadata-store", "kibana*", ".kibana*", ".tasks"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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