/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.common;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.unit.TimeValue;

public class Ip2GeoSettings {
    public static final Setting<String> DATASOURCE_ENDPOINT = Setting.simpleString((String)"plugins.geospatial.ip2geo.datasource.endpoint", (String)"https://geoip.maps.opensearch.org/v1/geolite2-city/manifest.json", (Setting.Validator)new DatasourceEndpointValidator(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Long> DATASOURCE_UPDATE_INTERVAL = Setting.longSetting((String)"plugins.geospatial.ip2geo.datasource.update_interval_in_days", (long)3L, (long)1L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Integer> BATCH_SIZE = Setting.intSetting((String)"plugins.geospatial.ip2geo.datasource.batch_size", (int)10000, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> TIMEOUT = Setting.timeSetting((String)"plugins.geospatial.ip2geo.timeout", (TimeValue)TimeValue.timeValueSeconds((long)30L), (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Long> CACHE_SIZE = Setting.longSetting((String)"plugins.geospatial.ip2geo.processor.cache_size", (long)1000L, (long)0L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});

    public static final List<Setting<?>> settings() {
        return List.of(DATASOURCE_ENDPOINT, DATASOURCE_UPDATE_INTERVAL, BATCH_SIZE, TIMEOUT, CACHE_SIZE);
    }

    protected static class DatasourceEndpointValidator
    implements Setting.Validator<String> {
        protected DatasourceEndpointValidator() {
        }

        public void validate(String value) {
            try {
                new URL(value).toURI();
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new IllegalArgumentException("Invalid URL format is provided");
            }
        }
    }
}

