/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.EaterDeclareProcedure;
import net.sourceforge.plantuml.tim.EaterDeclareReturnFunction;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterExceptionLocated;
import net.sourceforge.plantuml.tim.EaterLegacyDefine;
import net.sourceforge.plantuml.tim.EaterLegacyDefineLong;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunction;
import net.sourceforge.plantuml.tim.TFunctionImpl;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TFunctionType;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.Trie;
import net.sourceforge.plantuml.tim.TrieImpl;

public class FunctionsSet {
    private final Map<TFunctionSignature, TFunction> functions = new HashMap<TFunctionSignature, TFunction>();
    private final Set<TFunctionSignature> functionsFinal = new HashSet<TFunctionSignature>();
    private final Trie functions3 = new TrieImpl();
    private TFunctionImpl pendingFunction;

    public TFunction getFunctionSmart(TFunctionSignature searched) {
        TFunction func = this.functions.get(searched);
        if (func != null) {
            return func;
        }
        for (TFunction candidate : this.functions.values()) {
            if (!candidate.getSignature().sameFunctionNameAs(searched) || !candidate.canCover(searched.getNbArg(), searched.getNamedArguments())) continue;
            return candidate;
        }
        return null;
    }

    public int size() {
        return this.functions().size();
    }

    public Map<TFunctionSignature, TFunction> functions() {
        return Collections.unmodifiableMap(this.functions);
    }

    public String getLonguestMatchStartingIn(String s) {
        return this.functions3.getLonguestMatchStartingIn(s);
    }

    public TFunctionImpl pendingFunction() {
        return this.pendingFunction;
    }

    public void addFunction(TFunction func) {
        if (func.getFunctionType() == TFunctionType.LEGACY_DEFINELONG) {
            ((TFunctionImpl)func).finalizeEnddefinelong();
        }
        this.functions.put(func.getSignature(), func);
        this.functions3.add(func.getSignature().getFunctionName() + "(");
    }

    public void executeEndfunction() {
        this.addFunction(this.pendingFunction);
        this.pendingFunction = null;
    }

    public void executeLegacyDefine(TContext context, TMemory memory, StringLocated s) throws EaterException, EaterExceptionLocated {
        if (this.pendingFunction != null) {
            throw EaterException.located("already0048");
        }
        EaterLegacyDefine legacyDefine = new EaterLegacyDefine(s);
        legacyDefine.analyze(context, memory);
        TFunction function = legacyDefine.getFunction();
        this.functions.put(function.getSignature(), function);
        this.functions3.add(function.getSignature().getFunctionName() + "(");
    }

    public void executeLegacyDefineLong(TContext context, TMemory memory, StringLocated s) throws EaterException, EaterExceptionLocated {
        if (this.pendingFunction != null) {
            throw EaterException.located("already0068");
        }
        EaterLegacyDefineLong legacyDefineLong = new EaterLegacyDefineLong(s);
        legacyDefineLong.analyze(context, memory);
        this.pendingFunction = legacyDefineLong.getFunction();
    }

    public void executeDeclareReturnFunction(TContext context, TMemory memory, StringLocated s) throws EaterException, EaterExceptionLocated {
        if (this.pendingFunction != null) {
            throw EaterException.located("already0068");
        }
        EaterDeclareReturnFunction declareFunction = new EaterDeclareReturnFunction(s);
        declareFunction.analyze(context, memory);
        boolean finalFlag = declareFunction.getFinalFlag();
        TFunctionSignature declaredSignature = declareFunction.getFunction().getSignature();
        TFunction previous = this.functions.get(declaredSignature);
        if (previous != null && (finalFlag || this.functionsFinal.contains(declaredSignature))) {
            throw EaterException.located("This function is already defined");
        }
        if (finalFlag) {
            this.functionsFinal.add(declaredSignature);
        }
        if (declareFunction.getFunction().hasBody()) {
            this.addFunction(declareFunction.getFunction());
        } else {
            this.pendingFunction = declareFunction.getFunction();
        }
    }

    public void executeDeclareProcedure(TContext context, TMemory memory, StringLocated s) throws EaterException, EaterExceptionLocated {
        if (this.pendingFunction != null) {
            throw EaterException.located("already0068");
        }
        EaterDeclareProcedure declareFunction = new EaterDeclareProcedure(s);
        declareFunction.analyze(context, memory);
        boolean finalFlag = declareFunction.getFinalFlag();
        TFunctionSignature declaredSignature = declareFunction.getFunction().getSignature();
        TFunction previous = this.functions.get(declaredSignature);
        if (previous != null && (finalFlag || this.functionsFinal.contains(declaredSignature))) {
            throw EaterException.located("This function is already defined");
        }
        if (finalFlag) {
            this.functionsFinal.add(declaredSignature);
        }
        if (declareFunction.getFunction().hasBody()) {
            this.addFunction(declareFunction.getFunction());
        } else {
            this.pendingFunction = declareFunction.getFunction();
        }
    }
}

