/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLObjectDuplicator;

public class OWLEntityRenamer {
    private final OWLOntologyManager owlOntologyManager;
    private final Set<OWLOntology> ontologies;

    public OWLEntityRenamer(@Nonnull OWLOntologyManager owlOntologyManager, @Nonnull Set<OWLOntology> ontologies) {
        this.owlOntologyManager = OWLAPIPreconditions.checkNotNull(owlOntologyManager, "owlOntologyManager cannot be null");
        this.ontologies = OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null");
    }

    @Nonnull
    public List<OWLOntologyChange> changeIRI(@Nonnull IRI iri, @Nonnull IRI newIRI) {
        OWLAPIPreconditions.checkNotNull(iri, "iri cannot be null");
        OWLAPIPreconditions.checkNotNull(newIRI, "newIRI cannot be null");
        HashMap<IRI, IRI> uriMap = new HashMap<IRI, IRI>();
        uriMap.put(iri, newIRI);
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        OWLObjectDuplicator dup = new OWLObjectDuplicator(this.owlOntologyManager.getOWLDataFactory(), uriMap);
        for (OWLOntology ont : this.ontologies) {
            assert (ont != null);
            OWLEntityRenamer.fillListWithTransformChanges(changes, this.getAxioms(ont, iri), ont, dup);
        }
        return changes;
    }

    @Nonnull
    public List<OWLOntologyChange> changeIRI(@Nonnull OWLEntity entity, @Nonnull IRI newIRI) {
        HashMap<OWLEntity, IRI> iriMap = new HashMap<OWLEntity, IRI>();
        iriMap.put(entity, newIRI);
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        OWLObjectDuplicator duplicator = new OWLObjectDuplicator(iriMap, this.owlOntologyManager.getOWLDataFactory());
        for (OWLOntology ont : this.ontologies) {
            assert (ont != null);
            OWLEntityRenamer.fillListWithTransformChanges(changes, OWLEntityRenamer.getAxioms(ont, entity), ont, duplicator);
        }
        return changes;
    }

    public List<OWLOntologyChange> changeIRI(@Nonnull Map<OWLEntity, IRI> entity2IRIMap) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        OWLObjectDuplicator duplicator = new OWLObjectDuplicator(entity2IRIMap, this.owlOntologyManager.getOWLDataFactory());
        for (OWLOntology ont : this.ontologies) {
            assert (ont != null);
            for (OWLEntity ent : entity2IRIMap.keySet()) {
                assert (ent != null);
                OWLEntityRenamer.fillListWithTransformChanges(changes, OWLEntityRenamer.getAxioms(ont, ent), ont, duplicator);
            }
        }
        return changes;
    }

    private static Set<OWLAxiom> getAxioms(@Nonnull OWLOntology ont, @Nonnull OWLEntity entity) {
        Set<OWLAxiom> axioms = ont.getReferencingAxioms((OWLPrimitive)entity, Imports.EXCLUDED);
        axioms.addAll(ont.getDeclarationAxioms(entity));
        axioms.addAll(ont.getAnnotationAssertionAxioms(entity.getIRI()));
        return axioms;
    }

    private Set<OWLAxiom> getAxioms(@Nonnull OWLOntology ont, @Nonnull IRI iri) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        axioms.addAll(ont.getReferencingAxioms((OWLPrimitive)this.owlOntologyManager.getOWLDataFactory().getOWLClass(iri), Imports.EXCLUDED));
        axioms.addAll(ont.getReferencingAxioms((OWLPrimitive)this.owlOntologyManager.getOWLDataFactory().getOWLObjectProperty(iri), Imports.EXCLUDED));
        axioms.addAll(ont.getReferencingAxioms((OWLPrimitive)this.owlOntologyManager.getOWLDataFactory().getOWLDataProperty(iri), Imports.EXCLUDED));
        axioms.addAll(ont.getReferencingAxioms((OWLPrimitive)this.owlOntologyManager.getOWLDataFactory().getOWLNamedIndividual(iri), Imports.EXCLUDED));
        axioms.addAll(ont.getReferencingAxioms((OWLPrimitive)this.owlOntologyManager.getOWLDataFactory().getOWLDatatype(iri), Imports.EXCLUDED));
        axioms.addAll(ont.getReferencingAxioms((OWLPrimitive)this.owlOntologyManager.getOWLDataFactory().getOWLAnnotationProperty(iri), Imports.EXCLUDED));
        axioms.addAll(ont.getAnnotationAssertionAxioms(iri));
        return axioms;
    }

    private static void fillListWithTransformChanges(List<OWLOntologyChange> changes, Set<OWLAxiom> axioms, @Nonnull OWLOntology ont, OWLObjectDuplicator duplicator) {
        for (OWLAxiom ax : axioms) {
            assert (ax != null);
            changes.add(new RemoveAxiom(ont, ax));
            OWLAxiom dupAx = (OWLAxiom)duplicator.duplicateObject(ax);
            changes.add(new AddAxiom(ont, dupAx));
        }
        OWLEntityRenamer.fillListWithOntologyAnnotationTransformChanges(changes, ont, duplicator);
    }

    private static void fillListWithOntologyAnnotationTransformChanges(List<OWLOntologyChange> changes, @Nonnull OWLOntology ont, OWLObjectDuplicator duplicator) {
        for (OWLAnnotation ann : ont.getAnnotations()) {
            OWLAnnotation dupAx = (OWLAnnotation)duplicator.duplicateObject(ann);
            if (dupAx.equals(ann)) continue;
            changes.add(new RemoveOntologyAnnotation(ont, ann));
            changes.add(new AddOntologyAnnotation(ont, dupAx));
        }
    }
}

