/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.library;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.protege.editor.core.PropertyUtil;
import org.protege.editor.core.ProtegeProperties;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.util.Icons;
import org.protege.editor.core.ui.view.ViewBarComponent;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.library.CatalogEntryManager;
import org.protege.editor.owl.model.library.OntologyCatalogManager;
import org.protege.editor.owl.ui.OWLIcons;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.library.AddEntryDialog;
import org.protege.editor.owl.ui.library.DeleteRedirectAction;
import org.protege.editor.owl.ui.library.EditUriAction;
import org.protege.xmlcatalog.CatalogUtilities;
import org.protege.xmlcatalog.XMLCatalog;
import org.protege.xmlcatalog.entry.Entry;
import org.protege.xmlcatalog.entry.GroupEntry;
import org.protege.xmlcatalog.entry.UriEntry;
import org.slf4j.LoggerFactory;

public class OntologyLibraryPanel
extends JPanel {
    private final OntologyLibraryCellRenderer cellRenderer = new OntologyLibraryCellRenderer();
    private XMLCatalog catalog;
    private File catalogFile;
    private JTree tree;
    private Action addLibraryAction;
    private Action removeLibraryAction;
    private Action moveLibraryUpAction;
    private Action moveLibraryDownAction;
    private DefaultMutableTreeNode rootNode;
    private List<CatalogEntryManager> entryManagers;
    private ViewBarComponent vbc;

    public OntologyLibraryPanel(List<CatalogEntryManager> entryManagers, File catalogFile) throws IOException {
        this.entryManagers = entryManagers;
        this.catalogFile = catalogFile;
        this.catalog = CatalogUtilities.parseDocument(catalogFile.toURI().toURL());
        this.createUI(catalogFile);
    }

    public static void showDialog(OWLEditorKit owlEditorKit, File catalogFile) throws IOException {
        UIHelper helper = new UIHelper(owlEditorKit);
        OntologyCatalogManager catalogManager = owlEditorKit.getOWLModelManager().getOntologyCatalogManager();
        OntologyLibraryPanel panel = new OntologyLibraryPanel(catalogManager.getCatalogEntryManagers(), catalogFile);
        if (helper.showDialog("Catalog Entries", panel) == 0) {
            try {
                CatalogUtilities.save(panel.catalog, panel.catalogFile);
                owlEditorKit.getModelManager().getOntologyCatalogManager().reloadFolder(catalogFile.getParentFile());
            }
            catch (IOException e) {
                LoggerFactory.getLogger(OntologyLibraryPanel.class).error("An error occurred whilst saving the catalog file: {}", (Throwable)e);
            }
        }
        panel.dispose();
    }

    public void dispose() {
    }

    private void createUI(File catalogFile) {
        JPanel panel = new JPanel(new BorderLayout());
        this.vbc = new ViewBarComponent("Catalog Entries", PropertyUtil.getColor((String)ProtegeProperties.getInstance().getProperty("org.protege.ontologycolor"), (Color)Color.GRAY), (JComponent)panel);
        this.vbc.getViewBar().getViewBanner().setText(catalogFile.getAbsolutePath());
        this.setLayout(new BorderLayout());
        this.add((Component)this.vbc);
        this.rootNode = new DefaultMutableTreeNode("Entries");
        this.rootNode.setUserObject(catalogFile);
        DefaultTreeModel model = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(model);
        this.tree.setRowHeight(-1);
        this.tree.setRootVisible(true);
        this.tree.setCellRenderer(this.cellRenderer);
        panel.add(ComponentFactory.createScrollPane((JComponent)this.tree));
        this.addLibraryAction = new AbstractAction("Add catalog entry...", OWLIcons.getIcon("ontology.library.add.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                OntologyLibraryPanel.this.handleAddLibrary();
            }
        };
        this.vbc.addAction(this.addLibraryAction);
        this.removeLibraryAction = new AbstractAction("Remove selected catalog entry", OWLIcons.getIcon("ontology.library.remove.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                OntologyLibraryPanel.this.handleRemoveEntry();
            }
        };
        this.vbc.addAction(this.removeLibraryAction);
        this.moveLibraryDownAction = new AbstractAction("Move catalog entry down", Icons.getIcon((String)"facet.move_down.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                OntologyLibraryPanel.this.handleMoveEntryDown();
            }
        };
        this.vbc.addAction(this.moveLibraryDownAction);
        this.moveLibraryUpAction = new AbstractAction("Move catalog entry up", Icons.getIcon((String)"facet.move_up.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                OntologyLibraryPanel.this.handleMoveEntryUp();
            }
        };
        this.vbc.addAction(this.moveLibraryUpAction);
        this.tree.getSelectionModel().addTreeSelectionListener(e -> this.updateState());
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            private void showPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    OntologyLibraryPanel.this.showPopupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }
        });
        this.reloadTree();
        this.updateState();
    }

    private void showPopupMenu(MouseEvent e) {
        TreePath selectionPath = this.tree.getSelectionPath();
        if (selectionPath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        Object o = node.getUserObject();
        if (o instanceof CatalogEntryManager) {
            return;
        }
        if (o instanceof Entry) {
            Entry entry = (Entry)o;
            JPopupMenu popupMenu = new JPopupMenu();
            if (o instanceof UriEntry) {
                popupMenu.add(new EditUriAction(this.tree, selectionPath, this.catalogFile));
            }
            popupMenu.add(new DeleteRedirectAction(this.tree, selectionPath));
            popupMenu.show(this.tree, e.getX(), e.getY());
        }
    }

    private void handleAddLibrary() {
        if (AddEntryDialog.askUserForRepository(this, this.catalog, this.entryManagers) != null) {
            this.reloadTree();
        }
    }

    private void handleRemoveEntry() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (!(node.getUserObject() instanceof Entry)) {
            return;
        }
        Entry lib = (Entry)node.getUserObject();
        this.catalog.removeEntry(lib);
        this.removeLibraryFromTree(lib);
    }

    private void handleMoveEntryUp() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (!(node.getUserObject() instanceof Entry)) {
            return;
        }
        Entry lib = (Entry)node.getUserObject();
        int i = this.catalog.getEntries().indexOf(lib);
        if (i == 0) {
            return;
        }
        this.catalog.removeEntry(lib);
        this.catalog.addEntry(i - 1, lib);
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        model.removeNodeFromParent(node);
        model.insertNodeInto(node, this.rootNode, i - 1);
        this.tree.setSelectionPath(path);
    }

    private void handleMoveEntryDown() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (!(node.getUserObject() instanceof Entry)) {
            return;
        }
        Entry lib = (Entry)node.getUserObject();
        int i = this.catalog.getEntries().indexOf(lib);
        if (i == this.catalog.getEntries().size() - 1) {
            return;
        }
        this.catalog.removeEntry(lib);
        this.catalog.addEntry(i + 1, lib);
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        model.removeNodeFromParent(node);
        model.insertNodeInto(node, this.rootNode, i + 1);
        this.tree.setSelectionPath(path);
    }

    private void updateState() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            this.removeLibraryAction.setEnabled(false);
            this.moveLibraryDownAction.setEnabled(false);
            this.moveLibraryUpAction.setEnabled(false);
            return;
        }
        Object o = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        this.removeLibraryAction.setEnabled(o instanceof Entry);
        this.moveLibraryDownAction.setEnabled(o instanceof Entry);
        this.moveLibraryUpAction.setEnabled(o instanceof Entry);
    }

    private void reloadTree() {
        this.rootNode.removeAllChildren();
        for (Entry lib : this.catalog.getEntries()) {
            this.insertLibraryIntoTree(lib);
        }
        ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(this.rootNode);
    }

    private void removeLibraryFromTree(Entry lib) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        DefaultMutableTreeNode removeNode = null;
        for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.rootNode.getChildAt(i);
            if (!node.getUserObject().equals(lib)) continue;
            removeNode = node;
            break;
        }
        if (removeNode != null) {
            model.removeNodeFromParent(removeNode);
        }
    }

    private void insertLibraryIntoTree(Entry entry) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        DefaultMutableTreeNode libNode = new DefaultMutableTreeNode(entry);
        model.insertNodeInto(libNode, this.rootNode, this.rootNode.getChildCount());
        if (entry instanceof GroupEntry) {
            for (Entry subEntry : ((GroupEntry)entry).getEntries()) {
                this.insertEntryIntoTree(libNode, subEntry);
            }
        }
        this.tree.expandPath(new TreePath(libNode.getPath()));
    }

    private void insertEntryIntoTree(DefaultMutableTreeNode parent, Entry entry) {
        if (entry instanceof UriEntry && !this.isHidden((UriEntry)entry)) {
            DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
            DefaultMutableTreeNode entryNode = new DefaultMutableTreeNode(entry);
            model.insertNodeInto(entryNode, parent, parent.getChildCount());
        }
    }

    private boolean isHidden(UriEntry entry) {
        String u = entry.getName();
        for (String ignoredScheme : CatalogEntryManager.IGNORED_SCHEMES) {
            if (!u.startsWith(ignoredScheme)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(800, 600);
    }

    private class OntologyLibraryCellRenderer
    extends DefaultTreeCellRenderer {
        private boolean hasBorder = false;

        private OntologyLibraryCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node;
            Object userObject;
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (!this.hasBorder) {
                label.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
                this.hasBorder = true;
            }
            if ((userObject = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof File) {
                label.setText("Catalog file " + ((File)userObject).getPath());
            } else if (userObject instanceof Entry) {
                boolean foundManager = false;
                Entry entry = (Entry)userObject;
                for (CatalogEntryManager entryManager : OntologyLibraryPanel.this.entryManagers) {
                    if (!entryManager.isSuitable(entry)) continue;
                    label.setText(entryManager.getDescription(entry));
                    foundManager = true;
                    break;
                }
                if (!foundManager && entry.getId() != null) {
                    label.setText("Custom entry with id = " + entry.getId());
                } else if (!foundManager) {
                    label.setText("Custom entry");
                }
            } else if (userObject instanceof String) {
                label.setText((String)userObject);
            }
            return label;
        }
    }
}

