/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.math.geom;

import com.jogamp.graph.geom.plane.AffineTransform;
import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.Matrix4f;
import com.jogamp.opengl.math.Quaternion;
import com.jogamp.opengl.math.Ray;
import com.jogamp.opengl.math.Recti;
import com.jogamp.opengl.math.Vec3f;
import com.jogamp.opengl.util.PMVMatrix;

public class AABBox {
    private static final boolean DEBUG = FloatUtil.DEBUG;
    private final Vec3f low = new Vec3f();
    private final Vec3f high = new Vec3f();
    private final Vec3f center = new Vec3f();

    public AABBox() {
        this.reset();
    }

    public AABBox(AABBox aABBox) {
        this.copy(aABBox);
    }

    public AABBox(float f, float f2, float f3, float f4, float f5, float f6) {
        this.setSize(f, f2, f3, f4, f5, f6);
    }

    public AABBox(float[] fArray, float[] fArray2) {
        this.setSize(fArray, fArray2);
    }

    public final AABBox reset() {
        this.setLow(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.setHigh(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        this.center.set(0.0f, 0.0f, 0.0f);
        return this;
    }

    public final Vec3f getHigh() {
        return this.high;
    }

    private final void setHigh(float f, float f2, float f3) {
        this.high.set(f, f2, f3);
    }

    public final Vec3f getLow() {
        return this.low;
    }

    private final void setLow(float f, float f2, float f3) {
        this.low.set(f, f2, f3);
    }

    private final void computeCenter() {
        this.center.set(this.high).add(this.low).scale(0.5f);
    }

    public final AABBox copy(AABBox aABBox) {
        this.low.set(aABBox.low);
        this.high.set(aABBox.high);
        this.center.set(aABBox.center);
        return this;
    }

    public final AABBox setSize(float[] fArray, float[] fArray2) {
        return this.setSize(fArray[0], fArray[1], fArray[2], fArray2[0], fArray2[1], fArray2[2]);
    }

    public final AABBox setSize(float f, float f2, float f3, float f4, float f5, float f6) {
        this.low.set(f, f2, f3);
        this.high.set(f4, f5, f6);
        this.computeCenter();
        return this;
    }

    public final AABBox setSize(Vec3f vec3f, Vec3f vec3f2) {
        this.low.set(vec3f);
        this.high.set(vec3f2);
        this.computeCenter();
        return this;
    }

    public final AABBox resize(AABBox aABBox) {
        Vec3f vec3f = aABBox.getLow();
        Vec3f vec3f2 = aABBox.getHigh();
        if (vec3f.x() < this.low.x()) {
            this.low.setX(vec3f.x());
        }
        if (vec3f.y() < this.low.y()) {
            this.low.setY(vec3f.y());
        }
        if (vec3f.z() < this.low.z()) {
            this.low.setZ(vec3f.z());
        }
        if (vec3f2.x() > this.high.x()) {
            this.high.setX(vec3f2.x());
        }
        if (vec3f2.y() > this.high.y()) {
            this.high.setY(vec3f2.y());
        }
        if (vec3f2.z() > this.high.z()) {
            this.high.setZ(vec3f2.z());
        }
        this.computeCenter();
        return this;
    }

    public final AABBox resize(AABBox aABBox, AffineTransform affineTransform, Vec3f vec3f) {
        Vec3f vec3f2 = aABBox.getLow();
        affineTransform.transform(vec3f2, vec3f);
        if (vec3f.x() < this.low.x()) {
            this.low.setX(vec3f.x());
        }
        if (vec3f.y() < this.low.y()) {
            this.low.setY(vec3f.y());
        }
        if (vec3f.z() < this.low.z()) {
            this.low.setZ(vec3f.z());
        }
        vec3f2 = aABBox.getHigh();
        affineTransform.transform(vec3f2, vec3f);
        if (vec3f.x() > this.high.x()) {
            this.high.setX(vec3f.x());
        }
        if (vec3f.y() > this.high.y()) {
            this.high.setY(vec3f.y());
        }
        if (vec3f.z() > this.high.z()) {
            this.high.setZ(vec3f.z());
        }
        this.computeCenter();
        return this;
    }

    public final AABBox resize(float f, float f2, float f3) {
        if (f < this.low.x()) {
            this.low.setX(f);
        }
        if (f2 < this.low.y()) {
            this.low.setY(f2);
        }
        if (f3 < this.low.z()) {
            this.low.setZ(f3);
        }
        if (f > this.high.x()) {
            this.high.setX(f);
        }
        if (f2 > this.high.y()) {
            this.high.setY(f2);
        }
        if (f3 > this.high.z()) {
            this.high.setZ(f3);
        }
        this.computeCenter();
        return this;
    }

    public final AABBox resize(float[] fArray, int n) {
        return this.resize(fArray[0 + n], fArray[1 + n], fArray[2 + n]);
    }

    public final AABBox resize(float[] fArray) {
        return this.resize(fArray[0], fArray[1], fArray[2]);
    }

    public final AABBox resize(Vec3f vec3f) {
        return this.resize(vec3f.x(), vec3f.y(), vec3f.z());
    }

    public final boolean contains(float f, float f2) {
        if (f < this.low.x() || f > this.high.x()) {
            return false;
        }
        return !(f2 < this.low.y()) && !(f2 > this.high.y());
    }

    public final boolean contains(float f, float f2, float f3) {
        if (f < this.low.x() || f > this.high.x()) {
            return false;
        }
        if (f2 < this.low.y() || f2 > this.high.y()) {
            return false;
        }
        return !(f3 < this.low.z()) && !(f3 > this.high.z());
    }

    public final boolean intersects2DRegion(float f, float f2, float f3, float f4) {
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return false;
        }
        float f5 = this.getWidth();
        float f6 = this.getHeight();
        if (f5 <= 0.0f || f6 <= 0.0f) {
            return false;
        }
        float f7 = this.getMinX();
        float f8 = this.getMinY();
        return f + f3 > f7 && f2 + f4 > f8 && f < f7 + f5 && f2 < f8 + f6;
    }

    public final boolean intersectsRay(Ray ray) {
        float f = ray.dir.x();
        float f2 = ray.orig.x() - this.center.x();
        float f3 = this.high.x() - this.center.x();
        if (Math.abs(f2) > f3 && f2 * f >= 0.0f) {
            return false;
        }
        float f4 = ray.dir.y();
        float f5 = ray.orig.y() - this.center.y();
        float f6 = this.high.y() - this.center.y();
        if (Math.abs(f5) > f6 && f5 * f4 >= 0.0f) {
            return false;
        }
        float f7 = ray.dir.z();
        float f8 = ray.orig.z() - this.center.z();
        float f9 = this.high.z() - this.center.z();
        if (Math.abs(f8) > f9 && f8 * f7 >= 0.0f) {
            return false;
        }
        float f10 = Math.abs(f4);
        float f11 = Math.abs(f7);
        float f12 = f4 * f8 - f7 * f5;
        if (Math.abs(f12) > f6 * f11 + f9 * f10) {
            return false;
        }
        float f13 = Math.abs(f);
        f12 = f7 * f2 - f * f8;
        if (Math.abs(f12) > f3 * f11 + f9 * f13) {
            return false;
        }
        f12 = f * f5 - f4 * f2;
        return !(Math.abs(f12) > f3 * f10 + f6 * f13);
    }

    public final Vec3f getRayIntersection(Vec3f vec3f, Ray ray, float f, boolean bl) {
        block23: {
            int n;
            Vec3f vec3f2;
            Vec3f vec3f3;
            float[] fArray;
            block22: {
                fArray = new float[]{-1.0f, -1.0f, -1.0f};
                vec3f3 = ray.orig;
                vec3f2 = ray.dir;
                boolean bl2 = true;
                for (n = 0; n < 3; ++n) {
                    float f2 = vec3f3.get(n);
                    float f3 = vec3f2.get(n);
                    float f4 = this.low.get(n);
                    float f5 = this.high.get(n);
                    if (f2 < f4) {
                        vec3f.set(n, f4);
                        bl2 = false;
                        if (0 == Float.floatToIntBits(f3)) continue;
                        fArray[n] = (f4 - f2) / f3;
                        continue;
                    }
                    if (!(f2 > f5)) continue;
                    vec3f.set(n, f5);
                    bl2 = false;
                    if (0 == Float.floatToIntBits(f3)) continue;
                    fArray[n] = (f5 - f2) / f3;
                }
                if (bl2) {
                    vec3f.set(vec3f3);
                    return vec3f;
                }
                n = 0;
                if (fArray[1] > fArray[n]) {
                    n = 1;
                }
                if (fArray[2] > fArray[n]) {
                    n = 2;
                }
                if (bl) break block22;
                if (0 != (Float.floatToIntBits(fArray[n]) & Integer.MIN_VALUE)) {
                    return null;
                }
                switch (n) {
                    case 0: {
                        vec3f.setY(vec3f3.y() + fArray[n] * vec3f2.y());
                        if (vec3f.y() < this.low.y() - f || vec3f.y() > this.high.y() + f) {
                            return null;
                        }
                        vec3f.setZ(vec3f3.z() + fArray[n] * vec3f2.z());
                        if (vec3f.z() < this.low.z() - f || vec3f.z() > this.high.z() + f) {
                            return null;
                        }
                        break block23;
                    }
                    case 1: {
                        vec3f.setX(vec3f3.x() + fArray[n] * vec3f2.x());
                        if (vec3f.x() < this.low.x() - f || vec3f.x() > this.high.x() + f) {
                            return null;
                        }
                        vec3f.setZ(vec3f3.z() + fArray[n] * vec3f2.z());
                        if (vec3f.z() < this.low.z() - f || vec3f.z() > this.high.z() + f) {
                            return null;
                        }
                        break block23;
                    }
                    case 2: {
                        vec3f.setX(vec3f3.x() + fArray[n] * vec3f2.x());
                        if (vec3f.x() < this.low.x() - f || vec3f.x() > this.high.x() + f) {
                            return null;
                        }
                        vec3f.setY(vec3f3.y() + fArray[n] * vec3f2.y());
                        if (vec3f.y() < this.low.y() - f || vec3f.y() > this.high.y() + f) {
                            return null;
                        }
                        break block23;
                    }
                    default: {
                        throw new InternalError("XXX");
                    }
                }
            }
            switch (n) {
                case 0: {
                    vec3f.setY(vec3f3.y() + fArray[n] * vec3f2.y());
                    vec3f.setZ(vec3f3.z() + fArray[n] * vec3f2.z());
                    break;
                }
                case 1: {
                    vec3f.setX(vec3f3.x() + fArray[n] * vec3f2.x());
                    vec3f.setZ(vec3f3.z() + fArray[n] * vec3f2.z());
                    break;
                }
                case 2: {
                    vec3f.setX(vec3f3.x() + fArray[n] * vec3f2.x());
                    vec3f.setY(vec3f3.y() + fArray[n] * vec3f2.y());
                    break;
                }
                default: {
                    throw new InternalError("XXX");
                }
            }
        }
        return vec3f;
    }

    public final float getSize() {
        return this.low.dist(this.high);
    }

    public final Vec3f getCenter() {
        return this.center;
    }

    public final AABBox scale(float f) {
        Vec3f vec3f = new Vec3f();
        vec3f.set(this.high).sub(this.center).scale(f);
        this.high.set(this.center).add(vec3f);
        vec3f.set(this.low).sub(this.center).scale(f);
        this.low.set(this.center).add(vec3f);
        return this;
    }

    public final AABBox scale2(float f) {
        this.high.scale(f);
        this.low.scale(f);
        this.computeCenter();
        return this;
    }

    public final AABBox translate(float f, float f2, float f3) {
        this.low.add(f, f2, f3);
        this.high.add(f, f2, f3);
        this.computeCenter();
        return this;
    }

    public final AABBox translate(Vec3f vec3f) {
        this.low.add(vec3f);
        this.high.add(vec3f);
        this.computeCenter();
        return this;
    }

    public final AABBox rotate(Quaternion quaternion) {
        quaternion.rotateVector(this.low, this.low);
        quaternion.rotateVector(this.high, this.high);
        this.computeCenter();
        return this;
    }

    public final float getMinX() {
        return this.low.x();
    }

    public final float getMinY() {
        return this.low.y();
    }

    public final float getMinZ() {
        return this.low.z();
    }

    public final float getMaxX() {
        return this.high.x();
    }

    public final float getMaxY() {
        return this.high.y();
    }

    public final float getMaxZ() {
        return this.high.z();
    }

    public final float getWidth() {
        return this.high.x() - this.low.x();
    }

    public final float getHeight() {
        return this.high.y() - this.low.y();
    }

    public final float getDepth() {
        return this.high.z() - this.low.z();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (null == object || !(object instanceof AABBox)) {
            return false;
        }
        AABBox aABBox = (AABBox)object;
        return this.low.isEqual(aABBox.low) && this.high.isEqual(aABBox.high);
    }

    public final int hashCode() {
        throw new InternalError("hashCode not designed");
    }

    public AABBox transform(Matrix4f matrix4f, AABBox aABBox) {
        Vec3f vec3f = new Vec3f();
        aABBox.reset();
        aABBox.resize(matrix4f.mulVec3f(this.low, vec3f));
        aABBox.resize(matrix4f.mulVec3f(this.high, vec3f));
        aABBox.computeCenter();
        return aABBox;
    }

    public AABBox transformMv(PMVMatrix pMVMatrix, AABBox aABBox) {
        Vec3f vec3f = new Vec3f();
        aABBox.reset();
        aABBox.resize(pMVMatrix.mulMvMatVec3f(this.low, vec3f));
        aABBox.resize(pMVMatrix.mulMvMatVec3f(this.high, vec3f));
        aABBox.computeCenter();
        return aABBox;
    }

    public AABBox mapToWindow(AABBox aABBox, Matrix4f matrix4f, Recti recti, boolean bl) {
        Vec3f vec3f = new Vec3f();
        Vec3f vec3f2 = new Vec3f();
        float f = bl ? this.center.z() : this.getMinZ();
        aABBox.reset();
        Matrix4f.mapObjToWin(vec3f.set(this.getMinX(), this.getMinY(), f), matrix4f, recti, vec3f2);
        aABBox.resize(vec3f2);
        Matrix4f.mapObjToWin(vec3f.set(this.getMinX(), this.getMaxY(), f), matrix4f, recti, vec3f2);
        aABBox.resize(vec3f2);
        Matrix4f.mapObjToWin(vec3f.set(this.getMaxX(), this.getMaxY(), f), matrix4f, recti, vec3f2);
        aABBox.resize(vec3f2);
        Matrix4f.mapObjToWin(vec3f.set(this.getMaxX(), this.getMinY(), f), matrix4f, recti, vec3f2);
        aABBox.resize(vec3f2);
        if (!bl) {
            f = this.getMaxZ();
            Matrix4f.mapObjToWin(vec3f.set(this.getMinX(), this.getMinY(), f), matrix4f, recti, vec3f2);
            aABBox.resize(vec3f2);
            Matrix4f.mapObjToWin(vec3f.set(this.getMinX(), this.getMaxY(), f), matrix4f, recti, vec3f2);
            aABBox.resize(vec3f2);
            Matrix4f.mapObjToWin(vec3f.set(this.getMaxX(), this.getMaxY(), f), matrix4f, recti, vec3f2);
            aABBox.resize(vec3f2);
            Matrix4f.mapObjToWin(vec3f.set(this.getMaxX(), this.getMinY(), f), matrix4f, recti, vec3f2);
            aABBox.resize(vec3f2);
        }
        if (DEBUG) {
            System.err.printf("AABBox.mapToWindow: view[%s], this %s -> %s%n", recti, this.toString(), aABBox.toString());
        }
        return aABBox;
    }

    public final String toString() {
        return "[dim " + this.getWidth() + " x " + this.getHeight() + " x " + this.getDepth() + ", box " + this.low + " .. " + this.high + ", ctr " + this.center + "]";
    }
}

