/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.graalvm.visualvm.lib.profiler.Bundle;
import org.graalvm.visualvm.lib.profiler.LoadedSnapshot;
import org.graalvm.visualvm.lib.profiler.SnapshotInfoPanel;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;

class SnapshotInfoAction
extends AbstractAction {
    private final LoadedSnapshot snapshot;

    SnapshotInfoAction(LoadedSnapshot snapshot) {
        this.putValue("Name", Bundle.SnapshotInfoAction_ActionName());
        this.putValue("ShortDescription", Bundle.SnapshotInfoAction_ActionDescr());
        this.putValue("SmallIcon", Icons.getIcon((String)"GeneralIcons.Info"));
        this.putValue("iconBase", Icons.getResource((String)"GeneralIcons.Info"));
        this.snapshot = snapshot;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        HelpCtx helpCtx = new HelpCtx("SnapshotInfo.HelpCtx");
        DialogDescriptor dd = new DialogDescriptor((Object)new SnapshotInfoPanel(this.snapshot), Bundle.SnapshotInfoAction_WindowCaption(), true, new Object[]{DialogDescriptor.OK_OPTION}, DialogDescriptor.OK_OPTION, 0, helpCtx, null);
        DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
    }
}

