/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.instrumentation;

import java.io.IOException;
import java.util.ArrayList;
import org.graalvm.visualvm.lib.jfluid.ProfilerEngineSettings;
import org.graalvm.visualvm.lib.jfluid.classfile.BaseClassInfo;
import org.graalvm.visualvm.lib.jfluid.classfile.ClassRepository;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.client.RuntimeProfilingPoint;
import org.graalvm.visualvm.lib.jfluid.filters.InstrumentationFilter;
import org.graalvm.visualvm.lib.jfluid.global.CommonConstants;
import org.graalvm.visualvm.lib.jfluid.global.ProfilingSessionStatus;
import org.graalvm.visualvm.lib.jfluid.instrumentation.BadLocationException;
import org.graalvm.visualvm.lib.jfluid.instrumentation.CodeRegionMethodInstrumentor;
import org.graalvm.visualvm.lib.jfluid.instrumentation.MemoryProfMethodInstrumentor;
import org.graalvm.visualvm.lib.jfluid.instrumentation.MiscInstrumentationOps;
import org.graalvm.visualvm.lib.jfluid.instrumentation.ObjLivenessMethodInstrumentor;
import org.graalvm.visualvm.lib.jfluid.instrumentation.RecursiveMethodInstrumentor;
import org.graalvm.visualvm.lib.jfluid.instrumentation.RecursiveMethodInstrumentor1;
import org.graalvm.visualvm.lib.jfluid.instrumentation.RecursiveMethodInstrumentor2;
import org.graalvm.visualvm.lib.jfluid.instrumentation.RecursiveMethodInstrumentor3;
import org.graalvm.visualvm.lib.jfluid.instrumentation.RootMethods;
import org.graalvm.visualvm.lib.jfluid.utils.StringUtils;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.ClassLoadedCommand;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.Command;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.InstrumentMethodGroupCommand;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.InstrumentMethodGroupResponse;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.MethodInvokedFirstTimeCommand;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.MethodLoadedCommand;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.RootClassLoadedCommand;

public class Instrumentor
implements CommonConstants {
    private static final boolean DEBUG = System.getProperty("org.graalvm.visualvm.lib.jfluid.instrumentation.Instrumentor") != null;
    private CodeRegionMethodInstrumentor crms;
    private MemoryProfMethodInstrumentor oms;
    private ProfilerEngineSettings settings;
    private ProfilingSessionStatus status;
    private RecursiveMethodInstrumentor ms;
    private RootMethods rootMethods;
    private ClassRepository classRepo;
    private ClientUtils.SourceCodeSelection savedSourceCodeSelection;

    public Instrumentor(ClassRepository repo, ProfilingSessionStatus status, ProfilerEngineSettings settings) {
        this.status = status;
        this.settings = settings;
        this.classRepo = repo;
    }

    public int getClassId(String className, int classLoaderId) {
        BaseClassInfo clazz;
        InstrumentationFilter filter = this.settings.getInstrumentationFilter();
        if (className.charAt(0) == '[') {
            String filterName;
            if (className.endsWith(";")) {
                int elIndex = className.indexOf(76);
                className = new StringBuffer(className).deleteCharAt(className.length() - 1).deleteCharAt(elIndex).toString();
            }
            if (!filter.passes((filterName = StringUtils.userFormClassName(className)).replace('.', '/'))) {
                return -1;
            }
            clazz = this.classRepo.lookupSpecialClass(className);
            if (clazz.getInstrClassId() == -1) {
                clazz.setInstrClassId(this.oms.getNextClassId(className));
            }
        } else {
            if (!filter.passes(className.replace('.', '/'))) {
                return -1;
            }
            clazz = this.classRepo.lookupClassOrCreatePlaceholder(className, classLoaderId);
        }
        if (clazz == null) {
            System.err.println("Warning: could not find class " + className + " loaded by the VM on the class path");
            return -1;
        }
        if (clazz.getInstrClassId() == -1) {
            System.err.println("Warning: " + clazz.getNameAndLoader() + " does not have instrClassId");
        }
        return clazz.getInstrClassId();
    }

    public synchronized InstrumentMethodGroupCommand getCommandToUnprofileClasses(boolean[] unprofiledClassStatusArray) {
        ObjLivenessMethodInstrumentor olms = (ObjLivenessMethodInstrumentor)this.oms;
        Object[] ret = olms.getMethodsToInstrumentUponClassUnprofiling(unprofiledClassStatusArray);
        if (ret == null) {
            return new InstrumentMethodGroupCommand(null);
        }
        return new InstrumentMethodGroupCommand(6, (String[])ret[0], (int[])ret[1], (byte[][])ret[2], null, this.oms.getNInstantiatableClasses());
    }

    public String[] getRootClassNames() {
        ArrayList<String> rootClassNames = this.rootMethods.getRootClassNames();
        RuntimeProfilingPoint[] pps = this.settings.getRuntimeProfilingPoints();
        if (rootClassNames == null && pps.length > 0) {
            rootClassNames = new ArrayList<String>();
        }
        for (RuntimeProfilingPoint pp : pps) {
            String className = pp.getClassName();
            if (rootClassNames.contains(className)) continue;
            rootClassNames.add(className);
        }
        if (rootClassNames == null) {
            return null;
        }
        return rootClassNames.toArray(new String[0]);
    }

    public void setSavedSourceCodeSelection(ClientUtils.SourceCodeSelection[] s) {
        this.savedSourceCodeSelection = s[0];
    }

    public void setStatusInfoFromSourceCodeSelection(ClientUtils.SourceCodeSelection[] s) throws ClassNotFoundException, BadLocationException, IOException, ClassFormatError {
        ClientUtils.SourceCodeSelection sel;
        if (s.length > 0 && (sel = s[0]).definedViaSourceLines()) {
            this.status.instrStartLine = sel.getStartLine();
            this.status.instrEndLine = sel.getEndLine();
        }
        this.rootMethods = new RootMethods(s);
    }

    public synchronized InstrumentMethodGroupCommand createClearAllInstrumentationCommand() {
        Object[] ret = null;
        switch (this.status.currentInstrType) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.ms = null;
                ret = new MiscInstrumentationOps(this.classRepo, this.status).getOrigCodeForAllInstrumentedMethods();
                break;
            }
            case 1: {
                ret = new MiscInstrumentationOps(this.classRepo, this.status).getOrigCodeForSingleInstrumentedMethod(this.rootMethods);
            }
        }
        this.ms = null;
        this.oms = null;
        this.crms = null;
        if (ret == null) {
            return new InstrumentMethodGroupCommand(null);
        }
        return new InstrumentMethodGroupCommand(0, (String[])ret[0], (int[])ret[1], (byte[][])ret[2], null, 0);
    }

    public synchronized InstrumentMethodGroupResponse createFollowUpInstrumentMethodGroupResponse(Command cmd) {
        if (cmd instanceof ClassLoadedCommand) {
            byte[] classFileBytes;
            ClassLoadedCommand clcmd = (ClassLoadedCommand)cmd;
            int[] thisAndParentLoaderData = clcmd.getThisAndParentLoaderData();
            if (DEBUG) {
                System.err.println("Instrumentor.DEBUG: Class loaded command: " + cmd.toString());
            }
            if ((classFileBytes = clcmd.getClassFileBytes()) != null) {
                this.classRepo.addVMSuppliedClassFile(clcmd.getClassName().replace('.', '/'), thisAndParentLoaderData[0], classFileBytes);
            }
            this.classRepo.getClassPath().getClassLoaderTable().addChildAndParent(thisAndParentLoaderData);
        } else if (cmd instanceof MethodLoadedCommand) {
            MethodLoadedCommand mcmd = (MethodLoadedCommand)cmd;
            if (DEBUG) {
                System.err.println("Instrumentor.DEBUG: Method loaded command: " + mcmd.toString());
            }
        }
        InstrumentMethodGroupResponse imgr = null;
        switch (this.status.currentInstrType) {
            case 3: 
            case 4: {
                imgr = this.createFollowUpInstrumentMethodGroupResponseForCallGraph(cmd);
                break;
            }
            case 1: {
                if (!(cmd instanceof ClassLoadedCommand)) {
                    return new InstrumentMethodGroupResponse((Object)null);
                }
                imgr = this.createFollowUpInstrumentMethodGroupResponseForCodeRegion((ClassLoadedCommand)cmd);
                break;
            }
            case 5: 
            case 6: {
                if (!(cmd instanceof ClassLoadedCommand)) {
                    return new InstrumentMethodGroupResponse((Object)null);
                }
                imgr = this.createFollowUpInstrumentMethodGroupResponseForMemoryProfiling((ClassLoadedCommand)cmd);
                break;
            }
            default: {
                imgr = new InstrumentMethodGroupResponse((Object)null);
            }
        }
        return imgr;
    }

    public synchronized InstrumentMethodGroupResponse createInitialInstrumentMethodGroupResponse(RootClassLoadedCommand cmd) throws ClassNotFoundException, BadLocationException {
        this.classRepo.getClassPath().getClassLoaderTable().initTable(cmd.getParentLoaderIds());
        InstrumentMethodGroupResponse imgr = null;
        switch (this.status.currentInstrType) {
            case 3: 
            case 4: {
                imgr = this.createInitialInstrumentMethodGroupResponseForCallGraph(cmd);
                break;
            }
            case 1: {
                imgr = this.createInitialInstrumentMethodGroupResponseForCodeRegion(cmd);
                break;
            }
            case 5: 
            case 6: {
                imgr = this.createInitialInstrumentMethodGroupResponseForMemoryProfiling(this.status.currentInstrType, cmd);
                break;
            }
            default: {
                System.err.println("*** Profiler engine warning: Instrumentor.createInitialInstrumentMethodGroupResponse() called with INSTR_NONE?");
                System.err.println("*** Please report this problem to feedback@profiler.netbeans.org");
                imgr = new InstrumentMethodGroupResponse((Object)null);
            }
        }
        return imgr;
    }

    public void resetPerVMInstanceData() {
        this.classRepo.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstrumentMethodGroupResponse createFollowUpInstrumentMethodGroupResponseForCallGraph(Command cmd) {
        Object[] ret = null;
        if (this.ms == null) {
            return new InstrumentMethodGroupResponse((Object)null);
        }
        if (cmd instanceof MethodInvokedFirstTimeCommand) {
            int id = ((MethodInvokedFirstTimeCommand)cmd).getMethodId();
            this.status.beginTrans(false);
            try {
                if (id >= this.status.getInstrMethodClasses().length || this.status.getInstrMethodClasses()[id] == null) {
                    InstrumentMethodGroupResponse instrumentMethodGroupResponse = new InstrumentMethodGroupResponse((Object)null);
                    return instrumentMethodGroupResponse;
                }
                ret = this.ms.getMethodsToInstrumentUponMethodInvocation(this.status.getInstrMethodClasses()[id], this.status.getClassLoaderIds()[id], this.status.getInstrMethodNames()[id], this.status.getInstrMethodSignatures()[id]);
            }
            finally {
                this.status.endTrans();
            }
        } else if (cmd instanceof ClassLoadedCommand) {
            ClassLoadedCommand ccmd = (ClassLoadedCommand)cmd;
            ret = this.ms.getMethodsToInstrumentUponClassLoad(ccmd.getClassName(), ccmd.getThisAndParentLoaderData()[0], ccmd.getThreadInCallGraph());
        } else if (cmd instanceof MethodLoadedCommand) {
            MethodLoadedCommand mcmd = (MethodLoadedCommand)cmd;
            ret = this.ms.getMethodsToInstrumentUponReflectInvoke(mcmd.getClassName(), mcmd.getClassLoaderId(), mcmd.getMethodName(), mcmd.getMethodSignature());
        }
        if (ret == null) {
            return new InstrumentMethodGroupResponse((Object)null);
        }
        return new InstrumentMethodGroupResponse((String[])ret[0], (int[])ret[1], (byte[][])ret[3], (boolean[])ret[2], 0);
    }

    private InstrumentMethodGroupResponse createFollowUpInstrumentMethodGroupResponseForCodeRegion(ClassLoadedCommand cmd) {
        if (this.crms == null) {
            return new InstrumentMethodGroupResponse((Object)null);
        }
        Object[] ret = this.crms.getFollowUpInstrumentCodeRegionResponse(cmd.getThisAndParentLoaderData()[0]);
        if (ret == null) {
            return new InstrumentMethodGroupResponse((Object)null);
        }
        return new InstrumentMethodGroupResponse((String[])ret[0], (int[])ret[1], (byte[][])ret[2], null, 0);
    }

    private InstrumentMethodGroupResponse createFollowUpInstrumentMethodGroupResponseForMemoryProfiling(ClassLoadedCommand cmd) {
        if (this.oms == null) {
            return new InstrumentMethodGroupResponse((Object)null);
        }
        Object[] ret = this.oms.getMethodsToInstrumentUponClassLoad(cmd.getClassName(), cmd.getThisAndParentLoaderData()[0]);
        if (ret == null) {
            return new InstrumentMethodGroupResponse((Object)null);
        }
        int maxInstrClassId = this.status.getNInstrClasses();
        return new InstrumentMethodGroupResponse((String[])ret[0], (int[])ret[1], (byte[][])ret[2], null, maxInstrClassId);
    }

    private InstrumentMethodGroupResponse createInitialInstrumentMethodGroupResponseForCallGraph(RootClassLoadedCommand rootLoaded) {
        switch (this.settings.getInstrScheme()) {
            case 1: {
                this.ms = new RecursiveMethodInstrumentor1(this.classRepo, this.status, this.settings);
                break;
            }
            case 2: {
                this.ms = new RecursiveMethodInstrumentor2(this.classRepo, this.status, this.settings);
                break;
            }
            case 3: {
                this.ms = new RecursiveMethodInstrumentor3(this.classRepo, this.status, this.settings);
            }
        }
        Object[] ret = this.ms.getInitialMethodsToInstrument(rootLoaded, this.rootMethods);
        if (ret == null) {
            return new InstrumentMethodGroupResponse((Object)null);
        }
        return new InstrumentMethodGroupResponse((String[])ret[0], (int[])ret[1], (byte[][])ret[3], (boolean[])ret[2], 0);
    }

    private InstrumentMethodGroupResponse createInitialInstrumentMethodGroupResponseForCodeRegion(RootClassLoadedCommand rootLoaded) throws ClassNotFoundException, BadLocationException {
        this.classRepo.clearCache();
        this.crms = new CodeRegionMethodInstrumentor(this.classRepo, this.status, this.savedSourceCodeSelection);
        Object[] ret = this.crms.getInitialInstrumentCodeRegionResponse(rootLoaded);
        if (ret == null) {
            return new InstrumentMethodGroupResponse((Object)null);
        }
        return new InstrumentMethodGroupResponse((String[])ret[0], (int[])ret[1], (byte[][])ret[2], null, 0);
    }

    private InstrumentMethodGroupResponse createInitialInstrumentMethodGroupResponseForMemoryProfiling(int instrType, RootClassLoadedCommand rootLoaded) {
        this.oms = new ObjLivenessMethodInstrumentor(this.classRepo, this.status, this.settings, instrType == 6);
        Object[] ret = this.oms.getInitialMethodsToInstrument(rootLoaded);
        if (ret == null) {
            return new InstrumentMethodGroupResponse((Object)null);
        }
        int maxInstrClassId = this.oms.getNInstantiatableClasses() + this.status.getNInstrClasses();
        return new InstrumentMethodGroupResponse((String[])ret[0], (int[])ret[1], (byte[][])ret[2], null, maxInstrClassId);
    }
}

