﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cleanrooms/CleanRoomsRequest.h>
#include <aws/cleanrooms/CleanRooms_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace CleanRooms {
namespace Model {

/**
 */
class GetCollaborationConfiguredAudienceModelAssociationRequest : public CleanRoomsRequest {
 public:
  AWS_CLEANROOMS_API GetCollaborationConfiguredAudienceModelAssociationRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetCollaborationConfiguredAudienceModelAssociation"; }

  AWS_CLEANROOMS_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>A unique identifier for the collaboration that the configured audience model
   * association belongs to. Accepts a collaboration ID.</p>
   */
  inline const Aws::String& GetCollaborationIdentifier() const { return m_collaborationIdentifier; }
  inline bool CollaborationIdentifierHasBeenSet() const { return m_collaborationIdentifierHasBeenSet; }
  template <typename CollaborationIdentifierT = Aws::String>
  void SetCollaborationIdentifier(CollaborationIdentifierT&& value) {
    m_collaborationIdentifierHasBeenSet = true;
    m_collaborationIdentifier = std::forward<CollaborationIdentifierT>(value);
  }
  template <typename CollaborationIdentifierT = Aws::String>
  GetCollaborationConfiguredAudienceModelAssociationRequest& WithCollaborationIdentifier(CollaborationIdentifierT&& value) {
    SetCollaborationIdentifier(std::forward<CollaborationIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A unique identifier for the configured audience model association that you
   * want to retrieve.</p>
   */
  inline const Aws::String& GetConfiguredAudienceModelAssociationIdentifier() const {
    return m_configuredAudienceModelAssociationIdentifier;
  }
  inline bool ConfiguredAudienceModelAssociationIdentifierHasBeenSet() const {
    return m_configuredAudienceModelAssociationIdentifierHasBeenSet;
  }
  template <typename ConfiguredAudienceModelAssociationIdentifierT = Aws::String>
  void SetConfiguredAudienceModelAssociationIdentifier(ConfiguredAudienceModelAssociationIdentifierT&& value) {
    m_configuredAudienceModelAssociationIdentifierHasBeenSet = true;
    m_configuredAudienceModelAssociationIdentifier = std::forward<ConfiguredAudienceModelAssociationIdentifierT>(value);
  }
  template <typename ConfiguredAudienceModelAssociationIdentifierT = Aws::String>
  GetCollaborationConfiguredAudienceModelAssociationRequest& WithConfiguredAudienceModelAssociationIdentifier(
      ConfiguredAudienceModelAssociationIdentifierT&& value) {
    SetConfiguredAudienceModelAssociationIdentifier(std::forward<ConfiguredAudienceModelAssociationIdentifierT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_collaborationIdentifier;
  bool m_collaborationIdentifierHasBeenSet = false;

  Aws::String m_configuredAudienceModelAssociationIdentifier;
  bool m_configuredAudienceModelAssociationIdentifierHasBeenSet = false;
};

}  // namespace Model
}  // namespace CleanRooms
}  // namespace Aws
