﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ssm/SSM_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SSM {
namespace Model {
class PutResourcePolicyResult {
 public:
  AWS_SSM_API PutResourcePolicyResult() = default;
  AWS_SSM_API PutResourcePolicyResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SSM_API PutResourcePolicyResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The policy ID. To update a policy, you must specify <code>PolicyId</code> and
   * <code>PolicyHash</code>.</p>
   */
  inline const Aws::String& GetPolicyId() const { return m_policyId; }
  template <typename PolicyIdT = Aws::String>
  void SetPolicyId(PolicyIdT&& value) {
    m_policyIdHasBeenSet = true;
    m_policyId = std::forward<PolicyIdT>(value);
  }
  template <typename PolicyIdT = Aws::String>
  PutResourcePolicyResult& WithPolicyId(PolicyIdT&& value) {
    SetPolicyId(std::forward<PolicyIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>ID of the current policy version.</p>
   */
  inline const Aws::String& GetPolicyHash() const { return m_policyHash; }
  template <typename PolicyHashT = Aws::String>
  void SetPolicyHash(PolicyHashT&& value) {
    m_policyHashHasBeenSet = true;
    m_policyHash = std::forward<PolicyHashT>(value);
  }
  template <typename PolicyHashT = Aws::String>
  PutResourcePolicyResult& WithPolicyHash(PolicyHashT&& value) {
    SetPolicyHash(std::forward<PolicyHashT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  PutResourcePolicyResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_policyId;
  bool m_policyIdHasBeenSet = false;

  Aws::String m_policyHash;
  bool m_policyHashHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SSM
}  // namespace Aws
