/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.track;

import com.google.earth.kml._2.DocumentType;
import com.google.earth.kml._2.FolderType;
import com.google.earth.kml._2.KmlType;
import com.google.earth.kml._2.LineStringType;
import com.google.earth.kml._2.LineStyleType;
import com.google.earth.kml._2.ObjectFactory;
import com.google.earth.kml._2.PlacemarkType;
import com.google.earth.kml._2.StyleType;
import com.topografix.gpx._1._0.Gpx;
import java.util.List;

public class KmlTransformer {
    public KmlType transform(Gpx gpx) {
        ObjectFactory objectFactory = new ObjectFactory();
        KmlType kmlType = objectFactory.createKmlType();
        DocumentType document = objectFactory.createDocumentType();
        document.setName("Geotag");
        StyleType style = objectFactory.createStyleType();
        style.setId("linestyle");
        LineStyleType lineStyle = objectFactory.createLineStyleType();
        byte[] colour = new byte[]{100, -18, -18, 23};
        lineStyle.setColor(colour);
        Float linewidth = new Float(6.0f);
        lineStyle.setWidth(linewidth);
        style.setLineStyle(lineStyle);
        document.getStyleSelector().add(objectFactory.createStyle(style));
        for (Gpx.Trk track : gpx.getTrk()) {
            FolderType tracksFolder = objectFactory.createFolderType();
            tracksFolder.setName(track.getName());
            PlacemarkType placemark = objectFactory.createPlacemarkType();
            placemark.setName("Path");
            placemark.setStyleUrl("#linestyle");
            LineStringType lineString = objectFactory.createLineStringType();
            lineString.setTessellate(true);
            List<String> coordinates = lineString.getCoordinates();
            for (Gpx.Trk.Trkseg segment : track.getTrkseg()) {
                for (Gpx.Trk.Trkseg.Trkpt trackPoint : segment.getTrkpt()) {
                    String string = trackPoint.getLon() + "," + trackPoint.getLat() + "," + trackPoint.getEle();
                    coordinates.add(string);
                }
            }
            placemark.setGeometry(objectFactory.createLineString(lineString));
            tracksFolder.getFeature().add(objectFactory.createPlacemark(placemark));
            document.getFeature().add(objectFactory.createFolder(tracksFolder));
        }
        kmlType.setFeature(objectFactory.createDocument(document));
        return kmlType;
    }
}

