"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReadonlyService = void 0;
var _url = require("url");
var _common = require("../../common");
var _readonly_service = require("../../../../src/core/server/security/readonly_service");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          *   Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          *   Licensed under the Apache License, Version 2.0 (the "License").
                                                                                                                                                                                                                                                                                                                          *   You may not use this file except in compliance with the License.
                                                                                                                                                                                                                                                                                                                          *   A copy of the License is located at
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          *       http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          *   or in the "license" file accompanying this file. This file is distributed
                                                                                                                                                                                                                                                                                                                          *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
                                                                                                                                                                                                                                                                                                                          *   express or implied. See the License for the specific language governing
                                                                                                                                                                                                                                                                                                                          *   permissions and limitations under the License.
                                                                                                                                                                                                                                                                                                                          */
class ReadonlyService extends _readonly_service.ReadonlyService {
  constructor(logger, securityClient, auth, securitySessionStorageFactory, config) {
    super();
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "securityClient", void 0);
    _defineProperty(this, "auth", void 0);
    _defineProperty(this, "securitySessionStorageFactory", void 0);
    _defineProperty(this, "config", void 0);
    this.logger = logger;
    this.securityClient = securityClient;
    this.auth = auth;
    this.securitySessionStorageFactory = securitySessionStorageFactory;
    this.config = config;
  }
  isAnonymousPage(request) {
    if (typeof request.route.options.authRequired === 'boolean') {
      return !request.route.options.authRequired;
    }
    if (!request.headers || !request.headers.referer) {
      return false;
    }
    const url = new _url.URL(request.headers.referer);
    return ReadonlyService.ROUTES_TO_IGNORE.some(path => {
      var _url$pathname;
      return (_url$pathname = url.pathname) === null || _url$pathname === void 0 ? void 0 : _url$pathname.includes(path);
    });
  }
  isReadOnlyTenant(authInfo) {
    const currentTenant = authInfo.user_requested_tenant || _common.globalTenantName;

    // private tenants are isolated to individual users that always have read/write permissions
    if ((0, _common.isPrivateTenant)(currentTenant)) {
      return false;
    }
    const readWriteAccess = authInfo.tenants[currentTenant];
    return !readWriteAccess;
  }
  async isReadonly(request) {
    var _this$config;
    if (!((_this$config = this.config) !== null && _this$config !== void 0 && _this$config.multitenancy.enabled)) {
      return false;
    }

    // omit for anonymous pages to avoid authentication errors
    if (this.isAnonymousPage(request)) {
      return false;
    }
    try {
      const cookie = await this.securitySessionStorageFactory.asScoped(request).get();
      let headers = request.headers;
      if (!this.auth.requestIncludesAuthInfo(request) && cookie) {
        headers = this.auth.buildAuthHeaderFromCookie(cookie, request);
      }
      const dashboardsInfo = await this.securityClient.dashboardsinfo(request, headers);
      if (!dashboardsInfo.multitenancy_enabled) {
        return false;
      }
      const authInfo = await this.securityClient.authinfo(request, headers);
      if (!authInfo.user_requested_tenant && cookie) {
        authInfo.user_requested_tenant = cookie.tenant;
      }
      return authInfo && this.isReadOnlyTenant(authInfo);
    } catch (error) {
      this.logger.error(`Failed to resolve if it's a readonly tenant: ${error.stack}`);
      return false;
    }
  }
}
exports.ReadonlyService = ReadonlyService;
_defineProperty(ReadonlyService, "ROUTES_TO_IGNORE", [_common.LOGIN_PAGE_URI, _common.CUSTOM_ERROR_PAGE_URI]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfdXJsIiwicmVxdWlyZSIsIl9jb21tb24iLCJfcmVhZG9ubHlfc2VydmljZSIsIl9kZWZpbmVQcm9wZXJ0eSIsImUiLCJyIiwidCIsIl90b1Byb3BlcnR5S2V5IiwiT2JqZWN0IiwiZGVmaW5lUHJvcGVydHkiLCJ2YWx1ZSIsImVudW1lcmFibGUiLCJjb25maWd1cmFibGUiLCJ3cml0YWJsZSIsImkiLCJfdG9QcmltaXRpdmUiLCJTeW1ib2wiLCJ0b1ByaW1pdGl2ZSIsImNhbGwiLCJUeXBlRXJyb3IiLCJTdHJpbmciLCJOdW1iZXIiLCJSZWFkb25seVNlcnZpY2UiLCJCYXNlUmVhZG9ubHlTZXJ2aWNlIiwiY29uc3RydWN0b3IiLCJsb2dnZXIiLCJzZWN1cml0eUNsaWVudCIsImF1dGgiLCJzZWN1cml0eVNlc3Npb25TdG9yYWdlRmFjdG9yeSIsImNvbmZpZyIsImlzQW5vbnltb3VzUGFnZSIsInJlcXVlc3QiLCJyb3V0ZSIsIm9wdGlvbnMiLCJhdXRoUmVxdWlyZWQiLCJoZWFkZXJzIiwicmVmZXJlciIsInVybCIsIlVSTCIsIlJPVVRFU19UT19JR05PUkUiLCJzb21lIiwicGF0aCIsIl91cmwkcGF0aG5hbWUiLCJwYXRobmFtZSIsImluY2x1ZGVzIiwiaXNSZWFkT25seVRlbmFudCIsImF1dGhJbmZvIiwiY3VycmVudFRlbmFudCIsInVzZXJfcmVxdWVzdGVkX3RlbmFudCIsImdsb2JhbFRlbmFudE5hbWUiLCJpc1ByaXZhdGVUZW5hbnQiLCJyZWFkV3JpdGVBY2Nlc3MiLCJ0ZW5hbnRzIiwiaXNSZWFkb25seSIsIl90aGlzJGNvbmZpZyIsIm11bHRpdGVuYW5jeSIsImVuYWJsZWQiLCJjb29raWUiLCJhc1Njb3BlZCIsImdldCIsInJlcXVlc3RJbmNsdWRlc0F1dGhJbmZvIiwiYnVpbGRBdXRoSGVhZGVyRnJvbUNvb2tpZSIsImRhc2hib2FyZHNJbmZvIiwiZGFzaGJvYXJkc2luZm8iLCJtdWx0aXRlbmFuY3lfZW5hYmxlZCIsImF1dGhpbmZvIiwidGVuYW50IiwiZXJyb3IiLCJzdGFjayIsImV4cG9ydHMiLCJMT0dJTl9QQUdFX1VSSSIsIkNVU1RPTV9FUlJPUl9QQUdFX1VSSSJdLCJzb3VyY2VzIjpbInJlYWRvbmx5X3NlcnZpY2UudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqICAgQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKlxuICogICBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLlxuICogICBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlIHdpdGggdGhlIExpY2Vuc2UuXG4gKiAgIEEgY29weSBvZiB0aGUgTGljZW5zZSBpcyBsb2NhdGVkIGF0XG4gKlxuICogICAgICAgaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogICBvciBpbiB0aGUgXCJsaWNlbnNlXCIgZmlsZSBhY2NvbXBhbnlpbmcgdGhpcyBmaWxlLiBUaGlzIGZpbGUgaXMgZGlzdHJpYnV0ZWRcbiAqICAgb24gYW4gXCJBUyBJU1wiIEJBU0lTLCBXSVRIT1VUIFdBUlJBTlRJRVMgT1IgQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZWl0aGVyXG4gKiAgIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nXG4gKiAgIHBlcm1pc3Npb25zIGFuZCBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqL1xuXG5pbXBvcnQgeyBVUkwgfSBmcm9tICd1cmwnO1xuaW1wb3J0IHtcbiAgTG9nZ2VyLFxuICBPcGVuU2VhcmNoRGFzaGJvYXJkc1JlcXVlc3QsXG4gIFNlc3Npb25TdG9yYWdlRmFjdG9yeSxcbn0gZnJvbSAnLi4vLi4vLi4vLi4vc3JjL2NvcmUvc2VydmVyJztcbmltcG9ydCB7XG4gIGdsb2JhbFRlbmFudE5hbWUsXG4gIGlzUHJpdmF0ZVRlbmFudCxcbiAgTE9HSU5fUEFHRV9VUkksXG4gIENVU1RPTV9FUlJPUl9QQUdFX1VSSSxcbn0gZnJvbSAnLi4vLi4vY29tbW9uJztcbmltcG9ydCB7IFNlY3VyaXR5Q2xpZW50IH0gZnJvbSAnLi4vYmFja2VuZC9vcGVuc2VhcmNoX3NlY3VyaXR5X2NsaWVudCc7XG5pbXBvcnQgeyBJQXV0aGVudGljYXRpb25UeXBlLCBPcGVuU2VhcmNoQXV0aEluZm8gfSBmcm9tICcuLi9hdXRoL3R5cGVzL2F1dGhlbnRpY2F0aW9uX3R5cGUnO1xuaW1wb3J0IHsgU2VjdXJpdHlTZXNzaW9uQ29va2llIH0gZnJvbSAnLi4vc2Vzc2lvbi9zZWN1cml0eV9jb29raWUnO1xuaW1wb3J0IHsgU2VjdXJpdHlQbHVnaW5Db25maWdUeXBlIH0gZnJvbSAnLi4vaW5kZXgnO1xuaW1wb3J0IHsgUmVhZG9ubHlTZXJ2aWNlIGFzIEJhc2VSZWFkb25seVNlcnZpY2UgfSBmcm9tICcuLi8uLi8uLi8uLi9zcmMvY29yZS9zZXJ2ZXIvc2VjdXJpdHkvcmVhZG9ubHlfc2VydmljZSc7XG5cbmV4cG9ydCBjbGFzcyBSZWFkb25seVNlcnZpY2UgZXh0ZW5kcyBCYXNlUmVhZG9ubHlTZXJ2aWNlIHtcbiAgcHJvdGVjdGVkIHN0YXRpYyByZWFkb25seSBST1VURVNfVE9fSUdOT1JFOiBzdHJpbmdbXSA9IFtMT0dJTl9QQUdFX1VSSSwgQ1VTVE9NX0VSUk9SX1BBR0VfVVJJXTtcblxuICBwcml2YXRlIHJlYWRvbmx5IGxvZ2dlcjogTG9nZ2VyO1xuICBwcml2YXRlIHJlYWRvbmx5IHNlY3VyaXR5Q2xpZW50OiBTZWN1cml0eUNsaWVudDtcbiAgcHJpdmF0ZSByZWFkb25seSBhdXRoOiBJQXV0aGVudGljYXRpb25UeXBlO1xuICBwcml2YXRlIHJlYWRvbmx5IHNlY3VyaXR5U2Vzc2lvblN0b3JhZ2VGYWN0b3J5OiBTZXNzaW9uU3RvcmFnZUZhY3Rvcnk8U2VjdXJpdHlTZXNzaW9uQ29va2llPjtcbiAgcHJpdmF0ZSByZWFkb25seSBjb25maWc6IFNlY3VyaXR5UGx1Z2luQ29uZmlnVHlwZTtcblxuICBjb25zdHJ1Y3RvcihcbiAgICBsb2dnZXI6IExvZ2dlcixcbiAgICBzZWN1cml0eUNsaWVudDogU2VjdXJpdHlDbGllbnQsXG4gICAgYXV0aDogSUF1dGhlbnRpY2F0aW9uVHlwZSxcbiAgICBzZWN1cml0eVNlc3Npb25TdG9yYWdlRmFjdG9yeTogU2Vzc2lvblN0b3JhZ2VGYWN0b3J5PFNlY3VyaXR5U2Vzc2lvbkNvb2tpZT4sXG4gICAgY29uZmlnOiBTZWN1cml0eVBsdWdpbkNvbmZpZ1R5cGVcbiAgKSB7XG4gICAgc3VwZXIoKTtcbiAgICB0aGlzLmxvZ2dlciA9IGxvZ2dlcjtcbiAgICB0aGlzLnNlY3VyaXR5Q2xpZW50ID0gc2VjdXJpdHlDbGllbnQ7XG4gICAgdGhpcy5hdXRoID0gYXV0aDtcbiAgICB0aGlzLnNlY3VyaXR5U2Vzc2lvblN0b3JhZ2VGYWN0b3J5ID0gc2VjdXJpdHlTZXNzaW9uU3RvcmFnZUZhY3Rvcnk7XG4gICAgdGhpcy5jb25maWcgPSBjb25maWc7XG4gIH1cblxuICBpc0Fub255bW91c1BhZ2UocmVxdWVzdDogT3BlblNlYXJjaERhc2hib2FyZHNSZXF1ZXN0KSB7XG4gICAgaWYgKHR5cGVvZiByZXF1ZXN0LnJvdXRlLm9wdGlvbnMuYXV0aFJlcXVpcmVkID09PSAnYm9vbGVhbicpIHtcbiAgICAgIHJldHVybiAhcmVxdWVzdC5yb3V0ZS5vcHRpb25zLmF1dGhSZXF1aXJlZDtcbiAgICB9XG5cbiAgICBpZiAoIXJlcXVlc3QuaGVhZGVycyB8fCAhcmVxdWVzdC5oZWFkZXJzLnJlZmVyZXIpIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG5cbiAgICBjb25zdCB1cmwgPSBuZXcgVVJMKHJlcXVlc3QuaGVhZGVycy5yZWZlcmVyIGFzIHN0cmluZyk7XG4gICAgcmV0dXJuIFJlYWRvbmx5U2VydmljZS5ST1VURVNfVE9fSUdOT1JFLnNvbWUoKHBhdGgpID0+IHVybC5wYXRobmFtZT8uaW5jbHVkZXMocGF0aCkpO1xuICB9XG5cbiAgaXNSZWFkT25seVRlbmFudChhdXRoSW5mbzogT3BlblNlYXJjaEF1dGhJbmZvKTogYm9vbGVhbiB7XG4gICAgY29uc3QgY3VycmVudFRlbmFudCA9IGF1dGhJbmZvLnVzZXJfcmVxdWVzdGVkX3RlbmFudCB8fCBnbG9iYWxUZW5hbnROYW1lO1xuXG4gICAgLy8gcHJpdmF0ZSB0ZW5hbnRzIGFyZSBpc29sYXRlZCB0byBpbmRpdmlkdWFsIHVzZXJzIHRoYXQgYWx3YXlzIGhhdmUgcmVhZC93cml0ZSBwZXJtaXNzaW9uc1xuICAgIGlmIChpc1ByaXZhdGVUZW5hbnQoY3VycmVudFRlbmFudCkpIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG5cbiAgICBjb25zdCByZWFkV3JpdGVBY2Nlc3MgPSBhdXRoSW5mby50ZW5hbnRzW2N1cnJlbnRUZW5hbnRdO1xuICAgIHJldHVybiAhcmVhZFdyaXRlQWNjZXNzO1xuICB9XG5cbiAgYXN5bmMgaXNSZWFkb25seShyZXF1ZXN0OiBPcGVuU2VhcmNoRGFzaGJvYXJkc1JlcXVlc3QpOiBQcm9taXNlPGJvb2xlYW4+IHtcbiAgICBpZiAoIXRoaXMuY29uZmlnPy5tdWx0aXRlbmFuY3kuZW5hYmxlZCkge1xuICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cblxuICAgIC8vIG9taXQgZm9yIGFub255bW91cyBwYWdlcyB0byBhdm9pZCBhdXRoZW50aWNhdGlvbiBlcnJvcnNcbiAgICBpZiAodGhpcy5pc0Fub255bW91c1BhZ2UocmVxdWVzdCkpIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG5cbiAgICB0cnkge1xuICAgICAgY29uc3QgY29va2llID0gYXdhaXQgdGhpcy5zZWN1cml0eVNlc3Npb25TdG9yYWdlRmFjdG9yeS5hc1Njb3BlZChyZXF1ZXN0KS5nZXQoKTtcbiAgICAgIGxldCBoZWFkZXJzID0gcmVxdWVzdC5oZWFkZXJzO1xuXG4gICAgICBpZiAoIXRoaXMuYXV0aC5yZXF1ZXN0SW5jbHVkZXNBdXRoSW5mbyhyZXF1ZXN0KSAmJiBjb29raWUpIHtcbiAgICAgICAgaGVhZGVycyA9IHRoaXMuYXV0aC5idWlsZEF1dGhIZWFkZXJGcm9tQ29va2llKGNvb2tpZSwgcmVxdWVzdCk7XG4gICAgICB9XG5cbiAgICAgIGNvbnN0IGRhc2hib2FyZHNJbmZvID0gYXdhaXQgdGhpcy5zZWN1cml0eUNsaWVudC5kYXNoYm9hcmRzaW5mbyhyZXF1ZXN0LCBoZWFkZXJzKTtcblxuICAgICAgaWYgKCFkYXNoYm9hcmRzSW5mby5tdWx0aXRlbmFuY3lfZW5hYmxlZCkge1xuICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICB9XG5cbiAgICAgIGNvbnN0IGF1dGhJbmZvID0gYXdhaXQgdGhpcy5zZWN1cml0eUNsaWVudC5hdXRoaW5mbyhyZXF1ZXN0LCBoZWFkZXJzKTtcblxuICAgICAgaWYgKCFhdXRoSW5mby51c2VyX3JlcXVlc3RlZF90ZW5hbnQgJiYgY29va2llKSB7XG4gICAgICAgIGF1dGhJbmZvLnVzZXJfcmVxdWVzdGVkX3RlbmFudCA9IGNvb2tpZS50ZW5hbnQ7XG4gICAgICB9XG5cbiAgICAgIHJldHVybiBhdXRoSW5mbyAmJiB0aGlzLmlzUmVhZE9ubHlUZW5hbnQoYXV0aEluZm8pO1xuICAgIH0gY2F0Y2ggKGVycm9yOiBhbnkpIHtcbiAgICAgIHRoaXMubG9nZ2VyLmVycm9yKGBGYWlsZWQgdG8gcmVzb2x2ZSBpZiBpdCdzIGEgcmVhZG9ubHkgdGVuYW50OiAke2Vycm9yLnN0YWNrfWApO1xuICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cbiAgfVxufVxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFlQSxJQUFBQSxJQUFBLEdBQUFDLE9BQUE7QUFNQSxJQUFBQyxPQUFBLEdBQUFELE9BQUE7QUFVQSxJQUFBRSxpQkFBQSxHQUFBRixPQUFBO0FBQStHLFNBQUFHLGdCQUFBQyxDQUFBLEVBQUFDLENBQUEsRUFBQUMsQ0FBQSxZQUFBRCxDQUFBLEdBQUFFLGNBQUEsQ0FBQUYsQ0FBQSxNQUFBRCxDQUFBLEdBQUFJLE1BQUEsQ0FBQUMsY0FBQSxDQUFBTCxDQUFBLEVBQUFDLENBQUEsSUFBQUssS0FBQSxFQUFBSixDQUFBLEVBQUFLLFVBQUEsTUFBQUMsWUFBQSxNQUFBQyxRQUFBLFVBQUFULENBQUEsQ0FBQUMsQ0FBQSxJQUFBQyxDQUFBLEVBQUFGLENBQUE7QUFBQSxTQUFBRyxlQUFBRCxDQUFBLFFBQUFRLENBQUEsR0FBQUMsWUFBQSxDQUFBVCxDQUFBLHVDQUFBUSxDQUFBLEdBQUFBLENBQUEsR0FBQUEsQ0FBQTtBQUFBLFNBQUFDLGFBQUFULENBQUEsRUFBQUQsQ0FBQSwyQkFBQUMsQ0FBQSxLQUFBQSxDQUFBLFNBQUFBLENBQUEsTUFBQUYsQ0FBQSxHQUFBRSxDQUFBLENBQUFVLE1BQUEsQ0FBQUMsV0FBQSxrQkFBQWIsQ0FBQSxRQUFBVSxDQUFBLEdBQUFWLENBQUEsQ0FBQWMsSUFBQSxDQUFBWixDQUFBLEVBQUFELENBQUEsdUNBQUFTLENBQUEsU0FBQUEsQ0FBQSxZQUFBSyxTQUFBLHlFQUFBZCxDQUFBLEdBQUFlLE1BQUEsR0FBQUMsTUFBQSxFQUFBZixDQUFBLEtBL0IvRztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBb0JPLE1BQU1nQixlQUFlLFNBQVNDLGlDQUFtQixDQUFDO0VBU3ZEQyxXQUFXQSxDQUNUQyxNQUFjLEVBQ2RDLGNBQThCLEVBQzlCQyxJQUF5QixFQUN6QkMsNkJBQTJFLEVBQzNFQyxNQUFnQyxFQUNoQztJQUNBLEtBQUssQ0FBQyxDQUFDO0lBQUMxQixlQUFBO0lBQUFBLGVBQUE7SUFBQUEsZUFBQTtJQUFBQSxlQUFBO0lBQUFBLGVBQUE7SUFDUixJQUFJLENBQUNzQixNQUFNLEdBQUdBLE1BQU07SUFDcEIsSUFBSSxDQUFDQyxjQUFjLEdBQUdBLGNBQWM7SUFDcEMsSUFBSSxDQUFDQyxJQUFJLEdBQUdBLElBQUk7SUFDaEIsSUFBSSxDQUFDQyw2QkFBNkIsR0FBR0EsNkJBQTZCO0lBQ2xFLElBQUksQ0FBQ0MsTUFBTSxHQUFHQSxNQUFNO0VBQ3RCO0VBRUFDLGVBQWVBLENBQUNDLE9BQW9DLEVBQUU7SUFDcEQsSUFBSSxPQUFPQSxPQUFPLENBQUNDLEtBQUssQ0FBQ0MsT0FBTyxDQUFDQyxZQUFZLEtBQUssU0FBUyxFQUFFO01BQzNELE9BQU8sQ0FBQ0gsT0FBTyxDQUFDQyxLQUFLLENBQUNDLE9BQU8sQ0FBQ0MsWUFBWTtJQUM1QztJQUVBLElBQUksQ0FBQ0gsT0FBTyxDQUFDSSxPQUFPLElBQUksQ0FBQ0osT0FBTyxDQUFDSSxPQUFPLENBQUNDLE9BQU8sRUFBRTtNQUNoRCxPQUFPLEtBQUs7SUFDZDtJQUVBLE1BQU1DLEdBQUcsR0FBRyxJQUFJQyxRQUFHLENBQUNQLE9BQU8sQ0FBQ0ksT0FBTyxDQUFDQyxPQUFpQixDQUFDO0lBQ3RELE9BQU9kLGVBQWUsQ0FBQ2lCLGdCQUFnQixDQUFDQyxJQUFJLENBQUVDLElBQUk7TUFBQSxJQUFBQyxhQUFBO01BQUEsUUFBQUEsYUFBQSxHQUFLTCxHQUFHLENBQUNNLFFBQVEsY0FBQUQsYUFBQSx1QkFBWkEsYUFBQSxDQUFjRSxRQUFRLENBQUNILElBQUksQ0FBQztJQUFBLEVBQUM7RUFDdEY7RUFFQUksZ0JBQWdCQSxDQUFDQyxRQUE0QixFQUFXO0lBQ3RELE1BQU1DLGFBQWEsR0FBR0QsUUFBUSxDQUFDRSxxQkFBcUIsSUFBSUMsd0JBQWdCOztJQUV4RTtJQUNBLElBQUksSUFBQUMsdUJBQWUsRUFBQ0gsYUFBYSxDQUFDLEVBQUU7TUFDbEMsT0FBTyxLQUFLO0lBQ2Q7SUFFQSxNQUFNSSxlQUFlLEdBQUdMLFFBQVEsQ0FBQ00sT0FBTyxDQUFDTCxhQUFhLENBQUM7SUFDdkQsT0FBTyxDQUFDSSxlQUFlO0VBQ3pCO0VBRUEsTUFBTUUsVUFBVUEsQ0FBQ3RCLE9BQW9DLEVBQW9CO0lBQUEsSUFBQXVCLFlBQUE7SUFDdkUsSUFBSSxHQUFBQSxZQUFBLEdBQUMsSUFBSSxDQUFDekIsTUFBTSxjQUFBeUIsWUFBQSxlQUFYQSxZQUFBLENBQWFDLFlBQVksQ0FBQ0MsT0FBTyxHQUFFO01BQ3RDLE9BQU8sS0FBSztJQUNkOztJQUVBO0lBQ0EsSUFBSSxJQUFJLENBQUMxQixlQUFlLENBQUNDLE9BQU8sQ0FBQyxFQUFFO01BQ2pDLE9BQU8sS0FBSztJQUNkO0lBRUEsSUFBSTtNQUNGLE1BQU0wQixNQUFNLEdBQUcsTUFBTSxJQUFJLENBQUM3Qiw2QkFBNkIsQ0FBQzhCLFFBQVEsQ0FBQzNCLE9BQU8sQ0FBQyxDQUFDNEIsR0FBRyxDQUFDLENBQUM7TUFDL0UsSUFBSXhCLE9BQU8sR0FBR0osT0FBTyxDQUFDSSxPQUFPO01BRTdCLElBQUksQ0FBQyxJQUFJLENBQUNSLElBQUksQ0FBQ2lDLHVCQUF1QixDQUFDN0IsT0FBTyxDQUFDLElBQUkwQixNQUFNLEVBQUU7UUFDekR0QixPQUFPLEdBQUcsSUFBSSxDQUFDUixJQUFJLENBQUNrQyx5QkFBeUIsQ0FBQ0osTUFBTSxFQUFFMUIsT0FBTyxDQUFDO01BQ2hFO01BRUEsTUFBTStCLGNBQWMsR0FBRyxNQUFNLElBQUksQ0FBQ3BDLGNBQWMsQ0FBQ3FDLGNBQWMsQ0FBQ2hDLE9BQU8sRUFBRUksT0FBTyxDQUFDO01BRWpGLElBQUksQ0FBQzJCLGNBQWMsQ0FBQ0Usb0JBQW9CLEVBQUU7UUFDeEMsT0FBTyxLQUFLO01BQ2Q7TUFFQSxNQUFNbEIsUUFBUSxHQUFHLE1BQU0sSUFBSSxDQUFDcEIsY0FBYyxDQUFDdUMsUUFBUSxDQUFDbEMsT0FBTyxFQUFFSSxPQUFPLENBQUM7TUFFckUsSUFBSSxDQUFDVyxRQUFRLENBQUNFLHFCQUFxQixJQUFJUyxNQUFNLEVBQUU7UUFDN0NYLFFBQVEsQ0FBQ0UscUJBQXFCLEdBQUdTLE1BQU0sQ0FBQ1MsTUFBTTtNQUNoRDtNQUVBLE9BQU9wQixRQUFRLElBQUksSUFBSSxDQUFDRCxnQkFBZ0IsQ0FBQ0MsUUFBUSxDQUFDO0lBQ3BELENBQUMsQ0FBQyxPQUFPcUIsS0FBVSxFQUFFO01BQ25CLElBQUksQ0FBQzFDLE1BQU0sQ0FBQzBDLEtBQUssQ0FBRSxnREFBK0NBLEtBQUssQ0FBQ0MsS0FBTSxFQUFDLENBQUM7TUFDaEYsT0FBTyxLQUFLO0lBQ2Q7RUFDRjtBQUNGO0FBQUNDLE9BQUEsQ0FBQS9DLGVBQUEsR0FBQUEsZUFBQTtBQUFBbkIsZUFBQSxDQXJGWW1CLGVBQWUsc0JBQzZCLENBQUNnRCxzQkFBYyxFQUFFQyw2QkFBcUIsQ0FBQyJ9