/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.AbstractSignableSAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Extensions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.xmlsec.signature.Signature;

public abstract class StatusResponseTypeImpl
extends AbstractSignableSAMLObject
implements StatusResponseType {
    @Nullable
    private SAMLVersion version = SAMLVersion.VERSION_20;
    @Nullable
    private String id;
    @Nullable
    private String inResponseTo;
    @Nullable
    private Instant issueInstant;
    @Nullable
    private String destination;
    @Nullable
    private String consent;
    @Nullable
    private Issuer issuer;
    @Nullable
    private Extensions extensions;
    @Nullable
    private Status status;

    protected StatusResponseTypeImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
    @Nullable
    public SAMLVersion getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(@Nullable SAMLVersion newVersion) {
        this.version = this.prepareForAssignment(this.version, newVersion);
    }

    @Override
    @Nullable
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(@Nullable String newID) {
        String oldID = this.id;
        this.id = this.prepareForAssignment(this.id, newID);
        this.registerOwnID(oldID, this.id);
    }

    @Override
    @Nullable
    public String getInResponseTo() {
        return this.inResponseTo;
    }

    @Override
    public void setInResponseTo(@Nullable String newInResponseTo) {
        this.inResponseTo = this.prepareForAssignment(this.inResponseTo, newInResponseTo);
    }

    @Override
    @Nullable
    public Instant getIssueInstant() {
        return this.issueInstant;
    }

    @Override
    public void setIssueInstant(@Nullable Instant newIssueInstant) {
        this.issueInstant = this.prepareForAssignment(this.issueInstant, newIssueInstant);
    }

    @Override
    @Nullable
    public String getDestination() {
        return this.destination;
    }

    @Override
    public void setDestination(@Nullable String newDestination) {
        this.destination = this.prepareForAssignment(this.destination, newDestination);
    }

    @Override
    @Nullable
    public String getConsent() {
        return this.consent;
    }

    @Override
    public void setConsent(@Nullable String newConsent) {
        this.consent = this.prepareForAssignment(this.consent, newConsent);
    }

    @Override
    @Nullable
    public Issuer getIssuer() {
        return this.issuer;
    }

    @Override
    public void setIssuer(@Nullable Issuer newIssuer) {
        this.issuer = this.prepareForAssignment(this.issuer, newIssuer);
    }

    @Override
    @Nullable
    public Extensions getExtensions() {
        return this.extensions;
    }

    @Override
    public void setExtensions(@Nullable Extensions newExtensions) {
        this.extensions = this.prepareForAssignment(this.extensions, newExtensions);
    }

    @Override
    @Nullable
    public Status getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(@Nullable Status newStatus) {
        this.status = this.prepareForAssignment(this.status, newStatus);
    }

    @Override
    @Nullable
    public String getSignatureReferenceID() {
        return this.id;
    }

    @Override
    @Nullable
    @NotLive
    @Unmodifiable
    public List<XMLObject> getOrderedChildren() {
        Signature sig;
        ArrayList<XMLObject> children = new ArrayList<XMLObject>();
        if (this.issuer != null) {
            children.add(this.issuer);
        }
        if ((sig = this.getSignature()) != null) {
            children.add(sig);
        }
        if (this.extensions != null) {
            children.add(this.extensions);
        }
        if (this.status != null) {
            children.add(this.status);
        }
        return CollectionSupport.copyToList(children);
    }
}

