/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.sourceforge.plantuml.file.AFile;
import net.sourceforge.plantuml.file.AFileRegular;
import net.sourceforge.plantuml.file.AParentFolder;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.utils.Log;

public class FileWithSuffix {
    private final AFile file;
    private final String suffix;
    private final String entry;
    private final String description;

    public String toString() {
        if (this.file == null) {
            return super.toString();
        }
        return this.file.toString();
    }

    public Reader getReader(Charset charset) throws IOException {
        if (this.file == null) {
            return null;
        }
        InputStream tmp = this.file.openFile();
        if (tmp == null) {
            return null;
        }
        if (this.entry == null) {
            return new InputStreamReader(tmp, charset);
        }
        InputStream is = this.getDataFromZip(tmp, this.entry);
        if (is == null) {
            return null;
        }
        return new InputStreamReader(is, charset);
    }

    private InputStream getDataFromZip(InputStream is, String name) throws IOException {
        ZipInputStream zis = new ZipInputStream(is);
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            String fileName = ze.getName();
            if (!ze.isDirectory() && fileName.equals(name)) {
                return zis;
            }
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
        return null;
    }

    public boolean fileOk() {
        return this.file != null && this.file.isOk();
    }

    FileWithSuffix(SFile file, String suffix) {
        this.file = new AFileRegular(file);
        this.suffix = suffix;
        this.entry = null;
        this.description = file.getName();
    }

    FileWithSuffix(String description, String suffix, AFile file, String entry) {
        this.description = description;
        this.suffix = suffix;
        this.file = file;
        this.entry = entry;
    }

    static FileWithSuffix none() {
        return new FileWithSuffix("NONE", null, null, null);
    }

    public int hashCode() {
        int v = 0;
        if (this.file != null) {
            v += this.file.hashCode();
        }
        if (this.suffix != null) {
            v += this.suffix.hashCode() * 43;
        }
        if (this.entry != null) {
            v += this.entry.hashCode();
        }
        return v;
    }

    public boolean equals(Object arg) {
        FileWithSuffix other = (FileWithSuffix)arg;
        return this.file.equals(other.file) && FileWithSuffix.equals(this.suffix, other.suffix) && FileWithSuffix.same(this.entry, other.entry);
    }

    private static boolean same(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 != null && s2 != null) {
            return s1.equals(s2);
        }
        return false;
    }

    public AParentFolder getParentFile() {
        if (this.file == null) {
            return null;
        }
        Log.info(() -> "Getting parent of " + this.file);
        Log.info(() -> "-->The parent is " + this.file.getParentFile());
        return this.file.getParentFile();
    }

    public String getDescription() {
        return this.description;
    }

    public final String getSuffix() {
        return this.suffix;
    }

    private static boolean equals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 != null && s2 != null) {
            return s1.equals(s2);
        }
        assert (s1 == null && s2 != null || s1 != null && s2 == null);
        return false;
    }

    public static Set<File> convert(Set<FileWithSuffix> all) throws FileNotFoundException {
        HashSet<File> result = new HashSet<File>();
        for (FileWithSuffix f : all) {
            result.add(f.file.getUnderlyingFile().conv());
        }
        return result;
    }

    public static String getFileName(File file) {
        return file.getName();
    }
}

