import datetime
from typing import ClassVar

from ..core import WesternCalendar

class Australia(WesternCalendar):
    include_queens_birthday: ClassVar[bool]
    include_labour_day_october: ClassVar[bool]
    shift_anzac_day: ClassVar[bool]
    ANZAC_SHIFT_DAYS: ClassVar[tuple[int, ...]]
    def get_canberra_day(self, year: int) -> tuple[datetime.date, str]: ...
    def get_queens_birthday(self, year: int) -> tuple[datetime.date, str]: ...
    def get_labour_day_october(self, year: int) -> tuple[datetime.date, str]: ...
    def get_anzac_day(self, year: int) -> tuple[datetime.date, str]: ...

class AustralianCapitalTerritory(Australia):
    def get_family_community_day(self, year: int) -> tuple[datetime.date, str] | None: ...
    def get_reconciliation_day(self, year: int) -> tuple[datetime.date, str] | None: ...

class NewSouthWales(Australia): ...

class NorthernTerritory(Australia):
    def get_may_day(self, year: int) -> tuple[datetime.date, str]: ...
    def get_picnic_day(self, year: int) -> tuple[datetime.date, str]: ...

class Queensland(Australia):
    def get_labour_day_may(self, year: int) -> tuple[datetime.date, str]: ...

class SouthAustralia(Australia):
    def get_adelaides_cup(self, year: int) -> tuple[datetime.date, str]: ...
    def get_proclamation_day(self, year: int) -> tuple[datetime.date, str]: ...

class Tasmania(Australia):
    @property
    def has_recreation_day(self) -> bool: ...
    def get_eight_hours_day(self, year: int) -> tuple[datetime.date, str]: ...
    def get_recreation_day(self, year: int) -> tuple[datetime.date, str]: ...

class Hobart(Tasmania):
    def get_hobart(self, year: int) -> tuple[datetime.date, str]: ...

class Victoria(Australia):
    def get_labours_day_in_march(self, year: int) -> tuple[datetime.date, str]: ...
    def get_melbourne_cup(self, year: int) -> tuple[datetime.date, str]: ...

class WesternAustralia(Australia):
    def get_labours_day_in_march(self, year: int) -> tuple[datetime.date, str]: ...
    def get_western_australia_day(self, year: int) -> tuple[datetime.date, str]: ...
